/*
 * Copyright 2023, 2024 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.features.login.impl

import com.bumble.appyx.core.modality.BuildContext
import com.bumble.appyx.core.node.Node
import com.bumble.appyx.core.plugin.Plugin
import dev.zacsweers.metro.AppScope
import dev.zacsweers.metro.ContributesBinding
import dev.zacsweers.metro.Inject
import io.element.android.features.login.api.LoginEntryPoint
import io.element.android.libraries.architecture.createNode

@ContributesBinding(AppScope::class)
@Inject
class DefaultLoginEntryPoint : LoginEntryPoint {
    override fun nodeBuilder(parentNode: Node, buildContext: BuildContext): LoginEntryPoint.NodeBuilder {
        val plugins = ArrayList<Plugin>()

        return object : LoginEntryPoint.NodeBuilder {
            override fun params(params: LoginEntryPoint.Params): LoginEntryPoint.NodeBuilder {
                plugins += LoginFlowNode.Params(
                    accountProvider = params.accountProvider,
                    loginHint = params.loginHint,
                )
                return this
            }

            override fun callback(callback: LoginEntryPoint.Callback): LoginEntryPoint.NodeBuilder {
                plugins += callback
                return this
            }

            override fun build(): Node {
                return parentNode.createNode<LoginFlowNode>(buildContext, plugins)
            }
        }
    }
}
