/*
 * Copyright 2023, 2024 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.features.location.api

import com.bumble.appyx.core.modality.BuildContext
import com.bumble.appyx.core.node.Node
import io.element.android.libraries.architecture.FeatureEntryPoint
import io.element.android.libraries.matrix.api.timeline.Timeline

/**
 * The "Send location" screen.
 *
 * Allows a user to share a location message within a room.
 */
interface SendLocationEntryPoint : FeatureEntryPoint {
    fun builder(timelineMode: Timeline.Mode): Builder
    interface Builder {
        fun build(parentNode: Node, buildContext: BuildContext): Node
    }
}
