#!/bin/bash

set -e

flavors=("default" "beta" "internal")
types=("debug" "release")
base="fdroidSc"
pushd app/src

for build_flavor in "${flavors[@]}"; do
    for build_type in "${types[@]}"; do
        fullVariant="${base}${build_flavor^}${build_type^}"
        values_dir="$fullVariant/res/values"
        mkdir -p "$values_dir"
        cat > "$values_dir/variant.xml" <<EOL
<?xml version="1.0" encoding="utf-8"?>

<!-- File generated by $0 -->
<resources>
    <string name="login_redirect_scheme" translatable="false">chat.schildi.android.$build_flavor.$build_type</string>
</resources>
EOL
    done
done
