/*
 * Copyright 2023, 2024 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.libraries.wellknown.impl

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * https://matrix.org/docs/spec/client_server/r0.4.0.html#server-discovery
 * <pre>
 * {
 *     "m.homeserver": {
 *         "base_url": "https://matrix.org"
 *     },
 *     "m.identity_server": {
 *         "base_url": "https://vector.im"
 *     },
 * }
 * </pre>
 * .
 */
@Serializable
data class InternalWellKnown(
    @SerialName("m.homeserver")
    val homeServer: InternalWellKnownBaseConfig? = null,
    @SerialName("m.identity_server")
    val identityServer: InternalWellKnownBaseConfig? = null,
)
