# video_compress

Compress videos, remove audio, manipulate thumbnails, and make your video compatible with all platforms through this lightweight and efficient library.
100% native code was used, we do not use FFMPEG as it is very slow, bloated and the GNU license is an obstacle for commercial applications.
In addition, google chrome uses VP8/VP9, safari uses h264, and most of the time, it is necessary to encode the video in two formats, but not with this library.
All video files are encoded in an MP4 container with AAC audio that allows 100% compatibility with safari, mozila, chrome, android and iOS.

Works on ANDROID, IOS and desktop (just MacOS for now).



# Table of Contents
  - [Installing](#lets-get-started)
  - [How to use](#how-to-use)
    * [Imports](#imports)
    * [Video compression](#video-compression)
    * [Check compress state](#check-compress-state)
    * [Get memory thumbnail from VideoPath](#get-memory-thumbnail-from-videopath)
    * [Get File thumbnail from VideoPath](#get-file-thumbnail-from-videopath)
    * [Get media information](#get-media-information)
    * [delete all cache files](#delete-all-cache-files)
    * [Listen the compression progress](#listen-the-compression-progress)
  - [TODO](#todo)

# Lets Get Started

### 1. Depend on it
Add this to your package's `pubspec.yaml` file:

```yaml
dependencies:
  video_compress: ^3.1.0
```

### 2. Install it

You can install packages from the command line:

with `pub`:

```css
$  pub get
```

### 3. Import it

Now in your `Dart` code, you can use: 

````dart
import 'package:video_compress/video_compress.dart';
````

# How to use

### Imports

````dart
import 'package:video_compress/video_compress.dart';
    
````

## Video compression

```dart
MediaInfo mediaInfo = await VideoCompress.compressVideo(
  path,
  quality: VideoQuality.DefaultQuality, 
  deleteOrigin: false, // It's false by default
);
```

## Check compress state
```dart
VideoQuality.isCompressing
```
<!-- ## Cancel compression
```dart
await videoCompress.cancelCompression()
``` -->

## Get memory thumbnail from VideoPath
```dart
final uint8list = await VideoCompress.getByteThumbnail(
  videopath,
  quality: 50, // default(100)
  position: -1 // default(-1)
);
```

## Get File thumbnail from VideoPath
```dart
final thumbnailFile = await VideoCompress.getFileThumbnail(
  videopath,
  quality: 50, // default(100)
  position: -1 // default(-1)
);
```

## Get media information

```dart
final info = await VideoCompress.getMediaInfo(videopath);

```

## delete all cache files
- Delete all files generated by this will delete all files located at 'video_compress', you shoule ought to know what are you doing.

```dart
await VideoCompress.deleteAllCache()
```

## Listen the compression progress
```dart
class _Compress extends State<Compress> {

  Subscription _subscription;

  @override
  void initState() {
    super.initState();
    _subscription =
        VideoCompress.compressProgress$.subscribe((progress) {
      debugPrint('progress: $progress');
    });
  }

  @override
  void dispose() {
    super.dispose();
    _subscription.unsubscribe();
  }
}
```

### TODO
- Add the trim video function
- Add cancel function to Android

## Methods
| Functions         | Parameters                                                                                                                                                                                                                                                                                                                                    | Description                                                                                      | Returns             |
| ----------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ | ------------------- |
| getByteThumbnail  | String `path`[video path], int `quality`(1-100)[thumbnail quality], int `position`[Get a thumbnail from video position]                                                                                                                                                                                                                       | get thumbnail from video `path`                                                                  | `Future<Uint8List>` |
| getFileThumbnail  | String `path`[video path], int `quality`(1-100)[thumbnail quality], int `position`[Get a thumbnail from video position]                                                                                                                                                                                                                       | get thumbnail file from video `path`                                                             | `Future<File>`      |
| getMediaInfo      | String `path`[video path]                                                                                                                                                                                                                                                                                                                     | get media information from video `path`                                                          | `Future<MediaInfo>` |
| compressVideo     | String `path`[video path], VideoQuality `quality`[compressed video quality], bool `deleteOrigin`[delete the origin video], int `startTime`[compression video start time], int `duration`[compression video duration from start time], bool `includeAudio`[is include audio in compressed video], int `frameRate`[compressed video frame rate] | compression video at origin video `path`                                                         | `Future<MediaInfo>` |
| cancelCompression | `none`                                                                                                                                                                                                                                                                                                                                        | cancel compressing                                                                               | `Future<void>`      |
| deleteAllCache    | `none`                                                                                                                                                                                                                                                                                                                                        | Delete all files generated by 'video_compress' will delete all files located at 'video_compress' | `Future<bool>`      |

## Subscriptions
| Subscriptions     | Description                              | Stream            |
| ----------------- | ---------------------------------------- | ----------------- |
| compressProgress$ | Subscribe the compression progress steam | double `progress` |

## Contribute

Contributions are always welcome!
<!-- Please read the [contribution guidelines](contributing.md) first. -->

## acknowledgment

Inspired by the flutter_ffmpeg library.
https://github.com/rurico/flutter_video_compress

