// Copyright 2019 terrier989@gmail.com
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

part of main_test;

void _testServiceWorker() {
  group('Worker:', () {
    test('Worker()', () {
      final worker = Worker('example');
      worker.postMessage('message');
    }, testOn: 'browser && !browser'); // We don't want to execute this test
  });

  group('ServiceWorker', () {
    test('ServiceWorker()', () async {
      final registration =
          await window.navigator.serviceWorker!.register('example');
      final worker = registration.active!;
      worker.postMessage('message');
    }, testOn: 'browser && !browser'); // We don't want to execute this test
  });
}
