import 'package:matrix/matrix.dart';

extension AudioEventRoomExtension on Room {
  /// Sends an audio file with appropriate info to this room. Returns the event
  /// ID generated by the server for this event.
  Future<String?> sendAudioEvent(
    MatrixAudioFile audioFile, {
    Event? replyTo,
    int? durationInMs,
    List<int>? waveform,
    Map<String, dynamic>? otherFileInfo,
  }) {
    final extraContent = <String, Map<String, Object?>>{};
    if (durationInMs != null) {
      otherFileInfo ??= {};
      otherFileInfo['duration'] = durationInMs;
    }
    if (otherFileInfo != null) extraContent['info'] = otherFileInfo;
    extraContent['org.matrix.msc1767.audio'] = <String, Object?>{
      'duration': durationInMs,
      'waveform': waveform,
    };
    return sendFileEvent(
      audioFile,
      inReplyTo: replyTo,
      extraContent: extraContent,
    );
  }
}
