/* MIT License
* 
* Copyright (C) 2019, 2020, 2021 Famedly GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

/// Lightweight wrapper around the raw matrix API.
library;

export 'matrix_api_lite/generated/model.dart';
export 'matrix_api_lite/matrix_api.dart';
export 'matrix_api_lite/model/algorithm_types.dart';
export 'matrix_api_lite/model/auth/authentication_data.dart';
export 'matrix_api_lite/model/auth/authentication_identifier.dart';
export 'matrix_api_lite/model/auth/authentication_password.dart';
export 'matrix_api_lite/model/auth/authentication_phone_identifier.dart';
export 'matrix_api_lite/model/auth/authentication_recaptcha.dart';
export 'matrix_api_lite/model/auth/authentication_third_party_identifier.dart';
export 'matrix_api_lite/model/auth/authentication_three_pid_creds.dart';
export 'matrix_api_lite/model/auth/authentication_token.dart';
export 'matrix_api_lite/model/auth/authentication_types.dart';
export 'matrix_api_lite/model/auth/authentication_user_identifier.dart';
export 'matrix_api_lite/model/basic_event.dart';
export 'matrix_api_lite/model/basic_event_with_sender.dart';
export 'matrix_api_lite/model/event_types.dart';
export 'matrix_api_lite/model/events/forwarded_room_key_content.dart';
export 'matrix_api_lite/model/events/image_pack_content.dart';
export 'matrix_api_lite/model/events/olm_plaintext_payload.dart';
export 'matrix_api_lite/model/events/room_encrypted_content.dart';
export 'matrix_api_lite/model/events/room_encryption_content.dart';
export 'matrix_api_lite/model/events/room_key_content.dart';
export 'matrix_api_lite/model/events/room_key_request_content.dart';
export 'matrix_api_lite/model/events/secret_storage_default_key_content.dart';
export 'matrix_api_lite/model/events/secret_storage_key_content.dart';
export 'matrix_api_lite/model/events/tombstone_content.dart';
export 'matrix_api_lite/model/matrix_event.dart';
export 'matrix_api_lite/model/matrix_exception.dart';
export 'matrix_api_lite/model/matrix_keys.dart';
export 'matrix_api_lite/model/message_types.dart';
export 'matrix_api_lite/model/presence.dart';
export 'matrix_api_lite/model/presence_content.dart';
export 'matrix_api_lite/model/room_creation_types.dart';
export 'matrix_api_lite/model/room_summary.dart';
export 'matrix_api_lite/model/stripped_state_event.dart';
export 'matrix_api_lite/model/sync_update.dart';
export 'matrix_api_lite/utils/filter_map_extension.dart';
export 'matrix_api_lite/utils/logs.dart';
export 'matrix_api_lite/utils/map_copy_extension.dart';
export 'matrix_api_lite/utils/try_get_map_extension.dart';
export 'matrix_api_lite/values.dart';
