import 'package:collection/collection.dart' show IterableExtension;

/// All Groups
enum EmojiGroup{
smileysEmotion, activities, peopleBody, objects, travelPlaces, component, animalsNature, foodDrink, symbols, flags
}

/// All Subgroups
enum EmojiSubgroup {
faceSmiling, faceAffection, faceSleepy, faceTongue, faceNeutralSkeptical, faceGlasses, faceHat, faceConcerned, faceNegative, faceUnwell, faceHand, faceCostume, event, catFace, hands, handFingersClosed, handFingersPartial, handSingleFinger, handFingersOpen, bodyParts, handProp, clothing, emotion, family, personSymbol, person, personRole, personFantasy, personGesture, personActivity, artsCrafts, office, hotel, skyWeather, hairStyle, animalMammal, animalAmphibian, monkeyFace, animalBird, animalBug, animalReptile, animalMarine, foodMarine, plantOther, foodVegetable, placeBuilding, plantFlower, placeMap, foodFruit, foodAsian, foodPrepared, foodSweet, drink, dishware, sport, tool, game, transportGround, personSport, transportAir, personResting, awardMedal, placeOther, lightVideo, music, musicalInstrument, transportWater, otherObject, placeGeographic, placeReligious, time, phone, computer, science, household, money, medical, transportSign, lock, mail, bookPaper, sound, writing, religion, zodiac, alphanum, warning, avSymbol, otherSymbol, punctuation, geometric, keycap, arrow, math, currency, gender, flag, countryFlag, subdivisionFlag, skinTone, regional
}

/// List of All Emojis.
const _emojis = [Emoji(name: 'grinning face', char: '\u{1F600}', shortName:'grinning', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'grin', 'uc6', 'smiley', 'happy', 'silly', 'laugh', 'thank you', 'awesome', 'smile', 'friend', 'pleased', 'teeth', 'pacman', 'fun', 'awake', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'smiles', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'please', 'chill', 'confident', 'content', 'dentist', 'pac man']), Emoji(name: 'grinning face with big eyes', char: '\u{1F603}', shortName:'smiley', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'mouth', 'open', 'smile', 'uc6', 'smiley', 'happy', 'silly', 'laugh', 'good', 'smile', 'teeth', 'fun', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'smiles', 'dentist', ':-D', '=D']), Emoji(name: 'grinning face with smiling eyes', char: '\u{1F604}', shortName:'smile', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['eye', 'face', 'mouth', 'open', 'smile', 'uc6', 'smiley', 'happy', 'laugh', 'smile', 'teeth', 'fun', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'smiles', 'dentist', ':D']), Emoji(name: 'beaming face with smiling eyes', char: '\u{1F601}', shortName:'grin', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['eye', 'face', 'grin', 'smile', 'uc6', 'smiley', 'happy', 'silly', 'laugh', 'thank you', 'good', 'beautiful', 'selfie', 'smile', 'friend', 'teeth', 'dumb', 'grimace', 'fun', 'proud', 'awake', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'smiles', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'dentist', 'idiot', 'ignorant', 'stupid']), Emoji(name: 'grinning squinting face', char: '\u{1F606}', shortName:'laughing', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'laugh', 'mouth', 'open', 'satisfied', 'smile', 'uc6', 'smiley', 'happy', 'silly', 'laugh', 'smile', 'teeth', 'dumb', 'fun', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'smiles', 'dentist', 'idiot', 'ignorant', 'stupid', '>:)', '>;)', '>:-)', '>=)']), Emoji(name: 'grinning face with sweat', char: '\u{1F605}', shortName:'sweat_smile', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['cold', 'face', 'open', 'smile', 'sweat', 'uc6', 'smiley', 'happy', 'laugh', 'sweat', 'smile', 'tease', 'drip', 'guilty', 'sorry', 'relieved', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'smiles', 'joke', 'kidding', 'satisfied', "':)", "':-)", "'=)", "':D", "':-D", "'=D"]), Emoji(name: 'face with tears of joy', char: '\u{1F602}', shortName:'joy', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'joy', 'laugh', 'tear', 'uc6', 'smiley', 'happy', 'silly', 'cry', 'laugh', 'sarcastic', 'smile', 'tease', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'sarcasm', 'smiles', 'joke', 'kidding', 'weird', 'awkward', 'insane', 'wild', ":')", ":'-)"]), Emoji(name: 'rolling on the floor laughing', char: '\u{1F923}', shortName:'rofl', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'floor', 'laugh', 'rolling', 'uc9', 'smiley', 'happy', 'silly', 'laugh', 'tease', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'joke', 'kidding', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'smiling face', char: '\u{263A}\u{FE0F}', shortName:'relaxed', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['face', 'outlined', 'relaxed', 'smile', 'uc1', 'smiley', 'happy', 'beautiful', 'smile', 'blush', 'pleased', 'relieved', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'smiles', 'blushing', 'bella', 'embarrassed', 'creep', 'please', 'chill', 'confident', 'content', 'satisfied']), Emoji(name: 'smiling face with smiling eyes', char: '\u{1F60A}', shortName:'blush', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['blush', 'eye', 'face', 'smile', 'uc6', 'smiley', 'happy', 'good', 'beautiful', 'smile', 'blush', 'pleased', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'smiles', 'blushing', 'bella', 'embarrassed', 'creep', 'please', 'chill', 'confident', 'content']), Emoji(name: 'smiling face with halo', char: '\u{1F607}', shortName:'innocent', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['angel', 'face', 'fairy tale', 'fantasy', 'halo', 'innocent', 'smile', 'uc6', 'smiley', 'silly', 'pray', 'smile', 'blush', 'fantasy', 'soul', 'sorry', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'smiles', 'blushing', 'bella', 'embarrassed', 'creep', 'O:-)', '0:-3', '0:3', '0:-)', '0:)', '0;^)', 'O:)', 'O;-)', 'O=)', '0;-)', 'O:-3', 'O:3']), Emoji(name: 'slightly smiling face', char: '\u{1F642}', shortName:'slight_smile', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'smile', 'uc7', 'smiley', 'happy', 'awesome', 'smile', 'blush', 'pleased', 'fun', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'smiles', 'blushing', 'bella', 'embarrassed', 'creep', 'please', 'chill', 'confident', 'content', ':)', ':-)', '=]', '=)', ':]']), Emoji(name: 'upside-down face', char: '\u{1F643}', shortName:'upside_down', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'upside-down', 'uc8', 'smiley', 'happy', 'silly', 'sarcastic', 'smile', 'pleased', 'dumb', 'what', 'clever', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'sarcasm', 'smiles', 'please', 'chill', 'confident', 'content', 'idiot', 'ignorant', 'stupid', 'witty']), Emoji(name: 'winking face', char: '\u{1F609}', shortName:'wink', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSmiling, keywords: ['face', 'wink', 'uc6', 'smiley', 'happy', 'silly', 'sarcastic', 'selfie', 'smile', 'tease', 'clever', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'sarcasm', 'smiles', 'joke', 'kidding', 'witty', ';)', ';-)', '*-)', '*)', ';-]', ';]', ';D', ';^)']), Emoji(name: 'relieved face', char: '\u{1F60C}', shortName:'relieved', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSleepy, keywords: ['face', 'relieved', 'uc6', 'smiley', 'happy', 'smile', 'pleased', 'calm', 'relieved', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'smiles', 'please', 'chill', 'confident', 'content', 'satisfied']), Emoji(name: 'smiling face with tear', char: '\u{1F972}', shortName:'smiling_face_with_tear', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['uc13', 'smiley', 'happy', 'cry', 'thank you', 'beautiful', 'smile', 'blush', 'pleased', 'drip', 'hope', 'proud', 'sentimental', 'relieved', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'smiles', 'blushing', 'bella', 'embarrassed', 'creep', 'please', 'chill', 'confident', 'content', 'swear', 'promise', 'nostalgic', 'tender', 'dreamy', 'touched', 'satisfied']), Emoji(name: 'smiling face with heart-eyes', char: '\u{1F60D}', shortName:'heart_eyes', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['eye', 'face', 'love', 'smile', 'uc6', 'smiley', 'happy', 'love', 'heart eyes', 'beautiful', 'smile', 'hola', 'facebook', 'heart', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'smiles', 'hearts', 'serce', 'corazón', 'coração', 'coeur']), Emoji(name: 'smiling face with hearts', char: '\u{1F970}', shortName:'smiling_face_with_3_hearts', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['uc11', 'smiley', 'wedding', 'happy', 'love', 'hug', 'smile', 'friend', 'blush', 'pleased', 'heart', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'embrace', 'hugs', 'smiles', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'blushing', 'bella', 'embarrassed', 'creep', 'please', 'chill', 'confident', 'content', 'hearts', 'serce', 'corazón', 'coração', 'coeur']), Emoji(name: 'face blowing a kiss', char: '\u{1F618}', shortName:'kissing_heart', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['face', 'kiss', 'uc6', 'smiley', 'wedding', 'love', 'sexy', 'beautiful', 'disney', 'kisses', 'hit', 'heart', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'cartoon', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy', 'punch', 'pow', 'bam', 'hearts', 'serce', 'corazón', 'coração', 'coeur', ':*', ':-*', '=*', ':^*']), Emoji(name: 'kissing face', char: '\u{1F617}', shortName:'kissing', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['face', 'kiss', 'uc6', 'smiley', 'sexy', 'beautiful', 'selfie', 'kisses', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy']), Emoji(name: 'kissing face with smiling eyes', char: '\u{1F619}', shortName:'kissing_smiling_eyes', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['eye', 'face', 'kiss', 'smile', 'uc6', 'smiley', 'love', 'sexy', 'kisses', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy']), Emoji(name: 'kissing face with closed eyes', char: '\u{1F61A}', shortName:'kissing_closed_eyes', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['closed', 'eye', 'face', 'kiss', 'uc6', 'smiley', 'love', 'sexy', 'blush', 'kisses', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'blushing', 'bella', 'embarrassed', 'creep', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy']), Emoji(name: 'face savoring food', char: '\u{1F60B}', shortName:'yum', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceTongue, keywords: ['delicious', 'face', 'savouring', 'smile', 'um', 'yum', 'uc6', 'smiley', 'food', 'happy', 'silly', 'sarcastic', 'good', 'smile', 'pink', 'lick', 'tongue', 'dinner', 'picnic', 'delicious', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'sarcasm', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'smiles', 'rose', 'toung', 'tounge', 'lunch', 'savour']), Emoji(name: 'face with tongue', char: '\u{1F61B}', shortName:'stuck_out_tongue', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceTongue, keywords: ['face', 'tongue', 'uc6', 'smiley', 'happy', 'silly', 'pink', 'tease', 'lick', 'tongue', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'rose', 'joke', 'kidding', 'toung', 'tounge', ':P', ':-P', '=P', ':-Þ', ':Þ', ':-b', ':b']), Emoji(name: 'squinting face with tongue', char: '\u{1F61D}', shortName:'stuck_out_tongue_closed_eyes', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceTongue, keywords: ['eye', 'face', 'horrible', 'taste', 'tongue', 'uc6', 'smiley', 'happy', 'silly', 'laugh', 'pink', 'tease', 'grimace', 'lick', 'tongue', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'rose', 'joke', 'kidding', 'toung', 'tounge']), Emoji(name: 'winking face with tongue', char: '\u{1F61C}', shortName:'stuck_out_tongue_winking_eye', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceTongue, keywords: ['eye', 'face', 'joke', 'tongue', 'wink', 'uc6', 'smiley', 'happy', 'silly', 'pink', 'tease', 'pleased', 'lick', 'crazy', 'tongue', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'rose', 'joke', 'kidding', 'please', 'chill', 'confident', 'content', 'weird', 'awkward', 'insane', 'wild', 'toung', 'tounge', '>:P', 'X-P']), Emoji(name: 'zany face', char: '\u{1F92A}', shortName:'zany_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceTongue, keywords: ['eye', 'large', 'small', 'uc10', 'smiley', 'silly', 'nutcase', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'face with raised eyebrow', char: '\u{1F928}', shortName:'face_with_raised_eyebrow', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['uc10', 'smiley', 'doubt', 'jealous', 'colbert', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical']), Emoji(name: 'face with monocle', char: '\u{1F9D0}', shortName:'face_with_monocle', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceGlasses, keywords: ['uc10', 'smiley', 'nerd', 'rich', 'mystery', 'proud', 'explore', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'smart', 'geek', 'serious', 'grand', 'expensive', 'fancy']), Emoji(name: 'nerd face', char: '\u{1F913}', shortName:'nerd', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceGlasses, keywords: ['face', 'geek', 'nerd', 'uc8', 'smiley', 'glasses', 'nerd', 'google', 'brain', 'teeth', 'dumb', 'disguise', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'eyeglasses', 'eye glasses', 'smart', 'geek', 'serious', 'mind', 'memory', 'thought', 'conscience', 'dentist', 'idiot', 'ignorant', 'stupid']), Emoji(name: 'smiling face with sunglasses', char: '\u{1F60E}', shortName:'sunglasses', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceGlasses, keywords: ['bright', 'cool', 'eye', 'eyewear', 'face', 'glasses', 'smile', 'sun', 'sunglasses', 'uc6', 'smiley', 'happy', 'silly', 'glasses', 'emojione', 'awesome', 'beautiful', 'smile', 'sunglasses', 'hawaii', 'california', 'florida', 'las vegas', 'fun', 'summer', 'clever', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'eyeglasses', 'eye glasses', 'emoji one', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'smiles', 'shades', 'lunettes de soleil', 'sun glasses', 'aloha', 'kawaii', 'maui', 'moana', 'vegas', 'weekend', 'witty', 'B-)', 'B)', '8)', '8-)', 'B-D', '8-D']), Emoji(name: 'star-struck', char: '\u{1F929}', shortName:'star_struck', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceAffection, keywords: ['uc10', 'smiley', 'happy', 'selfie', 'fame', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'famous', 'celebrity']), Emoji(name: 'partying face', char: '\u{1F973}', shortName:'partying_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHat, keywords: ['uc11', 'smiley', 'holidays', 'happy', 'silly', 'hat', 'cheers', 'happy birthday', 'confetti', 'celebrate', 'fun', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'holiday', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'hats', 'cap', 'caps', 'gān bēi', 'Na zdravi', 'Proost', 'Prost', 'Sláinte', 'Cin cin', 'Kanpai', 'Na zdrowie', 'Saúde', 'На здоровье', 'Salud', 'Skål', 'Sei gesund', 'santé', 'Bon anniversaire', 'joyeux anniversaire', 'buon compleanno', 'feliz cumpleaños', 'alles Gute zum Geburtstag', 'feliz Aniversário', 'Gratulerer med dagen', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar']), Emoji(name: 'smirking face', char: '\u{1F60F}', shortName:'smirk', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['face', 'smirk', 'uc6', 'smiley', 'happy', 'silly', 'sexy', 'sarcastic', 'smile', 'pleased', 'clever', 'proud', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'sarcasm', 'smiles', 'please', 'chill', 'confident', 'content', 'witty']), Emoji(name: 'unamused face', char: '\u{1F612}', shortName:'unamused', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['face', 'unamused', 'unhappy', 'uc6', 'smiley', 'sad', 'tired', 'angry', 'bored', 'detest', 'doubt', 'grimace', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'boring', 'agree', 'whatever', 'boredom', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical']), Emoji(name: 'disappointed face', char: '\u{1F61E}', shortName:'disappointed', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['disappointed', 'face', 'uc6', 'smiley', 'sad', 'tired', 'angry', 'bored', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'boring', 'agree', 'whatever', 'boredom', '>:[', ':-(', ':(', ':-[', ':[', '=(']), Emoji(name: 'pensive face', char: '\u{1F614}', shortName:'pensive', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSleepy, keywords: ['dejected', 'face', 'pensive', 'uc6', 'smiley', 'sad', 'rip', 'guilty', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'rest in peace']), Emoji(name: 'worried face', char: '\u{1F61F}', shortName:'worried', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'worried', 'uc6', 'smiley', 'sad', 'angry', 'doubt', 'guilty', 'jealous', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical']), Emoji(name: 'confused face', char: '\u{1F615}', shortName:'confused', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['confused', 'face', 'uc6', 'smiley', 'nurse', 'doubt', 'what', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', '>:\\', '>:/', ':-/', ':-.', ':/', ':\\', '=/', '=\\', ':L', '=L']), Emoji(name: 'slightly frowning face', char: '\u{1F641}', shortName:'slight_frown', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'frown', 'uc7', 'smiley', 'sad', 'angry', 'detest', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no']), Emoji(name: 'frowning face', char: '\u{2639}\u{FE0F}', shortName:'frowning2', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'frown', 'uc1', 'smiley', 'sad', 'angry', 'detest', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no']), Emoji(name: 'persevering face', char: '\u{1F623}', shortName:'persevere', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'persevere', 'uc6', 'smiley', 'angry', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', '>.<']), Emoji(name: 'confounded face', char: '\u{1F616}', shortName:'confounded', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['confounded', 'face', 'uc6', 'smiley', 'angry', 'wow', 'detest', 'stinky', 'ugly', 'confused', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'smell', 'stink', 'odor', 'perplexed']), Emoji(name: 'tired face', char: '\u{1F62B}', shortName:'tired_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'tired', 'uc6', 'smiley', 'sad', 'tired', 'angry', 'sick', 'wow', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed']), Emoji(name: 'weary face', char: '\u{1F629}', shortName:'weary', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'tired', 'weary', 'uc6', 'smiley', 'sad', 'tired', 'angry', 'stressed', 'wow', 'shame', 'lazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed']), Emoji(name: 'pleading face', char: '\u{1F97A}', shortName:'pleading_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['uc11', 'smiley', 'sad', 'cry', 'condolence', 'omg', 'heartbreak', 'blush', 'begging', 'doubt', 'guilty', 'help', 'shame', 'hope', 'liar', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'compassion', 'omfg', 'oh my god', 'broken heart', 'heartbroken', 'blushing', 'bella', 'embarrassed', 'creep', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'swear', 'promise', 'lies', 'lying']), Emoji(name: 'crying face', char: '\u{1F622}', shortName:'cry', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['cry', 'face', 'sad', 'tear', 'uc6', 'smiley', 'sad', 'cry', 'rip', 'heartbreak', 'drip', 'guilty', 'covid', 'sorry', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'rest in peace', 'broken heart', 'heartbroken', ":'(", ":'-(", ';(', ';-(']), Emoji(name: 'loudly crying face', char: '\u{1F62D}', shortName:'sob', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['cry', 'face', 'sad', 'sob', 'tear', 'uc6', 'smiley', 'sad', 'cry', 'rip', 'heartbreak', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'rest in peace', 'broken heart', 'heartbroken']), Emoji(name: 'face with steam from nose', char: '\u{1F624}', shortName:'triumph', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['face', 'triumph', 'won', 'uc6', 'smiley', 'angry', 'smoking', 'steam', 'breathe', 'proud', 'festivus', 'booger', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'smoke', 'cigarette', 'puff', 'steaming', 'piping', 'sigh', 'inhale']), Emoji(name: 'face exhaling', char: '\u{1F62E}\u{200D}\u{1F4A8}', shortName:'face_exhaling', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['uc13', 'winter', 'smoking', 'breathe', 'spa', 'relieved', 'hiver', 'smoke', 'cigarette', 'puff', 'sigh', 'inhale', 'relax', 'sauna', 'satisfied']), Emoji(name: 'angry face', char: '\u{1F620}', shortName:'angry', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['angry', 'face', 'mad', 'uc6', 'smiley', 'angry', 'detest', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', '>:(', '>:-(', ':@']), Emoji(name: 'pouting face', char: '\u{1F621}', shortName:'rage', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['angry', 'face', 'mad', 'pouting', 'rage', 'red', 'uc6', 'smiley', 'angry', 'detest', 'bitch', 'guilty', 'las vegas', 'killer', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'vegas', 'savage', 'scary clown']), Emoji(name: 'face with symbols on mouth', char: '\u{1F92C}', shortName:'face_with_symbols_over_mouth', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['uc10', 'smiley', 'angry', 'detest', 'swearing', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'cussing', 'cursing']), Emoji(name: 'exploding head', char: '\u{1F92F}', shortName:'exploding_head', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['shocked', 'uc10', 'smiley', 'angry', 'wow', 'omg', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'omfg', 'oh my god']), Emoji(name: 'flushed face', char: '\u{1F633}', shortName:'flushed', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['dazed', 'face', 'flushed', 'uc6', 'smiley', 'omg', 'blush', 'guilty', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'omfg', 'oh my god', 'blushing', 'bella', 'embarrassed', 'creep', ':\$', '=\$']), Emoji(name: 'face in clouds', char: '\u{1F636}\u{200D}\u{1F32B}\u{FE0F}', shortName:'face_in_clouds', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['uc13', 'cloud', 'clouds', 'nuage']), Emoji(name: 'hot face', char: '\u{1F975}', shortName:'hot_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['uc11', 'weather', 'smiley', 'stressed', 'sweat', 'hot', 'detest', 'summer', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'weekend']), Emoji(name: 'cold face', char: '\u{1F976}', shortName:'cold_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['uc11', 'weather', 'smiley', 'winter', 'snow', 'cold', 'grimace', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hiver', 'freeze', 'frozen', 'frost', 'ice cube', 'chilly', 'chilled', 'brisk', 'freezing', 'frostbite', 'icicles']), Emoji(name: 'face screaming in fear', char: '\u{1F631}', shortName:'scream', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'fear', 'fearful', 'munch', 'scared', 'scream', 'uc6', 'smiley', 'halloween', 'wow', 'omg', 'fame', 'ugly', 'what', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'samhain', 'trick or treat', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'omfg', 'oh my god', 'famous', 'celebrity', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'fearful face', char: '\u{1F628}', shortName:'fearful', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'fear', 'fearful', 'scared', 'uc6', 'smiley', 'stressed', 'wow', 'guilty', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'D:']), Emoji(name: 'anxious face with sweat', char: '\u{1F630}', shortName:'cold_sweat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['blue', 'cold', 'face', 'mouth', 'open', 'rushed', 'sweat', 'uc6', 'smiley', 'angry', 'stressed', 'sweat', 'drip', 'covid', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad']), Emoji(name: 'sad but relieved face', char: '\u{1F625}', shortName:'disappointed_relieved', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['disappointed', 'face', 'relieved', 'whew', 'uc6', 'smiley', 'sad', 'cry', 'stressed', 'sweat', 'calm', 'drip', 'guilty', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling']), Emoji(name: 'downcast face with sweat', char: '\u{1F613}', shortName:'sweat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['cold', 'face', 'sweat', 'uc6', 'smiley', 'sad', 'stressed', 'sweat', 'drip', 'guilty', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', "':(", "':-(", "'=("]), Emoji(name: 'hugging face', char: '\u{1F917}', shortName:'hugging', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHand, keywords: ['face', 'hug', 'hugging', 'uc8', 'smiley', 'happy', 'tired', 'love', 'hug', 'thank you', 'friend', 'blush', 'facebook', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'embrace', 'hugs', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'blushing', 'bella', 'embarrassed', 'creep']), Emoji(name: 'thinking face', char: '\u{1F914}', shortName:'thinking', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHand, keywords: ['face', 'thinking', 'uc8', 'smiley', 'dream', 'brain', 'doubt', 'idea', 'confused', 'what', 'mystery', 'innovate', 'question', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'dreams', 'mind', 'memory', 'thought', 'conscience', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'perplexed', 'innovation', 'inquire', 'quiz', 'puzzled']), Emoji(name: 'face with hand over mouth', char: '\u{1F92D}', shortName:'face_with_hand_over_mouth', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHand, keywords: ['uc10', 'smiley', 'tired', 'blush', 'tease', 'quiet', 'what', 'secret', 'yawn', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'blushing', 'bella', 'embarrassed', 'creep', 'joke', 'kidding', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'shhhhh']), Emoji(name: 'yawning face', char: '\u{1F971}', shortName:'yawning_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['uc12', 'smiley', 'tired', 'goodnight', 'bored', 'calm', 'quiet', 'wait', 'yawn', 'lazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'boring', 'agree', 'whatever', 'boredom', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'hours']), Emoji(name: 'shushing face', char: '\u{1F92B}', shortName:'shushing_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHand, keywords: ['quiet', 'shush', 'uc10', 'smiley', 'quiet', 'secret', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'shhhhh']), Emoji(name: 'lying face', char: '\u{1F925}', shortName:'lying_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['face', 'lie', 'pinocchio', 'uc9', 'smiley', 'guilty', 'crazy', 'liar', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'weird', 'awkward', 'insane', 'wild', 'lies', 'lying']), Emoji(name: 'face without mouth', char: '\u{1F636}', shortName:'no_mouth', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['face', 'mouth', 'quiet', 'silent', 'uc6', 'smiley', 'neutral', 'detest', 'dumb', 'quiet', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'idiot', 'ignorant', 'stupid', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', ':-X', ':X', ':-#', ':#', '=X', '=#']), Emoji(name: 'neutral face', char: '\u{1F610}', shortName:'neutral_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['deadpan', 'face', 'neutral', 'uc6', 'smiley', 'shrug', 'neutral', 'bored', 'calm', 'doubt', 'dumb', 'quiet', 'sorry', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'boring', 'agree', 'whatever', 'boredom', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh']), Emoji(name: 'expressionless face', char: '\u{1F611}', shortName:'expressionless', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['expressionless', 'face', 'inexpressive', 'unexpressive', 'uc6', 'smiley', 'neutral', 'bored', 'calm', 'doubt', 'dumb', 'quiet', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'boring', 'agree', 'whatever', 'boredom', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', '-_-', '-__-', '-___-']), Emoji(name: 'grimacing face', char: '\u{1F62C}', shortName:'grimacing', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['face', 'grimace', 'uc6', 'smiley', 'silly', 'selfie', 'teeth', 'grimace', 'help', 'sorry', 'relieved', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'dentist', 'satisfied']), Emoji(name: 'face with rolling eyes', char: '\u{1F644}', shortName:'rolling_eyes', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['eyes', 'face', 'rolling', 'uc8', 'smiley', 'rolling eyes', 'sarcastic', 'bored', 'detest', 'doubt', 'eyeroll', 'jealous', 'sorry', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'eye roll', 'side eye', 'sarcasm', 'boring', 'agree', 'whatever', 'boredom', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical']), Emoji(name: 'hushed face', char: '\u{1F62F}', shortName:'hushed', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'hushed', 'stunned', 'surprised', 'uc6', 'smiley', 'wow', 'what', 'sorry', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed']), Emoji(name: 'frowning face with open mouth', char: '\u{1F626}', shortName:'frowning', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'frown', 'mouth', 'open', 'uc6', 'smiley', 'sad', 'jealous', 'what', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness']), Emoji(name: 'anguished face', char: '\u{1F627}', shortName:'anguished', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['anguished', 'face', 'uc6', 'smiley', 'sad', 'stressed', 'wow', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed']), Emoji(name: 'face with open mouth', char: '\u{1F62E}', shortName:'open_mouth', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['face', 'mouth', 'open', 'sympathy', 'uc6', 'smiley', 'wow', 'dumb', 'what', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'idiot', 'ignorant', 'stupid', ':-O', ':O', 'O_O', '>:O']), Emoji(name: 'astonished face', char: '\u{1F632}', shortName:'astonished', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceConcerned, keywords: ['astonished', 'face', 'shocked', 'totally', 'uc6', 'smiley', 'wow', 'omg', 'crazy', 'mystery', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'omfg', 'oh my god', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'sleeping face', char: '\u{1F634}', shortName:'sleeping', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSleepy, keywords: ['face', 'sleep', 'zzz', 'uc6', 'smiley', 'tired', 'goodnight', 'coffee', 'dream', 'calm', 'lazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'sleepy', 'sleep', 'dormi', 'pillow', 'blanket', 'exhausted', 'starbucks', 'dreams']), Emoji(name: 'drooling face', char: '\u{1F924}', shortName:'drooling_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSleepy, keywords: ['drooling', 'face', 'uc9', 'smiley', 'beautiful', 'dumb', 'ugly', 'what', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'idiot', 'ignorant', 'stupid', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'sleepy face', char: '\u{1F62A}', shortName:'sleepy', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceSleepy, keywords: ['face', 'sleep', 'uc6', 'smiley', 'sad', 'sick', 'costume', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'triste', 'depression', 'negative', 'sadness', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever']), Emoji(name: 'knocked-out face', char: '\u{1F635}', shortName:'dizzy_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['dizzy', 'face', 'uc6', 'smiley', 'dead', 'wow', 'nutcase', 'omg', 'detest', 'drunk', 'dumb', 'las vegas', 'what', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'death', 'die', 'dying', 'fart', 'goth', 'grave', 'headstone', 'horror', 'hurt', 'kill', 'murder', 'tomb', 'toot', 'died', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'omfg', 'oh my god', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'flustered', 'dizzy', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild', '#-)', '#)', '%-)', '%)', 'X)', 'X-)']), Emoji(name: 'face with spiral eyes', char: '\u{1F635}\u{200D}\u{1F4AB}', shortName:'face_with_spiral_eyes', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['uc13', 'drunk', 'flustered', 'dizzy']), Emoji(name: 'zipper-mouth face', char: '\u{1F910}', shortName:'zipper_mouth', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNeutralSkeptical, keywords: ['face', 'mouth', 'zipper', 'uc8', 'smiley', 'angry', 'fight', 'dumb', 'quiet', 'crazy', 'secret', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'idiot', 'ignorant', 'stupid', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'weird', 'awkward', 'insane', 'wild', 'shhhhh']), Emoji(name: 'woozy face', char: '\u{1F974}', shortName:'woozy_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['uc11', 'smiley', 'silly', 'drugs', 'sick', 'drunk', 'dumb', 'ugly', 'crazy', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'drug', 'narcotics', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'flustered', 'dizzy', 'idiot', 'ignorant', 'stupid', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'nauseated face', char: '\u{1F922}', shortName:'nauseated_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['face', 'nauseated', 'vomit', 'uc9', 'smiley', 'bathroom', 'sick', 'detest', 'drunk', 'stinky', 'poison', 'full', 'Nauseated', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'flustered', 'dizzy', 'smell', 'stink', 'odor', 'toxic', 'toxins', 'green face']), Emoji(name: 'face vomiting', char: '\u{1F92E}', shortName:'face_vomiting', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['sick', 'vomit', 'uc10', 'smiley', 'bathroom', 'sick', 'detest', 'Nauseated', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'green face']), Emoji(name: 'sneezing face', char: '\u{1F927}', shortName:'sneezing_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['face', 'gesundheit', 'sneeze', 'uc9', 'smiley', 'sick', 'nurse', 'stinky', 'booger', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'smell', 'stink', 'odor']), Emoji(name: 'face with medical mask', char: '\u{1F637}', shortName:'mask', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['cold', 'doctor', 'face', 'mask', 'medicine', 'sick', 'uc6', 'smiley', 'dead', 'health', 'sick', 'teeth', 'nurse', 'clean', 'poison', 'mask', 'virus', 'covid', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'death', 'die', 'dying', 'fart', 'goth', 'grave', 'headstone', 'horror', 'hurt', 'kill', 'murder', 'tomb', 'toot', 'died', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'dentist', 'toxic', 'toxins', 'corona']), Emoji(name: 'face with thermometer', char: '\u{1F912}', shortName:'thermometer_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['face', 'ill', 'sick', 'thermometer', 'uc8', 'smiley', 'health', 'sick', 'nurse', 'virus', 'covid', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'corona']), Emoji(name: 'face with head-bandage', char: '\u{1F915}', shortName:'head_bandage', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceUnwell, keywords: ['bandage', 'face', 'hurt', 'injury', 'uc8', 'smiley', 'health', 'sick', 'nurse', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever']), Emoji(name: 'money-mouth face', char: '\u{1F911}', shortName:'money_mouth', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceTongue, keywords: ['face', 'money', 'mouth', 'uc8', 'smiley', 'money', 'win', 'power', 'stinky', 'coins', 'discount', 'jealous', 'las vegas', 'rich', 'greed', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'cash', 'dollars', 'dollar', 'bucks', 'currency', 'funds', 'payment', 'money face', 'reward', 'thief', 'bank', 'benjamins', 'argent', 'dinero', 'i soldi', 'Geld', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'smell', 'stink', 'odor', 'sale', 'bargain', 'vegas', 'grand', 'expensive', 'fancy', 'selfish']), Emoji(name: 'cowboy hat face', char: '\u{1F920}', shortName:'cowboy', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHat, keywords: ['cowboy', 'cowgirl', 'face', 'hat', 'uc9', 'smiley', 'america', 'hat', 'magic', 'disney', 'fame', 'super hero', 'texas', 'costume', 'independence day', 'disguise', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'usa', 'united states', 'united states of america', 'american', 'hats', 'cap', 'caps', 'spell', 'genie', 'magical', 'cartoon', 'famous', 'celebrity', 'superhero', 'superman', 'batman', '4th of july']), Emoji(name: 'disguised face', char: '\u{1F978}', shortName:'disguised_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceHat, keywords: ['uc13', 'smiley', 'silly', 'halloween', 'eyes', 'celebrate', 'crazy', 'mystery', 'costume', 'clever', 'disguise', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'samhain', 'trick or treat', 'eye', 'eyebrow', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'witty']), Emoji(name: 'smiling face with horns', char: '\u{1F608}', shortName:'smiling_imp', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['face', 'fairy tale', 'fantasy', 'horns', 'smile', 'uc6', 'smiley', 'silly', 'halloween', 'angry', 'monster', 'evil', 'guilty', 'jealous', 'crazy', 'killer', 'disguise', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'samhain', 'trick or treat', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'monsters', 'beast', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'weird', 'awkward', 'insane', 'wild', 'savage', 'scary clown']), Emoji(name: 'angry face with horns', char: '\u{1F47F}', shortName:'imp', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['demon', 'devil', 'face', 'fairy tale', 'fantasy', 'imp', 'uc6', 'smiley', 'halloween', 'angry', 'monster', 'wth', 'fight', 'evil', 'dumb', 'vampire', 'crazy', 'killer', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'samhain', 'trick or treat', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'monsters', 'beast', 'what the hell', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'idiot', 'ignorant', 'stupid', 'dracula', 'weird', 'awkward', 'insane', 'wild', 'savage', 'scary clown']), Emoji(name: 'ogre', char: '\u{1F479}', shortName:'japanese_ogre', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['uc6', 'halloween', 'japan', 'angry', 'monster', 'wow', 'evil', 'super hero', 'ugly', 'crazy', 'killer', 'disguise', 'samhain', 'trick or treat', 'japanese', 'ninja', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'monsters', 'beast', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'superhero', 'superman', 'batman', 'weird', 'awkward', 'insane', 'wild', 'savage', 'scary clown']), Emoji(name: 'goblin', char: '\u{1F47A}', shortName:'japanese_goblin', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['creature', 'face', 'fairy tale', 'fantasy', 'monster', 'uc6', 'halloween', 'japan', 'angry', 'monster', 'wow', 'mustache', 'evil', 'super hero', 'ugly', 'crazy', 'killer', 'mask', 'disguise', 'samhain', 'trick or treat', 'japanese', 'ninja', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'monsters', 'beast', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'superhero', 'superman', 'batman', 'weird', 'awkward', 'insane', 'wild', 'savage', 'scary clown']), Emoji(name: 'clown face', char: '\u{1F921}', shortName:'clown', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['clown', 'face', 'uc9', 'smiley', 'silly', 'halloween', 'laugh', 'circus', 'magic', 'mcdonalds', 'super hero', 'crazy', 'killer', 'costume', 'disguise', 'smileys', 'mood', 'emotion', 'emotions', 'emotional', 'funny', 'samhain', 'trick or treat', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'circus tent', 'clown', 'clowns', 'spell', 'genie', 'magical', 'ronald mcdonald', 'macdo', 'superhero', 'superman', 'batman', 'weird', 'awkward', 'insane', 'wild', 'savage', 'scary clown']), Emoji(name: 'pile of poo', char: '\u{1F4A9}', shortName:'poop', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['comic', 'dung', 'face', 'monster', 'poo', 'poop', 'uc6', 'silly', 'butt', 'bathroom', 'dead', 'sol', 'diarrhea', 'shit', 'bitch', 'stinky', 'dumb', 'ugly', 'funny', 'ass', 'booty', 'anal', 'death', 'die', 'dying', 'fart', 'goth', 'grave', 'headstone', 'horror', 'hurt', 'kill', 'murder', 'tomb', 'toot', 'died', 'shit outta luck', 'shit out of luck', 'bad luck', 'shits', 'the shits', 'poop', 'turd', 'feces', 'pile', 'merde', 'butthole', 'caca', 'crap', 'dirty', 'pooo', 'mess', 'brown', 'poopoo', 'complain', 'smell', 'stink', 'odor', 'idiot', 'ignorant', 'stupid']), Emoji(name: 'ghost', char: '\u{1F47B}', shortName:'ghost', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['creature', 'face', 'fairy tale', 'fantasy', 'monster', 'uc6', 'holidays', 'halloween', 'dead', 'monster', 'wow', 'disney', 'pacman', 'disguise', 'holiday', 'samhain', 'trick or treat', 'death', 'die', 'dying', 'fart', 'goth', 'grave', 'headstone', 'horror', 'hurt', 'kill', 'murder', 'tomb', 'toot', 'died', 'monsters', 'beast', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'cartoon', 'pac man']), Emoji(name: 'skull', char: '\u{1F480}', shortName:'skull', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['death', 'face', 'fairy tale', 'monster', 'uc6', 'halloween', 'dead', 'skull', 'wow', 'harry potter', 'pirate', 'poison', 'super hero', 'killer', 'bones', 'samhain', 'trick or treat', 'death', 'die', 'dying', 'fart', 'goth', 'grave', 'headstone', 'horror', 'hurt', 'kill', 'murder', 'tomb', 'toot', 'died', 'skull and crossbones', 'skeleton', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'toxic', 'toxins', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'Os', 'hueso']), Emoji(name: 'skull and crossbones', char: '\u{2620}\u{FE0F}', shortName:'skull_crossbones', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceNegative, keywords: ['crossbones', 'death', 'face', 'monster', 'skull', 'uc1', 'halloween', 'dead', 'skull', 'wow', 'deadpool', 'pirate', 'danger', 'disney', 'poison', 'killer', 'bones', 'samhain', 'trick or treat', 'death', 'die', 'dying', 'fart', 'goth', 'grave', 'headstone', 'horror', 'hurt', 'kill', 'murder', 'tomb', 'toot', 'died', 'skull and crossbones', 'skeleton', 'surprised', 'scared', 'shocked', 'whoa', 'surprise', 'scary', 'nervous', 'shaking', 'afraid', 'amaze', 'amazing', 'creepy', 'cringe', 'gasp', 'anxious', 'mind blown', 'booo', 'amazed', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'cartoon', 'toxic', 'toxins', 'savage', 'scary clown', 'Os', 'hueso']), Emoji(name: 'alien', char: '\u{1F47D}', shortName:'alien', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo', 'uc6', 'space', 'monster', 'alien', 'scientology', 'star wars', 'disguise', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'monsters', 'beast', 'ufo', 'scientologist']), Emoji(name: 'alien monster', char: '\u{1F47E}', shortName:'space_invader', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['alien', 'creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo', 'uc6', 'space', 'monster', 'alien', 'star wars', 'vintage', 'pacman', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'monsters', 'beast', 'ufo', 'pac man']), Emoji(name: 'robot', char: '\u{1F916}', shortName:'robot', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.faceCostume, keywords: ['face', 'monster', 'robot', 'uc8', 'monster', 'disney', 'drone', 'monsters', 'beast', 'cartoon']), Emoji(name: 'jack-o-lantern', char: '\u{1F383}', shortName:'jack_o_lantern', emojiGroup: EmojiGroup.activities, emojiSubgroup: EmojiSubgroup.event, keywords: ['celebration', 'halloween', 'jack', 'lantern', 'uc6', 'holidays', 'halloween', 'pumpkin', 'minecraft', 'holiday', 'samhain', 'trick or treat', 'jack o lantern', 'zucca', 'citrouille']), Emoji(name: 'grinning cat', char: '\u{1F63A}', shortName:'smiley_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'face', 'mouth', 'open', 'smile', 'uc6', 'animal', 'happy', 'silly', 'cat', 'animals', 'animal kingdom', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow']), Emoji(name: 'grinning cat with smiling eyes', char: '\u{1F638}', shortName:'smile_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'eye', 'face', 'grin', 'smile', 'uc6', 'animal', 'happy', 'silly', 'cat', 'animals', 'animal kingdom', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow']), Emoji(name: 'cat with tears of joy', char: '\u{1F639}', shortName:'joy_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'face', 'joy', 'tear', 'uc6', 'animal', 'happy', 'silly', 'cry', 'laugh', 'cat', 'sarcastic', 'tease', 'animals', 'animal kingdom', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'funny', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'laughing', 'lol', 'rofl', 'lmao', 'lmfao', 'hilarious', 'ha', 'haha', 'chuckle', 'comedy', 'giggle', 'hehe', 'joyful', 'laugh out loud', 'rire', 'tee hee', 'jaja', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow', 'sarcasm', 'joke', 'kidding']), Emoji(name: 'smiling cat with heart-eyes', char: '\u{1F63B}', shortName:'heart_eyes_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'eye', 'face', 'love', 'smile', 'uc6', 'animal', 'happy', 'love', 'cat', 'heart eyes', 'beautiful', 'heart', 'animals', 'animal kingdom', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'hearts', 'serce', 'corazón', 'coração', 'coeur']), Emoji(name: 'cat with wry smile', char: '\u{1F63C}', shortName:'smirk_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'face', 'ironic', 'smile', 'wry', 'uc6', 'animal', 'cat', 'animals', 'animal kingdom', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow']), Emoji(name: 'kissing cat', char: '\u{1F63D}', shortName:'kissing_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'eye', 'face', 'kiss', 'uc6', 'animal', 'love', 'cat', 'kisses', 'animals', 'animal kingdom', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy']), Emoji(name: 'weary cat', char: '\u{1F640}', shortName:'scream_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'face', 'oh', 'surprised', 'weary', 'uc6', 'animal', 'cat', 'animals', 'animal kingdom', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow']), Emoji(name: 'crying cat', char: '\u{1F63F}', shortName:'crying_cat_face', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'cry', 'face', 'sad', 'tear', 'uc6', 'animal', 'cry', 'cat', 'animals', 'animal kingdom', 'crying', 'weeping', 'weep', 'sob', 'sobbing', 'tear', 'tears', 'bawling', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow']), Emoji(name: 'pouting cat', char: '\u{1F63E}', shortName:'pouting_cat', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.catFace, keywords: ['cat', 'face', 'pouting', 'uc6', 'animal', 'cat', 'animals', 'animal kingdom', 'kitty', 'kitten', 'cats', 'kittens', 'kitties', 'feline', 'felines', 'cat face', 'gato', 'meow']), Emoji(name: 'palms up together', char: '\u{1F932}', shortName:'palms_up_together', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['uc10', 'diversity', 'body', 'hands', 'pray', 'soul', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering']), Emoji(name: 'palms up together: light skin tone', char: '\u{1F932}\u{1F3FB}', shortName:'palms_up_together_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['light skin tone', 'prayer', 'uc10', 'diversity', 'body', 'hands', 'pray', 'soul', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering'], modifiable: true), Emoji(name: 'palms up together: medium-light skin tone', char: '\u{1F932}\u{1F3FC}', shortName:'palms_up_together_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['medium-light skin tone', 'prayer', 'uc10', 'diversity', 'body', 'hands', 'pray', 'soul', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering'], modifiable: true), Emoji(name: 'palms up together: medium skin tone', char: '\u{1F932}\u{1F3FD}', shortName:'palms_up_together_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['medium skin tone', 'prayer', 'uc10', 'diversity', 'body', 'hands', 'pray', 'soul', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering'], modifiable: true), Emoji(name: 'palms up together: medium-dark skin tone', char: '\u{1F932}\u{1F3FE}', shortName:'palms_up_together_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['medium-dark skin tone', 'prayer', 'uc10', 'diversity', 'body', 'hands', 'pray', 'soul', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering'], modifiable: true), Emoji(name: 'palms up together: dark skin tone', char: '\u{1F932}\u{1F3FF}', shortName:'palms_up_together_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['dark skin tone', 'prayer', 'uc10', 'diversity', 'body', 'hands', 'pray', 'soul', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering'], modifiable: true), Emoji(name: 'open hands', char: '\u{1F450}', shortName:'open_hands', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['hand', 'open', 'uc6', 'diversity', 'body', 'hands', 'hi', 'thank you', 'condolence', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'compassion', 'прив', 'privé', 'privado', 'reserved']), Emoji(name: 'open hands: light skin tone', char: '\u{1F450}\u{1F3FB}', shortName:'open_hands_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['hand', 'light skin tone', 'open', 'uc8', 'diversity', 'body', 'hands', 'hi', 'thank you', 'condolence', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'compassion', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'open hands: medium-light skin tone', char: '\u{1F450}\u{1F3FC}', shortName:'open_hands_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['hand', 'medium-light skin tone', 'open', 'uc8', 'diversity', 'body', 'hands', 'hi', 'thank you', 'condolence', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'compassion', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'open hands: medium skin tone', char: '\u{1F450}\u{1F3FD}', shortName:'open_hands_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['hand', 'medium skin tone', 'open', 'uc8', 'diversity', 'body', 'hands', 'hi', 'thank you', 'condolence', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'compassion', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'open hands: medium-dark skin tone', char: '\u{1F450}\u{1F3FE}', shortName:'open_hands_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['hand', 'medium-dark skin tone', 'open', 'uc8', 'diversity', 'body', 'hands', 'hi', 'thank you', 'condolence', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'compassion', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'open hands: dark skin tone', char: '\u{1F450}\u{1F3FF}', shortName:'open_hands_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['dark skin tone', 'hand', 'open', 'uc8', 'diversity', 'body', 'hands', 'hi', 'thank you', 'condolence', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'compassion', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'raising hands', char: '\u{1F64C}', shortName:'raised_hands', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['celebration', 'gesture', 'hand', 'hooray', 'raised', 'uc6', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'thank you', 'perfect', 'pray', 'good', 'easter', 'fame', 'festivus', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'famous', 'celebrity', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK']), Emoji(name: 'raising hands: light skin tone', char: '\u{1F64C}\u{1F3FB}', shortName:'raised_hands_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['celebration', 'gesture', 'hand', 'hooray', 'light skin tone', 'raised', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'thank you', 'perfect', 'pray', 'good', 'easter', 'fame', 'festivus', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'famous', 'celebrity', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raising hands: medium-light skin tone', char: '\u{1F64C}\u{1F3FC}', shortName:'raised_hands_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['celebration', 'gesture', 'hand', 'hooray', 'medium-light skin tone', 'raised', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'thank you', 'perfect', 'pray', 'good', 'easter', 'fame', 'festivus', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'famous', 'celebrity', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raising hands: medium skin tone', char: '\u{1F64C}\u{1F3FD}', shortName:'raised_hands_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['celebration', 'gesture', 'hand', 'hooray', 'medium skin tone', 'raised', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'thank you', 'perfect', 'pray', 'good', 'easter', 'fame', 'festivus', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'famous', 'celebrity', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raising hands: medium-dark skin tone', char: '\u{1F64C}\u{1F3FE}', shortName:'raised_hands_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['celebration', 'gesture', 'hand', 'hooray', 'medium-dark skin tone', 'raised', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'thank you', 'perfect', 'pray', 'good', 'easter', 'fame', 'festivus', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'famous', 'celebrity', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raising hands: dark skin tone', char: '\u{1F64C}\u{1F3FF}', shortName:'raised_hands_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['celebration', 'dark skin tone', 'gesture', 'hand', 'hooray', 'raised', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'thank you', 'perfect', 'pray', 'good', 'easter', 'fame', 'festivus', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'famous', 'celebrity', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'clapping hands', char: '\u{1F44F}', shortName:'clap', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['clap', 'hand', 'uc6', 'diversity', 'happy', 'body', 'hands', 'thank you', 'win', 'awesome', 'good', 'beautiful', 'clap', 'celebrate', 'pleased', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'clapping', 'claps', 'clapping hands', 'applause', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'please', 'chill', 'confident', 'content']), Emoji(name: 'clapping hands: light skin tone', char: '\u{1F44F}\u{1F3FB}', shortName:'clap_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['clap', 'hand', 'light skin tone', 'uc8', 'diversity', 'happy', 'body', 'hands', 'thank you', 'win', 'awesome', 'good', 'beautiful', 'clap', 'celebrate', 'pleased', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'clapping', 'claps', 'clapping hands', 'applause', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'please', 'chill', 'confident', 'content'], modifiable: true), Emoji(name: 'clapping hands: medium-light skin tone', char: '\u{1F44F}\u{1F3FC}', shortName:'clap_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['clap', 'hand', 'medium-light skin tone', 'uc8', 'diversity', 'happy', 'body', 'hands', 'thank you', 'win', 'awesome', 'good', 'beautiful', 'clap', 'celebrate', 'pleased', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'clapping', 'claps', 'clapping hands', 'applause', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'please', 'chill', 'confident', 'content'], modifiable: true), Emoji(name: 'clapping hands: medium skin tone', char: '\u{1F44F}\u{1F3FD}', shortName:'clap_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['clap', 'hand', 'medium skin tone', 'uc8', 'diversity', 'happy', 'body', 'hands', 'thank you', 'win', 'awesome', 'good', 'beautiful', 'clap', 'celebrate', 'pleased', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'clapping', 'claps', 'clapping hands', 'applause', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'please', 'chill', 'confident', 'content'], modifiable: true), Emoji(name: 'clapping hands: medium-dark skin tone', char: '\u{1F44F}\u{1F3FE}', shortName:'clap_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['clap', 'hand', 'medium-dark skin tone', 'uc8', 'diversity', 'happy', 'body', 'hands', 'thank you', 'win', 'awesome', 'good', 'beautiful', 'clap', 'celebrate', 'pleased', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'clapping', 'claps', 'clapping hands', 'applause', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'please', 'chill', 'confident', 'content'], modifiable: true), Emoji(name: 'clapping hands: dark skin tone', char: '\u{1F44F}\u{1F3FF}', shortName:'clap_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['clap', 'dark skin tone', 'hand', 'uc8', 'diversity', 'happy', 'body', 'hands', 'thank you', 'win', 'awesome', 'good', 'beautiful', 'clap', 'celebrate', 'pleased', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'clapping', 'claps', 'clapping hands', 'applause', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'please', 'chill', 'confident', 'content'], modifiable: true), Emoji(name: 'handshake', char: '\u{1F91D}', shortName:'handshake', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['agreement', 'hand', 'handshake', 'meeting', 'shake', 'uc9', 'diversity', 'body', 'hands', 'hi', 'business', 'proud', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'thumbs up', char: '\u{1F44D}', shortName:'thumbsup', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['+1', 'hand', 'thumb', 'up', 'uc6', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'luck', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'correct', 'fun', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade', '(y)']), Emoji(name: 'thumbs up: light skin tone', char: '\u{1F44D}\u{1F3FB}', shortName:'thumbsup_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['+1', 'hand', 'light skin tone', 'thumb', 'up', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'luck', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'correct', 'fun', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'thumbs up: medium-light skin tone', char: '\u{1F44D}\u{1F3FC}', shortName:'thumbsup_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['+1', 'hand', 'medium-light skin tone', 'thumb', 'up', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'luck', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'correct', 'fun', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'thumbs up: medium skin tone', char: '\u{1F44D}\u{1F3FD}', shortName:'thumbsup_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['+1', 'hand', 'medium skin tone', 'thumb', 'up', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'luck', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'correct', 'fun', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'thumbs up: medium-dark skin tone', char: '\u{1F44D}\u{1F3FE}', shortName:'thumbsup_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['+1', 'hand', 'medium-dark skin tone', 'thumb', 'up', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'luck', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'correct', 'fun', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'thumbs up: dark skin tone', char: '\u{1F44D}\u{1F3FF}', shortName:'thumbsup_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['+1', 'dark skin tone', 'hand', 'thumb', 'up', 'uc8', 'diversity', 'happy', 'body', 'hands', 'award', 'hi', 'luck', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'correct', 'fun', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'thumbs down', char: '\u{1F44E}', shortName:'thumbsdown', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['-1', 'down', 'hand', 'thumb', 'uc6', 'diversity', 'sad', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'body part', 'anatomy', 'hand', 'finger', 'fingers']), Emoji(name: 'thumbs down: light skin tone', char: '\u{1F44E}\u{1F3FB}', shortName:'thumbsdown_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['-1', 'down', 'hand', 'light skin tone', 'thumb', 'uc8', 'diversity', 'sad', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'thumbs down: medium-light skin tone', char: '\u{1F44E}\u{1F3FC}', shortName:'thumbsdown_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['-1', 'down', 'hand', 'medium-light skin tone', 'thumb', 'uc8', 'diversity', 'sad', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'thumbs down: medium skin tone', char: '\u{1F44E}\u{1F3FD}', shortName:'thumbsdown_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['-1', 'down', 'hand', 'medium skin tone', 'thumb', 'uc8', 'diversity', 'sad', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'thumbs down: medium-dark skin tone', char: '\u{1F44E}\u{1F3FE}', shortName:'thumbsdown_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['-1', 'down', 'hand', 'medium-dark skin tone', 'thumb', 'uc8', 'diversity', 'sad', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'thumbs down: dark skin tone', char: '\u{1F44E}\u{1F3FF}', shortName:'thumbsdown_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['-1', 'dark skin tone', 'down', 'hand', 'thumb', 'uc8', 'diversity', 'sad', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'oncoming fist', char: '\u{1F44A}', shortName:'punch', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'punch', 'uc6', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'awesome', 'friend', 'fight', 'hit', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam']), Emoji(name: 'oncoming fist: light skin tone', char: '\u{1F44A}\u{1F3FB}', shortName:'punch_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'light skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'awesome', 'friend', 'fight', 'hit', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'oncoming fist: medium-light skin tone', char: '\u{1F44A}\u{1F3FC}', shortName:'punch_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'awesome', 'friend', 'fight', 'hit', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'oncoming fist: medium skin tone', char: '\u{1F44A}\u{1F3FD}', shortName:'punch_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'medium skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'awesome', 'friend', 'fight', 'hit', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'oncoming fist: medium-dark skin tone', char: '\u{1F44A}\u{1F3FE}', shortName:'punch_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'awesome', 'friend', 'fight', 'hit', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'oncoming fist: dark skin tone', char: '\u{1F44A}\u{1F3FF}', shortName:'punch_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'dark skin tone', 'fist', 'hand', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'awesome', 'friend', 'fight', 'hit', 'proud', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'raised fist', char: '\u{270A}', shortName:'fist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'punch', 'uc6', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'condolence', 'proud', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'compassion', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK']), Emoji(name: 'raised fist: light skin tone', char: '\u{270A}\u{1F3FB}', shortName:'fist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'light skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'condolence', 'proud', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'compassion', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raised fist: medium-light skin tone', char: '\u{270A}\u{1F3FC}', shortName:'fist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'condolence', 'proud', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'compassion', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raised fist: medium skin tone', char: '\u{270A}\u{1F3FD}', shortName:'fist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'medium skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'condolence', 'proud', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'compassion', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raised fist: medium-dark skin tone', char: '\u{270A}\u{1F3FE}', shortName:'fist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'condolence', 'proud', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'compassion', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'raised fist: dark skin tone', char: '\u{270A}\u{1F3FF}', shortName:'fist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['clenched', 'dark skin tone', 'fist', 'hand', 'punch', 'uc8', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'condolence', 'proud', 'language', 'protest', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'compassion', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'left-facing fist', char: '\u{1F91B}', shortName:'left_facing_fist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'leftwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam']), Emoji(name: 'left-facing fist: light skin tone', char: '\u{1F91B}\u{1F3FB}', shortName:'left_facing_fist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'leftwards', 'light skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'left-facing fist: medium-light skin tone', char: '\u{1F91B}\u{1F3FC}', shortName:'left_facing_fist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'leftwards', 'medium-light skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'left-facing fist: medium skin tone', char: '\u{1F91B}\u{1F3FD}', shortName:'left_facing_fist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'leftwards', 'medium skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'left-facing fist: medium-dark skin tone', char: '\u{1F91B}\u{1F3FE}', shortName:'left_facing_fist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'leftwards', 'medium-dark skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'left-facing fist: dark skin tone', char: '\u{1F91B}\u{1F3FF}', shortName:'left_facing_fist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['dark skin tone', 'fist', 'leftwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'win', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'right-facing fist', char: '\u{1F91C}', shortName:'right_facing_fist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'rightwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam']), Emoji(name: 'right-facing fist: light skin tone', char: '\u{1F91C}\u{1F3FB}', shortName:'right_facing_fist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'light skin tone', 'rightwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'right-facing fist: medium-light skin tone', char: '\u{1F91C}\u{1F3FC}', shortName:'right_facing_fist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'medium-light skin tone', 'rightwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'right-facing fist: medium skin tone', char: '\u{1F91C}\u{1F3FD}', shortName:'right_facing_fist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'medium skin tone', 'rightwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'right-facing fist: medium-dark skin tone', char: '\u{1F91C}\u{1F3FE}', shortName:'right_facing_fist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['fist', 'medium-dark skin tone', 'rightwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'right-facing fist: dark skin tone', char: '\u{1F91C}\u{1F3FF}', shortName:'right_facing_fist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersClosed, keywords: ['dark skin tone', 'fist', 'rightwards', 'uc9', 'diversity', 'body', 'hands', 'hi', 'fist bump', 'friend', 'hit', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fist', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'punch', 'pow', 'bam'], modifiable: true), Emoji(name: 'crossed fingers', char: '\u{1F91E}', shortName:'fingers_crossed', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['cross', 'finger', 'hand', 'luck', 'uc9', 'diversity', 'body', 'hands', 'irish', 'hope', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'saint patricks day', 'st patricks day', 'leprechaun', 'swear', 'promise']), Emoji(name: 'crossed fingers: light skin tone', char: '\u{1F91E}\u{1F3FB}', shortName:'fingers_crossed_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['cross', 'finger', 'hand', 'light skin tone', 'luck', 'uc9', 'diversity', 'body', 'hands', 'irish', 'hope', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'saint patricks day', 'st patricks day', 'leprechaun', 'swear', 'promise'], modifiable: true), Emoji(name: 'crossed fingers: medium-light skin tone', char: '\u{1F91E}\u{1F3FC}', shortName:'fingers_crossed_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['cross', 'finger', 'hand', 'luck', 'medium-light skin tone', 'uc9', 'diversity', 'body', 'hands', 'irish', 'hope', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'saint patricks day', 'st patricks day', 'leprechaun', 'swear', 'promise'], modifiable: true), Emoji(name: 'crossed fingers: medium skin tone', char: '\u{1F91E}\u{1F3FD}', shortName:'fingers_crossed_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['cross', 'finger', 'hand', 'luck', 'medium skin tone', 'uc9', 'diversity', 'body', 'hands', 'irish', 'hope', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'saint patricks day', 'st patricks day', 'leprechaun', 'swear', 'promise'], modifiable: true), Emoji(name: 'crossed fingers: medium-dark skin tone', char: '\u{1F91E}\u{1F3FE}', shortName:'fingers_crossed_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['cross', 'finger', 'hand', 'luck', 'medium-dark skin tone', 'uc9', 'diversity', 'body', 'hands', 'irish', 'hope', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'saint patricks day', 'st patricks day', 'leprechaun', 'swear', 'promise'], modifiable: true), Emoji(name: 'crossed fingers: dark skin tone', char: '\u{1F91E}\u{1F3FF}', shortName:'fingers_crossed_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['cross', 'dark skin tone', 'finger', 'hand', 'luck', 'uc9', 'diversity', 'body', 'hands', 'irish', 'hope', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'saint patricks day', 'st patricks day', 'leprechaun', 'swear', 'promise'], modifiable: true), Emoji(name: 'victory hand', char: '\u{270C}\u{FE0F}', shortName:'v', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['hand', 'v', 'victory', 'uc1', 'diversity', 'peace', 'body', 'hands', 'hi', 'thank you', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable']), Emoji(name: 'victory hand: light skin tone', char: '\u{270C}\u{1F3FB}', shortName:'v_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['hand', 'light skin tone', 'v', 'victory', 'uc8', 'diversity', 'peace', 'body', 'hands', 'hi', 'thank you', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable'], modifiable: true), Emoji(name: 'victory hand: medium-light skin tone', char: '\u{270C}\u{1F3FC}', shortName:'v_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['hand', 'medium-light skin tone', 'v', 'victory', 'uc8', 'diversity', 'peace', 'body', 'hands', 'hi', 'thank you', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable'], modifiable: true), Emoji(name: 'victory hand: medium skin tone', char: '\u{270C}\u{1F3FD}', shortName:'v_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['hand', 'medium skin tone', 'v', 'victory', 'uc8', 'diversity', 'peace', 'body', 'hands', 'hi', 'thank you', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable'], modifiable: true), Emoji(name: 'victory hand: medium-dark skin tone', char: '\u{270C}\u{1F3FE}', shortName:'v_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['hand', 'medium-dark skin tone', 'v', 'victory', 'uc8', 'diversity', 'peace', 'body', 'hands', 'hi', 'thank you', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable'], modifiable: true), Emoji(name: 'victory hand: dark skin tone', char: '\u{270C}\u{1F3FF}', shortName:'v_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['dark skin tone', 'hand', 'v', 'victory', 'uc8', 'diversity', 'peace', 'body', 'hands', 'hi', 'thank you', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable'], modifiable: true), Emoji(name: 'love-you gesture', char: '\u{1F91F}', shortName:'love_you_gesture', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['ILY', 'hand', 'uc10', 'diversity', 'body', 'hands', 'love', 'beautiful', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely']), Emoji(name: 'love-you gesture: light skin tone', char: '\u{1F91F}\u{1F3FB}', shortName:'love_you_gesture_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['ILY', 'hand', 'light skin tone', 'uc10', 'diversity', 'body', 'hands', 'love', 'beautiful', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'love-you gesture: medium-light skin tone', char: '\u{1F91F}\u{1F3FC}', shortName:'love_you_gesture_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['ILY', 'hand', 'medium-light skin tone', 'uc10', 'diversity', 'body', 'hands', 'love', 'beautiful', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'love-you gesture: medium skin tone', char: '\u{1F91F}\u{1F3FD}', shortName:'love_you_gesture_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['ILY', 'hand', 'medium skin tone', 'uc10', 'diversity', 'body', 'hands', 'love', 'beautiful', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'love-you gesture: medium-dark skin tone', char: '\u{1F91F}\u{1F3FE}', shortName:'love_you_gesture_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['ILY', 'hand', 'medium-dark skin tone', 'uc10', 'diversity', 'body', 'hands', 'love', 'beautiful', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'love-you gesture: dark skin tone', char: '\u{1F91F}\u{1F3FF}', shortName:'love_you_gesture_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['ILY', 'dark skin tone', 'hand', 'uc10', 'diversity', 'body', 'hands', 'love', 'beautiful', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'sign of the horns', char: '\u{1F918}', shortName:'metal', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['finger', 'hand', 'horns', 'rock-on', 'uc8', 'diversity', 'body', 'hands', 'hi', 'rock and roll', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'sign of the horns: light skin tone', char: '\u{1F918}\u{1F3FB}', shortName:'metal_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['finger', 'hand', 'horns', 'light skin tone', 'rock-on', 'uc8', 'diversity', 'body', 'hands', 'hi', 'rock and roll', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'sign of the horns: medium-light skin tone', char: '\u{1F918}\u{1F3FC}', shortName:'metal_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['finger', 'hand', 'horns', 'medium-light skin tone', 'rock-on', 'uc8', 'diversity', 'body', 'hands', 'hi', 'rock and roll', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'sign of the horns: medium skin tone', char: '\u{1F918}\u{1F3FD}', shortName:'metal_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['finger', 'hand', 'horns', 'medium skin tone', 'rock-on', 'uc8', 'diversity', 'body', 'hands', 'hi', 'rock and roll', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'sign of the horns: medium-dark skin tone', char: '\u{1F918}\u{1F3FE}', shortName:'metal_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['finger', 'hand', 'horns', 'medium-dark skin tone', 'rock-on', 'uc8', 'diversity', 'body', 'hands', 'hi', 'rock and roll', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'sign of the horns: dark skin tone', char: '\u{1F918}\u{1F3FF}', shortName:'metal_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['dark skin tone', 'finger', 'hand', 'horns', 'rock-on', 'uc8', 'diversity', 'body', 'hands', 'hi', 'rock and roll', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'OK hand', char: '\u{1F44C}', shortName:'ok_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['OK', 'hand', 'uc6', 'diversity', 'happy', 'butt', 'body', 'hands', 'hi', 'sex', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'google', 'correct', 'fun', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'ass', 'booty', 'anal', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade']), Emoji(name: 'OK hand: light skin tone', char: '\u{1F44C}\u{1F3FB}', shortName:'ok_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['OK', 'hand', 'light skin tone', 'uc8', 'diversity', 'happy', 'butt', 'body', 'hands', 'hi', 'sex', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'google', 'correct', 'fun', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'ass', 'booty', 'anal', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'OK hand: medium-light skin tone', char: '\u{1F44C}\u{1F3FC}', shortName:'ok_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['OK', 'hand', 'medium-light skin tone', 'uc8', 'diversity', 'happy', 'butt', 'body', 'hands', 'hi', 'sex', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'google', 'correct', 'fun', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'ass', 'booty', 'anal', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'OK hand: medium skin tone', char: '\u{1F44C}\u{1F3FD}', shortName:'ok_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['OK', 'hand', 'medium skin tone', 'uc8', 'diversity', 'happy', 'butt', 'body', 'hands', 'hi', 'sex', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'google', 'correct', 'fun', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'ass', 'booty', 'anal', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'OK hand: medium-dark skin tone', char: '\u{1F44C}\u{1F3FE}', shortName:'ok_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['OK', 'hand', 'medium-dark skin tone', 'uc8', 'diversity', 'happy', 'butt', 'body', 'hands', 'hi', 'sex', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'google', 'correct', 'fun', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'ass', 'booty', 'anal', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'OK hand: dark skin tone', char: '\u{1F44C}\u{1F3FF}', shortName:'ok_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['OK', 'dark skin tone', 'hand', 'uc8', 'diversity', 'happy', 'butt', 'body', 'hands', 'hi', 'sex', 'thank you', 'perfect', 'awesome', 'good', 'beautiful', 'google', 'correct', 'fun', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'hooray', 'cheek', 'cheeky', 'excited', 'feliz', 'heureux', 'cheerful', 'delighted', 'ecstatic', 'elated', 'glad', 'joy', 'merry', 'ass', 'booty', 'anal', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'perfecto', 'perfection', 'superb', 'flawless', 'excellent', 'supreme', 'super', 'great', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'good job', 'nice', 'well done', 'bravo', 'congratulations', 'congrats', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'passing grade'], modifiable: true), Emoji(name: 'pinching hand', char: '\u{1F90F}', shortName:'pinching_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc12', 'diversity', 'penis', 'body', 'hands', 'half', 'quiet', 'tiny', 'greed', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'dick', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'petite bite', 'small dick', 'small', 'selfish']), Emoji(name: 'pinching hand: light skin tone', char: '\u{1F90F}\u{1F3FB}', shortName:'pinching_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc12', 'diversity', 'penis', 'body', 'hands', 'half', 'quiet', 'tiny', 'greed', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'dick', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'petite bite', 'small dick', 'small', 'selfish'], modifiable: true), Emoji(name: 'pinching hand: medium-light skin tone', char: '\u{1F90F}\u{1F3FC}', shortName:'pinching_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc12', 'diversity', 'penis', 'body', 'hands', 'half', 'quiet', 'tiny', 'greed', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'dick', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'petite bite', 'small dick', 'small', 'selfish'], modifiable: true), Emoji(name: 'pinching hand: medium skin tone', char: '\u{1F90F}\u{1F3FD}', shortName:'pinching_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc12', 'diversity', 'penis', 'body', 'hands', 'half', 'quiet', 'tiny', 'greed', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'dick', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'petite bite', 'small dick', 'small', 'selfish'], modifiable: true), Emoji(name: 'pinching hand: medium-dark skin tone', char: '\u{1F90F}\u{1F3FE}', shortName:'pinching_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc12', 'diversity', 'penis', 'body', 'hands', 'half', 'quiet', 'tiny', 'greed', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'dick', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'petite bite', 'small dick', 'small', 'selfish'], modifiable: true), Emoji(name: 'pinching hand: dark skin tone', char: '\u{1F90F}\u{1F3FF}', shortName:'pinching_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc12', 'diversity', 'penis', 'body', 'hands', 'half', 'quiet', 'tiny', 'greed', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'dick', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'petite bite', 'small dick', 'small', 'selfish'], modifiable: true), Emoji(name: 'pinched fingers', char: '\u{1F90C}', shortName:'pinched_fingers', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc13', 'diversity', 'italian', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'italy', 'italie', 'body part', 'anatomy', 'hand', 'finger', 'fingers']), Emoji(name: 'pinched fingers: medium-light skin tone', char: '\u{1F90C}\u{1F3FC}', shortName:'pinched_fingers_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc13', 'diversity', 'italian', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'italy', 'italie', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'pinched fingers: light skin tone', char: '\u{1F90C}\u{1F3FB}', shortName:'pinched_fingers_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc13', 'diversity', 'italian', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'italy', 'italie', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'pinched fingers: medium skin tone', char: '\u{1F90C}\u{1F3FD}', shortName:'pinched_fingers_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc13', 'diversity', 'italian', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'italy', 'italie', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'pinched fingers: medium-dark skin tone', char: '\u{1F90C}\u{1F3FE}', shortName:'pinched_fingers_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc13', 'diversity', 'italian', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'italy', 'italie', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'pinched fingers: dark skin tone', char: '\u{1F90C}\u{1F3FF}', shortName:'pinched_fingers_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['uc13', 'diversity', 'italian', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'italy', 'italie', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing left', char: '\u{1F448}', shortName:'point_left', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'point', 'uc6', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'backhand index pointing left: light skin tone', char: '\u{1F448}\u{1F3FB}', shortName:'point_left_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'backhand index pointing left: medium-light skin tone', char: '\u{1F448}\u{1F3FC}', shortName:'point_left_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'backhand index pointing left: medium skin tone', char: '\u{1F448}\u{1F3FD}', shortName:'point_left_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'backhand index pointing left: medium-dark skin tone', char: '\u{1F448}\u{1F3FE}', shortName:'point_left_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'backhand index pointing left: dark skin tone', char: '\u{1F448}\u{1F3FF}', shortName:'point_left_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'backhand index pointing right', char: '\u{1F449}', shortName:'point_right', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'point', 'uc6', 'diversity', 'body', 'hands', 'hi', 'sex', 'download', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping']), Emoji(name: 'backhand index pointing right: light skin tone', char: '\u{1F449}\u{1F3FB}', shortName:'point_right_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'sex', 'download', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'backhand index pointing right: medium-light skin tone', char: '\u{1F449}\u{1F3FC}', shortName:'point_right_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'sex', 'download', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'backhand index pointing right: medium skin tone', char: '\u{1F449}\u{1F3FD}', shortName:'point_right_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'sex', 'download', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'backhand index pointing right: medium-dark skin tone', char: '\u{1F449}\u{1F3FE}', shortName:'point_right_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'sex', 'download', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'backhand index pointing right: dark skin tone', char: '\u{1F449}\u{1F3FF}', shortName:'point_right_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'uc8', 'diversity', 'body', 'hands', 'hi', 'sex', 'download', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'backhand index pointing up', char: '\u{1F446}', shortName:'point_up_2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'point', 'up', 'uc6', 'diversity', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers']), Emoji(name: 'backhand index pointing up: light skin tone', char: '\u{1F446}\u{1F3FB}', shortName:'point_up_2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing up: medium-light skin tone', char: '\u{1F446}\u{1F3FC}', shortName:'point_up_2_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing up: medium skin tone', char: '\u{1F446}\u{1F3FD}', shortName:'point_up_2_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing up: medium-dark skin tone', char: '\u{1F446}\u{1F3FE}', shortName:'point_up_2_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing up: dark skin tone', char: '\u{1F446}\u{1F3FF}', shortName:'point_up_2_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing down', char: '\u{1F447}', shortName:'point_down', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'down', 'finger', 'hand', 'index', 'point', 'uc6', 'diversity', 'body', 'hands', 'click', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers']), Emoji(name: 'backhand index pointing down: light skin tone', char: '\u{1F447}\u{1F3FB}', shortName:'point_down_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'down', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'click', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing down: medium-light skin tone', char: '\u{1F447}\u{1F3FC}', shortName:'point_down_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'down', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'click', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing down: medium skin tone', char: '\u{1F447}\u{1F3FD}', shortName:'point_down_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'down', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'click', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing down: medium-dark skin tone', char: '\u{1F447}\u{1F3FE}', shortName:'point_down_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'down', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8', 'diversity', 'body', 'hands', 'click', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'backhand index pointing down: dark skin tone', char: '\u{1F447}\u{1F3FF}', shortName:'point_down_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['backhand', 'dark skin tone', 'down', 'finger', 'hand', 'index', 'point', 'uc8', 'diversity', 'body', 'hands', 'click', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers'], modifiable: true), Emoji(name: 'index pointing up', char: '\u{261D}\u{FE0F}', shortName:'point_up', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'index', 'point', 'up', 'uc1', 'diversity', 'body', 'hands', 'emojione', 'important', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'emoji one']), Emoji(name: 'index pointing up: light skin tone', char: '\u{261D}\u{1F3FB}', shortName:'point_up_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'index', 'light skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'emojione', 'important', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'emoji one'], modifiable: true), Emoji(name: 'index pointing up: medium-light skin tone', char: '\u{261D}\u{1F3FC}', shortName:'point_up_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'emojione', 'important', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'emoji one'], modifiable: true), Emoji(name: 'index pointing up: medium skin tone', char: '\u{261D}\u{1F3FD}', shortName:'point_up_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'index', 'medium skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'emojione', 'important', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'emoji one'], modifiable: true), Emoji(name: 'index pointing up: medium-dark skin tone', char: '\u{261D}\u{1F3FE}', shortName:'point_up_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'emojione', 'important', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'emoji one'], modifiable: true), Emoji(name: 'index pointing up: dark skin tone', char: '\u{261D}\u{1F3FF}', shortName:'point_up_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['dark skin tone', 'finger', 'hand', 'index', 'point', 'up', 'uc8', 'diversity', 'body', 'hands', 'emojione', 'important', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'emoji one'], modifiable: true), Emoji(name: 'raised hand', char: '\u{270B}', shortName:'raised_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'uc6', 'diversity', 'body', 'hands', 'hi', 'high five', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'raised hand: light skin tone', char: '\u{270B}\u{1F3FB}', shortName:'raised_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'light skin tone', 'uc8', 'diversity', 'body', 'hands', 'hi', 'high five', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'raised hand: medium-light skin tone', char: '\u{270B}\u{1F3FC}', shortName:'raised_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'medium-light skin tone', 'uc8', 'diversity', 'body', 'hands', 'hi', 'high five', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'raised hand: medium skin tone', char: '\u{270B}\u{1F3FD}', shortName:'raised_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'medium skin tone', 'uc8', 'diversity', 'body', 'hands', 'hi', 'high five', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'raised hand: medium-dark skin tone', char: '\u{270B}\u{1F3FE}', shortName:'raised_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'medium-dark skin tone', 'uc8', 'diversity', 'body', 'hands', 'hi', 'high five', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'raised hand: dark skin tone', char: '\u{270B}\u{1F3FF}', shortName:'raised_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['dark skin tone', 'hand', 'uc8', 'diversity', 'body', 'hands', 'hi', 'high five', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'raised back of hand', char: '\u{1F91A}', shortName:'raised_back_of_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['backhand', 'raised', 'uc9', 'diversity', 'body', 'hands', 'award', 'hi', 'detest', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'прив', 'privé', 'privado', 'reserved']), Emoji(name: 'raised back of hand: light skin tone', char: '\u{1F91A}\u{1F3FB}', shortName:'raised_back_of_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['backhand', 'light skin tone', 'raised', 'uc9', 'diversity', 'body', 'hands', 'award', 'hi', 'detest', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'raised back of hand: medium-light skin tone', char: '\u{1F91A}\u{1F3FC}', shortName:'raised_back_of_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['backhand', 'medium-light skin tone', 'raised', 'uc9', 'diversity', 'body', 'hands', 'award', 'hi', 'detest', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'raised back of hand: medium skin tone', char: '\u{1F91A}\u{1F3FD}', shortName:'raised_back_of_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['backhand', 'medium skin tone', 'raised', 'uc9', 'diversity', 'body', 'hands', 'award', 'hi', 'detest', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'raised back of hand: medium-dark skin tone', char: '\u{1F91A}\u{1F3FE}', shortName:'raised_back_of_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['backhand', 'medium-dark skin tone', 'raised', 'uc9', 'diversity', 'body', 'hands', 'award', 'hi', 'detest', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'raised back of hand: dark skin tone', char: '\u{1F91A}\u{1F3FF}', shortName:'raised_back_of_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['backhand', 'dark skin tone', 'raised', 'uc9', 'diversity', 'body', 'hands', 'award', 'hi', 'detest', 'private', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'awards', 'prize', 'prizes', 'trophy', 'trophies', 'spot', 'best', 'champion', 'hero', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'hand with fingers splayed', char: '\u{1F590}', shortName:'hand_splayed', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'splayed', 'uc7', 'diversity', 'body', 'hands', 'hi', 'gay pride', 'high five', 'proud', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'hand with fingers splayed: light skin tone', char: '\u{1F590}\u{1F3FB}', shortName:'hand_splayed_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'light skin tone', 'splayed', 'uc8', 'diversity', 'body', 'hands', 'hi', 'gay pride', 'high five', 'proud', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'hand with fingers splayed: medium-light skin tone', char: '\u{1F590}\u{1F3FC}', shortName:'hand_splayed_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'medium-light skin tone', 'splayed', 'uc8', 'diversity', 'body', 'hands', 'hi', 'gay pride', 'high five', 'proud', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'hand with fingers splayed: medium skin tone', char: '\u{1F590}\u{1F3FD}', shortName:'hand_splayed_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'medium skin tone', 'splayed', 'uc8', 'diversity', 'body', 'hands', 'hi', 'gay pride', 'high five', 'proud', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'hand with fingers splayed: medium-dark skin tone', char: '\u{1F590}\u{1F3FE}', shortName:'hand_splayed_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'medium-dark skin tone', 'splayed', 'uc8', 'diversity', 'body', 'hands', 'hi', 'gay pride', 'high five', 'proud', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'hand with fingers splayed: dark skin tone', char: '\u{1F590}\u{1F3FF}', shortName:'hand_splayed_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['dark skin tone', 'finger', 'hand', 'splayed', 'uc8', 'diversity', 'body', 'hands', 'hi', 'gay pride', 'high five', 'proud', 'language', 'slap', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'vulcan salute', char: '\u{1F596}', shortName:'vulcan', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'spock', 'vulcan', 'uc7', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'vulcan salute: light skin tone', char: '\u{1F596}\u{1F3FB}', shortName:'vulcan_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'light skin tone', 'spock', 'vulcan', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'vulcan salute: medium-light skin tone', char: '\u{1F596}\u{1F3FC}', shortName:'vulcan_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'medium-light skin tone', 'spock', 'vulcan', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'vulcan salute: medium skin tone', char: '\u{1F596}\u{1F3FD}', shortName:'vulcan_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'medium skin tone', 'spock', 'vulcan', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'vulcan salute: medium-dark skin tone', char: '\u{1F596}\u{1F3FE}', shortName:'vulcan_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['finger', 'hand', 'medium-dark skin tone', 'spock', 'vulcan', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'vulcan salute: dark skin tone', char: '\u{1F596}\u{1F3FF}', shortName:'vulcan_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['dark skin tone', 'finger', 'hand', 'spock', 'vulcan', 'uc8', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'waving hand', char: '\u{1F44B}', shortName:'wave', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'wave', 'waving', 'uc6', 'diversity', 'body', 'hands', 'hi', 'hola', 'friend', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo']), Emoji(name: 'waving hand: light skin tone', char: '\u{1F44B}\u{1F3FB}', shortName:'wave_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'light skin tone', 'wave', 'waving', 'uc8', 'diversity', 'body', 'hands', 'hi', 'hola', 'friend', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo'], modifiable: true), Emoji(name: 'waving hand: medium-light skin tone', char: '\u{1F44B}\u{1F3FC}', shortName:'wave_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'medium-light skin tone', 'wave', 'waving', 'uc8', 'diversity', 'body', 'hands', 'hi', 'hola', 'friend', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo'], modifiable: true), Emoji(name: 'waving hand: medium skin tone', char: '\u{1F44B}\u{1F3FD}', shortName:'wave_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'medium skin tone', 'wave', 'waving', 'uc8', 'diversity', 'body', 'hands', 'hi', 'hola', 'friend', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo'], modifiable: true), Emoji(name: 'waving hand: medium-dark skin tone', char: '\u{1F44B}\u{1F3FE}', shortName:'wave_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['hand', 'medium-dark skin tone', 'wave', 'waving', 'uc8', 'diversity', 'body', 'hands', 'hi', 'hola', 'friend', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo'], modifiable: true), Emoji(name: 'waving hand: dark skin tone', char: '\u{1F44B}\u{1F3FF}', shortName:'wave_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersOpen, keywords: ['dark skin tone', 'hand', 'wave', 'waving', 'uc8', 'diversity', 'body', 'hands', 'hi', 'hola', 'friend', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo'], modifiable: true), Emoji(name: 'call me hand', char: '\u{1F919}', shortName:'call_me', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['call', 'hand', 'uc9', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle']), Emoji(name: 'call me hand: light skin tone', char: '\u{1F919}\u{1F3FB}', shortName:'call_me_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['call', 'hand', 'light skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'call me hand: medium-light skin tone', char: '\u{1F919}\u{1F3FC}', shortName:'call_me_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['call', 'hand', 'medium-light skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'call me hand: medium skin tone', char: '\u{1F919}\u{1F3FD}', shortName:'call_me_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['call', 'hand', 'medium skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'call me hand: medium-dark skin tone', char: '\u{1F919}\u{1F3FE}', shortName:'call_me_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['call', 'hand', 'medium-dark skin tone', 'uc9', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'call me hand: dark skin tone', char: '\u{1F919}\u{1F3FF}', shortName:'call_me_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handFingersPartial, keywords: ['call', 'dark skin tone', 'hand', 'uc9', 'diversity', 'body', 'hands', 'hi', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle'], modifiable: true), Emoji(name: 'flexed biceps', char: '\u{1F4AA}', shortName:'muscle', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['biceps', 'comic', 'flex', 'muscle', 'uc6', 'sport', 'diversity', 'body', 'hands', 'flex', 'weight lifting', 'win', 'feminist', 'power', 'handsome', 'festivus', 'protest', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'strong', 'weight lifter', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'feminism', 'stud', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK']), Emoji(name: 'flexed biceps: light skin tone', char: '\u{1F4AA}\u{1F3FB}', shortName:'muscle_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['biceps', 'comic', 'flex', 'light skin tone', 'muscle', 'uc8', 'sport', 'diversity', 'body', 'hands', 'flex', 'weight lifting', 'win', 'feminist', 'power', 'handsome', 'festivus', 'protest', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'strong', 'weight lifter', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'feminism', 'stud', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'flexed biceps: medium-light skin tone', char: '\u{1F4AA}\u{1F3FC}', shortName:'muscle_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['biceps', 'comic', 'flex', 'medium-light skin tone', 'muscle', 'uc8', 'sport', 'diversity', 'body', 'hands', 'flex', 'weight lifting', 'win', 'feminist', 'power', 'handsome', 'festivus', 'protest', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'strong', 'weight lifter', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'feminism', 'stud', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'flexed biceps: medium skin tone', char: '\u{1F4AA}\u{1F3FD}', shortName:'muscle_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['biceps', 'comic', 'flex', 'medium skin tone', 'muscle', 'uc8', 'sport', 'diversity', 'body', 'hands', 'flex', 'weight lifting', 'win', 'feminist', 'power', 'handsome', 'festivus', 'protest', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'strong', 'weight lifter', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'feminism', 'stud', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'flexed biceps: medium-dark skin tone', char: '\u{1F4AA}\u{1F3FE}', shortName:'muscle_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['biceps', 'comic', 'flex', 'medium-dark skin tone', 'muscle', 'uc8', 'sport', 'diversity', 'body', 'hands', 'flex', 'weight lifting', 'win', 'feminist', 'power', 'handsome', 'festivus', 'protest', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'strong', 'weight lifter', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'feminism', 'stud', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'flexed biceps: dark skin tone', char: '\u{1F4AA}\u{1F3FF}', shortName:'muscle_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['biceps', 'comic', 'dark skin tone', 'flex', 'muscle', 'uc8', 'sport', 'diversity', 'body', 'hands', 'flex', 'weight lifting', 'win', 'feminist', 'power', 'handsome', 'festivus', 'protest', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'strong', 'weight lifter', 'winning', 'killing it', 'crushing it', 'victory', 'victorious', 'success', 'successful', 'winner', 'feminism', 'stud', 'blm', 'demonstration', 'rally', 'strike', 'picket', 'boycott', 'riot', 'martin luther king', 'MLK'], modifiable: true), Emoji(name: 'mechanical arm', char: '\u{1F9BE}', shortName:'mechanical_arm', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'body', 'science', 'handicap', 'prosthetic', 'fake arm', 'accessibility', 'body part', 'anatomy', 'lab', 'disabled', 'disability', 'prosthetics', 'robotic arm']), Emoji(name: 'middle finger', char: '\u{1F595}', shortName:'middle_finger', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'uc7', 'diversity', 'body', 'hands', 'angry', 'middle finger', 'sex', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'flipping off', 'fu', 'the finger', 'fuck you', 'fuck off', 'fuck', 'fucking', 'horny', 'humping']), Emoji(name: 'middle finger: light skin tone', char: '\u{1F595}\u{1F3FB}', shortName:'middle_finger_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'light skin tone', 'uc8', 'diversity', 'body', 'hands', 'angry', 'middle finger', 'sex', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'flipping off', 'fu', 'the finger', 'fuck you', 'fuck off', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'middle finger: medium-light skin tone', char: '\u{1F595}\u{1F3FC}', shortName:'middle_finger_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'medium-light skin tone', 'uc8', 'diversity', 'body', 'hands', 'angry', 'middle finger', 'sex', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'flipping off', 'fu', 'the finger', 'fuck you', 'fuck off', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'middle finger: medium skin tone', char: '\u{1F595}\u{1F3FD}', shortName:'middle_finger_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'medium skin tone', 'uc8', 'diversity', 'body', 'hands', 'angry', 'middle finger', 'sex', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'flipping off', 'fu', 'the finger', 'fuck you', 'fuck off', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'middle finger: medium-dark skin tone', char: '\u{1F595}\u{1F3FE}', shortName:'middle_finger_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['finger', 'hand', 'medium-dark skin tone', 'uc8', 'diversity', 'body', 'hands', 'angry', 'middle finger', 'sex', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'flipping off', 'fu', 'the finger', 'fuck you', 'fuck off', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'middle finger: dark skin tone', char: '\u{1F595}\u{1F3FF}', shortName:'middle_finger_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handSingleFinger, keywords: ['dark skin tone', 'finger', 'hand', 'uc8', 'diversity', 'body', 'hands', 'angry', 'middle finger', 'sex', 'language', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'flipping off', 'fu', 'the finger', 'fuck you', 'fuck off', 'fuck', 'fucking', 'horny', 'humping'], modifiable: true), Emoji(name: 'writing hand', char: '\u{270D}\u{FE0F}', shortName:'writing_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['hand', 'write', 'uc1', 'diversity', 'body', 'hands', 'write', 'color', 'correct', 'poet', 'grades', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'writing', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter', 'passing grade']), Emoji(name: 'writing hand: light skin tone', char: '\u{270D}\u{1F3FB}', shortName:'writing_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['hand', 'light skin tone', 'write', 'uc8', 'diversity', 'body', 'hands', 'write', 'color', 'correct', 'poet', 'grades', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'writing', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter', 'passing grade'], modifiable: true), Emoji(name: 'writing hand: medium-light skin tone', char: '\u{270D}\u{1F3FC}', shortName:'writing_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['hand', 'medium-light skin tone', 'write', 'uc8', 'diversity', 'body', 'hands', 'write', 'color', 'correct', 'poet', 'grades', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'writing', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter', 'passing grade'], modifiable: true), Emoji(name: 'writing hand: medium skin tone', char: '\u{270D}\u{1F3FD}', shortName:'writing_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['hand', 'medium skin tone', 'write', 'uc8', 'diversity', 'body', 'hands', 'write', 'color', 'correct', 'poet', 'grades', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'writing', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter', 'passing grade'], modifiable: true), Emoji(name: 'writing hand: medium-dark skin tone', char: '\u{270D}\u{1F3FE}', shortName:'writing_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['hand', 'medium-dark skin tone', 'write', 'uc8', 'diversity', 'body', 'hands', 'write', 'color', 'correct', 'poet', 'grades', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'writing', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter', 'passing grade'], modifiable: true), Emoji(name: 'writing hand: dark skin tone', char: '\u{270D}\u{1F3FF}', shortName:'writing_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['dark skin tone', 'hand', 'write', 'uc8', 'diversity', 'body', 'hands', 'write', 'color', 'correct', 'poet', 'grades', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'writing', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter', 'passing grade'], modifiable: true), Emoji(name: 'folded hands', char: '\u{1F64F}', shortName:'pray', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['ask', 'bow', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks', 'uc6', 'diversity', 'body', 'hands', 'hi', 'luck', 'thank you', 'pray', 'scientology', 'jesus', 'pleased', 'yoga', 'easter', 'begging', 'help', 'hope', 'soul', 'language', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'scientologist', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'swear', 'promise']), Emoji(name: 'folded hands: light skin tone', char: '\u{1F64F}\u{1F3FB}', shortName:'pray_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['ask', 'bow', 'folded', 'gesture', 'hand', 'light skin tone', 'please', 'pray', 'thanks', 'uc8', 'diversity', 'body', 'hands', 'hi', 'luck', 'thank you', 'pray', 'scientology', 'jesus', 'pleased', 'yoga', 'easter', 'begging', 'help', 'hope', 'soul', 'language', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'scientologist', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'swear', 'promise'], modifiable: true), Emoji(name: 'folded hands: medium-light skin tone', char: '\u{1F64F}\u{1F3FC}', shortName:'pray_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-light skin tone', 'please', 'pray', 'thanks', 'uc8', 'diversity', 'body', 'hands', 'hi', 'luck', 'thank you', 'pray', 'scientology', 'jesus', 'pleased', 'yoga', 'easter', 'begging', 'help', 'hope', 'soul', 'language', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'scientologist', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'swear', 'promise'], modifiable: true), Emoji(name: 'folded hands: medium skin tone', char: '\u{1F64F}\u{1F3FD}', shortName:'pray_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium skin tone', 'please', 'pray', 'thanks', 'uc8', 'diversity', 'body', 'hands', 'hi', 'luck', 'thank you', 'pray', 'scientology', 'jesus', 'pleased', 'yoga', 'easter', 'begging', 'help', 'hope', 'soul', 'language', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'scientologist', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'swear', 'promise'], modifiable: true), Emoji(name: 'folded hands: medium-dark skin tone', char: '\u{1F64F}\u{1F3FE}', shortName:'pray_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-dark skin tone', 'please', 'pray', 'thanks', 'uc8', 'diversity', 'body', 'hands', 'hi', 'luck', 'thank you', 'pray', 'scientology', 'jesus', 'pleased', 'yoga', 'easter', 'begging', 'help', 'hope', 'soul', 'language', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'scientologist', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'swear', 'promise'], modifiable: true), Emoji(name: 'folded hands: dark skin tone', char: '\u{1F64F}\u{1F3FF}', shortName:'pray_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.hands, keywords: ['ask', 'bow', 'dark skin tone', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks', 'uc8', 'diversity', 'body', 'hands', 'hi', 'luck', 'thank you', 'pray', 'scientology', 'jesus', 'pleased', 'yoga', 'easter', 'begging', 'help', 'hope', 'soul', 'language', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'good luck', 'lucky', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'scientologist', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'swear', 'promise'], modifiable: true), Emoji(name: 'foot', char: '\u{1F9B6}', shortName:'foot', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle']), Emoji(name: 'foot: light skin tone', char: '\u{1F9B6}\u{1F3FB}', shortName:'foot_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle'], modifiable: true), Emoji(name: 'foot: medium-light skin tone', char: '\u{1F9B6}\u{1F3FC}', shortName:'foot_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle'], modifiable: true), Emoji(name: 'foot: medium skin tone', char: '\u{1F9B6}\u{1F3FD}', shortName:'foot_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle'], modifiable: true), Emoji(name: 'foot: medium-dark skin tone', char: '\u{1F9B6}\u{1F3FE}', shortName:'foot_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle'], modifiable: true), Emoji(name: 'foot: dark skin tone', char: '\u{1F9B6}\u{1F3FF}', shortName:'foot_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle'], modifiable: true), Emoji(name: 'leg', char: '\u{1F9B5}', shortName:'leg', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'knee', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle', 'thigh', 'calf']), Emoji(name: 'leg: light skin tone', char: '\u{1F9B5}\u{1F3FB}', shortName:'leg_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'knee', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle', 'thigh', 'calf'], modifiable: true), Emoji(name: 'leg: medium-light skin tone', char: '\u{1F9B5}\u{1F3FC}', shortName:'leg_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'knee', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle', 'thigh', 'calf'], modifiable: true), Emoji(name: 'leg: medium skin tone', char: '\u{1F9B5}\u{1F3FD}', shortName:'leg_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'knee', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle', 'thigh', 'calf'], modifiable: true), Emoji(name: 'leg: medium-dark skin tone', char: '\u{1F9B5}\u{1F3FE}', shortName:'leg_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'knee', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle', 'thigh', 'calf'], modifiable: true), Emoji(name: 'leg: dark skin tone', char: '\u{1F9B5}\u{1F3FF}', shortName:'leg_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'diversity', 'body', 'feet', 'knee', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'toes', 'heel', 'ankle', 'thigh', 'calf'], modifiable: true), Emoji(name: 'mechanical leg', char: '\u{1F9BF}', shortName:'mechanical_leg', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'diversity', 'body', 'science', 'handicap', 'feet', 'knee', 'prosthetic', 'fake leg', 'accessibility', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'lab', 'disabled', 'disability', 'toes', 'heel', 'ankle', 'thigh', 'calf', 'prosthetics', 'robotic leg', 'aesculapius']), Emoji(name: 'lipstick', char: '\u{1F484}', shortName:'lipstick', emojiGroup: EmojiGroup.objects, emojiSubgroup: EmojiSubgroup.clothing, keywords: ['cosmetics', 'makeup', 'uc6', 'fashion', 'women', 'love', 'sexy', 'lipstick', 'beautiful', 'color', 'mirror', 'clothes', 'clothing', 'style', 'woman', 'female', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'colour', 'coloring', 'colouring', 'drawing', 'marker', 'sketch', 'highlighter']), Emoji(name: 'kiss mark', char: '\u{1F48B}', shortName:'kiss', emojiGroup: EmojiGroup.smileysEmotion, emojiSubgroup: EmojiSubgroup.emotion, keywords: ['kiss', 'lips', 'uc6', 'women', 'love', 'sexy', 'lipstick', 'beautiful', 'pink', 'kisses', 'mirror', 'woman', 'female', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'rose', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy']), Emoji(name: 'mouth', char: '\u{1F444}', shortName:'lips', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['lips', 'uc6', 'women', 'body', 'sexy', 'lipstick', 'beautiful', 'woman', 'female', 'body part', 'anatomy', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely']), Emoji(name: 'tooth', char: '\u{1F9B7}', shortName:'tooth', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'body', 'teeth', 'bite', 'bones', 'medical', 'body part', 'anatomy', 'dentist', 'Os', 'hueso', 'aesculapius']), Emoji(name: 'tongue', char: '\u{1F445}', shortName:'tongue', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'uc6', 'body', 'sexy', 'sex', 'lipstick', 'pink', 'lick', 'tongue', 'medical', 'body part', 'anatomy', 'fuck', 'fucking', 'horny', 'humping', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'rose', 'toung', 'tounge', 'aesculapius']), Emoji(name: 'ear', char: '\u{1F442}', shortName:'ear', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'uc6', 'diversity', 'body', 'sound', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear']), Emoji(name: 'ear: light skin tone', char: '\u{1F442}\u{1F3FB}', shortName:'ear_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'light skin tone', 'uc8', 'diversity', 'body', 'sound', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear'], modifiable: true), Emoji(name: 'ear: medium-light skin tone', char: '\u{1F442}\u{1F3FC}', shortName:'ear_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'medium-light skin tone', 'uc8', 'diversity', 'body', 'sound', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear'], modifiable: true), Emoji(name: 'kiss: person, person, dark skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F48B}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'kiss_person_person_tone5_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'hug', 'lgbt', 'pink', 'kisses', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'embrace', 'hugs', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'bisous', 'beijos', 'besos', 'bise', 'blowing kisses', 'kissy', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'ear: medium skin tone', char: '\u{1F442}\u{1F3FD}', shortName:'ear_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'medium skin tone', 'uc8', 'diversity', 'body', 'sound', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear'], modifiable: true), Emoji(name: 'ear: medium-dark skin tone', char: '\u{1F442}\u{1F3FE}', shortName:'ear_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'medium-dark skin tone', 'uc8', 'diversity', 'body', 'sound', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear'], modifiable: true), Emoji(name: 'ear: dark skin tone', char: '\u{1F442}\u{1F3FF}', shortName:'ear_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'dark skin tone', 'uc8', 'diversity', 'body', 'sound', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear'], modifiable: true), Emoji(name: 'ear with hearing aid', char: '\u{1F9BB}', shortName:'ear_with_hearing_aid', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'old people', 'diversity', 'earphone', 'sound', 'deaf', 'accessibility', 'medical', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'earbud', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing', 'aesculapius']), Emoji(name: 'ear with hearing aid: light skin tone', char: '\u{1F9BB}\u{1F3FB}', shortName:'ear_with_hearing_aid_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'old people', 'diversity', 'earphone', 'sound', 'deaf', 'accessibility', 'medical', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'earbud', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing', 'aesculapius'], modifiable: true), Emoji(name: 'ear with hearing aid: medium-light skin tone', char: '\u{1F9BB}\u{1F3FC}', shortName:'ear_with_hearing_aid_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'old people', 'diversity', 'earphone', 'sound', 'deaf', 'accessibility', 'medical', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'earbud', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing', 'aesculapius'], modifiable: true), Emoji(name: 'ear with hearing aid: medium skin tone', char: '\u{1F9BB}\u{1F3FD}', shortName:'ear_with_hearing_aid_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'old people', 'diversity', 'earphone', 'sound', 'deaf', 'accessibility', 'medical', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'earbud', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing', 'aesculapius'], modifiable: true), Emoji(name: 'ear with hearing aid: medium-dark skin tone', char: '\u{1F9BB}\u{1F3FE}', shortName:'ear_with_hearing_aid_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'old people', 'diversity', 'earphone', 'sound', 'deaf', 'accessibility', 'medical', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'earbud', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing', 'aesculapius'], modifiable: true), Emoji(name: 'ear with hearing aid: dark skin tone', char: '\u{1F9BB}\u{1F3FF}', shortName:'ear_with_hearing_aid_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc12', 'old people', 'diversity', 'earphone', 'sound', 'deaf', 'accessibility', 'medical', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'earbud', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing', 'aesculapius'], modifiable: true), Emoji(name: 'nose', char: '\u{1F443}', shortName:'nose', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'uc6', 'diversity', 'body', 'stinky', 'booger', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'smell', 'stink', 'odor']), Emoji(name: 'nose: light skin tone', char: '\u{1F443}\u{1F3FB}', shortName:'nose_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'light skin tone', 'uc8', 'diversity', 'body', 'stinky', 'booger', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'smell', 'stink', 'odor'], modifiable: true), Emoji(name: 'nose: medium-light skin tone', char: '\u{1F443}\u{1F3FC}', shortName:'nose_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'medium-light skin tone', 'uc8', 'diversity', 'body', 'stinky', 'booger', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'smell', 'stink', 'odor'], modifiable: true), Emoji(name: 'nose: medium skin tone', char: '\u{1F443}\u{1F3FD}', shortName:'nose_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'medium skin tone', 'uc8', 'diversity', 'body', 'stinky', 'booger', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'smell', 'stink', 'odor'], modifiable: true), Emoji(name: 'nose: medium-dark skin tone', char: '\u{1F443}\u{1F3FE}', shortName:'nose_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'medium-dark skin tone', 'uc8', 'diversity', 'body', 'stinky', 'booger', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'smell', 'stink', 'odor'], modifiable: true), Emoji(name: 'nose: dark skin tone', char: '\u{1F443}\u{1F3FF}', shortName:'nose_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'dark skin tone', 'uc8', 'diversity', 'body', 'stinky', 'booger', 'diverse', 'modifier', 'modifiers', 'equality', 'body part', 'anatomy', 'smell', 'stink', 'odor'], modifiable: true), Emoji(name: 'footprints', char: '\u{1F463}', shortName:'footprints', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personSymbol, keywords: ['clothing', 'footprint', 'print', 'uc6', 'baby', 'paws', 'feet', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'toes', 'heel', 'ankle']), Emoji(name: 'eye', char: '\u{1F441}\u{FE0F}', shortName:'eye', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['body', 'uc7', 'body', 'eyes', 'search', 'medical', 'body part', 'anatomy', 'eye', 'eyebrow', 'look', 'find', 'looking', 'see', 'aesculapius']), Emoji(name: 'eyes', char: '\u{1F440}', shortName:'eyes', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['eye', 'face', 'uc6', 'halloween', 'body', 'rolling eyes', 'eyes', 'google', 'brain', 'disney', 'search', 'eyeroll', 'samhain', 'trick or treat', 'body part', 'anatomy', 'eye roll', 'side eye', 'eye', 'eyebrow', 'mind', 'memory', 'thought', 'conscience', 'cartoon', 'look', 'find', 'looking', 'see']), Emoji(name: 'brain', char: '\u{1F9E0}', shortName:'brain', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['intelligent', 'uc10', 'halloween', 'body', 'science', 'nerd', 'brain', 'medical', 'samhain', 'trick or treat', 'body part', 'anatomy', 'lab', 'smart', 'geek', 'serious', 'mind', 'memory', 'thought', 'conscience', 'aesculapius']), Emoji(name: 'anatomical heart', char: '\u{1FAC0}', shortName:'anatomical_heart', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc13', 'body', 'science', 'heart', 'covid', 'medical', 'body part', 'anatomy', 'lab', 'hearts', 'serce', 'corazón', 'coração', 'coeur', 'aesculapius']), Emoji(name: 'lungs', char: '\u{1FAC1}', shortName:'lungs', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc13', 'body', 'smoking', 'science', 'breathe', 'covid', 'medical', 'body part', 'anatomy', 'smoke', 'cigarette', 'puff', 'lab', 'sigh', 'inhale', 'aesculapius']), Emoji(name: 'bone', char: '\u{1F9B4}', shortName:'bone', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.bodyParts, keywords: ['uc11', 'body', 'science', 'mystery', 'bones', 'medical', 'body part', 'anatomy', 'lab', 'Os', 'hueso', 'aesculapius']), Emoji(name: 'speaking head', char: '\u{1F5E3}\u{FE0F}', shortName:'speaking_head', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personSymbol, keywords: ['face', 'head', 'silhouette', 'speak', 'speaking', 'uc7', 'talk', 'sound', 'language', 'talking', 'speech', 'social', 'chat', 'voice', 'speechless', 'speak', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear']), Emoji(name: 'bust in silhouette', char: '\u{1F464}', shortName:'bust_in_silhouette', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personSymbol, keywords: ['bust', 'silhouette', 'uc6', 'facebook', 'fame', 'famous', 'celebrity']), Emoji(name: 'busts in silhouette', char: '\u{1F465}', shortName:'busts_in_silhouette', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personSymbol, keywords: ['bust', 'silhouette', 'uc6', 'magnet', 'facebook', 'network']), Emoji(name: 'people hugging', char: '\u{1FAC2}', shortName:'people_hugging', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personSymbol, keywords: ['uc13', 'hug', 'embrace', 'hugs']), Emoji(name: 'baby', char: '\u{1F476}', shortName:'baby', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['baby', 'young', 'uc6', 'diversity', 'baby', 'christmas', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'baby: light skin tone', char: '\u{1F476}\u{1F3FB}', shortName:'baby_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['baby', 'light skin tone', 'young', 'uc8', 'diversity', 'baby', 'christmas', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby: medium-light skin tone', char: '\u{1F476}\u{1F3FC}', shortName:'baby_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['baby', 'medium-light skin tone', 'young', 'uc8', 'diversity', 'baby', 'christmas', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby: medium skin tone', char: '\u{1F476}\u{1F3FD}', shortName:'baby_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['baby', 'medium skin tone', 'young', 'uc8', 'diversity', 'baby', 'christmas', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby: medium-dark skin tone', char: '\u{1F476}\u{1F3FE}', shortName:'baby_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['baby', 'medium-dark skin tone', 'young', 'uc8', 'diversity', 'baby', 'christmas', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby: dark skin tone', char: '\u{1F476}\u{1F3FF}', shortName:'baby_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['baby', 'dark skin tone', 'young', 'uc8', 'diversity', 'baby', 'christmas', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'girl', char: '\u{1F467}', shortName:'girl', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['Virgo', 'young', 'zodiac', 'uc6', 'diversity', 'women', 'beautiful', 'human', 'wife', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'girl: light skin tone', char: '\u{1F467}\u{1F3FB}', shortName:'girl_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['Virgo', 'light skin tone', 'young', 'zodiac', 'uc8', 'diversity', 'women', 'beautiful', 'human', 'wife', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'girl: medium-light skin tone', char: '\u{1F467}\u{1F3FC}', shortName:'girl_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['Virgo', 'medium-light skin tone', 'young', 'zodiac', 'uc8', 'diversity', 'women', 'beautiful', 'human', 'wife', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'girl: medium skin tone', char: '\u{1F467}\u{1F3FD}', shortName:'girl_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['Virgo', 'medium skin tone', 'young', 'zodiac', 'uc8', 'diversity', 'women', 'beautiful', 'human', 'wife', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'girl: medium-dark skin tone', char: '\u{1F467}\u{1F3FE}', shortName:'girl_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['Virgo', 'medium-dark skin tone', 'young', 'zodiac', 'uc8', 'diversity', 'women', 'beautiful', 'human', 'wife', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'girl: dark skin tone', char: '\u{1F467}\u{1F3FF}', shortName:'girl_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['Virgo', 'dark skin tone', 'young', 'zodiac', 'uc8', 'diversity', 'women', 'beautiful', 'human', 'wife', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'child', char: '\u{1F9D2}', shortName:'child', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc10', 'diversity', 'men', 'beautiful', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'child: light skin tone', char: '\u{1F9D2}\u{1F3FB}', shortName:'child_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'light skin tone', 'young', 'uc10', 'diversity', 'men', 'beautiful', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'child: medium-light skin tone', char: '\u{1F9D2}\u{1F3FC}', shortName:'child_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium-light skin tone', 'young', 'uc10', 'diversity', 'men', 'beautiful', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'child: medium skin tone', char: '\u{1F9D2}\u{1F3FD}', shortName:'child_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium skin tone', 'young', 'uc10', 'diversity', 'men', 'beautiful', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'child: medium-dark skin tone', char: '\u{1F9D2}\u{1F3FE}', shortName:'child_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium-dark skin tone', 'young', 'uc10', 'diversity', 'men', 'beautiful', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'child: dark skin tone', char: '\u{1F9D2}\u{1F3FF}', shortName:'child_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'gender-neutral', 'young', 'uc10', 'diversity', 'men', 'beautiful', 'human', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'boy', char: '\u{1F466}', shortName:'boy', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['boy', 'young', 'uc6', 'diversity', 'men', 'human', 'handsome', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'stud', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'boy: light skin tone', char: '\u{1F466}\u{1F3FB}', shortName:'boy_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['boy', 'light skin tone', 'young', 'uc8', 'diversity', 'men', 'human', 'handsome', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'stud', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'boy: medium-light skin tone', char: '\u{1F466}\u{1F3FC}', shortName:'boy_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['boy', 'medium-light skin tone', 'young', 'uc8', 'diversity', 'men', 'human', 'handsome', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'stud', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'boy: medium skin tone', char: '\u{1F466}\u{1F3FD}', shortName:'boy_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['boy', 'medium skin tone', 'young', 'uc8', 'diversity', 'men', 'human', 'handsome', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'stud', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'boy: medium-dark skin tone', char: '\u{1F466}\u{1F3FE}', shortName:'boy_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['boy', 'medium-dark skin tone', 'young', 'uc8', 'diversity', 'men', 'human', 'handsome', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'stud', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'boy: dark skin tone', char: '\u{1F466}\u{1F3FF}', shortName:'boy_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['boy', 'dark skin tone', 'young', 'uc8', 'diversity', 'men', 'human', 'handsome', 'child', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'stud', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'woman', char: '\u{1F469}', shortName:'woman', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['woman', 'uc6', 'diversity', 'lesbian', 'women', 'feminist', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'feminism', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman: light skin tone', char: '\u{1F469}\u{1F3FB}', shortName:'woman_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['light skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'feminist', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'feminism', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium-light skin tone', char: '\u{1F469}\u{1F3FC}', shortName:'woman_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['medium-light skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'feminist', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'feminism', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium skin tone', char: '\u{1F469}\u{1F3FD}', shortName:'woman_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['medium skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'feminist', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'feminism', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}', shortName:'woman_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['medium-dark skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'feminist', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'feminism', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: dark skin tone', char: '\u{1F469}\u{1F3FF}', shortName:'woman_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'feminist', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'feminism', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person', char: '\u{1F9D1}', shortName:'adult', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc10', 'diversity', 'lesbian', 'men', 'feminist', 'human', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person: light skin tone', char: '\u{1F9D1}\u{1F3FB}', shortName:'adult_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'light skin tone', 'uc10', 'diversity', 'lesbian', 'men', 'feminist', 'human', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}', shortName:'adult_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium-light skin tone', 'uc10', 'diversity', 'lesbian', 'men', 'feminist', 'human', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium skin tone', char: '\u{1F9D1}\u{1F3FD}', shortName:'adult_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium skin tone', 'uc10', 'diversity', 'lesbian', 'men', 'feminist', 'human', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}', shortName:'adult_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium-dark skin tone', 'uc10', 'diversity', 'lesbian', 'men', 'feminist', 'human', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: dark skin tone', char: '\u{1F9D1}\u{1F3FF}', shortName:'adult_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'gender-neutral', 'uc10', 'diversity', 'lesbian', 'men', 'feminist', 'human', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man', char: '\u{1F468}', shortName:'man', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'uc6', 'diversity', 'men', 'feminist', 'human', 'daddy', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud']), Emoji(name: 'man: light skin tone', char: '\u{1F468}\u{1F3FB}', shortName:'man_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['light skin tone', 'man', 'uc8', 'diversity', 'men', 'feminist', 'human', 'daddy', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium-light skin tone', char: '\u{1F468}\u{1F3FC}', shortName:'man_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'feminist', 'human', 'daddy', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium skin tone', char: '\u{1F468}\u{1F3FD}', shortName:'man_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'medium skin tone', 'uc8', 'diversity', 'men', 'feminist', 'human', 'daddy', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}', shortName:'man_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'feminist', 'human', 'daddy', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: dark skin tone', char: '\u{1F468}\u{1F3FF}', shortName:'man_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'man', 'uc8', 'diversity', 'men', 'feminist', 'human', 'daddy', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'feminism', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'person: curly hair', char: '\u{1F9D1}\u{200D}\u{1F9B1}', shortName:'person_curly_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm']), Emoji(name: 'person: light skin tone, curly hair', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9B1}', shortName:'person_tone1_curly_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'person: medium-light skin tone, curly hair', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9B1}', shortName:'person_tone2_curly_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'person: medium skin tone, curly hair', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9B1}', shortName:'person_tone3_curly_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'person: medium-dark skin tone, curly hair', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9B1}', shortName:'person_tone4_curly_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'person: dark skin tone, curly hair', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9B1}', shortName:'person_tone5_curly_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'woman: curly hair', char: '\u{1F469}\u{200D}\u{1F9B1}', shortName:'woman_curly_haired', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', "'fro", 'curls', 'frizzy', 'perm']), Emoji(name: 'woman: light skin tone, curly hair', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9B1}', shortName:'woman_curly_haired_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'woman: medium-light skin tone, curly hair', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9B1}', shortName:'woman_curly_haired_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'woman: medium skin tone, curly hair', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9B1}', shortName:'woman_curly_haired_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone, curly hair', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9B1}', shortName:'woman_curly_haired_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'woman: dark skin tone, curly hair', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9B1}', shortName:'woman_curly_haired_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'man: curly hair', char: '\u{1F468}\u{200D}\u{1F9B1}', shortName:'man_curly_haired', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm']), Emoji(name: 'man: light skin tone, curly hair', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9B1}', shortName:'man_curly_haired_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'man: medium-light skin tone, curly hair', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9B1}', shortName:'man_curly_haired_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'man: medium skin tone, curly hair', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9B1}', shortName:'man_curly_haired_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, curly hair', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9B1}', shortName:'man_curly_haired_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'man: dark skin tone, curly hair', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9B1}', shortName:'man_curly_haired_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'afro', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', "'fro", 'curls', 'frizzy', 'perm'], modifiable: true), Emoji(name: 'person: red hair', char: '\u{1F9D1}\u{200D}\u{1F9B0}', shortName:'person_red_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person: light skin tone, red hair', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9B0}', shortName:'person_tone1_red_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-light skin tone, red hair', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9B0}', shortName:'person_tone2_red_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium skin tone, red hair', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9B0}', shortName:'person_tone3_red_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-dark skin tone, red hair', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9B0}', shortName:'person_tone4_red_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: dark skin tone, red hair', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9B0}', shortName:'person_tone5_red_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: red hair', char: '\u{1F469}\u{200D}\u{1F9B0}', shortName:'woman_red_haired', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman: light skin tone, red hair', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9B0}', shortName:'woman_red_haired_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium-light skin tone, red hair', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9B0}', shortName:'woman_red_haired_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium skin tone, red hair', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9B0}', shortName:'woman_red_haired_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone, red hair', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9B0}', shortName:'woman_red_haired_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: dark skin tone, red hair', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9B0}', shortName:'woman_red_haired_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man: red hair', char: '\u{1F468}\u{200D}\u{1F9B0}', shortName:'man_red_haired', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud']), Emoji(name: 'man: light skin tone, red hair', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9B0}', shortName:'man_red_haired_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium-light skin tone, red hair', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9B0}', shortName:'man_red_haired_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium skin tone, red hair', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9B0}', shortName:'man_red_haired_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, red hair', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9B0}', shortName:'man_red_haired_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: dark skin tone, red hair', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9B0}', shortName:'man_red_haired_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'ginger', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'woman: blond hair', char: '\u{1F471}\u{200D}\u{2640}\u{FE0F}', shortName:'blond-haired_woman', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blonde', 'woman', 'uc6', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman: light skin tone, blond hair', char: '\u{1F471}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'blond-haired_woman_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blonde', 'light skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium-light skin tone, blond hair', char: '\u{1F471}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'blond-haired_woman_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blonde', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium skin tone, blond hair', char: '\u{1F471}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'blond-haired_woman_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blonde', 'medium skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone, blond hair', char: '\u{1F471}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'blond-haired_woman_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blonde', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: dark skin tone, blond hair', char: '\u{1F471}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'blond-haired_woman_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blonde', 'dark skin tone', 'woman', 'uc8', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: blond hair', char: '\u{1F471}', shortName:'blond_haired_person', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'uc6', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person: light skin tone, blond hair', char: '\u{1F471}\u{1F3FB}', shortName:'blond_haired_person_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'light skin tone', 'uc8', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-light skin tone, blond hair', char: '\u{1F471}\u{1F3FC}', shortName:'blond_haired_person_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'medium-light skin tone', 'uc8', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium skin tone, blond hair', char: '\u{1F471}\u{1F3FD}', shortName:'blond_haired_person_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'medium skin tone', 'uc8', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-dark skin tone, blond hair', char: '\u{1F471}\u{1F3FE}', shortName:'blond_haired_person_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'medium-dark skin tone', 'uc8', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: dark skin tone, blond hair', char: '\u{1F471}\u{1F3FF}', shortName:'blond_haired_person_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'dark skin tone', 'uc8', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man: blond hair', char: '\u{1F471}\u{200D}\u{2642}\u{FE0F}', shortName:'blond-haired_man', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'man', 'uc6', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult']), Emoji(name: 'man: light skin tone, blond hair', char: '\u{1F471}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'blond-haired_man_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'light skin tone', 'man', 'uc8', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man: medium-light skin tone, blond hair', char: '\u{1F471}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'blond-haired_man_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man: medium skin tone, blond hair', char: '\u{1F471}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'blond-haired_man_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'man', 'medium skin tone', 'uc8', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, blond hair', char: '\u{1F471}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'blond-haired_man_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man: dark skin tone, blond hair', char: '\u{1F471}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'blond-haired_man_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['blond', 'dark skin tone', 'man', 'uc8', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'person: white hair', char: '\u{1F9D1}\u{200D}\u{1F9B3}', shortName:'person_white_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'old people', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair']), Emoji(name: 'person: light skin tone, white hair', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9B3}', shortName:'person_tone1_white_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'old people', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'person: medium-light skin tone, white hair', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9B3}', shortName:'person_tone2_white_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'old people', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'person: medium skin tone, white hair', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9B3}', shortName:'person_tone3_white_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'old people', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'person: medium-dark skin tone, white hair', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9B3}', shortName:'person_tone4_white_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'old people', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'person: dark skin tone, white hair', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9B3}', shortName:'person_tone5_white_hair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'old people', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'woman: white hair', char: '\u{1F469}\u{200D}\u{1F9B3}', shortName:'woman_white_haired', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair']), Emoji(name: 'woman: light skin tone, white hair', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9B3}', shortName:'woman_white_haired_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'woman: medium-light skin tone, white hair', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9B3}', shortName:'woman_white_haired_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'woman: medium skin tone, white hair', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9B3}', shortName:'woman_white_haired_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone, white hair', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9B3}', shortName:'woman_white_haired_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'woman: dark skin tone, white hair', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9B3}', shortName:'woman_white_haired_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'man: white hair', char: '\u{1F468}\u{200D}\u{1F9B3}', shortName:'man_white_haired', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair']), Emoji(name: 'man: light skin tone, white hair', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9B3}', shortName:'man_white_haired_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair'], modifiable: true), Emoji(name: 'man: medium-light skin tone, white hair', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9B3}', shortName:'man_white_haired_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair'], modifiable: true), Emoji(name: 'man: medium skin tone, white hair', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9B3}', shortName:'man_white_haired_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, white hair', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9B3}', shortName:'man_white_haired_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair'], modifiable: true), Emoji(name: 'man: dark skin tone, white hair', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9B3}', shortName:'man_white_haired_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair'], modifiable: true), Emoji(name: 'person: bald', char: '\u{1F9D1}\u{200D}\u{1F9B2}', shortName:'person_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'shaved head', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person: light skin tone, bald', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9B2}', shortName:'person_tone1_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'shaved head', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-light skin tone, bald', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9B2}', shortName:'person_tone2_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'shaved head', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium skin tone, bald', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9B2}', shortName:'person_tone3_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'shaved head', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: medium-dark skin tone, bald', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9B2}', shortName:'person_tone4_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'shaved head', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person: dark skin tone, bald', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9B2}', shortName:'person_tone5_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc12', 'diversity', 'lesbian', 'men', 'human', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'shaved head', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman: bald', char: '\u{1F469}\u{200D}\u{1F9B2}', shortName:'woman_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'balding']), Emoji(name: 'woman: light skin tone, bald', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9B2}', shortName:'woman_bald_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'balding'], modifiable: true), Emoji(name: 'woman: medium-light skin tone, bald', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9B2}', shortName:'woman_bald_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'balding'], modifiable: true), Emoji(name: 'woman: medium skin tone, bald', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9B2}', shortName:'woman_bald_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'balding'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone, bald', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9B2}', shortName:'woman_bald_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'balding'], modifiable: true), Emoji(name: 'woman: dark skin tone, bald', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9B2}', shortName:'woman_bald_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'lesbian', 'women', 'beautiful', 'human', 'parent', 'wife', 'mom', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'balding'], modifiable: true), Emoji(name: 'man: bald', char: '\u{1F468}\u{200D}\u{1F9B2}', shortName:'man_bald', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'balding']), Emoji(name: 'man: light skin tone, bald', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9B2}', shortName:'man_bald_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'balding'], modifiable: true), Emoji(name: 'man: medium-light skin tone, bald', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9B2}', shortName:'man_bald_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'balding'], modifiable: true), Emoji(name: 'man: medium skin tone, bald', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9B2}', shortName:'man_bald_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'balding'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, bald', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9B2}', shortName:'man_bald_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'balding'], modifiable: true), Emoji(name: 'man: dark skin tone, bald', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9B2}', shortName:'man_bald_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc11', 'old people', 'diversity', 'men', 'human', 'daddy', 'parent', 'handsome', 'husband', 'shaved head', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'balding'], modifiable: true), Emoji(name: 'person: beard', char: '\u{1F9D4}', shortName:'bearded_person', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc10', 'diversity', 'men', 'mustache', 'human', 'daddy', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud']), Emoji(name: 'man: light skin tone, beard', char: '\u{1F9D4}\u{1F3FB}', shortName:'bearded_person_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['beard', 'light skin tone', 'uc10', 'diversity', 'men', 'mustache', 'human', 'daddy', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium-light skin tone, beard', char: '\u{1F9D4}\u{1F3FC}', shortName:'bearded_person_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['beard', 'medium-light skin tone', 'uc10', 'diversity', 'men', 'mustache', 'human', 'daddy', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium skin tone, beard', char: '\u{1F9D4}\u{1F3FD}', shortName:'bearded_person_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['beard', 'medium skin tone', 'uc10', 'diversity', 'men', 'mustache', 'human', 'daddy', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, beard', char: '\u{1F9D4}\u{1F3FE}', shortName:'bearded_person_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['beard', 'medium-dark skin tone', 'uc10', 'diversity', 'men', 'mustache', 'human', 'daddy', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: dark skin tone, beard', char: '\u{1F9D4}\u{1F3FF}', shortName:'bearded_person_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['beard', 'dark skin tone', 'uc10', 'diversity', 'men', 'mustache', 'human', 'daddy', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man: beard', char: '\u{1F9D4}\u{200D}\u{2642}\u{FE0F}', shortName:'man_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality']), Emoji(name: 'man: light skin tone, beard', char: '\u{1F9D4}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tone1_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'man: medium-light skin tone, beard', char: '\u{1F9D4}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tone2_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'man: medium skin tone, beard', char: '\u{1F9D4}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tone3_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'man: medium-dark skin tone, beard', char: '\u{1F9D4}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tone4_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'man: dark skin tone, beard', char: '\u{1F9D4}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tone5_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'woman: beard', char: '\u{1F9D4}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality']), Emoji(name: 'woman: light skin tone, beard', char: '\u{1F9D4}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tone1_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'woman: medium-light skin tone, beard', char: '\u{1F9D4}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tone2_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'woman: medium skin tone, beard', char: '\u{1F9D4}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tone3_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'woman: medium-dark skin tone, beard', char: '\u{1F9D4}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tone4_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'woman: dark skin tone, beard', char: '\u{1F9D4}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tone5_beard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc13', 'diversity', 'beard', 'diverse', 'modifier', 'modifiers', 'equality'], modifiable: true), Emoji(name: 'old woman', char: '\u{1F475}', shortName:'older_woman', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['old', 'woman', 'uc6', 'old people', 'diversity', 'lesbian', 'women', 'vintage', 'human', 'cane', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair']), Emoji(name: 'old woman: light skin tone', char: '\u{1F475}\u{1F3FB}', shortName:'older_woman_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['light skin tone', 'old', 'woman', 'uc8', 'old people', 'diversity', 'lesbian', 'women', 'vintage', 'human', 'cane', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'old woman: medium-light skin tone', char: '\u{1F475}\u{1F3FC}', shortName:'older_woman_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['medium-light skin tone', 'old', 'woman', 'uc8', 'old people', 'diversity', 'lesbian', 'women', 'vintage', 'human', 'cane', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'old woman: medium skin tone', char: '\u{1F475}\u{1F3FD}', shortName:'older_woman_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['medium skin tone', 'old', 'woman', 'uc8', 'old people', 'diversity', 'lesbian', 'women', 'vintage', 'human', 'cane', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'old woman: medium-dark skin tone', char: '\u{1F475}\u{1F3FE}', shortName:'older_woman_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['medium-dark skin tone', 'old', 'woman', 'uc8', 'old people', 'diversity', 'lesbian', 'women', 'vintage', 'human', 'cane', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'old woman: dark skin tone', char: '\u{1F475}\u{1F3FF}', shortName:'older_woman_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'old', 'woman', 'uc8', 'old people', 'diversity', 'lesbian', 'women', 'vintage', 'human', 'cane', 'parent', 'wife', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'older person', char: '\u{1F9D3}', shortName:'older_adult', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['uc10', 'old people', 'diversity', 'lesbian', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair']), Emoji(name: 'older person: light skin tone', char: '\u{1F9D3}\u{1F3FB}', shortName:'older_adult_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'light skin tone', 'old', 'uc10', 'old people', 'diversity', 'lesbian', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'older person: medium-light skin tone', char: '\u{1F9D3}\u{1F3FC}', shortName:'older_adult_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium-light skin tone', 'old', 'uc10', 'old people', 'diversity', 'lesbian', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'older person: medium skin tone', char: '\u{1F9D3}\u{1F3FD}', shortName:'older_adult_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium skin tone', 'old', 'uc10', 'old people', 'diversity', 'lesbian', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'older person: medium-dark skin tone', char: '\u{1F9D3}\u{1F3FE}', shortName:'older_adult_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['gender-neutral', 'medium-dark skin tone', 'old', 'uc10', 'old people', 'diversity', 'lesbian', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'older person: dark skin tone', char: '\u{1F9D3}\u{1F3FF}', shortName:'older_adult_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'gender-neutral', 'old', 'uc10', 'old people', 'diversity', 'lesbian', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'wife', 'husband', 'mom', 'grey hair', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'maman', 'mommy', 'mama', 'mother', 'silver hair'], modifiable: true), Emoji(name: 'old man', char: '\u{1F474}', shortName:'older_man', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'old', 'uc6', 'old people', 'diversity', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair', 'balding']), Emoji(name: 'old man: light skin tone', char: '\u{1F474}\u{1F3FB}', shortName:'older_man_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['light skin tone', 'man', 'old', 'uc8', 'old people', 'diversity', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair', 'balding'], modifiable: true), Emoji(name: 'old man: medium-light skin tone', char: '\u{1F474}\u{1F3FC}', shortName:'older_man_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'medium-light skin tone', 'old', 'uc8', 'old people', 'diversity', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair', 'balding'], modifiable: true), Emoji(name: 'old man: medium skin tone', char: '\u{1F474}\u{1F3FD}', shortName:'older_man_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'medium skin tone', 'old', 'uc8', 'old people', 'diversity', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair', 'balding'], modifiable: true), Emoji(name: 'old man: medium-dark skin tone', char: '\u{1F474}\u{1F3FE}', shortName:'older_man_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['man', 'medium-dark skin tone', 'old', 'uc8', 'old people', 'diversity', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair', 'balding'], modifiable: true), Emoji(name: 'old man: dark skin tone', char: '\u{1F474}\u{1F3FF}', shortName:'older_man_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.person, keywords: ['dark skin tone', 'man', 'old', 'uc8', 'old people', 'diversity', 'men', 'vintage', 'human', 'cane', 'daddy', 'parent', 'handsome', 'husband', 'grey hair', 'hairless', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'stud', 'silver hair', 'balding'], modifiable: true), Emoji(name: 'person with skullcap', char: '\u{1F472}', shortName:'man_with_chinese_cap', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['gua pi mao', 'hat', 'man', 'uc6', 'diversity', 'men', 'human', 'chinese', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'chinois', 'asian', 'chine', 'parents', 'adult', 'stud']), Emoji(name: 'person with skullcap: light skin tone', char: '\u{1F472}\u{1F3FB}', shortName:'man_with_chinese_cap_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['gua pi mao', 'hat', 'light skin tone', 'man', 'uc8', 'diversity', 'men', 'human', 'chinese', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'chinois', 'asian', 'chine', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'person with skullcap: medium-light skin tone', char: '\u{1F472}\u{1F3FC}', shortName:'man_with_chinese_cap_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['gua pi mao', 'hat', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'human', 'chinese', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'chinois', 'asian', 'chine', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'person with skullcap: medium skin tone', char: '\u{1F472}\u{1F3FD}', shortName:'man_with_chinese_cap_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['gua pi mao', 'hat', 'man', 'medium skin tone', 'uc8', 'diversity', 'men', 'human', 'chinese', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'chinois', 'asian', 'chine', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'person with skullcap: medium-dark skin tone', char: '\u{1F472}\u{1F3FE}', shortName:'man_with_chinese_cap_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['gua pi mao', 'hat', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'human', 'chinese', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'chinois', 'asian', 'chine', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'person with skullcap: dark skin tone', char: '\u{1F472}\u{1F3FF}', shortName:'man_with_chinese_cap_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'gua pi mao', 'hat', 'man', 'uc8', 'diversity', 'men', 'human', 'chinese', 'parent', 'handsome', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'chinois', 'asian', 'chine', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'person wearing turban', char: '\u{1F473}', shortName:'person_wearing_turban', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['turban', 'uc6', 'diversity', 'men', 'human', 'disney', 'daddy', 'islam', 'parent', 'wife', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'cartoon', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult']), Emoji(name: 'person wearing turban: light skin tone', char: '\u{1F473}\u{1F3FB}', shortName:'person_wearing_turban_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'turban', 'uc8', 'diversity', 'men', 'human', 'disney', 'daddy', 'islam', 'parent', 'wife', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'cartoon', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult'], modifiable: true), Emoji(name: 'person wearing turban: medium-light skin tone', char: '\u{1F473}\u{1F3FC}', shortName:'person_wearing_turban_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-light skin tone', 'turban', 'uc8', 'diversity', 'men', 'human', 'disney', 'daddy', 'islam', 'parent', 'wife', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'cartoon', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult'], modifiable: true), Emoji(name: 'person wearing turban: medium skin tone', char: '\u{1F473}\u{1F3FD}', shortName:'person_wearing_turban_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium skin tone', 'turban', 'uc8', 'diversity', 'men', 'human', 'disney', 'daddy', 'islam', 'parent', 'wife', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'cartoon', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult'], modifiable: true), Emoji(name: 'person wearing turban: medium-dark skin tone', char: '\u{1F473}\u{1F3FE}', shortName:'person_wearing_turban_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-dark skin tone', 'turban', 'uc8', 'diversity', 'men', 'human', 'disney', 'daddy', 'islam', 'parent', 'wife', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'cartoon', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult'], modifiable: true), Emoji(name: 'person wearing turban: dark skin tone', char: '\u{1F473}\u{1F3FF}', shortName:'person_wearing_turban_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'turban', 'uc8', 'diversity', 'men', 'human', 'disney', 'daddy', 'islam', 'parent', 'wife', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'cartoon', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman wearing turban', char: '\u{1F473}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_wearing_turban', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['turban', 'woman', 'uc6', 'diversity', 'women', 'human', 'islam', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'muslim', 'arab', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman wearing turban: light skin tone', char: '\u{1F473}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_wearing_turban_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'turban', 'woman', 'uc8', 'diversity', 'women', 'human', 'islam', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'muslim', 'arab', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman wearing turban: medium-light skin tone', char: '\u{1F473}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_wearing_turban_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-light skin tone', 'turban', 'woman', 'uc8', 'diversity', 'women', 'human', 'islam', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'muslim', 'arab', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman wearing turban: medium skin tone', char: '\u{1F473}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_wearing_turban_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium skin tone', 'turban', 'woman', 'uc8', 'diversity', 'women', 'human', 'islam', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'muslim', 'arab', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman wearing turban: medium-dark skin tone', char: '\u{1F473}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_wearing_turban_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-dark skin tone', 'turban', 'woman', 'uc8', 'diversity', 'women', 'human', 'islam', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'muslim', 'arab', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman wearing turban: dark skin tone', char: '\u{1F473}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_wearing_turban_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'turban', 'woman', 'uc8', 'diversity', 'women', 'human', 'islam', 'parent', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'muslim', 'arab', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man wearing turban', char: '\u{1F473}\u{200D}\u{2642}\u{FE0F}', shortName:'man_wearing_turban', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'turban', 'uc6', 'diversity', 'men', 'mustache', 'human', 'daddy', 'islam', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult', 'stud']), Emoji(name: 'man wearing turban: light skin tone', char: '\u{1F473}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_wearing_turban_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'man', 'turban', 'uc8', 'diversity', 'men', 'mustache', 'human', 'daddy', 'islam', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man wearing turban: medium-light skin tone', char: '\u{1F473}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_wearing_turban_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'medium-light skin tone', 'turban', 'uc8', 'diversity', 'men', 'mustache', 'human', 'daddy', 'islam', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man wearing turban: medium skin tone', char: '\u{1F473}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_wearing_turban_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'medium skin tone', 'turban', 'uc8', 'diversity', 'men', 'mustache', 'human', 'daddy', 'islam', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man wearing turban: medium-dark skin tone', char: '\u{1F473}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_wearing_turban_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'medium-dark skin tone', 'turban', 'uc8', 'diversity', 'men', 'mustache', 'human', 'daddy', 'islam', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'man wearing turban: dark skin tone', char: '\u{1F473}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_wearing_turban_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'man', 'turban', 'uc8', 'diversity', 'men', 'mustache', 'human', 'daddy', 'islam', 'parent', 'handsome', 'husband', 'beard', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'muslim', 'arab', 'parents', 'adult', 'stud'], modifiable: true), Emoji(name: 'woman with headscarf', char: '\u{1F9D5}', shortName:'woman_with_headscarf', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc10', 'diversity', 'women', 'human', 'parent', 'hijab', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman with headscarf: light skin tone', char: '\u{1F9D5}\u{1F3FB}', shortName:'woman_with_headscarf_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['headscarf', 'hijab', 'light skin tone', 'mantilla', 'tichel', 'uc10', 'diversity', 'women', 'human', 'parent', 'hijab', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman with headscarf: medium-light skin tone', char: '\u{1F9D5}\u{1F3FC}', shortName:'woman_with_headscarf_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['headscarf', 'hijab', 'mantilla', 'medium-light skin tone', 'tichel', 'uc10', 'diversity', 'women', 'human', 'parent', 'hijab', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman with headscarf: medium skin tone', char: '\u{1F9D5}\u{1F3FD}', shortName:'woman_with_headscarf_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['headscarf', 'hijab', 'mantilla', 'medium skin tone', 'tichel', 'uc10', 'diversity', 'women', 'human', 'parent', 'hijab', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman with headscarf: medium-dark skin tone', char: '\u{1F9D5}\u{1F3FE}', shortName:'woman_with_headscarf_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['headscarf', 'hijab', 'mantilla', 'medium-dark skin tone', 'tichel', 'uc10', 'diversity', 'women', 'human', 'parent', 'hijab', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman with headscarf: dark skin tone', char: '\u{1F9D5}\u{1F3FF}', shortName:'woman_with_headscarf_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'headscarf', 'hijab', 'mantilla', 'tichel', 'uc10', 'diversity', 'women', 'human', 'parent', 'hijab', 'wife', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'police officer', char: '\u{1F46E}', shortName:'police_officer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'officer', 'police', 'uc6', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt']), Emoji(name: 'police officer: light skin tone', char: '\u{1F46E}\u{1F3FB}', shortName:'police_officer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'light skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'police officer: medium-light skin tone', char: '\u{1F46E}\u{1F3FC}', shortName:'police_officer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'medium-light skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'police officer: medium skin tone', char: '\u{1F46E}\u{1F3FD}', shortName:'police_officer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'medium skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'police officer: medium-dark skin tone', char: '\u{1F46E}\u{1F3FE}', shortName:'police_officer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'medium-dark skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'police officer: dark skin tone', char: '\u{1F46E}\u{1F3FF}', shortName:'police_officer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'dark skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'woman police officer', char: '\u{1F46E}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_police_officer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'officer', 'police', 'woman', 'uc6', 'diversity', 'job', 'police', '911', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt']), Emoji(name: 'woman police officer: light skin tone', char: '\u{1F46E}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_police_officer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'light skin tone', 'officer', 'police', 'woman', 'uc8', 'diversity', 'job', 'police', '911', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'woman police officer: medium-light skin tone', char: '\u{1F46E}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_police_officer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'medium-light skin tone', 'officer', 'police', 'woman', 'uc8', 'diversity', 'job', 'police', '911', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'woman police officer: medium skin tone', char: '\u{1F46E}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_police_officer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'medium skin tone', 'officer', 'police', 'woman', 'uc8', 'diversity', 'job', 'police', '911', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'woman police officer: medium-dark skin tone', char: '\u{1F46E}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_police_officer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'medium-dark skin tone', 'officer', 'police', 'woman', 'uc8', 'diversity', 'job', 'police', '911', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'woman police officer: dark skin tone', char: '\u{1F46E}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_police_officer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'dark skin tone', 'officer', 'police', 'woman', 'uc8', 'diversity', 'job', 'police', '911', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'man police officer', char: '\u{1F46E}\u{200D}\u{2642}\u{FE0F}', shortName:'man_police_officer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'man', 'officer', 'police', 'uc6', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt']), Emoji(name: 'man police officer: light skin tone', char: '\u{1F46E}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_police_officer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'light skin tone', 'man', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'man police officer: medium-light skin tone', char: '\u{1F46E}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_police_officer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'man', 'medium-light skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'man police officer: medium skin tone', char: '\u{1F46E}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_police_officer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'man', 'medium skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'man police officer: medium-dark skin tone', char: '\u{1F46E}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_police_officer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'man', 'medium-dark skin tone', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'man police officer: dark skin tone', char: '\u{1F46E}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_police_officer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['cop', 'dark skin tone', 'man', 'officer', 'police', 'uc8', 'diversity', 'job', 'police', '911', 'mustache', 'power', 'help', 'private', 'mystery', 'court', 'disguise', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'cop', 'policeman', 'popo', 'prison', 'handcuff', 'jail', 'justice', 'emergency', 'injury', 'прив', 'privé', 'privado', 'reserved', 'president', 'govt'], modifiable: true), Emoji(name: 'construction worker', char: '\u{1F477}', shortName:'construction_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'hat', 'worker', 'uc6', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'construction worker: light skin tone', char: '\u{1F477}\u{1F3FB}', shortName:'construction_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'hat', 'light skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'construction worker: medium-light skin tone', char: '\u{1F477}\u{1F3FC}', shortName:'construction_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'hat', 'medium-light skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'construction worker: medium skin tone', char: '\u{1F477}\u{1F3FD}', shortName:'construction_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'hat', 'medium skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'construction worker: medium-dark skin tone', char: '\u{1F477}\u{1F3FE}', shortName:'construction_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'hat', 'medium-dark skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'construction worker: dark skin tone', char: '\u{1F477}\u{1F3FF}', shortName:'construction_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'dark skin tone', 'hat', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman construction worker', char: '\u{1F477}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_construction_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'woman', 'worker', 'uc6', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'woman construction worker: light skin tone', char: '\u{1F477}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_construction_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'light skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman construction worker: medium-light skin tone', char: '\u{1F477}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_construction_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'medium-light skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman construction worker: medium skin tone', char: '\u{1F477}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_construction_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'medium skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman construction worker: medium-dark skin tone', char: '\u{1F477}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_construction_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'medium-dark skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman construction worker: dark skin tone', char: '\u{1F477}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_construction_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'dark skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man construction worker', char: '\u{1F477}\u{200D}\u{2642}\u{FE0F}', shortName:'man_construction_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'man', 'worker', 'uc6', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'man construction worker: light skin tone', char: '\u{1F477}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_construction_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'light skin tone', 'man', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man construction worker: medium-light skin tone', char: '\u{1F477}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_construction_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'man', 'medium-light skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man construction worker: medium skin tone', char: '\u{1F477}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_construction_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'man', 'medium skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man construction worker: medium-dark skin tone', char: '\u{1F477}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_construction_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'man', 'medium-dark skin tone', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man construction worker: dark skin tone', char: '\u{1F477}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_construction_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['construction', 'dark skin tone', 'man', 'worker', 'uc8', 'diversity', 'job', 'build', 'construction', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'guard', char: '\u{1F482}', shortName:'guard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'uc6', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved']), Emoji(name: 'guard: light skin tone', char: '\u{1F482}\u{1F3FB}', shortName:'guard_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'light skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'guard: medium-light skin tone', char: '\u{1F482}\u{1F3FC}', shortName:'guard_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'medium-light skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'guard: medium skin tone', char: '\u{1F482}\u{1F3FD}', shortName:'guard_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'medium skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'guard: medium-dark skin tone', char: '\u{1F482}\u{1F3FE}', shortName:'guard_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'medium-dark skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'guard: dark skin tone', char: '\u{1F482}\u{1F3FF}', shortName:'guard_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'guard', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'woman guard', char: '\u{1F482}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_guard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'woman', 'uc6', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved']), Emoji(name: 'woman guard: light skin tone', char: '\u{1F482}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_guard_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'light skin tone', 'woman', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'woman guard: medium-light skin tone', char: '\u{1F482}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_guard_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'woman guard: medium skin tone', char: '\u{1F482}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_guard_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'medium skin tone', 'woman', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'woman guard: medium-dark skin tone', char: '\u{1F482}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_guard_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'woman guard: dark skin tone', char: '\u{1F482}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_guard_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'guard', 'woman', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man guard', char: '\u{1F482}\u{200D}\u{2642}\u{FE0F}', shortName:'man_guard', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'man', 'uc6', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved']), Emoji(name: 'man guard: light skin tone', char: '\u{1F482}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_guard_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'light skin tone', 'man', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man guard: medium-light skin tone', char: '\u{1F482}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_guard_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man guard: medium skin tone', char: '\u{1F482}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_guard_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'man', 'medium skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man guard: medium-dark skin tone', char: '\u{1F482}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_guard_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['guard', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man guard: dark skin tone', char: '\u{1F482}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_guard_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'guard', 'man', 'uc8', 'diversity', 'job', 'queen', 'england', 'private', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'king', 'prince', 'princess', 'united kingdom', 'london', 'uk', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'detective', char: '\u{1F575}', shortName:'detective', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'sleuth', 'spy', 'uc7', 'diversity', 'glasses', 'job', 'google', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'eyeglasses', 'eye glasses', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty']), Emoji(name: 'detective: light skin tone', char: '\u{1F575}\u{1F3FB}', shortName:'detective_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'light skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'glasses', 'job', 'google', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'eyeglasses', 'eye glasses', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'detective: medium-light skin tone', char: '\u{1F575}\u{1F3FC}', shortName:'detective_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'glasses', 'job', 'google', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'eyeglasses', 'eye glasses', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'detective: medium skin tone', char: '\u{1F575}\u{1F3FD}', shortName:'detective_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'medium skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'glasses', 'job', 'google', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'eyeglasses', 'eye glasses', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'detective: medium-dark skin tone', char: '\u{1F575}\u{1F3FE}', shortName:'detective_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'glasses', 'job', 'google', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'eyeglasses', 'eye glasses', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'detective: dark skin tone', char: '\u{1F575}\u{1F3FF}', shortName:'detective_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'detective', 'sleuth', 'spy', 'uc8', 'diversity', 'glasses', 'job', 'google', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'eyeglasses', 'eye glasses', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'woman detective', char: '\u{1F575}\u{FE0F}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_detective', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'sleuth', 'spy', 'woman', 'uc7', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty']), Emoji(name: 'woman detective: light skin tone', char: '\u{1F575}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_detective_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'light skin tone', 'sleuth', 'spy', 'woman', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'woman detective: medium-light skin tone', char: '\u{1F575}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_detective_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'woman', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'woman detective: medium skin tone', char: '\u{1F575}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_detective_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'medium skin tone', 'sleuth', 'spy', 'woman', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'woman detective: medium-dark skin tone', char: '\u{1F575}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_detective_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'woman', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'woman detective: dark skin tone', char: '\u{1F575}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_detective_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'detective', 'sleuth', 'spy', 'woman', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'man detective', char: '\u{1F575}\u{FE0F}\u{200D}\u{2642}\u{FE0F}', shortName:'man_detective', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'man', 'sleuth', 'spy', 'uc7', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty']), Emoji(name: 'man detective: light skin tone', char: '\u{1F575}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_detective_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'light skin tone', 'man', 'sleuth', 'spy', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'man detective: medium-light skin tone', char: '\u{1F575}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_detective_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'man', 'medium-light skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'man detective: medium skin tone', char: '\u{1F575}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_detective_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'man', 'medium skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'man detective: medium-dark skin tone', char: '\u{1F575}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_detective_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['detective', 'man', 'medium-dark skin tone', 'sleuth', 'spy', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'man detective: dark skin tone', char: '\u{1F575}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_detective_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'detective', 'man', 'sleuth', 'spy', 'uc8', 'diversity', 'job', 'search', 'detective', 'super hero', 'private', 'mystery', 'clever', 'disguise', 'explore', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'look', 'find', 'looking', 'see', 'superhero', 'superman', 'batman', 'прив', 'privé', 'privado', 'reserved', 'witty'], modifiable: true), Emoji(name: 'health worker', char: '\u{1F9D1}\u{200D}\u{2695}\u{FE0F}', shortName:'health_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius']), Emoji(name: 'health worker: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2695}\u{FE0F}', shortName:'health_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'health worker: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2695}\u{FE0F}', shortName:'health_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'health worker: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2695}\u{FE0F}', shortName:'health_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'health worker: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2695}\u{FE0F}', shortName:'health_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'health worker: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2695}\u{FE0F}', shortName:'health_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'woman health worker', char: '\u{1F469}\u{200D}\u{2695}\u{FE0F}', shortName:'woman_health_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'nurse', 'therapist', 'woman', 'uc6', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius']), Emoji(name: 'woman health worker: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2695}\u{FE0F}', shortName:'woman_health_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'light skin tone', 'nurse', 'therapist', 'woman', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'woman health worker: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{2695}\u{FE0F}', shortName:'woman_health_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'medium-light skin tone', 'nurse', 'therapist', 'woman', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'woman health worker: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{2695}\u{FE0F}', shortName:'woman_health_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'medium skin tone', 'nurse', 'therapist', 'woman', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'woman health worker: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{2695}\u{FE0F}', shortName:'woman_health_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'medium-dark skin tone', 'nurse', 'therapist', 'woman', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'woman health worker: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{2695}\u{FE0F}', shortName:'woman_health_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'doctor', 'healthcare', 'nurse', 'therapist', 'woman', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'man health worker', char: '\u{1F468}\u{200D}\u{2695}\u{FE0F}', shortName:'man_health_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'man', 'nurse', 'therapist', 'uc6', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius']), Emoji(name: 'man health worker: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{2695}\u{FE0F}', shortName:'man_health_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'light skin tone', 'man', 'nurse', 'therapist', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'man health worker: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{2695}\u{FE0F}', shortName:'man_health_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'man', 'medium-light skin tone', 'nurse', 'therapist', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'man health worker: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{2695}\u{FE0F}', shortName:'man_health_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'man', 'medium skin tone', 'nurse', 'therapist', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'man health worker: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{2695}\u{FE0F}', shortName:'man_health_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['doctor', 'healthcare', 'man', 'medium-dark skin tone', 'nurse', 'therapist', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'man health worker: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{2695}\u{FE0F}', shortName:'man_health_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'doctor', 'healthcare', 'man', 'nurse', 'therapist', 'uc8', 'diversity', 'health', 'sick', 'job', '911', 'nerd', 'nurse', 'help', 'disguise', 'medical', 'diverse', 'modifier', 'modifiers', 'equality', 'medicine', 'doctor', 'barf', 'vomit', 'throw up', 'puke', 'get well', 'cough', 'puking', 'barfing', 'malade', 'spew', 'fever', 'profession', 'boss', 'career', 'emergency', 'injury', 'smart', 'geek', 'serious', 'aesculapius'], modifiable: true), Emoji(name: 'farmer', char: '\u{1F9D1}\u{200D}\u{1F33E}', shortName:'farmer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'farmer: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F33E}', shortName:'farmer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'farmer: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F33E}', shortName:'farmer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'farmer: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F33E}', shortName:'farmer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'farmer: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F33E}', shortName:'farmer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'farmer: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F33E}', shortName:'farmer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman farmer', char: '\u{1F469}\u{200D}\u{1F33E}', shortName:'woman_farmer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'rancher', 'woman', 'uc6', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'woman farmer: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F33E}', shortName:'woman_farmer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'light skin tone', 'rancher', 'woman', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman farmer: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F33E}', shortName:'woman_farmer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'medium-light skin tone', 'rancher', 'woman', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman farmer: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F33E}', shortName:'woman_farmer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'medium skin tone', 'rancher', 'woman', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman farmer: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F33E}', shortName:'woman_farmer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'medium-dark skin tone', 'rancher', 'woman', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman farmer: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F33E}', shortName:'woman_farmer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'farmer', 'gardener', 'rancher', 'woman', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man farmer', char: '\u{1F468}\u{200D}\u{1F33E}', shortName:'man_farmer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'man', 'rancher', 'uc6', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'man farmer: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F33E}', shortName:'man_farmer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'light skin tone', 'man', 'rancher', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man farmer: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F33E}', shortName:'man_farmer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'man', 'medium-light skin tone', 'rancher', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man farmer: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F33E}', shortName:'man_farmer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'man', 'medium skin tone', 'rancher', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man farmer: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F33E}', shortName:'man_farmer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['farmer', 'gardener', 'man', 'medium-dark skin tone', 'rancher', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man farmer: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F33E}', shortName:'man_farmer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'farmer', 'gardener', 'man', 'rancher', 'uc8', 'diversity', 'job', 'farm', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'cook', char: '\u{1F9D1}\u{200D}\u{1F373}', shortName:'cook', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch']), Emoji(name: 'cook: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F373}', shortName:'cook_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'cook: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F373}', shortName:'cook_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'cook: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F373}', shortName:'cook_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'cook: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F373}', shortName:'cook_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'cook: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F373}', shortName:'cook_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'woman cook', char: '\u{1F469}\u{200D}\u{1F373}', shortName:'woman_cook', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'woman', 'uc6', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch']), Emoji(name: 'woman cook: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F373}', shortName:'woman_cook_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'light skin tone', 'woman', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'woman cook: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F373}', shortName:'woman_cook_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'woman cook: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F373}', shortName:'woman_cook_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'medium skin tone', 'woman', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'woman cook: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F373}', shortName:'woman_cook_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'woman cook: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F373}', shortName:'woman_cook_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'dark skin tone', 'woman', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'man cook', char: '\u{1F468}\u{200D}\u{1F373}', shortName:'man_cook', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'man', 'uc6', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch']), Emoji(name: 'man cook: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F373}', shortName:'man_cook_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'light skin tone', 'man', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'man cook: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F373}', shortName:'man_cook_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'man cook: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F373}', shortName:'man_cook_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'man', 'medium skin tone', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'man cook: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F373}', shortName:'man_cook_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'man cook: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F373}', shortName:'man_cook_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['chef', 'cook', 'dark skin tone', 'man', 'uc8', 'diversity', 'job', 'bake', 'chef', 'dinner', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'baking', 'cuisinière', 'cuisinier', 'lunch'], modifiable: true), Emoji(name: 'student', char: '\u{1F9D1}\u{200D}\u{1F393}', shortName:'student', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious']), Emoji(name: 'student: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F393}', shortName:'student_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'student: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F393}', shortName:'student_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'student: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F393}', shortName:'student_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'student: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F393}', shortName:'student_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'student: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F393}', shortName:'student_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman student', char: '\u{1F469}\u{200D}\u{1F393}', shortName:'woman_student', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'student', 'woman', 'uc6', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious']), Emoji(name: 'woman student: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F393}', shortName:'woman_student_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'light skin tone', 'student', 'woman', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman student: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F393}', shortName:'woman_student_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'medium-light skin tone', 'student', 'woman', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman student: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F393}', shortName:'woman_student_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'medium skin tone', 'student', 'woman', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman student: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F393}', shortName:'woman_student_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'medium-dark skin tone', 'student', 'woman', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman student: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F393}', shortName:'woman_student_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'graduate', 'student', 'woman', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man student', char: '\u{1F468}\u{200D}\u{1F393}', shortName:'man_student', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'man', 'student', 'uc6', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious']), Emoji(name: 'man student: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F393}', shortName:'man_student_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'light skin tone', 'man', 'student', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man student: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F393}', shortName:'man_student_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'man', 'medium-light skin tone', 'student', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man student: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F393}', shortName:'man_student_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'man', 'medium skin tone', 'student', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man student: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F393}', shortName:'man_student_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['graduate', 'man', 'medium-dark skin tone', 'student', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man student: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F393}', shortName:'man_student_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'graduate', 'man', 'student', 'uc8', 'diversity', 'classroom', 'nerd', 'graduate', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'singer', char: '\u{1F9D1}\u{200D}\u{1F3A4}', shortName:'singer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity']), Emoji(name: 'singer: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F3A4}', shortName:'singer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'singer: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F3A4}', shortName:'singer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'singer: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F3A4}', shortName:'singer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'singer: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F3A4}', shortName:'singer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'singer: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F3A4}', shortName:'singer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'woman singer', char: '\u{1F469}\u{200D}\u{1F3A4}', shortName:'woman_singer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'rock', 'singer', 'star', 'woman', 'uc6', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity']), Emoji(name: 'woman singer: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F3A4}', shortName:'woman_singer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'light skin tone', 'rock', 'singer', 'star', 'woman', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'woman singer: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F3A4}', shortName:'woman_singer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'medium-light skin tone', 'rock', 'singer', 'star', 'woman', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'woman singer: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F3A4}', shortName:'woman_singer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'medium skin tone', 'rock', 'singer', 'star', 'woman', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'woman singer: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F3A4}', shortName:'woman_singer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'medium-dark skin tone', 'rock', 'singer', 'star', 'woman', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'woman singer: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F3A4}', shortName:'woman_singer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'dark skin tone', 'entertainer', 'rock', 'singer', 'star', 'woman', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'man singer', char: '\u{1F468}\u{200D}\u{1F3A4}', shortName:'man_singer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'man', 'rock', 'singer', 'star', 'uc6', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity']), Emoji(name: 'man singer: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F3A4}', shortName:'man_singer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'light skin tone', 'man', 'rock', 'singer', 'star', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'man singer: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F3A4}', shortName:'man_singer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'man', 'medium-light skin tone', 'rock', 'singer', 'star', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'man singer: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F3A4}', shortName:'man_singer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'man', 'medium skin tone', 'rock', 'singer', 'star', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'man singer: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F3A4}', shortName:'man_singer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'entertainer', 'man', 'medium-dark skin tone', 'rock', 'singer', 'star', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'man singer: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F3A4}', shortName:'man_singer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['actor', 'dark skin tone', 'entertainer', 'man', 'rock', 'singer', 'star', 'uc8', 'instruments', 'diversity', 'job', 'rock and roll', 'fame', 'artist', 'disguise', 'advertise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'famous', 'celebrity'], modifiable: true), Emoji(name: 'teacher', char: '\u{1F9D1}\u{200D}\u{1F3EB}', shortName:'teacher', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'classroom', 'job', 'nerd', 'advertise', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious']), Emoji(name: 'teacher: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F3EB}', shortName:'teacher_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'classroom', 'job', 'nerd', 'advertise', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'teacher: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F3EB}', shortName:'teacher_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'classroom', 'job', 'nerd', 'advertise', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'teacher: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F3EB}', shortName:'teacher_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'classroom', 'job', 'nerd', 'advertise', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'teacher: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F3EB}', shortName:'teacher_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'classroom', 'job', 'nerd', 'advertise', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'teacher: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F3EB}', shortName:'teacher_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'classroom', 'job', 'nerd', 'advertise', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman teacher', char: '\u{1F469}\u{200D}\u{1F3EB}', shortName:'woman_teacher', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'professor', 'teacher', 'woman', 'uc6', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious']), Emoji(name: 'woman teacher: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F3EB}', shortName:'woman_teacher_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'light skin tone', 'professor', 'teacher', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman teacher: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F3EB}', shortName:'woman_teacher_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'medium-light skin tone', 'professor', 'teacher', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman teacher: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F3EB}', shortName:'woman_teacher_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'medium skin tone', 'professor', 'teacher', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman teacher: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F3EB}', shortName:'woman_teacher_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'medium-dark skin tone', 'professor', 'teacher', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman teacher: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F3EB}', shortName:'woman_teacher_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'instructor', 'professor', 'teacher', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man teacher', char: '\u{1F468}\u{200D}\u{1F3EB}', shortName:'man_teacher', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'man', 'professor', 'teacher', 'uc6', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious']), Emoji(name: 'man teacher: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F3EB}', shortName:'man_teacher_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'light skin tone', 'man', 'professor', 'teacher', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man teacher: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F3EB}', shortName:'man_teacher_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'man', 'medium-light skin tone', 'professor', 'teacher', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man teacher: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F3EB}', shortName:'man_teacher_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'man', 'medium skin tone', 'professor', 'teacher', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man teacher: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F3EB}', shortName:'man_teacher_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['instructor', 'man', 'medium-dark skin tone', 'professor', 'teacher', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man teacher: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F3EB}', shortName:'man_teacher_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'instructor', 'man', 'professor', 'teacher', 'uc8', 'diversity', 'classroom', 'job', 'nerd', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'factory worker', char: '\u{1F9D1}\u{200D}\u{1F3ED}', shortName:'factory_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'factory worker: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F3ED}', shortName:'factory_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'factory worker: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F3ED}', shortName:'factory_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'factory worker: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F3ED}', shortName:'factory_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'factory worker: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F3ED}', shortName:'factory_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'factory worker: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F3ED}', shortName:'factory_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman factory worker', char: '\u{1F469}\u{200D}\u{1F3ED}', shortName:'woman_factory_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'woman', 'worker', 'uc6', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'woman factory worker: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F3ED}', shortName:'woman_factory_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'light skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman factory worker: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F3ED}', shortName:'woman_factory_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'medium-light skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman factory worker: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F3ED}', shortName:'woman_factory_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'medium skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman factory worker: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F3ED}', shortName:'woman_factory_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'medium-dark skin tone', 'woman', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman factory worker: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F3ED}', shortName:'woman_factory_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'dark skin tone', 'factory', 'industrial', 'woman', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man factory worker', char: '\u{1F468}\u{200D}\u{1F3ED}', shortName:'man_factory_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'man', 'worker', 'uc6', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'man factory worker: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F3ED}', shortName:'man_factory_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'light skin tone', 'man', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man factory worker: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F3ED}', shortName:'man_factory_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'man', 'medium-light skin tone', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man factory worker: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F3ED}', shortName:'man_factory_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'man', 'medium skin tone', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man factory worker: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F3ED}', shortName:'man_factory_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'factory', 'industrial', 'man', 'medium-dark skin tone', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man factory worker: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F3ED}', shortName:'man_factory_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['assembly', 'dark skin tone', 'factory', 'industrial', 'man', 'worker', 'uc8', 'diversity', 'job', 'mask', 'build', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'technologist', char: '\u{1F9D1}\u{200D}\u{1F4BB}', shortName:'technologist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office']), Emoji(name: 'technologist: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F4BB}', shortName:'technologist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'technologist: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F4BB}', shortName:'technologist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'technologist: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F4BB}', shortName:'technologist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'technologist: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F4BB}', shortName:'technologist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'technologist: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F4BB}', shortName:'technologist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'classroom', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'woman technologist', char: '\u{1F469}\u{200D}\u{1F4BB}', shortName:'woman_technologist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'software', 'technologist', 'woman', 'uc6', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office']), Emoji(name: 'woman technologist: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F4BB}', shortName:'woman_technologist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'light skin tone', 'software', 'technologist', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'woman technologist: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F4BB}', shortName:'woman_technologist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'medium-light skin tone', 'software', 'technologist', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'woman technologist: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F4BB}', shortName:'woman_technologist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'medium skin tone', 'software', 'technologist', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'woman technologist: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F4BB}', shortName:'woman_technologist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'medium-dark skin tone', 'software', 'technologist', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'woman technologist: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F4BB}', shortName:'woman_technologist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'dark skin tone', 'developer', 'inventor', 'software', 'technologist', 'woman', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'man technologist', char: '\u{1F468}\u{200D}\u{1F4BB}', shortName:'man_technologist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'man', 'software', 'technologist', 'uc6', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office']), Emoji(name: 'man technologist: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F4BB}', shortName:'man_technologist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'light skin tone', 'man', 'software', 'technologist', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'man technologist: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F4BB}', shortName:'man_technologist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'man', 'medium-light skin tone', 'software', 'technologist', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'man technologist: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F4BB}', shortName:'man_technologist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'man', 'medium skin tone', 'software', 'technologist', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'man technologist: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F4BB}', shortName:'man_technologist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'developer', 'inventor', 'man', 'medium-dark skin tone', 'software', 'technologist', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'man technologist: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F4BB}', shortName:'man_technologist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['coder', 'dark skin tone', 'developer', 'inventor', 'man', 'software', 'technologist', 'uc8', 'diversity', 'classroom', 'job', 'business', 'nerd', 'code', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'school', 'teach', 'learn', 'study', 'college', 'degree', 'education', 'homework', 'student', 'teacher', 'university', 'test', 'learning', 'exam', 'lesson', 'assignment', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'coding', 'office'], modifiable: true), Emoji(name: 'office worker', char: '\u{1F9D1}\u{200D}\u{1F4BC}', shortName:'office_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office']), Emoji(name: 'office worker: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F4BC}', shortName:'office_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'office worker: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F4BC}', shortName:'office_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'office worker: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F4BC}', shortName:'office_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'office worker: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F4BC}', shortName:'office_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'office worker: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F4BC}', shortName:'office_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'woman office worker', char: '\u{1F469}\u{200D}\u{1F4BC}', shortName:'woman_office_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'manager', 'office', 'white-collar', 'woman', 'uc6', 'diversity', 'women', 'job', 'business', 'nerd', 'costume', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office']), Emoji(name: 'woman office worker: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F4BC}', shortName:'woman_office_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'light skin tone', 'manager', 'office', 'white-collar', 'woman', 'uc8', 'diversity', 'women', 'job', 'business', 'nerd', 'costume', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'woman office worker: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F4BC}', shortName:'woman_office_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'woman', 'uc8', 'diversity', 'women', 'job', 'business', 'nerd', 'costume', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'woman office worker: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F4BC}', shortName:'woman_office_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'manager', 'medium skin tone', 'office', 'white-collar', 'woman', 'uc8', 'diversity', 'women', 'job', 'business', 'nerd', 'costume', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'woman office worker: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F4BC}', shortName:'woman_office_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'woman', 'uc8', 'diversity', 'women', 'job', 'business', 'nerd', 'costume', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'woman office worker: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F4BC}', shortName:'woman_office_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'dark skin tone', 'manager', 'office', 'white-collar', 'woman', 'uc8', 'diversity', 'women', 'job', 'business', 'nerd', 'costume', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'man office worker', char: '\u{1F468}\u{200D}\u{1F4BC}', shortName:'man_office_worker', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'man', 'manager', 'office', 'white-collar', 'uc6', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office']), Emoji(name: 'man office worker: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F4BC}', shortName:'man_office_worker_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'light skin tone', 'man', 'manager', 'office', 'white-collar', 'uc8', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'man office worker: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F4BC}', shortName:'man_office_worker_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'man', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'uc8', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'man office worker: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F4BC}', shortName:'man_office_worker_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'man', 'manager', 'medium skin tone', 'office', 'white-collar', 'uc8', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'man office worker: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F4BC}', shortName:'man_office_worker_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'man', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'uc8', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'man office worker: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F4BC}', shortName:'man_office_worker_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['architect', 'business', 'dark skin tone', 'man', 'manager', 'office', 'white-collar', 'uc8', 'diversity', 'men', 'job', 'business', 'nerd', 'work', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'smart', 'geek', 'serious', 'office'], modifiable: true), Emoji(name: 'mechanic', char: '\u{1F9D1}\u{200D}\u{1F527}', shortName:'mechanic', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'mechanic: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F527}', shortName:'mechanic_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'mechanic: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F527}', shortName:'mechanic_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'mechanic: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F527}', shortName:'mechanic_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'mechanic: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F527}', shortName:'mechanic_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'mechanic: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F527}', shortName:'mechanic_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman mechanic', char: '\u{1F469}\u{200D}\u{1F527}', shortName:'woman_mechanic', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc6', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'woman mechanic: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F527}', shortName:'woman_mechanic_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'light skin tone', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman mechanic: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F527}', shortName:'woman_mechanic_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'woman', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman mechanic: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F527}', shortName:'woman_mechanic_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'woman', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman mechanic: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F527}', shortName:'woman_mechanic_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'woman', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman mechanic: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F527}', shortName:'woman_mechanic_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'electrician', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man mechanic', char: '\u{1F468}\u{200D}\u{1F527}', shortName:'man_mechanic', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc6', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career']), Emoji(name: 'man mechanic: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F527}', shortName:'man_mechanic_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'light skin tone', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man mechanic: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F527}', shortName:'man_mechanic_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'man', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man mechanic: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F527}', shortName:'man_mechanic_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'man', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man mechanic: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F527}', shortName:'man_mechanic_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['electrician', 'man', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man mechanic: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F527}', shortName:'man_mechanic_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'electrician', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc8', 'diversity', 'job', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'scientist', char: '\u{1F9D1}\u{200D}\u{1F52C}', shortName:'scientist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious']), Emoji(name: 'scientist: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F52C}', shortName:'scientist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'scientist: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F52C}', shortName:'scientist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'scientist: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F52C}', shortName:'scientist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'scientist: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F52C}', shortName:'scientist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'scientist: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F52C}', shortName:'scientist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman scientist', char: '\u{1F469}\u{200D}\u{1F52C}', shortName:'woman_scientist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman', 'uc6', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious']), Emoji(name: 'woman scientist: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F52C}', shortName:'woman_scientist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'light skin tone', 'mathematician', 'physicist', 'scientist', 'woman', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman scientist: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F52C}', shortName:'woman_scientist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'woman', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman scientist: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F52C}', shortName:'woman_scientist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'woman', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman scientist: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F52C}', shortName:'woman_scientist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'woman', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'woman scientist: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F52C}', shortName:'woman_scientist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'dark skin tone', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man scientist', char: '\u{1F468}\u{200D}\u{1F52C}', shortName:'man_scientist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'physicist', 'scientist', 'uc6', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious']), Emoji(name: 'man scientist: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F52C}', shortName:'man_scientist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'light skin tone', 'man', 'mathematician', 'physicist', 'scientist', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man scientist: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F52C}', shortName:'man_scientist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man scientist: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F52C}', shortName:'man_scientist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man scientist: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F52C}', shortName:'man_scientist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'man scientist: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F52C}', shortName:'man_scientist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['biologist', 'chemist', 'dark skin tone', 'engineer', 'man', 'mathematician', 'physicist', 'scientist', 'uc8', 'diversity', 'science', 'job', 'nerd', 'beaker', 'experiment', 'diverse', 'modifier', 'modifiers', 'equality', 'lab', 'profession', 'boss', 'career', 'smart', 'geek', 'serious'], modifiable: true), Emoji(name: 'artist', char: '\u{1F9D1}\u{200D}\u{1F3A8}', shortName:'artist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts']), Emoji(name: 'artist: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F3A8}', shortName:'artist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'artist: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F3A8}', shortName:'artist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'artist: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F3A8}', shortName:'artist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'artist: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F3A8}', shortName:'artist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'artist: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F3A8}', shortName:'artist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'woman artist', char: '\u{1F469}\u{200D}\u{1F3A8}', shortName:'woman_artist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'palette', 'woman', 'uc6', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts']), Emoji(name: 'woman artist: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F3A8}', shortName:'woman_artist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'light skin tone', 'palette', 'woman', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'woman artist: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F3A8}', shortName:'woman_artist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'medium-light skin tone', 'palette', 'woman', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'woman artist: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F3A8}', shortName:'woman_artist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'medium skin tone', 'palette', 'woman', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'woman artist: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F3A8}', shortName:'woman_artist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'medium-dark skin tone', 'palette', 'woman', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'woman artist: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F3A8}', shortName:'woman_artist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'dark skin tone', 'palette', 'woman', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'man artist', char: '\u{1F468}\u{200D}\u{1F3A8}', shortName:'man_artist', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'man', 'palette', 'uc6', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts']), Emoji(name: 'man artist: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F3A8}', shortName:'man_artist_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'light skin tone', 'man', 'palette', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'man artist: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F3A8}', shortName:'man_artist_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'man', 'medium-light skin tone', 'palette', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'man artist: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F3A8}', shortName:'man_artist_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'man', 'medium skin tone', 'palette', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'man artist: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F3A8}', shortName:'man_artist_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'man', 'medium-dark skin tone', 'palette', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'man artist: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F3A8}', shortName:'man_artist_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['artist', 'dark skin tone', 'man', 'palette', 'uc8', 'diversity', 'job', 'painting', 'artist', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'painter', 'arts'], modifiable: true), Emoji(name: 'firefighter', char: '\u{1F9D1}\u{200D}\u{1F692}', shortName:'firefighter', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer']), Emoji(name: 'firefighter: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F692}', shortName:'firefighter_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'firefighter: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F692}', shortName:'firefighter_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'firefighter: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F692}', shortName:'firefighter_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'firefighter: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F692}', shortName:'firefighter_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'firefighter: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F692}', shortName:'firefighter_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'woman firefighter', char: '\u{1F469}\u{200D}\u{1F692}', shortName:'woman_firefighter', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'woman', 'uc6', 'diversity', 'job', '911', 'help', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'fuego', 'feu', 'fuoco', 'feuer']), Emoji(name: 'woman firefighter: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F692}', shortName:'woman_firefighter_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'light skin tone', 'woman', 'uc8', 'diversity', 'job', '911', 'help', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'woman firefighter: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F692}', shortName:'woman_firefighter_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'job', '911', 'help', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'woman firefighter: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F692}', shortName:'woman_firefighter_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'medium skin tone', 'woman', 'uc8', 'diversity', 'job', '911', 'help', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'woman firefighter: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F692}', shortName:'woman_firefighter_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'job', '911', 'help', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'woman firefighter: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F692}', shortName:'woman_firefighter_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'firefighter', 'firetruck', 'woman', 'uc8', 'diversity', 'job', '911', 'help', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'man firefighter', char: '\u{1F468}\u{200D}\u{1F692}', shortName:'man_firefighter', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'man', 'uc6', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer']), Emoji(name: 'man firefighter: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F692}', shortName:'man_firefighter_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'light skin tone', 'man', 'uc8', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'man firefighter: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F692}', shortName:'man_firefighter_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'man firefighter: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F692}', shortName:'man_firefighter_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'man', 'medium skin tone', 'uc8', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'man firefighter: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F692}', shortName:'man_firefighter_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['firefighter', 'firetruck', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'man firefighter: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F692}', shortName:'man_firefighter_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'firefighter', 'firetruck', 'man', 'uc8', 'diversity', 'job', '911', 'help', 'handsome', 'fires', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'emergency', 'injury', 'stud', 'fuego', 'feu', 'fuoco', 'feuer'], modifiable: true), Emoji(name: 'pilot', char: '\u{1F9D1}\u{200D}\u{2708}\u{FE0F}', shortName:'pilot', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud']), Emoji(name: 'pilot: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2708}\u{FE0F}', shortName:'pilot_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'pilot: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2708}\u{FE0F}', shortName:'pilot_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'pilot: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2708}\u{FE0F}', shortName:'pilot_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'pilot: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2708}\u{FE0F}', shortName:'pilot_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'pilot: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2708}\u{FE0F}', shortName:'pilot_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'woman pilot', char: '\u{1F469}\u{200D}\u{2708}\u{FE0F}', shortName:'woman_pilot', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['pilot', 'plane', 'woman', 'uc6', 'diversity', 'fly', 'job', 'airplane', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport']), Emoji(name: 'woman pilot: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2708}\u{FE0F}', shortName:'woman_pilot_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'pilot', 'plane', 'woman', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport'], modifiable: true), Emoji(name: 'woman pilot: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{2708}\u{FE0F}', shortName:'woman_pilot_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-light skin tone', 'pilot', 'plane', 'woman', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport'], modifiable: true), Emoji(name: 'woman pilot: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{2708}\u{FE0F}', shortName:'woman_pilot_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium skin tone', 'pilot', 'plane', 'woman', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport'], modifiable: true), Emoji(name: 'woman pilot: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{2708}\u{FE0F}', shortName:'woman_pilot_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-dark skin tone', 'pilot', 'plane', 'woman', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport'], modifiable: true), Emoji(name: 'woman pilot: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{2708}\u{FE0F}', shortName:'woman_pilot_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'pilot', 'plane', 'woman', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport'], modifiable: true), Emoji(name: 'man pilot', char: '\u{1F468}\u{200D}\u{2708}\u{FE0F}', shortName:'man_pilot', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'pilot', 'plane', 'uc6', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud']), Emoji(name: 'man pilot: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{2708}\u{FE0F}', shortName:'man_pilot_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'man', 'pilot', 'plane', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'man pilot: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{2708}\u{FE0F}', shortName:'man_pilot_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'medium-light skin tone', 'pilot', 'plane', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'man pilot: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{2708}\u{FE0F}', shortName:'man_pilot_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'medium skin tone', 'pilot', 'plane', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'man pilot: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{2708}\u{FE0F}', shortName:'man_pilot_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['man', 'medium-dark skin tone', 'pilot', 'plane', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'man pilot: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{2708}\u{FE0F}', shortName:'man_pilot_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'man', 'pilot', 'plane', 'uc8', 'diversity', 'fly', 'job', 'airplane', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'flight', 'flying', 'flights', 'avion', 'profession', 'boss', 'career', 'airline', 'aircraft', 'airforce', 'air force', 'airport', 'stud'], modifiable: true), Emoji(name: 'astronaut', char: '\u{1F9D1}\u{200D}\u{1F680}', shortName:'astronaut', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career']), Emoji(name: 'astronaut: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F680}', shortName:'astronaut_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'astronaut: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F680}', shortName:'astronaut_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'astronaut: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F680}', shortName:'astronaut_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'astronaut: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F680}', shortName:'astronaut_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'astronaut: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F680}', shortName:'astronaut_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman astronaut', char: '\u{1F469}\u{200D}\u{1F680}', shortName:'woman_astronaut', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'rocket', 'woman', 'uc6', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career']), Emoji(name: 'woman astronaut: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F680}', shortName:'woman_astronaut_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'light skin tone', 'rocket', 'woman', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman astronaut: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F680}', shortName:'woman_astronaut_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'medium-light skin tone', 'rocket', 'woman', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman astronaut: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F680}', shortName:'woman_astronaut_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'medium skin tone', 'rocket', 'woman', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman astronaut: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F680}', shortName:'woman_astronaut_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'medium-dark skin tone', 'rocket', 'woman', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'woman astronaut: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F680}', shortName:'woman_astronaut_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'dark skin tone', 'rocket', 'woman', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man astronaut', char: '\u{1F468}\u{200D}\u{1F680}', shortName:'man_astronaut', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'man', 'rocket', 'uc6', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career']), Emoji(name: 'man astronaut: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F680}', shortName:'man_astronaut_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'light skin tone', 'man', 'rocket', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man astronaut: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F680}', shortName:'man_astronaut_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'man', 'medium-light skin tone', 'rocket', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man astronaut: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F680}', shortName:'man_astronaut_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'man', 'medium skin tone', 'rocket', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man astronaut: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F680}', shortName:'man_astronaut_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'man', 'medium-dark skin tone', 'rocket', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'man astronaut: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F680}', shortName:'man_astronaut_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['astronaut', 'dark skin tone', 'man', 'rocket', 'uc8', 'diversity', 'space', 'job', 'helmet', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'outer space', 'galaxy', 'universe', 'nasa', 'spaceship', 'profession', 'boss', 'career'], modifiable: true), Emoji(name: 'judge', char: '\u{1F9D1}\u{200D}\u{2696}\u{FE0F}', shortName:'judge', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt']), Emoji(name: 'judge: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2696}\u{FE0F}', shortName:'judge_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'judge: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2696}\u{FE0F}', shortName:'judge_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'judge: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2696}\u{FE0F}', shortName:'judge_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'judge: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2696}\u{FE0F}', shortName:'judge_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'judge: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2696}\u{FE0F}', shortName:'judge_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc12', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'woman judge', char: '\u{1F469}\u{200D}\u{2696}\u{FE0F}', shortName:'woman_judge', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['judge', 'scales', 'woman', 'uc6', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt']), Emoji(name: 'woman judge: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2696}\u{FE0F}', shortName:'woman_judge_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['judge', 'light skin tone', 'scales', 'woman', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'woman judge: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{2696}\u{FE0F}', shortName:'woman_judge_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['judge', 'medium-light skin tone', 'scales', 'woman', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'woman judge: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{2696}\u{FE0F}', shortName:'woman_judge_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['judge', 'medium skin tone', 'scales', 'woman', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'woman judge: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{2696}\u{FE0F}', shortName:'woman_judge_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['judge', 'medium-dark skin tone', 'scales', 'woman', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'woman judge: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{2696}\u{FE0F}', shortName:'woman_judge_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'judge', 'scales', 'woman', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'man judge', char: '\u{1F468}\u{200D}\u{2696}\u{FE0F}', shortName:'man_judge', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['justice', 'man', 'scales', 'uc6', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt']), Emoji(name: 'man judge: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{2696}\u{FE0F}', shortName:'man_judge_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['justice', 'light skin tone', 'man', 'scales', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'man judge: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{2696}\u{FE0F}', shortName:'man_judge_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['justice', 'man', 'medium-light skin tone', 'scales', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'man judge: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{2696}\u{FE0F}', shortName:'man_judge_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['justice', 'man', 'medium skin tone', 'scales', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'man judge: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{2696}\u{FE0F}', shortName:'man_judge_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['justice', 'man', 'medium-dark skin tone', 'scales', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'man judge: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{2696}\u{FE0F}', shortName:'man_judge_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'justice', 'man', 'scales', 'uc8', 'diversity', 'job', 'court', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'profession', 'boss', 'career', 'president', 'govt'], modifiable: true), Emoji(name: 'person with veil', char: '\u{1F470}', shortName:'person_with_veil', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'veil', 'wedding', 'uc6', 'diversity', 'wedding', 'women', 'beautiful', 'las vegas', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'vegas']), Emoji(name: 'person with veil: light skin tone', char: '\u{1F470}\u{1F3FB}', shortName:'person_with_veil_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'light skin tone', 'veil', 'wedding', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'las vegas', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'vegas'], modifiable: true), Emoji(name: 'person with veil: medium-light skin tone', char: '\u{1F470}\u{1F3FC}', shortName:'person_with_veil_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'medium-light skin tone', 'veil', 'wedding', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'las vegas', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'vegas'], modifiable: true), Emoji(name: 'person with veil: medium skin tone', char: '\u{1F470}\u{1F3FD}', shortName:'person_with_veil_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'medium skin tone', 'veil', 'wedding', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'las vegas', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'vegas'], modifiable: true), Emoji(name: 'person with veil: medium-dark skin tone', char: '\u{1F470}\u{1F3FE}', shortName:'person_with_veil_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'medium-dark skin tone', 'veil', 'wedding', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'las vegas', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'vegas'], modifiable: true), Emoji(name: 'person with veil: dark skin tone', char: '\u{1F470}\u{1F3FF}', shortName:'person_with_veil_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'dark skin tone', 'veil', 'wedding', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'las vegas', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'vegas'], modifiable: true), Emoji(name: 'woman with veil', char: '\u{1F470}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_with_veil', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'beautiful', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely']), Emoji(name: 'woman with veil: light skin tone', char: '\u{1F470}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_with_veil_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'beautiful', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'woman with veil: medium-light skin tone', char: '\u{1F470}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_with_veil_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'beautiful', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'woman with veil: medium skin tone', char: '\u{1F470}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_with_veil_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'beautiful', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'woman with veil: medium-dark skin tone', char: '\u{1F470}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_with_veil_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'beautiful', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'woman with veil: dark skin tone', char: '\u{1F470}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_with_veil_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'beautiful', 'wife', 'dress', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely'], modifiable: true), Emoji(name: 'man with veil', char: '\u{1F470}\u{200D}\u{2642}\u{FE0F}', shortName:'man_with_veil', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'wife', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry']), Emoji(name: 'man with veil: light skin tone', char: '\u{1F470}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_with_veil_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'wife', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry'], modifiable: true), Emoji(name: 'man with veil: medium-light skin tone', char: '\u{1F470}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_with_veil_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'wife', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry'], modifiable: true), Emoji(name: 'man with veil: medium skin tone', char: '\u{1F470}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_with_veil_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'wife', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry'], modifiable: true), Emoji(name: 'man with veil: medium-dark skin tone', char: '\u{1F470}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_with_veil_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'wife', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry'], modifiable: true), Emoji(name: 'man with veil: dark skin tone', char: '\u{1F470}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_with_veil_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'wife', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry'], modifiable: true), Emoji(name: 'person in tuxedo', char: '\u{1F935}', shortName:'person_in_tuxedo', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'tuxedo', 'uc9', 'diversity', 'wedding', 'men', 'donald trump', 'fame', 'vampire', 'las vegas', 'rich', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'trump', 'famous', 'celebrity', 'dracula', 'vegas', 'grand', 'expensive', 'fancy', 'veste', 'stud', 'president', 'govt']), Emoji(name: 'person in tuxedo: light skin tone', char: '\u{1F935}\u{1F3FB}', shortName:'person_in_tuxedo_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'person', 'tuxedo', 'uc9', 'diversity', 'wedding', 'men', 'donald trump', 'fame', 'vampire', 'las vegas', 'rich', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'trump', 'famous', 'celebrity', 'dracula', 'vegas', 'grand', 'expensive', 'fancy', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'person in tuxedo: medium-light skin tone', char: '\u{1F935}\u{1F3FC}', shortName:'person_in_tuxedo_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'medium-light skin tone', 'tuxedo', 'uc9', 'diversity', 'wedding', 'men', 'donald trump', 'fame', 'vampire', 'las vegas', 'rich', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'trump', 'famous', 'celebrity', 'dracula', 'vegas', 'grand', 'expensive', 'fancy', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'person in tuxedo: medium skin tone', char: '\u{1F935}\u{1F3FD}', shortName:'person_in_tuxedo_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'medium skin tone', 'tuxedo', 'uc9', 'diversity', 'wedding', 'men', 'donald trump', 'fame', 'vampire', 'las vegas', 'rich', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'trump', 'famous', 'celebrity', 'dracula', 'vegas', 'grand', 'expensive', 'fancy', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'person in tuxedo: medium-dark skin tone', char: '\u{1F935}\u{1F3FE}', shortName:'person_in_tuxedo_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['person', 'medium-dark skin tone', 'tuxedo', 'uc9', 'diversity', 'wedding', 'men', 'donald trump', 'fame', 'vampire', 'las vegas', 'rich', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'trump', 'famous', 'celebrity', 'dracula', 'vegas', 'grand', 'expensive', 'fancy', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'person in tuxedo: dark skin tone', char: '\u{1F935}\u{1F3FF}', shortName:'person_in_tuxedo_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'person', 'tuxedo', 'uc9', 'diversity', 'wedding', 'men', 'donald trump', 'fame', 'vampire', 'las vegas', 'rich', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'trump', 'famous', 'celebrity', 'dracula', 'vegas', 'grand', 'expensive', 'fancy', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'woman in tuxedo', char: '\u{1F935}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_tuxedo', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'fame', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'famous', 'celebrity', 'president', 'govt']), Emoji(name: 'woman in tuxedo: light skin tone', char: '\u{1F935}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_tuxedo_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'fame', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'famous', 'celebrity', 'president', 'govt'], modifiable: true), Emoji(name: 'woman in tuxedo: medium-light skin tone', char: '\u{1F935}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_tuxedo_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'fame', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'famous', 'celebrity', 'president', 'govt'], modifiable: true), Emoji(name: 'woman in tuxedo: medium skin tone', char: '\u{1F935}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_tuxedo_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'fame', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'famous', 'celebrity', 'president', 'govt'], modifiable: true), Emoji(name: 'woman in tuxedo: medium-dark skin tone', char: '\u{1F935}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_tuxedo_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'fame', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'famous', 'celebrity', 'president', 'govt'], modifiable: true), Emoji(name: 'woman in tuxedo: dark skin tone', char: '\u{1F935}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_tuxedo_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'fame', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'famous', 'celebrity', 'president', 'govt'], modifiable: true), Emoji(name: 'man in tuxedo', char: '\u{1F935}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_tuxedo', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'men', 'fame', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'famous', 'celebrity', 'veste', 'stud', 'president', 'govt']), Emoji(name: 'man in tuxedo: light skin tone', char: '\u{1F935}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_tuxedo_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'men', 'fame', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'famous', 'celebrity', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'man in tuxedo: medium-light skin tone', char: '\u{1F935}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_tuxedo_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'men', 'fame', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'famous', 'celebrity', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'man in tuxedo: medium skin tone', char: '\u{1F935}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_tuxedo_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'men', 'fame', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'famous', 'celebrity', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'man in tuxedo: medium-dark skin tone', char: '\u{1F935}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_tuxedo_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'men', 'fame', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'famous', 'celebrity', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'man in tuxedo: dark skin tone', char: '\u{1F935}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_tuxedo_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'wedding', 'men', 'fame', 'jacket', 'handsome', 'costume', 'husband', 'government', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'man', 'guy', 'guys', 'gentleman', 'male', 'famous', 'celebrity', 'veste', 'stud', 'president', 'govt'], modifiable: true), Emoji(name: 'princess', char: '\u{1F478}', shortName:'princess', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['fairy tale', 'fantasy', 'uc6', 'diversity', 'wedding', 'women', 'beautiful', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'dress', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy']), Emoji(name: 'princess: light skin tone', char: '\u{1F478}\u{1F3FB}', shortName:'princess_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['fairy tale', 'fantasy', 'light skin tone', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'dress', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy'], modifiable: true), Emoji(name: 'princess: medium-light skin tone', char: '\u{1F478}\u{1F3FC}', shortName:'princess_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['fairy tale', 'fantasy', 'medium-light skin tone', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'dress', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy'], modifiable: true), Emoji(name: 'princess: medium skin tone', char: '\u{1F478}\u{1F3FD}', shortName:'princess_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['fairy tale', 'fantasy', 'medium skin tone', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'dress', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy'], modifiable: true), Emoji(name: 'princess: medium-dark skin tone', char: '\u{1F478}\u{1F3FE}', shortName:'princess_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['fairy tale', 'fantasy', 'medium-dark skin tone', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'dress', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy'], modifiable: true), Emoji(name: 'princess: dark skin tone', char: '\u{1F478}\u{1F3FF}', shortName:'princess_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'fairy tale', 'fantasy', 'uc8', 'diversity', 'wedding', 'women', 'beautiful', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'dress', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'woman', 'female', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy'], modifiable: true), Emoji(name: 'prince', char: '\u{1F934}', shortName:'prince', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['prince', 'uc9', 'diversity', 'men', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy', 'stud']), Emoji(name: 'prince: light skin tone', char: '\u{1F934}\u{1F3FB}', shortName:'prince_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'prince', 'uc9', 'diversity', 'men', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy', 'stud'], modifiable: true), Emoji(name: 'prince: medium-light skin tone', char: '\u{1F934}\u{1F3FC}', shortName:'prince_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-light skin tone', 'prince', 'uc9', 'diversity', 'men', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy', 'stud'], modifiable: true), Emoji(name: 'prince: medium skin tone', char: '\u{1F934}\u{1F3FD}', shortName:'prince_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium skin tone', 'prince', 'uc9', 'diversity', 'men', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy', 'stud'], modifiable: true), Emoji(name: 'prince: medium-dark skin tone', char: '\u{1F934}\u{1F3FE}', shortName:'prince_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-dark skin tone', 'prince', 'uc9', 'diversity', 'men', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy', 'stud'], modifiable: true), Emoji(name: 'prince: dark skin tone', char: '\u{1F934}\u{1F3FF}', shortName:'prince_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'prince', 'uc9', 'diversity', 'men', 'power', 'queen', 'disney', 'bling', 'fame', 'crown', 'rich', 'handsome', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'king', 'prince', 'princess', 'cartoon', 'jewels', 'gems', 'jewel', 'jewelry', 'treasure', 'famous', 'celebrity', 'tiara', 'grand', 'expensive', 'fancy', 'stud'], modifiable: true), Emoji(name: 'superhero', char: '\u{1F9B8}', shortName:'superhero', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman']), Emoji(name: 'superhero: light skin tone', char: '\u{1F9B8}\u{1F3FB}', shortName:'superhero_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'superhero: medium-light skin tone', char: '\u{1F9B8}\u{1F3FC}', shortName:'superhero_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'superhero: medium skin tone', char: '\u{1F9B8}\u{1F3FD}', shortName:'superhero_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'superhero: medium-dark skin tone', char: '\u{1F9B8}\u{1F3FE}', shortName:'superhero_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'superhero: dark skin tone', char: '\u{1F9B8}\u{1F3FF}', shortName:'superhero_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'woman superhero', char: '\u{1F9B8}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_superhero', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', '911', 'power', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'mom', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'emergency', 'injury', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman superhero: light skin tone', char: '\u{1F9B8}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_superhero_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', '911', 'power', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'mom', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'emergency', 'injury', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman superhero: medium-light skin tone', char: '\u{1F9B8}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_superhero_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', '911', 'power', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'mom', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'emergency', 'injury', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman superhero: medium skin tone', char: '\u{1F9B8}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_superhero_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', '911', 'power', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'mom', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'emergency', 'injury', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman superhero: medium-dark skin tone', char: '\u{1F9B8}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_superhero_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', '911', 'power', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'mom', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'emergency', 'injury', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman superhero: dark skin tone', char: '\u{1F9B8}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_superhero_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', '911', 'power', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'mom', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'emergency', 'injury', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man superhero', char: '\u{1F9B8}\u{200D}\u{2642}\u{FE0F}', shortName:'man_superhero', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman']), Emoji(name: 'man superhero: light skin tone', char: '\u{1F9B8}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_superhero_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'man superhero: medium-light skin tone', char: '\u{1F9B8}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_superhero_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'man superhero: medium skin tone', char: '\u{1F9B8}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_superhero_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'man superhero: medium-dark skin tone', char: '\u{1F9B8}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_superhero_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'man superhero: dark skin tone', char: '\u{1F9B8}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_superhero_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'peace', 'men', '911', 'power', 'daddy', 'fame', 'help', 'super hero', 'costume', 'mask', 'fantasy', 'proud', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'peace out', 'peace sign', 'man', 'guy', 'guys', 'gentleman', 'male', 'emergency', 'injury', 'dad', 'papa', 'pere', 'father', 'famous', 'celebrity', 'superhero', 'superman', 'batman'], modifiable: true), Emoji(name: 'supervillain', char: '\u{1F9B9}', shortName:'supervillain', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish']), Emoji(name: 'supervillain: light skin tone', char: '\u{1F9B9}\u{1F3FB}', shortName:'supervillain_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'supervillain: medium-light skin tone', char: '\u{1F9B9}\u{1F3FC}', shortName:'supervillain_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'supervillain: medium skin tone', char: '\u{1F9B9}\u{1F3FD}', shortName:'supervillain_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'supervillain: medium-dark skin tone', char: '\u{1F9B9}\u{1F3FE}', shortName:'supervillain_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'supervillain: dark skin tone', char: '\u{1F9B9}\u{1F3FF}', shortName:'supervillain_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'woman supervillain', char: '\u{1F9B9}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_supervillain', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish']), Emoji(name: 'woman supervillain: light skin tone', char: '\u{1F9B9}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_supervillain_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'woman supervillain: medium-light skin tone', char: '\u{1F9B9}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_supervillain_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'woman supervillain: medium skin tone', char: '\u{1F9B9}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_supervillain_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'woman supervillain: medium-dark skin tone', char: '\u{1F9B9}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_supervillain_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'woman supervillain: dark skin tone', char: '\u{1F9B9}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_supervillain_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'man supervillain', char: '\u{1F9B9}\u{200D}\u{2642}\u{FE0F}', shortName:'man_supervillain', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish']), Emoji(name: 'man supervillain: light skin tone', char: '\u{1F9B9}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_supervillain_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'man supervillain: medium-light skin tone', char: '\u{1F9B9}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_supervillain_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'man supervillain: medium skin tone', char: '\u{1F9B9}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_supervillain_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'man supervillain: medium-dark skin tone', char: '\u{1F9B9}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_supervillain_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'man supervillain: dark skin tone', char: '\u{1F9B9}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_supervillain_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc11', 'diversity', 'men', 'power', 'evil', 'fame', 'guilty', 'super hero', 'killer', 'costume', 'mask', 'fantasy', 'proud', 'greed', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'famous', 'celebrity', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'selfish'], modifiable: true), Emoji(name: 'ninja', char: '\u{1F977}', shortName:'ninja', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'japan', 'evil', 'chinese', 'super hero', 'killer', 'mask', 'disguise', 'shinobi', 'diverse', 'modifier', 'modifiers', 'equality', 'japanese', 'ninja', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'chinois', 'asian', 'chine', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'samurai']), Emoji(name: 'ninja: light skin tone', char: '\u{1F977}\u{1F3FB}', shortName:'ninja_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'japan', 'evil', 'chinese', 'super hero', 'killer', 'mask', 'disguise', 'shinobi', 'diverse', 'modifier', 'modifiers', 'equality', 'japanese', 'ninja', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'chinois', 'asian', 'chine', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'samurai'], modifiable: true), Emoji(name: 'ninja: medium-light skin tone', char: '\u{1F977}\u{1F3FC}', shortName:'ninja_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'japan', 'evil', 'chinese', 'super hero', 'killer', 'mask', 'disguise', 'shinobi', 'diverse', 'modifier', 'modifiers', 'equality', 'japanese', 'ninja', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'chinois', 'asian', 'chine', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'samurai'], modifiable: true), Emoji(name: 'ninja: medium skin tone', char: '\u{1F977}\u{1F3FD}', shortName:'ninja_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'japan', 'evil', 'chinese', 'super hero', 'killer', 'mask', 'disguise', 'shinobi', 'diverse', 'modifier', 'modifiers', 'equality', 'japanese', 'ninja', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'chinois', 'asian', 'chine', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'samurai'], modifiable: true), Emoji(name: 'ninja: medium-dark skin tone', char: '\u{1F977}\u{1F3FE}', shortName:'ninja_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'japan', 'evil', 'chinese', 'super hero', 'killer', 'mask', 'disguise', 'shinobi', 'diverse', 'modifier', 'modifiers', 'equality', 'japanese', 'ninja', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'chinois', 'asian', 'chine', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'samurai'], modifiable: true), Emoji(name: 'ninja: dark skin tone', char: '\u{1F977}\u{1F3FF}', shortName:'ninja_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'diversity', 'japan', 'evil', 'chinese', 'super hero', 'killer', 'mask', 'disguise', 'shinobi', 'diverse', 'modifier', 'modifiers', 'equality', 'japanese', 'ninja', 'imp', 'demon', 'devil', 'naughty', 'devilish', 'diablo', 'diable', 'satan', 'chinois', 'asian', 'chine', 'superhero', 'superman', 'batman', 'savage', 'scary clown', 'samurai'], modifiable: true), Emoji(name: 'mx claus', char: '\u{1F9D1}\u{200D}\u{1F384}', shortName:'mx_claus', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc13', 'holidays', 'diversity', 'winter', 'christmas', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas']), Emoji(name: 'mx claus: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F384}', shortName:'mx_claus_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc13', 'holidays', 'diversity', 'winter', 'christmas', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas'], modifiable: true), Emoji(name: 'mx claus: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F384}', shortName:'mx_claus_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc13', 'holidays', 'diversity', 'winter', 'christmas', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas'], modifiable: true), Emoji(name: 'mx claus: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F384}', shortName:'mx_claus_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc13', 'holidays', 'diversity', 'winter', 'christmas', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas'], modifiable: true), Emoji(name: 'mx claus: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F384}', shortName:'mx_claus_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc13', 'holidays', 'diversity', 'winter', 'christmas', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas'], modifiable: true), Emoji(name: 'mx claus: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F384}', shortName:'mx_claus_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc13', 'holidays', 'diversity', 'winter', 'christmas', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas'], modifiable: true), Emoji(name: 'Mrs. Claus', char: '\u{1F936}', shortName:'mrs_claus', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'Mrs.', 'celebration', 'claus', 'mother', 'uc9', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus']), Emoji(name: 'Mrs. Claus: light skin tone', char: '\u{1F936}\u{1F3FB}', shortName:'mrs_claus_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'Mrs.', 'celebration', 'claus', 'light skin tone', 'mother', 'uc9', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Mrs. Claus: medium-light skin tone', char: '\u{1F936}\u{1F3FC}', shortName:'mrs_claus_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-light skin tone', 'mother', 'uc9', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Mrs. Claus: medium skin tone', char: '\u{1F936}\u{1F3FD}', shortName:'mrs_claus_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium skin tone', 'mother', 'uc9', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Mrs. Claus: medium-dark skin tone', char: '\u{1F936}\u{1F3FE}', shortName:'mrs_claus_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-dark skin tone', 'mother', 'uc9', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Mrs. Claus: dark skin tone', char: '\u{1F936}\u{1F3FF}', shortName:'mrs_claus_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'Mrs.', 'celebration', 'claus', 'dark skin tone', 'mother', 'uc9', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'advent', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Santa Claus', char: '\u{1F385}', shortName:'santa', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'celebration', 'claus', 'father', 'santa', 'uc6', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'mustache', 'advent', 'beard', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus']), Emoji(name: 'Santa Claus: light skin tone', char: '\u{1F385}\u{1F3FB}', shortName:'santa_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'celebration', 'claus', 'father', 'light skin tone', 'santa', 'uc8', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'mustache', 'advent', 'beard', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Santa Claus: medium-light skin tone', char: '\u{1F385}\u{1F3FC}', shortName:'santa_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'celebration', 'claus', 'father', 'medium-light skin tone', 'santa', 'uc8', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'mustache', 'advent', 'beard', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Santa Claus: medium skin tone', char: '\u{1F385}\u{1F3FD}', shortName:'santa_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'celebration', 'claus', 'father', 'medium skin tone', 'santa', 'uc8', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'mustache', 'advent', 'beard', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Santa Claus: medium-dark skin tone', char: '\u{1F385}\u{1F3FE}', shortName:'santa_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'celebration', 'claus', 'father', 'medium-dark skin tone', 'santa', 'uc8', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'mustache', 'advent', 'beard', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'Santa Claus: dark skin tone', char: '\u{1F385}\u{1F3FF}', shortName:'santa_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Christmas', 'celebration', 'claus', 'dark skin tone', 'father', 'santa', 'uc8', 'holidays', 'diversity', 'winter', 'christmas', 'santa', 'mustache', 'advent', 'beard', 'fantasy', 'disguise', 'holiday', 'diverse', 'modifier', 'modifiers', 'equality', 'hiver', 'navidad', 'xmas', 'noel', 'merry christmas', 'santa clause', 'santa claus'], modifiable: true), Emoji(name: 'mage', char: '\u{1F9D9}', shortName:'mage', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['sorcerer', 'sorceress', 'witch', 'wizard', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch']), Emoji(name: 'mage: light skin tone', char: '\u{1F9D9}\u{1F3FB}', shortName:'mage_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'mage: medium-light skin tone', char: '\u{1F9D9}\u{1F3FC}', shortName:'mage_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'mage: medium skin tone', char: '\u{1F9D9}\u{1F3FD}', shortName:'mage_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'mage: medium-dark skin tone', char: '\u{1F9D9}\u{1F3FE}', shortName:'mage_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'mage: dark skin tone', char: '\u{1F9D9}\u{1F3FF}', shortName:'mage_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'woman mage', char: '\u{1F9D9}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_mage', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['sorceress', 'witch', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'snow white', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch']), Emoji(name: 'woman mage: light skin tone', char: '\u{1F9D9}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_mage_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'sorceress', 'witch', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'snow white', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'woman mage: medium-light skin tone', char: '\u{1F9D9}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_mage_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-light skin tone', 'sorceress', 'witch', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'snow white', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'woman mage: medium skin tone', char: '\u{1F9D9}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_mage_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium skin tone', 'sorceress', 'witch', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'snow white', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'woman mage: medium-dark skin tone', char: '\u{1F9D9}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_mage_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-dark skin tone', 'sorceress', 'witch', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'snow white', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'woman mage: dark skin tone', char: '\u{1F9D9}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_mage_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'sorceress', 'witch', 'uc10', 'diversity', 'magic', 'wizard', 'fantasy', 'disguise', 'snow white', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'man mage', char: '\u{1F9D9}\u{200D}\u{2642}\u{FE0F}', shortName:'man_mage', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['sorcerer', 'wizard', 'uc10', 'diversity', 'magic', 'beard', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch']), Emoji(name: 'man mage: light skin tone', char: '\u{1F9D9}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_mage_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'sorcerer', 'wizard', 'uc10', 'diversity', 'magic', 'beard', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'man mage: medium-light skin tone', char: '\u{1F9D9}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_mage_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-light skin tone', 'sorcerer', 'wizard', 'uc10', 'diversity', 'magic', 'beard', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'man mage: medium skin tone', char: '\u{1F9D9}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_mage_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium skin tone', 'sorcerer', 'wizard', 'uc10', 'diversity', 'magic', 'beard', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'man mage: medium-dark skin tone', char: '\u{1F9D9}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_mage_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-dark skin tone', 'sorcerer', 'wizard', 'uc10', 'diversity', 'magic', 'beard', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'man mage: dark skin tone', char: '\u{1F9D9}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_mage_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'sorcerer', 'wizard', 'uc10', 'diversity', 'magic', 'beard', 'wizard', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical', 'Sorcerer', 'Sorceress', 'witch'], modifiable: true), Emoji(name: 'elf', char: '\u{1F9DD}', shortName:'elf', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical']), Emoji(name: 'elf: light skin tone', char: '\u{1F9DD}\u{1F3FB}', shortName:'elf_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'elf: medium-light skin tone', char: '\u{1F9DD}\u{1F3FC}', shortName:'elf_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium-light skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'elf: medium skin tone', char: '\u{1F9DD}\u{1F3FD}', shortName:'elf_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'elf: medium-dark skin tone', char: '\u{1F9DD}\u{1F3FE}', shortName:'elf_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium-dark skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'elf: dark skin tone', char: '\u{1F9DD}\u{1F3FF}', shortName:'elf_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'woman elf', char: '\u{1F9DD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_elf', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical']), Emoji(name: 'woman elf: light skin tone', char: '\u{1F9DD}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_elf_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'woman elf: medium-light skin tone', char: '\u{1F9DD}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_elf_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium-light skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'woman elf: medium skin tone', char: '\u{1F9DD}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_elf_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'woman elf: medium-dark skin tone', char: '\u{1F9DD}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_elf_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium-dark skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'woman elf: dark skin tone', char: '\u{1F9DD}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_elf_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man elf', char: '\u{1F9DD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_elf', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical']), Emoji(name: 'man elf: light skin tone', char: '\u{1F9DD}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_elf_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man elf: medium-light skin tone', char: '\u{1F9DD}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_elf_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium-light skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man elf: medium skin tone', char: '\u{1F9DD}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_elf_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man elf: medium-dark skin tone', char: '\u{1F9DD}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_elf_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['magical', 'medium-dark skin tone', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man elf: dark skin tone', char: '\u{1F9DD}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_elf_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'magical', 'uc10', 'diversity', 'christmas', 'magic', 'legolas', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'navidad', 'xmas', 'noel', 'merry christmas', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'vampire', char: '\u{1F9DB}', shortName:'vampire', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula']), Emoji(name: 'vampire: light skin tone', char: '\u{1F9DB}\u{1F3FB}', shortName:'vampire_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'light skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'vampire: medium-light skin tone', char: '\u{1F9DB}\u{1F3FC}', shortName:'vampire_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'medium-light skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'vampire: medium skin tone', char: '\u{1F9DB}\u{1F3FD}', shortName:'vampire_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'medium skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'vampire: medium-dark skin tone', char: '\u{1F9DB}\u{1F3FE}', shortName:'vampire_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'medium-dark skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'vampire: dark skin tone', char: '\u{1F9DB}\u{1F3FF}', shortName:'vampire_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'dark skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'woman vampire', char: '\u{1F9DB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_vampire', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula']), Emoji(name: 'woman vampire: light skin tone', char: '\u{1F9DB}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_vampire_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'woman vampire: medium-light skin tone', char: '\u{1F9DB}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_vampire_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-light skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'woman vampire: medium skin tone', char: '\u{1F9DB}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_vampire_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'woman vampire: medium-dark skin tone', char: '\u{1F9DB}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_vampire_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-dark skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'woman vampire: dark skin tone', char: '\u{1F9DB}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_vampire_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'man vampire', char: '\u{1F9DB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_vampire', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula']), Emoji(name: 'man vampire: light skin tone', char: '\u{1F9DB}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_vampire_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'light skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'man vampire: medium-light skin tone', char: '\u{1F9DB}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_vampire_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'medium-light skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'man vampire: medium skin tone', char: '\u{1F9DB}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_vampire_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'medium skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'man vampire: medium-dark skin tone', char: '\u{1F9DB}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_vampire_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'medium-dark skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'man vampire: dark skin tone', char: '\u{1F9DB}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_vampire_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Dracula', 'dark skin tone', 'undead', 'uc10', 'diversity', 'vampire', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'dracula'], modifiable: true), Emoji(name: 'zombie', char: '\u{1F9DF}', shortName:'zombie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc10', 'diversity', 'halloween', 'monster', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'samhain', 'trick or treat', 'monsters', 'beast']), Emoji(name: 'woman zombie', char: '\u{1F9DF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_zombie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['undead', 'walking dead', 'uc10', 'halloween', 'monster', 'fantasy', 'disguise', 'samhain', 'trick or treat', 'monsters', 'beast']), Emoji(name: 'man zombie', char: '\u{1F9DF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_zombie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['undead', 'walking dead', 'uc10', 'halloween', 'monster', 'fantasy', 'disguise', 'samhain', 'trick or treat', 'monsters', 'beast']), Emoji(name: 'genie', char: '\u{1F9DE}', shortName:'genie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['uc10', 'magic', 'djinni', 'fantasy', 'disguise', 'spell', 'genie', 'magical', 'jinni']), Emoji(name: 'woman genie', char: '\u{1F9DE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_genie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['djinn', 'uc10', 'magic', 'djinni', 'fantasy', 'disguise', 'spell', 'genie', 'magical', 'jinni']), Emoji(name: 'man genie', char: '\u{1F9DE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_genie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['djinn', 'uc10', 'magic', 'disney', 'djinni', 'fantasy', 'disguise', 'spell', 'genie', 'magical', 'cartoon', 'jinni']), Emoji(name: 'merperson', char: '\u{1F9DC}', shortName:'merperson', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['mermaid', 'merman', 'merwoman', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren']), Emoji(name: 'merperson: light skin tone', char: '\u{1F9DC}\u{1F3FB}', shortName:'merperson_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'mermaid', 'merman', 'merwoman', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merperson: medium-light skin tone', char: '\u{1F9DC}\u{1F3FC}', shortName:'merperson_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-light skin tone', 'mermaid', 'merman', 'merwoman', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merperson: medium skin tone', char: '\u{1F9DC}\u{1F3FD}', shortName:'merperson_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium skin tone', 'mermaid', 'merman', 'merwoman', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merperson: medium-dark skin tone', char: '\u{1F9DC}\u{1F3FE}', shortName:'merperson_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-dark skin tone', 'mermaid', 'merman', 'merwoman', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merperson: dark skin tone', char: '\u{1F9DC}\u{1F3FF}', shortName:'merperson_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'mermaid', 'merman', 'merwoman', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'mermaid', char: '\u{1F9DC}\u{200D}\u{2640}\u{FE0F}', shortName:'mermaid', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['merwoman', 'uc10', 'diversity', 'disney', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cartoon', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren']), Emoji(name: 'mermaid: light skin tone', char: '\u{1F9DC}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'mermaid_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['light skin tone', 'merwoman', 'uc10', 'diversity', 'disney', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cartoon', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'mermaid: medium-light skin tone', char: '\u{1F9DC}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'mermaid_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-light skin tone', 'merwoman', 'uc10', 'diversity', 'disney', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cartoon', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'mermaid: medium skin tone', char: '\u{1F9DC}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'mermaid_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium skin tone', 'merwoman', 'uc10', 'diversity', 'disney', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cartoon', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'mermaid: medium-dark skin tone', char: '\u{1F9DC}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'mermaid_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['medium-dark skin tone', 'merwoman', 'uc10', 'diversity', 'disney', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cartoon', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'mermaid: dark skin tone', char: '\u{1F9DC}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'mermaid_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['dark skin tone', 'merwoman', 'uc10', 'diversity', 'disney', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cartoon', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merman', char: '\u{1F9DC}\u{200D}\u{2642}\u{FE0F}', shortName:'merman', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Triton', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren']), Emoji(name: 'merman: light skin tone', char: '\u{1F9DC}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'merman_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Triton', 'light skin tone', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merman: medium-light skin tone', char: '\u{1F9DC}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'merman_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Triton', 'medium-light skin tone', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merman: medium skin tone', char: '\u{1F9DC}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'merman_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Triton', 'medium skin tone', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merman: medium-dark skin tone', char: '\u{1F9DC}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'merman_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Triton', 'medium-dark skin tone', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'merman: dark skin tone', char: '\u{1F9DC}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'merman_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Triton', 'dark skin tone', 'uc10', 'diversity', 'mermaid', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'merboy', 'mergirl', 'merman', 'merperson', 'selkie', 'undine', 'atargatis', 'siren'], modifiable: true), Emoji(name: 'fairy', char: '\u{1F9DA}', shortName:'fairy', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'Titania', 'uc10', 'diversity', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical']), Emoji(name: 'fairy: light skin tone', char: '\u{1F9DA}\u{1F3FB}', shortName:'fairy_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'Titania', 'light skin tone', 'uc10', 'diversity', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'fairy: medium-light skin tone', char: '\u{1F9DA}\u{1F3FC}', shortName:'fairy_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'Titania', 'medium-light skin tone', 'uc10', 'diversity', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'fairy: medium skin tone', char: '\u{1F9DA}\u{1F3FD}', shortName:'fairy_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'Titania', 'medium skin tone', 'uc10', 'diversity', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'fairy: medium-dark skin tone', char: '\u{1F9DA}\u{1F3FE}', shortName:'fairy_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'Titania', 'medium-dark skin tone', 'uc10', 'diversity', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'fairy: dark skin tone', char: '\u{1F9DA}\u{1F3FF}', shortName:'fairy_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'Titania', 'dark skin tone', 'uc10', 'diversity', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'woman fairy', char: '\u{1F9DA}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_fairy', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Titania', 'uc10', 'diversity', 'beautiful', 'magic', 'disney', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical', 'cartoon']), Emoji(name: 'woman fairy: light skin tone', char: '\u{1F9DA}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_fairy_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Titania', 'light skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'disney', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical', 'cartoon'], modifiable: true), Emoji(name: 'woman fairy: medium-light skin tone', char: '\u{1F9DA}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_fairy_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Titania', 'medium-light skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'disney', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical', 'cartoon'], modifiable: true), Emoji(name: 'woman fairy: medium skin tone', char: '\u{1F9DA}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_fairy_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Titania', 'medium skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'disney', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical', 'cartoon'], modifiable: true), Emoji(name: 'woman fairy: medium-dark skin tone', char: '\u{1F9DA}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_fairy_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Titania', 'medium-dark skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'disney', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical', 'cartoon'], modifiable: true), Emoji(name: 'woman fairy: dark skin tone', char: '\u{1F9DA}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_fairy_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Titania', 'dark skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'disney', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical', 'cartoon'], modifiable: true), Emoji(name: 'man fairy', char: '\u{1F9DA}\u{200D}\u{2642}\u{FE0F}', shortName:'man_fairy', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'uc10', 'diversity', 'beautiful', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical']), Emoji(name: 'man fairy: light skin tone', char: '\u{1F9DA}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_fairy_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'light skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man fairy: medium-light skin tone', char: '\u{1F9DA}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_fairy_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'medium-light skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man fairy: medium skin tone', char: '\u{1F9DA}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_fairy_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'medium skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man fairy: medium-dark skin tone', char: '\u{1F9DA}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_fairy_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'medium-dark skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'man fairy: dark skin tone', char: '\u{1F9DA}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_fairy_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['Oberon', 'Puck', 'dark skin tone', 'uc10', 'diversity', 'beautiful', 'magic', 'fantasy', 'disguise', 'diverse', 'modifier', 'modifiers', 'equality', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'spell', 'genie', 'magical'], modifiable: true), Emoji(name: 'baby angel', char: '\u{1F47C}', shortName:'angel', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'uc6', 'diversity', 'baby', 'christmas', 'pray', 'omg', 'jesus', 'fantasy', 'child', 'soul', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'omfg', 'oh my god', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'baby angel: light skin tone', char: '\u{1F47C}\u{1F3FB}', shortName:'angel_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'light skin tone', 'uc8', 'diversity', 'baby', 'christmas', 'pray', 'omg', 'jesus', 'fantasy', 'child', 'soul', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'omfg', 'oh my god', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby angel: medium-light skin tone', char: '\u{1F47C}\u{1F3FC}', shortName:'angel_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-light skin tone', 'uc8', 'diversity', 'baby', 'christmas', 'pray', 'omg', 'jesus', 'fantasy', 'child', 'soul', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'omfg', 'oh my god', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby angel: medium skin tone', char: '\u{1F47C}\u{1F3FD}', shortName:'angel_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium skin tone', 'uc8', 'diversity', 'baby', 'christmas', 'pray', 'omg', 'jesus', 'fantasy', 'child', 'soul', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'omfg', 'oh my god', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby angel: medium-dark skin tone', char: '\u{1F47C}\u{1F3FE}', shortName:'angel_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-dark skin tone', 'uc8', 'diversity', 'baby', 'christmas', 'pray', 'omg', 'jesus', 'fantasy', 'child', 'soul', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'omfg', 'oh my god', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'baby angel: dark skin tone', char: '\u{1F47C}\u{1F3FF}', shortName:'angel_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personFantasy, keywords: ['angel', 'baby', 'dark skin tone', 'face', 'fairy tale', 'fantasy', 'uc8', 'diversity', 'baby', 'christmas', 'pray', 'omg', 'jesus', 'fantasy', 'child', 'soul', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'navidad', 'xmas', 'noel', 'merry christmas', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'omfg', 'oh my god', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'pregnant woman', char: '\u{1F930}', shortName:'pregnant_woman', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['pregnant', 'woman', 'uc9', 'diversity', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'pregnant woman: light skin tone', char: '\u{1F930}\u{1F3FB}', shortName:'pregnant_woman_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['light skin tone', 'pregnant', 'woman', 'uc9', 'diversity', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'pregnant woman: medium-light skin tone', char: '\u{1F930}\u{1F3FC}', shortName:'pregnant_woman_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-light skin tone', 'pregnant', 'woman', 'uc9', 'diversity', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'pregnant woman: medium skin tone', char: '\u{1F930}\u{1F3FD}', shortName:'pregnant_woman_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium skin tone', 'pregnant', 'woman', 'uc9', 'diversity', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'pregnant woman: medium-dark skin tone', char: '\u{1F930}\u{1F3FE}', shortName:'pregnant_woman_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['medium-dark skin tone', 'pregnant', 'woman', 'uc9', 'diversity', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'pregnant woman: dark skin tone', char: '\u{1F930}\u{1F3FF}', shortName:'pregnant_woman_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['dark skin tone', 'pregnant', 'woman', 'uc9', 'diversity', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'breast-feeding', char: '\u{1F931}', shortName:'breast_feeding', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['baby', 'breast', 'nursing', 'uc10', 'food', 'diversity', 'boobs', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'boob', 'tits', 'tit', 'breast', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'breast-feeding: light skin tone', char: '\u{1F931}\u{1F3FB}', shortName:'breast_feeding_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['baby', 'breast', 'light skin tone', 'nursing', 'uc10', 'food', 'diversity', 'boobs', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'boob', 'tits', 'tit', 'breast', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'breast-feeding: medium-light skin tone', char: '\u{1F931}\u{1F3FC}', shortName:'breast_feeding_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['baby', 'breast', 'medium-light skin tone', 'nursing', 'uc10', 'food', 'diversity', 'boobs', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'boob', 'tits', 'tit', 'breast', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'breast-feeding: medium skin tone', char: '\u{1F931}\u{1F3FD}', shortName:'breast_feeding_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['baby', 'breast', 'medium skin tone', 'nursing', 'uc10', 'food', 'diversity', 'boobs', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'boob', 'tits', 'tit', 'breast', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'breast-feeding: medium-dark skin tone', char: '\u{1F931}\u{1F3FE}', shortName:'breast_feeding_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['baby', 'breast', 'medium-dark skin tone', 'nursing', 'uc10', 'food', 'diversity', 'boobs', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'boob', 'tits', 'tit', 'breast', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'breast-feeding: dark skin tone', char: '\u{1F931}\u{1F3FF}', shortName:'breast_feeding_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['baby', 'breast', 'dark skin tone', 'nursing', 'uc10', 'food', 'diversity', 'boobs', 'women', 'baby', 'parent', 'wife', 'child', 'mom', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'boob', 'tits', 'tit', 'breast', 'woman', 'female', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person feeding baby', char: '\u{1F9D1}\u{200D}\u{1F37C}', shortName:'person_feeding_baby', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'wife', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'person feeding baby: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F37C}', shortName:'person_feeding_baby_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'wife', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'person feeding baby: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F37C}', shortName:'person_feeding_baby_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'wife', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'person feeding baby: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F37C}', shortName:'person_feeding_baby_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'wife', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'person feeding baby: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F37C}', shortName:'person_feeding_baby_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'wife', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'person feeding baby: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F37C}', shortName:'person_feeding_baby_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'wife', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'woman feeding baby', char: '\u{1F469}\u{200D}\u{1F37C}', shortName:'woman_feeding_baby', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'parent', 'wife', 'child', 'mom', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman feeding baby: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F37C}', shortName:'woman_feeding_baby_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'parent', 'wife', 'child', 'mom', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman feeding baby: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F37C}', shortName:'woman_feeding_baby_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'parent', 'wife', 'child', 'mom', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman feeding baby: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F37C}', shortName:'woman_feeding_baby_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'parent', 'wife', 'child', 'mom', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman feeding baby: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F37C}', shortName:'woman_feeding_baby_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'parent', 'wife', 'child', 'mom', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman feeding baby: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F37C}', shortName:'woman_feeding_baby_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'parent', 'wife', 'child', 'mom', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man feeding baby', char: '\u{1F468}\u{200D}\u{1F37C}', shortName:'man_feeding_baby', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant']), Emoji(name: 'man feeding baby: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F37C}', shortName:'man_feeding_baby_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'man feeding baby: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F37C}', shortName:'man_feeding_baby_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'man feeding baby: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F37C}', shortName:'man_feeding_baby_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'man feeding baby: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F37C}', shortName:'man_feeding_baby_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'man feeding baby: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F37C}', shortName:'man_feeding_baby_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personRole, keywords: ['uc13', 'food', 'diversity', 'baby', 'daddy', 'parent', 'child', 'formula', 'foods', 'eat', 'meal', 'comida', 'nourriture', 'eats', 'groceries', 'grocery', 'hungry', 'tasty', 'mmm', 'yummy', 'feed', 'hunger', 'diverse', 'modifier', 'modifiers', 'equality', 'kid', 'babies', 'infant', 'infants', 'crying kid', 'bebe', 'little', 'petite', 'bambino', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'children', 'girl', 'boy', 'kids', 'niño', 'enfant'], modifiable: true), Emoji(name: 'person bowing', char: '\u{1F647}', shortName:'person_bowing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bow', 'gesture', 'sorry', 'uc6', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'begging', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise']), Emoji(name: 'person bowing: light skin tone', char: '\u{1F647}\u{1F3FB}', shortName:'person_bowing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bow', 'gesture', 'light skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'begging', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'person bowing: medium-light skin tone', char: '\u{1F647}\u{1F3FC}', shortName:'person_bowing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bow', 'gesture', 'medium-light skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'begging', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'person bowing: medium skin tone', char: '\u{1F647}\u{1F3FD}', shortName:'person_bowing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bow', 'gesture', 'medium skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'begging', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'person bowing: medium-dark skin tone', char: '\u{1F647}\u{1F3FE}', shortName:'person_bowing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bow', 'gesture', 'medium-dark skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'begging', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'person bowing: dark skin tone', char: '\u{1F647}\u{1F3FF}', shortName:'person_bowing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bow', 'dark skin tone', 'gesture', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'begging', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'woman bowing', char: '\u{1F647}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_bowing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'sorry', 'woman', 'uc6', 'diversity', 'women', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise']), Emoji(name: 'woman bowing: light skin tone', char: '\u{1F647}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_bowing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'sorry', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'woman bowing: medium-light skin tone', char: '\u{1F647}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_bowing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'medium-light skin tone', 'sorry', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'woman bowing: medium skin tone', char: '\u{1F647}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_bowing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'medium skin tone', 'sorry', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'woman bowing: medium-dark skin tone', char: '\u{1F647}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_bowing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'medium-dark skin tone', 'sorry', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'woman bowing: dark skin tone', char: '\u{1F647}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_bowing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'sorry', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'man bowing', char: '\u{1F647}\u{200D}\u{2642}\u{FE0F}', shortName:'man_bowing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'man', 'sorry', 'uc6', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise']), Emoji(name: 'man bowing: light skin tone', char: '\u{1F647}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_bowing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'man', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'man bowing: medium-light skin tone', char: '\u{1F647}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_bowing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-light skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'man bowing: medium skin tone', char: '\u{1F647}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_bowing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'man bowing: medium-dark skin tone', char: '\u{1F647}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_bowing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-dark skin tone', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'man bowing: dark skin tone', char: '\u{1F647}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_bowing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'man', 'sorry', 'uc8', 'diversity', 'thank you', 'pray', 'jesus', 'yoga', 'fame', 'idea', 'hope', 'diverse', 'modifier', 'modifiers', 'equality', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'prayer', 'praying', 'prayers', 'grateful', 'heaven', 'bless', 'faith', 'holy', 'spirit', 'hopeful', 'blessed', 'preach', 'offering', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'famous', 'celebrity', 'swear', 'promise'], modifiable: true), Emoji(name: 'person tipping hand', char: '\u{1F481}', shortName:'person_tipping_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['hand', 'help', 'information', 'sassy', 'tipping', 'uc6', 'diversity', 'men', 'lipstick', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person tipping hand: light skin tone', char: '\u{1F481}\u{1F3FB}', shortName:'person_tipping_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['hand', 'help', 'information', 'light skin tone', 'sassy', 'tipping', 'uc8', 'diversity', 'men', 'lipstick', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person tipping hand: medium-light skin tone', char: '\u{1F481}\u{1F3FC}', shortName:'person_tipping_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['hand', 'help', 'information', 'medium-light skin tone', 'sassy', 'tipping', 'uc8', 'diversity', 'men', 'lipstick', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person tipping hand: medium skin tone', char: '\u{1F481}\u{1F3FD}', shortName:'person_tipping_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['hand', 'help', 'information', 'medium skin tone', 'sassy', 'tipping', 'uc8', 'diversity', 'men', 'lipstick', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person tipping hand: medium-dark skin tone', char: '\u{1F481}\u{1F3FE}', shortName:'person_tipping_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['hand', 'help', 'information', 'medium-dark skin tone', 'sassy', 'tipping', 'uc8', 'diversity', 'men', 'lipstick', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person tipping hand: dark skin tone', char: '\u{1F481}\u{1F3FF}', shortName:'person_tipping_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'hand', 'help', 'information', 'sassy', 'tipping', 'uc8', 'diversity', 'men', 'lipstick', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'mouth', 'mouths', 'makeup', 'lip', 'lips', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman tipping hand', char: '\u{1F481}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tipping_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['sassy', 'tipping hand', 'woman', 'uc6', 'diversity', 'women', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman tipping hand: light skin tone', char: '\u{1F481}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tipping_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['light skin tone', 'sassy', 'tipping hand', 'woman', 'uc8', 'diversity', 'women', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman tipping hand: medium-light skin tone', char: '\u{1F481}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tipping_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['medium-light skin tone', 'sassy', 'tipping hand', 'woman', 'uc8', 'diversity', 'women', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman tipping hand: medium skin tone', char: '\u{1F481}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tipping_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['medium skin tone', 'sassy', 'tipping hand', 'woman', 'uc8', 'diversity', 'women', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman tipping hand: medium-dark skin tone', char: '\u{1F481}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tipping_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['medium-dark skin tone', 'sassy', 'tipping hand', 'woman', 'uc8', 'diversity', 'women', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman tipping hand: dark skin tone', char: '\u{1F481}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_tipping_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'sassy', 'tipping hand', 'woman', 'uc8', 'diversity', 'women', 'help', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man tipping hand', char: '\u{1F481}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tipping_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['man', 'sassy', 'tipping hand', 'uc6', 'diversity', 'men', 'help', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male']), Emoji(name: 'man tipping hand: light skin tone', char: '\u{1F481}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tipping_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['light skin tone', 'man', 'sassy', 'tipping hand', 'uc8', 'diversity', 'men', 'help', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man tipping hand: medium-light skin tone', char: '\u{1F481}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tipping_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['man', 'medium-light skin tone', 'sassy', 'tipping hand', 'uc8', 'diversity', 'men', 'help', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man tipping hand: medium skin tone', char: '\u{1F481}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tipping_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['man', 'medium skin tone', 'sassy', 'tipping hand', 'uc8', 'diversity', 'men', 'help', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man tipping hand: medium-dark skin tone', char: '\u{1F481}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tipping_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['man', 'medium-dark skin tone', 'sassy', 'tipping hand', 'uc8', 'diversity', 'men', 'help', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man tipping hand: dark skin tone', char: '\u{1F481}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_tipping_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'man', 'sassy', 'tipping hand', 'uc8', 'diversity', 'men', 'help', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'person gesturing NO', char: '\u{1F645}', shortName:'person_gesturing_no', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited', 'uc6', 'diversity', 'men', 'angry', 'detest', 'danger', 'bitch', 'daddy', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person gesturing NO: light skin tone', char: '\u{1F645}\u{1F3FB}', shortName:'person_gesturing_no_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'not', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'bitch', 'daddy', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person gesturing NO: medium-light skin tone', char: '\u{1F645}\u{1F3FC}', shortName:'person_gesturing_no_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'not', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'bitch', 'daddy', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person gesturing NO: medium skin tone', char: '\u{1F645}\u{1F3FD}', shortName:'person_gesturing_no_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'not', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'bitch', 'daddy', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person gesturing NO: medium-dark skin tone', char: '\u{1F645}\u{1F3FE}', shortName:'person_gesturing_no_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'not', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'bitch', 'daddy', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person gesturing NO: dark skin tone', char: '\u{1F645}\u{1F3FF}', shortName:'person_gesturing_no_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'bitch', 'daddy', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman gesturing NO', char: '\u{1F645}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_no', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman', 'uc6', 'diversity', 'women', 'danger', 'bitch', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman gesturing NO: light skin tone', char: '\u{1F645}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_no_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'prohibited', 'woman', 'uc8', 'diversity', 'women', 'danger', 'bitch', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman gesturing NO: medium-light skin tone', char: '\u{1F645}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_no_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'prohibited', 'woman', 'uc8', 'diversity', 'women', 'danger', 'bitch', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman gesturing NO: medium skin tone', char: '\u{1F645}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_no_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'prohibited', 'woman', 'uc8', 'diversity', 'women', 'danger', 'bitch', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman gesturing NO: medium-dark skin tone', char: '\u{1F645}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_no_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'prohibited', 'woman', 'uc8', 'diversity', 'women', 'danger', 'bitch', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman gesturing NO: dark skin tone', char: '\u{1F645}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_no_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman', 'uc8', 'diversity', 'women', 'danger', 'bitch', 'crazy', 'private', 'mom', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'complain', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man gesturing NO', char: '\u{1F645}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_no', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited', 'uc6', 'diversity', 'men', 'angry', 'detest', 'danger', 'daddy', 'crazy', 'private', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved']), Emoji(name: 'man gesturing NO: light skin tone', char: '\u{1F645}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_no_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'light skin tone', 'man', 'no', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'daddy', 'crazy', 'private', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man gesturing NO: medium-light skin tone', char: '\u{1F645}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_no_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'man', 'medium-light skin tone', 'no', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'daddy', 'crazy', 'private', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man gesturing NO: medium skin tone', char: '\u{1F645}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_no_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'man', 'medium skin tone', 'no', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'daddy', 'crazy', 'private', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man gesturing NO: medium-dark skin tone', char: '\u{1F645}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_no_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['forbidden', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'no', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'daddy', 'crazy', 'private', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'man gesturing NO: dark skin tone', char: '\u{1F645}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_no_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited', 'uc8', 'diversity', 'men', 'angry', 'detest', 'danger', 'daddy', 'crazy', 'private', 'never', 'wrong', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'warn', 'attention', 'caution', 'alert', 'error', 'panic', 'restricted', "don't", 'dont', 'dangerous', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'прив', 'privé', 'privado', 'reserved'], modifiable: true), Emoji(name: 'person gesturing OK', char: '\u{1F646}', shortName:'person_gesturing_ok', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'uc6', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild', '*\\0/*', '\\0/', '*\\O/*', '\\O/']), Emoji(name: 'person gesturing OK: light skin tone', char: '\u{1F646}\u{1F3FB}', shortName:'person_gesturing_ok_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'light skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person gesturing OK: medium-light skin tone', char: '\u{1F646}\u{1F3FC}', shortName:'person_gesturing_ok_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person gesturing OK: medium skin tone', char: '\u{1F646}\u{1F3FD}', shortName:'person_gesturing_ok_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'medium skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person gesturing OK: medium-dark skin tone', char: '\u{1F646}\u{1F3FE}', shortName:'person_gesturing_ok_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person gesturing OK: dark skin tone', char: '\u{1F646}\u{1F3FF}', shortName:'person_gesturing_ok_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'dark skin tone', 'gesture', 'hand', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman gesturing OK', char: '\u{1F646}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_ok', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'woman', 'uc6', 'diversity', 'women', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'woman gesturing OK: light skin tone', char: '\u{1F646}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_ok_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'light skin tone', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman gesturing OK: medium-light skin tone', char: '\u{1F646}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_ok_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman gesturing OK: medium skin tone', char: '\u{1F646}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_ok_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'medium skin tone', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman gesturing OK: medium-dark skin tone', char: '\u{1F646}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_ok_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman gesturing OK: dark skin tone', char: '\u{1F646}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_gesturing_ok_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'dark skin tone', 'gesture', 'hand', 'woman', 'uc8', 'diversity', 'women', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man gesturing OK', char: '\u{1F646}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_ok', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'man', 'uc6', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'man gesturing OK: light skin tone', char: '\u{1F646}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_ok_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'light skin tone', 'man', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man gesturing OK: medium-light skin tone', char: '\u{1F646}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_ok_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man gesturing OK: medium skin tone', char: '\u{1F646}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_ok_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'man', 'medium skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man gesturing OK: medium-dark skin tone', char: '\u{1F646}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_ok_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man gesturing OK: dark skin tone', char: '\u{1F646}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_gesturing_ok_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['OK', 'dark skin tone', 'gesture', 'hand', 'man', 'uc8', 'diversity', 'men', 'thank you', 'awesome', 'yoga', 'crazy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'thanks', 'thankful', 'praise', 'gracias', 'merci', 'thankyou', 'acceptable', 'okay', 'got it', 'cool', 'ok', 'will do', 'like', 'bien', 'yep', 'yup', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person raising hand', char: '\u{1F64B}', shortName:'person_raising_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'hand', 'happy', 'raised', 'uc6', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person raising hand: light skin tone', char: '\u{1F64B}\u{1F3FB}', shortName:'person_raising_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'hand', 'happy', 'light skin tone', 'raised', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person raising hand: medium-light skin tone', char: '\u{1F64B}\u{1F3FC}', shortName:'person_raising_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'hand', 'happy', 'medium-light skin tone', 'raised', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person raising hand: medium skin tone', char: '\u{1F64B}\u{1F3FD}', shortName:'person_raising_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'hand', 'happy', 'medium skin tone', 'raised', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person raising hand: medium-dark skin tone', char: '\u{1F64B}\u{1F3FE}', shortName:'person_raising_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'hand', 'happy', 'medium-dark skin tone', 'raised', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person raising hand: dark skin tone', char: '\u{1F64B}\u{1F3FF}', shortName:'person_raising_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'gesture', 'hand', 'happy', 'raised', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman raising hand', char: '\u{1F64B}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_raising_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'raising hand', 'woman', 'uc6', 'diversity', 'women', 'hi', 'celebrate', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman raising hand: light skin tone', char: '\u{1F64B}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_raising_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'light skin tone', 'raising hand', 'woman', 'uc8', 'diversity', 'women', 'hi', 'celebrate', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman raising hand: medium-light skin tone', char: '\u{1F64B}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_raising_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium-light skin tone', 'raising hand', 'woman', 'uc8', 'diversity', 'women', 'hi', 'celebrate', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman raising hand: medium skin tone', char: '\u{1F64B}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_raising_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium skin tone', 'raising hand', 'woman', 'uc8', 'diversity', 'women', 'hi', 'celebrate', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman raising hand: medium-dark skin tone', char: '\u{1F64B}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_raising_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium-dark skin tone', 'raising hand', 'woman', 'uc8', 'diversity', 'women', 'hi', 'celebrate', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman raising hand: dark skin tone', char: '\u{1F64B}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_raising_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'gesture', 'raising hand', 'woman', 'uc8', 'diversity', 'women', 'hi', 'celebrate', 'help', 'crazy', 'mom', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'weird', 'awkward', 'insane', 'wild', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man raising hand', char: '\u{1F64B}\u{200D}\u{2642}\u{FE0F}', shortName:'man_raising_hand', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'raising hand', 'uc6', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'man raising hand: light skin tone', char: '\u{1F64B}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_raising_hand_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'light skin tone', 'man', 'raising hand', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man raising hand: medium-light skin tone', char: '\u{1F64B}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_raising_hand_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'medium-light skin tone', 'raising hand', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man raising hand: medium skin tone', char: '\u{1F64B}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_raising_hand_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'medium skin tone', 'raising hand', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man raising hand: medium-dark skin tone', char: '\u{1F64B}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_raising_hand_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'medium-dark skin tone', 'raising hand', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man raising hand: dark skin tone', char: '\u{1F64B}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_raising_hand_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'gesture', 'man', 'raising hand', 'uc8', 'diversity', 'men', 'hi', 'celebrate', 'daddy', 'help', 'crazy', 'proud', 'explore', 'awake', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'hello', 'greeting', 'bonjour', 'bye', 'ciao', 'adios', 'goodbye', 'hey', 'holla', 'my name is', 'salut', 'welcome', 'ПРИВЕТ', 'tu tapelle', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'deaf person', char: '\u{1F9CF}', shortName:'deaf_person', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing']), Emoji(name: 'deaf person: light skin tone', char: '\u{1F9CF}\u{1F3FB}', shortName:'deaf_person_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf person: medium-light skin tone', char: '\u{1F9CF}\u{1F3FC}', shortName:'deaf_person_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf person: medium skin tone', char: '\u{1F9CF}\u{1F3FD}', shortName:'deaf_person_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf person: medium-dark skin tone', char: '\u{1F9CF}\u{1F3FE}', shortName:'deaf_person_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf person: dark skin tone', char: '\u{1F9CF}\u{1F3FF}', shortName:'deaf_person_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf woman', char: '\u{1F9CF}\u{200D}\u{2640}\u{FE0F}', shortName:'deaf_woman', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'women', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing']), Emoji(name: 'deaf woman: light skin tone', char: '\u{1F9CF}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'deaf_woman_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'women', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf woman: medium-light skin tone', char: '\u{1F9CF}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'deaf_woman_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'women', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf woman: medium skin tone', char: '\u{1F9CF}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'deaf_woman_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'women', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf woman: medium-dark skin tone', char: '\u{1F9CF}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'deaf_woman_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'women', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf woman: dark skin tone', char: '\u{1F9CF}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'deaf_woman_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'women', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf man', char: '\u{1F9CF}\u{200D}\u{2642}\u{FE0F}', shortName:'deaf_man', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing']), Emoji(name: 'deaf man: light skin tone', char: '\u{1F9CF}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'deaf_man_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf man: medium-light skin tone', char: '\u{1F9CF}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'deaf_man_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf man: medium skin tone', char: '\u{1F9CF}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'deaf_man_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf man: medium-dark skin tone', char: '\u{1F9CF}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'deaf_man_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'deaf man: dark skin tone', char: '\u{1F9CF}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'deaf_man_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'quiet', 'sound', 'deaf', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'shut up', 'hushed', 'silence', 'silent', 'shush', 'shh', 'volume', 'speaker', 'loud', 'mic', 'audio', 'hear', 'hard of hearing'], modifiable: true), Emoji(name: 'person facepalming', char: '\u{1F926}', shortName:'person_facepalming', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'face', 'palm', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'person facepalming: light skin tone', char: '\u{1F926}\u{1F3FB}', shortName:'person_facepalming_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'face', 'light skin tone', 'palm', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person facepalming: medium-light skin tone', char: '\u{1F926}\u{1F3FC}', shortName:'person_facepalming_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'face', 'medium-light skin tone', 'palm', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person facepalming: medium skin tone', char: '\u{1F926}\u{1F3FD}', shortName:'person_facepalming_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'face', 'medium skin tone', 'palm', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person facepalming: medium-dark skin tone', char: '\u{1F926}\u{1F3FE}', shortName:'person_facepalming_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'face', 'medium-dark skin tone', 'palm', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person facepalming: dark skin tone', char: '\u{1F926}\u{1F3FF}', shortName:'person_facepalming_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'disbelief', 'exasperation', 'face', 'palm', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman facepalming', char: '\u{1F926}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_facepalming', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'woman', 'uc9', 'diversity', 'women', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'woman facepalming: light skin tone', char: '\u{1F926}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_facepalming_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'woman', 'uc9', 'diversity', 'women', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman facepalming: medium-light skin tone', char: '\u{1F926}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_facepalming_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'medium-light skin tone', 'woman', 'uc9', 'diversity', 'women', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman facepalming: medium skin tone', char: '\u{1F926}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_facepalming_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'medium skin tone', 'woman', 'uc9', 'diversity', 'women', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman facepalming: medium-dark skin tone', char: '\u{1F926}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_facepalming_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'medium-dark skin tone', 'woman', 'uc9', 'diversity', 'women', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'woman facepalming: dark skin tone', char: '\u{1F926}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_facepalming_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'woman', 'uc9', 'diversity', 'women', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man facepalming', char: '\u{1F926}\u{200D}\u{2642}\u{FE0F}', shortName:'man_facepalming', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'man', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild']), Emoji(name: 'man facepalming: light skin tone', char: '\u{1F926}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_facepalming_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'man', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man facepalming: medium-light skin tone', char: '\u{1F926}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_facepalming_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-light skin tone', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man facepalming: medium skin tone', char: '\u{1F926}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_facepalming_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'man', 'medium skin tone', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man facepalming: medium-dark skin tone', char: '\u{1F926}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_facepalming_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-dark skin tone', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'man facepalming: dark skin tone', char: '\u{1F926}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_facepalming_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'man', 'uc9', 'diversity', 'men', 'stressed', 'facepalm', 'dumb', 'las vegas', 'crazy', 'wrong', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'whoops', 'oops', 'mistake', 'idiot', 'ignorant', 'stupid', 'vegas', 'weird', 'awkward', 'insane', 'wild'], modifiable: true), Emoji(name: 'person shrugging', char: '\u{1F937}', shortName:'person_shrugging', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'bitch', 'daddy', 'doubt', 'dumb', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'complain', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled']), Emoji(name: 'person shrugging: light skin tone', char: '\u{1F937}\u{1F3FB}', shortName:'person_shrugging_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'bitch', 'daddy', 'doubt', 'dumb', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'complain', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'person shrugging: medium-light skin tone', char: '\u{1F937}\u{1F3FC}', shortName:'person_shrugging_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'bitch', 'daddy', 'doubt', 'dumb', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'complain', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'person shrugging: medium skin tone', char: '\u{1F937}\u{1F3FD}', shortName:'person_shrugging_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'bitch', 'daddy', 'doubt', 'dumb', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'complain', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'person shrugging: medium-dark skin tone', char: '\u{1F937}\u{1F3FE}', shortName:'person_shrugging_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'bitch', 'daddy', 'doubt', 'dumb', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'complain', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'person shrugging: dark skin tone', char: '\u{1F937}\u{1F3FF}', shortName:'person_shrugging_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'bitch', 'daddy', 'doubt', 'dumb', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'complain', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'woman shrugging', char: '\u{1F937}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_shrugging', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'shrug', 'woman', 'uc9', 'diversity', 'women', 'shrug', 'neutral', 'bitch', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'complain', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled']), Emoji(name: 'woman shrugging: light skin tone', char: '\u{1F937}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_shrugging_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'woman', 'uc9', 'diversity', 'women', 'shrug', 'neutral', 'bitch', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'complain', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'woman shrugging: medium-light skin tone', char: '\u{1F937}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_shrugging_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'woman', 'uc9', 'diversity', 'women', 'shrug', 'neutral', 'bitch', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'complain', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'woman shrugging: medium skin tone', char: '\u{1F937}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_shrugging_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'woman', 'uc9', 'diversity', 'women', 'shrug', 'neutral', 'bitch', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'complain', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'woman shrugging: medium-dark skin tone', char: '\u{1F937}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_shrugging_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'woman', 'uc9', 'diversity', 'women', 'shrug', 'neutral', 'bitch', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'complain', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'woman shrugging: dark skin tone', char: '\u{1F937}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_shrugging_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'woman', 'uc9', 'diversity', 'women', 'shrug', 'neutral', 'bitch', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'complain', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'man shrugging', char: '\u{1F937}\u{200D}\u{2642}\u{FE0F}', shortName:'man_shrugging', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'man', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'daddy', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled']), Emoji(name: 'man shrugging: light skin tone', char: '\u{1F937}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_shrugging_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'light skin tone', 'man', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'daddy', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'man shrugging: medium-light skin tone', char: '\u{1F937}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_shrugging_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'man', 'medium-light skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'daddy', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'man shrugging: medium skin tone', char: '\u{1F937}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_shrugging_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'man', 'medium skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'daddy', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'man shrugging: medium-dark skin tone', char: '\u{1F937}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_shrugging_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['doubt', 'ignorance', 'indifference', 'man', 'medium-dark skin tone', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'daddy', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'man shrugging: dark skin tone', char: '\u{1F937}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_shrugging_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'man', 'shrug', 'uc9', 'diversity', 'men', 'shrug', 'neutral', 'daddy', 'doubt', 'dumb', 'guilty', 'confused', 'what', 'crazy', 'mystery', 'question', 'sorry', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'unsure', 'thinking', 'wonder', 'curious', 'worry', 'pensive', 'remember', 'skeptical', 'idiot', 'ignorant', 'stupid', 'perplexed', 'weird', 'awkward', 'insane', 'wild', 'quiz', 'puzzled'], modifiable: true), Emoji(name: 'person pouting', char: '\u{1F64E}', shortName:'person_pouting', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'pouting', 'uc6', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person pouting: light skin tone', char: '\u{1F64E}\u{1F3FB}', shortName:'person_pouting_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'light skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person pouting: medium-light skin tone', char: '\u{1F64E}\u{1F3FC}', shortName:'person_pouting_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium-light skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person pouting: medium skin tone', char: '\u{1F64E}\u{1F3FD}', shortName:'person_pouting_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person pouting: medium-dark skin tone', char: '\u{1F64E}\u{1F3FE}', shortName:'person_pouting_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium-dark skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person pouting: dark skin tone', char: '\u{1F64E}\u{1F3FF}', shortName:'person_pouting_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'gesture', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman pouting', char: '\u{1F64E}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_pouting', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'pouting', 'woman', 'uc6', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman pouting: light skin tone', char: '\u{1F64E}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_pouting_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'light skin tone', 'pouting', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman pouting: medium-light skin tone', char: '\u{1F64E}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_pouting_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium-light skin tone', 'pouting', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman pouting: medium skin tone', char: '\u{1F64E}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_pouting_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium skin tone', 'pouting', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman pouting: medium-dark skin tone', char: '\u{1F64E}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_pouting_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'medium-dark skin tone', 'pouting', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman pouting: dark skin tone', char: '\u{1F64E}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_pouting_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'gesture', 'pouting', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man pouting', char: '\u{1F64E}\u{200D}\u{2642}\u{FE0F}', shortName:'man_pouting', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'pouting', 'uc6', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father']), Emoji(name: 'man pouting: light skin tone', char: '\u{1F64E}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_pouting_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'light skin tone', 'man', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man pouting: medium-light skin tone', char: '\u{1F64E}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_pouting_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'medium-light skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man pouting: medium skin tone', char: '\u{1F64E}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_pouting_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'medium skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man pouting: medium-dark skin tone', char: '\u{1F64E}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_pouting_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['gesture', 'man', 'medium-dark skin tone', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man pouting: dark skin tone', char: '\u{1F64E}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_pouting_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'gesture', 'man', 'pouting', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'person frowning', char: '\u{1F64D}', shortName:'person_frowning', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frown', 'gesture', 'uc6', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person frowning: light skin tone', char: '\u{1F64D}\u{1F3FB}', shortName:'person_frowning_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frown', 'gesture', 'light skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person frowning: medium-light skin tone', char: '\u{1F64D}\u{1F3FC}', shortName:'person_frowning_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frown', 'gesture', 'medium-light skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person frowning: medium skin tone', char: '\u{1F64D}\u{1F3FD}', shortName:'person_frowning_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frown', 'gesture', 'medium skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person frowning: medium-dark skin tone', char: '\u{1F64D}\u{1F3FE}', shortName:'person_frowning_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frown', 'gesture', 'medium-dark skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person frowning: dark skin tone', char: '\u{1F64D}\u{1F3FF}', shortName:'person_frowning_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'frown', 'gesture', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'bitch', 'daddy', 'husband', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'complain', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman frowning', char: '\u{1F64D}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_frowning', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'woman', 'uc6', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman frowning: light skin tone', char: '\u{1F64D}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_frowning_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'light skin tone', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman frowning: medium-light skin tone', char: '\u{1F64D}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_frowning_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman frowning: medium skin tone', char: '\u{1F64D}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_frowning_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'medium skin tone', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman frowning: medium-dark skin tone', char: '\u{1F64D}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_frowning_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman frowning: dark skin tone', char: '\u{1F64D}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_frowning_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'frowning', 'gesture', 'woman', 'uc8', 'diversity', 'sad', 'women', 'stressed', 'bitch', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'woman', 'female', 'complain', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man frowning', char: '\u{1F64D}\u{200D}\u{2642}\u{FE0F}', shortName:'man_frowning', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'man', 'uc6', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father']), Emoji(name: 'man frowning: light skin tone', char: '\u{1F64D}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_frowning_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'light skin tone', 'man', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man frowning: medium-light skin tone', char: '\u{1F64D}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_frowning_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man frowning: medium skin tone', char: '\u{1F64D}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_frowning_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'man', 'medium skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man frowning: medium-dark skin tone', char: '\u{1F64D}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_frowning_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['frowning', 'gesture', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man frowning: dark skin tone', char: '\u{1F64D}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_frowning_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personGesture, keywords: ['dark skin tone', 'frowning', 'gesture', 'man', 'uc8', 'diversity', 'sad', 'men', 'angry', 'stressed', 'detest', 'daddy', 'husband', 'diverse', 'modifier', 'modifiers', 'equality', 'triste', 'depression', 'negative', 'sadness', 'man', 'guy', 'guys', 'gentleman', 'male', 'upset', 'pissed', 'pissed off', 'unhappy', 'frustrated', 'anger', 'rage', 'frustration', 'furious', 'mad', 'disgust', 'stump', 'shout', 'dislike', 'rude', 'annoy', 'grinch', 'gross', 'grumpy', 'mean', 'problem', 'suck', 'jerk', 'asshole', 'no', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'person getting haircut', char: '\u{1F487}', shortName:'person_getting_haircut', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['barber', 'beauty', 'haircut', 'parlor', 'uc6', 'diversity', 'men', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person getting haircut: light skin tone', char: '\u{1F487}\u{1F3FB}', shortName:'person_getting_haircut_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['barber', 'beauty', 'haircut', 'light skin tone', 'parlor', 'uc8', 'diversity', 'men', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting haircut: medium-light skin tone', char: '\u{1F487}\u{1F3FC}', shortName:'person_getting_haircut_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['barber', 'beauty', 'haircut', 'medium-light skin tone', 'parlor', 'uc8', 'diversity', 'men', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting haircut: medium skin tone', char: '\u{1F487}\u{1F3FD}', shortName:'person_getting_haircut_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['barber', 'beauty', 'haircut', 'medium skin tone', 'parlor', 'uc8', 'diversity', 'men', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting haircut: medium-dark skin tone', char: '\u{1F487}\u{1F3FE}', shortName:'person_getting_haircut_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['barber', 'beauty', 'haircut', 'medium-dark skin tone', 'parlor', 'uc8', 'diversity', 'men', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting haircut: dark skin tone', char: '\u{1F487}\u{1F3FF}', shortName:'person_getting_haircut_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['barber', 'beauty', 'dark skin tone', 'haircut', 'parlor', 'uc8', 'diversity', 'men', 'daddy', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting haircut', char: '\u{1F487}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_haircut', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'woman', 'uc6', 'diversity', 'women', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman getting haircut: light skin tone', char: '\u{1F487}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_haircut_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'light skin tone', 'woman', 'uc8', 'diversity', 'women', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting haircut: medium-light skin tone', char: '\u{1F487}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_haircut_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'women', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting haircut: medium skin tone', char: '\u{1F487}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_haircut_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'medium skin tone', 'woman', 'uc8', 'diversity', 'women', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting haircut: medium-dark skin tone', char: '\u{1F487}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_haircut_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'women', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting haircut: dark skin tone', char: '\u{1F487}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_haircut_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'haircut', 'woman', 'uc8', 'diversity', 'women', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man getting haircut', char: '\u{1F487}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_haircut', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'man', 'uc6', 'diversity', 'men', 'daddy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father']), Emoji(name: 'man getting haircut: light skin tone', char: '\u{1F487}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_haircut_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'light skin tone', 'man', 'uc8', 'diversity', 'men', 'daddy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man getting haircut: medium-light skin tone', char: '\u{1F487}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_haircut_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'man', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'daddy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man getting haircut: medium skin tone', char: '\u{1F487}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_haircut_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'man', 'medium skin tone', 'uc8', 'diversity', 'men', 'daddy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man getting haircut: medium-dark skin tone', char: '\u{1F487}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_haircut_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['haircut', 'man', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'daddy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'man getting haircut: dark skin tone', char: '\u{1F487}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_haircut_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'haircut', 'man', 'uc8', 'diversity', 'men', 'daddy', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dad', 'papa', 'pere', 'father'], modifiable: true), Emoji(name: 'person getting massage', char: '\u{1F486}', shortName:'person_getting_massage', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'salon', 'uc6', 'diversity', 'men', 'pleased', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person getting massage: light skin tone', char: '\u{1F486}\u{1F3FB}', shortName:'person_getting_massage_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'light skin tone', 'massage', 'salon', 'uc8', 'diversity', 'men', 'pleased', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting massage: medium-light skin tone', char: '\u{1F486}\u{1F3FC}', shortName:'person_getting_massage_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'medium-light skin tone', 'salon', 'uc8', 'diversity', 'men', 'pleased', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting massage: medium skin tone', char: '\u{1F486}\u{1F3FD}', shortName:'person_getting_massage_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'medium skin tone', 'salon', 'uc8', 'diversity', 'men', 'pleased', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting massage: medium-dark skin tone', char: '\u{1F486}\u{1F3FE}', shortName:'person_getting_massage_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'medium-dark skin tone', 'salon', 'uc8', 'diversity', 'men', 'pleased', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person getting massage: dark skin tone', char: '\u{1F486}\u{1F3FF}', shortName:'person_getting_massage_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'face', 'massage', 'salon', 'uc8', 'diversity', 'men', 'pleased', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'please', 'chill', 'confident', 'content', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting massage', char: '\u{1F486}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_face_massage', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'woman', 'uc6', 'diversity', 'women', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman getting massage: light skin tone', char: '\u{1F486}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_face_massage_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'light skin tone', 'massage', 'woman', 'uc8', 'diversity', 'women', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting massage: medium-light skin tone', char: '\u{1F486}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_face_massage_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'medium-light skin tone', 'woman', 'uc8', 'diversity', 'women', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting massage: medium skin tone', char: '\u{1F486}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_face_massage_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'medium skin tone', 'woman', 'uc8', 'diversity', 'women', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting massage: medium-dark skin tone', char: '\u{1F486}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_face_massage_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'massage', 'medium-dark skin tone', 'woman', 'uc8', 'diversity', 'women', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman getting massage: dark skin tone', char: '\u{1F486}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_getting_face_massage_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'face', 'massage', 'woman', 'uc8', 'diversity', 'women', 'yoga', 'calm', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man getting massage', char: '\u{1F486}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_face_massage', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'man', 'massage', 'uc6', 'diversity', 'men', 'yoga', 'calm', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna']), Emoji(name: 'man getting massage: light skin tone', char: '\u{1F486}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_face_massage_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'light skin tone', 'man', 'massage', 'uc8', 'diversity', 'men', 'yoga', 'calm', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man getting massage: medium-light skin tone', char: '\u{1F486}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_face_massage_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'man', 'massage', 'medium-light skin tone', 'uc8', 'diversity', 'men', 'yoga', 'calm', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man getting massage: medium skin tone', char: '\u{1F486}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_face_massage_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'man', 'massage', 'medium skin tone', 'uc8', 'diversity', 'men', 'yoga', 'calm', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man getting massage: medium-dark skin tone', char: '\u{1F486}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_face_massage_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['face', 'man', 'massage', 'medium-dark skin tone', 'uc8', 'diversity', 'men', 'yoga', 'calm', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man getting massage: dark skin tone', char: '\u{1F486}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_getting_face_massage_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'face', 'man', 'massage', 'uc8', 'diversity', 'men', 'yoga', 'calm', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'meditation', 'meditate', 'zen', 'om', 'aum', 'stretch', 'relax', 'sauna'], modifiable: true), Emoji(name: 'person in steamy room', char: '\u{1F9D6}', shortName:'person_in_steamy_room', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc10', 'diversity', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person in steamy room: light skin tone', char: '\u{1F9D6}\u{1F3FB}', shortName:'person_in_steamy_room_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['light skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person in steamy room: medium-light skin tone', char: '\u{1F9D6}\u{1F3FC}', shortName:'person_in_steamy_room_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium-light skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person in steamy room: medium skin tone', char: '\u{1F9D6}\u{1F3FD}', shortName:'person_in_steamy_room_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person in steamy room: medium-dark skin tone', char: '\u{1F9D6}\u{1F3FE}', shortName:'person_in_steamy_room_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium-dark skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person in steamy room: dark skin tone', char: '\u{1F9D6}\u{1F3FF}', shortName:'person_in_steamy_room_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman in steamy room', char: '\u{1F9D6}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_steamy_room', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['sauna', 'steam room', 'uc10', 'diversity', 'women', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman in steamy room: light skin tone', char: '\u{1F9D6}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_steamy_room_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['light skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'women', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman in steamy room: medium-light skin tone', char: '\u{1F9D6}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_steamy_room_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium-light skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'women', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman in steamy room: medium skin tone', char: '\u{1F9D6}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_steamy_room_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'women', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman in steamy room: medium-dark skin tone', char: '\u{1F9D6}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_steamy_room_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium-dark skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'women', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman in steamy room: dark skin tone', char: '\u{1F9D6}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_in_steamy_room_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'women', 'hot', 'steam', 'spa', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man in steamy room', char: '\u{1F9D6}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_steamy_room', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna']), Emoji(name: 'man in steamy room: light skin tone', char: '\u{1F9D6}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_steamy_room_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['light skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man in steamy room: medium-light skin tone', char: '\u{1F9D6}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_steamy_room_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium-light skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man in steamy room: medium skin tone', char: '\u{1F9D6}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_steamy_room_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man in steamy room: medium-dark skin tone', char: '\u{1F9D6}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_steamy_room_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['medium-dark skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna'], modifiable: true), Emoji(name: 'man in steamy room: dark skin tone', char: '\u{1F9D6}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_in_steamy_room_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'sauna', 'steam room', 'uc10', 'diversity', 'hot', 'steam', 'spa', 'diverse', 'modifier', 'modifiers', 'equality', 'heat', 'warm', 'caliente', 'chaud', 'heiß', 'steaming', 'piping', 'relax', 'sauna'], modifiable: true), Emoji(name: 'nail polish', char: '\u{1F485}', shortName:'nail_care', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['care', 'cosmetics', 'manicure', 'nail', 'polish', 'uc6', 'diversity', 'women', 'body', 'hands', 'nailpolish', 'beautiful', 'painting', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'nails', 'fingernails', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'painter', 'arts', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'nail polish: light skin tone', char: '\u{1F485}\u{1F3FB}', shortName:'nail_care_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['care', 'cosmetics', 'light skin tone', 'manicure', 'nail', 'polish', 'uc8', 'diversity', 'women', 'body', 'hands', 'nailpolish', 'beautiful', 'painting', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'nails', 'fingernails', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'painter', 'arts', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'nail polish: medium-light skin tone', char: '\u{1F485}\u{1F3FC}', shortName:'nail_care_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['care', 'cosmetics', 'manicure', 'medium-light skin tone', 'nail', 'polish', 'uc8', 'diversity', 'women', 'body', 'hands', 'nailpolish', 'beautiful', 'painting', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'nails', 'fingernails', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'painter', 'arts', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'nail polish: medium skin tone', char: '\u{1F485}\u{1F3FD}', shortName:'nail_care_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['care', 'cosmetics', 'manicure', 'medium skin tone', 'nail', 'polish', 'uc8', 'diversity', 'women', 'body', 'hands', 'nailpolish', 'beautiful', 'painting', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'nails', 'fingernails', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'painter', 'arts', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'nail polish: medium-dark skin tone', char: '\u{1F485}\u{1F3FE}', shortName:'nail_care_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['care', 'cosmetics', 'manicure', 'medium-dark skin tone', 'nail', 'polish', 'uc8', 'diversity', 'women', 'body', 'hands', 'nailpolish', 'beautiful', 'painting', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'nails', 'fingernails', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'painter', 'arts', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'nail polish: dark skin tone', char: '\u{1F485}\u{1F3FF}', shortName:'nail_care_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['care', 'cosmetics', 'dark skin tone', 'manicure', 'nail', 'polish', 'uc8', 'diversity', 'women', 'body', 'hands', 'nailpolish', 'beautiful', 'painting', 'mom', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'body part', 'anatomy', 'hand', 'finger', 'fingers', 'nails', 'fingernails', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'painter', 'arts', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'selfie', char: '\u{1F933}', shortName:'selfie', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['camera', 'phone', 'selfie', 'uc9', 'diversity', 'selfie', 'fame', 'instagram', 'fun', 'youtube', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'famous', 'celebrity', 'vlog']), Emoji(name: 'selfie: light skin tone', char: '\u{1F933}\u{1F3FB}', shortName:'selfie_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['camera', 'light skin tone', 'phone', 'selfie', 'uc9', 'diversity', 'selfie', 'fame', 'instagram', 'fun', 'youtube', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'famous', 'celebrity', 'vlog'], modifiable: true), Emoji(name: 'selfie: medium-light skin tone', char: '\u{1F933}\u{1F3FC}', shortName:'selfie_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['camera', 'medium-light skin tone', 'phone', 'selfie', 'uc9', 'diversity', 'selfie', 'fame', 'instagram', 'fun', 'youtube', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'famous', 'celebrity', 'vlog'], modifiable: true), Emoji(name: 'selfie: medium skin tone', char: '\u{1F933}\u{1F3FD}', shortName:'selfie_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['camera', 'medium skin tone', 'phone', 'selfie', 'uc9', 'diversity', 'selfie', 'fame', 'instagram', 'fun', 'youtube', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'famous', 'celebrity', 'vlog'], modifiable: true), Emoji(name: 'selfie: medium-dark skin tone', char: '\u{1F933}\u{1F3FE}', shortName:'selfie_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['camera', 'medium-dark skin tone', 'phone', 'selfie', 'uc9', 'diversity', 'selfie', 'fame', 'instagram', 'fun', 'youtube', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'famous', 'celebrity', 'vlog'], modifiable: true), Emoji(name: 'selfie: dark skin tone', char: '\u{1F933}\u{1F3FF}', shortName:'selfie_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.handProp, keywords: ['camera', 'dark skin tone', 'phone', 'selfie', 'uc9', 'diversity', 'selfie', 'fame', 'instagram', 'fun', 'youtube', 'advertise', 'diverse', 'modifier', 'modifiers', 'equality', 'famous', 'celebrity', 'vlog'], modifiable: true), Emoji(name: 'woman dancing', char: '\u{1F483}', shortName:'dancer', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dancing', 'woman', 'uc6', 'instruments', 'diversity', 'women', 'mexican', 'sexy', 'circus', 'beautiful', 'dance', 'hawaii', 'celebrate', 'disco', 'las vegas', 'fun', 'activity', 'dress', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'mexico', 'cinco de mayo', 'español', 'circus tent', 'clown', 'clowns', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'aloha', 'kawaii', 'maui', 'moana', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'vegas']), Emoji(name: 'woman dancing: light skin tone', char: '\u{1F483}\u{1F3FB}', shortName:'dancer_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dancing', 'light skin tone', 'woman', 'uc8', 'instruments', 'diversity', 'women', 'mexican', 'sexy', 'circus', 'beautiful', 'dance', 'hawaii', 'celebrate', 'disco', 'las vegas', 'fun', 'activity', 'dress', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'mexico', 'cinco de mayo', 'español', 'circus tent', 'clown', 'clowns', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'aloha', 'kawaii', 'maui', 'moana', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'vegas'], modifiable: true), Emoji(name: 'woman dancing: medium-light skin tone', char: '\u{1F483}\u{1F3FC}', shortName:'dancer_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dancing', 'medium-light skin tone', 'woman', 'uc8', 'instruments', 'diversity', 'women', 'mexican', 'sexy', 'circus', 'beautiful', 'dance', 'hawaii', 'celebrate', 'disco', 'las vegas', 'fun', 'activity', 'dress', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'mexico', 'cinco de mayo', 'español', 'circus tent', 'clown', 'clowns', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'aloha', 'kawaii', 'maui', 'moana', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'vegas'], modifiable: true), Emoji(name: 'woman dancing: medium skin tone', char: '\u{1F483}\u{1F3FD}', shortName:'dancer_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dancing', 'medium skin tone', 'woman', 'uc8', 'instruments', 'diversity', 'women', 'mexican', 'sexy', 'circus', 'beautiful', 'dance', 'hawaii', 'celebrate', 'disco', 'las vegas', 'fun', 'activity', 'dress', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'mexico', 'cinco de mayo', 'español', 'circus tent', 'clown', 'clowns', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'aloha', 'kawaii', 'maui', 'moana', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'vegas'], modifiable: true), Emoji(name: 'woman dancing: medium-dark skin tone', char: '\u{1F483}\u{1F3FE}', shortName:'dancer_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dancing', 'medium-dark skin tone', 'woman', 'uc8', 'instruments', 'diversity', 'women', 'mexican', 'sexy', 'circus', 'beautiful', 'dance', 'hawaii', 'celebrate', 'disco', 'las vegas', 'fun', 'activity', 'dress', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'mexico', 'cinco de mayo', 'español', 'circus tent', 'clown', 'clowns', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'aloha', 'kawaii', 'maui', 'moana', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'vegas'], modifiable: true), Emoji(name: 'woman dancing: dark skin tone', char: '\u{1F483}\u{1F3FF}', shortName:'dancer_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dancing', 'dark skin tone', 'woman', 'uc8', 'instruments', 'diversity', 'women', 'mexican', 'sexy', 'circus', 'beautiful', 'dance', 'hawaii', 'celebrate', 'disco', 'las vegas', 'fun', 'activity', 'dress', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'mexico', 'cinco de mayo', 'español', 'circus tent', 'clown', 'clowns', 'cute', 'pretty', 'adorable', 'adore', 'beauty', 'cutie', 'babe', 'lovely', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'aloha', 'kawaii', 'maui', 'moana', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'vegas'], modifiable: true), Emoji(name: 'man dancing', char: '\u{1F57A}', shortName:'man_dancing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dance', 'man', 'uc9', 'instruments', 'diversity', 'men', 'dance', 'celebrate', 'disco', 'daddy', 'las vegas', 'fun', 'activity', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'vegas']), Emoji(name: 'man dancing: light skin tone', char: '\u{1F57A}\u{1F3FB}', shortName:'man_dancing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dance', 'light skin tone', 'man', 'uc9', 'instruments', 'diversity', 'men', 'dance', 'celebrate', 'disco', 'daddy', 'las vegas', 'fun', 'activity', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'vegas'], modifiable: true), Emoji(name: 'man dancing: medium-light skin tone', char: '\u{1F57A}\u{1F3FC}', shortName:'man_dancing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dance', 'man', 'medium-light skin tone', 'uc9', 'instruments', 'diversity', 'men', 'dance', 'celebrate', 'disco', 'daddy', 'las vegas', 'fun', 'activity', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'vegas'], modifiable: true), Emoji(name: 'man dancing: medium skin tone', char: '\u{1F57A}\u{1F3FD}', shortName:'man_dancing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dance', 'man', 'medium skin tone', 'uc9', 'instruments', 'diversity', 'men', 'dance', 'celebrate', 'disco', 'daddy', 'las vegas', 'fun', 'activity', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'vegas'], modifiable: true), Emoji(name: 'man dancing: dark skin tone', char: '\u{1F57A}\u{1F3FF}', shortName:'man_dancing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dance', 'dark skin tone', 'man', 'uc9', 'instruments', 'diversity', 'men', 'dance', 'celebrate', 'disco', 'daddy', 'las vegas', 'fun', 'activity', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'vegas'], modifiable: true), Emoji(name: 'man dancing: medium-dark skin tone', char: '\u{1F57A}\u{1F3FE}', shortName:'man_dancing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dance', 'man', 'medium-dark skin tone', 'uc9', 'instruments', 'diversity', 'men', 'dance', 'celebrate', 'disco', 'daddy', 'las vegas', 'fun', 'activity', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'celebration', 'event', 'celebrating', 'festa', 'parties', 'events', 'new years', 'new year', 'fiesta', 'fete', 'newyear', 'party', 'festive', 'festival', 'yolo', 'festejar', 'dad', 'papa', 'pere', 'father', 'vegas'], modifiable: true), Emoji(name: 'people with bunny ears', char: '\u{1F46F}', shortName:'people_with_bunny_ears_partying', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['bunny ear', 'dancer', 'partying', 'uc6', 'instruments', 'diversity', 'silly', 'men', 'japan', 'sexy', 'dance', 'easter', 'las vegas', 'fun', 'crazy', 'playboy', 'activity', 'disguise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'diverse', 'modifier', 'modifiers', 'equality', 'funny', 'man', 'guy', 'guys', 'gentleman', 'male', 'japanese', 'ninja', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'vegas', 'weird', 'awkward', 'insane', 'wild', 'play boy']), Emoji(name: 'women with bunny ears', char: '\u{1F46F}\u{200D}\u{2640}\u{FE0F}', shortName:'women_with_bunny_ears_partying', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['bunny ear', 'dancer', 'partying', 'women', 'uc6', 'instruments', 'silly', 'women', 'japan', 'dance', 'easter', 'las vegas', 'fun', 'crazy', 'playboy', 'activity', 'disguise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'funny', 'woman', 'female', 'japanese', 'ninja', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'vegas', 'weird', 'awkward', 'insane', 'wild', 'play boy']), Emoji(name: 'men with bunny ears', char: '\u{1F46F}\u{200D}\u{2642}\u{FE0F}', shortName:'men_with_bunny_ears_partying', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['bunny ear', 'dancer', 'men', 'partying', 'uc6', 'instruments', 'silly', 'men', 'japan', 'dance', 'easter', 'las vegas', 'fun', 'crazy', 'playboy', 'activity', 'disguise', 'music', 'instrument', 'singing', 'concert', 'jaz', 'listen', 'singer', 'song', 'musique', 'funny', 'man', 'guy', 'guys', 'gentleman', 'male', 'japanese', 'ninja', 'dancers', 'dancing', 'ballet', 'ballerina', 'dabbing', 'salsa', 'vegas', 'weird', 'awkward', 'insane', 'wild', 'play boy']), Emoji(name: 'person in suit levitating', char: '\u{1F574}\u{FE0F}', shortName:'levitate', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['business', 'man', 'suit', 'uc7', 'men', 'job', 'business', 'sunglasses', 'google', 'detective', 'fame', 'gangster', 'super hero', 'vampire', 'las vegas', 'mystery', 'disguise', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'shades', 'lunettes de soleil', 'sun glasses', 'famous', 'celebrity', 'thug', 'superhero', 'superman', 'batman', 'dracula', 'vegas']), Emoji(name: 'person in suit levitating: light skin tone', char: '\u{1F574}\u{1F3FB}', shortName:'levitate_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['business', 'light skin tone', 'man', 'suit', 'uc8', 'men', 'job', 'business', 'sunglasses', 'google', 'detective', 'fame', 'gangster', 'super hero', 'vampire', 'las vegas', 'mystery', 'disguise', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'shades', 'lunettes de soleil', 'sun glasses', 'famous', 'celebrity', 'thug', 'superhero', 'superman', 'batman', 'dracula', 'vegas'], modifiable: true), Emoji(name: 'person in suit levitating: medium-light skin tone', char: '\u{1F574}\u{1F3FC}', shortName:'levitate_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['business', 'man', 'medium-light skin tone', 'suit', 'uc8', 'men', 'job', 'business', 'sunglasses', 'google', 'detective', 'fame', 'gangster', 'super hero', 'vampire', 'las vegas', 'mystery', 'disguise', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'shades', 'lunettes de soleil', 'sun glasses', 'famous', 'celebrity', 'thug', 'superhero', 'superman', 'batman', 'dracula', 'vegas'], modifiable: true), Emoji(name: 'person in suit levitating: medium skin tone', char: '\u{1F574}\u{1F3FD}', shortName:'levitate_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['business', 'man', 'medium skin tone', 'suit', 'uc8', 'men', 'job', 'business', 'sunglasses', 'google', 'detective', 'fame', 'gangster', 'super hero', 'vampire', 'las vegas', 'mystery', 'disguise', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'shades', 'lunettes de soleil', 'sun glasses', 'famous', 'celebrity', 'thug', 'superhero', 'superman', 'batman', 'dracula', 'vegas'], modifiable: true), Emoji(name: 'person in suit levitating: medium-dark skin tone', char: '\u{1F574}\u{1F3FE}', shortName:'levitate_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['business', 'man', 'medium-dark skin tone', 'suit', 'uc8', 'men', 'job', 'business', 'sunglasses', 'google', 'detective', 'fame', 'gangster', 'super hero', 'vampire', 'las vegas', 'mystery', 'disguise', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'shades', 'lunettes de soleil', 'sun glasses', 'famous', 'celebrity', 'thug', 'superhero', 'superman', 'batman', 'dracula', 'vegas'], modifiable: true), Emoji(name: 'person in suit levitating: dark skin tone', char: '\u{1F574}\u{1F3FF}', shortName:'levitate_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['business', 'dark skin tone', 'man', 'suit', 'uc8', 'men', 'job', 'business', 'sunglasses', 'google', 'detective', 'fame', 'gangster', 'super hero', 'vampire', 'las vegas', 'mystery', 'disguise', 'man', 'guy', 'guys', 'gentleman', 'male', 'profession', 'boss', 'career', 'shades', 'lunettes de soleil', 'sun glasses', 'famous', 'celebrity', 'thug', 'superhero', 'superman', 'batman', 'dracula', 'vegas'], modifiable: true), Emoji(name: 'person in manual wheelchair', char: '\u{1F9D1}\u{200D}\u{1F9BD}', shortName:'person_in_manual_wheelchair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability']), Emoji(name: 'person in manual wheelchair: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9BD}', shortName:'person_in_manual_wheelchair_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in manual wheelchair: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9BD}', shortName:'person_in_manual_wheelchair_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in manual wheelchair: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9BD}', shortName:'person_in_manual_wheelchair_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in manual wheelchair: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9BD}', shortName:'person_in_manual_wheelchair_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in manual wheelchair: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9BD}', shortName:'person_in_manual_wheelchair_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in manual wheelchair', char: '\u{1F469}\u{200D}\u{1F9BD}', shortName:'woman_in_manual_wheelchair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability']), Emoji(name: 'woman in manual wheelchair: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9BD}', shortName:'woman_in_manual_wheelchair_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in manual wheelchair: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9BD}', shortName:'woman_in_manual_wheelchair_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in manual wheelchair: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9BD}', shortName:'woman_in_manual_wheelchair_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in manual wheelchair: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9BD}', shortName:'woman_in_manual_wheelchair_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in manual wheelchair: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9BD}', shortName:'woman_in_manual_wheelchair_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in manual wheelchair', char: '\u{1F468}\u{200D}\u{1F9BD}', shortName:'man_in_manual_wheelchair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability']), Emoji(name: 'man in manual wheelchair: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9BD}', shortName:'man_in_manual_wheelchair_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in manual wheelchair: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9BD}', shortName:'man_in_manual_wheelchair_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in manual wheelchair: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9BD}', shortName:'man_in_manual_wheelchair_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in manual wheelchair: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9BD}', shortName:'man_in_manual_wheelchair_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in manual wheelchair: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9BD}', shortName:'man_in_manual_wheelchair_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in motorized wheelchair', char: '\u{1F9D1}\u{200D}\u{1F9BC}', shortName:'person_in_motorized_wheelchair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability']), Emoji(name: 'person in motorized wheelchair: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9BC}', shortName:'person_in_motorized_wheelchair_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in motorized wheelchair: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9BC}', shortName:'person_in_motorized_wheelchair_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in motorized wheelchair: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9BC}', shortName:'person_in_motorized_wheelchair_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in motorized wheelchair: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9BC}', shortName:'person_in_motorized_wheelchair_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person in motorized wheelchair: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9BC}', shortName:'person_in_motorized_wheelchair_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in motorized wheelchair', char: '\u{1F469}\u{200D}\u{1F9BC}', shortName:'woman_in_motorized_wheelchair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability']), Emoji(name: 'woman in motorized wheelchair: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9BC}', shortName:'woman_in_motorized_wheelchair_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in motorized wheelchair: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9BC}', shortName:'woman_in_motorized_wheelchair_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in motorized wheelchair: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9BC}', shortName:'woman_in_motorized_wheelchair_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in motorized wheelchair: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9BC}', shortName:'woman_in_motorized_wheelchair_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'woman in motorized wheelchair: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9BC}', shortName:'woman_in_motorized_wheelchair_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in motorized wheelchair', char: '\u{1F468}\u{200D}\u{1F9BC}', shortName:'man_in_motorized_wheelchair', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability']), Emoji(name: 'man in motorized wheelchair: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9BC}', shortName:'man_in_motorized_wheelchair_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in motorized wheelchair: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9BC}', shortName:'man_in_motorized_wheelchair_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in motorized wheelchair: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9BC}', shortName:'man_in_motorized_wheelchair_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in motorized wheelchair: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9BC}', shortName:'man_in_motorized_wheelchair_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'man in motorized wheelchair: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9BC}', shortName:'man_in_motorized_wheelchair_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'old people', 'diversity', 'handicap', 'accessibility', 'grandparents', 'elderly', 'grandma', 'grandpa', 'grandmother', 'grandfather', 'mamie', 'papy', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability'], modifiable: true), Emoji(name: 'person walking', char: '\u{1F6B6}', shortName:'person_walking', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'walk', 'walking', 'uc6', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male']), Emoji(name: 'person walking: light skin tone', char: '\u{1F6B6}\u{1F3FB}', shortName:'person_walking_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'light skin tone', 'walk', 'walking', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'person walking: medium-light skin tone', char: '\u{1F6B6}\u{1F3FC}', shortName:'person_walking_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'medium-light skin tone', 'walk', 'walking', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'person walking: medium skin tone', char: '\u{1F6B6}\u{1F3FD}', shortName:'person_walking_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'medium skin tone', 'walk', 'walking', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'person walking: medium-dark skin tone', char: '\u{1F6B6}\u{1F3FE}', shortName:'person_walking_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'medium-dark skin tone', 'walk', 'walking', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'person walking: dark skin tone', char: '\u{1F6B6}\u{1F3FF}', shortName:'person_walking_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'hike', 'walk', 'walking', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'woman walking', char: '\u{1F6B6}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_walking', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'walk', 'woman', 'uc6', 'sport', 'diversity', 'women', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female']), Emoji(name: 'woman walking: light skin tone', char: '\u{1F6B6}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_walking_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'light skin tone', 'walk', 'woman', 'uc8', 'sport', 'diversity', 'women', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female'], modifiable: true), Emoji(name: 'woman walking: medium-light skin tone', char: '\u{1F6B6}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_walking_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'medium-light skin tone', 'walk', 'woman', 'uc8', 'sport', 'diversity', 'women', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female'], modifiable: true), Emoji(name: 'woman walking: medium skin tone', char: '\u{1F6B6}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_walking_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'medium skin tone', 'walk', 'woman', 'uc8', 'sport', 'diversity', 'women', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female'], modifiable: true), Emoji(name: 'woman walking: medium-dark skin tone', char: '\u{1F6B6}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_walking_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'medium-dark skin tone', 'walk', 'woman', 'uc8', 'sport', 'diversity', 'women', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female'], modifiable: true), Emoji(name: 'woman walking: dark skin tone', char: '\u{1F6B6}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_walking_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'hike', 'walk', 'woman', 'uc8', 'sport', 'diversity', 'women', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female'], modifiable: true), Emoji(name: 'man walking', char: '\u{1F6B6}\u{200D}\u{2642}\u{FE0F}', shortName:'man_walking', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'man', 'walk', 'uc6', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male']), Emoji(name: 'man walking: light skin tone', char: '\u{1F6B6}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_walking_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'light skin tone', 'man', 'walk', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man walking: medium-light skin tone', char: '\u{1F6B6}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_walking_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'man', 'medium-light skin tone', 'walk', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man walking: medium skin tone', char: '\u{1F6B6}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_walking_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'man', 'medium skin tone', 'walk', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man walking: medium-dark skin tone', char: '\u{1F6B6}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_walking_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['hike', 'man', 'medium-dark skin tone', 'walk', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'man walking: dark skin tone', char: '\u{1F6B6}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_walking_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'hike', 'man', 'walk', 'uc8', 'sport', 'diversity', 'men', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male'], modifiable: true), Emoji(name: 'person with white cane', char: '\u{1F9D1}\u{200D}\u{1F9AF}', shortName:'person_with_probing_cane', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'blind', 'probe', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane']), Emoji(name: 'person with white cane: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F9AF}', shortName:'person_with_probing_cane_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'accessibility', 'diversity', 'cane', 'handicap', 'blind', 'probe', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'person with white cane: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F9AF}', shortName:'person_with_probing_cane_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'blind', 'probe', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'person with white cane: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F9AF}', shortName:'person_with_probing_cane_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'blind', 'probe', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'person with white cane: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F9AF}', shortName:'person_with_probing_cane_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'blind', 'probe', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'person with white cane: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F9AF}', shortName:'person_with_probing_cane_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'blind', 'probe', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'woman with white cane', char: '\u{1F469}\u{200D}\u{1F9AF}', shortName:'woman_with_probing_cane', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane']), Emoji(name: 'woman with white cane: light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F9AF}', shortName:'woman_with_probing_cane_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'cane', 'diversity', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'woman with white cane: medium-light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F9AF}', shortName:'woman_with_probing_cane_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'woman with white cane: medium skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F9AF}', shortName:'woman_with_probing_cane_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'woman with white cane: medium-dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F9AF}', shortName:'woman_with_probing_cane_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'woman with white cane: dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F9AF}', shortName:'woman_with_probing_cane_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'man with white cane', char: '\u{1F468}\u{200D}\u{1F9AF}', shortName:'man_with_probing_cane', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane']), Emoji(name: 'man with white cane: light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F9AF}', shortName:'man_with_probing_cane_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'man with white cane: medium skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F9AF}', shortName:'man_with_probing_cane_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'man with white cane: medium-light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F9AF}', shortName:'man_with_probing_cane_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'man with white cane: medium-dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F9AF}', shortName:'man_with_probing_cane_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'man with white cane: dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F9AF}', shortName:'man_with_probing_cane_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'cane', 'handicap', 'navigate', 'blind', 'probe', 'accessibility', 'diverse', 'modifier', 'modifiers', 'equality', 'disabled', 'disability', 'white cane'], modifiable: true), Emoji(name: 'person kneeling', char: '\u{1F9CE}', shortName:'person_kneeling', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling']), Emoji(name: 'person kneeling: light skin tone', char: '\u{1F9CE}\u{1F3FB}', shortName:'person_kneeling_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'person kneeling: medium-light skin tone', char: '\u{1F9CE}\u{1F3FC}', shortName:'person_kneeling_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'person kneeling: medium skin tone', char: '\u{1F9CE}\u{1F3FD}', shortName:'person_kneeling_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'person kneeling: medium-dark skin tone', char: '\u{1F9CE}\u{1F3FE}', shortName:'person_kneeling_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'person kneeling: dark skin tone', char: '\u{1F9CE}\u{1F3FF}', shortName:'person_kneeling_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'woman kneeling', char: '\u{1F9CE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_kneeling', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling']), Emoji(name: 'woman kneeling: light skin tone', char: '\u{1F9CE}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_kneeling_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'woman kneeling: medium-light skin tone', char: '\u{1F9CE}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_kneeling_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'woman kneeling: medium skin tone', char: '\u{1F9CE}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_kneeling_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'woman kneeling: medium-dark skin tone', char: '\u{1F9CE}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_kneeling_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'woman kneeling: dark skin tone', char: '\u{1F9CE}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_kneeling_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'man kneeling', char: '\u{1F9CE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_kneeling', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling']), Emoji(name: 'man kneeling: light skin tone', char: '\u{1F9CE}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_kneeling_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'man kneeling: medium-light skin tone', char: '\u{1F9CE}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_kneeling_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'man kneeling: medium skin tone', char: '\u{1F9CE}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_kneeling_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'man kneeling: medium-dark skin tone', char: '\u{1F9CE}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_kneeling_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'man kneeling: dark skin tone', char: '\u{1F9CE}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_kneeling_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'sit', 'diverse', 'modifier', 'modifiers', 'equality', 'sitting', 'kneel', 'kneeling'], modifiable: true), Emoji(name: 'person running', char: '\u{1F3C3}', shortName:'person_running', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'running', 'uc6', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner']), Emoji(name: 'person running: light skin tone', char: '\u{1F3C3}\u{1F3FB}', shortName:'person_running_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['light skin tone', 'marathon', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'person running: medium-light skin tone', char: '\u{1F3C3}\u{1F3FC}', shortName:'person_running_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'medium-light skin tone', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'person running: medium skin tone', char: '\u{1F3C3}\u{1F3FD}', shortName:'person_running_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'medium skin tone', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'person running: medium-dark skin tone', char: '\u{1F3C3}\u{1F3FE}', shortName:'person_running_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'medium-dark skin tone', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'person running: dark skin tone', char: '\u{1F3C3}\u{1F3FF}', shortName:'person_running_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'marathon', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'woman running', char: '\u{1F3C3}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_running', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'racing', 'running', 'woman', 'uc6', 'sport', 'diversity', 'women', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'running', 'jog', 'runner']), Emoji(name: 'woman running: light skin tone', char: '\u{1F3C3}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_running_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['light skin tone', 'marathon', 'racing', 'running', 'woman', 'uc8', 'sport', 'diversity', 'women', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'woman running: medium-light skin tone', char: '\u{1F3C3}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_running_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'medium-light skin tone', 'racing', 'running', 'woman', 'uc8', 'sport', 'diversity', 'women', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'woman running: medium skin tone', char: '\u{1F3C3}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_running_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'medium skin tone', 'racing', 'running', 'woman', 'uc8', 'sport', 'diversity', 'women', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'woman running: medium-dark skin tone', char: '\u{1F3C3}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_running_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['marathon', 'medium-dark skin tone', 'racing', 'running', 'woman', 'uc8', 'sport', 'diversity', 'women', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'woman running: dark skin tone', char: '\u{1F3C3}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_running_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'marathon', 'racing', 'running', 'woman', 'uc8', 'sport', 'diversity', 'women', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'woman', 'female', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'man running', char: '\u{1F3C3}\u{200D}\u{2642}\u{FE0F}', shortName:'man_running', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['man', 'marathon', 'racing', 'running', 'uc6', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner']), Emoji(name: 'man running: light skin tone', char: '\u{1F3C3}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_running_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['light skin tone', 'man', 'marathon', 'racing', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'man running: medium-light skin tone', char: '\u{1F3C3}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_running_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['man', 'marathon', 'medium-light skin tone', 'racing', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'man running: medium skin tone', char: '\u{1F3C3}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_running_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['man', 'marathon', 'medium skin tone', 'racing', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'man running: medium-dark skin tone', char: '\u{1F3C3}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_running_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['man', 'marathon', 'medium-dark skin tone', 'racing', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'man running: dark skin tone', char: '\u{1F3C3}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_running_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['dark skin tone', 'man', 'marathon', 'racing', 'running', 'uc8', 'sport', 'diversity', 'men', 'run', 'activity', 'sports', 'exercise', 'athlete', 'athletes', 'athletic', 'team', 'fitness', 'work out', 'workout', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'running', 'jog', 'runner'], modifiable: true), Emoji(name: 'person standing', char: '\u{1F9CD}', shortName:'person_standing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'wife', 'husband', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'person standing: light skin tone', char: '\u{1F9CD}\u{1F3FB}', shortName:'person_standing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'wife', 'husband', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person standing: medium-light skin tone', char: '\u{1F9CD}\u{1F3FC}', shortName:'person_standing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'wife', 'husband', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person standing: medium skin tone', char: '\u{1F9CD}\u{1F3FD}', shortName:'person_standing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'wife', 'husband', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person standing: medium-dark skin tone', char: '\u{1F9CD}\u{1F3FE}', shortName:'person_standing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'wife', 'husband', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'person standing: dark skin tone', char: '\u{1F9CD}\u{1F3FF}', shortName:'person_standing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'wife', 'husband', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman standing', char: '\u{1F9CD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_standing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'human', 'parent', 'wife', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'woman standing: light skin tone', char: '\u{1F9CD}\u{1F3FB}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_standing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'human', 'parent', 'wife', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman standing: medium-light skin tone', char: '\u{1F9CD}\u{1F3FC}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_standing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'human', 'parent', 'wife', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman standing: medium skin tone', char: '\u{1F9CD}\u{1F3FD}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_standing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'human', 'parent', 'wife', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman standing: medium-dark skin tone', char: '\u{1F9CD}\u{1F3FE}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_standing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'human', 'parent', 'wife', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'woman standing: dark skin tone', char: '\u{1F9CD}\u{1F3FF}\u{200D}\u{2640}\u{FE0F}', shortName:'woman_standing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'human', 'parent', 'wife', 'mom', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'man standing', char: '\u{1F9CD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_standing', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult']), Emoji(name: 'man standing: light skin tone', char: '\u{1F9CD}\u{1F3FB}\u{200D}\u{2642}\u{FE0F}', shortName:'man_standing_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man standing: medium-light skin tone', char: '\u{1F9CD}\u{1F3FC}\u{200D}\u{2642}\u{FE0F}', shortName:'man_standing_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man standing: medium skin tone', char: '\u{1F9CD}\u{1F3FD}\u{200D}\u{2642}\u{FE0F}', shortName:'man_standing_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man standing: medium-dark skin tone', char: '\u{1F9CD}\u{1F3FE}\u{200D}\u{2642}\u{FE0F}', shortName:'man_standing_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'man standing: dark skin tone', char: '\u{1F9CD}\u{1F3FF}\u{200D}\u{2642}\u{FE0F}', shortName:'man_standing_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.personActivity, keywords: ['uc12', 'diversity', 'men', 'human', 'daddy', 'parent', 'husband', 'stand', 'diverse', 'modifier', 'modifiers', 'equality', 'man', 'guy', 'guys', 'gentleman', 'male', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands', char: '\u{1F9D1}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}', shortName:'people_holding_hands', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult']), Emoji(name: 'people holding hands: light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'people_holding_hands_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: light skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'people_holding_hands_tone1_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: light skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'people_holding_hands_tone1_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: light skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'people_holding_hands_tone1_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: light skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'people_holding_hands_tone1_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-light skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'people_holding_hands_tone2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'people_holding_hands_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-light skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'people_holding_hands_tone2_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-light skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'people_holding_hands_tone2_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-light skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'people_holding_hands_tone2_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'people_holding_hands_tone3_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'people_holding_hands_tone3_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'people_holding_hands_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'people_holding_hands_tone3_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'people_holding_hands_tone3_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-dark skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'people_holding_hands_tone4_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-dark skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'people_holding_hands_tone4_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-dark skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'people_holding_hands_tone4_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'people_holding_hands_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: medium-dark skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'people_holding_hands_tone4_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: dark skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'people_holding_hands_tone5_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: dark skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'people_holding_hands_tone5_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: dark skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'people_holding_hands_tone5_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: dark skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'people_holding_hands_tone5_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'people holding hands: dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'people_holding_hands_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands', char: '\u{1F46B}', shortName:'couple', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['couple', 'hand', 'hold', 'man', 'woman', 'uc6', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult']), Emoji(name: 'woman and man holding hands: light skin tone', char: '\u{1F46B}\u{1F3FB}', shortName:'woman_and_man_holding_hands_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: light skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'woman_and_man_holding_hands_tone1_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: light skin tone, medium skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'woman_and_man_holding_hands_tone1_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: light skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'woman_and_man_holding_hands_tone1_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: light skin tone, dark skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'woman_and_man_holding_hands_tone1_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-light skin tone, light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'woman_and_man_holding_hands_tone2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-light skin tone', char: '\u{1F46B}\u{1F3FC}', shortName:'woman_and_man_holding_hands_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-light skin tone, medium skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'woman_and_man_holding_hands_tone2_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-light skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'woman_and_man_holding_hands_tone2_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-light skin tone, dark skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'woman_and_man_holding_hands_tone2_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium skin tone, light skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'woman_and_man_holding_hands_tone3_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'woman_and_man_holding_hands_tone3_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium skin tone', char: '\u{1F46B}\u{1F3FD}', shortName:'woman_and_man_holding_hands_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'woman_and_man_holding_hands_tone3_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium skin tone, dark skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'woman_and_man_holding_hands_tone3_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-dark skin tone, light skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'woman_and_man_holding_hands_tone4_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-dark skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'woman_and_man_holding_hands_tone4_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-dark skin tone, medium skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'woman_and_man_holding_hands_tone4_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-dark skin tone', char: '\u{1F46B}\u{1F3FE}', shortName:'woman_and_man_holding_hands_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: medium-dark skin tone, dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'woman_and_man_holding_hands_tone4_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: dark skin tone, light skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'woman_and_man_holding_hands_tone5_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: dark skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'woman_and_man_holding_hands_tone5_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: dark skin tone, medium skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'woman_and_man_holding_hands_tone5_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: dark skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'woman_and_man_holding_hands_tone5_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'woman and man holding hands: dark skin tone', char: '\u{1F46B}\u{1F3FF}', shortName:'woman_and_man_holding_hands_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'creationism', 'friend', 'human', 'parent', 'wife', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'adam & eve', 'adam and eve', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult'], modifiable: true), Emoji(name: 'women holding hands', char: '\u{1F46D}', shortName:'two_women_holding_hands', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['couple', 'hand', 'hold', 'woman', 'uc6', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother']), Emoji(name: 'women holding hands: light skin tone', char: '\u{1F46D}\u{1F3FB}', shortName:'women_holding_hands_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: light skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FC}', shortName:'women_holding_hands_tone1_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: light skin tone, medium skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FD}', shortName:'women_holding_hands_tone1_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: light skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FE}', shortName:'women_holding_hands_tone1_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: light skin tone, dark skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FF}', shortName:'women_holding_hands_tone1_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-light skin tone, light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FB}', shortName:'women_holding_hands_tone2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-light skin tone', char: '\u{1F46D}\u{1F3FC}', shortName:'women_holding_hands_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-light skin tone, medium skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FD}', shortName:'women_holding_hands_tone2_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-light skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FE}', shortName:'women_holding_hands_tone2_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-light skin tone, dark skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FF}', shortName:'women_holding_hands_tone2_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium skin tone, light skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FB}', shortName:'women_holding_hands_tone3_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FC}', shortName:'women_holding_hands_tone3_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium skin tone', char: '\u{1F46D}\u{1F3FD}', shortName:'women_holding_hands_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FE}', shortName:'women_holding_hands_tone3_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium skin tone, dark skin tone', char: '\u{1F469}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FF}', shortName:'women_holding_hands_tone3_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-dark skin tone, light skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FB}', shortName:'women_holding_hands_tone4_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-dark skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FC}', shortName:'women_holding_hands_tone4_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-dark skin tone, medium skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FD}', shortName:'women_holding_hands_tone4_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-dark skin tone', char: '\u{1F46D}\u{1F3FE}', shortName:'women_holding_hands_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: medium-dark skin tone, dark skin tone', char: '\u{1F469}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FF}', shortName:'women_holding_hands_tone4_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: dark skin tone, light skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FB}', shortName:'women_holding_hands_tone5_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: dark skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FC}', shortName:'women_holding_hands_tone5_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: dark skin tone, medium skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FD}', shortName:'women_holding_hands_tone5_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: dark skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F469}\u{1F3FE}', shortName:'women_holding_hands_tone5_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'women holding hands: dark skin tone', char: '\u{1F46D}\u{1F3FF}', shortName:'women_holding_hands_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'lesbian', 'gay', 'women', 'lgbt', 'friend', 'human', 'parent', 'wife', 'mom', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'woman', 'female', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'parents', 'adult', 'maman', 'mommy', 'mama', 'mother'], modifiable: true), Emoji(name: 'men holding hands', char: '\u{1F46C}', shortName:'two_men_holding_hands', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['Gemini', 'couple', 'hand', 'hold', 'man', 'twins', 'zodiac', 'uc6', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult']), Emoji(name: 'men holding hands: light skin tone', char: '\u{1F46C}\u{1F3FB}', shortName:'men_holding_hands_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: light skin tone, medium-light skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'men_holding_hands_tone1_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: light skin tone, medium skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'men_holding_hands_tone1_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: light skin tone, medium-dark skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'men_holding_hands_tone1_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: light skin tone, dark skin tone', char: '\u{1F468}\u{1F3FB}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'men_holding_hands_tone1_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-light skin tone, light skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'men_holding_hands_tone2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-light skin tone', char: '\u{1F46C}\u{1F3FC}', shortName:'men_holding_hands_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-light skin tone, medium skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'men_holding_hands_tone2_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-light skin tone, medium-dark skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'men_holding_hands_tone2_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-light skin tone, dark skin tone', char: '\u{1F468}\u{1F3FC}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'men_holding_hands_tone2_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium skin tone, light skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'men_holding_hands_tone3_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium skin tone, medium-light skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'men_holding_hands_tone3_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium skin tone', char: '\u{1F46C}\u{1F3FD}', shortName:'men_holding_hands_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium skin tone, medium-dark skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'men_holding_hands_tone3_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium skin tone, dark skin tone', char: '\u{1F468}\u{1F3FD}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'men_holding_hands_tone3_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-dark skin tone, light skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'men_holding_hands_tone4_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-dark skin tone, medium-light skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'men_holding_hands_tone4_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-dark skin tone, medium skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'men_holding_hands_tone4_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-dark skin tone', char: '\u{1F46C}\u{1F3FE}', shortName:'men_holding_hands_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: medium-dark skin tone, dark skin tone', char: '\u{1F468}\u{1F3FE}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FF}', shortName:'men_holding_hands_tone4_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: dark skin tone, light skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FB}', shortName:'men_holding_hands_tone5_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: dark skin tone, medium-light skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FC}', shortName:'men_holding_hands_tone5_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: dark skin tone, medium skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FD}', shortName:'men_holding_hands_tone5_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: dark skin tone, medium-dark skin tone', char: '\u{1F468}\u{1F3FF}\u{200D}\u{1F91D}\u{200D}\u{1F468}\u{1F3FE}', shortName:'men_holding_hands_tone5_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'men holding hands: dark skin tone', char: '\u{1F46C}\u{1F3FF}', shortName:'men_holding_hands_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc12', 'family', 'diversity', 'wedding', 'gay', 'men', 'lgbt', 'friend', 'human', 'daddy', 'parent', 'husband', 'families', 'group', 'brother', 'sister', 'daughter', 'son', 'together', 'sibling', 'twins', 'brothers', 'sisters', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'friends', 'friendship', 'best friends', 'bestfriends', 'ami', 'amiga', 'amigo', 'gender', 'people', 'dad', 'papa', 'pere', 'father', 'parents', 'adult'], modifiable: true), Emoji(name: 'couple with heart', char: '\u{1F491}', shortName:'couple_with_heart', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['couple', 'love', 'uc6', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur']), Emoji(name: 'couple with heart: light skin tone', char: '\u{1F491}\u{1F3FB}', shortName:'couple_with_heart_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, light skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'couple_with_heart_person_person_tone1_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, light skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'couple_with_heart_person_person_tone1_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, light skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'couple_with_heart_person_person_tone1_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, light skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'couple_with_heart_person_person_tone1_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-light skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'couple_with_heart_person_person_tone2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: medium-light skin tone', char: '\u{1F491}\u{1F3FC}', shortName:'couple_with_heart_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-light skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'couple_with_heart_person_person_tone2_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-light skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'couple_with_heart_person_person_tone2_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-light skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FC}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'couple_with_heart_person_person_tone2_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'couple_with_heart_person_person_tone3_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'couple_with_heart_person_person_tone3_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: medium skin tone', char: '\u{1F491}\u{1F3FD}', shortName:'couple_with_heart_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'couple_with_heart_person_person_tone3_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FD}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'couple_with_heart_person_person_tone3_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-dark skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'couple_with_heart_person_person_tone4_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-dark skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'couple_with_heart_person_person_tone4_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-dark skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'couple_with_heart_person_person_tone4_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: medium-dark skin tone', char: '\u{1F491}\u{1F3FE}', shortName:'couple_with_heart_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, medium-dark skin tone, dark skin tone', char: '\u{1F9D1}\u{1F3FE}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FF}', shortName:'couple_with_heart_person_person_tone4_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, dark skin tone, light skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FB}', shortName:'couple_with_heart_person_person_tone5_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, dark skin tone, medium-light skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FC}', shortName:'couple_with_heart_person_person_tone5_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, dark skin tone, medium skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FD}', shortName:'couple_with_heart_person_person_tone5_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: person, person, dark skin tone, medium-dark skin tone', char: '\u{1F9D1}\u{1F3FF}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F9D1}\u{1F3FE}', shortName:'couple_with_heart_person_person_tone5_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: dark skin tone', char: '\u{1F491}\u{1F3FF}', shortName:'couple_with_heart_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'lesbian', 'gay', 'men', 'love', 'sex', 'lgbt', 'pink', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'twink', 'man', 'guy', 'guys', 'gentleman', 'male', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'homosexual', 'bisex', 'transgender', 'non binary', 'pansexuality', 'intersex', 'bisexual', 'rose', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: woman, man', char: '\u{1F469}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}', shortName:'couple_with_heart_woman_man', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['couple', 'love', 'man', 'woman', 'uc6', 'diversity', 'wedding', 'love', 'sex', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'hearts', 'serce', 'corazón', 'coração', 'coeur']), Emoji(name: 'couple with heart: woman, man, light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}\u{1F3FB}', shortName:'couple_with_heart_woman_man_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'love', 'sex', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: woman, man, light skin tone, medium-light skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}\u{1F3FC}', shortName:'couple_with_heart_woman_man_tone1_tone2', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'love', 'sex', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: woman, man, light skin tone, medium skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}\u{1F3FD}', shortName:'couple_with_heart_woman_man_tone1_tone3', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'love', 'sex', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: woman, man, light skin tone, medium-dark skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}\u{1F3FE}', shortName:'couple_with_heart_woman_man_tone1_tone4', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'love', 'sex', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: woman, man, light skin tone, dark skin tone', char: '\u{1F469}\u{1F3FB}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}\u{1F3FF}', shortName:'couple_with_heart_woman_man_tone1_tone5', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wedding', 'love', 'sex', 'husband', 'heart', 'diverse', 'modifier', 'modifiers', 'equality', 'weddings', 'marriage', 'newlywed', 'bride', 'groome', 'groom', 'married', 'marry', 'i love you', 'te amo', "je t'aime", 'anniversary', 'lovin', 'amour', 'aimer', 'amor', 'valentines day', 'enamour', 'lovey', 'fuck', 'fucking', 'horny', 'humping', 'hearts', 'serce', 'corazón', 'coração', 'coeur'], modifiable: true), Emoji(name: 'couple with heart: woman, man, medium-light skin tone, light skin tone', char: '\u{1F469}\u{1F3FC}\u{200D}\u{2764}\u{FE0F}\u{200D}\u{1F468}\u{1F3FB}', shortName:'couple_with_heart_woman_man_tone2_tone1', emojiGroup: EmojiGroup.peopleBody, emojiSubgroup: EmojiSubgroup.family, keywords: ['uc13', 'diversity', 'wed