// file generated by src/provider/update.py

use crate::provider::Protocol::*;
use crate::provider::Socket::*;
use crate::provider::UsernamePattern::*;
use crate::provider::{
    Config, ConfigDefault, Oauth2Authorizer, Provider, ProviderOptions, Server, Status,
};
use std::collections::HashMap;

use std::sync::LazyLock;

// 163.md: 163.com
static P_163: Provider = Provider {
    id: "163",
    status: Status::Preparation,
    before_login_hint: "Enable \"POP3/SMTP/IMAP\" on the website, add a third-party auth code and use that as the login password",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/163",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.163.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.163.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// aktivix.org.md: aktivix.org
static P_AKTIVIX_ORG: Provider = Provider {
    id: "aktivix.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/aktivix-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "newyear.aktivix.org",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "newyear.aktivix.org",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// aliyun.md: aliyun.com
static P_ALIYUN: Provider = Provider {
    id: "aliyun",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/aliyun",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.aliyun.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.aliyun.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// aol.md: aol.com
static P_AOL: Provider = Provider {
    id: "aol",
    status: Status::Preparation,
    before_login_hint: "To log in to AOL, you need to set up an app password in the AOL web interface.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/aol",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.aol.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.aol.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// arcor.de.md: arcor.de
static P_ARCOR_DE: Provider = Provider {
    id: "arcor.de",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/arcor-de",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.arcor.de",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.arcor.de",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// autistici.org.md: autistici.org
static P_AUTISTICI_ORG: Provider = Provider {
    id: "autistici.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/autistici-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.autistici.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.autistici.org",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// blindzeln.org.md: delta.blinzeln.de, delta.blindzeln.org
static P_BLINDZELN_ORG: Provider = Provider {
    id: "blindzeln.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/blindzeln-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "webbox222.server-home.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "webbox222.server-home.org",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// bluewin.ch.md: bluewin.ch
static P_BLUEWIN_CH: Provider = Provider {
    id: "bluewin.ch",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/bluewin-ch",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imaps.bluewin.ch",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtpauths.bluewin.ch",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// buzon.uy.md: buzon.uy
static P_BUZON_UY: Provider = Provider {
    id: "buzon.uy",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/buzon-uy",
    server: &[
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "mail.buzon.uy",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "mail.buzon.uy",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// chello.at.md: chello.at
static P_CHELLO_AT: Provider = Provider {
    id: "chello.at",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/chello-at",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.mymagenta.at",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.mymagenta.at",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// comcast.md: xfinity.com, comcast.net
static P_COMCAST: Provider = Provider {
    id: "comcast",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/comcast",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// daleth.cafe.md: daleth.cafe
static P_DALETH_CAFE: Provider = Provider {
    id: "daleth.cafe",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/daleth-cafe",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "daleth.cafe",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "daleth.cafe",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "daleth.cafe",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "daleth.cafe",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// dismail.de.md: dismail.de
static P_DISMAIL_DE: Provider = Provider {
    id: "dismail.de",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/dismail-de",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// disroot.md: disroot.org
static P_DISROOT: Provider = Provider {
    id: "disroot",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/disroot",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "disroot.org",
            port: 993,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "disroot.org",
            port: 587,
            username_pattern: Emaillocalpart,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// e.email.md: e.email
static P_E_EMAIL: Provider = Provider {
    id: "e.email",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/e-email",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.ecloud.global",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "mail.ecloud.global",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// espiv.net.md: espiv.net
static P_ESPIV_NET: Provider = Provider {
    id: "espiv.net",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/espiv-net",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// example.com.md: example.com, example.org, example.net
static P_EXAMPLE_COM: Provider = Provider {
    id: "example.com",
    status: Status::Broken,
    before_login_hint: "Hush this provider doesn't exist!",
    after_login_hint: "This provider doesn't really exist, so you can't use it :/ If you need an email provider, take a look at providers.delta.chat!",
    overview_page: "https://providers.delta.chat/example-com",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.example.com",
            port: 1337,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.example.com",
            port: 1337,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// fastmail.md: 123mail.org, 150mail.com, 150ml.com, 16mail.com, 2-mail.com, 4email.net, 50mail.com, airpost.net, allmail.net, bestmail.us, cluemail.com, elitemail.org, emailcorner.net, emailengine.net, emailengine.org, emailgroups.net, emailplus.org, emailuser.net, eml.cc, f-m.fm, fast-email.com, fast-mail.org, fastem.com, fastemail.us, fastemailer.com, fastest.cc, fastimap.com, fastmail.cn, fastmail.co.uk, fastmail.com, fastmail.com.au, fastmail.de, fastmail.es, fastmail.fm, fastmail.fr, fastmail.im, fastmail.in, fastmail.jp, fastmail.mx, fastmail.net, fastmail.nl, fastmail.org, fastmail.se, fastmail.to, fastmail.tw, fastmail.uk, fastmail.us, fastmailbox.net, fastmessaging.com, fea.st, fmail.co.uk, fmailbox.com, fmgirl.com, fmguy.com, ftml.net, h-mail.us, hailmail.net, imap-mail.com, imap.cc, imapmail.org, inoutbox.com, internet-e-mail.com, internet-mail.org, internetemails.net, internetmailing.net, jetemail.net, justemail.net, letterboxes.org, mail-central.com, mail-page.com, mailandftp.com, mailas.com, mailbolt.com, mailc.net, mailcan.com, mailforce.net, mailftp.com, mailhaven.com, mailingaddress.org, mailite.com, mailmight.com, mailnew.com, mailsent.net, mailservice.ms, mailup.net, mailworks.org, ml1.net, mm.st, myfastmail.com, mymacmail.com, nospammail.net, ownmail.net, petml.com, postinbox.com, postpro.net, proinbox.com, promessage.com, realemail.net, reallyfast.biz, reallyfast.info, rushpost.com, sent.as, sent.at, sent.com, speedpost.net, speedymail.org, ssl-mail.com, swift-mail.com, the-fastest.net, the-quickest.com, theinternetemail.com, veryfast.biz, veryspeedy.net, warpmail.net, xsmail.com, yepmail.net, your-mail.com
static P_FASTMAIL: Provider = Provider {
    id: "fastmail",
    status: Status::Preparation,
    before_login_hint: "You must create an app-specific password before you can log in.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/fastmail",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.fastmail.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.fastmail.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// firemail.de.md: firemail.at, firemail.de
static P_FIREMAIL_DE: Provider = Provider {
    id: "firemail.de",
    status: Status::Preparation,
    before_login_hint: "Firemail erlaubt nur bei bezahlten Accounts den vollen Zugriff auf das E-Mail-Protokoll. Wenn Sie nicht für Firemail bezahlen, verwenden Sie bitte einen anderen E-Mail-Anbieter.",
    after_login_hint: "Leider schränkt Firemail die maximale Gruppengröße ein. Je nach Bezahlmodell sind nur 5 bis 30 Gruppenmitglieder erlaubt.",
    overview_page: "https://providers.delta.chat/firemail-de",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// five.chat.md: five.chat
static P_FIVE_CHAT: Provider = Provider {
    id: "five.chat",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/five-chat",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: Some(&[
        ConfigDefault {
            key: Config::BccSelf,
            value: "1",
        },
        ConfigDefault {
            key: Config::MvboxMove,
            value: "0",
        },
    ]),
    oauth2_authorizer: None,
};

// freenet.de.md: freenet.de
static P_FREENET_DE: Provider = Provider {
    id: "freenet.de",
    status: Status::Preparation,
    before_login_hint: "Um deine freenet.de E-Mail-Adresse zu benutzen, musst du erst auf der freenet.de-Webseite \"POP3/IMAP/SMTP\" aktivieren.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/freenet-de",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mx.freenet.de",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "mx.freenet.de",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mx.freenet.de",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "mx.freenet.de",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// gmail.md: gmail.com, googlemail.com, google.com
static P_GMAIL: Provider = Provider {
    id: "gmail",
    status: Status::Preparation,
    before_login_hint: "For Gmail accounts, you need to have \"2-Step Verification\" enabled and create an app-password.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/gmail",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.gmail.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.gmail.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions {
        delete_to_trash: true,
        ..ProviderOptions::new()
    },
    config_defaults: None,
    oauth2_authorizer: None,
};

// gmx.net.md: gmx.net, gmx.de, gmx.at, gmx.ch, gmx.org, gmx.eu, gmx.info, gmx.biz, gmx.com
static P_GMX_NET: Provider = Provider {
    id: "gmx.net",
    status: Status::Preparation,
    before_login_hint: "You must allow IMAP access to your account before you can login.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/gmx-net",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.gmx.net",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.gmx.net",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "mail.gmx.net",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// hermes.radio.md: *.hermes.radio, *.aco-connexion.org
static P_HERMES_RADIO: Provider = Provider {
    id: "hermes.radio",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/hermes-radio",
    server: &[],
    opt: ProviderOptions {
        strict_tls: false,
        ..ProviderOptions::new()
    },
    config_defaults: Some(&[
        ConfigDefault {
            key: Config::MdnsEnabled,
            value: "0",
        },
        ConfigDefault {
            key: Config::ShowEmails,
            value: "2",
        },
    ]),
    oauth2_authorizer: None,
};

// hey.com.md: hey.com
static P_HEY_COM: Provider = Provider {
    id: "hey.com",
    status: Status::Broken,
    before_login_hint: "hey.com does not offer the standard IMAP e-mail protocol, so you cannot log in to hey.com.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/hey-com",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// i.ua.md: i.ua
static P_I_UA: Provider = Provider {
    id: "i.ua",
    status: Status::Broken,
    before_login_hint: "Протокол IMAP не предоставляется и не планируется.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/i-ua",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// i3.net.md: i3.net
static P_I3_NET: Provider = Provider {
    id: "i3.net",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/i3-net",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// icloud.md: icloud.com, me.com, mac.com
static P_ICLOUD: Provider = Provider {
    id: "icloud",
    status: Status::Preparation,
    before_login_hint: "You must create an app-specific password before login.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/icloud",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mail.me.com",
            port: 993,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.mail.me.com",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// infomaniak.com.md: ik.me
static P_INFOMANIAK_COM: Provider = Provider {
    id: "infomaniak.com",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/infomaniak-com",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.infomaniak.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.infomaniak.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions {
        max_smtp_rcpt_to: Some(10),
        ..ProviderOptions::new()
    },
    config_defaults: None,
    oauth2_authorizer: None,
};

// kolst.com.md: kolst.com
static P_KOLST_COM: Provider = Provider {
    id: "kolst.com",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/kolst-com",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// kontent.com.md: kontent.com
static P_KONTENT_COM: Provider = Provider {
    id: "kontent.com",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/kontent-com",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mail.com.md: email.com, groupmail.com, post.com, homemail.com, housemail.com, writeme.com, mail.com, mail-me.com, workmail.com, accountant.com, activist.com, adexec.com, allergist.com, alumni.com, alumnidirector.com, archaeologist.com, auctioneer.net, bartender.net, brew-master.com, chef.net, chemist.com, collector.org, columnist.com, comic.com, consultant.com, contractor.net, counsellor.com, deliveryman.com, diplomats.com, dr.com, engineer.com, financier.com, fireman.net, gardener.com, geologist.com, graphic-designer.com, graduate.org, hairdresser.net, instructor.net, insurer.com, journalist.com, legislator.com, lobbyist.com, minister.com, musician.org, optician.com, orthodontist.net, pediatrician.com, photographer.net, physicist.net, politician.com, presidency.com, priest.com, programmer.net, publicist.com, radiologist.net, realtyagent.com, registerednurses.com, repairman.com, representative.com, salesperson.net, secretary.net, socialworker.net, sociologist.com, songwriter.net, teachers.org, techie.com, technologist.com, therapist.net, umpire.com, worker.com, artlover.com, bikerider.com, birdlover.com, blader.com, kittymail.com, lovecat.com, marchmail.com, boardermail.com, catlover.com, clubmember.org, nonpartisan.com, petlover.com, doglover.com, greenmail.net, hackermail.com, theplate.com, bsdmail.com, computer4u.com, coolsite.net, cyberdude.com, cybergal.com, cyberservices.com, cyber-wizard.com, linuxmail.org, null.net, solution4u.com, tech-center.com, webname.com, acdcfan.com, angelic.com, discofan.com, elvisfan.com, hiphopfan.com, kissfans.com, madonnafan.com, metalfan.com, ninfan.com, ravemail.com, reggaefan.com, snakebite.com, bellair.net, californiamail.com, dallasmail.com, nycmail.com, pacific-ocean.com, pacificwest.com, sanfranmail.com, usa.com, africamail.com, asia-mail.com, australiamail.com, berlin.com, brazilmail.com, chinamail.com, dublin.com, dutchmail.com, englandmail.com, europe.com, arcticmail.com, europemail.com, germanymail.com, irelandmail.com, israelmail.com, italymail.com, koreamail.com, mexicomail.com, moscowmail.com, munich.com, asia.com, polandmail.com, safrica.com, samerica.com, scotlandmail.com, spainmail.com, swedenmail.com, swissmail.com, torontomail.com, aircraftmail.com, cash4u.com, disposable.com, execs.com, fastservice.com, instruction.com, job4u.com, net-shopping.com, planetmail.com, planetmail.net, qualityservice.com, rescueteam.com, surgical.net, atheist.com, disciples.com, muslim.com, protestant.com, reborn.com, reincarnate.com, religious.com, saintly.com, brew-meister.com, cutey.com, dbzmail.com, doramail.com, galaxyhit.com, hilarious.com, humanoid.net, hot-shot.com, inorbit.com, iname.com, innocent.com, keromail.com, myself.com, rocketship.com, toothfairy.com, toke.com, tvstar.com, uymail.com, 2trom.com
static P_MAIL_COM: Provider = Provider {
    id: "mail.com",
    status: Status::Preparation,
    before_login_hint: "To log in, you first need to activate POP3/IMAP in your mail.com settings. Note that this is a mail.com Premium feature only.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mail-com",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mail.de.md: mail.de
static P_MAIL_DE: Provider = Provider {
    id: "mail.de",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mail-de",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mail.de",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.mail.de",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mail.ru.md: mail.ru, inbox.ru, internet.ru, bk.ru, list.ru
static P_MAIL_RU: Provider = Provider {
    id: "mail.ru",
    status: Status::Preparation,
    before_login_hint: "Вам необходимо сгенерировать \"пароль для внешнего приложения\" в веб-интерфейсе mail.ru, чтобы mail.ru работал с chatmail.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mail-ru",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mail.ru",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.mail.ru",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mail2tor.md: mail2tor.com
static P_MAIL2TOR: Provider = Provider {
    id: "mail2tor",
    status: Status::Preparation,
    before_login_hint: "Tor is needed to connect to the email servers.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mail2tor",
    server: &[
        Server {
            protocol: Imap,
            socket: Plain,
            hostname: "g77kjrad6bafzzyldqvffq6kxlsgphcygptxhnn4xlnktfgaqshilmyd.onion",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Plain,
            hostname: "xc7tgk2c5onxni2wsy76jslfsitxjbbptejnqhw6gy2ft7khpevhc7ad.onion",
            port: 25,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mailbox.org.md: mailbox.org, secure.mailbox.org
static P_MAILBOX_ORG: Provider = Provider {
    id: "mailbox.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mailbox-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mailbox.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.mailbox.org",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mailo.com.md: mailo.com
static P_MAILO_COM: Provider = Provider {
    id: "mailo.com",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mailo-com",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mailo.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.mailo.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mehl.cloud.md: mehl.cloud
static P_MEHL_CLOUD: Provider = Provider {
    id: "mehl.cloud",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/mehl-cloud",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mehl.cloud",
            port: 443,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mehl.cloud",
            port: 443,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mehl.cloud",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mehl.cloud",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "mehl.cloud",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "mehl.cloud",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// mehl.store.md: mehl.store, ende.in.net, l2i.top, szh.homes, sls.post.in, ente.quest, ente.cfd, nein.jetzt
static P_MEHL_STORE: Provider = Provider {
    id: "mehl.store",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "This account provides 3GB storage for eMails and the possibility to access a NEXTCLOUD-instance by using the email-credits!",
    overview_page: "https://providers.delta.chat/mehl-store",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.ende.in.net",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "mail.ende.in.net",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// migadu.md: migadu.com
static P_MIGADU: Provider = Provider {
    id: "migadu",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/migadu",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.migadu.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.migadu.com",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.migadu.com",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// nauta.cu.md: nauta.cu
static P_NAUTA_CU: Provider = Provider {
    id: "nauta.cu",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/nauta-cu",
    server: &[
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "imap.nauta.cu",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.nauta.cu",
            port: 25,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions {
        max_smtp_rcpt_to: Some(20),
        strict_tls: false,
        ..ProviderOptions::new()
    },
    config_defaults: Some(&[
        ConfigDefault {
            key: Config::DeleteServerAfter,
            value: "1",
        },
        ConfigDefault {
            key: Config::MvboxMove,
            value: "0",
        },
        ConfigDefault {
            key: Config::MediaQuality,
            value: "1",
        },
    ]),
    oauth2_authorizer: None,
};

// naver.md: naver.com
static P_NAVER: Provider = Provider {
    id: "naver",
    status: Status::Preparation,
    before_login_hint: "Manually enabling IMAP/SMTP is required.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/naver",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.naver.com",
            port: 993,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.naver.com",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// nine.testrun.org.md: nine.testrun.org
static P_NINE_TESTRUN_ORG: Provider = Provider {
    id: "nine.testrun.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/nine-testrun-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "nine.testrun.org",
            port: 443,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "nine.testrun.org",
            port: 443,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "nine.testrun.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "nine.testrun.org",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "nine.testrun.org",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "nine.testrun.org",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: Some(&[ConfigDefault {
        key: Config::MvboxMove,
        value: "0",
    }]),
    oauth2_authorizer: None,
};

// nubo.coop.md: nubo.coop
static P_NUBO_COOP: Provider = Provider {
    id: "nubo.coop",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/nubo-coop",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.nubo.coop",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.nubo.coop",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// outlook.com.md: hotmail.com, outlook.com, office365.com, outlook.com.tr, live.com, outlook.de
static P_OUTLOOK_COM: Provider = Provider {
    id: "outlook.com",
    status: Status::Broken,
    before_login_hint: "Unfortunately, Outlook does not allow using passwords anymore, per-app-passwords are currently not working.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/outlook-com",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "outlook.office365.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.office365.com",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// ouvaton.coop.md: ouvaton.org
static P_OUVATON_COOP: Provider = Provider {
    id: "ouvaton.coop",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/ouvaton-coop",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.ouvaton.coop",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.ouvaton.coop",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// posteo.md: posteo.de, posteo.af, posteo.at, posteo.be, posteo.ca, posteo.ch, posteo.cl, posteo.co, posteo.co.uk, posteo.com, posteo.com.br, posteo.cr, posteo.cz, posteo.dk, posteo.ee, posteo.es, posteo.eu, posteo.fi, posteo.gl, posteo.gr, posteo.hn, posteo.hr, posteo.hu, posteo.ie, posteo.in, posteo.is, posteo.it, posteo.jp, posteo.la, posteo.li, posteo.lt, posteo.lu, posteo.me, posteo.mx, posteo.my, posteo.net, posteo.nl, posteo.no, posteo.nz, posteo.org, posteo.pe, posteo.pl, posteo.pm, posteo.pt, posteo.ro, posteo.ru, posteo.se, posteo.sg, posteo.si, posteo.tn, posteo.uk, posteo.us
static P_POSTEO: Provider = Provider {
    id: "posteo",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/posteo",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "posteo.de",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "posteo.de",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "posteo.de",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "posteo.de",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// protonmail.md: protonmail.com, protonmail.ch, pm.me
static P_PROTONMAIL: Provider = Provider {
    id: "protonmail",
    status: Status::Broken,
    before_login_hint: "Protonmail does not offer the standard IMAP e-mail protocol, so you cannot log in with to Protonmail.",
    after_login_hint: "To use Protonmail, the IMAP bridge must be running in the background. If you have connectivity issues, double check whether it works as expected.",
    overview_page: "https://providers.delta.chat/protonmail",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// purelymail.com.md: purelymail.com, cheapermail.com, placeq.com, rethinkmail.com, worldofmail.com
static P_PURELYMAIL_COM: Provider = Provider {
    id: "purelymail.com",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/purelymail-com",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.purelymail.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.purelymail.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// qq.md: qq.com, foxmail.com
static P_QQ: Provider = Provider {
    id: "qq",
    status: Status::Preparation,
    before_login_hint: "Manually enabling IMAP/SMTP and creating an app-specific password are required.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/qq",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.qq.com",
            port: 993,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.qq.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// rambler.ru.md: rambler.ru, autorambler.ru, myrambler.ru, rambler.ua, lenta.ru, ro.ru, r0.ru
static P_RAMBLER_RU: Provider = Provider {
    id: "rambler.ru",
    status: Status::Preparation,
    before_login_hint: "Чтобы войти в Рамблер/почта, необходимо предварительно включить доступ с помощью почтовых клиентов на сайте mail.rambler.ru",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/rambler-ru",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.rambler.ru",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.rambler.ru",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "imap.rambler.ru",
            port: 143,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// riseup.net.md: riseup.net
static P_RISEUP_NET: Provider = Provider {
    id: "riseup.net",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/riseup-net",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.riseup.net",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.riseup.net",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// rogers.com.md: rogers.com
static P_ROGERS_COM: Provider = Provider {
    id: "rogers.com",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/rogers-com",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// sonic.md: sonic.net
static P_SONIC: Provider = Provider {
    id: "sonic",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/sonic",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// stinpriza.net.md: stinpriza.net, stinpriza.eu, el-hoyo.net
static P_STINPRIZA_NET: Provider = Provider {
    id: "stinpriza.net",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/stinpriza-net",
    server: &[
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "stinpriza.net",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "stinpriza.net",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions {
        strict_tls: true,
        ..ProviderOptions::new()
    },
    config_defaults: None,
    oauth2_authorizer: None,
};

// systemausfall.org.md: systemausfall.org, solidaris.me
static P_SYSTEMAUSFALL_ORG: Provider = Provider {
    id: "systemausfall.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/systemausfall-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.systemausfall.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.systemausfall.org",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// systemli.org.md: systemli.org
static P_SYSTEMLI_ORG: Provider = Provider {
    id: "systemli.org",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/systemli-org",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "mail.systemli.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "mail.systemli.org",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// t-online.md: t-online.de, magenta.de
static P_T_ONLINE: Provider = Provider {
    id: "t-online",
    status: Status::Preparation,
    before_login_hint: "To use a T-Online email address, you need to create an app password in the web interface.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/t-online",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "secureimap.t-online.de",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "securesmtp.t-online.de",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// testrun.md: testrun.org
static P_TESTRUN: Provider = Provider {
    id: "testrun",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/testrun",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "testrun.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "testrun.org",
            port: 465,
            username_pattern: Email,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "testrun.org",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "testrun.org",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: Some(&[
        ConfigDefault {
            key: Config::BccSelf,
            value: "1",
        },
        ConfigDefault {
            key: Config::MvboxMove,
            value: "0",
        },
    ]),
    oauth2_authorizer: None,
};

// tiscali.it.md: tiscali.it
static P_TISCALI_IT: Provider = Provider {
    id: "tiscali.it",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/tiscali-it",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.tiscali.it",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.tiscali.it",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// tutanota.md: tutanota.com, tutanota.de, tutamail.com, tuta.io, keemail.me
static P_TUTANOTA: Provider = Provider {
    id: "tutanota",
    status: Status::Broken,
    before_login_hint: "Tutanota does not offer the standard IMAP e-mail protocol, so you cannot log in to Tutanota.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/tutanota",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// ukr.net.md: ukr.net
static P_UKR_NET: Provider = Provider {
    id: "ukr.net",
    status: Status::Preparation,
    before_login_hint: "You must allow IMAP access to your account before you can login.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/ukr-net",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.ukr.net",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.ukr.net",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// undernet.uy.md: undernet.uy
static P_UNDERNET_UY: Provider = Provider {
    id: "undernet.uy",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/undernet-uy",
    server: &[
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "undernet.uy",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "undernet.uy",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// vfemail.md: vfemail.net
static P_VFEMAIL: Provider = Provider {
    id: "vfemail",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/vfemail",
    server: &[],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// vivaldi.md: vivaldi.net
static P_VIVALDI: Provider = Provider {
    id: "vivaldi",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/vivaldi",
    server: &[
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "imap.vivaldi.net",
            port: 143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.vivaldi.net",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// vk.com.md: vk.com
static P_VK_COM: Provider = Provider {
    id: "vk.com",
    status: Status::Preparation,
    before_login_hint: "Вам необходимо сгенерировать \"пароль для внешнего приложения\" в веб-интерфейсе mail.ru https://account.mail.ru/user/2-step-auth/passwords/ чтобы vk.com работал с chatmail.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/vk-com",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mail.ru",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.mail.ru",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// vodafone.de.md: vodafone.de, vodafonemail.de
static P_VODAFONE_DE: Provider = Provider {
    id: "vodafone.de",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/vodafone-de",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.vodafonemail.de",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.vodafonemail.de",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// web.de.md: web.de, email.de, flirt.ms, hallo.ms, kuss.ms, love.ms, magic.ms, singles.ms, cool.ms, kanzler.ms, okay.ms, party.ms, pop.ms, stars.ms, techno.ms, clever.ms, deutschland.ms, genial.ms, ich.ms, online.ms, smart.ms, wichtig.ms, action.ms, fussball.ms, joker.ms, planet.ms, power.ms
static P_WEB_DE: Provider = Provider {
    id: "web.de",
    status: Status::Preparation,
    before_login_hint: "You must allow IMAP access to your account before you can login.",
    after_login_hint: "Note: if you have your web.de spam settings too strict, you won't receive contact requests from new people. If you want to receive contact requests, you should disable the \"3-Wege-Spamschutz\" in the web.de settings.  Read how: https://hilfe.web.de/email/spam-und-viren/spamschutz-einstellungen.html",
    overview_page: "https://providers.delta.chat/web-de",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.web.de",
            port: 993,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Imap,
            socket: Starttls,
            hostname: "imap.web.de",
            port: 143,
            username_pattern: Emaillocalpart,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.web.de",
            port: 587,
            username_pattern: Emaillocalpart,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// wkpb.de.md: wkpb.de
static P_WKPB_DE: Provider = Provider {
    id: "wkpb.de",
    status: Status::Preparation,
    before_login_hint: "Dies sind die gleichen Anmeldedaten wie bei Moodle und Abitur-Online.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/wkpb-de",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "pimap.schulon.org",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "psmtp.schulon.org",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// yahoo.md: yahoo.com, yahoo.de, yahoo.it, yahoo.fr, yahoo.es, yahoo.se, yahoo.co.uk, yahoo.co.nz, yahoo.com.au, yahoo.com.ar, yahoo.com.br, yahoo.com.mx, myyahoo.com, ymail.com, rocketmail.com, yahoodns.net
static P_YAHOO: Provider = Provider {
    id: "yahoo",
    status: Status::Preparation,
    before_login_hint: "To use your Yahoo email address you have to create an app password in the Yahoo account security screen.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/yahoo",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.mail.yahoo.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.mail.yahoo.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// yandex.ru.md: yandex.com, yandex.by, yandex.kz, yandex.ru, yandex.ua, ya.ru, narod.ru
static P_YANDEX_RU: Provider = Provider {
    id: "yandex.ru",
    status: Status::Preparation,
    before_login_hint: "For Yandex accounts, you have to set IMAP protocol option turned on.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/yandex-ru",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.yandex.com",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.yandex.com",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: Some(Oauth2Authorizer::Yandex),
};

// yggmail.md: yggmail
static P_YGGMAIL: Provider = Provider {
    id: "yggmail",
    status: Status::Preparation,
    before_login_hint: "An Yggmail companion app needs to be installed on your device to access the Yggmail network.",
    after_login_hint: "Make sure, the Yggmail companion app runs whenever you want to use this account. Note, that you usually cannot write from @yggmail addresses to normal e-mail-addresses (as @gmx.net). However, you can create another account in the normal e-mail-network for this purpose.",
    overview_page: "https://providers.delta.chat/yggmail",
    server: &[
        Server {
            protocol: Imap,
            socket: Plain,
            hostname: "localhost",
            port: 1143,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Plain,
            hostname: "localhost",
            port: 1025,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: Some(&[ConfigDefault {
        key: Config::MvboxMove,
        value: "0",
    }]),
    oauth2_authorizer: None,
};

// ziggo.nl.md: ziggo.nl
static P_ZIGGO_NL: Provider = Provider {
    id: "ziggo.nl",
    status: Status::Ok,
    before_login_hint: "",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/ziggo-nl",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.ziggo.nl",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Starttls,
            hostname: "smtp.ziggo.nl",
            port: 587,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

// zoho.md: zohomail.eu, zohomail.com, zoho.com
static P_ZOHO: Provider = Provider {
    id: "zoho",
    status: Status::Preparation,
    before_login_hint: "To use Zoho Mail, you have to turn on IMAP in the Zoho Mail backend.",
    after_login_hint: "",
    overview_page: "https://providers.delta.chat/zoho",
    server: &[
        Server {
            protocol: Imap,
            socket: Ssl,
            hostname: "imap.zoho.eu",
            port: 993,
            username_pattern: Email,
        },
        Server {
            protocol: Smtp,
            socket: Ssl,
            hostname: "smtp.zoho.eu",
            port: 465,
            username_pattern: Email,
        },
    ],
    opt: ProviderOptions::new(),
    config_defaults: None,
    oauth2_authorizer: None,
};

pub(crate) static PROVIDER_DATA: [(&str, &Provider); 534] = [
    ("163.com", &P_163),
    ("aktivix.org", &P_AKTIVIX_ORG),
    ("aliyun.com", &P_ALIYUN),
    ("aol.com", &P_AOL),
    ("arcor.de", &P_ARCOR_DE),
    ("autistici.org", &P_AUTISTICI_ORG),
    ("delta.blinzeln.de", &P_BLINDZELN_ORG),
    ("delta.blindzeln.org", &P_BLINDZELN_ORG),
    ("bluewin.ch", &P_BLUEWIN_CH),
    ("buzon.uy", &P_BUZON_UY),
    ("chello.at", &P_CHELLO_AT),
    ("xfinity.com", &P_COMCAST),
    ("comcast.net", &P_COMCAST),
    ("daleth.cafe", &P_DALETH_CAFE),
    ("dismail.de", &P_DISMAIL_DE),
    ("disroot.org", &P_DISROOT),
    ("e.email", &P_E_EMAIL),
    ("espiv.net", &P_ESPIV_NET),
    ("example.com", &P_EXAMPLE_COM),
    ("example.org", &P_EXAMPLE_COM),
    ("example.net", &P_EXAMPLE_COM),
    ("123mail.org", &P_FASTMAIL),
    ("150mail.com", &P_FASTMAIL),
    ("150ml.com", &P_FASTMAIL),
    ("16mail.com", &P_FASTMAIL),
    ("2-mail.com", &P_FASTMAIL),
    ("4email.net", &P_FASTMAIL),
    ("50mail.com", &P_FASTMAIL),
    ("airpost.net", &P_FASTMAIL),
    ("allmail.net", &P_FASTMAIL),
    ("bestmail.us", &P_FASTMAIL),
    ("cluemail.com", &P_FASTMAIL),
    ("elitemail.org", &P_FASTMAIL),
    ("emailcorner.net", &P_FASTMAIL),
    ("emailengine.net", &P_FASTMAIL),
    ("emailengine.org", &P_FASTMAIL),
    ("emailgroups.net", &P_FASTMAIL),
    ("emailplus.org", &P_FASTMAIL),
    ("emailuser.net", &P_FASTMAIL),
    ("eml.cc", &P_FASTMAIL),
    ("f-m.fm", &P_FASTMAIL),
    ("fast-email.com", &P_FASTMAIL),
    ("fast-mail.org", &P_FASTMAIL),
    ("fastem.com", &P_FASTMAIL),
    ("fastemail.us", &P_FASTMAIL),
    ("fastemailer.com", &P_FASTMAIL),
    ("fastest.cc", &P_FASTMAIL),
    ("fastimap.com", &P_FASTMAIL),
    ("fastmail.cn", &P_FASTMAIL),
    ("fastmail.co.uk", &P_FASTMAIL),
    ("fastmail.com", &P_FASTMAIL),
    ("fastmail.com.au", &P_FASTMAIL),
    ("fastmail.de", &P_FASTMAIL),
    ("fastmail.es", &P_FASTMAIL),
    ("fastmail.fm", &P_FASTMAIL),
    ("fastmail.fr", &P_FASTMAIL),
    ("fastmail.im", &P_FASTMAIL),
    ("fastmail.in", &P_FASTMAIL),
    ("fastmail.jp", &P_FASTMAIL),
    ("fastmail.mx", &P_FASTMAIL),
    ("fastmail.net", &P_FASTMAIL),
    ("fastmail.nl", &P_FASTMAIL),
    ("fastmail.org", &P_FASTMAIL),
    ("fastmail.se", &P_FASTMAIL),
    ("fastmail.to", &P_FASTMAIL),
    ("fastmail.tw", &P_FASTMAIL),
    ("fastmail.uk", &P_FASTMAIL),
    ("fastmail.us", &P_FASTMAIL),
    ("fastmailbox.net", &P_FASTMAIL),
    ("fastmessaging.com", &P_FASTMAIL),
    ("fea.st", &P_FASTMAIL),
    ("fmail.co.uk", &P_FASTMAIL),
    ("fmailbox.com", &P_FASTMAIL),
    ("fmgirl.com", &P_FASTMAIL),
    ("fmguy.com", &P_FASTMAIL),
    ("ftml.net", &P_FASTMAIL),
    ("h-mail.us", &P_FASTMAIL),
    ("hailmail.net", &P_FASTMAIL),
    ("imap-mail.com", &P_FASTMAIL),
    ("imap.cc", &P_FASTMAIL),
    ("imapmail.org", &P_FASTMAIL),
    ("inoutbox.com", &P_FASTMAIL),
    ("internet-e-mail.com", &P_FASTMAIL),
    ("internet-mail.org", &P_FASTMAIL),
    ("internetemails.net", &P_FASTMAIL),
    ("internetmailing.net", &P_FASTMAIL),
    ("jetemail.net", &P_FASTMAIL),
    ("justemail.net", &P_FASTMAIL),
    ("letterboxes.org", &P_FASTMAIL),
    ("mail-central.com", &P_FASTMAIL),
    ("mail-page.com", &P_FASTMAIL),
    ("mailandftp.com", &P_FASTMAIL),
    ("mailas.com", &P_FASTMAIL),
    ("mailbolt.com", &P_FASTMAIL),
    ("mailc.net", &P_FASTMAIL),
    ("mailcan.com", &P_FASTMAIL),
    ("mailforce.net", &P_FASTMAIL),
    ("mailftp.com", &P_FASTMAIL),
    ("mailhaven.com", &P_FASTMAIL),
    ("mailingaddress.org", &P_FASTMAIL),
    ("mailite.com", &P_FASTMAIL),
    ("mailmight.com", &P_FASTMAIL),
    ("mailnew.com", &P_FASTMAIL),
    ("mailsent.net", &P_FASTMAIL),
    ("mailservice.ms", &P_FASTMAIL),
    ("mailup.net", &P_FASTMAIL),
    ("mailworks.org", &P_FASTMAIL),
    ("ml1.net", &P_FASTMAIL),
    ("mm.st", &P_FASTMAIL),
    ("myfastmail.com", &P_FASTMAIL),
    ("mymacmail.com", &P_FASTMAIL),
    ("nospammail.net", &P_FASTMAIL),
    ("ownmail.net", &P_FASTMAIL),
    ("petml.com", &P_FASTMAIL),
    ("postinbox.com", &P_FASTMAIL),
    ("postpro.net", &P_FASTMAIL),
    ("proinbox.com", &P_FASTMAIL),
    ("promessage.com", &P_FASTMAIL),
    ("realemail.net", &P_FASTMAIL),
    ("reallyfast.biz", &P_FASTMAIL),
    ("reallyfast.info", &P_FASTMAIL),
    ("rushpost.com", &P_FASTMAIL),
    ("sent.as", &P_FASTMAIL),
    ("sent.at", &P_FASTMAIL),
    ("sent.com", &P_FASTMAIL),
    ("speedpost.net", &P_FASTMAIL),
    ("speedymail.org", &P_FASTMAIL),
    ("ssl-mail.com", &P_FASTMAIL),
    ("swift-mail.com", &P_FASTMAIL),
    ("the-fastest.net", &P_FASTMAIL),
    ("the-quickest.com", &P_FASTMAIL),
    ("theinternetemail.com", &P_FASTMAIL),
    ("veryfast.biz", &P_FASTMAIL),
    ("veryspeedy.net", &P_FASTMAIL),
    ("warpmail.net", &P_FASTMAIL),
    ("xsmail.com", &P_FASTMAIL),
    ("yepmail.net", &P_FASTMAIL),
    ("your-mail.com", &P_FASTMAIL),
    ("firemail.at", &P_FIREMAIL_DE),
    ("firemail.de", &P_FIREMAIL_DE),
    ("five.chat", &P_FIVE_CHAT),
    ("freenet.de", &P_FREENET_DE),
    ("gmail.com", &P_GMAIL),
    ("googlemail.com", &P_GMAIL),
    ("google.com", &P_GMAIL),
    ("gmx.net", &P_GMX_NET),
    ("gmx.de", &P_GMX_NET),
    ("gmx.at", &P_GMX_NET),
    ("gmx.ch", &P_GMX_NET),
    ("gmx.org", &P_GMX_NET),
    ("gmx.eu", &P_GMX_NET),
    ("gmx.info", &P_GMX_NET),
    ("gmx.biz", &P_GMX_NET),
    ("gmx.com", &P_GMX_NET),
    ("*.hermes.radio", &P_HERMES_RADIO),
    ("*.aco-connexion.org", &P_HERMES_RADIO),
    ("hey.com", &P_HEY_COM),
    ("i.ua", &P_I_UA),
    ("i3.net", &P_I3_NET),
    ("icloud.com", &P_ICLOUD),
    ("me.com", &P_ICLOUD),
    ("mac.com", &P_ICLOUD),
    ("ik.me", &P_INFOMANIAK_COM),
    ("kolst.com", &P_KOLST_COM),
    ("kontent.com", &P_KONTENT_COM),
    ("email.com", &P_MAIL_COM),
    ("groupmail.com", &P_MAIL_COM),
    ("post.com", &P_MAIL_COM),
    ("homemail.com", &P_MAIL_COM),
    ("housemail.com", &P_MAIL_COM),
    ("writeme.com", &P_MAIL_COM),
    ("mail.com", &P_MAIL_COM),
    ("mail-me.com", &P_MAIL_COM),
    ("workmail.com", &P_MAIL_COM),
    ("accountant.com", &P_MAIL_COM),
    ("activist.com", &P_MAIL_COM),
    ("adexec.com", &P_MAIL_COM),
    ("allergist.com", &P_MAIL_COM),
    ("alumni.com", &P_MAIL_COM),
    ("alumnidirector.com", &P_MAIL_COM),
    ("archaeologist.com", &P_MAIL_COM),
    ("auctioneer.net", &P_MAIL_COM),
    ("bartender.net", &P_MAIL_COM),
    ("brew-master.com", &P_MAIL_COM),
    ("chef.net", &P_MAIL_COM),
    ("chemist.com", &P_MAIL_COM),
    ("collector.org", &P_MAIL_COM),
    ("columnist.com", &P_MAIL_COM),
    ("comic.com", &P_MAIL_COM),
    ("consultant.com", &P_MAIL_COM),
    ("contractor.net", &P_MAIL_COM),
    ("counsellor.com", &P_MAIL_COM),
    ("deliveryman.com", &P_MAIL_COM),
    ("diplomats.com", &P_MAIL_COM),
    ("dr.com", &P_MAIL_COM),
    ("engineer.com", &P_MAIL_COM),
    ("financier.com", &P_MAIL_COM),
    ("fireman.net", &P_MAIL_COM),
    ("gardener.com", &P_MAIL_COM),
    ("geologist.com", &P_MAIL_COM),
    ("graphic-designer.com", &P_MAIL_COM),
    ("graduate.org", &P_MAIL_COM),
    ("hairdresser.net", &P_MAIL_COM),
    ("instructor.net", &P_MAIL_COM),
    ("insurer.com", &P_MAIL_COM),
    ("journalist.com", &P_MAIL_COM),
    ("legislator.com", &P_MAIL_COM),
    ("lobbyist.com", &P_MAIL_COM),
    ("minister.com", &P_MAIL_COM),
    ("musician.org", &P_MAIL_COM),
    ("optician.com", &P_MAIL_COM),
    ("orthodontist.net", &P_MAIL_COM),
    ("pediatrician.com", &P_MAIL_COM),
    ("photographer.net", &P_MAIL_COM),
    ("physicist.net", &P_MAIL_COM),
    ("politician.com", &P_MAIL_COM),
    ("presidency.com", &P_MAIL_COM),
    ("priest.com", &P_MAIL_COM),
    ("programmer.net", &P_MAIL_COM),
    ("publicist.com", &P_MAIL_COM),
    ("radiologist.net", &P_MAIL_COM),
    ("realtyagent.com", &P_MAIL_COM),
    ("registerednurses.com", &P_MAIL_COM),
    ("repairman.com", &P_MAIL_COM),
    ("representative.com", &P_MAIL_COM),
    ("salesperson.net", &P_MAIL_COM),
    ("secretary.net", &P_MAIL_COM),
    ("socialworker.net", &P_MAIL_COM),
    ("sociologist.com", &P_MAIL_COM),
    ("songwriter.net", &P_MAIL_COM),
    ("teachers.org", &P_MAIL_COM),
    ("techie.com", &P_MAIL_COM),
    ("technologist.com", &P_MAIL_COM),
    ("therapist.net", &P_MAIL_COM),
    ("umpire.com", &P_MAIL_COM),
    ("worker.com", &P_MAIL_COM),
    ("artlover.com", &P_MAIL_COM),
    ("bikerider.com", &P_MAIL_COM),
    ("birdlover.com", &P_MAIL_COM),
    ("blader.com", &P_MAIL_COM),
    ("kittymail.com", &P_MAIL_COM),
    ("lovecat.com", &P_MAIL_COM),
    ("marchmail.com", &P_MAIL_COM),
    ("boardermail.com", &P_MAIL_COM),
    ("catlover.com", &P_MAIL_COM),
    ("clubmember.org", &P_MAIL_COM),
    ("nonpartisan.com", &P_MAIL_COM),
    ("petlover.com", &P_MAIL_COM),
    ("doglover.com", &P_MAIL_COM),
    ("greenmail.net", &P_MAIL_COM),
    ("hackermail.com", &P_MAIL_COM),
    ("theplate.com", &P_MAIL_COM),
    ("bsdmail.com", &P_MAIL_COM),
    ("computer4u.com", &P_MAIL_COM),
    ("coolsite.net", &P_MAIL_COM),
    ("cyberdude.com", &P_MAIL_COM),
    ("cybergal.com", &P_MAIL_COM),
    ("cyberservices.com", &P_MAIL_COM),
    ("cyber-wizard.com", &P_MAIL_COM),
    ("linuxmail.org", &P_MAIL_COM),
    ("null.net", &P_MAIL_COM),
    ("solution4u.com", &P_MAIL_COM),
    ("tech-center.com", &P_MAIL_COM),
    ("webname.com", &P_MAIL_COM),
    ("acdcfan.com", &P_MAIL_COM),
    ("angelic.com", &P_MAIL_COM),
    ("discofan.com", &P_MAIL_COM),
    ("elvisfan.com", &P_MAIL_COM),
    ("hiphopfan.com", &P_MAIL_COM),
    ("kissfans.com", &P_MAIL_COM),
    ("madonnafan.com", &P_MAIL_COM),
    ("metalfan.com", &P_MAIL_COM),
    ("ninfan.com", &P_MAIL_COM),
    ("ravemail.com", &P_MAIL_COM),
    ("reggaefan.com", &P_MAIL_COM),
    ("snakebite.com", &P_MAIL_COM),
    ("bellair.net", &P_MAIL_COM),
    ("californiamail.com", &P_MAIL_COM),
    ("dallasmail.com", &P_MAIL_COM),
    ("nycmail.com", &P_MAIL_COM),
    ("pacific-ocean.com", &P_MAIL_COM),
    ("pacificwest.com", &P_MAIL_COM),
    ("sanfranmail.com", &P_MAIL_COM),
    ("usa.com", &P_MAIL_COM),
    ("africamail.com", &P_MAIL_COM),
    ("asia-mail.com", &P_MAIL_COM),
    ("australiamail.com", &P_MAIL_COM),
    ("berlin.com", &P_MAIL_COM),
    ("brazilmail.com", &P_MAIL_COM),
    ("chinamail.com", &P_MAIL_COM),
    ("dublin.com", &P_MAIL_COM),
    ("dutchmail.com", &P_MAIL_COM),
    ("englandmail.com", &P_MAIL_COM),
    ("europe.com", &P_MAIL_COM),
    ("arcticmail.com", &P_MAIL_COM),
    ("europemail.com", &P_MAIL_COM),
    ("germanymail.com", &P_MAIL_COM),
    ("irelandmail.com", &P_MAIL_COM),
    ("israelmail.com", &P_MAIL_COM),
    ("italymail.com", &P_MAIL_COM),
    ("koreamail.com", &P_MAIL_COM),
    ("mexicomail.com", &P_MAIL_COM),
    ("moscowmail.com", &P_MAIL_COM),
    ("munich.com", &P_MAIL_COM),
    ("asia.com", &P_MAIL_COM),
    ("polandmail.com", &P_MAIL_COM),
    ("safrica.com", &P_MAIL_COM),
    ("samerica.com", &P_MAIL_COM),
    ("scotlandmail.com", &P_MAIL_COM),
    ("spainmail.com", &P_MAIL_COM),
    ("swedenmail.com", &P_MAIL_COM),
    ("swissmail.com", &P_MAIL_COM),
    ("torontomail.com", &P_MAIL_COM),
    ("aircraftmail.com", &P_MAIL_COM),
    ("cash4u.com", &P_MAIL_COM),
    ("disposable.com", &P_MAIL_COM),
    ("execs.com", &P_MAIL_COM),
    ("fastservice.com", &P_MAIL_COM),
    ("instruction.com", &P_MAIL_COM),
    ("job4u.com", &P_MAIL_COM),
    ("net-shopping.com", &P_MAIL_COM),
    ("planetmail.com", &P_MAIL_COM),
    ("planetmail.net", &P_MAIL_COM),
    ("qualityservice.com", &P_MAIL_COM),
    ("rescueteam.com", &P_MAIL_COM),
    ("surgical.net", &P_MAIL_COM),
    ("atheist.com", &P_MAIL_COM),
    ("disciples.com", &P_MAIL_COM),
    ("muslim.com", &P_MAIL_COM),
    ("protestant.com", &P_MAIL_COM),
    ("reborn.com", &P_MAIL_COM),
    ("reincarnate.com", &P_MAIL_COM),
    ("religious.com", &P_MAIL_COM),
    ("saintly.com", &P_MAIL_COM),
    ("brew-meister.com", &P_MAIL_COM),
    ("cutey.com", &P_MAIL_COM),
    ("dbzmail.com", &P_MAIL_COM),
    ("doramail.com", &P_MAIL_COM),
    ("galaxyhit.com", &P_MAIL_COM),
    ("hilarious.com", &P_MAIL_COM),
    ("humanoid.net", &P_MAIL_COM),
    ("hot-shot.com", &P_MAIL_COM),
    ("inorbit.com", &P_MAIL_COM),
    ("iname.com", &P_MAIL_COM),
    ("innocent.com", &P_MAIL_COM),
    ("keromail.com", &P_MAIL_COM),
    ("myself.com", &P_MAIL_COM),
    ("rocketship.com", &P_MAIL_COM),
    ("toothfairy.com", &P_MAIL_COM),
    ("toke.com", &P_MAIL_COM),
    ("tvstar.com", &P_MAIL_COM),
    ("uymail.com", &P_MAIL_COM),
    ("2trom.com", &P_MAIL_COM),
    ("mail.de", &P_MAIL_DE),
    ("mail.ru", &P_MAIL_RU),
    ("inbox.ru", &P_MAIL_RU),
    ("internet.ru", &P_MAIL_RU),
    ("bk.ru", &P_MAIL_RU),
    ("list.ru", &P_MAIL_RU),
    ("mail2tor.com", &P_MAIL2TOR),
    ("mailbox.org", &P_MAILBOX_ORG),
    ("secure.mailbox.org", &P_MAILBOX_ORG),
    ("mailo.com", &P_MAILO_COM),
    ("mehl.cloud", &P_MEHL_CLOUD),
    ("mehl.store", &P_MEHL_STORE),
    ("ende.in.net", &P_MEHL_STORE),
    ("l2i.top", &P_MEHL_STORE),
    ("szh.homes", &P_MEHL_STORE),
    ("sls.post.in", &P_MEHL_STORE),
    ("ente.quest", &P_MEHL_STORE),
    ("ente.cfd", &P_MEHL_STORE),
    ("nein.jetzt", &P_MEHL_STORE),
    ("migadu.com", &P_MIGADU),
    ("nauta.cu", &P_NAUTA_CU),
    ("naver.com", &P_NAVER),
    ("nine.testrun.org", &P_NINE_TESTRUN_ORG),
    ("nubo.coop", &P_NUBO_COOP),
    ("hotmail.com", &P_OUTLOOK_COM),
    ("outlook.com", &P_OUTLOOK_COM),
    ("office365.com", &P_OUTLOOK_COM),
    ("outlook.com.tr", &P_OUTLOOK_COM),
    ("live.com", &P_OUTLOOK_COM),
    ("outlook.de", &P_OUTLOOK_COM),
    ("ouvaton.org", &P_OUVATON_COOP),
    ("posteo.de", &P_POSTEO),
    ("posteo.af", &P_POSTEO),
    ("posteo.at", &P_POSTEO),
    ("posteo.be", &P_POSTEO),
    ("posteo.ca", &P_POSTEO),
    ("posteo.ch", &P_POSTEO),
    ("posteo.cl", &P_POSTEO),
    ("posteo.co", &P_POSTEO),
    ("posteo.co.uk", &P_POSTEO),
    ("posteo.com", &P_POSTEO),
    ("posteo.com.br", &P_POSTEO),
    ("posteo.cr", &P_POSTEO),
    ("posteo.cz", &P_POSTEO),
    ("posteo.dk", &P_POSTEO),
    ("posteo.ee", &P_POSTEO),
    ("posteo.es", &P_POSTEO),
    ("posteo.eu", &P_POSTEO),
    ("posteo.fi", &P_POSTEO),
    ("posteo.gl", &P_POSTEO),
    ("posteo.gr", &P_POSTEO),
    ("posteo.hn", &P_POSTEO),
    ("posteo.hr", &P_POSTEO),
    ("posteo.hu", &P_POSTEO),
    ("posteo.ie", &P_POSTEO),
    ("posteo.in", &P_POSTEO),
    ("posteo.is", &P_POSTEO),
    ("posteo.it", &P_POSTEO),
    ("posteo.jp", &P_POSTEO),
    ("posteo.la", &P_POSTEO),
    ("posteo.li", &P_POSTEO),
    ("posteo.lt", &P_POSTEO),
    ("posteo.lu", &P_POSTEO),
    ("posteo.me", &P_POSTEO),
    ("posteo.mx", &P_POSTEO),
    ("posteo.my", &P_POSTEO),
    ("posteo.net", &P_POSTEO),
    ("posteo.nl", &P_POSTEO),
    ("posteo.no", &P_POSTEO),
    ("posteo.nz", &P_POSTEO),
    ("posteo.org", &P_POSTEO),
    ("posteo.pe", &P_POSTEO),
    ("posteo.pl", &P_POSTEO),
    ("posteo.pm", &P_POSTEO),
    ("posteo.pt", &P_POSTEO),
    ("posteo.ro", &P_POSTEO),
    ("posteo.ru", &P_POSTEO),
    ("posteo.se", &P_POSTEO),
    ("posteo.sg", &P_POSTEO),
    ("posteo.si", &P_POSTEO),
    ("posteo.tn", &P_POSTEO),
    ("posteo.uk", &P_POSTEO),
    ("posteo.us", &P_POSTEO),
    ("protonmail.com", &P_PROTONMAIL),
    ("protonmail.ch", &P_PROTONMAIL),
    ("pm.me", &P_PROTONMAIL),
    ("purelymail.com", &P_PURELYMAIL_COM),
    ("cheapermail.com", &P_PURELYMAIL_COM),
    ("placeq.com", &P_PURELYMAIL_COM),
    ("rethinkmail.com", &P_PURELYMAIL_COM),
    ("worldofmail.com", &P_PURELYMAIL_COM),
    ("qq.com", &P_QQ),
    ("foxmail.com", &P_QQ),
    ("rambler.ru", &P_RAMBLER_RU),
    ("autorambler.ru", &P_RAMBLER_RU),
    ("myrambler.ru", &P_RAMBLER_RU),
    ("rambler.ua", &P_RAMBLER_RU),
    ("lenta.ru", &P_RAMBLER_RU),
    ("ro.ru", &P_RAMBLER_RU),
    ("r0.ru", &P_RAMBLER_RU),
    ("riseup.net", &P_RISEUP_NET),
    ("rogers.com", &P_ROGERS_COM),
    ("sonic.net", &P_SONIC),
    ("stinpriza.net", &P_STINPRIZA_NET),
    ("stinpriza.eu", &P_STINPRIZA_NET),
    ("el-hoyo.net", &P_STINPRIZA_NET),
    ("systemausfall.org", &P_SYSTEMAUSFALL_ORG),
    ("solidaris.me", &P_SYSTEMAUSFALL_ORG),
    ("systemli.org", &P_SYSTEMLI_ORG),
    ("t-online.de", &P_T_ONLINE),
    ("magenta.de", &P_T_ONLINE),
    ("testrun.org", &P_TESTRUN),
    ("tiscali.it", &P_TISCALI_IT),
    ("tutanota.com", &P_TUTANOTA),
    ("tutanota.de", &P_TUTANOTA),
    ("tutamail.com", &P_TUTANOTA),
    ("tuta.io", &P_TUTANOTA),
    ("keemail.me", &P_TUTANOTA),
    ("ukr.net", &P_UKR_NET),
    ("undernet.uy", &P_UNDERNET_UY),
    ("vfemail.net", &P_VFEMAIL),
    ("vivaldi.net", &P_VIVALDI),
    ("vk.com", &P_VK_COM),
    ("vodafone.de", &P_VODAFONE_DE),
    ("vodafonemail.de", &P_VODAFONE_DE),
    ("web.de", &P_WEB_DE),
    ("email.de", &P_WEB_DE),
    ("flirt.ms", &P_WEB_DE),
    ("hallo.ms", &P_WEB_DE),
    ("kuss.ms", &P_WEB_DE),
    ("love.ms", &P_WEB_DE),
    ("magic.ms", &P_WEB_DE),
    ("singles.ms", &P_WEB_DE),
    ("cool.ms", &P_WEB_DE),
    ("kanzler.ms", &P_WEB_DE),
    ("okay.ms", &P_WEB_DE),
    ("party.ms", &P_WEB_DE),
    ("pop.ms", &P_WEB_DE),
    ("stars.ms", &P_WEB_DE),
    ("techno.ms", &P_WEB_DE),
    ("clever.ms", &P_WEB_DE),
    ("deutschland.ms", &P_WEB_DE),
    ("genial.ms", &P_WEB_DE),
    ("ich.ms", &P_WEB_DE),
    ("online.ms", &P_WEB_DE),
    ("smart.ms", &P_WEB_DE),
    ("wichtig.ms", &P_WEB_DE),
    ("action.ms", &P_WEB_DE),
    ("fussball.ms", &P_WEB_DE),
    ("joker.ms", &P_WEB_DE),
    ("planet.ms", &P_WEB_DE),
    ("power.ms", &P_WEB_DE),
    ("wkpb.de", &P_WKPB_DE),
    ("yahoo.com", &P_YAHOO),
    ("yahoo.de", &P_YAHOO),
    ("yahoo.it", &P_YAHOO),
    ("yahoo.fr", &P_YAHOO),
    ("yahoo.es", &P_YAHOO),
    ("yahoo.se", &P_YAHOO),
    ("yahoo.co.uk", &P_YAHOO),
    ("yahoo.co.nz", &P_YAHOO),
    ("yahoo.com.au", &P_YAHOO),
    ("yahoo.com.ar", &P_YAHOO),
    ("yahoo.com.br", &P_YAHOO),
    ("yahoo.com.mx", &P_YAHOO),
    ("myyahoo.com", &P_YAHOO),
    ("ymail.com", &P_YAHOO),
    ("rocketmail.com", &P_YAHOO),
    ("yahoodns.net", &P_YAHOO),
    ("yandex.com", &P_YANDEX_RU),
    ("yandex.by", &P_YANDEX_RU),
    ("yandex.kz", &P_YANDEX_RU),
    ("yandex.ru", &P_YANDEX_RU),
    ("yandex.ua", &P_YANDEX_RU),
    ("ya.ru", &P_YANDEX_RU),
    ("narod.ru", &P_YANDEX_RU),
    ("yggmail", &P_YGGMAIL),
    ("ziggo.nl", &P_ZIGGO_NL),
    ("zohomail.eu", &P_ZOHO),
    ("zohomail.com", &P_ZOHO),
    ("zoho.com", &P_ZOHO),
];

pub(crate) static PROVIDER_IDS: LazyLock<HashMap<&'static str, &'static Provider>> =
    LazyLock::new(|| {
        HashMap::from([
            ("163", &P_163),
            ("aktivix.org", &P_AKTIVIX_ORG),
            ("aliyun", &P_ALIYUN),
            ("aol", &P_AOL),
            ("arcor.de", &P_ARCOR_DE),
            ("autistici.org", &P_AUTISTICI_ORG),
            ("blindzeln.org", &P_BLINDZELN_ORG),
            ("bluewin.ch", &P_BLUEWIN_CH),
            ("buzon.uy", &P_BUZON_UY),
            ("chello.at", &P_CHELLO_AT),
            ("comcast", &P_COMCAST),
            ("daleth.cafe", &P_DALETH_CAFE),
            ("dismail.de", &P_DISMAIL_DE),
            ("disroot", &P_DISROOT),
            ("e.email", &P_E_EMAIL),
            ("espiv.net", &P_ESPIV_NET),
            ("example.com", &P_EXAMPLE_COM),
            ("fastmail", &P_FASTMAIL),
            ("firemail.de", &P_FIREMAIL_DE),
            ("five.chat", &P_FIVE_CHAT),
            ("freenet.de", &P_FREENET_DE),
            ("gmail", &P_GMAIL),
            ("gmx.net", &P_GMX_NET),
            ("hermes.radio", &P_HERMES_RADIO),
            ("hey.com", &P_HEY_COM),
            ("i.ua", &P_I_UA),
            ("i3.net", &P_I3_NET),
            ("icloud", &P_ICLOUD),
            ("infomaniak.com", &P_INFOMANIAK_COM),
            ("kolst.com", &P_KOLST_COM),
            ("kontent.com", &P_KONTENT_COM),
            ("mail.com", &P_MAIL_COM),
            ("mail.de", &P_MAIL_DE),
            ("mail.ru", &P_MAIL_RU),
            ("mail2tor", &P_MAIL2TOR),
            ("mailbox.org", &P_MAILBOX_ORG),
            ("mailo.com", &P_MAILO_COM),
            ("mehl.cloud", &P_MEHL_CLOUD),
            ("mehl.store", &P_MEHL_STORE),
            ("migadu", &P_MIGADU),
            ("nauta.cu", &P_NAUTA_CU),
            ("naver", &P_NAVER),
            ("nine.testrun.org", &P_NINE_TESTRUN_ORG),
            ("nubo.coop", &P_NUBO_COOP),
            ("outlook.com", &P_OUTLOOK_COM),
            ("ouvaton.coop", &P_OUVATON_COOP),
            ("posteo", &P_POSTEO),
            ("protonmail", &P_PROTONMAIL),
            ("purelymail.com", &P_PURELYMAIL_COM),
            ("qq", &P_QQ),
            ("rambler.ru", &P_RAMBLER_RU),
            ("riseup.net", &P_RISEUP_NET),
            ("rogers.com", &P_ROGERS_COM),
            ("sonic", &P_SONIC),
            ("stinpriza.net", &P_STINPRIZA_NET),
            ("systemausfall.org", &P_SYSTEMAUSFALL_ORG),
            ("systemli.org", &P_SYSTEMLI_ORG),
            ("t-online", &P_T_ONLINE),
            ("testrun", &P_TESTRUN),
            ("tiscali.it", &P_TISCALI_IT),
            ("tutanota", &P_TUTANOTA),
            ("ukr.net", &P_UKR_NET),
            ("undernet.uy", &P_UNDERNET_UY),
            ("vfemail", &P_VFEMAIL),
            ("vivaldi", &P_VIVALDI),
            ("vk.com", &P_VK_COM),
            ("vodafone.de", &P_VODAFONE_DE),
            ("web.de", &P_WEB_DE),
            ("wkpb.de", &P_WKPB_DE),
            ("yahoo", &P_YAHOO),
            ("yandex.ru", &P_YANDEX_RU),
            ("yggmail", &P_YGGMAIL),
            ("ziggo.nl", &P_ZIGGO_NL),
            ("zoho", &P_ZOHO),
        ])
    });

pub static _PROVIDER_UPDATED: LazyLock<chrono::NaiveDate> =
    LazyLock::new(|| chrono::NaiveDate::from_ymd_opt(2025, 9, 10).unwrap());
