/* Autogenerated file, do not edit manually */
package chat.delta.rpc.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;

@JsonTypeInfo(use=Id.NAME, include=As.PROPERTY, property="kind")
@JsonSubTypes({@Type(value = EventType.Info.class, name="Info"), @Type(value = EventType.SmtpConnected.class, name="SmtpConnected"), @Type(value = EventType.ImapConnected.class, name="ImapConnected"), @Type(value = EventType.SmtpMessageSent.class, name="SmtpMessageSent"), @Type(value = EventType.ImapMessageDeleted.class, name="ImapMessageDeleted"), @Type(value = EventType.ImapMessageMoved.class, name="ImapMessageMoved"), @Type(value = EventType.ImapInboxIdle.class, name="ImapInboxIdle"), @Type(value = EventType.NewBlobFile.class, name="NewBlobFile"), @Type(value = EventType.DeletedBlobFile.class, name="DeletedBlobFile"), @Type(value = EventType.Warning.class, name="Warning"), @Type(value = EventType.Error.class, name="Error"), @Type(value = EventType.ErrorSelfNotInGroup.class, name="ErrorSelfNotInGroup"), @Type(value = EventType.MsgsChanged.class, name="MsgsChanged"), @Type(value = EventType.ReactionsChanged.class, name="ReactionsChanged"), @Type(value = EventType.IncomingReaction.class, name="IncomingReaction"), @Type(value = EventType.IncomingWebxdcNotify.class, name="IncomingWebxdcNotify"), @Type(value = EventType.IncomingMsg.class, name="IncomingMsg"), @Type(value = EventType.IncomingMsgBunch.class, name="IncomingMsgBunch"), @Type(value = EventType.MsgsNoticed.class, name="MsgsNoticed"), @Type(value = EventType.MsgDelivered.class, name="MsgDelivered"), @Type(value = EventType.MsgFailed.class, name="MsgFailed"), @Type(value = EventType.MsgRead.class, name="MsgRead"), @Type(value = EventType.MsgDeleted.class, name="MsgDeleted"), @Type(value = EventType.ChatModified.class, name="ChatModified"), @Type(value = EventType.ChatEphemeralTimerModified.class, name="ChatEphemeralTimerModified"), @Type(value = EventType.ChatDeleted.class, name="ChatDeleted"), @Type(value = EventType.ContactsChanged.class, name="ContactsChanged"), @Type(value = EventType.LocationChanged.class, name="LocationChanged"), @Type(value = EventType.ConfigureProgress.class, name="ConfigureProgress"), @Type(value = EventType.ImexProgress.class, name="ImexProgress"), @Type(value = EventType.ImexFileWritten.class, name="ImexFileWritten"), @Type(value = EventType.SecurejoinInviterProgress.class, name="SecurejoinInviterProgress"), @Type(value = EventType.SecurejoinJoinerProgress.class, name="SecurejoinJoinerProgress"), @Type(value = EventType.ConnectivityChanged.class, name="ConnectivityChanged"), @Type(value = EventType.SelfavatarChanged.class, name="SelfavatarChanged"), @Type(value = EventType.ConfigSynced.class, name="ConfigSynced"), @Type(value = EventType.WebxdcStatusUpdate.class, name="WebxdcStatusUpdate"), @Type(value = EventType.WebxdcRealtimeData.class, name="WebxdcRealtimeData"), @Type(value = EventType.WebxdcRealtimeAdvertisementReceived.class, name="WebxdcRealtimeAdvertisementReceived"), @Type(value = EventType.WebxdcInstanceDeleted.class, name="WebxdcInstanceDeleted"), @Type(value = EventType.AccountsBackgroundFetchDone.class, name="AccountsBackgroundFetchDone"), @Type(value = EventType.ChatlistChanged.class, name="ChatlistChanged"), @Type(value = EventType.ChatlistItemChanged.class, name="ChatlistItemChanged"), @Type(value = EventType.AccountsChanged.class, name="AccountsChanged"), @Type(value = EventType.AccountsItemChanged.class, name="AccountsItemChanged"), @Type(value = EventType.EventChannelOverflow.class, name="EventChannelOverflow"), @Type(value = EventType.IncomingCall.class, name="IncomingCall"), @Type(value = EventType.IncomingCallAccepted.class, name="IncomingCallAccepted"), @Type(value = EventType.OutgoingCallAccepted.class, name="OutgoingCallAccepted"), @Type(value = EventType.CallEnded.class, name="CallEnded"), @Type(value = EventType.TransportsModified.class, name="TransportsModified")})
public abstract class EventType {

/**
 * The library-user may write an informational string to the log.
 * <p>
 * This event should *not* be reported to the end-user using a popup or something like that.
 */
  public static class Info extends EventType {
    public String msg;
  }

/* Emitted when SMTP connection is established and login was successful. */
  public static class SmtpConnected extends EventType {
    public String msg;
  }

/* Emitted when IMAP connection is established and login was successful. */
  public static class ImapConnected extends EventType {
    public String msg;
  }

/* Emitted when a message was successfully sent to the SMTP server. */
  public static class SmtpMessageSent extends EventType {
    public String msg;
  }

/* Emitted when an IMAP message has been marked as deleted */
  public static class ImapMessageDeleted extends EventType {
    public String msg;
  }

/* Emitted when an IMAP message has been moved */
  public static class ImapMessageMoved extends EventType {
    public String msg;
  }

/* Emitted before going into IDLE on the Inbox folder. */
  public static class ImapInboxIdle extends EventType {
  }

/* Emitted when an new file in the $BLOBDIR was created */
  public static class NewBlobFile extends EventType {
    public String file;
  }

/* Emitted when an file in the $BLOBDIR was deleted */
  public static class DeletedBlobFile extends EventType {
    public String file;
  }

/**
 * The library-user should write a warning string to the log.
 * <p>
 * This event should *not* be reported to the end-user using a popup or something like that.
 */
  public static class Warning extends EventType {
    public String msg;
  }

/**
 * The library-user should report an error to the end-user.
 * <p>
 * As most things are asynchronous, things may go wrong at any time and the user should not be disturbed by a dialog or so.  Instead, use a bubble or so.
 * <p>
 * However, for ongoing processes (eg. configure()) or for functions that are expected to fail (eg. autocryptContinueKeyTransfer()) it might be better to delay showing these events until the function has really failed (returned false). It should be sufficient to report only the *last* error in a message box then.
 */
  public static class Error extends EventType {
    public String msg;
  }

/* An action cannot be performed because the user is not in the group. Reported eg. after a call to setChatName(), setChatProfileImage(), addContactToChat(), removeContactFromChat(), and messages sending functions. */
  public static class ErrorSelfNotInGroup extends EventType {
    public String msg;
  }

/* Messages or chats changed.  One or more messages or chats changed for various reasons in the database: - Messages sent, received or removed - Chats created, deleted or archived - A draft has been set */
  public static class MsgsChanged extends EventType {
    /* Set if only a single chat is affected by the changes, otherwise 0. */
    public Integer chatId;
    /* Set if only a single message is affected by the changes, otherwise 0. */
    public Integer msgId;
  }

/* Reactions for the message changed. */
  public static class ReactionsChanged extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chatId;
    /* ID of the contact whose reaction set is changed. */
    public Integer contactId;
    /* ID of the message for which reactions were changed. */
    public Integer msgId;
  }

/**
 * A reaction to one's own sent message received. Typically, the UI will show a notification for that.
 * <p>
 * In addition to this event, ReactionsChanged is emitted.
 */
  public static class IncomingReaction extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chatId;
    /* ID of the contact whose reaction set is changed. */
    public Integer contactId;
    /* ID of the message for which reactions were changed. */
    public Integer msgId;
    /* The reaction. */
    public String reaction;
  }

/* Incoming webxdc info or summary update, should be notified. */
  public static class IncomingWebxdcNotify extends EventType {
    /* ID of the chat. */
    public Integer chatId;
    /* ID of the contact sending. */
    public Integer contactId;
    /* Link assigned to this notification, if any. */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public String href;
    /* ID of the added info message or webxdc instance in case of summary change. */
    public Integer msgId;
    /* Text to notify. */
    public String text;
  }

/**
 * There is a fresh message. Typically, the user will show a notification when receiving this message.
 * <p>
 * There is no extra #DC_EVENT_MSGS_CHANGED event sent together with this event.
 */
  public static class IncomingMsg extends EventType {
    /* ID of the chat where the message is assigned. */
    public Integer chatId;
    /* ID of the message. */
    public Integer msgId;
  }

/* Downloading a bunch of messages just finished. This is an event to allow the UI to only show one notification per message bunch, instead of cluttering the user with many notifications. */
  public static class IncomingMsgBunch extends EventType {
  }

/* Messages were seen or noticed. chat id is always set. */
  public static class MsgsNoticed extends EventType {
    public Integer chatId;
  }

/* A single message is sent successfully. State changed from  DC_STATE_OUT_PENDING to DC_STATE_OUT_DELIVERED, see `Message.state`. */
  public static class MsgDelivered extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chatId;
    /* ID of the message that was successfully sent. */
    public Integer msgId;
  }

/* A single message could not be sent. State changed from DC_STATE_OUT_PENDING or DC_STATE_OUT_DELIVERED to DC_STATE_OUT_FAILED, see `Message.state`. */
  public static class MsgFailed extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chatId;
    /* ID of the message that could not be sent. */
    public Integer msgId;
  }

/* A single message is read by the receiver. State changed from DC_STATE_OUT_DELIVERED to DC_STATE_OUT_MDN_RCVD, see `Message.state`. */
  public static class MsgRead extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chatId;
    /* ID of the message that was read. */
    public Integer msgId;
  }

/**
 * A single message was deleted.
 * <p>
 * This event means that the message will no longer appear in the messagelist. UI should remove the message from the messagelist in response to this event if the message is currently displayed.
 * <p>
 * The message may have been explicitly deleted by the user or expired. Internally the message may have been removed from the database, moved to the trash chat or hidden.
 * <p>
 * This event does not indicate the message deletion from the server.
 */
  public static class MsgDeleted extends EventType {
    /* ID of the chat where the message was prior to deletion. Never 0. */
    public Integer chatId;
    /* ID of the deleted message. Never 0. */
    public Integer msgId;
  }

/**
 * Chat changed.  The name or the image of a chat group was changed or members were added or removed. See setChatName(), setChatProfileImage(), addContactToChat() and removeContactFromChat().
 * <p>
 * This event does not include ephemeral timer modification, which is a separate event.
 */
  public static class ChatModified extends EventType {
    public Integer chatId;
  }

/* Chat ephemeral timer changed. */
  public static class ChatEphemeralTimerModified extends EventType {
    /* Chat ID. */
    public Integer chatId;
    /* New ephemeral timer value. */
    public Integer timer;
  }

/* Chat deleted. */
  public static class ChatDeleted extends EventType {
    /* Chat ID. */
    public Integer chat_id;
  }

/* Contact(s) created, renamed, blocked or deleted. */
  public static class ContactsChanged extends EventType {
    /* If set, this is the contact_id of an added contact that should be selected. */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer contactId;
  }

/* Location of one or more contact has changed. */
  public static class LocationChanged extends EventType {
    /* contact_id of the contact for which the location has changed. If the locations of several contacts have been changed, this parameter is set to `None`. */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer contactId;
  }

/* Inform about the configuration progress started by configure(). */
  public static class ConfigureProgress extends EventType {
    /* Progress comment or error, something to display to the user. */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public String comment;
    /**
     * Progress.
     * <p>
     * 0=error, 1-999=progress in permille, 1000=success and done
     */
    public Integer progress;
  }

/* Inform about the import/export progress started by imex(). */
  public static class ImexProgress extends EventType {
    /* 0=error, 1-999=progress in permille, 1000=success and done */
    public Integer progress;
  }

/**
 * A file has been exported. A file has been written by imex(). This event may be sent multiple times by a single call to imex().
 * <p>
 * A typical purpose for a handler of this event may be to make the file public to some system services.
 * <p>
 * @param data2 0
 */
  public static class ImexFileWritten extends EventType {
    public String path;
  }

/**
 * Progress event sent when SecureJoin protocol has finished from the view of the inviter (Alice, the person who shows the QR code).
 * <p>
 * These events are typically sent after a joiner has scanned the QR code generated by getChatSecurejoinQrCodeSvg().
 */
  public static class SecurejoinInviterProgress extends EventType {
    /* ID of the chat in case of success. */
    public Integer chatId;
    /* The type of the joined chat. This can take the same values as `BasicChat.chatType` ([`crate::api::types::chat::BasicChat::chat_type`]). */
    public ChatType chatType;
    /* ID of the contact that wants to join. */
    public Integer contactId;
    /* Progress, always 1000. */
    public Integer progress;
  }

/* Progress information of a secure-join handshake from the view of the joiner (Bob, the person who scans the QR code). The events are typically sent while secureJoin(), which may take some time, is executed. */
  public static class SecurejoinJoinerProgress extends EventType {
    /* ID of the inviting contact. */
    public Integer contactId;
    /* Progress as: 400=vg-/vc-request-with-auth sent, typically shown as "alice@addr verified, introducing myself." (Bob has verified alice and waits until Alice does the same for him) 1000=vg-member-added/vc-contact-confirm received */
    public Integer progress;
  }

/* The connectivity to the server changed. This means that you should refresh the connectivity view and possibly the connectivtiy HTML; see getConnectivity() and getConnectivityHtml() for details. */
  public static class ConnectivityChanged extends EventType {
  }

/* Deprecated by `ConfigSynced`. */
  public static class SelfavatarChanged extends EventType {
  }

/* A multi-device synced config value changed. Maybe the app needs to refresh smth. For uniformity this is emitted on the source device too. The value isn't here, otherwise it would be logged which might not be good for privacy. */
  public static class ConfigSynced extends EventType {
    /* Configuration key. */
    public String key;
  }

  public static class WebxdcStatusUpdate extends EventType {
    /* Message ID. */
    public Integer msgId;
    /* Status update ID. */
    public Integer statusUpdateSerial;
  }

/* Data received over an ephemeral peer channel. */
  public static class WebxdcRealtimeData extends EventType {
    /* Realtime data. */
    public java.util.List<Integer> data;
    /* Message ID. */
    public Integer msgId;
  }

/* Advertisement received over an ephemeral peer channel. This can be used by bots to initiate peer-to-peer communication from their side. */
  public static class WebxdcRealtimeAdvertisementReceived extends EventType {
    /* Message ID of the webxdc instance. */
    public Integer msgId;
  }

/* Inform that a message containing a webxdc instance has been deleted */
  public static class WebxdcInstanceDeleted extends EventType {
    /* ID of the deleted message. */
    public Integer msgId;
  }

/**
 * Tells that the Background fetch was completed (or timed out). This event acts as a marker, when you reach this event you can be sure that all events emitted during the background fetch were processed.
 * <p>
 * This event is only emitted by the account manager
 */
  public static class AccountsBackgroundFetchDone extends EventType {
  }

/**
 * Inform that set of chats or the order of the chats in the chatlist has changed.
 * <p>
 * Sometimes this is emitted together with `UIChatlistItemChanged`.
 */
  public static class ChatlistChanged extends EventType {
  }

/* Inform that a single chat list item changed and needs to be rerendered. If `chat_id` is set to None, then all currently visible chats need to be rerendered, and all not-visible items need to be cleared from cache if the UI has a cache. */
  public static class ChatlistItemChanged extends EventType {
    /* ID of the changed chat */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer chatId;
  }

/**
 * Inform that the list of accounts has changed (an account removed or added or (not yet implemented) the account order changes)
 * <p>
 * This event is only emitted by the account manager
 */
  public static class AccountsChanged extends EventType {
  }

/**
 * Inform that an account property that might be shown in the account list changed, namely: - is_configured (see is_configured()) - displayname - selfavatar - private_tag
 * <p>
 * This event is emitted from the account whose property changed.
 */
  public static class AccountsItemChanged extends EventType {
  }

/* Inform than some events have been skipped due to event channel overflow. */
  public static class EventChannelOverflow extends EventType {
    /* Number of events skipped. */
    public Integer n;
  }

/* Incoming call. */
  public static class IncomingCall extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chat_id;
    /* True if incoming call is a video call. */
    public Boolean has_video;
    /* ID of the info message referring to the call. */
    public Integer msg_id;
    /* User-defined info as passed to place_outgoing_call() */
    public String place_call_info;
  }

/* Incoming call accepted. This is esp. interesting to stop ringing on other devices. */
  public static class IncomingCallAccepted extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chat_id;
    /* ID of the info message referring to the call. */
    public Integer msg_id;
  }

/* Outgoing call accepted. */
  public static class OutgoingCallAccepted extends EventType {
    /* User-defined info passed to dc_accept_incoming_call( */
    public String accept_call_info;
    /* ID of the chat which the message belongs to. */
    public Integer chat_id;
    /* ID of the info message referring to the call. */
    public Integer msg_id;
  }

/* Call ended. */
  public static class CallEnded extends EventType {
    /* ID of the chat which the message belongs to. */
    public Integer chat_id;
    /* ID of the info message referring to the call. */
    public Integer msg_id;
  }

/**
 * One or more transports has changed.
 * <p>
 * This event is used for tests to detect when transport synchronization messages arrives. UIs don't need to use it, it is unlikely that user modifies transports on multiple devices simultaneously.
 */
  public static class TransportsModified extends EventType {
  }

}