//! # libthreema
//!
//! The one stop shop for all your Threema needs!

// We have pretty strict linting rules and it would be a massive hassle having to conditionally
// compile all `pub(crate)` exposed items, depending on the selected features.
//
// The goal is to get it right with features `uniffi`, `wasm` and `cli` enabled (and of course, all
// feature variants still need to compile).
//
// However, it does make sense to disable this from time to time to check for actual issues.
#![cfg_attr(
    not(all(feature = "uniffi", feature = "wasm", feature = "cli")),
    allow(
        dead_code,
        unfulfilled_lint_expectations,
        unused_crate_dependencies,
        unused_imports,
        reason = "Don't care for non full-feature builds"
    )
)]
#![cfg_attr(
    test,
    allow(
        clippy::arithmetic_side_effects,
        clippy::borrow_interior_mutable_const,
        clippy::indexing_slicing,
        clippy::panic,
        clippy::struct_field_names,
        clippy::unchecked_time_subtraction,
        clippy::unreadable_literal,
        clippy::unwrap_used,
        unfulfilled_lint_expectations,
        unstable_features,
        reason = "Be less strict in tests"
    )
)]
#![cfg_attr(
    test,
    allow(clippy::large_stack_arrays, reason = "tests do not need to be efficient")
)]

// Pin generic-array to version 0.14.7 as 0.14.8 was deprecated and RustCrypto needs to upgrade first.
// See https://github.com/fizyk20/generic-array/issues/158
mod external_crate_false_positive_pinned_version {
    use generic_array as _;
}

// Avoids dev dependencies used only in examples to be picked up by the linter. Should no longer be
// necessary once https://github.com/rust-lang/cargo/issues/1982 has been resolved.
#[cfg(test)]
mod external_crate_false_positives {
    use anyhow as _;
}
#[cfg(feature = "cli")]
mod external_crate_false_positives_cli_feature {
    use clap as _;
    use futures_util as _;
    use rustls as _;
    use tokio as _;
    use tokio_tungstenite as _;
}

// Set up UniFFI scaffolding for UniFFI bindings
#[cfg(feature = "uniffi")]
uniffi::setup_scaffolding!();

/// Compiled low-level protobuf messages.
#[allow(
    clippy::all,
    clippy::pedantic,
    clippy::restriction,
    dead_code,
    missing_docs,
    rustdoc::broken_intra_doc_links,
    rustdoc::unescaped_backticks,
    reason = "Code generated by prost"
)]
pub mod protobuf {
    /// Common protobuf messages.
    pub mod common {
        include!(concat!(env!("OUT_DIR"), "/common.rs"));
    }

    /// End-to-end encrypted messages.
    pub mod csp_e2e {
        include!(concat!(env!("OUT_DIR"), "/csp_e2e.rs"));
    }

    /// Device to Device Protocol messages.
    pub mod d2d {
        include!(concat!(env!("OUT_DIR"), "/d2d.rs"));
    }

    /// Device to Mediator Protocol messages.
    pub mod d2m {
        include!(concat!(env!("OUT_DIR"), "/d2m.rs"));
    }

    /// Data synchronisation messages
    pub mod sync {
        include!(concat!(env!("OUT_DIR"), "/sync.rs"));
    }
    pub use sync as d2d_sync;

    /// Connection Rendezvous Protocol messages.
    pub mod d2d_rendezvous {
        include!(concat!(env!("OUT_DIR"), "/rendezvous.rs"));
    }
}

pub mod bindings;
#[cfg(feature = "cli")]
pub mod cli;
pub mod common;
pub mod crypto;
pub mod csp;
pub mod csp_e2e;
pub mod d2d_rendezvous;
pub mod d2m;
pub mod https;
pub mod id_backup;
pub mod model;
pub mod remote_secret;
pub mod utils;
