/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package config

@Suppress("ktlint:standard:max-line-length", "ktlint:standard:property-wrapping")
object PublicKeys {
    val threemaPush = byteArrayOf(0xfd, 0x71, 0x1e, 0x1a, 0x0d, 0xb0, 0xe2, 0xf0, 0x3f, 0xca, 0xab, 0x6c, 0x43, 0xda, 0x25, 0x75, 0xb9, 0x51, 0x36, 0x64, 0xa6, 0x2a, 0x12, 0xbd, 0x07, 0x28, 0xd8, 0x7f, 0x71, 0x25, 0xcc, 0x24)
    val prodServer = byteArrayOf(0x45, 0x0b, 0x97, 0x57, 0x35, 0x27, 0x9f, 0xde, 0xcb, 0x33, 0x13, 0x64, 0x8f, 0x5f, 0xc6, 0xee, 0x9f, 0xf4, 0x36, 0x0e, 0xa9, 0x2a, 0x8c, 0x17, 0x51, 0xc6, 0x61, 0xe4, 0xc0, 0xd8, 0xc9, 0x09)
    val prodServerAlt = byteArrayOf(0xda, 0x7c, 0x73, 0x79, 0x8f, 0x97, 0xd5, 0x87, 0xc3, 0xa2, 0x5e, 0xbe, 0x0a, 0x91, 0x41, 0x7f, 0x76, 0xdb, 0xcc, 0xcd, 0xda, 0x29, 0x30, 0xe6, 0xa9, 0x09, 0x0a, 0xf6, 0x2e, 0xba, 0x6f, 0x15)
    val sandboxServer = byteArrayOf(0x5a, 0x98, 0xf2, 0x3d, 0xe6, 0x56, 0x05, 0xd0, 0x50, 0xdc, 0x00, 0x64, 0xbe, 0x07, 0xdd, 0xdd, 0x81, 0x1d, 0xa1, 0x16, 0xa5, 0x43, 0xce, 0x43, 0xaa, 0x26, 0x87, 0xd1, 0x9f, 0x20, 0xaf, 0x3c)

    val onPremTrusted = arrayOf(
        "ek1qBp4DyRmLL9J5sCmsKSfwbsiGNB4veDAODjkwe/k=",
        "Hrk8aCjwKkXySubI7CZ3y9Sx+oToEHjNkGw98WSRneU=",
        "5pEn1T/5bhecNWrp9NgUQweRfgVtu/I8gRb3VxGP7k4=",
    )

    private fun byteArrayOf(vararg byte: Int): ByteArray =
        byte.map { it.toByte() }.toByteArray()
}
