/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2017-2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

@file:Suppress("ktlint")

package ch.threema.app.emojis

/**
 * Generated by Threema emoji-tools.
 */
object EmojiSpritemap {

    const val DIVERSITY_NONE: Byte = 0
    const val DIVERSITY_PARENT: Byte = 1
    const val DIVERSITY_CHILD: Byte = 2

    const val DISPLAY_NO: Byte = 0
    const val DISPLAY_YES: Byte = 1

    /**
     * List containing all groups containing all emoji in correct order.
     */
    @JvmField
    val emojiCategories: List<EmojiCategory> = listOf(
        EmojiCategory(EmojiCategoryType.SMILEYS, getsmileys()),
        EmojiCategory(EmojiCategoryType.PEOPLE, getpeople()),
        EmojiCategory(EmojiCategoryType.NATURE, getnature()),
        EmojiCategory(EmojiCategoryType.FOOD, getfood()),
        EmojiCategory(EmojiCategoryType.ACTIVITY, getactivity()),
        EmojiCategory(EmojiCategoryType.TRAVEL, gettravel()),
        EmojiCategory(EmojiCategoryType.OBJECTS, getobjects()),
        EmojiCategory(EmojiCategoryType.SYMBOLS, getsymbols()),
        EmojiCategory(EmojiCategoryType.FLAGS, getflags()),
    )

    private fun getsmileys() = listOf(
        // grinning face (1f600)
        EmojiInfo(
            "\uD83D\uDE00",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grinning face with big eyes (1f603)
        EmojiInfo(
            "\uD83D\uDE03",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grinning face with smiling eyes (1f604)
        EmojiInfo(
            "\uD83D\uDE04",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beaming face with smiling eyes (1f601)
        EmojiInfo(
            "\uD83D\uDE01",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grinning squinting face (1f606)
        EmojiInfo(
            "\uD83D\uDE06",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grinning face with sweat (1f605)
        EmojiInfo(
            "\uD83D\uDE05",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rolling on the floor laughing (1f923)
        EmojiInfo(
            "\uD83E\uDD23",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with tears of joy (1f602)
        EmojiInfo(
            "\uD83D\uDE02",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // slightly smiling face (1f642)
        EmojiInfo(
            "\uD83D\uDE42",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // upside-down face (1f643)
        EmojiInfo(
            "\uD83D\uDE43",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // melting face (1fae0)
        EmojiInfo(
            "\uD83E\uDEE0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // winking face (1f609)
        EmojiInfo(
            "\uD83D\uDE09",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with smiling eyes (1f60a)
        EmojiInfo(
            "\uD83D\uDE0A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with halo (1f607)
        EmojiInfo(
            "\uD83D\uDE07",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with hearts (1f970)
        EmojiInfo(
            "\uD83E\uDD70",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with heart-eyes (1f60d)
        EmojiInfo(
            "\uD83D\uDE0D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // star-struck (1f929)
        EmojiInfo(
            "\uD83E\uDD29",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face blowing a kiss (1f618)
        EmojiInfo(
            "\uD83D\uDE18",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kissing face (1f617)
        EmojiInfo(
            "\uD83D\uDE17",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face (263a-fe0f)
        EmojiInfo(
            "\u263A\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kissing face with closed eyes (1f61a)
        EmojiInfo(
            "\uD83D\uDE1A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kissing face with smiling eyes (1f619)
        EmojiInfo(
            "\uD83D\uDE19",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with tear (1f972)
        EmojiInfo(
            "\uD83E\uDD72",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face savoring food (1f60b)
        EmojiInfo(
            "\uD83D\uDE0B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with tongue (1f61b)
        EmojiInfo(
            "\uD83D\uDE1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // winking face with tongue (1f61c)
        EmojiInfo(
            "\uD83D\uDE1C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // zany face (1f92a)
        EmojiInfo(
            "\uD83E\uDD2A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // squinting face with tongue (1f61d)
        EmojiInfo(
            "\uD83D\uDE1D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // money-mouth face (1f911)
        EmojiInfo(
            "\uD83E\uDD11",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with open hands (1f917)
        EmojiInfo(
            "\uD83E\uDD17",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with hand over mouth (1f92d)
        EmojiInfo(
            "\uD83E\uDD2D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with open eyes and hand over mouth (1fae2)
        EmojiInfo(
            "\uD83E\uDEE2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with peeking eye (1fae3)
        EmojiInfo(
            "\uD83E\uDEE3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shushing face (1f92b)
        EmojiInfo(
            "\uD83E\uDD2B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // thinking face (1f914)
        EmojiInfo(
            "\uD83E\uDD14",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // saluting face (1fae1)
        EmojiInfo(
            "\uD83E\uDEE1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // zipper-mouth face (1f910)
        EmojiInfo(
            "\uD83E\uDD10",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with raised eyebrow (1f928)
        EmojiInfo(
            "\uD83E\uDD28",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // neutral face (1f610)
        EmojiInfo(
            "\uD83D\uDE10",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // expressionless face (1f611)
        EmojiInfo(
            "\uD83D\uDE11",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face without mouth (1f636)
        EmojiInfo(
            "\uD83D\uDE36",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dotted line face (1fae5)
        EmojiInfo(
            "\uD83E\uDEE5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face in clouds (1f636-200d-1f32b-fe0f)
        EmojiInfo(
            "\uD83D\uDE36\u200D\uD83C\uDF2B\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smirking face (1f60f)
        EmojiInfo(
            "\uD83D\uDE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // unamused face (1f612)
        EmojiInfo(
            "\uD83D\uDE12",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with rolling eyes (1f644)
        EmojiInfo(
            "\uD83D\uDE44",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grimacing face (1f62c)
        EmojiInfo(
            "\uD83D\uDE2C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face exhaling (1f62e-200d-1f4a8)
        EmojiInfo(
            "\uD83D\uDE2E\u200D\uD83D\uDCA8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lying face (1f925)
        EmojiInfo(
            "\uD83E\uDD25",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shaking face (1fae8)
        EmojiInfo(
            "\uD83E\uDEE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // head shaking horizontally (1f642-200d-2194-fe0f)
        EmojiInfo(
            "\uD83D\uDE42\u200D\u2194\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // head shaking vertically (1f642-200d-2195-fe0f)
        EmojiInfo(
            "\uD83D\uDE42\u200D\u2195\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // relieved face (1f60c)
        EmojiInfo(
            "\uD83D\uDE0C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pensive face (1f614)
        EmojiInfo(
            "\uD83D\uDE14",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sleepy face (1f62a)
        EmojiInfo(
            "\uD83D\uDE2A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // drooling face (1f924)
        EmojiInfo(
            "\uD83E\uDD24",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sleeping face (1f634)
        EmojiInfo(
            "\uD83D\uDE34",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with bags under eyes (1fae9)
        EmojiInfo(
            "\uD83E\uDEE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with medical mask (1f637)
        EmojiInfo(
            "\uD83D\uDE37",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with thermometer (1f912)
        EmojiInfo(
            "\uD83E\uDD12",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with head-bandage (1f915)
        EmojiInfo(
            "\uD83E\uDD15",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nauseated face (1f922)
        EmojiInfo(
            "\uD83E\uDD22",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face vomiting (1f92e)
        EmojiInfo(
            "\uD83E\uDD2E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sneezing face (1f927)
        EmojiInfo(
            "\uD83E\uDD27",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hot face (1f975)
        EmojiInfo(
            "\uD83E\uDD75",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cold face (1f976)
        EmojiInfo(
            "\uD83E\uDD76",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woozy face (1f974)
        EmojiInfo(
            "\uD83E\uDD74",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with crossed-out eyes (1f635)
        EmojiInfo(
            "\uD83D\uDE35",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with spiral eyes (1f635-200d-1f4ab)
        EmojiInfo(
            "\uD83D\uDE35\u200D\uD83D\uDCAB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // exploding head (1f92f)
        EmojiInfo(
            "\uD83E\uDD2F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cowboy hat face (1f920)
        EmojiInfo(
            "\uD83E\uDD20",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // partying face (1f973)
        EmojiInfo(
            "\uD83E\uDD73",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // disguised face (1f978)
        EmojiInfo(
            "\uD83E\uDD78",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with sunglasses (1f60e)
        EmojiInfo(
            "\uD83D\uDE0E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nerd face (1f913)
        EmojiInfo(
            "\uD83E\uDD13",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with monocle (1f9d0)
        EmojiInfo(
            "\uD83E\uDDD0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // confused face (1f615)
        EmojiInfo(
            "\uD83D\uDE15",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with diagonal mouth (1fae4)
        EmojiInfo(
            "\uD83E\uDEE4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // worried face (1f61f)
        EmojiInfo(
            "\uD83D\uDE1F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // slightly frowning face (1f641)
        EmojiInfo(
            "\uD83D\uDE41",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // frowning face (2639-fe0f)
        EmojiInfo(
            "\u2639\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with open mouth (1f62e)
        EmojiInfo(
            "\uD83D\uDE2E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hushed face (1f62f)
        EmojiInfo(
            "\uD83D\uDE2F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // astonished face (1f632)
        EmojiInfo(
            "\uD83D\uDE32",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flushed face (1f633)
        EmojiInfo(
            "\uD83D\uDE33",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pleading face (1f97a)
        EmojiInfo(
            "\uD83E\uDD7A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face holding back tears (1f979)
        EmojiInfo(
            "\uD83E\uDD79",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // frowning face with open mouth (1f626)
        EmojiInfo(
            "\uD83D\uDE26",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // anguished face (1f627)
        EmojiInfo(
            "\uD83D\uDE27",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fearful face (1f628)
        EmojiInfo(
            "\uD83D\uDE28",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // anxious face with sweat (1f630)
        EmojiInfo(
            "\uD83D\uDE30",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sad but relieved face (1f625)
        EmojiInfo(
            "\uD83D\uDE25",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crying face (1f622)
        EmojiInfo(
            "\uD83D\uDE22",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // loudly crying face (1f62d)
        EmojiInfo(
            "\uD83D\uDE2D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face screaming in fear (1f631)
        EmojiInfo(
            "\uD83D\uDE31",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // confounded face (1f616)
        EmojiInfo(
            "\uD83D\uDE16",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // persevering face (1f623)
        EmojiInfo(
            "\uD83D\uDE23",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // disappointed face (1f61e)
        EmojiInfo(
            "\uD83D\uDE1E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // downcast face with sweat (1f613)
        EmojiInfo(
            "\uD83D\uDE13",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // weary face (1f629)
        EmojiInfo(
            "\uD83D\uDE29",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tired face (1f62b)
        EmojiInfo(
            "\uD83D\uDE2B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yawning face (1f971)
        EmojiInfo(
            "\uD83E\uDD71",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with steam from nose (1f624)
        EmojiInfo(
            "\uD83D\uDE24",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // enraged face (1f621)
        EmojiInfo(
            "\uD83D\uDE21",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // angry face (1f620)
        EmojiInfo(
            "\uD83D\uDE20",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // face with symbols on mouth (1f92c)
        EmojiInfo(
            "\uD83E\uDD2C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling face with horns (1f608)
        EmojiInfo(
            "\uD83D\uDE08",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // angry face with horns (1f47f)
        EmojiInfo(
            "\uD83D\uDC7F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // skull (1f480)
        EmojiInfo(
            "\uD83D\uDC80",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // skull and crossbones (2620-fe0f)
        EmojiInfo(
            "\u2620\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pile of poo (1f4a9)
        EmojiInfo(
            "\uD83D\uDCA9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clown face (1f921)
        EmojiInfo(
            "\uD83E\uDD21",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ogre (1f479)
        EmojiInfo(
            "\uD83D\uDC79",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // goblin (1f47a)
        EmojiInfo(
            "\uD83D\uDC7A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ghost (1f47b)
        EmojiInfo(
            "\uD83D\uDC7B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // alien (1f47d)
        EmojiInfo(
            "\uD83D\uDC7D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // alien monster (1f47e)
        EmojiInfo(
            "\uD83D\uDC7E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // robot (1f916)
        EmojiInfo(
            "\uD83E\uDD16",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grinning cat (1f63a)
        EmojiInfo(
            "\uD83D\uDE3A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grinning cat with smiling eyes (1f638)
        EmojiInfo(
            "\uD83D\uDE38",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cat with tears of joy (1f639)
        EmojiInfo(
            "\uD83D\uDE39",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // smiling cat with heart-eyes (1f63b)
        EmojiInfo(
            "\uD83D\uDE3B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cat with wry smile (1f63c)
        EmojiInfo(
            "\uD83D\uDE3C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kissing cat (1f63d)
        EmojiInfo(
            "\uD83D\uDE3D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // weary cat (1f640)
        EmojiInfo(
            "\uD83D\uDE40",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crying cat (1f63f)
        EmojiInfo(
            "\uD83D\uDE3F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pouting cat (1f63e)
        EmojiInfo(
            "\uD83D\uDE3E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // see-no-evil monkey (1f648)
        EmojiInfo(
            "\uD83D\uDE48",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hear-no-evil monkey (1f649)
        EmojiInfo(
            "\uD83D\uDE49",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speak-no-evil monkey (1f64a)
        EmojiInfo(
            "\uD83D\uDE4A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // love letter (1f48c)
        EmojiInfo(
            "\uD83D\uDC8C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heart with arrow (1f498)
        EmojiInfo(
            "\uD83D\uDC98",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heart with ribbon (1f49d)
        EmojiInfo(
            "\uD83D\uDC9D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sparkling heart (1f496)
        EmojiInfo(
            "\uD83D\uDC96",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // growing heart (1f497)
        EmojiInfo(
            "\uD83D\uDC97",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beating heart (1f493)
        EmojiInfo(
            "\uD83D\uDC93",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // revolving hearts (1f49e)
        EmojiInfo(
            "\uD83D\uDC9E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // two hearts (1f495)
        EmojiInfo(
            "\uD83D\uDC95",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heart decoration (1f49f)
        EmojiInfo(
            "\uD83D\uDC9F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heart exclamation (2763-fe0f)
        EmojiInfo(
            "\u2763\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // broken heart (1f494)
        EmojiInfo(
            "\uD83D\uDC94",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heart on fire (2764-fe0f-200d-1f525)
        EmojiInfo(
            "\u2764\uFE0F\u200D\uD83D\uDD25",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mending heart (2764-fe0f-200d-1fa79)
        EmojiInfo(
            "\u2764\uFE0F\u200D\uD83E\uDE79",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red heart (2764-fe0f)
        EmojiInfo(
            "\u2764\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pink heart (1fa77)
        EmojiInfo(
            "\uD83E\uDE77",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // orange heart (1f9e1)
        EmojiInfo(
            "\uD83E\uDDE1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yellow heart (1f49b)
        EmojiInfo(
            "\uD83D\uDC9B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // green heart (1f49a)
        EmojiInfo(
            "\uD83D\uDC9A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blue heart (1f499)
        EmojiInfo(
            "\uD83D\uDC99",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // light blue heart (1fa75)
        EmojiInfo(
            "\uD83E\uDE75",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // purple heart (1f49c)
        EmojiInfo(
            "\uD83D\uDC9C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // brown heart (1f90e)
        EmojiInfo(
            "\uD83E\uDD0E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black heart (1f5a4)
        EmojiInfo(
            "\uD83D\uDDA4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // grey heart (1fa76)
        EmojiInfo(
            "\uD83E\uDE76",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white heart (1f90d)
        EmojiInfo(
            "\uD83E\uDD0D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kiss mark (1f48b)
        EmojiInfo(
            "\uD83D\uDC8B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hundred points (1f4af)
        EmojiInfo(
            "\uD83D\uDCAF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // anger symbol (1f4a2)
        EmojiInfo(
            "\uD83D\uDCA2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // collision (1f4a5)
        EmojiInfo(
            "\uD83D\uDCA5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dizzy (1f4ab)
        EmojiInfo(
            "\uD83D\uDCAB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sweat droplets (1f4a6)
        EmojiInfo(
            "\uD83D\uDCA6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dashing away (1f4a8)
        EmojiInfo(
            "\uD83D\uDCA8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hole (1f573-fe0f)
        EmojiInfo(
            "\uD83D\uDD73\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speech balloon (1f4ac)
        EmojiInfo(
            "\uD83D\uDCAC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eye in speech bubble (1f441-fe0f-200d-1f5e8-fe0f)
        EmojiInfo(
            "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // left speech bubble (1f5e8-fe0f)
        EmojiInfo(
            "\uD83D\uDDE8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // right anger bubble (1f5ef-fe0f)
        EmojiInfo(
            "\uD83D\uDDEF\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // thought balloon (1f4ad)
        EmojiInfo(
            "\uD83D\uDCAD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ZZZ (1f4a4)
        EmojiInfo(
            "\uD83D\uDCA4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getpeople() = listOf(
        // waving hand (1f44b)
        EmojiInfo(
            "\uD83D\uDC4B",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC4B\uD83C\uDFFB", "\uD83D\uDC4B\uD83C\uDFFC", "\uD83D\uDC4B\uD83C\uDFFD", "\uD83D\uDC4B\uD83C\uDFFE", "\uD83D\uDC4B\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // waving hand: light skin tone (1f44b-1f3fb)
        EmojiInfo(
            "\uD83D\uDC4B\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // waving hand: medium-light skin tone (1f44b-1f3fc)
        EmojiInfo(
            "\uD83D\uDC4B\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // waving hand: medium skin tone (1f44b-1f3fd)
        EmojiInfo(
            "\uD83D\uDC4B\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // waving hand: medium-dark skin tone (1f44b-1f3fe)
        EmojiInfo(
            "\uD83D\uDC4B\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // waving hand: dark skin tone (1f44b-1f3ff)
        EmojiInfo(
            "\uD83D\uDC4B\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised back of hand (1f91a)
        EmojiInfo(
            "\uD83E\uDD1A",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD1A\uD83C\uDFFB", "\uD83E\uDD1A\uD83C\uDFFC", "\uD83E\uDD1A\uD83C\uDFFD", "\uD83E\uDD1A\uD83C\uDFFE", "\uD83E\uDD1A\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // raised back of hand: light skin tone (1f91a-1f3fb)
        EmojiInfo(
            "\uD83E\uDD1A\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised back of hand: medium-light skin tone (1f91a-1f3fc)
        EmojiInfo(
            "\uD83E\uDD1A\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised back of hand: medium skin tone (1f91a-1f3fd)
        EmojiInfo(
            "\uD83E\uDD1A\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised back of hand: medium-dark skin tone (1f91a-1f3fe)
        EmojiInfo(
            "\uD83E\uDD1A\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised back of hand: dark skin tone (1f91a-1f3ff)
        EmojiInfo(
            "\uD83E\uDD1A\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with fingers splayed (1f590-fe0f)
        EmojiInfo(
            "\uD83D\uDD90\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD90\uD83C\uDFFB", "\uD83D\uDD90\uD83C\uDFFC", "\uD83D\uDD90\uD83C\uDFFD", "\uD83D\uDD90\uD83C\uDFFE", "\uD83D\uDD90\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // hand with fingers splayed: light skin tone (1f590-1f3fb)
        EmojiInfo(
            "\uD83D\uDD90\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with fingers splayed: medium-light skin tone (1f590-1f3fc)
        EmojiInfo(
            "\uD83D\uDD90\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with fingers splayed: medium skin tone (1f590-1f3fd)
        EmojiInfo(
            "\uD83D\uDD90\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with fingers splayed: medium-dark skin tone (1f590-1f3fe)
        EmojiInfo(
            "\uD83D\uDD90\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with fingers splayed: dark skin tone (1f590-1f3ff)
        EmojiInfo(
            "\uD83D\uDD90\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised hand (270b)
        EmojiInfo(
            "\u270B",
            DIVERSITY_PARENT,
            arrayOf("\u270B\uD83C\uDFFB", "\u270B\uD83C\uDFFC", "\u270B\uD83C\uDFFD", "\u270B\uD83C\uDFFE", "\u270B\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // raised hand: light skin tone (270b-1f3fb)
        EmojiInfo(
            "\u270B\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised hand: medium-light skin tone (270b-1f3fc)
        EmojiInfo(
            "\u270B\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised hand: medium skin tone (270b-1f3fd)
        EmojiInfo(
            "\u270B\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised hand: medium-dark skin tone (270b-1f3fe)
        EmojiInfo(
            "\u270B\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised hand: dark skin tone (270b-1f3ff)
        EmojiInfo(
            "\u270B\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vulcan salute (1f596)
        EmojiInfo(
            "\uD83D\uDD96",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD96\uD83C\uDFFB", "\uD83D\uDD96\uD83C\uDFFC", "\uD83D\uDD96\uD83C\uDFFD", "\uD83D\uDD96\uD83C\uDFFE", "\uD83D\uDD96\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // vulcan salute: light skin tone (1f596-1f3fb)
        EmojiInfo(
            "\uD83D\uDD96\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vulcan salute: medium-light skin tone (1f596-1f3fc)
        EmojiInfo(
            "\uD83D\uDD96\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vulcan salute: medium skin tone (1f596-1f3fd)
        EmojiInfo(
            "\uD83D\uDD96\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vulcan salute: medium-dark skin tone (1f596-1f3fe)
        EmojiInfo(
            "\uD83D\uDD96\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vulcan salute: dark skin tone (1f596-1f3ff)
        EmojiInfo(
            "\uD83D\uDD96\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards hand (1faf1)
        EmojiInfo(
            "\uD83E\uDEF1",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF1\uD83C\uDFFB", "\uD83E\uDEF1\uD83C\uDFFC", "\uD83E\uDEF1\uD83C\uDFFD", "\uD83E\uDEF1\uD83C\uDFFE", "\uD83E\uDEF1\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // rightwards hand: light skin tone (1faf1-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards hand: medium-light skin tone (1faf1-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards hand: medium skin tone (1faf1-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards hand: medium-dark skin tone (1faf1-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards hand: dark skin tone (1faf1-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards hand (1faf2)
        EmojiInfo(
            "\uD83E\uDEF2",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF2\uD83C\uDFFB", "\uD83E\uDEF2\uD83C\uDFFC", "\uD83E\uDEF2\uD83C\uDFFD", "\uD83E\uDEF2\uD83C\uDFFE", "\uD83E\uDEF2\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // leftwards hand: light skin tone (1faf2-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards hand: medium-light skin tone (1faf2-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards hand: medium skin tone (1faf2-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards hand: medium-dark skin tone (1faf2-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards hand: dark skin tone (1faf2-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm down hand (1faf3)
        EmojiInfo(
            "\uD83E\uDEF3",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF3\uD83C\uDFFB", "\uD83E\uDEF3\uD83C\uDFFC", "\uD83E\uDEF3\uD83C\uDFFD", "\uD83E\uDEF3\uD83C\uDFFE", "\uD83E\uDEF3\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // palm down hand: light skin tone (1faf3-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF3\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm down hand: medium-light skin tone (1faf3-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF3\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm down hand: medium skin tone (1faf3-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF3\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm down hand: medium-dark skin tone (1faf3-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF3\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm down hand: dark skin tone (1faf3-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF3\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm up hand (1faf4)
        EmojiInfo(
            "\uD83E\uDEF4",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF4\uD83C\uDFFB", "\uD83E\uDEF4\uD83C\uDFFC", "\uD83E\uDEF4\uD83C\uDFFD", "\uD83E\uDEF4\uD83C\uDFFE", "\uD83E\uDEF4\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // palm up hand: light skin tone (1faf4-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF4\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm up hand: medium-light skin tone (1faf4-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF4\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm up hand: medium skin tone (1faf4-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF4\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm up hand: medium-dark skin tone (1faf4-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF4\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palm up hand: dark skin tone (1faf4-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF4\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards pushing hand (1faf7)
        EmojiInfo(
            "\uD83E\uDEF7",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF7\uD83C\uDFFB", "\uD83E\uDEF7\uD83C\uDFFC", "\uD83E\uDEF7\uD83C\uDFFD", "\uD83E\uDEF7\uD83C\uDFFE", "\uD83E\uDEF7\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // leftwards pushing hand: light skin tone (1faf7-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF7\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards pushing hand: medium-light skin tone (1faf7-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF7\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards pushing hand: medium skin tone (1faf7-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF7\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards pushing hand: medium-dark skin tone (1faf7-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF7\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leftwards pushing hand: dark skin tone (1faf7-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF7\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards pushing hand (1faf8)
        EmojiInfo(
            "\uD83E\uDEF8",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF8\uD83C\uDFFB", "\uD83E\uDEF8\uD83C\uDFFC", "\uD83E\uDEF8\uD83C\uDFFD", "\uD83E\uDEF8\uD83C\uDFFE", "\uD83E\uDEF8\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // rightwards pushing hand: light skin tone (1faf8-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF8\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards pushing hand: medium-light skin tone (1faf8-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF8\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards pushing hand: medium skin tone (1faf8-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF8\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards pushing hand: medium-dark skin tone (1faf8-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF8\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // rightwards pushing hand: dark skin tone (1faf8-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF8\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // OK hand (1f44c)
        EmojiInfo(
            "\uD83D\uDC4C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC4C\uD83C\uDFFB", "\uD83D\uDC4C\uD83C\uDFFC", "\uD83D\uDC4C\uD83C\uDFFD", "\uD83D\uDC4C\uD83C\uDFFE", "\uD83D\uDC4C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // OK hand: light skin tone (1f44c-1f3fb)
        EmojiInfo(
            "\uD83D\uDC4C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // OK hand: medium-light skin tone (1f44c-1f3fc)
        EmojiInfo(
            "\uD83D\uDC4C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // OK hand: medium skin tone (1f44c-1f3fd)
        EmojiInfo(
            "\uD83D\uDC4C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // OK hand: medium-dark skin tone (1f44c-1f3fe)
        EmojiInfo(
            "\uD83D\uDC4C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // OK hand: dark skin tone (1f44c-1f3ff)
        EmojiInfo(
            "\uD83D\uDC4C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinched fingers (1f90c)
        EmojiInfo(
            "\uD83E\uDD0C",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD0C\uD83C\uDFFB", "\uD83E\uDD0C\uD83C\uDFFC", "\uD83E\uDD0C\uD83C\uDFFD", "\uD83E\uDD0C\uD83C\uDFFE", "\uD83E\uDD0C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // pinched fingers: light skin tone (1f90c-1f3fb)
        EmojiInfo(
            "\uD83E\uDD0C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinched fingers: medium-light skin tone (1f90c-1f3fc)
        EmojiInfo(
            "\uD83E\uDD0C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinched fingers: medium skin tone (1f90c-1f3fd)
        EmojiInfo(
            "\uD83E\uDD0C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinched fingers: medium-dark skin tone (1f90c-1f3fe)
        EmojiInfo(
            "\uD83E\uDD0C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinched fingers: dark skin tone (1f90c-1f3ff)
        EmojiInfo(
            "\uD83E\uDD0C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinching hand (1f90f)
        EmojiInfo(
            "\uD83E\uDD0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD0F\uD83C\uDFFB", "\uD83E\uDD0F\uD83C\uDFFC", "\uD83E\uDD0F\uD83C\uDFFD", "\uD83E\uDD0F\uD83C\uDFFE", "\uD83E\uDD0F\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // pinching hand: light skin tone (1f90f-1f3fb)
        EmojiInfo(
            "\uD83E\uDD0F\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinching hand: medium-light skin tone (1f90f-1f3fc)
        EmojiInfo(
            "\uD83E\uDD0F\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinching hand: medium skin tone (1f90f-1f3fd)
        EmojiInfo(
            "\uD83E\uDD0F\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinching hand: medium-dark skin tone (1f90f-1f3fe)
        EmojiInfo(
            "\uD83E\uDD0F\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pinching hand: dark skin tone (1f90f-1f3ff)
        EmojiInfo(
            "\uD83E\uDD0F\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // victory hand (270c-fe0f)
        EmojiInfo(
            "\u270C\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\u270C\uD83C\uDFFB", "\u270C\uD83C\uDFFC", "\u270C\uD83C\uDFFD", "\u270C\uD83C\uDFFE", "\u270C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // victory hand: light skin tone (270c-1f3fb)
        EmojiInfo(
            "\u270C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // victory hand: medium-light skin tone (270c-1f3fc)
        EmojiInfo(
            "\u270C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // victory hand: medium skin tone (270c-1f3fd)
        EmojiInfo(
            "\u270C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // victory hand: medium-dark skin tone (270c-1f3fe)
        EmojiInfo(
            "\u270C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // victory hand: dark skin tone (270c-1f3ff)
        EmojiInfo(
            "\u270C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // crossed fingers (1f91e)
        EmojiInfo(
            "\uD83E\uDD1E",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD1E\uD83C\uDFFB", "\uD83E\uDD1E\uD83C\uDFFC", "\uD83E\uDD1E\uD83C\uDFFD", "\uD83E\uDD1E\uD83C\uDFFE", "\uD83E\uDD1E\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // crossed fingers: light skin tone (1f91e-1f3fb)
        EmojiInfo(
            "\uD83E\uDD1E\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // crossed fingers: medium-light skin tone (1f91e-1f3fc)
        EmojiInfo(
            "\uD83E\uDD1E\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // crossed fingers: medium skin tone (1f91e-1f3fd)
        EmojiInfo(
            "\uD83E\uDD1E\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // crossed fingers: medium-dark skin tone (1f91e-1f3fe)
        EmojiInfo(
            "\uD83E\uDD1E\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // crossed fingers: dark skin tone (1f91e-1f3ff)
        EmojiInfo(
            "\uD83E\uDD1E\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with index finger and thumb crossed (1faf0)
        EmojiInfo(
            "\uD83E\uDEF0",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF0\uD83C\uDFFB", "\uD83E\uDEF0\uD83C\uDFFC", "\uD83E\uDEF0\uD83C\uDFFD", "\uD83E\uDEF0\uD83C\uDFFE", "\uD83E\uDEF0\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // hand with index finger and thumb crossed: light skin tone (1faf0-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF0\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with index finger and thumb crossed: medium-light skin tone (1faf0-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF0\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with index finger and thumb crossed: medium skin tone (1faf0-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF0\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with index finger and thumb crossed: medium-dark skin tone (1faf0-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF0\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // hand with index finger and thumb crossed: dark skin tone (1faf0-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF0\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // love-you gesture (1f91f)
        EmojiInfo(
            "\uD83E\uDD1F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD1F\uD83C\uDFFB", "\uD83E\uDD1F\uD83C\uDFFC", "\uD83E\uDD1F\uD83C\uDFFD", "\uD83E\uDD1F\uD83C\uDFFE", "\uD83E\uDD1F\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // love-you gesture: light skin tone (1f91f-1f3fb)
        EmojiInfo(
            "\uD83E\uDD1F\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // love-you gesture: medium-light skin tone (1f91f-1f3fc)
        EmojiInfo(
            "\uD83E\uDD1F\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // love-you gesture: medium skin tone (1f91f-1f3fd)
        EmojiInfo(
            "\uD83E\uDD1F\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // love-you gesture: medium-dark skin tone (1f91f-1f3fe)
        EmojiInfo(
            "\uD83E\uDD1F\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // love-you gesture: dark skin tone (1f91f-1f3ff)
        EmojiInfo(
            "\uD83E\uDD1F\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // sign of the horns (1f918)
        EmojiInfo(
            "\uD83E\uDD18",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD18\uD83C\uDFFB", "\uD83E\uDD18\uD83C\uDFFC", "\uD83E\uDD18\uD83C\uDFFD", "\uD83E\uDD18\uD83C\uDFFE", "\uD83E\uDD18\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // sign of the horns: light skin tone (1f918-1f3fb)
        EmojiInfo(
            "\uD83E\uDD18\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // sign of the horns: medium-light skin tone (1f918-1f3fc)
        EmojiInfo(
            "\uD83E\uDD18\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // sign of the horns: medium skin tone (1f918-1f3fd)
        EmojiInfo(
            "\uD83E\uDD18\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // sign of the horns: medium-dark skin tone (1f918-1f3fe)
        EmojiInfo(
            "\uD83E\uDD18\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // sign of the horns: dark skin tone (1f918-1f3ff)
        EmojiInfo(
            "\uD83E\uDD18\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // call me hand (1f919)
        EmojiInfo(
            "\uD83E\uDD19",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD19\uD83C\uDFFB", "\uD83E\uDD19\uD83C\uDFFC", "\uD83E\uDD19\uD83C\uDFFD", "\uD83E\uDD19\uD83C\uDFFE", "\uD83E\uDD19\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // call me hand: light skin tone (1f919-1f3fb)
        EmojiInfo(
            "\uD83E\uDD19\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // call me hand: medium-light skin tone (1f919-1f3fc)
        EmojiInfo(
            "\uD83E\uDD19\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // call me hand: medium skin tone (1f919-1f3fd)
        EmojiInfo(
            "\uD83E\uDD19\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // call me hand: medium-dark skin tone (1f919-1f3fe)
        EmojiInfo(
            "\uD83E\uDD19\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // call me hand: dark skin tone (1f919-1f3ff)
        EmojiInfo(
            "\uD83E\uDD19\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing left (1f448)
        EmojiInfo(
            "\uD83D\uDC48",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC48\uD83C\uDFFB", "\uD83D\uDC48\uD83C\uDFFC", "\uD83D\uDC48\uD83C\uDFFD", "\uD83D\uDC48\uD83C\uDFFE", "\uD83D\uDC48\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // backhand index pointing left: light skin tone (1f448-1f3fb)
        EmojiInfo(
            "\uD83D\uDC48\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing left: medium-light skin tone (1f448-1f3fc)
        EmojiInfo(
            "\uD83D\uDC48\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing left: medium skin tone (1f448-1f3fd)
        EmojiInfo(
            "\uD83D\uDC48\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing left: medium-dark skin tone (1f448-1f3fe)
        EmojiInfo(
            "\uD83D\uDC48\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing left: dark skin tone (1f448-1f3ff)
        EmojiInfo(
            "\uD83D\uDC48\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing right (1f449)
        EmojiInfo(
            "\uD83D\uDC49",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC49\uD83C\uDFFB", "\uD83D\uDC49\uD83C\uDFFC", "\uD83D\uDC49\uD83C\uDFFD", "\uD83D\uDC49\uD83C\uDFFE", "\uD83D\uDC49\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // backhand index pointing right: light skin tone (1f449-1f3fb)
        EmojiInfo(
            "\uD83D\uDC49\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing right: medium-light skin tone (1f449-1f3fc)
        EmojiInfo(
            "\uD83D\uDC49\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing right: medium skin tone (1f449-1f3fd)
        EmojiInfo(
            "\uD83D\uDC49\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing right: medium-dark skin tone (1f449-1f3fe)
        EmojiInfo(
            "\uD83D\uDC49\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing right: dark skin tone (1f449-1f3ff)
        EmojiInfo(
            "\uD83D\uDC49\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing up (1f446)
        EmojiInfo(
            "\uD83D\uDC46",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC46\uD83C\uDFFB", "\uD83D\uDC46\uD83C\uDFFC", "\uD83D\uDC46\uD83C\uDFFD", "\uD83D\uDC46\uD83C\uDFFE", "\uD83D\uDC46\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // backhand index pointing up: light skin tone (1f446-1f3fb)
        EmojiInfo(
            "\uD83D\uDC46\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing up: medium-light skin tone (1f446-1f3fc)
        EmojiInfo(
            "\uD83D\uDC46\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing up: medium skin tone (1f446-1f3fd)
        EmojiInfo(
            "\uD83D\uDC46\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing up: medium-dark skin tone (1f446-1f3fe)
        EmojiInfo(
            "\uD83D\uDC46\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing up: dark skin tone (1f446-1f3ff)
        EmojiInfo(
            "\uD83D\uDC46\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // middle finger (1f595)
        EmojiInfo(
            "\uD83D\uDD95",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD95\uD83C\uDFFB", "\uD83D\uDD95\uD83C\uDFFC", "\uD83D\uDD95\uD83C\uDFFD", "\uD83D\uDD95\uD83C\uDFFE", "\uD83D\uDD95\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // middle finger: light skin tone (1f595-1f3fb)
        EmojiInfo(
            "\uD83D\uDD95\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // middle finger: medium-light skin tone (1f595-1f3fc)
        EmojiInfo(
            "\uD83D\uDD95\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // middle finger: medium skin tone (1f595-1f3fd)
        EmojiInfo(
            "\uD83D\uDD95\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // middle finger: medium-dark skin tone (1f595-1f3fe)
        EmojiInfo(
            "\uD83D\uDD95\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // middle finger: dark skin tone (1f595-1f3ff)
        EmojiInfo(
            "\uD83D\uDD95\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing down (1f447)
        EmojiInfo(
            "\uD83D\uDC47",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC47\uD83C\uDFFB", "\uD83D\uDC47\uD83C\uDFFC", "\uD83D\uDC47\uD83C\uDFFD", "\uD83D\uDC47\uD83C\uDFFE", "\uD83D\uDC47\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // backhand index pointing down: light skin tone (1f447-1f3fb)
        EmojiInfo(
            "\uD83D\uDC47\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing down: medium-light skin tone (1f447-1f3fc)
        EmojiInfo(
            "\uD83D\uDC47\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing down: medium skin tone (1f447-1f3fd)
        EmojiInfo(
            "\uD83D\uDC47\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing down: medium-dark skin tone (1f447-1f3fe)
        EmojiInfo(
            "\uD83D\uDC47\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // backhand index pointing down: dark skin tone (1f447-1f3ff)
        EmojiInfo(
            "\uD83D\uDC47\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing up (261d-fe0f)
        EmojiInfo(
            "\u261D\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\u261D\uD83C\uDFFB", "\u261D\uD83C\uDFFC", "\u261D\uD83C\uDFFD", "\u261D\uD83C\uDFFE", "\u261D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // index pointing up: light skin tone (261d-1f3fb)
        EmojiInfo(
            "\u261D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing up: medium-light skin tone (261d-1f3fc)
        EmojiInfo(
            "\u261D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing up: medium skin tone (261d-1f3fd)
        EmojiInfo(
            "\u261D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing up: medium-dark skin tone (261d-1f3fe)
        EmojiInfo(
            "\u261D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing up: dark skin tone (261d-1f3ff)
        EmojiInfo(
            "\u261D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing at the viewer (1faf5)
        EmojiInfo(
            "\uD83E\uDEF5",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF5\uD83C\uDFFB", "\uD83E\uDEF5\uD83C\uDFFC", "\uD83E\uDEF5\uD83C\uDFFD", "\uD83E\uDEF5\uD83C\uDFFE", "\uD83E\uDEF5\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // index pointing at the viewer: light skin tone (1faf5-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF5\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing at the viewer: medium-light skin tone (1faf5-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF5\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing at the viewer: medium skin tone (1faf5-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF5\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing at the viewer: medium-dark skin tone (1faf5-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF5\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // index pointing at the viewer: dark skin tone (1faf5-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF5\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs up (1f44d)
        EmojiInfo(
            "\uD83D\uDC4D",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC4D\uD83C\uDFFB", "\uD83D\uDC4D\uD83C\uDFFC", "\uD83D\uDC4D\uD83C\uDFFD", "\uD83D\uDC4D\uD83C\uDFFE", "\uD83D\uDC4D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // thumbs up: light skin tone (1f44d-1f3fb)
        EmojiInfo(
            "\uD83D\uDC4D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs up: medium-light skin tone (1f44d-1f3fc)
        EmojiInfo(
            "\uD83D\uDC4D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs up: medium skin tone (1f44d-1f3fd)
        EmojiInfo(
            "\uD83D\uDC4D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs up: medium-dark skin tone (1f44d-1f3fe)
        EmojiInfo(
            "\uD83D\uDC4D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs up: dark skin tone (1f44d-1f3ff)
        EmojiInfo(
            "\uD83D\uDC4D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs down (1f44e)
        EmojiInfo(
            "\uD83D\uDC4E",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC4E\uD83C\uDFFB", "\uD83D\uDC4E\uD83C\uDFFC", "\uD83D\uDC4E\uD83C\uDFFD", "\uD83D\uDC4E\uD83C\uDFFE", "\uD83D\uDC4E\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // thumbs down: light skin tone (1f44e-1f3fb)
        EmojiInfo(
            "\uD83D\uDC4E\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs down: medium-light skin tone (1f44e-1f3fc)
        EmojiInfo(
            "\uD83D\uDC4E\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs down: medium skin tone (1f44e-1f3fd)
        EmojiInfo(
            "\uD83D\uDC4E\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs down: medium-dark skin tone (1f44e-1f3fe)
        EmojiInfo(
            "\uD83D\uDC4E\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // thumbs down: dark skin tone (1f44e-1f3ff)
        EmojiInfo(
            "\uD83D\uDC4E\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised fist (270a)
        EmojiInfo(
            "\u270A",
            DIVERSITY_PARENT,
            arrayOf("\u270A\uD83C\uDFFB", "\u270A\uD83C\uDFFC", "\u270A\uD83C\uDFFD", "\u270A\uD83C\uDFFE", "\u270A\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // raised fist: light skin tone (270a-1f3fb)
        EmojiInfo(
            "\u270A\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised fist: medium-light skin tone (270a-1f3fc)
        EmojiInfo(
            "\u270A\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised fist: medium skin tone (270a-1f3fd)
        EmojiInfo(
            "\u270A\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised fist: medium-dark skin tone (270a-1f3fe)
        EmojiInfo(
            "\u270A\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raised fist: dark skin tone (270a-1f3ff)
        EmojiInfo(
            "\u270A\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // oncoming fist (1f44a)
        EmojiInfo(
            "\uD83D\uDC4A",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC4A\uD83C\uDFFB", "\uD83D\uDC4A\uD83C\uDFFC", "\uD83D\uDC4A\uD83C\uDFFD", "\uD83D\uDC4A\uD83C\uDFFE", "\uD83D\uDC4A\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // oncoming fist: light skin tone (1f44a-1f3fb)
        EmojiInfo(
            "\uD83D\uDC4A\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // oncoming fist: medium-light skin tone (1f44a-1f3fc)
        EmojiInfo(
            "\uD83D\uDC4A\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // oncoming fist: medium skin tone (1f44a-1f3fd)
        EmojiInfo(
            "\uD83D\uDC4A\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // oncoming fist: medium-dark skin tone (1f44a-1f3fe)
        EmojiInfo(
            "\uD83D\uDC4A\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // oncoming fist: dark skin tone (1f44a-1f3ff)
        EmojiInfo(
            "\uD83D\uDC4A\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // left-facing fist (1f91b)
        EmojiInfo(
            "\uD83E\uDD1B",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD1B\uD83C\uDFFB", "\uD83E\uDD1B\uD83C\uDFFC", "\uD83E\uDD1B\uD83C\uDFFD", "\uD83E\uDD1B\uD83C\uDFFE", "\uD83E\uDD1B\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // left-facing fist: light skin tone (1f91b-1f3fb)
        EmojiInfo(
            "\uD83E\uDD1B\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // left-facing fist: medium-light skin tone (1f91b-1f3fc)
        EmojiInfo(
            "\uD83E\uDD1B\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // left-facing fist: medium skin tone (1f91b-1f3fd)
        EmojiInfo(
            "\uD83E\uDD1B\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // left-facing fist: medium-dark skin tone (1f91b-1f3fe)
        EmojiInfo(
            "\uD83E\uDD1B\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // left-facing fist: dark skin tone (1f91b-1f3ff)
        EmojiInfo(
            "\uD83E\uDD1B\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // right-facing fist (1f91c)
        EmojiInfo(
            "\uD83E\uDD1C",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD1C\uD83C\uDFFB", "\uD83E\uDD1C\uD83C\uDFFC", "\uD83E\uDD1C\uD83C\uDFFD", "\uD83E\uDD1C\uD83C\uDFFE", "\uD83E\uDD1C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // right-facing fist: light skin tone (1f91c-1f3fb)
        EmojiInfo(
            "\uD83E\uDD1C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // right-facing fist: medium-light skin tone (1f91c-1f3fc)
        EmojiInfo(
            "\uD83E\uDD1C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // right-facing fist: medium skin tone (1f91c-1f3fd)
        EmojiInfo(
            "\uD83E\uDD1C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // right-facing fist: medium-dark skin tone (1f91c-1f3fe)
        EmojiInfo(
            "\uD83E\uDD1C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // right-facing fist: dark skin tone (1f91c-1f3ff)
        EmojiInfo(
            "\uD83E\uDD1C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // clapping hands (1f44f)
        EmojiInfo(
            "\uD83D\uDC4F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC4F\uD83C\uDFFB", "\uD83D\uDC4F\uD83C\uDFFC", "\uD83D\uDC4F\uD83C\uDFFD", "\uD83D\uDC4F\uD83C\uDFFE", "\uD83D\uDC4F\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // clapping hands: light skin tone (1f44f-1f3fb)
        EmojiInfo(
            "\uD83D\uDC4F\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // clapping hands: medium-light skin tone (1f44f-1f3fc)
        EmojiInfo(
            "\uD83D\uDC4F\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // clapping hands: medium skin tone (1f44f-1f3fd)
        EmojiInfo(
            "\uD83D\uDC4F\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // clapping hands: medium-dark skin tone (1f44f-1f3fe)
        EmojiInfo(
            "\uD83D\uDC4F\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // clapping hands: dark skin tone (1f44f-1f3ff)
        EmojiInfo(
            "\uD83D\uDC4F\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raising hands (1f64c)
        EmojiInfo(
            "\uD83D\uDE4C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4C\uD83C\uDFFB", "\uD83D\uDE4C\uD83C\uDFFC", "\uD83D\uDE4C\uD83C\uDFFD", "\uD83D\uDE4C\uD83C\uDFFE", "\uD83D\uDE4C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // raising hands: light skin tone (1f64c-1f3fb)
        EmojiInfo(
            "\uD83D\uDE4C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raising hands: medium-light skin tone (1f64c-1f3fc)
        EmojiInfo(
            "\uD83D\uDE4C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raising hands: medium skin tone (1f64c-1f3fd)
        EmojiInfo(
            "\uD83D\uDE4C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raising hands: medium-dark skin tone (1f64c-1f3fe)
        EmojiInfo(
            "\uD83D\uDE4C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // raising hands: dark skin tone (1f64c-1f3ff)
        EmojiInfo(
            "\uD83D\uDE4C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // heart hands (1faf6)
        EmojiInfo(
            "\uD83E\uDEF6",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEF6\uD83C\uDFFB", "\uD83E\uDEF6\uD83C\uDFFC", "\uD83E\uDEF6\uD83C\uDFFD", "\uD83E\uDEF6\uD83C\uDFFE", "\uD83E\uDEF6\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // heart hands: light skin tone (1faf6-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF6\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // heart hands: medium-light skin tone (1faf6-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF6\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // heart hands: medium skin tone (1faf6-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF6\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // heart hands: medium-dark skin tone (1faf6-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF6\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // heart hands: dark skin tone (1faf6-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF6\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // open hands (1f450)
        EmojiInfo(
            "\uD83D\uDC50",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC50\uD83C\uDFFB", "\uD83D\uDC50\uD83C\uDFFC", "\uD83D\uDC50\uD83C\uDFFD", "\uD83D\uDC50\uD83C\uDFFE", "\uD83D\uDC50\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // open hands: light skin tone (1f450-1f3fb)
        EmojiInfo(
            "\uD83D\uDC50\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // open hands: medium-light skin tone (1f450-1f3fc)
        EmojiInfo(
            "\uD83D\uDC50\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // open hands: medium skin tone (1f450-1f3fd)
        EmojiInfo(
            "\uD83D\uDC50\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // open hands: medium-dark skin tone (1f450-1f3fe)
        EmojiInfo(
            "\uD83D\uDC50\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // open hands: dark skin tone (1f450-1f3ff)
        EmojiInfo(
            "\uD83D\uDC50\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palms up together (1f932)
        EmojiInfo(
            "\uD83E\uDD32",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD32\uD83C\uDFFB", "\uD83E\uDD32\uD83C\uDFFC", "\uD83E\uDD32\uD83C\uDFFD", "\uD83E\uDD32\uD83C\uDFFE", "\uD83E\uDD32\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // palms up together: light skin tone (1f932-1f3fb)
        EmojiInfo(
            "\uD83E\uDD32\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palms up together: medium-light skin tone (1f932-1f3fc)
        EmojiInfo(
            "\uD83E\uDD32\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palms up together: medium skin tone (1f932-1f3fd)
        EmojiInfo(
            "\uD83E\uDD32\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palms up together: medium-dark skin tone (1f932-1f3fe)
        EmojiInfo(
            "\uD83E\uDD32\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // palms up together: dark skin tone (1f932-1f3ff)
        EmojiInfo(
            "\uD83E\uDD32\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // handshake (1f91d)
        EmojiInfo(
            "\uD83E\uDD1D",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD1D\uD83C\uDFFB", "\uD83E\uDD1D\uD83C\uDFFC", "\uD83E\uDD1D\uD83C\uDFFD", "\uD83E\uDD1D\uD83C\uDFFE", "\uD83E\uDD1D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // handshake: light skin tone (1f91d-1f3fb)
        EmojiInfo(
            "\uD83E\uDD1D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // handshake: medium-light skin tone (1f91d-1f3fc)
        EmojiInfo(
            "\uD83E\uDD1D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // handshake: medium skin tone (1f91d-1f3fd)
        EmojiInfo(
            "\uD83E\uDD1D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // handshake: medium-dark skin tone (1f91d-1f3fe)
        EmojiInfo(
            "\uD83E\uDD1D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // handshake: dark skin tone (1f91d-1f3ff)
        EmojiInfo(
            "\uD83E\uDD1D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // handshake: light skin tone, medium-light skin tone (1faf1-1f3fb-200d-1faf2-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: light skin tone, medium skin tone (1faf1-1f3fb-200d-1faf2-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: light skin tone, medium-dark skin tone (1faf1-1f3fb-200d-1faf2-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: light skin tone, dark skin tone (1faf1-1f3fb-200d-1faf2-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFB\u200D\uD83E\uDEF2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-light skin tone, light skin tone (1faf1-1f3fc-200d-1faf2-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-light skin tone, medium skin tone (1faf1-1f3fc-200d-1faf2-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-light skin tone, medium-dark skin tone (1faf1-1f3fc-200d-1faf2-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-light skin tone, dark skin tone (1faf1-1f3fc-200d-1faf2-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFC\u200D\uD83E\uDEF2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium skin tone, light skin tone (1faf1-1f3fd-200d-1faf2-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium skin tone, medium-light skin tone (1faf1-1f3fd-200d-1faf2-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium skin tone, medium-dark skin tone (1faf1-1f3fd-200d-1faf2-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium skin tone, dark skin tone (1faf1-1f3fd-200d-1faf2-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFD\u200D\uD83E\uDEF2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-dark skin tone, light skin tone (1faf1-1f3fe-200d-1faf2-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-dark skin tone, medium-light skin tone (1faf1-1f3fe-200d-1faf2-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-dark skin tone, medium skin tone (1faf1-1f3fe-200d-1faf2-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: medium-dark skin tone, dark skin tone (1faf1-1f3fe-200d-1faf2-1f3ff)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFE\u200D\uD83E\uDEF2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: dark skin tone, light skin tone (1faf1-1f3ff-200d-1faf2-1f3fb)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: dark skin tone, medium-light skin tone (1faf1-1f3ff-200d-1faf2-1f3fc)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: dark skin tone, medium skin tone (1faf1-1f3ff-200d-1faf2-1f3fd)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // handshake: dark skin tone, medium-dark skin tone (1faf1-1f3ff-200d-1faf2-1f3fe)
        EmojiInfo(
            "\uD83E\uDEF1\uD83C\uDFFF\u200D\uD83E\uDEF2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // folded hands (1f64f)
        EmojiInfo(
            "\uD83D\uDE4F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4F\uD83C\uDFFB", "\uD83D\uDE4F\uD83C\uDFFC", "\uD83D\uDE4F\uD83C\uDFFD", "\uD83D\uDE4F\uD83C\uDFFE", "\uD83D\uDE4F\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // folded hands: light skin tone (1f64f-1f3fb)
        EmojiInfo(
            "\uD83D\uDE4F\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // folded hands: medium-light skin tone (1f64f-1f3fc)
        EmojiInfo(
            "\uD83D\uDE4F\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // folded hands: medium skin tone (1f64f-1f3fd)
        EmojiInfo(
            "\uD83D\uDE4F\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // folded hands: medium-dark skin tone (1f64f-1f3fe)
        EmojiInfo(
            "\uD83D\uDE4F\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // folded hands: dark skin tone (1f64f-1f3ff)
        EmojiInfo(
            "\uD83D\uDE4F\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // writing hand (270d-fe0f)
        EmojiInfo(
            "\u270D\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\u270D\uD83C\uDFFB", "\u270D\uD83C\uDFFC", "\u270D\uD83C\uDFFD", "\u270D\uD83C\uDFFE", "\u270D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // writing hand: light skin tone (270d-1f3fb)
        EmojiInfo(
            "\u270D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // writing hand: medium-light skin tone (270d-1f3fc)
        EmojiInfo(
            "\u270D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // writing hand: medium skin tone (270d-1f3fd)
        EmojiInfo(
            "\u270D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // writing hand: medium-dark skin tone (270d-1f3fe)
        EmojiInfo(
            "\u270D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // writing hand: dark skin tone (270d-1f3ff)
        EmojiInfo(
            "\u270D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nail polish (1f485)
        EmojiInfo(
            "\uD83D\uDC85",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC85\uD83C\uDFFB", "\uD83D\uDC85\uD83C\uDFFC", "\uD83D\uDC85\uD83C\uDFFD", "\uD83D\uDC85\uD83C\uDFFE", "\uD83D\uDC85\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // nail polish: light skin tone (1f485-1f3fb)
        EmojiInfo(
            "\uD83D\uDC85\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nail polish: medium-light skin tone (1f485-1f3fc)
        EmojiInfo(
            "\uD83D\uDC85\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nail polish: medium skin tone (1f485-1f3fd)
        EmojiInfo(
            "\uD83D\uDC85\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nail polish: medium-dark skin tone (1f485-1f3fe)
        EmojiInfo(
            "\uD83D\uDC85\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nail polish: dark skin tone (1f485-1f3ff)
        EmojiInfo(
            "\uD83D\uDC85\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // selfie (1f933)
        EmojiInfo(
            "\uD83E\uDD33",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD33\uD83C\uDFFB", "\uD83E\uDD33\uD83C\uDFFC", "\uD83E\uDD33\uD83C\uDFFD", "\uD83E\uDD33\uD83C\uDFFE", "\uD83E\uDD33\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // selfie: light skin tone (1f933-1f3fb)
        EmojiInfo(
            "\uD83E\uDD33\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // selfie: medium-light skin tone (1f933-1f3fc)
        EmojiInfo(
            "\uD83E\uDD33\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // selfie: medium skin tone (1f933-1f3fd)
        EmojiInfo(
            "\uD83E\uDD33\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // selfie: medium-dark skin tone (1f933-1f3fe)
        EmojiInfo(
            "\uD83E\uDD33\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // selfie: dark skin tone (1f933-1f3ff)
        EmojiInfo(
            "\uD83E\uDD33\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // flexed biceps (1f4aa)
        EmojiInfo(
            "\uD83D\uDCAA",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDCAA\uD83C\uDFFB", "\uD83D\uDCAA\uD83C\uDFFC", "\uD83D\uDCAA\uD83C\uDFFD", "\uD83D\uDCAA\uD83C\uDFFE", "\uD83D\uDCAA\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // flexed biceps: light skin tone (1f4aa-1f3fb)
        EmojiInfo(
            "\uD83D\uDCAA\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // flexed biceps: medium-light skin tone (1f4aa-1f3fc)
        EmojiInfo(
            "\uD83D\uDCAA\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // flexed biceps: medium skin tone (1f4aa-1f3fd)
        EmojiInfo(
            "\uD83D\uDCAA\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // flexed biceps: medium-dark skin tone (1f4aa-1f3fe)
        EmojiInfo(
            "\uD83D\uDCAA\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // flexed biceps: dark skin tone (1f4aa-1f3ff)
        EmojiInfo(
            "\uD83D\uDCAA\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mechanical arm (1f9be)
        EmojiInfo(
            "\uD83E\uDDBE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mechanical leg (1f9bf)
        EmojiInfo(
            "\uD83E\uDDBF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // leg (1f9b5)
        EmojiInfo(
            "\uD83E\uDDB5",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB5\uD83C\uDFFB", "\uD83E\uDDB5\uD83C\uDFFC", "\uD83E\uDDB5\uD83C\uDFFD", "\uD83E\uDDB5\uD83C\uDFFE", "\uD83E\uDDB5\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // leg: light skin tone (1f9b5-1f3fb)
        EmojiInfo(
            "\uD83E\uDDB5\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leg: medium-light skin tone (1f9b5-1f3fc)
        EmojiInfo(
            "\uD83E\uDDB5\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leg: medium skin tone (1f9b5-1f3fd)
        EmojiInfo(
            "\uD83E\uDDB5\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leg: medium-dark skin tone (1f9b5-1f3fe)
        EmojiInfo(
            "\uD83E\uDDB5\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // leg: dark skin tone (1f9b5-1f3ff)
        EmojiInfo(
            "\uD83E\uDDB5\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // foot (1f9b6)
        EmojiInfo(
            "\uD83E\uDDB6",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB6\uD83C\uDFFB", "\uD83E\uDDB6\uD83C\uDFFC", "\uD83E\uDDB6\uD83C\uDFFD", "\uD83E\uDDB6\uD83C\uDFFE", "\uD83E\uDDB6\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // foot: light skin tone (1f9b6-1f3fb)
        EmojiInfo(
            "\uD83E\uDDB6\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // foot: medium-light skin tone (1f9b6-1f3fc)
        EmojiInfo(
            "\uD83E\uDDB6\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // foot: medium skin tone (1f9b6-1f3fd)
        EmojiInfo(
            "\uD83E\uDDB6\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // foot: medium-dark skin tone (1f9b6-1f3fe)
        EmojiInfo(
            "\uD83E\uDDB6\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // foot: dark skin tone (1f9b6-1f3ff)
        EmojiInfo(
            "\uD83E\uDDB6\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear (1f442)
        EmojiInfo(
            "\uD83D\uDC42",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC42\uD83C\uDFFB", "\uD83D\uDC42\uD83C\uDFFC", "\uD83D\uDC42\uD83C\uDFFD", "\uD83D\uDC42\uD83C\uDFFE", "\uD83D\uDC42\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // ear: light skin tone (1f442-1f3fb)
        EmojiInfo(
            "\uD83D\uDC42\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear: medium-light skin tone (1f442-1f3fc)
        EmojiInfo(
            "\uD83D\uDC42\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear: medium skin tone (1f442-1f3fd)
        EmojiInfo(
            "\uD83D\uDC42\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear: medium-dark skin tone (1f442-1f3fe)
        EmojiInfo(
            "\uD83D\uDC42\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear: dark skin tone (1f442-1f3ff)
        EmojiInfo(
            "\uD83D\uDC42\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear with hearing aid (1f9bb)
        EmojiInfo(
            "\uD83E\uDDBB",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDBB\uD83C\uDFFB", "\uD83E\uDDBB\uD83C\uDFFC", "\uD83E\uDDBB\uD83C\uDFFD", "\uD83E\uDDBB\uD83C\uDFFE", "\uD83E\uDDBB\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // ear with hearing aid: light skin tone (1f9bb-1f3fb)
        EmojiInfo(
            "\uD83E\uDDBB\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear with hearing aid: medium-light skin tone (1f9bb-1f3fc)
        EmojiInfo(
            "\uD83E\uDDBB\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear with hearing aid: medium skin tone (1f9bb-1f3fd)
        EmojiInfo(
            "\uD83E\uDDBB\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear with hearing aid: medium-dark skin tone (1f9bb-1f3fe)
        EmojiInfo(
            "\uD83E\uDDBB\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ear with hearing aid: dark skin tone (1f9bb-1f3ff)
        EmojiInfo(
            "\uD83E\uDDBB\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nose (1f443)
        EmojiInfo(
            "\uD83D\uDC43",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC43\uD83C\uDFFB", "\uD83D\uDC43\uD83C\uDFFC", "\uD83D\uDC43\uD83C\uDFFD", "\uD83D\uDC43\uD83C\uDFFE", "\uD83D\uDC43\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // nose: light skin tone (1f443-1f3fb)
        EmojiInfo(
            "\uD83D\uDC43\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nose: medium-light skin tone (1f443-1f3fc)
        EmojiInfo(
            "\uD83D\uDC43\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nose: medium skin tone (1f443-1f3fd)
        EmojiInfo(
            "\uD83D\uDC43\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nose: medium-dark skin tone (1f443-1f3fe)
        EmojiInfo(
            "\uD83D\uDC43\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // nose: dark skin tone (1f443-1f3ff)
        EmojiInfo(
            "\uD83D\uDC43\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // brain (1f9e0)
        EmojiInfo(
            "\uD83E\uDDE0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // anatomical heart (1fac0)
        EmojiInfo(
            "\uD83E\uDEC0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lungs (1fac1)
        EmojiInfo(
            "\uD83E\uDEC1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tooth (1f9b7)
        EmojiInfo(
            "\uD83E\uDDB7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bone (1f9b4)
        EmojiInfo(
            "\uD83E\uDDB4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eyes (1f440)
        EmojiInfo(
            "\uD83D\uDC40",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eye (1f441-fe0f)
        EmojiInfo(
            "\uD83D\uDC41\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tongue (1f445)
        EmojiInfo(
            "\uD83D\uDC45",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mouth (1f444)
        EmojiInfo(
            "\uD83D\uDC44",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // biting lip (1fae6)
        EmojiInfo(
            "\uD83E\uDEE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baby (1f476)
        EmojiInfo(
            "\uD83D\uDC76",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC76\uD83C\uDFFB", "\uD83D\uDC76\uD83C\uDFFC", "\uD83D\uDC76\uD83C\uDFFD", "\uD83D\uDC76\uD83C\uDFFE", "\uD83D\uDC76\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // baby: light skin tone (1f476-1f3fb)
        EmojiInfo(
            "\uD83D\uDC76\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby: medium-light skin tone (1f476-1f3fc)
        EmojiInfo(
            "\uD83D\uDC76\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby: medium skin tone (1f476-1f3fd)
        EmojiInfo(
            "\uD83D\uDC76\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby: medium-dark skin tone (1f476-1f3fe)
        EmojiInfo(
            "\uD83D\uDC76\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby: dark skin tone (1f476-1f3ff)
        EmojiInfo(
            "\uD83D\uDC76\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // child (1f9d2)
        EmojiInfo(
            "\uD83E\uDDD2",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD2\uD83C\uDFFB", "\uD83E\uDDD2\uD83C\uDFFC", "\uD83E\uDDD2\uD83C\uDFFD", "\uD83E\uDDD2\uD83C\uDFFE", "\uD83E\uDDD2\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // child: light skin tone (1f9d2-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // child: medium-light skin tone (1f9d2-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // child: medium skin tone (1f9d2-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // child: medium-dark skin tone (1f9d2-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // child: dark skin tone (1f9d2-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // boy (1f466)
        EmojiInfo(
            "\uD83D\uDC66",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC66\uD83C\uDFFB", "\uD83D\uDC66\uD83C\uDFFC", "\uD83D\uDC66\uD83C\uDFFD", "\uD83D\uDC66\uD83C\uDFFE", "\uD83D\uDC66\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // boy: light skin tone (1f466-1f3fb)
        EmojiInfo(
            "\uD83D\uDC66\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // boy: medium-light skin tone (1f466-1f3fc)
        EmojiInfo(
            "\uD83D\uDC66\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // boy: medium skin tone (1f466-1f3fd)
        EmojiInfo(
            "\uD83D\uDC66\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // boy: medium-dark skin tone (1f466-1f3fe)
        EmojiInfo(
            "\uD83D\uDC66\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // boy: dark skin tone (1f466-1f3ff)
        EmojiInfo(
            "\uD83D\uDC66\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // girl (1f467)
        EmojiInfo(
            "\uD83D\uDC67",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC67\uD83C\uDFFB", "\uD83D\uDC67\uD83C\uDFFC", "\uD83D\uDC67\uD83C\uDFFD", "\uD83D\uDC67\uD83C\uDFFE", "\uD83D\uDC67\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // girl: light skin tone (1f467-1f3fb)
        EmojiInfo(
            "\uD83D\uDC67\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // girl: medium-light skin tone (1f467-1f3fc)
        EmojiInfo(
            "\uD83D\uDC67\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // girl: medium skin tone (1f467-1f3fd)
        EmojiInfo(
            "\uD83D\uDC67\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // girl: medium-dark skin tone (1f467-1f3fe)
        EmojiInfo(
            "\uD83D\uDC67\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // girl: dark skin tone (1f467-1f3ff)
        EmojiInfo(
            "\uD83D\uDC67\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person (1f9d1)
        EmojiInfo(
            "\uD83E\uDDD1",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB", "\uD83E\uDDD1\uD83C\uDFFC", "\uD83E\uDDD1\uD83C\uDFFD", "\uD83E\uDDD1\uD83C\uDFFE", "\uD83E\uDDD1\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person: light skin tone (1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone (1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone (1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone (1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone (1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: blond hair (1f471)
        EmojiInfo(
            "\uD83D\uDC71",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC71\uD83C\uDFFB", "\uD83D\uDC71\uD83C\uDFFC", "\uD83D\uDC71\uD83C\uDFFD", "\uD83D\uDC71\uD83C\uDFFE", "\uD83D\uDC71\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person: light skin tone, blond hair (1f471-1f3fb)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone, blond hair (1f471-1f3fc)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone, blond hair (1f471-1f3fd)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone, blond hair (1f471-1f3fe)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone, blond hair (1f471-1f3ff)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man (1f468)
        EmojiInfo(
            "\uD83D\uDC68",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB", "\uD83D\uDC68\uD83C\uDFFC", "\uD83D\uDC68\uD83C\uDFFD", "\uD83D\uDC68\uD83C\uDFFE", "\uD83D\uDC68\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // man: light skin tone (1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone (1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone (1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone (1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone (1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: beard (1f9d4)
        EmojiInfo(
            "\uD83E\uDDD4",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD4\uD83C\uDFFB", "\uD83E\uDDD4\uD83C\uDFFC", "\uD83E\uDDD4\uD83C\uDFFD", "\uD83E\uDDD4\uD83C\uDFFE", "\uD83E\uDDD4\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person: light skin tone, beard (1f9d4-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone, beard (1f9d4-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone, beard (1f9d4-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone, beard (1f9d4-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone, beard (1f9d4-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: beard (1f9d4-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD4\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man: light skin tone, beard (1f9d4-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone, beard (1f9d4-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone, beard (1f9d4-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone, beard (1f9d4-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone, beard (1f9d4-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: beard (1f9d4-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD4\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman: light skin tone, beard (1f9d4-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone, beard (1f9d4-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone, beard (1f9d4-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone, beard (1f9d4-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone, beard (1f9d4-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: red hair (1f468-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDB0",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB0", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB0", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB0", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB0", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB0"),
            DISPLAY_YES,
        ),
        // man: light skin tone, red hair (1f468-1f3fb-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone, red hair (1f468-1f3fc-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone, red hair (1f468-1f3fd-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone, red hair (1f468-1f3fe-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone, red hair (1f468-1f3ff-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: curly hair (1f468-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDB1",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB1", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB1", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB1", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB1", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB1"),
            DISPLAY_YES,
        ),
        // man: light skin tone, curly hair (1f468-1f3fb-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone, curly hair (1f468-1f3fc-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone, curly hair (1f468-1f3fd-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone, curly hair (1f468-1f3fe-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone, curly hair (1f468-1f3ff-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: white hair (1f468-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDB3",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB3", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB3", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB3", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB3", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB3"),
            DISPLAY_YES,
        ),
        // man: light skin tone, white hair (1f468-1f3fb-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone, white hair (1f468-1f3fc-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone, white hair (1f468-1f3fd-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone, white hair (1f468-1f3fe-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone, white hair (1f468-1f3ff-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: bald (1f468-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDB2",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB2", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB2", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB2", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB2", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB2"),
            DISPLAY_YES,
        ),
        // man: light skin tone, bald (1f468-1f3fb-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone, bald (1f468-1f3fc-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone, bald (1f468-1f3fd-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone, bald (1f468-1f3fe-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone, bald (1f468-1f3ff-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman (1f469)
        EmojiInfo(
            "\uD83D\uDC69",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB", "\uD83D\uDC69\uD83C\uDFFC", "\uD83D\uDC69\uD83C\uDFFD", "\uD83D\uDC69\uD83C\uDFFE", "\uD83D\uDC69\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // woman: light skin tone (1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone (1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone (1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone (1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone (1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: red hair (1f469-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDB0",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB0", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB0", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB0", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB0", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB0"),
            DISPLAY_YES,
        ),
        // woman: light skin tone, red hair (1f469-1f3fb-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone, red hair (1f469-1f3fc-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone, red hair (1f469-1f3fd-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone, red hair (1f469-1f3fe-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone, red hair (1f469-1f3ff-200d-1f9b0)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: red hair (1f9d1-200d-1f9b0)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDB0",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB0", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB0", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB0", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB0", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB0"),
            DISPLAY_YES,
        ),
        // person: light skin tone, red hair (1f9d1-1f3fb-200d-1f9b0)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone, red hair (1f9d1-1f3fc-200d-1f9b0)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone, red hair (1f9d1-1f3fd-200d-1f9b0)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone, red hair (1f9d1-1f3fe-200d-1f9b0)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone, red hair (1f9d1-1f3ff-200d-1f9b0)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB0",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: curly hair (1f469-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDB1",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB1", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB1", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB1", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB1", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB1"),
            DISPLAY_YES,
        ),
        // woman: light skin tone, curly hair (1f469-1f3fb-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone, curly hair (1f469-1f3fc-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone, curly hair (1f469-1f3fd-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone, curly hair (1f469-1f3fe-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone, curly hair (1f469-1f3ff-200d-1f9b1)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: curly hair (1f9d1-200d-1f9b1)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDB1",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB1", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB1", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB1", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB1", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB1"),
            DISPLAY_YES,
        ),
        // person: light skin tone, curly hair (1f9d1-1f3fb-200d-1f9b1)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone, curly hair (1f9d1-1f3fc-200d-1f9b1)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone, curly hair (1f9d1-1f3fd-200d-1f9b1)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone, curly hair (1f9d1-1f3fe-200d-1f9b1)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone, curly hair (1f9d1-1f3ff-200d-1f9b1)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB1",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: white hair (1f469-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDB3",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB3", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB3", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB3", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB3", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB3"),
            DISPLAY_YES,
        ),
        // woman: light skin tone, white hair (1f469-1f3fb-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone, white hair (1f469-1f3fc-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone, white hair (1f469-1f3fd-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone, white hair (1f469-1f3fe-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone, white hair (1f469-1f3ff-200d-1f9b3)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: white hair (1f9d1-200d-1f9b3)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDB3",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB3", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB3", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB3", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB3", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB3"),
            DISPLAY_YES,
        ),
        // person: light skin tone, white hair (1f9d1-1f3fb-200d-1f9b3)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone, white hair (1f9d1-1f3fc-200d-1f9b3)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone, white hair (1f9d1-1f3fd-200d-1f9b3)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone, white hair (1f9d1-1f3fe-200d-1f9b3)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone, white hair (1f9d1-1f3ff-200d-1f9b3)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB3",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: bald (1f469-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDB2",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB2", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB2", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB2", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB2", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB2"),
            DISPLAY_YES,
        ),
        // woman: light skin tone, bald (1f469-1f3fb-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone, bald (1f469-1f3fc-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone, bald (1f469-1f3fd-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone, bald (1f469-1f3fe-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone, bald (1f469-1f3ff-200d-1f9b2)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: bald (1f9d1-200d-1f9b2)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDB2",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB2", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB2", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB2", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB2", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB2"),
            DISPLAY_YES,
        ),
        // person: light skin tone, bald (1f9d1-1f3fb-200d-1f9b2)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-light skin tone, bald (1f9d1-1f3fc-200d-1f9b2)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium skin tone, bald (1f9d1-1f3fd-200d-1f9b2)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: medium-dark skin tone, bald (1f9d1-1f3fe-200d-1f9b2)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person: dark skin tone, bald (1f9d1-1f3ff-200d-1f9b2)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB2",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: blond hair (1f471-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC71\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman: light skin tone, blond hair (1f471-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-light skin tone, blond hair (1f471-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium skin tone, blond hair (1f471-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: medium-dark skin tone, blond hair (1f471-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman: dark skin tone, blond hair (1f471-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: blond hair (1f471-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC71\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man: light skin tone, blond hair (1f471-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-light skin tone, blond hair (1f471-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium skin tone, blond hair (1f471-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: medium-dark skin tone, blond hair (1f471-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man: dark skin tone, blond hair (1f471-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // older person (1f9d3)
        EmojiInfo(
            "\uD83E\uDDD3",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD3\uD83C\uDFFB", "\uD83E\uDDD3\uD83C\uDFFC", "\uD83E\uDDD3\uD83C\uDFFD", "\uD83E\uDDD3\uD83C\uDFFE", "\uD83E\uDDD3\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // older person: light skin tone (1f9d3-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD3\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // older person: medium-light skin tone (1f9d3-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD3\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // older person: medium skin tone (1f9d3-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD3\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // older person: medium-dark skin tone (1f9d3-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD3\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // older person: dark skin tone (1f9d3-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD3\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old man (1f474)
        EmojiInfo(
            "\uD83D\uDC74",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC74\uD83C\uDFFB", "\uD83D\uDC74\uD83C\uDFFC", "\uD83D\uDC74\uD83C\uDFFD", "\uD83D\uDC74\uD83C\uDFFE", "\uD83D\uDC74\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // old man: light skin tone (1f474-1f3fb)
        EmojiInfo(
            "\uD83D\uDC74\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old man: medium-light skin tone (1f474-1f3fc)
        EmojiInfo(
            "\uD83D\uDC74\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old man: medium skin tone (1f474-1f3fd)
        EmojiInfo(
            "\uD83D\uDC74\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old man: medium-dark skin tone (1f474-1f3fe)
        EmojiInfo(
            "\uD83D\uDC74\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old man: dark skin tone (1f474-1f3ff)
        EmojiInfo(
            "\uD83D\uDC74\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old woman (1f475)
        EmojiInfo(
            "\uD83D\uDC75",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC75\uD83C\uDFFB", "\uD83D\uDC75\uD83C\uDFFC", "\uD83D\uDC75\uD83C\uDFFD", "\uD83D\uDC75\uD83C\uDFFE", "\uD83D\uDC75\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // old woman: light skin tone (1f475-1f3fb)
        EmojiInfo(
            "\uD83D\uDC75\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old woman: medium-light skin tone (1f475-1f3fc)
        EmojiInfo(
            "\uD83D\uDC75\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old woman: medium skin tone (1f475-1f3fd)
        EmojiInfo(
            "\uD83D\uDC75\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old woman: medium-dark skin tone (1f475-1f3fe)
        EmojiInfo(
            "\uD83D\uDC75\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // old woman: dark skin tone (1f475-1f3ff)
        EmojiInfo(
            "\uD83D\uDC75\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person frowning (1f64d)
        EmojiInfo(
            "\uD83D\uDE4D",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4D\uD83C\uDFFB", "\uD83D\uDE4D\uD83C\uDFFC", "\uD83D\uDE4D\uD83C\uDFFD", "\uD83D\uDE4D\uD83C\uDFFE", "\uD83D\uDE4D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person frowning: light skin tone (1f64d-1f3fb)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person frowning: medium-light skin tone (1f64d-1f3fc)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person frowning: medium skin tone (1f64d-1f3fd)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person frowning: medium-dark skin tone (1f64d-1f3fe)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person frowning: dark skin tone (1f64d-1f3ff)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man frowning (1f64d-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man frowning: light skin tone (1f64d-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man frowning: medium-light skin tone (1f64d-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man frowning: medium skin tone (1f64d-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man frowning: medium-dark skin tone (1f64d-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man frowning: dark skin tone (1f64d-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman frowning (1f64d-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman frowning: light skin tone (1f64d-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman frowning: medium-light skin tone (1f64d-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman frowning: medium skin tone (1f64d-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman frowning: medium-dark skin tone (1f64d-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman frowning: dark skin tone (1f64d-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person pouting (1f64e)
        EmojiInfo(
            "\uD83D\uDE4E",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4E\uD83C\uDFFB", "\uD83D\uDE4E\uD83C\uDFFC", "\uD83D\uDE4E\uD83C\uDFFD", "\uD83D\uDE4E\uD83C\uDFFE", "\uD83D\uDE4E\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person pouting: light skin tone (1f64e-1f3fb)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person pouting: medium-light skin tone (1f64e-1f3fc)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person pouting: medium skin tone (1f64e-1f3fd)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person pouting: medium-dark skin tone (1f64e-1f3fe)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person pouting: dark skin tone (1f64e-1f3ff)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pouting (1f64e-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man pouting: light skin tone (1f64e-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pouting: medium-light skin tone (1f64e-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pouting: medium skin tone (1f64e-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pouting: medium-dark skin tone (1f64e-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pouting: dark skin tone (1f64e-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pouting (1f64e-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman pouting: light skin tone (1f64e-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pouting: medium-light skin tone (1f64e-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pouting: medium skin tone (1f64e-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pouting: medium-dark skin tone (1f64e-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pouting: dark skin tone (1f64e-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing NO (1f645)
        EmojiInfo(
            "\uD83D\uDE45",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE45\uD83C\uDFFB", "\uD83D\uDE45\uD83C\uDFFC", "\uD83D\uDE45\uD83C\uDFFD", "\uD83D\uDE45\uD83C\uDFFE", "\uD83D\uDE45\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person gesturing NO: light skin tone (1f645-1f3fb)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing NO: medium-light skin tone (1f645-1f3fc)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing NO: medium skin tone (1f645-1f3fd)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing NO: medium-dark skin tone (1f645-1f3fe)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing NO: dark skin tone (1f645-1f3ff)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing NO (1f645-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE45\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDE45\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDE45\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDE45\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDE45\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man gesturing NO: light skin tone (1f645-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing NO: medium-light skin tone (1f645-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing NO: medium skin tone (1f645-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing NO: medium-dark skin tone (1f645-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing NO: dark skin tone (1f645-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing NO (1f645-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE45\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDE45\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDE45\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDE45\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDE45\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman gesturing NO: light skin tone (1f645-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing NO: medium-light skin tone (1f645-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing NO: medium skin tone (1f645-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing NO: medium-dark skin tone (1f645-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing NO: dark skin tone (1f645-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE45\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing OK (1f646)
        EmojiInfo(
            "\uD83D\uDE46",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE46\uD83C\uDFFB", "\uD83D\uDE46\uD83C\uDFFC", "\uD83D\uDE46\uD83C\uDFFD", "\uD83D\uDE46\uD83C\uDFFE", "\uD83D\uDE46\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person gesturing OK: light skin tone (1f646-1f3fb)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing OK: medium-light skin tone (1f646-1f3fc)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing OK: medium skin tone (1f646-1f3fd)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing OK: medium-dark skin tone (1f646-1f3fe)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person gesturing OK: dark skin tone (1f646-1f3ff)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing OK (1f646-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE46\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDE46\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDE46\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDE46\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDE46\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man gesturing OK: light skin tone (1f646-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing OK: medium-light skin tone (1f646-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing OK: medium skin tone (1f646-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing OK: medium-dark skin tone (1f646-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man gesturing OK: dark skin tone (1f646-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing OK (1f646-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE46\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDE46\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDE46\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDE46\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDE46\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman gesturing OK: light skin tone (1f646-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing OK: medium-light skin tone (1f646-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing OK: medium skin tone (1f646-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing OK: medium-dark skin tone (1f646-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman gesturing OK: dark skin tone (1f646-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE46\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person tipping hand (1f481)
        EmojiInfo(
            "\uD83D\uDC81",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC81\uD83C\uDFFB", "\uD83D\uDC81\uD83C\uDFFC", "\uD83D\uDC81\uD83C\uDFFD", "\uD83D\uDC81\uD83C\uDFFE", "\uD83D\uDC81\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person tipping hand: light skin tone (1f481-1f3fb)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person tipping hand: medium-light skin tone (1f481-1f3fc)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person tipping hand: medium skin tone (1f481-1f3fd)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person tipping hand: medium-dark skin tone (1f481-1f3fe)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person tipping hand: dark skin tone (1f481-1f3ff)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man tipping hand (1f481-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC81\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC81\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC81\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC81\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC81\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man tipping hand: light skin tone (1f481-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man tipping hand: medium-light skin tone (1f481-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man tipping hand: medium skin tone (1f481-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man tipping hand: medium-dark skin tone (1f481-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man tipping hand: dark skin tone (1f481-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman tipping hand (1f481-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC81\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC81\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC81\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC81\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC81\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman tipping hand: light skin tone (1f481-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman tipping hand: medium-light skin tone (1f481-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman tipping hand: medium skin tone (1f481-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman tipping hand: medium-dark skin tone (1f481-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman tipping hand: dark skin tone (1f481-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC81\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person raising hand (1f64b)
        EmojiInfo(
            "\uD83D\uDE4B",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4B\uD83C\uDFFB", "\uD83D\uDE4B\uD83C\uDFFC", "\uD83D\uDE4B\uD83C\uDFFD", "\uD83D\uDE4B\uD83C\uDFFE", "\uD83D\uDE4B\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person raising hand: light skin tone (1f64b-1f3fb)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person raising hand: medium-light skin tone (1f64b-1f3fc)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person raising hand: medium skin tone (1f64b-1f3fd)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person raising hand: medium-dark skin tone (1f64b-1f3fe)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person raising hand: dark skin tone (1f64b-1f3ff)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man raising hand (1f64b-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man raising hand: light skin tone (1f64b-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man raising hand: medium-light skin tone (1f64b-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man raising hand: medium skin tone (1f64b-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man raising hand: medium-dark skin tone (1f64b-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man raising hand: dark skin tone (1f64b-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman raising hand (1f64b-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman raising hand: light skin tone (1f64b-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman raising hand: medium-light skin tone (1f64b-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman raising hand: medium skin tone (1f64b-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman raising hand: medium-dark skin tone (1f64b-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman raising hand: dark skin tone (1f64b-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf person (1f9cf)
        EmojiInfo(
            "\uD83E\uDDCF",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCF\uD83C\uDFFB", "\uD83E\uDDCF\uD83C\uDFFC", "\uD83E\uDDCF\uD83C\uDFFD", "\uD83E\uDDCF\uD83C\uDFFE", "\uD83E\uDDCF\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // deaf person: light skin tone (1f9cf-1f3fb)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf person: medium-light skin tone (1f9cf-1f3fc)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf person: medium skin tone (1f9cf-1f3fd)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf person: medium-dark skin tone (1f9cf-1f3fe)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf person: dark skin tone (1f9cf-1f3ff)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf man (1f9cf-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCF\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // deaf man: light skin tone (1f9cf-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf man: medium-light skin tone (1f9cf-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf man: medium skin tone (1f9cf-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf man: medium-dark skin tone (1f9cf-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf man: dark skin tone (1f9cf-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf woman (1f9cf-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCF\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // deaf woman: light skin tone (1f9cf-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf woman: medium-light skin tone (1f9cf-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf woman: medium skin tone (1f9cf-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf woman: medium-dark skin tone (1f9cf-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // deaf woman: dark skin tone (1f9cf-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bowing (1f647)
        EmojiInfo(
            "\uD83D\uDE47",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE47\uD83C\uDFFB", "\uD83D\uDE47\uD83C\uDFFC", "\uD83D\uDE47\uD83C\uDFFD", "\uD83D\uDE47\uD83C\uDFFE", "\uD83D\uDE47\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person bowing: light skin tone (1f647-1f3fb)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bowing: medium-light skin tone (1f647-1f3fc)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bowing: medium skin tone (1f647-1f3fd)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bowing: medium-dark skin tone (1f647-1f3fe)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bowing: dark skin tone (1f647-1f3ff)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bowing (1f647-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE47\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDE47\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDE47\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDE47\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDE47\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man bowing: light skin tone (1f647-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bowing: medium-light skin tone (1f647-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bowing: medium skin tone (1f647-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bowing: medium-dark skin tone (1f647-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bowing: dark skin tone (1f647-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bowing (1f647-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDE47\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDE47\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDE47\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDE47\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDE47\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman bowing: light skin tone (1f647-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bowing: medium-light skin tone (1f647-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bowing: medium skin tone (1f647-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bowing: medium-dark skin tone (1f647-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bowing: dark skin tone (1f647-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDE47\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person facepalming (1f926)
        EmojiInfo(
            "\uD83E\uDD26",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD26\uD83C\uDFFB", "\uD83E\uDD26\uD83C\uDFFC", "\uD83E\uDD26\uD83C\uDFFD", "\uD83E\uDD26\uD83C\uDFFE", "\uD83E\uDD26\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person facepalming: light skin tone (1f926-1f3fb)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person facepalming: medium-light skin tone (1f926-1f3fc)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person facepalming: medium skin tone (1f926-1f3fd)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person facepalming: medium-dark skin tone (1f926-1f3fe)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person facepalming: dark skin tone (1f926-1f3ff)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man facepalming (1f926-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD26\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD26\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD26\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD26\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD26\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man facepalming: light skin tone (1f926-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man facepalming: medium-light skin tone (1f926-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man facepalming: medium skin tone (1f926-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man facepalming: medium-dark skin tone (1f926-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man facepalming: dark skin tone (1f926-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman facepalming (1f926-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD26\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD26\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD26\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD26\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD26\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman facepalming: light skin tone (1f926-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman facepalming: medium-light skin tone (1f926-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman facepalming: medium skin tone (1f926-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman facepalming: medium-dark skin tone (1f926-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman facepalming: dark skin tone (1f926-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD26\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person shrugging (1f937)
        EmojiInfo(
            "\uD83E\uDD37",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD37\uD83C\uDFFB", "\uD83E\uDD37\uD83C\uDFFC", "\uD83E\uDD37\uD83C\uDFFD", "\uD83E\uDD37\uD83C\uDFFE", "\uD83E\uDD37\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person shrugging: light skin tone (1f937-1f3fb)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person shrugging: medium-light skin tone (1f937-1f3fc)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person shrugging: medium skin tone (1f937-1f3fd)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person shrugging: medium-dark skin tone (1f937-1f3fe)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person shrugging: dark skin tone (1f937-1f3ff)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man shrugging (1f937-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD37\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD37\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD37\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD37\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD37\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man shrugging: light skin tone (1f937-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man shrugging: medium-light skin tone (1f937-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man shrugging: medium skin tone (1f937-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man shrugging: medium-dark skin tone (1f937-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man shrugging: dark skin tone (1f937-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman shrugging (1f937-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD37\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD37\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD37\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD37\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD37\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman shrugging: light skin tone (1f937-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman shrugging: medium-light skin tone (1f937-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman shrugging: medium skin tone (1f937-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman shrugging: medium-dark skin tone (1f937-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman shrugging: dark skin tone (1f937-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD37\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // health worker (1f9d1-200d-2695-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\u2695\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\u2695\uFE0F", "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2695\uFE0F", "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2695\uFE0F", "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2695\uFE0F", "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2695\uFE0F"),
            DISPLAY_YES,
        ),
        // health worker: light skin tone (1f9d1-1f3fb-200d-2695-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // health worker: medium-light skin tone (1f9d1-1f3fc-200d-2695-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // health worker: medium skin tone (1f9d1-1f3fd-200d-2695-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // health worker: medium-dark skin tone (1f9d1-1f3fe-200d-2695-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // health worker: dark skin tone (1f9d1-1f3ff-200d-2695-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man health worker (1f468-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\u200D\u2695\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\u2695\uFE0F", "\uD83D\uDC68\uD83C\uDFFC\u200D\u2695\uFE0F", "\uD83D\uDC68\uD83C\uDFFD\u200D\u2695\uFE0F", "\uD83D\uDC68\uD83C\uDFFE\u200D\u2695\uFE0F", "\uD83D\uDC68\uD83C\uDFFF\u200D\u2695\uFE0F"),
            DISPLAY_YES,
        ),
        // man health worker: light skin tone (1f468-1f3fb-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man health worker: medium-light skin tone (1f468-1f3fc-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man health worker: medium skin tone (1f468-1f3fd-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man health worker: medium-dark skin tone (1f468-1f3fe-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man health worker: dark skin tone (1f468-1f3ff-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman health worker (1f469-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2695\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2695\uFE0F", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2695\uFE0F", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2695\uFE0F", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2695\uFE0F", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2695\uFE0F"),
            DISPLAY_YES,
        ),
        // woman health worker: light skin tone (1f469-1f3fb-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman health worker: medium-light skin tone (1f469-1f3fc-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman health worker: medium skin tone (1f469-1f3fd-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman health worker: medium-dark skin tone (1f469-1f3fe-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman health worker: dark skin tone (1f469-1f3ff-200d-2695-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2695\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // student (1f9d1-200d-1f393)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDF93",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF93", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF93", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF93", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF93", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF93"),
            DISPLAY_YES,
        ),
        // student: light skin tone (1f9d1-1f3fb-200d-1f393)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // student: medium-light skin tone (1f9d1-1f3fc-200d-1f393)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // student: medium skin tone (1f9d1-1f3fd-200d-1f393)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // student: medium-dark skin tone (1f9d1-1f3fe-200d-1f393)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // student: dark skin tone (1f9d1-1f3ff-200d-1f393)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man student (1f468-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDF93",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF93", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF93", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF93", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF93", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF93"),
            DISPLAY_YES,
        ),
        // man student: light skin tone (1f468-1f3fb-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man student: medium-light skin tone (1f468-1f3fc-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man student: medium skin tone (1f468-1f3fd-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man student: medium-dark skin tone (1f468-1f3fe-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man student: dark skin tone (1f468-1f3ff-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman student (1f469-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDF93",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF93", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF93", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF93", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF93", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF93"),
            DISPLAY_YES,
        ),
        // woman student: light skin tone (1f469-1f3fb-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman student: medium-light skin tone (1f469-1f3fc-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman student: medium skin tone (1f469-1f3fd-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman student: medium-dark skin tone (1f469-1f3fe-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman student: dark skin tone (1f469-1f3ff-200d-1f393)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF93",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // teacher (1f9d1-200d-1f3eb)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDFEB",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFEB", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFEB", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFEB", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFEB", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFEB"),
            DISPLAY_YES,
        ),
        // teacher: light skin tone (1f9d1-1f3fb-200d-1f3eb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // teacher: medium-light skin tone (1f9d1-1f3fc-200d-1f3eb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // teacher: medium skin tone (1f9d1-1f3fd-200d-1f3eb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // teacher: medium-dark skin tone (1f9d1-1f3fe-200d-1f3eb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // teacher: dark skin tone (1f9d1-1f3ff-200d-1f3eb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man teacher (1f468-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDFEB",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFEB", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFEB", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFEB", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFEB", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFEB"),
            DISPLAY_YES,
        ),
        // man teacher: light skin tone (1f468-1f3fb-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man teacher: medium-light skin tone (1f468-1f3fc-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man teacher: medium skin tone (1f468-1f3fd-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man teacher: medium-dark skin tone (1f468-1f3fe-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man teacher: dark skin tone (1f468-1f3ff-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman teacher (1f469-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDFEB",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFEB", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFEB", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFEB", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFEB", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFEB"),
            DISPLAY_YES,
        ),
        // woman teacher: light skin tone (1f469-1f3fb-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman teacher: medium-light skin tone (1f469-1f3fc-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman teacher: medium skin tone (1f469-1f3fd-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman teacher: medium-dark skin tone (1f469-1f3fe-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman teacher: dark skin tone (1f469-1f3ff-200d-1f3eb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFEB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // judge (1f9d1-200d-2696-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\u2696\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\u2696\uFE0F", "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2696\uFE0F", "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2696\uFE0F", "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2696\uFE0F", "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2696\uFE0F"),
            DISPLAY_YES,
        ),
        // judge: light skin tone (1f9d1-1f3fb-200d-2696-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // judge: medium-light skin tone (1f9d1-1f3fc-200d-2696-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // judge: medium skin tone (1f9d1-1f3fd-200d-2696-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // judge: medium-dark skin tone (1f9d1-1f3fe-200d-2696-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // judge: dark skin tone (1f9d1-1f3ff-200d-2696-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man judge (1f468-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\u200D\u2696\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\u2696\uFE0F", "\uD83D\uDC68\uD83C\uDFFC\u200D\u2696\uFE0F", "\uD83D\uDC68\uD83C\uDFFD\u200D\u2696\uFE0F", "\uD83D\uDC68\uD83C\uDFFE\u200D\u2696\uFE0F", "\uD83D\uDC68\uD83C\uDFFF\u200D\u2696\uFE0F"),
            DISPLAY_YES,
        ),
        // man judge: light skin tone (1f468-1f3fb-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man judge: medium-light skin tone (1f468-1f3fc-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man judge: medium skin tone (1f468-1f3fd-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man judge: medium-dark skin tone (1f468-1f3fe-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man judge: dark skin tone (1f468-1f3ff-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman judge (1f469-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2696\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2696\uFE0F", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2696\uFE0F", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2696\uFE0F", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2696\uFE0F", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2696\uFE0F"),
            DISPLAY_YES,
        ),
        // woman judge: light skin tone (1f469-1f3fb-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman judge: medium-light skin tone (1f469-1f3fc-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman judge: medium skin tone (1f469-1f3fd-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman judge: medium-dark skin tone (1f469-1f3fe-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman judge: dark skin tone (1f469-1f3ff-200d-2696-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2696\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // farmer (1f9d1-200d-1f33e)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDF3E",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF3E", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF3E", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF3E", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF3E", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF3E"),
            DISPLAY_YES,
        ),
        // farmer: light skin tone (1f9d1-1f3fb-200d-1f33e)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // farmer: medium-light skin tone (1f9d1-1f3fc-200d-1f33e)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // farmer: medium skin tone (1f9d1-1f3fd-200d-1f33e)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // farmer: medium-dark skin tone (1f9d1-1f3fe-200d-1f33e)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // farmer: dark skin tone (1f9d1-1f3ff-200d-1f33e)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man farmer (1f468-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDF3E",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF3E", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF3E", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF3E", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF3E", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF3E"),
            DISPLAY_YES,
        ),
        // man farmer: light skin tone (1f468-1f3fb-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man farmer: medium-light skin tone (1f468-1f3fc-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man farmer: medium skin tone (1f468-1f3fd-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man farmer: medium-dark skin tone (1f468-1f3fe-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man farmer: dark skin tone (1f468-1f3ff-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman farmer (1f469-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDF3E",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF3E", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF3E", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF3E", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF3E", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF3E"),
            DISPLAY_YES,
        ),
        // woman farmer: light skin tone (1f469-1f3fb-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman farmer: medium-light skin tone (1f469-1f3fc-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman farmer: medium skin tone (1f469-1f3fd-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman farmer: medium-dark skin tone (1f469-1f3fe-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman farmer: dark skin tone (1f469-1f3ff-200d-1f33e)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF3E",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // cook (1f9d1-200d-1f373)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDF73",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF73", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF73", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF73", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF73", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF73"),
            DISPLAY_YES,
        ),
        // cook: light skin tone (1f9d1-1f3fb-200d-1f373)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // cook: medium-light skin tone (1f9d1-1f3fc-200d-1f373)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // cook: medium skin tone (1f9d1-1f3fd-200d-1f373)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // cook: medium-dark skin tone (1f9d1-1f3fe-200d-1f373)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // cook: dark skin tone (1f9d1-1f3ff-200d-1f373)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cook (1f468-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDF73",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF73", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF73", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF73", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF73", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF73"),
            DISPLAY_YES,
        ),
        // man cook: light skin tone (1f468-1f3fb-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cook: medium-light skin tone (1f468-1f3fc-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cook: medium skin tone (1f468-1f3fd-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cook: medium-dark skin tone (1f468-1f3fe-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cook: dark skin tone (1f468-1f3ff-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cook (1f469-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDF73",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF73", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF73", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF73", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF73", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF73"),
            DISPLAY_YES,
        ),
        // woman cook: light skin tone (1f469-1f3fb-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cook: medium-light skin tone (1f469-1f3fc-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cook: medium skin tone (1f469-1f3fd-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cook: medium-dark skin tone (1f469-1f3fe-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cook: dark skin tone (1f469-1f3ff-200d-1f373)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF73",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mechanic (1f9d1-200d-1f527)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83D\uDD27",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDD27", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDD27", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDD27", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDD27", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDD27"),
            DISPLAY_YES,
        ),
        // mechanic: light skin tone (1f9d1-1f3fb-200d-1f527)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mechanic: medium-light skin tone (1f9d1-1f3fc-200d-1f527)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mechanic: medium skin tone (1f9d1-1f3fd-200d-1f527)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mechanic: medium-dark skin tone (1f9d1-1f3fe-200d-1f527)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mechanic: dark skin tone (1f9d1-1f3ff-200d-1f527)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mechanic (1f468-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDD27",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD27", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD27", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD27", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD27", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD27"),
            DISPLAY_YES,
        ),
        // man mechanic: light skin tone (1f468-1f3fb-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mechanic: medium-light skin tone (1f468-1f3fc-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mechanic: medium skin tone (1f468-1f3fd-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mechanic: medium-dark skin tone (1f468-1f3fe-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mechanic: dark skin tone (1f468-1f3ff-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mechanic (1f469-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDD27",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD27", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD27", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD27", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD27", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD27"),
            DISPLAY_YES,
        ),
        // woman mechanic: light skin tone (1f469-1f3fb-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mechanic: medium-light skin tone (1f469-1f3fc-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mechanic: medium skin tone (1f469-1f3fd-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mechanic: medium-dark skin tone (1f469-1f3fe-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mechanic: dark skin tone (1f469-1f3ff-200d-1f527)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD27",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // factory worker (1f9d1-200d-1f3ed)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDFED",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFED", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFED", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFED", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFED", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFED"),
            DISPLAY_YES,
        ),
        // factory worker: light skin tone (1f9d1-1f3fb-200d-1f3ed)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // factory worker: medium-light skin tone (1f9d1-1f3fc-200d-1f3ed)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // factory worker: medium skin tone (1f9d1-1f3fd-200d-1f3ed)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // factory worker: medium-dark skin tone (1f9d1-1f3fe-200d-1f3ed)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // factory worker: dark skin tone (1f9d1-1f3ff-200d-1f3ed)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man factory worker (1f468-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDFED",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFED", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFED", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFED", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFED", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFED"),
            DISPLAY_YES,
        ),
        // man factory worker: light skin tone (1f468-1f3fb-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man factory worker: medium-light skin tone (1f468-1f3fc-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man factory worker: medium skin tone (1f468-1f3fd-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man factory worker: medium-dark skin tone (1f468-1f3fe-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man factory worker: dark skin tone (1f468-1f3ff-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman factory worker (1f469-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDFED",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFED", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFED", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFED", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFED", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFED"),
            DISPLAY_YES,
        ),
        // woman factory worker: light skin tone (1f469-1f3fb-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman factory worker: medium-light skin tone (1f469-1f3fc-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman factory worker: medium skin tone (1f469-1f3fd-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman factory worker: medium-dark skin tone (1f469-1f3fe-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman factory worker: dark skin tone (1f469-1f3ff-200d-1f3ed)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFED",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // office worker (1f9d1-200d-1f4bc)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83D\uDCBC",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDCBC", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDCBC", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDCBC", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDCBC", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDCBC"),
            DISPLAY_YES,
        ),
        // office worker: light skin tone (1f9d1-1f3fb-200d-1f4bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // office worker: medium-light skin tone (1f9d1-1f3fc-200d-1f4bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // office worker: medium skin tone (1f9d1-1f3fd-200d-1f4bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // office worker: medium-dark skin tone (1f9d1-1f3fe-200d-1f4bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // office worker: dark skin tone (1f9d1-1f3ff-200d-1f4bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man office worker (1f468-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDCBC",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBC", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBC", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBC", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBC", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBC"),
            DISPLAY_YES,
        ),
        // man office worker: light skin tone (1f468-1f3fb-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man office worker: medium-light skin tone (1f468-1f3fc-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man office worker: medium skin tone (1f468-1f3fd-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man office worker: medium-dark skin tone (1f468-1f3fe-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man office worker: dark skin tone (1f468-1f3ff-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman office worker (1f469-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDCBC",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBC", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBC", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBC", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBC", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBC"),
            DISPLAY_YES,
        ),
        // woman office worker: light skin tone (1f469-1f3fb-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman office worker: medium-light skin tone (1f469-1f3fc-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman office worker: medium skin tone (1f469-1f3fd-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman office worker: medium-dark skin tone (1f469-1f3fe-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman office worker: dark skin tone (1f469-1f3ff-200d-1f4bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // scientist (1f9d1-200d-1f52c)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83D\uDD2C",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDD2C", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDD2C", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDD2C", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDD2C", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDD2C"),
            DISPLAY_YES,
        ),
        // scientist: light skin tone (1f9d1-1f3fb-200d-1f52c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // scientist: medium-light skin tone (1f9d1-1f3fc-200d-1f52c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // scientist: medium skin tone (1f9d1-1f3fd-200d-1f52c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // scientist: medium-dark skin tone (1f9d1-1f3fe-200d-1f52c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // scientist: dark skin tone (1f9d1-1f3ff-200d-1f52c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man scientist (1f468-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDD2C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD2C", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD2C", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD2C", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD2C", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD2C"),
            DISPLAY_YES,
        ),
        // man scientist: light skin tone (1f468-1f3fb-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man scientist: medium-light skin tone (1f468-1f3fc-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man scientist: medium skin tone (1f468-1f3fd-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man scientist: medium-dark skin tone (1f468-1f3fe-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man scientist: dark skin tone (1f468-1f3ff-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman scientist (1f469-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDD2C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD2C", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD2C", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD2C", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD2C", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD2C"),
            DISPLAY_YES,
        ),
        // woman scientist: light skin tone (1f469-1f3fb-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman scientist: medium-light skin tone (1f469-1f3fc-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman scientist: medium skin tone (1f469-1f3fd-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman scientist: medium-dark skin tone (1f469-1f3fe-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman scientist: dark skin tone (1f469-1f3ff-200d-1f52c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD2C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // technologist (1f9d1-200d-1f4bb)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83D\uDCBB",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDCBB", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDCBB", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDCBB", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDCBB", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDCBB"),
            DISPLAY_YES,
        ),
        // technologist: light skin tone (1f9d1-1f3fb-200d-1f4bb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // technologist: medium-light skin tone (1f9d1-1f3fc-200d-1f4bb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // technologist: medium skin tone (1f9d1-1f3fd-200d-1f4bb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // technologist: medium-dark skin tone (1f9d1-1f3fe-200d-1f4bb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // technologist: dark skin tone (1f9d1-1f3ff-200d-1f4bb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man technologist (1f468-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDCBB",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBB", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBB", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBB", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBB", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBB"),
            DISPLAY_YES,
        ),
        // man technologist: light skin tone (1f468-1f3fb-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man technologist: medium-light skin tone (1f468-1f3fc-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man technologist: medium skin tone (1f468-1f3fd-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man technologist: medium-dark skin tone (1f468-1f3fe-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man technologist: dark skin tone (1f468-1f3ff-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman technologist (1f469-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDCBB",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBB", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBB", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBB", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBB", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBB"),
            DISPLAY_YES,
        ),
        // woman technologist: light skin tone (1f469-1f3fb-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman technologist: medium-light skin tone (1f469-1f3fc-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman technologist: medium skin tone (1f469-1f3fd-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman technologist: medium-dark skin tone (1f469-1f3fe-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman technologist: dark skin tone (1f469-1f3ff-200d-1f4bb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // singer (1f9d1-200d-1f3a4)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDFA4",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFA4", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFA4", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFA4", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFA4", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFA4"),
            DISPLAY_YES,
        ),
        // singer: light skin tone (1f9d1-1f3fb-200d-1f3a4)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // singer: medium-light skin tone (1f9d1-1f3fc-200d-1f3a4)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // singer: medium skin tone (1f9d1-1f3fd-200d-1f3a4)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // singer: medium-dark skin tone (1f9d1-1f3fe-200d-1f3a4)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // singer: dark skin tone (1f9d1-1f3ff-200d-1f3a4)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man singer (1f468-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDFA4",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA4", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA4", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA4", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA4", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA4"),
            DISPLAY_YES,
        ),
        // man singer: light skin tone (1f468-1f3fb-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man singer: medium-light skin tone (1f468-1f3fc-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man singer: medium skin tone (1f468-1f3fd-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man singer: medium-dark skin tone (1f468-1f3fe-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man singer: dark skin tone (1f468-1f3ff-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman singer (1f469-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDFA4",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA4", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA4", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA4", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA4", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA4"),
            DISPLAY_YES,
        ),
        // woman singer: light skin tone (1f469-1f3fb-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman singer: medium-light skin tone (1f469-1f3fc-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman singer: medium skin tone (1f469-1f3fd-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman singer: medium-dark skin tone (1f469-1f3fe-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman singer: dark skin tone (1f469-1f3ff-200d-1f3a4)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA4",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // artist (1f9d1-200d-1f3a8)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDFA8",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFA8", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFA8", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFA8", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFA8", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFA8"),
            DISPLAY_YES,
        ),
        // artist: light skin tone (1f9d1-1f3fb-200d-1f3a8)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // artist: medium-light skin tone (1f9d1-1f3fc-200d-1f3a8)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // artist: medium skin tone (1f9d1-1f3fd-200d-1f3a8)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // artist: medium-dark skin tone (1f9d1-1f3fe-200d-1f3a8)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // artist: dark skin tone (1f9d1-1f3ff-200d-1f3a8)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man artist (1f468-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDFA8",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA8", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA8", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA8", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA8", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA8"),
            DISPLAY_YES,
        ),
        // man artist: light skin tone (1f468-1f3fb-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man artist: medium-light skin tone (1f468-1f3fc-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man artist: medium skin tone (1f468-1f3fd-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man artist: medium-dark skin tone (1f468-1f3fe-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man artist: dark skin tone (1f468-1f3ff-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman artist (1f469-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDFA8",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA8", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA8", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA8", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA8", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA8"),
            DISPLAY_YES,
        ),
        // woman artist: light skin tone (1f469-1f3fb-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman artist: medium-light skin tone (1f469-1f3fc-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman artist: medium skin tone (1f469-1f3fd-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman artist: medium-dark skin tone (1f469-1f3fe-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman artist: dark skin tone (1f469-1f3ff-200d-1f3a8)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA8",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pilot (1f9d1-200d-2708-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\u2708\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\u2708\uFE0F", "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2708\uFE0F", "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2708\uFE0F", "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2708\uFE0F", "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2708\uFE0F"),
            DISPLAY_YES,
        ),
        // pilot: light skin tone (1f9d1-1f3fb-200d-2708-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pilot: medium-light skin tone (1f9d1-1f3fc-200d-2708-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pilot: medium skin tone (1f9d1-1f3fd-200d-2708-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pilot: medium-dark skin tone (1f9d1-1f3fe-200d-2708-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pilot: dark skin tone (1f9d1-1f3ff-200d-2708-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pilot (1f468-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\u200D\u2708\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\u2708\uFE0F", "\uD83D\uDC68\uD83C\uDFFC\u200D\u2708\uFE0F", "\uD83D\uDC68\uD83C\uDFFD\u200D\u2708\uFE0F", "\uD83D\uDC68\uD83C\uDFFE\u200D\u2708\uFE0F", "\uD83D\uDC68\uD83C\uDFFF\u200D\u2708\uFE0F"),
            DISPLAY_YES,
        ),
        // man pilot: light skin tone (1f468-1f3fb-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pilot: medium-light skin tone (1f468-1f3fc-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pilot: medium skin tone (1f468-1f3fd-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pilot: medium-dark skin tone (1f468-1f3fe-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man pilot: dark skin tone (1f468-1f3ff-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pilot (1f469-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2708\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2708\uFE0F", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2708\uFE0F", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2708\uFE0F", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2708\uFE0F", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2708\uFE0F"),
            DISPLAY_YES,
        ),
        // woman pilot: light skin tone (1f469-1f3fb-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pilot: medium-light skin tone (1f469-1f3fc-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pilot: medium skin tone (1f469-1f3fd-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pilot: medium-dark skin tone (1f469-1f3fe-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman pilot: dark skin tone (1f469-1f3ff-200d-2708-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2708\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // astronaut (1f9d1-200d-1f680)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83D\uDE80",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDE80", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDE80", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDE80", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDE80", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDE80"),
            DISPLAY_YES,
        ),
        // astronaut: light skin tone (1f9d1-1f3fb-200d-1f680)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // astronaut: medium-light skin tone (1f9d1-1f3fc-200d-1f680)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // astronaut: medium skin tone (1f9d1-1f3fd-200d-1f680)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // astronaut: medium-dark skin tone (1f9d1-1f3fe-200d-1f680)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // astronaut: dark skin tone (1f9d1-1f3ff-200d-1f680)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man astronaut (1f468-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDE80",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE80", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE80", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE80", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE80", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE80"),
            DISPLAY_YES,
        ),
        // man astronaut: light skin tone (1f468-1f3fb-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man astronaut: medium-light skin tone (1f468-1f3fc-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man astronaut: medium skin tone (1f468-1f3fd-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man astronaut: medium-dark skin tone (1f468-1f3fe-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man astronaut: dark skin tone (1f468-1f3ff-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman astronaut (1f469-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDE80",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE80", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE80", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE80", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE80", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE80"),
            DISPLAY_YES,
        ),
        // woman astronaut: light skin tone (1f469-1f3fb-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman astronaut: medium-light skin tone (1f469-1f3fc-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman astronaut: medium skin tone (1f469-1f3fd-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman astronaut: medium-dark skin tone (1f469-1f3fe-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman astronaut: dark skin tone (1f469-1f3ff-200d-1f680)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE80",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // firefighter (1f9d1-200d-1f692)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83D\uDE92",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDE92", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDE92", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDE92", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDE92", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDE92"),
            DISPLAY_YES,
        ),
        // firefighter: light skin tone (1f9d1-1f3fb-200d-1f692)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // firefighter: medium-light skin tone (1f9d1-1f3fc-200d-1f692)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // firefighter: medium skin tone (1f9d1-1f3fd-200d-1f692)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // firefighter: medium-dark skin tone (1f9d1-1f3fe-200d-1f692)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // firefighter: dark skin tone (1f9d1-1f3ff-200d-1f692)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man firefighter (1f468-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDE92",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE92", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE92", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE92", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE92", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE92"),
            DISPLAY_YES,
        ),
        // man firefighter: light skin tone (1f468-1f3fb-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man firefighter: medium-light skin tone (1f468-1f3fc-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man firefighter: medium skin tone (1f468-1f3fd-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man firefighter: medium-dark skin tone (1f468-1f3fe-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man firefighter: dark skin tone (1f468-1f3ff-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman firefighter (1f469-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDE92",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE92", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE92", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE92", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE92", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE92"),
            DISPLAY_YES,
        ),
        // woman firefighter: light skin tone (1f469-1f3fb-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman firefighter: medium-light skin tone (1f469-1f3fc-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman firefighter: medium skin tone (1f469-1f3fd-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman firefighter: medium-dark skin tone (1f469-1f3fe-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman firefighter: dark skin tone (1f469-1f3ff-200d-1f692)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE92",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // police officer (1f46e)
        EmojiInfo(
            "\uD83D\uDC6E",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC6E\uD83C\uDFFB", "\uD83D\uDC6E\uD83C\uDFFC", "\uD83D\uDC6E\uD83C\uDFFD", "\uD83D\uDC6E\uD83C\uDFFE", "\uD83D\uDC6E\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // police officer: light skin tone (1f46e-1f3fb)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // police officer: medium-light skin tone (1f46e-1f3fc)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // police officer: medium skin tone (1f46e-1f3fd)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // police officer: medium-dark skin tone (1f46e-1f3fe)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // police officer: dark skin tone (1f46e-1f3ff)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man police officer (1f46e-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man police officer: light skin tone (1f46e-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man police officer: medium-light skin tone (1f46e-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man police officer: medium skin tone (1f46e-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man police officer: medium-dark skin tone (1f46e-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man police officer: dark skin tone (1f46e-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman police officer (1f46e-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman police officer: light skin tone (1f46e-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman police officer: medium-light skin tone (1f46e-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman police officer: medium skin tone (1f46e-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman police officer: medium-dark skin tone (1f46e-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman police officer: dark skin tone (1f46e-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // detective (1f575-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD75\uD83C\uDFFB", "\uD83D\uDD75\uD83C\uDFFC", "\uD83D\uDD75\uD83C\uDFFD", "\uD83D\uDD75\uD83C\uDFFE", "\uD83D\uDD75\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // detective: light skin tone (1f575-1f3fb)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // detective: medium-light skin tone (1f575-1f3fc)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // detective: medium skin tone (1f575-1f3fd)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // detective: medium-dark skin tone (1f575-1f3fe)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // detective: dark skin tone (1f575-1f3ff)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man detective (1f575-fe0f-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uFE0F\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD75\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDD75\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDD75\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDD75\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDD75\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man detective: light skin tone (1f575-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man detective: medium-light skin tone (1f575-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man detective: medium skin tone (1f575-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man detective: medium-dark skin tone (1f575-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man detective: dark skin tone (1f575-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman detective (1f575-fe0f-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uFE0F\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD75\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDD75\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDD75\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDD75\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDD75\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman detective: light skin tone (1f575-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman detective: medium-light skin tone (1f575-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman detective: medium skin tone (1f575-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman detective: medium-dark skin tone (1f575-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman detective: dark skin tone (1f575-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDD75\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // guard (1f482)
        EmojiInfo(
            "\uD83D\uDC82",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC82\uD83C\uDFFB", "\uD83D\uDC82\uD83C\uDFFC", "\uD83D\uDC82\uD83C\uDFFD", "\uD83D\uDC82\uD83C\uDFFE", "\uD83D\uDC82\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // guard: light skin tone (1f482-1f3fb)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // guard: medium-light skin tone (1f482-1f3fc)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // guard: medium skin tone (1f482-1f3fd)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // guard: medium-dark skin tone (1f482-1f3fe)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // guard: dark skin tone (1f482-1f3ff)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man guard (1f482-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC82\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC82\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC82\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC82\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC82\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man guard: light skin tone (1f482-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man guard: medium-light skin tone (1f482-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man guard: medium skin tone (1f482-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man guard: medium-dark skin tone (1f482-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man guard: dark skin tone (1f482-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman guard (1f482-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC82\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC82\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC82\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC82\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC82\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman guard: light skin tone (1f482-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman guard: medium-light skin tone (1f482-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman guard: medium skin tone (1f482-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman guard: medium-dark skin tone (1f482-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman guard: dark skin tone (1f482-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC82\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ninja (1f977)
        EmojiInfo(
            "\uD83E\uDD77",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD77\uD83C\uDFFB", "\uD83E\uDD77\uD83C\uDFFC", "\uD83E\uDD77\uD83C\uDFFD", "\uD83E\uDD77\uD83C\uDFFE", "\uD83E\uDD77\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // ninja: light skin tone (1f977-1f3fb)
        EmojiInfo(
            "\uD83E\uDD77\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ninja: medium-light skin tone (1f977-1f3fc)
        EmojiInfo(
            "\uD83E\uDD77\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ninja: medium skin tone (1f977-1f3fd)
        EmojiInfo(
            "\uD83E\uDD77\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ninja: medium-dark skin tone (1f977-1f3fe)
        EmojiInfo(
            "\uD83E\uDD77\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // ninja: dark skin tone (1f977-1f3ff)
        EmojiInfo(
            "\uD83E\uDD77\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // construction worker (1f477)
        EmojiInfo(
            "\uD83D\uDC77",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC77\uD83C\uDFFB", "\uD83D\uDC77\uD83C\uDFFC", "\uD83D\uDC77\uD83C\uDFFD", "\uD83D\uDC77\uD83C\uDFFE", "\uD83D\uDC77\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // construction worker: light skin tone (1f477-1f3fb)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // construction worker: medium-light skin tone (1f477-1f3fc)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // construction worker: medium skin tone (1f477-1f3fd)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // construction worker: medium-dark skin tone (1f477-1f3fe)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // construction worker: dark skin tone (1f477-1f3ff)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man construction worker (1f477-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC77\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC77\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC77\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC77\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC77\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man construction worker: light skin tone (1f477-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man construction worker: medium-light skin tone (1f477-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man construction worker: medium skin tone (1f477-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man construction worker: medium-dark skin tone (1f477-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man construction worker: dark skin tone (1f477-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman construction worker (1f477-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC77\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC77\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC77\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC77\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC77\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman construction worker: light skin tone (1f477-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman construction worker: medium-light skin tone (1f477-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman construction worker: medium skin tone (1f477-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman construction worker: medium-dark skin tone (1f477-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman construction worker: dark skin tone (1f477-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC77\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with crown (1fac5)
        EmojiInfo(
            "\uD83E\uDEC5",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEC5\uD83C\uDFFB", "\uD83E\uDEC5\uD83C\uDFFC", "\uD83E\uDEC5\uD83C\uDFFD", "\uD83E\uDEC5\uD83C\uDFFE", "\uD83E\uDEC5\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person with crown: light skin tone (1fac5-1f3fb)
        EmojiInfo(
            "\uD83E\uDEC5\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with crown: medium-light skin tone (1fac5-1f3fc)
        EmojiInfo(
            "\uD83E\uDEC5\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with crown: medium skin tone (1fac5-1f3fd)
        EmojiInfo(
            "\uD83E\uDEC5\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with crown: medium-dark skin tone (1fac5-1f3fe)
        EmojiInfo(
            "\uD83E\uDEC5\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with crown: dark skin tone (1fac5-1f3ff)
        EmojiInfo(
            "\uD83E\uDEC5\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // prince (1f934)
        EmojiInfo(
            "\uD83E\uDD34",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD34\uD83C\uDFFB", "\uD83E\uDD34\uD83C\uDFFC", "\uD83E\uDD34\uD83C\uDFFD", "\uD83E\uDD34\uD83C\uDFFE", "\uD83E\uDD34\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // prince: light skin tone (1f934-1f3fb)
        EmojiInfo(
            "\uD83E\uDD34\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // prince: medium-light skin tone (1f934-1f3fc)
        EmojiInfo(
            "\uD83E\uDD34\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // prince: medium skin tone (1f934-1f3fd)
        EmojiInfo(
            "\uD83E\uDD34\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // prince: medium-dark skin tone (1f934-1f3fe)
        EmojiInfo(
            "\uD83E\uDD34\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // prince: dark skin tone (1f934-1f3ff)
        EmojiInfo(
            "\uD83E\uDD34\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // princess (1f478)
        EmojiInfo(
            "\uD83D\uDC78",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC78\uD83C\uDFFB", "\uD83D\uDC78\uD83C\uDFFC", "\uD83D\uDC78\uD83C\uDFFD", "\uD83D\uDC78\uD83C\uDFFE", "\uD83D\uDC78\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // princess: light skin tone (1f478-1f3fb)
        EmojiInfo(
            "\uD83D\uDC78\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // princess: medium-light skin tone (1f478-1f3fc)
        EmojiInfo(
            "\uD83D\uDC78\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // princess: medium skin tone (1f478-1f3fd)
        EmojiInfo(
            "\uD83D\uDC78\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // princess: medium-dark skin tone (1f478-1f3fe)
        EmojiInfo(
            "\uD83D\uDC78\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // princess: dark skin tone (1f478-1f3ff)
        EmojiInfo(
            "\uD83D\uDC78\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person wearing turban (1f473)
        EmojiInfo(
            "\uD83D\uDC73",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC73\uD83C\uDFFB", "\uD83D\uDC73\uD83C\uDFFC", "\uD83D\uDC73\uD83C\uDFFD", "\uD83D\uDC73\uD83C\uDFFE", "\uD83D\uDC73\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person wearing turban: light skin tone (1f473-1f3fb)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person wearing turban: medium-light skin tone (1f473-1f3fc)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person wearing turban: medium skin tone (1f473-1f3fd)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person wearing turban: medium-dark skin tone (1f473-1f3fe)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person wearing turban: dark skin tone (1f473-1f3ff)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man wearing turban (1f473-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC73\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC73\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC73\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC73\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC73\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man wearing turban: light skin tone (1f473-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man wearing turban: medium-light skin tone (1f473-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man wearing turban: medium skin tone (1f473-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man wearing turban: medium-dark skin tone (1f473-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man wearing turban: dark skin tone (1f473-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman wearing turban (1f473-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC73\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC73\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC73\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC73\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC73\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman wearing turban: light skin tone (1f473-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman wearing turban: medium-light skin tone (1f473-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman wearing turban: medium skin tone (1f473-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman wearing turban: medium-dark skin tone (1f473-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman wearing turban: dark skin tone (1f473-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC73\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with skullcap (1f472)
        EmojiInfo(
            "\uD83D\uDC72",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC72\uD83C\uDFFB", "\uD83D\uDC72\uD83C\uDFFC", "\uD83D\uDC72\uD83C\uDFFD", "\uD83D\uDC72\uD83C\uDFFE", "\uD83D\uDC72\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person with skullcap: light skin tone (1f472-1f3fb)
        EmojiInfo(
            "\uD83D\uDC72\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with skullcap: medium-light skin tone (1f472-1f3fc)
        EmojiInfo(
            "\uD83D\uDC72\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with skullcap: medium skin tone (1f472-1f3fd)
        EmojiInfo(
            "\uD83D\uDC72\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with skullcap: medium-dark skin tone (1f472-1f3fe)
        EmojiInfo(
            "\uD83D\uDC72\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with skullcap: dark skin tone (1f472-1f3ff)
        EmojiInfo(
            "\uD83D\uDC72\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with headscarf (1f9d5)
        EmojiInfo(
            "\uD83E\uDDD5",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD5\uD83C\uDFFB", "\uD83E\uDDD5\uD83C\uDFFC", "\uD83E\uDDD5\uD83C\uDFFD", "\uD83E\uDDD5\uD83C\uDFFE", "\uD83E\uDDD5\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // woman with headscarf: light skin tone (1f9d5-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD5\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with headscarf: medium-light skin tone (1f9d5-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD5\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with headscarf: medium skin tone (1f9d5-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD5\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with headscarf: medium-dark skin tone (1f9d5-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD5\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with headscarf: dark skin tone (1f9d5-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD5\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in tuxedo (1f935)
        EmojiInfo(
            "\uD83E\uDD35",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD35\uD83C\uDFFB", "\uD83E\uDD35\uD83C\uDFFC", "\uD83E\uDD35\uD83C\uDFFD", "\uD83E\uDD35\uD83C\uDFFE", "\uD83E\uDD35\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person in tuxedo: light skin tone (1f935-1f3fb)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in tuxedo: medium-light skin tone (1f935-1f3fc)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in tuxedo: medium skin tone (1f935-1f3fd)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in tuxedo: medium-dark skin tone (1f935-1f3fe)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in tuxedo: dark skin tone (1f935-1f3ff)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in tuxedo (1f935-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD35\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD35\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD35\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD35\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD35\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man in tuxedo: light skin tone (1f935-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in tuxedo: medium-light skin tone (1f935-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in tuxedo: medium skin tone (1f935-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in tuxedo: medium-dark skin tone (1f935-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in tuxedo: dark skin tone (1f935-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in tuxedo (1f935-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD35\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD35\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD35\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD35\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD35\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman in tuxedo: light skin tone (1f935-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in tuxedo: medium-light skin tone (1f935-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in tuxedo: medium skin tone (1f935-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in tuxedo: medium-dark skin tone (1f935-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in tuxedo: dark skin tone (1f935-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD35\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with veil (1f470)
        EmojiInfo(
            "\uD83D\uDC70",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC70\uD83C\uDFFB", "\uD83D\uDC70\uD83C\uDFFC", "\uD83D\uDC70\uD83C\uDFFD", "\uD83D\uDC70\uD83C\uDFFE", "\uD83D\uDC70\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person with veil: light skin tone (1f470-1f3fb)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with veil: medium-light skin tone (1f470-1f3fc)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with veil: medium skin tone (1f470-1f3fd)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with veil: medium-dark skin tone (1f470-1f3fe)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with veil: dark skin tone (1f470-1f3ff)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with veil (1f470-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC70\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC70\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC70\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC70\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC70\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man with veil: light skin tone (1f470-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with veil: medium-light skin tone (1f470-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with veil: medium skin tone (1f470-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with veil: medium-dark skin tone (1f470-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with veil: dark skin tone (1f470-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with veil (1f470-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC70\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC70\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC70\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC70\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC70\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman with veil: light skin tone (1f470-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with veil: medium-light skin tone (1f470-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with veil: medium skin tone (1f470-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with veil: medium-dark skin tone (1f470-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with veil: dark skin tone (1f470-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC70\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant woman (1f930)
        EmojiInfo(
            "\uD83E\uDD30",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD30\uD83C\uDFFB", "\uD83E\uDD30\uD83C\uDFFC", "\uD83E\uDD30\uD83C\uDFFD", "\uD83E\uDD30\uD83C\uDFFE", "\uD83E\uDD30\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // pregnant woman: light skin tone (1f930-1f3fb)
        EmojiInfo(
            "\uD83E\uDD30\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant woman: medium-light skin tone (1f930-1f3fc)
        EmojiInfo(
            "\uD83E\uDD30\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant woman: medium skin tone (1f930-1f3fd)
        EmojiInfo(
            "\uD83E\uDD30\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant woman: medium-dark skin tone (1f930-1f3fe)
        EmojiInfo(
            "\uD83E\uDD30\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant woman: dark skin tone (1f930-1f3ff)
        EmojiInfo(
            "\uD83E\uDD30\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant man (1fac3)
        EmojiInfo(
            "\uD83E\uDEC3",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEC3\uD83C\uDFFB", "\uD83E\uDEC3\uD83C\uDFFC", "\uD83E\uDEC3\uD83C\uDFFD", "\uD83E\uDEC3\uD83C\uDFFE", "\uD83E\uDEC3\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // pregnant man: light skin tone (1fac3-1f3fb)
        EmojiInfo(
            "\uD83E\uDEC3\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant man: medium-light skin tone (1fac3-1f3fc)
        EmojiInfo(
            "\uD83E\uDEC3\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant man: medium skin tone (1fac3-1f3fd)
        EmojiInfo(
            "\uD83E\uDEC3\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant man: medium-dark skin tone (1fac3-1f3fe)
        EmojiInfo(
            "\uD83E\uDEC3\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant man: dark skin tone (1fac3-1f3ff)
        EmojiInfo(
            "\uD83E\uDEC3\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant person (1fac4)
        EmojiInfo(
            "\uD83E\uDEC4",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDEC4\uD83C\uDFFB", "\uD83E\uDEC4\uD83C\uDFFC", "\uD83E\uDEC4\uD83C\uDFFD", "\uD83E\uDEC4\uD83C\uDFFE", "\uD83E\uDEC4\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // pregnant person: light skin tone (1fac4-1f3fb)
        EmojiInfo(
            "\uD83E\uDEC4\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant person: medium-light skin tone (1fac4-1f3fc)
        EmojiInfo(
            "\uD83E\uDEC4\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant person: medium skin tone (1fac4-1f3fd)
        EmojiInfo(
            "\uD83E\uDEC4\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant person: medium-dark skin tone (1fac4-1f3fe)
        EmojiInfo(
            "\uD83E\uDEC4\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // pregnant person: dark skin tone (1fac4-1f3ff)
        EmojiInfo(
            "\uD83E\uDEC4\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // breast-feeding (1f931)
        EmojiInfo(
            "\uD83E\uDD31",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD31\uD83C\uDFFB", "\uD83E\uDD31\uD83C\uDFFC", "\uD83E\uDD31\uD83C\uDFFD", "\uD83E\uDD31\uD83C\uDFFE", "\uD83E\uDD31\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // breast-feeding: light skin tone (1f931-1f3fb)
        EmojiInfo(
            "\uD83E\uDD31\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // breast-feeding: medium-light skin tone (1f931-1f3fc)
        EmojiInfo(
            "\uD83E\uDD31\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // breast-feeding: medium skin tone (1f931-1f3fd)
        EmojiInfo(
            "\uD83E\uDD31\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // breast-feeding: medium-dark skin tone (1f931-1f3fe)
        EmojiInfo(
            "\uD83E\uDD31\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // breast-feeding: dark skin tone (1f931-1f3ff)
        EmojiInfo(
            "\uD83E\uDD31\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman feeding baby (1f469-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83C\uDF7C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF7C", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF7C", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF7C", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF7C", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF7C"),
            DISPLAY_YES,
        ),
        // woman feeding baby: light skin tone (1f469-1f3fb-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman feeding baby: medium-light skin tone (1f469-1f3fc-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman feeding baby: medium skin tone (1f469-1f3fd-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman feeding baby: medium-dark skin tone (1f469-1f3fe-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman feeding baby: dark skin tone (1f469-1f3ff-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man feeding baby (1f468-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83C\uDF7C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF7C", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF7C", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF7C", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF7C", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF7C"),
            DISPLAY_YES,
        ),
        // man feeding baby: light skin tone (1f468-1f3fb-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man feeding baby: medium-light skin tone (1f468-1f3fc-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man feeding baby: medium skin tone (1f468-1f3fd-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man feeding baby: medium-dark skin tone (1f468-1f3fe-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man feeding baby: dark skin tone (1f468-1f3ff-200d-1f37c)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person feeding baby (1f9d1-200d-1f37c)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDF7C",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF7C", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF7C", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF7C", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF7C", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF7C"),
            DISPLAY_YES,
        ),
        // person feeding baby: light skin tone (1f9d1-1f3fb-200d-1f37c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person feeding baby: medium-light skin tone (1f9d1-1f3fc-200d-1f37c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person feeding baby: medium skin tone (1f9d1-1f3fd-200d-1f37c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person feeding baby: medium-dark skin tone (1f9d1-1f3fe-200d-1f37c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person feeding baby: dark skin tone (1f9d1-1f3ff-200d-1f37c)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF7C",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby angel (1f47c)
        EmojiInfo(
            "\uD83D\uDC7C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC7C\uD83C\uDFFB", "\uD83D\uDC7C\uD83C\uDFFC", "\uD83D\uDC7C\uD83C\uDFFD", "\uD83D\uDC7C\uD83C\uDFFE", "\uD83D\uDC7C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // baby angel: light skin tone (1f47c-1f3fb)
        EmojiInfo(
            "\uD83D\uDC7C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby angel: medium-light skin tone (1f47c-1f3fc)
        EmojiInfo(
            "\uD83D\uDC7C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby angel: medium skin tone (1f47c-1f3fd)
        EmojiInfo(
            "\uD83D\uDC7C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby angel: medium-dark skin tone (1f47c-1f3fe)
        EmojiInfo(
            "\uD83D\uDC7C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // baby angel: dark skin tone (1f47c-1f3ff)
        EmojiInfo(
            "\uD83D\uDC7C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Santa Claus (1f385)
        EmojiInfo(
            "\uD83C\uDF85",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDF85\uD83C\uDFFB", "\uD83C\uDF85\uD83C\uDFFC", "\uD83C\uDF85\uD83C\uDFFD", "\uD83C\uDF85\uD83C\uDFFE", "\uD83C\uDF85\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // Santa Claus: light skin tone (1f385-1f3fb)
        EmojiInfo(
            "\uD83C\uDF85\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Santa Claus: medium-light skin tone (1f385-1f3fc)
        EmojiInfo(
            "\uD83C\uDF85\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Santa Claus: medium skin tone (1f385-1f3fd)
        EmojiInfo(
            "\uD83C\uDF85\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Santa Claus: medium-dark skin tone (1f385-1f3fe)
        EmojiInfo(
            "\uD83C\uDF85\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Santa Claus: dark skin tone (1f385-1f3ff)
        EmojiInfo(
            "\uD83C\uDF85\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mrs. Claus (1f936)
        EmojiInfo(
            "\uD83E\uDD36",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD36\uD83C\uDFFB", "\uD83E\uDD36\uD83C\uDFFC", "\uD83E\uDD36\uD83C\uDFFD", "\uD83E\uDD36\uD83C\uDFFE", "\uD83E\uDD36\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // Mrs. Claus: light skin tone (1f936-1f3fb)
        EmojiInfo(
            "\uD83E\uDD36\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mrs. Claus: medium-light skin tone (1f936-1f3fc)
        EmojiInfo(
            "\uD83E\uDD36\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mrs. Claus: medium skin tone (1f936-1f3fd)
        EmojiInfo(
            "\uD83E\uDD36\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mrs. Claus: medium-dark skin tone (1f936-1f3fe)
        EmojiInfo(
            "\uD83E\uDD36\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mrs. Claus: dark skin tone (1f936-1f3ff)
        EmojiInfo(
            "\uD83E\uDD36\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mx Claus (1f9d1-200d-1f384)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83C\uDF84",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF84", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF84", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF84", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF84", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF84"),
            DISPLAY_YES,
        ),
        // Mx Claus: light skin tone (1f9d1-1f3fb-200d-1f384)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF84",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mx Claus: medium-light skin tone (1f9d1-1f3fc-200d-1f384)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF84",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mx Claus: medium skin tone (1f9d1-1f3fd-200d-1f384)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF84",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mx Claus: medium-dark skin tone (1f9d1-1f3fe-200d-1f384)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF84",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // Mx Claus: dark skin tone (1f9d1-1f3ff-200d-1f384)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF84",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // superhero (1f9b8)
        EmojiInfo(
            "\uD83E\uDDB8",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB8\uD83C\uDFFB", "\uD83E\uDDB8\uD83C\uDFFC", "\uD83E\uDDB8\uD83C\uDFFD", "\uD83E\uDDB8\uD83C\uDFFE", "\uD83E\uDDB8\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // superhero: light skin tone (1f9b8-1f3fb)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // superhero: medium-light skin tone (1f9b8-1f3fc)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // superhero: medium skin tone (1f9b8-1f3fd)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // superhero: medium-dark skin tone (1f9b8-1f3fe)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // superhero: dark skin tone (1f9b8-1f3ff)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man superhero (1f9b8-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man superhero: light skin tone (1f9b8-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man superhero: medium-light skin tone (1f9b8-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man superhero: medium skin tone (1f9b8-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man superhero: medium-dark skin tone (1f9b8-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man superhero: dark skin tone (1f9b8-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman superhero (1f9b8-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman superhero: light skin tone (1f9b8-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman superhero: medium-light skin tone (1f9b8-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman superhero: medium skin tone (1f9b8-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman superhero: medium-dark skin tone (1f9b8-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman superhero: dark skin tone (1f9b8-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // supervillain (1f9b9)
        EmojiInfo(
            "\uD83E\uDDB9",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB9\uD83C\uDFFB", "\uD83E\uDDB9\uD83C\uDFFC", "\uD83E\uDDB9\uD83C\uDFFD", "\uD83E\uDDB9\uD83C\uDFFE", "\uD83E\uDDB9\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // supervillain: light skin tone (1f9b9-1f3fb)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // supervillain: medium-light skin tone (1f9b9-1f3fc)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // supervillain: medium skin tone (1f9b9-1f3fd)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // supervillain: medium-dark skin tone (1f9b9-1f3fe)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // supervillain: dark skin tone (1f9b9-1f3ff)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man supervillain (1f9b9-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man supervillain: light skin tone (1f9b9-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man supervillain: medium-light skin tone (1f9b9-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man supervillain: medium skin tone (1f9b9-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man supervillain: medium-dark skin tone (1f9b9-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man supervillain: dark skin tone (1f9b9-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman supervillain (1f9b9-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman supervillain: light skin tone (1f9b9-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman supervillain: medium-light skin tone (1f9b9-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman supervillain: medium skin tone (1f9b9-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman supervillain: medium-dark skin tone (1f9b9-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman supervillain: dark skin tone (1f9b9-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mage (1f9d9)
        EmojiInfo(
            "\uD83E\uDDD9",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD9\uD83C\uDFFB", "\uD83E\uDDD9\uD83C\uDFFC", "\uD83E\uDDD9\uD83C\uDFFD", "\uD83E\uDDD9\uD83C\uDFFE", "\uD83E\uDDD9\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // mage: light skin tone (1f9d9-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mage: medium-light skin tone (1f9d9-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mage: medium skin tone (1f9d9-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mage: medium-dark skin tone (1f9d9-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mage: dark skin tone (1f9d9-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mage (1f9d9-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man mage: light skin tone (1f9d9-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mage: medium-light skin tone (1f9d9-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mage: medium skin tone (1f9d9-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mage: medium-dark skin tone (1f9d9-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mage: dark skin tone (1f9d9-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mage (1f9d9-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman mage: light skin tone (1f9d9-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mage: medium-light skin tone (1f9d9-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mage: medium skin tone (1f9d9-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mage: medium-dark skin tone (1f9d9-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mage: dark skin tone (1f9d9-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // fairy (1f9da)
        EmojiInfo(
            "\uD83E\uDDDA",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDA\uD83C\uDFFB", "\uD83E\uDDDA\uD83C\uDFFC", "\uD83E\uDDDA\uD83C\uDFFD", "\uD83E\uDDDA\uD83C\uDFFE", "\uD83E\uDDDA\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // fairy: light skin tone (1f9da-1f3fb)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // fairy: medium-light skin tone (1f9da-1f3fc)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // fairy: medium skin tone (1f9da-1f3fd)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // fairy: medium-dark skin tone (1f9da-1f3fe)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // fairy: dark skin tone (1f9da-1f3ff)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man fairy (1f9da-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man fairy: light skin tone (1f9da-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man fairy: medium-light skin tone (1f9da-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man fairy: medium skin tone (1f9da-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man fairy: medium-dark skin tone (1f9da-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man fairy: dark skin tone (1f9da-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman fairy (1f9da-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman fairy: light skin tone (1f9da-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman fairy: medium-light skin tone (1f9da-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman fairy: medium skin tone (1f9da-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman fairy: medium-dark skin tone (1f9da-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman fairy: dark skin tone (1f9da-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vampire (1f9db)
        EmojiInfo(
            "\uD83E\uDDDB",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDB\uD83C\uDFFB", "\uD83E\uDDDB\uD83C\uDFFC", "\uD83E\uDDDB\uD83C\uDFFD", "\uD83E\uDDDB\uD83C\uDFFE", "\uD83E\uDDDB\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // vampire: light skin tone (1f9db-1f3fb)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vampire: medium-light skin tone (1f9db-1f3fc)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vampire: medium skin tone (1f9db-1f3fd)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vampire: medium-dark skin tone (1f9db-1f3fe)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // vampire: dark skin tone (1f9db-1f3ff)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man vampire (1f9db-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man vampire: light skin tone (1f9db-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man vampire: medium-light skin tone (1f9db-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man vampire: medium skin tone (1f9db-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man vampire: medium-dark skin tone (1f9db-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man vampire: dark skin tone (1f9db-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman vampire (1f9db-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman vampire: light skin tone (1f9db-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman vampire: medium-light skin tone (1f9db-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman vampire: medium skin tone (1f9db-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman vampire: medium-dark skin tone (1f9db-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman vampire: dark skin tone (1f9db-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merperson (1f9dc)
        EmojiInfo(
            "\uD83E\uDDDC",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDC\uD83C\uDFFB", "\uD83E\uDDDC\uD83C\uDFFC", "\uD83E\uDDDC\uD83C\uDFFD", "\uD83E\uDDDC\uD83C\uDFFE", "\uD83E\uDDDC\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // merperson: light skin tone (1f9dc-1f3fb)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merperson: medium-light skin tone (1f9dc-1f3fc)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merperson: medium skin tone (1f9dc-1f3fd)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merperson: medium-dark skin tone (1f9dc-1f3fe)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merperson: dark skin tone (1f9dc-1f3ff)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merman (1f9dc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // merman: light skin tone (1f9dc-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merman: medium-light skin tone (1f9dc-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merman: medium skin tone (1f9dc-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merman: medium-dark skin tone (1f9dc-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // merman: dark skin tone (1f9dc-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mermaid (1f9dc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // mermaid: light skin tone (1f9dc-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mermaid: medium-light skin tone (1f9dc-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mermaid: medium skin tone (1f9dc-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mermaid: medium-dark skin tone (1f9dc-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // mermaid: dark skin tone (1f9dc-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // elf (1f9dd)
        EmojiInfo(
            "\uD83E\uDDDD",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDD\uD83C\uDFFB", "\uD83E\uDDDD\uD83C\uDFFC", "\uD83E\uDDDD\uD83C\uDFFD", "\uD83E\uDDDD\uD83C\uDFFE", "\uD83E\uDDDD\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // elf: light skin tone (1f9dd-1f3fb)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // elf: medium-light skin tone (1f9dd-1f3fc)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // elf: medium skin tone (1f9dd-1f3fd)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // elf: medium-dark skin tone (1f9dd-1f3fe)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // elf: dark skin tone (1f9dd-1f3ff)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man elf (1f9dd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man elf: light skin tone (1f9dd-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man elf: medium-light skin tone (1f9dd-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man elf: medium skin tone (1f9dd-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man elf: medium-dark skin tone (1f9dd-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man elf: dark skin tone (1f9dd-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman elf (1f9dd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman elf: light skin tone (1f9dd-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman elf: medium-light skin tone (1f9dd-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman elf: medium skin tone (1f9dd-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman elf: medium-dark skin tone (1f9dd-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman elf: dark skin tone (1f9dd-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // genie (1f9de)
        EmojiInfo(
            "\uD83E\uDDDE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // man genie (1f9de-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDE\u200D\u2642\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woman genie (1f9de-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDE\u200D\u2640\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // zombie (1f9df)
        EmojiInfo(
            "\uD83E\uDDDF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // man zombie (1f9df-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDDF\u200D\u2642\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woman zombie (1f9df-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDDF\u200D\u2640\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // troll (1f9cc)
        EmojiInfo(
            "\uD83E\uDDCC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // person getting massage (1f486)
        EmojiInfo(
            "\uD83D\uDC86",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC86\uD83C\uDFFB", "\uD83D\uDC86\uD83C\uDFFC", "\uD83D\uDC86\uD83C\uDFFD", "\uD83D\uDC86\uD83C\uDFFE", "\uD83D\uDC86\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person getting massage: light skin tone (1f486-1f3fb)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting massage: medium-light skin tone (1f486-1f3fc)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting massage: medium skin tone (1f486-1f3fd)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting massage: medium-dark skin tone (1f486-1f3fe)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting massage: dark skin tone (1f486-1f3ff)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting massage (1f486-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC86\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC86\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC86\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC86\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC86\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man getting massage: light skin tone (1f486-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting massage: medium-light skin tone (1f486-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting massage: medium skin tone (1f486-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting massage: medium-dark skin tone (1f486-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting massage: dark skin tone (1f486-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting massage (1f486-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC86\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC86\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC86\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC86\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC86\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman getting massage: light skin tone (1f486-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting massage: medium-light skin tone (1f486-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting massage: medium skin tone (1f486-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting massage: medium-dark skin tone (1f486-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting massage: dark skin tone (1f486-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC86\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting haircut (1f487)
        EmojiInfo(
            "\uD83D\uDC87",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC87\uD83C\uDFFB", "\uD83D\uDC87\uD83C\uDFFC", "\uD83D\uDC87\uD83C\uDFFD", "\uD83D\uDC87\uD83C\uDFFE", "\uD83D\uDC87\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person getting haircut: light skin tone (1f487-1f3fb)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting haircut: medium-light skin tone (1f487-1f3fc)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting haircut: medium skin tone (1f487-1f3fd)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting haircut: medium-dark skin tone (1f487-1f3fe)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person getting haircut: dark skin tone (1f487-1f3ff)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting haircut (1f487-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC87\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDC87\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDC87\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDC87\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDC87\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man getting haircut: light skin tone (1f487-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting haircut: medium-light skin tone (1f487-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting haircut: medium skin tone (1f487-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting haircut: medium-dark skin tone (1f487-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man getting haircut: dark skin tone (1f487-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting haircut (1f487-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC87\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDC87\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDC87\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDC87\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDC87\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman getting haircut: light skin tone (1f487-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting haircut: medium-light skin tone (1f487-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting haircut: medium skin tone (1f487-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting haircut: medium-dark skin tone (1f487-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman getting haircut: dark skin tone (1f487-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC87\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking (1f6b6)
        EmojiInfo(
            "\uD83D\uDEB6",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB6\uD83C\uDFFB", "\uD83D\uDEB6\uD83C\uDFFC", "\uD83D\uDEB6\uD83C\uDFFD", "\uD83D\uDEB6\uD83C\uDFFE", "\uD83D\uDEB6\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person walking: light skin tone (1f6b6-1f3fb)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking: medium-light skin tone (1f6b6-1f3fc)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking: medium skin tone (1f6b6-1f3fd)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking: medium-dark skin tone (1f6b6-1f3fe)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking: dark skin tone (1f6b6-1f3ff)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking (1f6b6-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man walking: light skin tone (1f6b6-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking: medium-light skin tone (1f6b6-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking: medium skin tone (1f6b6-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking: medium-dark skin tone (1f6b6-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking: dark skin tone (1f6b6-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking (1f6b6-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman walking: light skin tone (1f6b6-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking: medium-light skin tone (1f6b6-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking: medium skin tone (1f6b6-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking: medium-dark skin tone (1f6b6-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking: dark skin tone (1f6b6-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking facing right (1f6b6-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB6\uD83C\uDFFB\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFC\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFD\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFE\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFF\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // person walking facing right (1f6b6-1f3fb-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFB\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking facing right (1f6b6-1f3fc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking facing right (1f6b6-1f3fd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking facing right (1f6b6-1f3fe-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFE\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person walking facing right (1f6b6-1f3ff-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking facing right (1f6b6-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // woman walking facing right (1f6b6-1f3fb-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking facing right (1f6b6-1f3fc-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking facing right (1f6b6-1f3fd-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking facing right (1f6b6-1f3fe-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman walking facing right (1f6b6-1f3ff-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking facing right (1f6b6-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // man walking facing right (1f6b6-1f3fb-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking facing right (1f6b6-1f3fc-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking facing right (1f6b6-1f3fd-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking facing right (1f6b6-1f3fe-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man walking facing right (1f6b6-1f3ff-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person standing (1f9cd)
        EmojiInfo(
            "\uD83E\uDDCD",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCD\uD83C\uDFFB", "\uD83E\uDDCD\uD83C\uDFFC", "\uD83E\uDDCD\uD83C\uDFFD", "\uD83E\uDDCD\uD83C\uDFFE", "\uD83E\uDDCD\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person standing: light skin tone (1f9cd-1f3fb)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person standing: medium-light skin tone (1f9cd-1f3fc)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person standing: medium skin tone (1f9cd-1f3fd)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person standing: medium-dark skin tone (1f9cd-1f3fe)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person standing: dark skin tone (1f9cd-1f3ff)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man standing (1f9cd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCD\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man standing: light skin tone (1f9cd-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man standing: medium-light skin tone (1f9cd-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man standing: medium skin tone (1f9cd-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man standing: medium-dark skin tone (1f9cd-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man standing: dark skin tone (1f9cd-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman standing (1f9cd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCD\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman standing: light skin tone (1f9cd-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman standing: medium-light skin tone (1f9cd-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman standing: medium skin tone (1f9cd-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman standing: medium-dark skin tone (1f9cd-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman standing: dark skin tone (1f9cd-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling (1f9ce)
        EmojiInfo(
            "\uD83E\uDDCE",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCE\uD83C\uDFFB", "\uD83E\uDDCE\uD83C\uDFFC", "\uD83E\uDDCE\uD83C\uDFFD", "\uD83E\uDDCE\uD83C\uDFFE", "\uD83E\uDDCE\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person kneeling: light skin tone (1f9ce-1f3fb)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling: medium-light skin tone (1f9ce-1f3fc)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling: medium skin tone (1f9ce-1f3fd)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling: medium-dark skin tone (1f9ce-1f3fe)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling: dark skin tone (1f9ce-1f3ff)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling (1f9ce-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCE\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man kneeling: light skin tone (1f9ce-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling: medium-light skin tone (1f9ce-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling: medium skin tone (1f9ce-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling: medium-dark skin tone (1f9ce-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling: dark skin tone (1f9ce-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling (1f9ce-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCE\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman kneeling: light skin tone (1f9ce-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling: medium-light skin tone (1f9ce-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling: medium skin tone (1f9ce-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling: medium-dark skin tone (1f9ce-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling: dark skin tone (1f9ce-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling facing right (1f9ce-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCE\uD83C\uDFFB\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFC\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFD\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFE\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFF\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // person kneeling facing right (1f9ce-1f3fb-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFB\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling facing right (1f9ce-1f3fc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling facing right (1f9ce-1f3fd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling facing right (1f9ce-1f3fe-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFE\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person kneeling facing right (1f9ce-1f3ff-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling facing right (1f9ce-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCE\uD83C\uDFFB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // woman kneeling facing right (1f9ce-1f3fb-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling facing right (1f9ce-1f3fc-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling facing right (1f9ce-1f3fd-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling facing right (1f9ce-1f3fe-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman kneeling facing right (1f9ce-1f3ff-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling facing right (1f9ce-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDCE\uD83C\uDFFB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // man kneeling facing right (1f9ce-1f3fb-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling facing right (1f9ce-1f3fc-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling facing right (1f9ce-1f3fd-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling facing right (1f9ce-1f3fe-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man kneeling facing right (1f9ce-1f3ff-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane (1f9d1-200d-1f9af)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDAF",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDAF", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDAF", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDAF", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDAF", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDAF"),
            DISPLAY_YES,
        ),
        // person with white cane: light skin tone (1f9d1-1f3fb-200d-1f9af)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane: medium-light skin tone (1f9d1-1f3fc-200d-1f9af)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane: medium skin tone (1f9d1-1f3fd-200d-1f9af)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane: medium-dark skin tone (1f9d1-1f3fe-200d-1f9af)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane: dark skin tone (1f9d1-1f3ff-200d-1f9af)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane facing right (1f9d1-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // person with white cane facing right (1f9d1-1f3fb-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane facing right (1f9d1-1f3fc-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane facing right (1f9d1-1f3fd-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane facing right (1f9d1-1f3fe-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person with white cane facing right (1f9d1-1f3ff-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane (1f468-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDAF",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDAF", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDAF", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDAF", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDAF", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDAF"),
            DISPLAY_YES,
        ),
        // man with white cane: light skin tone (1f468-1f3fb-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane: medium-light skin tone (1f468-1f3fc-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane: medium skin tone (1f468-1f3fd-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane: medium-dark skin tone (1f468-1f3fe-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane: dark skin tone (1f468-1f3ff-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane facing right (1f468-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // man with white cane facing right (1f468-1f3fb-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane facing right (1f468-1f3fc-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane facing right (1f468-1f3fd-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane facing right (1f468-1f3fe-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man with white cane facing right (1f468-1f3ff-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane (1f469-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDAF",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDAF", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDAF", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDAF", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDAF", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDAF"),
            DISPLAY_YES,
        ),
        // woman with white cane: light skin tone (1f469-1f3fb-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane: medium-light skin tone (1f469-1f3fc-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane: medium skin tone (1f469-1f3fd-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane: medium-dark skin tone (1f469-1f3fe-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane: dark skin tone (1f469-1f3ff-200d-1f9af)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDAF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane facing right (1f469-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // woman with white cane facing right (1f469-1f3fb-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane facing right (1f469-1f3fc-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane facing right (1f469-1f3fd-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane facing right (1f469-1f3fe-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman with white cane facing right (1f469-1f3ff-200d-1f9af-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDAF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair (1f9d1-200d-1f9bc)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDBC",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBC", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBC", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBC", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBC", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBC"),
            DISPLAY_YES,
        ),
        // person in motorized wheelchair: light skin tone (1f9d1-1f3fb-200d-1f9bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair: medium-light skin tone (1f9d1-1f3fc-200d-1f9bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair: medium skin tone (1f9d1-1f3fd-200d-1f9bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair: medium-dark skin tone (1f9d1-1f3fe-200d-1f9bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair: dark skin tone (1f9d1-1f3ff-200d-1f9bc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair facing right (1f9d1-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // person in motorized wheelchair facing right (1f9d1-1f3fb-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair facing right (1f9d1-1f3fc-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair facing right (1f9d1-1f3fd-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair facing right (1f9d1-1f3fe-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in motorized wheelchair facing right (1f9d1-1f3ff-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair (1f468-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDBC",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBC", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBC", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBC", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBC", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBC"),
            DISPLAY_YES,
        ),
        // man in motorized wheelchair: light skin tone (1f468-1f3fb-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair: medium-light skin tone (1f468-1f3fc-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair: medium skin tone (1f468-1f3fd-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair: medium-dark skin tone (1f468-1f3fe-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair: dark skin tone (1f468-1f3ff-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair facing right (1f468-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // man in motorized wheelchair facing right (1f468-1f3fb-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair facing right (1f468-1f3fc-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair facing right (1f468-1f3fd-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair facing right (1f468-1f3fe-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in motorized wheelchair facing right (1f468-1f3ff-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair (1f469-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDBC",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBC", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBC", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBC", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBC", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBC"),
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair: light skin tone (1f469-1f3fb-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair: medium-light skin tone (1f469-1f3fc-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair: medium skin tone (1f469-1f3fd-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair: medium-dark skin tone (1f469-1f3fe-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair: dark skin tone (1f469-1f3ff-200d-1f9bc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair facing right (1f469-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair facing right (1f469-1f3fb-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair facing right (1f469-1f3fc-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair facing right (1f469-1f3fd-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair facing right (1f469-1f3fe-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in motorized wheelchair facing right (1f469-1f3ff-200d-1f9bc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair (1f9d1-200d-1f9bd)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDBD",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBD", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBD", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBD", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBD", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBD"),
            DISPLAY_YES,
        ),
        // person in manual wheelchair: light skin tone (1f9d1-1f3fb-200d-1f9bd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair: medium-light skin tone (1f9d1-1f3fc-200d-1f9bd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair: medium skin tone (1f9d1-1f3fd-200d-1f9bd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair: medium-dark skin tone (1f9d1-1f3fe-200d-1f9bd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair: dark skin tone (1f9d1-1f3ff-200d-1f9bd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair facing right (1f9d1-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // person in manual wheelchair facing right (1f9d1-1f3fb-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair facing right (1f9d1-1f3fc-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair facing right (1f9d1-1f3fd-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair facing right (1f9d1-1f3fe-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in manual wheelchair facing right (1f9d1-1f3ff-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair (1f468-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDBD",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBD", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBD", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBD", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBD", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBD"),
            DISPLAY_YES,
        ),
        // man in manual wheelchair: light skin tone (1f468-1f3fb-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair: medium-light skin tone (1f468-1f3fc-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair: medium skin tone (1f468-1f3fd-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair: medium-dark skin tone (1f468-1f3fe-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair: dark skin tone (1f468-1f3ff-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair facing right (1f468-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // man in manual wheelchair facing right (1f468-1f3fb-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair facing right (1f468-1f3fc-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair facing right (1f468-1f3fd-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair facing right (1f468-1f3fe-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in manual wheelchair facing right (1f468-1f3ff-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair (1f469-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDBD",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBD", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBD", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBD", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBD", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBD"),
            DISPLAY_YES,
        ),
        // woman in manual wheelchair: light skin tone (1f469-1f3fb-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair: medium-light skin tone (1f469-1f3fc-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair: medium skin tone (1f469-1f3fd-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair: medium-dark skin tone (1f469-1f3fe-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair: dark skin tone (1f469-1f3ff-200d-1f9bd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair facing right (1f469-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // woman in manual wheelchair facing right (1f469-1f3fb-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair facing right (1f469-1f3fc-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair facing right (1f469-1f3fd-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair facing right (1f469-1f3fe-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in manual wheelchair facing right (1f469-1f3ff-200d-1f9bd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running (1f3c3)
        EmojiInfo(
            "\uD83C\uDFC3",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC3\uD83C\uDFFB", "\uD83C\uDFC3\uD83C\uDFFC", "\uD83C\uDFC3\uD83C\uDFFD", "\uD83C\uDFC3\uD83C\uDFFE", "\uD83C\uDFC3\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person running: light skin tone (1f3c3-1f3fb)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running: medium-light skin tone (1f3c3-1f3fc)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running: medium skin tone (1f3c3-1f3fd)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running: medium-dark skin tone (1f3c3-1f3fe)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running: dark skin tone (1f3c3-1f3ff)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running (1f3c3-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man running: light skin tone (1f3c3-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running: medium-light skin tone (1f3c3-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running: medium skin tone (1f3c3-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running: medium-dark skin tone (1f3c3-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running: dark skin tone (1f3c3-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running (1f3c3-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman running: light skin tone (1f3c3-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running: medium-light skin tone (1f3c3-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running: medium skin tone (1f3c3-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running: medium-dark skin tone (1f3c3-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running: dark skin tone (1f3c3-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running facing right (1f3c3-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC3\uD83C\uDFFB\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFC\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFD\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFE\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFF\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // person running facing right (1f3c3-1f3fb-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFB\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running facing right (1f3c3-1f3fc-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFC\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running facing right (1f3c3-1f3fd-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFD\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running facing right (1f3c3-1f3fe-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFE\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person running facing right (1f3c3-1f3ff-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFF\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running facing right (1f3c3-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // woman running facing right (1f3c3-1f3fb-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running facing right (1f3c3-1f3fc-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running facing right (1f3c3-1f3fd-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running facing right (1f3c3-1f3fe-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman running facing right (1f3c3-1f3ff-200d-2640-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running facing right (1f3c3-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F"),
            DISPLAY_YES,
        ),
        // man running facing right (1f3c3-1f3fb-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running facing right (1f3c3-1f3fc-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running facing right (1f3c3-1f3fd-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running facing right (1f3c3-1f3fe-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man running facing right (1f3c3-1f3ff-200d-2642-fe0f-200d-27a1-fe0f)
        EmojiInfo(
            "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman dancing (1f483)
        EmojiInfo(
            "\uD83D\uDC83",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC83\uD83C\uDFFB", "\uD83D\uDC83\uD83C\uDFFC", "\uD83D\uDC83\uD83C\uDFFD", "\uD83D\uDC83\uD83C\uDFFE", "\uD83D\uDC83\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // woman dancing: light skin tone (1f483-1f3fb)
        EmojiInfo(
            "\uD83D\uDC83\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman dancing: medium-light skin tone (1f483-1f3fc)
        EmojiInfo(
            "\uD83D\uDC83\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman dancing: medium skin tone (1f483-1f3fd)
        EmojiInfo(
            "\uD83D\uDC83\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman dancing: medium-dark skin tone (1f483-1f3fe)
        EmojiInfo(
            "\uD83D\uDC83\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman dancing: dark skin tone (1f483-1f3ff)
        EmojiInfo(
            "\uD83D\uDC83\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man dancing (1f57a)
        EmojiInfo(
            "\uD83D\uDD7A",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD7A\uD83C\uDFFB", "\uD83D\uDD7A\uD83C\uDFFC", "\uD83D\uDD7A\uD83C\uDFFD", "\uD83D\uDD7A\uD83C\uDFFE", "\uD83D\uDD7A\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // man dancing: light skin tone (1f57a-1f3fb)
        EmojiInfo(
            "\uD83D\uDD7A\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man dancing: medium-light skin tone (1f57a-1f3fc)
        EmojiInfo(
            "\uD83D\uDD7A\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man dancing: medium skin tone (1f57a-1f3fd)
        EmojiInfo(
            "\uD83D\uDD7A\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man dancing: medium-dark skin tone (1f57a-1f3fe)
        EmojiInfo(
            "\uD83D\uDD7A\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man dancing: dark skin tone (1f57a-1f3ff)
        EmojiInfo(
            "\uD83D\uDD7A\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in suit levitating (1f574-fe0f)
        EmojiInfo(
            "\uD83D\uDD74\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDD74\uD83C\uDFFB", "\uD83D\uDD74\uD83C\uDFFC", "\uD83D\uDD74\uD83C\uDFFD", "\uD83D\uDD74\uD83C\uDFFE", "\uD83D\uDD74\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person in suit levitating: light skin tone (1f574-1f3fb)
        EmojiInfo(
            "\uD83D\uDD74\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in suit levitating: medium-light skin tone (1f574-1f3fc)
        EmojiInfo(
            "\uD83D\uDD74\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in suit levitating: medium skin tone (1f574-1f3fd)
        EmojiInfo(
            "\uD83D\uDD74\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in suit levitating: medium-dark skin tone (1f574-1f3fe)
        EmojiInfo(
            "\uD83D\uDD74\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in suit levitating: dark skin tone (1f574-1f3ff)
        EmojiInfo(
            "\uD83D\uDD74\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people with bunny ears (1f46f)
        EmojiInfo(
            "\uD83D\uDC6F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // men with bunny ears (1f46f-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDC6F\u200D\u2642\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // women with bunny ears (1f46f-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDC6F\u200D\u2640\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // person in steamy room (1f9d6)
        EmojiInfo(
            "\uD83E\uDDD6",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD6\uD83C\uDFFB", "\uD83E\uDDD6\uD83C\uDFFC", "\uD83E\uDDD6\uD83C\uDFFD", "\uD83E\uDDD6\uD83C\uDFFE", "\uD83E\uDDD6\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person in steamy room: light skin tone (1f9d6-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in steamy room: medium-light skin tone (1f9d6-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in steamy room: medium skin tone (1f9d6-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in steamy room: medium-dark skin tone (1f9d6-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in steamy room: dark skin tone (1f9d6-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in steamy room (1f9d6-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man in steamy room: light skin tone (1f9d6-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in steamy room: medium-light skin tone (1f9d6-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in steamy room: medium skin tone (1f9d6-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in steamy room: medium-dark skin tone (1f9d6-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in steamy room: dark skin tone (1f9d6-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in steamy room (1f9d6-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman in steamy room: light skin tone (1f9d6-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in steamy room: medium-light skin tone (1f9d6-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in steamy room: medium skin tone (1f9d6-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in steamy room: medium-dark skin tone (1f9d6-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in steamy room: dark skin tone (1f9d6-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person climbing (1f9d7)
        EmojiInfo(
            "\uD83E\uDDD7",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD7\uD83C\uDFFB", "\uD83E\uDDD7\uD83C\uDFFC", "\uD83E\uDDD7\uD83C\uDFFD", "\uD83E\uDDD7\uD83C\uDFFE", "\uD83E\uDDD7\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person climbing: light skin tone (1f9d7-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person climbing: medium-light skin tone (1f9d7-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person climbing: medium skin tone (1f9d7-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person climbing: medium-dark skin tone (1f9d7-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person climbing: dark skin tone (1f9d7-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man climbing (1f9d7-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man climbing: light skin tone (1f9d7-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man climbing: medium-light skin tone (1f9d7-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man climbing: medium skin tone (1f9d7-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man climbing: medium-dark skin tone (1f9d7-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man climbing: dark skin tone (1f9d7-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman climbing (1f9d7-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman climbing: light skin tone (1f9d7-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman climbing: medium-light skin tone (1f9d7-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman climbing: medium skin tone (1f9d7-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman climbing: medium-dark skin tone (1f9d7-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman climbing: dark skin tone (1f9d7-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person fencing (1f93a)
        EmojiInfo(
            "\uD83E\uDD3A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // horse racing (1f3c7)
        EmojiInfo(
            "\uD83C\uDFC7",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC7\uD83C\uDFFB", "\uD83C\uDFC7\uD83C\uDFFC", "\uD83C\uDFC7\uD83C\uDFFD", "\uD83C\uDFC7\uD83C\uDFFE", "\uD83C\uDFC7\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // horse racing: light skin tone (1f3c7-1f3fb)
        EmojiInfo(
            "\uD83C\uDFC7\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // horse racing: medium-light skin tone (1f3c7-1f3fc)
        EmojiInfo(
            "\uD83C\uDFC7\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // horse racing: medium skin tone (1f3c7-1f3fd)
        EmojiInfo(
            "\uD83C\uDFC7\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // horse racing: medium-dark skin tone (1f3c7-1f3fe)
        EmojiInfo(
            "\uD83C\uDFC7\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // horse racing: dark skin tone (1f3c7-1f3ff)
        EmojiInfo(
            "\uD83C\uDFC7\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // skier (26f7-fe0f)
        EmojiInfo(
            "\u26F7\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snowboarder (1f3c2)
        EmojiInfo(
            "\uD83C\uDFC2",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC2\uD83C\uDFFB", "\uD83C\uDFC2\uD83C\uDFFC", "\uD83C\uDFC2\uD83C\uDFFD", "\uD83C\uDFC2\uD83C\uDFFE", "\uD83C\uDFC2\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // snowboarder: light skin tone (1f3c2-1f3fb)
        EmojiInfo(
            "\uD83C\uDFC2\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // snowboarder: medium-light skin tone (1f3c2-1f3fc)
        EmojiInfo(
            "\uD83C\uDFC2\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // snowboarder: medium skin tone (1f3c2-1f3fd)
        EmojiInfo(
            "\uD83C\uDFC2\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // snowboarder: medium-dark skin tone (1f3c2-1f3fe)
        EmojiInfo(
            "\uD83C\uDFC2\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // snowboarder: dark skin tone (1f3c2-1f3ff)
        EmojiInfo(
            "\uD83C\uDFC2\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person golfing (1f3cc-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCC\uD83C\uDFFB", "\uD83C\uDFCC\uD83C\uDFFC", "\uD83C\uDFCC\uD83C\uDFFD", "\uD83C\uDFCC\uD83C\uDFFE", "\uD83C\uDFCC\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person golfing: light skin tone (1f3cc-1f3fb)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person golfing: medium-light skin tone (1f3cc-1f3fc)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person golfing: medium skin tone (1f3cc-1f3fd)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person golfing: medium-dark skin tone (1f3cc-1f3fe)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person golfing: dark skin tone (1f3cc-1f3ff)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man golfing (1f3cc-fe0f-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uFE0F\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man golfing: light skin tone (1f3cc-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man golfing: medium-light skin tone (1f3cc-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man golfing: medium skin tone (1f3cc-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man golfing: medium-dark skin tone (1f3cc-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man golfing: dark skin tone (1f3cc-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman golfing (1f3cc-fe0f-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uFE0F\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman golfing: light skin tone (1f3cc-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman golfing: medium-light skin tone (1f3cc-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman golfing: medium skin tone (1f3cc-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman golfing: medium-dark skin tone (1f3cc-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman golfing: dark skin tone (1f3cc-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person surfing (1f3c4)
        EmojiInfo(
            "\uD83C\uDFC4",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC4\uD83C\uDFFB", "\uD83C\uDFC4\uD83C\uDFFC", "\uD83C\uDFC4\uD83C\uDFFD", "\uD83C\uDFC4\uD83C\uDFFE", "\uD83C\uDFC4\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person surfing: light skin tone (1f3c4-1f3fb)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person surfing: medium-light skin tone (1f3c4-1f3fc)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person surfing: medium skin tone (1f3c4-1f3fd)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person surfing: medium-dark skin tone (1f3c4-1f3fe)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person surfing: dark skin tone (1f3c4-1f3ff)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man surfing (1f3c4-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man surfing: light skin tone (1f3c4-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man surfing: medium-light skin tone (1f3c4-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man surfing: medium skin tone (1f3c4-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man surfing: medium-dark skin tone (1f3c4-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man surfing: dark skin tone (1f3c4-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman surfing (1f3c4-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman surfing: light skin tone (1f3c4-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman surfing: medium-light skin tone (1f3c4-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman surfing: medium skin tone (1f3c4-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman surfing: medium-dark skin tone (1f3c4-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman surfing: dark skin tone (1f3c4-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person rowing boat (1f6a3)
        EmojiInfo(
            "\uD83D\uDEA3",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEA3\uD83C\uDFFB", "\uD83D\uDEA3\uD83C\uDFFC", "\uD83D\uDEA3\uD83C\uDFFD", "\uD83D\uDEA3\uD83C\uDFFE", "\uD83D\uDEA3\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person rowing boat: light skin tone (1f6a3-1f3fb)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person rowing boat: medium-light skin tone (1f6a3-1f3fc)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person rowing boat: medium skin tone (1f6a3-1f3fd)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person rowing boat: medium-dark skin tone (1f6a3-1f3fe)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person rowing boat: dark skin tone (1f6a3-1f3ff)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man rowing boat (1f6a3-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man rowing boat: light skin tone (1f6a3-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man rowing boat: medium-light skin tone (1f6a3-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man rowing boat: medium skin tone (1f6a3-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man rowing boat: medium-dark skin tone (1f6a3-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man rowing boat: dark skin tone (1f6a3-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman rowing boat (1f6a3-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman rowing boat: light skin tone (1f6a3-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman rowing boat: medium-light skin tone (1f6a3-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman rowing boat: medium skin tone (1f6a3-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman rowing boat: medium-dark skin tone (1f6a3-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman rowing boat: dark skin tone (1f6a3-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person swimming (1f3ca)
        EmojiInfo(
            "\uD83C\uDFCA",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCA\uD83C\uDFFB", "\uD83C\uDFCA\uD83C\uDFFC", "\uD83C\uDFCA\uD83C\uDFFD", "\uD83C\uDFCA\uD83C\uDFFE", "\uD83C\uDFCA\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person swimming: light skin tone (1f3ca-1f3fb)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person swimming: medium-light skin tone (1f3ca-1f3fc)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person swimming: medium skin tone (1f3ca-1f3fd)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person swimming: medium-dark skin tone (1f3ca-1f3fe)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person swimming: dark skin tone (1f3ca-1f3ff)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man swimming (1f3ca-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man swimming: light skin tone (1f3ca-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man swimming: medium-light skin tone (1f3ca-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man swimming: medium skin tone (1f3ca-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man swimming: medium-dark skin tone (1f3ca-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man swimming: dark skin tone (1f3ca-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman swimming (1f3ca-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman swimming: light skin tone (1f3ca-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman swimming: medium-light skin tone (1f3ca-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman swimming: medium skin tone (1f3ca-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman swimming: medium-dark skin tone (1f3ca-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman swimming: dark skin tone (1f3ca-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bouncing ball (26f9-fe0f)
        EmojiInfo(
            "\u26F9\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\u26F9\uD83C\uDFFB", "\u26F9\uD83C\uDFFC", "\u26F9\uD83C\uDFFD", "\u26F9\uD83C\uDFFE", "\u26F9\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person bouncing ball: light skin tone (26f9-1f3fb)
        EmojiInfo(
            "\u26F9\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bouncing ball: medium-light skin tone (26f9-1f3fc)
        EmojiInfo(
            "\u26F9\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bouncing ball: medium skin tone (26f9-1f3fd)
        EmojiInfo(
            "\u26F9\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bouncing ball: medium-dark skin tone (26f9-1f3fe)
        EmojiInfo(
            "\u26F9\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person bouncing ball: dark skin tone (26f9-1f3ff)
        EmojiInfo(
            "\u26F9\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bouncing ball (26f9-fe0f-200d-2642-fe0f)
        EmojiInfo(
            "\u26F9\uFE0F\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\u26F9\uD83C\uDFFB\u200D\u2642\uFE0F", "\u26F9\uD83C\uDFFC\u200D\u2642\uFE0F", "\u26F9\uD83C\uDFFD\u200D\u2642\uFE0F", "\u26F9\uD83C\uDFFE\u200D\u2642\uFE0F", "\u26F9\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man bouncing ball: light skin tone (26f9-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bouncing ball: medium-light skin tone (26f9-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bouncing ball: medium skin tone (26f9-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bouncing ball: medium-dark skin tone (26f9-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man bouncing ball: dark skin tone (26f9-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bouncing ball (26f9-fe0f-200d-2640-fe0f)
        EmojiInfo(
            "\u26F9\uFE0F\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\u26F9\uD83C\uDFFB\u200D\u2640\uFE0F", "\u26F9\uD83C\uDFFC\u200D\u2640\uFE0F", "\u26F9\uD83C\uDFFD\u200D\u2640\uFE0F", "\u26F9\uD83C\uDFFE\u200D\u2640\uFE0F", "\u26F9\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman bouncing ball: light skin tone (26f9-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bouncing ball: medium-light skin tone (26f9-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bouncing ball: medium skin tone (26f9-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bouncing ball: medium-dark skin tone (26f9-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman bouncing ball: dark skin tone (26f9-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\u26F9\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person lifting weights (1f3cb-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCB\uD83C\uDFFB", "\uD83C\uDFCB\uD83C\uDFFC", "\uD83C\uDFCB\uD83C\uDFFD", "\uD83C\uDFCB\uD83C\uDFFE", "\uD83C\uDFCB\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person lifting weights: light skin tone (1f3cb-1f3fb)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person lifting weights: medium-light skin tone (1f3cb-1f3fc)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person lifting weights: medium skin tone (1f3cb-1f3fd)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person lifting weights: medium-dark skin tone (1f3cb-1f3fe)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person lifting weights: dark skin tone (1f3cb-1f3ff)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man lifting weights (1f3cb-fe0f-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uFE0F\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man lifting weights: light skin tone (1f3cb-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man lifting weights: medium-light skin tone (1f3cb-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man lifting weights: medium skin tone (1f3cb-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man lifting weights: medium-dark skin tone (1f3cb-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man lifting weights: dark skin tone (1f3cb-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman lifting weights (1f3cb-fe0f-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uFE0F\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman lifting weights: light skin tone (1f3cb-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman lifting weights: medium-light skin tone (1f3cb-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman lifting weights: medium skin tone (1f3cb-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman lifting weights: medium-dark skin tone (1f3cb-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman lifting weights: dark skin tone (1f3cb-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person biking (1f6b4)
        EmojiInfo(
            "\uD83D\uDEB4",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB4\uD83C\uDFFB", "\uD83D\uDEB4\uD83C\uDFFC", "\uD83D\uDEB4\uD83C\uDFFD", "\uD83D\uDEB4\uD83C\uDFFE", "\uD83D\uDEB4\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person biking: light skin tone (1f6b4-1f3fb)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person biking: medium-light skin tone (1f6b4-1f3fc)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person biking: medium skin tone (1f6b4-1f3fd)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person biking: medium-dark skin tone (1f6b4-1f3fe)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person biking: dark skin tone (1f6b4-1f3ff)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man biking (1f6b4-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man biking: light skin tone (1f6b4-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man biking: medium-light skin tone (1f6b4-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man biking: medium skin tone (1f6b4-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man biking: medium-dark skin tone (1f6b4-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man biking: dark skin tone (1f6b4-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman biking (1f6b4-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman biking: light skin tone (1f6b4-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman biking: medium-light skin tone (1f6b4-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman biking: medium skin tone (1f6b4-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman biking: medium-dark skin tone (1f6b4-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman biking: dark skin tone (1f6b4-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person mountain biking (1f6b5)
        EmojiInfo(
            "\uD83D\uDEB5",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB5\uD83C\uDFFB", "\uD83D\uDEB5\uD83C\uDFFC", "\uD83D\uDEB5\uD83C\uDFFD", "\uD83D\uDEB5\uD83C\uDFFE", "\uD83D\uDEB5\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person mountain biking: light skin tone (1f6b5-1f3fb)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person mountain biking: medium-light skin tone (1f6b5-1f3fc)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person mountain biking: medium skin tone (1f6b5-1f3fd)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person mountain biking: medium-dark skin tone (1f6b5-1f3fe)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person mountain biking: dark skin tone (1f6b5-1f3ff)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mountain biking (1f6b5-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man mountain biking: light skin tone (1f6b5-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mountain biking: medium-light skin tone (1f6b5-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mountain biking: medium skin tone (1f6b5-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mountain biking: medium-dark skin tone (1f6b5-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man mountain biking: dark skin tone (1f6b5-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mountain biking (1f6b5-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman mountain biking: light skin tone (1f6b5-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mountain biking: medium-light skin tone (1f6b5-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mountain biking: medium skin tone (1f6b5-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mountain biking: medium-dark skin tone (1f6b5-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman mountain biking: dark skin tone (1f6b5-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person cartwheeling (1f938)
        EmojiInfo(
            "\uD83E\uDD38",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD38\uD83C\uDFFB", "\uD83E\uDD38\uD83C\uDFFC", "\uD83E\uDD38\uD83C\uDFFD", "\uD83E\uDD38\uD83C\uDFFE", "\uD83E\uDD38\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person cartwheeling: light skin tone (1f938-1f3fb)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person cartwheeling: medium-light skin tone (1f938-1f3fc)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person cartwheeling: medium skin tone (1f938-1f3fd)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person cartwheeling: medium-dark skin tone (1f938-1f3fe)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person cartwheeling: dark skin tone (1f938-1f3ff)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cartwheeling (1f938-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD38\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD38\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD38\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD38\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD38\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man cartwheeling: light skin tone (1f938-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cartwheeling: medium-light skin tone (1f938-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cartwheeling: medium skin tone (1f938-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cartwheeling: medium-dark skin tone (1f938-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man cartwheeling: dark skin tone (1f938-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cartwheeling (1f938-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD38\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD38\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD38\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD38\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD38\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman cartwheeling: light skin tone (1f938-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cartwheeling: medium-light skin tone (1f938-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cartwheeling: medium skin tone (1f938-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cartwheeling: medium-dark skin tone (1f938-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman cartwheeling: dark skin tone (1f938-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD38\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people wrestling (1f93c)
        EmojiInfo(
            "\uD83E\uDD3C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // men wrestling (1f93c-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3C\u200D\u2642\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // women wrestling (1f93c-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3C\u200D\u2640\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // person playing water polo (1f93d)
        EmojiInfo(
            "\uD83E\uDD3D",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD3D\uD83C\uDFFB", "\uD83E\uDD3D\uD83C\uDFFC", "\uD83E\uDD3D\uD83C\uDFFD", "\uD83E\uDD3D\uD83C\uDFFE", "\uD83E\uDD3D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person playing water polo: light skin tone (1f93d-1f3fb)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing water polo: medium-light skin tone (1f93d-1f3fc)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing water polo: medium skin tone (1f93d-1f3fd)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing water polo: medium-dark skin tone (1f93d-1f3fe)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing water polo: dark skin tone (1f93d-1f3ff)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing water polo (1f93d-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man playing water polo: light skin tone (1f93d-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing water polo: medium-light skin tone (1f93d-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing water polo: medium skin tone (1f93d-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing water polo: medium-dark skin tone (1f93d-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing water polo: dark skin tone (1f93d-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing water polo (1f93d-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman playing water polo: light skin tone (1f93d-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing water polo: medium-light skin tone (1f93d-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing water polo: medium skin tone (1f93d-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing water polo: medium-dark skin tone (1f93d-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing water polo: dark skin tone (1f93d-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing handball (1f93e)
        EmojiInfo(
            "\uD83E\uDD3E",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD3E\uD83C\uDFFB", "\uD83E\uDD3E\uD83C\uDFFC", "\uD83E\uDD3E\uD83C\uDFFD", "\uD83E\uDD3E\uD83C\uDFFE", "\uD83E\uDD3E\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person playing handball: light skin tone (1f93e-1f3fb)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing handball: medium-light skin tone (1f93e-1f3fc)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing handball: medium skin tone (1f93e-1f3fd)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing handball: medium-dark skin tone (1f93e-1f3fe)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person playing handball: dark skin tone (1f93e-1f3ff)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing handball (1f93e-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man playing handball: light skin tone (1f93e-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing handball: medium-light skin tone (1f93e-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing handball: medium skin tone (1f93e-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing handball: medium-dark skin tone (1f93e-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man playing handball: dark skin tone (1f93e-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing handball (1f93e-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman playing handball: light skin tone (1f93e-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing handball: medium-light skin tone (1f93e-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing handball: medium skin tone (1f93e-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing handball: medium-dark skin tone (1f93e-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman playing handball: dark skin tone (1f93e-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person juggling (1f939)
        EmojiInfo(
            "\uD83E\uDD39",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD39\uD83C\uDFFB", "\uD83E\uDD39\uD83C\uDFFC", "\uD83E\uDD39\uD83C\uDFFD", "\uD83E\uDD39\uD83C\uDFFE", "\uD83E\uDD39\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person juggling: light skin tone (1f939-1f3fb)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person juggling: medium-light skin tone (1f939-1f3fc)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person juggling: medium skin tone (1f939-1f3fd)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person juggling: medium-dark skin tone (1f939-1f3fe)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person juggling: dark skin tone (1f939-1f3ff)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man juggling (1f939-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD39\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDD39\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDD39\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDD39\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDD39\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man juggling: light skin tone (1f939-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man juggling: medium-light skin tone (1f939-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man juggling: medium skin tone (1f939-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man juggling: medium-dark skin tone (1f939-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man juggling: dark skin tone (1f939-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman juggling (1f939-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDD39\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDD39\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDD39\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDD39\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDD39\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman juggling: light skin tone (1f939-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman juggling: medium-light skin tone (1f939-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman juggling: medium skin tone (1f939-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman juggling: medium-dark skin tone (1f939-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman juggling: dark skin tone (1f939-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDD39\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in lotus position (1f9d8)
        EmojiInfo(
            "\uD83E\uDDD8",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD8\uD83C\uDFFB", "\uD83E\uDDD8\uD83C\uDFFC", "\uD83E\uDDD8\uD83C\uDFFD", "\uD83E\uDDD8\uD83C\uDFFE", "\uD83E\uDDD8\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person in lotus position: light skin tone (1f9d8-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in lotus position: medium-light skin tone (1f9d8-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in lotus position: medium skin tone (1f9d8-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in lotus position: medium-dark skin tone (1f9d8-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in lotus position: dark skin tone (1f9d8-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in lotus position (1f9d8-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\u200D\u2642\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642\uFE0F", "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642\uFE0F", "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642\uFE0F", "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642\uFE0F", "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642\uFE0F"),
            DISPLAY_YES,
        ),
        // man in lotus position: light skin tone (1f9d8-1f3fb-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in lotus position: medium-light skin tone (1f9d8-1f3fc-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in lotus position: medium skin tone (1f9d8-1f3fd-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in lotus position: medium-dark skin tone (1f9d8-1f3fe-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // man in lotus position: dark skin tone (1f9d8-1f3ff-200d-2642-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in lotus position (1f9d8-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\u200D\u2640\uFE0F",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640\uFE0F", "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640\uFE0F", "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640\uFE0F", "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640\uFE0F", "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640\uFE0F"),
            DISPLAY_YES,
        ),
        // woman in lotus position: light skin tone (1f9d8-1f3fb-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in lotus position: medium-light skin tone (1f9d8-1f3fc-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in lotus position: medium skin tone (1f9d8-1f3fd-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in lotus position: medium-dark skin tone (1f9d8-1f3fe-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman in lotus position: dark skin tone (1f9d8-1f3ff-200d-2640-fe0f)
        EmojiInfo(
            "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640\uFE0F",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person taking bath (1f6c0)
        EmojiInfo(
            "\uD83D\uDEC0",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDEC0\uD83C\uDFFB", "\uD83D\uDEC0\uD83C\uDFFC", "\uD83D\uDEC0\uD83C\uDFFD", "\uD83D\uDEC0\uD83C\uDFFE", "\uD83D\uDEC0\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person taking bath: light skin tone (1f6c0-1f3fb)
        EmojiInfo(
            "\uD83D\uDEC0\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person taking bath: medium-light skin tone (1f6c0-1f3fc)
        EmojiInfo(
            "\uD83D\uDEC0\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person taking bath: medium skin tone (1f6c0-1f3fd)
        EmojiInfo(
            "\uD83D\uDEC0\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person taking bath: medium-dark skin tone (1f6c0-1f3fe)
        EmojiInfo(
            "\uD83D\uDEC0\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person taking bath: dark skin tone (1f6c0-1f3ff)
        EmojiInfo(
            "\uD83D\uDEC0\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in bed (1f6cc)
        EmojiInfo(
            "\uD83D\uDECC",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDECC\uD83C\uDFFB", "\uD83D\uDECC\uD83C\uDFFC", "\uD83D\uDECC\uD83C\uDFFD", "\uD83D\uDECC\uD83C\uDFFE", "\uD83D\uDECC\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // person in bed: light skin tone (1f6cc-1f3fb)
        EmojiInfo(
            "\uD83D\uDECC\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in bed: medium-light skin tone (1f6cc-1f3fc)
        EmojiInfo(
            "\uD83D\uDECC\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in bed: medium skin tone (1f6cc-1f3fd)
        EmojiInfo(
            "\uD83D\uDECC\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in bed: medium-dark skin tone (1f6cc-1f3fe)
        EmojiInfo(
            "\uD83D\uDECC\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // person in bed: dark skin tone (1f6cc-1f3ff)
        EmojiInfo(
            "\uD83D\uDECC\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people holding hands (1f9d1-200d-1f91d-200d-1f9d1)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1",
            DIVERSITY_PARENT,
            arrayOf("\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // people holding hands: light skin tone (1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people holding hands: light skin tone, medium-light skin tone (1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: light skin tone, medium skin tone (1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: light skin tone, medium-dark skin tone (1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: light skin tone, dark skin tone (1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-light skin tone, light skin tone (1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-light skin tone (1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people holding hands: medium-light skin tone, medium skin tone (1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-light skin tone, medium-dark skin tone (1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-light skin tone, dark skin tone (1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium skin tone, light skin tone (1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium skin tone, medium-light skin tone (1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium skin tone (1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people holding hands: medium skin tone, medium-dark skin tone (1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium skin tone, dark skin tone (1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-dark skin tone, light skin tone (1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-dark skin tone, medium-light skin tone (1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-dark skin tone, medium skin tone (1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: medium-dark skin tone (1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // people holding hands: medium-dark skin tone, dark skin tone (1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: dark skin tone, light skin tone (1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: dark skin tone, medium-light skin tone (1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: dark skin tone, medium skin tone (1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: dark skin tone, medium-dark skin tone (1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // people holding hands: dark skin tone (1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // women holding hands (1f46d)
        EmojiInfo(
            "\uD83D\uDC6D",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC6D\uD83C\uDFFB", "\uD83D\uDC6D\uD83C\uDFFC", "\uD83D\uDC6D\uD83C\uDFFD", "\uD83D\uDC6D\uD83C\uDFFE", "\uD83D\uDC6D\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // women holding hands: light skin tone (1f46d-1f3fb)
        EmojiInfo(
            "\uD83D\uDC6D\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // women holding hands: light skin tone, medium-light skin tone (1f469-1f3fb-200d-1f91d-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: light skin tone, medium skin tone (1f469-1f3fb-200d-1f91d-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: light skin tone, medium-dark skin tone (1f469-1f3fb-200d-1f91d-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: light skin tone, dark skin tone (1f469-1f3fb-200d-1f91d-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-light skin tone, light skin tone (1f469-1f3fc-200d-1f91d-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-light skin tone (1f46d-1f3fc)
        EmojiInfo(
            "\uD83D\uDC6D\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // women holding hands: medium-light skin tone, medium skin tone (1f469-1f3fc-200d-1f91d-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-light skin tone, medium-dark skin tone (1f469-1f3fc-200d-1f91d-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-light skin tone, dark skin tone (1f469-1f3fc-200d-1f91d-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium skin tone, light skin tone (1f469-1f3fd-200d-1f91d-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium skin tone, medium-light skin tone (1f469-1f3fd-200d-1f91d-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium skin tone (1f46d-1f3fd)
        EmojiInfo(
            "\uD83D\uDC6D\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // women holding hands: medium skin tone, medium-dark skin tone (1f469-1f3fd-200d-1f91d-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium skin tone, dark skin tone (1f469-1f3fd-200d-1f91d-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-dark skin tone, light skin tone (1f469-1f3fe-200d-1f91d-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-dark skin tone, medium-light skin tone (1f469-1f3fe-200d-1f91d-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-dark skin tone, medium skin tone (1f469-1f3fe-200d-1f91d-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: medium-dark skin tone (1f46d-1f3fe)
        EmojiInfo(
            "\uD83D\uDC6D\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // women holding hands: medium-dark skin tone, dark skin tone (1f469-1f3fe-200d-1f91d-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: dark skin tone, light skin tone (1f469-1f3ff-200d-1f91d-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: dark skin tone, medium-light skin tone (1f469-1f3ff-200d-1f91d-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: dark skin tone, medium skin tone (1f469-1f3ff-200d-1f91d-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: dark skin tone, medium-dark skin tone (1f469-1f3ff-200d-1f91d-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // women holding hands: dark skin tone (1f46d-1f3ff)
        EmojiInfo(
            "\uD83D\uDC6D\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman and man holding hands (1f46b)
        EmojiInfo(
            "\uD83D\uDC6B",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC6B\uD83C\uDFFB", "\uD83D\uDC6B\uD83C\uDFFC", "\uD83D\uDC6B\uD83C\uDFFD", "\uD83D\uDC6B\uD83C\uDFFE", "\uD83D\uDC6B\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // woman and man holding hands: light skin tone (1f46b-1f3fb)
        EmojiInfo(
            "\uD83D\uDC6B\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman and man holding hands: light skin tone, medium-light skin tone (1f469-1f3fb-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: light skin tone, medium skin tone (1f469-1f3fb-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: light skin tone, medium-dark skin tone (1f469-1f3fb-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: light skin tone, dark skin tone (1f469-1f3fb-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-light skin tone, light skin tone (1f469-1f3fc-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-light skin tone (1f46b-1f3fc)
        EmojiInfo(
            "\uD83D\uDC6B\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman and man holding hands: medium-light skin tone, medium skin tone (1f469-1f3fc-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-light skin tone, medium-dark skin tone (1f469-1f3fc-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-light skin tone, dark skin tone (1f469-1f3fc-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium skin tone, light skin tone (1f469-1f3fd-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium skin tone, medium-light skin tone (1f469-1f3fd-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium skin tone (1f46b-1f3fd)
        EmojiInfo(
            "\uD83D\uDC6B\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman and man holding hands: medium skin tone, medium-dark skin tone (1f469-1f3fd-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium skin tone, dark skin tone (1f469-1f3fd-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-dark skin tone, light skin tone (1f469-1f3fe-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-dark skin tone, medium-light skin tone (1f469-1f3fe-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-dark skin tone, medium skin tone (1f469-1f3fe-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: medium-dark skin tone (1f46b-1f3fe)
        EmojiInfo(
            "\uD83D\uDC6B\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // woman and man holding hands: medium-dark skin tone, dark skin tone (1f469-1f3fe-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: dark skin tone, light skin tone (1f469-1f3ff-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: dark skin tone, medium-light skin tone (1f469-1f3ff-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: dark skin tone, medium skin tone (1f469-1f3ff-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: dark skin tone, medium-dark skin tone (1f469-1f3ff-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // woman and man holding hands: dark skin tone (1f46b-1f3ff)
        EmojiInfo(
            "\uD83D\uDC6B\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // men holding hands (1f46c)
        EmojiInfo(
            "\uD83D\uDC6C",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC6C\uD83C\uDFFB", "\uD83D\uDC6C\uD83C\uDFFC", "\uD83D\uDC6C\uD83C\uDFFD", "\uD83D\uDC6C\uD83C\uDFFE", "\uD83D\uDC6C\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // men holding hands: light skin tone (1f46c-1f3fb)
        EmojiInfo(
            "\uD83D\uDC6C\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // men holding hands: light skin tone, medium-light skin tone (1f468-1f3fb-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: light skin tone, medium skin tone (1f468-1f3fb-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: light skin tone, medium-dark skin tone (1f468-1f3fb-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: light skin tone, dark skin tone (1f468-1f3fb-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-light skin tone, light skin tone (1f468-1f3fc-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-light skin tone (1f46c-1f3fc)
        EmojiInfo(
            "\uD83D\uDC6C\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // men holding hands: medium-light skin tone, medium skin tone (1f468-1f3fc-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-light skin tone, medium-dark skin tone (1f468-1f3fc-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-light skin tone, dark skin tone (1f468-1f3fc-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium skin tone, light skin tone (1f468-1f3fd-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium skin tone, medium-light skin tone (1f468-1f3fd-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium skin tone (1f46c-1f3fd)
        EmojiInfo(
            "\uD83D\uDC6C\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // men holding hands: medium skin tone, medium-dark skin tone (1f468-1f3fd-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium skin tone, dark skin tone (1f468-1f3fd-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-dark skin tone, light skin tone (1f468-1f3fe-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-dark skin tone, medium-light skin tone (1f468-1f3fe-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-dark skin tone, medium skin tone (1f468-1f3fe-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: medium-dark skin tone (1f46c-1f3fe)
        EmojiInfo(
            "\uD83D\uDC6C\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // men holding hands: medium-dark skin tone, dark skin tone (1f468-1f3fe-200d-1f91d-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: dark skin tone, light skin tone (1f468-1f3ff-200d-1f91d-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: dark skin tone, medium-light skin tone (1f468-1f3ff-200d-1f91d-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: dark skin tone, medium skin tone (1f468-1f3ff-200d-1f91d-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: dark skin tone, medium-dark skin tone (1f468-1f3ff-200d-1f91d-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // men holding hands: dark skin tone (1f46c-1f3ff)
        EmojiInfo(
            "\uD83D\uDC6C\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss (1f48f)
        EmojiInfo(
            "\uD83D\uDC8F",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC8F\uD83C\uDFFB", "\uD83D\uDC8F\uD83C\uDFFC", "\uD83D\uDC8F\uD83C\uDFFD", "\uD83D\uDC8F\uD83C\uDFFE", "\uD83D\uDC8F\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // kiss: light skin tone (1f48f-1f3fb)
        EmojiInfo(
            "\uD83D\uDC8F\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: medium-light skin tone (1f48f-1f3fc)
        EmojiInfo(
            "\uD83D\uDC8F\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: medium skin tone (1f48f-1f3fd)
        EmojiInfo(
            "\uD83D\uDC8F\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: medium-dark skin tone (1f48f-1f3fe)
        EmojiInfo(
            "\uD83D\uDC8F\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: dark skin tone (1f48f-1f3ff)
        EmojiInfo(
            "\uD83D\uDC8F\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: person, person, light skin tone, medium-light skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, light skin tone, medium skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, light skin tone, medium-dark skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, light skin tone, dark skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-light skin tone, light skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-light skin tone, medium skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-light skin tone, medium-dark skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-light skin tone, dark skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium skin tone, light skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium skin tone, medium-light skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium skin tone, medium-dark skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium skin tone, dark skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-dark skin tone, light skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-dark skin tone, medium-light skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-dark skin tone, medium skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, medium-dark skin tone, dark skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, dark skin tone, light skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, dark skin tone, medium-light skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, dark skin tone, medium skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: person, person, dark skin tone, medium-dark skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man (1f469-200d-2764-fe0f-200d-1f48b-200d-1f468)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // kiss: woman, man, light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, man, light skin tone, medium-light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, light skin tone, medium skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, light skin tone, medium-dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, light skin tone, dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-light skin tone, light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, man, medium-light skin tone, medium skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-light skin tone, medium-dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-light skin tone, dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium skin tone, light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium skin tone, medium-light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, man, medium skin tone, medium-dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium skin tone, dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-dark skin tone, light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-dark skin tone, medium-light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-dark skin tone, medium skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, medium-dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, man, medium-dark skin tone, dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, dark skin tone, light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, dark skin tone, medium-light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, dark skin tone, medium skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, dark skin tone, medium-dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, man, dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: man, man (1f468-200d-2764-fe0f-200d-1f48b-200d-1f468)
        EmojiInfo(
            "\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB", "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC", "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD", "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE", "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // kiss: man, man, light skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: man, man, light skin tone, medium-light skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, light skin tone, medium skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, light skin tone, medium-dark skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, light skin tone, dark skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-light skin tone, light skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-light skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: man, man, medium-light skin tone, medium skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-light skin tone, medium-dark skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-light skin tone, dark skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium skin tone, light skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium skin tone, medium-light skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: man, man, medium skin tone, medium-dark skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium skin tone, dark skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-dark skin tone, light skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-dark skin tone, medium-light skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-dark skin tone, medium skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, medium-dark skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: man, man, medium-dark skin tone, dark skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, dark skin tone, light skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, dark skin tone, medium-light skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, dark skin tone, medium skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, dark skin tone, medium-dark skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: man, man, dark skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, woman (1f469-200d-2764-fe0f-200d-1f48b-200d-1f469)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFB", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFC", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFD", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFE", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // kiss: woman, woman, light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, woman, light skin tone, medium-light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, light skin tone, medium skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, light skin tone, medium-dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, light skin tone, dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-light skin tone, light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, woman, medium-light skin tone, medium skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-light skin tone, medium-dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-light skin tone, dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium skin tone, light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium skin tone, medium-light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, woman, medium skin tone, medium-dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium skin tone, dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-dark skin tone, light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-dark skin tone, medium-light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-dark skin tone, medium skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, medium-dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // kiss: woman, woman, medium-dark skin tone, dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, dark skin tone, light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, dark skin tone, medium-light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, dark skin tone, medium skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, dark skin tone, medium-dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // kiss: woman, woman, dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart (1f491)
        EmojiInfo(
            "\uD83D\uDC91",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC91\uD83C\uDFFB", "\uD83D\uDC91\uD83C\uDFFC", "\uD83D\uDC91\uD83C\uDFFD", "\uD83D\uDC91\uD83C\uDFFE", "\uD83D\uDC91\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // couple with heart: light skin tone (1f491-1f3fb)
        EmojiInfo(
            "\uD83D\uDC91\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: medium-light skin tone (1f491-1f3fc)
        EmojiInfo(
            "\uD83D\uDC91\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: medium skin tone (1f491-1f3fd)
        EmojiInfo(
            "\uD83D\uDC91\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: medium-dark skin tone (1f491-1f3fe)
        EmojiInfo(
            "\uD83D\uDC91\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: dark skin tone (1f491-1f3ff)
        EmojiInfo(
            "\uD83D\uDC91\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: person, person, light skin tone, medium-light skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, light skin tone, medium skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, light skin tone, medium-dark skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, light skin tone, dark skin tone (1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-light skin tone, light skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-light skin tone, medium skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-light skin tone, medium-dark skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-light skin tone, dark skin tone (1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium skin tone, light skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium skin tone, medium-light skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium skin tone, medium-dark skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium skin tone, dark skin tone (1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-dark skin tone, light skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-dark skin tone, medium-light skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-dark skin tone, medium skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, medium-dark skin tone, dark skin tone (1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3ff)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, dark skin tone, light skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fb)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, dark skin tone, medium-light skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fc)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, dark skin tone, medium skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fd)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: person, person, dark skin tone, medium-dark skin tone (1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fe)
        EmojiInfo(
            "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83E\uDDD1\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man (1f469-200d-2764-fe0f-200d-1f468)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC68",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // couple with heart: woman, man, light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, man, light skin tone, medium-light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, light skin tone, medium skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, light skin tone, medium-dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, light skin tone, dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-light skin tone, light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, man, medium-light skin tone, medium skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-light skin tone, medium-dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-light skin tone, dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium skin tone, light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium skin tone, medium-light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, man, medium skin tone, medium-dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium skin tone, dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-dark skin tone, light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-dark skin tone, medium-light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-dark skin tone, medium skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, medium-dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, man, medium-dark skin tone, dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, dark skin tone, light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, dark skin tone, medium-light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, dark skin tone, medium skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, dark skin tone, medium-dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, man, dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: man, man (1f468-200d-2764-fe0f-200d-1f468)
        EmojiInfo(
            "\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC68",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB", "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC", "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD", "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE", "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // couple with heart: man, man, light skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: man, man, light skin tone, medium-light skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, light skin tone, medium skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, light skin tone, medium-dark skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, light skin tone, dark skin tone (1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-light skin tone, light skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-light skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: man, man, medium-light skin tone, medium skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-light skin tone, medium-dark skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-light skin tone, dark skin tone (1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium skin tone, light skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium skin tone, medium-light skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: man, man, medium skin tone, medium-dark skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium skin tone, dark skin tone (1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-dark skin tone, light skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-dark skin tone, medium-light skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-dark skin tone, medium skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, medium-dark skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: man, man, medium-dark skin tone, dark skin tone (1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, dark skin tone, light skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fb)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, dark skin tone, medium-light skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fc)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, dark skin tone, medium skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fd)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, dark skin tone, medium-dark skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fe)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: man, man, dark skin tone (1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3ff)
        EmojiInfo(
            "\uD83D\uDC68\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC68\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, woman (1f469-200d-2764-fe0f-200d-1f469)
        EmojiInfo(
            "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC69",
            DIVERSITY_PARENT,
            arrayOf("\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFB", "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFC", "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFD", "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFE", "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFF"),
            DISPLAY_YES,
        ),
        // couple with heart: woman, woman, light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, woman, light skin tone, medium-light skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, light skin tone, medium skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, light skin tone, medium-dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, light skin tone, dark skin tone (1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFB\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-light skin tone, light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-light skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, woman, medium-light skin tone, medium skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-light skin tone, dark skin tone (1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFC\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium skin tone, light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium skin tone, medium-light skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, woman, medium skin tone, medium-dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium skin tone, dark skin tone (1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFD\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-dark skin tone, light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-dark skin tone, medium skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, medium-dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // couple with heart: woman, woman, medium-dark skin tone, dark skin tone (1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFE\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, dark skin tone, light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fb)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFB",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, dark skin tone, medium-light skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fc)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFC",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, dark skin tone, medium skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fd)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFD",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, dark skin tone, medium-dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fe)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFE",
            DIVERSITY_CHILD,
            null,
            DISPLAY_NO,
        ),
        // couple with heart: woman, woman, dark skin tone (1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3ff)
        EmojiInfo(
            "\uD83D\uDC69\uD83C\uDFFF\u200D\u2764\uFE0F\u200D\uD83D\uDC69\uD83C\uDFFF",
            DIVERSITY_CHILD,
            null,
            DISPLAY_YES,
        ),
        // family: man, woman, boy (1f468-200d-1f469-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, woman, girl (1f468-200d-1f469-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, woman, girl, boy (1f468-200d-1f469-200d-1f467-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, woman, boy, boy (1f468-200d-1f469-200d-1f466-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, woman, girl, girl (1f468-200d-1f469-200d-1f467-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, man, boy (1f468-200d-1f468-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, man, girl (1f468-200d-1f468-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, man, girl, boy (1f468-200d-1f468-200d-1f467-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, man, boy, boy (1f468-200d-1f468-200d-1f466-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, man, girl, girl (1f468-200d-1f468-200d-1f467-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, woman, boy (1f469-200d-1f469-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, woman, girl (1f469-200d-1f469-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, woman, girl, boy (1f469-200d-1f469-200d-1f467-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, woman, boy, boy (1f469-200d-1f469-200d-1f466-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, woman, girl, girl (1f469-200d-1f469-200d-1f467-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, boy (1f468-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, boy, boy (1f468-200d-1f466-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, girl (1f468-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, girl, boy (1f468-200d-1f467-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: man, girl, girl (1f468-200d-1f467-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, boy (1f469-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, boy, boy (1f469-200d-1f466-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, girl (1f469-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, girl, boy (1f469-200d-1f467-200d-1f466)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: woman, girl, girl (1f469-200d-1f467-200d-1f467)
        EmojiInfo(
            "\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speaking head (1f5e3-fe0f)
        EmojiInfo(
            "\uD83D\uDDE3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bust in silhouette (1f464)
        EmojiInfo(
            "\uD83D\uDC64",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // busts in silhouette (1f465)
        EmojiInfo(
            "\uD83D\uDC65",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // people hugging (1fac2)
        EmojiInfo(
            "\uD83E\uDEC2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family (1f46a)
        EmojiInfo(
            "\uD83D\uDC6A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: adult, adult, child (1f9d1-200d-1f9d1-200d-1f9d2)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDD1\u200D\uD83E\uDDD2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: adult, adult, child, child (1f9d1-200d-1f9d1-200d-1f9d2-200d-1f9d2)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDD1\u200D\uD83E\uDDD2\u200D\uD83E\uDDD2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: adult, child (1f9d1-200d-1f9d2)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDD2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // family: adult, child, child (1f9d1-200d-1f9d2-200d-1f9d2)
        EmojiInfo(
            "\uD83E\uDDD1\u200D\uD83E\uDDD2\u200D\uD83E\uDDD2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // footprints (1f463)
        EmojiInfo(
            "\uD83D\uDC63",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fingerprint (1fac6)
        EmojiInfo(
            "\uD83E\uDEC6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getnature() = listOf(
        // monkey face (1f435)
        EmojiInfo(
            "\uD83D\uDC35",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // monkey (1f412)
        EmojiInfo(
            "\uD83D\uDC12",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // gorilla (1f98d)
        EmojiInfo(
            "\uD83E\uDD8D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // orangutan (1f9a7)
        EmojiInfo(
            "\uD83E\uDDA7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dog face (1f436)
        EmojiInfo(
            "\uD83D\uDC36",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dog (1f415)
        EmojiInfo(
            "\uD83D\uDC15",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // guide dog (1f9ae)
        EmojiInfo(
            "\uD83E\uDDAE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // service dog (1f415-200d-1f9ba)
        EmojiInfo(
            "\uD83D\uDC15\u200D\uD83E\uDDBA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // poodle (1f429)
        EmojiInfo(
            "\uD83D\uDC29",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wolf (1f43a)
        EmojiInfo(
            "\uD83D\uDC3A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fox (1f98a)
        EmojiInfo(
            "\uD83E\uDD8A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // raccoon (1f99d)
        EmojiInfo(
            "\uD83E\uDD9D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cat face (1f431)
        EmojiInfo(
            "\uD83D\uDC31",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cat (1f408)
        EmojiInfo(
            "\uD83D\uDC08",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black cat (1f408-200d-2b1b)
        EmojiInfo(
            "\uD83D\uDC08\u200D\u2B1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lion (1f981)
        EmojiInfo(
            "\uD83E\uDD81",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tiger face (1f42f)
        EmojiInfo(
            "\uD83D\uDC2F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tiger (1f405)
        EmojiInfo(
            "\uD83D\uDC05",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // leopard (1f406)
        EmojiInfo(
            "\uD83D\uDC06",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // horse face (1f434)
        EmojiInfo(
            "\uD83D\uDC34",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // moose (1face)
        EmojiInfo(
            "\uD83E\uDECE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // donkey (1facf)
        EmojiInfo(
            "\uD83E\uDECF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // horse (1f40e)
        EmojiInfo(
            "\uD83D\uDC0E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // unicorn (1f984)
        EmojiInfo(
            "\uD83E\uDD84",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // zebra (1f993)
        EmojiInfo(
            "\uD83E\uDD93",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // deer (1f98c)
        EmojiInfo(
            "\uD83E\uDD8C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bison (1f9ac)
        EmojiInfo(
            "\uD83E\uDDAC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cow face (1f42e)
        EmojiInfo(
            "\uD83D\uDC2E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ox (1f402)
        EmojiInfo(
            "\uD83D\uDC02",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // water buffalo (1f403)
        EmojiInfo(
            "\uD83D\uDC03",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cow (1f404)
        EmojiInfo(
            "\uD83D\uDC04",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pig face (1f437)
        EmojiInfo(
            "\uD83D\uDC37",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pig (1f416)
        EmojiInfo(
            "\uD83D\uDC16",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // boar (1f417)
        EmojiInfo(
            "\uD83D\uDC17",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pig nose (1f43d)
        EmojiInfo(
            "\uD83D\uDC3D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ram (1f40f)
        EmojiInfo(
            "\uD83D\uDC0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ewe (1f411)
        EmojiInfo(
            "\uD83D\uDC11",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // goat (1f410)
        EmojiInfo(
            "\uD83D\uDC10",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // camel (1f42a)
        EmojiInfo(
            "\uD83D\uDC2A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // two-hump camel (1f42b)
        EmojiInfo(
            "\uD83D\uDC2B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // llama (1f999)
        EmojiInfo(
            "\uD83E\uDD99",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // giraffe (1f992)
        EmojiInfo(
            "\uD83E\uDD92",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // elephant (1f418)
        EmojiInfo(
            "\uD83D\uDC18",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mammoth (1f9a3)
        EmojiInfo(
            "\uD83E\uDDA3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rhinoceros (1f98f)
        EmojiInfo(
            "\uD83E\uDD8F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hippopotamus (1f99b)
        EmojiInfo(
            "\uD83E\uDD9B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mouse face (1f42d)
        EmojiInfo(
            "\uD83D\uDC2D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mouse (1f401)
        EmojiInfo(
            "\uD83D\uDC01",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rat (1f400)
        EmojiInfo(
            "\uD83D\uDC00",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hamster (1f439)
        EmojiInfo(
            "\uD83D\uDC39",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rabbit face (1f430)
        EmojiInfo(
            "\uD83D\uDC30",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rabbit (1f407)
        EmojiInfo(
            "\uD83D\uDC07",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chipmunk (1f43f-fe0f)
        EmojiInfo(
            "\uD83D\uDC3F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beaver (1f9ab)
        EmojiInfo(
            "\uD83E\uDDAB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hedgehog (1f994)
        EmojiInfo(
            "\uD83E\uDD94",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bat (1f987)
        EmojiInfo(
            "\uD83E\uDD87",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bear (1f43b)
        EmojiInfo(
            "\uD83D\uDC3B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // polar bear (1f43b-200d-2744-fe0f)
        EmojiInfo(
            "\uD83D\uDC3B\u200D\u2744\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // koala (1f428)
        EmojiInfo(
            "\uD83D\uDC28",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // panda (1f43c)
        EmojiInfo(
            "\uD83D\uDC3C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sloth (1f9a5)
        EmojiInfo(
            "\uD83E\uDDA5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // otter (1f9a6)
        EmojiInfo(
            "\uD83E\uDDA6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // skunk (1f9a8)
        EmojiInfo(
            "\uD83E\uDDA8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kangaroo (1f998)
        EmojiInfo(
            "\uD83E\uDD98",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // badger (1f9a1)
        EmojiInfo(
            "\uD83E\uDDA1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // paw prints (1f43e)
        EmojiInfo(
            "\uD83D\uDC3E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // turkey (1f983)
        EmojiInfo(
            "\uD83E\uDD83",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chicken (1f414)
        EmojiInfo(
            "\uD83D\uDC14",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rooster (1f413)
        EmojiInfo(
            "\uD83D\uDC13",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hatching chick (1f423)
        EmojiInfo(
            "\uD83D\uDC23",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baby chick (1f424)
        EmojiInfo(
            "\uD83D\uDC24",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // front-facing baby chick (1f425)
        EmojiInfo(
            "\uD83D\uDC25",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bird (1f426)
        EmojiInfo(
            "\uD83D\uDC26",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // penguin (1f427)
        EmojiInfo(
            "\uD83D\uDC27",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dove (1f54a-fe0f)
        EmojiInfo(
            "\uD83D\uDD4A\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eagle (1f985)
        EmojiInfo(
            "\uD83E\uDD85",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // duck (1f986)
        EmojiInfo(
            "\uD83E\uDD86",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // swan (1f9a2)
        EmojiInfo(
            "\uD83E\uDDA2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // owl (1f989)
        EmojiInfo(
            "\uD83E\uDD89",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dodo (1f9a4)
        EmojiInfo(
            "\uD83E\uDDA4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // feather (1fab6)
        EmojiInfo(
            "\uD83E\uDEB6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flamingo (1f9a9)
        EmojiInfo(
            "\uD83E\uDDA9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // peacock (1f99a)
        EmojiInfo(
            "\uD83E\uDD9A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // parrot (1f99c)
        EmojiInfo(
            "\uD83E\uDD9C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wing (1fabd)
        EmojiInfo(
            "\uD83E\uDEBD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black bird (1f426-200d-2b1b)
        EmojiInfo(
            "\uD83D\uDC26\u200D\u2B1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // goose (1fabf)
        EmojiInfo(
            "\uD83E\uDEBF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // phoenix (1f426-200d-1f525)
        EmojiInfo(
            "\uD83D\uDC26\u200D\uD83D\uDD25",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // frog (1f438)
        EmojiInfo(
            "\uD83D\uDC38",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crocodile (1f40a)
        EmojiInfo(
            "\uD83D\uDC0A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // turtle (1f422)
        EmojiInfo(
            "\uD83D\uDC22",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lizard (1f98e)
        EmojiInfo(
            "\uD83E\uDD8E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snake (1f40d)
        EmojiInfo(
            "\uD83D\uDC0D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dragon face (1f432)
        EmojiInfo(
            "\uD83D\uDC32",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dragon (1f409)
        EmojiInfo(
            "\uD83D\uDC09",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sauropod (1f995)
        EmojiInfo(
            "\uD83E\uDD95",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // T-Rex (1f996)
        EmojiInfo(
            "\uD83E\uDD96",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spouting whale (1f433)
        EmojiInfo(
            "\uD83D\uDC33",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // whale (1f40b)
        EmojiInfo(
            "\uD83D\uDC0B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dolphin (1f42c)
        EmojiInfo(
            "\uD83D\uDC2C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // seal (1f9ad)
        EmojiInfo(
            "\uD83E\uDDAD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fish (1f41f)
        EmojiInfo(
            "\uD83D\uDC1F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tropical fish (1f420)
        EmojiInfo(
            "\uD83D\uDC20",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blowfish (1f421)
        EmojiInfo(
            "\uD83D\uDC21",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shark (1f988)
        EmojiInfo(
            "\uD83E\uDD88",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // octopus (1f419)
        EmojiInfo(
            "\uD83D\uDC19",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spiral shell (1f41a)
        EmojiInfo(
            "\uD83D\uDC1A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // coral (1fab8)
        EmojiInfo(
            "\uD83E\uDEB8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // jellyfish (1fabc)
        EmojiInfo(
            "\uD83E\uDEBC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crab (1f980)
        EmojiInfo(
            "\uD83E\uDD80",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lobster (1f99e)
        EmojiInfo(
            "\uD83E\uDD9E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shrimp (1f990)
        EmojiInfo(
            "\uD83E\uDD90",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // squid (1f991)
        EmojiInfo(
            "\uD83E\uDD91",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oyster (1f9aa)
        EmojiInfo(
            "\uD83E\uDDAA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snail (1f40c)
        EmojiInfo(
            "\uD83D\uDC0C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // butterfly (1f98b)
        EmojiInfo(
            "\uD83E\uDD8B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bug (1f41b)
        EmojiInfo(
            "\uD83D\uDC1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ant (1f41c)
        EmojiInfo(
            "\uD83D\uDC1C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // honeybee (1f41d)
        EmojiInfo(
            "\uD83D\uDC1D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beetle (1fab2)
        EmojiInfo(
            "\uD83E\uDEB2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lady beetle (1f41e)
        EmojiInfo(
            "\uD83D\uDC1E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cricket (1f997)
        EmojiInfo(
            "\uD83E\uDD97",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cockroach (1fab3)
        EmojiInfo(
            "\uD83E\uDEB3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spider (1f577-fe0f)
        EmojiInfo(
            "\uD83D\uDD77\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spider web (1f578-fe0f)
        EmojiInfo(
            "\uD83D\uDD78\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // scorpion (1f982)
        EmojiInfo(
            "\uD83E\uDD82",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mosquito (1f99f)
        EmojiInfo(
            "\uD83E\uDD9F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fly (1fab0)
        EmojiInfo(
            "\uD83E\uDEB0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // worm (1fab1)
        EmojiInfo(
            "\uD83E\uDEB1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // microbe (1f9a0)
        EmojiInfo(
            "\uD83E\uDDA0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bouquet (1f490)
        EmojiInfo(
            "\uD83D\uDC90",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cherry blossom (1f338)
        EmojiInfo(
            "\uD83C\uDF38",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white flower (1f4ae)
        EmojiInfo(
            "\uD83D\uDCAE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lotus (1fab7)
        EmojiInfo(
            "\uD83E\uDEB7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rosette (1f3f5-fe0f)
        EmojiInfo(
            "\uD83C\uDFF5\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rose (1f339)
        EmojiInfo(
            "\uD83C\uDF39",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wilted flower (1f940)
        EmojiInfo(
            "\uD83E\uDD40",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hibiscus (1f33a)
        EmojiInfo(
            "\uD83C\uDF3A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sunflower (1f33b)
        EmojiInfo(
            "\uD83C\uDF3B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blossom (1f33c)
        EmojiInfo(
            "\uD83C\uDF3C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tulip (1f337)
        EmojiInfo(
            "\uD83C\uDF37",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hyacinth (1fabb)
        EmojiInfo(
            "\uD83E\uDEBB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // seedling (1f331)
        EmojiInfo(
            "\uD83C\uDF31",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // potted plant (1fab4)
        EmojiInfo(
            "\uD83E\uDEB4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // evergreen tree (1f332)
        EmojiInfo(
            "\uD83C\uDF32",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // deciduous tree (1f333)
        EmojiInfo(
            "\uD83C\uDF33",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // palm tree (1f334)
        EmojiInfo(
            "\uD83C\uDF34",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cactus (1f335)
        EmojiInfo(
            "\uD83C\uDF35",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sheaf of rice (1f33e)
        EmojiInfo(
            "\uD83C\uDF3E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // herb (1f33f)
        EmojiInfo(
            "\uD83C\uDF3F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shamrock (2618-fe0f)
        EmojiInfo(
            "\u2618\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // four leaf clover (1f340)
        EmojiInfo(
            "\uD83C\uDF40",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // maple leaf (1f341)
        EmojiInfo(
            "\uD83C\uDF41",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fallen leaf (1f342)
        EmojiInfo(
            "\uD83C\uDF42",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // leaf fluttering in wind (1f343)
        EmojiInfo(
            "\uD83C\uDF43",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // empty nest (1fab9)
        EmojiInfo(
            "\uD83E\uDEB9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nest with eggs (1faba)
        EmojiInfo(
            "\uD83E\uDEBA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mushroom (1f344)
        EmojiInfo(
            "\uD83C\uDF44",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // leafless tree (1fabe)
        EmojiInfo(
            "\uD83E\uDEBE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getfood() = listOf(
        // grapes (1f347)
        EmojiInfo(
            "\uD83C\uDF47",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // melon (1f348)
        EmojiInfo(
            "\uD83C\uDF48",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // watermelon (1f349)
        EmojiInfo(
            "\uD83C\uDF49",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tangerine (1f34a)
        EmojiInfo(
            "\uD83C\uDF4A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lemon (1f34b)
        EmojiInfo(
            "\uD83C\uDF4B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lime (1f34b-200d-1f7e9)
        EmojiInfo(
            "\uD83C\uDF4B\u200D\uD83D\uDFE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // banana (1f34c)
        EmojiInfo(
            "\uD83C\uDF4C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pineapple (1f34d)
        EmojiInfo(
            "\uD83C\uDF4D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mango (1f96d)
        EmojiInfo(
            "\uD83E\uDD6D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red apple (1f34e)
        EmojiInfo(
            "\uD83C\uDF4E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // green apple (1f34f)
        EmojiInfo(
            "\uD83C\uDF4F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pear (1f350)
        EmojiInfo(
            "\uD83C\uDF50",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // peach (1f351)
        EmojiInfo(
            "\uD83C\uDF51",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cherries (1f352)
        EmojiInfo(
            "\uD83C\uDF52",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // strawberry (1f353)
        EmojiInfo(
            "\uD83C\uDF53",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blueberries (1fad0)
        EmojiInfo(
            "\uD83E\uDED0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kiwi fruit (1f95d)
        EmojiInfo(
            "\uD83E\uDD5D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tomato (1f345)
        EmojiInfo(
            "\uD83C\uDF45",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // olive (1fad2)
        EmojiInfo(
            "\uD83E\uDED2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // coconut (1f965)
        EmojiInfo(
            "\uD83E\uDD65",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // avocado (1f951)
        EmojiInfo(
            "\uD83E\uDD51",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eggplant (1f346)
        EmojiInfo(
            "\uD83C\uDF46",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // potato (1f954)
        EmojiInfo(
            "\uD83E\uDD54",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // carrot (1f955)
        EmojiInfo(
            "\uD83E\uDD55",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ear of corn (1f33d)
        EmojiInfo(
            "\uD83C\uDF3D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hot pepper (1f336-fe0f)
        EmojiInfo(
            "\uD83C\uDF36\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bell pepper (1fad1)
        EmojiInfo(
            "\uD83E\uDED1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cucumber (1f952)
        EmojiInfo(
            "\uD83E\uDD52",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // leafy green (1f96c)
        EmojiInfo(
            "\uD83E\uDD6C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // broccoli (1f966)
        EmojiInfo(
            "\uD83E\uDD66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // garlic (1f9c4)
        EmojiInfo(
            "\uD83E\uDDC4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // onion (1f9c5)
        EmojiInfo(
            "\uD83E\uDDC5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // peanuts (1f95c)
        EmojiInfo(
            "\uD83E\uDD5C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beans (1fad8)
        EmojiInfo(
            "\uD83E\uDED8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chestnut (1f330)
        EmojiInfo(
            "\uD83C\uDF30",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ginger root (1fada)
        EmojiInfo(
            "\uD83E\uDEDA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pea pod (1fadb)
        EmojiInfo(
            "\uD83E\uDEDB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // brown mushroom (1f344-200d-1f7eb)
        EmojiInfo(
            "\uD83C\uDF44\u200D\uD83D\uDFEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // root vegetable (1fadc)
        EmojiInfo(
            "\uD83E\uDEDC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bread (1f35e)
        EmojiInfo(
            "\uD83C\uDF5E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // croissant (1f950)
        EmojiInfo(
            "\uD83E\uDD50",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baguette bread (1f956)
        EmojiInfo(
            "\uD83E\uDD56",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flatbread (1fad3)
        EmojiInfo(
            "\uD83E\uDED3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pretzel (1f968)
        EmojiInfo(
            "\uD83E\uDD68",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bagel (1f96f)
        EmojiInfo(
            "\uD83E\uDD6F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pancakes (1f95e)
        EmojiInfo(
            "\uD83E\uDD5E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // waffle (1f9c7)
        EmojiInfo(
            "\uD83E\uDDC7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cheese wedge (1f9c0)
        EmojiInfo(
            "\uD83E\uDDC0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // meat on bone (1f356)
        EmojiInfo(
            "\uD83C\uDF56",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // poultry leg (1f357)
        EmojiInfo(
            "\uD83C\uDF57",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cut of meat (1f969)
        EmojiInfo(
            "\uD83E\uDD69",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bacon (1f953)
        EmojiInfo(
            "\uD83E\uDD53",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hamburger (1f354)
        EmojiInfo(
            "\uD83C\uDF54",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // french fries (1f35f)
        EmojiInfo(
            "\uD83C\uDF5F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pizza (1f355)
        EmojiInfo(
            "\uD83C\uDF55",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hot dog (1f32d)
        EmojiInfo(
            "\uD83C\uDF2D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sandwich (1f96a)
        EmojiInfo(
            "\uD83E\uDD6A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // taco (1f32e)
        EmojiInfo(
            "\uD83C\uDF2E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // burrito (1f32f)
        EmojiInfo(
            "\uD83C\uDF2F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tamale (1fad4)
        EmojiInfo(
            "\uD83E\uDED4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // stuffed flatbread (1f959)
        EmojiInfo(
            "\uD83E\uDD59",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // falafel (1f9c6)
        EmojiInfo(
            "\uD83E\uDDC6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // egg (1f95a)
        EmojiInfo(
            "\uD83E\uDD5A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cooking (1f373)
        EmojiInfo(
            "\uD83C\uDF73",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shallow pan of food (1f958)
        EmojiInfo(
            "\uD83E\uDD58",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pot of food (1f372)
        EmojiInfo(
            "\uD83C\uDF72",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fondue (1fad5)
        EmojiInfo(
            "\uD83E\uDED5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bowl with spoon (1f963)
        EmojiInfo(
            "\uD83E\uDD63",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // green salad (1f957)
        EmojiInfo(
            "\uD83E\uDD57",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // popcorn (1f37f)
        EmojiInfo(
            "\uD83C\uDF7F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // butter (1f9c8)
        EmojiInfo(
            "\uD83E\uDDC8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // salt (1f9c2)
        EmojiInfo(
            "\uD83E\uDDC2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // canned food (1f96b)
        EmojiInfo(
            "\uD83E\uDD6B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bento box (1f371)
        EmojiInfo(
            "\uD83C\uDF71",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rice cracker (1f358)
        EmojiInfo(
            "\uD83C\uDF58",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rice ball (1f359)
        EmojiInfo(
            "\uD83C\uDF59",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cooked rice (1f35a)
        EmojiInfo(
            "\uD83C\uDF5A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // curry rice (1f35b)
        EmojiInfo(
            "\uD83C\uDF5B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // steaming bowl (1f35c)
        EmojiInfo(
            "\uD83C\uDF5C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spaghetti (1f35d)
        EmojiInfo(
            "\uD83C\uDF5D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // roasted sweet potato (1f360)
        EmojiInfo(
            "\uD83C\uDF60",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oden (1f362)
        EmojiInfo(
            "\uD83C\uDF62",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sushi (1f363)
        EmojiInfo(
            "\uD83C\uDF63",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fried shrimp (1f364)
        EmojiInfo(
            "\uD83C\uDF64",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fish cake with swirl (1f365)
        EmojiInfo(
            "\uD83C\uDF65",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // moon cake (1f96e)
        EmojiInfo(
            "\uD83E\uDD6E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dango (1f361)
        EmojiInfo(
            "\uD83C\uDF61",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dumpling (1f95f)
        EmojiInfo(
            "\uD83E\uDD5F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fortune cookie (1f960)
        EmojiInfo(
            "\uD83E\uDD60",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // takeout box (1f961)
        EmojiInfo(
            "\uD83E\uDD61",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // soft ice cream (1f366)
        EmojiInfo(
            "\uD83C\uDF66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shaved ice (1f367)
        EmojiInfo(
            "\uD83C\uDF67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ice cream (1f368)
        EmojiInfo(
            "\uD83C\uDF68",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // doughnut (1f369)
        EmojiInfo(
            "\uD83C\uDF69",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cookie (1f36a)
        EmojiInfo(
            "\uD83C\uDF6A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // birthday cake (1f382)
        EmojiInfo(
            "\uD83C\uDF82",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shortcake (1f370)
        EmojiInfo(
            "\uD83C\uDF70",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cupcake (1f9c1)
        EmojiInfo(
            "\uD83E\uDDC1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pie (1f967)
        EmojiInfo(
            "\uD83E\uDD67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chocolate bar (1f36b)
        EmojiInfo(
            "\uD83C\uDF6B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // candy (1f36c)
        EmojiInfo(
            "\uD83C\uDF6C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lollipop (1f36d)
        EmojiInfo(
            "\uD83C\uDF6D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // custard (1f36e)
        EmojiInfo(
            "\uD83C\uDF6E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // honey pot (1f36f)
        EmojiInfo(
            "\uD83C\uDF6F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baby bottle (1f37c)
        EmojiInfo(
            "\uD83C\uDF7C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // glass of milk (1f95b)
        EmojiInfo(
            "\uD83E\uDD5B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hot beverage (2615)
        EmojiInfo(
            "\u2615",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // teapot (1fad6)
        EmojiInfo(
            "\uD83E\uDED6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // teacup without handle (1f375)
        EmojiInfo(
            "\uD83C\uDF75",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sake (1f376)
        EmojiInfo(
            "\uD83C\uDF76",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bottle with popping cork (1f37e)
        EmojiInfo(
            "\uD83C\uDF7E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wine glass (1f377)
        EmojiInfo(
            "\uD83C\uDF77",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cocktail glass (1f378)
        EmojiInfo(
            "\uD83C\uDF78",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tropical drink (1f379)
        EmojiInfo(
            "\uD83C\uDF79",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beer mug (1f37a)
        EmojiInfo(
            "\uD83C\uDF7A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clinking beer mugs (1f37b)
        EmojiInfo(
            "\uD83C\uDF7B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clinking glasses (1f942)
        EmojiInfo(
            "\uD83E\uDD42",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tumbler glass (1f943)
        EmojiInfo(
            "\uD83E\uDD43",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pouring liquid (1fad7)
        EmojiInfo(
            "\uD83E\uDED7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cup with straw (1f964)
        EmojiInfo(
            "\uD83E\uDD64",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bubble tea (1f9cb)
        EmojiInfo(
            "\uD83E\uDDCB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beverage box (1f9c3)
        EmojiInfo(
            "\uD83E\uDDC3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mate (1f9c9)
        EmojiInfo(
            "\uD83E\uDDC9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ice (1f9ca)
        EmojiInfo(
            "\uD83E\uDDCA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chopsticks (1f962)
        EmojiInfo(
            "\uD83E\uDD62",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fork and knife with plate (1f37d-fe0f)
        EmojiInfo(
            "\uD83C\uDF7D\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fork and knife (1f374)
        EmojiInfo(
            "\uD83C\uDF74",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spoon (1f944)
        EmojiInfo(
            "\uD83E\uDD44",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kitchen knife (1f52a)
        EmojiInfo(
            "\uD83D\uDD2A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // jar (1fad9)
        EmojiInfo(
            "\uD83E\uDED9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // amphora (1f3fa)
        EmojiInfo(
            "\uD83C\uDFFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun gettravel() = listOf(
        // globe showing Europe-Africa (1f30d)
        EmojiInfo(
            "\uD83C\uDF0D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // globe showing Americas (1f30e)
        EmojiInfo(
            "\uD83C\uDF0E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // globe showing Asia-Australia (1f30f)
        EmojiInfo(
            "\uD83C\uDF0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // globe with meridians (1f310)
        EmojiInfo(
            "\uD83C\uDF10",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // world map (1f5fa-fe0f)
        EmojiInfo(
            "\uD83D\uDDFA\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // map of Japan (1f5fe)
        EmojiInfo(
            "\uD83D\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // compass (1f9ed)
        EmojiInfo(
            "\uD83E\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snow-capped mountain (1f3d4-fe0f)
        EmojiInfo(
            "\uD83C\uDFD4\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mountain (26f0-fe0f)
        EmojiInfo(
            "\u26F0\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // volcano (1f30b)
        EmojiInfo(
            "\uD83C\uDF0B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mount fuji (1f5fb)
        EmojiInfo(
            "\uD83D\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // camping (1f3d5-fe0f)
        EmojiInfo(
            "\uD83C\uDFD5\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // beach with umbrella (1f3d6-fe0f)
        EmojiInfo(
            "\uD83C\uDFD6\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // desert (1f3dc-fe0f)
        EmojiInfo(
            "\uD83C\uDFDC\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // desert island (1f3dd-fe0f)
        EmojiInfo(
            "\uD83C\uDFDD\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // national park (1f3de-fe0f)
        EmojiInfo(
            "\uD83C\uDFDE\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // stadium (1f3df-fe0f)
        EmojiInfo(
            "\uD83C\uDFDF\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // classical building (1f3db-fe0f)
        EmojiInfo(
            "\uD83C\uDFDB\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // building construction (1f3d7-fe0f)
        EmojiInfo(
            "\uD83C\uDFD7\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // brick (1f9f1)
        EmojiInfo(
            "\uD83E\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rock (1faa8)
        EmojiInfo(
            "\uD83E\uDEA8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wood (1fab5)
        EmojiInfo(
            "\uD83E\uDEB5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hut (1f6d6)
        EmojiInfo(
            "\uD83D\uDED6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // houses (1f3d8-fe0f)
        EmojiInfo(
            "\uD83C\uDFD8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // derelict house (1f3da-fe0f)
        EmojiInfo(
            "\uD83C\uDFDA\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // house (1f3e0)
        EmojiInfo(
            "\uD83C\uDFE0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // house with garden (1f3e1)
        EmojiInfo(
            "\uD83C\uDFE1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // office building (1f3e2)
        EmojiInfo(
            "\uD83C\uDFE2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese post office (1f3e3)
        EmojiInfo(
            "\uD83C\uDFE3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // post office (1f3e4)
        EmojiInfo(
            "\uD83C\uDFE4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hospital (1f3e5)
        EmojiInfo(
            "\uD83C\uDFE5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bank (1f3e6)
        EmojiInfo(
            "\uD83C\uDFE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hotel (1f3e8)
        EmojiInfo(
            "\uD83C\uDFE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // love hotel (1f3e9)
        EmojiInfo(
            "\uD83C\uDFE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // convenience store (1f3ea)
        EmojiInfo(
            "\uD83C\uDFEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // school (1f3eb)
        EmojiInfo(
            "\uD83C\uDFEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // department store (1f3ec)
        EmojiInfo(
            "\uD83C\uDFEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // factory (1f3ed)
        EmojiInfo(
            "\uD83C\uDFED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese castle (1f3ef)
        EmojiInfo(
            "\uD83C\uDFEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // castle (1f3f0)
        EmojiInfo(
            "\uD83C\uDFF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wedding (1f492)
        EmojiInfo(
            "\uD83D\uDC92",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Tokyo tower (1f5fc)
        EmojiInfo(
            "\uD83D\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Statue of Liberty (1f5fd)
        EmojiInfo(
            "\uD83D\uDDFD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // church (26ea)
        EmojiInfo(
            "\u26EA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mosque (1f54c)
        EmojiInfo(
            "\uD83D\uDD4C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hindu temple (1f6d5)
        EmojiInfo(
            "\uD83D\uDED5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // synagogue (1f54d)
        EmojiInfo(
            "\uD83D\uDD4D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shinto shrine (26e9-fe0f)
        EmojiInfo(
            "\u26E9\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kaaba (1f54b)
        EmojiInfo(
            "\uD83D\uDD4B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fountain (26f2)
        EmojiInfo(
            "\u26F2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tent (26fa)
        EmojiInfo(
            "\u26FA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // foggy (1f301)
        EmojiInfo(
            "\uD83C\uDF01",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // night with stars (1f303)
        EmojiInfo(
            "\uD83C\uDF03",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cityscape (1f3d9-fe0f)
        EmojiInfo(
            "\uD83C\uDFD9\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sunrise over mountains (1f304)
        EmojiInfo(
            "\uD83C\uDF04",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sunrise (1f305)
        EmojiInfo(
            "\uD83C\uDF05",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cityscape at dusk (1f306)
        EmojiInfo(
            "\uD83C\uDF06",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sunset (1f307)
        EmojiInfo(
            "\uD83C\uDF07",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bridge at night (1f309)
        EmojiInfo(
            "\uD83C\uDF09",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hot springs (2668-fe0f)
        EmojiInfo(
            "\u2668\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // carousel horse (1f3a0)
        EmojiInfo(
            "\uD83C\uDFA0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // playground slide (1f6dd)
        EmojiInfo(
            "\uD83D\uDEDD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ferris wheel (1f3a1)
        EmojiInfo(
            "\uD83C\uDFA1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // roller coaster (1f3a2)
        EmojiInfo(
            "\uD83C\uDFA2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // barber pole (1f488)
        EmojiInfo(
            "\uD83D\uDC88",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // circus tent (1f3aa)
        EmojiInfo(
            "\uD83C\uDFAA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // locomotive (1f682)
        EmojiInfo(
            "\uD83D\uDE82",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // railway car (1f683)
        EmojiInfo(
            "\uD83D\uDE83",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // high-speed train (1f684)
        EmojiInfo(
            "\uD83D\uDE84",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bullet train (1f685)
        EmojiInfo(
            "\uD83D\uDE85",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // train (1f686)
        EmojiInfo(
            "\uD83D\uDE86",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // metro (1f687)
        EmojiInfo(
            "\uD83D\uDE87",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // light rail (1f688)
        EmojiInfo(
            "\uD83D\uDE88",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // station (1f689)
        EmojiInfo(
            "\uD83D\uDE89",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tram (1f68a)
        EmojiInfo(
            "\uD83D\uDE8A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // monorail (1f69d)
        EmojiInfo(
            "\uD83D\uDE9D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mountain railway (1f69e)
        EmojiInfo(
            "\uD83D\uDE9E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tram car (1f68b)
        EmojiInfo(
            "\uD83D\uDE8B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bus (1f68c)
        EmojiInfo(
            "\uD83D\uDE8C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oncoming bus (1f68d)
        EmojiInfo(
            "\uD83D\uDE8D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // trolleybus (1f68e)
        EmojiInfo(
            "\uD83D\uDE8E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // minibus (1f690)
        EmojiInfo(
            "\uD83D\uDE90",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ambulance (1f691)
        EmojiInfo(
            "\uD83D\uDE91",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fire engine (1f692)
        EmojiInfo(
            "\uD83D\uDE92",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // police car (1f693)
        EmojiInfo(
            "\uD83D\uDE93",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oncoming police car (1f694)
        EmojiInfo(
            "\uD83D\uDE94",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // taxi (1f695)
        EmojiInfo(
            "\uD83D\uDE95",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oncoming taxi (1f696)
        EmojiInfo(
            "\uD83D\uDE96",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // automobile (1f697)
        EmojiInfo(
            "\uD83D\uDE97",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oncoming automobile (1f698)
        EmojiInfo(
            "\uD83D\uDE98",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sport utility vehicle (1f699)
        EmojiInfo(
            "\uD83D\uDE99",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pickup truck (1f6fb)
        EmojiInfo(
            "\uD83D\uDEFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // delivery truck (1f69a)
        EmojiInfo(
            "\uD83D\uDE9A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // articulated lorry (1f69b)
        EmojiInfo(
            "\uD83D\uDE9B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tractor (1f69c)
        EmojiInfo(
            "\uD83D\uDE9C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // racing car (1f3ce-fe0f)
        EmojiInfo(
            "\uD83C\uDFCE\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // motorcycle (1f3cd-fe0f)
        EmojiInfo(
            "\uD83C\uDFCD\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // motor scooter (1f6f5)
        EmojiInfo(
            "\uD83D\uDEF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // manual wheelchair (1f9bd)
        EmojiInfo(
            "\uD83E\uDDBD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // motorized wheelchair (1f9bc)
        EmojiInfo(
            "\uD83E\uDDBC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // auto rickshaw (1f6fa)
        EmojiInfo(
            "\uD83D\uDEFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bicycle (1f6b2)
        EmojiInfo(
            "\uD83D\uDEB2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kick scooter (1f6f4)
        EmojiInfo(
            "\uD83D\uDEF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // skateboard (1f6f9)
        EmojiInfo(
            "\uD83D\uDEF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // roller skate (1f6fc)
        EmojiInfo(
            "\uD83D\uDEFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bus stop (1f68f)
        EmojiInfo(
            "\uD83D\uDE8F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // motorway (1f6e3-fe0f)
        EmojiInfo(
            "\uD83D\uDEE3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // railway track (1f6e4-fe0f)
        EmojiInfo(
            "\uD83D\uDEE4\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // oil drum (1f6e2-fe0f)
        EmojiInfo(
            "\uD83D\uDEE2\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fuel pump (26fd)
        EmojiInfo(
            "\u26FD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wheel (1f6de)
        EmojiInfo(
            "\uD83D\uDEDE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // police car light (1f6a8)
        EmojiInfo(
            "\uD83D\uDEA8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // horizontal traffic light (1f6a5)
        EmojiInfo(
            "\uD83D\uDEA5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // vertical traffic light (1f6a6)
        EmojiInfo(
            "\uD83D\uDEA6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // stop sign (1f6d1)
        EmojiInfo(
            "\uD83D\uDED1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // construction (1f6a7)
        EmojiInfo(
            "\uD83D\uDEA7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // anchor (2693)
        EmojiInfo(
            "\u2693",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ring buoy (1f6df)
        EmojiInfo(
            "\uD83D\uDEDF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sailboat (26f5)
        EmojiInfo(
            "\u26F5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // canoe (1f6f6)
        EmojiInfo(
            "\uD83D\uDEF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speedboat (1f6a4)
        EmojiInfo(
            "\uD83D\uDEA4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // passenger ship (1f6f3-fe0f)
        EmojiInfo(
            "\uD83D\uDEF3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ferry (26f4-fe0f)
        EmojiInfo(
            "\u26F4\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // motor boat (1f6e5-fe0f)
        EmojiInfo(
            "\uD83D\uDEE5\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ship (1f6a2)
        EmojiInfo(
            "\uD83D\uDEA2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // airplane (2708-fe0f)
        EmojiInfo(
            "\u2708\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // small airplane (1f6e9-fe0f)
        EmojiInfo(
            "\uD83D\uDEE9\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // airplane departure (1f6eb)
        EmojiInfo(
            "\uD83D\uDEEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // airplane arrival (1f6ec)
        EmojiInfo(
            "\uD83D\uDEEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // parachute (1fa82)
        EmojiInfo(
            "\uD83E\uDE82",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // seat (1f4ba)
        EmojiInfo(
            "\uD83D\uDCBA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // helicopter (1f681)
        EmojiInfo(
            "\uD83D\uDE81",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // suspension railway (1f69f)
        EmojiInfo(
            "\uD83D\uDE9F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mountain cableway (1f6a0)
        EmojiInfo(
            "\uD83D\uDEA0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // aerial tramway (1f6a1)
        EmojiInfo(
            "\uD83D\uDEA1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // satellite (1f6f0-fe0f)
        EmojiInfo(
            "\uD83D\uDEF0\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rocket (1f680)
        EmojiInfo(
            "\uD83D\uDE80",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flying saucer (1f6f8)
        EmojiInfo(
            "\uD83D\uDEF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bellhop bell (1f6ce-fe0f)
        EmojiInfo(
            "\uD83D\uDECE\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // luggage (1f9f3)
        EmojiInfo(
            "\uD83E\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hourglass done (231b)
        EmojiInfo(
            "\u231B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hourglass not done (23f3)
        EmojiInfo(
            "\u23F3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // watch (231a)
        EmojiInfo(
            "\u231A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // alarm clock (23f0)
        EmojiInfo(
            "\u23F0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // stopwatch (23f1-fe0f)
        EmojiInfo(
            "\u23F1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // timer clock (23f2-fe0f)
        EmojiInfo(
            "\u23F2\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mantelpiece clock (1f570-fe0f)
        EmojiInfo(
            "\uD83D\uDD70\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // twelve o’clock (1f55b)
        EmojiInfo(
            "\uD83D\uDD5B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // twelve-thirty (1f567)
        EmojiInfo(
            "\uD83D\uDD67",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // one o’clock (1f550)
        EmojiInfo(
            "\uD83D\uDD50",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // one-thirty (1f55c)
        EmojiInfo(
            "\uD83D\uDD5C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // two o’clock (1f551)
        EmojiInfo(
            "\uD83D\uDD51",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // two-thirty (1f55d)
        EmojiInfo(
            "\uD83D\uDD5D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // three o’clock (1f552)
        EmojiInfo(
            "\uD83D\uDD52",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // three-thirty (1f55e)
        EmojiInfo(
            "\uD83D\uDD5E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // four o’clock (1f553)
        EmojiInfo(
            "\uD83D\uDD53",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // four-thirty (1f55f)
        EmojiInfo(
            "\uD83D\uDD5F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // five o’clock (1f554)
        EmojiInfo(
            "\uD83D\uDD54",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // five-thirty (1f560)
        EmojiInfo(
            "\uD83D\uDD60",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // six o’clock (1f555)
        EmojiInfo(
            "\uD83D\uDD55",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // six-thirty (1f561)
        EmojiInfo(
            "\uD83D\uDD61",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // seven o’clock (1f556)
        EmojiInfo(
            "\uD83D\uDD56",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // seven-thirty (1f562)
        EmojiInfo(
            "\uD83D\uDD62",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eight o’clock (1f557)
        EmojiInfo(
            "\uD83D\uDD57",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eight-thirty (1f563)
        EmojiInfo(
            "\uD83D\uDD63",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nine o’clock (1f558)
        EmojiInfo(
            "\uD83D\uDD58",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nine-thirty (1f564)
        EmojiInfo(
            "\uD83D\uDD64",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ten o’clock (1f559)
        EmojiInfo(
            "\uD83D\uDD59",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ten-thirty (1f565)
        EmojiInfo(
            "\uD83D\uDD65",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eleven o’clock (1f55a)
        EmojiInfo(
            "\uD83D\uDD5A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eleven-thirty (1f566)
        EmojiInfo(
            "\uD83D\uDD66",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // new moon (1f311)
        EmojiInfo(
            "\uD83C\uDF11",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // waxing crescent moon (1f312)
        EmojiInfo(
            "\uD83C\uDF12",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // first quarter moon (1f313)
        EmojiInfo(
            "\uD83C\uDF13",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // waxing gibbous moon (1f314)
        EmojiInfo(
            "\uD83C\uDF14",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // full moon (1f315)
        EmojiInfo(
            "\uD83C\uDF15",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // waning gibbous moon (1f316)
        EmojiInfo(
            "\uD83C\uDF16",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // last quarter moon (1f317)
        EmojiInfo(
            "\uD83C\uDF17",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // waning crescent moon (1f318)
        EmojiInfo(
            "\uD83C\uDF18",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crescent moon (1f319)
        EmojiInfo(
            "\uD83C\uDF19",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // new moon face (1f31a)
        EmojiInfo(
            "\uD83C\uDF1A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // first quarter moon face (1f31b)
        EmojiInfo(
            "\uD83C\uDF1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // last quarter moon face (1f31c)
        EmojiInfo(
            "\uD83C\uDF1C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // thermometer (1f321-fe0f)
        EmojiInfo(
            "\uD83C\uDF21\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sun (2600-fe0f)
        EmojiInfo(
            "\u2600\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // full moon face (1f31d)
        EmojiInfo(
            "\uD83C\uDF1D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sun with face (1f31e)
        EmojiInfo(
            "\uD83C\uDF1E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ringed planet (1fa90)
        EmojiInfo(
            "\uD83E\uDE90",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // star (2b50)
        EmojiInfo(
            "\u2B50",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // glowing star (1f31f)
        EmojiInfo(
            "\uD83C\uDF1F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shooting star (1f320)
        EmojiInfo(
            "\uD83C\uDF20",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // milky way (1f30c)
        EmojiInfo(
            "\uD83C\uDF0C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cloud (2601-fe0f)
        EmojiInfo(
            "\u2601\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sun behind cloud (26c5)
        EmojiInfo(
            "\u26C5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cloud with lightning and rain (26c8-fe0f)
        EmojiInfo(
            "\u26C8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sun behind small cloud (1f324-fe0f)
        EmojiInfo(
            "\uD83C\uDF24\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sun behind large cloud (1f325-fe0f)
        EmojiInfo(
            "\uD83C\uDF25\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sun behind rain cloud (1f326-fe0f)
        EmojiInfo(
            "\uD83C\uDF26\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cloud with rain (1f327-fe0f)
        EmojiInfo(
            "\uD83C\uDF27\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cloud with snow (1f328-fe0f)
        EmojiInfo(
            "\uD83C\uDF28\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cloud with lightning (1f329-fe0f)
        EmojiInfo(
            "\uD83C\uDF29\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tornado (1f32a-fe0f)
        EmojiInfo(
            "\uD83C\uDF2A\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fog (1f32b-fe0f)
        EmojiInfo(
            "\uD83C\uDF2B\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wind face (1f32c-fe0f)
        EmojiInfo(
            "\uD83C\uDF2C\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cyclone (1f300)
        EmojiInfo(
            "\uD83C\uDF00",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rainbow (1f308)
        EmojiInfo(
            "\uD83C\uDF08",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // closed umbrella (1f302)
        EmojiInfo(
            "\uD83C\uDF02",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // umbrella (2602-fe0f)
        EmojiInfo(
            "\u2602\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // umbrella with rain drops (2614)
        EmojiInfo(
            "\u2614",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // umbrella on ground (26f1-fe0f)
        EmojiInfo(
            "\u26F1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // high voltage (26a1)
        EmojiInfo(
            "\u26A1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snowflake (2744-fe0f)
        EmojiInfo(
            "\u2744\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snowman (2603-fe0f)
        EmojiInfo(
            "\u2603\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // snowman without snow (26c4)
        EmojiInfo(
            "\u26C4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // comet (2604-fe0f)
        EmojiInfo(
            "\u2604\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fire (1f525)
        EmojiInfo(
            "\uD83D\uDD25",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // droplet (1f4a7)
        EmojiInfo(
            "\uD83D\uDCA7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // water wave (1f30a)
        EmojiInfo(
            "\uD83C\uDF0A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getactivity() = listOf(
        // jack-o-lantern (1f383)
        EmojiInfo(
            "\uD83C\uDF83",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Christmas tree (1f384)
        EmojiInfo(
            "\uD83C\uDF84",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fireworks (1f386)
        EmojiInfo(
            "\uD83C\uDF86",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sparkler (1f387)
        EmojiInfo(
            "\uD83C\uDF87",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // firecracker (1f9e8)
        EmojiInfo(
            "\uD83E\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sparkles (2728)
        EmojiInfo(
            "\u2728",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // balloon (1f388)
        EmojiInfo(
            "\uD83C\uDF88",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // party popper (1f389)
        EmojiInfo(
            "\uD83C\uDF89",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // confetti ball (1f38a)
        EmojiInfo(
            "\uD83C\uDF8A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tanabata tree (1f38b)
        EmojiInfo(
            "\uD83C\uDF8B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pine decoration (1f38d)
        EmojiInfo(
            "\uD83C\uDF8D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese dolls (1f38e)
        EmojiInfo(
            "\uD83C\uDF8E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // carp streamer (1f38f)
        EmojiInfo(
            "\uD83C\uDF8F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wind chime (1f390)
        EmojiInfo(
            "\uD83C\uDF90",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // moon viewing ceremony (1f391)
        EmojiInfo(
            "\uD83C\uDF91",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red envelope (1f9e7)
        EmojiInfo(
            "\uD83E\uDDE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ribbon (1f380)
        EmojiInfo(
            "\uD83C\uDF80",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wrapped gift (1f381)
        EmojiInfo(
            "\uD83C\uDF81",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // reminder ribbon (1f397-fe0f)
        EmojiInfo(
            "\uD83C\uDF97\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // admission tickets (1f39f-fe0f)
        EmojiInfo(
            "\uD83C\uDF9F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ticket (1f3ab)
        EmojiInfo(
            "\uD83C\uDFAB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // military medal (1f396-fe0f)
        EmojiInfo(
            "\uD83C\uDF96\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // trophy (1f3c6)
        EmojiInfo(
            "\uD83C\uDFC6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sports medal (1f3c5)
        EmojiInfo(
            "\uD83C\uDFC5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // 1st place medal (1f947)
        EmojiInfo(
            "\uD83E\uDD47",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // 2nd place medal (1f948)
        EmojiInfo(
            "\uD83E\uDD48",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // 3rd place medal (1f949)
        EmojiInfo(
            "\uD83E\uDD49",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // soccer ball (26bd)
        EmojiInfo(
            "\u26BD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baseball (26be)
        EmojiInfo(
            "\u26BE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // softball (1f94e)
        EmojiInfo(
            "\uD83E\uDD4E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // basketball (1f3c0)
        EmojiInfo(
            "\uD83C\uDFC0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // volleyball (1f3d0)
        EmojiInfo(
            "\uD83C\uDFD0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // american football (1f3c8)
        EmojiInfo(
            "\uD83C\uDFC8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rugby football (1f3c9)
        EmojiInfo(
            "\uD83C\uDFC9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tennis (1f3be)
        EmojiInfo(
            "\uD83C\uDFBE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flying disc (1f94f)
        EmojiInfo(
            "\uD83E\uDD4F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bowling (1f3b3)
        EmojiInfo(
            "\uD83C\uDFB3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cricket game (1f3cf)
        EmojiInfo(
            "\uD83C\uDFCF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // field hockey (1f3d1)
        EmojiInfo(
            "\uD83C\uDFD1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ice hockey (1f3d2)
        EmojiInfo(
            "\uD83C\uDFD2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lacrosse (1f94d)
        EmojiInfo(
            "\uD83E\uDD4D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ping pong (1f3d3)
        EmojiInfo(
            "\uD83C\uDFD3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // badminton (1f3f8)
        EmojiInfo(
            "\uD83C\uDFF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // boxing glove (1f94a)
        EmojiInfo(
            "\uD83E\uDD4A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // martial arts uniform (1f94b)
        EmojiInfo(
            "\uD83E\uDD4B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // goal net (1f945)
        EmojiInfo(
            "\uD83E\uDD45",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag in hole (26f3)
        EmojiInfo(
            "\u26F3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ice skate (26f8-fe0f)
        EmojiInfo(
            "\u26F8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fishing pole (1f3a3)
        EmojiInfo(
            "\uD83C\uDFA3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // diving mask (1f93f)
        EmojiInfo(
            "\uD83E\uDD3F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // running shirt (1f3bd)
        EmojiInfo(
            "\uD83C\uDFBD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // skis (1f3bf)
        EmojiInfo(
            "\uD83C\uDFBF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sled (1f6f7)
        EmojiInfo(
            "\uD83D\uDEF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // curling stone (1f94c)
        EmojiInfo(
            "\uD83E\uDD4C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bullseye (1f3af)
        EmojiInfo(
            "\uD83C\uDFAF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yo-yo (1fa80)
        EmojiInfo(
            "\uD83E\uDE80",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kite (1fa81)
        EmojiInfo(
            "\uD83E\uDE81",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // water pistol (1f52b)
        EmojiInfo(
            "\uD83D\uDD2B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pool 8 ball (1f3b1)
        EmojiInfo(
            "\uD83C\uDFB1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crystal ball (1f52e)
        EmojiInfo(
            "\uD83D\uDD2E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // magic wand (1fa84)
        EmojiInfo(
            "\uD83E\uDE84",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // video game (1f3ae)
        EmojiInfo(
            "\uD83C\uDFAE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // joystick (1f579-fe0f)
        EmojiInfo(
            "\uD83D\uDD79\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // slot machine (1f3b0)
        EmojiInfo(
            "\uD83C\uDFB0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // game die (1f3b2)
        EmojiInfo(
            "\uD83C\uDFB2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // puzzle piece (1f9e9)
        EmojiInfo(
            "\uD83E\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // teddy bear (1f9f8)
        EmojiInfo(
            "\uD83E\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // piñata (1fa85)
        EmojiInfo(
            "\uD83E\uDE85",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mirror ball (1faa9)
        EmojiInfo(
            "\uD83E\uDEA9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nesting dolls (1fa86)
        EmojiInfo(
            "\uD83E\uDE86",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spade suit (2660-fe0f)
        EmojiInfo(
            "\u2660\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heart suit (2665-fe0f)
        EmojiInfo(
            "\u2665\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // diamond suit (2666-fe0f)
        EmojiInfo(
            "\u2666\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // club suit (2663-fe0f)
        EmojiInfo(
            "\u2663\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chess pawn (265f-fe0f)
        EmojiInfo(
            "\u265F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // joker (1f0cf)
        EmojiInfo(
            "\uD83C\uDCCF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mahjong red dragon (1f004)
        EmojiInfo(
            "\uD83C\uDC04",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flower playing cards (1f3b4)
        EmojiInfo(
            "\uD83C\uDFB4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // performing arts (1f3ad)
        EmojiInfo(
            "\uD83C\uDFAD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // framed picture (1f5bc-fe0f)
        EmojiInfo(
            "\uD83D\uDDBC\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // artist palette (1f3a8)
        EmojiInfo(
            "\uD83C\uDFA8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // thread (1f9f5)
        EmojiInfo(
            "\uD83E\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sewing needle (1faa1)
        EmojiInfo(
            "\uD83E\uDEA1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yarn (1f9f6)
        EmojiInfo(
            "\uD83E\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // knot (1faa2)
        EmojiInfo(
            "\uD83E\uDEA2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getobjects() = listOf(
        // glasses (1f453)
        EmojiInfo(
            "\uD83D\uDC53",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sunglasses (1f576-fe0f)
        EmojiInfo(
            "\uD83D\uDD76\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // goggles (1f97d)
        EmojiInfo(
            "\uD83E\uDD7D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lab coat (1f97c)
        EmojiInfo(
            "\uD83E\uDD7C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // safety vest (1f9ba)
        EmojiInfo(
            "\uD83E\uDDBA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // necktie (1f454)
        EmojiInfo(
            "\uD83D\uDC54",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // t-shirt (1f455)
        EmojiInfo(
            "\uD83D\uDC55",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // jeans (1f456)
        EmojiInfo(
            "\uD83D\uDC56",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // scarf (1f9e3)
        EmojiInfo(
            "\uD83E\uDDE3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // gloves (1f9e4)
        EmojiInfo(
            "\uD83E\uDDE4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // coat (1f9e5)
        EmojiInfo(
            "\uD83E\uDDE5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // socks (1f9e6)
        EmojiInfo(
            "\uD83E\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dress (1f457)
        EmojiInfo(
            "\uD83D\uDC57",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // kimono (1f458)
        EmojiInfo(
            "\uD83D\uDC58",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sari (1f97b)
        EmojiInfo(
            "\uD83E\uDD7B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // one-piece swimsuit (1fa71)
        EmojiInfo(
            "\uD83E\uDE71",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // briefs (1fa72)
        EmojiInfo(
            "\uD83E\uDE72",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shorts (1fa73)
        EmojiInfo(
            "\uD83E\uDE73",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bikini (1f459)
        EmojiInfo(
            "\uD83D\uDC59",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woman’s clothes (1f45a)
        EmojiInfo(
            "\uD83D\uDC5A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // folding hand fan (1faad)
        EmojiInfo(
            "\uD83E\uDEAD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // purse (1f45b)
        EmojiInfo(
            "\uD83D\uDC5B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // handbag (1f45c)
        EmojiInfo(
            "\uD83D\uDC5C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clutch bag (1f45d)
        EmojiInfo(
            "\uD83D\uDC5D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shopping bags (1f6cd-fe0f)
        EmojiInfo(
            "\uD83D\uDECD\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // backpack (1f392)
        EmojiInfo(
            "\uD83C\uDF92",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // thong sandal (1fa74)
        EmojiInfo(
            "\uD83E\uDE74",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // man’s shoe (1f45e)
        EmojiInfo(
            "\uD83D\uDC5E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // running shoe (1f45f)
        EmojiInfo(
            "\uD83D\uDC5F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hiking boot (1f97e)
        EmojiInfo(
            "\uD83E\uDD7E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flat shoe (1f97f)
        EmojiInfo(
            "\uD83E\uDD7F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // high-heeled shoe (1f460)
        EmojiInfo(
            "\uD83D\uDC60",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woman’s sandal (1f461)
        EmojiInfo(
            "\uD83D\uDC61",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ballet shoes (1fa70)
        EmojiInfo(
            "\uD83E\uDE70",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woman’s boot (1f462)
        EmojiInfo(
            "\uD83D\uDC62",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hair pick (1faae)
        EmojiInfo(
            "\uD83E\uDEAE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crown (1f451)
        EmojiInfo(
            "\uD83D\uDC51",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // woman’s hat (1f452)
        EmojiInfo(
            "\uD83D\uDC52",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // top hat (1f3a9)
        EmojiInfo(
            "\uD83C\uDFA9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // graduation cap (1f393)
        EmojiInfo(
            "\uD83C\uDF93",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // billed cap (1f9e2)
        EmojiInfo(
            "\uD83E\uDDE2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // military helmet (1fa96)
        EmojiInfo(
            "\uD83E\uDE96",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rescue worker’s helmet (26d1-fe0f)
        EmojiInfo(
            "\u26D1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // prayer beads (1f4ff)
        EmojiInfo(
            "\uD83D\uDCFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lipstick (1f484)
        EmojiInfo(
            "\uD83D\uDC84",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ring (1f48d)
        EmojiInfo(
            "\uD83D\uDC8D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // gem stone (1f48e)
        EmojiInfo(
            "\uD83D\uDC8E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // muted speaker (1f507)
        EmojiInfo(
            "\uD83D\uDD07",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speaker low volume (1f508)
        EmojiInfo(
            "\uD83D\uDD08",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speaker medium volume (1f509)
        EmojiInfo(
            "\uD83D\uDD09",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // speaker high volume (1f50a)
        EmojiInfo(
            "\uD83D\uDD0A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // loudspeaker (1f4e2)
        EmojiInfo(
            "\uD83D\uDCE2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // megaphone (1f4e3)
        EmojiInfo(
            "\uD83D\uDCE3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // postal horn (1f4ef)
        EmojiInfo(
            "\uD83D\uDCEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bell (1f514)
        EmojiInfo(
            "\uD83D\uDD14",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bell with slash (1f515)
        EmojiInfo(
            "\uD83D\uDD15",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // musical score (1f3bc)
        EmojiInfo(
            "\uD83C\uDFBC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // musical note (1f3b5)
        EmojiInfo(
            "\uD83C\uDFB5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // musical notes (1f3b6)
        EmojiInfo(
            "\uD83C\uDFB6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // studio microphone (1f399-fe0f)
        EmojiInfo(
            "\uD83C\uDF99\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // level slider (1f39a-fe0f)
        EmojiInfo(
            "\uD83C\uDF9A\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // control knobs (1f39b-fe0f)
        EmojiInfo(
            "\uD83C\uDF9B\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // microphone (1f3a4)
        EmojiInfo(
            "\uD83C\uDFA4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // headphone (1f3a7)
        EmojiInfo(
            "\uD83C\uDFA7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // radio (1f4fb)
        EmojiInfo(
            "\uD83D\uDCFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // saxophone (1f3b7)
        EmojiInfo(
            "\uD83C\uDFB7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // accordion (1fa97)
        EmojiInfo(
            "\uD83E\uDE97",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // guitar (1f3b8)
        EmojiInfo(
            "\uD83C\uDFB8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // musical keyboard (1f3b9)
        EmojiInfo(
            "\uD83C\uDFB9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // trumpet (1f3ba)
        EmojiInfo(
            "\uD83C\uDFBA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // violin (1f3bb)
        EmojiInfo(
            "\uD83C\uDFBB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // banjo (1fa95)
        EmojiInfo(
            "\uD83E\uDE95",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // drum (1f941)
        EmojiInfo(
            "\uD83E\uDD41",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // long drum (1fa98)
        EmojiInfo(
            "\uD83E\uDE98",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // maracas (1fa87)
        EmojiInfo(
            "\uD83E\uDE87",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flute (1fa88)
        EmojiInfo(
            "\uD83E\uDE88",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // harp (1fa89)
        EmojiInfo(
            "\uD83E\uDE89",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mobile phone (1f4f1)
        EmojiInfo(
            "\uD83D\uDCF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mobile phone with arrow (1f4f2)
        EmojiInfo(
            "\uD83D\uDCF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // telephone (260e-fe0f)
        EmojiInfo(
            "\u260E\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // telephone receiver (1f4de)
        EmojiInfo(
            "\uD83D\uDCDE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pager (1f4df)
        EmojiInfo(
            "\uD83D\uDCDF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fax machine (1f4e0)
        EmojiInfo(
            "\uD83D\uDCE0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // battery (1f50b)
        EmojiInfo(
            "\uD83D\uDD0B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // low battery (1faab)
        EmojiInfo(
            "\uD83E\uDEAB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // electric plug (1f50c)
        EmojiInfo(
            "\uD83D\uDD0C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // laptop (1f4bb)
        EmojiInfo(
            "\uD83D\uDCBB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // desktop computer (1f5a5-fe0f)
        EmojiInfo(
            "\uD83D\uDDA5\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // printer (1f5a8-fe0f)
        EmojiInfo(
            "\uD83D\uDDA8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keyboard (2328-fe0f)
        EmojiInfo(
            "\u2328\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // computer mouse (1f5b1-fe0f)
        EmojiInfo(
            "\uD83D\uDDB1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // trackball (1f5b2-fe0f)
        EmojiInfo(
            "\uD83D\uDDB2\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // computer disk (1f4bd)
        EmojiInfo(
            "\uD83D\uDCBD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // floppy disk (1f4be)
        EmojiInfo(
            "\uD83D\uDCBE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // optical disk (1f4bf)
        EmojiInfo(
            "\uD83D\uDCBF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dvd (1f4c0)
        EmojiInfo(
            "\uD83D\uDCC0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // abacus (1f9ee)
        EmojiInfo(
            "\uD83E\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // movie camera (1f3a5)
        EmojiInfo(
            "\uD83C\uDFA5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // film frames (1f39e-fe0f)
        EmojiInfo(
            "\uD83C\uDF9E\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // film projector (1f4fd-fe0f)
        EmojiInfo(
            "\uD83D\uDCFD\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clapper board (1f3ac)
        EmojiInfo(
            "\uD83C\uDFAC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // television (1f4fa)
        EmojiInfo(
            "\uD83D\uDCFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // camera (1f4f7)
        EmojiInfo(
            "\uD83D\uDCF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // camera with flash (1f4f8)
        EmojiInfo(
            "\uD83D\uDCF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // video camera (1f4f9)
        EmojiInfo(
            "\uD83D\uDCF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // videocassette (1f4fc)
        EmojiInfo(
            "\uD83D\uDCFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // magnifying glass tilted left (1f50d)
        EmojiInfo(
            "\uD83D\uDD0D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // magnifying glass tilted right (1f50e)
        EmojiInfo(
            "\uD83D\uDD0E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // candle (1f56f-fe0f)
        EmojiInfo(
            "\uD83D\uDD6F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // light bulb (1f4a1)
        EmojiInfo(
            "\uD83D\uDCA1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flashlight (1f526)
        EmojiInfo(
            "\uD83D\uDD26",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red paper lantern (1f3ee)
        EmojiInfo(
            "\uD83C\uDFEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // diya lamp (1fa94)
        EmojiInfo(
            "\uD83E\uDE94",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // notebook with decorative cover (1f4d4)
        EmojiInfo(
            "\uD83D\uDCD4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // closed book (1f4d5)
        EmojiInfo(
            "\uD83D\uDCD5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // open book (1f4d6)
        EmojiInfo(
            "\uD83D\uDCD6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // green book (1f4d7)
        EmojiInfo(
            "\uD83D\uDCD7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blue book (1f4d8)
        EmojiInfo(
            "\uD83D\uDCD8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // orange book (1f4d9)
        EmojiInfo(
            "\uD83D\uDCD9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // books (1f4da)
        EmojiInfo(
            "\uD83D\uDCDA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // notebook (1f4d3)
        EmojiInfo(
            "\uD83D\uDCD3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ledger (1f4d2)
        EmojiInfo(
            "\uD83D\uDCD2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // page with curl (1f4c3)
        EmojiInfo(
            "\uD83D\uDCC3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // scroll (1f4dc)
        EmojiInfo(
            "\uD83D\uDCDC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // page facing up (1f4c4)
        EmojiInfo(
            "\uD83D\uDCC4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // newspaper (1f4f0)
        EmojiInfo(
            "\uD83D\uDCF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rolled-up newspaper (1f5de-fe0f)
        EmojiInfo(
            "\uD83D\uDDDE\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bookmark tabs (1f4d1)
        EmojiInfo(
            "\uD83D\uDCD1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bookmark (1f516)
        EmojiInfo(
            "\uD83D\uDD16",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // label (1f3f7-fe0f)
        EmojiInfo(
            "\uD83C\uDFF7\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // money bag (1f4b0)
        EmojiInfo(
            "\uD83D\uDCB0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // coin (1fa99)
        EmojiInfo(
            "\uD83E\uDE99",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yen banknote (1f4b4)
        EmojiInfo(
            "\uD83D\uDCB4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dollar banknote (1f4b5)
        EmojiInfo(
            "\uD83D\uDCB5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // euro banknote (1f4b6)
        EmojiInfo(
            "\uD83D\uDCB6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pound banknote (1f4b7)
        EmojiInfo(
            "\uD83D\uDCB7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // money with wings (1f4b8)
        EmojiInfo(
            "\uD83D\uDCB8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // credit card (1f4b3)
        EmojiInfo(
            "\uD83D\uDCB3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // receipt (1f9fe)
        EmojiInfo(
            "\uD83E\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chart increasing with yen (1f4b9)
        EmojiInfo(
            "\uD83D\uDCB9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // envelope (2709-fe0f)
        EmojiInfo(
            "\u2709\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // e-mail (1f4e7)
        EmojiInfo(
            "\uD83D\uDCE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // incoming envelope (1f4e8)
        EmojiInfo(
            "\uD83D\uDCE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // envelope with arrow (1f4e9)
        EmojiInfo(
            "\uD83D\uDCE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // outbox tray (1f4e4)
        EmojiInfo(
            "\uD83D\uDCE4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // inbox tray (1f4e5)
        EmojiInfo(
            "\uD83D\uDCE5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // package (1f4e6)
        EmojiInfo(
            "\uD83D\uDCE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // closed mailbox with raised flag (1f4eb)
        EmojiInfo(
            "\uD83D\uDCEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // closed mailbox with lowered flag (1f4ea)
        EmojiInfo(
            "\uD83D\uDCEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // open mailbox with raised flag (1f4ec)
        EmojiInfo(
            "\uD83D\uDCEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // open mailbox with lowered flag (1f4ed)
        EmojiInfo(
            "\uD83D\uDCED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // postbox (1f4ee)
        EmojiInfo(
            "\uD83D\uDCEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ballot box with ballot (1f5f3-fe0f)
        EmojiInfo(
            "\uD83D\uDDF3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pencil (270f-fe0f)
        EmojiInfo(
            "\u270F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black nib (2712-fe0f)
        EmojiInfo(
            "\u2712\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fountain pen (1f58b-fe0f)
        EmojiInfo(
            "\uD83D\uDD8B\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pen (1f58a-fe0f)
        EmojiInfo(
            "\uD83D\uDD8A\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // paintbrush (1f58c-fe0f)
        EmojiInfo(
            "\uD83D\uDD8C\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crayon (1f58d-fe0f)
        EmojiInfo(
            "\uD83D\uDD8D\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // memo (1f4dd)
        EmojiInfo(
            "\uD83D\uDCDD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // briefcase (1f4bc)
        EmojiInfo(
            "\uD83D\uDCBC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // file folder (1f4c1)
        EmojiInfo(
            "\uD83D\uDCC1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // open file folder (1f4c2)
        EmojiInfo(
            "\uD83D\uDCC2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // card index dividers (1f5c2-fe0f)
        EmojiInfo(
            "\uD83D\uDDC2\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // calendar (1f4c5)
        EmojiInfo(
            "\uD83D\uDCC5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // tear-off calendar (1f4c6)
        EmojiInfo(
            "\uD83D\uDCC6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spiral notepad (1f5d2-fe0f)
        EmojiInfo(
            "\uD83D\uDDD2\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // spiral calendar (1f5d3-fe0f)
        EmojiInfo(
            "\uD83D\uDDD3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // card index (1f4c7)
        EmojiInfo(
            "\uD83D\uDCC7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chart increasing (1f4c8)
        EmojiInfo(
            "\uD83D\uDCC8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chart decreasing (1f4c9)
        EmojiInfo(
            "\uD83D\uDCC9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bar chart (1f4ca)
        EmojiInfo(
            "\uD83D\uDCCA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clipboard (1f4cb)
        EmojiInfo(
            "\uD83D\uDCCB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pushpin (1f4cc)
        EmojiInfo(
            "\uD83D\uDCCC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // round pushpin (1f4cd)
        EmojiInfo(
            "\uD83D\uDCCD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // paperclip (1f4ce)
        EmojiInfo(
            "\uD83D\uDCCE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // linked paperclips (1f587-fe0f)
        EmojiInfo(
            "\uD83D\uDD87\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // straight ruler (1f4cf)
        EmojiInfo(
            "\uD83D\uDCCF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // triangular ruler (1f4d0)
        EmojiInfo(
            "\uD83D\uDCD0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // scissors (2702-fe0f)
        EmojiInfo(
            "\u2702\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // card file box (1f5c3-fe0f)
        EmojiInfo(
            "\uD83D\uDDC3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // file cabinet (1f5c4-fe0f)
        EmojiInfo(
            "\uD83D\uDDC4\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wastebasket (1f5d1-fe0f)
        EmojiInfo(
            "\uD83D\uDDD1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // locked (1f512)
        EmojiInfo(
            "\uD83D\uDD12",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // unlocked (1f513)
        EmojiInfo(
            "\uD83D\uDD13",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // locked with pen (1f50f)
        EmojiInfo(
            "\uD83D\uDD0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // locked with key (1f510)
        EmojiInfo(
            "\uD83D\uDD10",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // key (1f511)
        EmojiInfo(
            "\uD83D\uDD11",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // old key (1f5dd-fe0f)
        EmojiInfo(
            "\uD83D\uDDDD\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hammer (1f528)
        EmojiInfo(
            "\uD83D\uDD28",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // axe (1fa93)
        EmojiInfo(
            "\uD83E\uDE93",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pick (26cf-fe0f)
        EmojiInfo(
            "\u26CF\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hammer and pick (2692-fe0f)
        EmojiInfo(
            "\u2692\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hammer and wrench (1f6e0-fe0f)
        EmojiInfo(
            "\uD83D\uDEE0\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dagger (1f5e1-fe0f)
        EmojiInfo(
            "\uD83D\uDDE1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crossed swords (2694-fe0f)
        EmojiInfo(
            "\u2694\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bomb (1f4a3)
        EmojiInfo(
            "\uD83D\uDCA3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // boomerang (1fa83)
        EmojiInfo(
            "\uD83E\uDE83",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bow and arrow (1f3f9)
        EmojiInfo(
            "\uD83C\uDFF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shield (1f6e1-fe0f)
        EmojiInfo(
            "\uD83D\uDEE1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // carpentry saw (1fa9a)
        EmojiInfo(
            "\uD83E\uDE9A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wrench (1f527)
        EmojiInfo(
            "\uD83D\uDD27",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // screwdriver (1fa9b)
        EmojiInfo(
            "\uD83E\uDE9B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nut and bolt (1f529)
        EmojiInfo(
            "\uD83D\uDD29",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // gear (2699-fe0f)
        EmojiInfo(
            "\u2699\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clamp (1f5dc-fe0f)
        EmojiInfo(
            "\uD83D\uDDDC\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // balance scale (2696-fe0f)
        EmojiInfo(
            "\u2696\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white cane (1f9af)
        EmojiInfo(
            "\uD83E\uDDAF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // link (1f517)
        EmojiInfo(
            "\uD83D\uDD17",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // broken chain (26d3-fe0f-200d-1f4a5)
        EmojiInfo(
            "\u26D3\uFE0F\u200D\uD83D\uDCA5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chains (26d3-fe0f)
        EmojiInfo(
            "\u26D3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hook (1fa9d)
        EmojiInfo(
            "\uD83E\uDE9D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // toolbox (1f9f0)
        EmojiInfo(
            "\uD83E\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // magnet (1f9f2)
        EmojiInfo(
            "\uD83E\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ladder (1fa9c)
        EmojiInfo(
            "\uD83E\uDE9C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shovel (1fa8f)
        EmojiInfo(
            "\uD83E\uDE8F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // alembic (2697-fe0f)
        EmojiInfo(
            "\u2697\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // test tube (1f9ea)
        EmojiInfo(
            "\uD83E\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // petri dish (1f9eb)
        EmojiInfo(
            "\uD83E\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dna (1f9ec)
        EmojiInfo(
            "\uD83E\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // microscope (1f52c)
        EmojiInfo(
            "\uD83D\uDD2C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // telescope (1f52d)
        EmojiInfo(
            "\uD83D\uDD2D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // satellite antenna (1f4e1)
        EmojiInfo(
            "\uD83D\uDCE1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // syringe (1f489)
        EmojiInfo(
            "\uD83D\uDC89",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // drop of blood (1fa78)
        EmojiInfo(
            "\uD83E\uDE78",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pill (1f48a)
        EmojiInfo(
            "\uD83D\uDC8A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // adhesive bandage (1fa79)
        EmojiInfo(
            "\uD83E\uDE79",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crutch (1fa7c)
        EmojiInfo(
            "\uD83E\uDE7C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // stethoscope (1fa7a)
        EmojiInfo(
            "\uD83E\uDE7A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // x-ray (1fa7b)
        EmojiInfo(
            "\uD83E\uDE7B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // door (1f6aa)
        EmojiInfo(
            "\uD83D\uDEAA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // elevator (1f6d7)
        EmojiInfo(
            "\uD83D\uDED7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mirror (1fa9e)
        EmojiInfo(
            "\uD83E\uDE9E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // window (1fa9f)
        EmojiInfo(
            "\uD83E\uDE9F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bed (1f6cf-fe0f)
        EmojiInfo(
            "\uD83D\uDECF\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // couch and lamp (1f6cb-fe0f)
        EmojiInfo(
            "\uD83D\uDECB\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // chair (1fa91)
        EmojiInfo(
            "\uD83E\uDE91",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // toilet (1f6bd)
        EmojiInfo(
            "\uD83D\uDEBD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // plunger (1faa0)
        EmojiInfo(
            "\uD83E\uDEA0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shower (1f6bf)
        EmojiInfo(
            "\uD83D\uDEBF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bathtub (1f6c1)
        EmojiInfo(
            "\uD83D\uDEC1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mouse trap (1faa4)
        EmojiInfo(
            "\uD83E\uDEA4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // razor (1fa92)
        EmojiInfo(
            "\uD83E\uDE92",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // lotion bottle (1f9f4)
        EmojiInfo(
            "\uD83E\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // safety pin (1f9f7)
        EmojiInfo(
            "\uD83E\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // broom (1f9f9)
        EmojiInfo(
            "\uD83E\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // basket (1f9fa)
        EmojiInfo(
            "\uD83E\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // roll of paper (1f9fb)
        EmojiInfo(
            "\uD83E\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bucket (1faa3)
        EmojiInfo(
            "\uD83E\uDEA3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // soap (1f9fc)
        EmojiInfo(
            "\uD83E\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bubbles (1fae7)
        EmojiInfo(
            "\uD83E\uDEE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // toothbrush (1faa5)
        EmojiInfo(
            "\uD83E\uDEA5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sponge (1f9fd)
        EmojiInfo(
            "\uD83E\uDDFD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fire extinguisher (1f9ef)
        EmojiInfo(
            "\uD83E\uDDEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shopping cart (1f6d2)
        EmojiInfo(
            "\uD83D\uDED2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cigarette (1f6ac)
        EmojiInfo(
            "\uD83D\uDEAC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // coffin (26b0-fe0f)
        EmojiInfo(
            "\u26B0\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // headstone (1faa6)
        EmojiInfo(
            "\uD83E\uDEA6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // funeral urn (26b1-fe0f)
        EmojiInfo(
            "\u26B1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // nazar amulet (1f9ff)
        EmojiInfo(
            "\uD83E\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hamsa (1faac)
        EmojiInfo(
            "\uD83E\uDEAC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // moai (1f5ff)
        EmojiInfo(
            "\uD83D\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // placard (1faa7)
        EmojiInfo(
            "\uD83E\uDEA7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // identification card (1faaa)
        EmojiInfo(
            "\uD83E\uDEAA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getsymbols() = listOf(
        // ATM sign (1f3e7)
        EmojiInfo(
            "\uD83C\uDFE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // litter in bin sign (1f6ae)
        EmojiInfo(
            "\uD83D\uDEAE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // potable water (1f6b0)
        EmojiInfo(
            "\uD83D\uDEB0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wheelchair symbol (267f)
        EmojiInfo(
            "\u267F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // men’s room (1f6b9)
        EmojiInfo(
            "\uD83D\uDEB9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // women’s room (1f6ba)
        EmojiInfo(
            "\uD83D\uDEBA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // restroom (1f6bb)
        EmojiInfo(
            "\uD83D\uDEBB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baby symbol (1f6bc)
        EmojiInfo(
            "\uD83D\uDEBC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // water closet (1f6be)
        EmojiInfo(
            "\uD83D\uDEBE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // passport control (1f6c2)
        EmojiInfo(
            "\uD83D\uDEC2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // customs (1f6c3)
        EmojiInfo(
            "\uD83D\uDEC3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // baggage claim (1f6c4)
        EmojiInfo(
            "\uD83D\uDEC4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // left luggage (1f6c5)
        EmojiInfo(
            "\uD83D\uDEC5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // warning (26a0-fe0f)
        EmojiInfo(
            "\u26A0\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // children crossing (1f6b8)
        EmojiInfo(
            "\uD83D\uDEB8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no entry (26d4)
        EmojiInfo(
            "\u26D4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // prohibited (1f6ab)
        EmojiInfo(
            "\uD83D\uDEAB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no bicycles (1f6b3)
        EmojiInfo(
            "\uD83D\uDEB3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no smoking (1f6ad)
        EmojiInfo(
            "\uD83D\uDEAD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no littering (1f6af)
        EmojiInfo(
            "\uD83D\uDEAF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // non-potable water (1f6b1)
        EmojiInfo(
            "\uD83D\uDEB1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no pedestrians (1f6b7)
        EmojiInfo(
            "\uD83D\uDEB7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no mobile phones (1f4f5)
        EmojiInfo(
            "\uD83D\uDCF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // no one under eighteen (1f51e)
        EmojiInfo(
            "\uD83D\uDD1E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // radioactive (2622-fe0f)
        EmojiInfo(
            "\u2622\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // biohazard (2623-fe0f)
        EmojiInfo(
            "\u2623\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // up arrow (2b06-fe0f)
        EmojiInfo(
            "\u2B06\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // up-right arrow (2197-fe0f)
        EmojiInfo(
            "\u2197\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // right arrow (27a1-fe0f)
        EmojiInfo(
            "\u27A1\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // down-right arrow (2198-fe0f)
        EmojiInfo(
            "\u2198\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // down arrow (2b07-fe0f)
        EmojiInfo(
            "\u2B07\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // down-left arrow (2199-fe0f)
        EmojiInfo(
            "\u2199\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // left arrow (2b05-fe0f)
        EmojiInfo(
            "\u2B05\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // up-left arrow (2196-fe0f)
        EmojiInfo(
            "\u2196\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // up-down arrow (2195-fe0f)
        EmojiInfo(
            "\u2195\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // left-right arrow (2194-fe0f)
        EmojiInfo(
            "\u2194\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // right arrow curving left (21a9-fe0f)
        EmojiInfo(
            "\u21A9\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // left arrow curving right (21aa-fe0f)
        EmojiInfo(
            "\u21AA\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // right arrow curving up (2934-fe0f)
        EmojiInfo(
            "\u2934\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // right arrow curving down (2935-fe0f)
        EmojiInfo(
            "\u2935\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // clockwise vertical arrows (1f503)
        EmojiInfo(
            "\uD83D\uDD03",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // counterclockwise arrows button (1f504)
        EmojiInfo(
            "\uD83D\uDD04",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // BACK arrow (1f519)
        EmojiInfo(
            "\uD83D\uDD19",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // END arrow (1f51a)
        EmojiInfo(
            "\uD83D\uDD1A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ON! arrow (1f51b)
        EmojiInfo(
            "\uD83D\uDD1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // SOON arrow (1f51c)
        EmojiInfo(
            "\uD83D\uDD1C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // TOP arrow (1f51d)
        EmojiInfo(
            "\uD83D\uDD1D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // place of worship (1f6d0)
        EmojiInfo(
            "\uD83D\uDED0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // atom symbol (269b-fe0f)
        EmojiInfo(
            "\u269B\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // om (1f549-fe0f)
        EmojiInfo(
            "\uD83D\uDD49\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // star of David (2721-fe0f)
        EmojiInfo(
            "\u2721\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wheel of dharma (2638-fe0f)
        EmojiInfo(
            "\u2638\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yin yang (262f-fe0f)
        EmojiInfo(
            "\u262F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // latin cross (271d-fe0f)
        EmojiInfo(
            "\u271D\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // orthodox cross (2626-fe0f)
        EmojiInfo(
            "\u2626\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // star and crescent (262a-fe0f)
        EmojiInfo(
            "\u262A\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // peace symbol (262e-fe0f)
        EmojiInfo(
            "\u262E\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // menorah (1f54e)
        EmojiInfo(
            "\uD83D\uDD4E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dotted six-pointed star (1f52f)
        EmojiInfo(
            "\uD83D\uDD2F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // khanda (1faaf)
        EmojiInfo(
            "\uD83E\uDEAF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Aries (2648)
        EmojiInfo(
            "\u2648",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Taurus (2649)
        EmojiInfo(
            "\u2649",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Gemini (264a)
        EmojiInfo(
            "\u264A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Cancer (264b)
        EmojiInfo(
            "\u264B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Leo (264c)
        EmojiInfo(
            "\u264C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Virgo (264d)
        EmojiInfo(
            "\u264D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Libra (264e)
        EmojiInfo(
            "\u264E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Scorpio (264f)
        EmojiInfo(
            "\u264F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Sagittarius (2650)
        EmojiInfo(
            "\u2650",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Capricorn (2651)
        EmojiInfo(
            "\u2651",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Aquarius (2652)
        EmojiInfo(
            "\u2652",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Pisces (2653)
        EmojiInfo(
            "\u2653",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Ophiuchus (26ce)
        EmojiInfo(
            "\u26CE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // shuffle tracks button (1f500)
        EmojiInfo(
            "\uD83D\uDD00",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // repeat button (1f501)
        EmojiInfo(
            "\uD83D\uDD01",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // repeat single button (1f502)
        EmojiInfo(
            "\uD83D\uDD02",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // play button (25b6-fe0f)
        EmojiInfo(
            "\u25B6\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fast-forward button (23e9)
        EmojiInfo(
            "\u23E9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // next track button (23ed-fe0f)
        EmojiInfo(
            "\u23ED\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // play or pause button (23ef-fe0f)
        EmojiInfo(
            "\u23EF\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // reverse button (25c0-fe0f)
        EmojiInfo(
            "\u25C0\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fast reverse button (23ea)
        EmojiInfo(
            "\u23EA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // last track button (23ee-fe0f)
        EmojiInfo(
            "\u23EE\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // upwards button (1f53c)
        EmojiInfo(
            "\uD83D\uDD3C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fast up button (23eb)
        EmojiInfo(
            "\u23EB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // downwards button (1f53d)
        EmojiInfo(
            "\uD83D\uDD3D",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fast down button (23ec)
        EmojiInfo(
            "\u23EC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pause button (23f8-fe0f)
        EmojiInfo(
            "\u23F8\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // stop button (23f9-fe0f)
        EmojiInfo(
            "\u23F9\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // record button (23fa-fe0f)
        EmojiInfo(
            "\u23FA\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eject button (23cf-fe0f)
        EmojiInfo(
            "\u23CF\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cinema (1f3a6)
        EmojiInfo(
            "\uD83C\uDFA6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // dim button (1f505)
        EmojiInfo(
            "\uD83D\uDD05",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // bright button (1f506)
        EmojiInfo(
            "\uD83D\uDD06",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // antenna bars (1f4f6)
        EmojiInfo(
            "\uD83D\uDCF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wireless (1f6dc)
        EmojiInfo(
            "\uD83D\uDEDC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // vibration mode (1f4f3)
        EmojiInfo(
            "\uD83D\uDCF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // mobile phone off (1f4f4)
        EmojiInfo(
            "\uD83D\uDCF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // female sign (2640-fe0f)
        EmojiInfo(
            "\u2640\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // male sign (2642-fe0f)
        EmojiInfo(
            "\u2642\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // transgender symbol (26a7-fe0f)
        EmojiInfo(
            "\u26A7\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // multiply (2716-fe0f)
        EmojiInfo(
            "\u2716\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // plus (2795)
        EmojiInfo(
            "\u2795",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // minus (2796)
        EmojiInfo(
            "\u2796",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // divide (2797)
        EmojiInfo(
            "\u2797",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heavy equals sign (1f7f0)
        EmojiInfo(
            "\uD83D\uDFF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // infinity (267e-fe0f)
        EmojiInfo(
            "\u267E\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // double exclamation mark (203c-fe0f)
        EmojiInfo(
            "\u203C\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // exclamation question mark (2049-fe0f)
        EmojiInfo(
            "\u2049\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red question mark (2753)
        EmojiInfo(
            "\u2753",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white question mark (2754)
        EmojiInfo(
            "\u2754",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white exclamation mark (2755)
        EmojiInfo(
            "\u2755",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red exclamation mark (2757)
        EmojiInfo(
            "\u2757",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // wavy dash (3030-fe0f)
        EmojiInfo(
            "\u3030\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // currency exchange (1f4b1)
        EmojiInfo(
            "\uD83D\uDCB1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // heavy dollar sign (1f4b2)
        EmojiInfo(
            "\uD83D\uDCB2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // medical symbol (2695-fe0f)
        EmojiInfo(
            "\u2695\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // recycling symbol (267b-fe0f)
        EmojiInfo(
            "\u267B\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // fleur-de-lis (269c-fe0f)
        EmojiInfo(
            "\u269C\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // trident emblem (1f531)
        EmojiInfo(
            "\uD83D\uDD31",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // name badge (1f4db)
        EmojiInfo(
            "\uD83D\uDCDB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese symbol for beginner (1f530)
        EmojiInfo(
            "\uD83D\uDD30",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // hollow red circle (2b55)
        EmojiInfo(
            "\u2B55",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // check mark button (2705)
        EmojiInfo(
            "\u2705",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // check box with check (2611-fe0f)
        EmojiInfo(
            "\u2611\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // check mark (2714-fe0f)
        EmojiInfo(
            "\u2714\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cross mark (274c)
        EmojiInfo(
            "\u274C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // cross mark button (274e)
        EmojiInfo(
            "\u274E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // curly loop (27b0)
        EmojiInfo(
            "\u27B0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // double curly loop (27bf)
        EmojiInfo(
            "\u27BF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // part alternation mark (303d-fe0f)
        EmojiInfo(
            "\u303D\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eight-spoked asterisk (2733-fe0f)
        EmojiInfo(
            "\u2733\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // eight-pointed star (2734-fe0f)
        EmojiInfo(
            "\u2734\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // sparkle (2747-fe0f)
        EmojiInfo(
            "\u2747\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // copyright (00a9-fe0f)
        EmojiInfo(
            "\u00A9\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // registered (00ae-fe0f)
        EmojiInfo(
            "\u00AE\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // trade mark (2122-fe0f)
        EmojiInfo(
            "\u2122\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // splatter (1fadf)
        EmojiInfo(
            "\uD83E\uDEDF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: # (0023-fe0f-20e3)
        EmojiInfo(
            "\u0023\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: * (002a-fe0f-20e3)
        EmojiInfo(
            "\u002A\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 0 (0030-fe0f-20e3)
        EmojiInfo(
            "\u0030\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 1 (0031-fe0f-20e3)
        EmojiInfo(
            "\u0031\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 2 (0032-fe0f-20e3)
        EmojiInfo(
            "\u0032\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 3 (0033-fe0f-20e3)
        EmojiInfo(
            "\u0033\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 4 (0034-fe0f-20e3)
        EmojiInfo(
            "\u0034\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 5 (0035-fe0f-20e3)
        EmojiInfo(
            "\u0035\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 6 (0036-fe0f-20e3)
        EmojiInfo(
            "\u0036\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 7 (0037-fe0f-20e3)
        EmojiInfo(
            "\u0037\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 8 (0038-fe0f-20e3)
        EmojiInfo(
            "\u0038\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 9 (0039-fe0f-20e3)
        EmojiInfo(
            "\u0039\uFE0F\u20E3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // keycap: 10 (1f51f)
        EmojiInfo(
            "\uD83D\uDD1F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // input latin uppercase (1f520)
        EmojiInfo(
            "\uD83D\uDD20",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // input latin lowercase (1f521)
        EmojiInfo(
            "\uD83D\uDD21",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // input numbers (1f522)
        EmojiInfo(
            "\uD83D\uDD22",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // input symbols (1f523)
        EmojiInfo(
            "\uD83D\uDD23",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // input latin letters (1f524)
        EmojiInfo(
            "\uD83D\uDD24",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // A button (blood type) (1f170-fe0f)
        EmojiInfo(
            "\uD83C\uDD70\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // AB button (blood type) (1f18e)
        EmojiInfo(
            "\uD83C\uDD8E",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // B button (blood type) (1f171-fe0f)
        EmojiInfo(
            "\uD83C\uDD71\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // CL button (1f191)
        EmojiInfo(
            "\uD83C\uDD91",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // COOL button (1f192)
        EmojiInfo(
            "\uD83C\uDD92",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // FREE button (1f193)
        EmojiInfo(
            "\uD83C\uDD93",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // information (2139-fe0f)
        EmojiInfo(
            "\u2139\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // ID button (1f194)
        EmojiInfo(
            "\uD83C\uDD94",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // circled M (24c2-fe0f)
        EmojiInfo(
            "\u24C2\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // NEW button (1f195)
        EmojiInfo(
            "\uD83C\uDD95",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // NG button (1f196)
        EmojiInfo(
            "\uD83C\uDD96",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // O button (blood type) (1f17e-fe0f)
        EmojiInfo(
            "\uD83C\uDD7E\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // OK button (1f197)
        EmojiInfo(
            "\uD83C\uDD97",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // P button (1f17f-fe0f)
        EmojiInfo(
            "\uD83C\uDD7F\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // SOS button (1f198)
        EmojiInfo(
            "\uD83C\uDD98",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // UP! button (1f199)
        EmojiInfo(
            "\uD83C\uDD99",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // VS button (1f19a)
        EmojiInfo(
            "\uD83C\uDD9A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “here” button (1f201)
        EmojiInfo(
            "\uD83C\uDE01",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “service charge” button (1f202-fe0f)
        EmojiInfo(
            "\uD83C\uDE02\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “monthly amount” button (1f237-fe0f)
        EmojiInfo(
            "\uD83C\uDE37\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “not free of charge” button (1f236)
        EmojiInfo(
            "\uD83C\uDE36",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “reserved” button (1f22f)
        EmojiInfo(
            "\uD83C\uDE2F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “bargain” button (1f250)
        EmojiInfo(
            "\uD83C\uDE50",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “discount” button (1f239)
        EmojiInfo(
            "\uD83C\uDE39",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “free of charge” button (1f21a)
        EmojiInfo(
            "\uD83C\uDE1A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “prohibited” button (1f232)
        EmojiInfo(
            "\uD83C\uDE32",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “acceptable” button (1f251)
        EmojiInfo(
            "\uD83C\uDE51",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “application” button (1f238)
        EmojiInfo(
            "\uD83C\uDE38",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “passing grade” button (1f234)
        EmojiInfo(
            "\uD83C\uDE34",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “vacancy” button (1f233)
        EmojiInfo(
            "\uD83C\uDE33",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “congratulations” button (3297-fe0f)
        EmojiInfo(
            "\u3297\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “secret” button (3299-fe0f)
        EmojiInfo(
            "\u3299\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “open for business” button (1f23a)
        EmojiInfo(
            "\uD83C\uDE3A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // Japanese “no vacancy” button (1f235)
        EmojiInfo(
            "\uD83C\uDE35",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red circle (1f534)
        EmojiInfo(
            "\uD83D\uDD34",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // orange circle (1f7e0)
        EmojiInfo(
            "\uD83D\uDFE0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yellow circle (1f7e1)
        EmojiInfo(
            "\uD83D\uDFE1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // green circle (1f7e2)
        EmojiInfo(
            "\uD83D\uDFE2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blue circle (1f535)
        EmojiInfo(
            "\uD83D\uDD35",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // purple circle (1f7e3)
        EmojiInfo(
            "\uD83D\uDFE3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // brown circle (1f7e4)
        EmojiInfo(
            "\uD83D\uDFE4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black circle (26ab)
        EmojiInfo(
            "\u26AB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white circle (26aa)
        EmojiInfo(
            "\u26AA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red square (1f7e5)
        EmojiInfo(
            "\uD83D\uDFE5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // orange square (1f7e7)
        EmojiInfo(
            "\uD83D\uDFE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // yellow square (1f7e8)
        EmojiInfo(
            "\uD83D\uDFE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // green square (1f7e9)
        EmojiInfo(
            "\uD83D\uDFE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // blue square (1f7e6)
        EmojiInfo(
            "\uD83D\uDFE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // purple square (1f7ea)
        EmojiInfo(
            "\uD83D\uDFEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // brown square (1f7eb)
        EmojiInfo(
            "\uD83D\uDFEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black large square (2b1b)
        EmojiInfo(
            "\u2B1B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white large square (2b1c)
        EmojiInfo(
            "\u2B1C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black medium square (25fc-fe0f)
        EmojiInfo(
            "\u25FC\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white medium square (25fb-fe0f)
        EmojiInfo(
            "\u25FB\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black medium-small square (25fe)
        EmojiInfo(
            "\u25FE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white medium-small square (25fd)
        EmojiInfo(
            "\u25FD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black small square (25aa-fe0f)
        EmojiInfo(
            "\u25AA\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white small square (25ab-fe0f)
        EmojiInfo(
            "\u25AB\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // large orange diamond (1f536)
        EmojiInfo(
            "\uD83D\uDD36",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // large blue diamond (1f537)
        EmojiInfo(
            "\uD83D\uDD37",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // small orange diamond (1f538)
        EmojiInfo(
            "\uD83D\uDD38",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // small blue diamond (1f539)
        EmojiInfo(
            "\uD83D\uDD39",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red triangle pointed up (1f53a)
        EmojiInfo(
            "\uD83D\uDD3A",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // red triangle pointed down (1f53b)
        EmojiInfo(
            "\uD83D\uDD3B",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // diamond with a dot (1f4a0)
        EmojiInfo(
            "\uD83D\uDCA0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // radio button (1f518)
        EmojiInfo(
            "\uD83D\uDD18",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white square button (1f533)
        EmojiInfo(
            "\uD83D\uDD33",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black square button (1f532)
        EmojiInfo(
            "\uD83D\uDD32",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )

    private fun getflags() = listOf(
        // chequered flag (1f3c1)
        EmojiInfo(
            "\uD83C\uDFC1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // triangular flag (1f6a9)
        EmojiInfo(
            "\uD83D\uDEA9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // crossed flags (1f38c)
        EmojiInfo(
            "\uD83C\uDF8C",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // black flag (1f3f4)
        EmojiInfo(
            "\uD83C\uDFF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // white flag (1f3f3-fe0f)
        EmojiInfo(
            "\uD83C\uDFF3\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // rainbow flag (1f3f3-fe0f-200d-1f308)
        EmojiInfo(
            "\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // transgender flag (1f3f3-fe0f-200d-26a7-fe0f)
        EmojiInfo(
            "\uD83C\uDFF3\uFE0F\u200D\u26A7\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // pirate flag (1f3f4-200d-2620-fe0f)
        EmojiInfo(
            "\uD83C\uDFF4\u200D\u2620\uFE0F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Ascension Island (1f1e6-1f1e8)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Andorra (1f1e6-1f1e9)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: United Arab Emirates (1f1e6-1f1ea)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Afghanistan (1f1e6-1f1eb)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Antigua & Barbuda (1f1e6-1f1ec)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Anguilla (1f1e6-1f1ee)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Albania (1f1e6-1f1f1)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Armenia (1f1e6-1f1f2)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Angola (1f1e6-1f1f4)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Antarctica (1f1e6-1f1f6)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Argentina (1f1e6-1f1f7)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: American Samoa (1f1e6-1f1f8)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Austria (1f1e6-1f1f9)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Australia (1f1e6-1f1fa)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Aruba (1f1e6-1f1fc)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Åland Islands (1f1e6-1f1fd)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDFD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Azerbaijan (1f1e6-1f1ff)
        EmojiInfo(
            "\uD83C\uDDE6\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bosnia & Herzegovina (1f1e7-1f1e6)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Barbados (1f1e7-1f1e7)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bangladesh (1f1e7-1f1e9)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Belgium (1f1e7-1f1ea)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Burkina Faso (1f1e7-1f1eb)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bulgaria (1f1e7-1f1ec)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bahrain (1f1e7-1f1ed)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Burundi (1f1e7-1f1ee)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Benin (1f1e7-1f1ef)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Barthélemy (1f1e7-1f1f1)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bermuda (1f1e7-1f1f2)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Brunei (1f1e7-1f1f3)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bolivia (1f1e7-1f1f4)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Caribbean Netherlands (1f1e7-1f1f6)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Brazil (1f1e7-1f1f7)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bahamas (1f1e7-1f1f8)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bhutan (1f1e7-1f1f9)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Bouvet Island (1f1e7-1f1fb)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Botswana (1f1e7-1f1fc)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Belarus (1f1e7-1f1fe)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Belize (1f1e7-1f1ff)
        EmojiInfo(
            "\uD83C\uDDE7\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Canada (1f1e8-1f1e6)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cocos (Keeling) Islands (1f1e8-1f1e8)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Congo - Kinshasa (1f1e8-1f1e9)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Central African Republic (1f1e8-1f1eb)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Congo - Brazzaville (1f1e8-1f1ec)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Switzerland (1f1e8-1f1ed)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Côte d’Ivoire (1f1e8-1f1ee)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cook Islands (1f1e8-1f1f0)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Chile (1f1e8-1f1f1)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cameroon (1f1e8-1f1f2)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: China (1f1e8-1f1f3)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Colombia (1f1e8-1f1f4)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Clipperton Island (1f1e8-1f1f5)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Sark (1f1e8-1f1f6)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Costa Rica (1f1e8-1f1f7)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cuba (1f1e8-1f1fa)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cape Verde (1f1e8-1f1fb)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Curaçao (1f1e8-1f1fc)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Christmas Island (1f1e8-1f1fd)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDFD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cyprus (1f1e8-1f1fe)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Czechia (1f1e8-1f1ff)
        EmojiInfo(
            "\uD83C\uDDE8\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Germany (1f1e9-1f1ea)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Diego Garcia (1f1e9-1f1ec)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Djibouti (1f1e9-1f1ef)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Denmark (1f1e9-1f1f0)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Dominica (1f1e9-1f1f2)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Dominican Republic (1f1e9-1f1f4)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Algeria (1f1e9-1f1ff)
        EmojiInfo(
            "\uD83C\uDDE9\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Ceuta & Melilla (1f1ea-1f1e6)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Ecuador (1f1ea-1f1e8)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Estonia (1f1ea-1f1ea)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Egypt (1f1ea-1f1ec)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Western Sahara (1f1ea-1f1ed)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Eritrea (1f1ea-1f1f7)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Spain (1f1ea-1f1f8)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Ethiopia (1f1ea-1f1f9)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: European Union (1f1ea-1f1fa)
        EmojiInfo(
            "\uD83C\uDDEA\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Finland (1f1eb-1f1ee)
        EmojiInfo(
            "\uD83C\uDDEB\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Fiji (1f1eb-1f1ef)
        EmojiInfo(
            "\uD83C\uDDEB\uD83C\uDDEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Falkland Islands (1f1eb-1f1f0)
        EmojiInfo(
            "\uD83C\uDDEB\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Micronesia (1f1eb-1f1f2)
        EmojiInfo(
            "\uD83C\uDDEB\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Faroe Islands (1f1eb-1f1f4)
        EmojiInfo(
            "\uD83C\uDDEB\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: France (1f1eb-1f1f7)
        EmojiInfo(
            "\uD83C\uDDEB\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Gabon (1f1ec-1f1e6)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: United Kingdom (1f1ec-1f1e7)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Grenada (1f1ec-1f1e9)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Georgia (1f1ec-1f1ea)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: French Guiana (1f1ec-1f1eb)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guernsey (1f1ec-1f1ec)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Ghana (1f1ec-1f1ed)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Gibraltar (1f1ec-1f1ee)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Greenland (1f1ec-1f1f1)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Gambia (1f1ec-1f1f2)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guinea (1f1ec-1f1f3)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guadeloupe (1f1ec-1f1f5)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Equatorial Guinea (1f1ec-1f1f6)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Greece (1f1ec-1f1f7)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: South Georgia & South Sandwich Islands (1f1ec-1f1f8)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guatemala (1f1ec-1f1f9)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guam (1f1ec-1f1fa)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guinea-Bissau (1f1ec-1f1fc)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Guyana (1f1ec-1f1fe)
        EmojiInfo(
            "\uD83C\uDDEC\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Hong Kong SAR China (1f1ed-1f1f0)
        EmojiInfo(
            "\uD83C\uDDED\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Heard & McDonald Islands (1f1ed-1f1f2)
        EmojiInfo(
            "\uD83C\uDDED\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Honduras (1f1ed-1f1f3)
        EmojiInfo(
            "\uD83C\uDDED\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Croatia (1f1ed-1f1f7)
        EmojiInfo(
            "\uD83C\uDDED\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Haiti (1f1ed-1f1f9)
        EmojiInfo(
            "\uD83C\uDDED\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Hungary (1f1ed-1f1fa)
        EmojiInfo(
            "\uD83C\uDDED\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Canary Islands (1f1ee-1f1e8)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Indonesia (1f1ee-1f1e9)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Ireland (1f1ee-1f1ea)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Israel (1f1ee-1f1f1)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Isle of Man (1f1ee-1f1f2)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: India (1f1ee-1f1f3)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: British Indian Ocean Territory (1f1ee-1f1f4)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Iraq (1f1ee-1f1f6)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Iran (1f1ee-1f1f7)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Iceland (1f1ee-1f1f8)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Italy (1f1ee-1f1f9)
        EmojiInfo(
            "\uD83C\uDDEE\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Jersey (1f1ef-1f1ea)
        EmojiInfo(
            "\uD83C\uDDEF\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Jamaica (1f1ef-1f1f2)
        EmojiInfo(
            "\uD83C\uDDEF\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Jordan (1f1ef-1f1f4)
        EmojiInfo(
            "\uD83C\uDDEF\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Japan (1f1ef-1f1f5)
        EmojiInfo(
            "\uD83C\uDDEF\uD83C\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Kenya (1f1f0-1f1ea)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Kyrgyzstan (1f1f0-1f1ec)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cambodia (1f1f0-1f1ed)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Kiribati (1f1f0-1f1ee)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Comoros (1f1f0-1f1f2)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Kitts & Nevis (1f1f0-1f1f3)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: North Korea (1f1f0-1f1f5)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: South Korea (1f1f0-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Kuwait (1f1f0-1f1fc)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Cayman Islands (1f1f0-1f1fe)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Kazakhstan (1f1f0-1f1ff)
        EmojiInfo(
            "\uD83C\uDDF0\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Laos (1f1f1-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Lebanon (1f1f1-1f1e7)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Lucia (1f1f1-1f1e8)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Liechtenstein (1f1f1-1f1ee)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Sri Lanka (1f1f1-1f1f0)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Liberia (1f1f1-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Lesotho (1f1f1-1f1f8)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Lithuania (1f1f1-1f1f9)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Luxembourg (1f1f1-1f1fa)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Latvia (1f1f1-1f1fb)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Libya (1f1f1-1f1fe)
        EmojiInfo(
            "\uD83C\uDDF1\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Morocco (1f1f2-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Monaco (1f1f2-1f1e8)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Moldova (1f1f2-1f1e9)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Montenegro (1f1f2-1f1ea)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Martin (1f1f2-1f1eb)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Madagascar (1f1f2-1f1ec)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Marshall Islands (1f1f2-1f1ed)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: North Macedonia (1f1f2-1f1f0)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mali (1f1f2-1f1f1)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Myanmar (Burma) (1f1f2-1f1f2)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mongolia (1f1f2-1f1f3)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Macao SAR China (1f1f2-1f1f4)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Northern Mariana Islands (1f1f2-1f1f5)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Martinique (1f1f2-1f1f6)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mauritania (1f1f2-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Montserrat (1f1f2-1f1f8)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Malta (1f1f2-1f1f9)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mauritius (1f1f2-1f1fa)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Maldives (1f1f2-1f1fb)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Malawi (1f1f2-1f1fc)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mexico (1f1f2-1f1fd)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDFD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Malaysia (1f1f2-1f1fe)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mozambique (1f1f2-1f1ff)
        EmojiInfo(
            "\uD83C\uDDF2\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Namibia (1f1f3-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: New Caledonia (1f1f3-1f1e8)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Niger (1f1f3-1f1ea)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Norfolk Island (1f1f3-1f1eb)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Nigeria (1f1f3-1f1ec)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Nicaragua (1f1f3-1f1ee)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Netherlands (1f1f3-1f1f1)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Norway (1f1f3-1f1f4)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Nepal (1f1f3-1f1f5)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDF5",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Nauru (1f1f3-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Niue (1f1f3-1f1fa)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: New Zealand (1f1f3-1f1ff)
        EmojiInfo(
            "\uD83C\uDDF3\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Oman (1f1f4-1f1f2)
        EmojiInfo(
            "\uD83C\uDDF4\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Panama (1f1f5-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Peru (1f1f5-1f1ea)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: French Polynesia (1f1f5-1f1eb)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Papua New Guinea (1f1f5-1f1ec)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Philippines (1f1f5-1f1ed)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Pakistan (1f1f5-1f1f0)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Poland (1f1f5-1f1f1)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Pierre & Miquelon (1f1f5-1f1f2)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Pitcairn Islands (1f1f5-1f1f3)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Puerto Rico (1f1f5-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Palestinian Territories (1f1f5-1f1f8)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Portugal (1f1f5-1f1f9)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Palau (1f1f5-1f1fc)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Paraguay (1f1f5-1f1fe)
        EmojiInfo(
            "\uD83C\uDDF5\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Qatar (1f1f6-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF6\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Réunion (1f1f7-1f1ea)
        EmojiInfo(
            "\uD83C\uDDF7\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Romania (1f1f7-1f1f4)
        EmojiInfo(
            "\uD83C\uDDF7\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Serbia (1f1f7-1f1f8)
        EmojiInfo(
            "\uD83C\uDDF7\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Russia (1f1f7-1f1fa)
        EmojiInfo(
            "\uD83C\uDDF7\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Rwanda (1f1f7-1f1fc)
        EmojiInfo(
            "\uD83C\uDDF7\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Saudi Arabia (1f1f8-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Solomon Islands (1f1f8-1f1e7)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDE7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Seychelles (1f1f8-1f1e8)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Sudan (1f1f8-1f1e9)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Sweden (1f1f8-1f1ea)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Singapore (1f1f8-1f1ec)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Helena (1f1f8-1f1ed)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Slovenia (1f1f8-1f1ee)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Svalbard & Jan Mayen (1f1f8-1f1ef)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Slovakia (1f1f8-1f1f0)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Sierra Leone (1f1f8-1f1f1)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: San Marino (1f1f8-1f1f2)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Senegal (1f1f8-1f1f3)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Somalia (1f1f8-1f1f4)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Suriname (1f1f8-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: South Sudan (1f1f8-1f1f8)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: São Tomé & Príncipe (1f1f8-1f1f9)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: El Salvador (1f1f8-1f1fb)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Sint Maarten (1f1f8-1f1fd)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDFD",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Syria (1f1f8-1f1fe)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Eswatini (1f1f8-1f1ff)
        EmojiInfo(
            "\uD83C\uDDF8\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tristan da Cunha (1f1f9-1f1e6)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: Turks & Caicos Islands (1f1f9-1f1e8)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Chad (1f1f9-1f1e9)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDE9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: French Southern Territories (1f1f9-1f1eb)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Togo (1f1f9-1f1ec)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Thailand (1f1f9-1f1ed)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDED",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tajikistan (1f1f9-1f1ef)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDEF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tokelau (1f1f9-1f1f0)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Timor-Leste (1f1f9-1f1f1)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF1",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Turkmenistan (1f1f9-1f1f2)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tunisia (1f1f9-1f1f3)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tonga (1f1f9-1f1f4)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF4",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Türkiye (1f1f9-1f1f7)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF7",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Trinidad & Tobago (1f1f9-1f1f9)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tuvalu (1f1f9-1f1fb)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDFB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Taiwan (1f1f9-1f1fc)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Tanzania (1f1f9-1f1ff)
        EmojiInfo(
            "\uD83C\uDDF9\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Ukraine (1f1fa-1f1e6)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Uganda (1f1fa-1f1ec)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: U.S. Outlying Islands (1f1fa-1f1f2)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: United Nations (1f1fa-1f1f3)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_NO,
        ),
        // flag: United States (1f1fa-1f1f8)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Uruguay (1f1fa-1f1fe)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDFE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Uzbekistan (1f1fa-1f1ff)
        EmojiInfo(
            "\uD83C\uDDFA\uD83C\uDDFF",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Vatican City (1f1fb-1f1e6)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: St. Vincent & Grenadines (1f1fb-1f1e8)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDE8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Venezuela (1f1fb-1f1ea)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: British Virgin Islands (1f1fb-1f1ec)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDEC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: U.S. Virgin Islands (1f1fb-1f1ee)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDEE",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Vietnam (1f1fb-1f1f3)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDF3",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Vanuatu (1f1fb-1f1fa)
        EmojiInfo(
            "\uD83C\uDDFB\uD83C\uDDFA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Wallis & Futuna (1f1fc-1f1eb)
        EmojiInfo(
            "\uD83C\uDDFC\uD83C\uDDEB",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Samoa (1f1fc-1f1f8)
        EmojiInfo(
            "\uD83C\uDDFC\uD83C\uDDF8",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Kosovo (1f1fd-1f1f0)
        EmojiInfo(
            "\uD83C\uDDFD\uD83C\uDDF0",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Yemen (1f1fe-1f1ea)
        EmojiInfo(
            "\uD83C\uDDFE\uD83C\uDDEA",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Mayotte (1f1fe-1f1f9)
        EmojiInfo(
            "\uD83C\uDDFE\uD83C\uDDF9",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: South Africa (1f1ff-1f1e6)
        EmojiInfo(
            "\uD83C\uDDFF\uD83C\uDDE6",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Zambia (1f1ff-1f1f2)
        EmojiInfo(
            "\uD83C\uDDFF\uD83C\uDDF2",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Zimbabwe (1f1ff-1f1fc)
        EmojiInfo(
            "\uD83C\uDDFF\uD83C\uDDFC",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: England (1f3f4-e0067-e0062-e0065-e006e-e0067-e007f)
        EmojiInfo(
            "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67\uDB40\uDC7F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Scotland (1f3f4-e0067-e0062-e0073-e0063-e0074-e007f)
        EmojiInfo(
            "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74\uDB40\uDC7F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
        // flag: Wales (1f3f4-e0067-e0062-e0077-e006c-e0073-e007f)
        EmojiInfo(
            "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73\uDB40\uDC7F",
            DIVERSITY_NONE,
            null,
            DISPLAY_YES,
        ),
    )
}
