/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2017-2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package ch.threema.app.emojis

/**
 * This class contains metadata about an emoji.
 *
 * Generated by Threema emoji-tools.
 */
data class EmojiInfo(
    @JvmField val emojiSequence: String,
    @JvmField val diversityFlag: Byte,
    @JvmField val diversities: Array<String>?,
    @JvmField val displayFlag: Byte,
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        other as EmojiInfo
        if (diversityFlag != other.diversityFlag) return false
        if (displayFlag != other.displayFlag) return false
        if (emojiSequence != other.emojiSequence) return false
        if (!diversities.contentEquals(other.diversities)) return false
        return true
    }

    override fun hashCode(): Int {
        var result = diversityFlag.toInt()
        result = 31 * result + displayFlag
        result = 31 * result + emojiSequence.hashCode()
        result = 31 * result + (diversities?.contentHashCode() ?: 0)
        return result
    }
}
