/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package ch.threema.app.startup.models

/**
 * All the different systems that the app might need to wait for before being considered 'ready'.
 * Note that the (partial) order matters here, as it is used to decide what to show to the user while waiting.
 * Systems which depend on other systems or are expected to become ready after those should be listed later.
 */
enum class AppSystem {
    REMOTE_SECRET,
    SERVICE_MANAGER,
    DATABASE_UPDATES,
    SYSTEM_UPDATES,
}
