# Security

## Cryptography Whitepaper

The algorithms and design decisions behind the cryptography are documented in
the [Cryptography Whitepaper](https://threema.com/press-files/2_documentation/cryptography_whitepaper.pdf).

## Reporting Vulnerabilities

If you discover a security issue in Threema, please adhere to the coordinated
vulnerability disclosure model. To be eligible for a bug bounty, please [file a
report on GObugfree](https://app.gobugfree.com/programs/threema) (where all the
details, including the bounty levels, are listed). If you’re not interested in
the bug bounty program, you can contact us via Threema or by email; for contact
details, see [threema.com/contact](https://threema.com/en/contact) (section
“Security”).

## Code Signing

Every commit in this repository is cryptographically signed using the following
PGP key:

    pub   rsa4096 2016-09-06 [SC] [expires: 2026-09-04]
          E7AD D991 4E26 0E8B 35DF  B506 65FD E935 573A CDA6
    uid           Threema Signing Key <dev@threema.ch>

The public key can be found at <https://oss.threema.ch/65FDE935573ACDA6.pub>.
