/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2015-2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package ch.threema.app.utils;

import android.view.View;
import android.widget.TextView;

import com.google.android.material.snackbar.Snackbar;

import androidx.annotation.NonNull;
import ch.threema.app.R;

public class SnackbarUtil {
    @NonNull
    public static Snackbar make(View parentLayout, String text, int length, int maxLines) {
        final Snackbar snackbar = Snackbar.make(parentLayout, text, length);
        snackbar.setBackgroundTint(
            ConfigUtils.getColorFromAttribute(snackbar.getContext(), R.attr.colorSurfaceContainerHigh)
        );
        TextView textView = snackbar.getView().findViewById(com.google.android.material.R.id.snackbar_text);
        if (textView != null) {
            textView.setMaxLines(maxLines);
            textView.setTextColor(
                ConfigUtils.getColorFromAttribute(snackbar.getContext(), R.attr.colorOnSurface)
            );
        }
        return snackbar;
    }
}
