/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2017-2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

@file:Suppress("ktlint")

package ch.threema.app.emojis

import ch.threema.app.collections.IntTrie

/**
 * Emoji parser.
 *
 *
 * Generated by Threema emoji-tools.
 */
object EmojiParser {
    // The trie that stores emoji parse results at the end of a path of codepoints.
    private val trie: IntTrie<ParseResult> by lazy {
        IntTrie<ParseResult>().apply {
            init1(this)
            init2(this)
            init3(this)
            init4(this)
            init5(this)
            init6(this)
            init7(this)
            init8(this)
            init9(this)
            init10(this)
            init11(this)
            init12(this)
            init13(this)
        }
    }

    private fun init1(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(128512), ParseResult(2, SpriteCoordinates(1, 0, 397, 463))) // grinning face
        trie.insert(intArrayOf(128516), ParseResult(2, SpriteCoordinates(1, 0, 331, 463))) // grinning face with smiling eyes
        trie.insert(intArrayOf(128518), ParseResult(2, SpriteCoordinates(1, 0, 265, 463))) // grinning squinting face
        trie.insert(intArrayOf(129315), ParseResult(2, SpriteCoordinates(1, 0, 265, 1))) // rolling on the floor laughing
        trie.insert(intArrayOf(128578), ParseResult(2, SpriteCoordinates(1, 0, 331, 1))) // slightly smiling face
        trie.insert(intArrayOf(129760), ParseResult(2, SpriteCoordinates(1, 0, 67, 67))) // melting face
        trie.insert(intArrayOf(128522), ParseResult(2, SpriteCoordinates(1, 0, 133, 463))) // smiling face with smiling eyes
        trie.insert(intArrayOf(129392), ParseResult(2, SpriteCoordinates(1, 0, 199, 67))) // smiling face with hearts
        trie.insert(intArrayOf(129321), ParseResult(2, SpriteCoordinates(1, 0, 133, 199))) // star-struck
        trie.insert(intArrayOf(128535), ParseResult(2, SpriteCoordinates(1, 0, 463, 199))) // kissing face
        trie.insert(intArrayOf(128538), ParseResult(2, SpriteCoordinates(1, 0, 463, 133))) // kissing face with closed eyes
        trie.insert(intArrayOf(129394), ParseResult(2, SpriteCoordinates(1, 0, 199, 1))) // smiling face with tear
        trie.insert(intArrayOf(128539), ParseResult(2, SpriteCoordinates(1, 0, 463, 67))) // face with tongue
        trie.insert(intArrayOf(129322), ParseResult(2, SpriteCoordinates(1, 0, 67, 199))) // zany face
        trie.insert(intArrayOf(129297), ParseResult(2, SpriteCoordinates(1, 0, 67, 265))) // money-mouth face
        trie.insert(intArrayOf(129325), ParseResult(2, SpriteCoordinates(1, 0, 1, 199))) // face with hand over mouth
        trie.insert(intArrayOf(129763), ParseResult(2, SpriteCoordinates(1, 0, 1, 67))) // face with peeking eye
        trie.insert(intArrayOf(129300), ParseResult(2, SpriteCoordinates(1, 0, 265, 199))) // thinking face
        trie.insert(intArrayOf(129296), ParseResult(2, SpriteCoordinates(1, 0, 133, 265))) // zipper-mouth face
        trie.insert(intArrayOf(128528), ParseResult(2, SpriteCoordinates(1, 0, 1, 463))) // neutral face
        trie.insert(intArrayOf(128566), ParseResult(2, SpriteCoordinates(1, 0, 199, 331))) // face without mouth
        trie.insert(intArrayOf(128566, 8205, 127787, 65039), ParseResult(6, SpriteCoordinates(1, 0, 265, 331))) // face in clouds
        trie.insert(intArrayOf(128566, 8205, 127787), ParseResult(5, SpriteCoordinates(1, 0, 265, 331))) // face in clouds
        trie.insert(intArrayOf(128530), ParseResult(2, SpriteCoordinates(1, 0, 463, 397))) // unamused face
        trie.insert(intArrayOf(128556), ParseResult(2, SpriteCoordinates(1, 0, 397, 331))) // grimacing face
        trie.insert(intArrayOf(129317), ParseResult(2, SpriteCoordinates(1, 0, 199, 199))) // lying face
        trie.insert(intArrayOf(128578, 8205, 8596, 65039), ParseResult(5, SpriteCoordinates(1, 0, 331, 67))) // head shaking horizontally
        trie.insert(intArrayOf(128578, 8205, 8596), ParseResult(4, SpriteCoordinates(1, 0, 331, 67))) // head shaking horizontally
        trie.insert(intArrayOf(128524), ParseResult(2, SpriteCoordinates(1, 0, 67, 463))) // relieved face
        trie.insert(intArrayOf(128554), ParseResult(2, SpriteCoordinates(1, 0, 67, 397))) // sleepy face
        trie.insert(intArrayOf(128564), ParseResult(2, SpriteCoordinates(1, 0, 397, 1))) // sleeping face
        trie.insert(intArrayOf(128567), ParseResult(2, SpriteCoordinates(1, 0, 133, 331))) // face with medical mask
        trie.insert(intArrayOf(129301), ParseResult(2, SpriteCoordinates(1, 0, 265, 133))) // face with head-bandage
        trie.insert(intArrayOf(129326), ParseResult(2, SpriteCoordinates(1, 0, 199, 133))) // face vomiting
        trie.insert(intArrayOf(129397), ParseResult(2, SpriteCoordinates(1, 0, 67, 133))) // hot face
        trie.insert(intArrayOf(129396), ParseResult(2, SpriteCoordinates(1, 0, 133, 133))) // woozy face
        trie.insert(intArrayOf(128565, 8205, 128171), ParseResult(5, SpriteCoordinates(1, 0, 331, 331))) // face with spiral eyes
        trie.insert(intArrayOf(129312), ParseResult(2, SpriteCoordinates(1, 0, 265, 67))) // cowboy hat face
        trie.insert(intArrayOf(129400), ParseResult(2, SpriteCoordinates(1, 0, 1, 133))) // disguised face
        trie.insert(intArrayOf(129299), ParseResult(2, SpriteCoordinates(1, 0, 1, 265))) // nerd face
        trie.insert(intArrayOf(128533), ParseResult(2, SpriteCoordinates(1, 0, 463, 265))) // confused face
        trie.insert(intArrayOf(128543), ParseResult(2, SpriteCoordinates(1, 0, 463, 1))) // worried face
        trie.insert(intArrayOf(9785), ParseResult(1, SpriteCoordinates(1, 0, 67, 1))) // frowning face
        trie.insert(intArrayOf(9785, 65039), ParseResult(2, SpriteCoordinates(1, 0, 67, 1))) // frowning face
        trie.insert(intArrayOf(128559), ParseResult(2, SpriteCoordinates(1, 0, 397, 265))) // hushed face
        trie.insert(intArrayOf(128563), ParseResult(2, SpriteCoordinates(1, 0, 397, 67))) // flushed face
        trie.insert(intArrayOf(129401), ParseResult(2, SpriteCoordinates(1, 0, 133, 67))) // face holding back tears
        trie.insert(intArrayOf(128551), ParseResult(2, SpriteCoordinates(1, 0, 133, 397))) // anguished face
        trie.insert(intArrayOf(128560), ParseResult(2, SpriteCoordinates(1, 0, 397, 199))) // anxious face with sweat
        trie.insert(intArrayOf(128546), ParseResult(2, SpriteCoordinates(1, 0, 331, 397))) // crying face
        trie.insert(intArrayOf(128561), ParseResult(2, SpriteCoordinates(1, 0, 397, 133))) // face screaming in fear
        trie.insert(intArrayOf(128547), ParseResult(2, SpriteCoordinates(1, 0, 265, 397))) // persevering face
        trie.insert(intArrayOf(128531), ParseResult(2, SpriteCoordinates(1, 0, 463, 331))) // downcast face with sweat
        trie.insert(intArrayOf(128555), ParseResult(2, SpriteCoordinates(1, 0, 1, 397))) // tired face
        trie.insert(intArrayOf(128548), ParseResult(2, SpriteCoordinates(1, 0, 199, 397))) // face with steam from nose
        trie.insert(intArrayOf(128544), ParseResult(2, SpriteCoordinates(1, 0, 397, 397))) // angry face
        trie.insert(intArrayOf(128520), ParseResult(2, SpriteCoordinates(1, 0, 199, 463))) // smiling face with horns
        trie.insert(intArrayOf(128128), ParseResult(2, SpriteCoordinates(1, 0, 529, 529))) // skull
        trie.insert(intArrayOf(128169), ParseResult(2, SpriteCoordinates(1, 0, 529, 199))) // pile of poo
        trie.insert(intArrayOf(128121), ParseResult(2, SpriteCoordinates(1, 0, 595, 133))) // ogre
        trie.insert(intArrayOf(128123), ParseResult(2, SpriteCoordinates(1, 0, 595, 67))) // ghost
        trie.insert(intArrayOf(128126), ParseResult(2, SpriteCoordinates(1, 0, 595, 1))) // alien monster
        trie.insert(intArrayOf(128570), ParseResult(2, SpriteCoordinates(1, 0, 1, 331))) // grinning cat
        trie.insert(intArrayOf(128569), ParseResult(2, SpriteCoordinates(1, 0, 67, 331))) // cat with tears of joy
        trie.insert(intArrayOf(128572), ParseResult(2, SpriteCoordinates(1, 0, 331, 265))) // cat with wry smile
        trie.insert(intArrayOf(128576), ParseResult(2, SpriteCoordinates(1, 0, 331, 133))) // weary cat
        trie.insert(intArrayOf(128574), ParseResult(2, SpriteCoordinates(1, 0, 331, 199))) // pouting cat
        trie.insert(intArrayOf(128585), ParseResult(2, SpriteCoordinates(1, 0, 265, 265))) // hear-no-evil monkey
        trie.insert(intArrayOf(128140), ParseResult(2, SpriteCoordinates(1, 0, 463, 529))) // love letter
        trie.insert(intArrayOf(128157), ParseResult(2, SpriteCoordinates(1, 0, 67, 529))) // heart with ribbon
        trie.insert(intArrayOf(128151), ParseResult(2, SpriteCoordinates(1, 0, 331, 529))) // growing heart
        trie.insert(intArrayOf(128158), ParseResult(2, SpriteCoordinates(1, 0, 1, 529))) // revolving hearts
        trie.insert(intArrayOf(128159), ParseResult(2, SpriteCoordinates(1, 0, 529, 463))) // heart decoration
        trie.insert(intArrayOf(128148), ParseResult(2, SpriteCoordinates(1, 0, 397, 529))) // broken heart
        trie.insert(intArrayOf(10084, 65039, 8205, 129657), ParseResult(5, SpriteCoordinates(1, 0, 1, 1))) // mending heart
        trie.insert(intArrayOf(10084, 8205, 129657), ParseResult(4, SpriteCoordinates(1, 0, 1, 1))) // mending heart
        trie.insert(intArrayOf(129655), ParseResult(2, SpriteCoordinates(1, 0, 133, 1))) // pink heart
        trie.insert(intArrayOf(128155), ParseResult(2, SpriteCoordinates(1, 0, 199, 529))) // yellow heart
        trie.insert(intArrayOf(128153), ParseResult(2, SpriteCoordinates(1, 0, 265, 529))) // blue heart
        trie.insert(intArrayOf(128156), ParseResult(2, SpriteCoordinates(1, 0, 133, 529))) // purple heart
        trie.insert(intArrayOf(128420), ParseResult(2, SpriteCoordinates(1, 0, 529, 1))) // black heart
        trie.insert(intArrayOf(129293), ParseResult(2, SpriteCoordinates(1, 0, 199, 265))) // white heart
        trie.insert(intArrayOf(128175), ParseResult(2, SpriteCoordinates(1, 0, 529, 133))) // hundred points
        trie.insert(intArrayOf(128165), ParseResult(2, SpriteCoordinates(1, 0, 529, 331))) // collision
        trie.insert(intArrayOf(128166), ParseResult(2, SpriteCoordinates(1, 0, 529, 265))) // sweat droplets
        trie.insert(intArrayOf(128371), ParseResult(2, SpriteCoordinates(1, 0, 529, 67))) // hole
        trie.insert(intArrayOf(128371, 65039), ParseResult(3, SpriteCoordinates(1, 0, 529, 67))) // hole
        trie.insert(intArrayOf(128065, 65039, 8205, 128488), ParseResult(6, SpriteCoordinates(1, 0, 595, 199))) // eye in speech bubble
        trie.insert(intArrayOf(128065, 65039, 8205, 128488, 65039), ParseResult(7, SpriteCoordinates(1, 0, 595, 199))) // eye in speech bubble
        trie.insert(intArrayOf(128065, 8205, 128488), ParseResult(5, SpriteCoordinates(1, 0, 595, 199))) // eye in speech bubble
        trie.insert(intArrayOf(128065, 8205, 128488, 65039), ParseResult(6, SpriteCoordinates(1, 0, 595, 199))) // eye in speech bubble
        trie.insert(intArrayOf(128495), ParseResult(2, SpriteCoordinates(1, 0, 463, 463))) // right anger bubble
        trie.insert(intArrayOf(128495, 65039), ParseResult(3, SpriteCoordinates(1, 0, 463, 463))) // right anger bubble
        trie.insert(intArrayOf(128164), ParseResult(2, SpriteCoordinates(1, 0, 529, 397))) // ZZZ
        trie.insert(intArrayOf(128515), ParseResult(2, SpriteCoordinates(1, 1, 529, 133))) // grinning face with big eyes
        trie.insert(intArrayOf(128513), ParseResult(2, SpriteCoordinates(1, 1, 529, 265))) // beaming face with smiling eyes
        trie.insert(intArrayOf(128517), ParseResult(2, SpriteCoordinates(1, 1, 529, 67))) // grinning face with sweat
        trie.insert(intArrayOf(128514), ParseResult(2, SpriteCoordinates(1, 1, 529, 199))) // face with tears of joy
        trie.insert(intArrayOf(128579), ParseResult(2, SpriteCoordinates(1, 1, 265, 331))) // upside-down face
        trie.insert(intArrayOf(128521), ParseResult(2, SpriteCoordinates(1, 1, 463, 463))) // winking face
        trie.insert(intArrayOf(128519), ParseResult(2, SpriteCoordinates(1, 1, 529, 1))) // smiling face with halo
        trie.insert(intArrayOf(128525), ParseResult(2, SpriteCoordinates(1, 1, 331, 463))) // smiling face with heart-eyes
        trie.insert(intArrayOf(128536), ParseResult(2, SpriteCoordinates(1, 1, 463, 397))) // face blowing a kiss
        trie.insert(intArrayOf(9786), ParseResult(1, SpriteCoordinates(1, 1, 67, 67))) // smiling face
        trie.insert(intArrayOf(9786, 65039), ParseResult(2, SpriteCoordinates(1, 1, 67, 67))) // smiling face
        trie.insert(intArrayOf(128537), ParseResult(2, SpriteCoordinates(1, 1, 463, 331))) // kissing face with smiling eyes
        trie.insert(intArrayOf(128523), ParseResult(2, SpriteCoordinates(1, 1, 397, 463))) // face savoring food
        trie.insert(intArrayOf(128540), ParseResult(2, SpriteCoordinates(1, 1, 463, 265))) // winking face with tongue
        trie.insert(intArrayOf(128541), ParseResult(2, SpriteCoordinates(1, 1, 463, 199))) // squinting face with tongue
        trie.insert(intArrayOf(129303), ParseResult(2, SpriteCoordinates(1, 1, 331, 133))) // smiling face with open hands
        trie.insert(intArrayOf(129762), ParseResult(2, SpriteCoordinates(1, 1, 199, 1))) // face with open eyes and hand over mouth
        trie.insert(intArrayOf(129323), ParseResult(2, SpriteCoordinates(1, 1, 67, 265))) // shushing face
        trie.insert(intArrayOf(129761), ParseResult(2, SpriteCoordinates(1, 1, 199, 67))) // saluting face
        trie.insert(intArrayOf(129320), ParseResult(2, SpriteCoordinates(1, 1, 133, 265))) // face with raised eyebrow
        trie.insert(intArrayOf(128529), ParseResult(2, SpriteCoordinates(1, 1, 133, 463))) // expressionless face
        trie.insert(intArrayOf(129765), ParseResult(2, SpriteCoordinates(1, 1, 67, 133))) // dotted line face
        trie.insert(intArrayOf(128527), ParseResult(2, SpriteCoordinates(1, 1, 199, 463))) // smirking face
        trie.insert(intArrayOf(128580), ParseResult(2, SpriteCoordinates(1, 1, 199, 331))) // face with rolling eyes
        trie.insert(intArrayOf(128558, 8205, 128168), ParseResult(5, SpriteCoordinates(1, 1, 133, 397))) // face exhaling
        trie.insert(intArrayOf(129768), ParseResult(2, SpriteCoordinates(1, 1, 1, 133))) // shaking face
        trie.insert(intArrayOf(128578, 8205, 8597, 65039), ParseResult(5, SpriteCoordinates(1, 1, 331, 331))) // head shaking vertically
        trie.insert(intArrayOf(128578, 8205, 8597), ParseResult(4, SpriteCoordinates(1, 1, 331, 331))) // head shaking vertically
        trie.insert(intArrayOf(128532), ParseResult(2, SpriteCoordinates(1, 1, 67, 463))) // pensive face
        trie.insert(intArrayOf(129316), ParseResult(2, SpriteCoordinates(1, 1, 265, 265))) // drooling face
        trie.insert(intArrayOf(129769), ParseResult(2, SpriteCoordinates(1, 1, 133, 67))) // face with bags under eyes
        trie.insert(intArrayOf(129298), ParseResult(2, SpriteCoordinates(1, 1, 331, 265))) // face with thermometer
        trie.insert(intArrayOf(129314), ParseResult(2, SpriteCoordinates(1, 1, 331, 1))) // nauseated face
        trie.insert(intArrayOf(129319), ParseResult(2, SpriteCoordinates(1, 1, 199, 265))) // sneezing face
        trie.insert(intArrayOf(129398), ParseResult(2, SpriteCoordinates(1, 1, 265, 1))) // cold face
        trie.insert(intArrayOf(128565), ParseResult(2, SpriteCoordinates(1, 1, 397, 331))) // face with crossed-out eyes
        trie.insert(intArrayOf(129327), ParseResult(2, SpriteCoordinates(1, 1, 265, 199))) // exploding head
        trie.insert(intArrayOf(129395), ParseResult(2, SpriteCoordinates(1, 1, 265, 67))) // partying face
        trie.insert(intArrayOf(128526), ParseResult(2, SpriteCoordinates(1, 1, 265, 463))) // smiling face with sunglasses
        trie.insert(intArrayOf(129488), ParseResult(2, SpriteCoordinates(1, 1, 133, 199))) // face with monocle
        trie.insert(intArrayOf(129764), ParseResult(2, SpriteCoordinates(1, 1, 133, 133))) // face with diagonal mouth
        trie.insert(intArrayOf(128577), ParseResult(2, SpriteCoordinates(1, 1, 397, 1))) // slightly frowning face
        trie.insert(intArrayOf(128558), ParseResult(2, SpriteCoordinates(1, 1, 67, 397))) // face with open mouth
        trie.insert(intArrayOf(128562), ParseResult(2, SpriteCoordinates(1, 1, 1, 397))) // astonished face
        trie.insert(intArrayOf(129402), ParseResult(2, SpriteCoordinates(1, 1, 199, 199))) // pleading face
        trie.insert(intArrayOf(128550), ParseResult(2, SpriteCoordinates(1, 1, 397, 397))) // frowning face with open mouth
        trie.insert(intArrayOf(128552), ParseResult(2, SpriteCoordinates(1, 1, 331, 397))) // fearful face
        trie.insert(intArrayOf(128549), ParseResult(2, SpriteCoordinates(1, 1, 463, 1))) // sad but relieved face
        trie.insert(intArrayOf(128557), ParseResult(2, SpriteCoordinates(1, 1, 199, 397))) // loudly crying face
        trie.insert(intArrayOf(128534), ParseResult(2, SpriteCoordinates(1, 1, 1, 463))) // confounded face
        trie.insert(intArrayOf(128542), ParseResult(2, SpriteCoordinates(1, 1, 463, 133))) // disappointed face
        trie.insert(intArrayOf(128553), ParseResult(2, SpriteCoordinates(1, 1, 265, 397))) // weary face
        trie.insert(intArrayOf(129393), ParseResult(2, SpriteCoordinates(1, 1, 265, 133))) // yawning face
        trie.insert(intArrayOf(128545), ParseResult(2, SpriteCoordinates(1, 1, 463, 67))) // enraged face
        trie.insert(intArrayOf(129324), ParseResult(2, SpriteCoordinates(1, 1, 1, 265))) // face with symbols on mouth
        trie.insert(intArrayOf(128127), ParseResult(2, SpriteCoordinates(1, 1, 595, 1))) // angry face with horns
        trie.insert(intArrayOf(9760, 65039), ParseResult(2, SpriteCoordinates(1, 1, 133, 1))) // skull and crossbones
        trie.insert(intArrayOf(9760), ParseResult(1, SpriteCoordinates(1, 1, 133, 1))) // skull and crossbones
        trie.insert(intArrayOf(129313), ParseResult(2, SpriteCoordinates(1, 1, 331, 67))) // clown face
        trie.insert(intArrayOf(128122), ParseResult(2, SpriteCoordinates(1, 1, 595, 133))) // goblin
        trie.insert(intArrayOf(128125), ParseResult(2, SpriteCoordinates(1, 1, 595, 67))) // alien
        trie.insert(intArrayOf(129302), ParseResult(2, SpriteCoordinates(1, 1, 331, 199))) // robot
        trie.insert(intArrayOf(128568), ParseResult(2, SpriteCoordinates(1, 1, 397, 265))) // grinning cat with smiling eyes
        trie.insert(intArrayOf(128571), ParseResult(2, SpriteCoordinates(1, 1, 397, 199))) // smiling cat with heart-eyes
        trie.insert(intArrayOf(128573), ParseResult(2, SpriteCoordinates(1, 1, 397, 133))) // kissing cat
        trie.insert(intArrayOf(128575), ParseResult(2, SpriteCoordinates(1, 1, 397, 67))) // crying cat
        trie.insert(intArrayOf(128584), ParseResult(2, SpriteCoordinates(1, 1, 133, 331))) // see-no-evil monkey
        trie.insert(intArrayOf(128586), ParseResult(2, SpriteCoordinates(1, 1, 67, 331))) // speak-no-evil monkey
        trie.insert(intArrayOf(128152), ParseResult(2, SpriteCoordinates(1, 1, 265, 529))) // heart with arrow
        trie.insert(intArrayOf(128150), ParseResult(2, SpriteCoordinates(1, 1, 331, 529))) // sparkling heart
        trie.insert(intArrayOf(128147), ParseResult(2, SpriteCoordinates(1, 1, 463, 529))) // beating heart
        trie.insert(intArrayOf(128149), ParseResult(2, SpriteCoordinates(1, 1, 397, 529))) // two hearts
        trie.insert(intArrayOf(10083), ParseResult(1, SpriteCoordinates(1, 1, 1, 67))) // heart exclamation
        trie.insert(intArrayOf(10083, 65039), ParseResult(2, SpriteCoordinates(1, 1, 1, 67))) // heart exclamation
        trie.insert(intArrayOf(10084, 8205, 128293), ParseResult(4, SpriteCoordinates(1, 1, 67, 1))) // heart on fire
        trie.insert(intArrayOf(10084, 65039, 8205, 128293), ParseResult(5, SpriteCoordinates(1, 1, 67, 1))) // heart on fire
        trie.insert(intArrayOf(10084), ParseResult(1, SpriteCoordinates(1, 1, 1, 1))) // red heart
        trie.insert(intArrayOf(10084, 65039), ParseResult(2, SpriteCoordinates(1, 1, 1, 1))) // red heart
        trie.insert(intArrayOf(129505), ParseResult(2, SpriteCoordinates(1, 1, 67, 199))) // orange heart
        trie.insert(intArrayOf(128154), ParseResult(2, SpriteCoordinates(1, 1, 199, 529))) // green heart
        trie.insert(intArrayOf(129653), ParseResult(2, SpriteCoordinates(1, 1, 1, 199))) // light blue heart
        trie.insert(intArrayOf(129294), ParseResult(2, SpriteCoordinates(1, 1, 1, 331))) // brown heart
        trie.insert(intArrayOf(129654), ParseResult(2, SpriteCoordinates(1, 1, 199, 133))) // grey heart
        trie.insert(intArrayOf(128139), ParseResult(2, SpriteCoordinates(1, 1, 529, 529))) // kiss mark
        trie.insert(intArrayOf(128162), ParseResult(2, SpriteCoordinates(1, 1, 133, 529))) // anger symbol
        trie.insert(intArrayOf(128171), ParseResult(2, SpriteCoordinates(1, 1, 1, 529))) // dizzy
        trie.insert(intArrayOf(128168), ParseResult(2, SpriteCoordinates(1, 1, 67, 529))) // dashing away
        trie.insert(intArrayOf(128172), ParseResult(2, SpriteCoordinates(1, 1, 529, 463))) // speech balloon
        trie.insert(intArrayOf(128488, 65039), ParseResult(3, SpriteCoordinates(1, 1, 529, 331))) // left speech bubble
        trie.insert(intArrayOf(128488), ParseResult(2, SpriteCoordinates(1, 1, 529, 331))) // left speech bubble
        trie.insert(intArrayOf(128173), ParseResult(2, SpriteCoordinates(1, 1, 529, 397))) // thought balloon
        trie.insert(intArrayOf(128075), ParseResult(2, SpriteCoordinates(2, 0, 661, 859))) // waving hand
        trie.insert(intArrayOf(129306, 127999), ParseResult(4, SpriteCoordinates(2, 0, 595, 397))) // raised back of hand: dark skin tone
        trie.insert(intArrayOf(9995, 127998), ParseResult(3, SpriteCoordinates(2, 0, 1, 67))) // raised hand: medium-dark skin tone
        trie.insert(intArrayOf(129777, 127997), ParseResult(4, SpriteCoordinates(2, 0, 199, 67))) // rightwards hand: medium skin tone
        trie.insert(intArrayOf(129779, 127996), ParseResult(4, SpriteCoordinates(2, 0, 133, 133))) // palm down hand: medium-light skin tone
        trie.insert(intArrayOf(129783, 127995), ParseResult(4, SpriteCoordinates(2, 0, 67, 133))) // leftwards pushing hand: light skin tone
        trie.insert(intArrayOf(128076), ParseResult(2, SpriteCoordinates(2, 0, 595, 859))) // OK hand
        trie.insert(intArrayOf(129292, 127999), ParseResult(4, SpriteCoordinates(2, 0, 595, 529))) // pinched fingers: dark skin tone
        trie.insert(intArrayOf(9996, 127998), ParseResult(3, SpriteCoordinates(2, 0, 67, 1))) // victory hand: medium-dark skin tone
        trie.insert(intArrayOf(129776, 127997), ParseResult(4, SpriteCoordinates(2, 0, 1, 199))) // hand with index finger and thumb crossed: medium skin tone
        trie.insert(intArrayOf(129304, 127996), ParseResult(4, SpriteCoordinates(2, 0, 595, 463))) // sign of the horns: medium-light skin tone
        trie.insert(intArrayOf(128072, 127995), ParseResult(4, SpriteCoordinates(2, 0, 727, 859))) // backhand index pointing left: light skin tone
        trie.insert(intArrayOf(128070), ParseResult(2, SpriteCoordinates(2, 0, 793, 859))) // backhand index pointing up
        trie.insert(intArrayOf(128405, 127999), ParseResult(4, SpriteCoordinates(2, 0, 661, 595))) // middle finger: dark skin tone
        trie.insert(intArrayOf(9757, 127998), ParseResult(3, SpriteCoordinates(2, 0, 1, 133))) // index pointing up: medium-dark skin tone
        trie.insert(intArrayOf(128077, 127997), ParseResult(4, SpriteCoordinates(2, 0, 529, 859))) // thumbs up: medium skin tone
        trie.insert(intArrayOf(9994, 127996), ParseResult(3, SpriteCoordinates(2, 0, 67, 67))) // raised fist: medium-light skin tone
        trie.insert(intArrayOf(129307, 127995), ParseResult(4, SpriteCoordinates(2, 0, 595, 331))) // left-facing fist: light skin tone
        trie.insert(intArrayOf(128079), ParseResult(2, SpriteCoordinates(2, 0, 463, 859))) // clapping hands
        trie.insert(intArrayOf(128588, 127999), ParseResult(4, SpriteCoordinates(2, 0, 661, 199))) // raising hands: dark skin tone
        trie.insert(intArrayOf(128080, 127998), ParseResult(4, SpriteCoordinates(2, 0, 397, 859))) // open hands: medium-dark skin tone
        trie.insert(intArrayOf(129309, 127997), ParseResult(4, SpriteCoordinates(2, 0, 595, 265))) // handshake: medium skin tone
        trie.insert(intArrayOf(129777, 127997, 8205, 129778, 127995), ParseResult(9, SpriteCoordinates(2, 0, 199, 133))) // handshake: medium skin tone, light skin tone
        trie.insert(intArrayOf(129777, 127999, 8205, 129778, 127998), ParseResult(9, SpriteCoordinates(2, 0, 199, 1))) // handshake: dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(9997, 127998), ParseResult(3, SpriteCoordinates(2, 0, 1, 1))) // writing hand: medium-dark skin tone
        trie.insert(intArrayOf(129331, 127997), ParseResult(4, SpriteCoordinates(2, 0, 595, 1))) // selfie: medium skin tone
        trie.insert(intArrayOf(129461), ParseResult(2, SpriteCoordinates(2, 0, 529, 265))) // leg
        trie.insert(intArrayOf(129462, 127999), ParseResult(4, SpriteCoordinates(2, 0, 529, 199))) // foot: dark skin tone
        trie.insert(intArrayOf(129467, 127998), ParseResult(4, SpriteCoordinates(2, 0, 397, 463))) // ear with hearing aid: medium-dark skin tone
        trie.insert(intArrayOf(129463), ParseResult(2, SpriteCoordinates(2, 0, 529, 133))) // tooth
        trie.insert(intArrayOf(128118, 127998), ParseResult(4, SpriteCoordinates(2, 0, 727, 265))) // baby: medium-dark skin tone
        trie.insert(intArrayOf(128102, 127997), ParseResult(4, SpriteCoordinates(2, 0, 331, 859))) // boy: medium skin tone
        trie.insert(intArrayOf(129489, 127996), ParseResult(4, SpriteCoordinates(2, 0, 265, 397))) // person: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995), ParseResult(4, SpriteCoordinates(2, 0, 859, 793))) // man: light skin tone
        trie.insert(intArrayOf(129492, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 331, 199))) // man: beard
        trie.insert(intArrayOf(129492, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 331, 199))) // man: beard
        trie.insert(intArrayOf(129492, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 331, 265))) // woman: dark skin tone, beard
        trie.insert(intArrayOf(129492, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 331, 265))) // woman: dark skin tone, beard
        trie.insert(intArrayOf(128104, 127998, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 0, 859, 133))) // man: medium-dark skin tone, curly hair
        trie.insert(intArrayOf(128104, 127997, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 0, 859, 331))) // man: medium skin tone, bald
        trie.insert(intArrayOf(128105, 127996, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 0, 793, 529))) // woman: medium-light skin tone, red hair
        trie.insert(intArrayOf(128105, 127995, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 0, 67, 793))) // woman: light skin tone, curly hair
        trie.insert(intArrayOf(128105, 8205, 129459), ParseResult(5, SpriteCoordinates(2, 0, 331, 727))) // woman: white hair
        trie.insert(intArrayOf(129489, 127999, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 0, 397, 1))) // person: dark skin tone, white hair
        trie.insert(intArrayOf(129489, 127998, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 0, 397, 265))) // person: medium-dark skin tone, bald
        trie.insert(intArrayOf(128113, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 727, 529))) // man: medium skin tone, blond hair
        trie.insert(intArrayOf(128113, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 727, 529))) // man: medium skin tone, blond hair
        trie.insert(intArrayOf(128116, 127996), ParseResult(4, SpriteCoordinates(2, 0, 727, 331))) // old man: medium-light skin tone
        trie.insert(intArrayOf(128589, 127995), ParseResult(4, SpriteCoordinates(2, 0, 661, 133))) // person frowning: light skin tone
        trie.insert(intArrayOf(128589, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 0, 661, 67))) // woman frowning
        trie.insert(intArrayOf(128589, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 0, 661, 67))) // woman frowning
        trie.insert(intArrayOf(128590, 127999), ParseResult(4, SpriteCoordinates(2, 0, 595, 595))) // person pouting: dark skin tone
        trie.insert(intArrayOf(128590, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 661, 1))) // woman pouting: medium-dark skin tone
        trie.insert(intArrayOf(128590, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 661, 1))) // woman pouting: medium-dark skin tone
        trie.insert(intArrayOf(128581, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 661, 529))) // man gesturing NO: medium skin tone
        trie.insert(intArrayOf(128581, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 661, 529))) // man gesturing NO: medium skin tone
        trie.insert(intArrayOf(128582, 127996), ParseResult(4, SpriteCoordinates(2, 0, 661, 397))) // person gesturing OK: medium-light skin tone
        trie.insert(intArrayOf(128582, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 661, 463))) // woman gesturing OK: light skin tone
        trie.insert(intArrayOf(128582, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 661, 463))) // woman gesturing OK: light skin tone
        trie.insert(intArrayOf(128129, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 595, 661))) // man tipping hand
        trie.insert(intArrayOf(128129, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 595, 661))) // man tipping hand
        trie.insert(intArrayOf(128129, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 661, 661))) // woman tipping hand: dark skin tone
        trie.insert(intArrayOf(128129, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 661, 661))) // woman tipping hand: dark skin tone
        trie.insert(intArrayOf(128587, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 661, 265))) // man raising hand: medium-dark skin tone
        trie.insert(intArrayOf(128587, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 661, 265))) // man raising hand: medium-dark skin tone
        trie.insert(intArrayOf(129487, 127997), ParseResult(4, SpriteCoordinates(2, 0, 463, 397))) // deaf person: medium skin tone
        trie.insert(intArrayOf(129487, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 1, 463))) // deaf woman: medium-light skin tone
        trie.insert(intArrayOf(129487, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 1, 463))) // deaf woman: medium-light skin tone
        trie.insert(intArrayOf(128583, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 661, 331))) // man bowing: light skin tone
        trie.insert(intArrayOf(128583, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 661, 331))) // man bowing: light skin tone
        trie.insert(intArrayOf(129318), ParseResult(2, SpriteCoordinates(2, 0, 595, 133))) // person facepalming
        trie.insert(intArrayOf(129318, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 595, 199))) // man facepalming: dark skin tone
        trie.insert(intArrayOf(129318, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 595, 199))) // man facepalming: dark skin tone
        trie.insert(intArrayOf(129335, 127998), ParseResult(4, SpriteCoordinates(2, 0, 331, 529))) // person shrugging: medium-dark skin tone
        trie.insert(intArrayOf(129335, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 397, 529))) // woman shrugging: medium skin tone
        trie.insert(intArrayOf(129335, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 397, 529))) // woman shrugging: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 0, 859, 595))) // man health worker: medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 0, 859, 595))) // man health worker: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 0, 463, 331))) // student: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127891), ParseResult(5, SpriteCoordinates(2, 0, 463, 793))) // woman student
        trie.insert(intArrayOf(129489, 127999, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 0, 397, 133))) // teacher: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 0, 793, 1))) // woman teacher: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 0, 859, 265))) // man judge: medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 0, 859, 265))) // man judge: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 0, 463, 67))) // farmer: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 0, 331, 793))) // woman farmer: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127859), ParseResult(5, SpriteCoordinates(2, 0, 265, 859))) // man cook
        trie.insert(intArrayOf(128105, 127999, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 0, 529, 727))) // woman cook: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 0, 859, 199))) // man mechanic: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 0, 199, 397))) // factory worker: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 0, 793, 661))) // woman factory worker: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 0, 133, 859))) // man office worker: light skin tone
        trie.insert(intArrayOf(129489, 8205, 128300), ParseResult(5, SpriteCoordinates(2, 0, 133, 331))) // scientist
        trie.insert(intArrayOf(128104, 127999, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 0, 793, 793))) // man scientist: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 0, 397, 331))) // technologist: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 0, 793, 331))) // woman technologist: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 0, 859, 727))) // man singer: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 0, 463, 265))) // artist: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127912), ParseResult(5, SpriteCoordinates(2, 0, 397, 793))) // woman artist
        trie.insert(intArrayOf(129489, 127999, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 0, 265, 331))) // pilot: dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 0, 265, 331))) // pilot: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 0, 727, 727))) // woman pilot: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 0, 727, 727))) // woman pilot: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 0, 859, 463))) // man astronaut: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 0, 463, 1))) // firefighter: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 0, 265, 793))) // woman firefighter: light skin tone
        trie.insert(intArrayOf(128110, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 1, 727))) // man police officer
        trie.insert(intArrayOf(128110, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 1, 727))) // man police officer
        trie.insert(intArrayOf(128110, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 67, 727))) // woman police officer: dark skin tone
        trie.insert(intArrayOf(128110, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 67, 727))) // woman police officer: dark skin tone
        trie.insert(intArrayOf(128373, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 1, 661))) // man detective: medium-dark skin tone
        trie.insert(intArrayOf(128373, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 1, 661))) // man detective: medium-dark skin tone
        trie.insert(intArrayOf(128130, 127997), ParseResult(4, SpriteCoordinates(2, 0, 463, 661))) // guard: medium skin tone
        trie.insert(intArrayOf(128130, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 529, 661))) // woman guard: medium-light skin tone
        trie.insert(intArrayOf(128130, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 529, 661))) // woman guard: medium-light skin tone
        trie.insert(intArrayOf(128119, 127995), ParseResult(4, SpriteCoordinates(2, 0, 727, 199))) // construction worker: light skin tone
        trie.insert(intArrayOf(128119, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 0, 727, 133))) // woman construction worker
        trie.insert(intArrayOf(128119, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 0, 727, 133))) // woman construction worker
        trie.insert(intArrayOf(129733, 127999), ParseResult(4, SpriteCoordinates(2, 0, 67, 199))) // person with crown: dark skin tone
        trie.insert(intArrayOf(128120, 127998), ParseResult(4, SpriteCoordinates(2, 0, 727, 67))) // princess: medium-dark skin tone
        trie.insert(intArrayOf(128115, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 727, 397))) // man wearing turban: medium skin tone
        trie.insert(intArrayOf(128115, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 727, 397))) // man wearing turban: medium skin tone
        trie.insert(intArrayOf(128114, 127996), ParseResult(4, SpriteCoordinates(2, 0, 727, 463))) // person with skullcap: medium-light skin tone
        trie.insert(intArrayOf(129333, 127995), ParseResult(4, SpriteCoordinates(2, 0, 529, 529))) // person in tuxedo: light skin tone
        trie.insert(intArrayOf(129333, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 0, 463, 529))) // woman in tuxedo
        trie.insert(intArrayOf(129333, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 0, 463, 529))) // woman in tuxedo
        trie.insert(intArrayOf(128112, 127999), ParseResult(4, SpriteCoordinates(2, 0, 727, 595))) // person with veil: dark skin tone
        trie.insert(intArrayOf(128112, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 727, 661))) // woman with veil: medium-dark skin tone
        trie.insert(intArrayOf(128112, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 727, 661))) // woman with veil: medium-dark skin tone
        trie.insert(intArrayOf(129731, 127997), ParseResult(4, SpriteCoordinates(2, 0, 133, 199))) // pregnant man: medium skin tone
        trie.insert(intArrayOf(129329, 127996), ParseResult(4, SpriteCoordinates(2, 0, 595, 67))) // breast-feeding: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 0, 199, 859))) // man feeding baby: light skin tone
        trie.insert(intArrayOf(128124), ParseResult(2, SpriteCoordinates(2, 0, 727, 1))) // baby angel
        trie.insert(intArrayOf(127877, 127999), ParseResult(4, SpriteCoordinates(2, 0, 925, 595))) // Santa Claus: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127876), ParseResult(7, SpriteCoordinates(2, 0, 1, 397))) // Mx Claus: medium-dark skin tone
        trie.insert(intArrayOf(129464, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 529, 67))) // man superhero: medium skin tone
        trie.insert(intArrayOf(129464, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 529, 67))) // man superhero: medium skin tone
        trie.insert(intArrayOf(129465, 127996), ParseResult(4, SpriteCoordinates(2, 0, 463, 463))) // supervillain: medium-light skin tone
        trie.insert(intArrayOf(129465, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 529, 1))) // woman supervillain: light skin tone
        trie.insert(intArrayOf(129465, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 529, 1))) // woman supervillain: light skin tone
        trie.insert(intArrayOf(129497, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 133, 265))) // man mage
        trie.insert(intArrayOf(129497, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 133, 265))) // man mage
        trie.insert(intArrayOf(129497, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 199, 265))) // woman mage: dark skin tone
        trie.insert(intArrayOf(129497, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 199, 265))) // woman mage: dark skin tone
        trie.insert(intArrayOf(129498, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 67, 265))) // man fairy: medium-dark skin tone
        trie.insert(intArrayOf(129498, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 67, 265))) // man fairy: medium-dark skin tone
        trie.insert(intArrayOf(129499, 127997), ParseResult(4, SpriteCoordinates(2, 0, 265, 199))) // vampire: medium skin tone
        trie.insert(intArrayOf(129499, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 1, 265))) // woman vampire: medium-light skin tone
        trie.insert(intArrayOf(129499, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 1, 265))) // woman vampire: medium-light skin tone
        trie.insert(intArrayOf(129500, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 265, 133))) // merman: light skin tone
        trie.insert(intArrayOf(129500, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 265, 133))) // merman: light skin tone
        trie.insert(intArrayOf(129501), ParseResult(2, SpriteCoordinates(2, 0, 265, 1))) // elf
        trie.insert(intArrayOf(129501, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 265, 67))) // man elf: dark skin tone
        trie.insert(intArrayOf(129501, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 265, 67))) // man elf: dark skin tone
        trie.insert(intArrayOf(129503, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 199, 199))) // man zombie
        trie.insert(intArrayOf(129503, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 199, 199))) // man zombie
        trie.insert(intArrayOf(128134, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 331, 661))) // man getting massage: medium-light skin tone
        trie.insert(intArrayOf(128134, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 331, 661))) // man getting massage: medium-light skin tone
        trie.insert(intArrayOf(128135, 127995), ParseResult(4, SpriteCoordinates(2, 0, 265, 661))) // person getting haircut: light skin tone
        trie.insert(intArrayOf(128135, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 0, 199, 661))) // woman getting haircut
        trie.insert(intArrayOf(128135, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 0, 199, 661))) // woman getting haircut
        trie.insert(intArrayOf(128694, 127999), ParseResult(4, SpriteCoordinates(2, 0, 67, 595))) // person walking: dark skin tone
        trie.insert(intArrayOf(128694, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 133, 595))) // woman walking: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 133, 595))) // woman walking: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127997, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 0, 199, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 0, 199, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 199, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 199, 595))) // woman walking facing right
        trie.insert(intArrayOf(129485, 127996), ParseResult(4, SpriteCoordinates(2, 0, 265, 463))) // person standing: medium-light skin tone
        trie.insert(intArrayOf(129485, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 331, 463))) // woman standing: light skin tone
        trie.insert(intArrayOf(129485, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 331, 463))) // woman standing: light skin tone
        trie.insert(intArrayOf(129486, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 67, 463))) // man kneeling
        trie.insert(intArrayOf(129486, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 67, 463))) // man kneeling
        trie.insert(intArrayOf(129486, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 133, 463))) // woman kneeling: dark skin tone
        trie.insert(intArrayOf(129486, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 133, 463))) // woman kneeling: dark skin tone
    }

    private fun init2(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(129486, 127998, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 0, 199, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 199, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 0, 199, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 199, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 0, 67, 397))) // person with white cane: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 0, 859, 661))) // man with white cane: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 0, 133, 793))) // woman with white cane: light skin tone
        trie.insert(intArrayOf(129489, 8205, 129468), ParseResult(5, SpriteCoordinates(2, 0, 67, 331))) // person in motorized wheelchair
        trie.insert(intArrayOf(129489, 127999, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 331, 331))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127999, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 331, 331))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127998, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 859, 67))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127998, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 859, 67))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127997, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 793, 199))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127997, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 793, 199))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 397, 397))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 397, 397))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127995, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 67, 859))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127995, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 67, 859))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 8205, 129469, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 0, 265, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 8205, 129469, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 0, 265, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(127939, 127999), ParseResult(4, SpriteCoordinates(2, 0, 925, 331))) // person running: dark skin tone
        trie.insert(intArrayOf(127939, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 925, 397))) // woman running: medium-dark skin tone
        trie.insert(intArrayOf(127939, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 925, 397))) // woman running: medium-dark skin tone
        trie.insert(intArrayOf(127939, 127997, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 0, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 0, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 0, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 0, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(128131, 127996), ParseResult(4, SpriteCoordinates(2, 0, 397, 661))) // woman dancing: medium-light skin tone
        trie.insert(intArrayOf(128372, 127995), ParseResult(4, SpriteCoordinates(2, 0, 67, 661))) // person in suit levitating: light skin tone
        trie.insert(intArrayOf(129494, 127997), ParseResult(4, SpriteCoordinates(2, 0, 331, 67))) // person in steamy room: medium skin tone
        trie.insert(intArrayOf(129494, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 331, 133))) // woman in steamy room: medium-light skin tone
        trie.insert(intArrayOf(129494, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 331, 133))) // woman in steamy room: medium-light skin tone
        trie.insert(intArrayOf(129495, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 331, 1))) // man climbing: light skin tone
        trie.insert(intArrayOf(129495, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 331, 1))) // man climbing: light skin tone
        trie.insert(intArrayOf(129338), ParseResult(2, SpriteCoordinates(2, 0, 67, 529))) // person fencing
        trie.insert(intArrayOf(127938, 127997), ParseResult(4, SpriteCoordinates(2, 0, 925, 529))) // snowboarder: medium skin tone
        trie.insert(intArrayOf(127948, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 859, 859))) // man golfing: medium-light skin tone
        trie.insert(intArrayOf(127948, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 859, 859))) // man golfing: medium-light skin tone
        trie.insert(intArrayOf(127940, 127995), ParseResult(4, SpriteCoordinates(2, 0, 925, 265))) // person surfing: light skin tone
        trie.insert(intArrayOf(127940, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 0, 925, 199))) // woman surfing
        trie.insert(intArrayOf(127940, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 0, 925, 199))) // woman surfing
        trie.insert(intArrayOf(128675, 127999), ParseResult(4, SpriteCoordinates(2, 0, 463, 595))) // person rowing boat: dark skin tone
        trie.insert(intArrayOf(128675, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 529, 595))) // woman rowing boat: medium-dark skin tone
        trie.insert(intArrayOf(128675, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 529, 595))) // woman rowing boat: medium-dark skin tone
        trie.insert(intArrayOf(127946, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 925, 133))) // man swimming: medium skin tone
        trie.insert(intArrayOf(127946, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 925, 133))) // man swimming: medium skin tone
        trie.insert(intArrayOf(9977, 127996), ParseResult(3, SpriteCoordinates(2, 0, 133, 1))) // person bouncing ball: medium-light skin tone
        trie.insert(intArrayOf(9977, 127995, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 0, 133, 67))) // woman bouncing ball: light skin tone
        trie.insert(intArrayOf(9977, 127995, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 0, 133, 67))) // woman bouncing ball: light skin tone
        trie.insert(intArrayOf(127947, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 0, 925, 1))) // man lifting weights
        trie.insert(intArrayOf(127947, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 0, 925, 1))) // man lifting weights
        trie.insert(intArrayOf(127947, 65039, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 0, 925, 1))) // man lifting weights
        trie.insert(intArrayOf(127947, 65039, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 0, 925, 1))) // man lifting weights
        trie.insert(intArrayOf(127947, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 925, 67))) // woman lifting weights: dark skin tone
        trie.insert(intArrayOf(127947, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 925, 67))) // woman lifting weights: dark skin tone
        trie.insert(intArrayOf(128692, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 397, 595))) // man biking: medium-dark skin tone
        trie.insert(intArrayOf(128692, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 397, 595))) // man biking: medium-dark skin tone
        trie.insert(intArrayOf(128693, 127997), ParseResult(4, SpriteCoordinates(2, 0, 265, 595))) // person mountain biking: medium skin tone
        trie.insert(intArrayOf(128693, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 331, 595))) // woman mountain biking: medium-light skin tone
        trie.insert(intArrayOf(128693, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 331, 595))) // woman mountain biking: medium-light skin tone
        trie.insert(intArrayOf(129336, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 265, 529))) // man cartwheeling: light skin tone
        trie.insert(intArrayOf(129336, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 265, 529))) // man cartwheeling: light skin tone
        trie.insert(intArrayOf(129340), ParseResult(2, SpriteCoordinates(2, 0, 1, 529))) // people wrestling
        trie.insert(intArrayOf(129341, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 529, 463))) // man playing water polo: medium-light skin tone
        trie.insert(intArrayOf(129341, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 529, 463))) // man playing water polo: medium-light skin tone
        trie.insert(intArrayOf(129342, 127995), ParseResult(4, SpriteCoordinates(2, 0, 529, 397))) // person playing handball: light skin tone
        trie.insert(intArrayOf(129342, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 0, 529, 331))) // woman playing handball
        trie.insert(intArrayOf(129342, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 0, 529, 331))) // woman playing handball
        trie.insert(intArrayOf(129337, 127999), ParseResult(4, SpriteCoordinates(2, 0, 133, 529))) // person juggling: dark skin tone
        trie.insert(intArrayOf(129337, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 0, 199, 529))) // woman juggling: medium-dark skin tone
        trie.insert(intArrayOf(129337, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 0, 199, 529))) // woman juggling: medium-dark skin tone
        trie.insert(intArrayOf(129496, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 0, 265, 265))) // man in lotus position: medium skin tone
        trie.insert(intArrayOf(129496, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 0, 265, 265))) // man in lotus position: medium skin tone
        trie.insert(intArrayOf(128704, 127996), ParseResult(4, SpriteCoordinates(2, 0, 1, 595))) // person taking bath: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129309, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 0, 463, 199))) // people holding hands: light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129309, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 0, 133, 397))) // people holding hands: medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 129309, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 0, 397, 67))) // people holding hands: dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 0, 793, 595))) // women holding hands: medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128109, 127998), ParseResult(4, SpriteCoordinates(2, 0, 133, 727))) // women holding hands: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 0, 199, 793))) // woman and man holding hands: light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 0, 793, 265))) // woman and man holding hands: medium skin tone, dark skin tone
        trie.insert(intArrayOf(128108), ParseResult(2, SpriteCoordinates(2, 0, 199, 727))) // men holding hands
        trie.insert(intArrayOf(128104, 127997, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 0, 859, 397))) // men holding hands: medium skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 0, 727, 793))) // men holding hands: dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127997), ParseResult(14, SpriteCoordinates(2, 0, 463, 133))) // kiss: person, person, light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997), ParseResult(15, SpriteCoordinates(2, 0, 463, 133))) // kiss: person, person, light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127995), ParseResult(14, SpriteCoordinates(2, 0, 397, 199))) // kiss: person, person, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995), ParseResult(15, SpriteCoordinates(2, 0, 397, 199))) // kiss: person, person, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 0, 793, 727))) // kiss: woman, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 0, 793, 727))) // kiss: woman, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 0, 793, 67))) // kiss: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 0, 793, 67))) // kiss: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 0, 397, 727))) // kiss: woman, man, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 0, 397, 727))) // kiss: woman, man, dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 0, 859, 529))) // kiss: man, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 0, 859, 529))) // kiss: man, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 0, 661, 793))) // kiss: man, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 0, 661, 793))) // kiss: man, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995), ParseResult(15, SpriteCoordinates(2, 0, 793, 397))) // kiss: woman, woman, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127995), ParseResult(14, SpriteCoordinates(2, 0, 793, 397))) // kiss: woman, woman, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996), ParseResult(15, SpriteCoordinates(2, 0, 595, 727))) // kiss: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127996), ParseResult(14, SpriteCoordinates(2, 0, 595, 727))) // kiss: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128145, 127996), ParseResult(4, SpriteCoordinates(2, 0, 133, 661))) // couple with heart: medium-light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 129489, 127999), ParseResult(11, SpriteCoordinates(2, 0, 331, 397))) // couple with heart: person, person, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 0, 331, 397))) // couple with heart: person, person, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 129489, 127997), ParseResult(11, SpriteCoordinates(2, 0, 199, 331))) // couple with heart: person, person, dark skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 0, 199, 331))) // couple with heart: person, person, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 0, 793, 463))) // couple with heart: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 0, 793, 463))) // couple with heart: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 0, 661, 727))) // couple with heart: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 0, 661, 727))) // couple with heart: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 0, 1, 859))) // couple with heart: man, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 0, 1, 859))) // couple with heart: man, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 0, 859, 1))) // couple with heart: man, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 0, 859, 1))) // couple with heart: man, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128105, 127995), ParseResult(11, SpriteCoordinates(2, 0, 1, 793))) // couple with heart: woman, woman, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 0, 1, 793))) // couple with heart: woman, woman, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128105, 127996), ParseResult(11, SpriteCoordinates(2, 0, 793, 133))) // couple with heart: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 0, 793, 133))) // couple with heart: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 0, 463, 727))) // couple with heart: woman, woman, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128105, 127997), ParseResult(11, SpriteCoordinates(2, 0, 463, 727))) // couple with heart: woman, woman, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 8205, 128104, 8205, 128102, 8205, 128102), ParseResult(11, SpriteCoordinates(2, 0, 529, 793))) // family: man, man, boy, boy
        trie.insert(intArrayOf(128104, 8205, 128103, 8205, 128103), ParseResult(8, SpriteCoordinates(2, 0, 595, 793))) // family: man, girl, girl
        trie.insert(intArrayOf(129489, 8205, 129489, 8205, 129490), ParseResult(8, SpriteCoordinates(2, 0, 1, 331))) // family: adult, adult, child
        trie.insert(intArrayOf(128075, 127995), ParseResult(4, SpriteCoordinates(2, 1, 595, 859))) // waving hand: light skin tone
        trie.insert(intArrayOf(128400), ParseResult(2, SpriteCoordinates(2, 1, 661, 331))) // hand with fingers splayed
        trie.insert(intArrayOf(128400, 65039), ParseResult(3, SpriteCoordinates(2, 1, 661, 331))) // hand with fingers splayed
        trie.insert(intArrayOf(9995, 127999), ParseResult(3, SpriteCoordinates(2, 1, 1, 67))) // raised hand: dark skin tone
        trie.insert(intArrayOf(129777, 127998), ParseResult(4, SpriteCoordinates(2, 1, 199, 67))) // rightwards hand: medium-dark skin tone
        trie.insert(intArrayOf(129779, 127997), ParseResult(4, SpriteCoordinates(2, 1, 199, 1))) // palm down hand: medium skin tone
        trie.insert(intArrayOf(129783, 127996), ParseResult(4, SpriteCoordinates(2, 1, 67, 133))) // leftwards pushing hand: medium-light skin tone
        trie.insert(intArrayOf(128076, 127995), ParseResult(4, SpriteCoordinates(2, 1, 529, 859))) // OK hand: light skin tone
        trie.insert(intArrayOf(129295), ParseResult(2, SpriteCoordinates(2, 1, 595, 133))) // pinching hand
        trie.insert(intArrayOf(9996, 127999), ParseResult(3, SpriteCoordinates(2, 1, 67, 1))) // victory hand: dark skin tone
        trie.insert(intArrayOf(129776, 127998), ParseResult(4, SpriteCoordinates(2, 1, 1, 199))) // hand with index finger and thumb crossed: medium-dark skin tone
        trie.insert(intArrayOf(129304, 127997), ParseResult(4, SpriteCoordinates(2, 1, 595, 67))) // sign of the horns: medium skin tone
        trie.insert(intArrayOf(128072, 127996), ParseResult(4, SpriteCoordinates(2, 1, 661, 859))) // backhand index pointing left: medium-light skin tone
        trie.insert(intArrayOf(128070, 127995), ParseResult(4, SpriteCoordinates(2, 1, 793, 859))) // backhand index pointing up: light skin tone
        trie.insert(intArrayOf(128071), ParseResult(2, SpriteCoordinates(2, 1, 727, 859))) // backhand index pointing down
        trie.insert(intArrayOf(9757, 127999), ParseResult(3, SpriteCoordinates(2, 1, 1, 133))) // index pointing up: dark skin tone
        trie.insert(intArrayOf(128077, 127998), ParseResult(4, SpriteCoordinates(2, 1, 463, 859))) // thumbs up: medium-dark skin tone
        trie.insert(intArrayOf(9994, 127997), ParseResult(3, SpriteCoordinates(2, 1, 67, 67))) // raised fist: medium skin tone
        trie.insert(intArrayOf(129307, 127996), ParseResult(4, SpriteCoordinates(2, 1, 595, 1))) // left-facing fist: medium-light skin tone
        trie.insert(intArrayOf(128079, 127995), ParseResult(4, SpriteCoordinates(2, 1, 397, 859))) // clapping hands: light skin tone
        trie.insert(intArrayOf(129782), ParseResult(2, SpriteCoordinates(2, 1, 133, 133))) // heart hands
        trie.insert(intArrayOf(128080, 127999), ParseResult(4, SpriteCoordinates(2, 1, 331, 859))) // open hands: dark skin tone
        trie.insert(intArrayOf(129309, 127998), ParseResult(4, SpriteCoordinates(2, 1, 529, 529))) // handshake: medium-dark skin tone
        trie.insert(intArrayOf(129777, 127997, 8205, 129778, 127996), ParseResult(9, SpriteCoordinates(2, 1, 199, 133))) // handshake: medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128591), ParseResult(2, SpriteCoordinates(2, 1, 265, 595))) // folded hands
        trie.insert(intArrayOf(9997, 127999), ParseResult(3, SpriteCoordinates(2, 1, 1, 1))) // writing hand: dark skin tone
        trie.insert(intArrayOf(129331, 127998), ParseResult(4, SpriteCoordinates(2, 1, 265, 529))) // selfie: medium-dark skin tone
        trie.insert(intArrayOf(129461, 127995), ParseResult(4, SpriteCoordinates(2, 1, 331, 463))) // leg: light skin tone
        trie.insert(intArrayOf(128066), ParseResult(2, SpriteCoordinates(2, 1, 859, 859))) // ear
        trie.insert(intArrayOf(129467, 127999), ParseResult(4, SpriteCoordinates(2, 1, 67, 463))) // ear with hearing aid: dark skin tone
        trie.insert(intArrayOf(129460), ParseResult(2, SpriteCoordinates(2, 1, 397, 463))) // bone
        trie.insert(intArrayOf(128118, 127999), ParseResult(4, SpriteCoordinates(2, 1, 727, 1))) // baby: dark skin tone
        trie.insert(intArrayOf(128102, 127998), ParseResult(4, SpriteCoordinates(2, 1, 265, 859))) // boy: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997), ParseResult(4, SpriteCoordinates(2, 1, 397, 133))) // person: medium skin tone
        trie.insert(intArrayOf(128104, 127996), ParseResult(4, SpriteCoordinates(2, 1, 859, 661))) // man: medium-light skin tone
        trie.insert(intArrayOf(129492, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 331, 133))) // man: light skin tone, beard
        trie.insert(intArrayOf(129492, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 331, 133))) // man: light skin tone, beard
        trie.insert(intArrayOf(128104, 8205, 129456), ParseResult(5, SpriteCoordinates(2, 1, 463, 793))) // man: red hair
        trie.insert(intArrayOf(128104, 127999, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 1, 727, 793))) // man: dark skin tone, curly hair
        trie.insert(intArrayOf(128104, 127998, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 1, 859, 199))) // man: medium-dark skin tone, bald
        trie.insert(intArrayOf(128105, 127997, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 1, 793, 1))) // woman: medium skin tone, red hair
        trie.insert(intArrayOf(128105, 127996, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 1, 793, 265))) // woman: medium-light skin tone, curly hair
        trie.insert(intArrayOf(128105, 127995, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 1, 1, 793))) // woman: light skin tone, white hair
        trie.insert(intArrayOf(128105, 8205, 129458), ParseResult(5, SpriteCoordinates(2, 1, 727, 595))) // woman: bald
        trie.insert(intArrayOf(129489, 127999, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 1, 67, 331))) // person: dark skin tone, bald
        trie.insert(intArrayOf(128113, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 727, 265))) // man: medium-dark skin tone, blond hair
        trie.insert(intArrayOf(128113, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 727, 265))) // man: medium-dark skin tone, blond hair
        trie.insert(intArrayOf(128116, 127997), ParseResult(4, SpriteCoordinates(2, 1, 727, 67))) // old man: medium skin tone
        trie.insert(intArrayOf(128589, 127996), ParseResult(4, SpriteCoordinates(2, 1, 463, 595))) // person frowning: medium-light skin tone
        trie.insert(intArrayOf(128589, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 529, 595))) // woman frowning: light skin tone
        trie.insert(intArrayOf(128589, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 529, 595))) // woman frowning: light skin tone
        trie.insert(intArrayOf(128590, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 331, 595))) // man pouting
        trie.insert(intArrayOf(128590, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 331, 595))) // man pouting
        trie.insert(intArrayOf(128590, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 397, 595))) // woman pouting: dark skin tone
        trie.insert(intArrayOf(128590, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 397, 595))) // woman pouting: dark skin tone
        trie.insert(intArrayOf(128581, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 661, 265))) // man gesturing NO: medium-dark skin tone
        trie.insert(intArrayOf(128581, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 661, 265))) // man gesturing NO: medium-dark skin tone
        trie.insert(intArrayOf(128582, 127997), ParseResult(4, SpriteCoordinates(2, 1, 661, 133))) // person gesturing OK: medium skin tone
        trie.insert(intArrayOf(128582, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 661, 199))) // woman gesturing OK: medium-light skin tone
        trie.insert(intArrayOf(128582, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 661, 199))) // woman gesturing OK: medium-light skin tone
        trie.insert(intArrayOf(128129, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 397, 661))) // man tipping hand: light skin tone
        trie.insert(intArrayOf(128129, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 397, 661))) // man tipping hand: light skin tone
        trie.insert(intArrayOf(128587), ParseResult(2, SpriteCoordinates(2, 1, 595, 595))) // person raising hand
        trie.insert(intArrayOf(128587, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 661, 1))) // man raising hand: dark skin tone
        trie.insert(intArrayOf(128587, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 661, 1))) // man raising hand: dark skin tone
        trie.insert(intArrayOf(129487, 127998), ParseResult(4, SpriteCoordinates(2, 1, 463, 67))) // deaf person: medium-dark skin tone
        trie.insert(intArrayOf(129487, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 463, 133))) // deaf woman: medium skin tone
        trie.insert(intArrayOf(129487, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 463, 133))) // deaf woman: medium skin tone
        trie.insert(intArrayOf(128583, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 661, 67))) // man bowing: medium-light skin tone
        trie.insert(intArrayOf(128583, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 661, 67))) // man bowing: medium-light skin tone
        trie.insert(intArrayOf(129318, 127995), ParseResult(4, SpriteCoordinates(2, 1, 463, 529))) // person facepalming: light skin tone
        trie.insert(intArrayOf(129318, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 1, 397, 529))) // woman facepalming
        trie.insert(intArrayOf(129318, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 1, 397, 529))) // woman facepalming
        trie.insert(intArrayOf(129335, 127999), ParseResult(4, SpriteCoordinates(2, 1, 529, 397))) // person shrugging: dark skin tone
        trie.insert(intArrayOf(129335, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 529, 463))) // woman shrugging: medium-dark skin tone
        trie.insert(intArrayOf(129335, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 529, 463))) // woman shrugging: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 1, 859, 397))) // man health worker: medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 1, 859, 397))) // man health worker: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 1, 199, 397))) // student: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 1, 199, 793))) // woman student: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127979), ParseResult(5, SpriteCoordinates(2, 1, 199, 859))) // man teacher
        trie.insert(intArrayOf(128105, 127999, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 1, 265, 727))) // woman teacher: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 1, 859, 133))) // man judge: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 1, 859, 133))) // man judge: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 1, 67, 397))) // farmer: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 1, 793, 529))) // woman farmer: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 1, 133, 859))) // man cook: light skin tone
        trie.insert(intArrayOf(129489, 8205, 128295), ParseResult(5, SpriteCoordinates(2, 1, 331, 265))) // mechanic
        trie.insert(intArrayOf(128104, 127999, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 1, 859, 1))) // man mechanic: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 1, 397, 67))) // factory worker: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 1, 793, 67))) // woman factory worker: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 1, 1, 859))) // man office worker: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 1, 463, 1))) // scientist: light skin tone
        trie.insert(intArrayOf(128105, 8205, 128300), ParseResult(5, SpriteCoordinates(2, 1, 727, 661))) // woman scientist
        trie.insert(intArrayOf(129489, 127999, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 1, 199, 331))) // technologist: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 1, 595, 727))) // woman technologist: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 1, 859, 595))) // man singer: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 1, 133, 397))) // artist: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 1, 133, 793))) // woman artist: light skin tone
        trie.insert(intArrayOf(128104, 8205, 9992), ParseResult(4, SpriteCoordinates(2, 1, 331, 793))) // man pilot
        trie.insert(intArrayOf(128104, 8205, 9992, 65039), ParseResult(5, SpriteCoordinates(2, 1, 331, 793))) // man pilot
        trie.insert(intArrayOf(128105, 127999, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 1, 199, 727))) // woman pilot: dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 1, 199, 727))) // woman pilot: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 1, 859, 265))) // man astronaut: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 1, 1, 397))) // firefighter: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 1, 793, 463))) // woman firefighter: medium-light skin tone
        trie.insert(intArrayOf(128110, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 727, 463))) // man police officer: light skin tone
        trie.insert(intArrayOf(128110, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 727, 463))) // man police officer: light skin tone
        trie.insert(intArrayOf(128373), ParseResult(2, SpriteCoordinates(2, 1, 661, 397))) // detective
        trie.insert(intArrayOf(128373, 65039), ParseResult(3, SpriteCoordinates(2, 1, 661, 397))) // detective
        trie.insert(intArrayOf(128373, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 661, 463))) // man detective: dark skin tone
        trie.insert(intArrayOf(128373, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 661, 463))) // man detective: dark skin tone
        trie.insert(intArrayOf(128130, 127998), ParseResult(4, SpriteCoordinates(2, 1, 265, 661))) // guard: medium-dark skin tone
        trie.insert(intArrayOf(128130, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 331, 661))) // woman guard: medium skin tone
        trie.insert(intArrayOf(128130, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 331, 661))) // woman guard: medium skin tone
        trie.insert(intArrayOf(128119, 127996), ParseResult(4, SpriteCoordinates(2, 1, 595, 661))) // construction worker: medium-light skin tone
        trie.insert(intArrayOf(128119, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 661, 661))) // woman construction worker: light skin tone
        trie.insert(intArrayOf(128119, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 661, 661))) // woman construction worker: light skin tone
        trie.insert(intArrayOf(129332), ParseResult(2, SpriteCoordinates(2, 1, 199, 529))) // prince
        trie.insert(intArrayOf(128120, 127999), ParseResult(4, SpriteCoordinates(2, 1, 529, 661))) // princess: dark skin tone
        trie.insert(intArrayOf(128115, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 727, 133))) // man wearing turban: medium-dark skin tone
        trie.insert(intArrayOf(128115, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 727, 133))) // man wearing turban: medium-dark skin tone
        trie.insert(intArrayOf(128114, 127997), ParseResult(4, SpriteCoordinates(2, 1, 727, 199))) // person with skullcap: medium skin tone
        trie.insert(intArrayOf(129333, 127996), ParseResult(4, SpriteCoordinates(2, 1, 67, 529))) // person in tuxedo: medium-light skin tone
        trie.insert(intArrayOf(129333, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 133, 529))) // woman in tuxedo: light skin tone
        trie.insert(intArrayOf(129333, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 133, 529))) // woman in tuxedo: light skin tone
        trie.insert(intArrayOf(128112, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 727, 331))) // man with veil
        trie.insert(intArrayOf(128112, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 727, 331))) // man with veil
        trie.insert(intArrayOf(128112, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 727, 397))) // woman with veil: dark skin tone
        trie.insert(intArrayOf(128112, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 727, 397))) // woman with veil: dark skin tone
        trie.insert(intArrayOf(129731, 127998), ParseResult(4, SpriteCoordinates(2, 1, 67, 199))) // pregnant man: medium-dark skin tone
        trie.insert(intArrayOf(129329, 127997), ParseResult(4, SpriteCoordinates(2, 1, 331, 529))) // breast-feeding: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 1, 67, 859))) // man feeding baby: medium-light skin tone
        trie.insert(intArrayOf(128124, 127995), ParseResult(4, SpriteCoordinates(2, 1, 463, 661))) // baby angel: light skin tone
        trie.insert(intArrayOf(129334), ParseResult(2, SpriteCoordinates(2, 1, 1, 529))) // Mrs. Claus
        trie.insert(intArrayOf(129489, 127999, 8205, 127876), ParseResult(7, SpriteCoordinates(2, 1, 265, 331))) // Mx Claus: dark skin tone
        trie.insert(intArrayOf(129464, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 265, 463))) // man superhero: medium-dark skin tone
        trie.insert(intArrayOf(129464, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 265, 463))) // man superhero: medium-dark skin tone
        trie.insert(intArrayOf(129465, 127997), ParseResult(4, SpriteCoordinates(2, 1, 133, 463))) // supervillain: medium skin tone
        trie.insert(intArrayOf(129465, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 199, 463))) // woman supervillain: medium-light skin tone
        trie.insert(intArrayOf(129465, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 199, 463))) // woman supervillain: medium-light skin tone
        trie.insert(intArrayOf(129497, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 133, 265))) // man mage: light skin tone
        trie.insert(intArrayOf(129497, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 133, 265))) // man mage: light skin tone
        trie.insert(intArrayOf(129498), ParseResult(2, SpriteCoordinates(2, 1, 1, 265))) // fairy
        trie.insert(intArrayOf(129498, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 67, 265))) // man fairy: dark skin tone
        trie.insert(intArrayOf(129498, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 67, 265))) // man fairy: dark skin tone
        trie.insert(intArrayOf(129499, 127998), ParseResult(4, SpriteCoordinates(2, 1, 265, 133))) // vampire: medium-dark skin tone
        trie.insert(intArrayOf(129499, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 265, 199))) // woman vampire: medium skin tone
        trie.insert(intArrayOf(129499, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 265, 199))) // woman vampire: medium skin tone
        trie.insert(intArrayOf(129500, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 265, 67))) // merman: medium-light skin tone
        trie.insert(intArrayOf(129500, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 265, 67))) // merman: medium-light skin tone
        trie.insert(intArrayOf(129501, 127995), ParseResult(4, SpriteCoordinates(2, 1, 265, 1))) // elf: light skin tone
        trie.insert(intArrayOf(129501, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 1, 199, 199))) // woman elf
        trie.insert(intArrayOf(129501, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 1, 199, 199))) // woman elf
        trie.insert(intArrayOf(129503, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 1, 133, 199))) // woman zombie
        trie.insert(intArrayOf(129503, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 1, 133, 199))) // woman zombie
        trie.insert(intArrayOf(128134, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 133, 661))) // man getting massage: medium skin tone
        trie.insert(intArrayOf(128134, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 133, 661))) // man getting massage: medium skin tone
        trie.insert(intArrayOf(128135, 127996), ParseResult(4, SpriteCoordinates(2, 1, 1, 661))) // person getting haircut: medium-light skin tone
        trie.insert(intArrayOf(128135, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 67, 661))) // woman getting haircut: light skin tone
        trie.insert(intArrayOf(128135, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 67, 661))) // woman getting haircut: light skin tone
        trie.insert(intArrayOf(128694, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 595, 265))) // man walking
        trie.insert(intArrayOf(128694, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 595, 265))) // man walking
        trie.insert(intArrayOf(128694, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 595, 331))) // woman walking: dark skin tone
        trie.insert(intArrayOf(128694, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 595, 331))) // woman walking: dark skin tone
        trie.insert(intArrayOf(128694, 127998, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 595, 397))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 1, 595, 397))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 1, 595, 397))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 595, 397))) // woman walking facing right
        trie.insert(intArrayOf(129485, 127997), ParseResult(4, SpriteCoordinates(2, 1, 463, 397))) // person standing: medium skin tone
        trie.insert(intArrayOf(129485, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 1, 463))) // woman standing: medium-light skin tone
        trie.insert(intArrayOf(129485, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 1, 463))) // woman standing: medium-light skin tone
        trie.insert(intArrayOf(129486, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 463, 331))) // man kneeling: light skin tone
        trie.insert(intArrayOf(129486, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 463, 331))) // man kneeling: light skin tone
        trie.insert(intArrayOf(129486, 8205, 10145), ParseResult(4, SpriteCoordinates(2, 1, 463, 199))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 10145, 65039), ParseResult(5, SpriteCoordinates(2, 1, 463, 199))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 463, 265))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 1, 463, 265))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 463, 265))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 1, 463, 265))) // woman kneeling facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 1, 397, 1))) // person with white cane: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 1, 859, 463))) // man with white cane: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 1, 793, 331))) // woman with white cane: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 1, 331, 397))) // person in motorized wheelchair: light skin tone
        trie.insert(intArrayOf(128104, 8205, 129468), ParseResult(5, SpriteCoordinates(2, 1, 397, 793))) // man in motorized wheelchair
        trie.insert(intArrayOf(128104, 127999, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 661, 793))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127999, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 661, 793))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127998, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 397, 727))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127998, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 397, 727))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 397, 265))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 397, 265))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127996, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 859, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127996, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 859, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127995, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 793, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127995, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 793, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(127939, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 925, 397))) // man running
        trie.insert(intArrayOf(127939, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 925, 397))) // man running
        trie.insert(intArrayOf(127939, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 925, 463))) // woman running: dark skin tone
        trie.insert(intArrayOf(127939, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 925, 463))) // woman running: dark skin tone
        trie.insert(intArrayOf(127939, 127998, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 1, 925, 529))) // woman running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 1, 925, 529))) // woman running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 1, 925, 529))) // woman running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 1, 925, 529))) // woman running facing right
        trie.insert(intArrayOf(128131, 127997), ParseResult(4, SpriteCoordinates(2, 1, 199, 661))) // woman dancing: medium skin tone
        trie.insert(intArrayOf(128372, 127996), ParseResult(4, SpriteCoordinates(2, 1, 661, 529))) // person in suit levitating: medium-light skin tone
        trie.insert(intArrayOf(129494, 127998), ParseResult(4, SpriteCoordinates(2, 1, 331, 1))) // person in steamy room: medium-dark skin tone
        trie.insert(intArrayOf(129494, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 331, 67))) // woman in steamy room: medium skin tone
        trie.insert(intArrayOf(129494, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 331, 67))) // woman in steamy room: medium skin tone
        trie.insert(intArrayOf(129495, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 265, 265))) // man climbing: medium-light skin tone
        trie.insert(intArrayOf(129495, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 265, 265))) // man climbing: medium-light skin tone
        trie.insert(intArrayOf(127943), ParseResult(2, SpriteCoordinates(2, 1, 925, 199))) // horse racing
        trie.insert(intArrayOf(127938, 127998), ParseResult(4, SpriteCoordinates(2, 1, 925, 595))) // snowboarder: medium-dark skin tone
        trie.insert(intArrayOf(127948, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 925, 1))) // man golfing: medium skin tone
        trie.insert(intArrayOf(127948, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 925, 1))) // man golfing: medium skin tone
        trie.insert(intArrayOf(127940, 127996), ParseResult(4, SpriteCoordinates(2, 1, 925, 265))) // person surfing: medium-light skin tone
        trie.insert(intArrayOf(127940, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 925, 331))) // woman surfing: light skin tone
        trie.insert(intArrayOf(127940, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 925, 331))) // woman surfing: light skin tone
        trie.insert(intArrayOf(128675, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 133, 595))) // man rowing boat
        trie.insert(intArrayOf(128675, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 133, 595))) // man rowing boat
        trie.insert(intArrayOf(128675, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 199, 595))) // woman rowing boat: dark skin tone
        trie.insert(intArrayOf(128675, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 199, 595))) // woman rowing boat: dark skin tone
        trie.insert(intArrayOf(127946, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 925, 133))) // man swimming: medium-dark skin tone
        trie.insert(intArrayOf(127946, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 925, 133))) // man swimming: medium-dark skin tone
        trie.insert(intArrayOf(9977, 127997), ParseResult(3, SpriteCoordinates(2, 1, 133, 1))) // person bouncing ball: medium skin tone
        trie.insert(intArrayOf(9977, 127996, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 1, 133, 67))) // woman bouncing ball: medium-light skin tone
        trie.insert(intArrayOf(9977, 127996, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 1, 133, 67))) // woman bouncing ball: medium-light skin tone
        trie.insert(intArrayOf(127947, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 925, 67))) // man lifting weights: light skin tone
        trie.insert(intArrayOf(127947, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 925, 67))) // man lifting weights: light skin tone
        trie.insert(intArrayOf(128692), ParseResult(2, SpriteCoordinates(2, 1, 1, 595))) // person biking
        trie.insert(intArrayOf(128692, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 67, 595))) // man biking: dark skin tone
        trie.insert(intArrayOf(128692, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 67, 595))) // man biking: dark skin tone
        trie.insert(intArrayOf(128693, 127998), ParseResult(4, SpriteCoordinates(2, 1, 595, 463))) // person mountain biking: medium-dark skin tone
        trie.insert(intArrayOf(128693, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 595, 529))) // woman mountain biking: medium skin tone
        trie.insert(intArrayOf(128693, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 595, 529))) // woman mountain biking: medium skin tone
        trie.insert(intArrayOf(129336, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 529, 331))) // man cartwheeling: medium-light skin tone
        trie.insert(intArrayOf(129336, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 529, 331))) // man cartwheeling: medium-light skin tone
        trie.insert(intArrayOf(129340, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 529, 133))) // men wrestling
        trie.insert(intArrayOf(129340, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 529, 133))) // men wrestling
        trie.insert(intArrayOf(129341, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 529, 67))) // man playing water polo: medium skin tone
        trie.insert(intArrayOf(129341, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 529, 67))) // man playing water polo: medium skin tone
        trie.insert(intArrayOf(129342, 127996), ParseResult(4, SpriteCoordinates(2, 1, 463, 463))) // person playing handball: medium-light skin tone
        trie.insert(intArrayOf(129342, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 529, 1))) // woman playing handball: light skin tone
        trie.insert(intArrayOf(129342, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 529, 1))) // woman playing handball: light skin tone
        trie.insert(intArrayOf(129337, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 1, 529, 199))) // man juggling
        trie.insert(intArrayOf(129337, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 1, 529, 199))) // man juggling
        trie.insert(intArrayOf(129337, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 1, 529, 265))) // woman juggling: dark skin tone
        trie.insert(intArrayOf(129337, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 1, 529, 265))) // woman juggling: dark skin tone
        trie.insert(intArrayOf(129496, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 1, 199, 265))) // man in lotus position: medium-dark skin tone
        trie.insert(intArrayOf(129496, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 1, 199, 265))) // man in lotus position: medium-dark skin tone
        trie.insert(intArrayOf(128704, 127997), ParseResult(4, SpriteCoordinates(2, 1, 595, 199))) // person taking bath: medium skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129309, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 1, 397, 397))) // people holding hands: light skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129309, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 1, 397, 331))) // people holding hands: medium skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 129309, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 1, 133, 331))) // people holding hands: dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 1, 793, 397))) // women holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 1, 463, 727))) // women holding hands: medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 1, 67, 793))) // woman and man holding hands: light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 1, 529, 727))) // woman and man holding hands: medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128108, 127995), ParseResult(4, SpriteCoordinates(2, 1, 727, 529))) // men holding hands: light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 1, 859, 529))) // men holding hands: medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 1, 793, 793))) // men holding hands: dark skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127998), ParseResult(14, SpriteCoordinates(2, 1, 265, 397))) // kiss: person, person, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998), ParseResult(15, SpriteCoordinates(2, 1, 265, 397))) // kiss: person, person, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127996), ParseResult(14, SpriteCoordinates(2, 1, 331, 331))) // kiss: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996), ParseResult(15, SpriteCoordinates(2, 1, 331, 331))) // kiss: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 1, 793, 595))) // kiss: woman, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 1, 793, 595))) // kiss: woman, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 1, 661, 727))) // kiss: woman, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 1, 661, 727))) // kiss: woman, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 8205, 10084, 65039, 8205, 128139, 8205, 128104), ParseResult(11, SpriteCoordinates(2, 1, 265, 793))) // kiss: man, man
        trie.insert(intArrayOf(128104, 8205, 10084, 8205, 128139, 8205, 128104), ParseResult(10, SpriteCoordinates(2, 1, 265, 793))) // kiss: man, man
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 1, 859, 331))) // kiss: man, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 1, 859, 331))) // kiss: man, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 1, 595, 793))) // kiss: man, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 1, 595, 793))) // kiss: man, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996), ParseResult(15, SpriteCoordinates(2, 1, 793, 133))) // kiss: woman, woman, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127996), ParseResult(14, SpriteCoordinates(2, 1, 793, 133))) // kiss: woman, woman, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127997), ParseResult(14, SpriteCoordinates(2, 1, 331, 727))) // kiss: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997), ParseResult(15, SpriteCoordinates(2, 1, 331, 727))) // kiss: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128145, 127997), ParseResult(4, SpriteCoordinates(2, 1, 661, 595))) // couple with heart: medium skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 1, 397, 199))) // couple with heart: person, person, medium skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 129489, 127995), ParseResult(11, SpriteCoordinates(2, 1, 397, 199))) // couple with heart: person, person, medium skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 1, 1, 331))) // couple with heart: person, person, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 129489, 127998), ParseResult(11, SpriteCoordinates(2, 1, 1, 331))) // couple with heart: person, person, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 1, 793, 199))) // couple with heart: woman, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 1, 793, 199))) // couple with heart: woman, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 1, 133, 727))) // couple with heart: woman, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 1, 133, 727))) // couple with heart: woman, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 1, 859, 727))) // couple with heart: man, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 1, 859, 727))) // couple with heart: man, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 1, 859, 67))) // couple with heart: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 1, 859, 67))) // couple with heart: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 1, 793, 661))) // couple with heart: woman, woman, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128105, 127996), ParseResult(11, SpriteCoordinates(2, 1, 793, 661))) // couple with heart: woman, woman, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128105, 127997), ParseResult(11, SpriteCoordinates(2, 1, 727, 727))) // couple with heart: woman, woman, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 1, 727, 727))) // couple with heart: woman, woman, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 1, 67, 727))) // couple with heart: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128105, 127998), ParseResult(11, SpriteCoordinates(2, 1, 67, 727))) // couple with heart: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 8205, 128104, 8205, 128103, 8205, 128103), ParseResult(11, SpriteCoordinates(2, 1, 529, 793))) // family: man, man, girl, girl
        trie.insert(intArrayOf(128105, 8205, 128102), ParseResult(5, SpriteCoordinates(2, 1, 1, 727))) // family: woman, boy
        trie.insert(intArrayOf(129489, 8205, 129489, 8205, 129490, 8205, 129490), ParseResult(11, SpriteCoordinates(2, 1, 331, 199))) // family: adult, adult, child, child
        trie.insert(intArrayOf(128075, 127996), ParseResult(4, SpriteCoordinates(2, 2, 397, 859))) // waving hand: medium-light skin tone
        trie.insert(intArrayOf(128400, 127995), ParseResult(4, SpriteCoordinates(2, 2, 661, 199))) // hand with fingers splayed: light skin tone
        trie.insert(intArrayOf(128406), ParseResult(2, SpriteCoordinates(2, 2, 661, 133))) // vulcan salute
        trie.insert(intArrayOf(129777, 127999), ParseResult(4, SpriteCoordinates(2, 2, 67, 133))) // rightwards hand: dark skin tone
        trie.insert(intArrayOf(129779, 127998), ParseResult(4, SpriteCoordinates(2, 2, 1, 133))) // palm down hand: medium-dark skin tone
        trie.insert(intArrayOf(129783, 127997), ParseResult(4, SpriteCoordinates(2, 2, 67, 67))) // leftwards pushing hand: medium skin tone
        trie.insert(intArrayOf(128076, 127996), ParseResult(4, SpriteCoordinates(2, 2, 331, 859))) // OK hand: medium-light skin tone
        trie.insert(intArrayOf(129295, 127995), ParseResult(4, SpriteCoordinates(2, 2, 595, 1))) // pinching hand: light skin tone
        trie.insert(intArrayOf(129310), ParseResult(2, SpriteCoordinates(2, 2, 331, 529))) // crossed fingers
        trie.insert(intArrayOf(129776, 127999), ParseResult(4, SpriteCoordinates(2, 2, 199, 1))) // hand with index finger and thumb crossed: dark skin tone
        trie.insert(intArrayOf(129304, 127998), ParseResult(4, SpriteCoordinates(2, 2, 529, 529))) // sign of the horns: medium-dark skin tone
        trie.insert(intArrayOf(128072, 127997), ParseResult(4, SpriteCoordinates(2, 2, 463, 859))) // backhand index pointing left: medium skin tone
        trie.insert(intArrayOf(128070, 127996), ParseResult(4, SpriteCoordinates(2, 2, 595, 859))) // backhand index pointing up: medium-light skin tone
        trie.insert(intArrayOf(128071, 127995), ParseResult(4, SpriteCoordinates(2, 2, 529, 859))) // backhand index pointing down: light skin tone
        trie.insert(intArrayOf(129781), ParseResult(2, SpriteCoordinates(2, 2, 133, 67))) // index pointing at the viewer
        trie.insert(intArrayOf(128077, 127999), ParseResult(4, SpriteCoordinates(2, 2, 265, 859))) // thumbs up: dark skin tone
        trie.insert(intArrayOf(9994, 127998), ParseResult(3, SpriteCoordinates(2, 2, 1, 1))) // raised fist: medium-dark skin tone
        trie.insert(intArrayOf(129307, 127997), ParseResult(4, SpriteCoordinates(2, 2, 463, 529))) // left-facing fist: medium skin tone
        trie.insert(intArrayOf(128079, 127996), ParseResult(4, SpriteCoordinates(2, 2, 199, 859))) // clapping hands: medium-light skin tone
    }

    private fun init3(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(129782, 127995), ParseResult(4, SpriteCoordinates(2, 2, 133, 1))) // heart hands: light skin tone
        trie.insert(intArrayOf(129330), ParseResult(2, SpriteCoordinates(2, 2, 1, 529))) // palms up together
        trie.insert(intArrayOf(129309, 127999), ParseResult(4, SpriteCoordinates(2, 2, 397, 529))) // handshake: dark skin tone
        trie.insert(intArrayOf(129777, 127997, 8205, 129778, 127998), ParseResult(9, SpriteCoordinates(2, 2, 133, 133))) // handshake: medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128591, 127995), ParseResult(4, SpriteCoordinates(2, 2, 67, 595))) // folded hands: light skin tone
        trie.insert(intArrayOf(128133), ParseResult(2, SpriteCoordinates(2, 2, 67, 661))) // nail polish
        trie.insert(intArrayOf(129331, 127999), ParseResult(4, SpriteCoordinates(2, 2, 529, 463))) // selfie: dark skin tone
        trie.insert(intArrayOf(129461, 127996), ParseResult(4, SpriteCoordinates(2, 2, 133, 463))) // leg: medium-light skin tone
        trie.insert(intArrayOf(128066, 127995), ParseResult(4, SpriteCoordinates(2, 2, 727, 859))) // ear: light skin tone
        trie.insert(intArrayOf(128067), ParseResult(2, SpriteCoordinates(2, 2, 661, 859))) // nose
        trie.insert(intArrayOf(128064), ParseResult(2, SpriteCoordinates(2, 2, 793, 859))) // eyes
        trie.insert(intArrayOf(129490), ParseResult(2, SpriteCoordinates(2, 2, 331, 1))) // child
        trie.insert(intArrayOf(128102, 127999), ParseResult(4, SpriteCoordinates(2, 2, 133, 859))) // boy: dark skin tone
        trie.insert(intArrayOf(129489, 127998), ParseResult(4, SpriteCoordinates(2, 2, 133, 331))) // person: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997), ParseResult(4, SpriteCoordinates(2, 2, 859, 133))) // man: medium skin tone
        trie.insert(intArrayOf(129492, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 265, 265))) // man: medium-light skin tone, beard
        trie.insert(intArrayOf(129492, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 265, 265))) // man: medium-light skin tone, beard
        trie.insert(intArrayOf(128104, 127995, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 2, 859, 793))) // man: light skin tone, red hair
        trie.insert(intArrayOf(128104, 8205, 129459), ParseResult(5, SpriteCoordinates(2, 2, 265, 793))) // man: white hair
        trie.insert(intArrayOf(128104, 127999, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 2, 529, 793))) // man: dark skin tone, bald
        trie.insert(intArrayOf(128105, 127998, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 2, 529, 727))) // woman: medium-dark skin tone, red hair
        trie.insert(intArrayOf(128105, 127997, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 2, 793, 67))) // woman: medium skin tone, curly hair
        trie.insert(intArrayOf(128105, 127996, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 2, 793, 463))) // woman: medium-light skin tone, white hair
        trie.insert(intArrayOf(128105, 127995, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 2, 133, 793))) // woman: light skin tone, bald
        trie.insert(intArrayOf(128113, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 2, 727, 133))) // woman: blond hair
        trie.insert(intArrayOf(128113, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 2, 727, 133))) // woman: blond hair
        trie.insert(intArrayOf(128113, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 727, 199))) // man: dark skin tone, blond hair
        trie.insert(intArrayOf(128113, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 727, 199))) // man: dark skin tone, blond hair
        trie.insert(intArrayOf(128116, 127998), ParseResult(4, SpriteCoordinates(2, 2, 595, 661))) // old man: medium-dark skin tone
        trie.insert(intArrayOf(128589, 127997), ParseResult(4, SpriteCoordinates(2, 2, 199, 595))) // person frowning: medium skin tone
        trie.insert(intArrayOf(128589, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 265, 595))) // woman frowning: medium-light skin tone
        trie.insert(intArrayOf(128589, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 265, 595))) // woman frowning: medium-light skin tone
        trie.insert(intArrayOf(128590, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 133, 595))) // man pouting: light skin tone
        trie.insert(intArrayOf(128590, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 133, 595))) // man pouting: light skin tone
        trie.insert(intArrayOf(128581), ParseResult(2, SpriteCoordinates(2, 2, 661, 1))) // person gesturing NO
        trie.insert(intArrayOf(128581, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 661, 67))) // man gesturing NO: dark skin tone
        trie.insert(intArrayOf(128581, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 661, 67))) // man gesturing NO: dark skin tone
        trie.insert(intArrayOf(128582, 127998), ParseResult(4, SpriteCoordinates(2, 2, 529, 595))) // person gesturing OK: medium-dark skin tone
        trie.insert(intArrayOf(128582, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 595, 595))) // woman gesturing OK: medium skin tone
        trie.insert(intArrayOf(128582, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 595, 595))) // woman gesturing OK: medium skin tone
        trie.insert(intArrayOf(128129, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 331, 661))) // man tipping hand: medium-light skin tone
        trie.insert(intArrayOf(128129, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 331, 661))) // man tipping hand: medium-light skin tone
        trie.insert(intArrayOf(128587, 127995), ParseResult(4, SpriteCoordinates(2, 2, 397, 595))) // person raising hand: light skin tone
        trie.insert(intArrayOf(128587, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 2, 331, 595))) // woman raising hand
        trie.insert(intArrayOf(128587, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 2, 331, 595))) // woman raising hand
        trie.insert(intArrayOf(129487, 127999), ParseResult(4, SpriteCoordinates(2, 2, 265, 397))) // deaf person: dark skin tone
        trie.insert(intArrayOf(129487, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 331, 397))) // deaf woman: medium-dark skin tone
        trie.insert(intArrayOf(129487, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 331, 397))) // deaf woman: medium-dark skin tone
        trie.insert(intArrayOf(128583, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 595))) // man bowing: medium skin tone
        trie.insert(intArrayOf(128583, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 463, 595))) // man bowing: medium skin tone
        trie.insert(intArrayOf(129318, 127996), ParseResult(4, SpriteCoordinates(2, 2, 199, 529))) // person facepalming: medium-light skin tone
        trie.insert(intArrayOf(129318, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 265, 529))) // woman facepalming: light skin tone
        trie.insert(intArrayOf(129318, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 265, 529))) // woman facepalming: light skin tone
        trie.insert(intArrayOf(129335, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 2, 529, 67))) // man shrugging
        trie.insert(intArrayOf(129335, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 2, 529, 67))) // man shrugging
        trie.insert(intArrayOf(129335, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 529, 133))) // woman shrugging: dark skin tone
        trie.insert(intArrayOf(129335, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 529, 133))) // woman shrugging: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 2, 793, 793))) // man health worker: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 2, 793, 793))) // man health worker: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 2, 397, 265))) // student: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 2, 793, 727))) // woman student: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 2, 67, 859))) // man teacher: light skin tone
        trie.insert(intArrayOf(129489, 8205, 9878, 65039), ParseResult(5, SpriteCoordinates(2, 2, 331, 67))) // judge
        trie.insert(intArrayOf(129489, 8205, 9878), ParseResult(4, SpriteCoordinates(2, 2, 331, 67))) // judge
        trie.insert(intArrayOf(128104, 127999, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 793))) // man judge: dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 2, 463, 793))) // man judge: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 2, 397, 1))) // farmer: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 2, 793, 265))) // woman farmer: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 2, 859, 529))) // man cook: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 2, 199, 397))) // mechanic: light skin tone
        trie.insert(intArrayOf(128105, 8205, 128295), ParseResult(5, SpriteCoordinates(2, 2, 727, 595))) // woman mechanic
        trie.insert(intArrayOf(129489, 127999, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 2, 67, 331))) // factory worker: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 2, 661, 727))) // woman factory worker: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 2, 859, 331))) // man office worker: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 2, 1, 397))) // scientist: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 2, 199, 793))) // woman scientist: light skin tone
        trie.insert(intArrayOf(128104, 8205, 128187), ParseResult(5, SpriteCoordinates(2, 2, 331, 793))) // man technologist
        trie.insert(intArrayOf(128105, 127999, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 2, 331, 727))) // woman technologist: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 2, 859, 67))) // man singer: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 2, 397, 199))) // artist: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 2, 793, 661))) // woman artist: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 2, 859, 661))) // man pilot: light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 2, 859, 661))) // man pilot: light skin tone
        trie.insert(intArrayOf(129489, 8205, 128640), ParseResult(5, SpriteCoordinates(2, 2, 331, 199))) // astronaut
        trie.insert(intArrayOf(128104, 127999, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 2, 661, 793))) // man astronaut: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 2, 331, 331))) // firefighter: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 2, 793, 199))) // woman firefighter: medium skin tone
        trie.insert(intArrayOf(128110, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 727, 331))) // man police officer: medium-light skin tone
        trie.insert(intArrayOf(128110, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 727, 331))) // man police officer: medium-light skin tone
        trie.insert(intArrayOf(128373, 127995), ParseResult(4, SpriteCoordinates(2, 2, 661, 331))) // detective: light skin tone
        trie.insert(intArrayOf(128373, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 2, 661, 265))) // woman detective
        trie.insert(intArrayOf(128373, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 2, 661, 265))) // woman detective
        trie.insert(intArrayOf(128373, 65039, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 2, 661, 265))) // woman detective
        trie.insert(intArrayOf(128373, 65039, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 2, 661, 265))) // woman detective
        trie.insert(intArrayOf(128130, 127999), ParseResult(4, SpriteCoordinates(2, 2, 199, 661))) // guard: dark skin tone
        trie.insert(intArrayOf(128130, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 265, 661))) // woman guard: medium-dark skin tone
        trie.insert(intArrayOf(128130, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 265, 661))) // woman guard: medium-dark skin tone
        trie.insert(intArrayOf(128119, 127997), ParseResult(4, SpriteCoordinates(2, 2, 463, 661))) // construction worker: medium skin tone
        trie.insert(intArrayOf(128119, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 529, 661))) // woman construction worker: medium-light skin tone
        trie.insert(intArrayOf(128119, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 529, 661))) // woman construction worker: medium-light skin tone
        trie.insert(intArrayOf(129332, 127995), ParseResult(4, SpriteCoordinates(2, 2, 529, 397))) // prince: light skin tone
        trie.insert(intArrayOf(128115), ParseResult(2, SpriteCoordinates(2, 2, 661, 661))) // person wearing turban
        trie.insert(intArrayOf(128115, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 727, 1))) // man wearing turban: dark skin tone
        trie.insert(intArrayOf(128115, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 727, 1))) // man wearing turban: dark skin tone
        trie.insert(intArrayOf(128114, 127998), ParseResult(4, SpriteCoordinates(2, 2, 727, 67))) // person with skullcap: medium-dark skin tone
        trie.insert(intArrayOf(129333, 127997), ParseResult(4, SpriteCoordinates(2, 2, 529, 265))) // person in tuxedo: medium skin tone
        trie.insert(intArrayOf(129333, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 529, 331))) // woman in tuxedo: medium-light skin tone
        trie.insert(intArrayOf(129333, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 529, 331))) // woman in tuxedo: medium-light skin tone
        trie.insert(intArrayOf(128112, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 727, 265))) // man with veil: light skin tone
        trie.insert(intArrayOf(128112, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 727, 265))) // man with veil: light skin tone
        trie.insert(intArrayOf(129328), ParseResult(2, SpriteCoordinates(2, 2, 133, 529))) // pregnant woman
        trie.insert(intArrayOf(129731, 127999), ParseResult(4, SpriteCoordinates(2, 2, 199, 67))) // pregnant man: dark skin tone
        trie.insert(intArrayOf(129329, 127998), ParseResult(4, SpriteCoordinates(2, 2, 67, 529))) // breast-feeding: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 2, 859, 397))) // man feeding baby: medium skin tone
        trie.insert(intArrayOf(128124, 127996), ParseResult(4, SpriteCoordinates(2, 2, 397, 661))) // baby angel: medium-light skin tone
        trie.insert(intArrayOf(129334, 127995), ParseResult(4, SpriteCoordinates(2, 2, 529, 199))) // Mrs. Claus: light skin tone
        trie.insert(intArrayOf(129464), ParseResult(2, SpriteCoordinates(2, 2, 1, 463))) // superhero
        trie.insert(intArrayOf(129464, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 67, 463))) // man superhero: dark skin tone
        trie.insert(intArrayOf(129464, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 67, 463))) // man superhero: dark skin tone
        trie.insert(intArrayOf(129465, 127998), ParseResult(4, SpriteCoordinates(2, 2, 463, 331))) // supervillain: medium-dark skin tone
        trie.insert(intArrayOf(129465, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 463, 397))) // woman supervillain: medium skin tone
        trie.insert(intArrayOf(129465, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 397))) // woman supervillain: medium skin tone
        trie.insert(intArrayOf(129497, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 265, 133))) // man mage: medium-light skin tone
        trie.insert(intArrayOf(129497, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 265, 133))) // man mage: medium-light skin tone
        trie.insert(intArrayOf(129498, 127995), ParseResult(4, SpriteCoordinates(2, 2, 265, 67))) // fairy: light skin tone
        trie.insert(intArrayOf(129498, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 2, 265, 1))) // woman fairy
        trie.insert(intArrayOf(129498, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 2, 265, 1))) // woman fairy
        trie.insert(intArrayOf(129499, 127999), ParseResult(4, SpriteCoordinates(2, 2, 133, 199))) // vampire: dark skin tone
        trie.insert(intArrayOf(129499, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 199, 199))) // woman vampire: medium-dark skin tone
        trie.insert(intArrayOf(129499, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 199, 199))) // woman vampire: medium-dark skin tone
        trie.insert(intArrayOf(129500, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 67, 199))) // merman: medium skin tone
        trie.insert(intArrayOf(129500, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 67, 199))) // merman: medium skin tone
        trie.insert(intArrayOf(129501, 127996), ParseResult(4, SpriteCoordinates(2, 2, 199, 133))) // elf: medium-light skin tone
        trie.insert(intArrayOf(129501, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 1, 199))) // woman elf: light skin tone
        trie.insert(intArrayOf(129501, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 1, 199))) // woman elf: light skin tone
        trie.insert(intArrayOf(129484), ParseResult(2, SpriteCoordinates(2, 2, 463, 265))) // troll
        trie.insert(intArrayOf(128134, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 1, 661))) // man getting massage: medium-dark skin tone
        trie.insert(intArrayOf(128134, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 1, 661))) // man getting massage: medium-dark skin tone
        trie.insert(intArrayOf(128135, 127997), ParseResult(4, SpriteCoordinates(2, 2, 661, 529))) // person getting haircut: medium skin tone
        trie.insert(intArrayOf(128135, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 661, 595))) // woman getting haircut: medium-light skin tone
        trie.insert(intArrayOf(128135, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 661, 595))) // woman getting haircut: medium-light skin tone
        trie.insert(intArrayOf(128694, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 595, 265))) // man walking: light skin tone
        trie.insert(intArrayOf(128694, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 595, 265))) // man walking: light skin tone
        trie.insert(intArrayOf(128694, 8205, 10145), ParseResult(4, SpriteCoordinates(2, 2, 595, 133))) // person walking facing right
        trie.insert(intArrayOf(128694, 8205, 10145, 65039), ParseResult(5, SpriteCoordinates(2, 2, 595, 133))) // person walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 2, 595, 199))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 2, 595, 199))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 2, 595, 199))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 2, 595, 199))) // woman walking facing right
        trie.insert(intArrayOf(129485, 127998), ParseResult(4, SpriteCoordinates(2, 2, 463, 133))) // person standing: medium-dark skin tone
        trie.insert(intArrayOf(129485, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 199))) // woman standing: medium skin tone
        trie.insert(intArrayOf(129485, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 463, 199))) // woman standing: medium skin tone
        trie.insert(intArrayOf(129486, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 463, 1))) // man kneeling: medium-light skin tone
        trie.insert(intArrayOf(129486, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 1))) // man kneeling: medium-light skin tone
        trie.insert(intArrayOf(129486, 127995, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 2, 463, 67))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 67))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9794, 65039, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 2, 397, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 2, 397, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9794, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 2, 397, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9794, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 2, 397, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129489, 127999, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 2, 331, 265))) // person with white cane: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 2, 859, 1))) // man with white cane: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 2, 793, 133))) // woman with white cane: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 2, 397, 331))) // person in motorized wheelchair: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 2, 859, 727))) // man in motorized wheelchair: light skin tone
        trie.insert(intArrayOf(128105, 8205, 129468), ParseResult(5, SpriteCoordinates(2, 2, 727, 529))) // woman in motorized wheelchair
        trie.insert(intArrayOf(128105, 127999, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 2, 199, 727))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127999, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 2, 199, 727))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 2, 265, 331))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 2, 265, 331))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127997, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 2, 859, 265))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127997, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 2, 859, 265))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127996, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 2, 793, 397))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127996, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 2, 793, 397))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 925, 529))) // man running: light skin tone
        trie.insert(intArrayOf(127939, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 925, 529))) // man running: light skin tone
        trie.insert(intArrayOf(127939, 8205, 10145), ParseResult(4, SpriteCoordinates(2, 2, 925, 397))) // person running facing right
        trie.insert(intArrayOf(127939, 8205, 10145, 65039), ParseResult(5, SpriteCoordinates(2, 2, 925, 397))) // person running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 2, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 2, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 2, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 2, 925, 463))) // woman running facing right
        trie.insert(intArrayOf(128131, 127998), ParseResult(4, SpriteCoordinates(2, 2, 133, 661))) // woman dancing: medium-dark skin tone
        trie.insert(intArrayOf(128372, 127997), ParseResult(4, SpriteCoordinates(2, 2, 661, 397))) // person in suit levitating: medium skin tone
        trie.insert(intArrayOf(129494, 127999), ParseResult(4, SpriteCoordinates(2, 2, 133, 265))) // person in steamy room: dark skin tone
        trie.insert(intArrayOf(129494, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 199, 265))) // woman in steamy room: medium-dark skin tone
        trie.insert(intArrayOf(129494, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 199, 265))) // woman in steamy room: medium-dark skin tone
        trie.insert(intArrayOf(129495, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 67, 265))) // man climbing: medium skin tone
        trie.insert(intArrayOf(129495, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 67, 265))) // man climbing: medium skin tone
        trie.insert(intArrayOf(127943, 127995), ParseResult(4, SpriteCoordinates(2, 2, 925, 199))) // horse racing: light skin tone
        trie.insert(intArrayOf(127938, 127999), ParseResult(4, SpriteCoordinates(2, 2, 925, 595))) // snowboarder: dark skin tone
        trie.insert(intArrayOf(127948, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 859, 859))) // man golfing: medium-dark skin tone
        trie.insert(intArrayOf(127948, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 859, 859))) // man golfing: medium-dark skin tone
        trie.insert(intArrayOf(127940, 127997), ParseResult(4, SpriteCoordinates(2, 2, 925, 265))) // person surfing: medium skin tone
        trie.insert(intArrayOf(127940, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 925, 331))) // woman surfing: medium-light skin tone
        trie.insert(intArrayOf(127940, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 925, 331))) // woman surfing: medium-light skin tone
        trie.insert(intArrayOf(128675, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 1, 595))) // man rowing boat: light skin tone
        trie.insert(intArrayOf(128675, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 1, 595))) // man rowing boat: light skin tone
        trie.insert(intArrayOf(127946), ParseResult(2, SpriteCoordinates(2, 2, 925, 67))) // person swimming
        trie.insert(intArrayOf(127946, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 925, 133))) // man swimming: dark skin tone
        trie.insert(intArrayOf(127946, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 925, 133))) // man swimming: dark skin tone
        trie.insert(intArrayOf(9977, 127998), ParseResult(3, SpriteCoordinates(2, 2, 67, 1))) // person bouncing ball: medium-dark skin tone
        trie.insert(intArrayOf(9977, 127997, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 2, 1, 67))) // woman bouncing ball: medium skin tone
        trie.insert(intArrayOf(9977, 127997, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 2, 1, 67))) // woman bouncing ball: medium skin tone
        trie.insert(intArrayOf(127947, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 925, 1))) // man lifting weights: medium-light skin tone
        trie.insert(intArrayOf(127947, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 925, 1))) // man lifting weights: medium-light skin tone
        trie.insert(intArrayOf(128692, 127995), ParseResult(4, SpriteCoordinates(2, 2, 595, 529))) // person biking: light skin tone
        trie.insert(intArrayOf(128692, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 2, 595, 463))) // woman biking
        trie.insert(intArrayOf(128692, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 2, 595, 463))) // woman biking
        trie.insert(intArrayOf(128693, 127999), ParseResult(4, SpriteCoordinates(2, 2, 595, 331))) // person mountain biking: dark skin tone
        trie.insert(intArrayOf(128693, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 595, 397))) // woman mountain biking: medium-dark skin tone
        trie.insert(intArrayOf(128693, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 595, 397))) // woman mountain biking: medium-dark skin tone
        trie.insert(intArrayOf(129336, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 529, 1))) // man cartwheeling: medium skin tone
        trie.insert(intArrayOf(129336, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 529, 1))) // man cartwheeling: medium skin tone
        trie.insert(intArrayOf(129340, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 2, 397, 463))) // women wrestling
        trie.insert(intArrayOf(129340, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 2, 397, 463))) // women wrestling
        trie.insert(intArrayOf(129341, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 331, 463))) // man playing water polo: medium-dark skin tone
        trie.insert(intArrayOf(129341, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 331, 463))) // man playing water polo: medium-dark skin tone
        trie.insert(intArrayOf(129342, 127997), ParseResult(4, SpriteCoordinates(2, 2, 199, 463))) // person playing handball: medium skin tone
        trie.insert(intArrayOf(129342, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 2, 265, 463))) // woman playing handball: medium-light skin tone
        trie.insert(intArrayOf(129342, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 2, 265, 463))) // woman playing handball: medium-light skin tone
        trie.insert(intArrayOf(129337, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 463, 463))) // man juggling: light skin tone
        trie.insert(intArrayOf(129337, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 463, 463))) // man juggling: light skin tone
        trie.insert(intArrayOf(129496), ParseResult(2, SpriteCoordinates(2, 2, 265, 199))) // person in lotus position
        trie.insert(intArrayOf(129496, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 2, 1, 265))) // man in lotus position: dark skin tone
        trie.insert(intArrayOf(129496, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 2, 1, 265))) // man in lotus position: dark skin tone
        trie.insert(intArrayOf(128704, 127998), ParseResult(4, SpriteCoordinates(2, 2, 595, 67))) // person taking bath: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129309, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 2, 133, 397))) // people holding hands: light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129309, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 2, 397, 133))) // people holding hands: medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 129309, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 2, 1, 331))) // people holding hands: dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 2, 793, 529))) // women holding hands: medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 2, 265, 727))) // women holding hands: dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 2, 793, 595))) // woman and man holding hands: medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 2, 595, 727))) // woman and man holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 2, 1, 859))) // men holding hands: light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128108, 127997), ParseResult(4, SpriteCoordinates(2, 2, 727, 397))) // men holding hands: medium skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 2, 595, 793))) // men holding hands: dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999), ParseResult(15, SpriteCoordinates(2, 2, 67, 397))) // kiss: person, person, light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127999), ParseResult(14, SpriteCoordinates(2, 2, 67, 397))) // kiss: person, person, light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997), ParseResult(15, SpriteCoordinates(2, 2, 199, 331))) // kiss: person, person, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127997), ParseResult(14, SpriteCoordinates(2, 2, 199, 331))) // kiss: person, person, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 2, 1, 793))) // kiss: woman, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 2, 1, 793))) // kiss: woman, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 2, 463, 727))) // kiss: woman, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 2, 463, 727))) // kiss: woman, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 2, 859, 595))) // kiss: man, man, light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 2, 859, 595))) // kiss: man, man, light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 2, 859, 199))) // kiss: man, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 2, 859, 199))) // kiss: man, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 2, 397, 793))) // kiss: man, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 2, 397, 793))) // kiss: man, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997), ParseResult(15, SpriteCoordinates(2, 2, 793, 331))) // kiss: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127997), ParseResult(14, SpriteCoordinates(2, 2, 793, 331))) // kiss: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998), ParseResult(15, SpriteCoordinates(2, 2, 397, 727))) // kiss: woman, woman, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127998), ParseResult(14, SpriteCoordinates(2, 2, 397, 727))) // kiss: woman, woman, medium-dark skin tone
        trie.insert(intArrayOf(128145, 127998), ParseResult(4, SpriteCoordinates(2, 2, 661, 463))) // couple with heart: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 129489, 127996), ParseResult(11, SpriteCoordinates(2, 2, 397, 67))) // couple with heart: person, person, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 2, 397, 67))) // couple with heart: person, person, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 8205, 10084, 8205, 128104), ParseResult(7, SpriteCoordinates(2, 2, 727, 463))) // couple with heart: woman, man
        trie.insert(intArrayOf(128105, 8205, 10084, 65039, 8205, 128104), ParseResult(8, SpriteCoordinates(2, 2, 727, 463))) // couple with heart: woman, man
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 2, 793, 1))) // couple with heart: woman, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 2, 793, 1))) // couple with heart: woman, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 2, 133, 727))) // couple with heart: woman, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 2, 133, 727))) // couple with heart: woman, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 2, 859, 463))) // couple with heart: man, man, medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 2, 859, 463))) // couple with heart: man, man, medium-light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 2, 727, 793))) // couple with heart: man, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 2, 727, 793))) // couple with heart: man, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 2, 67, 793))) // couple with heart: woman, woman, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128105, 127997), ParseResult(11, SpriteCoordinates(2, 2, 67, 793))) // couple with heart: woman, woman, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128105, 127998), ParseResult(11, SpriteCoordinates(2, 2, 727, 727))) // couple with heart: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 2, 727, 727))) // couple with heart: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128105, 127999), ParseResult(11, SpriteCoordinates(2, 2, 67, 727))) // couple with heart: woman, woman, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 2, 67, 727))) // couple with heart: woman, woman, dark skin tone
        trie.insert(intArrayOf(128105, 8205, 128105, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 2, 727, 661))) // family: woman, woman, boy
        trie.insert(intArrayOf(128105, 8205, 128102, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 2, 1, 727))) // family: woman, boy, boy
        trie.insert(intArrayOf(129489, 8205, 129490), ParseResult(5, SpriteCoordinates(2, 2, 331, 133))) // family: adult, child
        trie.insert(intArrayOf(128075, 127997), ParseResult(4, SpriteCoordinates(2, 3, 397, 859))) // waving hand: medium skin tone
        trie.insert(intArrayOf(128400, 127996), ParseResult(4, SpriteCoordinates(2, 3, 661, 133))) // hand with fingers splayed: medium-light skin tone
        trie.insert(intArrayOf(128406, 127995), ParseResult(4, SpriteCoordinates(2, 3, 661, 67))) // vulcan salute: light skin tone
        trie.insert(intArrayOf(129778), ParseResult(2, SpriteCoordinates(2, 3, 67, 133))) // leftwards hand
        trie.insert(intArrayOf(129779, 127999), ParseResult(4, SpriteCoordinates(2, 3, 1, 133))) // palm down hand: dark skin tone
        trie.insert(intArrayOf(129783, 127998), ParseResult(4, SpriteCoordinates(2, 3, 67, 67))) // leftwards pushing hand: medium-dark skin tone
        trie.insert(intArrayOf(128076, 127997), ParseResult(4, SpriteCoordinates(2, 3, 331, 859))) // OK hand: medium skin tone
        trie.insert(intArrayOf(129295, 127996), ParseResult(4, SpriteCoordinates(2, 3, 529, 529))) // pinching hand: medium-light skin tone
        trie.insert(intArrayOf(129310, 127995), ParseResult(4, SpriteCoordinates(2, 3, 331, 529))) // crossed fingers: light skin tone
        trie.insert(intArrayOf(129311), ParseResult(2, SpriteCoordinates(2, 3, 265, 529))) // love-you gesture
        trie.insert(intArrayOf(129304, 127999), ParseResult(4, SpriteCoordinates(2, 3, 463, 529))) // sign of the horns: dark skin tone
        trie.insert(intArrayOf(128072, 127998), ParseResult(4, SpriteCoordinates(2, 3, 463, 859))) // backhand index pointing left: medium-dark skin tone
        trie.insert(intArrayOf(128070, 127997), ParseResult(4, SpriteCoordinates(2, 3, 595, 859))) // backhand index pointing up: medium skin tone
        trie.insert(intArrayOf(128071, 127996), ParseResult(4, SpriteCoordinates(2, 3, 529, 859))) // backhand index pointing down: medium-light skin tone
        trie.insert(intArrayOf(129781, 127995), ParseResult(4, SpriteCoordinates(2, 3, 133, 67))) // index pointing at the viewer: light skin tone
        trie.insert(intArrayOf(128078), ParseResult(2, SpriteCoordinates(2, 3, 265, 859))) // thumbs down
        trie.insert(intArrayOf(9994, 127999), ParseResult(3, SpriteCoordinates(2, 3, 1, 1))) // raised fist: dark skin tone
        trie.insert(intArrayOf(129307, 127998), ParseResult(4, SpriteCoordinates(2, 3, 397, 529))) // left-facing fist: medium-dark skin tone
        trie.insert(intArrayOf(128079, 127997), ParseResult(4, SpriteCoordinates(2, 3, 199, 859))) // clapping hands: medium skin tone
        trie.insert(intArrayOf(129782, 127996), ParseResult(4, SpriteCoordinates(2, 3, 133, 1))) // heart hands: medium-light skin tone
        trie.insert(intArrayOf(129330, 127995), ParseResult(4, SpriteCoordinates(2, 3, 529, 463))) // palms up together: light skin tone
        trie.insert(intArrayOf(129777, 127995, 8205, 129778, 127996), ParseResult(9, SpriteCoordinates(2, 3, 199, 1))) // handshake: light skin tone, medium-light skin tone
        trie.insert(intArrayOf(129777, 127997, 8205, 129778, 127999), ParseResult(9, SpriteCoordinates(2, 3, 133, 133))) // handshake: medium skin tone, dark skin tone
        trie.insert(intArrayOf(128591, 127996), ParseResult(4, SpriteCoordinates(2, 3, 1, 595))) // folded hands: medium-light skin tone
        trie.insert(intArrayOf(128133, 127995), ParseResult(4, SpriteCoordinates(2, 3, 133, 661))) // nail polish: light skin tone
        trie.insert(intArrayOf(128170), ParseResult(2, SpriteCoordinates(2, 3, 661, 397))) // flexed biceps
        trie.insert(intArrayOf(129461, 127997), ParseResult(4, SpriteCoordinates(2, 3, 199, 463))) // leg: medium skin tone
        trie.insert(intArrayOf(128066, 127996), ParseResult(4, SpriteCoordinates(2, 3, 727, 859))) // ear: medium-light skin tone
        trie.insert(intArrayOf(128067, 127995), ParseResult(4, SpriteCoordinates(2, 3, 661, 859))) // nose: light skin tone
        trie.insert(intArrayOf(128065), ParseResult(2, SpriteCoordinates(2, 3, 793, 859))) // eye
        trie.insert(intArrayOf(128065, 65039), ParseResult(3, SpriteCoordinates(2, 3, 793, 859))) // eye
        trie.insert(intArrayOf(129490, 127995), ParseResult(4, SpriteCoordinates(2, 3, 331, 67))) // child: light skin tone
        trie.insert(intArrayOf(128103), ParseResult(2, SpriteCoordinates(2, 3, 133, 859))) // girl
        trie.insert(intArrayOf(129489, 127999), ParseResult(4, SpriteCoordinates(2, 3, 67, 331))) // person: dark skin tone
        trie.insert(intArrayOf(128104, 127998), ParseResult(4, SpriteCoordinates(2, 3, 661, 793))) // man: medium-dark skin tone
        trie.insert(intArrayOf(129492, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 265, 265))) // man: medium skin tone, beard
        trie.insert(intArrayOf(129492, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 265, 265))) // man: medium skin tone, beard
        trie.insert(intArrayOf(128104, 127996, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 3, 859, 529))) // man: medium-light skin tone, red hair
        trie.insert(intArrayOf(128104, 127995, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 3, 859, 727))) // man: light skin tone, white hair
        trie.insert(intArrayOf(128105), ParseResult(2, SpriteCoordinates(2, 3, 727, 595))) // woman
        trie.insert(intArrayOf(128105, 127999, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 3, 265, 727))) // woman: dark skin tone, red hair
        trie.insert(intArrayOf(128105, 127998, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 3, 595, 727))) // woman: medium-dark skin tone, curly hair
        trie.insert(intArrayOf(128105, 127997, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 3, 793, 331))) // woman: medium skin tone, white hair
        trie.insert(intArrayOf(128105, 127996, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 3, 793, 727))) // woman: medium-light skin tone, bald
        trie.insert(intArrayOf(128113, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 727, 199))) // woman: light skin tone, blond hair
        trie.insert(intArrayOf(128113, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 727, 199))) // woman: light skin tone, blond hair
        trie.insert(intArrayOf(129491), ParseResult(2, SpriteCoordinates(2, 3, 331, 1))) // older person
        trie.insert(intArrayOf(128116, 127999), ParseResult(4, SpriteCoordinates(2, 3, 661, 661))) // old man: dark skin tone
        trie.insert(intArrayOf(128589, 127998), ParseResult(4, SpriteCoordinates(2, 3, 133, 595))) // person frowning: medium-dark skin tone
        trie.insert(intArrayOf(128589, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 199, 595))) // woman frowning: medium skin tone
        trie.insert(intArrayOf(128589, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 199, 595))) // woman frowning: medium skin tone
        trie.insert(intArrayOf(128590, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 67, 595))) // man pouting: medium-light skin tone
        trie.insert(intArrayOf(128590, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 67, 595))) // man pouting: medium-light skin tone
        trie.insert(intArrayOf(128581, 127995), ParseResult(4, SpriteCoordinates(2, 3, 661, 1))) // person gesturing NO: light skin tone
        trie.insert(intArrayOf(128581, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 3, 595, 595))) // woman gesturing NO
        trie.insert(intArrayOf(128581, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 3, 595, 595))) // woman gesturing NO
        trie.insert(intArrayOf(128582, 127999), ParseResult(4, SpriteCoordinates(2, 3, 463, 595))) // person gesturing OK: dark skin tone
        trie.insert(intArrayOf(128582, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 529, 595))) // woman gesturing OK: medium-dark skin tone
        trie.insert(intArrayOf(128582, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 529, 595))) // woman gesturing OK: medium-dark skin tone
        trie.insert(intArrayOf(128129, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 397, 661))) // man tipping hand: medium skin tone
        trie.insert(intArrayOf(128129, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 397, 661))) // man tipping hand: medium skin tone
        trie.insert(intArrayOf(128587, 127996), ParseResult(4, SpriteCoordinates(2, 3, 265, 595))) // person raising hand: medium-light skin tone
        trie.insert(intArrayOf(128587, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 331, 595))) // woman raising hand: light skin tone
        trie.insert(intArrayOf(128587, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 331, 595))) // woman raising hand: light skin tone
        trie.insert(intArrayOf(129487, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 3, 397, 397))) // deaf man
        trie.insert(intArrayOf(129487, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 3, 397, 397))) // deaf man
        trie.insert(intArrayOf(129487, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 463, 1))) // deaf woman: dark skin tone
        trie.insert(intArrayOf(129487, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 463, 1))) // deaf woman: dark skin tone
        trie.insert(intArrayOf(128583, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 397, 595))) // man bowing: medium-dark skin tone
        trie.insert(intArrayOf(128583, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 397, 595))) // man bowing: medium-dark skin tone
        trie.insert(intArrayOf(129318, 127997), ParseResult(4, SpriteCoordinates(2, 3, 133, 529))) // person facepalming: medium skin tone
        trie.insert(intArrayOf(129318, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 199, 529))) // woman facepalming: medium-light skin tone
        trie.insert(intArrayOf(129318, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 199, 529))) // woman facepalming: medium-light skin tone
        trie.insert(intArrayOf(129335, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 529, 133))) // man shrugging: light skin tone
        trie.insert(intArrayOf(129335, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 529, 133))) // man shrugging: light skin tone
        trie.insert(intArrayOf(129489, 8205, 9877, 65039), ParseResult(5, SpriteCoordinates(2, 3, 331, 133))) // health worker
        trie.insert(intArrayOf(129489, 8205, 9877), ParseResult(4, SpriteCoordinates(2, 3, 331, 133))) // health worker
        trie.insert(intArrayOf(128104, 127999, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 3, 463, 793))) // man health worker: dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 3, 463, 793))) // man health worker: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 3, 397, 67))) // student: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 3, 793, 529))) // woman student: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 3, 859, 595))) // man teacher: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 3, 133, 397))) // judge: light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 3, 133, 397))) // judge: light skin tone
        trie.insert(intArrayOf(128105, 8205, 9878), ParseResult(4, SpriteCoordinates(2, 3, 727, 661))) // woman judge
        trie.insert(intArrayOf(128105, 8205, 9878, 65039), ParseResult(5, SpriteCoordinates(2, 3, 727, 661))) // woman judge
        trie.insert(intArrayOf(129489, 127999, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 3, 265, 331))) // farmer: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 3, 793, 67))) // woman farmer: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 3, 859, 265))) // man cook: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 3, 67, 397))) // mechanic: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 3, 265, 793))) // woman mechanic: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127981), ParseResult(5, SpriteCoordinates(2, 3, 67, 859))) // man factory worker
        trie.insert(intArrayOf(128105, 127999, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 3, 397, 727))) // woman factory worker: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 3, 859, 1))) // man office worker: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 3, 397, 331))) // scientist: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 3, 1, 793))) // woman scientist: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 3, 1, 859))) // man technologist: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127908), ParseResult(5, SpriteCoordinates(2, 3, 331, 397))) // singer
        trie.insert(intArrayOf(128104, 127999, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 3, 595, 793))) // man singer: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 3, 397, 1))) // artist: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 3, 793, 463))) // woman artist: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 3, 859, 397))) // man pilot: medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 3, 859, 397))) // man pilot: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 3, 265, 397))) // astronaut: light skin tone
        trie.insert(intArrayOf(128105, 8205, 128640), ParseResult(5, SpriteCoordinates(2, 3, 1, 727))) // woman astronaut
        trie.insert(intArrayOf(129489, 127999, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 3, 199, 331))) // firefighter: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 3, 793, 1))) // woman firefighter: medium-dark skin tone
        trie.insert(intArrayOf(128110, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 727, 331))) // man police officer: medium skin tone
        trie.insert(intArrayOf(128110, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 727, 331))) // man police officer: medium skin tone
        trie.insert(intArrayOf(128373, 127996), ParseResult(4, SpriteCoordinates(2, 3, 661, 199))) // detective: medium-light skin tone
        trie.insert(intArrayOf(128373, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 661, 265))) // woman detective: light skin tone
        trie.insert(intArrayOf(128373, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 661, 265))) // woman detective: light skin tone
        trie.insert(intArrayOf(128130, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 3, 265, 661))) // man guard
        trie.insert(intArrayOf(128130, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 3, 265, 661))) // man guard
        trie.insert(intArrayOf(128130, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 331, 661))) // woman guard: dark skin tone
        trie.insert(intArrayOf(128130, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 331, 661))) // woman guard: dark skin tone
        trie.insert(intArrayOf(128119, 127998), ParseResult(4, SpriteCoordinates(2, 3, 529, 661))) // construction worker: medium-dark skin tone
        trie.insert(intArrayOf(128119, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 661))) // woman construction worker: medium skin tone
        trie.insert(intArrayOf(128119, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 595, 661))) // woman construction worker: medium skin tone
        trie.insert(intArrayOf(129332, 127996), ParseResult(4, SpriteCoordinates(2, 3, 529, 397))) // prince: medium-light skin tone
        trie.insert(intArrayOf(128115, 127995), ParseResult(4, SpriteCoordinates(2, 3, 727, 67))) // person wearing turban: light skin tone
        trie.insert(intArrayOf(128115, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 3, 727, 1))) // woman wearing turban
        trie.insert(intArrayOf(128115, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 3, 727, 1))) // woman wearing turban
        trie.insert(intArrayOf(128114, 127999), ParseResult(4, SpriteCoordinates(2, 3, 727, 133))) // person with skullcap: dark skin tone
        trie.insert(intArrayOf(129333, 127998), ParseResult(4, SpriteCoordinates(2, 3, 529, 265))) // person in tuxedo: medium-dark skin tone
        trie.insert(intArrayOf(129333, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 529, 331))) // woman in tuxedo: medium skin tone
        trie.insert(intArrayOf(129333, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 529, 331))) // woman in tuxedo: medium skin tone
        trie.insert(intArrayOf(128112, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 727, 265))) // man with veil: medium-light skin tone
        trie.insert(intArrayOf(128112, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 727, 265))) // man with veil: medium-light skin tone
        trie.insert(intArrayOf(129328, 127995), ParseResult(4, SpriteCoordinates(2, 3, 67, 529))) // pregnant woman: light skin tone
        trie.insert(intArrayOf(129732), ParseResult(2, SpriteCoordinates(2, 3, 199, 67))) // pregnant person
        trie.insert(intArrayOf(129329, 127999), ParseResult(4, SpriteCoordinates(2, 3, 1, 529))) // breast-feeding: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 3, 859, 67))) // man feeding baby: medium-dark skin tone
        trie.insert(intArrayOf(128124, 127997), ParseResult(4, SpriteCoordinates(2, 3, 463, 661))) // baby angel: medium skin tone
        trie.insert(intArrayOf(129334, 127996), ParseResult(4, SpriteCoordinates(2, 3, 529, 199))) // Mrs. Claus: medium-light skin tone
        trie.insert(intArrayOf(129464, 127995), ParseResult(4, SpriteCoordinates(2, 3, 133, 463))) // superhero: light skin tone
        trie.insert(intArrayOf(129464, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 3, 67, 463))) // woman superhero
        trie.insert(intArrayOf(129464, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 3, 67, 463))) // woman superhero
        trie.insert(intArrayOf(129465, 127999), ParseResult(4, SpriteCoordinates(2, 3, 463, 397))) // supervillain: dark skin tone
        trie.insert(intArrayOf(129465, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 1, 463))) // woman supervillain: medium-dark skin tone
        trie.insert(intArrayOf(129465, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 1, 463))) // woman supervillain: medium-dark skin tone
        trie.insert(intArrayOf(129497, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 265, 133))) // man mage: medium skin tone
        trie.insert(intArrayOf(129497, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 265, 133))) // man mage: medium skin tone
    }

    private fun init4(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(129498, 127996), ParseResult(4, SpriteCoordinates(2, 3, 265, 1))) // fairy: medium-light skin tone
        trie.insert(intArrayOf(129498, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 265, 67))) // woman fairy: light skin tone
        trie.insert(intArrayOf(129498, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 265, 67))) // woman fairy: light skin tone
        trie.insert(intArrayOf(129499, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 3, 133, 199))) // man vampire
        trie.insert(intArrayOf(129499, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 3, 133, 199))) // man vampire
        trie.insert(intArrayOf(129499, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 199, 199))) // woman vampire: dark skin tone
        trie.insert(intArrayOf(129499, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 199, 199))) // woman vampire: dark skin tone
        trie.insert(intArrayOf(129500, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 67, 199))) // merman: medium-dark skin tone
        trie.insert(intArrayOf(129500, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 67, 199))) // merman: medium-dark skin tone
        trie.insert(intArrayOf(129501, 127997), ParseResult(4, SpriteCoordinates(2, 3, 199, 133))) // elf: medium skin tone
        trie.insert(intArrayOf(129501, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 1, 199))) // woman elf: medium-light skin tone
        trie.insert(intArrayOf(129501, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 1, 199))) // woman elf: medium-light skin tone
        trie.insert(intArrayOf(128134), ParseResult(2, SpriteCoordinates(2, 3, 1, 661))) // person getting massage
        trie.insert(intArrayOf(128134, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 67, 661))) // man getting massage: dark skin tone
        trie.insert(intArrayOf(128134, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 67, 661))) // man getting massage: dark skin tone
        trie.insert(intArrayOf(128135, 127998), ParseResult(4, SpriteCoordinates(2, 3, 661, 529))) // person getting haircut: medium-dark skin tone
        trie.insert(intArrayOf(128135, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 661, 595))) // woman getting haircut: medium skin tone
        trie.insert(intArrayOf(128135, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 661, 595))) // woman getting haircut: medium skin tone
        trie.insert(intArrayOf(128694, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 133))) // man walking: medium-light skin tone
        trie.insert(intArrayOf(128694, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 595, 133))) // man walking: medium-light skin tone
        trie.insert(intArrayOf(128694, 127995, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 3, 595, 199))) // person walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 199))) // person walking facing right
        trie.insert(intArrayOf(128694, 8205, 9794, 65039, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 3, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(128694, 8205, 9794, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(128694, 8205, 9794, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 3, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(128694, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 3, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(129485, 127999), ParseResult(4, SpriteCoordinates(2, 3, 463, 265))) // person standing: dark skin tone
        trie.insert(intArrayOf(129485, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 463, 331))) // woman standing: medium-dark skin tone
        trie.insert(intArrayOf(129485, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 463, 331))) // woman standing: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 463, 67))) // man kneeling: medium skin tone
        trie.insert(intArrayOf(129486, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 463, 67))) // man kneeling: medium skin tone
        trie.insert(intArrayOf(129486, 127996, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 3, 463, 133))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 3, 463, 133))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 3, 463, 199))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 3, 463, 199))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 3, 463, 199))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 3, 463, 199))) // man kneeling facing right
        trie.insert(intArrayOf(129489, 8205, 129455, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 3, 1, 331))) // person with white cane facing right
        trie.insert(intArrayOf(129489, 8205, 129455, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 3, 1, 331))) // person with white cane facing right
        trie.insert(intArrayOf(128104, 127999, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 3, 529, 793))) // man with white cane: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 3, 661, 727))) // woman with white cane: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 3, 397, 199))) // person in motorized wheelchair: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 3, 859, 463))) // man in motorized wheelchair: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 3, 199, 793))) // woman in motorized wheelchair: light skin tone
        trie.insert(intArrayOf(129489, 8205, 129469), ParseResult(5, SpriteCoordinates(2, 3, 331, 265))) // person in manual wheelchair
        trie.insert(intArrayOf(129489, 127999, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 3, 133, 331))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(129489, 127999, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 3, 133, 331))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127998, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 3, 793, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127998, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 3, 793, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127997, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 3, 793, 265))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127997, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 3, 793, 265))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 925, 529))) // man running: medium-light skin tone
        trie.insert(intArrayOf(127939, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 925, 529))) // man running: medium-light skin tone
        trie.insert(intArrayOf(127939, 127995, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 3, 925, 595))) // person running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 3, 925, 595))) // person running facing right
        trie.insert(intArrayOf(127939, 8205, 9794, 65039, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 3, 925, 463))) // man running facing right
        trie.insert(intArrayOf(127939, 8205, 9794, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 3, 925, 463))) // man running facing right
        trie.insert(intArrayOf(127939, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 3, 925, 463))) // man running facing right
        trie.insert(intArrayOf(127939, 8205, 9794, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 3, 925, 463))) // man running facing right
        trie.insert(intArrayOf(128131, 127999), ParseResult(4, SpriteCoordinates(2, 3, 199, 661))) // woman dancing: dark skin tone
        trie.insert(intArrayOf(128372, 127998), ParseResult(4, SpriteCoordinates(2, 3, 661, 331))) // person in suit levitating: medium-dark skin tone
        trie.insert(intArrayOf(129494, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 3, 133, 265))) // man in steamy room
        trie.insert(intArrayOf(129494, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 3, 133, 265))) // man in steamy room
        trie.insert(intArrayOf(129494, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 199, 265))) // woman in steamy room: dark skin tone
        trie.insert(intArrayOf(129494, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 199, 265))) // woman in steamy room: dark skin tone
        trie.insert(intArrayOf(129495, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 67, 265))) // man climbing: medium-dark skin tone
        trie.insert(intArrayOf(129495, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 67, 265))) // man climbing: medium-dark skin tone
        trie.insert(intArrayOf(127943, 127996), ParseResult(4, SpriteCoordinates(2, 3, 925, 265))) // horse racing: medium-light skin tone
        trie.insert(intArrayOf(127948, 65039), ParseResult(3, SpriteCoordinates(2, 3, 859, 859))) // person golfing
        trie.insert(intArrayOf(127948), ParseResult(2, SpriteCoordinates(2, 3, 859, 859))) // person golfing
        trie.insert(intArrayOf(127948, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 925, 1))) // man golfing: dark skin tone
        trie.insert(intArrayOf(127948, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 925, 1))) // man golfing: dark skin tone
        trie.insert(intArrayOf(127940, 127998), ParseResult(4, SpriteCoordinates(2, 3, 925, 331))) // person surfing: medium-dark skin tone
        trie.insert(intArrayOf(127940, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 925, 397))) // woman surfing: medium skin tone
        trie.insert(intArrayOf(127940, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 925, 397))) // woman surfing: medium skin tone
        trie.insert(intArrayOf(128675, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 529))) // man rowing boat: medium-light skin tone
        trie.insert(intArrayOf(128675, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 595, 529))) // man rowing boat: medium-light skin tone
        trie.insert(intArrayOf(127946, 127995), ParseResult(4, SpriteCoordinates(2, 3, 925, 199))) // person swimming: light skin tone
        trie.insert(intArrayOf(127946, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 3, 925, 133))) // woman swimming
        trie.insert(intArrayOf(127946, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 3, 925, 133))) // woman swimming
        trie.insert(intArrayOf(9977, 127999), ParseResult(3, SpriteCoordinates(2, 3, 67, 1))) // person bouncing ball: dark skin tone
        trie.insert(intArrayOf(9977, 127998, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 3, 1, 67))) // woman bouncing ball: medium-dark skin tone
        trie.insert(intArrayOf(9977, 127998, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 3, 1, 67))) // woman bouncing ball: medium-dark skin tone
        trie.insert(intArrayOf(127947, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 925, 67))) // man lifting weights: medium skin tone
        trie.insert(intArrayOf(127947, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 925, 67))) // man lifting weights: medium skin tone
        trie.insert(intArrayOf(128692, 127996), ParseResult(4, SpriteCoordinates(2, 3, 595, 397))) // person biking: medium-light skin tone
        trie.insert(intArrayOf(128692, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 595, 463))) // woman biking: light skin tone
        trie.insert(intArrayOf(128692, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 463))) // woman biking: light skin tone
        trie.insert(intArrayOf(128693, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 3, 595, 265))) // man mountain biking
        trie.insert(intArrayOf(128693, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 3, 595, 265))) // man mountain biking
        trie.insert(intArrayOf(128693, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 595, 331))) // woman mountain biking: dark skin tone
        trie.insert(intArrayOf(128693, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 595, 331))) // woman mountain biking: dark skin tone
        trie.insert(intArrayOf(129336, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 529, 67))) // man cartwheeling: medium-dark skin tone
        trie.insert(intArrayOf(129336, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 529, 67))) // man cartwheeling: medium-dark skin tone
        trie.insert(intArrayOf(129341), ParseResult(2, SpriteCoordinates(2, 3, 397, 463))) // person playing water polo
        trie.insert(intArrayOf(129341, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 463, 463))) // man playing water polo: dark skin tone
        trie.insert(intArrayOf(129341, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 463, 463))) // man playing water polo: dark skin tone
        trie.insert(intArrayOf(129342, 127998), ParseResult(4, SpriteCoordinates(2, 3, 265, 463))) // person playing handball: medium-dark skin tone
        trie.insert(intArrayOf(129342, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 3, 331, 463))) // woman playing handball: medium skin tone
        trie.insert(intArrayOf(129342, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 3, 331, 463))) // woman playing handball: medium skin tone
        trie.insert(intArrayOf(129337, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 3, 529, 1))) // man juggling: medium-light skin tone
        trie.insert(intArrayOf(129337, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 3, 529, 1))) // man juggling: medium-light skin tone
        trie.insert(intArrayOf(129496, 127995), ParseResult(4, SpriteCoordinates(2, 3, 1, 265))) // person in lotus position: light skin tone
        trie.insert(intArrayOf(129496, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 3, 265, 199))) // woman in lotus position
        trie.insert(intArrayOf(129496, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 3, 265, 199))) // woman in lotus position
        trie.insert(intArrayOf(128704, 127999), ParseResult(4, SpriteCoordinates(2, 3, 595, 1))) // person taking bath: dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129309, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 3, 199, 397))) // people holding hands: light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129309, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 3, 397, 265))) // people holding hands: medium skin tone, dark skin tone
        trie.insert(intArrayOf(128109), ParseResult(2, SpriteCoordinates(2, 3, 727, 397))) // women holding hands
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 3, 793, 397))) // women holding hands: medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 3, 331, 727))) // women holding hands: dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128107, 127996), ParseResult(4, SpriteCoordinates(2, 3, 727, 529))) // woman and man holding hands: medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 3, 727, 727))) // woman and man holding hands: medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 3, 859, 793))) // men holding hands: light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 3, 859, 199))) // men holding hands: medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128108, 127999), ParseResult(4, SpriteCoordinates(2, 3, 727, 463))) // men holding hands: dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995), ParseResult(15, SpriteCoordinates(2, 3, 1, 397))) // kiss: person, person, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127995), ParseResult(14, SpriteCoordinates(2, 3, 1, 397))) // kiss: person, person, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127999), ParseResult(14, SpriteCoordinates(2, 3, 331, 331))) // kiss: person, person, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999), ParseResult(15, SpriteCoordinates(2, 3, 331, 331))) // kiss: person, person, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 3, 793, 661))) // kiss: woman, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 3, 793, 661))) // kiss: woman, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 3, 529, 727))) // kiss: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 3, 529, 727))) // kiss: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 3, 859, 661))) // kiss: man, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 3, 859, 661))) // kiss: man, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 3, 859, 133))) // kiss: man, man, medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 3, 859, 133))) // kiss: man, man, medium skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 3, 397, 793))) // kiss: man, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 3, 397, 793))) // kiss: man, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127998), ParseResult(14, SpriteCoordinates(2, 3, 793, 595))) // kiss: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998), ParseResult(15, SpriteCoordinates(2, 3, 793, 595))) // kiss: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999), ParseResult(15, SpriteCoordinates(2, 3, 463, 727))) // kiss: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127999), ParseResult(14, SpriteCoordinates(2, 3, 463, 727))) // kiss: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128145, 127999), ParseResult(4, SpriteCoordinates(2, 3, 661, 463))) // couple with heart: dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 3, 397, 133))) // couple with heart: person, person, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 129489, 127998), ParseResult(11, SpriteCoordinates(2, 3, 397, 133))) // couple with heart: person, person, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 3, 133, 793))) // couple with heart: woman, man, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 3, 133, 793))) // couple with heart: woman, man, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 3, 793, 199))) // couple with heart: woman, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 3, 793, 199))) // couple with heart: woman, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 3, 199, 727))) // couple with heart: woman, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 3, 199, 727))) // couple with heart: woman, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 3, 859, 331))) // couple with heart: man, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 3, 859, 331))) // couple with heart: man, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 3, 727, 793))) // couple with heart: man, man, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 3, 727, 793))) // couple with heart: man, man, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 3, 67, 793))) // couple with heart: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128105, 127998), ParseResult(11, SpriteCoordinates(2, 3, 67, 793))) // couple with heart: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 3, 793, 133))) // couple with heart: woman, woman, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128105, 127999), ParseResult(11, SpriteCoordinates(2, 3, 793, 133))) // couple with heart: woman, woman, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 8205, 128105, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 3, 331, 793))) // family: man, woman, boy
        trie.insert(intArrayOf(128105, 8205, 128105, 8205, 128103), ParseResult(8, SpriteCoordinates(2, 3, 67, 727))) // family: woman, woman, girl
        trie.insert(intArrayOf(128105, 8205, 128103), ParseResult(5, SpriteCoordinates(2, 3, 133, 727))) // family: woman, girl
        trie.insert(intArrayOf(129489, 8205, 129490, 8205, 129490), ParseResult(8, SpriteCoordinates(2, 3, 331, 199))) // family: adult, child, child
        trie.insert(intArrayOf(128075, 127998), ParseResult(4, SpriteCoordinates(2, 4, 331, 859))) // waving hand: medium-dark skin tone
        trie.insert(intArrayOf(128400, 127997), ParseResult(4, SpriteCoordinates(2, 4, 661, 1))) // hand with fingers splayed: medium skin tone
        trie.insert(intArrayOf(128406, 127996), ParseResult(4, SpriteCoordinates(2, 4, 595, 595))) // vulcan salute: medium-light skin tone
        trie.insert(intArrayOf(129778, 127995), ParseResult(4, SpriteCoordinates(2, 4, 1, 133))) // leftwards hand: light skin tone
        trie.insert(intArrayOf(129780), ParseResult(2, SpriteCoordinates(2, 4, 133, 67))) // palm up hand
        trie.insert(intArrayOf(129783, 127999), ParseResult(4, SpriteCoordinates(2, 4, 1, 67))) // leftwards pushing hand: dark skin tone
        trie.insert(intArrayOf(128076, 127998), ParseResult(4, SpriteCoordinates(2, 4, 265, 859))) // OK hand: medium-dark skin tone
        trie.insert(intArrayOf(129295, 127997), ParseResult(4, SpriteCoordinates(2, 4, 397, 529))) // pinching hand: medium skin tone
        trie.insert(intArrayOf(129310, 127996), ParseResult(4, SpriteCoordinates(2, 4, 199, 529))) // crossed fingers: medium-light skin tone
        trie.insert(intArrayOf(129311, 127995), ParseResult(4, SpriteCoordinates(2, 4, 133, 529))) // love-you gesture: light skin tone
        trie.insert(intArrayOf(129305), ParseResult(2, SpriteCoordinates(2, 4, 331, 529))) // call me hand
        trie.insert(intArrayOf(128072, 127999), ParseResult(4, SpriteCoordinates(2, 4, 463, 859))) // backhand index pointing left: dark skin tone
        trie.insert(intArrayOf(128070, 127998), ParseResult(4, SpriteCoordinates(2, 4, 595, 859))) // backhand index pointing up: medium-dark skin tone
        trie.insert(intArrayOf(128071, 127997), ParseResult(4, SpriteCoordinates(2, 4, 529, 859))) // backhand index pointing down: medium skin tone
        trie.insert(intArrayOf(129781, 127996), ParseResult(4, SpriteCoordinates(2, 4, 133, 1))) // index pointing at the viewer: medium-light skin tone
        trie.insert(intArrayOf(128078, 127995), ParseResult(4, SpriteCoordinates(2, 4, 199, 859))) // thumbs down: light skin tone
        trie.insert(intArrayOf(128074), ParseResult(2, SpriteCoordinates(2, 4, 397, 859))) // oncoming fist
        trie.insert(intArrayOf(129307, 127999), ParseResult(4, SpriteCoordinates(2, 4, 265, 529))) // left-facing fist: dark skin tone
        trie.insert(intArrayOf(128079, 127998), ParseResult(4, SpriteCoordinates(2, 4, 133, 859))) // clapping hands: medium-dark skin tone
        trie.insert(intArrayOf(129782, 127997), ParseResult(4, SpriteCoordinates(2, 4, 67, 67))) // heart hands: medium skin tone
        trie.insert(intArrayOf(129330, 127996), ParseResult(4, SpriteCoordinates(2, 4, 529, 397))) // palms up together: medium-light skin tone
        trie.insert(intArrayOf(129777, 127995, 8205, 129778, 127997), ParseResult(9, SpriteCoordinates(2, 4, 133, 133))) // handshake: light skin tone, medium skin tone
        trie.insert(intArrayOf(129777, 127998, 8205, 129778, 127995), ParseResult(9, SpriteCoordinates(2, 4, 67, 133))) // handshake: medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128591, 127997), ParseResult(4, SpriteCoordinates(2, 4, 595, 397))) // folded hands: medium skin tone
        trie.insert(intArrayOf(128133, 127996), ParseResult(4, SpriteCoordinates(2, 4, 67, 661))) // nail polish: medium-light skin tone
        trie.insert(intArrayOf(128170, 127995), ParseResult(4, SpriteCoordinates(2, 4, 661, 331))) // flexed biceps: light skin tone
        trie.insert(intArrayOf(129461, 127998), ParseResult(4, SpriteCoordinates(2, 4, 1, 463))) // leg: medium-dark skin tone
        trie.insert(intArrayOf(128066, 127997), ParseResult(4, SpriteCoordinates(2, 4, 793, 859))) // ear: medium skin tone
        trie.insert(intArrayOf(128067, 127996), ParseResult(4, SpriteCoordinates(2, 4, 727, 859))) // nose: medium-light skin tone
        trie.insert(intArrayOf(128069), ParseResult(2, SpriteCoordinates(2, 4, 661, 859))) // tongue
        trie.insert(intArrayOf(129490, 127996), ParseResult(4, SpriteCoordinates(2, 4, 331, 67))) // child: medium-light skin tone
        trie.insert(intArrayOf(128103, 127995), ParseResult(4, SpriteCoordinates(2, 4, 1, 859))) // girl: light skin tone
        trie.insert(intArrayOf(128113), ParseResult(2, SpriteCoordinates(2, 4, 661, 661))) // person: blond hair
        trie.insert(intArrayOf(128104, 127999), ParseResult(4, SpriteCoordinates(2, 4, 397, 793))) // man: dark skin tone
        trie.insert(intArrayOf(129492, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 265, 265))) // man: medium-dark skin tone, beard
        trie.insert(intArrayOf(129492, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 265, 265))) // man: medium-dark skin tone, beard
        trie.insert(intArrayOf(128104, 127997, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 4, 859, 199))) // man: medium skin tone, red hair
        trie.insert(intArrayOf(128104, 127996, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 4, 859, 463))) // man: medium-light skin tone, white hair
        trie.insert(intArrayOf(128105, 127995), ParseResult(4, SpriteCoordinates(2, 4, 793, 463))) // woman: light skin tone
        trie.insert(intArrayOf(129489, 8205, 129456), ParseResult(5, SpriteCoordinates(2, 4, 331, 133))) // person: red hair
        trie.insert(intArrayOf(128105, 127999, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 4, 727, 661))) // woman: dark skin tone, curly hair
        trie.insert(intArrayOf(128105, 127998, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 4, 463, 727))) // woman: medium-dark skin tone, white hair
        trie.insert(intArrayOf(128105, 127997, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 4, 727, 727))) // woman: medium skin tone, bald
        trie.insert(intArrayOf(128113, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 727, 1))) // woman: medium-light skin tone, blond hair
        trie.insert(intArrayOf(128113, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 727, 1))) // woman: medium-light skin tone, blond hair
        trie.insert(intArrayOf(129491, 127995), ParseResult(4, SpriteCoordinates(2, 4, 331, 1))) // older person: light skin tone
        trie.insert(intArrayOf(128117), ParseResult(2, SpriteCoordinates(2, 4, 463, 661))) // old woman
        trie.insert(intArrayOf(128589, 127999), ParseResult(4, SpriteCoordinates(2, 4, 595, 529))) // person frowning: dark skin tone
        trie.insert(intArrayOf(128589, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 1, 595))) // woman frowning: medium-dark skin tone
        trie.insert(intArrayOf(128589, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 1, 595))) // woman frowning: medium-dark skin tone
        trie.insert(intArrayOf(128590, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 595, 463))) // man pouting: medium skin tone
        trie.insert(intArrayOf(128590, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 595, 463))) // man pouting: medium skin tone
        trie.insert(intArrayOf(128581, 127996), ParseResult(4, SpriteCoordinates(2, 4, 463, 595))) // person gesturing NO: medium-light skin tone
        trie.insert(intArrayOf(128581, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 529, 595))) // woman gesturing NO: light skin tone
        trie.insert(intArrayOf(128581, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 529, 595))) // woman gesturing NO: light skin tone
        trie.insert(intArrayOf(128582, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 4, 331, 595))) // man gesturing OK
        trie.insert(intArrayOf(128582, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 4, 331, 595))) // man gesturing OK
        trie.insert(intArrayOf(128582, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 397, 595))) // woman gesturing OK: dark skin tone
        trie.insert(intArrayOf(128582, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 397, 595))) // woman gesturing OK: dark skin tone
        trie.insert(intArrayOf(128129, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 199, 661))) // man tipping hand: medium-dark skin tone
        trie.insert(intArrayOf(128129, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 199, 661))) // man tipping hand: medium-dark skin tone
        trie.insert(intArrayOf(128587, 127997), ParseResult(4, SpriteCoordinates(2, 4, 67, 595))) // person raising hand: medium skin tone
        trie.insert(intArrayOf(128587, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 133, 595))) // woman raising hand: medium-light skin tone
        trie.insert(intArrayOf(128587, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 133, 595))) // woman raising hand: medium-light skin tone
        trie.insert(intArrayOf(129487, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 265, 397))) // deaf man: light skin tone
        trie.insert(intArrayOf(129487, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 265, 397))) // deaf man: light skin tone
        trie.insert(intArrayOf(128583), ParseResult(2, SpriteCoordinates(2, 4, 199, 595))) // person bowing
        trie.insert(intArrayOf(128583, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 265, 595))) // man bowing: dark skin tone
        trie.insert(intArrayOf(128583, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 265, 595))) // man bowing: dark skin tone
        trie.insert(intArrayOf(129318, 127998), ParseResult(4, SpriteCoordinates(2, 4, 1, 529))) // person facepalming: medium-dark skin tone
        trie.insert(intArrayOf(129318, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 67, 529))) // woman facepalming: medium skin tone
        trie.insert(intArrayOf(129318, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 67, 529))) // woman facepalming: medium skin tone
        trie.insert(intArrayOf(129335, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 529, 67))) // man shrugging: medium-light skin tone
        trie.insert(intArrayOf(129335, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 529, 67))) // man shrugging: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 4, 397, 331))) // health worker: light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 4, 397, 331))) // health worker: light skin tone
        trie.insert(intArrayOf(128105, 8205, 9877, 65039), ParseResult(5, SpriteCoordinates(2, 4, 727, 331))) // woman health worker
        trie.insert(intArrayOf(128105, 8205, 9877), ParseResult(4, SpriteCoordinates(2, 4, 727, 331))) // woman health worker
        trie.insert(intArrayOf(129489, 127999, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 4, 67, 331))) // student: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 4, 595, 727))) // woman student: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 4, 859, 331))) // man teacher: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 4, 397, 133))) // judge: medium-light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 4, 397, 133))) // judge: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 4, 793, 661))) // woman judge: light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 4, 793, 661))) // woman judge: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127806), ParseResult(5, SpriteCoordinates(2, 4, 859, 793))) // man farmer
        trie.insert(intArrayOf(128105, 127999, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 4, 199, 727))) // woman farmer: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 4, 793, 793))) // man cook: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 4, 397, 1))) // mechanic: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 4, 793, 397))) // woman mechanic: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 4, 859, 727))) // man factory worker: light skin tone
        trie.insert(intArrayOf(129489, 8205, 128188), ParseResult(5, SpriteCoordinates(2, 4, 331, 199))) // office worker
        trie.insert(intArrayOf(128104, 127999, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 4, 595, 793))) // man office worker: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 4, 265, 331))) // scientist: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 4, 793, 67))) // woman scientist: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 4, 859, 529))) // man technologist: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 4, 199, 397))) // singer: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127908), ParseResult(5, SpriteCoordinates(2, 4, 1, 793))) // woman singer
        trie.insert(intArrayOf(129489, 127999, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 4, 1, 331))) // artist: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 4, 529, 727))) // woman artist: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 4, 859, 67))) // man pilot: medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 4, 859, 67))) // man pilot: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 4, 397, 199))) // astronaut: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 4, 793, 727))) // woman astronaut: light skin tone
        trie.insert(intArrayOf(128104, 8205, 128658), ParseResult(5, SpriteCoordinates(2, 4, 265, 793))) // man firefighter
        trie.insert(intArrayOf(128105, 127999, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 4, 133, 727))) // woman firefighter: dark skin tone
        trie.insert(intArrayOf(128110, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 727, 133))) // man police officer: medium-dark skin tone
        trie.insert(intArrayOf(128110, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 727, 133))) // man police officer: medium-dark skin tone
        trie.insert(intArrayOf(128373, 127997), ParseResult(4, SpriteCoordinates(2, 4, 661, 133))) // detective: medium skin tone
        trie.insert(intArrayOf(128373, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 661, 199))) // woman detective: medium-light skin tone
        trie.insert(intArrayOf(128373, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 661, 199))) // woman detective: medium-light skin tone
        trie.insert(intArrayOf(128130, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 133, 661))) // man guard: light skin tone
        trie.insert(intArrayOf(128130, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 133, 661))) // man guard: light skin tone
        trie.insert(intArrayOf(129399), ParseResult(2, SpriteCoordinates(2, 4, 67, 463))) // ninja
        trie.insert(intArrayOf(128119, 127999), ParseResult(4, SpriteCoordinates(2, 4, 331, 661))) // construction worker: dark skin tone
        trie.insert(intArrayOf(128119, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 397, 661))) // woman construction worker: medium-dark skin tone
        trie.insert(intArrayOf(128119, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 397, 661))) // woman construction worker: medium-dark skin tone
        trie.insert(intArrayOf(129332, 127997), ParseResult(4, SpriteCoordinates(2, 4, 529, 331))) // prince: medium skin tone
        trie.insert(intArrayOf(128115, 127996), ParseResult(4, SpriteCoordinates(2, 4, 529, 661))) // person wearing turban: medium-light skin tone
        trie.insert(intArrayOf(128115, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 595, 661))) // woman wearing turban: light skin tone
        trie.insert(intArrayOf(128115, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 595, 661))) // woman wearing turban: light skin tone
        trie.insert(intArrayOf(129493), ParseResult(2, SpriteCoordinates(2, 4, 199, 265))) // woman with headscarf
        trie.insert(intArrayOf(129333, 127999), ParseResult(4, SpriteCoordinates(2, 4, 529, 199))) // person in tuxedo: dark skin tone
        trie.insert(intArrayOf(129333, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 529, 265))) // woman in tuxedo: medium-dark skin tone
        trie.insert(intArrayOf(129333, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 529, 265))) // woman in tuxedo: medium-dark skin tone
        trie.insert(intArrayOf(128112, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 727, 67))) // man with veil: medium skin tone
        trie.insert(intArrayOf(128112, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 727, 67))) // man with veil: medium skin tone
        trie.insert(intArrayOf(129328, 127996), ParseResult(4, SpriteCoordinates(2, 4, 529, 463))) // pregnant woman: medium-light skin tone
        trie.insert(intArrayOf(129732, 127995), ParseResult(4, SpriteCoordinates(2, 4, 199, 1))) // pregnant person: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127868), ParseResult(5, SpriteCoordinates(2, 4, 67, 793))) // woman feeding baby
        trie.insert(intArrayOf(128104, 127999, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 4, 661, 793))) // man feeding baby: dark skin tone
        trie.insert(intArrayOf(128124, 127998), ParseResult(4, SpriteCoordinates(2, 4, 265, 661))) // baby angel: medium-dark skin tone
        trie.insert(intArrayOf(129334, 127997), ParseResult(4, SpriteCoordinates(2, 4, 529, 133))) // Mrs. Claus: medium skin tone
        trie.insert(intArrayOf(129464, 127996), ParseResult(4, SpriteCoordinates(2, 4, 463, 331))) // superhero: medium-light skin tone
        trie.insert(intArrayOf(129464, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 463, 397))) // woman superhero: light skin tone
        trie.insert(intArrayOf(129464, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 463, 397))) // woman superhero: light skin tone
        trie.insert(intArrayOf(129465, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 4, 463, 199))) // man supervillain
        trie.insert(intArrayOf(129465, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 4, 463, 199))) // man supervillain
        trie.insert(intArrayOf(129465, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 463, 265))) // woman supervillain: dark skin tone
        trie.insert(intArrayOf(129465, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 463, 265))) // woman supervillain: dark skin tone
        trie.insert(intArrayOf(129497, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 265, 67))) // man mage: medium-dark skin tone
        trie.insert(intArrayOf(129497, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 265, 67))) // man mage: medium-dark skin tone
        trie.insert(intArrayOf(129498, 127997), ParseResult(4, SpriteCoordinates(2, 4, 199, 199))) // fairy: medium skin tone
        trie.insert(intArrayOf(129498, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 265, 1))) // woman fairy: medium-light skin tone
        trie.insert(intArrayOf(129498, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 265, 1))) // woman fairy: medium-light skin tone
        trie.insert(intArrayOf(129499, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 133, 199))) // man vampire: light skin tone
        trie.insert(intArrayOf(129499, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 133, 199))) // man vampire: light skin tone
        trie.insert(intArrayOf(129500), ParseResult(2, SpriteCoordinates(2, 4, 1, 199))) // merperson
        trie.insert(intArrayOf(129500, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 67, 199))) // merman: dark skin tone
        trie.insert(intArrayOf(129500, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 67, 199))) // merman: dark skin tone
        trie.insert(intArrayOf(129501, 127998), ParseResult(4, SpriteCoordinates(2, 4, 199, 67))) // elf: medium-dark skin tone
        trie.insert(intArrayOf(129501, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 199, 133))) // woman elf: medium skin tone
        trie.insert(intArrayOf(129501, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 199, 133))) // woman elf: medium skin tone
        trie.insert(intArrayOf(128134, 127995), ParseResult(4, SpriteCoordinates(2, 4, 1, 661))) // person getting massage: light skin tone
        trie.insert(intArrayOf(128134, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 4, 661, 595))) // woman getting massage
        trie.insert(intArrayOf(128134, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 4, 661, 595))) // woman getting massage
        trie.insert(intArrayOf(128135, 127999), ParseResult(4, SpriteCoordinates(2, 4, 661, 463))) // person getting haircut: dark skin tone
        trie.insert(intArrayOf(128135, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 661, 529))) // woman getting haircut: medium-dark skin tone
        trie.insert(intArrayOf(128135, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 661, 529))) // woman getting haircut: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 529, 529))) // man walking: medium skin tone
        trie.insert(intArrayOf(128694, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 529, 529))) // man walking: medium skin tone
        trie.insert(intArrayOf(128694, 127996, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 4, 595, 1))) // person walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 4, 595, 1))) // person walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 4, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 4, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 4, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 4, 595, 67))) // man walking facing right
        trie.insert(intArrayOf(129485, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 4, 463, 67))) // man standing
        trie.insert(intArrayOf(129485, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 4, 463, 67))) // man standing
        trie.insert(intArrayOf(129485, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 463, 133))) // woman standing: dark skin tone
        trie.insert(intArrayOf(129485, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 463, 133))) // woman standing: dark skin tone
        trie.insert(intArrayOf(129486, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 331, 397))) // man kneeling: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 331, 397))) // man kneeling: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127997, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 4, 397, 397))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 4, 397, 397))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 4, 463, 1))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 4, 463, 1))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 4, 463, 1))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 4, 463, 1))) // man kneeling facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 4, 67, 397))) // person with white cane facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 4, 67, 397))) // person with white cane facing right
        trie.insert(intArrayOf(128104, 8205, 129455, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 4, 199, 793))) // man with white cane facing right
        trie.insert(intArrayOf(128104, 8205, 129455, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 4, 199, 793))) // man with white cane facing right
        trie.insert(intArrayOf(128105, 127999, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 4, 1, 727))) // woman with white cane: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 4, 133, 331))) // person in motorized wheelchair: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 4, 859, 133))) // man in motorized wheelchair: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 4, 793, 265))) // woman in motorized wheelchair: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 4, 1, 397))) // person in manual wheelchair: light skin tone
        trie.insert(intArrayOf(128104, 8205, 129469), ParseResult(5, SpriteCoordinates(2, 4, 133, 793))) // man in manual wheelchair
        trie.insert(intArrayOf(128104, 127999, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 4, 529, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127999, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 4, 529, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127998, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 4, 397, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127998, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 4, 397, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 925, 463))) // man running: medium skin tone
        trie.insert(intArrayOf(127939, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 925, 463))) // man running: medium skin tone
        trie.insert(intArrayOf(127939, 127996, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 4, 925, 529))) // person running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 4, 925, 529))) // person running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 4, 925, 595))) // man running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 4, 925, 595))) // man running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 4, 925, 595))) // man running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 4, 925, 595))) // man running facing right
        trie.insert(intArrayOf(128378), ParseResult(2, SpriteCoordinates(2, 4, 661, 67))) // man dancing
        trie.insert(intArrayOf(128372, 127999), ParseResult(4, SpriteCoordinates(2, 4, 661, 265))) // person in suit levitating: dark skin tone
        trie.insert(intArrayOf(129494, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 133, 265))) // man in steamy room: light skin tone
        trie.insert(intArrayOf(129494, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 133, 265))) // man in steamy room: light skin tone
        trie.insert(intArrayOf(129495), ParseResult(2, SpriteCoordinates(2, 4, 1, 265))) // person climbing
        trie.insert(intArrayOf(129495, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 67, 265))) // man climbing: dark skin tone
        trie.insert(intArrayOf(129495, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 67, 265))) // man climbing: dark skin tone
        trie.insert(intArrayOf(127943, 127997), ParseResult(4, SpriteCoordinates(2, 4, 925, 265))) // horse racing: medium skin tone
        trie.insert(intArrayOf(127948, 127995), ParseResult(4, SpriteCoordinates(2, 4, 925, 1))) // person golfing: light skin tone
        trie.insert(intArrayOf(127948, 65039, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 4, 859, 859))) // woman golfing
        trie.insert(intArrayOf(127948, 65039, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 4, 859, 859))) // woman golfing
        trie.insert(intArrayOf(127948, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 4, 859, 859))) // woman golfing
        trie.insert(intArrayOf(127948, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 4, 859, 859))) // woman golfing
        trie.insert(intArrayOf(127940, 127999), ParseResult(4, SpriteCoordinates(2, 4, 925, 331))) // person surfing: dark skin tone
        trie.insert(intArrayOf(127940, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 925, 397))) // woman surfing: medium-dark skin tone
        trie.insert(intArrayOf(127940, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 925, 397))) // woman surfing: medium-dark skin tone
        trie.insert(intArrayOf(128675, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 595, 331))) // man rowing boat: medium skin tone
        trie.insert(intArrayOf(128675, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 595, 331))) // man rowing boat: medium skin tone
        trie.insert(intArrayOf(127946, 127996), ParseResult(4, SpriteCoordinates(2, 4, 925, 133))) // person swimming: medium-light skin tone
        trie.insert(intArrayOf(127946, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 925, 199))) // woman swimming: light skin tone
        trie.insert(intArrayOf(127946, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 925, 199))) // woman swimming: light skin tone
        trie.insert(intArrayOf(9977, 8205, 9794, 65039), ParseResult(4, SpriteCoordinates(2, 4, 1, 1))) // man bouncing ball
        trie.insert(intArrayOf(9977, 65039, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 4, 1, 1))) // man bouncing ball
        trie.insert(intArrayOf(9977, 8205, 9794), ParseResult(3, SpriteCoordinates(2, 4, 1, 1))) // man bouncing ball
        trie.insert(intArrayOf(9977, 65039, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 4, 1, 1))) // man bouncing ball
        trie.insert(intArrayOf(9977, 127999, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 4, 67, 1))) // woman bouncing ball: dark skin tone
        trie.insert(intArrayOf(9977, 127999, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 4, 67, 1))) // woman bouncing ball: dark skin tone
        trie.insert(intArrayOf(127947, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 925, 67))) // man lifting weights: medium-dark skin tone
        trie.insert(intArrayOf(127947, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 925, 67))) // man lifting weights: medium-dark skin tone
        trie.insert(intArrayOf(128692, 127997), ParseResult(4, SpriteCoordinates(2, 4, 595, 199))) // person biking: medium skin tone
        trie.insert(intArrayOf(128692, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 595, 265))) // woman biking: medium-light skin tone
        trie.insert(intArrayOf(128692, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 595, 265))) // woman biking: medium-light skin tone
        trie.insert(intArrayOf(128693, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 595, 133))) // man mountain biking: light skin tone
        trie.insert(intArrayOf(128693, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 595, 133))) // man mountain biking: light skin tone
        trie.insert(intArrayOf(129336), ParseResult(2, SpriteCoordinates(2, 4, 463, 463))) // person cartwheeling
        trie.insert(intArrayOf(129336, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 529, 1))) // man cartwheeling: dark skin tone
        trie.insert(intArrayOf(129336, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 529, 1))) // man cartwheeling: dark skin tone
        trie.insert(intArrayOf(129341, 127995), ParseResult(4, SpriteCoordinates(2, 4, 331, 463))) // person playing water polo: light skin tone
        trie.insert(intArrayOf(129341, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 4, 265, 463))) // woman playing water polo
        trie.insert(intArrayOf(129341, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 4, 265, 463))) // woman playing water polo
        trie.insert(intArrayOf(129342, 127999), ParseResult(4, SpriteCoordinates(2, 4, 133, 463))) // person playing handball: dark skin tone
        trie.insert(intArrayOf(129342, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 199, 463))) // woman playing handball: medium-dark skin tone
        trie.insert(intArrayOf(129342, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 199, 463))) // woman playing handball: medium-dark skin tone
        trie.insert(intArrayOf(129337, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 4, 397, 463))) // man juggling: medium skin tone
        trie.insert(intArrayOf(129337, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 4, 397, 463))) // man juggling: medium skin tone
        trie.insert(intArrayOf(129496, 127996), ParseResult(4, SpriteCoordinates(2, 4, 265, 133))) // person in lotus position: medium-light skin tone
        trie.insert(intArrayOf(129496, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 4, 265, 199))) // woman in lotus position: light skin tone
        trie.insert(intArrayOf(129496, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 4, 265, 199))) // woman in lotus position: light skin tone
        trie.insert(intArrayOf(128716), ParseResult(2, SpriteCoordinates(2, 4, 463, 529))) // person in bed
        trie.insert(intArrayOf(129489, 127995, 8205, 129309, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 4, 133, 397))) // people holding hands: light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129309, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 4, 199, 331))) // people holding hands: medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128109, 127995), ParseResult(4, SpriteCoordinates(2, 4, 727, 199))) // women holding hands: light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 4, 793, 1))) // women holding hands: medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 4, 67, 727))) // women holding hands: dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 4, 793, 331))) // woman and man holding hands: medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128107, 127998), ParseResult(4, SpriteCoordinates(2, 4, 727, 265))) // woman and man holding hands: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 4, 859, 661))) // men holding hands: light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 4, 859, 265))) // men holding hands: medium skin tone, dark skin tone
        trie.insert(intArrayOf(128143), ParseResult(2, SpriteCoordinates(2, 4, 661, 397))) // kiss
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997), ParseResult(15, SpriteCoordinates(2, 4, 397, 67))) // kiss: person, person, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127997), ParseResult(14, SpriteCoordinates(2, 4, 397, 67))) // kiss: person, person, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127995), ParseResult(14, SpriteCoordinates(2, 4, 331, 265))) // kiss: person, person, dark skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995), ParseResult(15, SpriteCoordinates(2, 4, 331, 265))) // kiss: person, person, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 4, 793, 199))) // kiss: woman, man, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 4, 793, 199))) // kiss: woman, man, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 4, 265, 727))) // kiss: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 4, 265, 727))) // kiss: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 4, 859, 595))) // kiss: man, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 4, 859, 595))) // kiss: man, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 4, 859, 1))) // kiss: man, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 4, 859, 1))) // kiss: man, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 4, 463, 793))) // kiss: man, man, dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 4, 463, 793))) // kiss: man, man, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127999), ParseResult(14, SpriteCoordinates(2, 4, 793, 133))) // kiss: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999), ParseResult(15, SpriteCoordinates(2, 4, 793, 133))) // kiss: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995), ParseResult(15, SpriteCoordinates(2, 4, 727, 529))) // kiss: woman, woman, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127995), ParseResult(14, SpriteCoordinates(2, 4, 727, 529))) // kiss: woman, woman, dark skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 4, 397, 265))) // couple with heart: person, person, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 129489, 127996), ParseResult(11, SpriteCoordinates(2, 4, 397, 265))) // couple with heart: person, person, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 4, 331, 331))) // couple with heart: person, person, medium skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 129489, 127999), ParseResult(11, SpriteCoordinates(2, 4, 331, 331))) // couple with heart: person, person, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 4, 793, 595))) // couple with heart: woman, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 4, 793, 595))) // couple with heart: woman, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 4, 661, 727))) // couple with heart: woman, man, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 4, 661, 727))) // couple with heart: woman, man, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 4, 727, 595))) // couple with heart: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 4, 727, 595))) // couple with heart: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 4, 859, 397))) // couple with heart: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 4, 859, 397))) // couple with heart: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 4, 727, 793))) // couple with heart: man, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 4, 727, 793))) // couple with heart: man, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 4, 793, 529))) // couple with heart: woman, woman, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128105, 127999), ParseResult(11, SpriteCoordinates(2, 4, 793, 529))) // couple with heart: woman, woman, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 4, 331, 727))) // couple with heart: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128105, 127995), ParseResult(11, SpriteCoordinates(2, 4, 331, 727))) // couple with heart: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 8205, 128105, 8205, 128103), ParseResult(8, SpriteCoordinates(2, 4, 331, 793))) // family: man, woman, girl
        trie.insert(intArrayOf(128105, 8205, 128105, 8205, 128103, 8205, 128102), ParseResult(11, SpriteCoordinates(2, 4, 727, 397))) // family: woman, woman, girl, boy
        trie.insert(intArrayOf(128105, 8205, 128103, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 4, 727, 463))) // family: woman, girl, boy
        trie.insert(intArrayOf(128099), ParseResult(2, SpriteCoordinates(2, 4, 67, 859))) // footprints
        trie.insert(intArrayOf(128075, 127999), ParseResult(4, SpriteCoordinates(2, 5, 265, 859))) // waving hand: dark skin tone
    }

    private fun init5(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(128400, 127998), ParseResult(4, SpriteCoordinates(2, 5, 661, 67))) // hand with fingers splayed: medium-dark skin tone
        trie.insert(intArrayOf(128406, 127997), ParseResult(4, SpriteCoordinates(2, 5, 661, 1))) // vulcan salute: medium skin tone
        trie.insert(intArrayOf(129778, 127996), ParseResult(4, SpriteCoordinates(2, 5, 133, 67))) // leftwards hand: medium-light skin tone
        trie.insert(intArrayOf(129780, 127995), ParseResult(4, SpriteCoordinates(2, 5, 133, 1))) // palm up hand: light skin tone
        trie.insert(intArrayOf(129784), ParseResult(2, SpriteCoordinates(2, 5, 67, 1))) // rightwards pushing hand
        trie.insert(intArrayOf(128076, 127999), ParseResult(4, SpriteCoordinates(2, 5, 199, 859))) // OK hand: dark skin tone
        trie.insert(intArrayOf(129295, 127998), ParseResult(4, SpriteCoordinates(2, 5, 529, 529))) // pinching hand: medium-dark skin tone
        trie.insert(intArrayOf(129310, 127997), ParseResult(4, SpriteCoordinates(2, 5, 331, 529))) // crossed fingers: medium skin tone
        trie.insert(intArrayOf(129311, 127996), ParseResult(4, SpriteCoordinates(2, 5, 265, 529))) // love-you gesture: medium-light skin tone
        trie.insert(intArrayOf(129305, 127995), ParseResult(4, SpriteCoordinates(2, 5, 463, 529))) // call me hand: light skin tone
        trie.insert(intArrayOf(128073), ParseResult(2, SpriteCoordinates(2, 5, 397, 859))) // backhand index pointing right
        trie.insert(intArrayOf(128070, 127999), ParseResult(4, SpriteCoordinates(2, 5, 529, 859))) // backhand index pointing up: dark skin tone
        trie.insert(intArrayOf(128071, 127998), ParseResult(4, SpriteCoordinates(2, 5, 463, 859))) // backhand index pointing down: medium-dark skin tone
        trie.insert(intArrayOf(129781, 127997), ParseResult(4, SpriteCoordinates(2, 5, 67, 67))) // index pointing at the viewer: medium skin tone
        trie.insert(intArrayOf(128078, 127996), ParseResult(4, SpriteCoordinates(2, 5, 133, 859))) // thumbs down: medium-light skin tone
        trie.insert(intArrayOf(128074, 127995), ParseResult(4, SpriteCoordinates(2, 5, 331, 859))) // oncoming fist: light skin tone
        trie.insert(intArrayOf(129308), ParseResult(2, SpriteCoordinates(2, 5, 397, 529))) // right-facing fist
        trie.insert(intArrayOf(128079, 127999), ParseResult(4, SpriteCoordinates(2, 5, 67, 859))) // clapping hands: dark skin tone
        trie.insert(intArrayOf(129782, 127998), ParseResult(4, SpriteCoordinates(2, 5, 1, 67))) // heart hands: medium-dark skin tone
        trie.insert(intArrayOf(129330, 127997), ParseResult(4, SpriteCoordinates(2, 5, 1, 529))) // palms up together: medium skin tone
        trie.insert(intArrayOf(129777, 127995, 8205, 129778, 127998), ParseResult(9, SpriteCoordinates(2, 5, 67, 133))) // handshake: light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129777, 127998, 8205, 129778, 127996), ParseResult(9, SpriteCoordinates(2, 5, 1, 133))) // handshake: medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128591, 127998), ParseResult(4, SpriteCoordinates(2, 5, 595, 529))) // folded hands: medium-dark skin tone
        trie.insert(intArrayOf(128133, 127997), ParseResult(4, SpriteCoordinates(2, 5, 67, 661))) // nail polish: medium skin tone
        trie.insert(intArrayOf(128170, 127996), ParseResult(4, SpriteCoordinates(2, 5, 661, 331))) // flexed biceps: medium-light skin tone
        trie.insert(intArrayOf(129461, 127999), ParseResult(4, SpriteCoordinates(2, 5, 133, 463))) // leg: dark skin tone
        trie.insert(intArrayOf(128066, 127998), ParseResult(4, SpriteCoordinates(2, 5, 727, 859))) // ear: medium-dark skin tone
        trie.insert(intArrayOf(128067, 127997), ParseResult(4, SpriteCoordinates(2, 5, 661, 859))) // nose: medium skin tone
        trie.insert(intArrayOf(128068), ParseResult(2, SpriteCoordinates(2, 5, 595, 859))) // mouth
        trie.insert(intArrayOf(129490, 127997), ParseResult(4, SpriteCoordinates(2, 5, 331, 199))) // child: medium skin tone
        trie.insert(intArrayOf(128103, 127996), ParseResult(4, SpriteCoordinates(2, 5, 1, 859))) // girl: medium-light skin tone
        trie.insert(intArrayOf(128113, 127995), ParseResult(4, SpriteCoordinates(2, 5, 727, 67))) // person: light skin tone, blond hair
        trie.insert(intArrayOf(129492), ParseResult(2, SpriteCoordinates(2, 5, 331, 1))) // person: beard
        trie.insert(intArrayOf(129492, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 331, 67))) // man: dark skin tone, beard
        trie.insert(intArrayOf(129492, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 331, 67))) // man: dark skin tone, beard
        trie.insert(intArrayOf(128104, 127998, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 5, 661, 793))) // man: medium-dark skin tone, red hair
        trie.insert(intArrayOf(128104, 127997, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 5, 859, 67))) // man: medium skin tone, white hair
        trie.insert(intArrayOf(128105, 127996), ParseResult(4, SpriteCoordinates(2, 5, 793, 397))) // woman: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 5, 199, 397))) // person: light skin tone, red hair
        trie.insert(intArrayOf(129489, 8205, 129457), ParseResult(5, SpriteCoordinates(2, 5, 331, 265))) // person: curly hair
        trie.insert(intArrayOf(128105, 127999, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 5, 331, 727))) // woman: dark skin tone, white hair
        trie.insert(intArrayOf(128105, 127998, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 5, 727, 727))) // woman: medium-dark skin tone, bald
        trie.insert(intArrayOf(128113, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 727, 1))) // woman: medium skin tone, blond hair
        trie.insert(intArrayOf(128113, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 727, 1))) // woman: medium skin tone, blond hair
        trie.insert(intArrayOf(129491, 127996), ParseResult(4, SpriteCoordinates(2, 5, 331, 133))) // older person: medium-light skin tone
        trie.insert(intArrayOf(128117, 127995), ParseResult(4, SpriteCoordinates(2, 5, 529, 661))) // old woman: light skin tone
        trie.insert(intArrayOf(128589, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 5, 67, 595))) // man frowning
        trie.insert(intArrayOf(128589, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 5, 67, 595))) // man frowning
        trie.insert(intArrayOf(128589, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 133, 595))) // woman frowning: dark skin tone
        trie.insert(intArrayOf(128589, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 133, 595))) // woman frowning: dark skin tone
        trie.insert(intArrayOf(128590, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 1, 595))) // man pouting: medium-dark skin tone
        trie.insert(intArrayOf(128590, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 1, 595))) // man pouting: medium-dark skin tone
        trie.insert(intArrayOf(128581, 127997), ParseResult(4, SpriteCoordinates(2, 5, 529, 595))) // person gesturing NO: medium skin tone
        trie.insert(intArrayOf(128581, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 595, 595))) // woman gesturing NO: medium-light skin tone
        trie.insert(intArrayOf(128581, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 595, 595))) // woman gesturing NO: medium-light skin tone
        trie.insert(intArrayOf(128582, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 463, 595))) // man gesturing OK: light skin tone
        trie.insert(intArrayOf(128582, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 595))) // man gesturing OK: light skin tone
        trie.insert(intArrayOf(128129), ParseResult(2, SpriteCoordinates(2, 5, 199, 661))) // person tipping hand
        trie.insert(intArrayOf(128129, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 265, 661))) // man tipping hand: dark skin tone
        trie.insert(intArrayOf(128129, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 265, 661))) // man tipping hand: dark skin tone
        trie.insert(intArrayOf(128587, 127998), ParseResult(4, SpriteCoordinates(2, 5, 199, 595))) // person raising hand: medium-dark skin tone
        trie.insert(intArrayOf(128587, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 265, 595))) // woman raising hand: medium skin tone
        trie.insert(intArrayOf(128587, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 265, 595))) // woman raising hand: medium skin tone
        trie.insert(intArrayOf(129487, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 463, 1))) // deaf man: medium-light skin tone
        trie.insert(intArrayOf(129487, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 1))) // deaf man: medium-light skin tone
        trie.insert(intArrayOf(128583, 127995), ParseResult(4, SpriteCoordinates(2, 5, 397, 595))) // person bowing: light skin tone
        trie.insert(intArrayOf(128583, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 5, 331, 595))) // woman bowing
        trie.insert(intArrayOf(128583, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 5, 331, 595))) // woman bowing
        trie.insert(intArrayOf(129318, 127999), ParseResult(4, SpriteCoordinates(2, 5, 133, 529))) // person facepalming: dark skin tone
        trie.insert(intArrayOf(129318, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 199, 529))) // woman facepalming: medium-dark skin tone
        trie.insert(intArrayOf(129318, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 199, 529))) // woman facepalming: medium-dark skin tone
        trie.insert(intArrayOf(129335, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 529, 199))) // man shrugging: medium skin tone
        trie.insert(intArrayOf(129335, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 529, 199))) // man shrugging: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 5, 397, 199))) // health worker: medium-light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 5, 397, 199))) // health worker: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 5, 67, 793))) // woman health worker: light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 5, 67, 793))) // woman health worker: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127891), ParseResult(5, SpriteCoordinates(2, 5, 859, 793))) // man student
        trie.insert(intArrayOf(128105, 127999, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 5, 529, 727))) // woman student: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 5, 793, 793))) // man teacher: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 5, 397, 1))) // judge: medium skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 5, 397, 1))) // judge: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 5, 793, 595))) // woman judge: medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 5, 793, 595))) // woman judge: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 5, 859, 661))) // man farmer: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127859), ParseResult(5, SpriteCoordinates(2, 5, 397, 397))) // cook
        trie.insert(intArrayOf(128104, 127999, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 5, 463, 793))) // man cook: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 5, 331, 331))) // mechanic: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 5, 793, 331))) // woman mechanic: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 5, 859, 265))) // man factory worker: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 5, 265, 397))) // office worker: light skin tone
        trie.insert(intArrayOf(128105, 8205, 128188), ParseResult(5, SpriteCoordinates(2, 5, 727, 661))) // woman office worker
        trie.insert(intArrayOf(129489, 127999, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 5, 133, 331))) // scientist: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 5, 793, 67))) // woman scientist: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 5, 859, 133))) // man technologist: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 5, 67, 397))) // singer: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 5, 199, 793))) // woman singer: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127912), ParseResult(5, SpriteCoordinates(2, 5, 859, 727))) // man artist
        trie.insert(intArrayOf(128105, 127999, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 5, 463, 727))) // woman artist: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 5, 529, 793))) // man pilot: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 5, 529, 793))) // man pilot: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 5, 397, 67))) // astronaut: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 5, 793, 727))) // woman astronaut: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 5, 859, 595))) // man firefighter: light skin tone
        trie.insert(intArrayOf(128110), ParseResult(2, SpriteCoordinates(2, 5, 727, 265))) // police officer
        trie.insert(intArrayOf(128110, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 727, 331))) // man police officer: dark skin tone
        trie.insert(intArrayOf(128110, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 727, 331))) // man police officer: dark skin tone
        trie.insert(intArrayOf(128373, 127998), ParseResult(4, SpriteCoordinates(2, 5, 661, 199))) // detective: medium-dark skin tone
        trie.insert(intArrayOf(128373, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 661, 265))) // woman detective: medium skin tone
        trie.insert(intArrayOf(128373, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 661, 265))) // woman detective: medium skin tone
        trie.insert(intArrayOf(128130, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 133, 661))) // man guard: medium-light skin tone
        trie.insert(intArrayOf(128130, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 133, 661))) // man guard: medium-light skin tone
        trie.insert(intArrayOf(129399, 127995), ParseResult(4, SpriteCoordinates(2, 5, 199, 463))) // ninja: light skin tone
        trie.insert(intArrayOf(128119, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 5, 397, 661))) // man construction worker
        trie.insert(intArrayOf(128119, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 5, 397, 661))) // man construction worker
        trie.insert(intArrayOf(128119, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 463, 661))) // woman construction worker: dark skin tone
        trie.insert(intArrayOf(128119, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 661))) // woman construction worker: dark skin tone
        trie.insert(intArrayOf(129332, 127998), ParseResult(4, SpriteCoordinates(2, 5, 529, 463))) // prince: medium-dark skin tone
        trie.insert(intArrayOf(128115, 127997), ParseResult(4, SpriteCoordinates(2, 5, 595, 661))) // person wearing turban: medium skin tone
        trie.insert(intArrayOf(128115, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 661, 661))) // woman wearing turban: medium-light skin tone
        trie.insert(intArrayOf(128115, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 661, 661))) // woman wearing turban: medium-light skin tone
        trie.insert(intArrayOf(129493, 127995), ParseResult(4, SpriteCoordinates(2, 5, 265, 265))) // woman with headscarf: light skin tone
        trie.insert(intArrayOf(129333, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 5, 529, 331))) // man in tuxedo
        trie.insert(intArrayOf(129333, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 5, 529, 331))) // man in tuxedo
        trie.insert(intArrayOf(129333, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 529, 397))) // woman in tuxedo: dark skin tone
        trie.insert(intArrayOf(129333, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 529, 397))) // woman in tuxedo: dark skin tone
        trie.insert(intArrayOf(128112, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 727, 133))) // man with veil: medium-dark skin tone
        trie.insert(intArrayOf(128112, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 727, 133))) // man with veil: medium-dark skin tone
        trie.insert(intArrayOf(129328, 127997), ParseResult(4, SpriteCoordinates(2, 5, 67, 529))) // pregnant woman: medium skin tone
        trie.insert(intArrayOf(129732, 127996), ParseResult(4, SpriteCoordinates(2, 5, 199, 1))) // pregnant person: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 5, 265, 793))) // woman feeding baby: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127868), ParseResult(5, SpriteCoordinates(2, 5, 331, 397))) // person feeding baby
        trie.insert(intArrayOf(128124, 127999), ParseResult(4, SpriteCoordinates(2, 5, 331, 661))) // baby angel: dark skin tone
        trie.insert(intArrayOf(129334, 127998), ParseResult(4, SpriteCoordinates(2, 5, 529, 265))) // Mrs. Claus: medium-dark skin tone
        trie.insert(intArrayOf(129464, 127997), ParseResult(4, SpriteCoordinates(2, 5, 1, 463))) // superhero: medium skin tone
        trie.insert(intArrayOf(129464, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 67, 463))) // woman superhero: medium-light skin tone
        trie.insert(intArrayOf(129464, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 67, 463))) // woman superhero: medium-light skin tone
        trie.insert(intArrayOf(129465, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 463, 397))) // man supervillain: light skin tone
        trie.insert(intArrayOf(129465, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 397))) // man supervillain: light skin tone
        trie.insert(intArrayOf(129497), ParseResult(2, SpriteCoordinates(2, 5, 265, 67))) // mage
        trie.insert(intArrayOf(129497, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 265, 133))) // man mage: dark skin tone
        trie.insert(intArrayOf(129497, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 265, 133))) // man mage: dark skin tone
        trie.insert(intArrayOf(129498, 127998), ParseResult(4, SpriteCoordinates(2, 5, 199, 199))) // fairy: medium-dark skin tone
        trie.insert(intArrayOf(129498, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 265, 1))) // woman fairy: medium skin tone
        trie.insert(intArrayOf(129498, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 265, 1))) // woman fairy: medium skin tone
        trie.insert(intArrayOf(129499, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 133, 199))) // man vampire: medium-light skin tone
        trie.insert(intArrayOf(129499, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 133, 199))) // man vampire: medium-light skin tone
        trie.insert(intArrayOf(129500, 127995), ParseResult(4, SpriteCoordinates(2, 5, 67, 199))) // merperson: light skin tone
        trie.insert(intArrayOf(129500, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 5, 1, 199))) // mermaid
        trie.insert(intArrayOf(129500, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 5, 1, 199))) // mermaid
        trie.insert(intArrayOf(129501, 127999), ParseResult(4, SpriteCoordinates(2, 5, 199, 67))) // elf: dark skin tone
        trie.insert(intArrayOf(129501, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 199, 133))) // woman elf: medium-dark skin tone
        trie.insert(intArrayOf(129501, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 199, 133))) // woman elf: medium-dark skin tone
        trie.insert(intArrayOf(128134, 127996), ParseResult(4, SpriteCoordinates(2, 5, 661, 595))) // person getting massage: medium-light skin tone
        trie.insert(intArrayOf(128134, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 1, 661))) // woman getting massage: light skin tone
        trie.insert(intArrayOf(128134, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 1, 661))) // woman getting massage: light skin tone
        trie.insert(intArrayOf(128135, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 5, 661, 463))) // man getting haircut
        trie.insert(intArrayOf(128135, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 5, 661, 463))) // man getting haircut
        trie.insert(intArrayOf(128135, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 661, 529))) // woman getting haircut: dark skin tone
        trie.insert(intArrayOf(128135, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 661, 529))) // woman getting haircut: dark skin tone
        trie.insert(intArrayOf(128694, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 595, 67))) // man walking: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 595, 67))) // man walking: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127997, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 5, 595, 133))) // person walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 5, 595, 133))) // person walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 5, 595, 199))) // man walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 5, 595, 199))) // man walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 5, 595, 199))) // man walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 5, 595, 199))) // man walking facing right
        trie.insert(intArrayOf(129485, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 463, 331))) // man standing: light skin tone
        trie.insert(intArrayOf(129485, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 331))) // man standing: light skin tone
        trie.insert(intArrayOf(129486), ParseResult(2, SpriteCoordinates(2, 5, 463, 67))) // person kneeling
        trie.insert(intArrayOf(129486, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 463, 133))) // man kneeling: dark skin tone
        trie.insert(intArrayOf(129486, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 133))) // man kneeling: dark skin tone
        trie.insert(intArrayOf(129486, 127998, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 199))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 5, 463, 199))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 5, 463, 265))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 5, 463, 265))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 5, 463, 265))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 5, 463, 265))) // man kneeling facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 5, 397, 331))) // person with white cane facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 5, 397, 331))) // person with white cane facing right
        trie.insert(intArrayOf(128104, 127995, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 5, 859, 463))) // man with white cane facing right
        trie.insert(intArrayOf(128104, 127995, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 5, 859, 463))) // man with white cane facing right
        trie.insert(intArrayOf(128105, 8205, 129455, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 5, 727, 595))) // woman with white cane facing right
        trie.insert(intArrayOf(128105, 8205, 129455, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 5, 727, 595))) // woman with white cane facing right
        trie.insert(intArrayOf(129489, 127999, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 5, 67, 331))) // person in motorized wheelchair: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 5, 595, 793))) // man in motorized wheelchair: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 5, 793, 265))) // woman in motorized wheelchair: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 5, 397, 265))) // person in manual wheelchair: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 5, 859, 397))) // man in manual wheelchair: light skin tone
        trie.insert(intArrayOf(128105, 8205, 129469), ParseResult(5, SpriteCoordinates(2, 5, 727, 529))) // woman in manual wheelchair
        trie.insert(intArrayOf(128105, 127999, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 5, 265, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127999, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 5, 265, 727))) // woman in manual wheelchair facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 925, 463))) // man running: medium-dark skin tone
        trie.insert(intArrayOf(127939, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 925, 463))) // man running: medium-dark skin tone
        trie.insert(intArrayOf(127939, 127997, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 5, 925, 529))) // person running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 5, 925, 529))) // person running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 5, 925, 595))) // man running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 5, 925, 595))) // man running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 5, 925, 595))) // man running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 5, 925, 595))) // man running facing right
        trie.insert(intArrayOf(128378, 127995), ParseResult(4, SpriteCoordinates(2, 5, 661, 133))) // man dancing: light skin tone
        trie.insert(intArrayOf(128111), ParseResult(2, SpriteCoordinates(2, 5, 727, 199))) // people with bunny ears
        trie.insert(intArrayOf(129494, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 199, 265))) // man in steamy room: medium-light skin tone
        trie.insert(intArrayOf(129494, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 199, 265))) // man in steamy room: medium-light skin tone
        trie.insert(intArrayOf(129495, 127995), ParseResult(4, SpriteCoordinates(2, 5, 133, 265))) // person climbing: light skin tone
        trie.insert(intArrayOf(129495, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 5, 67, 265))) // woman climbing
        trie.insert(intArrayOf(129495, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 5, 67, 265))) // woman climbing
        trie.insert(intArrayOf(127943, 127998), ParseResult(4, SpriteCoordinates(2, 5, 925, 265))) // horse racing: medium-dark skin tone
        trie.insert(intArrayOf(127948, 127996), ParseResult(4, SpriteCoordinates(2, 5, 793, 859))) // person golfing: medium-light skin tone
        trie.insert(intArrayOf(127948, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 859, 859))) // woman golfing: light skin tone
        trie.insert(intArrayOf(127948, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 859, 859))) // woman golfing: light skin tone
        trie.insert(intArrayOf(127940, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 5, 925, 331))) // man surfing
        trie.insert(intArrayOf(127940, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 5, 925, 331))) // man surfing
        trie.insert(intArrayOf(127940, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 925, 397))) // woman surfing: dark skin tone
        trie.insert(intArrayOf(127940, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 925, 397))) // woman surfing: dark skin tone
        trie.insert(intArrayOf(128675, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 595, 463))) // man rowing boat: medium-dark skin tone
        trie.insert(intArrayOf(128675, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 595, 463))) // man rowing boat: medium-dark skin tone
        trie.insert(intArrayOf(127946, 127997), ParseResult(4, SpriteCoordinates(2, 5, 925, 133))) // person swimming: medium skin tone
        trie.insert(intArrayOf(127946, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 925, 199))) // woman swimming: medium-light skin tone
        trie.insert(intArrayOf(127946, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 925, 199))) // woman swimming: medium-light skin tone
        trie.insert(intArrayOf(9977, 127995, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 5, 1, 1))) // man bouncing ball: light skin tone
        trie.insert(intArrayOf(9977, 127995, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 5, 1, 1))) // man bouncing ball: light skin tone
        trie.insert(intArrayOf(127947), ParseResult(2, SpriteCoordinates(2, 5, 925, 1))) // person lifting weights
        trie.insert(intArrayOf(127947, 65039), ParseResult(3, SpriteCoordinates(2, 5, 925, 1))) // person lifting weights
        trie.insert(intArrayOf(127947, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 925, 67))) // man lifting weights: dark skin tone
        trie.insert(intArrayOf(127947, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 925, 67))) // man lifting weights: dark skin tone
        trie.insert(intArrayOf(128692, 127998), ParseResult(4, SpriteCoordinates(2, 5, 595, 331))) // person biking: medium-dark skin tone
        trie.insert(intArrayOf(128692, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 595, 397))) // woman biking: medium skin tone
        trie.insert(intArrayOf(128692, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 595, 397))) // woman biking: medium skin tone
        trie.insert(intArrayOf(128693, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 595, 265))) // man mountain biking: medium-light skin tone
        trie.insert(intArrayOf(128693, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 595, 265))) // man mountain biking: medium-light skin tone
        trie.insert(intArrayOf(129336, 127995), ParseResult(4, SpriteCoordinates(2, 5, 529, 133))) // person cartwheeling: light skin tone
        trie.insert(intArrayOf(129336, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 5, 529, 67))) // woman cartwheeling
        trie.insert(intArrayOf(129336, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 5, 529, 67))) // woman cartwheeling
        trie.insert(intArrayOf(129341, 127996), ParseResult(4, SpriteCoordinates(2, 5, 397, 463))) // person playing water polo: medium-light skin tone
        trie.insert(intArrayOf(129341, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 463, 463))) // woman playing water polo: light skin tone
        trie.insert(intArrayOf(129341, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 463, 463))) // woman playing water polo: light skin tone
        trie.insert(intArrayOf(129342, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 5, 265, 463))) // man playing handball
        trie.insert(intArrayOf(129342, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 5, 265, 463))) // man playing handball
        trie.insert(intArrayOf(129342, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 331, 463))) // woman playing handball: dark skin tone
        trie.insert(intArrayOf(129342, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 331, 463))) // woman playing handball: dark skin tone
        trie.insert(intArrayOf(129337, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 5, 529, 1))) // man juggling: medium-dark skin tone
        trie.insert(intArrayOf(129337, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 5, 529, 1))) // man juggling: medium-dark skin tone
        trie.insert(intArrayOf(129496, 127997), ParseResult(4, SpriteCoordinates(2, 5, 265, 199))) // person in lotus position: medium skin tone
        trie.insert(intArrayOf(129496, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 5, 1, 265))) // woman in lotus position: medium-light skin tone
        trie.insert(intArrayOf(129496, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 5, 1, 265))) // woman in lotus position: medium-light skin tone
        trie.insert(intArrayOf(128716, 127995), ParseResult(4, SpriteCoordinates(2, 5, 595, 1))) // person in bed: light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129309, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 5, 1, 397))) // people holding hands: medium-light skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129309, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 5, 265, 331))) // people holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 5, 133, 793))) // women holding hands: light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128109, 127997), ParseResult(4, SpriteCoordinates(2, 5, 727, 397))) // women holding hands: medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 5, 397, 727))) // women holding hands: dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 5, 793, 661))) // woman and man holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 5, 793, 1))) // woman and man holding hands: medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 5, 859, 529))) // men holding hands: light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 5, 727, 793))) // men holding hands: medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128143, 127995), ParseResult(4, SpriteCoordinates(2, 5, 661, 397))) // kiss: light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127998), ParseResult(14, SpriteCoordinates(2, 5, 397, 133))) // kiss: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998), ParseResult(15, SpriteCoordinates(2, 5, 397, 133))) // kiss: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996), ParseResult(15, SpriteCoordinates(2, 5, 1, 331))) // kiss: person, person, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127996), ParseResult(14, SpriteCoordinates(2, 5, 1, 331))) // kiss: person, person, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 5, 793, 463))) // kiss: woman, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 5, 793, 463))) // kiss: woman, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 5, 595, 727))) // kiss: woman, man, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 5, 595, 727))) // kiss: woman, man, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 5, 859, 331))) // kiss: man, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 5, 859, 331))) // kiss: man, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 5, 859, 1))) // kiss: man, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 5, 859, 1))) // kiss: man, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 8205, 10084, 65039, 8205, 128139, 8205, 128105), ParseResult(11, SpriteCoordinates(2, 5, 727, 463))) // kiss: woman, woman
        trie.insert(intArrayOf(128105, 8205, 10084, 8205, 128139, 8205, 128105), ParseResult(10, SpriteCoordinates(2, 5, 727, 463))) // kiss: woman, woman
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127995), ParseResult(14, SpriteCoordinates(2, 5, 793, 133))) // kiss: woman, woman, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995), ParseResult(15, SpriteCoordinates(2, 5, 793, 133))) // kiss: woman, woman, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996), ParseResult(15, SpriteCoordinates(2, 5, 133, 727))) // kiss: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127996), ParseResult(14, SpriteCoordinates(2, 5, 133, 727))) // kiss: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 5, 133, 397))) // couple with heart: person, person, light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 129489, 127997), ParseResult(11, SpriteCoordinates(2, 5, 133, 397))) // couple with heart: person, person, light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 5, 199, 331))) // couple with heart: person, person, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 129489, 127995), ParseResult(11, SpriteCoordinates(2, 5, 199, 331))) // couple with heart: person, person, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 5, 1, 793))) // couple with heart: woman, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 5, 1, 793))) // couple with heart: woman, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 5, 793, 199))) // couple with heart: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 5, 793, 199))) // couple with heart: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 5, 199, 727))) // couple with heart: woman, man, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 5, 199, 727))) // couple with heart: woman, man, dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 5, 859, 199))) // couple with heart: man, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 5, 859, 199))) // couple with heart: man, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 5, 397, 793))) // couple with heart: man, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 5, 397, 793))) // couple with heart: man, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 5, 793, 529))) // couple with heart: woman, woman, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128105, 127995), ParseResult(11, SpriteCoordinates(2, 5, 793, 529))) // couple with heart: woman, woman, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128105, 127996), ParseResult(11, SpriteCoordinates(2, 5, 661, 727))) // couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 5, 661, 727))) // couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 8205, 128105, 8205, 128103, 8205, 128102), ParseResult(11, SpriteCoordinates(2, 5, 331, 793))) // family: man, woman, girl, boy
        trie.insert(intArrayOf(128105, 8205, 128105, 8205, 128102, 8205, 128102), ParseResult(11, SpriteCoordinates(2, 5, 1, 727))) // family: woman, woman, boy, boy
        trie.insert(intArrayOf(128105, 8205, 128103, 8205, 128103), ParseResult(8, SpriteCoordinates(2, 5, 67, 727))) // family: woman, girl, girl
        trie.insert(intArrayOf(129734), ParseResult(2, SpriteCoordinates(2, 5, 133, 133))) // fingerprint
        trie.insert(intArrayOf(129306), ParseResult(2, SpriteCoordinates(2, 6, 595, 1))) // raised back of hand
        trie.insert(intArrayOf(128400, 127999), ParseResult(4, SpriteCoordinates(2, 6, 1, 661))) // hand with fingers splayed: dark skin tone
        trie.insert(intArrayOf(128406, 127998), ParseResult(4, SpriteCoordinates(2, 6, 661, 529))) // vulcan salute: medium-dark skin tone
        trie.insert(intArrayOf(129778, 127997), ParseResult(4, SpriteCoordinates(2, 6, 133, 67))) // leftwards hand: medium skin tone
        trie.insert(intArrayOf(129780, 127996), ParseResult(4, SpriteCoordinates(2, 6, 133, 1))) // palm up hand: medium-light skin tone
        trie.insert(intArrayOf(129784, 127995), ParseResult(4, SpriteCoordinates(2, 6, 67, 1))) // rightwards pushing hand: light skin tone
        trie.insert(intArrayOf(129292), ParseResult(2, SpriteCoordinates(2, 6, 595, 199))) // pinched fingers
        trie.insert(intArrayOf(129295, 127999), ParseResult(4, SpriteCoordinates(2, 6, 595, 133))) // pinching hand: dark skin tone
        trie.insert(intArrayOf(129310, 127998), ParseResult(4, SpriteCoordinates(2, 6, 463, 529))) // crossed fingers: medium-dark skin tone
        trie.insert(intArrayOf(129311, 127997), ParseResult(4, SpriteCoordinates(2, 6, 397, 529))) // love-you gesture: medium skin tone
        trie.insert(intArrayOf(129305, 127996), ParseResult(4, SpriteCoordinates(2, 6, 595, 67))) // call me hand: medium-light skin tone
        trie.insert(intArrayOf(128073, 127995), ParseResult(4, SpriteCoordinates(2, 6, 397, 859))) // backhand index pointing right: light skin tone
        trie.insert(intArrayOf(128405), ParseResult(2, SpriteCoordinates(2, 6, 661, 595))) // middle finger
        trie.insert(intArrayOf(128071, 127999), ParseResult(4, SpriteCoordinates(2, 6, 463, 859))) // backhand index pointing down: dark skin tone
        trie.insert(intArrayOf(129781, 127998), ParseResult(4, SpriteCoordinates(2, 6, 67, 67))) // index pointing at the viewer: medium-dark skin tone
        trie.insert(intArrayOf(128078, 127997), ParseResult(4, SpriteCoordinates(2, 6, 265, 859))) // thumbs down: medium skin tone
        trie.insert(intArrayOf(128074, 127996), ParseResult(4, SpriteCoordinates(2, 6, 331, 859))) // oncoming fist: medium-light skin tone
        trie.insert(intArrayOf(129308, 127995), ParseResult(4, SpriteCoordinates(2, 6, 529, 529))) // right-facing fist: light skin tone
        trie.insert(intArrayOf(128588), ParseResult(2, SpriteCoordinates(2, 6, 595, 595))) // raising hands
        trie.insert(intArrayOf(129782, 127999), ParseResult(4, SpriteCoordinates(2, 6, 1, 67))) // heart hands: dark skin tone
        trie.insert(intArrayOf(129330, 127998), ParseResult(4, SpriteCoordinates(2, 6, 133, 529))) // palms up together: medium-dark skin tone
        trie.insert(intArrayOf(129777, 127995, 8205, 129778, 127999), ParseResult(9, SpriteCoordinates(2, 6, 67, 133))) // handshake: light skin tone, dark skin tone
        trie.insert(intArrayOf(129777, 127998, 8205, 129778, 127997), ParseResult(9, SpriteCoordinates(2, 6, 1, 133))) // handshake: medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128591, 127999), ParseResult(4, SpriteCoordinates(2, 6, 331, 595))) // folded hands: dark skin tone
        trie.insert(intArrayOf(128133, 127998), ParseResult(4, SpriteCoordinates(2, 6, 595, 661))) // nail polish: medium-dark skin tone
        trie.insert(intArrayOf(128170, 127997), ParseResult(4, SpriteCoordinates(2, 6, 265, 661))) // flexed biceps: medium skin tone
        trie.insert(intArrayOf(129462), ParseResult(2, SpriteCoordinates(2, 6, 331, 463))) // foot
        trie.insert(intArrayOf(128066, 127999), ParseResult(4, SpriteCoordinates(2, 6, 595, 859))) // ear: dark skin tone
        trie.insert(intArrayOf(128067, 127998), ParseResult(4, SpriteCoordinates(2, 6, 529, 859))) // nose: medium-dark skin tone
        trie.insert(intArrayOf(129766), ParseResult(2, SpriteCoordinates(2, 6, 133, 133))) // biting lip
        trie.insert(intArrayOf(129490, 127998), ParseResult(4, SpriteCoordinates(2, 6, 331, 265))) // child: medium-dark skin tone
        trie.insert(intArrayOf(128103, 127997), ParseResult(4, SpriteCoordinates(2, 6, 199, 859))) // girl: medium skin tone
        trie.insert(intArrayOf(128113, 127996), ParseResult(4, SpriteCoordinates(2, 6, 727, 463))) // person: medium-light skin tone, blond hair
        trie.insert(intArrayOf(129492, 127995), ParseResult(4, SpriteCoordinates(2, 6, 331, 133))) // person: light skin tone, beard
        trie.insert(intArrayOf(129492, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 6, 331, 67))) // woman: beard
        trie.insert(intArrayOf(129492, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 6, 331, 67))) // woman: beard
        trie.insert(intArrayOf(128104, 127999, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 6, 859, 1))) // man: dark skin tone, red hair
        trie.insert(intArrayOf(128104, 127998, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 6, 859, 199))) // man: medium-dark skin tone, white hair
        trie.insert(intArrayOf(128105, 127997), ParseResult(4, SpriteCoordinates(2, 6, 793, 1))) // woman: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 6, 133, 397))) // person: medium-light skin tone, red hair
        trie.insert(intArrayOf(129489, 127995, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 6, 397, 397))) // person: light skin tone, curly hair
        trie.insert(intArrayOf(129489, 8205, 129459), ParseResult(5, SpriteCoordinates(2, 6, 133, 331))) // person: white hair
        trie.insert(intArrayOf(128105, 127999, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 6, 331, 727))) // woman: dark skin tone, bald
        trie.insert(intArrayOf(128113, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 727, 397))) // woman: medium-dark skin tone, blond hair
        trie.insert(intArrayOf(128113, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 727, 397))) // woman: medium-dark skin tone, blond hair
        trie.insert(intArrayOf(129491, 127997), ParseResult(4, SpriteCoordinates(2, 6, 331, 199))) // older person: medium skin tone
        trie.insert(intArrayOf(128117, 127996), ParseResult(4, SpriteCoordinates(2, 6, 727, 199))) // old woman: medium-light skin tone
        trie.insert(intArrayOf(128589, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 529, 595))) // man frowning: light skin tone
        trie.insert(intArrayOf(128589, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 529, 595))) // man frowning: light skin tone
        trie.insert(intArrayOf(128590), ParseResult(2, SpriteCoordinates(2, 6, 397, 595))) // person pouting
        trie.insert(intArrayOf(128590, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 463, 595))) // man pouting: dark skin tone
        trie.insert(intArrayOf(128590, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 463, 595))) // man pouting: dark skin tone
        trie.insert(intArrayOf(128581, 127998), ParseResult(4, SpriteCoordinates(2, 6, 661, 331))) // person gesturing NO: medium-dark skin tone
        trie.insert(intArrayOf(128581, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 661, 397))) // woman gesturing NO: medium skin tone
        trie.insert(intArrayOf(128581, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 661, 397))) // woman gesturing NO: medium skin tone
        trie.insert(intArrayOf(128582, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 661, 265))) // man gesturing OK: medium-light skin tone
        trie.insert(intArrayOf(128582, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 661, 265))) // man gesturing OK: medium-light skin tone
        trie.insert(intArrayOf(128129, 127995), ParseResult(4, SpriteCoordinates(2, 6, 727, 67))) // person tipping hand: light skin tone
        trie.insert(intArrayOf(128129, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 6, 727, 1))) // woman tipping hand
        trie.insert(intArrayOf(128129, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 6, 727, 1))) // woman tipping hand
        trie.insert(intArrayOf(128587, 127999), ParseResult(4, SpriteCoordinates(2, 6, 661, 1))) // person raising hand: dark skin tone
        trie.insert(intArrayOf(128587, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 661, 67))) // woman raising hand: medium-dark skin tone
        trie.insert(intArrayOf(128587, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 661, 67))) // woman raising hand: medium-dark skin tone
        trie.insert(intArrayOf(129487, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 463, 199))) // deaf man: medium skin tone
        trie.insert(intArrayOf(129487, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 463, 199))) // deaf man: medium skin tone
        trie.insert(intArrayOf(128583, 127996), ParseResult(4, SpriteCoordinates(2, 6, 661, 133))) // person bowing: medium-light skin tone
        trie.insert(intArrayOf(128583, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 661, 199))) // woman bowing: light skin tone
        trie.insert(intArrayOf(128583, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 661, 199))) // woman bowing: light skin tone
        trie.insert(intArrayOf(129318, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 6, 265, 529))) // man facepalming
        trie.insert(intArrayOf(129318, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 6, 265, 529))) // man facepalming
        trie.insert(intArrayOf(129318, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 331, 529))) // woman facepalming: dark skin tone
        trie.insert(intArrayOf(129318, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 331, 529))) // woman facepalming: dark skin tone
        trie.insert(intArrayOf(129335, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 529, 397))) // man shrugging: medium-dark skin tone
        trie.insert(intArrayOf(129335, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 529, 397))) // man shrugging: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 6, 397, 199))) // health worker: medium skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 6, 397, 199))) // health worker: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 6, 793, 529))) // woman health worker: medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 6, 793, 529))) // woman health worker: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 6, 133, 859))) // man student: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127979), ParseResult(5, SpriteCoordinates(2, 6, 463, 133))) // teacher
        trie.insert(intArrayOf(128104, 127999, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 6, 859, 67))) // man teacher: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 6, 397, 1))) // judge: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 6, 397, 1))) // judge: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 6, 793, 199))) // woman judge: medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 6, 793, 199))) // woman judge: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 6, 859, 793))) // man farmer: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 6, 463, 67))) // cook: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127859), ParseResult(5, SpriteCoordinates(2, 6, 397, 793))) // woman cook
        trie.insert(intArrayOf(129489, 127999, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 6, 265, 331))) // mechanic: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 6, 727, 727))) // woman mechanic: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 6, 859, 463))) // man factory worker: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 6, 265, 397))) // office worker: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 6, 331, 793))) // woman office worker: light skin tone
        trie.insert(intArrayOf(128104, 8205, 128300), ParseResult(5, SpriteCoordinates(2, 6, 529, 793))) // man scientist
        trie.insert(intArrayOf(128105, 127999, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 6, 463, 727))) // woman scientist: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 6, 859, 331))) // man technologist: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 6, 1, 397))) // singer: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 6, 793, 661))) // woman singer: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 6, 67, 859))) // man artist: light skin tone
        trie.insert(intArrayOf(129489, 8205, 9992), ParseResult(4, SpriteCoordinates(2, 6, 1, 331))) // pilot
        trie.insert(intArrayOf(129489, 8205, 9992, 65039), ParseResult(5, SpriteCoordinates(2, 6, 1, 331))) // pilot
        trie.insert(intArrayOf(128104, 127999, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 6, 727, 793))) // man pilot: dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 6, 727, 793))) // man pilot: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 6, 397, 133))) // astronaut: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 6, 793, 331))) // woman astronaut: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 6, 859, 727))) // man firefighter: medium-light skin tone
        trie.insert(intArrayOf(128110, 127995), ParseResult(4, SpriteCoordinates(2, 6, 67, 727))) // police officer: light skin tone
        trie.insert(intArrayOf(128110, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 6, 1, 727))) // woman police officer
        trie.insert(intArrayOf(128110, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 6, 1, 727))) // woman police officer
        trie.insert(intArrayOf(128373, 127999), ParseResult(4, SpriteCoordinates(2, 6, 133, 661))) // detective: dark skin tone
        trie.insert(intArrayOf(128373, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 199, 661))) // woman detective: medium-dark skin tone
        trie.insert(intArrayOf(128373, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 199, 661))) // woman detective: medium-dark skin tone
        trie.insert(intArrayOf(128130, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 661, 661))) // man guard: medium skin tone
        trie.insert(intArrayOf(128130, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 661, 661))) // man guard: medium skin tone
        trie.insert(intArrayOf(129399, 127996), ParseResult(4, SpriteCoordinates(2, 6, 397, 463))) // ninja: medium-light skin tone
        trie.insert(intArrayOf(128119, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 727, 133))) // man construction worker: light skin tone
        trie.insert(intArrayOf(128119, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 727, 133))) // man construction worker: light skin tone
        trie.insert(intArrayOf(129733), ParseResult(2, SpriteCoordinates(2, 6, 199, 1))) // person with crown
    }

    private fun init6(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(129332, 127999), ParseResult(4, SpriteCoordinates(2, 6, 67, 529))) // prince: dark skin tone
        trie.insert(intArrayOf(128115, 127998), ParseResult(4, SpriteCoordinates(2, 6, 727, 265))) // person wearing turban: medium-dark skin tone
        trie.insert(intArrayOf(128115, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 727, 331))) // woman wearing turban: medium skin tone
        trie.insert(intArrayOf(128115, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 727, 331))) // woman wearing turban: medium skin tone
        trie.insert(intArrayOf(129493, 127996), ParseResult(4, SpriteCoordinates(2, 6, 331, 1))) // woman with headscarf: medium-light skin tone
        trie.insert(intArrayOf(129333, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 1, 529))) // man in tuxedo: light skin tone
        trie.insert(intArrayOf(129333, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 1, 529))) // man in tuxedo: light skin tone
        trie.insert(intArrayOf(128112), ParseResult(2, SpriteCoordinates(2, 6, 727, 529))) // person with veil
        trie.insert(intArrayOf(128112, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 727, 595))) // man with veil: dark skin tone
        trie.insert(intArrayOf(128112, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 727, 595))) // man with veil: dark skin tone
        trie.insert(intArrayOf(129328, 127998), ParseResult(4, SpriteCoordinates(2, 6, 199, 529))) // pregnant woman: medium-dark skin tone
        trie.insert(intArrayOf(129732, 127997), ParseResult(4, SpriteCoordinates(2, 6, 199, 67))) // pregnant person: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 6, 793, 727))) // woman feeding baby: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 6, 463, 1))) // person feeding baby: light skin tone
        trie.insert(intArrayOf(127877), ParseResult(2, SpriteCoordinates(2, 6, 925, 529))) // Santa Claus
        trie.insert(intArrayOf(129334, 127999), ParseResult(4, SpriteCoordinates(2, 6, 529, 463))) // Mrs. Claus: dark skin tone
        trie.insert(intArrayOf(129464, 127998), ParseResult(4, SpriteCoordinates(2, 6, 199, 463))) // superhero: medium-dark skin tone
        trie.insert(intArrayOf(129464, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 265, 463))) // woman superhero: medium skin tone
        trie.insert(intArrayOf(129464, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 265, 463))) // woman superhero: medium skin tone
        trie.insert(intArrayOf(129465, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 133, 463))) // man supervillain: medium-light skin tone
        trie.insert(intArrayOf(129465, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 133, 463))) // man supervillain: medium-light skin tone
        trie.insert(intArrayOf(129497, 127995), ParseResult(4, SpriteCoordinates(2, 6, 265, 199))) // mage: light skin tone
        trie.insert(intArrayOf(129497, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 6, 265, 133))) // woman mage
        trie.insert(intArrayOf(129497, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 6, 265, 133))) // woman mage
        trie.insert(intArrayOf(129498, 127999), ParseResult(4, SpriteCoordinates(2, 6, 265, 1))) // fairy: dark skin tone
        trie.insert(intArrayOf(129498, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 265, 67))) // woman fairy: medium-dark skin tone
        trie.insert(intArrayOf(129498, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 265, 67))) // woman fairy: medium-dark skin tone
        trie.insert(intArrayOf(129499, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 199, 199))) // man vampire: medium skin tone
        trie.insert(intArrayOf(129499, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 199, 199))) // man vampire: medium skin tone
        trie.insert(intArrayOf(129500, 127996), ParseResult(4, SpriteCoordinates(2, 6, 67, 199))) // merperson: medium-light skin tone
        trie.insert(intArrayOf(129500, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 133, 199))) // mermaid: light skin tone
        trie.insert(intArrayOf(129500, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 133, 199))) // mermaid: light skin tone
        trie.insert(intArrayOf(129501, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 6, 199, 133))) // man elf
        trie.insert(intArrayOf(129501, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 6, 199, 133))) // man elf
        trie.insert(intArrayOf(129501, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 1, 199))) // woman elf: dark skin tone
        trie.insert(intArrayOf(129501, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 1, 199))) // woman elf: dark skin tone
        trie.insert(intArrayOf(128134, 127997), ParseResult(4, SpriteCoordinates(2, 6, 463, 661))) // person getting massage: medium skin tone
        trie.insert(intArrayOf(128134, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 529, 661))) // woman getting massage: medium-light skin tone
        trie.insert(intArrayOf(128134, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 529, 661))) // woman getting massage: medium-light skin tone
        trie.insert(intArrayOf(128135, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 397, 661))) // man getting haircut: light skin tone
        trie.insert(intArrayOf(128135, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 397, 661))) // man getting haircut: light skin tone
        trie.insert(intArrayOf(128694), ParseResult(2, SpriteCoordinates(2, 6, 595, 331))) // person walking
        trie.insert(intArrayOf(128694, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 595, 397))) // man walking: dark skin tone
        trie.insert(intArrayOf(128694, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 595, 397))) // man walking: dark skin tone
        trie.insert(intArrayOf(128694, 127998, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 6, 595, 463))) // person walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 6, 595, 463))) // person walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 6, 595, 529))) // man walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 6, 595, 529))) // man walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 6, 595, 529))) // man walking facing right
        trie.insert(intArrayOf(128694, 127997, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 6, 595, 529))) // man walking facing right
        trie.insert(intArrayOf(129485, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 67, 463))) // man standing: medium-light skin tone
        trie.insert(intArrayOf(129485, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 67, 463))) // man standing: medium-light skin tone
        trie.insert(intArrayOf(129486, 127995), ParseResult(4, SpriteCoordinates(2, 6, 1, 463))) // person kneeling: light skin tone
        trie.insert(intArrayOf(129486, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 6, 463, 265))) // woman kneeling
        trie.insert(intArrayOf(129486, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 6, 463, 265))) // woman kneeling
        trie.insert(intArrayOf(129486, 127999, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 6, 463, 331))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 6, 463, 331))) // person kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 6, 463, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 6, 463, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 6, 463, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127998, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 6, 463, 397))) // man kneeling facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 6, 397, 331))) // person with white cane facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 6, 397, 331))) // person with white cane facing right
        trie.insert(intArrayOf(128104, 127996, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 6, 859, 595))) // man with white cane facing right
        trie.insert(intArrayOf(128104, 127996, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 6, 859, 595))) // man with white cane facing right
        trie.insert(intArrayOf(128105, 127995, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 6, 199, 793))) // woman with white cane facing right
        trie.insert(intArrayOf(128105, 127995, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 6, 199, 793))) // woman with white cane facing right
        trie.insert(intArrayOf(129489, 8205, 129468, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 6, 67, 331))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 8205, 129468, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 6, 67, 331))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127999, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 6, 793, 793))) // man in motorized wheelchair: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 6, 661, 727))) // woman in motorized wheelchair: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 6, 397, 265))) // person in manual wheelchair: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 6, 859, 529))) // man in manual wheelchair: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 6, 133, 793))) // woman in manual wheelchair: light skin tone
        trie.insert(intArrayOf(127939), ParseResult(2, SpriteCoordinates(2, 6, 925, 265))) // person running
        trie.insert(intArrayOf(127939, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 925, 331))) // man running: dark skin tone
        trie.insert(intArrayOf(127939, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 925, 331))) // man running: dark skin tone
        trie.insert(intArrayOf(127939, 127998, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 6, 925, 397))) // person running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 6, 925, 397))) // person running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 6, 925, 463))) // man running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 6, 925, 463))) // man running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 6, 925, 463))) // man running facing right
        trie.insert(intArrayOf(127939, 127997, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 6, 925, 463))) // man running facing right
        trie.insert(intArrayOf(128378, 127996), ParseResult(4, SpriteCoordinates(2, 6, 67, 661))) // man dancing: medium-light skin tone
        trie.insert(intArrayOf(128111, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 6, 727, 661))) // men with bunny ears
        trie.insert(intArrayOf(128111, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 6, 727, 661))) // men with bunny ears
        trie.insert(intArrayOf(129494, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 265, 265))) // man in steamy room: medium skin tone
        trie.insert(intArrayOf(129494, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 265, 265))) // man in steamy room: medium skin tone
        trie.insert(intArrayOf(129495, 127996), ParseResult(4, SpriteCoordinates(2, 6, 133, 265))) // person climbing: medium-light skin tone
        trie.insert(intArrayOf(129495, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 199, 265))) // woman climbing: light skin tone
        trie.insert(intArrayOf(129495, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 199, 265))) // woman climbing: light skin tone
        trie.insert(intArrayOf(127943, 127999), ParseResult(4, SpriteCoordinates(2, 6, 925, 133))) // horse racing: dark skin tone
        trie.insert(intArrayOf(127948, 127997), ParseResult(4, SpriteCoordinates(2, 6, 661, 859))) // person golfing: medium skin tone
        trie.insert(intArrayOf(127948, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 727, 859))) // woman golfing: medium-light skin tone
        trie.insert(intArrayOf(127948, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 727, 859))) // woman golfing: medium-light skin tone
        trie.insert(intArrayOf(127940, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 925, 199))) // man surfing: light skin tone
        trie.insert(intArrayOf(127940, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 925, 199))) // man surfing: light skin tone
        trie.insert(intArrayOf(128675), ParseResult(2, SpriteCoordinates(2, 6, 199, 595))) // person rowing boat
        trie.insert(intArrayOf(128675, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 265, 595))) // man rowing boat: dark skin tone
        trie.insert(intArrayOf(128675, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 265, 595))) // man rowing boat: dark skin tone
        trie.insert(intArrayOf(127946, 127998), ParseResult(4, SpriteCoordinates(2, 6, 925, 1))) // person swimming: medium-dark skin tone
        trie.insert(intArrayOf(127946, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 925, 67))) // woman swimming: medium skin tone
        trie.insert(intArrayOf(127946, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 925, 67))) // woman swimming: medium skin tone
        trie.insert(intArrayOf(9977, 127996, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 6, 1, 1))) // man bouncing ball: medium-light skin tone
        trie.insert(intArrayOf(9977, 127996, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 6, 1, 1))) // man bouncing ball: medium-light skin tone
        trie.insert(intArrayOf(127947, 127995), ParseResult(4, SpriteCoordinates(2, 6, 859, 859))) // person lifting weights: light skin tone
        trie.insert(intArrayOf(127947, 65039, 8205, 9792, 65039), ParseResult(6, SpriteCoordinates(2, 6, 793, 859))) // woman lifting weights
        trie.insert(intArrayOf(127947, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 6, 793, 859))) // woman lifting weights
        trie.insert(intArrayOf(127947, 65039, 8205, 9792), ParseResult(5, SpriteCoordinates(2, 6, 793, 859))) // woman lifting weights
        trie.insert(intArrayOf(127947, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 6, 793, 859))) // woman lifting weights
        trie.insert(intArrayOf(128692, 127999), ParseResult(4, SpriteCoordinates(2, 6, 67, 595))) // person biking: dark skin tone
        trie.insert(intArrayOf(128692, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 133, 595))) // woman biking: medium-dark skin tone
        trie.insert(intArrayOf(128692, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 133, 595))) // woman biking: medium-dark skin tone
        trie.insert(intArrayOf(128693, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 1, 595))) // man mountain biking: medium skin tone
        trie.insert(intArrayOf(128693, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 1, 595))) // man mountain biking: medium skin tone
        trie.insert(intArrayOf(129336, 127996), ParseResult(4, SpriteCoordinates(2, 6, 529, 265))) // person cartwheeling: medium-light skin tone
        trie.insert(intArrayOf(129336, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 529, 331))) // woman cartwheeling: light skin tone
        trie.insert(intArrayOf(129336, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 529, 331))) // woman cartwheeling: light skin tone
        trie.insert(intArrayOf(129341, 127997), ParseResult(4, SpriteCoordinates(2, 6, 529, 1))) // person playing water polo: medium skin tone
        trie.insert(intArrayOf(129341, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 529, 67))) // woman playing water polo: medium-light skin tone
        trie.insert(intArrayOf(129341, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 529, 67))) // woman playing water polo: medium-light skin tone
        trie.insert(intArrayOf(129342, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 463, 463))) // man playing handball: light skin tone
        trie.insert(intArrayOf(129342, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 463, 463))) // man playing handball: light skin tone
        trie.insert(intArrayOf(129337), ParseResult(2, SpriteCoordinates(2, 6, 529, 133))) // person juggling
        trie.insert(intArrayOf(129337, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 6, 529, 199))) // man juggling: dark skin tone
        trie.insert(intArrayOf(129337, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 6, 529, 199))) // man juggling: dark skin tone
        trie.insert(intArrayOf(129496, 127998), ParseResult(4, SpriteCoordinates(2, 6, 1, 265))) // person in lotus position: medium-dark skin tone
        trie.insert(intArrayOf(129496, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 6, 67, 265))) // woman in lotus position: medium skin tone
        trie.insert(intArrayOf(129496, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 6, 67, 265))) // woman in lotus position: medium skin tone
        trie.insert(intArrayOf(128716, 127996), ParseResult(4, SpriteCoordinates(2, 6, 595, 265))) // person in bed: medium-light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129309, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 6, 199, 397))) // people holding hands: medium-light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129309, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 6, 397, 67))) // people holding hands: medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 6, 265, 793))) // women holding hands: light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 6, 793, 265))) // women holding hands: medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128109, 127999), ParseResult(4, SpriteCoordinates(2, 6, 133, 727))) // women holding hands: dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 6, 793, 595))) // woman and man holding hands: medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 6, 397, 727))) // woman and man holding hands: dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 6, 859, 661))) // men holding hands: medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 6, 859, 265))) // men holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128143, 127996), ParseResult(4, SpriteCoordinates(2, 6, 331, 661))) // kiss: medium-light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999), ParseResult(15, SpriteCoordinates(2, 6, 67, 397))) // kiss: person, person, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127999), ParseResult(14, SpriteCoordinates(2, 6, 67, 397))) // kiss: person, person, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127997), ParseResult(14, SpriteCoordinates(2, 6, 199, 331))) // kiss: person, person, dark skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997), ParseResult(15, SpriteCoordinates(2, 6, 199, 331))) // kiss: person, person, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 6, 793, 397))) // kiss: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 6, 793, 397))) // kiss: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 6, 529, 727))) // kiss: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 6, 529, 727))) // kiss: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 6, 1, 859))) // kiss: man, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 6, 1, 859))) // kiss: man, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 6, 859, 133))) // kiss: man, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 6, 859, 133))) // kiss: man, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995), ParseResult(15, SpriteCoordinates(2, 6, 1, 793))) // kiss: woman, woman, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127995), ParseResult(14, SpriteCoordinates(2, 6, 1, 793))) // kiss: woman, woman, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127996), ParseResult(14, SpriteCoordinates(2, 6, 793, 67))) // kiss: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996), ParseResult(15, SpriteCoordinates(2, 6, 793, 67))) // kiss: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127997), ParseResult(14, SpriteCoordinates(2, 6, 265, 727))) // kiss: woman, woman, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997), ParseResult(15, SpriteCoordinates(2, 6, 265, 727))) // kiss: woman, woman, dark skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 6, 331, 397))) // couple with heart: person, person, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 129489, 127998), ParseResult(11, SpriteCoordinates(2, 6, 331, 397))) // couple with heart: person, person, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 129489, 127996), ParseResult(11, SpriteCoordinates(2, 6, 331, 331))) // couple with heart: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 6, 331, 331))) // couple with heart: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 6, 67, 793))) // couple with heart: woman, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 6, 67, 793))) // couple with heart: woman, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 6, 793, 133))) // couple with heart: woman, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 6, 793, 133))) // couple with heart: woman, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 8205, 10084, 65039, 8205, 128104), ParseResult(8, SpriteCoordinates(2, 6, 463, 793))) // couple with heart: man, man
        trie.insert(intArrayOf(128104, 8205, 10084, 8205, 128104), ParseResult(7, SpriteCoordinates(2, 6, 463, 793))) // couple with heart: man, man
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 6, 859, 397))) // couple with heart: man, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 6, 859, 397))) // couple with heart: man, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 6, 661, 793))) // couple with heart: man, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 6, 661, 793))) // couple with heart: man, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 6, 793, 463))) // couple with heart: woman, woman, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128105, 127996), ParseResult(11, SpriteCoordinates(2, 6, 793, 463))) // couple with heart: woman, woman, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128105, 127997), ParseResult(11, SpriteCoordinates(2, 6, 595, 727))) // couple with heart: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 6, 595, 727))) // couple with heart: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 8205, 128105, 8205, 128102, 8205, 128102), ParseResult(11, SpriteCoordinates(2, 6, 595, 793))) // family: man, woman, boy, boy
        trie.insert(intArrayOf(128105, 8205, 128105, 8205, 128103, 8205, 128103), ParseResult(11, SpriteCoordinates(2, 6, 199, 727))) // family: woman, woman, girl, girl
        trie.insert(intArrayOf(128483), ParseResult(2, SpriteCoordinates(2, 6, 661, 463))) // speaking head
        trie.insert(intArrayOf(128483, 65039), ParseResult(3, SpriteCoordinates(2, 6, 661, 463))) // speaking head
        trie.insert(intArrayOf(129306, 127995), ParseResult(4, SpriteCoordinates(2, 7, 595, 265))) // raised back of hand: light skin tone
        trie.insert(intArrayOf(9995), ParseResult(1, SpriteCoordinates(2, 7, 1, 67))) // raised hand
        trie.insert(intArrayOf(128406, 127999), ParseResult(4, SpriteCoordinates(2, 7, 661, 595))) // vulcan salute: dark skin tone
        trie.insert(intArrayOf(129778, 127998), ParseResult(4, SpriteCoordinates(2, 7, 199, 1))) // leftwards hand: medium-dark skin tone
        trie.insert(intArrayOf(129780, 127997), ParseResult(4, SpriteCoordinates(2, 7, 133, 133))) // palm up hand: medium skin tone
        trie.insert(intArrayOf(129784, 127996), ParseResult(4, SpriteCoordinates(2, 7, 1, 133))) // rightwards pushing hand: medium-light skin tone
        trie.insert(intArrayOf(129292, 127995), ParseResult(4, SpriteCoordinates(2, 7, 595, 397))) // pinched fingers: light skin tone
        trie.insert(intArrayOf(9996), ParseResult(1, SpriteCoordinates(2, 7, 67, 1))) // victory hand
        trie.insert(intArrayOf(9996, 65039), ParseResult(2, SpriteCoordinates(2, 7, 67, 1))) // victory hand
        trie.insert(intArrayOf(129310, 127999), ParseResult(4, SpriteCoordinates(2, 7, 595, 133))) // crossed fingers: dark skin tone
        trie.insert(intArrayOf(129311, 127998), ParseResult(4, SpriteCoordinates(2, 7, 595, 67))) // love-you gesture: medium-dark skin tone
        trie.insert(intArrayOf(129305, 127997), ParseResult(4, SpriteCoordinates(2, 7, 595, 331))) // call me hand: medium skin tone
        trie.insert(intArrayOf(128073, 127996), ParseResult(4, SpriteCoordinates(2, 7, 595, 859))) // backhand index pointing right: medium-light skin tone
        trie.insert(intArrayOf(128405, 127995), ParseResult(4, SpriteCoordinates(2, 7, 1, 661))) // middle finger: light skin tone
        trie.insert(intArrayOf(9757), ParseResult(1, SpriteCoordinates(2, 7, 133, 67))) // index pointing up
        trie.insert(intArrayOf(9757, 65039), ParseResult(2, SpriteCoordinates(2, 7, 133, 67))) // index pointing up
        trie.insert(intArrayOf(129781, 127999), ParseResult(4, SpriteCoordinates(2, 7, 67, 133))) // index pointing at the viewer: dark skin tone
        trie.insert(intArrayOf(128078, 127998), ParseResult(4, SpriteCoordinates(2, 7, 463, 859))) // thumbs down: medium-dark skin tone
        trie.insert(intArrayOf(128074, 127997), ParseResult(4, SpriteCoordinates(2, 7, 529, 859))) // oncoming fist: medium skin tone
        trie.insert(intArrayOf(129308, 127996), ParseResult(4, SpriteCoordinates(2, 7, 595, 199))) // right-facing fist: medium-light skin tone
        trie.insert(intArrayOf(128588, 127995), ParseResult(4, SpriteCoordinates(2, 7, 661, 67))) // raising hands: light skin tone
        trie.insert(intArrayOf(128080), ParseResult(2, SpriteCoordinates(2, 7, 397, 859))) // open hands
        trie.insert(intArrayOf(129330, 127999), ParseResult(4, SpriteCoordinates(2, 7, 463, 529))) // palms up together: dark skin tone
        trie.insert(intArrayOf(129777, 127996, 8205, 129778, 127995), ParseResult(9, SpriteCoordinates(2, 7, 199, 133))) // handshake: medium-light skin tone, light skin tone
        trie.insert(intArrayOf(129777, 127998, 8205, 129778, 127999), ParseResult(9, SpriteCoordinates(2, 7, 199, 67))) // handshake: medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(9997, 65039), ParseResult(2, SpriteCoordinates(2, 7, 1, 1))) // writing hand
        trie.insert(intArrayOf(9997), ParseResult(1, SpriteCoordinates(2, 7, 1, 1))) // writing hand
        trie.insert(intArrayOf(128133, 127999), ParseResult(4, SpriteCoordinates(2, 7, 595, 661))) // nail polish: dark skin tone
        trie.insert(intArrayOf(128170, 127998), ParseResult(4, SpriteCoordinates(2, 7, 265, 661))) // flexed biceps: medium-dark skin tone
        trie.insert(intArrayOf(129462, 127995), ParseResult(4, SpriteCoordinates(2, 7, 529, 199))) // foot: light skin tone
        trie.insert(intArrayOf(129467), ParseResult(2, SpriteCoordinates(2, 7, 463, 463))) // ear with hearing aid
        trie.insert(intArrayOf(128067, 127999), ParseResult(4, SpriteCoordinates(2, 7, 661, 859))) // nose: dark skin tone
        trie.insert(intArrayOf(128118), ParseResult(2, SpriteCoordinates(2, 7, 727, 265))) // baby
        trie.insert(intArrayOf(129490, 127999), ParseResult(4, SpriteCoordinates(2, 7, 133, 331))) // child: dark skin tone
        trie.insert(intArrayOf(128103, 127998), ParseResult(4, SpriteCoordinates(2, 7, 265, 859))) // girl: medium-dark skin tone
        trie.insert(intArrayOf(128113, 127997), ParseResult(4, SpriteCoordinates(2, 7, 727, 595))) // person: medium skin tone, blond hair
        trie.insert(intArrayOf(129492, 127996), ParseResult(4, SpriteCoordinates(2, 7, 331, 265))) // person: medium-light skin tone, beard
        trie.insert(intArrayOf(129492, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 1, 331))) // woman: light skin tone, beard
        trie.insert(intArrayOf(129492, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 1, 331))) // woman: light skin tone, beard
        trie.insert(intArrayOf(128104, 8205, 129457), ParseResult(5, SpriteCoordinates(2, 7, 661, 793))) // man: curly hair
        trie.insert(intArrayOf(128104, 127999, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 7, 859, 133))) // man: dark skin tone, white hair
        trie.insert(intArrayOf(128105, 127998), ParseResult(4, SpriteCoordinates(2, 7, 793, 1))) // woman: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 7, 199, 397))) // person: medium skin tone, red hair
        trie.insert(intArrayOf(129489, 127996, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 7, 331, 397))) // person: medium-light skin tone, curly hair
        trie.insert(intArrayOf(129489, 127995, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 7, 463, 331))) // person: light skin tone, white hair
        trie.insert(intArrayOf(129489, 8205, 129458), ParseResult(5, SpriteCoordinates(2, 7, 199, 331))) // person: bald
        trie.insert(intArrayOf(128113, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 727, 529))) // woman: dark skin tone, blond hair
        trie.insert(intArrayOf(128113, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 727, 529))) // woman: dark skin tone, blond hair
        trie.insert(intArrayOf(129491, 127998), ParseResult(4, SpriteCoordinates(2, 7, 67, 331))) // older person: medium-dark skin tone
        trie.insert(intArrayOf(128117, 127997), ParseResult(4, SpriteCoordinates(2, 7, 727, 331))) // old woman: medium skin tone
        trie.insert(intArrayOf(128589, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 661, 1))) // man frowning: medium-light skin tone
        trie.insert(intArrayOf(128589, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 661, 1))) // man frowning: medium-light skin tone
        trie.insert(intArrayOf(128590, 127995), ParseResult(4, SpriteCoordinates(2, 7, 595, 595))) // person pouting: light skin tone
        trie.insert(intArrayOf(128590, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 529, 595))) // woman pouting
        trie.insert(intArrayOf(128590, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 529, 595))) // woman pouting
        trie.insert(intArrayOf(128581, 127999), ParseResult(4, SpriteCoordinates(2, 7, 661, 463))) // person gesturing NO: dark skin tone
        trie.insert(intArrayOf(128581, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 661, 529))) // woman gesturing NO: medium-dark skin tone
        trie.insert(intArrayOf(128581, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 661, 529))) // woman gesturing NO: medium-dark skin tone
        trie.insert(intArrayOf(128582, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 661, 397))) // man gesturing OK: medium skin tone
        trie.insert(intArrayOf(128582, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 661, 397))) // man gesturing OK: medium skin tone
        trie.insert(intArrayOf(128129, 127996), ParseResult(4, SpriteCoordinates(2, 7, 727, 1))) // person tipping hand: medium-light skin tone
        trie.insert(intArrayOf(128129, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 727, 67))) // woman tipping hand: light skin tone
        trie.insert(intArrayOf(128129, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 727, 67))) // woman tipping hand: light skin tone
        trie.insert(intArrayOf(128587, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 7, 661, 133))) // man raising hand
        trie.insert(intArrayOf(128587, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 7, 661, 133))) // man raising hand
        trie.insert(intArrayOf(128587, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 661, 199))) // woman raising hand: dark skin tone
        trie.insert(intArrayOf(128587, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 661, 199))) // woman raising hand: dark skin tone
        trie.insert(intArrayOf(129487, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 67, 463))) // deaf man: medium-dark skin tone
        trie.insert(intArrayOf(129487, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 67, 463))) // deaf man: medium-dark skin tone
        trie.insert(intArrayOf(128583, 127997), ParseResult(4, SpriteCoordinates(2, 7, 661, 265))) // person bowing: medium skin tone
        trie.insert(intArrayOf(128583, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 661, 331))) // woman bowing: medium-light skin tone
        trie.insert(intArrayOf(128583, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 661, 331))) // woman bowing: medium-light skin tone
        trie.insert(intArrayOf(129318, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 595, 1))) // man facepalming: light skin tone
        trie.insert(intArrayOf(129318, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 595, 1))) // man facepalming: light skin tone
        trie.insert(intArrayOf(129335), ParseResult(2, SpriteCoordinates(2, 7, 265, 529))) // person shrugging
        trie.insert(intArrayOf(129335, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 331, 529))) // man shrugging: dark skin tone
        trie.insert(intArrayOf(129335, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 331, 529))) // man shrugging: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 7, 397, 199))) // health worker: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 7, 397, 199))) // health worker: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 7, 793, 397))) // woman health worker: medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 7, 793, 397))) // woman health worker: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 7, 67, 859))) // man student: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 7, 463, 397))) // teacher: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127979), ParseResult(5, SpriteCoordinates(2, 7, 529, 793))) // woman teacher
        trie.insert(intArrayOf(129489, 127999, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 7, 397, 1))) // judge: dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 7, 397, 1))) // judge: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 7, 793, 199))) // woman judge: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 7, 793, 199))) // woman judge: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 7, 859, 727))) // man farmer: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 7, 463, 67))) // cook: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 7, 463, 793))) // woman cook: light skin tone
        trie.insert(intArrayOf(128104, 8205, 128295), ParseResult(5, SpriteCoordinates(2, 7, 727, 793))) // man mechanic
        trie.insert(intArrayOf(128105, 127999, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 7, 727, 727))) // woman mechanic: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 7, 859, 397))) // man factory worker: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 7, 265, 397))) // office worker: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 7, 199, 793))) // woman office worker: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 7, 199, 859))) // man scientist: light skin tone
        trie.insert(intArrayOf(129489, 8205, 128187), ParseResult(5, SpriteCoordinates(2, 7, 265, 331))) // technologist
        trie.insert(intArrayOf(128104, 127999, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 7, 859, 199))) // man technologist: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 7, 67, 397))) // singer: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 7, 793, 595))) // woman singer: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 7, 1, 859))) // man artist: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 7, 463, 199))) // pilot: light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 7, 463, 199))) // pilot: light skin tone
        trie.insert(intArrayOf(128105, 8205, 9992), ParseResult(4, SpriteCoordinates(2, 7, 397, 727))) // woman pilot
        trie.insert(intArrayOf(128105, 8205, 9992, 65039), ParseResult(5, SpriteCoordinates(2, 7, 397, 727))) // woman pilot
        trie.insert(intArrayOf(129489, 127999, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 7, 397, 67))) // astronaut: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 7, 793, 265))) // woman astronaut: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 7, 859, 661))) // man firefighter: medium skin tone
        trie.insert(intArrayOf(128110, 127996), ParseResult(4, SpriteCoordinates(2, 7, 133, 727))) // police officer: medium-light skin tone
        trie.insert(intArrayOf(128110, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 199, 727))) // woman police officer: light skin tone
        trie.insert(intArrayOf(128110, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 199, 727))) // woman police officer: light skin tone
        trie.insert(intArrayOf(128373, 65039, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 7, 133, 661))) // man detective
        trie.insert(intArrayOf(128373, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 7, 133, 661))) // man detective
        trie.insert(intArrayOf(128373, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 7, 133, 661))) // man detective
        trie.insert(intArrayOf(128373, 65039, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 7, 133, 661))) // man detective
        trie.insert(intArrayOf(128373, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 199, 661))) // woman detective: dark skin tone
        trie.insert(intArrayOf(128373, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 199, 661))) // woman detective: dark skin tone
        trie.insert(intArrayOf(128130, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 661, 661))) // man guard: medium-dark skin tone
        trie.insert(intArrayOf(128130, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 661, 661))) // man guard: medium-dark skin tone
        trie.insert(intArrayOf(129399, 127997), ParseResult(4, SpriteCoordinates(2, 7, 529, 265))) // ninja: medium skin tone
        trie.insert(intArrayOf(128119, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 727, 199))) // man construction worker: medium-light skin tone
        trie.insert(intArrayOf(128119, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 727, 199))) // man construction worker: medium-light skin tone
        trie.insert(intArrayOf(129733, 127995), ParseResult(4, SpriteCoordinates(2, 7, 1, 199))) // person with crown: light skin tone
        trie.insert(intArrayOf(128120), ParseResult(2, SpriteCoordinates(2, 7, 727, 133))) // princess
        trie.insert(intArrayOf(128115, 127999), ParseResult(4, SpriteCoordinates(2, 7, 727, 397))) // person wearing turban: dark skin tone
        trie.insert(intArrayOf(128115, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 727, 463))) // woman wearing turban: medium-dark skin tone
        trie.insert(intArrayOf(128115, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 727, 463))) // woman wearing turban: medium-dark skin tone
        trie.insert(intArrayOf(129493, 127997), ParseResult(4, SpriteCoordinates(2, 7, 331, 199))) // woman with headscarf: medium skin tone
        trie.insert(intArrayOf(129333, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 397, 529))) // man in tuxedo: medium-light skin tone
        trie.insert(intArrayOf(129333, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 397, 529))) // man in tuxedo: medium-light skin tone
        trie.insert(intArrayOf(128112, 127995), ParseResult(4, SpriteCoordinates(2, 7, 1, 727))) // person with veil: light skin tone
        trie.insert(intArrayOf(128112, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 727, 661))) // woman with veil
        trie.insert(intArrayOf(128112, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 727, 661))) // woman with veil
        trie.insert(intArrayOf(129328, 127999), ParseResult(4, SpriteCoordinates(2, 7, 529, 529))) // pregnant woman: dark skin tone
        trie.insert(intArrayOf(129732, 127998), ParseResult(4, SpriteCoordinates(2, 7, 67, 199))) // pregnant person: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 7, 793, 661))) // woman feeding baby: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 7, 463, 1))) // person feeding baby: medium-light skin tone
        trie.insert(intArrayOf(127877, 127995), ParseResult(4, SpriteCoordinates(2, 7, 925, 529))) // Santa Claus: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127876), ParseResult(5, SpriteCoordinates(2, 7, 1, 463))) // Mx Claus
        trie.insert(intArrayOf(129464, 127999), ParseResult(4, SpriteCoordinates(2, 7, 529, 67))) // superhero: dark skin tone
        trie.insert(intArrayOf(129464, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 529, 133))) // woman superhero: medium-dark skin tone
        trie.insert(intArrayOf(129464, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 529, 133))) // woman superhero: medium-dark skin tone
        trie.insert(intArrayOf(129465, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 529, 1))) // man supervillain: medium skin tone
        trie.insert(intArrayOf(129465, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 529, 1))) // man supervillain: medium skin tone
        trie.insert(intArrayOf(129497, 127996), ParseResult(4, SpriteCoordinates(2, 7, 67, 265))) // mage: medium-light skin tone
        trie.insert(intArrayOf(129497, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 133, 265))) // woman mage: light skin tone
        trie.insert(intArrayOf(129497, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 133, 265))) // woman mage: light skin tone
        trie.insert(intArrayOf(129498, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 7, 265, 199))) // man fairy
        trie.insert(intArrayOf(129498, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 7, 265, 199))) // man fairy
        trie.insert(intArrayOf(129498, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 1, 265))) // woman fairy: dark skin tone
        trie.insert(intArrayOf(129498, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 1, 265))) // woman fairy: dark skin tone
        trie.insert(intArrayOf(129499, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 265, 133))) // man vampire: medium-dark skin tone
        trie.insert(intArrayOf(129499, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 265, 133))) // man vampire: medium-dark skin tone
        trie.insert(intArrayOf(129500, 127997), ParseResult(4, SpriteCoordinates(2, 7, 265, 1))) // merperson: medium skin tone
        trie.insert(intArrayOf(129500, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 265, 67))) // mermaid: medium-light skin tone
        trie.insert(intArrayOf(129500, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 265, 67))) // mermaid: medium-light skin tone
        trie.insert(intArrayOf(129501, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 199, 199))) // man elf: light skin tone
        trie.insert(intArrayOf(129501, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 199, 199))) // man elf: light skin tone
        trie.insert(intArrayOf(129502), ParseResult(2, SpriteCoordinates(2, 7, 133, 199))) // genie
        trie.insert(intArrayOf(128134, 127998), ParseResult(4, SpriteCoordinates(2, 7, 463, 661))) // person getting massage: medium-dark skin tone
        trie.insert(intArrayOf(128134, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 529, 661))) // woman getting massage: medium skin tone
        trie.insert(intArrayOf(128134, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 529, 661))) // woman getting massage: medium skin tone
        trie.insert(intArrayOf(128135, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 397, 661))) // man getting haircut: medium-light skin tone
        trie.insert(intArrayOf(128135, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 397, 661))) // man getting haircut: medium-light skin tone
        trie.insert(intArrayOf(128694, 127995), ParseResult(4, SpriteCoordinates(2, 7, 133, 595))) // person walking: light skin tone
        trie.insert(intArrayOf(128694, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 595, 529))) // woman walking
        trie.insert(intArrayOf(128694, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 595, 529))) // woman walking
        trie.insert(intArrayOf(128694, 127999, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 7, 1, 595))) // person walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 7, 1, 595))) // person walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 7, 67, 595))) // man walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 67, 595))) // man walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 67, 595))) // man walking facing right
        trie.insert(intArrayOf(128694, 127998, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 7, 67, 595))) // man walking facing right
        trie.insert(intArrayOf(129485, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 397, 463))) // man standing: medium skin tone
        trie.insert(intArrayOf(129485, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 397, 463))) // man standing: medium skin tone
        trie.insert(intArrayOf(129486, 127996), ParseResult(4, SpriteCoordinates(2, 7, 265, 463))) // person kneeling: medium-light skin tone
        trie.insert(intArrayOf(129486, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 331, 463))) // woman kneeling: light skin tone
        trie.insert(intArrayOf(129486, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 331, 463))) // woman kneeling: light skin tone
        trie.insert(intArrayOf(129486, 8205, 9792, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 7, 133, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9792, 65039, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 7, 133, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9792, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 7, 133, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 7, 133, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 7, 199, 463))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 199, 463))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 7, 199, 463))) // man kneeling facing right
        trie.insert(intArrayOf(129486, 127999, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 199, 463))) // man kneeling facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 397, 331))) // person with white cane facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 397, 331))) // person with white cane facing right
        trie.insert(intArrayOf(128104, 127997, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 859, 595))) // man with white cane facing right
        trie.insert(intArrayOf(128104, 127997, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 859, 595))) // man with white cane facing right
        trie.insert(intArrayOf(128105, 127996, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 133, 793))) // woman with white cane facing right
        trie.insert(intArrayOf(128105, 127996, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 133, 793))) // woman with white cane facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 463, 265))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 463, 265))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 8205, 129468, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 7, 595, 793))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 8205, 129468, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 7, 595, 793))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127999, 8205, 129468), ParseResult(7, SpriteCoordinates(2, 7, 595, 727))) // woman in motorized wheelchair: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 7, 397, 265))) // person in manual wheelchair: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 7, 859, 529))) // man in manual wheelchair: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 7, 67, 793))) // woman in manual wheelchair: medium-light skin tone
        trie.insert(intArrayOf(127939, 127995), ParseResult(4, SpriteCoordinates(2, 7, 925, 463))) // person running: light skin tone
        trie.insert(intArrayOf(127939, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 925, 265))) // woman running
        trie.insert(intArrayOf(127939, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 925, 265))) // woman running
        trie.insert(intArrayOf(127939, 127999, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 7, 925, 331))) // person running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 7, 925, 331))) // person running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 7, 925, 397))) // man running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 7, 925, 397))) // man running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 7, 925, 397))) // man running facing right
        trie.insert(intArrayOf(127939, 127998, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 7, 925, 397))) // man running facing right
        trie.insert(intArrayOf(128378, 127997), ParseResult(4, SpriteCoordinates(2, 7, 67, 661))) // man dancing: medium skin tone
        trie.insert(intArrayOf(128111, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 67, 727))) // women with bunny ears
        trie.insert(intArrayOf(128111, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 67, 727))) // women with bunny ears
        trie.insert(intArrayOf(129494, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 331, 133))) // man in steamy room: medium-dark skin tone
        trie.insert(intArrayOf(129494, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 331, 133))) // man in steamy room: medium-dark skin tone
        trie.insert(intArrayOf(129495, 127997), ParseResult(4, SpriteCoordinates(2, 7, 331, 1))) // person climbing: medium skin tone
        trie.insert(intArrayOf(129495, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 331, 67))) // woman climbing: medium-light skin tone
        trie.insert(intArrayOf(129495, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 331, 67))) // woman climbing: medium-light skin tone
        trie.insert(intArrayOf(9975, 65039), ParseResult(2, SpriteCoordinates(2, 7, 133, 1))) // skier
        trie.insert(intArrayOf(9975), ParseResult(1, SpriteCoordinates(2, 7, 133, 1))) // skier
        trie.insert(intArrayOf(127948, 127998), ParseResult(4, SpriteCoordinates(2, 7, 727, 859))) // person golfing: medium-dark skin tone
        trie.insert(intArrayOf(127948, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 793, 859))) // woman golfing: medium skin tone
        trie.insert(intArrayOf(127948, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 793, 859))) // woman golfing: medium skin tone
        trie.insert(intArrayOf(127940, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 925, 199))) // man surfing: medium-light skin tone
        trie.insert(intArrayOf(127940, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 925, 199))) // man surfing: medium-light skin tone
        trie.insert(intArrayOf(128675, 127995), ParseResult(4, SpriteCoordinates(2, 7, 463, 595))) // person rowing boat: light skin tone
        trie.insert(intArrayOf(128675, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 397, 595))) // woman rowing boat
        trie.insert(intArrayOf(128675, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 397, 595))) // woman rowing boat
        trie.insert(intArrayOf(127946, 127999), ParseResult(4, SpriteCoordinates(2, 7, 925, 67))) // person swimming: dark skin tone
        trie.insert(intArrayOf(127946, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 925, 133))) // woman swimming: medium-dark skin tone
        trie.insert(intArrayOf(127946, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 925, 133))) // woman swimming: medium-dark skin tone
        trie.insert(intArrayOf(9977, 127997, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 7, 67, 67))) // man bouncing ball: medium skin tone
        trie.insert(intArrayOf(9977, 127997, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 7, 67, 67))) // man bouncing ball: medium skin tone
        trie.insert(intArrayOf(127947, 127996), ParseResult(4, SpriteCoordinates(2, 7, 859, 859))) // person lifting weights: medium-light skin tone
        trie.insert(intArrayOf(127947, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 925, 1))) // woman lifting weights: light skin tone
        trie.insert(intArrayOf(127947, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 925, 1))) // woman lifting weights: light skin tone
        trie.insert(intArrayOf(128692, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 7, 265, 595))) // man biking
        trie.insert(intArrayOf(128692, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 7, 265, 595))) // man biking
        trie.insert(intArrayOf(128692, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 331, 595))) // woman biking: dark skin tone
        trie.insert(intArrayOf(128692, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 331, 595))) // woman biking: dark skin tone
        trie.insert(intArrayOf(128693, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 199, 595))) // man mountain biking: medium-dark skin tone
        trie.insert(intArrayOf(128693, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 199, 595))) // man mountain biking: medium-dark skin tone
        trie.insert(intArrayOf(129336, 127997), ParseResult(4, SpriteCoordinates(2, 7, 133, 529))) // person cartwheeling: medium skin tone
        trie.insert(intArrayOf(129336, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 199, 529))) // woman cartwheeling: medium-light skin tone
        trie.insert(intArrayOf(129336, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 199, 529))) // woman cartwheeling: medium-light skin tone
        trie.insert(intArrayOf(129341, 127998), ParseResult(4, SpriteCoordinates(2, 7, 529, 397))) // person playing water polo: medium-dark skin tone
        trie.insert(intArrayOf(129341, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 529, 463))) // woman playing water polo: medium skin tone
        trie.insert(intArrayOf(129341, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 529, 463))) // woman playing water polo: medium skin tone
        trie.insert(intArrayOf(129342, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 7, 529, 331))) // man playing handball: medium-light skin tone
        trie.insert(intArrayOf(129342, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 7, 529, 331))) // man playing handball: medium-light skin tone
        trie.insert(intArrayOf(129337, 127995), ParseResult(4, SpriteCoordinates(2, 7, 67, 529))) // person juggling: light skin tone
        trie.insert(intArrayOf(129337, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 7, 1, 529))) // woman juggling
        trie.insert(intArrayOf(129337, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 7, 1, 529))) // woman juggling
        trie.insert(intArrayOf(129496, 127999), ParseResult(4, SpriteCoordinates(2, 7, 199, 265))) // person in lotus position: dark skin tone
        trie.insert(intArrayOf(129496, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 7, 265, 265))) // woman in lotus position: medium-dark skin tone
        trie.insert(intArrayOf(129496, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 7, 265, 265))) // woman in lotus position: medium-dark skin tone
        trie.insert(intArrayOf(128716, 127997), ParseResult(4, SpriteCoordinates(2, 7, 595, 463))) // person in bed: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129309, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 7, 397, 397))) // people holding hands: medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129309, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 7, 1, 397))) // people holding hands: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 7, 397, 793))) // women holding hands: light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 7, 793, 463))) // women holding hands: medium skin tone, dark skin tone
        trie.insert(intArrayOf(128107), ParseResult(2, SpriteCoordinates(2, 7, 331, 727))) // woman and man holding hands
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 7, 793, 529))) // woman and man holding hands: medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 7, 661, 727))) // woman and man holding hands: dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128108, 127996), ParseResult(4, SpriteCoordinates(2, 7, 265, 727))) // men holding hands: medium-light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 7, 859, 331))) // men holding hands: medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128143, 127997), ParseResult(4, SpriteCoordinates(2, 7, 331, 661))) // kiss: medium skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995), ParseResult(15, SpriteCoordinates(2, 7, 133, 397))) // kiss: person, person, medium skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127995), ParseResult(14, SpriteCoordinates(2, 7, 133, 397))) // kiss: person, person, medium skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127998), ParseResult(14, SpriteCoordinates(2, 7, 331, 331))) // kiss: person, person, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998), ParseResult(15, SpriteCoordinates(2, 7, 331, 331))) // kiss: person, person, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 7, 793, 727))) // kiss: woman, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 7, 793, 727))) // kiss: woman, man, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 7, 529, 727))) // kiss: woman, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 7, 529, 727))) // kiss: woman, man, dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 7, 859, 793))) // kiss: man, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 7, 859, 793))) // kiss: man, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 7, 859, 265))) // kiss: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 7, 859, 265))) // kiss: man, man, medium-dark skin tone, medium-light skin tone
    }

    private fun init7(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996), ParseResult(15, SpriteCoordinates(2, 7, 265, 793))) // kiss: woman, woman, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127996), ParseResult(14, SpriteCoordinates(2, 7, 265, 793))) // kiss: woman, woman, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127997), ParseResult(14, SpriteCoordinates(2, 7, 793, 331))) // kiss: woman, woman, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997), ParseResult(15, SpriteCoordinates(2, 7, 793, 331))) // kiss: woman, woman, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998), ParseResult(15, SpriteCoordinates(2, 7, 463, 727))) // kiss: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127998), ParseResult(14, SpriteCoordinates(2, 7, 463, 727))) // kiss: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 7, 463, 133))) // couple with heart: person, person, light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 129489, 127999), ParseResult(11, SpriteCoordinates(2, 7, 463, 133))) // couple with heart: person, person, light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 7, 397, 133))) // couple with heart: person, person, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 129489, 127997), ParseResult(11, SpriteCoordinates(2, 7, 397, 133))) // couple with heart: person, person, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 7, 331, 793))) // couple with heart: woman, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 7, 331, 793))) // couple with heart: woman, man, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 7, 793, 133))) // couple with heart: woman, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 7, 793, 133))) // couple with heart: woman, man, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 7, 133, 859))) // couple with heart: man, man, light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 7, 133, 859))) // couple with heart: man, man, light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 7, 859, 463))) // couple with heart: man, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 7, 859, 463))) // couple with heart: man, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 7, 859, 67))) // couple with heart: man, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 7, 859, 67))) // couple with heart: man, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128105, 127997), ParseResult(11, SpriteCoordinates(2, 7, 1, 793))) // couple with heart: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 7, 1, 793))) // couple with heart: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128105, 127998), ParseResult(11, SpriteCoordinates(2, 7, 793, 67))) // couple with heart: woman, woman, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 7, 793, 67))) // couple with heart: woman, woman, medium-dark skin tone
        trie.insert(intArrayOf(128104, 8205, 128105, 8205, 128103, 8205, 128103), ParseResult(11, SpriteCoordinates(2, 7, 793, 793))) // family: man, woman, girl, girl
        trie.insert(intArrayOf(128104, 8205, 128102), ParseResult(5, SpriteCoordinates(2, 7, 859, 1))) // family: man, boy
        trie.insert(intArrayOf(128100), ParseResult(2, SpriteCoordinates(2, 7, 331, 859))) // bust in silhouette
        trie.insert(intArrayOf(129306, 127996), ParseResult(4, SpriteCoordinates(2, 8, 595, 265))) // raised back of hand: medium-light skin tone
        trie.insert(intArrayOf(9995, 127995), ParseResult(3, SpriteCoordinates(2, 8, 1, 67))) // raised hand: light skin tone
        trie.insert(intArrayOf(129777), ParseResult(2, SpriteCoordinates(2, 8, 133, 133))) // rightwards hand
        trie.insert(intArrayOf(129778, 127999), ParseResult(4, SpriteCoordinates(2, 8, 67, 133))) // leftwards hand: dark skin tone
        trie.insert(intArrayOf(129780, 127998), ParseResult(4, SpriteCoordinates(2, 8, 1, 133))) // palm up hand: medium-dark skin tone
        trie.insert(intArrayOf(129784, 127997), ParseResult(4, SpriteCoordinates(2, 8, 133, 67))) // rightwards pushing hand: medium skin tone
        trie.insert(intArrayOf(129292, 127996), ParseResult(4, SpriteCoordinates(2, 8, 595, 397))) // pinched fingers: medium-light skin tone
        trie.insert(intArrayOf(9996, 127995), ParseResult(3, SpriteCoordinates(2, 8, 67, 1))) // victory hand: light skin tone
        trie.insert(intArrayOf(129776), ParseResult(2, SpriteCoordinates(2, 8, 199, 133))) // hand with index finger and thumb crossed
        trie.insert(intArrayOf(129311, 127999), ParseResult(4, SpriteCoordinates(2, 8, 595, 67))) // love-you gesture: dark skin tone
        trie.insert(intArrayOf(129305, 127998), ParseResult(4, SpriteCoordinates(2, 8, 595, 331))) // call me hand: medium-dark skin tone
        trie.insert(intArrayOf(128073, 127997), ParseResult(4, SpriteCoordinates(2, 8, 595, 859))) // backhand index pointing right: medium skin tone
        trie.insert(intArrayOf(128405, 127996), ParseResult(4, SpriteCoordinates(2, 8, 661, 529))) // middle finger: medium-light skin tone
        trie.insert(intArrayOf(9757, 127995), ParseResult(3, SpriteCoordinates(2, 8, 133, 1))) // index pointing up: light skin tone
        trie.insert(intArrayOf(128077), ParseResult(2, SpriteCoordinates(2, 8, 463, 859))) // thumbs up
        trie.insert(intArrayOf(128078, 127999), ParseResult(4, SpriteCoordinates(2, 8, 397, 859))) // thumbs down: dark skin tone
        trie.insert(intArrayOf(128074, 127998), ParseResult(4, SpriteCoordinates(2, 8, 529, 859))) // oncoming fist: medium-dark skin tone
        trie.insert(intArrayOf(129308, 127997), ParseResult(4, SpriteCoordinates(2, 8, 595, 199))) // right-facing fist: medium skin tone
        trie.insert(intArrayOf(128588, 127996), ParseResult(4, SpriteCoordinates(2, 8, 661, 67))) // raising hands: medium-light skin tone
        trie.insert(intArrayOf(128080, 127995), ParseResult(4, SpriteCoordinates(2, 8, 331, 859))) // open hands: light skin tone
        trie.insert(intArrayOf(129309), ParseResult(2, SpriteCoordinates(2, 8, 595, 133))) // handshake
        trie.insert(intArrayOf(129777, 127996, 8205, 129778, 127997), ParseResult(9, SpriteCoordinates(2, 8, 199, 67))) // handshake: medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(129777, 127999, 8205, 129778, 127995), ParseResult(9, SpriteCoordinates(2, 8, 199, 1))) // handshake: dark skin tone, light skin tone
        trie.insert(intArrayOf(9997, 127995), ParseResult(3, SpriteCoordinates(2, 8, 1, 1))) // writing hand: light skin tone
        trie.insert(intArrayOf(129331), ParseResult(2, SpriteCoordinates(2, 8, 529, 529))) // selfie
        trie.insert(intArrayOf(128170, 127999), ParseResult(4, SpriteCoordinates(2, 8, 67, 661))) // flexed biceps: dark skin tone
        trie.insert(intArrayOf(129462, 127996), ParseResult(4, SpriteCoordinates(2, 8, 529, 265))) // foot: medium-light skin tone
        trie.insert(intArrayOf(129467, 127995), ParseResult(4, SpriteCoordinates(2, 8, 529, 1))) // ear with hearing aid: light skin tone
        trie.insert(intArrayOf(129504), ParseResult(2, SpriteCoordinates(2, 8, 199, 199))) // brain
        trie.insert(intArrayOf(128118, 127995), ParseResult(4, SpriteCoordinates(2, 8, 727, 67))) // baby: light skin tone
        trie.insert(intArrayOf(128102), ParseResult(2, SpriteCoordinates(2, 8, 199, 859))) // boy
        trie.insert(intArrayOf(128103, 127999), ParseResult(4, SpriteCoordinates(2, 8, 133, 859))) // girl: dark skin tone
        trie.insert(intArrayOf(128113, 127998), ParseResult(4, SpriteCoordinates(2, 8, 727, 397))) // person: medium-dark skin tone, blond hair
        trie.insert(intArrayOf(129492, 127997), ParseResult(4, SpriteCoordinates(2, 8, 133, 331))) // person: medium skin tone, beard
        trie.insert(intArrayOf(129492, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 199, 331))) // woman: medium-light skin tone, beard
        trie.insert(intArrayOf(129492, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 199, 331))) // woman: medium-light skin tone, beard
        trie.insert(intArrayOf(128104, 127995, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 8, 1, 859))) // man: light skin tone, curly hair
        trie.insert(intArrayOf(128104, 8205, 129458), ParseResult(5, SpriteCoordinates(2, 8, 463, 793))) // man: bald
        trie.insert(intArrayOf(128105, 127999), ParseResult(4, SpriteCoordinates(2, 8, 331, 727))) // woman: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 8, 397, 331))) // person: medium-dark skin tone, red hair
        trie.insert(intArrayOf(129489, 127997, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 8, 199, 397))) // person: medium skin tone, curly hair
        trie.insert(intArrayOf(129489, 127996, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 8, 463, 133))) // person: medium-light skin tone, white hair
        trie.insert(intArrayOf(129489, 127995, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 8, 463, 331))) // person: light skin tone, bald
        trie.insert(intArrayOf(128113, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 727, 331))) // man: blond hair
        trie.insert(intArrayOf(128113, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 727, 331))) // man: blond hair
        trie.insert(intArrayOf(129491, 127999), ParseResult(4, SpriteCoordinates(2, 8, 265, 331))) // older person: dark skin tone
        trie.insert(intArrayOf(128117, 127998), ParseResult(4, SpriteCoordinates(2, 8, 727, 133))) // old woman: medium-dark skin tone
        trie.insert(intArrayOf(128589, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 661, 1))) // man frowning: medium skin tone
        trie.insert(intArrayOf(128589, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 661, 1))) // man frowning: medium skin tone
        trie.insert(intArrayOf(128590, 127996), ParseResult(4, SpriteCoordinates(2, 8, 529, 595))) // person pouting: medium-light skin tone
        trie.insert(intArrayOf(128590, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 595, 595))) // woman pouting: light skin tone
        trie.insert(intArrayOf(128590, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 595, 595))) // woman pouting: light skin tone
        trie.insert(intArrayOf(128581, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 661, 397))) // man gesturing NO
        trie.insert(intArrayOf(128581, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 661, 397))) // man gesturing NO
        trie.insert(intArrayOf(128581, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 661, 463))) // woman gesturing NO: dark skin tone
        trie.insert(intArrayOf(128581, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 661, 463))) // woman gesturing NO: dark skin tone
        trie.insert(intArrayOf(128582, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 661, 331))) // man gesturing OK: medium-dark skin tone
        trie.insert(intArrayOf(128582, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 661, 331))) // man gesturing OK: medium-dark skin tone
        trie.insert(intArrayOf(128129, 127997), ParseResult(4, SpriteCoordinates(2, 8, 529, 661))) // person tipping hand: medium skin tone
        trie.insert(intArrayOf(128129, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 595, 661))) // woman tipping hand: medium-light skin tone
        trie.insert(intArrayOf(128129, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 595, 661))) // woman tipping hand: medium-light skin tone
        trie.insert(intArrayOf(128587, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 661, 133))) // man raising hand: light skin tone
        trie.insert(intArrayOf(128587, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 661, 133))) // man raising hand: light skin tone
        trie.insert(intArrayOf(129487), ParseResult(2, SpriteCoordinates(2, 8, 133, 463))) // deaf person
        trie.insert(intArrayOf(129487, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 199, 463))) // deaf man: dark skin tone
        trie.insert(intArrayOf(129487, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 199, 463))) // deaf man: dark skin tone
        trie.insert(intArrayOf(128583, 127998), ParseResult(4, SpriteCoordinates(2, 8, 661, 199))) // person bowing: medium-dark skin tone
        trie.insert(intArrayOf(128583, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 661, 265))) // woman bowing: medium skin tone
        trie.insert(intArrayOf(128583, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 661, 265))) // woman bowing: medium skin tone
        trie.insert(intArrayOf(129318, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 595, 1))) // man facepalming: medium-light skin tone
        trie.insert(intArrayOf(129318, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 595, 1))) // man facepalming: medium-light skin tone
        trie.insert(intArrayOf(129335, 127995), ParseResult(4, SpriteCoordinates(2, 8, 397, 529))) // person shrugging: light skin tone
        trie.insert(intArrayOf(129335, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 8, 331, 529))) // woman shrugging
        trie.insert(intArrayOf(129335, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 8, 331, 529))) // woman shrugging
        trie.insert(intArrayOf(129489, 127999, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 8, 397, 1))) // health worker: dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 8, 397, 1))) // health worker: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 8, 793, 67))) // woman health worker: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 8, 793, 67))) // woman health worker: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 8, 859, 463))) // man student: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 8, 463, 265))) // teacher: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 8, 331, 793))) // woman teacher: light skin tone
        trie.insert(intArrayOf(128104, 8205, 9878, 65039), ParseResult(5, SpriteCoordinates(2, 8, 397, 793))) // man judge
        trie.insert(intArrayOf(128104, 8205, 9878), ParseResult(4, SpriteCoordinates(2, 8, 397, 793))) // man judge
        trie.insert(intArrayOf(128105, 127999, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 8, 529, 727))) // woman judge: dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 8, 529, 727))) // woman judge: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 8, 859, 265))) // man farmer: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 8, 331, 397))) // cook: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 8, 67, 793))) // woman cook: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 8, 67, 859))) // man mechanic: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127981), ParseResult(5, SpriteCoordinates(2, 8, 67, 463))) // factory worker
        trie.insert(intArrayOf(128104, 127999, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 8, 793, 793))) // man factory worker: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 8, 67, 397))) // office worker: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 8, 793, 661))) // woman office worker: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 8, 859, 661))) // man scientist: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 8, 463, 397))) // technologist: light skin tone
        trie.insert(intArrayOf(128105, 8205, 128187), ParseResult(5, SpriteCoordinates(2, 8, 265, 727))) // woman technologist
        trie.insert(intArrayOf(129489, 127999, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 8, 397, 199))) // singer: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 8, 793, 199))) // woman singer: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 8, 859, 397))) // man artist: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 8, 463, 1))) // pilot: medium-light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 8, 463, 1))) // pilot: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 8, 199, 793))) // woman pilot: light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 8, 199, 793))) // woman pilot: light skin tone
        trie.insert(intArrayOf(128104, 8205, 128640), ParseResult(5, SpriteCoordinates(2, 8, 529, 793))) // man astronaut
        trie.insert(intArrayOf(128105, 127999, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 8, 661, 727))) // woman astronaut: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 8, 859, 199))) // man firefighter: medium-dark skin tone
        trie.insert(intArrayOf(128110, 127997), ParseResult(4, SpriteCoordinates(2, 8, 727, 595))) // police officer: medium skin tone
        trie.insert(intArrayOf(128110, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 727, 661))) // woman police officer: medium-light skin tone
        trie.insert(intArrayOf(128110, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 727, 661))) // woman police officer: medium-light skin tone
        trie.insert(intArrayOf(128373, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 1, 661))) // man detective: light skin tone
        trie.insert(intArrayOf(128373, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 1, 661))) // man detective: light skin tone
        trie.insert(intArrayOf(128130), ParseResult(2, SpriteCoordinates(2, 8, 397, 661))) // guard
        trie.insert(intArrayOf(128130, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 463, 661))) // man guard: dark skin tone
        trie.insert(intArrayOf(128130, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 463, 661))) // man guard: dark skin tone
        trie.insert(intArrayOf(129399, 127998), ParseResult(4, SpriteCoordinates(2, 8, 529, 331))) // ninja: medium-dark skin tone
        trie.insert(intArrayOf(128119, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 727, 1))) // man construction worker: medium skin tone
        trie.insert(intArrayOf(128119, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 727, 1))) // man construction worker: medium skin tone
        trie.insert(intArrayOf(129733, 127996), ParseResult(4, SpriteCoordinates(2, 8, 1, 199))) // person with crown: medium-light skin tone
        trie.insert(intArrayOf(128120, 127995), ParseResult(4, SpriteCoordinates(2, 8, 661, 661))) // princess: light skin tone
        trie.insert(intArrayOf(128115, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 727, 199))) // man wearing turban
        trie.insert(intArrayOf(128115, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 727, 199))) // man wearing turban
        trie.insert(intArrayOf(128115, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 727, 265))) // woman wearing turban: dark skin tone
        trie.insert(intArrayOf(128115, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 727, 265))) // woman wearing turban: dark skin tone
        trie.insert(intArrayOf(129493, 127998), ParseResult(4, SpriteCoordinates(2, 8, 67, 331))) // woman with headscarf: medium-dark skin tone
        trie.insert(intArrayOf(129333, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 463, 529))) // man in tuxedo: medium skin tone
        trie.insert(intArrayOf(129333, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 463, 529))) // man in tuxedo: medium skin tone
        trie.insert(intArrayOf(128112, 127996), ParseResult(4, SpriteCoordinates(2, 8, 727, 463))) // person with veil: medium-light skin tone
        trie.insert(intArrayOf(128112, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 727, 529))) // woman with veil: light skin tone
        trie.insert(intArrayOf(128112, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 727, 529))) // woman with veil: light skin tone
        trie.insert(intArrayOf(129731), ParseResult(2, SpriteCoordinates(2, 8, 133, 199))) // pregnant man
        trie.insert(intArrayOf(129732, 127999), ParseResult(4, SpriteCoordinates(2, 8, 67, 199))) // pregnant person: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 8, 793, 265))) // woman feeding baby: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 8, 265, 397))) // person feeding baby: medium skin tone
        trie.insert(intArrayOf(127877, 127996), ParseResult(4, SpriteCoordinates(2, 8, 925, 529))) // Santa Claus: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127876), ParseResult(7, SpriteCoordinates(2, 8, 1, 463))) // Mx Claus: light skin tone
        trie.insert(intArrayOf(129464, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 529, 133))) // man superhero
        trie.insert(intArrayOf(129464, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 529, 133))) // man superhero
        trie.insert(intArrayOf(129464, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 529, 199))) // woman superhero: dark skin tone
        trie.insert(intArrayOf(129464, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 529, 199))) // woman superhero: dark skin tone
        trie.insert(intArrayOf(129465, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 529, 67))) // man supervillain: medium-dark skin tone
        trie.insert(intArrayOf(129465, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 529, 67))) // man supervillain: medium-dark skin tone
        trie.insert(intArrayOf(129497, 127997), ParseResult(4, SpriteCoordinates(2, 8, 199, 265))) // mage: medium skin tone
        trie.insert(intArrayOf(129497, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 265, 265))) // woman mage: medium-light skin tone
        trie.insert(intArrayOf(129497, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 265, 265))) // woman mage: medium-light skin tone
        trie.insert(intArrayOf(129498, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 133, 265))) // man fairy: light skin tone
        trie.insert(intArrayOf(129498, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 133, 265))) // man fairy: light skin tone
        trie.insert(intArrayOf(129499), ParseResult(2, SpriteCoordinates(2, 8, 1, 265))) // vampire
        trie.insert(intArrayOf(129499, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 67, 265))) // man vampire: dark skin tone
        trie.insert(intArrayOf(129499, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 67, 265))) // man vampire: dark skin tone
        trie.insert(intArrayOf(129500, 127998), ParseResult(4, SpriteCoordinates(2, 8, 265, 133))) // merperson: medium-dark skin tone
        trie.insert(intArrayOf(129500, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 265, 199))) // mermaid: medium skin tone
        trie.insert(intArrayOf(129500, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 265, 199))) // mermaid: medium skin tone
        trie.insert(intArrayOf(129501, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 265, 67))) // man elf: medium-light skin tone
        trie.insert(intArrayOf(129501, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 265, 67))) // man elf: medium-light skin tone
        trie.insert(intArrayOf(129502, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 265, 1))) // man genie
        trie.insert(intArrayOf(129502, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 265, 1))) // man genie
        trie.insert(intArrayOf(128134, 127999), ParseResult(4, SpriteCoordinates(2, 8, 265, 661))) // person getting massage: dark skin tone
        trie.insert(intArrayOf(128134, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 331, 661))) // woman getting massage: medium-dark skin tone
        trie.insert(intArrayOf(128134, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 331, 661))) // woman getting massage: medium-dark skin tone
        trie.insert(intArrayOf(128135, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 199, 661))) // man getting haircut: medium skin tone
        trie.insert(intArrayOf(128135, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 199, 661))) // man getting haircut: medium skin tone
        trie.insert(intArrayOf(128694, 127996), ParseResult(4, SpriteCoordinates(2, 8, 67, 595))) // person walking: medium-light skin tone
        trie.insert(intArrayOf(128694, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 133, 595))) // woman walking: light skin tone
        trie.insert(intArrayOf(128694, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 133, 595))) // woman walking: light skin tone
        trie.insert(intArrayOf(128694, 8205, 9792, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 8, 595, 529))) // woman walking facing right
        trie.insert(intArrayOf(128694, 8205, 9792, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 8, 595, 529))) // woman walking facing right
        trie.insert(intArrayOf(128694, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 8, 595, 529))) // woman walking facing right
        trie.insert(intArrayOf(128694, 8205, 9792, 65039, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 8, 595, 529))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 8, 1, 595))) // man walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 1, 595))) // man walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 8, 1, 595))) // man walking facing right
        trie.insert(intArrayOf(128694, 127999, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 1, 595))) // man walking facing right
        trie.insert(intArrayOf(129485, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 463, 463))) // man standing: medium-dark skin tone
        trie.insert(intArrayOf(129485, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 463, 463))) // man standing: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127997), ParseResult(4, SpriteCoordinates(2, 8, 265, 463))) // person kneeling: medium skin tone
        trie.insert(intArrayOf(129486, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 331, 463))) // woman kneeling: medium-light skin tone
        trie.insert(intArrayOf(129486, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 331, 463))) // woman kneeling: medium-light skin tone
        trie.insert(intArrayOf(129486, 127995, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 8, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 8, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127995, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129489, 8205, 129455), ParseResult(5, SpriteCoordinates(2, 8, 331, 331))) // person with white cane
        trie.insert(intArrayOf(129489, 127999, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 397, 133))) // person with white cane facing right
        trie.insert(intArrayOf(129489, 127999, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 397, 133))) // person with white cane facing right
        trie.insert(intArrayOf(128104, 127998, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 859, 133))) // man with white cane facing right
        trie.insert(intArrayOf(128104, 127998, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 859, 133))) // man with white cane facing right
        trie.insert(intArrayOf(128105, 127997, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 793, 529))) // woman with white cane facing right
        trie.insert(intArrayOf(128105, 127997, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 793, 529))) // woman with white cane facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 463, 67))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 463, 67))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127995, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 859, 793))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127995, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 859, 793))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 8205, 129468, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 8, 199, 727))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 8205, 129468, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 8, 199, 727))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127999, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 8, 397, 67))) // person in manual wheelchair: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 8, 859, 67))) // man in manual wheelchair: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 8, 793, 463))) // woman in manual wheelchair: medium skin tone
        trie.insert(intArrayOf(127939, 127996), ParseResult(4, SpriteCoordinates(2, 8, 925, 331))) // person running: medium-light skin tone
        trie.insert(intArrayOf(127939, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 925, 397))) // woman running: light skin tone
        trie.insert(intArrayOf(127939, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 925, 397))) // woman running: light skin tone
        trie.insert(intArrayOf(127939, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 8, 925, 199))) // woman running facing right
        trie.insert(intArrayOf(127939, 8205, 9792, 8205, 10145), ParseResult(6, SpriteCoordinates(2, 8, 925, 199))) // woman running facing right
        trie.insert(intArrayOf(127939, 8205, 9792, 65039, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 8, 925, 199))) // woman running facing right
        trie.insert(intArrayOf(127939, 8205, 9792, 8205, 10145, 65039), ParseResult(7, SpriteCoordinates(2, 8, 925, 199))) // woman running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9794, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 8, 925, 265))) // man running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9794, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 8, 925, 265))) // man running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9794, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 8, 925, 265))) // man running facing right
        trie.insert(intArrayOf(127939, 127999, 8205, 9794, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 8, 925, 265))) // man running facing right
        trie.insert(intArrayOf(128378, 127998), ParseResult(4, SpriteCoordinates(2, 8, 661, 595))) // man dancing: medium-dark skin tone
        trie.insert(intArrayOf(129494), ParseResult(2, SpriteCoordinates(2, 8, 331, 265))) // person in steamy room
        trie.insert(intArrayOf(129494, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 1, 331))) // man in steamy room: dark skin tone
        trie.insert(intArrayOf(129494, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 1, 331))) // man in steamy room: dark skin tone
        trie.insert(intArrayOf(129495, 127998), ParseResult(4, SpriteCoordinates(2, 8, 331, 133))) // person climbing: medium-dark skin tone
        trie.insert(intArrayOf(129495, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 331, 199))) // woman climbing: medium skin tone
        trie.insert(intArrayOf(129495, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 331, 199))) // woman climbing: medium skin tone
        trie.insert(intArrayOf(127938), ParseResult(2, SpriteCoordinates(2, 8, 925, 463))) // snowboarder
        trie.insert(intArrayOf(127948, 127999), ParseResult(4, SpriteCoordinates(2, 8, 661, 859))) // person golfing: dark skin tone
        trie.insert(intArrayOf(127948, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 727, 859))) // woman golfing: medium-dark skin tone
        trie.insert(intArrayOf(127948, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 727, 859))) // woman golfing: medium-dark skin tone
        trie.insert(intArrayOf(127940, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 925, 133))) // man surfing: medium skin tone
        trie.insert(intArrayOf(127940, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 925, 133))) // man surfing: medium skin tone
        trie.insert(intArrayOf(128675, 127996), ParseResult(4, SpriteCoordinates(2, 8, 397, 595))) // person rowing boat: medium-light skin tone
        trie.insert(intArrayOf(128675, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 463, 595))) // woman rowing boat: light skin tone
        trie.insert(intArrayOf(128675, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 463, 595))) // woman rowing boat: light skin tone
        trie.insert(intArrayOf(127946, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 925, 1))) // man swimming
        trie.insert(intArrayOf(127946, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 925, 1))) // man swimming
        trie.insert(intArrayOf(127946, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 925, 67))) // woman swimming: dark skin tone
        trie.insert(intArrayOf(127946, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 925, 67))) // woman swimming: dark skin tone
        trie.insert(intArrayOf(9977, 127998, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 8, 67, 67))) // man bouncing ball: medium-dark skin tone
        trie.insert(intArrayOf(9977, 127998, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 8, 67, 67))) // man bouncing ball: medium-dark skin tone
        trie.insert(intArrayOf(127947, 127997), ParseResult(4, SpriteCoordinates(2, 8, 793, 859))) // person lifting weights: medium skin tone
        trie.insert(intArrayOf(127947, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 859, 859))) // woman lifting weights: medium-light skin tone
        trie.insert(intArrayOf(127947, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 859, 859))) // woman lifting weights: medium-light skin tone
        trie.insert(intArrayOf(128692, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 331, 595))) // man biking: light skin tone
        trie.insert(intArrayOf(128692, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 331, 595))) // man biking: light skin tone
        trie.insert(intArrayOf(128693), ParseResult(2, SpriteCoordinates(2, 8, 199, 595))) // person mountain biking
        trie.insert(intArrayOf(128693, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 265, 595))) // man mountain biking: dark skin tone
        trie.insert(intArrayOf(128693, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 265, 595))) // man mountain biking: dark skin tone
        trie.insert(intArrayOf(129336, 127998), ParseResult(4, SpriteCoordinates(2, 8, 199, 529))) // person cartwheeling: medium-dark skin tone
        trie.insert(intArrayOf(129336, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 265, 529))) // woman cartwheeling: medium skin tone
        trie.insert(intArrayOf(129336, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 265, 529))) // woman cartwheeling: medium skin tone
        trie.insert(intArrayOf(129341, 127999), ParseResult(4, SpriteCoordinates(2, 8, 529, 463))) // person playing water polo: dark skin tone
        trie.insert(intArrayOf(129341, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 1, 529))) // woman playing water polo: medium-dark skin tone
        trie.insert(intArrayOf(129341, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 1, 529))) // woman playing water polo: medium-dark skin tone
        trie.insert(intArrayOf(129342, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 8, 529, 397))) // man playing handball: medium skin tone
        trie.insert(intArrayOf(129342, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 8, 529, 397))) // man playing handball: medium skin tone
        trie.insert(intArrayOf(129337, 127996), ParseResult(4, SpriteCoordinates(2, 8, 67, 529))) // person juggling: medium-light skin tone
        trie.insert(intArrayOf(129337, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 133, 529))) // woman juggling: light skin tone
        trie.insert(intArrayOf(129337, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 133, 529))) // woman juggling: light skin tone
        trie.insert(intArrayOf(129496, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 8, 331, 1))) // man in lotus position
        trie.insert(intArrayOf(129496, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 8, 331, 1))) // man in lotus position
        trie.insert(intArrayOf(129496, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 8, 331, 67))) // woman in lotus position: dark skin tone
        trie.insert(intArrayOf(129496, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 8, 331, 67))) // woman in lotus position: dark skin tone
        trie.insert(intArrayOf(128716, 127998), ParseResult(4, SpriteCoordinates(2, 8, 595, 463))) // person in bed: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129309, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 8, 463, 199))) // people holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 129309, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 8, 1, 397))) // people holding hands: medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 8, 265, 793))) // women holding hands: light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 8, 793, 133))) // women holding hands: medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128107, 127995), ParseResult(4, SpriteCoordinates(2, 8, 67, 727))) // woman and man holding hands: light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 8, 793, 595))) // woman and man holding hands: medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 8, 595, 727))) // woman and man holding hands: dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 8, 859, 595))) // men holding hands: medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128108, 127998), ParseResult(4, SpriteCoordinates(2, 8, 1, 727))) // men holding hands: medium-dark skin tone
        trie.insert(intArrayOf(128143, 127998), ParseResult(4, SpriteCoordinates(2, 8, 133, 661))) // kiss: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127996), ParseResult(14, SpriteCoordinates(2, 8, 133, 397))) // kiss: person, person, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996), ParseResult(15, SpriteCoordinates(2, 8, 133, 397))) // kiss: person, person, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 8205, 10084, 8205, 128139, 8205, 128104), ParseResult(10, SpriteCoordinates(2, 8, 133, 727))) // kiss: woman, man
        trie.insert(intArrayOf(128105, 8205, 10084, 65039, 8205, 128139, 8205, 128104), ParseResult(11, SpriteCoordinates(2, 8, 133, 727))) // kiss: woman, man
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 8, 793, 397))) // kiss: woman, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 8, 793, 397))) // kiss: woman, man, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 8, 463, 727))) // kiss: woman, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 8, 463, 727))) // kiss: woman, man, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 8, 859, 529))) // kiss: man, man, medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 8, 859, 529))) // kiss: man, man, medium-light skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 8, 859, 1))) // kiss: man, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 8, 859, 1))) // kiss: man, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127997), ParseResult(14, SpriteCoordinates(2, 8, 133, 793))) // kiss: woman, woman, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997), ParseResult(15, SpriteCoordinates(2, 8, 133, 793))) // kiss: woman, woman, light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127998), ParseResult(14, SpriteCoordinates(2, 8, 793, 331))) // kiss: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998), ParseResult(15, SpriteCoordinates(2, 8, 793, 331))) // kiss: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127999), ParseResult(14, SpriteCoordinates(2, 8, 397, 727))) // kiss: woman, woman, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999), ParseResult(15, SpriteCoordinates(2, 8, 397, 727))) // kiss: woman, woman, dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 8, 397, 397))) // couple with heart: person, person, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 129489, 127995), ParseResult(11, SpriteCoordinates(2, 8, 397, 397))) // couple with heart: person, person, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 65039, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 8, 397, 265))) // couple with heart: person, person, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 10084, 8205, 129489, 127999), ParseResult(11, SpriteCoordinates(2, 8, 397, 265))) // couple with heart: person, person, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128104, 127995), ParseResult(11, SpriteCoordinates(2, 8, 1, 793))) // couple with heart: woman, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 8, 1, 793))) // couple with heart: woman, man, medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 8, 793, 1))) // couple with heart: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 8, 793, 1))) // couple with heart: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 8, 859, 727))) // couple with heart: man, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 8, 859, 727))) // couple with heart: man, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 8, 859, 331))) // couple with heart: man, man, medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 8, 859, 331))) // couple with heart: man, man, medium skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 8, 727, 793))) // couple with heart: man, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 8, 727, 793))) // couple with heart: man, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128105, 127998), ParseResult(12, SpriteCoordinates(2, 8, 793, 727))) // couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128105, 127998), ParseResult(11, SpriteCoordinates(2, 8, 793, 727))) // couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128105, 127999), ParseResult(11, SpriteCoordinates(2, 8, 727, 727))) // couple with heart: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 8, 727, 727))) // couple with heart: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 8205, 128104, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 8, 595, 793))) // family: man, man, boy
        trie.insert(intArrayOf(128104, 8205, 128102, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 8, 661, 793))) // family: man, boy, boy
        trie.insert(intArrayOf(128101), ParseResult(2, SpriteCoordinates(2, 8, 265, 859))) // busts in silhouette
        trie.insert(intArrayOf(129306, 127997), ParseResult(4, SpriteCoordinates(2, 9, 595, 397))) // raised back of hand: medium skin tone
        trie.insert(intArrayOf(9995, 127996), ParseResult(3, SpriteCoordinates(2, 9, 1, 67))) // raised hand: medium-light skin tone
        trie.insert(intArrayOf(129777, 127995), ParseResult(4, SpriteCoordinates(2, 9, 1, 199))) // rightwards hand: light skin tone
        trie.insert(intArrayOf(129779), ParseResult(2, SpriteCoordinates(2, 9, 199, 1))) // palm down hand
        trie.insert(intArrayOf(129780, 127999), ParseResult(4, SpriteCoordinates(2, 9, 133, 133))) // palm up hand: dark skin tone
        trie.insert(intArrayOf(129784, 127998), ParseResult(4, SpriteCoordinates(2, 9, 67, 133))) // rightwards pushing hand: medium-dark skin tone
        trie.insert(intArrayOf(129292, 127997), ParseResult(4, SpriteCoordinates(2, 9, 1, 595))) // pinched fingers: medium skin tone
        trie.insert(intArrayOf(9996, 127996), ParseResult(3, SpriteCoordinates(2, 9, 67, 1))) // victory hand: medium-light skin tone
        trie.insert(intArrayOf(129776, 127995), ParseResult(4, SpriteCoordinates(2, 9, 67, 199))) // hand with index finger and thumb crossed: light skin tone
        trie.insert(intArrayOf(129304), ParseResult(2, SpriteCoordinates(2, 9, 595, 529))) // sign of the horns
        trie.insert(intArrayOf(129305, 127999), ParseResult(4, SpriteCoordinates(2, 9, 595, 463))) // call me hand: dark skin tone
        trie.insert(intArrayOf(128073, 127998), ParseResult(4, SpriteCoordinates(2, 9, 727, 859))) // backhand index pointing right: medium-dark skin tone
        trie.insert(intArrayOf(128405, 127997), ParseResult(4, SpriteCoordinates(2, 9, 67, 661))) // middle finger: medium skin tone
        trie.insert(intArrayOf(9757, 127996), ParseResult(3, SpriteCoordinates(2, 9, 1, 133))) // index pointing up: medium-light skin tone
        trie.insert(intArrayOf(128077, 127995), ParseResult(4, SpriteCoordinates(2, 9, 595, 859))) // thumbs up: light skin tone
        trie.insert(intArrayOf(9994), ParseResult(1, SpriteCoordinates(2, 9, 67, 67))) // raised fist
        trie.insert(intArrayOf(128074, 127999), ParseResult(4, SpriteCoordinates(2, 9, 661, 859))) // oncoming fist: dark skin tone
        trie.insert(intArrayOf(129308, 127998), ParseResult(4, SpriteCoordinates(2, 9, 595, 331))) // right-facing fist: medium-dark skin tone
        trie.insert(intArrayOf(128588, 127997), ParseResult(4, SpriteCoordinates(2, 9, 661, 265))) // raising hands: medium skin tone
        trie.insert(intArrayOf(128080, 127996), ParseResult(4, SpriteCoordinates(2, 9, 529, 859))) // open hands: medium-light skin tone
        trie.insert(intArrayOf(129309, 127995), ParseResult(4, SpriteCoordinates(2, 9, 595, 265))) // handshake: light skin tone
        trie.insert(intArrayOf(129777, 127996, 8205, 129778, 127998), ParseResult(9, SpriteCoordinates(2, 9, 199, 133))) // handshake: medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129777, 127999, 8205, 129778, 127996), ParseResult(9, SpriteCoordinates(2, 9, 199, 67))) // handshake: dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(9997, 127996), ParseResult(3, SpriteCoordinates(2, 9, 1, 1))) // writing hand: medium-light skin tone
        trie.insert(intArrayOf(129331, 127995), ParseResult(4, SpriteCoordinates(2, 9, 595, 67))) // selfie: light skin tone
        trie.insert(intArrayOf(129470), ParseResult(2, SpriteCoordinates(2, 9, 529, 67))) // mechanical arm
        trie.insert(intArrayOf(129462, 127997), ParseResult(4, SpriteCoordinates(2, 9, 529, 397))) // foot: medium skin tone
        trie.insert(intArrayOf(129467, 127996), ParseResult(4, SpriteCoordinates(2, 9, 529, 133))) // ear with hearing aid: medium-light skin tone
        trie.insert(intArrayOf(129728), ParseResult(2, SpriteCoordinates(2, 9, 265, 67))) // anatomical heart
        trie.insert(intArrayOf(128118, 127996), ParseResult(4, SpriteCoordinates(2, 9, 727, 331))) // baby: medium-light skin tone
        trie.insert(intArrayOf(128102, 127995), ParseResult(4, SpriteCoordinates(2, 9, 463, 859))) // boy: light skin tone
        trie.insert(intArrayOf(129489), ParseResult(2, SpriteCoordinates(2, 9, 331, 331))) // person
        trie.insert(intArrayOf(128113, 127999), ParseResult(4, SpriteCoordinates(2, 9, 727, 661))) // person: dark skin tone, blond hair
        trie.insert(intArrayOf(129492, 127998), ParseResult(4, SpriteCoordinates(2, 9, 199, 331))) // person: medium-dark skin tone, beard
        trie.insert(intArrayOf(129492, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 331))) // woman: medium skin tone, beard
        trie.insert(intArrayOf(129492, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 265, 331))) // woman: medium skin tone, beard
        trie.insert(intArrayOf(128104, 127996, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 9, 859, 793))) // man: medium-light skin tone, curly hair
        trie.insert(intArrayOf(128104, 127995, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 9, 265, 859))) // man: light skin tone, bald
        trie.insert(intArrayOf(128105, 8205, 129456), ParseResult(5, SpriteCoordinates(2, 9, 397, 727))) // woman: red hair
        trie.insert(intArrayOf(129489, 127999, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 9, 397, 199))) // person: dark skin tone, red hair
        trie.insert(intArrayOf(129489, 127998, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 9, 1, 397))) // person: medium-dark skin tone, curly hair
        trie.insert(intArrayOf(129489, 127997, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 9, 397, 397))) // person: medium skin tone, white hair
        trie.insert(intArrayOf(129489, 127996, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 9, 463, 133))) // person: medium-light skin tone, bald
        trie.insert(intArrayOf(128113, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 1, 727))) // man: light skin tone, blond hair
        trie.insert(intArrayOf(128113, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 1, 727))) // man: light skin tone, blond hair
        trie.insert(intArrayOf(128116), ParseResult(2, SpriteCoordinates(2, 9, 727, 463))) // old man
        trie.insert(intArrayOf(128117, 127999), ParseResult(4, SpriteCoordinates(2, 9, 727, 397))) // old woman: dark skin tone
        trie.insert(intArrayOf(128589, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 661, 199))) // man frowning: medium-dark skin tone
        trie.insert(intArrayOf(128589, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 661, 199))) // man frowning: medium-dark skin tone
        trie.insert(intArrayOf(128590, 127997), ParseResult(4, SpriteCoordinates(2, 9, 661, 67))) // person pouting: medium skin tone
        trie.insert(intArrayOf(128590, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 661, 133))) // woman pouting: medium-light skin tone
        trie.insert(intArrayOf(128590, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 661, 133))) // woman pouting: medium-light skin tone
        trie.insert(intArrayOf(128581, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 1, 661))) // man gesturing NO: light skin tone
        trie.insert(intArrayOf(128581, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 1, 661))) // man gesturing NO: light skin tone
        trie.insert(intArrayOf(128582), ParseResult(2, SpriteCoordinates(2, 9, 661, 529))) // person gesturing OK
        trie.insert(intArrayOf(128582, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 661, 595))) // man gesturing OK: dark skin tone
        trie.insert(intArrayOf(128582, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 661, 595))) // man gesturing OK: dark skin tone
        trie.insert(intArrayOf(128129, 127998), ParseResult(4, SpriteCoordinates(2, 9, 727, 67))) // person tipping hand: medium-dark skin tone
        trie.insert(intArrayOf(128129, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 727, 133))) // woman tipping hand: medium skin tone
        trie.insert(intArrayOf(128129, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 727, 133))) // woman tipping hand: medium skin tone
        trie.insert(intArrayOf(128587, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 661, 331))) // man raising hand: medium-light skin tone
        trie.insert(intArrayOf(128587, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 661, 331))) // man raising hand: medium-light skin tone
        trie.insert(intArrayOf(129487, 127995), ParseResult(4, SpriteCoordinates(2, 9, 199, 463))) // deaf person: light skin tone
        trie.insert(intArrayOf(129487, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 9, 133, 463))) // deaf woman
        trie.insert(intArrayOf(129487, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 9, 133, 463))) // deaf woman
        trie.insert(intArrayOf(128583, 127999), ParseResult(4, SpriteCoordinates(2, 9, 661, 397))) // person bowing: dark skin tone
        trie.insert(intArrayOf(128583, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 661, 463))) // woman bowing: medium-dark skin tone
        trie.insert(intArrayOf(128583, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 661, 463))) // woman bowing: medium-dark skin tone
        trie.insert(intArrayOf(129318, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 595, 199))) // man facepalming: medium skin tone
        trie.insert(intArrayOf(129318, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 595, 199))) // man facepalming: medium skin tone
        trie.insert(intArrayOf(129335, 127996), ParseResult(4, SpriteCoordinates(2, 9, 463, 529))) // person shrugging: medium-light skin tone
        trie.insert(intArrayOf(129335, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 529, 529))) // woman shrugging: light skin tone
        trie.insert(intArrayOf(129335, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 529, 529))) // woman shrugging: light skin tone
        trie.insert(intArrayOf(128104, 8205, 9877, 65039), ParseResult(5, SpriteCoordinates(2, 9, 529, 793))) // man health worker
        trie.insert(intArrayOf(128104, 8205, 9877), ParseResult(4, SpriteCoordinates(2, 9, 529, 793))) // man health worker
        trie.insert(intArrayOf(128105, 127999, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 9, 595, 727))) // woman health worker: dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 9, 595, 727))) // woman health worker: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 9, 859, 463))) // man student: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 9, 463, 1))) // teacher: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 9, 67, 793))) // woman teacher: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 9, 199, 859))) // man judge: light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 9, 199, 859))) // man judge: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127806), ParseResult(5, SpriteCoordinates(2, 9, 67, 463))) // farmer
        trie.insert(intArrayOf(128104, 127999, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 9, 859, 199))) // man farmer: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 9, 133, 397))) // cook: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 9, 793, 529))) // woman cook: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 9, 67, 859))) // man mechanic: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 9, 1, 463))) // factory worker: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127981), ParseResult(5, SpriteCoordinates(2, 9, 463, 793))) // woman factory worker
        trie.insert(intArrayOf(129489, 127999, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 9, 397, 331))) // office worker: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 9, 793, 331))) // woman office worker: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 9, 859, 595))) // man scientist: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 9, 463, 265))) // technologist: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 9, 397, 793))) // woman technologist: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127908), ParseResult(5, SpriteCoordinates(2, 9, 397, 859))) // man singer
    }

    private fun init8(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(128105, 127999, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 9, 727, 727))) // woman singer: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 9, 859, 397))) // man artist: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 9, 265, 397))) // pilot: medium skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 397))) // pilot: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 9, 793, 727))) // woman pilot: medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 9, 793, 727))) // woman pilot: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 9, 331, 859))) // man astronaut: light skin tone
        trie.insert(intArrayOf(129489, 8205, 128658), ParseResult(5, SpriteCoordinates(2, 9, 397, 67))) // firefighter
        trie.insert(intArrayOf(128104, 127999, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 9, 859, 133))) // man firefighter: dark skin tone
        trie.insert(intArrayOf(128110, 127998), ParseResult(4, SpriteCoordinates(2, 9, 199, 727))) // police officer: medium-dark skin tone
        trie.insert(intArrayOf(128110, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 265, 727))) // woman police officer: medium skin tone
        trie.insert(intArrayOf(128110, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 727))) // woman police officer: medium skin tone
        trie.insert(intArrayOf(128373, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 199, 661))) // man detective: medium-light skin tone
        trie.insert(intArrayOf(128373, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 199, 661))) // man detective: medium-light skin tone
        trie.insert(intArrayOf(128130, 127995), ParseResult(4, SpriteCoordinates(2, 9, 727, 1))) // guard: light skin tone
        trie.insert(intArrayOf(128130, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 9, 661, 661))) // woman guard
        trie.insert(intArrayOf(128130, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 9, 661, 661))) // woman guard
        trie.insert(intArrayOf(129399, 127999), ParseResult(4, SpriteCoordinates(2, 9, 529, 463))) // ninja: dark skin tone
        trie.insert(intArrayOf(128119, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 727, 265))) // man construction worker: medium-dark skin tone
        trie.insert(intArrayOf(128119, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 727, 265))) // man construction worker: medium-dark skin tone
        trie.insert(intArrayOf(129733, 127997), ParseResult(4, SpriteCoordinates(2, 9, 133, 199))) // person with crown: medium skin tone
        trie.insert(intArrayOf(128120, 127996), ParseResult(4, SpriteCoordinates(2, 9, 727, 199))) // princess: medium-light skin tone
        trie.insert(intArrayOf(128115, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 727, 529))) // man wearing turban: light skin tone
        trie.insert(intArrayOf(128115, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 727, 529))) // man wearing turban: light skin tone
        trie.insert(intArrayOf(128114), ParseResult(2, SpriteCoordinates(2, 9, 727, 595))) // person with skullcap
        trie.insert(intArrayOf(129493, 127999), ParseResult(4, SpriteCoordinates(2, 9, 133, 331))) // woman with headscarf: dark skin tone
        trie.insert(intArrayOf(129333, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 595, 1))) // man in tuxedo: medium-dark skin tone
        trie.insert(intArrayOf(129333, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 595, 1))) // man in tuxedo: medium-dark skin tone
        trie.insert(intArrayOf(128112, 127997), ParseResult(4, SpriteCoordinates(2, 9, 67, 727))) // person with veil: medium skin tone
        trie.insert(intArrayOf(128112, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 133, 727))) // woman with veil: medium-light skin tone
        trie.insert(intArrayOf(128112, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 133, 727))) // woman with veil: medium-light skin tone
        trie.insert(intArrayOf(129731, 127995), ParseResult(4, SpriteCoordinates(2, 9, 199, 199))) // pregnant man: light skin tone
        trie.insert(intArrayOf(129329), ParseResult(2, SpriteCoordinates(2, 9, 595, 133))) // breast-feeding
        trie.insert(intArrayOf(128105, 127999, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 9, 793, 1))) // woman feeding baby: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 9, 67, 397))) // person feeding baby: medium-dark skin tone
        trie.insert(intArrayOf(127877, 127997), ParseResult(4, SpriteCoordinates(2, 9, 925, 529))) // Santa Claus: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127876), ParseResult(7, SpriteCoordinates(2, 9, 463, 331))) // Mx Claus: medium-light skin tone
        trie.insert(intArrayOf(129464, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 529, 331))) // man superhero: light skin tone
        trie.insert(intArrayOf(129464, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 529, 331))) // man superhero: light skin tone
        trie.insert(intArrayOf(129465), ParseResult(2, SpriteCoordinates(2, 9, 529, 199))) // supervillain
        trie.insert(intArrayOf(129465, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 529, 265))) // man supervillain: dark skin tone
        trie.insert(intArrayOf(129465, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 529, 265))) // man supervillain: dark skin tone
        trie.insert(intArrayOf(129497, 127998), ParseResult(4, SpriteCoordinates(2, 9, 331, 1))) // mage: medium-dark skin tone
        trie.insert(intArrayOf(129497, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 331, 67))) // woman mage: medium skin tone
        trie.insert(intArrayOf(129497, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 331, 67))) // woman mage: medium skin tone
        trie.insert(intArrayOf(129498, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 265))) // man fairy: medium-light skin tone
        trie.insert(intArrayOf(129498, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 265, 265))) // man fairy: medium-light skin tone
        trie.insert(intArrayOf(129499, 127995), ParseResult(4, SpriteCoordinates(2, 9, 199, 265))) // vampire: light skin tone
        trie.insert(intArrayOf(129499, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 9, 133, 265))) // woman vampire
        trie.insert(intArrayOf(129499, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 9, 133, 265))) // woman vampire
        trie.insert(intArrayOf(129500, 127999), ParseResult(4, SpriteCoordinates(2, 9, 1, 265))) // merperson: dark skin tone
        trie.insert(intArrayOf(129500, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 67, 265))) // mermaid: medium-dark skin tone
        trie.insert(intArrayOf(129500, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 67, 265))) // mermaid: medium-dark skin tone
        trie.insert(intArrayOf(129501, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 265, 199))) // man elf: medium skin tone
        trie.insert(intArrayOf(129501, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 199))) // man elf: medium skin tone
        trie.insert(intArrayOf(129502, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 9, 265, 133))) // woman genie
        trie.insert(intArrayOf(129502, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 9, 265, 133))) // woman genie
        trie.insert(intArrayOf(128134, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 9, 463, 661))) // man getting massage
        trie.insert(intArrayOf(128134, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 9, 463, 661))) // man getting massage
        trie.insert(intArrayOf(128134, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 529, 661))) // woman getting massage: dark skin tone
        trie.insert(intArrayOf(128134, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 529, 661))) // woman getting massage: dark skin tone
        trie.insert(intArrayOf(128135, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 397, 661))) // man getting haircut: medium-dark skin tone
        trie.insert(intArrayOf(128135, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 397, 661))) // man getting haircut: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127997), ParseResult(4, SpriteCoordinates(2, 9, 199, 595))) // person walking: medium skin tone
        trie.insert(intArrayOf(128694, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 595))) // woman walking: medium-light skin tone
        trie.insert(intArrayOf(128694, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 265, 595))) // woman walking: medium-light skin tone
        trie.insert(intArrayOf(128694, 127995, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 331, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 331, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 9, 331, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127995, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 9, 331, 595))) // woman walking facing right
        trie.insert(intArrayOf(129485), ParseResult(2, SpriteCoordinates(2, 9, 463, 463))) // person standing
        trie.insert(intArrayOf(129485, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 529, 1))) // man standing: dark skin tone
        trie.insert(intArrayOf(129485, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 529, 1))) // man standing: dark skin tone
        trie.insert(intArrayOf(129486, 127998), ParseResult(4, SpriteCoordinates(2, 9, 265, 463))) // person kneeling: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 331, 463))) // woman kneeling: medium skin tone
        trie.insert(intArrayOf(129486, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 331, 463))) // woman kneeling: medium skin tone
        trie.insert(intArrayOf(129486, 127996, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 9, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 9, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127996, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 9, 463, 397))) // person with white cane: light skin tone
        trie.insert(intArrayOf(128104, 8205, 129455), ParseResult(5, SpriteCoordinates(2, 9, 595, 793))) // man with white cane
        trie.insert(intArrayOf(128104, 127999, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 859, 67))) // man with white cane facing right
        trie.insert(intArrayOf(128104, 127999, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 859, 67))) // man with white cane facing right
        trie.insert(intArrayOf(128105, 127998, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 793, 199))) // woman with white cane facing right
        trie.insert(intArrayOf(128105, 127998, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 793, 199))) // woman with white cane facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 331, 397))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127997, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 331, 397))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127996, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 859, 727))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127996, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 859, 727))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127995, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 265, 793))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127995, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 265, 793))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 8205, 129469, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 9, 397, 1))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(129489, 8205, 129469, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 9, 397, 1))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 127999, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 9, 859, 1))) // man in manual wheelchair: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 9, 793, 133))) // woman in manual wheelchair: medium-dark skin tone
        trie.insert(intArrayOf(127939, 127997), ParseResult(4, SpriteCoordinates(2, 9, 925, 265))) // person running: medium skin tone
        trie.insert(intArrayOf(127939, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 925, 331))) // woman running: medium-light skin tone
        trie.insert(intArrayOf(127939, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 925, 331))) // woman running: medium-light skin tone
        trie.insert(intArrayOf(127939, 127995, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 9, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 9, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 9, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(127939, 127995, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 9, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(128131), ParseResult(2, SpriteCoordinates(2, 9, 595, 661))) // woman dancing
        trie.insert(intArrayOf(128378, 127999), ParseResult(4, SpriteCoordinates(2, 9, 133, 661))) // man dancing: dark skin tone
        trie.insert(intArrayOf(129494, 127995), ParseResult(4, SpriteCoordinates(2, 9, 67, 331))) // person in steamy room: light skin tone
        trie.insert(intArrayOf(129494, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 9, 1, 331))) // woman in steamy room
        trie.insert(intArrayOf(129494, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 9, 1, 331))) // woman in steamy room
        trie.insert(intArrayOf(129495, 127999), ParseResult(4, SpriteCoordinates(2, 9, 331, 199))) // person climbing: dark skin tone
        trie.insert(intArrayOf(129495, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 331, 265))) // woman climbing: medium-dark skin tone
        trie.insert(intArrayOf(129495, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 331, 265))) // woman climbing: medium-dark skin tone
        trie.insert(intArrayOf(127938, 127995), ParseResult(4, SpriteCoordinates(2, 9, 925, 463))) // snowboarder: light skin tone
        trie.insert(intArrayOf(127948, 65039, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 9, 793, 859))) // man golfing
        trie.insert(intArrayOf(127948, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 9, 793, 859))) // man golfing
        trie.insert(intArrayOf(127948, 65039, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 9, 793, 859))) // man golfing
        trie.insert(intArrayOf(127948, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 9, 793, 859))) // man golfing
        trie.insert(intArrayOf(127948, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 859, 859))) // woman golfing: dark skin tone
        trie.insert(intArrayOf(127948, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 859, 859))) // woman golfing: dark skin tone
        trie.insert(intArrayOf(127940, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 925, 199))) // man surfing: medium-dark skin tone
        trie.insert(intArrayOf(127940, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 925, 199))) // man surfing: medium-dark skin tone
        trie.insert(intArrayOf(128675, 127997), ParseResult(4, SpriteCoordinates(2, 9, 595, 595))) // person rowing boat: medium skin tone
        trie.insert(intArrayOf(128675, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 661, 1))) // woman rowing boat: medium-light skin tone
        trie.insert(intArrayOf(128675, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 661, 1))) // woman rowing boat: medium-light skin tone
        trie.insert(intArrayOf(127946, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 925, 133))) // man swimming: light skin tone
        trie.insert(intArrayOf(127946, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 925, 133))) // man swimming: light skin tone
        trie.insert(intArrayOf(9977, 65039), ParseResult(2, SpriteCoordinates(2, 9, 133, 1))) // person bouncing ball
        trie.insert(intArrayOf(9977), ParseResult(1, SpriteCoordinates(2, 9, 133, 1))) // person bouncing ball
        trie.insert(intArrayOf(9977, 127999, 8205, 9794, 65039), ParseResult(6, SpriteCoordinates(2, 9, 133, 67))) // man bouncing ball: dark skin tone
        trie.insert(intArrayOf(9977, 127999, 8205, 9794), ParseResult(5, SpriteCoordinates(2, 9, 133, 67))) // man bouncing ball: dark skin tone
        trie.insert(intArrayOf(127947, 127998), ParseResult(4, SpriteCoordinates(2, 9, 925, 1))) // person lifting weights: medium-dark skin tone
        trie.insert(intArrayOf(127947, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 925, 67))) // woman lifting weights: medium skin tone
        trie.insert(intArrayOf(127947, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 925, 67))) // woman lifting weights: medium skin tone
        trie.insert(intArrayOf(128692, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 529, 595))) // man biking: medium-light skin tone
        trie.insert(intArrayOf(128692, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 529, 595))) // man biking: medium-light skin tone
        trie.insert(intArrayOf(128693, 127995), ParseResult(4, SpriteCoordinates(2, 9, 463, 595))) // person mountain biking: light skin tone
        trie.insert(intArrayOf(128693, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 9, 397, 595))) // woman mountain biking
        trie.insert(intArrayOf(128693, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 9, 397, 595))) // woman mountain biking
        trie.insert(intArrayOf(129336, 127999), ParseResult(4, SpriteCoordinates(2, 9, 331, 529))) // person cartwheeling: dark skin tone
        trie.insert(intArrayOf(129336, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 397, 529))) // woman cartwheeling: medium-dark skin tone
        trie.insert(intArrayOf(129336, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 397, 529))) // woman cartwheeling: medium-dark skin tone
        trie.insert(intArrayOf(129341, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 9, 67, 529))) // man playing water polo
        trie.insert(intArrayOf(129341, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 9, 67, 529))) // man playing water polo
        trie.insert(intArrayOf(129341, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 133, 529))) // woman playing water polo: dark skin tone
        trie.insert(intArrayOf(129341, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 133, 529))) // woman playing water polo: dark skin tone
        trie.insert(intArrayOf(129342, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 1, 529))) // man playing handball: medium-dark skin tone
        trie.insert(intArrayOf(129342, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 1, 529))) // man playing handball: medium-dark skin tone
        trie.insert(intArrayOf(129337, 127997), ParseResult(4, SpriteCoordinates(2, 9, 199, 529))) // person juggling: medium skin tone
        trie.insert(intArrayOf(129337, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 9, 265, 529))) // woman juggling: medium-light skin tone
        trie.insert(intArrayOf(129337, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 9, 265, 529))) // woman juggling: medium-light skin tone
        trie.insert(intArrayOf(129496, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 9, 331, 133))) // man in lotus position: light skin tone
        trie.insert(intArrayOf(129496, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 9, 331, 133))) // man in lotus position: light skin tone
        trie.insert(intArrayOf(128704), ParseResult(2, SpriteCoordinates(2, 9, 133, 595))) // person taking bath
        trie.insert(intArrayOf(128716, 127999), ParseResult(4, SpriteCoordinates(2, 9, 67, 595))) // person in bed: dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 129309, 8205, 129489, 127999), ParseResult(12, SpriteCoordinates(2, 9, 463, 199))) // people holding hands: medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 129309, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 9, 397, 265))) // people holding hands: dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 129309, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 9, 1, 793))) // women holding hands: medium-light skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 9, 793, 265))) // women holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 9, 331, 793))) // woman and man holding hands: light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128107, 127997), ParseResult(4, SpriteCoordinates(2, 9, 331, 727))) // woman and man holding hands: medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 9, 661, 727))) // woman and man holding hands: dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 9, 1, 859))) // men holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 9, 859, 331))) // men holding hands: medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128143, 127999), ParseResult(4, SpriteCoordinates(2, 9, 331, 661))) // kiss: dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127998), ParseResult(14, SpriteCoordinates(2, 9, 199, 397))) // kiss: person, person, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998), ParseResult(15, SpriteCoordinates(2, 9, 199, 397))) // kiss: person, person, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127995), ParseResult(14, SpriteCoordinates(2, 9, 199, 793))) // kiss: woman, man, light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995), ParseResult(15, SpriteCoordinates(2, 9, 199, 793))) // kiss: woman, man, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 9, 793, 463))) // kiss: woman, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 9, 793, 463))) // kiss: woman, man, medium skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 9, 463, 727))) // kiss: woman, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 9, 463, 727))) // kiss: woman, man, dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 9, 859, 661))) // kiss: man, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 9, 859, 661))) // kiss: man, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 9, 859, 265))) // kiss: man, man, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 9, 859, 265))) // kiss: man, man, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998), ParseResult(15, SpriteCoordinates(2, 9, 133, 793))) // kiss: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127998), ParseResult(14, SpriteCoordinates(2, 9, 133, 793))) // kiss: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999), ParseResult(15, SpriteCoordinates(2, 9, 793, 397))) // kiss: woman, woman, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127999), ParseResult(14, SpriteCoordinates(2, 9, 793, 397))) // kiss: woman, woman, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128145), ParseResult(2, SpriteCoordinates(2, 9, 265, 661))) // couple with heart
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 129489, 127997), ParseResult(11, SpriteCoordinates(2, 9, 463, 67))) // couple with heart: person, person, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 129489, 127997), ParseResult(12, SpriteCoordinates(2, 9, 463, 67))) // couple with heart: person, person, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 129489, 127995), ParseResult(11, SpriteCoordinates(2, 9, 397, 133))) // couple with heart: person, person, dark skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 9, 397, 133))) // couple with heart: person, person, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128104, 127996), ParseResult(12, SpriteCoordinates(2, 9, 793, 661))) // couple with heart: woman, man, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128104, 127996), ParseResult(11, SpriteCoordinates(2, 9, 793, 661))) // couple with heart: woman, man, medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 9, 793, 67))) // couple with heart: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 9, 793, 67))) // couple with heart: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 9, 133, 859))) // couple with heart: man, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 9, 133, 859))) // couple with heart: man, man, light skin tone, medium skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 9, 859, 529))) // couple with heart: man, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 9, 859, 529))) // couple with heart: man, man, medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 9, 793, 793))) // couple with heart: man, man, dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 9, 793, 793))) // couple with heart: man, man, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128105, 127999), ParseResult(12, SpriteCoordinates(2, 9, 793, 595))) // couple with heart: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128105, 127999), ParseResult(11, SpriteCoordinates(2, 9, 793, 595))) // couple with heart: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 9, 529, 727))) // couple with heart: woman, woman, dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128105, 127995), ParseResult(11, SpriteCoordinates(2, 9, 529, 727))) // couple with heart: woman, woman, dark skin tone, light skin tone
        trie.insert(intArrayOf(128104, 8205, 128104, 8205, 128103), ParseResult(8, SpriteCoordinates(2, 9, 661, 793))) // family: man, man, girl
        trie.insert(intArrayOf(128104, 8205, 128103), ParseResult(5, SpriteCoordinates(2, 9, 727, 793))) // family: man, girl
        trie.insert(intArrayOf(129730), ParseResult(2, SpriteCoordinates(2, 9, 265, 1))) // people hugging
        trie.insert(intArrayOf(129306, 127998), ParseResult(4, SpriteCoordinates(2, 10, 595, 463))) // raised back of hand: medium-dark skin tone
        trie.insert(intArrayOf(9995, 127997), ParseResult(3, SpriteCoordinates(2, 10, 1, 67))) // raised hand: medium skin tone
        trie.insert(intArrayOf(129777, 127996), ParseResult(4, SpriteCoordinates(2, 10, 199, 133))) // rightwards hand: medium-light skin tone
        trie.insert(intArrayOf(129779, 127995), ParseResult(4, SpriteCoordinates(2, 10, 199, 1))) // palm down hand: light skin tone
        trie.insert(intArrayOf(129783), ParseResult(2, SpriteCoordinates(2, 10, 133, 133))) // leftwards pushing hand
        trie.insert(intArrayOf(129784, 127999), ParseResult(4, SpriteCoordinates(2, 10, 67, 133))) // rightwards pushing hand: dark skin tone
        trie.insert(intArrayOf(129292, 127998), ParseResult(4, SpriteCoordinates(2, 10, 1, 595))) // pinched fingers: medium-dark skin tone
        trie.insert(intArrayOf(9996, 127997), ParseResult(3, SpriteCoordinates(2, 10, 67, 1))) // victory hand: medium skin tone
        trie.insert(intArrayOf(129776, 127996), ParseResult(4, SpriteCoordinates(2, 10, 67, 199))) // hand with index finger and thumb crossed: medium-light skin tone
        trie.insert(intArrayOf(129304, 127995), ParseResult(4, SpriteCoordinates(2, 10, 595, 529))) // sign of the horns: light skin tone
        trie.insert(intArrayOf(128072), ParseResult(2, SpriteCoordinates(2, 10, 727, 859))) // backhand index pointing left
        trie.insert(intArrayOf(128073, 127999), ParseResult(4, SpriteCoordinates(2, 10, 661, 859))) // backhand index pointing right: dark skin tone
        trie.insert(intArrayOf(128405, 127998), ParseResult(4, SpriteCoordinates(2, 10, 67, 661))) // middle finger: medium-dark skin tone
        trie.insert(intArrayOf(9757, 127997), ParseResult(3, SpriteCoordinates(2, 10, 1, 133))) // index pointing up: medium skin tone
        trie.insert(intArrayOf(128077, 127996), ParseResult(4, SpriteCoordinates(2, 10, 595, 859))) // thumbs up: medium-light skin tone
        trie.insert(intArrayOf(9994, 127995), ParseResult(3, SpriteCoordinates(2, 10, 67, 67))) // raised fist: light skin tone
        trie.insert(intArrayOf(129307), ParseResult(2, SpriteCoordinates(2, 10, 595, 397))) // left-facing fist
        trie.insert(intArrayOf(129308, 127999), ParseResult(4, SpriteCoordinates(2, 10, 595, 331))) // right-facing fist: dark skin tone
        trie.insert(intArrayOf(128588, 127998), ParseResult(4, SpriteCoordinates(2, 10, 661, 265))) // raising hands: medium-dark skin tone
        trie.insert(intArrayOf(128080, 127997), ParseResult(4, SpriteCoordinates(2, 10, 529, 859))) // open hands: medium skin tone
        trie.insert(intArrayOf(129309, 127996), ParseResult(4, SpriteCoordinates(2, 10, 595, 265))) // handshake: medium-light skin tone
        trie.insert(intArrayOf(129777, 127996, 8205, 129778, 127999), ParseResult(9, SpriteCoordinates(2, 10, 1, 199))) // handshake: medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(129777, 127999, 8205, 129778, 127997), ParseResult(9, SpriteCoordinates(2, 10, 199, 67))) // handshake: dark skin tone, medium skin tone
        trie.insert(intArrayOf(9997, 127997), ParseResult(3, SpriteCoordinates(2, 10, 1, 1))) // writing hand: medium skin tone
        trie.insert(intArrayOf(129331, 127996), ParseResult(4, SpriteCoordinates(2, 10, 595, 67))) // selfie: medium-light skin tone
        trie.insert(intArrayOf(129471), ParseResult(2, SpriteCoordinates(2, 10, 529, 67))) // mechanical leg
        trie.insert(intArrayOf(129462, 127998), ParseResult(4, SpriteCoordinates(2, 10, 529, 397))) // foot: medium-dark skin tone
        trie.insert(intArrayOf(129467, 127997), ParseResult(4, SpriteCoordinates(2, 10, 529, 133))) // ear with hearing aid: medium skin tone
        trie.insert(intArrayOf(129729), ParseResult(2, SpriteCoordinates(2, 10, 265, 1))) // lungs
        trie.insert(intArrayOf(128118, 127997), ParseResult(4, SpriteCoordinates(2, 10, 727, 331))) // baby: medium skin tone
        trie.insert(intArrayOf(128102, 127996), ParseResult(4, SpriteCoordinates(2, 10, 463, 859))) // boy: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995), ParseResult(4, SpriteCoordinates(2, 10, 463, 133))) // person: light skin tone
        trie.insert(intArrayOf(128104), ParseResult(2, SpriteCoordinates(2, 10, 595, 793))) // man
        trie.insert(intArrayOf(129492, 127999), ParseResult(4, SpriteCoordinates(2, 10, 67, 331))) // person: dark skin tone, beard
        trie.insert(intArrayOf(129492, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 133, 331))) // woman: medium-dark skin tone, beard
        trie.insert(intArrayOf(129492, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 133, 331))) // woman: medium-dark skin tone, beard
        trie.insert(intArrayOf(128104, 127997, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 10, 859, 529))) // man: medium skin tone, curly hair
        trie.insert(intArrayOf(128104, 127996, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 10, 859, 793))) // man: medium-light skin tone, bald
        trie.insert(intArrayOf(128105, 127995, 8205, 129456), ParseResult(7, SpriteCoordinates(2, 10, 331, 793))) // woman: light skin tone, red hair
        trie.insert(intArrayOf(128105, 8205, 129457), ParseResult(5, SpriteCoordinates(2, 10, 463, 727))) // woman: curly hair
        trie.insert(intArrayOf(129489, 127999, 8205, 129457), ParseResult(7, SpriteCoordinates(2, 10, 331, 331))) // person: dark skin tone, curly hair
        trie.insert(intArrayOf(129489, 127998, 8205, 129459), ParseResult(7, SpriteCoordinates(2, 10, 397, 331))) // person: medium-dark skin tone, white hair
        trie.insert(intArrayOf(129489, 127997, 8205, 129458), ParseResult(7, SpriteCoordinates(2, 10, 133, 397))) // person: medium skin tone, bald
        trie.insert(intArrayOf(128113, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 727, 595))) // man: medium-light skin tone, blond hair
        trie.insert(intArrayOf(128113, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 727, 595))) // man: medium-light skin tone, blond hair
        trie.insert(intArrayOf(128116, 127995), ParseResult(4, SpriteCoordinates(2, 10, 727, 397))) // old man: light skin tone
        trie.insert(intArrayOf(128589), ParseResult(2, SpriteCoordinates(2, 10, 661, 133))) // person frowning
        trie.insert(intArrayOf(128589, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 661, 199))) // man frowning: dark skin tone
        trie.insert(intArrayOf(128589, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 661, 199))) // man frowning: dark skin tone
        trie.insert(intArrayOf(128590, 127998), ParseResult(4, SpriteCoordinates(2, 10, 661, 1))) // person pouting: medium-dark skin tone
        trie.insert(intArrayOf(128590, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 661, 67))) // woman pouting: medium skin tone
        trie.insert(intArrayOf(128590, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 661, 67))) // woman pouting: medium skin tone
        trie.insert(intArrayOf(128581, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 1, 661))) // man gesturing NO: medium-light skin tone
        trie.insert(intArrayOf(128581, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 1, 661))) // man gesturing NO: medium-light skin tone
        trie.insert(intArrayOf(128582, 127995), ParseResult(4, SpriteCoordinates(2, 10, 661, 595))) // person gesturing OK: light skin tone
        trie.insert(intArrayOf(128582, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 10, 661, 529))) // woman gesturing OK
        trie.insert(intArrayOf(128582, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 10, 661, 529))) // woman gesturing OK
        trie.insert(intArrayOf(128129, 127999), ParseResult(4, SpriteCoordinates(2, 10, 727, 1))) // person tipping hand: dark skin tone
        trie.insert(intArrayOf(128129, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 727, 67))) // woman tipping hand: medium-dark skin tone
        trie.insert(intArrayOf(128129, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 727, 67))) // woman tipping hand: medium-dark skin tone
        trie.insert(intArrayOf(128587, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 661, 331))) // man raising hand: medium skin tone
        trie.insert(intArrayOf(128587, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 661, 331))) // man raising hand: medium skin tone
        trie.insert(intArrayOf(129487, 127996), ParseResult(4, SpriteCoordinates(2, 10, 133, 463))) // deaf person: medium-light skin tone
        trie.insert(intArrayOf(129487, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 199, 463))) // deaf woman: light skin tone
        trie.insert(intArrayOf(129487, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 199, 463))) // deaf woman: light skin tone
        trie.insert(intArrayOf(128583, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 10, 661, 397))) // man bowing
        trie.insert(intArrayOf(128583, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 10, 661, 397))) // man bowing
        trie.insert(intArrayOf(128583, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 661, 463))) // woman bowing: dark skin tone
        trie.insert(intArrayOf(128583, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 661, 463))) // woman bowing: dark skin tone
        trie.insert(intArrayOf(129318, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 595, 199))) // man facepalming: medium-dark skin tone
        trie.insert(intArrayOf(129318, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 595, 199))) // man facepalming: medium-dark skin tone
        trie.insert(intArrayOf(129335, 127997), ParseResult(4, SpriteCoordinates(2, 10, 397, 529))) // person shrugging: medium skin tone
        trie.insert(intArrayOf(129335, 127996, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 463, 529))) // woman shrugging: medium-light skin tone
        trie.insert(intArrayOf(129335, 127996, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 463, 529))) // woman shrugging: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 9877, 65039), ParseResult(7, SpriteCoordinates(2, 10, 199, 859))) // man health worker: light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 9877), ParseResult(6, SpriteCoordinates(2, 10, 199, 859))) // man health worker: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127891), ParseResult(5, SpriteCoordinates(2, 10, 67, 463))) // student
        trie.insert(intArrayOf(128104, 127999, 8205, 127891), ParseResult(7, SpriteCoordinates(2, 10, 859, 199))) // man student: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 10, 1, 397))) // teacher: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 127979), ParseResult(7, SpriteCoordinates(2, 10, 793, 727))) // woman teacher: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 9878, 65039), ParseResult(7, SpriteCoordinates(2, 10, 859, 727))) // man judge: medium-light skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 9878), ParseResult(6, SpriteCoordinates(2, 10, 859, 727))) // man judge: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 127806), ParseResult(7, SpriteCoordinates(2, 10, 463, 397))) // farmer: light skin tone
        trie.insert(intArrayOf(128105, 8205, 127806), ParseResult(5, SpriteCoordinates(2, 10, 529, 793))) // woman farmer
        trie.insert(intArrayOf(129489, 127999, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 10, 397, 133))) // cook: dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 127859), ParseResult(7, SpriteCoordinates(2, 10, 793, 397))) // woman cook: medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 128295), ParseResult(7, SpriteCoordinates(2, 10, 859, 595))) // man mechanic: medium skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 10, 463, 67))) // factory worker: medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 127981), ParseResult(7, SpriteCoordinates(2, 10, 463, 793))) // woman factory worker: light skin tone
        trie.insert(intArrayOf(128104, 8205, 128188), ParseResult(5, SpriteCoordinates(2, 10, 727, 793))) // man office worker
        trie.insert(intArrayOf(128105, 127999, 8205, 128188), ParseResult(7, SpriteCoordinates(2, 10, 793, 133))) // woman office worker: dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 128300), ParseResult(7, SpriteCoordinates(2, 10, 859, 331))) // man scientist: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 10, 265, 397))) // technologist: medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 128187), ParseResult(7, SpriteCoordinates(2, 10, 133, 793))) // woman technologist: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 127908), ParseResult(7, SpriteCoordinates(2, 10, 331, 859))) // man singer: light skin tone
        trie.insert(intArrayOf(129489, 8205, 127912), ParseResult(5, SpriteCoordinates(2, 10, 1, 463))) // artist
        trie.insert(intArrayOf(128104, 127999, 8205, 127912), ParseResult(7, SpriteCoordinates(2, 10, 859, 133))) // man artist: dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 10, 397, 199))) // pilot: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127998, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 10, 397, 199))) // pilot: medium-dark skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 9992), ParseResult(6, SpriteCoordinates(2, 10, 793, 595))) // woman pilot: medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 9992, 65039), ParseResult(7, SpriteCoordinates(2, 10, 793, 595))) // woman pilot: medium skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 128640), ParseResult(7, SpriteCoordinates(2, 10, 67, 859))) // man astronaut: medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 128658), ParseResult(7, SpriteCoordinates(2, 10, 463, 331))) // firefighter: light skin tone
        trie.insert(intArrayOf(128105, 8205, 128658), ParseResult(5, SpriteCoordinates(2, 10, 595, 727))) // woman firefighter
        trie.insert(intArrayOf(128110, 127999), ParseResult(4, SpriteCoordinates(2, 10, 67, 727))) // police officer: dark skin tone
        trie.insert(intArrayOf(128110, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 133, 727))) // woman police officer: medium-dark skin tone
        trie.insert(intArrayOf(128110, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 133, 727))) // woman police officer: medium-dark skin tone
        trie.insert(intArrayOf(128373, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 133, 661))) // man detective: medium skin tone
        trie.insert(intArrayOf(128373, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 133, 661))) // man detective: medium skin tone
        trie.insert(intArrayOf(128130, 127996), ParseResult(4, SpriteCoordinates(2, 10, 595, 661))) // guard: medium-light skin tone
        trie.insert(intArrayOf(128130, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 661, 661))) // woman guard: light skin tone
        trie.insert(intArrayOf(128130, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 661, 661))) // woman guard: light skin tone
        trie.insert(intArrayOf(128119), ParseResult(2, SpriteCoordinates(2, 10, 727, 199))) // construction worker
        trie.insert(intArrayOf(128119, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 727, 265))) // man construction worker: dark skin tone
        trie.insert(intArrayOf(128119, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 727, 265))) // man construction worker: dark skin tone
        trie.insert(intArrayOf(129733, 127998), ParseResult(4, SpriteCoordinates(2, 10, 133, 199))) // person with crown: medium-dark skin tone
        trie.insert(intArrayOf(128120, 127997), ParseResult(4, SpriteCoordinates(2, 10, 727, 133))) // princess: medium skin tone
        trie.insert(intArrayOf(128115, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 727, 463))) // man wearing turban: medium-light skin tone
        trie.insert(intArrayOf(128115, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 727, 463))) // man wearing turban: medium-light skin tone
        trie.insert(intArrayOf(128114, 127995), ParseResult(4, SpriteCoordinates(2, 10, 727, 529))) // person with skullcap: light skin tone
        trie.insert(intArrayOf(129333), ParseResult(2, SpriteCoordinates(2, 10, 529, 529))) // person in tuxedo
        trie.insert(intArrayOf(129333, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 595, 1))) // man in tuxedo: dark skin tone
        trie.insert(intArrayOf(129333, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 595, 1))) // man in tuxedo: dark skin tone
        trie.insert(intArrayOf(128112, 127998), ParseResult(4, SpriteCoordinates(2, 10, 727, 661))) // person with veil: medium-dark skin tone
        trie.insert(intArrayOf(128112, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 1, 727))) // woman with veil: medium skin tone
        trie.insert(intArrayOf(128112, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 1, 727))) // woman with veil: medium skin tone
        trie.insert(intArrayOf(129731, 127996), ParseResult(4, SpriteCoordinates(2, 10, 199, 199))) // pregnant man: medium-light skin tone
        trie.insert(intArrayOf(129329, 127995), ParseResult(4, SpriteCoordinates(2, 10, 595, 133))) // breast-feeding: light skin tone
        trie.insert(intArrayOf(128104, 8205, 127868), ParseResult(5, SpriteCoordinates(2, 10, 397, 859))) // man feeding baby
        trie.insert(intArrayOf(129489, 127999, 8205, 127868), ParseResult(7, SpriteCoordinates(2, 10, 397, 67))) // person feeding baby: dark skin tone
        trie.insert(intArrayOf(127877, 127998), ParseResult(4, SpriteCoordinates(2, 10, 925, 529))) // Santa Claus: medium-dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 127876), ParseResult(7, SpriteCoordinates(2, 10, 331, 397))) // Mx Claus: medium skin tone
        trie.insert(intArrayOf(129464, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 529, 331))) // man superhero: medium-light skin tone
        trie.insert(intArrayOf(129464, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 529, 331))) // man superhero: medium-light skin tone
        trie.insert(intArrayOf(129465, 127995), ParseResult(4, SpriteCoordinates(2, 10, 529, 265))) // supervillain: light skin tone
        trie.insert(intArrayOf(129465, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 10, 529, 199))) // woman supervillain
        trie.insert(intArrayOf(129465, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 10, 529, 199))) // woman supervillain
        trie.insert(intArrayOf(129497, 127999), ParseResult(4, SpriteCoordinates(2, 10, 265, 265))) // mage: dark skin tone
        trie.insert(intArrayOf(129497, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 331, 1))) // woman mage: medium-dark skin tone
        trie.insert(intArrayOf(129497, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 331, 1))) // woman mage: medium-dark skin tone
        trie.insert(intArrayOf(129498, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 199, 265))) // man fairy: medium skin tone
        trie.insert(intArrayOf(129498, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 199, 265))) // man fairy: medium skin tone
        trie.insert(intArrayOf(129499, 127996), ParseResult(4, SpriteCoordinates(2, 10, 67, 265))) // vampire: medium-light skin tone
        trie.insert(intArrayOf(129499, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 133, 265))) // woman vampire: light skin tone
        trie.insert(intArrayOf(129499, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 133, 265))) // woman vampire: light skin tone
        trie.insert(intArrayOf(129500, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 10, 265, 199))) // merman
        trie.insert(intArrayOf(129500, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 10, 265, 199))) // merman
        trie.insert(intArrayOf(129500, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 1, 265))) // mermaid: dark skin tone
        trie.insert(intArrayOf(129500, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 1, 265))) // mermaid: dark skin tone
        trie.insert(intArrayOf(129501, 127998, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 265, 133))) // man elf: medium-dark skin tone
        trie.insert(intArrayOf(129501, 127998, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 265, 133))) // man elf: medium-dark skin tone
        trie.insert(intArrayOf(129503), ParseResult(2, SpriteCoordinates(2, 10, 265, 67))) // zombie
        trie.insert(intArrayOf(128134, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 463, 661))) // man getting massage: light skin tone
        trie.insert(intArrayOf(128134, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 463, 661))) // man getting massage: light skin tone
        trie.insert(intArrayOf(128135), ParseResult(2, SpriteCoordinates(2, 10, 331, 661))) // person getting haircut
        trie.insert(intArrayOf(128135, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 397, 661))) // man getting haircut: dark skin tone
        trie.insert(intArrayOf(128135, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 397, 661))) // man getting haircut: dark skin tone
        trie.insert(intArrayOf(128694, 127998), ParseResult(4, SpriteCoordinates(2, 10, 133, 595))) // person walking: medium-dark skin tone
        trie.insert(intArrayOf(128694, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 199, 595))) // woman walking: medium skin tone
        trie.insert(intArrayOf(128694, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 199, 595))) // woman walking: medium skin tone
        trie.insert(intArrayOf(128694, 127996, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 10, 265, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 265, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 265, 595))) // woman walking facing right
        trie.insert(intArrayOf(128694, 127996, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 10, 265, 595))) // woman walking facing right
        trie.insert(intArrayOf(129485, 127995), ParseResult(4, SpriteCoordinates(2, 10, 529, 1))) // person standing: light skin tone
        trie.insert(intArrayOf(129485, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 10, 463, 463))) // woman standing
        trie.insert(intArrayOf(129485, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 10, 463, 463))) // woman standing
        trie.insert(intArrayOf(129486, 127999), ParseResult(4, SpriteCoordinates(2, 10, 265, 463))) // person kneeling: dark skin tone
        trie.insert(intArrayOf(129486, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 331, 463))) // woman kneeling: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 331, 463))) // woman kneeling: medium-dark skin tone
        trie.insert(intArrayOf(129486, 127997, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 10, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 10, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129486, 127997, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 397, 463))) // woman kneeling facing right
        trie.insert(intArrayOf(129489, 127996, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 10, 463, 1))) // person with white cane: medium-light skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 129455), ParseResult(7, SpriteCoordinates(2, 10, 265, 859))) // man with white cane: light skin tone
        trie.insert(intArrayOf(128105, 8205, 129455), ParseResult(5, SpriteCoordinates(2, 10, 529, 727))) // woman with white cane
        trie.insert(intArrayOf(128105, 127999, 8205, 129455, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 793, 67))) // woman with white cane facing right
        trie.insert(intArrayOf(128105, 127999, 8205, 129455, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 793, 67))) // woman with white cane facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 397, 265))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127998, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 397, 265))) // person in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127997, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 859, 463))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128104, 127997, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 859, 463))) // man in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127996, 8205, 129468, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 67, 793))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(128105, 127996, 8205, 129468, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 67, 793))) // woman in motorized wheelchair facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129469, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 463, 265))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(129489, 127995, 8205, 129469, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 463, 265))) // person in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 8205, 129469, 8205, 10145, 65039), ParseResult(8, SpriteCoordinates(2, 10, 661, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128104, 8205, 129469, 8205, 10145), ParseResult(7, SpriteCoordinates(2, 10, 661, 793))) // man in manual wheelchair facing right
        trie.insert(intArrayOf(128105, 127999, 8205, 129469), ParseResult(7, SpriteCoordinates(2, 10, 793, 1))) // woman in manual wheelchair: dark skin tone
        trie.insert(intArrayOf(127939, 127998), ParseResult(4, SpriteCoordinates(2, 10, 925, 265))) // person running: medium-dark skin tone
        trie.insert(intArrayOf(127939, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 925, 331))) // woman running: medium skin tone
        trie.insert(intArrayOf(127939, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 925, 331))) // woman running: medium skin tone
        trie.insert(intArrayOf(127939, 127996, 8205, 9792, 65039, 8205, 10145), ParseResult(9, SpriteCoordinates(2, 10, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9792, 65039, 8205, 10145, 65039), ParseResult(10, SpriteCoordinates(2, 10, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9792, 8205, 10145), ParseResult(8, SpriteCoordinates(2, 10, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(127939, 127996, 8205, 9792, 8205, 10145, 65039), ParseResult(9, SpriteCoordinates(2, 10, 925, 397))) // woman running facing right
        trie.insert(intArrayOf(128131, 127995), ParseResult(4, SpriteCoordinates(2, 10, 529, 661))) // woman dancing: light skin tone
        trie.insert(intArrayOf(128372), ParseResult(2, SpriteCoordinates(2, 10, 199, 661))) // person in suit levitating
        trie.insert(intArrayOf(128372, 65039), ParseResult(3, SpriteCoordinates(2, 10, 199, 661))) // person in suit levitating
        trie.insert(intArrayOf(129494, 127996), ParseResult(4, SpriteCoordinates(2, 10, 331, 265))) // person in steamy room: medium-light skin tone
        trie.insert(intArrayOf(129494, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 1, 331))) // woman in steamy room: light skin tone
        trie.insert(intArrayOf(129494, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 1, 331))) // woman in steamy room: light skin tone
        trie.insert(intArrayOf(129495, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 10, 331, 133))) // man climbing
        trie.insert(intArrayOf(129495, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 10, 331, 133))) // man climbing
        trie.insert(intArrayOf(129495, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 331, 199))) // woman climbing: dark skin tone
        trie.insert(intArrayOf(129495, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 331, 199))) // woman climbing: dark skin tone
        trie.insert(intArrayOf(127938, 127996), ParseResult(4, SpriteCoordinates(2, 10, 925, 463))) // snowboarder: medium-light skin tone
        trie.insert(intArrayOf(127948, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 793, 859))) // man golfing: light skin tone
        trie.insert(intArrayOf(127948, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 793, 859))) // man golfing: light skin tone
        trie.insert(intArrayOf(127940), ParseResult(2, SpriteCoordinates(2, 10, 925, 133))) // person surfing
        trie.insert(intArrayOf(127940, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 925, 199))) // man surfing: dark skin tone
        trie.insert(intArrayOf(127940, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 925, 199))) // man surfing: dark skin tone
        trie.insert(intArrayOf(128675, 127998), ParseResult(4, SpriteCoordinates(2, 10, 529, 595))) // person rowing boat: medium-dark skin tone
        trie.insert(intArrayOf(128675, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 595, 595))) // woman rowing boat: medium skin tone
        trie.insert(intArrayOf(128675, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 595, 595))) // woman rowing boat: medium skin tone
        trie.insert(intArrayOf(127946, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 925, 67))) // man swimming: medium-light skin tone
        trie.insert(intArrayOf(127946, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 925, 67))) // man swimming: medium-light skin tone
        trie.insert(intArrayOf(9977, 127995), ParseResult(3, SpriteCoordinates(2, 10, 133, 67))) // person bouncing ball: light skin tone
        trie.insert(intArrayOf(9977, 8205, 9792), ParseResult(3, SpriteCoordinates(2, 10, 133, 1))) // woman bouncing ball
        trie.insert(intArrayOf(9977, 65039, 8205, 9792), ParseResult(4, SpriteCoordinates(2, 10, 133, 1))) // woman bouncing ball
        trie.insert(intArrayOf(9977, 65039, 8205, 9792, 65039), ParseResult(5, SpriteCoordinates(2, 10, 133, 1))) // woman bouncing ball
        trie.insert(intArrayOf(9977, 8205, 9792, 65039), ParseResult(4, SpriteCoordinates(2, 10, 133, 1))) // woman bouncing ball
        trie.insert(intArrayOf(127947, 127999), ParseResult(4, SpriteCoordinates(2, 10, 859, 859))) // person lifting weights: dark skin tone
        trie.insert(intArrayOf(127947, 127998, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 925, 1))) // woman lifting weights: medium-dark skin tone
        trie.insert(intArrayOf(127947, 127998, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 925, 1))) // woman lifting weights: medium-dark skin tone
        trie.insert(intArrayOf(128692, 127997, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 463, 595))) // man biking: medium skin tone
        trie.insert(intArrayOf(128692, 127997, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 463, 595))) // man biking: medium skin tone
        trie.insert(intArrayOf(128693, 127996), ParseResult(4, SpriteCoordinates(2, 10, 331, 595))) // person mountain biking: medium-light skin tone
        trie.insert(intArrayOf(128693, 127995, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 397, 595))) // woman mountain biking: light skin tone
        trie.insert(intArrayOf(128693, 127995, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 397, 595))) // woman mountain biking: light skin tone
        trie.insert(intArrayOf(129336, 8205, 9794), ParseResult(4, SpriteCoordinates(2, 10, 265, 529))) // man cartwheeling
        trie.insert(intArrayOf(129336, 8205, 9794, 65039), ParseResult(5, SpriteCoordinates(2, 10, 265, 529))) // man cartwheeling
        trie.insert(intArrayOf(129336, 127999, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 331, 529))) // woman cartwheeling: dark skin tone
        trie.insert(intArrayOf(129336, 127999, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 331, 529))) // woman cartwheeling: dark skin tone
        trie.insert(intArrayOf(129341, 127995, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 67, 529))) // man playing water polo: light skin tone
        trie.insert(intArrayOf(129341, 127995, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 67, 529))) // man playing water polo: light skin tone
        trie.insert(intArrayOf(129342), ParseResult(2, SpriteCoordinates(2, 10, 529, 463))) // person playing handball
        trie.insert(intArrayOf(129342, 127999, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 1, 529))) // man playing handball: dark skin tone
        trie.insert(intArrayOf(129342, 127999, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 1, 529))) // man playing handball: dark skin tone
        trie.insert(intArrayOf(129337, 127998), ParseResult(4, SpriteCoordinates(2, 10, 133, 529))) // person juggling: medium-dark skin tone
        trie.insert(intArrayOf(129337, 127997, 8205, 9792, 65039), ParseResult(7, SpriteCoordinates(2, 10, 199, 529))) // woman juggling: medium skin tone
        trie.insert(intArrayOf(129337, 127997, 8205, 9792), ParseResult(6, SpriteCoordinates(2, 10, 199, 529))) // woman juggling: medium skin tone
        trie.insert(intArrayOf(129496, 127996, 8205, 9794), ParseResult(6, SpriteCoordinates(2, 10, 331, 67))) // man in lotus position: medium-light skin tone
        trie.insert(intArrayOf(129496, 127996, 8205, 9794, 65039), ParseResult(7, SpriteCoordinates(2, 10, 331, 67))) // man in lotus position: medium-light skin tone
        trie.insert(intArrayOf(128704, 127995), ParseResult(4, SpriteCoordinates(2, 10, 67, 595))) // person taking bath: light skin tone
        trie.insert(intArrayOf(129489, 8205, 129309, 8205, 129489), ParseResult(8, SpriteCoordinates(2, 10, 199, 331))) // people holding hands
        trie.insert(intArrayOf(129489, 127997, 8205, 129309, 8205, 129489, 127995), ParseResult(12, SpriteCoordinates(2, 10, 199, 397))) // people holding hands: medium skin tone, light skin tone
    }

    private fun init9(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(129489, 127999, 8205, 129309, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 10, 397, 1))) // people holding hands: dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128109, 127996), ParseResult(4, SpriteCoordinates(2, 10, 199, 727))) // women holding hands: medium-light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 129309, 8205, 128105, 127997), ParseResult(12, SpriteCoordinates(2, 10, 793, 331))) // women holding hands: medium-dark skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 129309, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 10, 397, 793))) // woman and man holding hands: light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 129309, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 10, 793, 661))) // woman and man holding hands: medium skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128107, 127999), ParseResult(4, SpriteCoordinates(2, 10, 265, 727))) // woman and man holding hands: dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 129309, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 10, 1, 859))) // men holding hands: medium-light skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127999, 8205, 129309, 8205, 128104, 127995), ParseResult(12, SpriteCoordinates(2, 10, 859, 67))) // men holding hands: dark skin tone, light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996), ParseResult(15, SpriteCoordinates(2, 10, 463, 199))) // kiss: person, person, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127996), ParseResult(14, SpriteCoordinates(2, 10, 463, 199))) // kiss: person, person, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127999), ParseResult(14, SpriteCoordinates(2, 10, 67, 397))) // kiss: person, person, medium skin tone, dark skin tone
        trie.insert(intArrayOf(129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999), ParseResult(15, SpriteCoordinates(2, 10, 67, 397))) // kiss: person, person, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127996), ParseResult(14, SpriteCoordinates(2, 10, 265, 793))) // kiss: woman, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996), ParseResult(15, SpriteCoordinates(2, 10, 265, 793))) // kiss: woman, man, light skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997), ParseResult(15, SpriteCoordinates(2, 10, 793, 463))) // kiss: woman, man, medium skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127997), ParseResult(14, SpriteCoordinates(2, 10, 793, 463))) // kiss: woman, man, medium skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 10, 661, 727))) // kiss: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 10, 661, 727))) // kiss: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998), ParseResult(15, SpriteCoordinates(2, 10, 859, 661))) // kiss: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127998), ParseResult(14, SpriteCoordinates(2, 10, 859, 661))) // kiss: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999), ParseResult(15, SpriteCoordinates(2, 10, 859, 265))) // kiss: man, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127999), ParseResult(14, SpriteCoordinates(2, 10, 859, 265))) // kiss: man, man, medium-dark skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127999), ParseResult(14, SpriteCoordinates(2, 10, 199, 793))) // kiss: woman, woman, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999), ParseResult(15, SpriteCoordinates(2, 10, 199, 793))) // kiss: woman, woman, light skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995), ParseResult(15, SpriteCoordinates(2, 10, 793, 199))) // kiss: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127995), ParseResult(14, SpriteCoordinates(2, 10, 793, 199))) // kiss: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(intArrayOf(128145, 127995), ParseResult(4, SpriteCoordinates(2, 10, 265, 661))) // couple with heart: light skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 8205, 129489, 127998), ParseResult(11, SpriteCoordinates(2, 10, 397, 397))) // couple with heart: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127996, 8205, 10084, 65039, 8205, 129489, 127998), ParseResult(12, SpriteCoordinates(2, 10, 397, 397))) // couple with heart: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 8205, 129489, 127996), ParseResult(11, SpriteCoordinates(2, 10, 265, 331))) // couple with heart: person, person, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(129489, 127999, 8205, 10084, 65039, 8205, 129489, 127996), ParseResult(12, SpriteCoordinates(2, 10, 265, 331))) // couple with heart: person, person, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 8205, 128104, 127997), ParseResult(11, SpriteCoordinates(2, 10, 1, 793))) // couple with heart: woman, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127996, 8205, 10084, 65039, 8205, 128104, 127997), ParseResult(12, SpriteCoordinates(2, 10, 1, 793))) // couple with heart: woman, man, medium-light skin tone, medium skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 10, 793, 265))) // couple with heart: woman, man, medium-dark skin tone
        trie.insert(intArrayOf(128105, 127998, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 10, 793, 265))) // couple with heart: woman, man, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 65039, 8205, 128104, 127998), ParseResult(12, SpriteCoordinates(2, 10, 133, 859))) // couple with heart: man, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127995, 8205, 10084, 8205, 128104, 127998), ParseResult(11, SpriteCoordinates(2, 10, 133, 859))) // couple with heart: man, man, light skin tone, medium-dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 65039, 8205, 128104, 127999), ParseResult(12, SpriteCoordinates(2, 10, 859, 397))) // couple with heart: man, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128104, 127997, 8205, 10084, 8205, 128104, 127999), ParseResult(11, SpriteCoordinates(2, 10, 859, 397))) // couple with heart: man, man, medium skin tone, dark skin tone
        trie.insert(intArrayOf(128105, 8205, 10084, 8205, 128105), ParseResult(7, SpriteCoordinates(2, 10, 397, 727))) // couple with heart: woman, woman
        trie.insert(intArrayOf(128105, 8205, 10084, 65039, 8205, 128105), ParseResult(8, SpriteCoordinates(2, 10, 397, 727))) // couple with heart: woman, woman
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 65039, 8205, 128105, 127995), ParseResult(12, SpriteCoordinates(2, 10, 793, 529))) // couple with heart: woman, woman, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127997, 8205, 10084, 8205, 128105, 127995), ParseResult(11, SpriteCoordinates(2, 10, 793, 529))) // couple with heart: woman, woman, medium skin tone, light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 65039, 8205, 128105, 127996), ParseResult(12, SpriteCoordinates(2, 10, 727, 727))) // couple with heart: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128105, 127999, 8205, 10084, 8205, 128105, 127996), ParseResult(11, SpriteCoordinates(2, 10, 727, 727))) // couple with heart: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(intArrayOf(128104, 8205, 128104, 8205, 128103, 8205, 128102), ParseResult(11, SpriteCoordinates(2, 10, 793, 793))) // family: man, man, girl, boy
        trie.insert(intArrayOf(128104, 8205, 128103, 8205, 128102), ParseResult(8, SpriteCoordinates(2, 10, 859, 1))) // family: man, girl, boy
        trie.insert(intArrayOf(128106), ParseResult(2, SpriteCoordinates(2, 10, 331, 727))) // family
        trie.insert(intArrayOf(128053), ParseResult(2, SpriteCoordinates(3, 0, 595, 67))) // monkey face
        trie.insert(intArrayOf(128018), ParseResult(2, SpriteCoordinates(3, 0, 661, 661))) // monkey
        trie.insert(intArrayOf(129421), ParseResult(2, SpriteCoordinates(3, 0, 463, 133))) // gorilla
        trie.insert(intArrayOf(129447), ParseResult(2, SpriteCoordinates(3, 0, 331, 1))) // orangutan
        trie.insert(intArrayOf(128054), ParseResult(2, SpriteCoordinates(3, 0, 595, 1))) // dog face
        trie.insert(intArrayOf(128021), ParseResult(2, SpriteCoordinates(3, 0, 397, 661))) // dog
        trie.insert(intArrayOf(129454), ParseResult(2, SpriteCoordinates(3, 0, 265, 133))) // guide dog
        trie.insert(intArrayOf(128021, 8205, 129466), ParseResult(5, SpriteCoordinates(3, 0, 463, 661))) // service dog
        trie.insert(intArrayOf(128041), ParseResult(2, SpriteCoordinates(3, 0, 265, 595))) // poodle
        trie.insert(intArrayOf(128058), ParseResult(2, SpriteCoordinates(3, 0, 331, 529))) // wolf
        trie.insert(intArrayOf(129418), ParseResult(2, SpriteCoordinates(3, 0, 463, 331))) // fox
        trie.insert(intArrayOf(129437), ParseResult(2, SpriteCoordinates(3, 0, 331, 331))) // raccoon
        trie.insert(intArrayOf(128049), ParseResult(2, SpriteCoordinates(3, 0, 595, 331))) // cat face
        trie.insert(intArrayOf(128008), ParseResult(2, SpriteCoordinates(3, 0, 727, 595))) // cat
        trie.insert(intArrayOf(128008, 8205, 11035), ParseResult(4, SpriteCoordinates(3, 0, 727, 661))) // black cat
        trie.insert(intArrayOf(129409), ParseResult(2, SpriteCoordinates(3, 0, 463, 463))) // lion
        trie.insert(intArrayOf(128047), ParseResult(2, SpriteCoordinates(3, 0, 595, 463))) // tiger face
        trie.insert(intArrayOf(128005), ParseResult(2, SpriteCoordinates(3, 0, 133, 727))) // tiger
        trie.insert(intArrayOf(128006), ParseResult(2, SpriteCoordinates(3, 0, 67, 727))) // leopard
        trie.insert(intArrayOf(128052), ParseResult(2, SpriteCoordinates(3, 0, 595, 133))) // horse face
        trie.insert(intArrayOf(129742), ParseResult(2, SpriteCoordinates(3, 0, 1, 67))) // moose
        trie.insert(intArrayOf(129743), ParseResult(2, SpriteCoordinates(3, 0, 67, 1))) // donkey
        trie.insert(intArrayOf(128014), ParseResult(2, SpriteCoordinates(3, 0, 727, 199))) // horse
        trie.insert(intArrayOf(129412), ParseResult(2, SpriteCoordinates(3, 0, 265, 463))) // unicorn
        trie.insert(intArrayOf(129427), ParseResult(2, SpriteCoordinates(3, 0, 199, 397))) // zebra
        trie.insert(intArrayOf(129420), ParseResult(2, SpriteCoordinates(3, 0, 463, 199))) // deer
        trie.insert(intArrayOf(129452), ParseResult(2, SpriteCoordinates(3, 0, 1, 265))) // bison
        trie.insert(intArrayOf(128046), ParseResult(2, SpriteCoordinates(3, 0, 595, 529))) // cow face
        trie.insert(intArrayOf(128002), ParseResult(2, SpriteCoordinates(3, 0, 331, 727))) // ox
        trie.insert(intArrayOf(128003), ParseResult(2, SpriteCoordinates(3, 0, 265, 727))) // water buffalo
        trie.insert(intArrayOf(128004), ParseResult(2, SpriteCoordinates(3, 0, 199, 727))) // cow
        trie.insert(intArrayOf(128055), ParseResult(2, SpriteCoordinates(3, 0, 529, 529))) // pig face
        trie.insert(intArrayOf(128022), ParseResult(2, SpriteCoordinates(3, 0, 331, 661))) // pig
        trie.insert(intArrayOf(128023), ParseResult(2, SpriteCoordinates(3, 0, 265, 661))) // boar
        trie.insert(intArrayOf(128061), ParseResult(2, SpriteCoordinates(3, 0, 67, 529))) // pig nose
        trie.insert(intArrayOf(128015), ParseResult(2, SpriteCoordinates(3, 0, 727, 133))) // ram
        trie.insert(intArrayOf(128017), ParseResult(2, SpriteCoordinates(3, 0, 727, 1))) // ewe
        trie.insert(intArrayOf(128016), ParseResult(2, SpriteCoordinates(3, 0, 727, 67))) // goat
        trie.insert(intArrayOf(128042), ParseResult(2, SpriteCoordinates(3, 0, 199, 595))) // camel
        trie.insert(intArrayOf(128043), ParseResult(2, SpriteCoordinates(3, 0, 133, 595))) // two-hump camel
        trie.insert(intArrayOf(129433), ParseResult(2, SpriteCoordinates(3, 0, 397, 199))) // llama
        trie.insert(intArrayOf(129426), ParseResult(2, SpriteCoordinates(3, 0, 265, 397))) // giraffe
        trie.insert(intArrayOf(128024), ParseResult(2, SpriteCoordinates(3, 0, 199, 661))) // elephant
        trie.insert(intArrayOf(129443), ParseResult(2, SpriteCoordinates(3, 0, 331, 265))) // mammoth
        trie.insert(intArrayOf(129423), ParseResult(2, SpriteCoordinates(3, 0, 463, 1))) // rhinoceros
        trie.insert(intArrayOf(129435), ParseResult(2, SpriteCoordinates(3, 0, 397, 67))) // hippopotamus
        trie.insert(intArrayOf(128045), ParseResult(2, SpriteCoordinates(3, 0, 1, 595))) // mouse face
        trie.insert(intArrayOf(128001), ParseResult(2, SpriteCoordinates(3, 0, 397, 727))) // mouse
        trie.insert(intArrayOf(128000), ParseResult(2, SpriteCoordinates(3, 0, 463, 727))) // rat
        trie.insert(intArrayOf(128057), ParseResult(2, SpriteCoordinates(3, 0, 397, 529))) // hamster
        trie.insert(intArrayOf(128048), ParseResult(2, SpriteCoordinates(3, 0, 595, 397))) // rabbit face
        trie.insert(intArrayOf(128007), ParseResult(2, SpriteCoordinates(3, 0, 1, 727))) // rabbit
        trie.insert(intArrayOf(128063, 65039), ParseResult(3, SpriteCoordinates(3, 0, 529, 463))) // chipmunk
        trie.insert(intArrayOf(128063), ParseResult(2, SpriteCoordinates(3, 0, 529, 463))) // chipmunk
        trie.insert(intArrayOf(129451), ParseResult(2, SpriteCoordinates(3, 0, 67, 265))) // beaver
        trie.insert(intArrayOf(129428), ParseResult(2, SpriteCoordinates(3, 0, 133, 397))) // hedgehog
        trie.insert(intArrayOf(129415), ParseResult(2, SpriteCoordinates(3, 0, 67, 463))) // bat
        trie.insert(intArrayOf(128059), ParseResult(2, SpriteCoordinates(3, 0, 199, 529))) // bear
        trie.insert(intArrayOf(128059, 8205, 10052, 65039), ParseResult(5, SpriteCoordinates(3, 0, 265, 529))) // polar bear
        trie.insert(intArrayOf(128059, 8205, 10052), ParseResult(4, SpriteCoordinates(3, 0, 265, 529))) // polar bear
        trie.insert(intArrayOf(128040), ParseResult(2, SpriteCoordinates(3, 0, 331, 595))) // koala
        trie.insert(intArrayOf(128060), ParseResult(2, SpriteCoordinates(3, 0, 133, 529))) // panda
        trie.insert(intArrayOf(129445), ParseResult(2, SpriteCoordinates(3, 0, 331, 133))) // sloth
        trie.insert(intArrayOf(129446), ParseResult(2, SpriteCoordinates(3, 0, 331, 67))) // otter
        trie.insert(intArrayOf(129448), ParseResult(2, SpriteCoordinates(3, 0, 265, 265))) // skunk
        trie.insert(intArrayOf(129432), ParseResult(2, SpriteCoordinates(3, 0, 397, 265))) // kangaroo
        trie.insert(intArrayOf(129441), ParseResult(2, SpriteCoordinates(3, 0, 67, 331))) // badger
        trie.insert(intArrayOf(128062), ParseResult(2, SpriteCoordinates(3, 0, 1, 529))) // paw prints
        trie.insert(intArrayOf(129411), ParseResult(2, SpriteCoordinates(3, 0, 331, 463))) // turkey
        trie.insert(intArrayOf(128020), ParseResult(2, SpriteCoordinates(3, 0, 529, 661))) // chicken
        trie.insert(intArrayOf(128019), ParseResult(2, SpriteCoordinates(3, 0, 595, 661))) // rooster
        trie.insert(intArrayOf(128035), ParseResult(2, SpriteCoordinates(3, 0, 661, 133))) // hatching chick
        trie.insert(intArrayOf(128036), ParseResult(2, SpriteCoordinates(3, 0, 661, 67))) // baby chick
        trie.insert(intArrayOf(128037), ParseResult(2, SpriteCoordinates(3, 0, 661, 1))) // front-facing baby chick
        trie.insert(intArrayOf(128038), ParseResult(2, SpriteCoordinates(3, 0, 463, 595))) // bird
        trie.insert(intArrayOf(128039), ParseResult(2, SpriteCoordinates(3, 0, 397, 595))) // penguin
        trie.insert(intArrayOf(128330), ParseResult(2, SpriteCoordinates(3, 0, 529, 265))) // dove
        trie.insert(intArrayOf(128330, 65039), ParseResult(3, SpriteCoordinates(3, 0, 529, 265))) // dove
        trie.insert(intArrayOf(129413), ParseResult(2, SpriteCoordinates(3, 0, 199, 463))) // eagle
        trie.insert(intArrayOf(129414), ParseResult(2, SpriteCoordinates(3, 0, 133, 463))) // duck
        trie.insert(intArrayOf(129442), ParseResult(2, SpriteCoordinates(3, 0, 1, 331))) // swan
        trie.insert(intArrayOf(129417), ParseResult(2, SpriteCoordinates(3, 0, 463, 397))) // owl
        trie.insert(intArrayOf(129444), ParseResult(2, SpriteCoordinates(3, 0, 331, 199))) // dodo
        trie.insert(intArrayOf(129718), ParseResult(2, SpriteCoordinates(3, 0, 1, 199))) // feather
        trie.insert(intArrayOf(129449), ParseResult(2, SpriteCoordinates(3, 0, 199, 265))) // flamingo
        trie.insert(intArrayOf(129434), ParseResult(2, SpriteCoordinates(3, 0, 397, 133))) // peacock
        trie.insert(intArrayOf(129436), ParseResult(2, SpriteCoordinates(3, 0, 397, 1))) // parrot
        trie.insert(intArrayOf(129725), ParseResult(2, SpriteCoordinates(3, 0, 133, 67))) // wing
        trie.insert(intArrayOf(128038, 8205, 11035), ParseResult(4, SpriteCoordinates(3, 0, 529, 595))) // black bird
        trie.insert(intArrayOf(129727), ParseResult(2, SpriteCoordinates(3, 0, 67, 67))) // goose
        trie.insert(intArrayOf(128038, 8205, 128293), ParseResult(5, SpriteCoordinates(3, 0, 595, 595))) // phoenix
        trie.insert(intArrayOf(128056), ParseResult(2, SpriteCoordinates(3, 0, 463, 529))) // frog
        trie.insert(intArrayOf(128010), ParseResult(2, SpriteCoordinates(3, 0, 727, 463))) // crocodile
        trie.insert(intArrayOf(128034), ParseResult(2, SpriteCoordinates(3, 0, 661, 199))) // turtle
        trie.insert(intArrayOf(129422), ParseResult(2, SpriteCoordinates(3, 0, 463, 67))) // lizard
        trie.insert(intArrayOf(128013), ParseResult(2, SpriteCoordinates(3, 0, 727, 265))) // snake
        trie.insert(intArrayOf(128050), ParseResult(2, SpriteCoordinates(3, 0, 595, 265))) // dragon face
        trie.insert(intArrayOf(128009), ParseResult(2, SpriteCoordinates(3, 0, 727, 529))) // dragon
        trie.insert(intArrayOf(129429), ParseResult(2, SpriteCoordinates(3, 0, 67, 397))) // sauropod
        trie.insert(intArrayOf(129430), ParseResult(2, SpriteCoordinates(3, 0, 1, 397))) // T-Rex
        trie.insert(intArrayOf(128051), ParseResult(2, SpriteCoordinates(3, 0, 595, 199))) // spouting whale
        trie.insert(intArrayOf(128011), ParseResult(2, SpriteCoordinates(3, 0, 727, 397))) // whale
        trie.insert(intArrayOf(128044), ParseResult(2, SpriteCoordinates(3, 0, 67, 595))) // dolphin
        trie.insert(intArrayOf(129453), ParseResult(2, SpriteCoordinates(3, 0, 265, 199))) // seal
        trie.insert(intArrayOf(128031), ParseResult(2, SpriteCoordinates(3, 0, 661, 397))) // fish
        trie.insert(intArrayOf(128032), ParseResult(2, SpriteCoordinates(3, 0, 661, 331))) // tropical fish
        trie.insert(intArrayOf(128033), ParseResult(2, SpriteCoordinates(3, 0, 661, 265))) // blowfish
        trie.insert(intArrayOf(129416), ParseResult(2, SpriteCoordinates(3, 0, 1, 463))) // shark
        trie.insert(intArrayOf(128025), ParseResult(2, SpriteCoordinates(3, 0, 133, 661))) // octopus
        trie.insert(intArrayOf(128026), ParseResult(2, SpriteCoordinates(3, 0, 67, 661))) // spiral shell
        trie.insert(intArrayOf(129720), ParseResult(2, SpriteCoordinates(3, 0, 199, 67))) // coral
        trie.insert(intArrayOf(129724), ParseResult(2, SpriteCoordinates(3, 0, 1, 133))) // jellyfish
        trie.insert(intArrayOf(129408), ParseResult(2, SpriteCoordinates(3, 0, 529, 1))) // crab
        trie.insert(intArrayOf(129438), ParseResult(2, SpriteCoordinates(3, 0, 265, 331))) // lobster
        trie.insert(intArrayOf(129424), ParseResult(2, SpriteCoordinates(3, 0, 397, 397))) // shrimp
        trie.insert(intArrayOf(129425), ParseResult(2, SpriteCoordinates(3, 0, 331, 397))) // squid
        trie.insert(intArrayOf(129450), ParseResult(2, SpriteCoordinates(3, 0, 133, 265))) // oyster
        trie.insert(intArrayOf(128012), ParseResult(2, SpriteCoordinates(3, 0, 727, 331))) // snail
        trie.insert(intArrayOf(129419), ParseResult(2, SpriteCoordinates(3, 0, 463, 265))) // butterfly
        trie.insert(intArrayOf(128027), ParseResult(2, SpriteCoordinates(3, 0, 1, 661))) // bug
        trie.insert(intArrayOf(128028), ParseResult(2, SpriteCoordinates(3, 0, 661, 595))) // ant
        trie.insert(intArrayOf(128029), ParseResult(2, SpriteCoordinates(3, 0, 661, 529))) // honeybee
        trie.insert(intArrayOf(129714), ParseResult(2, SpriteCoordinates(3, 0, 199, 199))) // beetle
        trie.insert(intArrayOf(128030), ParseResult(2, SpriteCoordinates(3, 0, 661, 463))) // lady beetle
        trie.insert(intArrayOf(129431), ParseResult(2, SpriteCoordinates(3, 0, 397, 331))) // cricket
        trie.insert(intArrayOf(129715), ParseResult(2, SpriteCoordinates(3, 0, 133, 199))) // cockroach
        trie.insert(intArrayOf(128375, 65039), ParseResult(3, SpriteCoordinates(3, 0, 529, 199))) // spider
        trie.insert(intArrayOf(128375), ParseResult(2, SpriteCoordinates(3, 0, 529, 199))) // spider
        trie.insert(intArrayOf(128376), ParseResult(2, SpriteCoordinates(3, 0, 529, 133))) // spider web
        trie.insert(intArrayOf(128376, 65039), ParseResult(3, SpriteCoordinates(3, 0, 529, 133))) // spider web
        trie.insert(intArrayOf(129410), ParseResult(2, SpriteCoordinates(3, 0, 397, 463))) // scorpion
        trie.insert(intArrayOf(129439), ParseResult(2, SpriteCoordinates(3, 0, 199, 331))) // mosquito
        trie.insert(intArrayOf(129712), ParseResult(2, SpriteCoordinates(3, 0, 265, 67))) // fly
        trie.insert(intArrayOf(129713), ParseResult(2, SpriteCoordinates(3, 0, 265, 1))) // worm
        trie.insert(intArrayOf(129440), ParseResult(2, SpriteCoordinates(3, 0, 133, 331))) // microbe
        trie.insert(intArrayOf(128144), ParseResult(2, SpriteCoordinates(3, 0, 529, 397))) // bouquet
        trie.insert(intArrayOf(127800), ParseResult(2, SpriteCoordinates(3, 0, 793, 529))) // cherry blossom
        trie.insert(intArrayOf(128174), ParseResult(2, SpriteCoordinates(3, 0, 529, 331))) // white flower
        trie.insert(intArrayOf(129719), ParseResult(2, SpriteCoordinates(3, 0, 199, 133))) // lotus
        trie.insert(intArrayOf(127989), ParseResult(2, SpriteCoordinates(3, 0, 529, 727))) // rosette
        trie.insert(intArrayOf(127989, 65039), ParseResult(3, SpriteCoordinates(3, 0, 529, 727))) // rosette
        trie.insert(intArrayOf(127801), ParseResult(2, SpriteCoordinates(3, 0, 793, 463))) // rose
        trie.insert(intArrayOf(129344), ParseResult(2, SpriteCoordinates(3, 0, 529, 67))) // wilted flower
        trie.insert(intArrayOf(127802), ParseResult(2, SpriteCoordinates(3, 0, 793, 397))) // hibiscus
        trie.insert(intArrayOf(127803), ParseResult(2, SpriteCoordinates(3, 0, 793, 331))) // sunflower
        trie.insert(intArrayOf(127804), ParseResult(2, SpriteCoordinates(3, 0, 793, 265))) // blossom
        trie.insert(intArrayOf(127799), ParseResult(2, SpriteCoordinates(3, 0, 793, 595))) // tulip
        trie.insert(intArrayOf(129723), ParseResult(2, SpriteCoordinates(3, 0, 67, 133))) // hyacinth
        trie.insert(intArrayOf(127793), ParseResult(2, SpriteCoordinates(3, 0, 133, 793))) // seedling
        trie.insert(intArrayOf(129716), ParseResult(2, SpriteCoordinates(3, 0, 67, 199))) // potted plant
        trie.insert(intArrayOf(127794), ParseResult(2, SpriteCoordinates(3, 0, 67, 793))) // evergreen tree
        trie.insert(intArrayOf(127795), ParseResult(2, SpriteCoordinates(3, 0, 1, 793))) // deciduous tree
        trie.insert(intArrayOf(127796), ParseResult(2, SpriteCoordinates(3, 0, 793, 727))) // palm tree
        trie.insert(intArrayOf(127797), ParseResult(2, SpriteCoordinates(3, 0, 793, 661))) // cactus
        trie.insert(intArrayOf(127806), ParseResult(2, SpriteCoordinates(3, 0, 793, 199))) // sheaf of rice
        trie.insert(intArrayOf(127807), ParseResult(2, SpriteCoordinates(3, 0, 793, 133))) // herb
        trie.insert(intArrayOf(9752, 65039), ParseResult(2, SpriteCoordinates(3, 0, 1, 1))) // shamrock
        trie.insert(intArrayOf(9752), ParseResult(1, SpriteCoordinates(3, 0, 1, 1))) // shamrock
        trie.insert(intArrayOf(127808), ParseResult(2, SpriteCoordinates(3, 0, 793, 67))) // four leaf clover
        trie.insert(intArrayOf(127809), ParseResult(2, SpriteCoordinates(3, 0, 793, 1))) // maple leaf
        trie.insert(intArrayOf(127810), ParseResult(2, SpriteCoordinates(3, 0, 727, 727))) // fallen leaf
        trie.insert(intArrayOf(127811), ParseResult(2, SpriteCoordinates(3, 0, 661, 727))) // leaf fluttering in wind
        trie.insert(intArrayOf(129721), ParseResult(2, SpriteCoordinates(3, 0, 199, 1))) // empty nest
        trie.insert(intArrayOf(129722), ParseResult(2, SpriteCoordinates(3, 0, 133, 133))) // nest with eggs
        trie.insert(intArrayOf(127812), ParseResult(2, SpriteCoordinates(3, 0, 595, 727))) // mushroom
        trie.insert(intArrayOf(129726), ParseResult(2, SpriteCoordinates(3, 0, 133, 1))) // leafless tree
        trie.insert(intArrayOf(127815), ParseResult(2, SpriteCoordinates(4, 0, 727, 1))) // grapes
        trie.insert(intArrayOf(127816), ParseResult(2, SpriteCoordinates(4, 0, 661, 661))) // melon
        trie.insert(intArrayOf(127817), ParseResult(2, SpriteCoordinates(4, 0, 595, 661))) // watermelon
        trie.insert(intArrayOf(127818), ParseResult(2, SpriteCoordinates(4, 0, 529, 661))) // tangerine
        trie.insert(intArrayOf(127819), ParseResult(2, SpriteCoordinates(4, 0, 397, 661))) // lemon
        trie.insert(intArrayOf(127819, 8205, 129001), ParseResult(5, SpriteCoordinates(4, 0, 463, 661))) // lime
        trie.insert(intArrayOf(127820), ParseResult(2, SpriteCoordinates(4, 0, 331, 661))) // banana
        trie.insert(intArrayOf(127821), ParseResult(2, SpriteCoordinates(4, 0, 265, 661))) // pineapple
        trie.insert(intArrayOf(129389), ParseResult(2, SpriteCoordinates(4, 0, 331, 199))) // mango
        trie.insert(intArrayOf(127822), ParseResult(2, SpriteCoordinates(4, 0, 199, 661))) // red apple
        trie.insert(intArrayOf(127823), ParseResult(2, SpriteCoordinates(4, 0, 133, 661))) // green apple
        trie.insert(intArrayOf(127824), ParseResult(2, SpriteCoordinates(4, 0, 67, 661))) // pear
        trie.insert(intArrayOf(127825), ParseResult(2, SpriteCoordinates(4, 0, 1, 661))) // peach
        trie.insert(intArrayOf(127826), ParseResult(2, SpriteCoordinates(4, 0, 661, 595))) // cherries
        trie.insert(intArrayOf(127827), ParseResult(2, SpriteCoordinates(4, 0, 661, 529))) // strawberry
        trie.insert(intArrayOf(129744), ParseResult(2, SpriteCoordinates(4, 0, 67, 199))) // blueberries
        trie.insert(intArrayOf(129373), ParseResult(2, SpriteCoordinates(4, 0, 133, 397))) // kiwi fruit
        trie.insert(intArrayOf(127813), ParseResult(2, SpriteCoordinates(4, 0, 727, 133))) // tomato
        trie.insert(intArrayOf(129746), ParseResult(2, SpriteCoordinates(4, 0, 199, 133))) // olive
        trie.insert(intArrayOf(129381), ParseResult(2, SpriteCoordinates(4, 0, 397, 1))) // coconut
        trie.insert(intArrayOf(129361), ParseResult(2, SpriteCoordinates(4, 0, 1, 463))) // avocado
        trie.insert(intArrayOf(127814), ParseResult(2, SpriteCoordinates(4, 0, 727, 67))) // eggplant
        trie.insert(intArrayOf(129364), ParseResult(2, SpriteCoordinates(4, 0, 463, 265))) // potato
        trie.insert(intArrayOf(129365), ParseResult(2, SpriteCoordinates(4, 0, 463, 199))) // carrot
        trie.insert(intArrayOf(127805), ParseResult(2, SpriteCoordinates(4, 0, 727, 265))) // ear of corn
        trie.insert(intArrayOf(127798, 65039), ParseResult(3, SpriteCoordinates(4, 0, 727, 331))) // hot pepper
        trie.insert(intArrayOf(127798), ParseResult(2, SpriteCoordinates(4, 0, 727, 331))) // hot pepper
        trie.insert(intArrayOf(129745), ParseResult(2, SpriteCoordinates(4, 0, 1, 199))) // bell pepper
        trie.insert(intArrayOf(129362), ParseResult(2, SpriteCoordinates(4, 0, 463, 397))) // cucumber
        trie.insert(intArrayOf(129388), ParseResult(2, SpriteCoordinates(4, 0, 331, 265))) // leafy green
        trie.insert(intArrayOf(129382), ParseResult(2, SpriteCoordinates(4, 0, 331, 331))) // broccoli
        trie.insert(intArrayOf(129476), ParseResult(2, SpriteCoordinates(4, 0, 67, 265))) // garlic
        trie.insert(intArrayOf(129477), ParseResult(2, SpriteCoordinates(4, 0, 1, 265))) // onion
        trie.insert(intArrayOf(129372), ParseResult(2, SpriteCoordinates(4, 0, 199, 397))) // peanuts
        trie.insert(intArrayOf(129752), ParseResult(2, SpriteCoordinates(4, 0, 133, 67))) // beans
        trie.insert(intArrayOf(127792), ParseResult(2, SpriteCoordinates(4, 0, 727, 397))) // chestnut
        trie.insert(intArrayOf(129754), ParseResult(2, SpriteCoordinates(4, 0, 67, 67))) // ginger root
        trie.insert(intArrayOf(129755), ParseResult(2, SpriteCoordinates(4, 0, 1, 67))) // pea pod
        trie.insert(intArrayOf(127812, 8205, 129003), ParseResult(5, SpriteCoordinates(4, 0, 727, 199))) // brown mushroom
        trie.insert(intArrayOf(129756), ParseResult(2, SpriteCoordinates(4, 0, 67, 1))) // root vegetable
        trie.insert(intArrayOf(127838), ParseResult(2, SpriteCoordinates(4, 0, 463, 595))) // bread
        trie.insert(intArrayOf(129360), ParseResult(2, SpriteCoordinates(4, 0, 67, 463))) // croissant
        trie.insert(intArrayOf(129366), ParseResult(2, SpriteCoordinates(4, 0, 463, 133))) // baguette bread
        trie.insert(intArrayOf(129747), ParseResult(2, SpriteCoordinates(4, 0, 199, 67))) // flatbread
        trie.insert(intArrayOf(129384), ParseResult(2, SpriteCoordinates(4, 0, 199, 331))) // pretzel
        trie.insert(intArrayOf(129391), ParseResult(2, SpriteCoordinates(4, 0, 331, 67))) // bagel
        trie.insert(intArrayOf(129374), ParseResult(2, SpriteCoordinates(4, 0, 67, 397))) // pancakes
        trie.insert(intArrayOf(129479), ParseResult(2, SpriteCoordinates(4, 0, 265, 133))) // waffle
        trie.insert(intArrayOf(129472), ParseResult(2, SpriteCoordinates(4, 0, 331, 1))) // cheese wedge
        trie.insert(intArrayOf(127830), ParseResult(2, SpriteCoordinates(4, 0, 661, 331))) // meat on bone
        trie.insert(intArrayOf(127831), ParseResult(2, SpriteCoordinates(4, 0, 661, 265))) // poultry leg
        trie.insert(intArrayOf(129385), ParseResult(2, SpriteCoordinates(4, 0, 133, 331))) // cut of meat
        trie.insert(intArrayOf(129363), ParseResult(2, SpriteCoordinates(4, 0, 463, 331))) // bacon
        trie.insert(intArrayOf(127828), ParseResult(2, SpriteCoordinates(4, 0, 661, 463))) // hamburger
        trie.insert(intArrayOf(127839), ParseResult(2, SpriteCoordinates(4, 0, 397, 595))) // french fries
        trie.insert(intArrayOf(127829), ParseResult(2, SpriteCoordinates(4, 0, 661, 397))) // pizza
        trie.insert(intArrayOf(127789), ParseResult(2, SpriteCoordinates(4, 0, 727, 595))) // hot dog
        trie.insert(intArrayOf(129386), ParseResult(2, SpriteCoordinates(4, 0, 67, 331))) // sandwich
        trie.insert(intArrayOf(127790), ParseResult(2, SpriteCoordinates(4, 0, 727, 529))) // taco
        trie.insert(intArrayOf(127791), ParseResult(2, SpriteCoordinates(4, 0, 727, 463))) // burrito
        trie.insert(intArrayOf(129748), ParseResult(2, SpriteCoordinates(4, 0, 199, 1))) // tamale
        trie.insert(intArrayOf(129369), ParseResult(2, SpriteCoordinates(4, 0, 397, 397))) // stuffed flatbread
        trie.insert(intArrayOf(129478), ParseResult(2, SpriteCoordinates(4, 0, 265, 199))) // falafel
        trie.insert(intArrayOf(129370), ParseResult(2, SpriteCoordinates(4, 0, 331, 397))) // egg
        trie.insert(intArrayOf(127859), ParseResult(2, SpriteCoordinates(4, 0, 265, 529))) // cooking
        trie.insert(intArrayOf(129368), ParseResult(2, SpriteCoordinates(4, 0, 463, 1))) // shallow pan of food
        trie.insert(intArrayOf(127858), ParseResult(2, SpriteCoordinates(4, 0, 331, 529))) // pot of food
        trie.insert(intArrayOf(129749), ParseResult(2, SpriteCoordinates(4, 0, 133, 133))) // fondue
        trie.insert(intArrayOf(129379), ParseResult(2, SpriteCoordinates(4, 0, 397, 133))) // bowl with spoon
        trie.insert(intArrayOf(129367), ParseResult(2, SpriteCoordinates(4, 0, 463, 67))) // green salad
        trie.insert(intArrayOf(127871), ParseResult(2, SpriteCoordinates(4, 0, 529, 1))) // popcorn
        trie.insert(intArrayOf(129480), ParseResult(2, SpriteCoordinates(4, 0, 265, 67))) // butter
        trie.insert(intArrayOf(129474), ParseResult(2, SpriteCoordinates(4, 0, 199, 265))) // salt
        trie.insert(intArrayOf(129387), ParseResult(2, SpriteCoordinates(4, 0, 1, 331))) // canned food
        trie.insert(intArrayOf(127857), ParseResult(2, SpriteCoordinates(4, 0, 397, 529))) // bento box
        trie.insert(intArrayOf(127832), ParseResult(2, SpriteCoordinates(4, 0, 661, 199))) // rice cracker
        trie.insert(intArrayOf(127833), ParseResult(2, SpriteCoordinates(4, 0, 661, 133))) // rice ball
        trie.insert(intArrayOf(127834), ParseResult(2, SpriteCoordinates(4, 0, 661, 67))) // cooked rice
        trie.insert(intArrayOf(127835), ParseResult(2, SpriteCoordinates(4, 0, 661, 1))) // curry rice
        trie.insert(intArrayOf(127836), ParseResult(2, SpriteCoordinates(4, 0, 595, 595))) // steaming bowl
        trie.insert(intArrayOf(127837), ParseResult(2, SpriteCoordinates(4, 0, 529, 595))) // spaghetti
        trie.insert(intArrayOf(127840), ParseResult(2, SpriteCoordinates(4, 0, 331, 595))) // roasted sweet potato
        trie.insert(intArrayOf(127842), ParseResult(2, SpriteCoordinates(4, 0, 199, 595))) // oden
        trie.insert(intArrayOf(127843), ParseResult(2, SpriteCoordinates(4, 0, 133, 595))) // sushi
        trie.insert(intArrayOf(127844), ParseResult(2, SpriteCoordinates(4, 0, 67, 595))) // fried shrimp
        trie.insert(intArrayOf(127845), ParseResult(2, SpriteCoordinates(4, 0, 1, 595))) // fish cake with swirl
        trie.insert(intArrayOf(129390), ParseResult(2, SpriteCoordinates(4, 0, 331, 133))) // moon cake
        trie.insert(intArrayOf(127841), ParseResult(2, SpriteCoordinates(4, 0, 265, 595))) // dango
        trie.insert(intArrayOf(129375), ParseResult(2, SpriteCoordinates(4, 0, 1, 397))) // dumpling
        trie.insert(intArrayOf(129376), ParseResult(2, SpriteCoordinates(4, 0, 397, 331))) // fortune cookie
        trie.insert(intArrayOf(129377), ParseResult(2, SpriteCoordinates(4, 0, 397, 265))) // takeout box
        trie.insert(intArrayOf(127846), ParseResult(2, SpriteCoordinates(4, 0, 595, 529))) // soft ice cream
        trie.insert(intArrayOf(127847), ParseResult(2, SpriteCoordinates(4, 0, 595, 463))) // shaved ice
        trie.insert(intArrayOf(127848), ParseResult(2, SpriteCoordinates(4, 0, 595, 397))) // ice cream
        trie.insert(intArrayOf(127849), ParseResult(2, SpriteCoordinates(4, 0, 595, 331))) // doughnut
        trie.insert(intArrayOf(127850), ParseResult(2, SpriteCoordinates(4, 0, 595, 265))) // cookie
        trie.insert(intArrayOf(127874), ParseResult(2, SpriteCoordinates(4, 0, 463, 463))) // birthday cake
        trie.insert(intArrayOf(127856), ParseResult(2, SpriteCoordinates(4, 0, 463, 529))) // shortcake
        trie.insert(intArrayOf(129473), ParseResult(2, SpriteCoordinates(4, 0, 265, 265))) // cupcake
        trie.insert(intArrayOf(129383), ParseResult(2, SpriteCoordinates(4, 0, 265, 331))) // pie
        trie.insert(intArrayOf(127851), ParseResult(2, SpriteCoordinates(4, 0, 595, 199))) // chocolate bar
        trie.insert(intArrayOf(127852), ParseResult(2, SpriteCoordinates(4, 0, 595, 133))) // candy
        trie.insert(intArrayOf(127853), ParseResult(2, SpriteCoordinates(4, 0, 595, 67))) // lollipop
        trie.insert(intArrayOf(127854), ParseResult(2, SpriteCoordinates(4, 0, 595, 1))) // custard
        trie.insert(intArrayOf(127855), ParseResult(2, SpriteCoordinates(4, 0, 529, 529))) // honey pot
        trie.insert(intArrayOf(127868), ParseResult(2, SpriteCoordinates(4, 0, 529, 199))) // baby bottle
        trie.insert(intArrayOf(129371), ParseResult(2, SpriteCoordinates(4, 0, 265, 397))) // glass of milk
        trie.insert(intArrayOf(9749), ParseResult(1, SpriteCoordinates(4, 0, 1, 1))) // hot beverage
        trie.insert(intArrayOf(129750), ParseResult(2, SpriteCoordinates(4, 0, 67, 133))) // teapot
        trie.insert(intArrayOf(127861), ParseResult(2, SpriteCoordinates(4, 0, 133, 529))) // teacup without handle
        trie.insert(intArrayOf(127862), ParseResult(2, SpriteCoordinates(4, 0, 67, 529))) // sake
        trie.insert(intArrayOf(127870), ParseResult(2, SpriteCoordinates(4, 0, 529, 67))) // bottle with popping cork
    }

    private fun init10(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(127863), ParseResult(2, SpriteCoordinates(4, 0, 1, 529))) // wine glass
        trie.insert(intArrayOf(127864), ParseResult(2, SpriteCoordinates(4, 0, 529, 463))) // cocktail glass
        trie.insert(intArrayOf(127865), ParseResult(2, SpriteCoordinates(4, 0, 529, 397))) // tropical drink
        trie.insert(intArrayOf(127866), ParseResult(2, SpriteCoordinates(4, 0, 529, 331))) // beer mug
        trie.insert(intArrayOf(127867), ParseResult(2, SpriteCoordinates(4, 0, 529, 265))) // clinking beer mugs
        trie.insert(intArrayOf(129346), ParseResult(2, SpriteCoordinates(4, 0, 265, 463))) // clinking glasses
        trie.insert(intArrayOf(129347), ParseResult(2, SpriteCoordinates(4, 0, 199, 463))) // tumbler glass
        trie.insert(intArrayOf(129751), ParseResult(2, SpriteCoordinates(4, 0, 1, 133))) // pouring liquid
        trie.insert(intArrayOf(129380), ParseResult(2, SpriteCoordinates(4, 0, 397, 67))) // cup with straw
        trie.insert(intArrayOf(129483), ParseResult(2, SpriteCoordinates(4, 0, 133, 199))) // bubble tea
        trie.insert(intArrayOf(129475), ParseResult(2, SpriteCoordinates(4, 0, 133, 265))) // beverage box
        trie.insert(intArrayOf(129481), ParseResult(2, SpriteCoordinates(4, 0, 265, 1))) // mate
        trie.insert(intArrayOf(129482), ParseResult(2, SpriteCoordinates(4, 0, 199, 199))) // ice
        trie.insert(intArrayOf(129378), ParseResult(2, SpriteCoordinates(4, 0, 397, 199))) // chopsticks
        trie.insert(intArrayOf(127869, 65039), ParseResult(3, SpriteCoordinates(4, 0, 529, 133))) // fork and knife with plate
        trie.insert(intArrayOf(127869), ParseResult(2, SpriteCoordinates(4, 0, 529, 133))) // fork and knife with plate
        trie.insert(intArrayOf(127860), ParseResult(2, SpriteCoordinates(4, 0, 199, 529))) // fork and knife
        trie.insert(intArrayOf(129348), ParseResult(2, SpriteCoordinates(4, 0, 133, 463))) // spoon
        trie.insert(intArrayOf(128298), ParseResult(2, SpriteCoordinates(4, 0, 331, 463))) // kitchen knife
        trie.insert(intArrayOf(129753), ParseResult(2, SpriteCoordinates(4, 0, 133, 1))) // jar
        trie.insert(intArrayOf(127994), ParseResult(2, SpriteCoordinates(4, 0, 397, 463))) // amphora
        trie.insert(intArrayOf(127875), ParseResult(2, SpriteCoordinates(5, 0, 529, 529))) // jack-o-lantern
        trie.insert(intArrayOf(127876), ParseResult(2, SpriteCoordinates(5, 0, 463, 529))) // Christmas tree
        trie.insert(intArrayOf(127878), ParseResult(2, SpriteCoordinates(5, 0, 397, 529))) // fireworks
        trie.insert(intArrayOf(127879), ParseResult(2, SpriteCoordinates(5, 0, 331, 529))) // sparkler
        trie.insert(intArrayOf(129512), ParseResult(2, SpriteCoordinates(5, 0, 133, 265))) // firecracker
        trie.insert(intArrayOf(10024), ParseResult(1, SpriteCoordinates(5, 0, 1, 1))) // sparkles
        trie.insert(intArrayOf(127880), ParseResult(2, SpriteCoordinates(5, 0, 265, 529))) // balloon
        trie.insert(intArrayOf(127881), ParseResult(2, SpriteCoordinates(5, 0, 199, 529))) // party popper
        trie.insert(intArrayOf(127882), ParseResult(2, SpriteCoordinates(5, 0, 133, 529))) // confetti ball
        trie.insert(intArrayOf(127883), ParseResult(2, SpriteCoordinates(5, 0, 67, 529))) // tanabata tree
        trie.insert(intArrayOf(127885), ParseResult(2, SpriteCoordinates(5, 0, 1, 529))) // pine decoration
        trie.insert(intArrayOf(127886), ParseResult(2, SpriteCoordinates(5, 0, 529, 463))) // Japanese dolls
        trie.insert(intArrayOf(127887), ParseResult(2, SpriteCoordinates(5, 0, 529, 397))) // carp streamer
        trie.insert(intArrayOf(127888), ParseResult(2, SpriteCoordinates(5, 0, 529, 331))) // wind chime
        trie.insert(intArrayOf(127889), ParseResult(2, SpriteCoordinates(5, 0, 529, 265))) // moon viewing ceremony
        trie.insert(intArrayOf(129511), ParseResult(2, SpriteCoordinates(5, 0, 199, 265))) // red envelope
        trie.insert(intArrayOf(127872), ParseResult(2, SpriteCoordinates(5, 0, 595, 67))) // ribbon
        trie.insert(intArrayOf(127873), ParseResult(2, SpriteCoordinates(5, 0, 595, 1))) // wrapped gift
        trie.insert(intArrayOf(127895), ParseResult(2, SpriteCoordinates(5, 0, 529, 133))) // reminder ribbon
        trie.insert(intArrayOf(127895, 65039), ParseResult(3, SpriteCoordinates(5, 0, 529, 133))) // reminder ribbon
        trie.insert(intArrayOf(127903), ParseResult(2, SpriteCoordinates(5, 0, 529, 67))) // admission tickets
        trie.insert(intArrayOf(127903, 65039), ParseResult(3, SpriteCoordinates(5, 0, 529, 67))) // admission tickets
        trie.insert(intArrayOf(127915), ParseResult(2, SpriteCoordinates(5, 0, 397, 463))) // ticket
        trie.insert(intArrayOf(127894), ParseResult(2, SpriteCoordinates(5, 0, 529, 199))) // military medal
        trie.insert(intArrayOf(127894, 65039), ParseResult(3, SpriteCoordinates(5, 0, 529, 199))) // military medal
        trie.insert(intArrayOf(127942), ParseResult(2, SpriteCoordinates(5, 0, 397, 397))) // trophy
        trie.insert(intArrayOf(127941), ParseResult(2, SpriteCoordinates(5, 0, 463, 1))) // sports medal
        trie.insert(intArrayOf(129351), ParseResult(2, SpriteCoordinates(5, 0, 133, 331))) // 1st place medal
        trie.insert(intArrayOf(129352), ParseResult(2, SpriteCoordinates(5, 0, 67, 331))) // 2nd place medal
        trie.insert(intArrayOf(129353), ParseResult(2, SpriteCoordinates(5, 0, 1, 331))) // 3rd place medal
        trie.insert(intArrayOf(9917), ParseResult(1, SpriteCoordinates(5, 0, 133, 1))) // soccer ball
        trie.insert(intArrayOf(9918), ParseResult(1, SpriteCoordinates(5, 0, 67, 67))) // baseball
        trie.insert(intArrayOf(129358), ParseResult(2, SpriteCoordinates(5, 0, 331, 1))) // softball
        trie.insert(intArrayOf(127936), ParseResult(2, SpriteCoordinates(5, 0, 463, 67))) // basketball
        trie.insert(intArrayOf(127952), ParseResult(2, SpriteCoordinates(5, 0, 133, 397))) // volleyball
        trie.insert(intArrayOf(127944), ParseResult(2, SpriteCoordinates(5, 0, 331, 397))) // american football
        trie.insert(intArrayOf(127945), ParseResult(2, SpriteCoordinates(5, 0, 265, 397))) // rugby football
        trie.insert(intArrayOf(127934), ParseResult(2, SpriteCoordinates(5, 0, 463, 199))) // tennis
        trie.insert(intArrayOf(129359), ParseResult(2, SpriteCoordinates(5, 0, 265, 265))) // flying disc
        trie.insert(intArrayOf(127923), ParseResult(2, SpriteCoordinates(5, 0, 463, 397))) // bowling
        trie.insert(intArrayOf(127951), ParseResult(2, SpriteCoordinates(5, 0, 199, 397))) // cricket game
        trie.insert(intArrayOf(127953), ParseResult(2, SpriteCoordinates(5, 0, 67, 397))) // field hockey
        trie.insert(intArrayOf(127954), ParseResult(2, SpriteCoordinates(5, 0, 1, 397))) // ice hockey
        trie.insert(intArrayOf(129357), ParseResult(2, SpriteCoordinates(5, 0, 331, 67))) // lacrosse
        trie.insert(intArrayOf(127955), ParseResult(2, SpriteCoordinates(5, 0, 397, 331))) // ping pong
        trie.insert(intArrayOf(127992), ParseResult(2, SpriteCoordinates(5, 0, 397, 265))) // badminton
        trie.insert(intArrayOf(129354), ParseResult(2, SpriteCoordinates(5, 0, 331, 265))) // boxing glove
        trie.insert(intArrayOf(129355), ParseResult(2, SpriteCoordinates(5, 0, 331, 199))) // martial arts uniform
        trie.insert(intArrayOf(129349), ParseResult(2, SpriteCoordinates(5, 0, 199, 331))) // goal net
        trie.insert(intArrayOf(9971), ParseResult(1, SpriteCoordinates(5, 0, 1, 67))) // flag in hole
        trie.insert(intArrayOf(9976), ParseResult(1, SpriteCoordinates(5, 0, 67, 1))) // ice skate
        trie.insert(intArrayOf(9976, 65039), ParseResult(2, SpriteCoordinates(5, 0, 67, 1))) // ice skate
        trie.insert(intArrayOf(127907), ParseResult(2, SpriteCoordinates(5, 0, 529, 1))) // fishing pole
        trie.insert(intArrayOf(129343), ParseResult(2, SpriteCoordinates(5, 0, 265, 331))) // diving mask
        trie.insert(intArrayOf(127933), ParseResult(2, SpriteCoordinates(5, 0, 463, 265))) // running shirt
        trie.insert(intArrayOf(127935), ParseResult(2, SpriteCoordinates(5, 0, 463, 133))) // skis
        trie.insert(intArrayOf(128759), ParseResult(2, SpriteCoordinates(5, 0, 331, 331))) // sled
        trie.insert(intArrayOf(129356), ParseResult(2, SpriteCoordinates(5, 0, 331, 133))) // curling stone
        trie.insert(intArrayOf(127919), ParseResult(2, SpriteCoordinates(5, 0, 199, 463))) // bullseye
        trie.insert(intArrayOf(129664), ParseResult(2, SpriteCoordinates(5, 0, 265, 67))) // yo-yo
        trie.insert(intArrayOf(129665), ParseResult(2, SpriteCoordinates(5, 0, 265, 1))) // kite
        trie.insert(intArrayOf(128299), ParseResult(2, SpriteCoordinates(5, 0, 397, 199))) // water pistol
        trie.insert(intArrayOf(127921), ParseResult(2, SpriteCoordinates(5, 0, 67, 463))) // pool 8 ball
        trie.insert(intArrayOf(128302), ParseResult(2, SpriteCoordinates(5, 0, 397, 133))) // crystal ball
        trie.insert(intArrayOf(129668), ParseResult(2, SpriteCoordinates(5, 0, 199, 199))) // magic wand
        trie.insert(intArrayOf(127918), ParseResult(2, SpriteCoordinates(5, 0, 265, 463))) // video game
        trie.insert(intArrayOf(128377), ParseResult(2, SpriteCoordinates(5, 0, 397, 67))) // joystick
        trie.insert(intArrayOf(128377, 65039), ParseResult(3, SpriteCoordinates(5, 0, 397, 67))) // joystick
        trie.insert(intArrayOf(127920), ParseResult(2, SpriteCoordinates(5, 0, 133, 463))) // slot machine
        trie.insert(intArrayOf(127922), ParseResult(2, SpriteCoordinates(5, 0, 1, 463))) // game die
        trie.insert(intArrayOf(129513), ParseResult(2, SpriteCoordinates(5, 0, 67, 265))) // puzzle piece
        trie.insert(intArrayOf(129528), ParseResult(2, SpriteCoordinates(5, 0, 265, 133))) // teddy bear
        trie.insert(intArrayOf(129669), ParseResult(2, SpriteCoordinates(5, 0, 133, 199))) // piñata
        trie.insert(intArrayOf(129705), ParseResult(2, SpriteCoordinates(5, 0, 199, 67))) // mirror ball
        trie.insert(intArrayOf(129670), ParseResult(2, SpriteCoordinates(5, 0, 67, 199))) // nesting dolls
        trie.insert(intArrayOf(9824), ParseResult(1, SpriteCoordinates(5, 0, 133, 133))) // spade suit
        trie.insert(intArrayOf(9824, 65039), ParseResult(2, SpriteCoordinates(5, 0, 133, 133))) // spade suit
        trie.insert(intArrayOf(9829, 65039), ParseResult(2, SpriteCoordinates(5, 0, 1, 133))) // heart suit
        trie.insert(intArrayOf(9829), ParseResult(1, SpriteCoordinates(5, 0, 1, 133))) // heart suit
        trie.insert(intArrayOf(9830, 65039), ParseResult(2, SpriteCoordinates(5, 0, 133, 67))) // diamond suit
        trie.insert(intArrayOf(9830), ParseResult(1, SpriteCoordinates(5, 0, 133, 67))) // diamond suit
        trie.insert(intArrayOf(9827, 65039), ParseResult(2, SpriteCoordinates(5, 0, 67, 133))) // club suit
        trie.insert(intArrayOf(9827), ParseResult(1, SpriteCoordinates(5, 0, 67, 133))) // club suit
        trie.insert(intArrayOf(9823, 65039), ParseResult(2, SpriteCoordinates(5, 0, 199, 1))) // chess pawn
        trie.insert(intArrayOf(9823), ParseResult(1, SpriteCoordinates(5, 0, 199, 1))) // chess pawn
        trie.insert(intArrayOf(127183), ParseResult(2, SpriteCoordinates(5, 0, 595, 133))) // joker
        trie.insert(intArrayOf(126980), ParseResult(2, SpriteCoordinates(5, 0, 595, 199))) // mahjong red dragon
        trie.insert(intArrayOf(127924), ParseResult(2, SpriteCoordinates(5, 0, 463, 331))) // flower playing cards
        trie.insert(intArrayOf(127917), ParseResult(2, SpriteCoordinates(5, 0, 331, 463))) // performing arts
        trie.insert(intArrayOf(128444), ParseResult(2, SpriteCoordinates(5, 0, 397, 1))) // framed picture
        trie.insert(intArrayOf(128444, 65039), ParseResult(3, SpriteCoordinates(5, 0, 397, 1))) // framed picture
        trie.insert(intArrayOf(127912), ParseResult(2, SpriteCoordinates(5, 0, 463, 463))) // artist palette
        trie.insert(intArrayOf(129525), ParseResult(2, SpriteCoordinates(5, 0, 1, 265))) // thread
        trie.insert(intArrayOf(129697), ParseResult(2, SpriteCoordinates(5, 0, 1, 199))) // sewing needle
        trie.insert(intArrayOf(129526), ParseResult(2, SpriteCoordinates(5, 0, 265, 199))) // yarn
        trie.insert(intArrayOf(129698), ParseResult(2, SpriteCoordinates(5, 0, 199, 133))) // knot
        trie.insert(intArrayOf(127757), ParseResult(2, SpriteCoordinates(6, 0, 925, 529))) // globe showing Europe-Africa
        trie.insert(intArrayOf(127758), ParseResult(2, SpriteCoordinates(6, 0, 925, 463))) // globe showing Americas
        trie.insert(intArrayOf(127759), ParseResult(2, SpriteCoordinates(6, 0, 925, 397))) // globe showing Asia-Australia
        trie.insert(intArrayOf(127760), ParseResult(2, SpriteCoordinates(6, 0, 925, 331))) // globe with meridians
        trie.insert(intArrayOf(128506), ParseResult(2, SpriteCoordinates(6, 0, 661, 529))) // world map
        trie.insert(intArrayOf(128506, 65039), ParseResult(3, SpriteCoordinates(6, 0, 661, 529))) // world map
        trie.insert(intArrayOf(128510), ParseResult(2, SpriteCoordinates(6, 0, 661, 265))) // map of Japan
        trie.insert(intArrayOf(129517), ParseResult(2, SpriteCoordinates(6, 0, 397, 1))) // compass
        trie.insert(intArrayOf(127956, 65039), ParseResult(3, SpriteCoordinates(6, 0, 793, 793))) // snow-capped mountain
        trie.insert(intArrayOf(127956), ParseResult(2, SpriteCoordinates(6, 0, 793, 793))) // snow-capped mountain
        trie.insert(intArrayOf(9968), ParseResult(1, SpriteCoordinates(6, 0, 199, 1))) // mountain
        trie.insert(intArrayOf(9968, 65039), ParseResult(2, SpriteCoordinates(6, 0, 199, 1))) // mountain
        trie.insert(intArrayOf(127755), ParseResult(2, SpriteCoordinates(6, 0, 925, 661))) // volcano
        trie.insert(intArrayOf(128507), ParseResult(2, SpriteCoordinates(6, 0, 661, 463))) // mount fuji
        trie.insert(intArrayOf(127957, 65039), ParseResult(3, SpriteCoordinates(6, 0, 727, 793))) // camping
        trie.insert(intArrayOf(127957), ParseResult(2, SpriteCoordinates(6, 0, 727, 793))) // camping
        trie.insert(intArrayOf(127958), ParseResult(2, SpriteCoordinates(6, 0, 661, 793))) // beach with umbrella
        trie.insert(intArrayOf(127958, 65039), ParseResult(3, SpriteCoordinates(6, 0, 661, 793))) // beach with umbrella
        trie.insert(intArrayOf(127964), ParseResult(2, SpriteCoordinates(6, 0, 265, 793))) // desert
        trie.insert(intArrayOf(127964, 65039), ParseResult(3, SpriteCoordinates(6, 0, 265, 793))) // desert
        trie.insert(intArrayOf(127965), ParseResult(2, SpriteCoordinates(6, 0, 199, 793))) // desert island
        trie.insert(intArrayOf(127965, 65039), ParseResult(3, SpriteCoordinates(6, 0, 199, 793))) // desert island
        trie.insert(intArrayOf(127966), ParseResult(2, SpriteCoordinates(6, 0, 133, 793))) // national park
        trie.insert(intArrayOf(127966, 65039), ParseResult(3, SpriteCoordinates(6, 0, 133, 793))) // national park
        trie.insert(intArrayOf(127967), ParseResult(2, SpriteCoordinates(6, 0, 67, 793))) // stadium
        trie.insert(intArrayOf(127967, 65039), ParseResult(3, SpriteCoordinates(6, 0, 67, 793))) // stadium
        trie.insert(intArrayOf(127963), ParseResult(2, SpriteCoordinates(6, 0, 331, 793))) // classical building
        trie.insert(intArrayOf(127963, 65039), ParseResult(3, SpriteCoordinates(6, 0, 331, 793))) // classical building
        trie.insert(intArrayOf(127959), ParseResult(2, SpriteCoordinates(6, 0, 595, 793))) // building construction
        trie.insert(intArrayOf(127959, 65039), ParseResult(3, SpriteCoordinates(6, 0, 595, 793))) // building construction
        trie.insert(intArrayOf(129521), ParseResult(2, SpriteCoordinates(6, 0, 331, 331))) // brick
        trie.insert(intArrayOf(129704), ParseResult(2, SpriteCoordinates(6, 0, 67, 331))) // rock
        trie.insert(intArrayOf(129717), ParseResult(2, SpriteCoordinates(6, 0, 1, 331))) // wood
        trie.insert(intArrayOf(128726), ParseResult(2, SpriteCoordinates(6, 0, 199, 463))) // hut
        trie.insert(intArrayOf(127960), ParseResult(2, SpriteCoordinates(6, 0, 529, 793))) // houses
        trie.insert(intArrayOf(127960, 65039), ParseResult(3, SpriteCoordinates(6, 0, 529, 793))) // houses
        trie.insert(intArrayOf(127962, 65039), ParseResult(3, SpriteCoordinates(6, 0, 397, 793))) // derelict house
        trie.insert(intArrayOf(127962), ParseResult(2, SpriteCoordinates(6, 0, 397, 793))) // derelict house
        trie.insert(intArrayOf(127968), ParseResult(2, SpriteCoordinates(6, 0, 1, 793))) // house
        trie.insert(intArrayOf(127969), ParseResult(2, SpriteCoordinates(6, 0, 793, 727))) // house with garden
        trie.insert(intArrayOf(127970), ParseResult(2, SpriteCoordinates(6, 0, 793, 661))) // office building
        trie.insert(intArrayOf(127971), ParseResult(2, SpriteCoordinates(6, 0, 793, 595))) // Japanese post office
        trie.insert(intArrayOf(127972), ParseResult(2, SpriteCoordinates(6, 0, 793, 529))) // post office
        trie.insert(intArrayOf(127973), ParseResult(2, SpriteCoordinates(6, 0, 793, 463))) // hospital
        trie.insert(intArrayOf(127974), ParseResult(2, SpriteCoordinates(6, 0, 793, 397))) // bank
        trie.insert(intArrayOf(127976), ParseResult(2, SpriteCoordinates(6, 0, 793, 331))) // hotel
        trie.insert(intArrayOf(127977), ParseResult(2, SpriteCoordinates(6, 0, 793, 265))) // love hotel
        trie.insert(intArrayOf(127978), ParseResult(2, SpriteCoordinates(6, 0, 793, 199))) // convenience store
        trie.insert(intArrayOf(127979), ParseResult(2, SpriteCoordinates(6, 0, 793, 133))) // school
        trie.insert(intArrayOf(127980), ParseResult(2, SpriteCoordinates(6, 0, 793, 67))) // department store
        trie.insert(intArrayOf(127981), ParseResult(2, SpriteCoordinates(6, 0, 793, 1))) // factory
        trie.insert(intArrayOf(127983), ParseResult(2, SpriteCoordinates(6, 0, 727, 727))) // Japanese castle
        trie.insert(intArrayOf(127984), ParseResult(2, SpriteCoordinates(6, 0, 661, 727))) // castle
        trie.insert(intArrayOf(128146), ParseResult(2, SpriteCoordinates(6, 0, 529, 727))) // wedding
        trie.insert(intArrayOf(128508), ParseResult(2, SpriteCoordinates(6, 0, 661, 397))) // Tokyo tower
        trie.insert(intArrayOf(128509), ParseResult(2, SpriteCoordinates(6, 0, 661, 331))) // Statue of Liberty
        trie.insert(intArrayOf(9962), ParseResult(1, SpriteCoordinates(6, 0, 199, 67))) // church
        trie.insert(intArrayOf(128332), ParseResult(2, SpriteCoordinates(6, 0, 199, 727))) // mosque
        trie.insert(intArrayOf(128725), ParseResult(2, SpriteCoordinates(6, 0, 265, 463))) // hindu temple
        trie.insert(intArrayOf(128333), ParseResult(2, SpriteCoordinates(6, 0, 133, 727))) // synagogue
        trie.insert(intArrayOf(9961), ParseResult(1, SpriteCoordinates(6, 0, 199, 133))) // shinto shrine
        trie.insert(intArrayOf(9961, 65039), ParseResult(2, SpriteCoordinates(6, 0, 199, 133))) // shinto shrine
        trie.insert(intArrayOf(128331), ParseResult(2, SpriteCoordinates(6, 0, 265, 727))) // kaaba
        trie.insert(intArrayOf(9970), ParseResult(1, SpriteCoordinates(6, 0, 67, 133))) // fountain
        trie.insert(intArrayOf(9978), ParseResult(1, SpriteCoordinates(6, 0, 133, 1))) // tent
        trie.insert(intArrayOf(127745), ParseResult(2, SpriteCoordinates(6, 0, 397, 925))) // foggy
        trie.insert(intArrayOf(127747), ParseResult(2, SpriteCoordinates(6, 0, 265, 925))) // night with stars
        trie.insert(intArrayOf(127961), ParseResult(2, SpriteCoordinates(6, 0, 463, 793))) // cityscape
        trie.insert(intArrayOf(127961, 65039), ParseResult(3, SpriteCoordinates(6, 0, 463, 793))) // cityscape
        trie.insert(intArrayOf(127748), ParseResult(2, SpriteCoordinates(6, 0, 199, 925))) // sunrise over mountains
        trie.insert(intArrayOf(127749), ParseResult(2, SpriteCoordinates(6, 0, 133, 925))) // sunrise
        trie.insert(intArrayOf(127750), ParseResult(2, SpriteCoordinates(6, 0, 67, 925))) // cityscape at dusk
        trie.insert(intArrayOf(127751), ParseResult(2, SpriteCoordinates(6, 0, 1, 925))) // sunset
        trie.insert(intArrayOf(127753), ParseResult(2, SpriteCoordinates(6, 0, 925, 793))) // bridge at night
        trie.insert(intArrayOf(9832, 65039), ParseResult(2, SpriteCoordinates(6, 0, 265, 67))) // hot springs
        trie.insert(intArrayOf(9832), ParseResult(1, SpriteCoordinates(6, 0, 265, 67))) // hot springs
        trie.insert(intArrayOf(127904), ParseResult(2, SpriteCoordinates(6, 0, 859, 331))) // carousel horse
        trie.insert(intArrayOf(128733), ParseResult(2, SpriteCoordinates(6, 0, 133, 463))) // playground slide
        trie.insert(intArrayOf(127905), ParseResult(2, SpriteCoordinates(6, 0, 859, 265))) // ferris wheel
        trie.insert(intArrayOf(127906), ParseResult(2, SpriteCoordinates(6, 0, 859, 199))) // roller coaster
        trie.insert(intArrayOf(128136), ParseResult(2, SpriteCoordinates(6, 0, 595, 727))) // barber pole
        trie.insert(intArrayOf(127914), ParseResult(2, SpriteCoordinates(6, 0, 859, 133))) // circus tent
        trie.insert(intArrayOf(128642), ParseResult(2, SpriteCoordinates(6, 0, 661, 67))) // locomotive
        trie.insert(intArrayOf(128643), ParseResult(2, SpriteCoordinates(6, 0, 661, 1))) // railway car
        trie.insert(intArrayOf(128644), ParseResult(2, SpriteCoordinates(6, 0, 595, 595))) // high-speed train
        trie.insert(intArrayOf(128645), ParseResult(2, SpriteCoordinates(6, 0, 529, 595))) // bullet train
        trie.insert(intArrayOf(128646), ParseResult(2, SpriteCoordinates(6, 0, 463, 595))) // train
        trie.insert(intArrayOf(128647), ParseResult(2, SpriteCoordinates(6, 0, 397, 595))) // metro
        trie.insert(intArrayOf(128648), ParseResult(2, SpriteCoordinates(6, 0, 331, 595))) // light rail
        trie.insert(intArrayOf(128649), ParseResult(2, SpriteCoordinates(6, 0, 265, 595))) // station
        trie.insert(intArrayOf(128650), ParseResult(2, SpriteCoordinates(6, 0, 199, 595))) // tram
        trie.insert(intArrayOf(128669), ParseResult(2, SpriteCoordinates(6, 0, 133, 529))) // monorail
        trie.insert(intArrayOf(128670), ParseResult(2, SpriteCoordinates(6, 0, 67, 529))) // mountain railway
        trie.insert(intArrayOf(128651), ParseResult(2, SpriteCoordinates(6, 0, 133, 595))) // tram car
        trie.insert(intArrayOf(128652), ParseResult(2, SpriteCoordinates(6, 0, 67, 595))) // bus
        trie.insert(intArrayOf(128653), ParseResult(2, SpriteCoordinates(6, 0, 1, 595))) // oncoming bus
        trie.insert(intArrayOf(128654), ParseResult(2, SpriteCoordinates(6, 0, 595, 529))) // trolleybus
        trie.insert(intArrayOf(128656), ParseResult(2, SpriteCoordinates(6, 0, 595, 397))) // minibus
        trie.insert(intArrayOf(128657), ParseResult(2, SpriteCoordinates(6, 0, 595, 331))) // ambulance
        trie.insert(intArrayOf(128658), ParseResult(2, SpriteCoordinates(6, 0, 595, 265))) // fire engine
        trie.insert(intArrayOf(128659), ParseResult(2, SpriteCoordinates(6, 0, 595, 199))) // police car
        trie.insert(intArrayOf(128660), ParseResult(2, SpriteCoordinates(6, 0, 595, 133))) // oncoming police car
        trie.insert(intArrayOf(128661), ParseResult(2, SpriteCoordinates(6, 0, 595, 67))) // taxi
        trie.insert(intArrayOf(128662), ParseResult(2, SpriteCoordinates(6, 0, 595, 1))) // oncoming taxi
        trie.insert(intArrayOf(128663), ParseResult(2, SpriteCoordinates(6, 0, 529, 529))) // automobile
        trie.insert(intArrayOf(128664), ParseResult(2, SpriteCoordinates(6, 0, 463, 529))) // oncoming automobile
        trie.insert(intArrayOf(128665), ParseResult(2, SpriteCoordinates(6, 0, 397, 529))) // sport utility vehicle
        trie.insert(intArrayOf(128763), ParseResult(2, SpriteCoordinates(6, 0, 397, 265))) // pickup truck
        trie.insert(intArrayOf(128666), ParseResult(2, SpriteCoordinates(6, 0, 331, 529))) // delivery truck
        trie.insert(intArrayOf(128667), ParseResult(2, SpriteCoordinates(6, 0, 265, 529))) // articulated lorry
        trie.insert(intArrayOf(128668), ParseResult(2, SpriteCoordinates(6, 0, 199, 529))) // tractor
        trie.insert(intArrayOf(127950, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 1))) // racing car
        trie.insert(intArrayOf(127950), ParseResult(2, SpriteCoordinates(6, 0, 859, 1))) // racing car
        trie.insert(intArrayOf(127949), ParseResult(2, SpriteCoordinates(6, 0, 859, 67))) // motorcycle
        trie.insert(intArrayOf(127949, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 67))) // motorcycle
        trie.insert(intArrayOf(128757), ParseResult(2, SpriteCoordinates(6, 0, 199, 397))) // motor scooter
        trie.insert(intArrayOf(129469), ParseResult(2, SpriteCoordinates(6, 0, 397, 67))) // manual wheelchair
        trie.insert(intArrayOf(129468), ParseResult(2, SpriteCoordinates(6, 0, 397, 133))) // motorized wheelchair
        trie.insert(intArrayOf(128762), ParseResult(2, SpriteCoordinates(6, 0, 397, 331))) // auto rickshaw
        trie.insert(intArrayOf(128690), ParseResult(2, SpriteCoordinates(6, 0, 463, 463))) // bicycle
        trie.insert(intArrayOf(128756), ParseResult(2, SpriteCoordinates(6, 0, 265, 397))) // kick scooter
        trie.insert(intArrayOf(128761), ParseResult(2, SpriteCoordinates(6, 0, 1, 397))) // skateboard
        trie.insert(intArrayOf(128764), ParseResult(2, SpriteCoordinates(6, 0, 397, 199))) // roller skate
        trie.insert(intArrayOf(128655), ParseResult(2, SpriteCoordinates(6, 0, 595, 463))) // bus stop
        trie.insert(intArrayOf(128739), ParseResult(2, SpriteCoordinates(6, 0, 463, 331))) // motorway
        trie.insert(intArrayOf(128739, 65039), ParseResult(3, SpriteCoordinates(6, 0, 463, 331))) // motorway
        trie.insert(intArrayOf(128740, 65039), ParseResult(3, SpriteCoordinates(6, 0, 463, 265))) // railway track
        trie.insert(intArrayOf(128740), ParseResult(2, SpriteCoordinates(6, 0, 463, 265))) // railway track
        trie.insert(intArrayOf(128738, 65039), ParseResult(3, SpriteCoordinates(6, 0, 463, 397))) // oil drum
        trie.insert(intArrayOf(128738), ParseResult(2, SpriteCoordinates(6, 0, 463, 397))) // oil drum
        trie.insert(intArrayOf(9981), ParseResult(1, SpriteCoordinates(6, 0, 67, 67))) // fuel pump
        trie.insert(intArrayOf(128734), ParseResult(2, SpriteCoordinates(6, 0, 67, 463))) // wheel
        trie.insert(intArrayOf(128680), ParseResult(2, SpriteCoordinates(6, 0, 529, 1))) // police car light
        trie.insert(intArrayOf(128677), ParseResult(2, SpriteCoordinates(6, 0, 529, 199))) // horizontal traffic light
        trie.insert(intArrayOf(128678), ParseResult(2, SpriteCoordinates(6, 0, 529, 133))) // vertical traffic light
        trie.insert(intArrayOf(128721), ParseResult(2, SpriteCoordinates(6, 0, 331, 463))) // stop sign
        trie.insert(intArrayOf(128679), ParseResult(2, SpriteCoordinates(6, 0, 529, 67))) // construction
        trie.insert(intArrayOf(9875), ParseResult(1, SpriteCoordinates(6, 0, 265, 1))) // anchor
        trie.insert(intArrayOf(128735), ParseResult(2, SpriteCoordinates(6, 0, 1, 463))) // ring buoy
        trie.insert(intArrayOf(9973), ParseResult(1, SpriteCoordinates(6, 0, 133, 67))) // sailboat
        trie.insert(intArrayOf(128758), ParseResult(2, SpriteCoordinates(6, 0, 133, 397))) // canoe
        trie.insert(intArrayOf(128676), ParseResult(2, SpriteCoordinates(6, 0, 529, 265))) // speedboat
        trie.insert(intArrayOf(128755), ParseResult(2, SpriteCoordinates(6, 0, 331, 397))) // passenger ship
        trie.insert(intArrayOf(128755, 65039), ParseResult(3, SpriteCoordinates(6, 0, 331, 397))) // passenger ship
        trie.insert(intArrayOf(9972, 65039), ParseResult(2, SpriteCoordinates(6, 0, 1, 133))) // ferry
        trie.insert(intArrayOf(9972), ParseResult(1, SpriteCoordinates(6, 0, 1, 133))) // ferry
        trie.insert(intArrayOf(128741, 65039), ParseResult(3, SpriteCoordinates(6, 0, 463, 199))) // motor boat
        trie.insert(intArrayOf(128741), ParseResult(2, SpriteCoordinates(6, 0, 463, 199))) // motor boat
        trie.insert(intArrayOf(128674), ParseResult(2, SpriteCoordinates(6, 0, 529, 331))) // ship
        trie.insert(intArrayOf(9992, 65039), ParseResult(2, SpriteCoordinates(6, 0, 1, 67))) // airplane
        trie.insert(intArrayOf(9992), ParseResult(1, SpriteCoordinates(6, 0, 1, 67))) // airplane
        trie.insert(intArrayOf(128745, 65039), ParseResult(3, SpriteCoordinates(6, 0, 463, 133))) // small airplane
        trie.insert(intArrayOf(128745), ParseResult(2, SpriteCoordinates(6, 0, 463, 133))) // small airplane
        trie.insert(intArrayOf(128747), ParseResult(2, SpriteCoordinates(6, 0, 463, 67))) // airplane departure
        trie.insert(intArrayOf(128748), ParseResult(2, SpriteCoordinates(6, 0, 463, 1))) // airplane arrival
        trie.insert(intArrayOf(129666), ParseResult(2, SpriteCoordinates(6, 0, 199, 331))) // parachute
        trie.insert(intArrayOf(128186), ParseResult(2, SpriteCoordinates(6, 0, 397, 727))) // seat
        trie.insert(intArrayOf(128641), ParseResult(2, SpriteCoordinates(6, 0, 661, 133))) // helicopter
        trie.insert(intArrayOf(128671), ParseResult(2, SpriteCoordinates(6, 0, 1, 529))) // suspension railway
        trie.insert(intArrayOf(128672), ParseResult(2, SpriteCoordinates(6, 0, 529, 463))) // mountain cableway
        trie.insert(intArrayOf(128673), ParseResult(2, SpriteCoordinates(6, 0, 529, 397))) // aerial tramway
        trie.insert(intArrayOf(128752), ParseResult(2, SpriteCoordinates(6, 0, 397, 397))) // satellite
        trie.insert(intArrayOf(128752, 65039), ParseResult(3, SpriteCoordinates(6, 0, 397, 397))) // satellite
        trie.insert(intArrayOf(128640), ParseResult(2, SpriteCoordinates(6, 0, 661, 199))) // rocket
        trie.insert(intArrayOf(128760), ParseResult(2, SpriteCoordinates(6, 0, 67, 397))) // flying saucer
        trie.insert(intArrayOf(128718, 65039), ParseResult(3, SpriteCoordinates(6, 0, 397, 463))) // bellhop bell
        trie.insert(intArrayOf(128718), ParseResult(2, SpriteCoordinates(6, 0, 397, 463))) // bellhop bell
        trie.insert(intArrayOf(129523), ParseResult(2, SpriteCoordinates(6, 0, 265, 331))) // luggage
        trie.insert(intArrayOf(8987), ParseResult(1, SpriteCoordinates(6, 0, 331, 199))) // hourglass done
        trie.insert(intArrayOf(9203), ParseResult(1, SpriteCoordinates(6, 0, 265, 265))) // hourglass not done
        trie.insert(intArrayOf(8986), ParseResult(1, SpriteCoordinates(6, 0, 331, 265))) // watch
        trie.insert(intArrayOf(9200), ParseResult(1, SpriteCoordinates(6, 0, 331, 133))) // alarm clock
        trie.insert(intArrayOf(9201), ParseResult(1, SpriteCoordinates(6, 0, 331, 67))) // stopwatch
        trie.insert(intArrayOf(9201, 65039), ParseResult(2, SpriteCoordinates(6, 0, 331, 67))) // stopwatch
        trie.insert(intArrayOf(9202, 65039), ParseResult(2, SpriteCoordinates(6, 0, 331, 1))) // timer clock
        trie.insert(intArrayOf(9202), ParseResult(1, SpriteCoordinates(6, 0, 331, 1))) // timer clock
        trie.insert(intArrayOf(128368), ParseResult(2, SpriteCoordinates(6, 0, 661, 595))) // mantelpiece clock
        trie.insert(intArrayOf(128368, 65039), ParseResult(3, SpriteCoordinates(6, 0, 661, 595))) // mantelpiece clock
        trie.insert(intArrayOf(128347), ParseResult(2, SpriteCoordinates(6, 0, 727, 67))) // twelve o’clock
        trie.insert(intArrayOf(128359), ParseResult(2, SpriteCoordinates(6, 0, 1, 661))) // twelve-thirty
        trie.insert(intArrayOf(128336), ParseResult(2, SpriteCoordinates(6, 0, 67, 727))) // one o’clock
        trie.insert(intArrayOf(128348), ParseResult(2, SpriteCoordinates(6, 0, 727, 1))) // one-thirty
        trie.insert(intArrayOf(128337), ParseResult(2, SpriteCoordinates(6, 0, 1, 727))) // two o’clock
        trie.insert(intArrayOf(128349), ParseResult(2, SpriteCoordinates(6, 0, 661, 661))) // two-thirty
        trie.insert(intArrayOf(128338), ParseResult(2, SpriteCoordinates(6, 0, 727, 661))) // three o’clock
        trie.insert(intArrayOf(128350), ParseResult(2, SpriteCoordinates(6, 0, 595, 661))) // three-thirty
        trie.insert(intArrayOf(128339), ParseResult(2, SpriteCoordinates(6, 0, 727, 595))) // four o’clock
        trie.insert(intArrayOf(128351), ParseResult(2, SpriteCoordinates(6, 0, 529, 661))) // four-thirty
        trie.insert(intArrayOf(128340), ParseResult(2, SpriteCoordinates(6, 0, 727, 529))) // five o’clock
        trie.insert(intArrayOf(128352), ParseResult(2, SpriteCoordinates(6, 0, 463, 661))) // five-thirty
        trie.insert(intArrayOf(128341), ParseResult(2, SpriteCoordinates(6, 0, 727, 463))) // six o’clock
        trie.insert(intArrayOf(128353), ParseResult(2, SpriteCoordinates(6, 0, 397, 661))) // six-thirty
        trie.insert(intArrayOf(128342), ParseResult(2, SpriteCoordinates(6, 0, 727, 397))) // seven o’clock
        trie.insert(intArrayOf(128354), ParseResult(2, SpriteCoordinates(6, 0, 331, 661))) // seven-thirty
        trie.insert(intArrayOf(128343), ParseResult(2, SpriteCoordinates(6, 0, 727, 331))) // eight o’clock
        trie.insert(intArrayOf(128355), ParseResult(2, SpriteCoordinates(6, 0, 265, 661))) // eight-thirty
        trie.insert(intArrayOf(128344), ParseResult(2, SpriteCoordinates(6, 0, 727, 265))) // nine o’clock
        trie.insert(intArrayOf(128356), ParseResult(2, SpriteCoordinates(6, 0, 199, 661))) // nine-thirty
        trie.insert(intArrayOf(128345), ParseResult(2, SpriteCoordinates(6, 0, 727, 199))) // ten o’clock
        trie.insert(intArrayOf(128357), ParseResult(2, SpriteCoordinates(6, 0, 133, 661))) // ten-thirty
        trie.insert(intArrayOf(128346), ParseResult(2, SpriteCoordinates(6, 0, 727, 133))) // eleven o’clock
        trie.insert(intArrayOf(128358), ParseResult(2, SpriteCoordinates(6, 0, 67, 661))) // eleven-thirty
        trie.insert(intArrayOf(127761), ParseResult(2, SpriteCoordinates(6, 0, 925, 265))) // new moon
        trie.insert(intArrayOf(127762), ParseResult(2, SpriteCoordinates(6, 0, 925, 199))) // waxing crescent moon
        trie.insert(intArrayOf(127763), ParseResult(2, SpriteCoordinates(6, 0, 925, 133))) // first quarter moon
        trie.insert(intArrayOf(127764), ParseResult(2, SpriteCoordinates(6, 0, 925, 67))) // waxing gibbous moon
        trie.insert(intArrayOf(127765), ParseResult(2, SpriteCoordinates(6, 0, 925, 1))) // full moon
        trie.insert(intArrayOf(127766), ParseResult(2, SpriteCoordinates(6, 0, 859, 859))) // waning gibbous moon
        trie.insert(intArrayOf(127767), ParseResult(2, SpriteCoordinates(6, 0, 793, 859))) // last quarter moon
        trie.insert(intArrayOf(127768), ParseResult(2, SpriteCoordinates(6, 0, 727, 859))) // waning crescent moon
        trie.insert(intArrayOf(127769), ParseResult(2, SpriteCoordinates(6, 0, 661, 859))) // crescent moon
        trie.insert(intArrayOf(127770), ParseResult(2, SpriteCoordinates(6, 0, 595, 859))) // new moon face
        trie.insert(intArrayOf(127771), ParseResult(2, SpriteCoordinates(6, 0, 529, 859))) // first quarter moon face
        trie.insert(intArrayOf(127772), ParseResult(2, SpriteCoordinates(6, 0, 463, 859))) // last quarter moon face
        trie.insert(intArrayOf(127777, 65039), ParseResult(3, SpriteCoordinates(6, 0, 133, 859))) // thermometer
        trie.insert(intArrayOf(127777), ParseResult(2, SpriteCoordinates(6, 0, 133, 859))) // thermometer
        trie.insert(intArrayOf(9728, 65039), ParseResult(2, SpriteCoordinates(6, 0, 199, 265))) // sun
        trie.insert(intArrayOf(9728), ParseResult(1, SpriteCoordinates(6, 0, 199, 265))) // sun
        trie.insert(intArrayOf(127773), ParseResult(2, SpriteCoordinates(6, 0, 397, 859))) // full moon face
        trie.insert(intArrayOf(127774), ParseResult(2, SpriteCoordinates(6, 0, 331, 859))) // sun with face
        trie.insert(intArrayOf(129680), ParseResult(2, SpriteCoordinates(6, 0, 133, 331))) // ringed planet
        trie.insert(intArrayOf(11088), ParseResult(1, SpriteCoordinates(6, 0, 1, 1))) // star
        trie.insert(intArrayOf(127775), ParseResult(2, SpriteCoordinates(6, 0, 265, 859))) // glowing star
        trie.insert(intArrayOf(127776), ParseResult(2, SpriteCoordinates(6, 0, 199, 859))) // shooting star
        trie.insert(intArrayOf(127756), ParseResult(2, SpriteCoordinates(6, 0, 925, 595))) // milky way
        trie.insert(intArrayOf(9729), ParseResult(1, SpriteCoordinates(6, 0, 133, 265))) // cloud
        trie.insert(intArrayOf(9729, 65039), ParseResult(2, SpriteCoordinates(6, 0, 133, 265))) // cloud
        trie.insert(intArrayOf(9925), ParseResult(1, SpriteCoordinates(6, 0, 67, 199))) // sun behind cloud
        trie.insert(intArrayOf(9928, 65039), ParseResult(2, SpriteCoordinates(6, 0, 1, 199))) // cloud with lightning and rain
        trie.insert(intArrayOf(9928), ParseResult(1, SpriteCoordinates(6, 0, 1, 199))) // cloud with lightning and rain
    }

    private fun init11(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(127780, 65039), ParseResult(3, SpriteCoordinates(6, 0, 67, 859))) // sun behind small cloud
        trie.insert(intArrayOf(127780), ParseResult(2, SpriteCoordinates(6, 0, 67, 859))) // sun behind small cloud
        trie.insert(intArrayOf(127781, 65039), ParseResult(3, SpriteCoordinates(6, 0, 1, 859))) // sun behind large cloud
        trie.insert(intArrayOf(127781), ParseResult(2, SpriteCoordinates(6, 0, 1, 859))) // sun behind large cloud
        trie.insert(intArrayOf(127782, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 793))) // sun behind rain cloud
        trie.insert(intArrayOf(127782), ParseResult(2, SpriteCoordinates(6, 0, 859, 793))) // sun behind rain cloud
        trie.insert(intArrayOf(127783, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 727))) // cloud with rain
        trie.insert(intArrayOf(127783), ParseResult(2, SpriteCoordinates(6, 0, 859, 727))) // cloud with rain
        trie.insert(intArrayOf(127784, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 661))) // cloud with snow
        trie.insert(intArrayOf(127784), ParseResult(2, SpriteCoordinates(6, 0, 859, 661))) // cloud with snow
        trie.insert(intArrayOf(127785, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 595))) // cloud with lightning
        trie.insert(intArrayOf(127785), ParseResult(2, SpriteCoordinates(6, 0, 859, 595))) // cloud with lightning
        trie.insert(intArrayOf(127786), ParseResult(2, SpriteCoordinates(6, 0, 859, 529))) // tornado
        trie.insert(intArrayOf(127786, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 529))) // tornado
        trie.insert(intArrayOf(127787, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 463))) // fog
        trie.insert(intArrayOf(127787), ParseResult(2, SpriteCoordinates(6, 0, 859, 463))) // fog
        trie.insert(intArrayOf(127788, 65039), ParseResult(3, SpriteCoordinates(6, 0, 859, 397))) // wind face
        trie.insert(intArrayOf(127788), ParseResult(2, SpriteCoordinates(6, 0, 859, 397))) // wind face
        trie.insert(intArrayOf(127744), ParseResult(2, SpriteCoordinates(6, 0, 463, 925))) // cyclone
        trie.insert(intArrayOf(127752), ParseResult(2, SpriteCoordinates(6, 0, 925, 859))) // rainbow
        trie.insert(intArrayOf(127746), ParseResult(2, SpriteCoordinates(6, 0, 331, 925))) // closed umbrella
        trie.insert(intArrayOf(9730, 65039), ParseResult(2, SpriteCoordinates(6, 0, 67, 265))) // umbrella
        trie.insert(intArrayOf(9730), ParseResult(1, SpriteCoordinates(6, 0, 67, 265))) // umbrella
        trie.insert(intArrayOf(9748), ParseResult(1, SpriteCoordinates(6, 0, 265, 133))) // umbrella with rain drops
        trie.insert(intArrayOf(9969, 65039), ParseResult(2, SpriteCoordinates(6, 0, 133, 133))) // umbrella on ground
        trie.insert(intArrayOf(9969), ParseResult(1, SpriteCoordinates(6, 0, 133, 133))) // umbrella on ground
        trie.insert(intArrayOf(9889), ParseResult(1, SpriteCoordinates(6, 0, 199, 199))) // high voltage
        trie.insert(intArrayOf(10052), ParseResult(1, SpriteCoordinates(6, 0, 67, 1))) // snowflake
        trie.insert(intArrayOf(10052, 65039), ParseResult(2, SpriteCoordinates(6, 0, 67, 1))) // snowflake
        trie.insert(intArrayOf(9731, 65039), ParseResult(2, SpriteCoordinates(6, 0, 1, 265))) // snowman
        trie.insert(intArrayOf(9731), ParseResult(1, SpriteCoordinates(6, 0, 1, 265))) // snowman
        trie.insert(intArrayOf(9924), ParseResult(1, SpriteCoordinates(6, 0, 133, 199))) // snowman without snow
        trie.insert(intArrayOf(9732, 65039), ParseResult(2, SpriteCoordinates(6, 0, 265, 199))) // comet
        trie.insert(intArrayOf(9732), ParseResult(1, SpriteCoordinates(6, 0, 265, 199))) // comet
        trie.insert(intArrayOf(128293), ParseResult(2, SpriteCoordinates(6, 0, 331, 727))) // fire
        trie.insert(intArrayOf(128167), ParseResult(2, SpriteCoordinates(6, 0, 463, 727))) // droplet
        trie.insert(intArrayOf(127754), ParseResult(2, SpriteCoordinates(6, 0, 925, 727))) // water wave
        trie.insert(intArrayOf(128083), ParseResult(2, SpriteCoordinates(7, 0, 991, 925))) // glasses
        trie.insert(intArrayOf(128374, 65039), ParseResult(3, SpriteCoordinates(7, 0, 727, 1))) // sunglasses
        trie.insert(intArrayOf(128374), ParseResult(2, SpriteCoordinates(7, 0, 727, 1))) // sunglasses
        trie.insert(intArrayOf(129405), ParseResult(2, SpriteCoordinates(7, 0, 595, 199))) // goggles
        trie.insert(intArrayOf(129404), ParseResult(2, SpriteCoordinates(7, 0, 595, 265))) // lab coat
        trie.insert(intArrayOf(129466), ParseResult(2, SpriteCoordinates(7, 0, 529, 529))) // safety vest
        trie.insert(intArrayOf(128084), ParseResult(2, SpriteCoordinates(7, 0, 991, 859))) // necktie
        trie.insert(intArrayOf(128085), ParseResult(2, SpriteCoordinates(7, 0, 991, 793))) // t-shirt
        trie.insert(intArrayOf(128086), ParseResult(2, SpriteCoordinates(7, 0, 991, 727))) // jeans
        trie.insert(intArrayOf(129507), ParseResult(2, SpriteCoordinates(7, 0, 397, 529))) // scarf
        trie.insert(intArrayOf(129508), ParseResult(2, SpriteCoordinates(7, 0, 331, 529))) // gloves
        trie.insert(intArrayOf(129509), ParseResult(2, SpriteCoordinates(7, 0, 265, 529))) // coat
        trie.insert(intArrayOf(129510), ParseResult(2, SpriteCoordinates(7, 0, 199, 529))) // socks
        trie.insert(intArrayOf(128087), ParseResult(2, SpriteCoordinates(7, 0, 991, 661))) // dress
        trie.insert(intArrayOf(128088), ParseResult(2, SpriteCoordinates(7, 0, 991, 595))) // kimono
        trie.insert(intArrayOf(129403), ParseResult(2, SpriteCoordinates(7, 0, 595, 331))) // sari
        trie.insert(intArrayOf(129649), ParseResult(2, SpriteCoordinates(7, 0, 67, 463))) // one-piece swimsuit
        trie.insert(intArrayOf(129650), ParseResult(2, SpriteCoordinates(7, 0, 1, 463))) // briefs
        trie.insert(intArrayOf(129651), ParseResult(2, SpriteCoordinates(7, 0, 463, 397))) // shorts
        trie.insert(intArrayOf(128089), ParseResult(2, SpriteCoordinates(7, 0, 991, 529))) // bikini
        trie.insert(intArrayOf(128090), ParseResult(2, SpriteCoordinates(7, 0, 991, 463))) // woman’s clothes
        trie.insert(intArrayOf(129709), ParseResult(2, SpriteCoordinates(7, 0, 265, 199))) // folding hand fan
        trie.insert(intArrayOf(128091), ParseResult(2, SpriteCoordinates(7, 0, 991, 397))) // purse
        trie.insert(intArrayOf(128092), ParseResult(2, SpriteCoordinates(7, 0, 991, 331))) // handbag
        trie.insert(intArrayOf(128093), ParseResult(2, SpriteCoordinates(7, 0, 991, 265))) // clutch bag
        trie.insert(intArrayOf(128717), ParseResult(2, SpriteCoordinates(7, 0, 199, 595))) // shopping bags
        trie.insert(intArrayOf(128717, 65039), ParseResult(3, SpriteCoordinates(7, 0, 199, 595))) // shopping bags
        trie.insert(intArrayOf(127890), ParseResult(2, SpriteCoordinates(7, 0, 1057, 463))) // backpack
        trie.insert(intArrayOf(129652), ParseResult(2, SpriteCoordinates(7, 0, 463, 331))) // thong sandal
        trie.insert(intArrayOf(128094), ParseResult(2, SpriteCoordinates(7, 0, 991, 199))) // man’s shoe
        trie.insert(intArrayOf(128095), ParseResult(2, SpriteCoordinates(7, 0, 991, 133))) // running shoe
        trie.insert(intArrayOf(129406), ParseResult(2, SpriteCoordinates(7, 0, 595, 133))) // hiking boot
        trie.insert(intArrayOf(129407), ParseResult(2, SpriteCoordinates(7, 0, 595, 67))) // flat shoe
        trie.insert(intArrayOf(128096), ParseResult(2, SpriteCoordinates(7, 0, 991, 67))) // high-heeled shoe
        trie.insert(intArrayOf(128097), ParseResult(2, SpriteCoordinates(7, 0, 991, 1))) // woman’s sandal
        trie.insert(intArrayOf(129648), ParseResult(2, SpriteCoordinates(7, 0, 133, 463))) // ballet shoes
        trie.insert(intArrayOf(128098), ParseResult(2, SpriteCoordinates(7, 0, 925, 925))) // woman’s boot
        trie.insert(intArrayOf(129710), ParseResult(2, SpriteCoordinates(7, 0, 265, 133))) // hair pick
        trie.insert(intArrayOf(128081), ParseResult(2, SpriteCoordinates(7, 0, 67, 991))) // crown
        trie.insert(intArrayOf(128082), ParseResult(2, SpriteCoordinates(7, 0, 1, 991))) // woman’s hat
        trie.insert(intArrayOf(127913), ParseResult(2, SpriteCoordinates(7, 0, 925, 991))) // top hat
        trie.insert(intArrayOf(127891), ParseResult(2, SpriteCoordinates(7, 0, 1057, 397))) // graduation cap
        trie.insert(intArrayOf(129506), ParseResult(2, SpriteCoordinates(7, 0, 463, 529))) // billed cap
        trie.insert(intArrayOf(129686), ParseResult(2, SpriteCoordinates(7, 0, 397, 133))) // military helmet
        trie.insert(intArrayOf(9937), ParseResult(1, SpriteCoordinates(7, 0, 1, 133))) // rescue worker’s helmet
        trie.insert(intArrayOf(9937, 65039), ParseResult(2, SpriteCoordinates(7, 0, 1, 133))) // rescue worker’s helmet
        trie.insert(intArrayOf(128255), ParseResult(2, SpriteCoordinates(7, 0, 793, 133))) // prayer beads
        trie.insert(intArrayOf(128132), ParseResult(2, SpriteCoordinates(7, 0, 859, 925))) // lipstick
        trie.insert(intArrayOf(128141), ParseResult(2, SpriteCoordinates(7, 0, 661, 925))) // ring
        trie.insert(intArrayOf(128142), ParseResult(2, SpriteCoordinates(7, 0, 595, 925))) // gem stone
        trie.insert(intArrayOf(128263), ParseResult(2, SpriteCoordinates(7, 0, 793, 67))) // muted speaker
        trie.insert(intArrayOf(128264), ParseResult(2, SpriteCoordinates(7, 0, 793, 1))) // speaker low volume
        trie.insert(intArrayOf(128265), ParseResult(2, SpriteCoordinates(7, 0, 727, 727))) // speaker medium volume
        trie.insert(intArrayOf(128266), ParseResult(2, SpriteCoordinates(7, 0, 661, 727))) // speaker high volume
        trie.insert(intArrayOf(128226), ParseResult(2, SpriteCoordinates(7, 0, 859, 67))) // loudspeaker
        trie.insert(intArrayOf(128227), ParseResult(2, SpriteCoordinates(7, 0, 859, 1))) // megaphone
        trie.insert(intArrayOf(128239), ParseResult(2, SpriteCoordinates(7, 0, 67, 793))) // postal horn
        trie.insert(intArrayOf(128276), ParseResult(2, SpriteCoordinates(7, 0, 1, 727))) // bell
        trie.insert(intArrayOf(128277), ParseResult(2, SpriteCoordinates(7, 0, 727, 661))) // bell with slash
        trie.insert(intArrayOf(127932), ParseResult(2, SpriteCoordinates(7, 0, 331, 991))) // musical score
        trie.insert(intArrayOf(127925), ParseResult(2, SpriteCoordinates(7, 0, 793, 991))) // musical note
        trie.insert(intArrayOf(127926), ParseResult(2, SpriteCoordinates(7, 0, 727, 991))) // musical notes
        trie.insert(intArrayOf(127897, 65039), ParseResult(3, SpriteCoordinates(7, 0, 1057, 331))) // studio microphone
        trie.insert(intArrayOf(127897), ParseResult(2, SpriteCoordinates(7, 0, 1057, 331))) // studio microphone
        trie.insert(intArrayOf(127898), ParseResult(2, SpriteCoordinates(7, 0, 1057, 265))) // level slider
        trie.insert(intArrayOf(127898, 65039), ParseResult(3, SpriteCoordinates(7, 0, 1057, 265))) // level slider
        trie.insert(intArrayOf(127899, 65039), ParseResult(3, SpriteCoordinates(7, 0, 1057, 199))) // control knobs
        trie.insert(intArrayOf(127899), ParseResult(2, SpriteCoordinates(7, 0, 1057, 199))) // control knobs
        trie.insert(intArrayOf(127908), ParseResult(2, SpriteCoordinates(7, 0, 1057, 67))) // microphone
        trie.insert(intArrayOf(127911), ParseResult(2, SpriteCoordinates(7, 0, 991, 991))) // headphone
        trie.insert(intArrayOf(128251), ParseResult(2, SpriteCoordinates(7, 0, 793, 331))) // radio
        trie.insert(intArrayOf(127927), ParseResult(2, SpriteCoordinates(7, 0, 661, 991))) // saxophone
        trie.insert(intArrayOf(129687), ParseResult(2, SpriteCoordinates(7, 0, 397, 67))) // accordion
        trie.insert(intArrayOf(127928), ParseResult(2, SpriteCoordinates(7, 0, 595, 991))) // guitar
        trie.insert(intArrayOf(127929), ParseResult(2, SpriteCoordinates(7, 0, 529, 991))) // musical keyboard
        trie.insert(intArrayOf(127930), ParseResult(2, SpriteCoordinates(7, 0, 463, 991))) // trumpet
        trie.insert(intArrayOf(127931), ParseResult(2, SpriteCoordinates(7, 0, 397, 991))) // violin
        trie.insert(intArrayOf(129685), ParseResult(2, SpriteCoordinates(7, 0, 397, 199))) // banjo
        trie.insert(intArrayOf(129345), ParseResult(2, SpriteCoordinates(7, 0, 595, 397))) // drum
        trie.insert(intArrayOf(129688), ParseResult(2, SpriteCoordinates(7, 0, 397, 1))) // long drum
        trie.insert(intArrayOf(129671), ParseResult(2, SpriteCoordinates(7, 0, 331, 397))) // maracas
        trie.insert(intArrayOf(129672), ParseResult(2, SpriteCoordinates(7, 0, 265, 397))) // flute
        trie.insert(intArrayOf(129673), ParseResult(2, SpriteCoordinates(7, 0, 199, 397))) // harp
        trie.insert(intArrayOf(128241), ParseResult(2, SpriteCoordinates(7, 0, 793, 727))) // mobile phone
        trie.insert(intArrayOf(128242), ParseResult(2, SpriteCoordinates(7, 0, 793, 661))) // mobile phone with arrow
        trie.insert(intArrayOf(9742, 65039), ParseResult(2, SpriteCoordinates(7, 0, 199, 199))) // telephone
        trie.insert(intArrayOf(9742), ParseResult(1, SpriteCoordinates(7, 0, 199, 199))) // telephone
        trie.insert(intArrayOf(128222), ParseResult(2, SpriteCoordinates(7, 0, 859, 331))) // telephone receiver
        trie.insert(intArrayOf(128223), ParseResult(2, SpriteCoordinates(7, 0, 859, 265))) // pager
        trie.insert(intArrayOf(128224), ParseResult(2, SpriteCoordinates(7, 0, 859, 199))) // fax machine
        trie.insert(intArrayOf(128267), ParseResult(2, SpriteCoordinates(7, 0, 595, 727))) // battery
        trie.insert(intArrayOf(129707), ParseResult(2, SpriteCoordinates(7, 0, 67, 265))) // low battery
        trie.insert(intArrayOf(128268), ParseResult(2, SpriteCoordinates(7, 0, 529, 727))) // electric plug
        trie.insert(intArrayOf(128187), ParseResult(2, SpriteCoordinates(7, 0, 925, 793))) // laptop
        trie.insert(intArrayOf(128421, 65039), ParseResult(3, SpriteCoordinates(7, 0, 331, 661))) // desktop computer
        trie.insert(intArrayOf(128421), ParseResult(2, SpriteCoordinates(7, 0, 331, 661))) // desktop computer
        trie.insert(intArrayOf(128424, 65039), ParseResult(3, SpriteCoordinates(7, 0, 265, 661))) // printer
        trie.insert(intArrayOf(128424), ParseResult(2, SpriteCoordinates(7, 0, 265, 661))) // printer
        trie.insert(intArrayOf(9000, 65039), ParseResult(2, SpriteCoordinates(7, 0, 265, 1))) // keyboard
        trie.insert(intArrayOf(9000), ParseResult(1, SpriteCoordinates(7, 0, 265, 1))) // keyboard
        trie.insert(intArrayOf(128433), ParseResult(2, SpriteCoordinates(7, 0, 199, 661))) // computer mouse
        trie.insert(intArrayOf(128433, 65039), ParseResult(3, SpriteCoordinates(7, 0, 199, 661))) // computer mouse
        trie.insert(intArrayOf(128434, 65039), ParseResult(3, SpriteCoordinates(7, 0, 133, 661))) // trackball
        trie.insert(intArrayOf(128434), ParseResult(2, SpriteCoordinates(7, 0, 133, 661))) // trackball
        trie.insert(intArrayOf(128189), ParseResult(2, SpriteCoordinates(7, 0, 925, 661))) // computer disk
        trie.insert(intArrayOf(128190), ParseResult(2, SpriteCoordinates(7, 0, 925, 595))) // floppy disk
        trie.insert(intArrayOf(128191), ParseResult(2, SpriteCoordinates(7, 0, 925, 529))) // optical disk
        trie.insert(intArrayOf(128192), ParseResult(2, SpriteCoordinates(7, 0, 925, 463))) // dvd
        trie.insert(intArrayOf(129518), ParseResult(2, SpriteCoordinates(7, 0, 529, 463))) // abacus
        trie.insert(intArrayOf(127909), ParseResult(2, SpriteCoordinates(7, 0, 1057, 1))) // movie camera
        trie.insert(intArrayOf(127902), ParseResult(2, SpriteCoordinates(7, 0, 1057, 133))) // film frames
        trie.insert(intArrayOf(127902, 65039), ParseResult(3, SpriteCoordinates(7, 0, 1057, 133))) // film frames
        trie.insert(intArrayOf(128253, 65039), ParseResult(3, SpriteCoordinates(7, 0, 793, 199))) // film projector
        trie.insert(intArrayOf(128253), ParseResult(2, SpriteCoordinates(7, 0, 793, 199))) // film projector
        trie.insert(intArrayOf(127916), ParseResult(2, SpriteCoordinates(7, 0, 859, 991))) // clapper board
        trie.insert(intArrayOf(128250), ParseResult(2, SpriteCoordinates(7, 0, 793, 397))) // television
        trie.insert(intArrayOf(128247), ParseResult(2, SpriteCoordinates(7, 0, 793, 595))) // camera
        trie.insert(intArrayOf(128248), ParseResult(2, SpriteCoordinates(7, 0, 793, 529))) // camera with flash
        trie.insert(intArrayOf(128249), ParseResult(2, SpriteCoordinates(7, 0, 793, 463))) // video camera
        trie.insert(intArrayOf(128252), ParseResult(2, SpriteCoordinates(7, 0, 793, 265))) // videocassette
        trie.insert(intArrayOf(128269), ParseResult(2, SpriteCoordinates(7, 0, 463, 727))) // magnifying glass tilted left
        trie.insert(intArrayOf(128270), ParseResult(2, SpriteCoordinates(7, 0, 397, 727))) // magnifying glass tilted right
        trie.insert(intArrayOf(128367), ParseResult(2, SpriteCoordinates(7, 0, 727, 67))) // candle
        trie.insert(intArrayOf(128367, 65039), ParseResult(3, SpriteCoordinates(7, 0, 727, 67))) // candle
        trie.insert(intArrayOf(128161), ParseResult(2, SpriteCoordinates(7, 0, 529, 925))) // light bulb
        trie.insert(intArrayOf(128294), ParseResult(2, SpriteCoordinates(7, 0, 727, 463))) // flashlight
        trie.insert(intArrayOf(127982), ParseResult(2, SpriteCoordinates(7, 0, 265, 991))) // red paper lantern
        trie.insert(intArrayOf(129684), ParseResult(2, SpriteCoordinates(7, 0, 397, 265))) // diya lamp
        trie.insert(intArrayOf(128212), ParseResult(2, SpriteCoordinates(7, 0, 67, 859))) // notebook with decorative cover
        trie.insert(intArrayOf(128213), ParseResult(2, SpriteCoordinates(7, 0, 1, 859))) // closed book
        trie.insert(intArrayOf(128214), ParseResult(2, SpriteCoordinates(7, 0, 859, 793))) // open book
        trie.insert(intArrayOf(128215), ParseResult(2, SpriteCoordinates(7, 0, 859, 727))) // green book
        trie.insert(intArrayOf(128216), ParseResult(2, SpriteCoordinates(7, 0, 859, 661))) // blue book
        trie.insert(intArrayOf(128217), ParseResult(2, SpriteCoordinates(7, 0, 859, 595))) // orange book
        trie.insert(intArrayOf(128218), ParseResult(2, SpriteCoordinates(7, 0, 859, 529))) // books
        trie.insert(intArrayOf(128211), ParseResult(2, SpriteCoordinates(7, 0, 133, 859))) // notebook
        trie.insert(intArrayOf(128210), ParseResult(2, SpriteCoordinates(7, 0, 199, 859))) // ledger
        trie.insert(intArrayOf(128195), ParseResult(2, SpriteCoordinates(7, 0, 925, 265))) // page with curl
        trie.insert(intArrayOf(128220), ParseResult(2, SpriteCoordinates(7, 0, 859, 463))) // scroll
        trie.insert(intArrayOf(128196), ParseResult(2, SpriteCoordinates(7, 0, 925, 199))) // page facing up
        trie.insert(intArrayOf(128240), ParseResult(2, SpriteCoordinates(7, 0, 1, 793))) // newspaper
        trie.insert(intArrayOf(128478, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 199))) // rolled-up newspaper
        trie.insert(intArrayOf(128478), ParseResult(2, SpriteCoordinates(7, 0, 661, 199))) // rolled-up newspaper
        trie.insert(intArrayOf(128209), ParseResult(2, SpriteCoordinates(7, 0, 265, 859))) // bookmark tabs
        trie.insert(intArrayOf(128278), ParseResult(2, SpriteCoordinates(7, 0, 727, 595))) // bookmark
        trie.insert(intArrayOf(127991, 65039), ParseResult(3, SpriteCoordinates(7, 0, 199, 991))) // label
        trie.insert(intArrayOf(127991), ParseResult(2, SpriteCoordinates(7, 0, 199, 991))) // label
        trie.insert(intArrayOf(128176), ParseResult(2, SpriteCoordinates(7, 0, 397, 925))) // money bag
        trie.insert(intArrayOf(129689), ParseResult(2, SpriteCoordinates(7, 0, 331, 331))) // coin
        trie.insert(intArrayOf(128180), ParseResult(2, SpriteCoordinates(7, 0, 265, 925))) // yen banknote
        trie.insert(intArrayOf(128181), ParseResult(2, SpriteCoordinates(7, 0, 199, 925))) // dollar banknote
        trie.insert(intArrayOf(128182), ParseResult(2, SpriteCoordinates(7, 0, 133, 925))) // euro banknote
        trie.insert(intArrayOf(128183), ParseResult(2, SpriteCoordinates(7, 0, 67, 925))) // pound banknote
        trie.insert(intArrayOf(128184), ParseResult(2, SpriteCoordinates(7, 0, 1, 925))) // money with wings
        trie.insert(intArrayOf(128179), ParseResult(2, SpriteCoordinates(7, 0, 331, 925))) // credit card
        trie.insert(intArrayOf(129534), ParseResult(2, SpriteCoordinates(7, 0, 265, 463))) // receipt
        trie.insert(intArrayOf(128185), ParseResult(2, SpriteCoordinates(7, 0, 925, 859))) // chart increasing with yen
        trie.insert(intArrayOf(9993, 65039), ParseResult(2, SpriteCoordinates(7, 0, 1, 67))) // envelope
        trie.insert(intArrayOf(9993), ParseResult(1, SpriteCoordinates(7, 0, 1, 67))) // envelope
        trie.insert(intArrayOf(128231), ParseResult(2, SpriteCoordinates(7, 0, 595, 793))) // e-mail
        trie.insert(intArrayOf(128232), ParseResult(2, SpriteCoordinates(7, 0, 529, 793))) // incoming envelope
        trie.insert(intArrayOf(128233), ParseResult(2, SpriteCoordinates(7, 0, 463, 793))) // envelope with arrow
        trie.insert(intArrayOf(128228), ParseResult(2, SpriteCoordinates(7, 0, 793, 793))) // outbox tray
        trie.insert(intArrayOf(128229), ParseResult(2, SpriteCoordinates(7, 0, 727, 793))) // inbox tray
        trie.insert(intArrayOf(128230), ParseResult(2, SpriteCoordinates(7, 0, 661, 793))) // package
        trie.insert(intArrayOf(128235), ParseResult(2, SpriteCoordinates(7, 0, 331, 793))) // closed mailbox with raised flag
        trie.insert(intArrayOf(128234), ParseResult(2, SpriteCoordinates(7, 0, 397, 793))) // closed mailbox with lowered flag
        trie.insert(intArrayOf(128236), ParseResult(2, SpriteCoordinates(7, 0, 265, 793))) // open mailbox with raised flag
        trie.insert(intArrayOf(128237), ParseResult(2, SpriteCoordinates(7, 0, 199, 793))) // open mailbox with lowered flag
        trie.insert(intArrayOf(128238), ParseResult(2, SpriteCoordinates(7, 0, 133, 793))) // postbox
        trie.insert(intArrayOf(128499), ParseResult(2, SpriteCoordinates(7, 0, 661, 67))) // ballot box with ballot
        trie.insert(intArrayOf(128499, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 67))) // ballot box with ballot
        trie.insert(intArrayOf(9999, 65039), ParseResult(2, SpriteCoordinates(7, 0, 67, 1))) // pencil
        trie.insert(intArrayOf(9999), ParseResult(1, SpriteCoordinates(7, 0, 67, 1))) // pencil
        trie.insert(intArrayOf(10002), ParseResult(1, SpriteCoordinates(7, 0, 1, 1))) // black nib
        trie.insert(intArrayOf(10002, 65039), ParseResult(2, SpriteCoordinates(7, 0, 1, 1))) // black nib
        trie.insert(intArrayOf(128395, 65039), ParseResult(3, SpriteCoordinates(7, 0, 529, 661))) // fountain pen
        trie.insert(intArrayOf(128395), ParseResult(2, SpriteCoordinates(7, 0, 529, 661))) // fountain pen
        trie.insert(intArrayOf(128394), ParseResult(2, SpriteCoordinates(7, 0, 595, 661))) // pen
        trie.insert(intArrayOf(128394, 65039), ParseResult(3, SpriteCoordinates(7, 0, 595, 661))) // pen
        trie.insert(intArrayOf(128396), ParseResult(2, SpriteCoordinates(7, 0, 463, 661))) // paintbrush
        trie.insert(intArrayOf(128396, 65039), ParseResult(3, SpriteCoordinates(7, 0, 463, 661))) // paintbrush
        trie.insert(intArrayOf(128397), ParseResult(2, SpriteCoordinates(7, 0, 397, 661))) // crayon
        trie.insert(intArrayOf(128397, 65039), ParseResult(3, SpriteCoordinates(7, 0, 397, 661))) // crayon
        trie.insert(intArrayOf(128221), ParseResult(2, SpriteCoordinates(7, 0, 859, 397))) // memo
        trie.insert(intArrayOf(128188), ParseResult(2, SpriteCoordinates(7, 0, 925, 727))) // briefcase
        trie.insert(intArrayOf(128193), ParseResult(2, SpriteCoordinates(7, 0, 925, 397))) // file folder
        trie.insert(intArrayOf(128194), ParseResult(2, SpriteCoordinates(7, 0, 925, 331))) // open file folder
        trie.insert(intArrayOf(128450), ParseResult(2, SpriteCoordinates(7, 0, 67, 661))) // card index dividers
        trie.insert(intArrayOf(128450, 65039), ParseResult(3, SpriteCoordinates(7, 0, 67, 661))) // card index dividers
        trie.insert(intArrayOf(128197), ParseResult(2, SpriteCoordinates(7, 0, 925, 133))) // calendar
        trie.insert(intArrayOf(128198), ParseResult(2, SpriteCoordinates(7, 0, 925, 67))) // tear-off calendar
        trie.insert(intArrayOf(128466), ParseResult(2, SpriteCoordinates(7, 0, 661, 463))) // spiral notepad
        trie.insert(intArrayOf(128466, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 463))) // spiral notepad
        trie.insert(intArrayOf(128467, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 397))) // spiral calendar
        trie.insert(intArrayOf(128467), ParseResult(2, SpriteCoordinates(7, 0, 661, 397))) // spiral calendar
        trie.insert(intArrayOf(128199), ParseResult(2, SpriteCoordinates(7, 0, 925, 1))) // card index
        trie.insert(intArrayOf(128200), ParseResult(2, SpriteCoordinates(7, 0, 859, 859))) // chart increasing
        trie.insert(intArrayOf(128201), ParseResult(2, SpriteCoordinates(7, 0, 793, 859))) // chart decreasing
        trie.insert(intArrayOf(128202), ParseResult(2, SpriteCoordinates(7, 0, 727, 859))) // bar chart
        trie.insert(intArrayOf(128203), ParseResult(2, SpriteCoordinates(7, 0, 661, 859))) // clipboard
        trie.insert(intArrayOf(128204), ParseResult(2, SpriteCoordinates(7, 0, 595, 859))) // pushpin
        trie.insert(intArrayOf(128205), ParseResult(2, SpriteCoordinates(7, 0, 529, 859))) // round pushpin
        trie.insert(intArrayOf(128206), ParseResult(2, SpriteCoordinates(7, 0, 463, 859))) // paperclip
        trie.insert(intArrayOf(128391, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 661))) // linked paperclips
        trie.insert(intArrayOf(128391), ParseResult(2, SpriteCoordinates(7, 0, 661, 661))) // linked paperclips
        trie.insert(intArrayOf(128207), ParseResult(2, SpriteCoordinates(7, 0, 397, 859))) // straight ruler
        trie.insert(intArrayOf(128208), ParseResult(2, SpriteCoordinates(7, 0, 331, 859))) // triangular ruler
        trie.insert(intArrayOf(9986, 65039), ParseResult(2, SpriteCoordinates(7, 0, 67, 67))) // scissors
        trie.insert(intArrayOf(9986), ParseResult(1, SpriteCoordinates(7, 0, 67, 67))) // scissors
        trie.insert(intArrayOf(128451), ParseResult(2, SpriteCoordinates(7, 0, 1, 661))) // card file box
        trie.insert(intArrayOf(128451, 65039), ParseResult(3, SpriteCoordinates(7, 0, 1, 661))) // card file box
        trie.insert(intArrayOf(128452, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 595))) // file cabinet
        trie.insert(intArrayOf(128452), ParseResult(2, SpriteCoordinates(7, 0, 661, 595))) // file cabinet
        trie.insert(intArrayOf(128465), ParseResult(2, SpriteCoordinates(7, 0, 661, 529))) // wastebasket
        trie.insert(intArrayOf(128465, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 529))) // wastebasket
        trie.insert(intArrayOf(128274), ParseResult(2, SpriteCoordinates(7, 0, 133, 727))) // locked
        trie.insert(intArrayOf(128275), ParseResult(2, SpriteCoordinates(7, 0, 67, 727))) // unlocked
        trie.insert(intArrayOf(128271), ParseResult(2, SpriteCoordinates(7, 0, 331, 727))) // locked with pen
        trie.insert(intArrayOf(128272), ParseResult(2, SpriteCoordinates(7, 0, 265, 727))) // locked with key
        trie.insert(intArrayOf(128273), ParseResult(2, SpriteCoordinates(7, 0, 199, 727))) // key
        trie.insert(intArrayOf(128477), ParseResult(2, SpriteCoordinates(7, 0, 661, 265))) // old key
        trie.insert(intArrayOf(128477, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 265))) // old key
        trie.insert(intArrayOf(128296), ParseResult(2, SpriteCoordinates(7, 0, 727, 331))) // hammer
        trie.insert(intArrayOf(129683), ParseResult(2, SpriteCoordinates(7, 0, 397, 331))) // axe
        trie.insert(intArrayOf(9935), ParseResult(1, SpriteCoordinates(7, 0, 67, 133))) // pick
        trie.insert(intArrayOf(9935, 65039), ParseResult(2, SpriteCoordinates(7, 0, 67, 133))) // pick
        trie.insert(intArrayOf(9874), ParseResult(1, SpriteCoordinates(7, 0, 133, 199))) // hammer and pick
        trie.insert(intArrayOf(9874, 65039), ParseResult(2, SpriteCoordinates(7, 0, 133, 199))) // hammer and pick
        trie.insert(intArrayOf(128736, 65039), ParseResult(3, SpriteCoordinates(7, 0, 595, 529))) // hammer and wrench
        trie.insert(intArrayOf(128736), ParseResult(2, SpriteCoordinates(7, 0, 595, 529))) // hammer and wrench
        trie.insert(intArrayOf(128481), ParseResult(2, SpriteCoordinates(7, 0, 661, 133))) // dagger
        trie.insert(intArrayOf(128481, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 133))) // dagger
        trie.insert(intArrayOf(9876), ParseResult(1, SpriteCoordinates(7, 0, 67, 199))) // crossed swords
        trie.insert(intArrayOf(9876, 65039), ParseResult(2, SpriteCoordinates(7, 0, 67, 199))) // crossed swords
        trie.insert(intArrayOf(128163), ParseResult(2, SpriteCoordinates(7, 0, 463, 925))) // bomb
        trie.insert(intArrayOf(129667), ParseResult(2, SpriteCoordinates(7, 0, 397, 397))) // boomerang
        trie.insert(intArrayOf(127993), ParseResult(2, SpriteCoordinates(7, 0, 133, 991))) // bow and arrow
        trie.insert(intArrayOf(128737, 65039), ParseResult(3, SpriteCoordinates(7, 0, 595, 463))) // shield
        trie.insert(intArrayOf(128737), ParseResult(2, SpriteCoordinates(7, 0, 595, 463))) // shield
        trie.insert(intArrayOf(129690), ParseResult(2, SpriteCoordinates(7, 0, 265, 331))) // carpentry saw
        trie.insert(intArrayOf(128295), ParseResult(2, SpriteCoordinates(7, 0, 727, 397))) // wrench
        trie.insert(intArrayOf(129691), ParseResult(2, SpriteCoordinates(7, 0, 199, 331))) // screwdriver
        trie.insert(intArrayOf(128297), ParseResult(2, SpriteCoordinates(7, 0, 727, 265))) // nut and bolt
        trie.insert(intArrayOf(9881, 65039), ParseResult(2, SpriteCoordinates(7, 0, 199, 67))) // gear
        trie.insert(intArrayOf(9881), ParseResult(1, SpriteCoordinates(7, 0, 199, 67))) // gear
        trie.insert(intArrayOf(128476, 65039), ParseResult(3, SpriteCoordinates(7, 0, 661, 331))) // clamp
        trie.insert(intArrayOf(128476), ParseResult(2, SpriteCoordinates(7, 0, 661, 331))) // clamp
        trie.insert(intArrayOf(9878), ParseResult(1, SpriteCoordinates(7, 0, 1, 199))) // balance scale
        trie.insert(intArrayOf(9878, 65039), ParseResult(2, SpriteCoordinates(7, 0, 1, 199))) // balance scale
        trie.insert(intArrayOf(129455), ParseResult(2, SpriteCoordinates(7, 0, 595, 1))) // white cane
        trie.insert(intArrayOf(128279), ParseResult(2, SpriteCoordinates(7, 0, 727, 529))) // link
        trie.insert(intArrayOf(9939, 65039, 8205, 128165), ParseResult(5, SpriteCoordinates(7, 0, 133, 67))) // broken chain
        trie.insert(intArrayOf(9939, 8205, 128165), ParseResult(4, SpriteCoordinates(7, 0, 133, 67))) // broken chain
        trie.insert(intArrayOf(9939, 65039), ParseResult(2, SpriteCoordinates(7, 0, 133, 1))) // chains
        trie.insert(intArrayOf(9939), ParseResult(1, SpriteCoordinates(7, 0, 133, 1))) // chains
        trie.insert(intArrayOf(129693), ParseResult(2, SpriteCoordinates(7, 0, 67, 331))) // hook
        trie.insert(intArrayOf(129520), ParseResult(2, SpriteCoordinates(7, 0, 529, 331))) // toolbox
        trie.insert(intArrayOf(129522), ParseResult(2, SpriteCoordinates(7, 0, 529, 265))) // magnet
        trie.insert(intArrayOf(129692), ParseResult(2, SpriteCoordinates(7, 0, 133, 331))) // ladder
        trie.insert(intArrayOf(129679), ParseResult(2, SpriteCoordinates(7, 0, 133, 397))) // shovel
        trie.insert(intArrayOf(9879, 65039), ParseResult(2, SpriteCoordinates(7, 0, 199, 133))) // alembic
        trie.insert(intArrayOf(9879), ParseResult(1, SpriteCoordinates(7, 0, 199, 133))) // alembic
        trie.insert(intArrayOf(129514), ParseResult(2, SpriteCoordinates(7, 0, 133, 529))) // test tube
        trie.insert(intArrayOf(129515), ParseResult(2, SpriteCoordinates(7, 0, 67, 529))) // petri dish
        trie.insert(intArrayOf(129516), ParseResult(2, SpriteCoordinates(7, 0, 1, 529))) // dna
        trie.insert(intArrayOf(128300), ParseResult(2, SpriteCoordinates(7, 0, 727, 199))) // microscope
        trie.insert(intArrayOf(128301), ParseResult(2, SpriteCoordinates(7, 0, 727, 133))) // telescope
        trie.insert(intArrayOf(128225), ParseResult(2, SpriteCoordinates(7, 0, 859, 133))) // satellite antenna
        trie.insert(intArrayOf(128137), ParseResult(2, SpriteCoordinates(7, 0, 793, 925))) // syringe
        trie.insert(intArrayOf(129656), ParseResult(2, SpriteCoordinates(7, 0, 463, 265))) // drop of blood
        trie.insert(intArrayOf(128138), ParseResult(2, SpriteCoordinates(7, 0, 727, 925))) // pill
        trie.insert(intArrayOf(129657), ParseResult(2, SpriteCoordinates(7, 0, 463, 199))) // adhesive bandage
        trie.insert(intArrayOf(129660), ParseResult(2, SpriteCoordinates(7, 0, 463, 1))) // crutch
        trie.insert(intArrayOf(129658), ParseResult(2, SpriteCoordinates(7, 0, 463, 133))) // stethoscope
        trie.insert(intArrayOf(129659), ParseResult(2, SpriteCoordinates(7, 0, 463, 67))) // x-ray
        trie.insert(intArrayOf(128682), ParseResult(2, SpriteCoordinates(7, 0, 595, 595))) // door
        trie.insert(intArrayOf(128727), ParseResult(2, SpriteCoordinates(7, 0, 1, 595))) // elevator
        trie.insert(intArrayOf(129694), ParseResult(2, SpriteCoordinates(7, 0, 1, 331))) // mirror
        trie.insert(intArrayOf(129695), ParseResult(2, SpriteCoordinates(7, 0, 331, 265))) // window
        trie.insert(intArrayOf(128719, 65039), ParseResult(3, SpriteCoordinates(7, 0, 133, 595))) // bed
        trie.insert(intArrayOf(128719), ParseResult(2, SpriteCoordinates(7, 0, 133, 595))) // bed
        trie.insert(intArrayOf(128715, 65039), ParseResult(3, SpriteCoordinates(7, 0, 265, 595))) // couch and lamp
        trie.insert(intArrayOf(128715), ParseResult(2, SpriteCoordinates(7, 0, 265, 595))) // couch and lamp
        trie.insert(intArrayOf(129681), ParseResult(2, SpriteCoordinates(7, 0, 67, 397))) // chair
        trie.insert(intArrayOf(128701), ParseResult(2, SpriteCoordinates(7, 0, 463, 595))) // toilet
        trie.insert(intArrayOf(129696), ParseResult(2, SpriteCoordinates(7, 0, 331, 199))) // plunger
        trie.insert(intArrayOf(128703), ParseResult(2, SpriteCoordinates(7, 0, 397, 595))) // shower
        trie.insert(intArrayOf(128705), ParseResult(2, SpriteCoordinates(7, 0, 331, 595))) // bathtub
        trie.insert(intArrayOf(129700), ParseResult(2, SpriteCoordinates(7, 0, 331, 67))) // mouse trap
        trie.insert(intArrayOf(129682), ParseResult(2, SpriteCoordinates(7, 0, 1, 397))) // razor
        trie.insert(intArrayOf(129524), ParseResult(2, SpriteCoordinates(7, 0, 529, 199))) // lotion bottle
        trie.insert(intArrayOf(129527), ParseResult(2, SpriteCoordinates(7, 0, 529, 133))) // safety pin
        trie.insert(intArrayOf(129529), ParseResult(2, SpriteCoordinates(7, 0, 529, 67))) // broom
        trie.insert(intArrayOf(129530), ParseResult(2, SpriteCoordinates(7, 0, 529, 1))) // basket
        trie.insert(intArrayOf(129531), ParseResult(2, SpriteCoordinates(7, 0, 463, 463))) // roll of paper
        trie.insert(intArrayOf(129699), ParseResult(2, SpriteCoordinates(7, 0, 331, 133))) // bucket
        trie.insert(intArrayOf(129532), ParseResult(2, SpriteCoordinates(7, 0, 397, 463))) // soap
        trie.insert(intArrayOf(129767), ParseResult(2, SpriteCoordinates(7, 0, 265, 67))) // bubbles
        trie.insert(intArrayOf(129701), ParseResult(2, SpriteCoordinates(7, 0, 331, 1))) // toothbrush
        trie.insert(intArrayOf(129533), ParseResult(2, SpriteCoordinates(7, 0, 331, 463))) // sponge
        trie.insert(intArrayOf(129519), ParseResult(2, SpriteCoordinates(7, 0, 529, 397))) // fire extinguisher
        trie.insert(intArrayOf(128722), ParseResult(2, SpriteCoordinates(7, 0, 67, 595))) // shopping cart
        trie.insert(intArrayOf(128684), ParseResult(2, SpriteCoordinates(7, 0, 529, 595))) // cigarette
        trie.insert(intArrayOf(9904), ParseResult(1, SpriteCoordinates(7, 0, 199, 1))) // coffin
        trie.insert(intArrayOf(9904, 65039), ParseResult(2, SpriteCoordinates(7, 0, 199, 1))) // coffin
        trie.insert(intArrayOf(129702), ParseResult(2, SpriteCoordinates(7, 0, 265, 265))) // headstone
        trie.insert(intArrayOf(9905, 65039), ParseResult(2, SpriteCoordinates(7, 0, 133, 133))) // funeral urn
        trie.insert(intArrayOf(9905), ParseResult(1, SpriteCoordinates(7, 0, 133, 133))) // funeral urn
        trie.insert(intArrayOf(129535), ParseResult(2, SpriteCoordinates(7, 0, 199, 463))) // nazar amulet
        trie.insert(intArrayOf(129708), ParseResult(2, SpriteCoordinates(7, 0, 1, 265))) // hamsa
        trie.insert(intArrayOf(128511), ParseResult(2, SpriteCoordinates(7, 0, 661, 1))) // moai
        trie.insert(intArrayOf(129703), ParseResult(2, SpriteCoordinates(7, 0, 199, 265))) // placard
        trie.insert(intArrayOf(129706), ParseResult(2, SpriteCoordinates(7, 0, 133, 265))) // identification card
        trie.insert(intArrayOf(127975), ParseResult(2, SpriteCoordinates(8, 0, 859, 595))) // ATM sign
        trie.insert(intArrayOf(128686), ParseResult(2, SpriteCoordinates(8, 0, 727, 595))) // litter in bin sign
        trie.insert(intArrayOf(128688), ParseResult(2, SpriteCoordinates(8, 0, 727, 463))) // potable water
        trie.insert(intArrayOf(9855), ParseResult(1, SpriteCoordinates(8, 0, 397, 331))) // wheelchair symbol
        trie.insert(intArrayOf(128697), ParseResult(2, SpriteCoordinates(8, 0, 727, 133))) // men’s room
        trie.insert(intArrayOf(128698), ParseResult(2, SpriteCoordinates(8, 0, 727, 67))) // women’s room
        trie.insert(intArrayOf(128699), ParseResult(2, SpriteCoordinates(8, 0, 727, 1))) // restroom
        trie.insert(intArrayOf(128700), ParseResult(2, SpriteCoordinates(8, 0, 661, 661))) // baby symbol
        trie.insert(intArrayOf(128702), ParseResult(2, SpriteCoordinates(8, 0, 595, 661))) // water closet
        trie.insert(intArrayOf(128706), ParseResult(2, SpriteCoordinates(8, 0, 529, 661))) // passport control
        trie.insert(intArrayOf(128707), ParseResult(2, SpriteCoordinates(8, 0, 463, 661))) // customs
        trie.insert(intArrayOf(128708), ParseResult(2, SpriteCoordinates(8, 0, 397, 661))) // baggage claim
        trie.insert(intArrayOf(128709), ParseResult(2, SpriteCoordinates(8, 0, 331, 661))) // left luggage
    }

    private fun init12(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(9888, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 67))) // warning
        trie.insert(intArrayOf(9888), ParseResult(1, SpriteCoordinates(8, 0, 397, 67))) // warning
        trie.insert(intArrayOf(128696), ParseResult(2, SpriteCoordinates(8, 0, 727, 199))) // children crossing
        trie.insert(intArrayOf(9940), ParseResult(1, SpriteCoordinates(8, 0, 133, 331))) // no entry
        trie.insert(intArrayOf(128683), ParseResult(2, SpriteCoordinates(8, 0, 1, 727))) // prohibited
        trie.insert(intArrayOf(128691), ParseResult(2, SpriteCoordinates(8, 0, 727, 331))) // no bicycles
        trie.insert(intArrayOf(128685), ParseResult(2, SpriteCoordinates(8, 0, 727, 661))) // no smoking
        trie.insert(intArrayOf(128687), ParseResult(2, SpriteCoordinates(8, 0, 727, 529))) // no littering
        trie.insert(intArrayOf(128689), ParseResult(2, SpriteCoordinates(8, 0, 727, 397))) // non-potable water
        trie.insert(intArrayOf(128695), ParseResult(2, SpriteCoordinates(8, 0, 727, 265))) // no pedestrians
        trie.insert(intArrayOf(128245), ParseResult(2, SpriteCoordinates(8, 0, 859, 133))) // no mobile phones
        trie.insert(intArrayOf(128286), ParseResult(2, SpriteCoordinates(8, 0, 1, 793))) // no one under eighteen
        trie.insert(intArrayOf(9762, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 1))) // radioactive
        trie.insert(intArrayOf(9762), ParseResult(1, SpriteCoordinates(8, 0, 529, 1))) // radioactive
        trie.insert(intArrayOf(9763, 65039), ParseResult(2, SpriteCoordinates(8, 0, 463, 463))) // biohazard
        trie.insert(intArrayOf(9763), ParseResult(1, SpriteCoordinates(8, 0, 463, 463))) // biohazard
        trie.insert(intArrayOf(11014, 65039), ParseResult(2, SpriteCoordinates(8, 0, 133, 133))) // up arrow
        trie.insert(intArrayOf(11014), ParseResult(1, SpriteCoordinates(8, 0, 133, 133))) // up arrow
        trie.insert(intArrayOf(8599, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 595))) // up-right arrow
        trie.insert(intArrayOf(8599), ParseResult(1, SpriteCoordinates(8, 0, 1, 595))) // up-right arrow
        trie.insert(intArrayOf(10145), ParseResult(1, SpriteCoordinates(8, 0, 133, 199))) // right arrow
        trie.insert(intArrayOf(10145, 65039), ParseResult(2, SpriteCoordinates(8, 0, 133, 199))) // right arrow
        trie.insert(intArrayOf(8600), ParseResult(1, SpriteCoordinates(8, 0, 595, 529))) // down-right arrow
        trie.insert(intArrayOf(8600, 65039), ParseResult(2, SpriteCoordinates(8, 0, 595, 529))) // down-right arrow
        trie.insert(intArrayOf(11015, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 133))) // down arrow
        trie.insert(intArrayOf(11015), ParseResult(1, SpriteCoordinates(8, 0, 67, 133))) // down arrow
        trie.insert(intArrayOf(8601, 65039), ParseResult(2, SpriteCoordinates(8, 0, 595, 463))) // down-left arrow
        trie.insert(intArrayOf(8601), ParseResult(1, SpriteCoordinates(8, 0, 595, 463))) // down-left arrow
        trie.insert(intArrayOf(11013), ParseResult(1, SpriteCoordinates(8, 0, 199, 1))) // left arrow
        trie.insert(intArrayOf(11013, 65039), ParseResult(2, SpriteCoordinates(8, 0, 199, 1))) // left arrow
        trie.insert(intArrayOf(8598, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 595))) // up-left arrow
        trie.insert(intArrayOf(8598), ParseResult(1, SpriteCoordinates(8, 0, 67, 595))) // up-left arrow
        trie.insert(intArrayOf(8597), ParseResult(1, SpriteCoordinates(8, 0, 133, 595))) // up-down arrow
        trie.insert(intArrayOf(8597, 65039), ParseResult(2, SpriteCoordinates(8, 0, 133, 595))) // up-down arrow
        trie.insert(intArrayOf(8596), ParseResult(1, SpriteCoordinates(8, 0, 199, 595))) // left-right arrow
        trie.insert(intArrayOf(8596, 65039), ParseResult(2, SpriteCoordinates(8, 0, 199, 595))) // left-right arrow
        trie.insert(intArrayOf(8617), ParseResult(1, SpriteCoordinates(8, 0, 595, 397))) // right arrow curving left
        trie.insert(intArrayOf(8617, 65039), ParseResult(2, SpriteCoordinates(8, 0, 595, 397))) // right arrow curving left
        trie.insert(intArrayOf(8618), ParseResult(1, SpriteCoordinates(8, 0, 595, 331))) // left arrow curving right
        trie.insert(intArrayOf(8618, 65039), ParseResult(2, SpriteCoordinates(8, 0, 595, 331))) // left arrow curving right
        trie.insert(intArrayOf(10548), ParseResult(1, SpriteCoordinates(8, 0, 199, 133))) // right arrow curving up
        trie.insert(intArrayOf(10548, 65039), ParseResult(2, SpriteCoordinates(8, 0, 199, 133))) // right arrow curving up
        trie.insert(intArrayOf(10549), ParseResult(1, SpriteCoordinates(8, 0, 199, 67))) // right arrow curving down
        trie.insert(intArrayOf(10549, 65039), ParseResult(2, SpriteCoordinates(8, 0, 199, 67))) // right arrow curving down
        trie.insert(intArrayOf(128259), ParseResult(2, SpriteCoordinates(8, 0, 661, 793))) // clockwise vertical arrows
        trie.insert(intArrayOf(128260), ParseResult(2, SpriteCoordinates(8, 0, 595, 793))) // counterclockwise arrows button
        trie.insert(intArrayOf(128281), ParseResult(2, SpriteCoordinates(8, 0, 331, 793))) // BACK arrow
        trie.insert(intArrayOf(128282), ParseResult(2, SpriteCoordinates(8, 0, 265, 793))) // END arrow
        trie.insert(intArrayOf(128283), ParseResult(2, SpriteCoordinates(8, 0, 199, 793))) // ON! arrow
        trie.insert(intArrayOf(128284), ParseResult(2, SpriteCoordinates(8, 0, 133, 793))) // SOON arrow
        trie.insert(intArrayOf(128285), ParseResult(2, SpriteCoordinates(8, 0, 67, 793))) // TOP arrow
        trie.insert(intArrayOf(128720), ParseResult(2, SpriteCoordinates(8, 0, 265, 661))) // place of worship
        trie.insert(intArrayOf(9883), ParseResult(1, SpriteCoordinates(8, 0, 397, 199))) // atom symbol
        trie.insert(intArrayOf(9883, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 199))) // atom symbol
        trie.insert(intArrayOf(128329, 65039), ParseResult(3, SpriteCoordinates(8, 0, 133, 727))) // om
        trie.insert(intArrayOf(128329), ParseResult(2, SpriteCoordinates(8, 0, 133, 727))) // om
        trie.insert(intArrayOf(10017), ParseResult(1, SpriteCoordinates(8, 0, 331, 133))) // star of David
        trie.insert(intArrayOf(10017, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 133))) // star of David
        trie.insert(intArrayOf(9784), ParseResult(1, SpriteCoordinates(8, 0, 133, 463))) // wheel of dharma
        trie.insert(intArrayOf(9784, 65039), ParseResult(2, SpriteCoordinates(8, 0, 133, 463))) // wheel of dharma
        trie.insert(intArrayOf(9775), ParseResult(1, SpriteCoordinates(8, 0, 199, 463))) // yin yang
        trie.insert(intArrayOf(9775, 65039), ParseResult(2, SpriteCoordinates(8, 0, 199, 463))) // yin yang
        trie.insert(intArrayOf(10013), ParseResult(1, SpriteCoordinates(8, 0, 331, 199))) // latin cross
        trie.insert(intArrayOf(10013, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 199))) // latin cross
        trie.insert(intArrayOf(9766), ParseResult(1, SpriteCoordinates(8, 0, 397, 463))) // orthodox cross
        trie.insert(intArrayOf(9766, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 463))) // orthodox cross
        trie.insert(intArrayOf(9770, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 463))) // star and crescent
        trie.insert(intArrayOf(9770), ParseResult(1, SpriteCoordinates(8, 0, 331, 463))) // star and crescent
        trie.insert(intArrayOf(9774), ParseResult(1, SpriteCoordinates(8, 0, 265, 463))) // peace symbol
        trie.insert(intArrayOf(9774, 65039), ParseResult(2, SpriteCoordinates(8, 0, 265, 463))) // peace symbol
        trie.insert(intArrayOf(128334), ParseResult(2, SpriteCoordinates(8, 0, 67, 727))) // menorah
        trie.insert(intArrayOf(128303), ParseResult(2, SpriteCoordinates(8, 0, 793, 331))) // dotted six-pointed star
        trie.insert(intArrayOf(129711), ParseResult(2, SpriteCoordinates(8, 0, 595, 595))) // khanda
        trie.insert(intArrayOf(9800), ParseResult(1, SpriteCoordinates(8, 0, 463, 397))) // Aries
        trie.insert(intArrayOf(9801), ParseResult(1, SpriteCoordinates(8, 0, 463, 331))) // Taurus
        trie.insert(intArrayOf(9802), ParseResult(1, SpriteCoordinates(8, 0, 463, 265))) // Gemini
        trie.insert(intArrayOf(9803), ParseResult(1, SpriteCoordinates(8, 0, 463, 199))) // Cancer
        trie.insert(intArrayOf(9804), ParseResult(1, SpriteCoordinates(8, 0, 463, 133))) // Leo
        trie.insert(intArrayOf(9805), ParseResult(1, SpriteCoordinates(8, 0, 463, 67))) // Virgo
        trie.insert(intArrayOf(9806), ParseResult(1, SpriteCoordinates(8, 0, 463, 1))) // Libra
        trie.insert(intArrayOf(9807), ParseResult(1, SpriteCoordinates(8, 0, 397, 397))) // Scorpio
        trie.insert(intArrayOf(9808), ParseResult(1, SpriteCoordinates(8, 0, 331, 397))) // Sagittarius
        trie.insert(intArrayOf(9809), ParseResult(1, SpriteCoordinates(8, 0, 265, 397))) // Capricorn
        trie.insert(intArrayOf(9810), ParseResult(1, SpriteCoordinates(8, 0, 199, 397))) // Aquarius
        trie.insert(intArrayOf(9811), ParseResult(1, SpriteCoordinates(8, 0, 133, 397))) // Pisces
        trie.insert(intArrayOf(9934), ParseResult(1, SpriteCoordinates(8, 0, 199, 331))) // Ophiuchus
        trie.insert(intArrayOf(128256), ParseResult(2, SpriteCoordinates(8, 0, 859, 1))) // shuffle tracks button
        trie.insert(intArrayOf(128257), ParseResult(2, SpriteCoordinates(8, 0, 793, 793))) // repeat button
        trie.insert(intArrayOf(128258), ParseResult(2, SpriteCoordinates(8, 0, 727, 793))) // repeat single button
        trie.insert(intArrayOf(9654, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 463))) // play button
        trie.insert(intArrayOf(9654), ParseResult(1, SpriteCoordinates(8, 0, 529, 463))) // play button
        trie.insert(intArrayOf(9193), ParseResult(1, SpriteCoordinates(8, 0, 595, 199))) // fast-forward button
        trie.insert(intArrayOf(9197), ParseResult(1, SpriteCoordinates(8, 0, 529, 529))) // next track button
        trie.insert(intArrayOf(9197, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 529))) // next track button
        trie.insert(intArrayOf(9199, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 529))) // play or pause button
        trie.insert(intArrayOf(9199), ParseResult(1, SpriteCoordinates(8, 0, 397, 529))) // play or pause button
        trie.insert(intArrayOf(9664, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 397))) // reverse button
        trie.insert(intArrayOf(9664), ParseResult(1, SpriteCoordinates(8, 0, 529, 397))) // reverse button
        trie.insert(intArrayOf(9194), ParseResult(1, SpriteCoordinates(8, 0, 595, 133))) // fast reverse button
        trie.insert(intArrayOf(9198, 65039), ParseResult(2, SpriteCoordinates(8, 0, 463, 529))) // last track button
        trie.insert(intArrayOf(9198), ParseResult(1, SpriteCoordinates(8, 0, 463, 529))) // last track button
        trie.insert(intArrayOf(128316), ParseResult(2, SpriteCoordinates(8, 0, 265, 727))) // upwards button
        trie.insert(intArrayOf(9195), ParseResult(1, SpriteCoordinates(8, 0, 595, 67))) // fast up button
        trie.insert(intArrayOf(128317), ParseResult(2, SpriteCoordinates(8, 0, 199, 727))) // downwards button
        trie.insert(intArrayOf(9196), ParseResult(1, SpriteCoordinates(8, 0, 595, 1))) // fast down button
        trie.insert(intArrayOf(9208), ParseResult(1, SpriteCoordinates(8, 0, 331, 529))) // pause button
        trie.insert(intArrayOf(9208, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 529))) // pause button
        trie.insert(intArrayOf(9209, 65039), ParseResult(2, SpriteCoordinates(8, 0, 265, 529))) // stop button
        trie.insert(intArrayOf(9209), ParseResult(1, SpriteCoordinates(8, 0, 265, 529))) // stop button
        trie.insert(intArrayOf(9210, 65039), ParseResult(2, SpriteCoordinates(8, 0, 199, 529))) // record button
        trie.insert(intArrayOf(9210), ParseResult(1, SpriteCoordinates(8, 0, 199, 529))) // record button
        trie.insert(intArrayOf(9167), ParseResult(1, SpriteCoordinates(8, 0, 595, 265))) // eject button
        trie.insert(intArrayOf(9167, 65039), ParseResult(2, SpriteCoordinates(8, 0, 595, 265))) // eject button
        trie.insert(intArrayOf(127910), ParseResult(2, SpriteCoordinates(8, 0, 859, 661))) // cinema
        trie.insert(intArrayOf(128261), ParseResult(2, SpriteCoordinates(8, 0, 529, 793))) // dim button
        trie.insert(intArrayOf(128262), ParseResult(2, SpriteCoordinates(8, 0, 463, 793))) // bright button
        trie.insert(intArrayOf(128246), ParseResult(2, SpriteCoordinates(8, 0, 859, 67))) // antenna bars
        trie.insert(intArrayOf(128732), ParseResult(2, SpriteCoordinates(8, 0, 199, 661))) // wireless
        trie.insert(intArrayOf(128243), ParseResult(2, SpriteCoordinates(8, 0, 859, 265))) // vibration mode
        trie.insert(intArrayOf(128244), ParseResult(2, SpriteCoordinates(8, 0, 859, 199))) // mobile phone off
        trie.insert(intArrayOf(9792, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 463))) // female sign
        trie.insert(intArrayOf(9792), ParseResult(1, SpriteCoordinates(8, 0, 67, 463))) // female sign
        trie.insert(intArrayOf(9794, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 463))) // male sign
        trie.insert(intArrayOf(9794), ParseResult(1, SpriteCoordinates(8, 0, 1, 463))) // male sign
        trie.insert(intArrayOf(9895), ParseResult(1, SpriteCoordinates(8, 0, 397, 1))) // transgender symbol
        trie.insert(intArrayOf(9895, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 1))) // transgender symbol
        trie.insert(intArrayOf(10006, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 265))) // multiply
        trie.insert(intArrayOf(10006), ParseResult(1, SpriteCoordinates(8, 0, 331, 265))) // multiply
        trie.insert(intArrayOf(10133), ParseResult(1, SpriteCoordinates(8, 0, 265, 67))) // plus
        trie.insert(intArrayOf(10134), ParseResult(1, SpriteCoordinates(8, 0, 265, 1))) // minus
        trie.insert(intArrayOf(10135), ParseResult(1, SpriteCoordinates(8, 0, 199, 199))) // divide
        trie.insert(intArrayOf(129008), ParseResult(2, SpriteCoordinates(8, 0, 661, 1))) // heavy equals sign
        trie.insert(intArrayOf(9854, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 397))) // infinity
        trie.insert(intArrayOf(9854), ParseResult(1, SpriteCoordinates(8, 0, 1, 397))) // infinity
        trie.insert(intArrayOf(8252), ParseResult(1, SpriteCoordinates(8, 0, 463, 595))) // double exclamation mark
        trie.insert(intArrayOf(8252, 65039), ParseResult(2, SpriteCoordinates(8, 0, 463, 595))) // double exclamation mark
        trie.insert(intArrayOf(8265, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 595))) // exclamation question mark
        trie.insert(intArrayOf(8265), ParseResult(1, SpriteCoordinates(8, 0, 397, 595))) // exclamation question mark
        trie.insert(intArrayOf(10067), ParseResult(1, SpriteCoordinates(8, 0, 67, 265))) // red question mark
        trie.insert(intArrayOf(10068), ParseResult(1, SpriteCoordinates(8, 0, 1, 265))) // white question mark
        trie.insert(intArrayOf(10069), ParseResult(1, SpriteCoordinates(8, 0, 265, 199))) // white exclamation mark
        trie.insert(intArrayOf(10071), ParseResult(1, SpriteCoordinates(8, 0, 265, 133))) // red exclamation mark
        trie.insert(intArrayOf(12336), ParseResult(1, SpriteCoordinates(8, 0, 67, 67))) // wavy dash
        trie.insert(intArrayOf(12336, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 67))) // wavy dash
        trie.insert(intArrayOf(128177), ParseResult(2, SpriteCoordinates(8, 0, 859, 463))) // currency exchange
        trie.insert(intArrayOf(128178), ParseResult(2, SpriteCoordinates(8, 0, 859, 397))) // heavy dollar sign
        trie.insert(intArrayOf(9877, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 265))) // medical symbol
        trie.insert(intArrayOf(9877), ParseResult(1, SpriteCoordinates(8, 0, 397, 265))) // medical symbol
        trie.insert(intArrayOf(9851, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 397))) // recycling symbol
        trie.insert(intArrayOf(9851), ParseResult(1, SpriteCoordinates(8, 0, 67, 397))) // recycling symbol
        trie.insert(intArrayOf(9884), ParseResult(1, SpriteCoordinates(8, 0, 397, 133))) // fleur-de-lis
        trie.insert(intArrayOf(9884, 65039), ParseResult(2, SpriteCoordinates(8, 0, 397, 133))) // fleur-de-lis
        trie.insert(intArrayOf(128305), ParseResult(2, SpriteCoordinates(8, 0, 793, 199))) // trident emblem
        trie.insert(intArrayOf(128219), ParseResult(2, SpriteCoordinates(8, 0, 859, 331))) // name badge
        trie.insert(intArrayOf(128304), ParseResult(2, SpriteCoordinates(8, 0, 793, 265))) // Japanese symbol for beginner
        trie.insert(intArrayOf(11093), ParseResult(1, SpriteCoordinates(8, 0, 133, 1))) // hollow red circle
        trie.insert(intArrayOf(9989), ParseResult(1, SpriteCoordinates(8, 0, 67, 331))) // check mark button
        trie.insert(intArrayOf(9745), ParseResult(1, SpriteCoordinates(8, 0, 529, 67))) // check box with check
        trie.insert(intArrayOf(9745, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 67))) // check box with check
        trie.insert(intArrayOf(10004, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 331))) // check mark
        trie.insert(intArrayOf(10004), ParseResult(1, SpriteCoordinates(8, 0, 1, 331))) // check mark
        trie.insert(intArrayOf(10060), ParseResult(1, SpriteCoordinates(8, 0, 199, 265))) // cross mark
        trie.insert(intArrayOf(10062), ParseResult(1, SpriteCoordinates(8, 0, 133, 265))) // cross mark button
        trie.insert(intArrayOf(10160), ParseResult(1, SpriteCoordinates(8, 0, 67, 199))) // curly loop
        trie.insert(intArrayOf(10175), ParseResult(1, SpriteCoordinates(8, 0, 1, 199))) // double curly loop
        trie.insert(intArrayOf(12349, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 67))) // part alternation mark
        trie.insert(intArrayOf(12349), ParseResult(1, SpriteCoordinates(8, 0, 1, 67))) // part alternation mark
        trie.insert(intArrayOf(10035, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 67))) // eight-spoked asterisk
        trie.insert(intArrayOf(10035), ParseResult(1, SpriteCoordinates(8, 0, 331, 67))) // eight-spoked asterisk
        trie.insert(intArrayOf(10036, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 1))) // eight-pointed star
        trie.insert(intArrayOf(10036), ParseResult(1, SpriteCoordinates(8, 0, 331, 1))) // eight-pointed star
        trie.insert(intArrayOf(10055, 65039), ParseResult(2, SpriteCoordinates(8, 0, 265, 265))) // sparkle
        trie.insert(intArrayOf(10055), ParseResult(1, SpriteCoordinates(8, 0, 265, 265))) // sparkle
        trie.insert(intArrayOf(169, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 925))) // copyright
        trie.insert(intArrayOf(174, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 925))) // registered
        trie.insert(intArrayOf(8482, 65039), ParseResult(2, SpriteCoordinates(8, 0, 331, 595))) // trade mark
        trie.insert(intArrayOf(129759), ParseResult(2, SpriteCoordinates(8, 0, 529, 595))) // splatter
        trie.insert(intArrayOf(35, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 859, 925))) // keycap: #
        trie.insert(intArrayOf(35, 8419), ParseResult(2, SpriteCoordinates(8, 0, 859, 925))) // keycap: #
        trie.insert(intArrayOf(42, 8419), ParseResult(2, SpriteCoordinates(8, 0, 793, 925))) // keycap: *
        trie.insert(intArrayOf(42, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 793, 925))) // keycap: *
        trie.insert(intArrayOf(48, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 727, 925))) // keycap: 0
        trie.insert(intArrayOf(48, 8419), ParseResult(2, SpriteCoordinates(8, 0, 727, 925))) // keycap: 0
        trie.insert(intArrayOf(49, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 661, 925))) // keycap: 1
        trie.insert(intArrayOf(49, 8419), ParseResult(2, SpriteCoordinates(8, 0, 661, 925))) // keycap: 1
        trie.insert(intArrayOf(50, 8419), ParseResult(2, SpriteCoordinates(8, 0, 595, 925))) // keycap: 2
        trie.insert(intArrayOf(50, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 595, 925))) // keycap: 2
        trie.insert(intArrayOf(51, 8419), ParseResult(2, SpriteCoordinates(8, 0, 529, 925))) // keycap: 3
        trie.insert(intArrayOf(51, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 529, 925))) // keycap: 3
        trie.insert(intArrayOf(52, 8419), ParseResult(2, SpriteCoordinates(8, 0, 463, 925))) // keycap: 4
        trie.insert(intArrayOf(52, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 463, 925))) // keycap: 4
        trie.insert(intArrayOf(53, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 397, 925))) // keycap: 5
        trie.insert(intArrayOf(53, 8419), ParseResult(2, SpriteCoordinates(8, 0, 397, 925))) // keycap: 5
        trie.insert(intArrayOf(54, 8419), ParseResult(2, SpriteCoordinates(8, 0, 331, 925))) // keycap: 6
        trie.insert(intArrayOf(54, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 331, 925))) // keycap: 6
        trie.insert(intArrayOf(55, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 265, 925))) // keycap: 7
        trie.insert(intArrayOf(55, 8419), ParseResult(2, SpriteCoordinates(8, 0, 265, 925))) // keycap: 7
        trie.insert(intArrayOf(56, 8419), ParseResult(2, SpriteCoordinates(8, 0, 199, 925))) // keycap: 8
        trie.insert(intArrayOf(56, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 199, 925))) // keycap: 8
        trie.insert(intArrayOf(57, 65039, 8419), ParseResult(3, SpriteCoordinates(8, 0, 133, 925))) // keycap: 9
        trie.insert(intArrayOf(57, 8419), ParseResult(2, SpriteCoordinates(8, 0, 133, 925))) // keycap: 9
        trie.insert(intArrayOf(128287), ParseResult(2, SpriteCoordinates(8, 0, 793, 727))) // keycap: 10
        trie.insert(intArrayOf(128288), ParseResult(2, SpriteCoordinates(8, 0, 793, 661))) // input latin uppercase
        trie.insert(intArrayOf(128289), ParseResult(2, SpriteCoordinates(8, 0, 793, 595))) // input latin lowercase
        trie.insert(intArrayOf(128290), ParseResult(2, SpriteCoordinates(8, 0, 793, 529))) // input numbers
        trie.insert(intArrayOf(128291), ParseResult(2, SpriteCoordinates(8, 0, 793, 463))) // input symbols
        trie.insert(intArrayOf(128292), ParseResult(2, SpriteCoordinates(8, 0, 793, 397))) // input latin letters
        trie.insert(intArrayOf(127344, 65039), ParseResult(3, SpriteCoordinates(8, 0, 925, 859))) // A button (blood type)
        trie.insert(intArrayOf(127344), ParseResult(2, SpriteCoordinates(8, 0, 925, 859))) // A button (blood type)
        trie.insert(intArrayOf(127374), ParseResult(2, SpriteCoordinates(8, 0, 925, 595))) // AB button (blood type)
        trie.insert(intArrayOf(127345, 65039), ParseResult(3, SpriteCoordinates(8, 0, 925, 793))) // B button (blood type)
        trie.insert(intArrayOf(127345), ParseResult(2, SpriteCoordinates(8, 0, 925, 793))) // B button (blood type)
        trie.insert(intArrayOf(127377), ParseResult(2, SpriteCoordinates(8, 0, 925, 529))) // CL button
        trie.insert(intArrayOf(127378), ParseResult(2, SpriteCoordinates(8, 0, 925, 463))) // COOL button
        trie.insert(intArrayOf(127379), ParseResult(2, SpriteCoordinates(8, 0, 925, 397))) // FREE button
        trie.insert(intArrayOf(8505, 65039), ParseResult(2, SpriteCoordinates(8, 0, 265, 595))) // information
        trie.insert(intArrayOf(8505), ParseResult(1, SpriteCoordinates(8, 0, 265, 595))) // information
        trie.insert(intArrayOf(127380), ParseResult(2, SpriteCoordinates(8, 0, 925, 331))) // ID button
        trie.insert(intArrayOf(9410, 65039), ParseResult(2, SpriteCoordinates(8, 0, 133, 529))) // circled M
        trie.insert(intArrayOf(9410), ParseResult(1, SpriteCoordinates(8, 0, 133, 529))) // circled M
        trie.insert(intArrayOf(127381), ParseResult(2, SpriteCoordinates(8, 0, 925, 265))) // NEW button
        trie.insert(intArrayOf(127382), ParseResult(2, SpriteCoordinates(8, 0, 925, 199))) // NG button
        trie.insert(intArrayOf(127358, 65039), ParseResult(3, SpriteCoordinates(8, 0, 925, 727))) // O button (blood type)
        trie.insert(intArrayOf(127358), ParseResult(2, SpriteCoordinates(8, 0, 925, 727))) // O button (blood type)
        trie.insert(intArrayOf(127383), ParseResult(2, SpriteCoordinates(8, 0, 925, 133))) // OK button
        trie.insert(intArrayOf(127359), ParseResult(2, SpriteCoordinates(8, 0, 925, 661))) // P button
        trie.insert(intArrayOf(127359, 65039), ParseResult(3, SpriteCoordinates(8, 0, 925, 661))) // P button
        trie.insert(intArrayOf(127384), ParseResult(2, SpriteCoordinates(8, 0, 925, 67))) // SOS button
        trie.insert(intArrayOf(127385), ParseResult(2, SpriteCoordinates(8, 0, 925, 1))) // UP! button
        trie.insert(intArrayOf(127386), ParseResult(2, SpriteCoordinates(8, 0, 859, 859))) // VS button
        trie.insert(intArrayOf(127489), ParseResult(2, SpriteCoordinates(8, 0, 793, 859))) // Japanese “here” button
        trie.insert(intArrayOf(127490, 65039), ParseResult(3, SpriteCoordinates(8, 0, 727, 859))) // Japanese “service charge” button
        trie.insert(intArrayOf(127490), ParseResult(2, SpriteCoordinates(8, 0, 727, 859))) // Japanese “service charge” button
        trie.insert(intArrayOf(127543), ParseResult(2, SpriteCoordinates(8, 0, 199, 859))) // Japanese “monthly amount” button
        trie.insert(intArrayOf(127543, 65039), ParseResult(3, SpriteCoordinates(8, 0, 199, 859))) // Japanese “monthly amount” button
        trie.insert(intArrayOf(127542), ParseResult(2, SpriteCoordinates(8, 0, 265, 859))) // Japanese “not free of charge” button
        trie.insert(intArrayOf(127535), ParseResult(2, SpriteCoordinates(8, 0, 595, 859))) // Japanese “reserved” button
        trie.insert(intArrayOf(127568), ParseResult(2, SpriteCoordinates(8, 0, 859, 793))) // Japanese “bargain” button
        trie.insert(intArrayOf(127545), ParseResult(2, SpriteCoordinates(8, 0, 67, 859))) // Japanese “discount” button
        trie.insert(intArrayOf(127514), ParseResult(2, SpriteCoordinates(8, 0, 661, 859))) // Japanese “free of charge” button
        trie.insert(intArrayOf(127538), ParseResult(2, SpriteCoordinates(8, 0, 529, 859))) // Japanese “prohibited” button
        trie.insert(intArrayOf(127569), ParseResult(2, SpriteCoordinates(8, 0, 859, 727))) // Japanese “acceptable” button
        trie.insert(intArrayOf(127544), ParseResult(2, SpriteCoordinates(8, 0, 133, 859))) // Japanese “application” button
        trie.insert(intArrayOf(127540), ParseResult(2, SpriteCoordinates(8, 0, 397, 859))) // Japanese “passing grade” button
        trie.insert(intArrayOf(127539), ParseResult(2, SpriteCoordinates(8, 0, 463, 859))) // Japanese “vacancy” button
        trie.insert(intArrayOf(12951), ParseResult(1, SpriteCoordinates(8, 0, 67, 1))) // Japanese “congratulations” button
        trie.insert(intArrayOf(12951, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 1))) // Japanese “congratulations” button
        trie.insert(intArrayOf(12953, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 1))) // Japanese “secret” button
        trie.insert(intArrayOf(12953), ParseResult(1, SpriteCoordinates(8, 0, 1, 1))) // Japanese “secret” button
        trie.insert(intArrayOf(127546), ParseResult(2, SpriteCoordinates(8, 0, 1, 859))) // Japanese “open for business” button
        trie.insert(intArrayOf(127541), ParseResult(2, SpriteCoordinates(8, 0, 331, 859))) // Japanese “no vacancy” button
        trie.insert(intArrayOf(128308), ParseResult(2, SpriteCoordinates(8, 0, 793, 1))) // red circle
        trie.insert(intArrayOf(128992), ParseResult(2, SpriteCoordinates(8, 0, 133, 661))) // orange circle
        trie.insert(intArrayOf(128993), ParseResult(2, SpriteCoordinates(8, 0, 67, 661))) // yellow circle
        trie.insert(intArrayOf(128994), ParseResult(2, SpriteCoordinates(8, 0, 1, 661))) // green circle
        trie.insert(intArrayOf(128309), ParseResult(2, SpriteCoordinates(8, 0, 727, 727))) // blue circle
        trie.insert(intArrayOf(128995), ParseResult(2, SpriteCoordinates(8, 0, 661, 595))) // purple circle
        trie.insert(intArrayOf(128996), ParseResult(2, SpriteCoordinates(8, 0, 661, 529))) // brown circle
        trie.insert(intArrayOf(9899), ParseResult(1, SpriteCoordinates(8, 0, 265, 331))) // black circle
        trie.insert(intArrayOf(9898), ParseResult(1, SpriteCoordinates(8, 0, 331, 331))) // white circle
        trie.insert(intArrayOf(128997), ParseResult(2, SpriteCoordinates(8, 0, 661, 463))) // red square
        trie.insert(intArrayOf(128999), ParseResult(2, SpriteCoordinates(8, 0, 661, 331))) // orange square
        trie.insert(intArrayOf(129000), ParseResult(2, SpriteCoordinates(8, 0, 661, 265))) // yellow square
        trie.insert(intArrayOf(129001), ParseResult(2, SpriteCoordinates(8, 0, 661, 199))) // green square
        trie.insert(intArrayOf(128998), ParseResult(2, SpriteCoordinates(8, 0, 661, 397))) // blue square
        trie.insert(intArrayOf(129002), ParseResult(2, SpriteCoordinates(8, 0, 661, 133))) // purple square
        trie.insert(intArrayOf(129003), ParseResult(2, SpriteCoordinates(8, 0, 661, 67))) // brown square
        trie.insert(intArrayOf(11035), ParseResult(1, SpriteCoordinates(8, 0, 1, 133))) // black large square
        trie.insert(intArrayOf(11036), ParseResult(1, SpriteCoordinates(8, 0, 133, 67))) // white large square
        trie.insert(intArrayOf(9724, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 265))) // black medium square
        trie.insert(intArrayOf(9724), ParseResult(1, SpriteCoordinates(8, 0, 529, 265))) // black medium square
        trie.insert(intArrayOf(9723), ParseResult(1, SpriteCoordinates(8, 0, 529, 331))) // white medium square
        trie.insert(intArrayOf(9723, 65039), ParseResult(2, SpriteCoordinates(8, 0, 529, 331))) // white medium square
        trie.insert(intArrayOf(9726), ParseResult(1, SpriteCoordinates(8, 0, 529, 133))) // black medium-small square
        trie.insert(intArrayOf(9725), ParseResult(1, SpriteCoordinates(8, 0, 529, 199))) // white medium-small square
        trie.insert(intArrayOf(9642, 65039), ParseResult(2, SpriteCoordinates(8, 0, 67, 529))) // black small square
        trie.insert(intArrayOf(9642), ParseResult(1, SpriteCoordinates(8, 0, 67, 529))) // black small square
        trie.insert(intArrayOf(9643, 65039), ParseResult(2, SpriteCoordinates(8, 0, 1, 529))) // white small square
        trie.insert(intArrayOf(9643), ParseResult(1, SpriteCoordinates(8, 0, 1, 529))) // white small square
        trie.insert(intArrayOf(128310), ParseResult(2, SpriteCoordinates(8, 0, 661, 727))) // large orange diamond
        trie.insert(intArrayOf(128311), ParseResult(2, SpriteCoordinates(8, 0, 595, 727))) // large blue diamond
        trie.insert(intArrayOf(128312), ParseResult(2, SpriteCoordinates(8, 0, 529, 727))) // small orange diamond
        trie.insert(intArrayOf(128313), ParseResult(2, SpriteCoordinates(8, 0, 463, 727))) // small blue diamond
        trie.insert(intArrayOf(128314), ParseResult(2, SpriteCoordinates(8, 0, 397, 727))) // red triangle pointed up
        trie.insert(intArrayOf(128315), ParseResult(2, SpriteCoordinates(8, 0, 331, 727))) // red triangle pointed down
        trie.insert(intArrayOf(128160), ParseResult(2, SpriteCoordinates(8, 0, 859, 529))) // diamond with a dot
        trie.insert(intArrayOf(128280), ParseResult(2, SpriteCoordinates(8, 0, 397, 793))) // radio button
        trie.insert(intArrayOf(128307), ParseResult(2, SpriteCoordinates(8, 0, 793, 67))) // white square button
        trie.insert(intArrayOf(128306), ParseResult(2, SpriteCoordinates(8, 0, 793, 133))) // black square button
        trie.insert(intArrayOf(127937), ParseResult(2, SpriteCoordinates(9, 0, 67, 67))) // chequered flag
        trie.insert(intArrayOf(127884), ParseResult(2, SpriteCoordinates(9, 0, 133, 1))) // crossed flags
        trie.insert(intArrayOf(127987, 65039), ParseResult(3, SpriteCoordinates(9, 0, 67, 1))) // white flag
        trie.insert(intArrayOf(127987), ParseResult(2, SpriteCoordinates(9, 0, 67, 1))) // white flag
        trie.insert(intArrayOf(127987, 65039, 8205, 9895, 65039), ParseResult(6, SpriteCoordinates(9, 0, 1, 67))) // transgender flag
        trie.insert(intArrayOf(127987, 8205, 9895, 65039), ParseResult(5, SpriteCoordinates(9, 0, 1, 67))) // transgender flag
        trie.insert(intArrayOf(127987, 65039, 8205, 9895), ParseResult(5, SpriteCoordinates(9, 0, 1, 67))) // transgender flag
        trie.insert(intArrayOf(127987, 8205, 9895), ParseResult(4, SpriteCoordinates(9, 0, 1, 67))) // transgender flag
        trie.insert(intArrayOf(127462, 127464), ParseResult(4, SpriteCoordinates(9, 0, 133, 727))) // flag: Ascension Island
        trie.insert(intArrayOf(127462, 127466), ParseResult(4, SpriteCoordinates(9, 0, 67, 727))) // flag: United Arab Emirates
        trie.insert(intArrayOf(127462, 127468), ParseResult(4, SpriteCoordinates(9, 0, 1, 727))) // flag: Antigua & Barbuda
        trie.insert(intArrayOf(127462, 127473), ParseResult(4, SpriteCoordinates(9, 0, 727, 661))) // flag: Albania
        trie.insert(intArrayOf(127462, 127476), ParseResult(4, SpriteCoordinates(9, 0, 727, 595))) // flag: Angola
        trie.insert(intArrayOf(127462, 127479), ParseResult(4, SpriteCoordinates(9, 0, 727, 529))) // flag: Argentina
        trie.insert(intArrayOf(127462, 127481), ParseResult(4, SpriteCoordinates(9, 0, 727, 463))) // flag: Austria
        trie.insert(intArrayOf(127462, 127484), ParseResult(4, SpriteCoordinates(9, 0, 727, 397))) // flag: Aruba
        trie.insert(intArrayOf(127462, 127487), ParseResult(4, SpriteCoordinates(9, 0, 727, 331))) // flag: Azerbaijan
        trie.insert(intArrayOf(127463, 127463), ParseResult(4, SpriteCoordinates(9, 0, 727, 265))) // flag: Barbados
        trie.insert(intArrayOf(127463, 127466), ParseResult(4, SpriteCoordinates(9, 0, 727, 199))) // flag: Belgium
        trie.insert(intArrayOf(127463, 127468), ParseResult(4, SpriteCoordinates(9, 0, 727, 133))) // flag: Bulgaria
        trie.insert(intArrayOf(127463, 127470), ParseResult(4, SpriteCoordinates(9, 0, 727, 67))) // flag: Burundi
        trie.insert(intArrayOf(127463, 127473), ParseResult(4, SpriteCoordinates(9, 0, 727, 1))) // flag: St. Barthélemy
        trie.insert(intArrayOf(127463, 127475), ParseResult(4, SpriteCoordinates(9, 0, 661, 661))) // flag: Brunei
        trie.insert(intArrayOf(127463, 127478), ParseResult(4, SpriteCoordinates(9, 0, 595, 661))) // flag: Caribbean Netherlands
        trie.insert(intArrayOf(127463, 127480), ParseResult(4, SpriteCoordinates(9, 0, 529, 661))) // flag: Bahamas
        trie.insert(intArrayOf(127463, 127483), ParseResult(4, SpriteCoordinates(9, 0, 463, 661))) // flag: Bouvet Island
        trie.insert(intArrayOf(127463, 127486), ParseResult(4, SpriteCoordinates(9, 0, 397, 661))) // flag: Belarus
        trie.insert(intArrayOf(127464, 127462), ParseResult(4, SpriteCoordinates(9, 0, 331, 661))) // flag: Canada
        trie.insert(intArrayOf(127464, 127465), ParseResult(4, SpriteCoordinates(9, 0, 265, 661))) // flag: Congo - Kinshasa
        trie.insert(intArrayOf(127464, 127468), ParseResult(4, SpriteCoordinates(9, 0, 199, 661))) // flag: Congo - Brazzaville
        trie.insert(intArrayOf(127464, 127470), ParseResult(4, SpriteCoordinates(9, 0, 133, 661))) // flag: Côte d’Ivoire
        trie.insert(intArrayOf(127464, 127473), ParseResult(4, SpriteCoordinates(9, 0, 67, 661))) // flag: Chile
        trie.insert(intArrayOf(127464, 127475), ParseResult(4, SpriteCoordinates(9, 0, 1, 661))) // flag: China
        trie.insert(intArrayOf(127464, 127477), ParseResult(4, SpriteCoordinates(9, 0, 661, 595))) // flag: Clipperton Island
        trie.insert(intArrayOf(127464, 127479), ParseResult(4, SpriteCoordinates(9, 0, 661, 529))) // flag: Costa Rica
        trie.insert(intArrayOf(127464, 127483), ParseResult(4, SpriteCoordinates(9, 0, 661, 463))) // flag: Cape Verde
        trie.insert(intArrayOf(127464, 127485), ParseResult(4, SpriteCoordinates(9, 0, 661, 397))) // flag: Christmas Island
        trie.insert(intArrayOf(127464, 127487), ParseResult(4, SpriteCoordinates(9, 0, 661, 331))) // flag: Czechia
        trie.insert(intArrayOf(127465, 127468), ParseResult(4, SpriteCoordinates(9, 0, 661, 265))) // flag: Diego Garcia
        trie.insert(intArrayOf(127465, 127472), ParseResult(4, SpriteCoordinates(9, 0, 661, 199))) // flag: Denmark
        trie.insert(intArrayOf(127465, 127476), ParseResult(4, SpriteCoordinates(9, 0, 661, 133))) // flag: Dominican Republic
        trie.insert(intArrayOf(127466, 127462), ParseResult(4, SpriteCoordinates(9, 0, 661, 67))) // flag: Ceuta & Melilla
        trie.insert(intArrayOf(127466, 127466), ParseResult(4, SpriteCoordinates(9, 0, 661, 1))) // flag: Estonia
        trie.insert(intArrayOf(127466, 127469), ParseResult(4, SpriteCoordinates(9, 0, 595, 595))) // flag: Western Sahara
        trie.insert(intArrayOf(127466, 127480), ParseResult(4, SpriteCoordinates(9, 0, 529, 595))) // flag: Spain
        trie.insert(intArrayOf(127466, 127482), ParseResult(4, SpriteCoordinates(9, 0, 463, 595))) // flag: European Union
        trie.insert(intArrayOf(127467, 127471), ParseResult(4, SpriteCoordinates(9, 0, 397, 595))) // flag: Fiji
        trie.insert(intArrayOf(127467, 127474), ParseResult(4, SpriteCoordinates(9, 0, 331, 595))) // flag: Micronesia
        trie.insert(intArrayOf(127467, 127479), ParseResult(4, SpriteCoordinates(9, 0, 265, 595))) // flag: France
        trie.insert(intArrayOf(127468, 127463), ParseResult(4, SpriteCoordinates(9, 0, 199, 595))) // flag: United Kingdom
        trie.insert(intArrayOf(127468, 127466), ParseResult(4, SpriteCoordinates(9, 0, 133, 595))) // flag: Georgia
        trie.insert(intArrayOf(127468, 127468), ParseResult(4, SpriteCoordinates(9, 0, 67, 595))) // flag: Guernsey
        trie.insert(intArrayOf(127468, 127470), ParseResult(4, SpriteCoordinates(9, 0, 1, 595))) // flag: Gibraltar
        trie.insert(intArrayOf(127468, 127474), ParseResult(4, SpriteCoordinates(9, 0, 595, 529))) // flag: Gambia
        trie.insert(intArrayOf(127468, 127477), ParseResult(4, SpriteCoordinates(9, 0, 595, 463))) // flag: Guadeloupe
        trie.insert(intArrayOf(127468, 127479), ParseResult(4, SpriteCoordinates(9, 0, 595, 397))) // flag: Greece
        trie.insert(intArrayOf(127468, 127481), ParseResult(4, SpriteCoordinates(9, 0, 595, 331))) // flag: Guatemala
        trie.insert(intArrayOf(127468, 127484), ParseResult(4, SpriteCoordinates(9, 0, 595, 265))) // flag: Guinea-Bissau
        trie.insert(intArrayOf(127469, 127472), ParseResult(4, SpriteCoordinates(9, 0, 595, 199))) // flag: Hong Kong SAR China
        trie.insert(intArrayOf(127469, 127475), ParseResult(4, SpriteCoordinates(9, 0, 595, 133))) // flag: Honduras
        trie.insert(intArrayOf(127469, 127481), ParseResult(4, SpriteCoordinates(9, 0, 595, 67))) // flag: Haiti
        trie.insert(intArrayOf(127470, 127464), ParseResult(4, SpriteCoordinates(9, 0, 595, 1))) // flag: Canary Islands
        trie.insert(intArrayOf(127470, 127466), ParseResult(4, SpriteCoordinates(9, 0, 529, 529))) // flag: Ireland
        trie.insert(intArrayOf(127470, 127474), ParseResult(4, SpriteCoordinates(9, 0, 463, 529))) // flag: Isle of Man
        trie.insert(intArrayOf(127470, 127476), ParseResult(4, SpriteCoordinates(9, 0, 397, 529))) // flag: British Indian Ocean Territory
        trie.insert(intArrayOf(127470, 127479), ParseResult(4, SpriteCoordinates(9, 0, 331, 529))) // flag: Iran
        trie.insert(intArrayOf(127470, 127481), ParseResult(4, SpriteCoordinates(9, 0, 265, 529))) // flag: Italy
        trie.insert(intArrayOf(127471, 127474), ParseResult(4, SpriteCoordinates(9, 0, 199, 529))) // flag: Jamaica
        trie.insert(intArrayOf(127471, 127477), ParseResult(4, SpriteCoordinates(9, 0, 133, 529))) // flag: Japan
        trie.insert(intArrayOf(127472, 127468), ParseResult(4, SpriteCoordinates(9, 0, 67, 529))) // flag: Kyrgyzstan
        trie.insert(intArrayOf(127472, 127470), ParseResult(4, SpriteCoordinates(9, 0, 1, 529))) // flag: Kiribati
        trie.insert(intArrayOf(127472, 127475), ParseResult(4, SpriteCoordinates(9, 0, 529, 463))) // flag: St. Kitts & Nevis
        trie.insert(intArrayOf(127472, 127479), ParseResult(4, SpriteCoordinates(9, 0, 529, 397))) // flag: South Korea
        trie.insert(intArrayOf(127472, 127486), ParseResult(4, SpriteCoordinates(9, 0, 529, 331))) // flag: Cayman Islands
        trie.insert(intArrayOf(127473, 127462), ParseResult(4, SpriteCoordinates(9, 0, 529, 265))) // flag: Laos
        trie.insert(intArrayOf(127473, 127464), ParseResult(4, SpriteCoordinates(9, 0, 529, 199))) // flag: St. Lucia
        trie.insert(intArrayOf(127473, 127472), ParseResult(4, SpriteCoordinates(9, 0, 529, 133))) // flag: Sri Lanka
        trie.insert(intArrayOf(127473, 127480), ParseResult(4, SpriteCoordinates(9, 0, 529, 67))) // flag: Lesotho
        trie.insert(intArrayOf(127473, 127482), ParseResult(4, SpriteCoordinates(9, 0, 529, 1))) // flag: Luxembourg
        trie.insert(intArrayOf(127473, 127486), ParseResult(4, SpriteCoordinates(9, 0, 463, 463))) // flag: Libya
        trie.insert(intArrayOf(127474, 127464), ParseResult(4, SpriteCoordinates(9, 0, 397, 463))) // flag: Monaco
        trie.insert(intArrayOf(127474, 127466), ParseResult(4, SpriteCoordinates(9, 0, 331, 463))) // flag: Montenegro
        trie.insert(intArrayOf(127474, 127468), ParseResult(4, SpriteCoordinates(9, 0, 265, 463))) // flag: Madagascar
        trie.insert(intArrayOf(127474, 127472), ParseResult(4, SpriteCoordinates(9, 0, 199, 463))) // flag: North Macedonia
        trie.insert(intArrayOf(127474, 127474), ParseResult(4, SpriteCoordinates(9, 0, 133, 463))) // flag: Myanmar (Burma)
        trie.insert(intArrayOf(127474, 127476), ParseResult(4, SpriteCoordinates(9, 0, 67, 463))) // flag: Macao SAR China
        trie.insert(intArrayOf(127474, 127478), ParseResult(4, SpriteCoordinates(9, 0, 1, 463))) // flag: Martinique
        trie.insert(intArrayOf(127474, 127480), ParseResult(4, SpriteCoordinates(9, 0, 463, 397))) // flag: Montserrat
        trie.insert(intArrayOf(127474, 127482), ParseResult(4, SpriteCoordinates(9, 0, 463, 331))) // flag: Mauritius
        trie.insert(intArrayOf(127474, 127484), ParseResult(4, SpriteCoordinates(9, 0, 463, 265))) // flag: Malawi
        trie.insert(intArrayOf(127474, 127486), ParseResult(4, SpriteCoordinates(9, 0, 463, 199))) // flag: Malaysia
        trie.insert(intArrayOf(127475, 127462), ParseResult(4, SpriteCoordinates(9, 0, 463, 133))) // flag: Namibia
        trie.insert(intArrayOf(127475, 127466), ParseResult(4, SpriteCoordinates(9, 0, 463, 67))) // flag: Niger
    }

    private fun init13(trie: IntTrie<ParseResult>) {
        trie.insert(intArrayOf(127475, 127468), ParseResult(4, SpriteCoordinates(9, 0, 463, 1))) // flag: Nigeria
        trie.insert(intArrayOf(127475, 127473), ParseResult(4, SpriteCoordinates(9, 0, 397, 397))) // flag: Netherlands
        trie.insert(intArrayOf(127475, 127477), ParseResult(4, SpriteCoordinates(9, 0, 331, 397))) // flag: Nepal
        trie.insert(intArrayOf(127475, 127482), ParseResult(4, SpriteCoordinates(9, 0, 265, 397))) // flag: Niue
        trie.insert(intArrayOf(127476, 127474), ParseResult(4, SpriteCoordinates(9, 0, 199, 397))) // flag: Oman
        trie.insert(intArrayOf(127477, 127466), ParseResult(4, SpriteCoordinates(9, 0, 133, 397))) // flag: Peru
        trie.insert(intArrayOf(127477, 127468), ParseResult(4, SpriteCoordinates(9, 0, 67, 397))) // flag: Papua New Guinea
        trie.insert(intArrayOf(127477, 127472), ParseResult(4, SpriteCoordinates(9, 0, 1, 397))) // flag: Pakistan
        trie.insert(intArrayOf(127477, 127474), ParseResult(4, SpriteCoordinates(9, 0, 397, 331))) // flag: St. Pierre & Miquelon
        trie.insert(intArrayOf(127477, 127479), ParseResult(4, SpriteCoordinates(9, 0, 397, 265))) // flag: Puerto Rico
        trie.insert(intArrayOf(127477, 127481), ParseResult(4, SpriteCoordinates(9, 0, 397, 199))) // flag: Portugal
        trie.insert(intArrayOf(127477, 127486), ParseResult(4, SpriteCoordinates(9, 0, 397, 133))) // flag: Paraguay
        trie.insert(intArrayOf(127479, 127466), ParseResult(4, SpriteCoordinates(9, 0, 397, 67))) // flag: Réunion
        trie.insert(intArrayOf(127479, 127480), ParseResult(4, SpriteCoordinates(9, 0, 397, 1))) // flag: Serbia
        trie.insert(intArrayOf(127479, 127484), ParseResult(4, SpriteCoordinates(9, 0, 331, 331))) // flag: Rwanda
        trie.insert(intArrayOf(127480, 127463), ParseResult(4, SpriteCoordinates(9, 0, 265, 331))) // flag: Solomon Islands
        trie.insert(intArrayOf(127480, 127465), ParseResult(4, SpriteCoordinates(9, 0, 199, 331))) // flag: Sudan
        trie.insert(intArrayOf(127480, 127468), ParseResult(4, SpriteCoordinates(9, 0, 133, 331))) // flag: Singapore
        trie.insert(intArrayOf(127480, 127470), ParseResult(4, SpriteCoordinates(9, 0, 67, 331))) // flag: Slovenia
        trie.insert(intArrayOf(127480, 127472), ParseResult(4, SpriteCoordinates(9, 0, 1, 331))) // flag: Slovakia
        trie.insert(intArrayOf(127480, 127474), ParseResult(4, SpriteCoordinates(9, 0, 331, 265))) // flag: San Marino
        trie.insert(intArrayOf(127480, 127476), ParseResult(4, SpriteCoordinates(9, 0, 331, 199))) // flag: Somalia
        trie.insert(intArrayOf(127480, 127480), ParseResult(4, SpriteCoordinates(9, 0, 331, 133))) // flag: South Sudan
        trie.insert(intArrayOf(127480, 127483), ParseResult(4, SpriteCoordinates(9, 0, 331, 67))) // flag: El Salvador
        trie.insert(intArrayOf(127480, 127486), ParseResult(4, SpriteCoordinates(9, 0, 331, 1))) // flag: Syria
        trie.insert(intArrayOf(127481, 127462), ParseResult(4, SpriteCoordinates(9, 0, 265, 265))) // flag: Tristan da Cunha
        trie.insert(intArrayOf(127481, 127465), ParseResult(4, SpriteCoordinates(9, 0, 199, 265))) // flag: Chad
        trie.insert(intArrayOf(127481, 127468), ParseResult(4, SpriteCoordinates(9, 0, 133, 265))) // flag: Togo
        trie.insert(intArrayOf(127481, 127471), ParseResult(4, SpriteCoordinates(9, 0, 67, 265))) // flag: Tajikistan
        trie.insert(intArrayOf(127481, 127473), ParseResult(4, SpriteCoordinates(9, 0, 1, 265))) // flag: Timor-Leste
        trie.insert(intArrayOf(127481, 127475), ParseResult(4, SpriteCoordinates(9, 0, 265, 199))) // flag: Tunisia
        trie.insert(intArrayOf(127481, 127479), ParseResult(4, SpriteCoordinates(9, 0, 265, 133))) // flag: Türkiye
        trie.insert(intArrayOf(127481, 127483), ParseResult(4, SpriteCoordinates(9, 0, 265, 67))) // flag: Tuvalu
        trie.insert(intArrayOf(127481, 127487), ParseResult(4, SpriteCoordinates(9, 0, 265, 1))) // flag: Tanzania
        trie.insert(intArrayOf(127482, 127468), ParseResult(4, SpriteCoordinates(9, 0, 199, 199))) // flag: Uganda
        trie.insert(intArrayOf(127482, 127475), ParseResult(4, SpriteCoordinates(9, 0, 133, 199))) // flag: United Nations
        trie.insert(intArrayOf(127482, 127486), ParseResult(4, SpriteCoordinates(9, 0, 67, 199))) // flag: Uruguay
        trie.insert(intArrayOf(127483, 127462), ParseResult(4, SpriteCoordinates(9, 0, 1, 199))) // flag: Vatican City
        trie.insert(intArrayOf(127483, 127466), ParseResult(4, SpriteCoordinates(9, 0, 199, 133))) // flag: Venezuela
        trie.insert(intArrayOf(127483, 127470), ParseResult(4, SpriteCoordinates(9, 0, 199, 67))) // flag: U.S. Virgin Islands
        trie.insert(intArrayOf(127483, 127482), ParseResult(4, SpriteCoordinates(9, 0, 199, 1))) // flag: Vanuatu
        trie.insert(intArrayOf(127484, 127480), ParseResult(4, SpriteCoordinates(9, 0, 133, 133))) // flag: Samoa
        trie.insert(intArrayOf(127486, 127466), ParseResult(4, SpriteCoordinates(9, 0, 67, 133))) // flag: Yemen
        trie.insert(intArrayOf(127487, 127462), ParseResult(4, SpriteCoordinates(9, 0, 1, 133))) // flag: South Africa
        trie.insert(intArrayOf(127487, 127484), ParseResult(4, SpriteCoordinates(9, 0, 133, 67))) // flag: Zimbabwe
        trie.insert(intArrayOf(127988, 917607, 917602, 917619, 917603, 917620, 917631), ParseResult(14, SpriteCoordinates(9, 0, 1, 1))) // flag: Scotland
        trie.insert(intArrayOf(128681), ParseResult(2, SpriteCoordinates(9, 1, 1, 1))) // triangular flag
        trie.insert(intArrayOf(127988), ParseResult(2, SpriteCoordinates(9, 1, 67, 1))) // black flag
        trie.insert(intArrayOf(127987, 65039, 8205, 127752), ParseResult(6, SpriteCoordinates(9, 1, 133, 67))) // rainbow flag
        trie.insert(intArrayOf(127987, 8205, 127752), ParseResult(5, SpriteCoordinates(9, 1, 133, 67))) // rainbow flag
        trie.insert(intArrayOf(127988, 8205, 9760), ParseResult(4, SpriteCoordinates(9, 1, 133, 1))) // pirate flag
        trie.insert(intArrayOf(127988, 8205, 9760, 65039), ParseResult(5, SpriteCoordinates(9, 1, 133, 1))) // pirate flag
        trie.insert(intArrayOf(127462, 127465), ParseResult(4, SpriteCoordinates(9, 1, 133, 727))) // flag: Andorra
        trie.insert(intArrayOf(127462, 127467), ParseResult(4, SpriteCoordinates(9, 1, 67, 727))) // flag: Afghanistan
        trie.insert(intArrayOf(127462, 127470), ParseResult(4, SpriteCoordinates(9, 1, 1, 727))) // flag: Anguilla
        trie.insert(intArrayOf(127462, 127474), ParseResult(4, SpriteCoordinates(9, 1, 727, 661))) // flag: Armenia
        trie.insert(intArrayOf(127462, 127478), ParseResult(4, SpriteCoordinates(9, 1, 727, 595))) // flag: Antarctica
        trie.insert(intArrayOf(127462, 127480), ParseResult(4, SpriteCoordinates(9, 1, 727, 529))) // flag: American Samoa
        trie.insert(intArrayOf(127462, 127482), ParseResult(4, SpriteCoordinates(9, 1, 727, 463))) // flag: Australia
        trie.insert(intArrayOf(127462, 127485), ParseResult(4, SpriteCoordinates(9, 1, 727, 397))) // flag: Åland Islands
        trie.insert(intArrayOf(127463, 127462), ParseResult(4, SpriteCoordinates(9, 1, 727, 331))) // flag: Bosnia & Herzegovina
        trie.insert(intArrayOf(127463, 127465), ParseResult(4, SpriteCoordinates(9, 1, 727, 265))) // flag: Bangladesh
        trie.insert(intArrayOf(127463, 127467), ParseResult(4, SpriteCoordinates(9, 1, 727, 199))) // flag: Burkina Faso
        trie.insert(intArrayOf(127463, 127469), ParseResult(4, SpriteCoordinates(9, 1, 727, 133))) // flag: Bahrain
        trie.insert(intArrayOf(127463, 127471), ParseResult(4, SpriteCoordinates(9, 1, 727, 67))) // flag: Benin
        trie.insert(intArrayOf(127463, 127474), ParseResult(4, SpriteCoordinates(9, 1, 727, 1))) // flag: Bermuda
        trie.insert(intArrayOf(127463, 127476), ParseResult(4, SpriteCoordinates(9, 1, 661, 661))) // flag: Bolivia
        trie.insert(intArrayOf(127463, 127479), ParseResult(4, SpriteCoordinates(9, 1, 595, 661))) // flag: Brazil
        trie.insert(intArrayOf(127463, 127481), ParseResult(4, SpriteCoordinates(9, 1, 529, 661))) // flag: Bhutan
        trie.insert(intArrayOf(127463, 127484), ParseResult(4, SpriteCoordinates(9, 1, 463, 661))) // flag: Botswana
        trie.insert(intArrayOf(127463, 127487), ParseResult(4, SpriteCoordinates(9, 1, 397, 661))) // flag: Belize
        trie.insert(intArrayOf(127464, 127464), ParseResult(4, SpriteCoordinates(9, 1, 331, 661))) // flag: Cocos (Keeling) Islands
        trie.insert(intArrayOf(127464, 127467), ParseResult(4, SpriteCoordinates(9, 1, 265, 661))) // flag: Central African Republic
        trie.insert(intArrayOf(127464, 127469), ParseResult(4, SpriteCoordinates(9, 1, 199, 661))) // flag: Switzerland
        trie.insert(intArrayOf(127464, 127472), ParseResult(4, SpriteCoordinates(9, 1, 133, 661))) // flag: Cook Islands
        trie.insert(intArrayOf(127464, 127474), ParseResult(4, SpriteCoordinates(9, 1, 67, 661))) // flag: Cameroon
        trie.insert(intArrayOf(127464, 127476), ParseResult(4, SpriteCoordinates(9, 1, 1, 661))) // flag: Colombia
        trie.insert(intArrayOf(127464, 127478), ParseResult(4, SpriteCoordinates(9, 1, 661, 595))) // flag: Sark
        trie.insert(intArrayOf(127464, 127482), ParseResult(4, SpriteCoordinates(9, 1, 661, 529))) // flag: Cuba
        trie.insert(intArrayOf(127464, 127484), ParseResult(4, SpriteCoordinates(9, 1, 661, 463))) // flag: Curaçao
        trie.insert(intArrayOf(127464, 127486), ParseResult(4, SpriteCoordinates(9, 1, 661, 397))) // flag: Cyprus
        trie.insert(intArrayOf(127465, 127466), ParseResult(4, SpriteCoordinates(9, 1, 661, 331))) // flag: Germany
        trie.insert(intArrayOf(127465, 127471), ParseResult(4, SpriteCoordinates(9, 1, 661, 265))) // flag: Djibouti
        trie.insert(intArrayOf(127465, 127474), ParseResult(4, SpriteCoordinates(9, 1, 661, 199))) // flag: Dominica
        trie.insert(intArrayOf(127465, 127487), ParseResult(4, SpriteCoordinates(9, 1, 661, 133))) // flag: Algeria
        trie.insert(intArrayOf(127466, 127464), ParseResult(4, SpriteCoordinates(9, 1, 661, 67))) // flag: Ecuador
        trie.insert(intArrayOf(127466, 127468), ParseResult(4, SpriteCoordinates(9, 1, 661, 1))) // flag: Egypt
        trie.insert(intArrayOf(127466, 127479), ParseResult(4, SpriteCoordinates(9, 1, 595, 595))) // flag: Eritrea
        trie.insert(intArrayOf(127466, 127481), ParseResult(4, SpriteCoordinates(9, 1, 529, 595))) // flag: Ethiopia
        trie.insert(intArrayOf(127467, 127470), ParseResult(4, SpriteCoordinates(9, 1, 463, 595))) // flag: Finland
        trie.insert(intArrayOf(127467, 127472), ParseResult(4, SpriteCoordinates(9, 1, 397, 595))) // flag: Falkland Islands
        trie.insert(intArrayOf(127467, 127476), ParseResult(4, SpriteCoordinates(9, 1, 331, 595))) // flag: Faroe Islands
        trie.insert(intArrayOf(127468, 127462), ParseResult(4, SpriteCoordinates(9, 1, 265, 595))) // flag: Gabon
        trie.insert(intArrayOf(127468, 127465), ParseResult(4, SpriteCoordinates(9, 1, 199, 595))) // flag: Grenada
        trie.insert(intArrayOf(127468, 127467), ParseResult(4, SpriteCoordinates(9, 1, 133, 595))) // flag: French Guiana
        trie.insert(intArrayOf(127468, 127469), ParseResult(4, SpriteCoordinates(9, 1, 67, 595))) // flag: Ghana
        trie.insert(intArrayOf(127468, 127473), ParseResult(4, SpriteCoordinates(9, 1, 1, 595))) // flag: Greenland
        trie.insert(intArrayOf(127468, 127475), ParseResult(4, SpriteCoordinates(9, 1, 595, 529))) // flag: Guinea
        trie.insert(intArrayOf(127468, 127478), ParseResult(4, SpriteCoordinates(9, 1, 595, 463))) // flag: Equatorial Guinea
        trie.insert(intArrayOf(127468, 127480), ParseResult(4, SpriteCoordinates(9, 1, 595, 397))) // flag: South Georgia & South Sandwich Islands
        trie.insert(intArrayOf(127468, 127482), ParseResult(4, SpriteCoordinates(9, 1, 595, 331))) // flag: Guam
        trie.insert(intArrayOf(127468, 127486), ParseResult(4, SpriteCoordinates(9, 1, 595, 265))) // flag: Guyana
        trie.insert(intArrayOf(127469, 127474), ParseResult(4, SpriteCoordinates(9, 1, 595, 199))) // flag: Heard & McDonald Islands
        trie.insert(intArrayOf(127469, 127479), ParseResult(4, SpriteCoordinates(9, 1, 595, 133))) // flag: Croatia
        trie.insert(intArrayOf(127469, 127482), ParseResult(4, SpriteCoordinates(9, 1, 595, 67))) // flag: Hungary
        trie.insert(intArrayOf(127470, 127465), ParseResult(4, SpriteCoordinates(9, 1, 595, 1))) // flag: Indonesia
        trie.insert(intArrayOf(127470, 127473), ParseResult(4, SpriteCoordinates(9, 1, 529, 529))) // flag: Israel
        trie.insert(intArrayOf(127470, 127475), ParseResult(4, SpriteCoordinates(9, 1, 463, 529))) // flag: India
        trie.insert(intArrayOf(127470, 127478), ParseResult(4, SpriteCoordinates(9, 1, 397, 529))) // flag: Iraq
        trie.insert(intArrayOf(127470, 127480), ParseResult(4, SpriteCoordinates(9, 1, 331, 529))) // flag: Iceland
        trie.insert(intArrayOf(127471, 127466), ParseResult(4, SpriteCoordinates(9, 1, 265, 529))) // flag: Jersey
        trie.insert(intArrayOf(127471, 127476), ParseResult(4, SpriteCoordinates(9, 1, 199, 529))) // flag: Jordan
        trie.insert(intArrayOf(127472, 127466), ParseResult(4, SpriteCoordinates(9, 1, 133, 529))) // flag: Kenya
        trie.insert(intArrayOf(127472, 127469), ParseResult(4, SpriteCoordinates(9, 1, 67, 529))) // flag: Cambodia
        trie.insert(intArrayOf(127472, 127474), ParseResult(4, SpriteCoordinates(9, 1, 1, 529))) // flag: Comoros
        trie.insert(intArrayOf(127472, 127477), ParseResult(4, SpriteCoordinates(9, 1, 529, 463))) // flag: North Korea
        trie.insert(intArrayOf(127472, 127484), ParseResult(4, SpriteCoordinates(9, 1, 529, 397))) // flag: Kuwait
        trie.insert(intArrayOf(127472, 127487), ParseResult(4, SpriteCoordinates(9, 1, 529, 331))) // flag: Kazakhstan
        trie.insert(intArrayOf(127473, 127463), ParseResult(4, SpriteCoordinates(9, 1, 529, 265))) // flag: Lebanon
        trie.insert(intArrayOf(127473, 127470), ParseResult(4, SpriteCoordinates(9, 1, 529, 199))) // flag: Liechtenstein
        trie.insert(intArrayOf(127473, 127479), ParseResult(4, SpriteCoordinates(9, 1, 529, 133))) // flag: Liberia
        trie.insert(intArrayOf(127473, 127481), ParseResult(4, SpriteCoordinates(9, 1, 529, 67))) // flag: Lithuania
        trie.insert(intArrayOf(127473, 127483), ParseResult(4, SpriteCoordinates(9, 1, 529, 1))) // flag: Latvia
        trie.insert(intArrayOf(127474, 127462), ParseResult(4, SpriteCoordinates(9, 1, 463, 463))) // flag: Morocco
        trie.insert(intArrayOf(127474, 127465), ParseResult(4, SpriteCoordinates(9, 1, 397, 463))) // flag: Moldova
        trie.insert(intArrayOf(127474, 127467), ParseResult(4, SpriteCoordinates(9, 1, 331, 463))) // flag: St. Martin
        trie.insert(intArrayOf(127474, 127469), ParseResult(4, SpriteCoordinates(9, 1, 265, 463))) // flag: Marshall Islands
        trie.insert(intArrayOf(127474, 127473), ParseResult(4, SpriteCoordinates(9, 1, 199, 463))) // flag: Mali
        trie.insert(intArrayOf(127474, 127475), ParseResult(4, SpriteCoordinates(9, 1, 133, 463))) // flag: Mongolia
        trie.insert(intArrayOf(127474, 127477), ParseResult(4, SpriteCoordinates(9, 1, 67, 463))) // flag: Northern Mariana Islands
        trie.insert(intArrayOf(127474, 127479), ParseResult(4, SpriteCoordinates(9, 1, 1, 463))) // flag: Mauritania
        trie.insert(intArrayOf(127474, 127481), ParseResult(4, SpriteCoordinates(9, 1, 463, 397))) // flag: Malta
        trie.insert(intArrayOf(127474, 127483), ParseResult(4, SpriteCoordinates(9, 1, 463, 331))) // flag: Maldives
        trie.insert(intArrayOf(127474, 127485), ParseResult(4, SpriteCoordinates(9, 1, 463, 265))) // flag: Mexico
        trie.insert(intArrayOf(127474, 127487), ParseResult(4, SpriteCoordinates(9, 1, 463, 199))) // flag: Mozambique
        trie.insert(intArrayOf(127475, 127464), ParseResult(4, SpriteCoordinates(9, 1, 463, 133))) // flag: New Caledonia
        trie.insert(intArrayOf(127475, 127467), ParseResult(4, SpriteCoordinates(9, 1, 463, 67))) // flag: Norfolk Island
        trie.insert(intArrayOf(127475, 127470), ParseResult(4, SpriteCoordinates(9, 1, 463, 1))) // flag: Nicaragua
        trie.insert(intArrayOf(127475, 127476), ParseResult(4, SpriteCoordinates(9, 1, 397, 397))) // flag: Norway
        trie.insert(intArrayOf(127475, 127479), ParseResult(4, SpriteCoordinates(9, 1, 331, 397))) // flag: Nauru
        trie.insert(intArrayOf(127475, 127487), ParseResult(4, SpriteCoordinates(9, 1, 265, 397))) // flag: New Zealand
        trie.insert(intArrayOf(127477, 127462), ParseResult(4, SpriteCoordinates(9, 1, 199, 397))) // flag: Panama
        trie.insert(intArrayOf(127477, 127467), ParseResult(4, SpriteCoordinates(9, 1, 133, 397))) // flag: French Polynesia
        trie.insert(intArrayOf(127477, 127469), ParseResult(4, SpriteCoordinates(9, 1, 67, 397))) // flag: Philippines
        trie.insert(intArrayOf(127477, 127473), ParseResult(4, SpriteCoordinates(9, 1, 1, 397))) // flag: Poland
        trie.insert(intArrayOf(127477, 127475), ParseResult(4, SpriteCoordinates(9, 1, 397, 331))) // flag: Pitcairn Islands
        trie.insert(intArrayOf(127477, 127480), ParseResult(4, SpriteCoordinates(9, 1, 397, 265))) // flag: Palestinian Territories
        trie.insert(intArrayOf(127477, 127484), ParseResult(4, SpriteCoordinates(9, 1, 397, 199))) // flag: Palau
        trie.insert(intArrayOf(127478, 127462), ParseResult(4, SpriteCoordinates(9, 1, 397, 133))) // flag: Qatar
        trie.insert(intArrayOf(127479, 127476), ParseResult(4, SpriteCoordinates(9, 1, 397, 67))) // flag: Romania
        trie.insert(intArrayOf(127479, 127482), ParseResult(4, SpriteCoordinates(9, 1, 397, 1))) // flag: Russia
        trie.insert(intArrayOf(127480, 127462), ParseResult(4, SpriteCoordinates(9, 1, 331, 331))) // flag: Saudi Arabia
        trie.insert(intArrayOf(127480, 127464), ParseResult(4, SpriteCoordinates(9, 1, 265, 331))) // flag: Seychelles
        trie.insert(intArrayOf(127480, 127466), ParseResult(4, SpriteCoordinates(9, 1, 199, 331))) // flag: Sweden
        trie.insert(intArrayOf(127480, 127469), ParseResult(4, SpriteCoordinates(9, 1, 133, 331))) // flag: St. Helena
        trie.insert(intArrayOf(127480, 127471), ParseResult(4, SpriteCoordinates(9, 1, 67, 331))) // flag: Svalbard & Jan Mayen
        trie.insert(intArrayOf(127480, 127473), ParseResult(4, SpriteCoordinates(9, 1, 1, 331))) // flag: Sierra Leone
        trie.insert(intArrayOf(127480, 127475), ParseResult(4, SpriteCoordinates(9, 1, 331, 265))) // flag: Senegal
        trie.insert(intArrayOf(127480, 127479), ParseResult(4, SpriteCoordinates(9, 1, 331, 199))) // flag: Suriname
        trie.insert(intArrayOf(127480, 127481), ParseResult(4, SpriteCoordinates(9, 1, 331, 133))) // flag: São Tomé & Príncipe
        trie.insert(intArrayOf(127480, 127485), ParseResult(4, SpriteCoordinates(9, 1, 331, 67))) // flag: Sint Maarten
        trie.insert(intArrayOf(127480, 127487), ParseResult(4, SpriteCoordinates(9, 1, 331, 1))) // flag: Eswatini
        trie.insert(intArrayOf(127481, 127464), ParseResult(4, SpriteCoordinates(9, 1, 265, 265))) // flag: Turks & Caicos Islands
        trie.insert(intArrayOf(127481, 127467), ParseResult(4, SpriteCoordinates(9, 1, 199, 265))) // flag: French Southern Territories
        trie.insert(intArrayOf(127481, 127469), ParseResult(4, SpriteCoordinates(9, 1, 133, 265))) // flag: Thailand
        trie.insert(intArrayOf(127481, 127472), ParseResult(4, SpriteCoordinates(9, 1, 67, 265))) // flag: Tokelau
        trie.insert(intArrayOf(127481, 127474), ParseResult(4, SpriteCoordinates(9, 1, 1, 265))) // flag: Turkmenistan
        trie.insert(intArrayOf(127481, 127476), ParseResult(4, SpriteCoordinates(9, 1, 265, 199))) // flag: Tonga
        trie.insert(intArrayOf(127481, 127481), ParseResult(4, SpriteCoordinates(9, 1, 265, 133))) // flag: Trinidad & Tobago
        trie.insert(intArrayOf(127481, 127484), ParseResult(4, SpriteCoordinates(9, 1, 265, 67))) // flag: Taiwan
        trie.insert(intArrayOf(127482, 127462), ParseResult(4, SpriteCoordinates(9, 1, 265, 1))) // flag: Ukraine
        trie.insert(intArrayOf(127482, 127474), ParseResult(4, SpriteCoordinates(9, 1, 199, 199))) // flag: U.S. Outlying Islands
        trie.insert(intArrayOf(127482, 127480), ParseResult(4, SpriteCoordinates(9, 1, 133, 199))) // flag: United States
        trie.insert(intArrayOf(127482, 127487), ParseResult(4, SpriteCoordinates(9, 1, 67, 199))) // flag: Uzbekistan
        trie.insert(intArrayOf(127483, 127464), ParseResult(4, SpriteCoordinates(9, 1, 1, 199))) // flag: St. Vincent & Grenadines
        trie.insert(intArrayOf(127483, 127468), ParseResult(4, SpriteCoordinates(9, 1, 199, 133))) // flag: British Virgin Islands
        trie.insert(intArrayOf(127483, 127475), ParseResult(4, SpriteCoordinates(9, 1, 199, 67))) // flag: Vietnam
        trie.insert(intArrayOf(127484, 127467), ParseResult(4, SpriteCoordinates(9, 1, 199, 1))) // flag: Wallis & Futuna
        trie.insert(intArrayOf(127485, 127472), ParseResult(4, SpriteCoordinates(9, 1, 133, 133))) // flag: Kosovo
        trie.insert(intArrayOf(127486, 127481), ParseResult(4, SpriteCoordinates(9, 1, 67, 133))) // flag: Mayotte
        trie.insert(intArrayOf(127487, 127474), ParseResult(4, SpriteCoordinates(9, 1, 1, 133))) // flag: Zambia
        trie.insert(intArrayOf(127988, 917607, 917602, 917605, 917614, 917607, 917631), ParseResult(14, SpriteCoordinates(9, 1, 67, 67))) // flag: England
        trie.insert(intArrayOf(127988, 917607, 917602, 917623, 917612, 917619, 917631), ParseResult(14, SpriteCoordinates(9, 1, 1, 67))) // flag: Wales
    }

    /**
     * Greedily process the char sequence and try to find an emoji at the
     * specified index.
     *
     * The first time this static method is called, the parse trie will be initialized.
     */
    @JvmStatic
    fun parseAt(charSequence: CharSequence, index: Int): ParseResult? {
        var lastFound: ParseResult? = null

        // Process codepoints
        val codepoints = mutableListOf<Int>()
        var i = 0
        while (true) {
            val codepoint: Int
            try {
                codepoint = Character.codePointAt(charSequence, index + i)
                codepoints.add(codepoint)
            } catch (_: IndexOutOfBoundsException) {
                // We're at the end of the char sequence
                return lastFound
            }
            val value = trie.get(codepoints)
            if (value == null) {
                // Unknown path
                return lastFound
            }
            if (value.value != null) {
                // This is a valid path
                lastFound = value.value
            }
            if (value.isLeaf) {
                // We're done!
                return lastFound
            }
            i += Character.charCount(codepoint)
        }
    }

    data class ParseResult(
        @JvmField val length: Int,
        @JvmField val coords: SpriteCoordinates,
    )
}
