/*  _____ _
 * |_   _| |_  _ _ ___ ___ _ __  __ _
 *   | | | ' \| '_/ -_) -_) '  \/ _` |_
 *   |_| |_||_|_| \___\___|_|_|_\__,_(_)
 *
 * Threema for Android
 * Copyright (c) 2017-2025 Threema GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package ch.threema.app.emojis;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import ch.threema.app.collections.IntTrie;

/**
 * Emoji parser.
 * <p>
 * Generated by Threema emoji-tools.
 */
public class EmojiParser {

    public static class ParseResult {
        @NonNull
        public final Integer length;
        @NonNull
        public final SpriteCoordinates coords;

        ParseResult(@NonNull Integer length, @NonNull SpriteCoordinates coords) {
            this.length = length;
            this.coords = coords;
        }
    }

    // The trie that stores emoji parse results at the end of a path of codepoints.
    private static IntTrie<ParseResult> trie = null;

    private EmojiParser() {
        // Static, do not instantiate
    }

    private synchronized static void init() {
        if (EmojiParser.trie != null) {
            // Already initialized
            return;
        }

        // Initialize parse trie
        EmojiParser.trie = new IntTrie<>();
        EmojiParser.init1(EmojiParser.trie);
        EmojiParser.init2(EmojiParser.trie);
        EmojiParser.init3(EmojiParser.trie);
        EmojiParser.init4(EmojiParser.trie);
        EmojiParser.init5(EmojiParser.trie);
        EmojiParser.init6(EmojiParser.trie);
        EmojiParser.init7(EmojiParser.trie);
        EmojiParser.init8(EmojiParser.trie);
        EmojiParser.init9(EmojiParser.trie);
        EmojiParser.init10(EmojiParser.trie);
        EmojiParser.init11(EmojiParser.trie);
        EmojiParser.init12(EmojiParser.trie);
        EmojiParser.init13(EmojiParser.trie);
    }


    public static void init1(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{128512}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 265))); // grinning face
        trie.insert(new int[]{128516}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 199))); // grinning face with smiling eyes
        trie.insert(new int[]{128518}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 133))); // grinning squinting face
        trie.insert(new int[]{129315}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 265))); // rolling on the floor laughing
        trie.insert(new int[]{128578}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 331))); // slightly smiling face
        trie.insert(new int[]{129760}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 133))); // melting face
        trie.insert(new int[]{128522}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 67))); // smiling face with smiling eyes
        trie.insert(new int[]{129392}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 1))); // smiling face with hearts
        trie.insert(new int[]{129321}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 265))); // star-struck
        trie.insert(new int[]{128535}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 463))); // kissing face
        trie.insert(new int[]{128538}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 463))); // kissing face with closed eyes
        trie.insert(new int[]{129394}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 199))); // smiling face with tear
        trie.insert(new int[]{128539}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 463))); // face with tongue
        trie.insert(new int[]{129322}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 265))); // zany face
        trie.insert(new int[]{129297}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 331))); // money-mouth face
        trie.insert(new int[]{129325}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 133))); // face with hand over mouth
        trie.insert(new int[]{129763}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 67))); // face with peeking eye
        trie.insert(new int[]{129300}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 199))); // thinking face
        trie.insert(new int[]{129296}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 331))); // zipper-mouth face
        trie.insert(new int[]{128528}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 463))); // neutral face
        trie.insert(new int[]{128566}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 397))); // face without mouth
        trie.insert(new int[]{128566, 8205, 127787, 65039}, new ParseResult(6, new SpriteCoordinates(1, 0, 67, 397))); // face in clouds
        trie.insert(new int[]{128566, 8205, 127787}, new ParseResult(5, new SpriteCoordinates(1, 0, 67, 397))); // face in clouds
        trie.insert(new int[]{128530}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 463))); // unamused face
        trie.insert(new int[]{128556}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 1))); // grimacing face
        trie.insert(new int[]{129317}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 265))); // lying face
        trie.insert(new int[]{128578, 8205, 8596, 65039}, new ParseResult(5, new SpriteCoordinates(1, 0, 397, 1))); // head shaking horizontally
        trie.insert(new int[]{128578, 8205, 8596}, new ParseResult(4, new SpriteCoordinates(1, 0, 397, 1))); // head shaking horizontally
        trie.insert(new int[]{128524}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 1))); // relieved face
        trie.insert(new int[]{128554}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 67))); // sleepy face
        trie.insert(new int[]{128564}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 397))); // sleeping face
        trie.insert(new int[]{129298}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 265))); // face with thermometer
        trie.insert(new int[]{129314}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 1))); // nauseated face
        trie.insert(new int[]{129319}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 265))); // sneezing face
        trie.insert(new int[]{129398}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 199))); // cold face
        trie.insert(new int[]{128565}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 397))); // face with crossed-out eyes
        trie.insert(new int[]{129327}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 67))); // exploding head
        trie.insert(new int[]{129395}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 199))); // partying face
        trie.insert(new int[]{128526}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 463))); // smiling face with sunglasses
        trie.insert(new int[]{129488}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 67))); // face with monocle
        trie.insert(new int[]{129764}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 1))); // face with diagonal mouth
        trie.insert(new int[]{128577}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 67))); // slightly frowning face
        trie.insert(new int[]{128558}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 397))); // face with open mouth
        trie.insert(new int[]{128562}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 397))); // astonished face
        trie.insert(new int[]{129402}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 133))); // pleading face
        trie.insert(new int[]{128550}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 265))); // frowning face with open mouth
        trie.insert(new int[]{128552}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 199))); // fearful face
        trie.insert(new int[]{128549}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 331))); // sad but relieved face
        trie.insert(new int[]{128557}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 397))); // loudly crying face
        trie.insert(new int[]{128534}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 463))); // confounded face
        trie.insert(new int[]{128542}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 463))); // disappointed face
        trie.insert(new int[]{128553}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 133))); // weary face
        trie.insert(new int[]{129393}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 199))); // yawning face
        trie.insert(new int[]{128545}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 397))); // enraged face
        trie.insert(new int[]{129324}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 199))); // face with symbols on mouth
        trie.insert(new int[]{128127}, new ParseResult(2, new SpriteCoordinates(1, 0, 595, 1))); // angry face with horns
        trie.insert(new int[]{9760, 65039}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 67))); // skull and crossbones
        trie.insert(new int[]{9760}, new ParseResult(1, new SpriteCoordinates(1, 0, 67, 67))); // skull and crossbones
        trie.insert(new int[]{129313}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 67))); // clown face
        trie.insert(new int[]{128122}, new ParseResult(2, new SpriteCoordinates(1, 0, 595, 133))); // goblin
        trie.insert(new int[]{128125}, new ParseResult(2, new SpriteCoordinates(1, 0, 595, 67))); // alien
        trie.insert(new int[]{129302}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 133))); // robot
        trie.insert(new int[]{128568}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 331))); // grinning cat with smiling eyes
        trie.insert(new int[]{128571}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 265))); // smiling cat with heart-eyes
        trie.insert(new int[]{128573}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 199))); // kissing cat
        trie.insert(new int[]{128575}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 133))); // crying cat
        trie.insert(new int[]{128584}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 331))); // see-no-evil monkey
        trie.insert(new int[]{128586}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 331))); // speak-no-evil monkey
        trie.insert(new int[]{128152}, new ParseResult(2, new SpriteCoordinates(1, 0, 265, 529))); // heart with arrow
        trie.insert(new int[]{128150}, new ParseResult(2, new SpriteCoordinates(1, 0, 331, 529))); // sparkling heart
        trie.insert(new int[]{128147}, new ParseResult(2, new SpriteCoordinates(1, 0, 463, 529))); // beating heart
        trie.insert(new int[]{128149}, new ParseResult(2, new SpriteCoordinates(1, 0, 397, 529))); // two hearts
        trie.insert(new int[]{10083}, new ParseResult(1, new SpriteCoordinates(1, 0, 1, 67))); // heart exclamation
        trie.insert(new int[]{10083, 65039}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 67))); // heart exclamation
        trie.insert(new int[]{10084, 65039, 8205, 128293}, new ParseResult(5, new SpriteCoordinates(1, 0, 67, 1))); // heart on fire
        trie.insert(new int[]{10084, 8205, 128293}, new ParseResult(4, new SpriteCoordinates(1, 0, 67, 1))); // heart on fire
        trie.insert(new int[]{10084, 65039}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 1))); // red heart
        trie.insert(new int[]{10084}, new ParseResult(1, new SpriteCoordinates(1, 0, 1, 1))); // red heart
        trie.insert(new int[]{129505}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 1))); // orange heart
        trie.insert(new int[]{128154}, new ParseResult(2, new SpriteCoordinates(1, 0, 199, 529))); // green heart
        trie.insert(new int[]{129653}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 133))); // light blue heart
        trie.insert(new int[]{129294}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 331))); // brown heart
        trie.insert(new int[]{129654}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 133))); // grey heart
        trie.insert(new int[]{128139}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 529))); // kiss mark
        trie.insert(new int[]{128162}, new ParseResult(2, new SpriteCoordinates(1, 0, 133, 529))); // anger symbol
        trie.insert(new int[]{128171}, new ParseResult(2, new SpriteCoordinates(1, 0, 1, 529))); // dizzy
        trie.insert(new int[]{128168}, new ParseResult(2, new SpriteCoordinates(1, 0, 67, 529))); // dashing away
        trie.insert(new int[]{128172}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 463))); // speech balloon
        trie.insert(new int[]{128488}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 331))); // left speech bubble
        trie.insert(new int[]{128488, 65039}, new ParseResult(3, new SpriteCoordinates(1, 0, 529, 331))); // left speech bubble
        trie.insert(new int[]{128173}, new ParseResult(2, new SpriteCoordinates(1, 0, 529, 397))); // thought balloon
        trie.insert(new int[]{128515}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 463))); // grinning face with big eyes
        trie.insert(new int[]{128513}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 463))); // beaming face with smiling eyes
        trie.insert(new int[]{128517}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 463))); // grinning face with sweat
        trie.insert(new int[]{128514}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 463))); // face with tears of joy
        trie.insert(new int[]{128579}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 265))); // upside-down face
        trie.insert(new int[]{128521}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 397))); // winking face
        trie.insert(new int[]{128519}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 463))); // smiling face with halo
        trie.insert(new int[]{128525}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 265))); // smiling face with heart-eyes
        trie.insert(new int[]{128536}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 397))); // face blowing a kiss
        trie.insert(new int[]{9786}, new ParseResult(1, new SpriteCoordinates(1, 1, 67, 1))); // smiling face
        trie.insert(new int[]{9786, 65039}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 1))); // smiling face
        trie.insert(new int[]{128537}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 397))); // kissing face with smiling eyes
        trie.insert(new int[]{128523}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 331))); // face savoring food
        trie.insert(new int[]{128540}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 397))); // winking face with tongue
        trie.insert(new int[]{128541}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 397))); // squinting face with tongue
        trie.insert(new int[]{129303}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 67))); // smiling face with open hands
        trie.insert(new int[]{129762}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 67))); // face with open eyes and hand over mouth
        trie.insert(new int[]{129323}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 199))); // shushing face
        trie.insert(new int[]{129761}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 133))); // saluting face
        trie.insert(new int[]{129320}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 199))); // face with raised eyebrow
        trie.insert(new int[]{128529}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 133))); // expressionless face
        trie.insert(new int[]{129765}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 1))); // dotted line face
        trie.insert(new int[]{128527}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 199))); // smirking face
        trie.insert(new int[]{128580}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 265))); // face with rolling eyes
        trie.insert(new int[]{128558, 8205, 128168}, new ParseResult(5, new SpriteCoordinates(1, 1, 397, 1))); // face exhaling
        trie.insert(new int[]{129768}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 67))); // shaking face
        trie.insert(new int[]{128578, 8205, 8597, 65039}, new ParseResult(5, new SpriteCoordinates(1, 1, 265, 265))); // head shaking vertically
        trie.insert(new int[]{128578, 8205, 8597}, new ParseResult(4, new SpriteCoordinates(1, 1, 265, 265))); // head shaking vertically
        trie.insert(new int[]{128532}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 1))); // pensive face
        trie.insert(new int[]{129316}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 199))); // drooling face
        trie.insert(new int[]{128567}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 331))); // face with medical mask
        trie.insert(new int[]{129301}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 133))); // face with head-bandage
        trie.insert(new int[]{129326}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 199))); // face vomiting
        trie.insert(new int[]{129397}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 67))); // hot face
        trie.insert(new int[]{129396}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 133))); // woozy face
        trie.insert(new int[]{128565, 8205, 128171}, new ParseResult(5, new SpriteCoordinates(1, 1, 67, 331))); // face with spiral eyes
        trie.insert(new int[]{129312}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 1))); // cowboy hat face
        trie.insert(new int[]{129400}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 1))); // disguised face
        trie.insert(new int[]{129299}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 199))); // nerd face
        trie.insert(new int[]{128533}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 397))); // confused face
        trie.insert(new int[]{128543}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 397))); // worried face
        trie.insert(new int[]{9785, 65039}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 67))); // frowning face
        trie.insert(new int[]{9785}, new ParseResult(1, new SpriteCoordinates(1, 1, 1, 67))); // frowning face
        trie.insert(new int[]{128559}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 331))); // hushed face
        trie.insert(new int[]{128563}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 331))); // flushed face
        trie.insert(new int[]{129401}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 133))); // face holding back tears
        trie.insert(new int[]{128551}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 133))); // anguished face
        trie.insert(new int[]{128560}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 331))); // anxious face with sweat
        trie.insert(new int[]{128546}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 331))); // crying face
        trie.insert(new int[]{128561}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 331))); // face screaming in fear
        trie.insert(new int[]{128547}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 265))); // persevering face
        trie.insert(new int[]{128531}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 67))); // downcast face with sweat
        trie.insert(new int[]{128555}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 67))); // tired face
        trie.insert(new int[]{128548}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 199))); // face with steam from nose
        trie.insert(new int[]{128544}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 397))); // angry face
        trie.insert(new int[]{128520}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 463))); // smiling face with horns
        trie.insert(new int[]{128128}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 529))); // skull
        trie.insert(new int[]{128169}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 133))); // pile of poo
        trie.insert(new int[]{128121}, new ParseResult(2, new SpriteCoordinates(1, 1, 595, 67))); // ogre
        trie.insert(new int[]{128123}, new ParseResult(2, new SpriteCoordinates(1, 1, 595, 1))); // ghost
        trie.insert(new int[]{128126}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 529))); // alien monster
        trie.insert(new int[]{128570}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 199))); // grinning cat
        trie.insert(new int[]{128569}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 265))); // cat with tears of joy
        trie.insert(new int[]{128572}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 133))); // cat with wry smile
        trie.insert(new int[]{128576}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 1))); // weary cat
        trie.insert(new int[]{128574}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 67))); // pouting cat
        trie.insert(new int[]{128585}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 265))); // hear-no-evil monkey
        trie.insert(new int[]{128140}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 529))); // love letter
        trie.insert(new int[]{128157}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 529))); // heart with ribbon
        trie.insert(new int[]{128151}, new ParseResult(2, new SpriteCoordinates(1, 1, 265, 529))); // growing heart
        trie.insert(new int[]{128158}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 463))); // revolving hearts
        trie.insert(new int[]{128159}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 397))); // heart decoration
        trie.insert(new int[]{128148}, new ParseResult(2, new SpriteCoordinates(1, 1, 331, 529))); // broken heart
        trie.insert(new int[]{10084, 65039, 8205, 129657}, new ParseResult(5, new SpriteCoordinates(1, 1, 1, 1))); // mending heart
        trie.insert(new int[]{10084, 8205, 129657}, new ParseResult(4, new SpriteCoordinates(1, 1, 1, 1))); // mending heart
        trie.insert(new int[]{129655}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 133))); // pink heart
        trie.insert(new int[]{128155}, new ParseResult(2, new SpriteCoordinates(1, 1, 133, 529))); // yellow heart
        trie.insert(new int[]{128153}, new ParseResult(2, new SpriteCoordinates(1, 1, 199, 529))); // blue heart
        trie.insert(new int[]{128156}, new ParseResult(2, new SpriteCoordinates(1, 1, 67, 529))); // purple heart
        trie.insert(new int[]{128420}, new ParseResult(2, new SpriteCoordinates(1, 1, 463, 463))); // black heart
        trie.insert(new int[]{129293}, new ParseResult(2, new SpriteCoordinates(1, 1, 1, 265))); // white heart
        trie.insert(new int[]{128175}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 67))); // hundred points
        trie.insert(new int[]{128165}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 265))); // collision
        trie.insert(new int[]{128166}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 199))); // sweat droplets
        trie.insert(new int[]{128371, 65039}, new ParseResult(3, new SpriteCoordinates(1, 1, 529, 1))); // hole
        trie.insert(new int[]{128371}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 1))); // hole
        trie.insert(new int[]{128065, 8205, 128488}, new ParseResult(5, new SpriteCoordinates(1, 1, 595, 133))); // eye in speech bubble
        trie.insert(new int[]{128065, 65039, 8205, 128488}, new ParseResult(6, new SpriteCoordinates(1, 1, 595, 133))); // eye in speech bubble
        trie.insert(new int[]{128065, 8205, 128488, 65039}, new ParseResult(6, new SpriteCoordinates(1, 1, 595, 133))); // eye in speech bubble
        trie.insert(new int[]{128065, 65039, 8205, 128488, 65039}, new ParseResult(7, new SpriteCoordinates(1, 1, 595, 133))); // eye in speech bubble
        trie.insert(new int[]{128495, 65039}, new ParseResult(3, new SpriteCoordinates(1, 1, 397, 463))); // right anger bubble
        trie.insert(new int[]{128495}, new ParseResult(2, new SpriteCoordinates(1, 1, 397, 463))); // right anger bubble
        trie.insert(new int[]{128164}, new ParseResult(2, new SpriteCoordinates(1, 1, 529, 331))); // ZZZ
        trie.insert(new int[]{128075}, new ParseResult(2, new SpriteCoordinates(2, 0, 661, 859))); // waving hand
        trie.insert(new int[]{129306, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 397))); // raised back of hand: dark skin tone
        trie.insert(new int[]{9995, 127998}, new ParseResult(3, new SpriteCoordinates(2, 0, 1, 67))); // raised hand: medium-dark skin tone
        trie.insert(new int[]{129777, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 199, 67))); // rightwards hand: medium skin tone
        trie.insert(new int[]{129779, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 133, 133))); // palm down hand: medium-light skin tone
        trie.insert(new int[]{129783, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 67, 133))); // leftwards pushing hand: light skin tone
        trie.insert(new int[]{128076}, new ParseResult(2, new SpriteCoordinates(2, 0, 595, 859))); // OK hand
        trie.insert(new int[]{129292, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 529))); // pinched fingers: dark skin tone
        trie.insert(new int[]{9996, 127998}, new ParseResult(3, new SpriteCoordinates(2, 0, 67, 1))); // victory hand: medium-dark skin tone
        trie.insert(new int[]{129776, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 1, 199))); // hand with index finger and thumb crossed: medium skin tone
        trie.insert(new int[]{129304, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 463))); // sign of the horns: medium-light skin tone
        trie.insert(new int[]{128072, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 859))); // backhand index pointing left: light skin tone
        trie.insert(new int[]{128070}, new ParseResult(2, new SpriteCoordinates(2, 0, 793, 859))); // backhand index pointing up
        trie.insert(new int[]{128405, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 661, 595))); // middle finger: dark skin tone
        trie.insert(new int[]{9757, 127998}, new ParseResult(3, new SpriteCoordinates(2, 0, 1, 133))); // index pointing up: medium-dark skin tone
        trie.insert(new int[]{128077, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 529, 859))); // thumbs up: medium skin tone
        trie.insert(new int[]{9994, 127996}, new ParseResult(3, new SpriteCoordinates(2, 0, 67, 67))); // raised fist: medium-light skin tone
        trie.insert(new int[]{129307, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 331))); // left-facing fist: light skin tone
        trie.insert(new int[]{128079}, new ParseResult(2, new SpriteCoordinates(2, 0, 463, 859))); // clapping hands
        trie.insert(new int[]{128588, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 661, 199))); // raising hands: dark skin tone
        trie.insert(new int[]{128080, 127998}, new ParseResult(4, new SpriteCoordinates(2, 0, 397, 859))); // open hands: medium-dark skin tone
        trie.insert(new int[]{129309, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 265))); // handshake: medium skin tone
        trie.insert(new int[]{129777, 127997, 8205, 129778, 127995}, new ParseResult(9, new SpriteCoordinates(2, 0, 199, 133))); // handshake: medium skin tone, light skin tone
        trie.insert(new int[]{129777, 127999, 8205, 129778, 127998}, new ParseResult(9, new SpriteCoordinates(2, 0, 199, 1))); // handshake: dark skin tone, medium-dark skin tone
        trie.insert(new int[]{9997, 127998}, new ParseResult(3, new SpriteCoordinates(2, 0, 1, 1))); // writing hand: medium-dark skin tone
        trie.insert(new int[]{129331, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 1))); // selfie: medium skin tone
        trie.insert(new int[]{129461}, new ParseResult(2, new SpriteCoordinates(2, 0, 529, 265))); // leg
        trie.insert(new int[]{129462, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 529, 199))); // foot: dark skin tone
        trie.insert(new int[]{129467, 127998}, new ParseResult(4, new SpriteCoordinates(2, 0, 397, 463))); // ear with hearing aid: medium-dark skin tone
        trie.insert(new int[]{129463}, new ParseResult(2, new SpriteCoordinates(2, 0, 529, 133))); // tooth
        trie.insert(new int[]{128118, 127998}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 265))); // baby: medium-dark skin tone
        trie.insert(new int[]{128102, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 331, 859))); // boy: medium skin tone
        trie.insert(new int[]{129489, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 265, 397))); // person: medium-light skin tone
        trie.insert(new int[]{128104, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 859, 793))); // man: light skin tone
        trie.insert(new int[]{129492, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 331, 199))); // man: beard
        trie.insert(new int[]{129492, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 331, 199))); // man: beard
        trie.insert(new int[]{129492, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 331, 265))); // woman: dark skin tone, beard
        trie.insert(new int[]{129492, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 265))); // woman: dark skin tone, beard
        trie.insert(new int[]{128104, 127998, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 133))); // man: medium-dark skin tone, curly hair
        trie.insert(new int[]{128104, 127997, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 331))); // man: medium skin tone, bald
        trie.insert(new int[]{128105, 127996, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 0, 793, 529))); // woman: medium-light skin tone, red hair
        trie.insert(new int[]{128105, 127995, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 0, 67, 793))); // woman: light skin tone, curly hair
        trie.insert(new int[]{128105, 8205, 129459}, new ParseResult(5, new SpriteCoordinates(2, 0, 331, 727))); // woman: white hair
        trie.insert(new int[]{129489, 127999, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 0, 397, 1))); // person: dark skin tone, white hair
        trie.insert(new int[]{129489, 127998, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 0, 397, 265))); // person: medium-dark skin tone, bald
        trie.insert(new int[]{128113, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 727, 529))); // man: medium skin tone, blond hair
        trie.insert(new int[]{128113, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 727, 529))); // man: medium skin tone, blond hair
        trie.insert(new int[]{128116, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 331))); // old man: medium-light skin tone
        trie.insert(new int[]{128589, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 661, 133))); // person frowning: light skin tone
        trie.insert(new int[]{128589, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 0, 661, 67))); // woman frowning
        trie.insert(new int[]{128589, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 661, 67))); // woman frowning
        trie.insert(new int[]{128590, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 595))); // person pouting: dark skin tone
        trie.insert(new int[]{128590, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 661, 1))); // woman pouting: medium-dark skin tone
        trie.insert(new int[]{128590, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 661, 1))); // woman pouting: medium-dark skin tone
        trie.insert(new int[]{128581, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 661, 529))); // man gesturing NO: medium skin tone
        trie.insert(new int[]{128581, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 661, 529))); // man gesturing NO: medium skin tone
        trie.insert(new int[]{128582, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 661, 397))); // person gesturing OK: medium-light skin tone
        trie.insert(new int[]{128582, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 661, 463))); // woman gesturing OK: light skin tone
        trie.insert(new int[]{128582, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 661, 463))); // woman gesturing OK: light skin tone
        trie.insert(new int[]{128129, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 595, 661))); // man tipping hand
        trie.insert(new int[]{128129, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 661))); // man tipping hand
        trie.insert(new int[]{128129, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 661, 661))); // woman tipping hand: dark skin tone
        trie.insert(new int[]{128129, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 661, 661))); // woman tipping hand: dark skin tone
        trie.insert(new int[]{128587, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 661, 265))); // man raising hand: medium-dark skin tone
        trie.insert(new int[]{128587, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 661, 265))); // man raising hand: medium-dark skin tone
        trie.insert(new int[]{129487, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 463, 397))); // deaf person: medium skin tone
        trie.insert(new int[]{129487, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 1, 463))); // deaf woman: medium-light skin tone
        trie.insert(new int[]{129487, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 1, 463))); // deaf woman: medium-light skin tone
        trie.insert(new int[]{128583, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 661, 331))); // man bowing: light skin tone
        trie.insert(new int[]{128583, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 661, 331))); // man bowing: light skin tone
        trie.insert(new int[]{129318}, new ParseResult(2, new SpriteCoordinates(2, 0, 595, 133))); // person facepalming
        trie.insert(new int[]{129318, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 595, 199))); // man facepalming: dark skin tone
        trie.insert(new int[]{129318, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 595, 199))); // man facepalming: dark skin tone
        trie.insert(new int[]{129335, 127998}, new ParseResult(4, new SpriteCoordinates(2, 0, 331, 529))); // person shrugging: medium-dark skin tone
        trie.insert(new int[]{129335, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 397, 529))); // woman shrugging: medium skin tone
        trie.insert(new int[]{129335, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 397, 529))); // woman shrugging: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 595))); // man health worker: medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 0, 859, 595))); // man health worker: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 0, 463, 331))); // student: light skin tone
        trie.insert(new int[]{128105, 8205, 127891}, new ParseResult(5, new SpriteCoordinates(2, 0, 463, 793))); // woman student
        trie.insert(new int[]{129489, 127999, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 0, 397, 133))); // teacher: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 0, 793, 1))); // woman teacher: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 265))); // man judge: medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 0, 859, 265))); // man judge: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 0, 463, 67))); // farmer: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 793))); // woman farmer: light skin tone
        trie.insert(new int[]{128104, 8205, 127859}, new ParseResult(5, new SpriteCoordinates(2, 0, 265, 859))); // man cook
        trie.insert(new int[]{128105, 127999, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 0, 529, 727))); // woman cook: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 199))); // man mechanic: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 0, 199, 397))); // factory worker: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 0, 793, 661))); // woman factory worker: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 0, 133, 859))); // man office worker: light skin tone
        trie.insert(new int[]{129489, 8205, 128300}, new ParseResult(5, new SpriteCoordinates(2, 0, 133, 331))); // scientist
        trie.insert(new int[]{128104, 127999, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 0, 793, 793))); // man scientist: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 0, 397, 331))); // technologist: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 0, 793, 331))); // woman technologist: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 727))); // man singer: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 0, 463, 265))); // artist: light skin tone
        trie.insert(new int[]{128105, 8205, 127912}, new ParseResult(5, new SpriteCoordinates(2, 0, 397, 793))); // woman artist
        trie.insert(new int[]{129489, 127999, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 0, 265, 331))); // pilot: dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 331))); // pilot: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 0, 727, 727))); // woman pilot: medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 727, 727))); // woman pilot: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 463))); // man astronaut: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 0, 463, 1))); // firefighter: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 793))); // woman firefighter: light skin tone
        trie.insert(new int[]{128110, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 1, 727))); // man police officer
        trie.insert(new int[]{128110, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 1, 727))); // man police officer
        trie.insert(new int[]{128110, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 67, 727))); // woman police officer: dark skin tone
        trie.insert(new int[]{128110, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 67, 727))); // woman police officer: dark skin tone
        trie.insert(new int[]{128373, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 1, 661))); // man detective: medium-dark skin tone
        trie.insert(new int[]{128373, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 1, 661))); // man detective: medium-dark skin tone
        trie.insert(new int[]{128130, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 463, 661))); // guard: medium skin tone
        trie.insert(new int[]{128130, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 529, 661))); // woman guard: medium-light skin tone
        trie.insert(new int[]{128130, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 529, 661))); // woman guard: medium-light skin tone
        trie.insert(new int[]{128119, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 199))); // construction worker: light skin tone
        trie.insert(new int[]{128119, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 133))); // woman construction worker
        trie.insert(new int[]{128119, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 727, 133))); // woman construction worker
        trie.insert(new int[]{129733, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 67, 199))); // person with crown: dark skin tone
        trie.insert(new int[]{128120, 127998}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 67))); // princess: medium-dark skin tone
        trie.insert(new int[]{128115, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 727, 397))); // man wearing turban: medium skin tone
        trie.insert(new int[]{128115, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 727, 397))); // man wearing turban: medium skin tone
        trie.insert(new int[]{128114, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 463))); // person with skullcap: medium-light skin tone
        trie.insert(new int[]{129333, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 529, 529))); // person in tuxedo: light skin tone
        trie.insert(new int[]{129333, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 463, 529))); // woman in tuxedo
        trie.insert(new int[]{129333, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 0, 463, 529))); // woman in tuxedo
        trie.insert(new int[]{128112, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 727, 595))); // person with veil: dark skin tone
        trie.insert(new int[]{128112, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 727, 661))); // woman with veil: medium-dark skin tone
        trie.insert(new int[]{128112, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 727, 661))); // woman with veil: medium-dark skin tone
        trie.insert(new int[]{129731, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 133, 199))); // pregnant man: medium skin tone
        trie.insert(new int[]{129329, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 595, 67))); // breast-feeding: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 0, 199, 859))); // man feeding baby: light skin tone
        trie.insert(new int[]{128124}, new ParseResult(2, new SpriteCoordinates(2, 0, 727, 1))); // baby angel
        trie.insert(new int[]{127877, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 925, 595))); // Santa Claus: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127876}, new ParseResult(7, new SpriteCoordinates(2, 0, 1, 397))); // mx claus: medium-dark skin tone
        trie.insert(new int[]{129464, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 529, 67))); // man superhero: medium skin tone
        trie.insert(new int[]{129464, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 529, 67))); // man superhero: medium skin tone
        trie.insert(new int[]{129465, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 463, 463))); // supervillain: medium-light skin tone
        trie.insert(new int[]{129465, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 529, 1))); // woman supervillain: light skin tone
        trie.insert(new int[]{129465, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 529, 1))); // woman supervillain: light skin tone
        trie.insert(new int[]{129497, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 133, 265))); // man mage
        trie.insert(new int[]{129497, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 133, 265))); // man mage
        trie.insert(new int[]{129497, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 199, 265))); // woman mage: dark skin tone
        trie.insert(new int[]{129497, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 199, 265))); // woman mage: dark skin tone
        trie.insert(new int[]{129498, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 67, 265))); // man fairy: medium-dark skin tone
        trie.insert(new int[]{129498, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 67, 265))); // man fairy: medium-dark skin tone
        trie.insert(new int[]{129499, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 265, 199))); // vampire: medium skin tone
        trie.insert(new int[]{129499, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 1, 265))); // woman vampire: medium-light skin tone
        trie.insert(new int[]{129499, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 1, 265))); // woman vampire: medium-light skin tone
        trie.insert(new int[]{129500, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 133))); // merman: light skin tone
        trie.insert(new int[]{129500, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 265, 133))); // merman: light skin tone
        trie.insert(new int[]{129501}, new ParseResult(2, new SpriteCoordinates(2, 0, 265, 1))); // elf
        trie.insert(new int[]{129501, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 265, 67))); // man elf: dark skin tone
        trie.insert(new int[]{129501, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 67))); // man elf: dark skin tone
        trie.insert(new int[]{129503, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 199, 199))); // man zombie
        trie.insert(new int[]{129503, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 199, 199))); // man zombie
        trie.insert(new int[]{128134, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 331, 661))); // man getting massage: medium-light skin tone
        trie.insert(new int[]{128134, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 661))); // man getting massage: medium-light skin tone
        trie.insert(new int[]{128135, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 265, 661))); // person getting haircut: light skin tone
        trie.insert(new int[]{128135, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 0, 199, 661))); // woman getting haircut
        trie.insert(new int[]{128135, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 199, 661))); // woman getting haircut
        trie.insert(new int[]{128694, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 67, 595))); // person walking: dark skin tone
        trie.insert(new int[]{128694, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 133, 595))); // woman walking: medium-dark skin tone
        trie.insert(new int[]{128694, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 133, 595))); // woman walking: medium-dark skin tone
        trie.insert(new int[]{128694, 127997, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 0, 199, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 199, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 199, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 0, 199, 595))); // woman walking facing right
        trie.insert(new int[]{129485, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 265, 463))); // person standing: medium-light skin tone
        trie.insert(new int[]{129485, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 463))); // woman standing: light skin tone
        trie.insert(new int[]{129485, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 331, 463))); // woman standing: light skin tone
        trie.insert(new int[]{129486, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 67, 463))); // man kneeling
        trie.insert(new int[]{129486, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 67, 463))); // man kneeling
        trie.insert(new int[]{129486, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 133, 463))); // woman kneeling: dark skin tone
        trie.insert(new int[]{129486, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 133, 463))); // woman kneeling: dark skin tone
        trie.insert(new int[]{129486, 127998, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 0, 199, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 0, 199, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 199, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 199, 463))); // woman kneeling facing right
    }

    public static void init2(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{129489, 127997, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 0, 67, 397))); // person with white cane: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 661))); // man with white cane: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 0, 133, 793))); // woman with white cane: light skin tone
        trie.insert(new int[]{129489, 8205, 129468}, new ParseResult(5, new SpriteCoordinates(2, 0, 67, 331))); // person in motorized wheelchair
        trie.insert(new int[]{129489, 127999, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 331, 331))); // person in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127999, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 331, 331))); // person in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127998, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 859, 67))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127998, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 859, 67))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127997, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 793, 199))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127997, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 793, 199))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127996, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 397, 397))); // person in manual wheelchair facing right
        trie.insert(new int[]{129489, 127996, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 397, 397))); // person in manual wheelchair facing right
        trie.insert(new int[]{128104, 127995, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 67, 859))); // man in manual wheelchair facing right
        trie.insert(new int[]{128104, 127995, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 67, 859))); // man in manual wheelchair facing right
        trie.insert(new int[]{128105, 8205, 129469, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{128105, 8205, 129469, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 0, 265, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{127939, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 925, 331))); // person running: dark skin tone
        trie.insert(new int[]{127939, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 925, 397))); // woman running: medium-dark skin tone
        trie.insert(new int[]{127939, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 925, 397))); // woman running: medium-dark skin tone
        trie.insert(new int[]{127939, 127997, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 0, 925, 463))); // woman running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 0, 925, 463))); // woman running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 0, 925, 463))); // woman running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 0, 925, 463))); // woman running facing right
        trie.insert(new int[]{128131, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 397, 661))); // woman dancing: medium-light skin tone
        trie.insert(new int[]{128372, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 67, 661))); // person in suit levitating: light skin tone
        trie.insert(new int[]{129494, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 331, 67))); // person in steamy room: medium skin tone
        trie.insert(new int[]{129494, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 331, 133))); // woman in steamy room: medium-light skin tone
        trie.insert(new int[]{129494, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 133))); // woman in steamy room: medium-light skin tone
        trie.insert(new int[]{129495, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 331, 1))); // man climbing: light skin tone
        trie.insert(new int[]{129495, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 1))); // man climbing: light skin tone
        trie.insert(new int[]{129338}, new ParseResult(2, new SpriteCoordinates(2, 0, 67, 529))); // person fencing
        trie.insert(new int[]{127938, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 925, 529))); // snowboarder: medium skin tone
        trie.insert(new int[]{127948, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 859, 859))); // man golfing: medium-light skin tone
        trie.insert(new int[]{127948, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 859, 859))); // man golfing: medium-light skin tone
        trie.insert(new int[]{127940, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 925, 265))); // person surfing: light skin tone
        trie.insert(new int[]{127940, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 925, 199))); // woman surfing
        trie.insert(new int[]{127940, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 0, 925, 199))); // woman surfing
        trie.insert(new int[]{128675, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 463, 595))); // person rowing boat: dark skin tone
        trie.insert(new int[]{128675, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 529, 595))); // woman rowing boat: medium-dark skin tone
        trie.insert(new int[]{128675, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 529, 595))); // woman rowing boat: medium-dark skin tone
        trie.insert(new int[]{127946, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 925, 133))); // man swimming: medium skin tone
        trie.insert(new int[]{127946, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 925, 133))); // man swimming: medium skin tone
        trie.insert(new int[]{9977, 127996}, new ParseResult(3, new SpriteCoordinates(2, 0, 133, 1))); // person bouncing ball: medium-light skin tone
        trie.insert(new int[]{9977, 127995, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 0, 133, 67))); // woman bouncing ball: light skin tone
        trie.insert(new int[]{9977, 127995, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 0, 133, 67))); // woman bouncing ball: light skin tone
        trie.insert(new int[]{127947, 65039, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 0, 925, 1))); // man lifting weights
        trie.insert(new int[]{127947, 65039, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 0, 925, 1))); // man lifting weights
        trie.insert(new int[]{127947, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 925, 1))); // man lifting weights
        trie.insert(new int[]{127947, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 0, 925, 1))); // man lifting weights
        trie.insert(new int[]{127947, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 925, 67))); // woman lifting weights: dark skin tone
        trie.insert(new int[]{127947, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 925, 67))); // woman lifting weights: dark skin tone
        trie.insert(new int[]{128692, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 397, 595))); // man biking: medium-dark skin tone
        trie.insert(new int[]{128692, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 397, 595))); // man biking: medium-dark skin tone
        trie.insert(new int[]{128693, 127997}, new ParseResult(4, new SpriteCoordinates(2, 0, 265, 595))); // person mountain biking: medium skin tone
        trie.insert(new int[]{128693, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 331, 595))); // woman mountain biking: medium-light skin tone
        trie.insert(new int[]{128693, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 331, 595))); // woman mountain biking: medium-light skin tone
        trie.insert(new int[]{129336, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 529))); // man cartwheeling: light skin tone
        trie.insert(new int[]{129336, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 265, 529))); // man cartwheeling: light skin tone
        trie.insert(new int[]{129340}, new ParseResult(2, new SpriteCoordinates(2, 0, 1, 529))); // people wrestling
        trie.insert(new int[]{129341, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 529, 463))); // man playing water polo: medium-light skin tone
        trie.insert(new int[]{129341, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 529, 463))); // man playing water polo: medium-light skin tone
        trie.insert(new int[]{129342, 127995}, new ParseResult(4, new SpriteCoordinates(2, 0, 529, 397))); // person playing handball: light skin tone
        trie.insert(new int[]{129342, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 0, 529, 331))); // woman playing handball
        trie.insert(new int[]{129342, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 0, 529, 331))); // woman playing handball
        trie.insert(new int[]{129337, 127999}, new ParseResult(4, new SpriteCoordinates(2, 0, 133, 529))); // person juggling: dark skin tone
        trie.insert(new int[]{129337, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 199, 529))); // woman juggling: medium-dark skin tone
        trie.insert(new int[]{129337, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 0, 199, 529))); // woman juggling: medium-dark skin tone
        trie.insert(new int[]{129496, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 0, 265, 265))); // man in lotus position: medium skin tone
        trie.insert(new int[]{129496, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 0, 265, 265))); // man in lotus position: medium skin tone
        trie.insert(new int[]{128704, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 1, 595))); // person taking bath: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129309, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 0, 463, 199))); // people holding hands: light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129309, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 0, 133, 397))); // people holding hands: medium skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 129309, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 0, 397, 67))); // people holding hands: dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 0, 793, 595))); // women holding hands: medium-light skin tone, medium skin tone
        trie.insert(new int[]{128109, 127998}, new ParseResult(4, new SpriteCoordinates(2, 0, 133, 727))); // women holding hands: medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 0, 199, 793))); // woman and man holding hands: light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 0, 793, 265))); // woman and man holding hands: medium skin tone, dark skin tone
        trie.insert(new int[]{128108}, new ParseResult(2, new SpriteCoordinates(2, 0, 199, 727))); // men holding hands
        trie.insert(new int[]{128104, 127997, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 0, 859, 397))); // men holding hands: medium skin tone, light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 0, 727, 793))); // men holding hands: dark skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127997}, new ParseResult(14, new SpriteCoordinates(2, 0, 463, 133))); // kiss: person, person, light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997}, new ParseResult(15, new SpriteCoordinates(2, 0, 463, 133))); // kiss: person, person, light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995}, new ParseResult(15, new SpriteCoordinates(2, 0, 397, 199))); // kiss: person, person, medium-dark skin tone, light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127995}, new ParseResult(14, new SpriteCoordinates(2, 0, 397, 199))); // kiss: person, person, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 0, 793, 727))); // kiss: woman, man, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 0, 793, 727))); // kiss: woman, man, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 0, 793, 67))); // kiss: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 0, 793, 67))); // kiss: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 0, 397, 727))); // kiss: woman, man, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 0, 397, 727))); // kiss: woman, man, dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 0, 859, 529))); // kiss: man, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 0, 859, 529))); // kiss: man, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 0, 661, 793))); // kiss: man, man, dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 0, 661, 793))); // kiss: man, man, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995}, new ParseResult(15, new SpriteCoordinates(2, 0, 793, 397))); // kiss: woman, woman, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127995}, new ParseResult(14, new SpriteCoordinates(2, 0, 793, 397))); // kiss: woman, woman, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996}, new ParseResult(15, new SpriteCoordinates(2, 0, 595, 727))); // kiss: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127996}, new ParseResult(14, new SpriteCoordinates(2, 0, 595, 727))); // kiss: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128145, 127996}, new ParseResult(4, new SpriteCoordinates(2, 0, 133, 661))); // couple with heart: medium-light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 0, 331, 397))); // couple with heart: person, person, medium-light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 129489, 127999}, new ParseResult(11, new SpriteCoordinates(2, 0, 331, 397))); // couple with heart: person, person, medium-light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 0, 199, 331))); // couple with heart: person, person, dark skin tone, medium skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 129489, 127997}, new ParseResult(11, new SpriteCoordinates(2, 0, 199, 331))); // couple with heart: person, person, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 0, 793, 463))); // couple with heart: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 0, 793, 463))); // couple with heart: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 0, 661, 727))); // couple with heart: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 0, 661, 727))); // couple with heart: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 0, 1, 859))); // couple with heart: man, man, light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 0, 1, 859))); // couple with heart: man, man, light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 0, 859, 1))); // couple with heart: man, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 0, 859, 1))); // couple with heart: man, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 0, 1, 793))); // couple with heart: woman, woman, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128105, 127995}, new ParseResult(11, new SpriteCoordinates(2, 0, 1, 793))); // couple with heart: woman, woman, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128105, 127996}, new ParseResult(11, new SpriteCoordinates(2, 0, 793, 133))); // couple with heart: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 0, 793, 133))); // couple with heart: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128105, 127997}, new ParseResult(11, new SpriteCoordinates(2, 0, 463, 727))); // couple with heart: woman, woman, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 0, 463, 727))); // couple with heart: woman, woman, dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 8205, 128104, 8205, 128102, 8205, 128102}, new ParseResult(11, new SpriteCoordinates(2, 0, 529, 793))); // family: man, man, boy, boy
        trie.insert(new int[]{128104, 8205, 128103, 8205, 128103}, new ParseResult(8, new SpriteCoordinates(2, 0, 595, 793))); // family: man, girl, girl
        trie.insert(new int[]{129489, 8205, 129489, 8205, 129490}, new ParseResult(8, new SpriteCoordinates(2, 0, 1, 331))); // family: adult, adult, child
        trie.insert(new int[]{128075, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 859))); // waving hand: light skin tone
        trie.insert(new int[]{128400}, new ParseResult(2, new SpriteCoordinates(2, 1, 661, 331))); // hand with fingers splayed
        trie.insert(new int[]{128400, 65039}, new ParseResult(3, new SpriteCoordinates(2, 1, 661, 331))); // hand with fingers splayed
        trie.insert(new int[]{9995, 127999}, new ParseResult(3, new SpriteCoordinates(2, 1, 1, 67))); // raised hand: dark skin tone
        trie.insert(new int[]{129777, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 199, 67))); // rightwards hand: medium-dark skin tone
        trie.insert(new int[]{129779, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 199, 1))); // palm down hand: medium skin tone
        trie.insert(new int[]{129783, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 67, 133))); // leftwards pushing hand: medium-light skin tone
        trie.insert(new int[]{128076, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 529, 859))); // OK hand: light skin tone
        trie.insert(new int[]{129295}, new ParseResult(2, new SpriteCoordinates(2, 1, 595, 133))); // pinching hand
        trie.insert(new int[]{9996, 127999}, new ParseResult(3, new SpriteCoordinates(2, 1, 67, 1))); // victory hand: dark skin tone
        trie.insert(new int[]{129776, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 1, 199))); // hand with index finger and thumb crossed: medium-dark skin tone
        trie.insert(new int[]{129304, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 67))); // sign of the horns: medium skin tone
        trie.insert(new int[]{128072, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 661, 859))); // backhand index pointing left: medium-light skin tone
        trie.insert(new int[]{128070, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 793, 859))); // backhand index pointing up: light skin tone
        trie.insert(new int[]{128071}, new ParseResult(2, new SpriteCoordinates(2, 1, 727, 859))); // backhand index pointing down
        trie.insert(new int[]{9757, 127999}, new ParseResult(3, new SpriteCoordinates(2, 1, 1, 133))); // index pointing up: dark skin tone
        trie.insert(new int[]{128077, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 859))); // thumbs up: medium-dark skin tone
        trie.insert(new int[]{9994, 127997}, new ParseResult(3, new SpriteCoordinates(2, 1, 67, 67))); // raised fist: medium skin tone
        trie.insert(new int[]{129307, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 1))); // left-facing fist: medium-light skin tone
        trie.insert(new int[]{128079, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 397, 859))); // clapping hands: light skin tone
        trie.insert(new int[]{129782}, new ParseResult(2, new SpriteCoordinates(2, 1, 133, 133))); // heart hands
        trie.insert(new int[]{128080, 127999}, new ParseResult(4, new SpriteCoordinates(2, 1, 331, 859))); // open hands: dark skin tone
        trie.insert(new int[]{129309, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 529, 529))); // handshake: medium-dark skin tone
        trie.insert(new int[]{129777, 127997, 8205, 129778, 127996}, new ParseResult(9, new SpriteCoordinates(2, 1, 199, 133))); // handshake: medium skin tone, medium-light skin tone
        trie.insert(new int[]{128591}, new ParseResult(2, new SpriteCoordinates(2, 1, 265, 595))); // folded hands
        trie.insert(new int[]{9997, 127999}, new ParseResult(3, new SpriteCoordinates(2, 1, 1, 1))); // writing hand: dark skin tone
        trie.insert(new int[]{129331, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 265, 529))); // selfie: medium-dark skin tone
        trie.insert(new int[]{129461, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 331, 463))); // leg: light skin tone
        trie.insert(new int[]{128066}, new ParseResult(2, new SpriteCoordinates(2, 1, 859, 859))); // ear
        trie.insert(new int[]{129467, 127999}, new ParseResult(4, new SpriteCoordinates(2, 1, 67, 463))); // ear with hearing aid: dark skin tone
        trie.insert(new int[]{129460}, new ParseResult(2, new SpriteCoordinates(2, 1, 397, 463))); // bone
        trie.insert(new int[]{128118, 127999}, new ParseResult(4, new SpriteCoordinates(2, 1, 727, 1))); // baby: dark skin tone
        trie.insert(new int[]{128102, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 265, 859))); // boy: medium-dark skin tone
        trie.insert(new int[]{129489, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 397, 133))); // person: medium skin tone
        trie.insert(new int[]{128104, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 859, 661))); // man: medium-light skin tone
        trie.insert(new int[]{129492, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 331, 133))); // man: light skin tone, beard
        trie.insert(new int[]{129492, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 331, 133))); // man: light skin tone, beard
        trie.insert(new int[]{128104, 8205, 129456}, new ParseResult(5, new SpriteCoordinates(2, 1, 463, 793))); // man: red hair
        trie.insert(new int[]{128104, 127999, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 1, 727, 793))); // man: dark skin tone, curly hair
        trie.insert(new int[]{128104, 127998, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 199))); // man: medium-dark skin tone, bald
        trie.insert(new int[]{128105, 127997, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 1, 793, 1))); // woman: medium skin tone, red hair
        trie.insert(new int[]{128105, 127996, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 1, 793, 265))); // woman: medium-light skin tone, curly hair
        trie.insert(new int[]{128105, 127995, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 1, 1, 793))); // woman: light skin tone, white hair
        trie.insert(new int[]{128105, 8205, 129458}, new ParseResult(5, new SpriteCoordinates(2, 1, 727, 595))); // woman: bald
        trie.insert(new int[]{129489, 127999, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 1, 67, 331))); // person: dark skin tone, bald
        trie.insert(new int[]{128113, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 727, 265))); // man: medium-dark skin tone, blond hair
        trie.insert(new int[]{128113, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 727, 265))); // man: medium-dark skin tone, blond hair
        trie.insert(new int[]{128116, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 727, 67))); // old man: medium skin tone
        trie.insert(new int[]{128589, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 595))); // person frowning: medium-light skin tone
        trie.insert(new int[]{128589, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 529, 595))); // woman frowning: light skin tone
        trie.insert(new int[]{128589, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 529, 595))); // woman frowning: light skin tone
        trie.insert(new int[]{128590, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 331, 595))); // man pouting
        trie.insert(new int[]{128590, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 331, 595))); // man pouting
        trie.insert(new int[]{128590, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 397, 595))); // woman pouting: dark skin tone
        trie.insert(new int[]{128590, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 397, 595))); // woman pouting: dark skin tone
        trie.insert(new int[]{128581, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 661, 265))); // man gesturing NO: medium-dark skin tone
        trie.insert(new int[]{128581, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 661, 265))); // man gesturing NO: medium-dark skin tone
        trie.insert(new int[]{128582, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 661, 133))); // person gesturing OK: medium skin tone
        trie.insert(new int[]{128582, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 661, 199))); // woman gesturing OK: medium-light skin tone
        trie.insert(new int[]{128582, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 661, 199))); // woman gesturing OK: medium-light skin tone
        trie.insert(new int[]{128129, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 397, 661))); // man tipping hand: light skin tone
        trie.insert(new int[]{128129, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 397, 661))); // man tipping hand: light skin tone
        trie.insert(new int[]{128587}, new ParseResult(2, new SpriteCoordinates(2, 1, 595, 595))); // person raising hand
        trie.insert(new int[]{128587, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 661, 1))); // man raising hand: dark skin tone
        trie.insert(new int[]{128587, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 661, 1))); // man raising hand: dark skin tone
        trie.insert(new int[]{129487, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 67))); // deaf person: medium-dark skin tone
        trie.insert(new int[]{129487, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 463, 133))); // deaf woman: medium skin tone
        trie.insert(new int[]{129487, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 463, 133))); // deaf woman: medium skin tone
        trie.insert(new int[]{128583, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 661, 67))); // man bowing: medium-light skin tone
        trie.insert(new int[]{128583, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 661, 67))); // man bowing: medium-light skin tone
        trie.insert(new int[]{129318, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 529))); // person facepalming: light skin tone
        trie.insert(new int[]{129318, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 397, 529))); // woman facepalming
        trie.insert(new int[]{129318, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 1, 397, 529))); // woman facepalming
        trie.insert(new int[]{129335, 127999}, new ParseResult(4, new SpriteCoordinates(2, 1, 529, 397))); // person shrugging: dark skin tone
        trie.insert(new int[]{129335, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 529, 463))); // woman shrugging: medium-dark skin tone
        trie.insert(new int[]{129335, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 529, 463))); // woman shrugging: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 1, 859, 397))); // man health worker: medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 397))); // man health worker: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 397))); // student: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 793))); // woman student: light skin tone
        trie.insert(new int[]{128104, 8205, 127979}, new ParseResult(5, new SpriteCoordinates(2, 1, 199, 859))); // man teacher
        trie.insert(new int[]{128105, 127999, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 1, 265, 727))); // woman teacher: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 1, 859, 133))); // man judge: medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 133))); // man judge: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 1, 67, 397))); // farmer: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 1, 793, 529))); // woman farmer: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 1, 133, 859))); // man cook: light skin tone
        trie.insert(new int[]{129489, 8205, 128295}, new ParseResult(5, new SpriteCoordinates(2, 1, 331, 265))); // mechanic
        trie.insert(new int[]{128104, 127999, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 1))); // man mechanic: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 1, 397, 67))); // factory worker: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 1, 793, 67))); // woman factory worker: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 1, 1, 859))); // man office worker: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 1, 463, 1))); // scientist: light skin tone
        trie.insert(new int[]{128105, 8205, 128300}, new ParseResult(5, new SpriteCoordinates(2, 1, 727, 661))); // woman scientist
        trie.insert(new int[]{129489, 127999, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 331))); // technologist: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 1, 595, 727))); // woman technologist: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 595))); // man singer: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 1, 133, 397))); // artist: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 1, 133, 793))); // woman artist: light skin tone
        trie.insert(new int[]{128104, 8205, 9992}, new ParseResult(4, new SpriteCoordinates(2, 1, 331, 793))); // man pilot
        trie.insert(new int[]{128104, 8205, 9992, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 331, 793))); // man pilot
        trie.insert(new int[]{128105, 127999, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 1, 199, 727))); // woman pilot: dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 727))); // woman pilot: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 265))); // man astronaut: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 1, 1, 397))); // firefighter: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 1, 793, 463))); // woman firefighter: medium-light skin tone
        trie.insert(new int[]{128110, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 727, 463))); // man police officer: light skin tone
        trie.insert(new int[]{128110, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 727, 463))); // man police officer: light skin tone
        trie.insert(new int[]{128373, 65039}, new ParseResult(3, new SpriteCoordinates(2, 1, 661, 397))); // detective
        trie.insert(new int[]{128373}, new ParseResult(2, new SpriteCoordinates(2, 1, 661, 397))); // detective
        trie.insert(new int[]{128373, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 661, 463))); // man detective: dark skin tone
        trie.insert(new int[]{128373, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 661, 463))); // man detective: dark skin tone
        trie.insert(new int[]{128130, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 265, 661))); // guard: medium-dark skin tone
        trie.insert(new int[]{128130, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 331, 661))); // woman guard: medium skin tone
        trie.insert(new int[]{128130, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 331, 661))); // woman guard: medium skin tone
        trie.insert(new int[]{128119, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 661))); // construction worker: medium-light skin tone
        trie.insert(new int[]{128119, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 661, 661))); // woman construction worker: light skin tone
        trie.insert(new int[]{128119, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 661, 661))); // woman construction worker: light skin tone
        trie.insert(new int[]{129332}, new ParseResult(2, new SpriteCoordinates(2, 1, 199, 529))); // prince
        trie.insert(new int[]{128120, 127999}, new ParseResult(4, new SpriteCoordinates(2, 1, 529, 661))); // princess: dark skin tone
        trie.insert(new int[]{128115, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 727, 133))); // man wearing turban: medium-dark skin tone
        trie.insert(new int[]{128115, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 727, 133))); // man wearing turban: medium-dark skin tone
        trie.insert(new int[]{128114, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 727, 199))); // person with skullcap: medium skin tone
        trie.insert(new int[]{129333, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 67, 529))); // person in tuxedo: medium-light skin tone
        trie.insert(new int[]{129333, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 133, 529))); // woman in tuxedo: light skin tone
        trie.insert(new int[]{129333, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 133, 529))); // woman in tuxedo: light skin tone
        trie.insert(new int[]{128112, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 727, 331))); // man with veil
        trie.insert(new int[]{128112, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 727, 331))); // man with veil
        trie.insert(new int[]{128112, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 727, 397))); // woman with veil: dark skin tone
        trie.insert(new int[]{128112, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 727, 397))); // woman with veil: dark skin tone
        trie.insert(new int[]{129731, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 67, 199))); // pregnant man: medium-dark skin tone
        trie.insert(new int[]{129329, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 331, 529))); // breast-feeding: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 1, 67, 859))); // man feeding baby: medium-light skin tone
        trie.insert(new int[]{128124, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 661))); // baby angel: light skin tone
        trie.insert(new int[]{129334}, new ParseResult(2, new SpriteCoordinates(2, 1, 1, 529))); // Mrs. Claus
        trie.insert(new int[]{129489, 127999, 8205, 127876}, new ParseResult(7, new SpriteCoordinates(2, 1, 265, 331))); // mx claus: dark skin tone
        trie.insert(new int[]{129464, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 265, 463))); // man superhero: medium-dark skin tone
        trie.insert(new int[]{129464, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 265, 463))); // man superhero: medium-dark skin tone
        trie.insert(new int[]{129465, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 133, 463))); // supervillain: medium skin tone
        trie.insert(new int[]{129465, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 463))); // woman supervillain: medium-light skin tone
        trie.insert(new int[]{129465, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 199, 463))); // woman supervillain: medium-light skin tone
        trie.insert(new int[]{129497, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 133, 265))); // man mage: light skin tone
        trie.insert(new int[]{129497, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 133, 265))); // man mage: light skin tone
        trie.insert(new int[]{129498}, new ParseResult(2, new SpriteCoordinates(2, 1, 1, 265))); // fairy
        trie.insert(new int[]{129498, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 67, 265))); // man fairy: dark skin tone
        trie.insert(new int[]{129498, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 67, 265))); // man fairy: dark skin tone
        trie.insert(new int[]{129499, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 265, 133))); // vampire: medium-dark skin tone
        trie.insert(new int[]{129499, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 265, 199))); // woman vampire: medium skin tone
        trie.insert(new int[]{129499, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 265, 199))); // woman vampire: medium skin tone
        trie.insert(new int[]{129500, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 265, 67))); // merman: medium-light skin tone
        trie.insert(new int[]{129500, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 265, 67))); // merman: medium-light skin tone
        trie.insert(new int[]{129501, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 265, 1))); // elf: light skin tone
        trie.insert(new int[]{129501, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 199, 199))); // woman elf
        trie.insert(new int[]{129501, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 1, 199, 199))); // woman elf
        trie.insert(new int[]{129503, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 133, 199))); // woman zombie
        trie.insert(new int[]{129503, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 1, 133, 199))); // woman zombie
        trie.insert(new int[]{128134, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 133, 661))); // man getting massage: medium skin tone
        trie.insert(new int[]{128134, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 133, 661))); // man getting massage: medium skin tone
        trie.insert(new int[]{128135, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 1, 661))); // person getting haircut: medium-light skin tone
        trie.insert(new int[]{128135, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 67, 661))); // woman getting haircut: light skin tone
        trie.insert(new int[]{128135, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 67, 661))); // woman getting haircut: light skin tone
        trie.insert(new int[]{128694, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 265))); // man walking
        trie.insert(new int[]{128694, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 595, 265))); // man walking
        trie.insert(new int[]{128694, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 595, 331))); // woman walking: dark skin tone
        trie.insert(new int[]{128694, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 595, 331))); // woman walking: dark skin tone
        trie.insert(new int[]{128694, 127998, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 595, 397))); // woman walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 595, 397))); // woman walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 1, 595, 397))); // woman walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 1, 595, 397))); // woman walking facing right
        trie.insert(new int[]{129485, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 397))); // person standing: medium skin tone
        trie.insert(new int[]{129485, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 1, 463))); // woman standing: medium-light skin tone
        trie.insert(new int[]{129485, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 1, 463))); // woman standing: medium-light skin tone
        trie.insert(new int[]{129486, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 463, 331))); // man kneeling: light skin tone
        trie.insert(new int[]{129486, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 463, 331))); // man kneeling: light skin tone
        trie.insert(new int[]{129486, 8205, 10145, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 463, 199))); // person kneeling facing right
        trie.insert(new int[]{129486, 8205, 10145}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 199))); // person kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 463, 265))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 463, 265))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 1, 463, 265))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 1, 463, 265))); // woman kneeling facing right
        trie.insert(new int[]{129489, 127998, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 1, 397, 1))); // person with white cane: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 1, 859, 463))); // man with white cane: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 1, 793, 331))); // woman with white cane: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 1, 331, 397))); // person in motorized wheelchair: light skin tone
        trie.insert(new int[]{128104, 8205, 129468}, new ParseResult(5, new SpriteCoordinates(2, 1, 397, 793))); // man in motorized wheelchair
        trie.insert(new int[]{128104, 127999, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 661, 793))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127999, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 661, 793))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127998, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 397, 727))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127998, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 397, 727))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127997, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 397, 265))); // person in manual wheelchair facing right
        trie.insert(new int[]{129489, 127997, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 397, 265))); // person in manual wheelchair facing right
        trie.insert(new int[]{128104, 127996, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 859, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128104, 127996, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 859, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128105, 127995, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 793, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{128105, 127995, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 793, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{127939, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 925, 397))); // man running
        trie.insert(new int[]{127939, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 925, 397))); // man running
        trie.insert(new int[]{127939, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 925, 463))); // woman running: dark skin tone
        trie.insert(new int[]{127939, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 925, 463))); // woman running: dark skin tone
        trie.insert(new int[]{127939, 127998, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 1, 925, 529))); // woman running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 1, 925, 529))); // woman running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 1, 925, 529))); // woman running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 1, 925, 529))); // woman running facing right
        trie.insert(new int[]{128131, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 199, 661))); // woman dancing: medium skin tone
        trie.insert(new int[]{128372, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 661, 529))); // person in suit levitating: medium-light skin tone
        trie.insert(new int[]{129494, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 331, 1))); // person in steamy room: medium-dark skin tone
        trie.insert(new int[]{129494, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 331, 67))); // woman in steamy room: medium skin tone
        trie.insert(new int[]{129494, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 331, 67))); // woman in steamy room: medium skin tone
        trie.insert(new int[]{129495, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 265, 265))); // man climbing: medium-light skin tone
        trie.insert(new int[]{129495, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 265, 265))); // man climbing: medium-light skin tone
        trie.insert(new int[]{127943}, new ParseResult(2, new SpriteCoordinates(2, 1, 925, 199))); // horse racing
        trie.insert(new int[]{127938, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 925, 595))); // snowboarder: medium-dark skin tone
        trie.insert(new int[]{127948, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 925, 1))); // man golfing: medium skin tone
        trie.insert(new int[]{127948, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 925, 1))); // man golfing: medium skin tone
        trie.insert(new int[]{127940, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 925, 265))); // person surfing: medium-light skin tone
        trie.insert(new int[]{127940, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 925, 331))); // woman surfing: light skin tone
        trie.insert(new int[]{127940, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 925, 331))); // woman surfing: light skin tone
        trie.insert(new int[]{128675, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 133, 595))); // man rowing boat
        trie.insert(new int[]{128675, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 133, 595))); // man rowing boat
        trie.insert(new int[]{128675, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 595))); // woman rowing boat: dark skin tone
        trie.insert(new int[]{128675, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 199, 595))); // woman rowing boat: dark skin tone
        trie.insert(new int[]{127946, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 925, 133))); // man swimming: medium-dark skin tone
        trie.insert(new int[]{127946, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 925, 133))); // man swimming: medium-dark skin tone
        trie.insert(new int[]{9977, 127997}, new ParseResult(3, new SpriteCoordinates(2, 1, 133, 1))); // person bouncing ball: medium skin tone
        trie.insert(new int[]{9977, 127996, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 1, 133, 67))); // woman bouncing ball: medium-light skin tone
        trie.insert(new int[]{9977, 127996, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 1, 133, 67))); // woman bouncing ball: medium-light skin tone
        trie.insert(new int[]{127947, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 925, 67))); // man lifting weights: light skin tone
        trie.insert(new int[]{127947, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 925, 67))); // man lifting weights: light skin tone
        trie.insert(new int[]{128692}, new ParseResult(2, new SpriteCoordinates(2, 1, 1, 595))); // person biking
        trie.insert(new int[]{128692, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 67, 595))); // man biking: dark skin tone
        trie.insert(new int[]{128692, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 67, 595))); // man biking: dark skin tone
        trie.insert(new int[]{128693, 127998}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 463))); // person mountain biking: medium-dark skin tone
        trie.insert(new int[]{128693, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 595, 529))); // woman mountain biking: medium skin tone
        trie.insert(new int[]{128693, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 595, 529))); // woman mountain biking: medium skin tone
        trie.insert(new int[]{129336, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 529, 331))); // man cartwheeling: medium-light skin tone
        trie.insert(new int[]{129336, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 529, 331))); // man cartwheeling: medium-light skin tone
        trie.insert(new int[]{129340, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 529, 133))); // men wrestling
        trie.insert(new int[]{129340, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 529, 133))); // men wrestling
        trie.insert(new int[]{129341, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 529, 67))); // man playing water polo: medium skin tone
        trie.insert(new int[]{129341, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 529, 67))); // man playing water polo: medium skin tone
        trie.insert(new int[]{129342, 127996}, new ParseResult(4, new SpriteCoordinates(2, 1, 463, 463))); // person playing handball: medium-light skin tone
        trie.insert(new int[]{129342, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 529, 1))); // woman playing handball: light skin tone
        trie.insert(new int[]{129342, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 529, 1))); // woman playing handball: light skin tone
        trie.insert(new int[]{129337, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 1, 529, 199))); // man juggling
        trie.insert(new int[]{129337, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 1, 529, 199))); // man juggling
        trie.insert(new int[]{129337, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 529, 265))); // woman juggling: dark skin tone
        trie.insert(new int[]{129337, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 1, 529, 265))); // woman juggling: dark skin tone
        trie.insert(new int[]{129496, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 1, 199, 265))); // man in lotus position: medium-dark skin tone
        trie.insert(new int[]{129496, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 1, 199, 265))); // man in lotus position: medium-dark skin tone
        trie.insert(new int[]{128704, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 595, 199))); // person taking bath: medium skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129309, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 1, 397, 397))); // people holding hands: light skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129309, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 1, 397, 331))); // people holding hands: medium skin tone
        trie.insert(new int[]{129489, 127999, 8205, 129309, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 1, 133, 331))); // people holding hands: dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 1, 793, 397))); // women holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 1, 463, 727))); // women holding hands: medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 1, 67, 793))); // woman and man holding hands: light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 1, 529, 727))); // woman and man holding hands: medium-dark skin tone, light skin tone
        trie.insert(new int[]{128108, 127995}, new ParseResult(4, new SpriteCoordinates(2, 1, 727, 529))); // men holding hands: light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 1, 859, 529))); // men holding hands: medium skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 1, 793, 793))); // men holding hands: dark skin tone, medium skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127998}, new ParseResult(14, new SpriteCoordinates(2, 1, 265, 397))); // kiss: person, person, light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998}, new ParseResult(15, new SpriteCoordinates(2, 1, 265, 397))); // kiss: person, person, light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996}, new ParseResult(15, new SpriteCoordinates(2, 1, 331, 331))); // kiss: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127996}, new ParseResult(14, new SpriteCoordinates(2, 1, 331, 331))); // kiss: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 1, 793, 595))); // kiss: woman, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 1, 793, 595))); // kiss: woman, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 1, 661, 727))); // kiss: woman, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 1, 661, 727))); // kiss: woman, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128104, 8205, 10084, 65039, 8205, 128139, 8205, 128104}, new ParseResult(11, new SpriteCoordinates(2, 1, 265, 793))); // kiss: man, man
        trie.insert(new int[]{128104, 8205, 10084, 8205, 128139, 8205, 128104}, new ParseResult(10, new SpriteCoordinates(2, 1, 265, 793))); // kiss: man, man
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 1, 859, 331))); // kiss: man, man, medium skin tone, light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 1, 859, 331))); // kiss: man, man, medium skin tone, light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 1, 595, 793))); // kiss: man, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 1, 595, 793))); // kiss: man, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996}, new ParseResult(15, new SpriteCoordinates(2, 1, 793, 133))); // kiss: woman, woman, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127996}, new ParseResult(14, new SpriteCoordinates(2, 1, 793, 133))); // kiss: woman, woman, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127997}, new ParseResult(14, new SpriteCoordinates(2, 1, 331, 727))); // kiss: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997}, new ParseResult(15, new SpriteCoordinates(2, 1, 331, 727))); // kiss: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128145, 127997}, new ParseResult(4, new SpriteCoordinates(2, 1, 661, 595))); // couple with heart: medium skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 129489, 127995}, new ParseResult(11, new SpriteCoordinates(2, 1, 397, 199))); // couple with heart: person, person, medium skin tone, light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 1, 397, 199))); // couple with heart: person, person, medium skin tone, light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 129489, 127998}, new ParseResult(11, new SpriteCoordinates(2, 1, 1, 331))); // couple with heart: person, person, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 1, 1, 331))); // couple with heart: person, person, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 1, 793, 199))); // couple with heart: woman, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 1, 793, 199))); // couple with heart: woman, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 1, 133, 727))); // couple with heart: woman, man, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 1, 133, 727))); // couple with heart: woman, man, dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 1, 859, 727))); // couple with heart: man, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 1, 859, 727))); // couple with heart: man, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 1, 859, 67))); // couple with heart: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 1, 859, 67))); // couple with heart: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128105, 127996}, new ParseResult(11, new SpriteCoordinates(2, 1, 793, 661))); // couple with heart: woman, woman, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 1, 793, 661))); // couple with heart: woman, woman, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 1, 727, 727))); // couple with heart: woman, woman, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128105, 127997}, new ParseResult(11, new SpriteCoordinates(2, 1, 727, 727))); // couple with heart: woman, woman, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 1, 67, 727))); // couple with heart: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128105, 127998}, new ParseResult(11, new SpriteCoordinates(2, 1, 67, 727))); // couple with heart: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 8205, 128104, 8205, 128103, 8205, 128103}, new ParseResult(11, new SpriteCoordinates(2, 1, 529, 793))); // family: man, man, girl, girl
        trie.insert(new int[]{128105, 8205, 128102}, new ParseResult(5, new SpriteCoordinates(2, 1, 1, 727))); // family: woman, boy
        trie.insert(new int[]{129489, 8205, 129489, 8205, 129490, 8205, 129490}, new ParseResult(11, new SpriteCoordinates(2, 1, 331, 199))); // family: adult, adult, child, child
        trie.insert(new int[]{128075, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 397, 859))); // waving hand: medium-light skin tone
        trie.insert(new int[]{128400, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 661, 199))); // hand with fingers splayed: light skin tone
        trie.insert(new int[]{128406}, new ParseResult(2, new SpriteCoordinates(2, 2, 661, 133))); // vulcan salute
        trie.insert(new int[]{129777, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 67, 133))); // rightwards hand: dark skin tone
        trie.insert(new int[]{129779, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 1, 133))); // palm down hand: medium-dark skin tone
        trie.insert(new int[]{129783, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 67, 67))); // leftwards pushing hand: medium skin tone
        trie.insert(new int[]{128076, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 331, 859))); // OK hand: medium-light skin tone
        trie.insert(new int[]{129295, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 1))); // pinching hand: light skin tone
        trie.insert(new int[]{129310}, new ParseResult(2, new SpriteCoordinates(2, 2, 331, 529))); // crossed fingers
        trie.insert(new int[]{129776, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 1))); // hand with index finger and thumb crossed: dark skin tone
        trie.insert(new int[]{129304, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 529))); // sign of the horns: medium-dark skin tone
        trie.insert(new int[]{128072, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 463, 859))); // backhand index pointing left: medium skin tone
        trie.insert(new int[]{128070, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 859))); // backhand index pointing up: medium-light skin tone
        trie.insert(new int[]{128071, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 859))); // backhand index pointing down: light skin tone
        trie.insert(new int[]{129781}, new ParseResult(2, new SpriteCoordinates(2, 2, 133, 67))); // index pointing at the viewer
        trie.insert(new int[]{128077, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 265, 859))); // thumbs up: dark skin tone
        trie.insert(new int[]{9994, 127998}, new ParseResult(3, new SpriteCoordinates(2, 2, 1, 1))); // raised fist: medium-dark skin tone
        trie.insert(new int[]{129307, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 463, 529))); // left-facing fist: medium skin tone
        trie.insert(new int[]{128079, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 859))); // clapping hands: medium-light skin tone
        trie.insert(new int[]{129782, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 1))); // heart hands: light skin tone
    }

    public static void init3(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{129330}, new ParseResult(2, new SpriteCoordinates(2, 2, 1, 529))); // palms up together
        trie.insert(new int[]{129309, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 397, 529))); // handshake: dark skin tone
        trie.insert(new int[]{129777, 127997, 8205, 129778, 127998}, new ParseResult(9, new SpriteCoordinates(2, 2, 133, 133))); // handshake: medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128591, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 67, 595))); // folded hands: light skin tone
        trie.insert(new int[]{128133}, new ParseResult(2, new SpriteCoordinates(2, 2, 67, 661))); // nail polish
        trie.insert(new int[]{129331, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 463))); // selfie: dark skin tone
        trie.insert(new int[]{129461, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 463))); // leg: medium-light skin tone
        trie.insert(new int[]{128066, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 727, 859))); // ear: light skin tone
        trie.insert(new int[]{128067}, new ParseResult(2, new SpriteCoordinates(2, 2, 661, 859))); // nose
        trie.insert(new int[]{128064}, new ParseResult(2, new SpriteCoordinates(2, 2, 793, 859))); // eyes
        trie.insert(new int[]{129490}, new ParseResult(2, new SpriteCoordinates(2, 2, 331, 1))); // child
        trie.insert(new int[]{128102, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 859))); // boy: dark skin tone
        trie.insert(new int[]{129489, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 331))); // person: medium-dark skin tone
        trie.insert(new int[]{128104, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 859, 133))); // man: medium skin tone
        trie.insert(new int[]{129492, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 265, 265))); // man: medium-light skin tone, beard
        trie.insert(new int[]{129492, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 265, 265))); // man: medium-light skin tone, beard
        trie.insert(new int[]{128104, 127995, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 793))); // man: light skin tone, red hair
        trie.insert(new int[]{128104, 8205, 129459}, new ParseResult(5, new SpriteCoordinates(2, 2, 265, 793))); // man: white hair
        trie.insert(new int[]{128104, 127999, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 2, 529, 793))); // man: dark skin tone, bald
        trie.insert(new int[]{128105, 127998, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 2, 529, 727))); // woman: medium-dark skin tone, red hair
        trie.insert(new int[]{128105, 127997, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 67))); // woman: medium skin tone, curly hair
        trie.insert(new int[]{128105, 127996, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 463))); // woman: medium-light skin tone, white hair
        trie.insert(new int[]{128105, 127995, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 2, 133, 793))); // woman: light skin tone, bald
        trie.insert(new int[]{128113, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 727, 133))); // woman: blond hair
        trie.insert(new int[]{128113, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 2, 727, 133))); // woman: blond hair
        trie.insert(new int[]{128113, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 727, 199))); // man: dark skin tone, blond hair
        trie.insert(new int[]{128113, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 727, 199))); // man: dark skin tone, blond hair
        trie.insert(new int[]{128116, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 661))); // old man: medium-dark skin tone
        trie.insert(new int[]{128589, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 595))); // person frowning: medium skin tone
        trie.insert(new int[]{128589, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 265, 595))); // woman frowning: medium-light skin tone
        trie.insert(new int[]{128589, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 265, 595))); // woman frowning: medium-light skin tone
        trie.insert(new int[]{128590, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 133, 595))); // man pouting: light skin tone
        trie.insert(new int[]{128590, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 133, 595))); // man pouting: light skin tone
        trie.insert(new int[]{128581}, new ParseResult(2, new SpriteCoordinates(2, 2, 661, 1))); // person gesturing NO
        trie.insert(new int[]{128581, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 661, 67))); // man gesturing NO: dark skin tone
        trie.insert(new int[]{128581, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 661, 67))); // man gesturing NO: dark skin tone
        trie.insert(new int[]{128582, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 595))); // person gesturing OK: medium-dark skin tone
        trie.insert(new int[]{128582, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 595, 595))); // woman gesturing OK: medium skin tone
        trie.insert(new int[]{128582, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 595, 595))); // woman gesturing OK: medium skin tone
        trie.insert(new int[]{128129, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 331, 661))); // man tipping hand: medium-light skin tone
        trie.insert(new int[]{128129, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 331, 661))); // man tipping hand: medium-light skin tone
        trie.insert(new int[]{128587, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 397, 595))); // person raising hand: light skin tone
        trie.insert(new int[]{128587, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 2, 331, 595))); // woman raising hand
        trie.insert(new int[]{128587, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 331, 595))); // woman raising hand
        trie.insert(new int[]{129487, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 265, 397))); // deaf person: dark skin tone
        trie.insert(new int[]{129487, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 331, 397))); // deaf woman: medium-dark skin tone
        trie.insert(new int[]{129487, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 331, 397))); // deaf woman: medium-dark skin tone
        trie.insert(new int[]{128583, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 595))); // man bowing: medium skin tone
        trie.insert(new int[]{128583, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 595))); // man bowing: medium skin tone
        trie.insert(new int[]{129318, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 529))); // person facepalming: medium-light skin tone
        trie.insert(new int[]{129318, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 265, 529))); // woman facepalming: light skin tone
        trie.insert(new int[]{129318, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 265, 529))); // woman facepalming: light skin tone
        trie.insert(new int[]{129335, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 529, 67))); // man shrugging
        trie.insert(new int[]{129335, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 67))); // man shrugging
        trie.insert(new int[]{129335, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 529, 133))); // woman shrugging: dark skin tone
        trie.insert(new int[]{129335, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 529, 133))); // woman shrugging: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 2, 793, 793))); // man health worker: medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 793))); // man health worker: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 2, 397, 265))); // student: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 727))); // woman student: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 2, 67, 859))); // man teacher: light skin tone
        trie.insert(new int[]{129489, 8205, 9878}, new ParseResult(4, new SpriteCoordinates(2, 2, 331, 67))); // judge
        trie.insert(new int[]{129489, 8205, 9878, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 331, 67))); // judge
        trie.insert(new int[]{128104, 127999, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 793))); // man judge: dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 793))); // man judge: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 2, 397, 1))); // farmer: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 265))); // woman farmer: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 529))); // man cook: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 2, 199, 397))); // mechanic: light skin tone
        trie.insert(new int[]{128105, 8205, 128295}, new ParseResult(5, new SpriteCoordinates(2, 2, 727, 595))); // woman mechanic
        trie.insert(new int[]{129489, 127999, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 2, 67, 331))); // factory worker: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 2, 661, 727))); // woman factory worker: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 331))); // man office worker: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 2, 1, 397))); // scientist: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 2, 199, 793))); // woman scientist: light skin tone
        trie.insert(new int[]{128104, 8205, 128187}, new ParseResult(5, new SpriteCoordinates(2, 2, 331, 793))); // man technologist
        trie.insert(new int[]{128105, 127999, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 2, 331, 727))); // woman technologist: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 67))); // man singer: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 2, 397, 199))); // artist: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 661))); // woman artist: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 2, 859, 661))); // man pilot: light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 661))); // man pilot: light skin tone
        trie.insert(new int[]{129489, 8205, 128640}, new ParseResult(5, new SpriteCoordinates(2, 2, 331, 199))); // astronaut
        trie.insert(new int[]{128104, 127999, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 2, 661, 793))); // man astronaut: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 2, 331, 331))); // firefighter: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 199))); // woman firefighter: medium skin tone
        trie.insert(new int[]{128110, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 727, 331))); // man police officer: medium-light skin tone
        trie.insert(new int[]{128110, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 727, 331))); // man police officer: medium-light skin tone
        trie.insert(new int[]{128373, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 661, 331))); // detective: light skin tone
        trie.insert(new int[]{128373, 65039, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 2, 661, 265))); // woman detective
        trie.insert(new int[]{128373, 65039, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 2, 661, 265))); // woman detective
        trie.insert(new int[]{128373, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 661, 265))); // woman detective
        trie.insert(new int[]{128373, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 2, 661, 265))); // woman detective
        trie.insert(new int[]{128130, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 661))); // guard: dark skin tone
        trie.insert(new int[]{128130, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 265, 661))); // woman guard: medium-dark skin tone
        trie.insert(new int[]{128130, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 265, 661))); // woman guard: medium-dark skin tone
        trie.insert(new int[]{128119, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 463, 661))); // construction worker: medium skin tone
        trie.insert(new int[]{128119, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 529, 661))); // woman construction worker: medium-light skin tone
        trie.insert(new int[]{128119, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 529, 661))); // woman construction worker: medium-light skin tone
        trie.insert(new int[]{129332, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 397))); // prince: light skin tone
        trie.insert(new int[]{128115}, new ParseResult(2, new SpriteCoordinates(2, 2, 661, 661))); // person wearing turban
        trie.insert(new int[]{128115, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 727, 1))); // man wearing turban: dark skin tone
        trie.insert(new int[]{128115, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 727, 1))); // man wearing turban: dark skin tone
        trie.insert(new int[]{128114, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 727, 67))); // person with skullcap: medium-dark skin tone
        trie.insert(new int[]{129333, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 265))); // person in tuxedo: medium skin tone
        trie.insert(new int[]{129333, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 529, 331))); // woman in tuxedo: medium-light skin tone
        trie.insert(new int[]{129333, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 529, 331))); // woman in tuxedo: medium-light skin tone
        trie.insert(new int[]{128112, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 727, 265))); // man with veil: light skin tone
        trie.insert(new int[]{128112, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 727, 265))); // man with veil: light skin tone
        trie.insert(new int[]{129328}, new ParseResult(2, new SpriteCoordinates(2, 2, 133, 529))); // pregnant woman
        trie.insert(new int[]{129731, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 67))); // pregnant man: dark skin tone
        trie.insert(new int[]{129329, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 67, 529))); // breast-feeding: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 397))); // man feeding baby: medium skin tone
        trie.insert(new int[]{128124, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 397, 661))); // baby angel: medium-light skin tone
        trie.insert(new int[]{129334, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 529, 199))); // Mrs. Claus: light skin tone
        trie.insert(new int[]{129464}, new ParseResult(2, new SpriteCoordinates(2, 2, 1, 463))); // superhero
        trie.insert(new int[]{129464, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 67, 463))); // man superhero: dark skin tone
        trie.insert(new int[]{129464, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 67, 463))); // man superhero: dark skin tone
        trie.insert(new int[]{129465, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 463, 331))); // supervillain: medium-dark skin tone
        trie.insert(new int[]{129465, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 397))); // woman supervillain: medium skin tone
        trie.insert(new int[]{129465, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 397))); // woman supervillain: medium skin tone
        trie.insert(new int[]{129497, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 265, 133))); // man mage: medium-light skin tone
        trie.insert(new int[]{129497, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 265, 133))); // man mage: medium-light skin tone
        trie.insert(new int[]{129498, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 265, 67))); // fairy: light skin tone
        trie.insert(new int[]{129498, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 265, 1))); // woman fairy
        trie.insert(new int[]{129498, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 2, 265, 1))); // woman fairy
        trie.insert(new int[]{129499, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 199))); // vampire: dark skin tone
        trie.insert(new int[]{129499, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 199, 199))); // woman vampire: medium-dark skin tone
        trie.insert(new int[]{129499, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 199, 199))); // woman vampire: medium-dark skin tone
        trie.insert(new int[]{129500, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 67, 199))); // merman: medium skin tone
        trie.insert(new int[]{129500, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 67, 199))); // merman: medium skin tone
        trie.insert(new int[]{129501, 127996}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 133))); // elf: medium-light skin tone
        trie.insert(new int[]{129501, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 1, 199))); // woman elf: light skin tone
        trie.insert(new int[]{129501, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 1, 199))); // woman elf: light skin tone
        trie.insert(new int[]{129484}, new ParseResult(2, new SpriteCoordinates(2, 2, 463, 265))); // troll
        trie.insert(new int[]{128134, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 1, 661))); // man getting massage: medium-dark skin tone
        trie.insert(new int[]{128134, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 1, 661))); // man getting massage: medium-dark skin tone
        trie.insert(new int[]{128135, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 661, 529))); // person getting haircut: medium skin tone
        trie.insert(new int[]{128135, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 661, 595))); // woman getting haircut: medium-light skin tone
        trie.insert(new int[]{128135, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 661, 595))); // woman getting haircut: medium-light skin tone
        trie.insert(new int[]{128694, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 595, 265))); // man walking: light skin tone
        trie.insert(new int[]{128694, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 595, 265))); // man walking: light skin tone
        trie.insert(new int[]{128694, 8205, 10145, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 595, 133))); // person walking facing right
        trie.insert(new int[]{128694, 8205, 10145}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 133))); // person walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 2, 595, 199))); // woman walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 2, 595, 199))); // woman walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 2, 595, 199))); // woman walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 2, 595, 199))); // woman walking facing right
        trie.insert(new int[]{129485, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 463, 133))); // person standing: medium-dark skin tone
        trie.insert(new int[]{129485, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 199))); // woman standing: medium skin tone
        trie.insert(new int[]{129485, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 199))); // woman standing: medium skin tone
        trie.insert(new int[]{129486, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 1))); // man kneeling: medium-light skin tone
        trie.insert(new int[]{129486, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 1))); // man kneeling: medium-light skin tone
        trie.insert(new int[]{129486, 127995, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 67))); // person kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 67))); // person kneeling facing right
        trie.insert(new int[]{129486, 8205, 9794, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 2, 397, 397))); // man kneeling facing right
        trie.insert(new int[]{129486, 8205, 9794, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 397, 397))); // man kneeling facing right
        trie.insert(new int[]{129486, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 2, 397, 397))); // man kneeling facing right
        trie.insert(new int[]{129486, 8205, 9794, 65039, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 2, 397, 397))); // man kneeling facing right
        trie.insert(new int[]{129489, 127999, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 2, 331, 265))); // person with white cane: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 1))); // man with white cane: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 2, 793, 133))); // woman with white cane: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 2, 397, 331))); // person in motorized wheelchair: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 727))); // man in motorized wheelchair: light skin tone
        trie.insert(new int[]{128105, 8205, 129468}, new ParseResult(5, new SpriteCoordinates(2, 2, 727, 529))); // woman in motorized wheelchair
        trie.insert(new int[]{128105, 127999, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 2, 199, 727))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127999, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 2, 199, 727))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127998, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 2, 265, 331))); // person in manual wheelchair facing right
        trie.insert(new int[]{129489, 127998, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 2, 265, 331))); // person in manual wheelchair facing right
        trie.insert(new int[]{128104, 127997, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 2, 859, 265))); // man in manual wheelchair facing right
        trie.insert(new int[]{128104, 127997, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 2, 859, 265))); // man in manual wheelchair facing right
        trie.insert(new int[]{128105, 127996, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 2, 793, 397))); // woman in manual wheelchair facing right
        trie.insert(new int[]{128105, 127996, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 2, 793, 397))); // woman in manual wheelchair facing right
        trie.insert(new int[]{127939, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 925, 529))); // man running: light skin tone
        trie.insert(new int[]{127939, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 925, 529))); // man running: light skin tone
        trie.insert(new int[]{127939, 8205, 10145, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 925, 397))); // person running facing right
        trie.insert(new int[]{127939, 8205, 10145}, new ParseResult(4, new SpriteCoordinates(2, 2, 925, 397))); // person running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 2, 925, 463))); // woman running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 2, 925, 463))); // woman running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 2, 925, 463))); // woman running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 2, 925, 463))); // woman running facing right
        trie.insert(new int[]{128131, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 661))); // woman dancing: medium-dark skin tone
        trie.insert(new int[]{128372, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 661, 397))); // person in suit levitating: medium skin tone
        trie.insert(new int[]{129494, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 133, 265))); // person in steamy room: dark skin tone
        trie.insert(new int[]{129494, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 199, 265))); // woman in steamy room: medium-dark skin tone
        trie.insert(new int[]{129494, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 199, 265))); // woman in steamy room: medium-dark skin tone
        trie.insert(new int[]{129495, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 67, 265))); // man climbing: medium skin tone
        trie.insert(new int[]{129495, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 67, 265))); // man climbing: medium skin tone
        trie.insert(new int[]{127943, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 925, 199))); // horse racing: light skin tone
        trie.insert(new int[]{127938, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 925, 595))); // snowboarder: dark skin tone
        trie.insert(new int[]{127948, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 859, 859))); // man golfing: medium-dark skin tone
        trie.insert(new int[]{127948, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 859, 859))); // man golfing: medium-dark skin tone
        trie.insert(new int[]{127940, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 925, 265))); // person surfing: medium skin tone
        trie.insert(new int[]{127940, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 925, 331))); // woman surfing: medium-light skin tone
        trie.insert(new int[]{127940, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 925, 331))); // woman surfing: medium-light skin tone
        trie.insert(new int[]{128675, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 1, 595))); // man rowing boat: light skin tone
        trie.insert(new int[]{128675, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 1, 595))); // man rowing boat: light skin tone
        trie.insert(new int[]{127946}, new ParseResult(2, new SpriteCoordinates(2, 2, 925, 67))); // person swimming
        trie.insert(new int[]{127946, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 925, 133))); // man swimming: dark skin tone
        trie.insert(new int[]{127946, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 925, 133))); // man swimming: dark skin tone
        trie.insert(new int[]{9977, 127998}, new ParseResult(3, new SpriteCoordinates(2, 2, 67, 1))); // person bouncing ball: medium-dark skin tone
        trie.insert(new int[]{9977, 127997, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 2, 1, 67))); // woman bouncing ball: medium skin tone
        trie.insert(new int[]{9977, 127997, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 2, 1, 67))); // woman bouncing ball: medium skin tone
        trie.insert(new int[]{127947, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 925, 1))); // man lifting weights: medium-light skin tone
        trie.insert(new int[]{127947, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 925, 1))); // man lifting weights: medium-light skin tone
        trie.insert(new int[]{128692, 127995}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 529))); // person biking: light skin tone
        trie.insert(new int[]{128692, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 595, 463))); // woman biking
        trie.insert(new int[]{128692, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 463))); // woman biking
        trie.insert(new int[]{128693, 127999}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 331))); // person mountain biking: dark skin tone
        trie.insert(new int[]{128693, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 595, 397))); // woman mountain biking: medium-dark skin tone
        trie.insert(new int[]{128693, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 595, 397))); // woman mountain biking: medium-dark skin tone
        trie.insert(new int[]{129336, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 529, 1))); // man cartwheeling: medium skin tone
        trie.insert(new int[]{129336, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 529, 1))); // man cartwheeling: medium skin tone
        trie.insert(new int[]{129340, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 2, 397, 463))); // women wrestling
        trie.insert(new int[]{129340, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 2, 397, 463))); // women wrestling
        trie.insert(new int[]{129341, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 331, 463))); // man playing water polo: medium-dark skin tone
        trie.insert(new int[]{129341, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 331, 463))); // man playing water polo: medium-dark skin tone
        trie.insert(new int[]{129342, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 199, 463))); // person playing handball: medium skin tone
        trie.insert(new int[]{129342, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 265, 463))); // woman playing handball: medium-light skin tone
        trie.insert(new int[]{129342, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 2, 265, 463))); // woman playing handball: medium-light skin tone
        trie.insert(new int[]{129337, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 463, 463))); // man juggling: light skin tone
        trie.insert(new int[]{129337, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 463, 463))); // man juggling: light skin tone
        trie.insert(new int[]{129496}, new ParseResult(2, new SpriteCoordinates(2, 2, 265, 199))); // person in lotus position
        trie.insert(new int[]{129496, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 2, 1, 265))); // man in lotus position: dark skin tone
        trie.insert(new int[]{129496, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 2, 1, 265))); // man in lotus position: dark skin tone
        trie.insert(new int[]{128704, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 595, 67))); // person taking bath: medium-dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129309, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 2, 133, 397))); // people holding hands: light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129309, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 2, 397, 133))); // people holding hands: medium skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 129309, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 2, 1, 331))); // people holding hands: dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 2, 793, 529))); // women holding hands: medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 2, 265, 727))); // women holding hands: dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 2, 793, 595))); // woman and man holding hands: medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 2, 595, 727))); // woman and man holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 2, 1, 859))); // men holding hands: light skin tone, medium-light skin tone
        trie.insert(new int[]{128108, 127997}, new ParseResult(4, new SpriteCoordinates(2, 2, 727, 397))); // men holding hands: medium skin tone
        trie.insert(new int[]{128104, 127999, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 2, 595, 793))); // men holding hands: dark skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127999}, new ParseResult(14, new SpriteCoordinates(2, 2, 67, 397))); // kiss: person, person, light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999}, new ParseResult(15, new SpriteCoordinates(2, 2, 67, 397))); // kiss: person, person, light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997}, new ParseResult(15, new SpriteCoordinates(2, 2, 199, 331))); // kiss: person, person, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127997}, new ParseResult(14, new SpriteCoordinates(2, 2, 199, 331))); // kiss: person, person, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 2, 1, 793))); // kiss: woman, man, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 2, 1, 793))); // kiss: woman, man, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 2, 463, 727))); // kiss: woman, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 2, 463, 727))); // kiss: woman, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 2, 859, 595))); // kiss: man, man, light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 2, 859, 595))); // kiss: man, man, light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 2, 859, 199))); // kiss: man, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 2, 859, 199))); // kiss: man, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 2, 397, 793))); // kiss: man, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 2, 397, 793))); // kiss: man, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127997}, new ParseResult(14, new SpriteCoordinates(2, 2, 793, 331))); // kiss: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997}, new ParseResult(15, new SpriteCoordinates(2, 2, 793, 331))); // kiss: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998}, new ParseResult(15, new SpriteCoordinates(2, 2, 397, 727))); // kiss: woman, woman, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127998}, new ParseResult(14, new SpriteCoordinates(2, 2, 397, 727))); // kiss: woman, woman, medium-dark skin tone
        trie.insert(new int[]{128145, 127998}, new ParseResult(4, new SpriteCoordinates(2, 2, 661, 463))); // couple with heart: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 129489, 127996}, new ParseResult(11, new SpriteCoordinates(2, 2, 397, 67))); // couple with heart: person, person, medium skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 2, 397, 67))); // couple with heart: person, person, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 8205, 10084, 8205, 128104}, new ParseResult(7, new SpriteCoordinates(2, 2, 727, 463))); // couple with heart: woman, man
        trie.insert(new int[]{128105, 8205, 10084, 65039, 8205, 128104}, new ParseResult(8, new SpriteCoordinates(2, 2, 727, 463))); // couple with heart: woman, man
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 2, 793, 1))); // couple with heart: woman, man, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 2, 793, 1))); // couple with heart: woman, man, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 2, 133, 727))); // couple with heart: woman, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 2, 133, 727))); // couple with heart: woman, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 2, 859, 463))); // couple with heart: man, man, medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 2, 859, 463))); // couple with heart: man, man, medium-light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 2, 727, 793))); // couple with heart: man, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 2, 727, 793))); // couple with heart: man, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128105, 127997}, new ParseResult(11, new SpriteCoordinates(2, 2, 67, 793))); // couple with heart: woman, woman, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 2, 67, 793))); // couple with heart: woman, woman, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128105, 127998}, new ParseResult(11, new SpriteCoordinates(2, 2, 727, 727))); // couple with heart: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 2, 727, 727))); // couple with heart: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128105, 127999}, new ParseResult(11, new SpriteCoordinates(2, 2, 67, 727))); // couple with heart: woman, woman, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 2, 67, 727))); // couple with heart: woman, woman, dark skin tone
        trie.insert(new int[]{128105, 8205, 128105, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 2, 727, 661))); // family: woman, woman, boy
        trie.insert(new int[]{128105, 8205, 128102, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 2, 1, 727))); // family: woman, boy, boy
        trie.insert(new int[]{129489, 8205, 129490}, new ParseResult(5, new SpriteCoordinates(2, 2, 331, 133))); // family: adult, child
        trie.insert(new int[]{128075, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 397, 859))); // waving hand: medium skin tone
        trie.insert(new int[]{128400, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 133))); // hand with fingers splayed: medium-light skin tone
        trie.insert(new int[]{128406, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 67))); // vulcan salute: light skin tone
        trie.insert(new int[]{129778}, new ParseResult(2, new SpriteCoordinates(2, 3, 67, 133))); // leftwards hand
        trie.insert(new int[]{129779, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 1, 133))); // palm down hand: dark skin tone
        trie.insert(new int[]{129783, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 67, 67))); // leftwards pushing hand: medium-dark skin tone
        trie.insert(new int[]{128076, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 331, 859))); // OK hand: medium skin tone
        trie.insert(new int[]{129295, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 529))); // pinching hand: medium-light skin tone
        trie.insert(new int[]{129310, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 331, 529))); // crossed fingers: light skin tone
        trie.insert(new int[]{129311}, new ParseResult(2, new SpriteCoordinates(2, 3, 265, 529))); // love-you gesture
        trie.insert(new int[]{129304, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 463, 529))); // sign of the horns: dark skin tone
        trie.insert(new int[]{128072, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 463, 859))); // backhand index pointing left: medium-dark skin tone
        trie.insert(new int[]{128070, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 595, 859))); // backhand index pointing up: medium skin tone
        trie.insert(new int[]{128071, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 859))); // backhand index pointing down: medium-light skin tone
        trie.insert(new int[]{129781, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 67))); // index pointing at the viewer: light skin tone
        trie.insert(new int[]{128078}, new ParseResult(2, new SpriteCoordinates(2, 3, 265, 859))); // thumbs down
        trie.insert(new int[]{9994, 127999}, new ParseResult(3, new SpriteCoordinates(2, 3, 1, 1))); // raised fist: dark skin tone
        trie.insert(new int[]{129307, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 397, 529))); // left-facing fist: medium-dark skin tone
        trie.insert(new int[]{128079, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 199, 859))); // clapping hands: medium skin tone
        trie.insert(new int[]{129782, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 1))); // heart hands: medium-light skin tone
        trie.insert(new int[]{129330, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 463))); // palms up together: light skin tone
        trie.insert(new int[]{129777, 127995, 8205, 129778, 127996}, new ParseResult(9, new SpriteCoordinates(2, 3, 199, 1))); // handshake: light skin tone, medium-light skin tone
        trie.insert(new int[]{129777, 127997, 8205, 129778, 127999}, new ParseResult(9, new SpriteCoordinates(2, 3, 133, 133))); // handshake: medium skin tone, dark skin tone
        trie.insert(new int[]{128591, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 1, 595))); // folded hands: medium-light skin tone
        trie.insert(new int[]{128133, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 661))); // nail polish: light skin tone
        trie.insert(new int[]{128170}, new ParseResult(2, new SpriteCoordinates(2, 3, 661, 397))); // flexed biceps
        trie.insert(new int[]{129461, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 199, 463))); // leg: medium skin tone
        trie.insert(new int[]{128066, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 859))); // ear: medium-light skin tone
        trie.insert(new int[]{128067, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 859))); // nose: light skin tone
        trie.insert(new int[]{128065, 65039}, new ParseResult(3, new SpriteCoordinates(2, 3, 793, 859))); // eye
        trie.insert(new int[]{128065}, new ParseResult(2, new SpriteCoordinates(2, 3, 793, 859))); // eye
        trie.insert(new int[]{129490, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 331, 67))); // child: light skin tone
        trie.insert(new int[]{128103}, new ParseResult(2, new SpriteCoordinates(2, 3, 133, 859))); // girl
        trie.insert(new int[]{129489, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 67, 331))); // person: dark skin tone
        trie.insert(new int[]{128104, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 793))); // man: medium-dark skin tone
        trie.insert(new int[]{129492, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 265, 265))); // man: medium skin tone, beard
        trie.insert(new int[]{129492, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 265))); // man: medium skin tone, beard
        trie.insert(new int[]{128104, 127996, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 529))); // man: medium-light skin tone, red hair
        trie.insert(new int[]{128104, 127995, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 727))); // man: light skin tone, white hair
        trie.insert(new int[]{128105}, new ParseResult(2, new SpriteCoordinates(2, 3, 727, 595))); // woman
        trie.insert(new int[]{128105, 127999, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 727))); // woman: dark skin tone, red hair
        trie.insert(new int[]{128105, 127998, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 727))); // woman: medium-dark skin tone, curly hair
        trie.insert(new int[]{128105, 127997, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 3, 793, 331))); // woman: medium skin tone, white hair
        trie.insert(new int[]{128105, 127996, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 3, 793, 727))); // woman: medium-light skin tone, bald
        trie.insert(new int[]{128113, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 727, 199))); // woman: light skin tone, blond hair
        trie.insert(new int[]{128113, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 727, 199))); // woman: light skin tone, blond hair
        trie.insert(new int[]{129491}, new ParseResult(2, new SpriteCoordinates(2, 3, 331, 1))); // older person
        trie.insert(new int[]{128116, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 661))); // old man: dark skin tone
        trie.insert(new int[]{128589, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 595))); // person frowning: medium-dark skin tone
        trie.insert(new int[]{128589, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 199, 595))); // woman frowning: medium skin tone
        trie.insert(new int[]{128589, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 199, 595))); // woman frowning: medium skin tone
        trie.insert(new int[]{128590, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 67, 595))); // man pouting: medium-light skin tone
        trie.insert(new int[]{128590, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 67, 595))); // man pouting: medium-light skin tone
        trie.insert(new int[]{128581, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 1))); // person gesturing NO: light skin tone
        trie.insert(new int[]{128581, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 3, 595, 595))); // woman gesturing NO
        trie.insert(new int[]{128581, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 595, 595))); // woman gesturing NO
        trie.insert(new int[]{128582, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 463, 595))); // person gesturing OK: dark skin tone
        trie.insert(new int[]{128582, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 529, 595))); // woman gesturing OK: medium-dark skin tone
        trie.insert(new int[]{128582, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 529, 595))); // woman gesturing OK: medium-dark skin tone
        trie.insert(new int[]{128129, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 397, 661))); // man tipping hand: medium skin tone
        trie.insert(new int[]{128129, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 661))); // man tipping hand: medium skin tone
        trie.insert(new int[]{128587, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 265, 595))); // person raising hand: medium-light skin tone
        trie.insert(new int[]{128587, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 331, 595))); // woman raising hand: light skin tone
        trie.insert(new int[]{128587, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 331, 595))); // woman raising hand: light skin tone
        trie.insert(new int[]{129487, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 3, 397, 397))); // deaf man
        trie.insert(new int[]{129487, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 397, 397))); // deaf man
        trie.insert(new int[]{129487, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 463, 1))); // deaf woman: dark skin tone
        trie.insert(new int[]{129487, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 463, 1))); // deaf woman: dark skin tone
        trie.insert(new int[]{128583, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 595))); // man bowing: medium-dark skin tone
        trie.insert(new int[]{128583, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 397, 595))); // man bowing: medium-dark skin tone
        trie.insert(new int[]{129318, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 529))); // person facepalming: medium skin tone
        trie.insert(new int[]{129318, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 199, 529))); // woman facepalming: medium-light skin tone
        trie.insert(new int[]{129318, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 199, 529))); // woman facepalming: medium-light skin tone
        trie.insert(new int[]{129335, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 529, 133))); // man shrugging: light skin tone
        trie.insert(new int[]{129335, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 529, 133))); // man shrugging: light skin tone
        trie.insert(new int[]{129489, 8205, 9877}, new ParseResult(4, new SpriteCoordinates(2, 3, 331, 133))); // health worker
        trie.insert(new int[]{129489, 8205, 9877, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 331, 133))); // health worker
        trie.insert(new int[]{128104, 127999, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 3, 463, 793))); // man health worker: dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 463, 793))); // man health worker: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 67))); // student: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 3, 793, 529))); // woman student: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 595))); // man teacher: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 3, 133, 397))); // judge: light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 133, 397))); // judge: light skin tone
        trie.insert(new int[]{128105, 8205, 9878}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 661))); // woman judge
        trie.insert(new int[]{128105, 8205, 9878, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 727, 661))); // woman judge
        trie.insert(new int[]{129489, 127999, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 331))); // farmer: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 3, 793, 67))); // woman farmer: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 265))); // man cook: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 3, 67, 397))); // mechanic: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 793))); // woman mechanic: light skin tone
        trie.insert(new int[]{128104, 8205, 127981}, new ParseResult(5, new SpriteCoordinates(2, 3, 67, 859))); // man factory worker
        trie.insert(new int[]{128105, 127999, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 727))); // woman factory worker: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 1))); // man office worker: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 331))); // scientist: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 3, 1, 793))); // woman scientist: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 3, 1, 859))); // man technologist: light skin tone
        trie.insert(new int[]{129489, 8205, 127908}, new ParseResult(5, new SpriteCoordinates(2, 3, 331, 397))); // singer
        trie.insert(new int[]{128104, 127999, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 793))); // man singer: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 1))); // artist: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 3, 793, 463))); // woman artist: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 397))); // man pilot: medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 3, 859, 397))); // man pilot: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 397))); // astronaut: light skin tone
        trie.insert(new int[]{128105, 8205, 128640}, new ParseResult(5, new SpriteCoordinates(2, 3, 1, 727))); // woman astronaut
        trie.insert(new int[]{129489, 127999, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 3, 199, 331))); // firefighter: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 3, 793, 1))); // woman firefighter: medium-dark skin tone
        trie.insert(new int[]{128110, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 727, 331))); // man police officer: medium skin tone
        trie.insert(new int[]{128110, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 727, 331))); // man police officer: medium skin tone
        trie.insert(new int[]{128373, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 199))); // detective: medium-light skin tone
        trie.insert(new int[]{128373, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 661, 265))); // woman detective: light skin tone
        trie.insert(new int[]{128373, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 661, 265))); // woman detective: light skin tone
        trie.insert(new int[]{128130, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 3, 265, 661))); // man guard
        trie.insert(new int[]{128130, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 265, 661))); // man guard
        trie.insert(new int[]{128130, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 331, 661))); // woman guard: dark skin tone
        trie.insert(new int[]{128130, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 331, 661))); // woman guard: dark skin tone
        trie.insert(new int[]{128119, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 661))); // construction worker: medium-dark skin tone
        trie.insert(new int[]{128119, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 661))); // woman construction worker: medium skin tone
        trie.insert(new int[]{128119, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 661))); // woman construction worker: medium skin tone
        trie.insert(new int[]{129332, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 397))); // prince: medium-light skin tone
        trie.insert(new int[]{128115, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 67))); // person wearing turban: light skin tone
        trie.insert(new int[]{128115, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 727, 1))); // woman wearing turban
        trie.insert(new int[]{128115, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 1))); // woman wearing turban
        trie.insert(new int[]{128114, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 133))); // person with skullcap: dark skin tone
        trie.insert(new int[]{129333, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 265))); // person in tuxedo: medium-dark skin tone
        trie.insert(new int[]{129333, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 529, 331))); // woman in tuxedo: medium skin tone
        trie.insert(new int[]{129333, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 529, 331))); // woman in tuxedo: medium skin tone
        trie.insert(new int[]{128112, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 727, 265))); // man with veil: medium-light skin tone
        trie.insert(new int[]{128112, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 727, 265))); // man with veil: medium-light skin tone
        trie.insert(new int[]{129328, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 67, 529))); // pregnant woman: light skin tone
        trie.insert(new int[]{129732}, new ParseResult(2, new SpriteCoordinates(2, 3, 199, 67))); // pregnant person
        trie.insert(new int[]{129329, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 1, 529))); // breast-feeding: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 67))); // man feeding baby: medium-dark skin tone
        trie.insert(new int[]{128124, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 463, 661))); // baby angel: medium skin tone
        trie.insert(new int[]{129334, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 529, 199))); // Mrs. Claus: medium-light skin tone
        trie.insert(new int[]{129464, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 463))); // superhero: light skin tone
        trie.insert(new int[]{129464, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 3, 67, 463))); // woman superhero
        trie.insert(new int[]{129464, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 67, 463))); // woman superhero
        trie.insert(new int[]{129465, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 463, 397))); // supervillain: dark skin tone
        trie.insert(new int[]{129465, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 1, 463))); // woman supervillain: medium-dark skin tone
        trie.insert(new int[]{129465, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 1, 463))); // woman supervillain: medium-dark skin tone
        trie.insert(new int[]{129497, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 265, 133))); // man mage: medium skin tone
        trie.insert(new int[]{129497, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 133))); // man mage: medium skin tone
        trie.insert(new int[]{129498, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 265, 1))); // fairy: medium-light skin tone
    }

    public static void init4(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{129498, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 265, 67))); // woman fairy: light skin tone
        trie.insert(new int[]{129498, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 265, 67))); // woman fairy: light skin tone
        trie.insert(new int[]{129499, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 199))); // man vampire
        trie.insert(new int[]{129499, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 133, 199))); // man vampire
        trie.insert(new int[]{129499, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 199, 199))); // woman vampire: dark skin tone
        trie.insert(new int[]{129499, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 199, 199))); // woman vampire: dark skin tone
        trie.insert(new int[]{129500, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 67, 199))); // merman: medium-dark skin tone
        trie.insert(new int[]{129500, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 67, 199))); // merman: medium-dark skin tone
        trie.insert(new int[]{129501, 127997}, new ParseResult(4, new SpriteCoordinates(2, 3, 199, 133))); // elf: medium skin tone
        trie.insert(new int[]{129501, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 1, 199))); // woman elf: medium-light skin tone
        trie.insert(new int[]{129501, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 1, 199))); // woman elf: medium-light skin tone
        trie.insert(new int[]{128134}, new ParseResult(2, new SpriteCoordinates(2, 3, 1, 661))); // person getting massage
        trie.insert(new int[]{128134, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 67, 661))); // man getting massage: dark skin tone
        trie.insert(new int[]{128134, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 67, 661))); // man getting massage: dark skin tone
        trie.insert(new int[]{128135, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 529))); // person getting haircut: medium-dark skin tone
        trie.insert(new int[]{128135, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 661, 595))); // woman getting haircut: medium skin tone
        trie.insert(new int[]{128135, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 661, 595))); // woman getting haircut: medium skin tone
        trie.insert(new int[]{128694, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 133))); // man walking: medium-light skin tone
        trie.insert(new int[]{128694, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 133))); // man walking: medium-light skin tone
        trie.insert(new int[]{128694, 127995, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 199))); // person walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 199))); // person walking facing right
        trie.insert(new int[]{128694, 8205, 9794, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 67))); // man walking facing right
        trie.insert(new int[]{128694, 8205, 9794, 65039, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 67))); // man walking facing right
        trie.insert(new int[]{128694, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 3, 595, 67))); // man walking facing right
        trie.insert(new int[]{128694, 8205, 9794, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 67))); // man walking facing right
        trie.insert(new int[]{129485, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 463, 265))); // person standing: dark skin tone
        trie.insert(new int[]{129485, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 463, 331))); // woman standing: medium-dark skin tone
        trie.insert(new int[]{129485, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 463, 331))); // woman standing: medium-dark skin tone
        trie.insert(new int[]{129486, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 463, 67))); // man kneeling: medium skin tone
        trie.insert(new int[]{129486, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 463, 67))); // man kneeling: medium skin tone
        trie.insert(new int[]{129486, 127996, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 3, 463, 133))); // person kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 463, 133))); // person kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 3, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 3, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 3, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 3, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129489, 8205, 129455, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 3, 1, 331))); // person with white cane facing right
        trie.insert(new int[]{129489, 8205, 129455, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 3, 1, 331))); // person with white cane facing right
        trie.insert(new int[]{128104, 127999, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 3, 529, 793))); // man with white cane: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 3, 661, 727))); // woman with white cane: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 3, 397, 199))); // person in motorized wheelchair: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 3, 859, 463))); // man in motorized wheelchair: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 3, 199, 793))); // woman in motorized wheelchair: light skin tone
        trie.insert(new int[]{129489, 8205, 129469}, new ParseResult(5, new SpriteCoordinates(2, 3, 331, 265))); // person in manual wheelchair
        trie.insert(new int[]{129489, 127999, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 3, 133, 331))); // person in manual wheelchair facing right
        trie.insert(new int[]{129489, 127999, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 3, 133, 331))); // person in manual wheelchair facing right
        trie.insert(new int[]{128104, 127998, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 3, 793, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128104, 127998, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 3, 793, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128105, 127997, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 3, 793, 265))); // woman in manual wheelchair facing right
        trie.insert(new int[]{128105, 127997, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 3, 793, 265))); // woman in manual wheelchair facing right
        trie.insert(new int[]{127939, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 529))); // man running: medium-light skin tone
        trie.insert(new int[]{127939, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 925, 529))); // man running: medium-light skin tone
        trie.insert(new int[]{127939, 127995, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 595))); // person running facing right
        trie.insert(new int[]{127939, 127995, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 3, 925, 595))); // person running facing right
        trie.insert(new int[]{127939, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 3, 925, 463))); // man running facing right
        trie.insert(new int[]{127939, 8205, 9794, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 3, 925, 463))); // man running facing right
        trie.insert(new int[]{127939, 8205, 9794, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 463))); // man running facing right
        trie.insert(new int[]{127939, 8205, 9794, 65039, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 463))); // man running facing right
        trie.insert(new int[]{128131, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 199, 661))); // woman dancing: dark skin tone
        trie.insert(new int[]{128372, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 331))); // person in suit levitating: medium-dark skin tone
        trie.insert(new int[]{129494, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 3, 133, 265))); // man in steamy room
        trie.insert(new int[]{129494, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 133, 265))); // man in steamy room
        trie.insert(new int[]{129494, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 199, 265))); // woman in steamy room: dark skin tone
        trie.insert(new int[]{129494, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 199, 265))); // woman in steamy room: dark skin tone
        trie.insert(new int[]{129495, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 67, 265))); // man climbing: medium-dark skin tone
        trie.insert(new int[]{129495, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 67, 265))); // man climbing: medium-dark skin tone
        trie.insert(new int[]{127943, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 925, 265))); // horse racing: medium-light skin tone
        trie.insert(new int[]{127948, 65039}, new ParseResult(3, new SpriteCoordinates(2, 3, 859, 859))); // person golfing
        trie.insert(new int[]{127948}, new ParseResult(2, new SpriteCoordinates(2, 3, 859, 859))); // person golfing
        trie.insert(new int[]{127948, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 925, 1))); // man golfing: dark skin tone
        trie.insert(new int[]{127948, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 1))); // man golfing: dark skin tone
        trie.insert(new int[]{127940, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 925, 331))); // person surfing: medium-dark skin tone
        trie.insert(new int[]{127940, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 925, 397))); // woman surfing: medium skin tone
        trie.insert(new int[]{127940, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 397))); // woman surfing: medium skin tone
        trie.insert(new int[]{128675, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 529))); // man rowing boat: medium-light skin tone
        trie.insert(new int[]{128675, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 529))); // man rowing boat: medium-light skin tone
        trie.insert(new int[]{127946, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 925, 199))); // person swimming: light skin tone
        trie.insert(new int[]{127946, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 925, 133))); // woman swimming
        trie.insert(new int[]{127946, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 3, 925, 133))); // woman swimming
        trie.insert(new int[]{9977, 127999}, new ParseResult(3, new SpriteCoordinates(2, 3, 67, 1))); // person bouncing ball: dark skin tone
        trie.insert(new int[]{9977, 127998, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 3, 1, 67))); // woman bouncing ball: medium-dark skin tone
        trie.insert(new int[]{9977, 127998, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 3, 1, 67))); // woman bouncing ball: medium-dark skin tone
        trie.insert(new int[]{127947, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 925, 67))); // man lifting weights: medium skin tone
        trie.insert(new int[]{127947, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 925, 67))); // man lifting weights: medium skin tone
        trie.insert(new int[]{128692, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 595, 397))); // person biking: medium-light skin tone
        trie.insert(new int[]{128692, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 463))); // woman biking: light skin tone
        trie.insert(new int[]{128692, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 463))); // woman biking: light skin tone
        trie.insert(new int[]{128693, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 595, 265))); // man mountain biking
        trie.insert(new int[]{128693, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 3, 595, 265))); // man mountain biking
        trie.insert(new int[]{128693, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 595, 331))); // woman mountain biking: dark skin tone
        trie.insert(new int[]{128693, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 595, 331))); // woman mountain biking: dark skin tone
        trie.insert(new int[]{129336, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 529, 67))); // man cartwheeling: medium-dark skin tone
        trie.insert(new int[]{129336, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 529, 67))); // man cartwheeling: medium-dark skin tone
        trie.insert(new int[]{129341}, new ParseResult(2, new SpriteCoordinates(2, 3, 397, 463))); // person playing water polo
        trie.insert(new int[]{129341, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 463, 463))); // man playing water polo: dark skin tone
        trie.insert(new int[]{129341, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 463, 463))); // man playing water polo: dark skin tone
        trie.insert(new int[]{129342, 127998}, new ParseResult(4, new SpriteCoordinates(2, 3, 265, 463))); // person playing handball: medium-dark skin tone
        trie.insert(new int[]{129342, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 331, 463))); // woman playing handball: medium skin tone
        trie.insert(new int[]{129342, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 3, 331, 463))); // woman playing handball: medium skin tone
        trie.insert(new int[]{129337, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 3, 529, 1))); // man juggling: medium-light skin tone
        trie.insert(new int[]{129337, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 3, 529, 1))); // man juggling: medium-light skin tone
        trie.insert(new int[]{129496, 127995}, new ParseResult(4, new SpriteCoordinates(2, 3, 1, 265))); // person in lotus position: light skin tone
        trie.insert(new int[]{129496, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 3, 265, 199))); // woman in lotus position
        trie.insert(new int[]{129496, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 3, 265, 199))); // woman in lotus position
        trie.insert(new int[]{128704, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 595, 1))); // person taking bath: dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129309, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 3, 199, 397))); // people holding hands: light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129309, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 3, 397, 265))); // people holding hands: medium skin tone, dark skin tone
        trie.insert(new int[]{128109}, new ParseResult(2, new SpriteCoordinates(2, 3, 727, 397))); // women holding hands
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 3, 793, 397))); // women holding hands: medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 3, 331, 727))); // women holding hands: dark skin tone, medium-light skin tone
        trie.insert(new int[]{128107, 127996}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 529))); // woman and man holding hands: medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 3, 727, 727))); // woman and man holding hands: medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 3, 859, 793))); // men holding hands: light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 3, 859, 199))); // men holding hands: medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128108, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 727, 463))); // men holding hands: dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995}, new ParseResult(15, new SpriteCoordinates(2, 3, 1, 397))); // kiss: person, person, medium-light skin tone, light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127995}, new ParseResult(14, new SpriteCoordinates(2, 3, 1, 397))); // kiss: person, person, medium-light skin tone, light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 128139, 8205, 129489, 127999}, new ParseResult(14, new SpriteCoordinates(2, 3, 331, 331))); // kiss: person, person, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999}, new ParseResult(15, new SpriteCoordinates(2, 3, 331, 331))); // kiss: person, person, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 3, 793, 661))); // kiss: woman, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 3, 793, 661))); // kiss: woman, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 3, 529, 727))); // kiss: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 3, 529, 727))); // kiss: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 3, 859, 661))); // kiss: man, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 3, 859, 661))); // kiss: man, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 3, 859, 133))); // kiss: man, man, medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 3, 859, 133))); // kiss: man, man, medium skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 3, 397, 793))); // kiss: man, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 3, 397, 793))); // kiss: man, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998}, new ParseResult(15, new SpriteCoordinates(2, 3, 793, 595))); // kiss: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127998}, new ParseResult(14, new SpriteCoordinates(2, 3, 793, 595))); // kiss: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999}, new ParseResult(15, new SpriteCoordinates(2, 3, 463, 727))); // kiss: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127999}, new ParseResult(14, new SpriteCoordinates(2, 3, 463, 727))); // kiss: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128145, 127999}, new ParseResult(4, new SpriteCoordinates(2, 3, 661, 463))); // couple with heart: dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 129489, 127998}, new ParseResult(11, new SpriteCoordinates(2, 3, 397, 133))); // couple with heart: person, person, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 3, 397, 133))); // couple with heart: person, person, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 3, 133, 793))); // couple with heart: woman, man, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 3, 133, 793))); // couple with heart: woman, man, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 3, 793, 199))); // couple with heart: woman, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 3, 793, 199))); // couple with heart: woman, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 3, 199, 727))); // couple with heart: woman, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 3, 199, 727))); // couple with heart: woman, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 3, 859, 331))); // couple with heart: man, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 3, 859, 331))); // couple with heart: man, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 3, 727, 793))); // couple with heart: man, man, medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 3, 727, 793))); // couple with heart: man, man, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128105, 127998}, new ParseResult(11, new SpriteCoordinates(2, 3, 67, 793))); // couple with heart: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 3, 67, 793))); // couple with heart: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 3, 793, 133))); // couple with heart: woman, woman, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128105, 127999}, new ParseResult(11, new SpriteCoordinates(2, 3, 793, 133))); // couple with heart: woman, woman, medium skin tone, dark skin tone
        trie.insert(new int[]{128104, 8205, 128105, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 3, 331, 793))); // family: man, woman, boy
        trie.insert(new int[]{128105, 8205, 128105, 8205, 128103}, new ParseResult(8, new SpriteCoordinates(2, 3, 67, 727))); // family: woman, woman, girl
        trie.insert(new int[]{128105, 8205, 128103}, new ParseResult(5, new SpriteCoordinates(2, 3, 133, 727))); // family: woman, girl
        trie.insert(new int[]{129489, 8205, 129490, 8205, 129490}, new ParseResult(8, new SpriteCoordinates(2, 3, 331, 199))); // family: adult, child, child
        trie.insert(new int[]{128075, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 331, 859))); // waving hand: medium-dark skin tone
        trie.insert(new int[]{128400, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 661, 1))); // hand with fingers splayed: medium skin tone
        trie.insert(new int[]{128406, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 595, 595))); // vulcan salute: medium-light skin tone
        trie.insert(new int[]{129778, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 133))); // leftwards hand: light skin tone
        trie.insert(new int[]{129780}, new ParseResult(2, new SpriteCoordinates(2, 4, 133, 67))); // palm up hand
        trie.insert(new int[]{129783, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 67))); // leftwards pushing hand: dark skin tone
        trie.insert(new int[]{128076, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 265, 859))); // OK hand: medium-dark skin tone
        trie.insert(new int[]{129295, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 397, 529))); // pinching hand: medium skin tone
        trie.insert(new int[]{129310, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 199, 529))); // crossed fingers: medium-light skin tone
        trie.insert(new int[]{129311, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 133, 529))); // love-you gesture: light skin tone
        trie.insert(new int[]{129305}, new ParseResult(2, new SpriteCoordinates(2, 4, 331, 529))); // call me hand
        trie.insert(new int[]{128072, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 463, 859))); // backhand index pointing left: dark skin tone
        trie.insert(new int[]{128070, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 595, 859))); // backhand index pointing up: medium-dark skin tone
        trie.insert(new int[]{128071, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 859))); // backhand index pointing down: medium skin tone
        trie.insert(new int[]{129781, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 133, 1))); // index pointing at the viewer: medium-light skin tone
        trie.insert(new int[]{128078, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 199, 859))); // thumbs down: light skin tone
        trie.insert(new int[]{128074}, new ParseResult(2, new SpriteCoordinates(2, 4, 397, 859))); // oncoming fist
        trie.insert(new int[]{129307, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 265, 529))); // left-facing fist: dark skin tone
        trie.insert(new int[]{128079, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 133, 859))); // clapping hands: medium-dark skin tone
        trie.insert(new int[]{129782, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 67, 67))); // heart hands: medium skin tone
        trie.insert(new int[]{129330, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 397))); // palms up together: medium-light skin tone
        trie.insert(new int[]{129777, 127995, 8205, 129778, 127997}, new ParseResult(9, new SpriteCoordinates(2, 4, 133, 133))); // handshake: light skin tone, medium skin tone
        trie.insert(new int[]{129777, 127998, 8205, 129778, 127995}, new ParseResult(9, new SpriteCoordinates(2, 4, 67, 133))); // handshake: medium-dark skin tone, light skin tone
        trie.insert(new int[]{128591, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 595, 397))); // folded hands: medium skin tone
        trie.insert(new int[]{128133, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 67, 661))); // nail polish: medium-light skin tone
        trie.insert(new int[]{128170, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 661, 331))); // flexed biceps: light skin tone
        trie.insert(new int[]{129461, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 463))); // leg: medium-dark skin tone
        trie.insert(new int[]{128066, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 793, 859))); // ear: medium skin tone
        trie.insert(new int[]{128067, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 727, 859))); // nose: medium-light skin tone
        trie.insert(new int[]{128069}, new ParseResult(2, new SpriteCoordinates(2, 4, 661, 859))); // tongue
        trie.insert(new int[]{129490, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 331, 67))); // child: medium-light skin tone
        trie.insert(new int[]{128103, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 859))); // girl: light skin tone
        trie.insert(new int[]{128113}, new ParseResult(2, new SpriteCoordinates(2, 4, 661, 661))); // person: blond hair
        trie.insert(new int[]{128104, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 397, 793))); // man: dark skin tone
        trie.insert(new int[]{129492, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 265))); // man: medium-dark skin tone, beard
        trie.insert(new int[]{129492, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 265, 265))); // man: medium-dark skin tone, beard
        trie.insert(new int[]{128104, 127997, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 199))); // man: medium skin tone, red hair
        trie.insert(new int[]{128104, 127996, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 463))); // man: medium-light skin tone, white hair
        trie.insert(new int[]{128105, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 793, 463))); // woman: light skin tone
        trie.insert(new int[]{129489, 8205, 129456}, new ParseResult(5, new SpriteCoordinates(2, 4, 331, 133))); // person: red hair
        trie.insert(new int[]{128105, 127999, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 4, 727, 661))); // woman: dark skin tone, curly hair
        trie.insert(new int[]{128105, 127998, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 4, 463, 727))); // woman: medium-dark skin tone, white hair
        trie.insert(new int[]{128105, 127997, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 4, 727, 727))); // woman: medium skin tone, bald
        trie.insert(new int[]{128113, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 727, 1))); // woman: medium-light skin tone, blond hair
        trie.insert(new int[]{128113, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 727, 1))); // woman: medium-light skin tone, blond hair
        trie.insert(new int[]{129491, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 331, 1))); // older person: light skin tone
        trie.insert(new int[]{128117}, new ParseResult(2, new SpriteCoordinates(2, 4, 463, 661))); // old woman
        trie.insert(new int[]{128589, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 595, 529))); // person frowning: dark skin tone
        trie.insert(new int[]{128589, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 1, 595))); // woman frowning: medium-dark skin tone
        trie.insert(new int[]{128589, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 1, 595))); // woman frowning: medium-dark skin tone
        trie.insert(new int[]{128590, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 595, 463))); // man pouting: medium skin tone
        trie.insert(new int[]{128590, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 463))); // man pouting: medium skin tone
        trie.insert(new int[]{128581, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 463, 595))); // person gesturing NO: medium-light skin tone
        trie.insert(new int[]{128581, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 529, 595))); // woman gesturing NO: light skin tone
        trie.insert(new int[]{128581, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 529, 595))); // woman gesturing NO: light skin tone
        trie.insert(new int[]{128582, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 331, 595))); // man gesturing OK
        trie.insert(new int[]{128582, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 4, 331, 595))); // man gesturing OK
        trie.insert(new int[]{128582, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 397, 595))); // woman gesturing OK: dark skin tone
        trie.insert(new int[]{128582, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 595))); // woman gesturing OK: dark skin tone
        trie.insert(new int[]{128129, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 199, 661))); // man tipping hand: medium-dark skin tone
        trie.insert(new int[]{128129, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 199, 661))); // man tipping hand: medium-dark skin tone
        trie.insert(new int[]{128587, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 67, 595))); // person raising hand: medium skin tone
        trie.insert(new int[]{128587, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 133, 595))); // woman raising hand: medium-light skin tone
        trie.insert(new int[]{128587, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 133, 595))); // woman raising hand: medium-light skin tone
        trie.insert(new int[]{129487, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 265, 397))); // deaf man: light skin tone
        trie.insert(new int[]{129487, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 397))); // deaf man: light skin tone
        trie.insert(new int[]{128583}, new ParseResult(2, new SpriteCoordinates(2, 4, 199, 595))); // person bowing
        trie.insert(new int[]{128583, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 595))); // man bowing: dark skin tone
        trie.insert(new int[]{128583, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 265, 595))); // man bowing: dark skin tone
        trie.insert(new int[]{129318, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 529))); // person facepalming: medium-dark skin tone
        trie.insert(new int[]{129318, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 67, 529))); // woman facepalming: medium skin tone
        trie.insert(new int[]{129318, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 67, 529))); // woman facepalming: medium skin tone
        trie.insert(new int[]{129335, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 529, 67))); // man shrugging: medium-light skin tone
        trie.insert(new int[]{129335, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 529, 67))); // man shrugging: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 4, 397, 331))); // health worker: light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 331))); // health worker: light skin tone
        trie.insert(new int[]{128105, 8205, 9877, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 727, 331))); // woman health worker
        trie.insert(new int[]{128105, 8205, 9877}, new ParseResult(4, new SpriteCoordinates(2, 4, 727, 331))); // woman health worker
        trie.insert(new int[]{129489, 127999, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 4, 67, 331))); // student: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 727))); // woman student: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 331))); // man teacher: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 4, 397, 133))); // judge: medium-light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 133))); // judge: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 4, 793, 661))); // woman judge: light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 793, 661))); // woman judge: light skin tone
        trie.insert(new int[]{128104, 8205, 127806}, new ParseResult(5, new SpriteCoordinates(2, 4, 859, 793))); // man farmer
        trie.insert(new int[]{128105, 127999, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 4, 199, 727))); // woman farmer: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 4, 793, 793))); // man cook: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 1))); // mechanic: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 4, 793, 397))); // woman mechanic: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 727))); // man factory worker: light skin tone
        trie.insert(new int[]{129489, 8205, 128188}, new ParseResult(5, new SpriteCoordinates(2, 4, 331, 199))); // office worker
        trie.insert(new int[]{128104, 127999, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 793))); // man office worker: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 331))); // scientist: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 4, 793, 67))); // woman scientist: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 529))); // man technologist: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 4, 199, 397))); // singer: light skin tone
        trie.insert(new int[]{128105, 8205, 127908}, new ParseResult(5, new SpriteCoordinates(2, 4, 1, 793))); // woman singer
        trie.insert(new int[]{129489, 127999, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 4, 1, 331))); // artist: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 4, 529, 727))); // woman artist: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 4, 859, 67))); // man pilot: medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 67))); // man pilot: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 199))); // astronaut: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 4, 793, 727))); // woman astronaut: light skin tone
        trie.insert(new int[]{128104, 8205, 128658}, new ParseResult(5, new SpriteCoordinates(2, 4, 265, 793))); // man firefighter
        trie.insert(new int[]{128105, 127999, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 4, 133, 727))); // woman firefighter: dark skin tone
        trie.insert(new int[]{128110, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 727, 133))); // man police officer: medium-dark skin tone
        trie.insert(new int[]{128110, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 727, 133))); // man police officer: medium-dark skin tone
        trie.insert(new int[]{128373, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 661, 133))); // detective: medium skin tone
        trie.insert(new int[]{128373, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 661, 199))); // woman detective: medium-light skin tone
        trie.insert(new int[]{128373, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 661, 199))); // woman detective: medium-light skin tone
        trie.insert(new int[]{128130, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 133, 661))); // man guard: light skin tone
        trie.insert(new int[]{128130, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 133, 661))); // man guard: light skin tone
        trie.insert(new int[]{129399}, new ParseResult(2, new SpriteCoordinates(2, 4, 67, 463))); // ninja
        trie.insert(new int[]{128119, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 331, 661))); // construction worker: dark skin tone
        trie.insert(new int[]{128119, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 661))); // woman construction worker: medium-dark skin tone
        trie.insert(new int[]{128119, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 397, 661))); // woman construction worker: medium-dark skin tone
        trie.insert(new int[]{129332, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 331))); // prince: medium skin tone
        trie.insert(new int[]{128115, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 661))); // person wearing turban: medium-light skin tone
        trie.insert(new int[]{128115, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 661))); // woman wearing turban: light skin tone
        trie.insert(new int[]{128115, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 595, 661))); // woman wearing turban: light skin tone
        trie.insert(new int[]{129493}, new ParseResult(2, new SpriteCoordinates(2, 4, 199, 265))); // woman with headscarf
        trie.insert(new int[]{129333, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 199))); // person in tuxedo: dark skin tone
        trie.insert(new int[]{129333, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 529, 265))); // woman in tuxedo: medium-dark skin tone
        trie.insert(new int[]{129333, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 529, 265))); // woman in tuxedo: medium-dark skin tone
        trie.insert(new int[]{128112, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 727, 67))); // man with veil: medium skin tone
        trie.insert(new int[]{128112, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 727, 67))); // man with veil: medium skin tone
        trie.insert(new int[]{129328, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 463))); // pregnant woman: medium-light skin tone
        trie.insert(new int[]{129732, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 199, 1))); // pregnant person: light skin tone
        trie.insert(new int[]{128105, 8205, 127868}, new ParseResult(5, new SpriteCoordinates(2, 4, 67, 793))); // woman feeding baby
        trie.insert(new int[]{128104, 127999, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 4, 661, 793))); // man feeding baby: dark skin tone
        trie.insert(new int[]{128124, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 265, 661))); // baby angel: medium-dark skin tone
        trie.insert(new int[]{129334, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 529, 133))); // Mrs. Claus: medium skin tone
        trie.insert(new int[]{129464, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 463, 331))); // superhero: medium-light skin tone
        trie.insert(new int[]{129464, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 463, 397))); // woman superhero: light skin tone
        trie.insert(new int[]{129464, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 463, 397))); // woman superhero: light skin tone
        trie.insert(new int[]{129465, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 4, 463, 199))); // man supervillain
        trie.insert(new int[]{129465, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 463, 199))); // man supervillain
        trie.insert(new int[]{129465, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 463, 265))); // woman supervillain: dark skin tone
        trie.insert(new int[]{129465, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 463, 265))); // woman supervillain: dark skin tone
        trie.insert(new int[]{129497, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 67))); // man mage: medium-dark skin tone
        trie.insert(new int[]{129497, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 265, 67))); // man mage: medium-dark skin tone
        trie.insert(new int[]{129498, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 199, 199))); // fairy: medium skin tone
        trie.insert(new int[]{129498, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 265, 1))); // woman fairy: medium-light skin tone
        trie.insert(new int[]{129498, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 1))); // woman fairy: medium-light skin tone
        trie.insert(new int[]{129499, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 133, 199))); // man vampire: light skin tone
        trie.insert(new int[]{129499, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 133, 199))); // man vampire: light skin tone
        trie.insert(new int[]{129500}, new ParseResult(2, new SpriteCoordinates(2, 4, 1, 199))); // merperson
        trie.insert(new int[]{129500, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 67, 199))); // merman: dark skin tone
        trie.insert(new int[]{129500, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 67, 199))); // merman: dark skin tone
        trie.insert(new int[]{129501, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 199, 67))); // elf: medium-dark skin tone
        trie.insert(new int[]{129501, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 199, 133))); // woman elf: medium skin tone
        trie.insert(new int[]{129501, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 199, 133))); // woman elf: medium skin tone
        trie.insert(new int[]{128134, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 661))); // person getting massage: light skin tone
        trie.insert(new int[]{128134, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 4, 661, 595))); // woman getting massage
        trie.insert(new int[]{128134, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 661, 595))); // woman getting massage
        trie.insert(new int[]{128135, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 661, 463))); // person getting haircut: dark skin tone
        trie.insert(new int[]{128135, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 661, 529))); // woman getting haircut: medium-dark skin tone
        trie.insert(new int[]{128135, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 661, 529))); // woman getting haircut: medium-dark skin tone
        trie.insert(new int[]{128694, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 529, 529))); // man walking: medium skin tone
        trie.insert(new int[]{128694, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 529, 529))); // man walking: medium skin tone
        trie.insert(new int[]{128694, 127996, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 4, 595, 1))); // person walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 1))); // person walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 4, 595, 67))); // man walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 4, 595, 67))); // man walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 4, 595, 67))); // man walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 4, 595, 67))); // man walking facing right
        trie.insert(new int[]{129485, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 463, 67))); // man standing
        trie.insert(new int[]{129485, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 4, 463, 67))); // man standing
        trie.insert(new int[]{129485, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 463, 133))); // woman standing: dark skin tone
        trie.insert(new int[]{129485, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 463, 133))); // woman standing: dark skin tone
        trie.insert(new int[]{129486, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 331, 397))); // man kneeling: medium-dark skin tone
        trie.insert(new int[]{129486, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 331, 397))); // man kneeling: medium-dark skin tone
        trie.insert(new int[]{129486, 127997, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 397))); // person kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 4, 397, 397))); // person kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 4, 463, 1))); // man kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 4, 463, 1))); // man kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 4, 463, 1))); // man kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 4, 463, 1))); // man kneeling facing right
        trie.insert(new int[]{129489, 127995, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 4, 67, 397))); // person with white cane facing right
        trie.insert(new int[]{129489, 127995, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 4, 67, 397))); // person with white cane facing right
        trie.insert(new int[]{128104, 8205, 129455, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 4, 199, 793))); // man with white cane facing right
        trie.insert(new int[]{128104, 8205, 129455, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 4, 199, 793))); // man with white cane facing right
        trie.insert(new int[]{128105, 127999, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 4, 1, 727))); // woman with white cane: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 4, 133, 331))); // person in motorized wheelchair: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 4, 859, 133))); // man in motorized wheelchair: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 4, 793, 265))); // woman in motorized wheelchair: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 4, 1, 397))); // person in manual wheelchair: light skin tone
        trie.insert(new int[]{128104, 8205, 129469}, new ParseResult(5, new SpriteCoordinates(2, 4, 133, 793))); // man in manual wheelchair
        trie.insert(new int[]{128104, 127999, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 4, 529, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128104, 127999, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 4, 529, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128105, 127998, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 4, 397, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{128105, 127998, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 4, 397, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{127939, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 925, 463))); // man running: medium skin tone
        trie.insert(new int[]{127939, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 925, 463))); // man running: medium skin tone
        trie.insert(new int[]{127939, 127996, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 925, 529))); // person running facing right
        trie.insert(new int[]{127939, 127996, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 4, 925, 529))); // person running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 4, 925, 595))); // man running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 4, 925, 595))); // man running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 4, 925, 595))); // man running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 4, 925, 595))); // man running facing right
        trie.insert(new int[]{128378}, new ParseResult(2, new SpriteCoordinates(2, 4, 661, 67))); // man dancing
        trie.insert(new int[]{128372, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 661, 265))); // person in suit levitating: dark skin tone
        trie.insert(new int[]{129494, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 133, 265))); // man in steamy room: light skin tone
        trie.insert(new int[]{129494, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 133, 265))); // man in steamy room: light skin tone
        trie.insert(new int[]{129495}, new ParseResult(2, new SpriteCoordinates(2, 4, 1, 265))); // person climbing
        trie.insert(new int[]{129495, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 67, 265))); // man climbing: dark skin tone
        trie.insert(new int[]{129495, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 67, 265))); // man climbing: dark skin tone
        trie.insert(new int[]{127943, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 925, 265))); // horse racing: medium skin tone
        trie.insert(new int[]{127948, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 925, 1))); // person golfing: light skin tone
        trie.insert(new int[]{127948, 65039, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 4, 859, 859))); // woman golfing
        trie.insert(new int[]{127948, 65039, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 4, 859, 859))); // woman golfing
        trie.insert(new int[]{127948, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 4, 859, 859))); // woman golfing
        trie.insert(new int[]{127948, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 859, 859))); // woman golfing
        trie.insert(new int[]{127940, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 925, 331))); // person surfing: dark skin tone
        trie.insert(new int[]{127940, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 925, 397))); // woman surfing: medium-dark skin tone
        trie.insert(new int[]{127940, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 925, 397))); // woman surfing: medium-dark skin tone
        trie.insert(new int[]{128675, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 595, 331))); // man rowing boat: medium skin tone
        trie.insert(new int[]{128675, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 331))); // man rowing boat: medium skin tone
        trie.insert(new int[]{127946, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 925, 133))); // person swimming: medium-light skin tone
        trie.insert(new int[]{127946, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 925, 199))); // woman swimming: light skin tone
        trie.insert(new int[]{127946, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 925, 199))); // woman swimming: light skin tone
        trie.insert(new int[]{9977, 8205, 9794}, new ParseResult(3, new SpriteCoordinates(2, 4, 1, 1))); // man bouncing ball
        trie.insert(new int[]{9977, 65039, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 1))); // man bouncing ball
        trie.insert(new int[]{9977, 65039, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 1, 1))); // man bouncing ball
        trie.insert(new int[]{9977, 8205, 9794, 65039}, new ParseResult(4, new SpriteCoordinates(2, 4, 1, 1))); // man bouncing ball
        trie.insert(new int[]{9977, 127999, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 4, 67, 1))); // woman bouncing ball: dark skin tone
        trie.insert(new int[]{9977, 127999, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 4, 67, 1))); // woman bouncing ball: dark skin tone
        trie.insert(new int[]{127947, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 925, 67))); // man lifting weights: medium-dark skin tone
        trie.insert(new int[]{127947, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 925, 67))); // man lifting weights: medium-dark skin tone
        trie.insert(new int[]{128692, 127997}, new ParseResult(4, new SpriteCoordinates(2, 4, 595, 199))); // person biking: medium skin tone
        trie.insert(new int[]{128692, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 595, 265))); // woman biking: medium-light skin tone
        trie.insert(new int[]{128692, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 265))); // woman biking: medium-light skin tone
        trie.insert(new int[]{128693, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 595, 133))); // man mountain biking: light skin tone
        trie.insert(new int[]{128693, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 595, 133))); // man mountain biking: light skin tone
        trie.insert(new int[]{129336}, new ParseResult(2, new SpriteCoordinates(2, 4, 463, 463))); // person cartwheeling
        trie.insert(new int[]{129336, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 529, 1))); // man cartwheeling: dark skin tone
        trie.insert(new int[]{129336, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 529, 1))); // man cartwheeling: dark skin tone
        trie.insert(new int[]{129341, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 331, 463))); // person playing water polo: light skin tone
        trie.insert(new int[]{129341, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 4, 265, 463))); // woman playing water polo
        trie.insert(new int[]{129341, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 4, 265, 463))); // woman playing water polo
        trie.insert(new int[]{129342, 127999}, new ParseResult(4, new SpriteCoordinates(2, 4, 133, 463))); // person playing handball: dark skin tone
        trie.insert(new int[]{129342, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 199, 463))); // woman playing handball: medium-dark skin tone
        trie.insert(new int[]{129342, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 199, 463))); // woman playing handball: medium-dark skin tone
        trie.insert(new int[]{129337, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 397, 463))); // man juggling: medium skin tone
        trie.insert(new int[]{129337, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 4, 397, 463))); // man juggling: medium skin tone
        trie.insert(new int[]{129496, 127996}, new ParseResult(4, new SpriteCoordinates(2, 4, 265, 133))); // person in lotus position: medium-light skin tone
        trie.insert(new int[]{129496, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 4, 265, 199))); // woman in lotus position: light skin tone
        trie.insert(new int[]{129496, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 4, 265, 199))); // woman in lotus position: light skin tone
        trie.insert(new int[]{128716}, new ParseResult(2, new SpriteCoordinates(2, 4, 463, 529))); // person in bed
        trie.insert(new int[]{129489, 127995, 8205, 129309, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 4, 133, 397))); // people holding hands: light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129309, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 4, 199, 331))); // people holding hands: medium-dark skin tone, light skin tone
        trie.insert(new int[]{128109, 127995}, new ParseResult(4, new SpriteCoordinates(2, 4, 727, 199))); // women holding hands: light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 4, 793, 1))); // women holding hands: medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 4, 67, 727))); // women holding hands: dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 4, 793, 331))); // woman and man holding hands: medium-light skin tone, medium skin tone
        trie.insert(new int[]{128107, 127998}, new ParseResult(4, new SpriteCoordinates(2, 4, 727, 265))); // woman and man holding hands: medium-dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 4, 859, 661))); // men holding hands: light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 4, 859, 265))); // men holding hands: medium skin tone, dark skin tone
        trie.insert(new int[]{128143}, new ParseResult(2, new SpriteCoordinates(2, 4, 661, 397))); // kiss
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127997}, new ParseResult(14, new SpriteCoordinates(2, 4, 397, 67))); // kiss: person, person, medium-light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997}, new ParseResult(15, new SpriteCoordinates(2, 4, 397, 67))); // kiss: person, person, medium-light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127995}, new ParseResult(14, new SpriteCoordinates(2, 4, 331, 265))); // kiss: person, person, dark skin tone, light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995}, new ParseResult(15, new SpriteCoordinates(2, 4, 331, 265))); // kiss: person, person, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 4, 793, 199))); // kiss: woman, man, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 4, 793, 199))); // kiss: woman, man, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 4, 265, 727))); // kiss: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 4, 265, 727))); // kiss: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 4, 859, 595))); // kiss: man, man, light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 4, 859, 595))); // kiss: man, man, light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 4, 859, 1))); // kiss: man, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 4, 859, 1))); // kiss: man, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 4, 463, 793))); // kiss: man, man, dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 4, 463, 793))); // kiss: man, man, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128105, 127999}, new ParseResult(14, new SpriteCoordinates(2, 4, 793, 133))); // kiss: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999}, new ParseResult(15, new SpriteCoordinates(2, 4, 793, 133))); // kiss: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127995}, new ParseResult(14, new SpriteCoordinates(2, 4, 727, 529))); // kiss: woman, woman, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995}, new ParseResult(15, new SpriteCoordinates(2, 4, 727, 529))); // kiss: woman, woman, dark skin tone, light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 4, 397, 265))); // couple with heart: person, person, light skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 129489, 127996}, new ParseResult(11, new SpriteCoordinates(2, 4, 397, 265))); // couple with heart: person, person, light skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 4, 331, 331))); // couple with heart: person, person, medium skin tone, dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 129489, 127999}, new ParseResult(11, new SpriteCoordinates(2, 4, 331, 331))); // couple with heart: person, person, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 4, 793, 595))); // couple with heart: woman, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 4, 793, 595))); // couple with heart: woman, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 4, 661, 727))); // couple with heart: woman, man, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 4, 661, 727))); // couple with heart: woman, man, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 4, 727, 595))); // couple with heart: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 4, 727, 595))); // couple with heart: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 4, 859, 397))); // couple with heart: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 4, 859, 397))); // couple with heart: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 4, 727, 793))); // couple with heart: man, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 4, 727, 793))); // couple with heart: man, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 4, 793, 529))); // couple with heart: woman, woman, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128105, 127999}, new ParseResult(11, new SpriteCoordinates(2, 4, 793, 529))); // couple with heart: woman, woman, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 4, 331, 727))); // couple with heart: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128105, 127995}, new ParseResult(11, new SpriteCoordinates(2, 4, 331, 727))); // couple with heart: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128104, 8205, 128105, 8205, 128103}, new ParseResult(8, new SpriteCoordinates(2, 4, 331, 793))); // family: man, woman, girl
        trie.insert(new int[]{128105, 8205, 128105, 8205, 128103, 8205, 128102}, new ParseResult(11, new SpriteCoordinates(2, 4, 727, 397))); // family: woman, woman, girl, boy
        trie.insert(new int[]{128105, 8205, 128103, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 4, 727, 463))); // family: woman, girl, boy
        trie.insert(new int[]{128099}, new ParseResult(2, new SpriteCoordinates(2, 4, 67, 859))); // footprints
        trie.insert(new int[]{128075, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 199, 859))); // waving hand: dark skin tone
        trie.insert(new int[]{128400, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 1))); // hand with fingers splayed: medium-dark skin tone
    }

    public static void init5(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{128406, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 595, 595))); // vulcan salute: medium skin tone
        trie.insert(new int[]{129778, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 67))); // leftwards hand: medium-light skin tone
        trie.insert(new int[]{129780, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 1))); // palm up hand: light skin tone
        trie.insert(new int[]{129784}, new ParseResult(2, new SpriteCoordinates(2, 5, 67, 1))); // rightwards pushing hand
        trie.insert(new int[]{128076, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 859))); // OK hand: dark skin tone
        trie.insert(new int[]{129295, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 463, 529))); // pinching hand: medium-dark skin tone
        trie.insert(new int[]{129310, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 265, 529))); // crossed fingers: medium skin tone
        trie.insert(new int[]{129311, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 199, 529))); // love-you gesture: medium-light skin tone
        trie.insert(new int[]{129305, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 397, 529))); // call me hand: light skin tone
        trie.insert(new int[]{128073}, new ParseResult(2, new SpriteCoordinates(2, 5, 331, 859))); // backhand index pointing right
        trie.insert(new int[]{128070, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 463, 859))); // backhand index pointing up: dark skin tone
        trie.insert(new int[]{128071, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 397, 859))); // backhand index pointing down: medium-dark skin tone
        trie.insert(new int[]{129781, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 67, 67))); // index pointing at the viewer: medium skin tone
        trie.insert(new int[]{128078, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 67, 859))); // thumbs down: medium-light skin tone
        trie.insert(new int[]{128074, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 265, 859))); // oncoming fist: light skin tone
        trie.insert(new int[]{129308}, new ParseResult(2, new SpriteCoordinates(2, 5, 331, 529))); // right-facing fist
        trie.insert(new int[]{128079, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 859))); // clapping hands: dark skin tone
        trie.insert(new int[]{129782, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 67))); // heart hands: medium-dark skin tone
        trie.insert(new int[]{129330, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 463))); // palms up together: medium skin tone
        trie.insert(new int[]{129777, 127995, 8205, 129778, 127998}, new ParseResult(9, new SpriteCoordinates(2, 5, 67, 133))); // handshake: light skin tone, medium-dark skin tone
        trie.insert(new int[]{129777, 127998, 8205, 129778, 127996}, new ParseResult(9, new SpriteCoordinates(2, 5, 1, 133))); // handshake: medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128591, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 595, 463))); // folded hands: medium-dark skin tone
        trie.insert(new int[]{128133, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 661))); // nail polish: medium skin tone
        trie.insert(new int[]{128170, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 265))); // flexed biceps: medium-light skin tone
        trie.insert(new int[]{129461, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 67, 463))); // leg: dark skin tone
        trie.insert(new int[]{128066, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 859))); // ear: medium-dark skin tone
        trie.insert(new int[]{128067, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 595, 859))); // nose: medium skin tone
        trie.insert(new int[]{128068}, new ParseResult(2, new SpriteCoordinates(2, 5, 529, 859))); // mouth
        trie.insert(new int[]{129490, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 331, 133))); // child: medium skin tone
        trie.insert(new int[]{128103, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 859, 793))); // girl: medium-light skin tone
        trie.insert(new int[]{128113, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 727, 1))); // person: light skin tone, blond hair
        trie.insert(new int[]{129492}, new ParseResult(2, new SpriteCoordinates(2, 5, 265, 265))); // person: beard
        trie.insert(new int[]{129492, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 331, 1))); // man: dark skin tone, beard
        trie.insert(new int[]{129492, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 331, 1))); // man: dark skin tone, beard
        trie.insert(new int[]{128104, 127998, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 793))); // man: medium-dark skin tone, red hair
        trie.insert(new int[]{128104, 127997, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 5, 859, 1))); // man: medium skin tone, white hair
        trie.insert(new int[]{128105, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 793, 331))); // woman: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 5, 133, 397))); // person: light skin tone, red hair
        trie.insert(new int[]{129489, 8205, 129457}, new ParseResult(5, new SpriteCoordinates(2, 5, 331, 199))); // person: curly hair
        trie.insert(new int[]{128105, 127999, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 5, 265, 727))); // woman: dark skin tone, white hair
        trie.insert(new int[]{128105, 127998, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 5, 661, 727))); // woman: medium-dark skin tone, bald
        trie.insert(new int[]{128113, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 661, 661))); // woman: medium skin tone, blond hair
        trie.insert(new int[]{128113, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 661, 661))); // woman: medium skin tone, blond hair
        trie.insert(new int[]{129491, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 331, 67))); // older person: medium-light skin tone
        trie.insert(new int[]{128117, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 463, 661))); // old woman: light skin tone
        trie.insert(new int[]{128589, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 1, 595))); // man frowning
        trie.insert(new int[]{128589, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 595))); // man frowning
        trie.insert(new int[]{128589, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 67, 595))); // woman frowning: dark skin tone
        trie.insert(new int[]{128589, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 67, 595))); // woman frowning: dark skin tone
        trie.insert(new int[]{128590, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 529))); // man pouting: medium-dark skin tone
        trie.insert(new int[]{128590, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 529))); // man pouting: medium-dark skin tone
        trie.insert(new int[]{128581, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 463, 595))); // person gesturing NO: medium skin tone
        trie.insert(new int[]{128581, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 529, 595))); // woman gesturing NO: medium-light skin tone
        trie.insert(new int[]{128581, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 529, 595))); // woman gesturing NO: medium-light skin tone
        trie.insert(new int[]{128582, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 595))); // man gesturing OK: light skin tone
        trie.insert(new int[]{128582, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 397, 595))); // man gesturing OK: light skin tone
        trie.insert(new int[]{128129}, new ParseResult(2, new SpriteCoordinates(2, 5, 133, 661))); // person tipping hand
        trie.insert(new int[]{128129, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 199, 661))); // man tipping hand: dark skin tone
        trie.insert(new int[]{128129, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 199, 661))); // man tipping hand: dark skin tone
        trie.insert(new int[]{128587, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 595))); // person raising hand: medium-dark skin tone
        trie.insert(new int[]{128587, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 199, 595))); // woman raising hand: medium skin tone
        trie.insert(new int[]{128587, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 199, 595))); // woman raising hand: medium skin tone
        trie.insert(new int[]{129487, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 397))); // deaf man: medium-light skin tone
        trie.insert(new int[]{129487, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 397, 397))); // deaf man: medium-light skin tone
        trie.insert(new int[]{128583, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 331, 595))); // person bowing: light skin tone
        trie.insert(new int[]{128583, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 265, 595))); // woman bowing
        trie.insert(new int[]{128583, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 5, 265, 595))); // woman bowing
        trie.insert(new int[]{129318, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 67, 529))); // person facepalming: dark skin tone
        trie.insert(new int[]{129318, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 133, 529))); // woman facepalming: medium-dark skin tone
        trie.insert(new int[]{129318, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 133, 529))); // woman facepalming: medium-dark skin tone
        trie.insert(new int[]{129335, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 529, 133))); // man shrugging: medium skin tone
        trie.insert(new int[]{129335, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 529, 133))); // man shrugging: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 133))); // health worker: medium-light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 5, 397, 133))); // health worker: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 1, 793))); // woman health worker: light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 5, 1, 793))); // woman health worker: light skin tone
        trie.insert(new int[]{128104, 8205, 127891}, new ParseResult(5, new SpriteCoordinates(2, 5, 859, 727))); // man student
        trie.insert(new int[]{128105, 127999, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 727))); // woman student: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 5, 727, 793))); // man teacher: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 5, 331, 331))); // judge: medium skin tone
        trie.insert(new int[]{129489, 127997, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 331, 331))); // judge: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 793, 529))); // woman judge: medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 5, 793, 529))); // woman judge: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 5, 859, 595))); // man farmer: light skin tone
        trie.insert(new int[]{129489, 8205, 127859}, new ParseResult(5, new SpriteCoordinates(2, 5, 331, 397))); // cook
        trie.insert(new int[]{128104, 127999, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 793))); // man cook: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 5, 265, 331))); // mechanic: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 5, 793, 265))); // woman mechanic: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 5, 859, 199))); // man factory worker: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 5, 199, 397))); // office worker: light skin tone
        trie.insert(new int[]{128105, 8205, 128188}, new ParseResult(5, new SpriteCoordinates(2, 5, 727, 595))); // woman office worker
        trie.insert(new int[]{129489, 127999, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 5, 67, 331))); // scientist: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 5, 793, 1))); // woman scientist: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 5, 859, 67))); // man technologist: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 5, 1, 397))); // singer: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 5, 133, 793))); // woman singer: light skin tone
        trie.insert(new int[]{128104, 8205, 127912}, new ParseResult(5, new SpriteCoordinates(2, 5, 859, 661))); // man artist
        trie.insert(new int[]{128105, 127999, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 727))); // woman artist: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 793))); // man pilot: medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 5, 463, 793))); // man pilot: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 1))); // astronaut: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 5, 793, 661))); // woman astronaut: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 5, 859, 529))); // man firefighter: light skin tone
        trie.insert(new int[]{128110}, new ParseResult(2, new SpriteCoordinates(2, 5, 727, 199))); // police officer
        trie.insert(new int[]{128110, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 727, 265))); // man police officer: dark skin tone
        trie.insert(new int[]{128110, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 727, 265))); // man police officer: dark skin tone
        trie.insert(new int[]{128373, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 133))); // detective: medium-dark skin tone
        trie.insert(new int[]{128373, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 661, 199))); // woman detective: medium skin tone
        trie.insert(new int[]{128373, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 661, 199))); // woman detective: medium skin tone
        trie.insert(new int[]{128130, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 67, 661))); // man guard: medium-light skin tone
        trie.insert(new int[]{128130, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 67, 661))); // man guard: medium-light skin tone
        trie.insert(new int[]{129399, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 463))); // ninja: light skin tone
        trie.insert(new int[]{128119, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 331, 661))); // man construction worker
        trie.insert(new int[]{128119, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 5, 331, 661))); // man construction worker
        trie.insert(new int[]{128119, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 397, 661))); // woman construction worker: dark skin tone
        trie.insert(new int[]{128119, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 661))); // woman construction worker: dark skin tone
        trie.insert(new int[]{129332, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 397))); // prince: medium-dark skin tone
        trie.insert(new int[]{128115, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 661))); // person wearing turban: medium skin tone
        trie.insert(new int[]{128115, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 661))); // woman wearing turban: medium-light skin tone
        trie.insert(new int[]{128115, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 661))); // woman wearing turban: medium-light skin tone
        trie.insert(new int[]{129493, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 199, 265))); // woman with headscarf: light skin tone
        trie.insert(new int[]{129333, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 265))); // man in tuxedo
        trie.insert(new int[]{129333, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 529, 265))); // man in tuxedo
        trie.insert(new int[]{129333, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 529, 331))); // woman in tuxedo: dark skin tone
        trie.insert(new int[]{129333, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 529, 331))); // woman in tuxedo: dark skin tone
        trie.insert(new int[]{128112, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 727, 67))); // man with veil: medium-dark skin tone
        trie.insert(new int[]{128112, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 727, 67))); // man with veil: medium-dark skin tone
        trie.insert(new int[]{129328, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 529))); // pregnant woman: medium skin tone
        trie.insert(new int[]{129732, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 133))); // pregnant person: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 5, 199, 793))); // woman feeding baby: light skin tone
        trie.insert(new int[]{129489, 8205, 127868}, new ParseResult(5, new SpriteCoordinates(2, 5, 265, 397))); // person feeding baby
        trie.insert(new int[]{128124, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 265, 661))); // baby angel: dark skin tone
        trie.insert(new int[]{129334, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 199))); // Mrs. Claus: medium-dark skin tone
        trie.insert(new int[]{129464, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 463, 397))); // superhero: medium skin tone
        trie.insert(new int[]{129464, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 1, 463))); // woman superhero: medium-light skin tone
        trie.insert(new int[]{129464, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 1, 463))); // woman superhero: medium-light skin tone
        trie.insert(new int[]{129465, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 463, 331))); // man supervillain: light skin tone
        trie.insert(new int[]{129465, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 331))); // man supervillain: light skin tone
        trie.insert(new int[]{129497}, new ParseResult(2, new SpriteCoordinates(2, 5, 265, 1))); // mage
        trie.insert(new int[]{129497, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 265, 67))); // man mage: dark skin tone
        trie.insert(new int[]{129497, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 265, 67))); // man mage: dark skin tone
        trie.insert(new int[]{129498, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 133, 199))); // fairy: medium-dark skin tone
        trie.insert(new int[]{129498, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 199, 199))); // woman fairy: medium skin tone
        trie.insert(new int[]{129498, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 199, 199))); // woman fairy: medium skin tone
        trie.insert(new int[]{129499, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 67, 199))); // man vampire: medium-light skin tone
        trie.insert(new int[]{129499, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 67, 199))); // man vampire: medium-light skin tone
        trie.insert(new int[]{129500, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 199))); // merperson: light skin tone
        trie.insert(new int[]{129500, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 5, 199, 133))); // mermaid
        trie.insert(new int[]{129500, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 199, 133))); // mermaid
        trie.insert(new int[]{129501, 127999}, new ParseResult(4, new SpriteCoordinates(2, 5, 199, 1))); // elf: dark skin tone
        trie.insert(new int[]{129501, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 199, 67))); // woman elf: medium-dark skin tone
        trie.insert(new int[]{129501, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 199, 67))); // woman elf: medium-dark skin tone
        trie.insert(new int[]{128134, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 529))); // person getting massage: medium-light skin tone
        trie.insert(new int[]{128134, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 661, 595))); // woman getting massage: light skin tone
        trie.insert(new int[]{128134, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 661, 595))); // woman getting massage: light skin tone
        trie.insert(new int[]{128135, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 661, 397))); // man getting haircut
        trie.insert(new int[]{128135, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 397))); // man getting haircut
        trie.insert(new int[]{128135, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 661, 463))); // woman getting haircut: dark skin tone
        trie.insert(new int[]{128135, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 661, 463))); // woman getting haircut: dark skin tone
        trie.insert(new int[]{128694, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 1))); // man walking: medium-dark skin tone
        trie.insert(new int[]{128694, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 1))); // man walking: medium-dark skin tone
        trie.insert(new int[]{128694, 127997, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 67))); // person walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 67))); // person walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 5, 595, 133))); // man walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 5, 595, 133))); // man walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 5, 595, 133))); // man walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 5, 595, 133))); // man walking facing right
        trie.insert(new int[]{129485, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 265))); // man standing: light skin tone
        trie.insert(new int[]{129485, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 463, 265))); // man standing: light skin tone
        trie.insert(new int[]{129486}, new ParseResult(2, new SpriteCoordinates(2, 5, 463, 1))); // person kneeling
        trie.insert(new int[]{129486, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 67))); // man kneeling: dark skin tone
        trie.insert(new int[]{129486, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 463, 67))); // man kneeling: dark skin tone
        trie.insert(new int[]{129486, 127998, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 133))); // person kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 5, 463, 133))); // person kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 5, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 5, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 5, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 5, 463, 199))); // man kneeling facing right
        trie.insert(new int[]{129489, 127996, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 5, 397, 265))); // person with white cane facing right
        trie.insert(new int[]{129489, 127996, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 5, 397, 265))); // person with white cane facing right
        trie.insert(new int[]{128104, 127995, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 5, 859, 397))); // man with white cane facing right
        trie.insert(new int[]{128104, 127995, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 5, 859, 397))); // man with white cane facing right
        trie.insert(new int[]{128105, 8205, 129455, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 5, 727, 529))); // woman with white cane facing right
        trie.insert(new int[]{128105, 8205, 129455, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 5, 727, 529))); // woman with white cane facing right
        trie.insert(new int[]{129489, 127999, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 5, 1, 331))); // person in motorized wheelchair: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 5, 529, 793))); // man in motorized wheelchair: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 5, 793, 199))); // woman in motorized wheelchair: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 199))); // person in manual wheelchair: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 5, 859, 331))); // man in manual wheelchair: light skin tone
        trie.insert(new int[]{128105, 8205, 129469}, new ParseResult(5, new SpriteCoordinates(2, 5, 727, 463))); // woman in manual wheelchair
        trie.insert(new int[]{128105, 127999, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 5, 199, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{128105, 127999, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 5, 199, 727))); // woman in manual wheelchair facing right
        trie.insert(new int[]{127939, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 925, 397))); // man running: medium-dark skin tone
        trie.insert(new int[]{127939, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 925, 397))); // man running: medium-dark skin tone
        trie.insert(new int[]{127939, 127997, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 925, 463))); // person running facing right
        trie.insert(new int[]{127939, 127997, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 5, 925, 463))); // person running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 5, 925, 529))); // man running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 5, 925, 529))); // man running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 5, 925, 529))); // man running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 5, 925, 529))); // man running facing right
        trie.insert(new int[]{128378, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 67))); // man dancing: light skin tone
        trie.insert(new int[]{128111}, new ParseResult(2, new SpriteCoordinates(2, 5, 727, 133))); // people with bunny ears
        trie.insert(new int[]{129494, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 133, 265))); // man in steamy room: medium-light skin tone
        trie.insert(new int[]{129494, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 133, 265))); // man in steamy room: medium-light skin tone
        trie.insert(new int[]{129495, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 67, 265))); // person climbing: light skin tone
        trie.insert(new int[]{129495, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 5, 1, 265))); // woman climbing
        trie.insert(new int[]{129495, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 1, 265))); // woman climbing
        trie.insert(new int[]{127943, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 925, 199))); // horse racing: medium-dark skin tone
        trie.insert(new int[]{127948, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 727, 859))); // person golfing: medium-light skin tone
        trie.insert(new int[]{127948, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 793, 859))); // woman golfing: light skin tone
        trie.insert(new int[]{127948, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 793, 859))); // woman golfing: light skin tone
        trie.insert(new int[]{127940, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 925, 265))); // man surfing
        trie.insert(new int[]{127940, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 5, 925, 265))); // man surfing
        trie.insert(new int[]{127940, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 925, 331))); // woman surfing: dark skin tone
        trie.insert(new int[]{127940, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 925, 331))); // woman surfing: dark skin tone
        trie.insert(new int[]{128675, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 397))); // man rowing boat: medium-dark skin tone
        trie.insert(new int[]{128675, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 397))); // man rowing boat: medium-dark skin tone
        trie.insert(new int[]{127946, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 925, 67))); // person swimming: medium skin tone
        trie.insert(new int[]{127946, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 925, 133))); // woman swimming: medium-light skin tone
        trie.insert(new int[]{127946, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 925, 133))); // woman swimming: medium-light skin tone
        trie.insert(new int[]{9977, 127995, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 5, 1, 1))); // man bouncing ball: light skin tone
        trie.insert(new int[]{9977, 127995, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 5, 1, 1))); // man bouncing ball: light skin tone
        trie.insert(new int[]{127947}, new ParseResult(2, new SpriteCoordinates(2, 5, 859, 859))); // person lifting weights
        trie.insert(new int[]{127947, 65039}, new ParseResult(3, new SpriteCoordinates(2, 5, 859, 859))); // person lifting weights
        trie.insert(new int[]{127947, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 925, 1))); // man lifting weights: dark skin tone
        trie.insert(new int[]{127947, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 925, 1))); // man lifting weights: dark skin tone
        trie.insert(new int[]{128692, 127998}, new ParseResult(4, new SpriteCoordinates(2, 5, 595, 265))); // person biking: medium-dark skin tone
        trie.insert(new int[]{128692, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 331))); // woman biking: medium skin tone
        trie.insert(new int[]{128692, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 331))); // woman biking: medium skin tone
        trie.insert(new int[]{128693, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 595, 199))); // man mountain biking: medium-light skin tone
        trie.insert(new int[]{128693, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 595, 199))); // man mountain biking: medium-light skin tone
        trie.insert(new int[]{129336, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 67))); // person cartwheeling: light skin tone
        trie.insert(new int[]{129336, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 1))); // woman cartwheeling
        trie.insert(new int[]{129336, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 529, 1))); // woman cartwheeling
        trie.insert(new int[]{129341, 127996}, new ParseResult(4, new SpriteCoordinates(2, 5, 331, 463))); // person playing water polo: medium-light skin tone
        trie.insert(new int[]{129341, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 397, 463))); // woman playing water polo: light skin tone
        trie.insert(new int[]{129341, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 397, 463))); // woman playing water polo: light skin tone
        trie.insert(new int[]{129342, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 5, 199, 463))); // man playing handball
        trie.insert(new int[]{129342, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 5, 199, 463))); // man playing handball
        trie.insert(new int[]{129342, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 265, 463))); // woman playing handball: dark skin tone
        trie.insert(new int[]{129342, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 265, 463))); // woman playing handball: dark skin tone
        trie.insert(new int[]{129337, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 463, 463))); // man juggling: medium-dark skin tone
        trie.insert(new int[]{129337, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 5, 463, 463))); // man juggling: medium-dark skin tone
        trie.insert(new int[]{129496, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 265, 133))); // person in lotus position: medium skin tone
        trie.insert(new int[]{129496, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 5, 265, 199))); // woman in lotus position: medium-light skin tone
        trie.insert(new int[]{129496, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 5, 265, 199))); // woman in lotus position: medium-light skin tone
        trie.insert(new int[]{128716, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 529, 529))); // person in bed: light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129309, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 5, 397, 331))); // people holding hands: medium-light skin tone, light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129309, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 5, 199, 331))); // people holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 5, 67, 793))); // women holding hands: light skin tone, medium-light skin tone
        trie.insert(new int[]{128109, 127997}, new ParseResult(4, new SpriteCoordinates(2, 5, 727, 331))); // women holding hands: medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 5, 331, 727))); // women holding hands: dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 5, 793, 595))); // woman and man holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 5, 727, 727))); // woman and man holding hands: medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 5, 859, 463))); // men holding hands: light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 5, 661, 793))); // men holding hands: medium-dark skin tone, light skin tone
        trie.insert(new int[]{128143, 127995}, new ParseResult(4, new SpriteCoordinates(2, 5, 661, 331))); // kiss: light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998}, new ParseResult(15, new SpriteCoordinates(2, 5, 397, 67))); // kiss: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127998}, new ParseResult(14, new SpriteCoordinates(2, 5, 397, 67))); // kiss: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127996}, new ParseResult(14, new SpriteCoordinates(2, 5, 331, 265))); // kiss: person, person, dark skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996}, new ParseResult(15, new SpriteCoordinates(2, 5, 331, 265))); // kiss: person, person, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 5, 793, 397))); // kiss: woman, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 5, 793, 397))); // kiss: woman, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 5, 529, 727))); // kiss: woman, man, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 5, 529, 727))); // kiss: woman, man, medium-dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 5, 859, 265))); // kiss: man, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 5, 859, 265))); // kiss: man, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 5, 793, 793))); // kiss: man, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 5, 793, 793))); // kiss: man, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 8205, 10084, 65039, 8205, 128139, 8205, 128105}, new ParseResult(11, new SpriteCoordinates(2, 5, 727, 397))); // kiss: woman, woman
        trie.insert(new int[]{128105, 8205, 10084, 8205, 128139, 8205, 128105}, new ParseResult(10, new SpriteCoordinates(2, 5, 727, 397))); // kiss: woman, woman
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995}, new ParseResult(15, new SpriteCoordinates(2, 5, 793, 67))); // kiss: woman, woman, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127995}, new ParseResult(14, new SpriteCoordinates(2, 5, 793, 67))); // kiss: woman, woman, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996}, new ParseResult(15, new SpriteCoordinates(2, 5, 67, 727))); // kiss: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127996}, new ParseResult(14, new SpriteCoordinates(2, 5, 67, 727))); // kiss: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 129489, 127997}, new ParseResult(11, new SpriteCoordinates(2, 5, 67, 397))); // couple with heart: person, person, light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 5, 67, 397))); // couple with heart: person, person, light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 129489, 127995}, new ParseResult(11, new SpriteCoordinates(2, 5, 133, 331))); // couple with heart: person, person, medium-dark skin tone, light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 5, 133, 331))); // couple with heart: person, person, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 5, 793, 727))); // couple with heart: woman, man, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 5, 793, 727))); // couple with heart: woman, man, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 5, 793, 133))); // couple with heart: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 5, 793, 133))); // couple with heart: woman, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 5, 133, 727))); // couple with heart: woman, man, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 5, 133, 727))); // couple with heart: woman, man, dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 5, 859, 133))); // couple with heart: man, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 5, 859, 133))); // couple with heart: man, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 5, 331, 793))); // couple with heart: man, man, dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 5, 331, 793))); // couple with heart: man, man, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 5, 793, 463))); // couple with heart: woman, woman, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128105, 127995}, new ParseResult(11, new SpriteCoordinates(2, 5, 793, 463))); // couple with heart: woman, woman, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128105, 127996}, new ParseResult(11, new SpriteCoordinates(2, 5, 595, 727))); // couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 5, 595, 727))); // couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 8205, 128105, 8205, 128103, 8205, 128102}, new ParseResult(11, new SpriteCoordinates(2, 5, 265, 793))); // family: man, woman, girl, boy
        trie.insert(new int[]{128105, 8205, 128105, 8205, 128102, 8205, 128102}, new ParseResult(11, new SpriteCoordinates(2, 5, 727, 661))); // family: woman, woman, boy, boy
        trie.insert(new int[]{128105, 8205, 128103, 8205, 128103}, new ParseResult(8, new SpriteCoordinates(2, 5, 1, 727))); // family: woman, girl, girl
        trie.insert(new int[]{129306}, new ParseResult(2, new SpriteCoordinates(2, 6, 595, 1))); // raised back of hand
        trie.insert(new int[]{128400, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 1, 661))); // hand with fingers splayed: dark skin tone
        trie.insert(new int[]{128406, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 661, 529))); // vulcan salute: medium-dark skin tone
        trie.insert(new int[]{129778, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 133, 67))); // leftwards hand: medium skin tone
        trie.insert(new int[]{129780, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 133, 1))); // palm up hand: medium-light skin tone
        trie.insert(new int[]{129784, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 1))); // rightwards pushing hand: light skin tone
        trie.insert(new int[]{129292}, new ParseResult(2, new SpriteCoordinates(2, 6, 595, 199))); // pinched fingers
        trie.insert(new int[]{129295, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 595, 133))); // pinching hand: dark skin tone
        trie.insert(new int[]{129310, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 463, 529))); // crossed fingers: medium-dark skin tone
        trie.insert(new int[]{129311, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 397, 529))); // love-you gesture: medium skin tone
        trie.insert(new int[]{129305, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 595, 67))); // call me hand: medium-light skin tone
        trie.insert(new int[]{128073, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 397, 859))); // backhand index pointing right: light skin tone
        trie.insert(new int[]{128405}, new ParseResult(2, new SpriteCoordinates(2, 6, 661, 595))); // middle finger
        trie.insert(new int[]{128071, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 463, 859))); // backhand index pointing down: dark skin tone
        trie.insert(new int[]{129781, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 67))); // index pointing at the viewer: medium-dark skin tone
        trie.insert(new int[]{128078, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 265, 859))); // thumbs down: medium skin tone
        trie.insert(new int[]{128074, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 859))); // oncoming fist: medium-light skin tone
        trie.insert(new int[]{129308, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 529, 529))); // right-facing fist: light skin tone
        trie.insert(new int[]{128588}, new ParseResult(2, new SpriteCoordinates(2, 6, 595, 595))); // raising hands
        trie.insert(new int[]{129782, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 1, 67))); // heart hands: dark skin tone
        trie.insert(new int[]{129330, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 133, 529))); // palms up together: medium-dark skin tone
        trie.insert(new int[]{129777, 127995, 8205, 129778, 127999}, new ParseResult(9, new SpriteCoordinates(2, 6, 67, 133))); // handshake: light skin tone, dark skin tone
        trie.insert(new int[]{129777, 127998, 8205, 129778, 127997}, new ParseResult(9, new SpriteCoordinates(2, 6, 1, 133))); // handshake: medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128591, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 595))); // folded hands: dark skin tone
        trie.insert(new int[]{128133, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 595, 661))); // nail polish: medium-dark skin tone
        trie.insert(new int[]{128170, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 265, 661))); // flexed biceps: medium skin tone
        trie.insert(new int[]{129462}, new ParseResult(2, new SpriteCoordinates(2, 6, 331, 463))); // foot
        trie.insert(new int[]{128066, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 595, 859))); // ear: dark skin tone
        trie.insert(new int[]{128067, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 529, 859))); // nose: medium-dark skin tone
        trie.insert(new int[]{129766}, new ParseResult(2, new SpriteCoordinates(2, 6, 133, 133))); // biting lip
        trie.insert(new int[]{129490, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 265))); // child: medium-dark skin tone
        trie.insert(new int[]{128103, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 199, 859))); // girl: medium skin tone
        trie.insert(new int[]{128113, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 727, 463))); // person: medium-light skin tone, blond hair
        trie.insert(new int[]{129492, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 133))); // person: light skin tone, beard
        trie.insert(new int[]{129492, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 67))); // woman: beard
        trie.insert(new int[]{129492, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 331, 67))); // woman: beard
        trie.insert(new int[]{128104, 127999, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 1))); // man: dark skin tone, red hair
        trie.insert(new int[]{128104, 127998, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 199))); // man: medium-dark skin tone, white hair
        trie.insert(new int[]{128105, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 793, 1))); // woman: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 6, 133, 397))); // person: medium-light skin tone, red hair
        trie.insert(new int[]{129489, 127995, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 6, 397, 397))); // person: light skin tone, curly hair
        trie.insert(new int[]{129489, 8205, 129459}, new ParseResult(5, new SpriteCoordinates(2, 6, 133, 331))); // person: white hair
        trie.insert(new int[]{128105, 127999, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 6, 331, 727))); // woman: dark skin tone, bald
        trie.insert(new int[]{128113, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 397))); // woman: medium-dark skin tone, blond hair
        trie.insert(new int[]{128113, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 727, 397))); // woman: medium-dark skin tone, blond hair
        trie.insert(new int[]{129491, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 199))); // older person: medium skin tone
        trie.insert(new int[]{128117, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 727, 199))); // old woman: medium-light skin tone
        trie.insert(new int[]{128589, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 529, 595))); // man frowning: light skin tone
        trie.insert(new int[]{128589, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 529, 595))); // man frowning: light skin tone
        trie.insert(new int[]{128590}, new ParseResult(2, new SpriteCoordinates(2, 6, 397, 595))); // person pouting
        trie.insert(new int[]{128590, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 595))); // man pouting: dark skin tone
        trie.insert(new int[]{128590, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 463, 595))); // man pouting: dark skin tone
        trie.insert(new int[]{128581, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 661, 331))); // person gesturing NO: medium-dark skin tone
        trie.insert(new int[]{128581, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 661, 397))); // woman gesturing NO: medium skin tone
        trie.insert(new int[]{128581, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 661, 397))); // woman gesturing NO: medium skin tone
        trie.insert(new int[]{128582, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 661, 265))); // man gesturing OK: medium-light skin tone
        trie.insert(new int[]{128582, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 661, 265))); // man gesturing OK: medium-light skin tone
        trie.insert(new int[]{128129, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 727, 67))); // person tipping hand: light skin tone
        trie.insert(new int[]{128129, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 727, 1))); // woman tipping hand
        trie.insert(new int[]{128129, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 6, 727, 1))); // woman tipping hand
        trie.insert(new int[]{128587, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 661, 1))); // person raising hand: dark skin tone
        trie.insert(new int[]{128587, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 661, 67))); // woman raising hand: medium-dark skin tone
        trie.insert(new int[]{128587, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 661, 67))); // woman raising hand: medium-dark skin tone
        trie.insert(new int[]{129487, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 463, 199))); // deaf man: medium skin tone
        trie.insert(new int[]{129487, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 199))); // deaf man: medium skin tone
        trie.insert(new int[]{128583, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 661, 133))); // person bowing: medium-light skin tone
        trie.insert(new int[]{128583, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 661, 199))); // woman bowing: light skin tone
        trie.insert(new int[]{128583, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 661, 199))); // woman bowing: light skin tone
        trie.insert(new int[]{129318, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 265, 529))); // man facepalming
        trie.insert(new int[]{129318, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 6, 265, 529))); // man facepalming
        trie.insert(new int[]{129318, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 331, 529))); // woman facepalming: dark skin tone
        trie.insert(new int[]{129318, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 331, 529))); // woman facepalming: dark skin tone
        trie.insert(new int[]{129335, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 529, 397))); // man shrugging: medium-dark skin tone
        trie.insert(new int[]{129335, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 529, 397))); // man shrugging: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 6, 397, 199))); // health worker: medium skin tone
        trie.insert(new int[]{129489, 127997, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 397, 199))); // health worker: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 793, 529))); // woman health worker: medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 6, 793, 529))); // woman health worker: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 6, 133, 859))); // man student: light skin tone
        trie.insert(new int[]{129489, 8205, 127979}, new ParseResult(5, new SpriteCoordinates(2, 6, 463, 133))); // teacher
        trie.insert(new int[]{128104, 127999, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 67))); // man teacher: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 6, 397, 1))); // judge: medium-dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 397, 1))); // judge: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 793, 199))); // woman judge: medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 6, 793, 199))); // woman judge: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 793))); // man farmer: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 67))); // cook: light skin tone
        trie.insert(new int[]{128105, 8205, 127859}, new ParseResult(5, new SpriteCoordinates(2, 6, 397, 793))); // woman cook
        trie.insert(new int[]{129489, 127999, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 6, 265, 331))); // mechanic: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 727))); // woman mechanic: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 463))); // man factory worker: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 6, 265, 397))); // office worker: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 6, 331, 793))); // woman office worker: light skin tone
        trie.insert(new int[]{128104, 8205, 128300}, new ParseResult(5, new SpriteCoordinates(2, 6, 529, 793))); // man scientist
        trie.insert(new int[]{128105, 127999, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 727))); // woman scientist: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 331))); // man technologist: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 6, 1, 397))); // singer: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 6, 793, 661))); // woman singer: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 6, 67, 859))); // man artist: light skin tone
        trie.insert(new int[]{129489, 8205, 9992, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 1, 331))); // pilot
        trie.insert(new int[]{129489, 8205, 9992}, new ParseResult(4, new SpriteCoordinates(2, 6, 1, 331))); // pilot
        trie.insert(new int[]{128104, 127999, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 6, 727, 793))); // man pilot: dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 793))); // man pilot: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 6, 397, 133))); // astronaut: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 6, 793, 331))); // woman astronaut: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 727))); // man firefighter: medium-light skin tone
        trie.insert(new int[]{128110, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 727))); // police officer: light skin tone
        trie.insert(new int[]{128110, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 1, 727))); // woman police officer
        trie.insert(new int[]{128110, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 6, 1, 727))); // woman police officer
        trie.insert(new int[]{128373, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 133, 661))); // detective: dark skin tone
        trie.insert(new int[]{128373, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 199, 661))); // woman detective: medium-dark skin tone
        trie.insert(new int[]{128373, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 199, 661))); // woman detective: medium-dark skin tone
        trie.insert(new int[]{128130, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 661, 661))); // man guard: medium skin tone
        trie.insert(new int[]{128130, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 661, 661))); // man guard: medium skin tone
        trie.insert(new int[]{129399, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 397, 463))); // ninja: medium-light skin tone
        trie.insert(new int[]{128119, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 133))); // man construction worker: light skin tone
        trie.insert(new int[]{128119, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 727, 133))); // man construction worker: light skin tone
        trie.insert(new int[]{129733}, new ParseResult(2, new SpriteCoordinates(2, 6, 199, 1))); // person with crown
        trie.insert(new int[]{129332, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 529))); // prince: dark skin tone
        trie.insert(new int[]{128115, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 727, 265))); // person wearing turban: medium-dark skin tone
    }

    public static void init6(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{128115, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 331))); // woman wearing turban: medium skin tone
        trie.insert(new int[]{128115, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 727, 331))); // woman wearing turban: medium skin tone
        trie.insert(new int[]{129493, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 1))); // woman with headscarf: medium-light skin tone
        trie.insert(new int[]{129333, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 1, 529))); // man in tuxedo: light skin tone
        trie.insert(new int[]{129333, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 1, 529))); // man in tuxedo: light skin tone
        trie.insert(new int[]{128112}, new ParseResult(2, new SpriteCoordinates(2, 6, 727, 529))); // person with veil
        trie.insert(new int[]{128112, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 727, 595))); // man with veil: dark skin tone
        trie.insert(new int[]{128112, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 595))); // man with veil: dark skin tone
        trie.insert(new int[]{129328, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 199, 529))); // pregnant woman: medium-dark skin tone
        trie.insert(new int[]{129732, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 199, 67))); // pregnant person: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 6, 793, 727))); // woman feeding baby: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 1))); // person feeding baby: light skin tone
        trie.insert(new int[]{127877}, new ParseResult(2, new SpriteCoordinates(2, 6, 925, 529))); // Santa Claus
        trie.insert(new int[]{129334, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 529, 463))); // Mrs. Claus: dark skin tone
        trie.insert(new int[]{129464, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 199, 463))); // superhero: medium-dark skin tone
        trie.insert(new int[]{129464, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 265, 463))); // woman superhero: medium skin tone
        trie.insert(new int[]{129464, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 265, 463))); // woman superhero: medium skin tone
        trie.insert(new int[]{129465, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 133, 463))); // man supervillain: medium-light skin tone
        trie.insert(new int[]{129465, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 133, 463))); // man supervillain: medium-light skin tone
        trie.insert(new int[]{129497, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 265, 199))); // mage: light skin tone
        trie.insert(new int[]{129497, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 265, 133))); // woman mage
        trie.insert(new int[]{129497, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 6, 265, 133))); // woman mage
        trie.insert(new int[]{129498, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 265, 1))); // fairy: dark skin tone
        trie.insert(new int[]{129498, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 265, 67))); // woman fairy: medium-dark skin tone
        trie.insert(new int[]{129498, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 265, 67))); // woman fairy: medium-dark skin tone
        trie.insert(new int[]{129499, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 199, 199))); // man vampire: medium skin tone
        trie.insert(new int[]{129499, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 199, 199))); // man vampire: medium skin tone
        trie.insert(new int[]{129500, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 199))); // merperson: medium-light skin tone
        trie.insert(new int[]{129500, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 133, 199))); // mermaid: light skin tone
        trie.insert(new int[]{129500, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 133, 199))); // mermaid: light skin tone
        trie.insert(new int[]{129501, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 6, 199, 133))); // man elf
        trie.insert(new int[]{129501, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 199, 133))); // man elf
        trie.insert(new int[]{129501, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 1, 199))); // woman elf: dark skin tone
        trie.insert(new int[]{129501, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 1, 199))); // woman elf: dark skin tone
        trie.insert(new int[]{128134, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 463, 661))); // person getting massage: medium skin tone
        trie.insert(new int[]{128134, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 529, 661))); // woman getting massage: medium-light skin tone
        trie.insert(new int[]{128134, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 529, 661))); // woman getting massage: medium-light skin tone
        trie.insert(new int[]{128135, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 397, 661))); // man getting haircut: light skin tone
        trie.insert(new int[]{128135, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 397, 661))); // man getting haircut: light skin tone
        trie.insert(new int[]{128694}, new ParseResult(2, new SpriteCoordinates(2, 6, 595, 331))); // person walking
        trie.insert(new int[]{128694, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 595, 397))); // man walking: dark skin tone
        trie.insert(new int[]{128694, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 595, 397))); // man walking: dark skin tone
        trie.insert(new int[]{128694, 127998, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 6, 595, 463))); // person walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 595, 463))); // person walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 6, 595, 529))); // man walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 6, 595, 529))); // man walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 6, 595, 529))); // man walking facing right
        trie.insert(new int[]{128694, 127997, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 6, 595, 529))); // man walking facing right
        trie.insert(new int[]{129485, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 67, 463))); // man standing: medium-light skin tone
        trie.insert(new int[]{129485, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 67, 463))); // man standing: medium-light skin tone
        trie.insert(new int[]{129486, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 1, 463))); // person kneeling: light skin tone
        trie.insert(new int[]{129486, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 6, 463, 265))); // woman kneeling
        trie.insert(new int[]{129486, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 463, 265))); // woman kneeling
        trie.insert(new int[]{129486, 127999, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 6, 463, 331))); // person kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 331))); // person kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 6, 463, 397))); // man kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 6, 463, 397))); // man kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 6, 463, 397))); // man kneeling facing right
        trie.insert(new int[]{129486, 127998, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 6, 463, 397))); // man kneeling facing right
        trie.insert(new int[]{129489, 127997, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 6, 397, 331))); // person with white cane facing right
        trie.insert(new int[]{129489, 127997, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 6, 397, 331))); // person with white cane facing right
        trie.insert(new int[]{128104, 127996, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 6, 859, 595))); // man with white cane facing right
        trie.insert(new int[]{128104, 127996, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 6, 859, 595))); // man with white cane facing right
        trie.insert(new int[]{128105, 127995, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 6, 199, 793))); // woman with white cane facing right
        trie.insert(new int[]{128105, 127995, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 6, 199, 793))); // woman with white cane facing right
        trie.insert(new int[]{129489, 8205, 129468, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 6, 67, 331))); // person in motorized wheelchair facing right
        trie.insert(new int[]{129489, 8205, 129468, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 6, 67, 331))); // person in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127999, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 6, 793, 793))); // man in motorized wheelchair: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 6, 661, 727))); // woman in motorized wheelchair: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 6, 397, 265))); // person in manual wheelchair: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 6, 859, 529))); // man in manual wheelchair: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 6, 133, 793))); // woman in manual wheelchair: light skin tone
        trie.insert(new int[]{127939}, new ParseResult(2, new SpriteCoordinates(2, 6, 925, 265))); // person running
        trie.insert(new int[]{127939, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 925, 331))); // man running: dark skin tone
        trie.insert(new int[]{127939, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 925, 331))); // man running: dark skin tone
        trie.insert(new int[]{127939, 127998, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 925, 397))); // person running facing right
        trie.insert(new int[]{127939, 127998, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 6, 925, 397))); // person running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 6, 925, 463))); // man running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 6, 925, 463))); // man running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 6, 925, 463))); // man running facing right
        trie.insert(new int[]{127939, 127997, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 6, 925, 463))); // man running facing right
        trie.insert(new int[]{128378, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 661))); // man dancing: medium-light skin tone
        trie.insert(new int[]{128111, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 727, 661))); // men with bunny ears
        trie.insert(new int[]{128111, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 6, 727, 661))); // men with bunny ears
        trie.insert(new int[]{129494, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 265, 265))); // man in steamy room: medium skin tone
        trie.insert(new int[]{129494, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 265, 265))); // man in steamy room: medium skin tone
        trie.insert(new int[]{129495, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 133, 265))); // person climbing: medium-light skin tone
        trie.insert(new int[]{129495, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 199, 265))); // woman climbing: light skin tone
        trie.insert(new int[]{129495, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 199, 265))); // woman climbing: light skin tone
        trie.insert(new int[]{127943, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 925, 133))); // horse racing: dark skin tone
        trie.insert(new int[]{127948, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 661, 859))); // person golfing: medium skin tone
        trie.insert(new int[]{127948, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 727, 859))); // woman golfing: medium-light skin tone
        trie.insert(new int[]{127948, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 727, 859))); // woman golfing: medium-light skin tone
        trie.insert(new int[]{127940, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 925, 199))); // man surfing: light skin tone
        trie.insert(new int[]{127940, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 925, 199))); // man surfing: light skin tone
        trie.insert(new int[]{128675}, new ParseResult(2, new SpriteCoordinates(2, 6, 199, 595))); // person rowing boat
        trie.insert(new int[]{128675, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 265, 595))); // man rowing boat: dark skin tone
        trie.insert(new int[]{128675, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 265, 595))); // man rowing boat: dark skin tone
        trie.insert(new int[]{127946, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 925, 1))); // person swimming: medium-dark skin tone
        trie.insert(new int[]{127946, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 925, 67))); // woman swimming: medium skin tone
        trie.insert(new int[]{127946, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 925, 67))); // woman swimming: medium skin tone
        trie.insert(new int[]{9977, 127996, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 6, 1, 1))); // man bouncing ball: medium-light skin tone
        trie.insert(new int[]{9977, 127996, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 6, 1, 1))); // man bouncing ball: medium-light skin tone
        trie.insert(new int[]{127947, 127995}, new ParseResult(4, new SpriteCoordinates(2, 6, 859, 859))); // person lifting weights: light skin tone
        trie.insert(new int[]{127947, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 6, 793, 859))); // woman lifting weights
        trie.insert(new int[]{127947, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 6, 793, 859))); // woman lifting weights
        trie.insert(new int[]{127947, 65039, 8205, 9792, 65039}, new ParseResult(6, new SpriteCoordinates(2, 6, 793, 859))); // woman lifting weights
        trie.insert(new int[]{127947, 65039, 8205, 9792}, new ParseResult(5, new SpriteCoordinates(2, 6, 793, 859))); // woman lifting weights
        trie.insert(new int[]{128692, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 67, 595))); // person biking: dark skin tone
        trie.insert(new int[]{128692, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 133, 595))); // woman biking: medium-dark skin tone
        trie.insert(new int[]{128692, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 133, 595))); // woman biking: medium-dark skin tone
        trie.insert(new int[]{128693, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 1, 595))); // man mountain biking: medium skin tone
        trie.insert(new int[]{128693, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 1, 595))); // man mountain biking: medium skin tone
        trie.insert(new int[]{129336, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 529, 265))); // person cartwheeling: medium-light skin tone
        trie.insert(new int[]{129336, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 529, 331))); // woman cartwheeling: light skin tone
        trie.insert(new int[]{129336, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 529, 331))); // woman cartwheeling: light skin tone
        trie.insert(new int[]{129341, 127997}, new ParseResult(4, new SpriteCoordinates(2, 6, 529, 1))); // person playing water polo: medium skin tone
        trie.insert(new int[]{129341, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 529, 67))); // woman playing water polo: medium-light skin tone
        trie.insert(new int[]{129341, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 529, 67))); // woman playing water polo: medium-light skin tone
        trie.insert(new int[]{129342, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 463))); // man playing handball: light skin tone
        trie.insert(new int[]{129342, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 463, 463))); // man playing handball: light skin tone
        trie.insert(new int[]{129337}, new ParseResult(2, new SpriteCoordinates(2, 6, 529, 133))); // person juggling
        trie.insert(new int[]{129337, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 6, 529, 199))); // man juggling: dark skin tone
        trie.insert(new int[]{129337, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 529, 199))); // man juggling: dark skin tone
        trie.insert(new int[]{129496, 127998}, new ParseResult(4, new SpriteCoordinates(2, 6, 1, 265))); // person in lotus position: medium-dark skin tone
        trie.insert(new int[]{129496, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 6, 67, 265))); // woman in lotus position: medium skin tone
        trie.insert(new int[]{129496, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 6, 67, 265))); // woman in lotus position: medium skin tone
        trie.insert(new int[]{128716, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 595, 265))); // person in bed: medium-light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129309, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 6, 199, 397))); // people holding hands: medium-light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129309, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 6, 397, 67))); // people holding hands: medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 6, 265, 793))); // women holding hands: light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 6, 793, 265))); // women holding hands: medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128109, 127999}, new ParseResult(4, new SpriteCoordinates(2, 6, 133, 727))); // women holding hands: dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 6, 793, 595))); // woman and man holding hands: medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 6, 397, 727))); // woman and man holding hands: dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 6, 859, 661))); // men holding hands: medium-light skin tone, light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 6, 859, 265))); // men holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128143, 127996}, new ParseResult(4, new SpriteCoordinates(2, 6, 331, 661))); // kiss: medium-light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999}, new ParseResult(15, new SpriteCoordinates(2, 6, 67, 397))); // kiss: person, person, medium-light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 128139, 8205, 129489, 127999}, new ParseResult(14, new SpriteCoordinates(2, 6, 67, 397))); // kiss: person, person, medium-light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127997}, new ParseResult(14, new SpriteCoordinates(2, 6, 199, 331))); // kiss: person, person, dark skin tone, medium skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127997}, new ParseResult(15, new SpriteCoordinates(2, 6, 199, 331))); // kiss: person, person, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 6, 793, 397))); // kiss: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 6, 793, 397))); // kiss: woman, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 6, 529, 727))); // kiss: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 6, 529, 727))); // kiss: woman, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 6, 1, 859))); // kiss: man, man, light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 6, 1, 859))); // kiss: man, man, light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 6, 859, 133))); // kiss: man, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 6, 859, 133))); // kiss: man, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995}, new ParseResult(15, new SpriteCoordinates(2, 6, 1, 793))); // kiss: woman, woman, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127995}, new ParseResult(14, new SpriteCoordinates(2, 6, 1, 793))); // kiss: woman, woman, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996}, new ParseResult(15, new SpriteCoordinates(2, 6, 793, 67))); // kiss: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127996}, new ParseResult(14, new SpriteCoordinates(2, 6, 793, 67))); // kiss: woman, woman, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127997}, new ParseResult(14, new SpriteCoordinates(2, 6, 265, 727))); // kiss: woman, woman, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997}, new ParseResult(15, new SpriteCoordinates(2, 6, 265, 727))); // kiss: woman, woman, dark skin tone, medium skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 6, 331, 397))); // couple with heart: person, person, light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 129489, 127998}, new ParseResult(11, new SpriteCoordinates(2, 6, 331, 397))); // couple with heart: person, person, light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 129489, 127996}, new ParseResult(11, new SpriteCoordinates(2, 6, 331, 331))); // couple with heart: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 6, 331, 331))); // couple with heart: person, person, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 6, 67, 793))); // couple with heart: woman, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 6, 67, 793))); // couple with heart: woman, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 6, 793, 133))); // couple with heart: woman, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 6, 793, 133))); // couple with heart: woman, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128104, 8205, 10084, 8205, 128104}, new ParseResult(7, new SpriteCoordinates(2, 6, 463, 793))); // couple with heart: man, man
        trie.insert(new int[]{128104, 8205, 10084, 65039, 8205, 128104}, new ParseResult(8, new SpriteCoordinates(2, 6, 463, 793))); // couple with heart: man, man
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 6, 859, 397))); // couple with heart: man, man, medium skin tone, light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 6, 859, 397))); // couple with heart: man, man, medium skin tone, light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 6, 661, 793))); // couple with heart: man, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 6, 661, 793))); // couple with heart: man, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 6, 793, 463))); // couple with heart: woman, woman, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128105, 127996}, new ParseResult(11, new SpriteCoordinates(2, 6, 793, 463))); // couple with heart: woman, woman, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 6, 595, 727))); // couple with heart: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128105, 127997}, new ParseResult(11, new SpriteCoordinates(2, 6, 595, 727))); // couple with heart: woman, woman, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 8205, 128105, 8205, 128102, 8205, 128102}, new ParseResult(11, new SpriteCoordinates(2, 6, 595, 793))); // family: man, woman, boy, boy
        trie.insert(new int[]{128105, 8205, 128105, 8205, 128103, 8205, 128103}, new ParseResult(11, new SpriteCoordinates(2, 6, 199, 727))); // family: woman, woman, girl, girl
        trie.insert(new int[]{128483, 65039}, new ParseResult(3, new SpriteCoordinates(2, 6, 661, 463))); // speaking head
        trie.insert(new int[]{128483}, new ParseResult(2, new SpriteCoordinates(2, 6, 661, 463))); // speaking head
        trie.insert(new int[]{129306, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 265))); // raised back of hand: light skin tone
        trie.insert(new int[]{9995}, new ParseResult(1, new SpriteCoordinates(2, 7, 1, 67))); // raised hand
        trie.insert(new int[]{128406, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 661, 595))); // vulcan salute: dark skin tone
        trie.insert(new int[]{129778, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 199, 1))); // leftwards hand: medium-dark skin tone
        trie.insert(new int[]{129780, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 133, 133))); // palm up hand: medium skin tone
        trie.insert(new int[]{129784, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 1, 133))); // rightwards pushing hand: medium-light skin tone
        trie.insert(new int[]{129292, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 397))); // pinched fingers: light skin tone
        trie.insert(new int[]{9996, 65039}, new ParseResult(2, new SpriteCoordinates(2, 7, 67, 1))); // victory hand
        trie.insert(new int[]{9996}, new ParseResult(1, new SpriteCoordinates(2, 7, 67, 1))); // victory hand
        trie.insert(new int[]{129310, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 133))); // crossed fingers: dark skin tone
        trie.insert(new int[]{129311, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 67))); // love-you gesture: medium-dark skin tone
        trie.insert(new int[]{129305, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 331))); // call me hand: medium skin tone
        trie.insert(new int[]{128073, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 859))); // backhand index pointing right: medium-light skin tone
        trie.insert(new int[]{128405, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 1, 661))); // middle finger: light skin tone
        trie.insert(new int[]{9757}, new ParseResult(1, new SpriteCoordinates(2, 7, 133, 67))); // index pointing up
        trie.insert(new int[]{9757, 65039}, new ParseResult(2, new SpriteCoordinates(2, 7, 133, 67))); // index pointing up
        trie.insert(new int[]{129781, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 133))); // index pointing at the viewer: dark skin tone
        trie.insert(new int[]{128078, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 463, 859))); // thumbs down: medium-dark skin tone
        trie.insert(new int[]{128074, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 859))); // oncoming fist: medium skin tone
        trie.insert(new int[]{129308, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 199))); // right-facing fist: medium-light skin tone
        trie.insert(new int[]{128588, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 661, 67))); // raising hands: light skin tone
        trie.insert(new int[]{128080}, new ParseResult(2, new SpriteCoordinates(2, 7, 397, 859))); // open hands
        trie.insert(new int[]{129330, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 463, 529))); // palms up together: dark skin tone
        trie.insert(new int[]{129777, 127996, 8205, 129778, 127995}, new ParseResult(9, new SpriteCoordinates(2, 7, 199, 133))); // handshake: medium-light skin tone, light skin tone
        trie.insert(new int[]{129777, 127998, 8205, 129778, 127999}, new ParseResult(9, new SpriteCoordinates(2, 7, 199, 67))); // handshake: medium-dark skin tone, dark skin tone
        trie.insert(new int[]{9997}, new ParseResult(1, new SpriteCoordinates(2, 7, 1, 1))); // writing hand
        trie.insert(new int[]{9997, 65039}, new ParseResult(2, new SpriteCoordinates(2, 7, 1, 1))); // writing hand
        trie.insert(new int[]{128133, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 661))); // nail polish: dark skin tone
        trie.insert(new int[]{128170, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 661))); // flexed biceps: medium-dark skin tone
        trie.insert(new int[]{129462, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 199))); // foot: light skin tone
        trie.insert(new int[]{129467}, new ParseResult(2, new SpriteCoordinates(2, 7, 463, 463))); // ear with hearing aid
        trie.insert(new int[]{128067, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 661, 859))); // nose: dark skin tone
        trie.insert(new int[]{128118}, new ParseResult(2, new SpriteCoordinates(2, 7, 727, 265))); // baby
        trie.insert(new int[]{129490, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 133, 331))); // child: dark skin tone
        trie.insert(new int[]{128103, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 859))); // girl: medium-dark skin tone
        trie.insert(new int[]{128113, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 727, 595))); // person: medium skin tone, blond hair
        trie.insert(new int[]{129492, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 331, 265))); // person: medium-light skin tone, beard
        trie.insert(new int[]{129492, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 1, 331))); // woman: light skin tone, beard
        trie.insert(new int[]{129492, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 1, 331))); // woman: light skin tone, beard
        trie.insert(new int[]{128104, 8205, 129457}, new ParseResult(5, new SpriteCoordinates(2, 7, 661, 793))); // man: curly hair
        trie.insert(new int[]{128104, 127999, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 7, 859, 133))); // man: dark skin tone, white hair
        trie.insert(new int[]{128105, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 793, 1))); // woman: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 397))); // person: medium skin tone, red hair
        trie.insert(new int[]{129489, 127996, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 7, 331, 397))); // person: medium-light skin tone, curly hair
        trie.insert(new int[]{129489, 127995, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 7, 463, 331))); // person: light skin tone, white hair
        trie.insert(new int[]{129489, 8205, 129458}, new ParseResult(5, new SpriteCoordinates(2, 7, 199, 331))); // person: bald
        trie.insert(new int[]{128113, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 727, 529))); // woman: dark skin tone, blond hair
        trie.insert(new int[]{128113, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 727, 529))); // woman: dark skin tone, blond hair
        trie.insert(new int[]{129491, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 331))); // older person: medium-dark skin tone
        trie.insert(new int[]{128117, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 727, 331))); // old woman: medium skin tone
        trie.insert(new int[]{128589, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 661, 1))); // man frowning: medium-light skin tone
        trie.insert(new int[]{128589, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 661, 1))); // man frowning: medium-light skin tone
        trie.insert(new int[]{128590, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 595))); // person pouting: light skin tone
        trie.insert(new int[]{128590, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 595))); // woman pouting
        trie.insert(new int[]{128590, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 529, 595))); // woman pouting
        trie.insert(new int[]{128581, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 661, 463))); // person gesturing NO: dark skin tone
        trie.insert(new int[]{128581, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 661, 529))); // woman gesturing NO: medium-dark skin tone
        trie.insert(new int[]{128581, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 661, 529))); // woman gesturing NO: medium-dark skin tone
        trie.insert(new int[]{128582, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 661, 397))); // man gesturing OK: medium skin tone
        trie.insert(new int[]{128582, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 661, 397))); // man gesturing OK: medium skin tone
        trie.insert(new int[]{128129, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 727, 1))); // person tipping hand: medium-light skin tone
        trie.insert(new int[]{128129, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 727, 67))); // woman tipping hand: light skin tone
        trie.insert(new int[]{128129, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 727, 67))); // woman tipping hand: light skin tone
        trie.insert(new int[]{128587, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 661, 133))); // man raising hand
        trie.insert(new int[]{128587, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 7, 661, 133))); // man raising hand
        trie.insert(new int[]{128587, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 661, 199))); // woman raising hand: dark skin tone
        trie.insert(new int[]{128587, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 661, 199))); // woman raising hand: dark skin tone
        trie.insert(new int[]{129487, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 67, 463))); // deaf man: medium-dark skin tone
        trie.insert(new int[]{129487, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 67, 463))); // deaf man: medium-dark skin tone
        trie.insert(new int[]{128583, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 661, 265))); // person bowing: medium skin tone
        trie.insert(new int[]{128583, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 661, 331))); // woman bowing: medium-light skin tone
        trie.insert(new int[]{128583, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 661, 331))); // woman bowing: medium-light skin tone
        trie.insert(new int[]{129318, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 595, 1))); // man facepalming: light skin tone
        trie.insert(new int[]{129318, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 595, 1))); // man facepalming: light skin tone
        trie.insert(new int[]{129335}, new ParseResult(2, new SpriteCoordinates(2, 7, 265, 529))); // person shrugging
        trie.insert(new int[]{129335, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 331, 529))); // man shrugging: dark skin tone
        trie.insert(new int[]{129335, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 331, 529))); // man shrugging: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 199))); // health worker: medium-dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 7, 397, 199))); // health worker: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 7, 793, 397))); // woman health worker: medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 793, 397))); // woman health worker: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 7, 67, 859))); // man student: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 7, 463, 397))); // teacher: light skin tone
        trie.insert(new int[]{128105, 8205, 127979}, new ParseResult(5, new SpriteCoordinates(2, 7, 529, 793))); // woman teacher
        trie.insert(new int[]{129489, 127999, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 1))); // judge: dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 7, 397, 1))); // judge: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 7, 793, 199))); // woman judge: medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 793, 199))); // woman judge: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 7, 859, 727))); // man farmer: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 7, 463, 67))); // cook: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 7, 463, 793))); // woman cook: light skin tone
        trie.insert(new int[]{128104, 8205, 128295}, new ParseResult(5, new SpriteCoordinates(2, 7, 727, 793))); // man mechanic
        trie.insert(new int[]{128105, 127999, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 7, 727, 727))); // woman mechanic: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 7, 859, 397))); // man factory worker: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 7, 265, 397))); // office worker: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 793))); // woman office worker: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 859))); // man scientist: light skin tone
        trie.insert(new int[]{129489, 8205, 128187}, new ParseResult(5, new SpriteCoordinates(2, 7, 265, 331))); // technologist
        trie.insert(new int[]{128104, 127999, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 7, 859, 199))); // man technologist: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 7, 67, 397))); // singer: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 7, 793, 595))); // woman singer: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 7, 1, 859))); // man artist: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 463, 199))); // pilot: light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 7, 463, 199))); // pilot: light skin tone
        trie.insert(new int[]{128105, 8205, 9992}, new ParseResult(4, new SpriteCoordinates(2, 7, 397, 727))); // woman pilot
        trie.insert(new int[]{128105, 8205, 9992, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 397, 727))); // woman pilot
        trie.insert(new int[]{129489, 127999, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 67))); // astronaut: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 7, 793, 265))); // woman astronaut: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 7, 859, 661))); // man firefighter: medium skin tone
        trie.insert(new int[]{128110, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 133, 727))); // police officer: medium-light skin tone
        trie.insert(new int[]{128110, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 199, 727))); // woman police officer: light skin tone
        trie.insert(new int[]{128110, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 727))); // woman police officer: light skin tone
        trie.insert(new int[]{128373, 65039, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 7, 133, 661))); // man detective
        trie.insert(new int[]{128373, 65039, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 7, 133, 661))); // man detective
        trie.insert(new int[]{128373, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 133, 661))); // man detective
        trie.insert(new int[]{128373, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 7, 133, 661))); // man detective
        trie.insert(new int[]{128373, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 661))); // woman detective: dark skin tone
        trie.insert(new int[]{128373, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 199, 661))); // woman detective: dark skin tone
        trie.insert(new int[]{128130, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 661, 661))); // man guard: medium-dark skin tone
        trie.insert(new int[]{128130, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 661, 661))); // man guard: medium-dark skin tone
        trie.insert(new int[]{129399, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 265))); // ninja: medium skin tone
        trie.insert(new int[]{128119, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 727, 199))); // man construction worker: medium-light skin tone
        trie.insert(new int[]{128119, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 727, 199))); // man construction worker: medium-light skin tone
        trie.insert(new int[]{129733, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 1, 199))); // person with crown: light skin tone
        trie.insert(new int[]{128120}, new ParseResult(2, new SpriteCoordinates(2, 7, 727, 133))); // princess
        trie.insert(new int[]{128115, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 727, 397))); // person wearing turban: dark skin tone
        trie.insert(new int[]{128115, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 727, 463))); // woman wearing turban: medium-dark skin tone
        trie.insert(new int[]{128115, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 727, 463))); // woman wearing turban: medium-dark skin tone
        trie.insert(new int[]{129493, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 331, 199))); // woman with headscarf: medium skin tone
        trie.insert(new int[]{129333, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 397, 529))); // man in tuxedo: medium-light skin tone
        trie.insert(new int[]{129333, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 529))); // man in tuxedo: medium-light skin tone
        trie.insert(new int[]{128112, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 1, 727))); // person with veil: light skin tone
        trie.insert(new int[]{128112, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 727, 661))); // woman with veil
        trie.insert(new int[]{128112, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 727, 661))); // woman with veil
        trie.insert(new int[]{129328, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 529))); // pregnant woman: dark skin tone
        trie.insert(new int[]{129732, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 199))); // pregnant person: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 7, 793, 661))); // woman feeding baby: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 7, 463, 1))); // person feeding baby: medium-light skin tone
        trie.insert(new int[]{127877, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 925, 529))); // Santa Claus: light skin tone
        trie.insert(new int[]{129489, 8205, 127876}, new ParseResult(5, new SpriteCoordinates(2, 7, 1, 463))); // mx claus
        trie.insert(new int[]{129464, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 67))); // superhero: dark skin tone
        trie.insert(new int[]{129464, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 529, 133))); // woman superhero: medium-dark skin tone
        trie.insert(new int[]{129464, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 529, 133))); // woman superhero: medium-dark skin tone
        trie.insert(new int[]{129465, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 529, 1))); // man supervillain: medium skin tone
        trie.insert(new int[]{129465, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 529, 1))); // man supervillain: medium skin tone
        trie.insert(new int[]{129497, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 265))); // mage: medium-light skin tone
        trie.insert(new int[]{129497, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 133, 265))); // woman mage: light skin tone
        trie.insert(new int[]{129497, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 133, 265))); // woman mage: light skin tone
        trie.insert(new int[]{129498, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 199))); // man fairy
        trie.insert(new int[]{129498, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 265, 199))); // man fairy
        trie.insert(new int[]{129498, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 1, 265))); // woman fairy: dark skin tone
        trie.insert(new int[]{129498, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 1, 265))); // woman fairy: dark skin tone
        trie.insert(new int[]{129499, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 265, 133))); // man vampire: medium-dark skin tone
        trie.insert(new int[]{129499, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 265, 133))); // man vampire: medium-dark skin tone
        trie.insert(new int[]{129500, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 1))); // merperson: medium skin tone
        trie.insert(new int[]{129500, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 265, 67))); // mermaid: medium-light skin tone
        trie.insert(new int[]{129500, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 265, 67))); // mermaid: medium-light skin tone
        trie.insert(new int[]{129501, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 199))); // man elf: light skin tone
        trie.insert(new int[]{129501, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 199, 199))); // man elf: light skin tone
        trie.insert(new int[]{129502}, new ParseResult(2, new SpriteCoordinates(2, 7, 133, 199))); // genie
        trie.insert(new int[]{128134, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 463, 661))); // person getting massage: medium-dark skin tone
        trie.insert(new int[]{128134, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 529, 661))); // woman getting massage: medium skin tone
        trie.insert(new int[]{128134, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 529, 661))); // woman getting massage: medium skin tone
        trie.insert(new int[]{128135, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 397, 661))); // man getting haircut: medium-light skin tone
        trie.insert(new int[]{128135, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 661))); // man getting haircut: medium-light skin tone
        trie.insert(new int[]{128694, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 133, 595))); // person walking: light skin tone
        trie.insert(new int[]{128694, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 529))); // woman walking
        trie.insert(new int[]{128694, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 595, 529))); // woman walking
        trie.insert(new int[]{128694, 127999, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 7, 1, 595))); // person walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 1, 595))); // person walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 67, 595))); // man walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 67, 595))); // man walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 7, 67, 595))); // man walking facing right
        trie.insert(new int[]{128694, 127998, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 7, 67, 595))); // man walking facing right
        trie.insert(new int[]{129485, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 397, 463))); // man standing: medium skin tone
        trie.insert(new int[]{129485, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 463))); // man standing: medium skin tone
        trie.insert(new int[]{129486, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 463))); // person kneeling: medium-light skin tone
        trie.insert(new int[]{129486, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 331, 463))); // woman kneeling: light skin tone
        trie.insert(new int[]{129486, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 331, 463))); // woman kneeling: light skin tone
        trie.insert(new int[]{129486, 8205, 9792, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 133, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 8205, 9792, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 7, 133, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 8205, 9792, 65039, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 7, 133, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 7, 133, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 7, 199, 463))); // man kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 199, 463))); // man kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 7, 199, 463))); // man kneeling facing right
        trie.insert(new int[]{129486, 127999, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 199, 463))); // man kneeling facing right
        trie.insert(new int[]{129489, 127998, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 397, 331))); // person with white cane facing right
        trie.insert(new int[]{129489, 127998, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 397, 331))); // person with white cane facing right
        trie.insert(new int[]{128104, 127997, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 859, 595))); // man with white cane facing right
        trie.insert(new int[]{128104, 127997, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 859, 595))); // man with white cane facing right
        trie.insert(new int[]{128105, 127996, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 133, 793))); // woman with white cane facing right
        trie.insert(new int[]{128105, 127996, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 133, 793))); // woman with white cane facing right
        trie.insert(new int[]{129489, 127995, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 463, 265))); // person in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127995, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 463, 265))); // person in motorized wheelchair facing right
        trie.insert(new int[]{128104, 8205, 129468, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 7, 595, 793))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128104, 8205, 129468, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 7, 595, 793))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127999, 8205, 129468}, new ParseResult(7, new SpriteCoordinates(2, 7, 595, 727))); // woman in motorized wheelchair: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 7, 397, 265))); // person in manual wheelchair: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 7, 859, 529))); // man in manual wheelchair: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 7, 67, 793))); // woman in manual wheelchair: medium-light skin tone
        trie.insert(new int[]{127939, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 925, 463))); // person running: light skin tone
        trie.insert(new int[]{127939, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 925, 265))); // woman running
        trie.insert(new int[]{127939, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 925, 265))); // woman running
        trie.insert(new int[]{127939, 127999, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 925, 331))); // person running facing right
        trie.insert(new int[]{127939, 127999, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 7, 925, 331))); // person running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 7, 925, 397))); // man running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 7, 925, 397))); // man running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 7, 925, 397))); // man running facing right
        trie.insert(new int[]{127939, 127998, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 7, 925, 397))); // man running facing right
        trie.insert(new int[]{128378, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 661))); // man dancing: medium skin tone
        trie.insert(new int[]{128111, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 67, 727))); // women with bunny ears
        trie.insert(new int[]{128111, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 727))); // women with bunny ears
        trie.insert(new int[]{129494, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 331, 133))); // man in steamy room: medium-dark skin tone
        trie.insert(new int[]{129494, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 331, 133))); // man in steamy room: medium-dark skin tone
        trie.insert(new int[]{129495, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 331, 1))); // person climbing: medium skin tone
        trie.insert(new int[]{129495, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 331, 67))); // woman climbing: medium-light skin tone
        trie.insert(new int[]{129495, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 331, 67))); // woman climbing: medium-light skin tone
        trie.insert(new int[]{9975, 65039}, new ParseResult(2, new SpriteCoordinates(2, 7, 133, 1))); // skier
        trie.insert(new int[]{9975}, new ParseResult(1, new SpriteCoordinates(2, 7, 133, 1))); // skier
        trie.insert(new int[]{127948, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 727, 859))); // person golfing: medium-dark skin tone
        trie.insert(new int[]{127948, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 793, 859))); // woman golfing: medium skin tone
        trie.insert(new int[]{127948, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 793, 859))); // woman golfing: medium skin tone
        trie.insert(new int[]{127940, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 925, 199))); // man surfing: medium-light skin tone
        trie.insert(new int[]{127940, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 925, 199))); // man surfing: medium-light skin tone
        trie.insert(new int[]{128675, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 463, 595))); // person rowing boat: light skin tone
        trie.insert(new int[]{128675, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 397, 595))); // woman rowing boat
        trie.insert(new int[]{128675, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 397, 595))); // woman rowing boat
        trie.insert(new int[]{127946, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 925, 67))); // person swimming: dark skin tone
        trie.insert(new int[]{127946, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 925, 133))); // woman swimming: medium-dark skin tone
        trie.insert(new int[]{127946, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 925, 133))); // woman swimming: medium-dark skin tone
        trie.insert(new int[]{9977, 127997, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 7, 67, 67))); // man bouncing ball: medium skin tone
        trie.insert(new int[]{9977, 127997, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 7, 67, 67))); // man bouncing ball: medium skin tone
        trie.insert(new int[]{127947, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 859, 859))); // person lifting weights: medium-light skin tone
        trie.insert(new int[]{127947, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 925, 1))); // woman lifting weights: light skin tone
        trie.insert(new int[]{127947, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 925, 1))); // woman lifting weights: light skin tone
        trie.insert(new int[]{128692, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 595))); // man biking
        trie.insert(new int[]{128692, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 265, 595))); // man biking
        trie.insert(new int[]{128692, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 331, 595))); // woman biking: dark skin tone
        trie.insert(new int[]{128692, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 331, 595))); // woman biking: dark skin tone
        trie.insert(new int[]{128693, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 595))); // man mountain biking: medium-dark skin tone
        trie.insert(new int[]{128693, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 199, 595))); // man mountain biking: medium-dark skin tone
        trie.insert(new int[]{129336, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 133, 529))); // person cartwheeling: medium skin tone
        trie.insert(new int[]{129336, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 199, 529))); // woman cartwheeling: medium-light skin tone
        trie.insert(new int[]{129336, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 199, 529))); // woman cartwheeling: medium-light skin tone
        trie.insert(new int[]{129341, 127998}, new ParseResult(4, new SpriteCoordinates(2, 7, 529, 397))); // person playing water polo: medium-dark skin tone
        trie.insert(new int[]{129341, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 529, 463))); // woman playing water polo: medium skin tone
        trie.insert(new int[]{129341, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 529, 463))); // woman playing water polo: medium skin tone
        trie.insert(new int[]{129342, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 7, 529, 331))); // man playing handball: medium-light skin tone
        trie.insert(new int[]{129342, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 529, 331))); // man playing handball: medium-light skin tone
        trie.insert(new int[]{129337, 127995}, new ParseResult(4, new SpriteCoordinates(2, 7, 67, 529))); // person juggling: light skin tone
        trie.insert(new int[]{129337, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 7, 1, 529))); // woman juggling
        trie.insert(new int[]{129337, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 7, 1, 529))); // woman juggling
        trie.insert(new int[]{129496, 127999}, new ParseResult(4, new SpriteCoordinates(2, 7, 199, 265))); // person in lotus position: dark skin tone
        trie.insert(new int[]{129496, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 7, 265, 265))); // woman in lotus position: medium-dark skin tone
        trie.insert(new int[]{129496, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 7, 265, 265))); // woman in lotus position: medium-dark skin tone
        trie.insert(new int[]{128716, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 595, 463))); // person in bed: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129309, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 7, 397, 397))); // people holding hands: medium-light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129309, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 7, 1, 397))); // people holding hands: medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 7, 397, 793))); // women holding hands: light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 7, 793, 463))); // women holding hands: medium skin tone, dark skin tone
        trie.insert(new int[]{128107}, new ParseResult(2, new SpriteCoordinates(2, 7, 331, 727))); // woman and man holding hands
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 7, 793, 529))); // woman and man holding hands: medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 7, 661, 727))); // woman and man holding hands: dark skin tone, medium-light skin tone
        trie.insert(new int[]{128108, 127996}, new ParseResult(4, new SpriteCoordinates(2, 7, 265, 727))); // men holding hands: medium-light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 7, 859, 331))); // men holding hands: medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128143, 127997}, new ParseResult(4, new SpriteCoordinates(2, 7, 331, 661))); // kiss: medium skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127995}, new ParseResult(15, new SpriteCoordinates(2, 7, 133, 397))); // kiss: person, person, medium skin tone, light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127995}, new ParseResult(14, new SpriteCoordinates(2, 7, 133, 397))); // kiss: person, person, medium skin tone, light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 128139, 8205, 129489, 127998}, new ParseResult(14, new SpriteCoordinates(2, 7, 331, 331))); // kiss: person, person, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998}, new ParseResult(15, new SpriteCoordinates(2, 7, 331, 331))); // kiss: person, person, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 7, 793, 727))); // kiss: woman, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 7, 793, 727))); // kiss: woman, man, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 7, 529, 727))); // kiss: woman, man, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 7, 529, 727))); // kiss: woman, man, dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 7, 859, 793))); // kiss: man, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 7, 859, 793))); // kiss: man, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 7, 859, 265))); // kiss: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 7, 859, 265))); // kiss: man, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127996}, new ParseResult(14, new SpriteCoordinates(2, 7, 265, 793))); // kiss: woman, woman, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127996}, new ParseResult(15, new SpriteCoordinates(2, 7, 265, 793))); // kiss: woman, woman, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127997}, new ParseResult(14, new SpriteCoordinates(2, 7, 793, 331))); // kiss: woman, woman, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997}, new ParseResult(15, new SpriteCoordinates(2, 7, 793, 331))); // kiss: woman, woman, medium skin tone
    }

    public static void init7(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127998}, new ParseResult(14, new SpriteCoordinates(2, 7, 463, 727))); // kiss: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998}, new ParseResult(15, new SpriteCoordinates(2, 7, 463, 727))); // kiss: woman, woman, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 129489, 127999}, new ParseResult(11, new SpriteCoordinates(2, 7, 463, 133))); // couple with heart: person, person, light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 7, 463, 133))); // couple with heart: person, person, light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 129489, 127997}, new ParseResult(11, new SpriteCoordinates(2, 7, 397, 133))); // couple with heart: person, person, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 7, 397, 133))); // couple with heart: person, person, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 7, 331, 793))); // couple with heart: woman, man, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 7, 331, 793))); // couple with heart: woman, man, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 7, 793, 133))); // couple with heart: woman, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 7, 793, 133))); // couple with heart: woman, man, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 7, 133, 859))); // couple with heart: man, man, light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 7, 133, 859))); // couple with heart: man, man, light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 7, 859, 463))); // couple with heart: man, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 7, 859, 463))); // couple with heart: man, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 7, 859, 67))); // couple with heart: man, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 7, 859, 67))); // couple with heart: man, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 7, 1, 793))); // couple with heart: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128105, 127997}, new ParseResult(11, new SpriteCoordinates(2, 7, 1, 793))); // couple with heart: woman, woman, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128105, 127998}, new ParseResult(11, new SpriteCoordinates(2, 7, 793, 67))); // couple with heart: woman, woman, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 7, 793, 67))); // couple with heart: woman, woman, medium-dark skin tone
        trie.insert(new int[]{128104, 8205, 128105, 8205, 128103, 8205, 128103}, new ParseResult(11, new SpriteCoordinates(2, 7, 793, 793))); // family: man, woman, girl, girl
        trie.insert(new int[]{128104, 8205, 128102}, new ParseResult(5, new SpriteCoordinates(2, 7, 859, 1))); // family: man, boy
        trie.insert(new int[]{128100}, new ParseResult(2, new SpriteCoordinates(2, 7, 331, 859))); // bust in silhouette
        trie.insert(new int[]{129306, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 265))); // raised back of hand: medium-light skin tone
        trie.insert(new int[]{9995, 127995}, new ParseResult(3, new SpriteCoordinates(2, 8, 1, 67))); // raised hand: light skin tone
        trie.insert(new int[]{129777}, new ParseResult(2, new SpriteCoordinates(2, 8, 133, 133))); // rightwards hand
        trie.insert(new int[]{129778, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 133))); // leftwards hand: dark skin tone
        trie.insert(new int[]{129780, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 1, 133))); // palm up hand: medium-dark skin tone
        trie.insert(new int[]{129784, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 133, 67))); // rightwards pushing hand: medium skin tone
        trie.insert(new int[]{129292, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 397))); // pinched fingers: medium-light skin tone
        trie.insert(new int[]{9996, 127995}, new ParseResult(3, new SpriteCoordinates(2, 8, 67, 1))); // victory hand: light skin tone
        trie.insert(new int[]{129776}, new ParseResult(2, new SpriteCoordinates(2, 8, 199, 133))); // hand with index finger and thumb crossed
        trie.insert(new int[]{129311, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 67))); // love-you gesture: dark skin tone
        trie.insert(new int[]{129305, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 331))); // call me hand: medium-dark skin tone
        trie.insert(new int[]{128073, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 859))); // backhand index pointing right: medium skin tone
        trie.insert(new int[]{128405, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 529))); // middle finger: medium-light skin tone
        trie.insert(new int[]{9757, 127995}, new ParseResult(3, new SpriteCoordinates(2, 8, 133, 1))); // index pointing up: light skin tone
        trie.insert(new int[]{128077}, new ParseResult(2, new SpriteCoordinates(2, 8, 463, 859))); // thumbs up
        trie.insert(new int[]{128078, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 397, 859))); // thumbs down: dark skin tone
        trie.insert(new int[]{128074, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 859))); // oncoming fist: medium-dark skin tone
        trie.insert(new int[]{129308, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 199))); // right-facing fist: medium skin tone
        trie.insert(new int[]{128588, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 67))); // raising hands: medium-light skin tone
        trie.insert(new int[]{128080, 127995}, new ParseResult(4, new SpriteCoordinates(2, 8, 331, 859))); // open hands: light skin tone
        trie.insert(new int[]{129309}, new ParseResult(2, new SpriteCoordinates(2, 8, 595, 133))); // handshake
        trie.insert(new int[]{129777, 127996, 8205, 129778, 127997}, new ParseResult(9, new SpriteCoordinates(2, 8, 199, 67))); // handshake: medium-light skin tone, medium skin tone
        trie.insert(new int[]{129777, 127999, 8205, 129778, 127995}, new ParseResult(9, new SpriteCoordinates(2, 8, 199, 1))); // handshake: dark skin tone, light skin tone
        trie.insert(new int[]{9997, 127995}, new ParseResult(3, new SpriteCoordinates(2, 8, 1, 1))); // writing hand: light skin tone
        trie.insert(new int[]{129331}, new ParseResult(2, new SpriteCoordinates(2, 8, 529, 529))); // selfie
        trie.insert(new int[]{128170, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 661))); // flexed biceps: dark skin tone
        trie.insert(new int[]{129462, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 265))); // foot: medium-light skin tone
        trie.insert(new int[]{129467, 127995}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 1))); // ear with hearing aid: light skin tone
        trie.insert(new int[]{129504}, new ParseResult(2, new SpriteCoordinates(2, 8, 199, 199))); // brain
        trie.insert(new int[]{128118, 127995}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 67))); // baby: light skin tone
        trie.insert(new int[]{128102}, new ParseResult(2, new SpriteCoordinates(2, 8, 199, 859))); // boy
        trie.insert(new int[]{128103, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 133, 859))); // girl: dark skin tone
        trie.insert(new int[]{128113, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 397))); // person: medium-dark skin tone, blond hair
        trie.insert(new int[]{129492, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 133, 331))); // person: medium skin tone, beard
        trie.insert(new int[]{129492, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 199, 331))); // woman: medium-light skin tone, beard
        trie.insert(new int[]{129492, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 199, 331))); // woman: medium-light skin tone, beard
        trie.insert(new int[]{128104, 127995, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 8, 1, 859))); // man: light skin tone, curly hair
        trie.insert(new int[]{128104, 8205, 129458}, new ParseResult(5, new SpriteCoordinates(2, 8, 463, 793))); // man: bald
        trie.insert(new int[]{128105, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 331, 727))); // woman: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 8, 397, 331))); // person: medium-dark skin tone, red hair
        trie.insert(new int[]{129489, 127997, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 8, 199, 397))); // person: medium skin tone, curly hair
        trie.insert(new int[]{129489, 127996, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 133))); // person: medium-light skin tone, white hair
        trie.insert(new int[]{129489, 127995, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 331))); // person: light skin tone, bald
        trie.insert(new int[]{128113, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 331))); // man: blond hair
        trie.insert(new int[]{128113, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 727, 331))); // man: blond hair
        trie.insert(new int[]{129491, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 265, 331))); // older person: dark skin tone
        trie.insert(new int[]{128117, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 133))); // old woman: medium-dark skin tone
        trie.insert(new int[]{128589, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 661, 1))); // man frowning: medium skin tone
        trie.insert(new int[]{128589, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 661, 1))); // man frowning: medium skin tone
        trie.insert(new int[]{128590, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 595))); // person pouting: medium-light skin tone
        trie.insert(new int[]{128590, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 595, 595))); // woman pouting: light skin tone
        trie.insert(new int[]{128590, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 595, 595))); // woman pouting: light skin tone
        trie.insert(new int[]{128581, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 397))); // man gesturing NO
        trie.insert(new int[]{128581, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 661, 397))); // man gesturing NO
        trie.insert(new int[]{128581, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 661, 463))); // woman gesturing NO: dark skin tone
        trie.insert(new int[]{128581, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 661, 463))); // woman gesturing NO: dark skin tone
        trie.insert(new int[]{128582, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 661, 331))); // man gesturing OK: medium-dark skin tone
        trie.insert(new int[]{128582, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 661, 331))); // man gesturing OK: medium-dark skin tone
        trie.insert(new int[]{128129, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 661))); // person tipping hand: medium skin tone
        trie.insert(new int[]{128129, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 595, 661))); // woman tipping hand: medium-light skin tone
        trie.insert(new int[]{128129, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 595, 661))); // woman tipping hand: medium-light skin tone
        trie.insert(new int[]{128587, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 661, 133))); // man raising hand: light skin tone
        trie.insert(new int[]{128587, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 661, 133))); // man raising hand: light skin tone
        trie.insert(new int[]{129487}, new ParseResult(2, new SpriteCoordinates(2, 8, 133, 463))); // deaf person
        trie.insert(new int[]{129487, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 199, 463))); // deaf man: dark skin tone
        trie.insert(new int[]{129487, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 199, 463))); // deaf man: dark skin tone
        trie.insert(new int[]{128583, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 199))); // person bowing: medium-dark skin tone
        trie.insert(new int[]{128583, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 661, 265))); // woman bowing: medium skin tone
        trie.insert(new int[]{128583, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 661, 265))); // woman bowing: medium skin tone
        trie.insert(new int[]{129318, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 595, 1))); // man facepalming: medium-light skin tone
        trie.insert(new int[]{129318, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 595, 1))); // man facepalming: medium-light skin tone
        trie.insert(new int[]{129335, 127995}, new ParseResult(4, new SpriteCoordinates(2, 8, 397, 529))); // person shrugging: light skin tone
        trie.insert(new int[]{129335, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 331, 529))); // woman shrugging
        trie.insert(new int[]{129335, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 8, 331, 529))); // woman shrugging
        trie.insert(new int[]{129489, 127999, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 8, 397, 1))); // health worker: dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 397, 1))); // health worker: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 793, 67))); // woman health worker: medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 8, 793, 67))); // woman health worker: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 463))); // man student: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 265))); // teacher: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 793))); // woman teacher: light skin tone
        trie.insert(new int[]{128104, 8205, 9878}, new ParseResult(4, new SpriteCoordinates(2, 8, 397, 793))); // man judge
        trie.insert(new int[]{128104, 8205, 9878, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 397, 793))); // man judge
        trie.insert(new int[]{128105, 127999, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 529, 727))); // woman judge: dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 8, 529, 727))); // woman judge: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 265))); // man farmer: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 397))); // cook: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 8, 67, 793))); // woman cook: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 8, 67, 859))); // man mechanic: light skin tone
        trie.insert(new int[]{129489, 8205, 127981}, new ParseResult(5, new SpriteCoordinates(2, 8, 67, 463))); // factory worker
        trie.insert(new int[]{128104, 127999, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 8, 793, 793))); // man factory worker: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 8, 67, 397))); // office worker: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 8, 793, 661))); // woman office worker: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 661))); // man scientist: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 397))); // technologist: light skin tone
        trie.insert(new int[]{128105, 8205, 128187}, new ParseResult(5, new SpriteCoordinates(2, 8, 265, 727))); // woman technologist
        trie.insert(new int[]{129489, 127999, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 8, 397, 199))); // singer: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 8, 793, 199))); // woman singer: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 397))); // man artist: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 1))); // pilot: medium-light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 8, 463, 1))); // pilot: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 8, 199, 793))); // woman pilot: light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 199, 793))); // woman pilot: light skin tone
        trie.insert(new int[]{128104, 8205, 128640}, new ParseResult(5, new SpriteCoordinates(2, 8, 529, 793))); // man astronaut
        trie.insert(new int[]{128105, 127999, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 8, 661, 727))); // woman astronaut: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 199))); // man firefighter: medium-dark skin tone
        trie.insert(new int[]{128110, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 595))); // police officer: medium skin tone
        trie.insert(new int[]{128110, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 727, 661))); // woman police officer: medium-light skin tone
        trie.insert(new int[]{128110, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 727, 661))); // woman police officer: medium-light skin tone
        trie.insert(new int[]{128373, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 1, 661))); // man detective: light skin tone
        trie.insert(new int[]{128373, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 1, 661))); // man detective: light skin tone
        trie.insert(new int[]{128130}, new ParseResult(2, new SpriteCoordinates(2, 8, 397, 661))); // guard
        trie.insert(new int[]{128130, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 661))); // man guard: dark skin tone
        trie.insert(new int[]{128130, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 463, 661))); // man guard: dark skin tone
        trie.insert(new int[]{129399, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 331))); // ninja: medium-dark skin tone
        trie.insert(new int[]{128119, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 727, 1))); // man construction worker: medium skin tone
        trie.insert(new int[]{128119, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 727, 1))); // man construction worker: medium skin tone
        trie.insert(new int[]{129733, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 1, 199))); // person with crown: medium-light skin tone
        trie.insert(new int[]{128120, 127995}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 661))); // princess: light skin tone
        trie.insert(new int[]{128115, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 199))); // man wearing turban
        trie.insert(new int[]{128115, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 727, 199))); // man wearing turban
        trie.insert(new int[]{128115, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 727, 265))); // woman wearing turban: dark skin tone
        trie.insert(new int[]{128115, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 727, 265))); // woman wearing turban: dark skin tone
        trie.insert(new int[]{129493, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 331))); // woman with headscarf: medium-dark skin tone
        trie.insert(new int[]{129333, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 529))); // man in tuxedo: medium skin tone
        trie.insert(new int[]{129333, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 463, 529))); // man in tuxedo: medium skin tone
        trie.insert(new int[]{128112, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 727, 463))); // person with veil: medium-light skin tone
        trie.insert(new int[]{128112, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 727, 529))); // woman with veil: light skin tone
        trie.insert(new int[]{128112, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 727, 529))); // woman with veil: light skin tone
        trie.insert(new int[]{129731}, new ParseResult(2, new SpriteCoordinates(2, 8, 133, 199))); // pregnant man
        trie.insert(new int[]{129732, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 199))); // pregnant person: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 8, 793, 265))); // woman feeding baby: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 8, 265, 397))); // person feeding baby: medium skin tone
        trie.insert(new int[]{127877, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 925, 529))); // Santa Claus: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127876}, new ParseResult(7, new SpriteCoordinates(2, 8, 1, 463))); // mx claus: light skin tone
        trie.insert(new int[]{129464, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 529, 133))); // man superhero
        trie.insert(new int[]{129464, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 133))); // man superhero
        trie.insert(new int[]{129464, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 529, 199))); // woman superhero: dark skin tone
        trie.insert(new int[]{129464, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 529, 199))); // woman superhero: dark skin tone
        trie.insert(new int[]{129465, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 529, 67))); // man supervillain: medium-dark skin tone
        trie.insert(new int[]{129465, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 529, 67))); // man supervillain: medium-dark skin tone
        trie.insert(new int[]{129497, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 199, 265))); // mage: medium skin tone
        trie.insert(new int[]{129497, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 265, 265))); // woman mage: medium-light skin tone
        trie.insert(new int[]{129497, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 265, 265))); // woman mage: medium-light skin tone
        trie.insert(new int[]{129498, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 133, 265))); // man fairy: light skin tone
        trie.insert(new int[]{129498, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 133, 265))); // man fairy: light skin tone
        trie.insert(new int[]{129499}, new ParseResult(2, new SpriteCoordinates(2, 8, 1, 265))); // vampire
        trie.insert(new int[]{129499, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 67, 265))); // man vampire: dark skin tone
        trie.insert(new int[]{129499, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 67, 265))); // man vampire: dark skin tone
        trie.insert(new int[]{129500, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 265, 133))); // merperson: medium-dark skin tone
        trie.insert(new int[]{129500, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 265, 199))); // mermaid: medium skin tone
        trie.insert(new int[]{129500, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 265, 199))); // mermaid: medium skin tone
        trie.insert(new int[]{129501, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 265, 67))); // man elf: medium-light skin tone
        trie.insert(new int[]{129501, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 265, 67))); // man elf: medium-light skin tone
        trie.insert(new int[]{129502, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 265, 1))); // man genie
        trie.insert(new int[]{129502, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 265, 1))); // man genie
        trie.insert(new int[]{128134, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 265, 661))); // person getting massage: dark skin tone
        trie.insert(new int[]{128134, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 331, 661))); // woman getting massage: medium-dark skin tone
        trie.insert(new int[]{128134, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 661))); // woman getting massage: medium-dark skin tone
        trie.insert(new int[]{128135, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 199, 661))); // man getting haircut: medium skin tone
        trie.insert(new int[]{128135, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 199, 661))); // man getting haircut: medium skin tone
        trie.insert(new int[]{128694, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 595))); // person walking: medium-light skin tone
        trie.insert(new int[]{128694, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 133, 595))); // woman walking: light skin tone
        trie.insert(new int[]{128694, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 133, 595))); // woman walking: light skin tone
        trie.insert(new int[]{128694, 8205, 9792, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 595, 529))); // woman walking facing right
        trie.insert(new int[]{128694, 8205, 9792, 65039, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 8, 595, 529))); // woman walking facing right
        trie.insert(new int[]{128694, 8205, 9792, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 8, 595, 529))); // woman walking facing right
        trie.insert(new int[]{128694, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 8, 595, 529))); // woman walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 1, 595))); // man walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 8, 1, 595))); // man walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 8, 1, 595))); // man walking facing right
        trie.insert(new int[]{128694, 127999, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 1, 595))); // man walking facing right
        trie.insert(new int[]{129485, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 463, 463))); // man standing: medium-dark skin tone
        trie.insert(new int[]{129485, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 463))); // man standing: medium-dark skin tone
        trie.insert(new int[]{129486, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 265, 463))); // person kneeling: medium skin tone
        trie.insert(new int[]{129486, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 463))); // woman kneeling: medium-light skin tone
        trie.insert(new int[]{129486, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 331, 463))); // woman kneeling: medium-light skin tone
        trie.insert(new int[]{129486, 127995, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 8, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 8, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127995, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129489, 8205, 129455}, new ParseResult(5, new SpriteCoordinates(2, 8, 331, 331))); // person with white cane
        trie.insert(new int[]{129489, 127999, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 397, 133))); // person with white cane facing right
        trie.insert(new int[]{129489, 127999, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 397, 133))); // person with white cane facing right
        trie.insert(new int[]{128104, 127998, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 859, 133))); // man with white cane facing right
        trie.insert(new int[]{128104, 127998, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 859, 133))); // man with white cane facing right
        trie.insert(new int[]{128105, 127997, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 793, 529))); // woman with white cane facing right
        trie.insert(new int[]{128105, 127997, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 793, 529))); // woman with white cane facing right
        trie.insert(new int[]{129489, 127996, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 463, 67))); // person in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127996, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 463, 67))); // person in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127995, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 859, 793))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127995, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 859, 793))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128105, 8205, 129468, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 8, 199, 727))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{128105, 8205, 129468, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 8, 199, 727))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127999, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 8, 397, 67))); // person in manual wheelchair: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 67))); // man in manual wheelchair: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 8, 793, 463))); // woman in manual wheelchair: medium skin tone
        trie.insert(new int[]{127939, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 925, 331))); // person running: medium-light skin tone
        trie.insert(new int[]{127939, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 925, 397))); // woman running: light skin tone
        trie.insert(new int[]{127939, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 925, 397))); // woman running: light skin tone
        trie.insert(new int[]{127939, 8205, 9792, 8205, 10145, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 925, 199))); // woman running facing right
        trie.insert(new int[]{127939, 8205, 9792, 8205, 10145}, new ParseResult(6, new SpriteCoordinates(2, 8, 925, 199))); // woman running facing right
        trie.insert(new int[]{127939, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 8, 925, 199))); // woman running facing right
        trie.insert(new int[]{127939, 8205, 9792, 65039, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 8, 925, 199))); // woman running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9794, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 8, 925, 265))); // man running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9794, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 8, 925, 265))); // man running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9794, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 8, 925, 265))); // man running facing right
        trie.insert(new int[]{127939, 127999, 8205, 9794, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 8, 925, 265))); // man running facing right
        trie.insert(new int[]{128378, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 595))); // man dancing: medium-dark skin tone
        trie.insert(new int[]{129494}, new ParseResult(2, new SpriteCoordinates(2, 8, 331, 265))); // person in steamy room
        trie.insert(new int[]{129494, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 1, 331))); // man in steamy room: dark skin tone
        trie.insert(new int[]{129494, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 1, 331))); // man in steamy room: dark skin tone
        trie.insert(new int[]{129495, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 331, 133))); // person climbing: medium-dark skin tone
        trie.insert(new int[]{129495, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 331, 199))); // woman climbing: medium skin tone
        trie.insert(new int[]{129495, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 199))); // woman climbing: medium skin tone
        trie.insert(new int[]{127938}, new ParseResult(2, new SpriteCoordinates(2, 8, 925, 463))); // snowboarder
        trie.insert(new int[]{127948, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 661, 859))); // person golfing: dark skin tone
        trie.insert(new int[]{127948, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 727, 859))); // woman golfing: medium-dark skin tone
        trie.insert(new int[]{127948, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 727, 859))); // woman golfing: medium-dark skin tone
        trie.insert(new int[]{127940, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 925, 133))); // man surfing: medium skin tone
        trie.insert(new int[]{127940, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 925, 133))); // man surfing: medium skin tone
        trie.insert(new int[]{128675, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 397, 595))); // person rowing boat: medium-light skin tone
        trie.insert(new int[]{128675, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 463, 595))); // woman rowing boat: light skin tone
        trie.insert(new int[]{128675, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 463, 595))); // woman rowing boat: light skin tone
        trie.insert(new int[]{127946, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 925, 1))); // man swimming
        trie.insert(new int[]{127946, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 925, 1))); // man swimming
        trie.insert(new int[]{127946, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 925, 67))); // woman swimming: dark skin tone
        trie.insert(new int[]{127946, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 925, 67))); // woman swimming: dark skin tone
        trie.insert(new int[]{9977, 127998, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 8, 67, 67))); // man bouncing ball: medium-dark skin tone
        trie.insert(new int[]{9977, 127998, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 8, 67, 67))); // man bouncing ball: medium-dark skin tone
        trie.insert(new int[]{127947, 127997}, new ParseResult(4, new SpriteCoordinates(2, 8, 793, 859))); // person lifting weights: medium skin tone
        trie.insert(new int[]{127947, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 859, 859))); // woman lifting weights: medium-light skin tone
        trie.insert(new int[]{127947, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 859, 859))); // woman lifting weights: medium-light skin tone
        trie.insert(new int[]{128692, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 595))); // man biking: light skin tone
        trie.insert(new int[]{128692, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 331, 595))); // man biking: light skin tone
        trie.insert(new int[]{128693}, new ParseResult(2, new SpriteCoordinates(2, 8, 199, 595))); // person mountain biking
        trie.insert(new int[]{128693, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 265, 595))); // man mountain biking: dark skin tone
        trie.insert(new int[]{128693, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 265, 595))); // man mountain biking: dark skin tone
        trie.insert(new int[]{129336, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 199, 529))); // person cartwheeling: medium-dark skin tone
        trie.insert(new int[]{129336, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 265, 529))); // woman cartwheeling: medium skin tone
        trie.insert(new int[]{129336, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 265, 529))); // woman cartwheeling: medium skin tone
        trie.insert(new int[]{129341, 127999}, new ParseResult(4, new SpriteCoordinates(2, 8, 529, 463))); // person playing water polo: dark skin tone
        trie.insert(new int[]{129341, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 1, 529))); // woman playing water polo: medium-dark skin tone
        trie.insert(new int[]{129341, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 1, 529))); // woman playing water polo: medium-dark skin tone
        trie.insert(new int[]{129342, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 8, 529, 397))); // man playing handball: medium skin tone
        trie.insert(new int[]{129342, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 529, 397))); // man playing handball: medium skin tone
        trie.insert(new int[]{129337, 127996}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 529))); // person juggling: medium-light skin tone
        trie.insert(new int[]{129337, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 133, 529))); // woman juggling: light skin tone
        trie.insert(new int[]{129337, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 133, 529))); // woman juggling: light skin tone
        trie.insert(new int[]{129496, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 8, 331, 1))); // man in lotus position
        trie.insert(new int[]{129496, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 8, 331, 1))); // man in lotus position
        trie.insert(new int[]{129496, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 8, 331, 67))); // woman in lotus position: dark skin tone
        trie.insert(new int[]{129496, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 8, 331, 67))); // woman in lotus position: dark skin tone
        trie.insert(new int[]{128716, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 595, 463))); // person in bed: medium-dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129309, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 8, 463, 199))); // people holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 129309, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 8, 1, 397))); // people holding hands: medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 8, 265, 793))); // women holding hands: light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 8, 793, 133))); // women holding hands: medium-dark skin tone, light skin tone
        trie.insert(new int[]{128107, 127995}, new ParseResult(4, new SpriteCoordinates(2, 8, 67, 727))); // woman and man holding hands: light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 8, 793, 595))); // woman and man holding hands: medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 8, 595, 727))); // woman and man holding hands: dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 8, 859, 595))); // men holding hands: medium-light skin tone, medium skin tone
        trie.insert(new int[]{128108, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 1, 727))); // men holding hands: medium-dark skin tone
        trie.insert(new int[]{128143, 127998}, new ParseResult(4, new SpriteCoordinates(2, 8, 133, 661))); // kiss: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127996}, new ParseResult(14, new SpriteCoordinates(2, 8, 133, 397))); // kiss: person, person, medium skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996}, new ParseResult(15, new SpriteCoordinates(2, 8, 133, 397))); // kiss: person, person, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 8205, 10084, 8205, 128139, 8205, 128104}, new ParseResult(10, new SpriteCoordinates(2, 8, 133, 727))); // kiss: woman, man
        trie.insert(new int[]{128105, 8205, 10084, 65039, 8205, 128139, 8205, 128104}, new ParseResult(11, new SpriteCoordinates(2, 8, 133, 727))); // kiss: woman, man
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 8, 793, 397))); // kiss: woman, man, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 8, 793, 397))); // kiss: woman, man, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 8, 463, 727))); // kiss: woman, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 8, 463, 727))); // kiss: woman, man, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 8, 859, 529))); // kiss: man, man, medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 8, 859, 529))); // kiss: man, man, medium-light skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 8, 859, 1))); // kiss: man, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 8, 859, 1))); // kiss: man, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127997}, new ParseResult(15, new SpriteCoordinates(2, 8, 133, 793))); // kiss: woman, woman, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127997}, new ParseResult(14, new SpriteCoordinates(2, 8, 133, 793))); // kiss: woman, woman, light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127998}, new ParseResult(14, new SpriteCoordinates(2, 8, 793, 331))); // kiss: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998}, new ParseResult(15, new SpriteCoordinates(2, 8, 793, 331))); // kiss: woman, woman, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128105, 127999}, new ParseResult(14, new SpriteCoordinates(2, 8, 397, 727))); // kiss: woman, woman, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999}, new ParseResult(15, new SpriteCoordinates(2, 8, 397, 727))); // kiss: woman, woman, dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 8, 397, 397))); // couple with heart: person, person, medium-light skin tone, light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 129489, 127995}, new ParseResult(11, new SpriteCoordinates(2, 8, 397, 397))); // couple with heart: person, person, medium-light skin tone, light skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 65039, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 8, 397, 265))); // couple with heart: person, person, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 10084, 8205, 129489, 127999}, new ParseResult(11, new SpriteCoordinates(2, 8, 397, 265))); // couple with heart: person, person, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 8, 1, 793))); // couple with heart: woman, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128104, 127995}, new ParseResult(11, new SpriteCoordinates(2, 8, 1, 793))); // couple with heart: woman, man, medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 8, 793, 1))); // couple with heart: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 8, 793, 1))); // couple with heart: woman, man, medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 8, 859, 727))); // couple with heart: man, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 8, 859, 727))); // couple with heart: man, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 8, 859, 331))); // couple with heart: man, man, medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 8, 859, 331))); // couple with heart: man, man, medium skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 8, 727, 793))); // couple with heart: man, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 8, 727, 793))); // couple with heart: man, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128105, 127998}, new ParseResult(11, new SpriteCoordinates(2, 8, 793, 727))); // couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128105, 127998}, new ParseResult(12, new SpriteCoordinates(2, 8, 793, 727))); // couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128105, 127999}, new ParseResult(11, new SpriteCoordinates(2, 8, 727, 727))); // couple with heart: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 8, 727, 727))); // couple with heart: woman, woman, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128104, 8205, 128104, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 8, 595, 793))); // family: man, man, boy
        trie.insert(new int[]{128104, 8205, 128102, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 8, 661, 793))); // family: man, boy, boy
        trie.insert(new int[]{128101}, new ParseResult(2, new SpriteCoordinates(2, 8, 265, 859))); // busts in silhouette
        trie.insert(new int[]{129306, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 397))); // raised back of hand: medium skin tone
        trie.insert(new int[]{9995, 127996}, new ParseResult(3, new SpriteCoordinates(2, 9, 1, 67))); // raised hand: medium-light skin tone
        trie.insert(new int[]{129777, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 1, 199))); // rightwards hand: light skin tone
        trie.insert(new int[]{129779}, new ParseResult(2, new SpriteCoordinates(2, 9, 199, 1))); // palm down hand
        trie.insert(new int[]{129780, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 133, 133))); // palm up hand: dark skin tone
        trie.insert(new int[]{129784, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 133))); // rightwards pushing hand: medium-dark skin tone
        trie.insert(new int[]{129292, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 1, 595))); // pinched fingers: medium skin tone
        trie.insert(new int[]{9996, 127996}, new ParseResult(3, new SpriteCoordinates(2, 9, 67, 1))); // victory hand: medium-light skin tone
        trie.insert(new int[]{129776, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 199))); // hand with index finger and thumb crossed: light skin tone
        trie.insert(new int[]{129304}, new ParseResult(2, new SpriteCoordinates(2, 9, 595, 529))); // sign of the horns
        trie.insert(new int[]{129305, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 463))); // call me hand: dark skin tone
        trie.insert(new int[]{128073, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 859))); // backhand index pointing right: medium-dark skin tone
        trie.insert(new int[]{128405, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 661))); // middle finger: medium skin tone
        trie.insert(new int[]{9757, 127996}, new ParseResult(3, new SpriteCoordinates(2, 9, 1, 133))); // index pointing up: medium-light skin tone
        trie.insert(new int[]{128077, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 859))); // thumbs up: light skin tone
        trie.insert(new int[]{9994}, new ParseResult(1, new SpriteCoordinates(2, 9, 67, 67))); // raised fist
        trie.insert(new int[]{128074, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 661, 859))); // oncoming fist: dark skin tone
        trie.insert(new int[]{129308, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 331))); // right-facing fist: medium-dark skin tone
        trie.insert(new int[]{128588, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 661, 265))); // raising hands: medium skin tone
        trie.insert(new int[]{128080, 127996}, new ParseResult(4, new SpriteCoordinates(2, 9, 529, 859))); // open hands: medium-light skin tone
        trie.insert(new int[]{129309, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 265))); // handshake: light skin tone
        trie.insert(new int[]{129777, 127996, 8205, 129778, 127998}, new ParseResult(9, new SpriteCoordinates(2, 9, 199, 133))); // handshake: medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{129777, 127999, 8205, 129778, 127996}, new ParseResult(9, new SpriteCoordinates(2, 9, 199, 67))); // handshake: dark skin tone, medium-light skin tone
        trie.insert(new int[]{9997, 127996}, new ParseResult(3, new SpriteCoordinates(2, 9, 1, 1))); // writing hand: medium-light skin tone
        trie.insert(new int[]{129331, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 67))); // selfie: light skin tone
        trie.insert(new int[]{129470}, new ParseResult(2, new SpriteCoordinates(2, 9, 529, 67))); // mechanical arm
        trie.insert(new int[]{129462, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 529, 397))); // foot: medium skin tone
        trie.insert(new int[]{129467, 127996}, new ParseResult(4, new SpriteCoordinates(2, 9, 529, 133))); // ear with hearing aid: medium-light skin tone
        trie.insert(new int[]{129728}, new ParseResult(2, new SpriteCoordinates(2, 9, 265, 67))); // anatomical heart
        trie.insert(new int[]{128118, 127996}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 331))); // baby: medium-light skin tone
        trie.insert(new int[]{128102, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 463, 859))); // boy: light skin tone
        trie.insert(new int[]{129489}, new ParseResult(2, new SpriteCoordinates(2, 9, 331, 331))); // person
        trie.insert(new int[]{128113, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 661))); // person: dark skin tone, blond hair
        trie.insert(new int[]{129492, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 331))); // person: medium-dark skin tone, beard
        trie.insert(new int[]{129492, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 331))); // woman: medium skin tone, beard
        trie.insert(new int[]{129492, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 331))); // woman: medium skin tone, beard
        trie.insert(new int[]{128104, 127996, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 793))); // man: medium-light skin tone, curly hair
        trie.insert(new int[]{128104, 127995, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 859))); // man: light skin tone, bald
        trie.insert(new int[]{128105, 8205, 129456}, new ParseResult(5, new SpriteCoordinates(2, 9, 397, 727))); // woman: red hair
        trie.insert(new int[]{129489, 127999, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 199))); // person: dark skin tone, red hair
        trie.insert(new int[]{129489, 127998, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 9, 1, 397))); // person: medium-dark skin tone, curly hair
        trie.insert(new int[]{129489, 127997, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 397))); // person: medium skin tone, white hair
        trie.insert(new int[]{129489, 127996, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 9, 463, 133))); // person: medium-light skin tone, bald
        trie.insert(new int[]{128113, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 1, 727))); // man: light skin tone, blond hair
        trie.insert(new int[]{128113, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 1, 727))); // man: light skin tone, blond hair
        trie.insert(new int[]{128116}, new ParseResult(2, new SpriteCoordinates(2, 9, 727, 463))); // old man
        trie.insert(new int[]{128117, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 397))); // old woman: dark skin tone
        trie.insert(new int[]{128589, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 661, 199))); // man frowning: medium-dark skin tone
        trie.insert(new int[]{128589, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 661, 199))); // man frowning: medium-dark skin tone
        trie.insert(new int[]{128590, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 661, 67))); // person pouting: medium skin tone
        trie.insert(new int[]{128590, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 661, 133))); // woman pouting: medium-light skin tone
        trie.insert(new int[]{128590, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 661, 133))); // woman pouting: medium-light skin tone
        trie.insert(new int[]{128581, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 1, 661))); // man gesturing NO: light skin tone
        trie.insert(new int[]{128581, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 1, 661))); // man gesturing NO: light skin tone
        trie.insert(new int[]{128582}, new ParseResult(2, new SpriteCoordinates(2, 9, 661, 529))); // person gesturing OK
        trie.insert(new int[]{128582, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 661, 595))); // man gesturing OK: dark skin tone
        trie.insert(new int[]{128582, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 661, 595))); // man gesturing OK: dark skin tone
        trie.insert(new int[]{128129, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 67))); // person tipping hand: medium-dark skin tone
        trie.insert(new int[]{128129, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 727, 133))); // woman tipping hand: medium skin tone
        trie.insert(new int[]{128129, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 727, 133))); // woman tipping hand: medium skin tone
        trie.insert(new int[]{128587, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 661, 331))); // man raising hand: medium-light skin tone
        trie.insert(new int[]{128587, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 661, 331))); // man raising hand: medium-light skin tone
        trie.insert(new int[]{129487, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 463))); // deaf person: light skin tone
        trie.insert(new int[]{129487, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 133, 463))); // deaf woman
        trie.insert(new int[]{129487, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 9, 133, 463))); // deaf woman
        trie.insert(new int[]{128583, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 661, 397))); // person bowing: dark skin tone
        trie.insert(new int[]{128583, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 661, 463))); // woman bowing: medium-dark skin tone
        trie.insert(new int[]{128583, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 661, 463))); // woman bowing: medium-dark skin tone
        trie.insert(new int[]{129318, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 595, 199))); // man facepalming: medium skin tone
        trie.insert(new int[]{129318, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 595, 199))); // man facepalming: medium skin tone
        trie.insert(new int[]{129335, 127996}, new ParseResult(4, new SpriteCoordinates(2, 9, 463, 529))); // person shrugging: medium-light skin tone
        trie.insert(new int[]{129335, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 529, 529))); // woman shrugging: light skin tone
        trie.insert(new int[]{129335, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 529, 529))); // woman shrugging: light skin tone
        trie.insert(new int[]{128104, 8205, 9877, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 529, 793))); // man health worker
        trie.insert(new int[]{128104, 8205, 9877}, new ParseResult(4, new SpriteCoordinates(2, 9, 529, 793))); // man health worker
        trie.insert(new int[]{128105, 127999, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 595, 727))); // woman health worker: dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 9, 595, 727))); // woman health worker: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 463))); // man student: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 9, 463, 1))); // teacher: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 9, 67, 793))); // woman teacher: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 9, 199, 859))); // man judge: light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 199, 859))); // man judge: light skin tone
        trie.insert(new int[]{129489, 8205, 127806}, new ParseResult(5, new SpriteCoordinates(2, 9, 67, 463))); // farmer
        trie.insert(new int[]{128104, 127999, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 199))); // man farmer: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 9, 133, 397))); // cook: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 9, 793, 529))); // woman cook: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 9, 67, 859))); // man mechanic: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 9, 1, 463))); // factory worker: light skin tone
        trie.insert(new int[]{128105, 8205, 127981}, new ParseResult(5, new SpriteCoordinates(2, 9, 463, 793))); // woman factory worker
        trie.insert(new int[]{129489, 127999, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 331))); // office worker: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 9, 793, 331))); // woman office worker: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 595))); // man scientist: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 9, 463, 265))); // technologist: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 793))); // woman technologist: light skin tone
        trie.insert(new int[]{128104, 8205, 127908}, new ParseResult(5, new SpriteCoordinates(2, 9, 397, 859))); // man singer
        trie.insert(new int[]{128105, 127999, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 9, 727, 727))); // woman singer: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 397))); // man artist: medium-dark skin tone
    }

    public static void init8(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{129489, 127997, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 397))); // pilot: medium skin tone
        trie.insert(new int[]{129489, 127997, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 397))); // pilot: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 9, 793, 727))); // woman pilot: medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 793, 727))); // woman pilot: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 9, 331, 859))); // man astronaut: light skin tone
        trie.insert(new int[]{129489, 8205, 128658}, new ParseResult(5, new SpriteCoordinates(2, 9, 397, 67))); // firefighter
        trie.insert(new int[]{128104, 127999, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 133))); // man firefighter: dark skin tone
        trie.insert(new int[]{128110, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 727))); // police officer: medium-dark skin tone
        trie.insert(new int[]{128110, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 727))); // woman police officer: medium skin tone
        trie.insert(new int[]{128110, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 727))); // woman police officer: medium skin tone
        trie.insert(new int[]{128373, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 199, 661))); // man detective: medium-light skin tone
        trie.insert(new int[]{128373, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 199, 661))); // man detective: medium-light skin tone
        trie.insert(new int[]{128130, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 1))); // guard: light skin tone
        trie.insert(new int[]{128130, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 661, 661))); // woman guard
        trie.insert(new int[]{128130, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 9, 661, 661))); // woman guard
        trie.insert(new int[]{129399, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 529, 463))); // ninja: dark skin tone
        trie.insert(new int[]{128119, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 727, 265))); // man construction worker: medium-dark skin tone
        trie.insert(new int[]{128119, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 727, 265))); // man construction worker: medium-dark skin tone
        trie.insert(new int[]{129733, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 133, 199))); // person with crown: medium skin tone
        trie.insert(new int[]{128120, 127996}, new ParseResult(4, new SpriteCoordinates(2, 9, 727, 199))); // princess: medium-light skin tone
        trie.insert(new int[]{128115, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 727, 529))); // man wearing turban: light skin tone
        trie.insert(new int[]{128115, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 727, 529))); // man wearing turban: light skin tone
        trie.insert(new int[]{128114}, new ParseResult(2, new SpriteCoordinates(2, 9, 727, 595))); // person with skullcap
        trie.insert(new int[]{129493, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 133, 331))); // woman with headscarf: dark skin tone
        trie.insert(new int[]{129333, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 595, 1))); // man in tuxedo: medium-dark skin tone
        trie.insert(new int[]{129333, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 595, 1))); // man in tuxedo: medium-dark skin tone
        trie.insert(new int[]{128112, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 727))); // person with veil: medium skin tone
        trie.insert(new int[]{128112, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 133, 727))); // woman with veil: medium-light skin tone
        trie.insert(new int[]{128112, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 133, 727))); // woman with veil: medium-light skin tone
        trie.insert(new int[]{129731, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 199))); // pregnant man: light skin tone
        trie.insert(new int[]{129329}, new ParseResult(2, new SpriteCoordinates(2, 9, 595, 133))); // breast-feeding
        trie.insert(new int[]{128105, 127999, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 9, 793, 1))); // woman feeding baby: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 9, 67, 397))); // person feeding baby: medium-dark skin tone
        trie.insert(new int[]{127877, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 925, 529))); // Santa Claus: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127876}, new ParseResult(7, new SpriteCoordinates(2, 9, 463, 331))); // mx claus: medium-light skin tone
        trie.insert(new int[]{129464, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 529, 331))); // man superhero: light skin tone
        trie.insert(new int[]{129464, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 529, 331))); // man superhero: light skin tone
        trie.insert(new int[]{129465}, new ParseResult(2, new SpriteCoordinates(2, 9, 529, 199))); // supervillain
        trie.insert(new int[]{129465, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 529, 265))); // man supervillain: dark skin tone
        trie.insert(new int[]{129465, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 529, 265))); // man supervillain: dark skin tone
        trie.insert(new int[]{129497, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 331, 1))); // mage: medium-dark skin tone
        trie.insert(new int[]{129497, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 331, 67))); // woman mage: medium skin tone
        trie.insert(new int[]{129497, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 331, 67))); // woman mage: medium skin tone
        trie.insert(new int[]{129498, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 265))); // man fairy: medium-light skin tone
        trie.insert(new int[]{129498, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 265))); // man fairy: medium-light skin tone
        trie.insert(new int[]{129499, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 265))); // vampire: light skin tone
        trie.insert(new int[]{129499, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 9, 133, 265))); // woman vampire
        trie.insert(new int[]{129499, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 133, 265))); // woman vampire
        trie.insert(new int[]{129500, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 1, 265))); // merperson: dark skin tone
        trie.insert(new int[]{129500, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 67, 265))); // mermaid: medium-dark skin tone
        trie.insert(new int[]{129500, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 67, 265))); // mermaid: medium-dark skin tone
        trie.insert(new int[]{129501, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 199))); // man elf: medium skin tone
        trie.insert(new int[]{129501, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 199))); // man elf: medium skin tone
        trie.insert(new int[]{129502, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 265, 133))); // woman genie
        trie.insert(new int[]{129502, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 9, 265, 133))); // woman genie
        trie.insert(new int[]{128134, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 9, 463, 661))); // man getting massage
        trie.insert(new int[]{128134, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 463, 661))); // man getting massage
        trie.insert(new int[]{128134, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 529, 661))); // woman getting massage: dark skin tone
        trie.insert(new int[]{128134, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 529, 661))); // woman getting massage: dark skin tone
        trie.insert(new int[]{128135, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 397, 661))); // man getting haircut: medium-dark skin tone
        trie.insert(new int[]{128135, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 661))); // man getting haircut: medium-dark skin tone
        trie.insert(new int[]{128694, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 595))); // person walking: medium skin tone
        trie.insert(new int[]{128694, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 595))); // woman walking: medium-light skin tone
        trie.insert(new int[]{128694, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 595))); // woman walking: medium-light skin tone
        trie.insert(new int[]{128694, 127995, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 331, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 331, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 9, 331, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127995, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 9, 331, 595))); // woman walking facing right
        trie.insert(new int[]{129485}, new ParseResult(2, new SpriteCoordinates(2, 9, 463, 463))); // person standing
        trie.insert(new int[]{129485, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 529, 1))); // man standing: dark skin tone
        trie.insert(new int[]{129485, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 529, 1))); // man standing: dark skin tone
        trie.insert(new int[]{129486, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 265, 463))); // person kneeling: medium-dark skin tone
        trie.insert(new int[]{129486, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 331, 463))); // woman kneeling: medium skin tone
        trie.insert(new int[]{129486, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 331, 463))); // woman kneeling: medium skin tone
        trie.insert(new int[]{129486, 127996, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 9, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 9, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127996, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129489, 127995, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 9, 463, 397))); // person with white cane: light skin tone
        trie.insert(new int[]{128104, 8205, 129455}, new ParseResult(5, new SpriteCoordinates(2, 9, 595, 793))); // man with white cane
        trie.insert(new int[]{128104, 127999, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 859, 67))); // man with white cane facing right
        trie.insert(new int[]{128104, 127999, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 859, 67))); // man with white cane facing right
        trie.insert(new int[]{128105, 127998, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 793, 199))); // woman with white cane facing right
        trie.insert(new int[]{128105, 127998, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 793, 199))); // woman with white cane facing right
        trie.insert(new int[]{129489, 127997, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 331, 397))); // person in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127997, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 331, 397))); // person in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127996, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 859, 727))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127996, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 859, 727))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127995, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 265, 793))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127995, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 265, 793))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{129489, 8205, 129469, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 9, 397, 1))); // person in manual wheelchair facing right
        trie.insert(new int[]{129489, 8205, 129469, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 1))); // person in manual wheelchair facing right
        trie.insert(new int[]{128104, 127999, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 1))); // man in manual wheelchair: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 9, 793, 133))); // woman in manual wheelchair: medium-dark skin tone
        trie.insert(new int[]{127939, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 925, 265))); // person running: medium skin tone
        trie.insert(new int[]{127939, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 925, 331))); // woman running: medium-light skin tone
        trie.insert(new int[]{127939, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 925, 331))); // woman running: medium-light skin tone
        trie.insert(new int[]{127939, 127995, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 9, 925, 397))); // woman running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 9, 925, 397))); // woman running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 9, 925, 397))); // woman running facing right
        trie.insert(new int[]{127939, 127995, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 9, 925, 397))); // woman running facing right
        trie.insert(new int[]{128131}, new ParseResult(2, new SpriteCoordinates(2, 9, 595, 661))); // woman dancing
        trie.insert(new int[]{128378, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 133, 661))); // man dancing: dark skin tone
        trie.insert(new int[]{129494, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 331))); // person in steamy room: light skin tone
        trie.insert(new int[]{129494, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 1, 331))); // woman in steamy room
        trie.insert(new int[]{129494, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 9, 1, 331))); // woman in steamy room
        trie.insert(new int[]{129495, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 331, 199))); // person climbing: dark skin tone
        trie.insert(new int[]{129495, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 331, 265))); // woman climbing: medium-dark skin tone
        trie.insert(new int[]{129495, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 331, 265))); // woman climbing: medium-dark skin tone
        trie.insert(new int[]{127938, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 925, 463))); // snowboarder: light skin tone
        trie.insert(new int[]{127948, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 9, 793, 859))); // man golfing
        trie.insert(new int[]{127948, 65039, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 9, 793, 859))); // man golfing
        trie.insert(new int[]{127948, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 793, 859))); // man golfing
        trie.insert(new int[]{127948, 65039, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 9, 793, 859))); // man golfing
        trie.insert(new int[]{127948, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 859, 859))); // woman golfing: dark skin tone
        trie.insert(new int[]{127948, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 859, 859))); // woman golfing: dark skin tone
        trie.insert(new int[]{127940, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 925, 199))); // man surfing: medium-dark skin tone
        trie.insert(new int[]{127940, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 925, 199))); // man surfing: medium-dark skin tone
        trie.insert(new int[]{128675, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 595, 595))); // person rowing boat: medium skin tone
        trie.insert(new int[]{128675, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 661, 1))); // woman rowing boat: medium-light skin tone
        trie.insert(new int[]{128675, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 661, 1))); // woman rowing boat: medium-light skin tone
        trie.insert(new int[]{127946, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 925, 133))); // man swimming: light skin tone
        trie.insert(new int[]{127946, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 925, 133))); // man swimming: light skin tone
        trie.insert(new int[]{9977}, new ParseResult(1, new SpriteCoordinates(2, 9, 133, 1))); // person bouncing ball
        trie.insert(new int[]{9977, 65039}, new ParseResult(2, new SpriteCoordinates(2, 9, 133, 1))); // person bouncing ball
        trie.insert(new int[]{9977, 127999, 8205, 9794}, new ParseResult(5, new SpriteCoordinates(2, 9, 133, 67))); // man bouncing ball: dark skin tone
        trie.insert(new int[]{9977, 127999, 8205, 9794, 65039}, new ParseResult(6, new SpriteCoordinates(2, 9, 133, 67))); // man bouncing ball: dark skin tone
        trie.insert(new int[]{127947, 127998}, new ParseResult(4, new SpriteCoordinates(2, 9, 925, 1))); // person lifting weights: medium-dark skin tone
        trie.insert(new int[]{127947, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 925, 67))); // woman lifting weights: medium skin tone
        trie.insert(new int[]{127947, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 925, 67))); // woman lifting weights: medium skin tone
        trie.insert(new int[]{128692, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 529, 595))); // man biking: medium-light skin tone
        trie.insert(new int[]{128692, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 529, 595))); // man biking: medium-light skin tone
        trie.insert(new int[]{128693, 127995}, new ParseResult(4, new SpriteCoordinates(2, 9, 463, 595))); // person mountain biking: light skin tone
        trie.insert(new int[]{128693, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 9, 397, 595))); // woman mountain biking
        trie.insert(new int[]{128693, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 397, 595))); // woman mountain biking
        trie.insert(new int[]{129336, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 331, 529))); // person cartwheeling: dark skin tone
        trie.insert(new int[]{129336, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 397, 529))); // woman cartwheeling: medium-dark skin tone
        trie.insert(new int[]{129336, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 397, 529))); // woman cartwheeling: medium-dark skin tone
        trie.insert(new int[]{129341, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 9, 67, 529))); // man playing water polo
        trie.insert(new int[]{129341, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 529))); // man playing water polo
        trie.insert(new int[]{129341, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 133, 529))); // woman playing water polo: dark skin tone
        trie.insert(new int[]{129341, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 133, 529))); // woman playing water polo: dark skin tone
        trie.insert(new int[]{129342, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 1, 529))); // man playing handball: medium-dark skin tone
        trie.insert(new int[]{129342, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 1, 529))); // man playing handball: medium-dark skin tone
        trie.insert(new int[]{129337, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 199, 529))); // person juggling: medium skin tone
        trie.insert(new int[]{129337, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 265, 529))); // woman juggling: medium-light skin tone
        trie.insert(new int[]{129337, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 9, 265, 529))); // woman juggling: medium-light skin tone
        trie.insert(new int[]{129496, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 9, 331, 133))); // man in lotus position: light skin tone
        trie.insert(new int[]{129496, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 9, 331, 133))); // man in lotus position: light skin tone
        trie.insert(new int[]{128704}, new ParseResult(2, new SpriteCoordinates(2, 9, 133, 595))); // person taking bath
        trie.insert(new int[]{128716, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 67, 595))); // person in bed: dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 129309, 8205, 129489, 127999}, new ParseResult(12, new SpriteCoordinates(2, 9, 463, 199))); // people holding hands: medium-light skin tone, dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 129309, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 9, 397, 265))); // people holding hands: dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 129309, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 9, 1, 793))); // women holding hands: medium-light skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 9, 793, 265))); // women holding hands: medium-dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 9, 331, 793))); // woman and man holding hands: light skin tone, medium-light skin tone
        trie.insert(new int[]{128107, 127997}, new ParseResult(4, new SpriteCoordinates(2, 9, 331, 727))); // woman and man holding hands: medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 9, 661, 727))); // woman and man holding hands: dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 9, 1, 859))); // men holding hands: medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 9, 859, 331))); // men holding hands: medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128143, 127999}, new ParseResult(4, new SpriteCoordinates(2, 9, 331, 661))); // kiss: dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127998}, new ParseResult(14, new SpriteCoordinates(2, 9, 199, 397))); // kiss: person, person, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127998}, new ParseResult(15, new SpriteCoordinates(2, 9, 199, 397))); // kiss: person, person, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127995}, new ParseResult(14, new SpriteCoordinates(2, 9, 199, 793))); // kiss: woman, man, light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127995}, new ParseResult(15, new SpriteCoordinates(2, 9, 199, 793))); // kiss: woman, man, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 9, 793, 463))); // kiss: woman, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 9, 793, 463))); // kiss: woman, man, medium skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 9, 463, 727))); // kiss: woman, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 9, 463, 727))); // kiss: woman, man, dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 9, 859, 661))); // kiss: man, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 9, 859, 661))); // kiss: man, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 9, 859, 265))); // kiss: man, man, medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 9, 859, 265))); // kiss: man, man, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127998}, new ParseResult(15, new SpriteCoordinates(2, 9, 133, 793))); // kiss: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127998}, new ParseResult(14, new SpriteCoordinates(2, 9, 133, 793))); // kiss: woman, woman, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999}, new ParseResult(15, new SpriteCoordinates(2, 9, 793, 397))); // kiss: woman, woman, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128105, 127999}, new ParseResult(14, new SpriteCoordinates(2, 9, 793, 397))); // kiss: woman, woman, medium skin tone, dark skin tone
        trie.insert(new int[]{128145}, new ParseResult(2, new SpriteCoordinates(2, 9, 265, 661))); // couple with heart
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 129489, 127997}, new ParseResult(11, new SpriteCoordinates(2, 9, 463, 67))); // couple with heart: person, person, medium-light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 129489, 127997}, new ParseResult(12, new SpriteCoordinates(2, 9, 463, 67))); // couple with heart: person, person, medium-light skin tone, medium skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 9, 397, 133))); // couple with heart: person, person, dark skin tone, light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 129489, 127995}, new ParseResult(11, new SpriteCoordinates(2, 9, 397, 133))); // couple with heart: person, person, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128104, 127996}, new ParseResult(11, new SpriteCoordinates(2, 9, 793, 661))); // couple with heart: woman, man, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128104, 127996}, new ParseResult(12, new SpriteCoordinates(2, 9, 793, 661))); // couple with heart: woman, man, medium-light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 9, 793, 67))); // couple with heart: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 9, 793, 67))); // couple with heart: woman, man, medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 9, 133, 859))); // couple with heart: man, man, light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 9, 133, 859))); // couple with heart: man, man, light skin tone, medium skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 9, 859, 529))); // couple with heart: man, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 9, 859, 529))); // couple with heart: man, man, medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 9, 793, 793))); // couple with heart: man, man, dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 9, 793, 793))); // couple with heart: man, man, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128105, 127999}, new ParseResult(11, new SpriteCoordinates(2, 9, 793, 595))); // couple with heart: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128105, 127999}, new ParseResult(12, new SpriteCoordinates(2, 9, 793, 595))); // couple with heart: woman, woman, medium-light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128105, 127995}, new ParseResult(11, new SpriteCoordinates(2, 9, 529, 727))); // couple with heart: woman, woman, dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 9, 529, 727))); // couple with heart: woman, woman, dark skin tone, light skin tone
        trie.insert(new int[]{128104, 8205, 128104, 8205, 128103}, new ParseResult(8, new SpriteCoordinates(2, 9, 661, 793))); // family: man, man, girl
        trie.insert(new int[]{128104, 8205, 128103}, new ParseResult(5, new SpriteCoordinates(2, 9, 727, 793))); // family: man, girl
        trie.insert(new int[]{129730}, new ParseResult(2, new SpriteCoordinates(2, 9, 265, 1))); // people hugging
        trie.insert(new int[]{129306, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 463))); // raised back of hand: medium-dark skin tone
        trie.insert(new int[]{9995, 127997}, new ParseResult(3, new SpriteCoordinates(2, 10, 1, 67))); // raised hand: medium skin tone
        trie.insert(new int[]{129777, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 199, 133))); // rightwards hand: medium-light skin tone
        trie.insert(new int[]{129779, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 199, 1))); // palm down hand: light skin tone
        trie.insert(new int[]{129783}, new ParseResult(2, new SpriteCoordinates(2, 10, 133, 133))); // leftwards pushing hand
        trie.insert(new int[]{129784, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 133))); // rightwards pushing hand: dark skin tone
        trie.insert(new int[]{129292, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 1, 595))); // pinched fingers: medium-dark skin tone
        trie.insert(new int[]{9996, 127997}, new ParseResult(3, new SpriteCoordinates(2, 10, 67, 1))); // victory hand: medium skin tone
        trie.insert(new int[]{129776, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 199))); // hand with index finger and thumb crossed: medium-light skin tone
        trie.insert(new int[]{129304, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 529))); // sign of the horns: light skin tone
        trie.insert(new int[]{128072}, new ParseResult(2, new SpriteCoordinates(2, 10, 727, 859))); // backhand index pointing left
        trie.insert(new int[]{128073, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 661, 859))); // backhand index pointing right: dark skin tone
        trie.insert(new int[]{128405, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 661))); // middle finger: medium-dark skin tone
        trie.insert(new int[]{9757, 127997}, new ParseResult(3, new SpriteCoordinates(2, 10, 1, 133))); // index pointing up: medium skin tone
        trie.insert(new int[]{128077, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 859))); // thumbs up: medium-light skin tone
        trie.insert(new int[]{9994, 127995}, new ParseResult(3, new SpriteCoordinates(2, 10, 67, 67))); // raised fist: light skin tone
        trie.insert(new int[]{129307}, new ParseResult(2, new SpriteCoordinates(2, 10, 595, 397))); // left-facing fist
        trie.insert(new int[]{129308, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 331))); // right-facing fist: dark skin tone
        trie.insert(new int[]{128588, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 661, 265))); // raising hands: medium-dark skin tone
        trie.insert(new int[]{128080, 127997}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 859))); // open hands: medium skin tone
        trie.insert(new int[]{129309, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 265))); // handshake: medium-light skin tone
        trie.insert(new int[]{129777, 127996, 8205, 129778, 127999}, new ParseResult(9, new SpriteCoordinates(2, 10, 1, 199))); // handshake: medium-light skin tone, dark skin tone
        trie.insert(new int[]{129777, 127999, 8205, 129778, 127997}, new ParseResult(9, new SpriteCoordinates(2, 10, 199, 67))); // handshake: dark skin tone, medium skin tone
        trie.insert(new int[]{9997, 127997}, new ParseResult(3, new SpriteCoordinates(2, 10, 1, 1))); // writing hand: medium skin tone
        trie.insert(new int[]{129331, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 67))); // selfie: medium-light skin tone
        trie.insert(new int[]{129471}, new ParseResult(2, new SpriteCoordinates(2, 10, 529, 67))); // mechanical leg
        trie.insert(new int[]{129462, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 397))); // foot: medium-dark skin tone
        trie.insert(new int[]{129467, 127997}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 133))); // ear with hearing aid: medium skin tone
        trie.insert(new int[]{129729}, new ParseResult(2, new SpriteCoordinates(2, 10, 265, 1))); // lungs
        trie.insert(new int[]{128118, 127997}, new ParseResult(4, new SpriteCoordinates(2, 10, 727, 331))); // baby: medium skin tone
        trie.insert(new int[]{128102, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 463, 859))); // boy: medium-light skin tone
        trie.insert(new int[]{129489, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 463, 133))); // person: light skin tone
        trie.insert(new int[]{128104}, new ParseResult(2, new SpriteCoordinates(2, 10, 595, 793))); // man
        trie.insert(new int[]{129492, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 331))); // person: dark skin tone, beard
        trie.insert(new int[]{129492, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 133, 331))); // woman: medium-dark skin tone, beard
        trie.insert(new int[]{129492, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 133, 331))); // woman: medium-dark skin tone, beard
        trie.insert(new int[]{128104, 127997, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 529))); // man: medium skin tone, curly hair
        trie.insert(new int[]{128104, 127996, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 793))); // man: medium-light skin tone, bald
        trie.insert(new int[]{128105, 127995, 8205, 129456}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 793))); // woman: light skin tone, red hair
        trie.insert(new int[]{128105, 8205, 129457}, new ParseResult(5, new SpriteCoordinates(2, 10, 463, 727))); // woman: curly hair
        trie.insert(new int[]{129489, 127999, 8205, 129457}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 331))); // person: dark skin tone, curly hair
        trie.insert(new int[]{129489, 127998, 8205, 129459}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 331))); // person: medium-dark skin tone, white hair
        trie.insert(new int[]{129489, 127997, 8205, 129458}, new ParseResult(7, new SpriteCoordinates(2, 10, 133, 397))); // person: medium skin tone, bald
        trie.insert(new int[]{128113, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 727, 595))); // man: medium-light skin tone, blond hair
        trie.insert(new int[]{128113, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 727, 595))); // man: medium-light skin tone, blond hair
        trie.insert(new int[]{128116, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 727, 397))); // old man: light skin tone
        trie.insert(new int[]{128589}, new ParseResult(2, new SpriteCoordinates(2, 10, 661, 133))); // person frowning
        trie.insert(new int[]{128589, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 661, 199))); // man frowning: dark skin tone
        trie.insert(new int[]{128589, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 661, 199))); // man frowning: dark skin tone
        trie.insert(new int[]{128590, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 661, 1))); // person pouting: medium-dark skin tone
        trie.insert(new int[]{128590, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 661, 67))); // woman pouting: medium skin tone
        trie.insert(new int[]{128590, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 661, 67))); // woman pouting: medium skin tone
        trie.insert(new int[]{128581, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 1, 661))); // man gesturing NO: medium-light skin tone
        trie.insert(new int[]{128581, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 1, 661))); // man gesturing NO: medium-light skin tone
        trie.insert(new int[]{128582, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 661, 595))); // person gesturing OK: light skin tone
        trie.insert(new int[]{128582, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 10, 661, 529))); // woman gesturing OK
        trie.insert(new int[]{128582, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 661, 529))); // woman gesturing OK
        trie.insert(new int[]{128129, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 727, 1))); // person tipping hand: dark skin tone
        trie.insert(new int[]{128129, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 727, 67))); // woman tipping hand: medium-dark skin tone
        trie.insert(new int[]{128129, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 727, 67))); // woman tipping hand: medium-dark skin tone
        trie.insert(new int[]{128587, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 661, 331))); // man raising hand: medium skin tone
        trie.insert(new int[]{128587, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 661, 331))); // man raising hand: medium skin tone
        trie.insert(new int[]{129487, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 133, 463))); // deaf person: medium-light skin tone
        trie.insert(new int[]{129487, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 199, 463))); // deaf woman: light skin tone
        trie.insert(new int[]{129487, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 199, 463))); // deaf woman: light skin tone
        trie.insert(new int[]{128583, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 661, 397))); // man bowing
        trie.insert(new int[]{128583, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 10, 661, 397))); // man bowing
        trie.insert(new int[]{128583, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 661, 463))); // woman bowing: dark skin tone
        trie.insert(new int[]{128583, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 661, 463))); // woman bowing: dark skin tone
        trie.insert(new int[]{129318, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 595, 199))); // man facepalming: medium-dark skin tone
        trie.insert(new int[]{129318, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 595, 199))); // man facepalming: medium-dark skin tone
        trie.insert(new int[]{129335, 127997}, new ParseResult(4, new SpriteCoordinates(2, 10, 397, 529))); // person shrugging: medium skin tone
        trie.insert(new int[]{129335, 127996, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 529))); // woman shrugging: medium-light skin tone
        trie.insert(new int[]{129335, 127996, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 463, 529))); // woman shrugging: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 9877}, new ParseResult(6, new SpriteCoordinates(2, 10, 199, 859))); // man health worker: light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 9877, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 199, 859))); // man health worker: light skin tone
        trie.insert(new int[]{129489, 8205, 127891}, new ParseResult(5, new SpriteCoordinates(2, 10, 67, 463))); // student
        trie.insert(new int[]{128104, 127999, 8205, 127891}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 199))); // man student: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 10, 1, 397))); // teacher: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 127979}, new ParseResult(7, new SpriteCoordinates(2, 10, 793, 727))); // woman teacher: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 9878, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 727))); // man judge: medium-light skin tone
        trie.insert(new int[]{128104, 127996, 8205, 9878}, new ParseResult(6, new SpriteCoordinates(2, 10, 859, 727))); // man judge: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 127806}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 397))); // farmer: light skin tone
        trie.insert(new int[]{128105, 8205, 127806}, new ParseResult(5, new SpriteCoordinates(2, 10, 529, 793))); // woman farmer
        trie.insert(new int[]{129489, 127999, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 133))); // cook: dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 127859}, new ParseResult(7, new SpriteCoordinates(2, 10, 793, 397))); // woman cook: medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 128295}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 595))); // man mechanic: medium skin tone
        trie.insert(new int[]{129489, 127996, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 67))); // factory worker: medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 127981}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 793))); // woman factory worker: light skin tone
        trie.insert(new int[]{128104, 8205, 128188}, new ParseResult(5, new SpriteCoordinates(2, 10, 727, 793))); // man office worker
        trie.insert(new int[]{128105, 127999, 8205, 128188}, new ParseResult(7, new SpriteCoordinates(2, 10, 793, 133))); // woman office worker: dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 128300}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 331))); // man scientist: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 10, 265, 397))); // technologist: medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 128187}, new ParseResult(7, new SpriteCoordinates(2, 10, 133, 793))); // woman technologist: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 127908}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 859))); // man singer: light skin tone
        trie.insert(new int[]{129489, 8205, 127912}, new ParseResult(5, new SpriteCoordinates(2, 10, 1, 463))); // artist
        trie.insert(new int[]{128104, 127999, 8205, 127912}, new ParseResult(7, new SpriteCoordinates(2, 10, 859, 133))); // man artist: dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 199))); // pilot: medium-dark skin tone
        trie.insert(new int[]{129489, 127998, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 10, 397, 199))); // pilot: medium-dark skin tone
        trie.insert(new int[]{128105, 127997, 8205, 9992, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 793, 595))); // woman pilot: medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 9992}, new ParseResult(6, new SpriteCoordinates(2, 10, 793, 595))); // woman pilot: medium skin tone
        trie.insert(new int[]{128104, 127996, 8205, 128640}, new ParseResult(7, new SpriteCoordinates(2, 10, 67, 859))); // man astronaut: medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 128658}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 331))); // firefighter: light skin tone
        trie.insert(new int[]{128105, 8205, 128658}, new ParseResult(5, new SpriteCoordinates(2, 10, 595, 727))); // woman firefighter
        trie.insert(new int[]{128110, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 727))); // police officer: dark skin tone
        trie.insert(new int[]{128110, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 133, 727))); // woman police officer: medium-dark skin tone
        trie.insert(new int[]{128110, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 133, 727))); // woman police officer: medium-dark skin tone
        trie.insert(new int[]{128373, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 133, 661))); // man detective: medium skin tone
        trie.insert(new int[]{128373, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 133, 661))); // man detective: medium skin tone
        trie.insert(new int[]{128130, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 661))); // guard: medium-light skin tone
        trie.insert(new int[]{128130, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 661, 661))); // woman guard: light skin tone
        trie.insert(new int[]{128130, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 661, 661))); // woman guard: light skin tone
        trie.insert(new int[]{128119}, new ParseResult(2, new SpriteCoordinates(2, 10, 727, 199))); // construction worker
        trie.insert(new int[]{128119, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 727, 265))); // man construction worker: dark skin tone
        trie.insert(new int[]{128119, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 727, 265))); // man construction worker: dark skin tone
        trie.insert(new int[]{129733, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 133, 199))); // person with crown: medium-dark skin tone
        trie.insert(new int[]{128120, 127997}, new ParseResult(4, new SpriteCoordinates(2, 10, 727, 133))); // princess: medium skin tone
        trie.insert(new int[]{128115, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 727, 463))); // man wearing turban: medium-light skin tone
        trie.insert(new int[]{128115, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 727, 463))); // man wearing turban: medium-light skin tone
        trie.insert(new int[]{128114, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 727, 529))); // person with skullcap: light skin tone
        trie.insert(new int[]{129333}, new ParseResult(2, new SpriteCoordinates(2, 10, 529, 529))); // person in tuxedo
        trie.insert(new int[]{129333, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 595, 1))); // man in tuxedo: dark skin tone
        trie.insert(new int[]{129333, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 595, 1))); // man in tuxedo: dark skin tone
        trie.insert(new int[]{128112, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 727, 661))); // person with veil: medium-dark skin tone
        trie.insert(new int[]{128112, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 1, 727))); // woman with veil: medium skin tone
        trie.insert(new int[]{128112, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 1, 727))); // woman with veil: medium skin tone
        trie.insert(new int[]{129731, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 199, 199))); // pregnant man: medium-light skin tone
        trie.insert(new int[]{129329, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 595, 133))); // breast-feeding: light skin tone
        trie.insert(new int[]{128104, 8205, 127868}, new ParseResult(5, new SpriteCoordinates(2, 10, 397, 859))); // man feeding baby
        trie.insert(new int[]{129489, 127999, 8205, 127868}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 67))); // person feeding baby: dark skin tone
        trie.insert(new int[]{127877, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 925, 529))); // Santa Claus: medium-dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 127876}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 397))); // mx claus: medium skin tone
        trie.insert(new int[]{129464, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 529, 331))); // man superhero: medium-light skin tone
        trie.insert(new int[]{129464, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 529, 331))); // man superhero: medium-light skin tone
        trie.insert(new int[]{129465, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 265))); // supervillain: light skin tone
        trie.insert(new int[]{129465, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 199))); // woman supervillain
        trie.insert(new int[]{129465, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 529, 199))); // woman supervillain
        trie.insert(new int[]{129497, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 265, 265))); // mage: dark skin tone
        trie.insert(new int[]{129497, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 331, 1))); // woman mage: medium-dark skin tone
        trie.insert(new int[]{129497, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 1))); // woman mage: medium-dark skin tone
        trie.insert(new int[]{129498, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 199, 265))); // man fairy: medium skin tone
        trie.insert(new int[]{129498, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 199, 265))); // man fairy: medium skin tone
        trie.insert(new int[]{129499, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 265))); // vampire: medium-light skin tone
        trie.insert(new int[]{129499, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 133, 265))); // woman vampire: light skin tone
        trie.insert(new int[]{129499, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 133, 265))); // woman vampire: light skin tone
        trie.insert(new int[]{129500, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 265, 199))); // merman
        trie.insert(new int[]{129500, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 10, 265, 199))); // merman
        trie.insert(new int[]{129500, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 1, 265))); // mermaid: dark skin tone
        trie.insert(new int[]{129500, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 1, 265))); // mermaid: dark skin tone
        trie.insert(new int[]{129501, 127998, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 265, 133))); // man elf: medium-dark skin tone
        trie.insert(new int[]{129501, 127998, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 265, 133))); // man elf: medium-dark skin tone
        trie.insert(new int[]{129503}, new ParseResult(2, new SpriteCoordinates(2, 10, 265, 67))); // zombie
        trie.insert(new int[]{128134, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 661))); // man getting massage: light skin tone
        trie.insert(new int[]{128134, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 463, 661))); // man getting massage: light skin tone
        trie.insert(new int[]{128135}, new ParseResult(2, new SpriteCoordinates(2, 10, 331, 661))); // person getting haircut
        trie.insert(new int[]{128135, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 397, 661))); // man getting haircut: dark skin tone
        trie.insert(new int[]{128135, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 661))); // man getting haircut: dark skin tone
        trie.insert(new int[]{128694, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 133, 595))); // person walking: medium-dark skin tone
        trie.insert(new int[]{128694, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 199, 595))); // woman walking: medium skin tone
        trie.insert(new int[]{128694, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 199, 595))); // woman walking: medium skin tone
        trie.insert(new int[]{128694, 127996, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 10, 265, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 10, 265, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 265, 595))); // woman walking facing right
        trie.insert(new int[]{128694, 127996, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 265, 595))); // woman walking facing right
        trie.insert(new int[]{129485, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 1))); // person standing: light skin tone
        trie.insert(new int[]{129485, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 463, 463))); // woman standing
        trie.insert(new int[]{129485, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 10, 463, 463))); // woman standing
        trie.insert(new int[]{129486, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 265, 463))); // person kneeling: dark skin tone
        trie.insert(new int[]{129486, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 463))); // woman kneeling: medium-dark skin tone
        trie.insert(new int[]{129486, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 331, 463))); // woman kneeling: medium-dark skin tone
        trie.insert(new int[]{129486, 127997, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 10, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 10, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129486, 127997, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 397, 463))); // woman kneeling facing right
        trie.insert(new int[]{129489, 127996, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 1))); // person with white cane: medium-light skin tone
        trie.insert(new int[]{128104, 127995, 8205, 129455}, new ParseResult(7, new SpriteCoordinates(2, 10, 265, 859))); // man with white cane: light skin tone
        trie.insert(new int[]{128105, 8205, 129455}, new ParseResult(5, new SpriteCoordinates(2, 10, 529, 727))); // woman with white cane
        trie.insert(new int[]{128105, 127999, 8205, 129455, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 793, 67))); // woman with white cane facing right
        trie.insert(new int[]{128105, 127999, 8205, 129455, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 793, 67))); // woman with white cane facing right
        trie.insert(new int[]{129489, 127998, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 397, 265))); // person in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127998, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 397, 265))); // person in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127997, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 859, 463))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128104, 127997, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 859, 463))); // man in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127996, 8205, 129468, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 67, 793))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{128105, 127996, 8205, 129468, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 67, 793))); // woman in motorized wheelchair facing right
        trie.insert(new int[]{129489, 127995, 8205, 129469, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 463, 265))); // person in manual wheelchair facing right
        trie.insert(new int[]{129489, 127995, 8205, 129469, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 463, 265))); // person in manual wheelchair facing right
        trie.insert(new int[]{128104, 8205, 129469, 8205, 10145}, new ParseResult(7, new SpriteCoordinates(2, 10, 661, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128104, 8205, 129469, 8205, 10145, 65039}, new ParseResult(8, new SpriteCoordinates(2, 10, 661, 793))); // man in manual wheelchair facing right
        trie.insert(new int[]{128105, 127999, 8205, 129469}, new ParseResult(7, new SpriteCoordinates(2, 10, 793, 1))); // woman in manual wheelchair: dark skin tone
        trie.insert(new int[]{127939, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 925, 265))); // person running: medium-dark skin tone
        trie.insert(new int[]{127939, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 925, 331))); // woman running: medium skin tone
        trie.insert(new int[]{127939, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 925, 331))); // woman running: medium skin tone
        trie.insert(new int[]{127939, 127996, 8205, 9792, 65039, 8205, 10145, 65039}, new ParseResult(10, new SpriteCoordinates(2, 10, 925, 397))); // woman running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9792, 8205, 10145, 65039}, new ParseResult(9, new SpriteCoordinates(2, 10, 925, 397))); // woman running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9792, 8205, 10145}, new ParseResult(8, new SpriteCoordinates(2, 10, 925, 397))); // woman running facing right
        trie.insert(new int[]{127939, 127996, 8205, 9792, 65039, 8205, 10145}, new ParseResult(9, new SpriteCoordinates(2, 10, 925, 397))); // woman running facing right
        trie.insert(new int[]{128131, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 661))); // woman dancing: light skin tone
        trie.insert(new int[]{128372, 65039}, new ParseResult(3, new SpriteCoordinates(2, 10, 199, 661))); // person in suit levitating
        trie.insert(new int[]{128372}, new ParseResult(2, new SpriteCoordinates(2, 10, 199, 661))); // person in suit levitating
        trie.insert(new int[]{129494, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 331, 265))); // person in steamy room: medium-light skin tone
        trie.insert(new int[]{129494, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 1, 331))); // woman in steamy room: light skin tone
        trie.insert(new int[]{129494, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 1, 331))); // woman in steamy room: light skin tone
        trie.insert(new int[]{129495, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 331, 133))); // man climbing
        trie.insert(new int[]{129495, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 10, 331, 133))); // man climbing
        trie.insert(new int[]{129495, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 331, 199))); // woman climbing: dark skin tone
        trie.insert(new int[]{129495, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 199))); // woman climbing: dark skin tone
        trie.insert(new int[]{127938, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 925, 463))); // snowboarder: medium-light skin tone
        trie.insert(new int[]{127948, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 793, 859))); // man golfing: light skin tone
        trie.insert(new int[]{127948, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 793, 859))); // man golfing: light skin tone
        trie.insert(new int[]{127940}, new ParseResult(2, new SpriteCoordinates(2, 10, 925, 133))); // person surfing
        trie.insert(new int[]{127940, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 925, 199))); // man surfing: dark skin tone
        trie.insert(new int[]{127940, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 925, 199))); // man surfing: dark skin tone
        trie.insert(new int[]{128675, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 529, 595))); // person rowing boat: medium-dark skin tone
        trie.insert(new int[]{128675, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 595, 595))); // woman rowing boat: medium skin tone
        trie.insert(new int[]{128675, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 595, 595))); // woman rowing boat: medium skin tone
        trie.insert(new int[]{127946, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 925, 67))); // man swimming: medium-light skin tone
        trie.insert(new int[]{127946, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 925, 67))); // man swimming: medium-light skin tone
        trie.insert(new int[]{9977, 127995}, new ParseResult(3, new SpriteCoordinates(2, 10, 133, 67))); // person bouncing ball: light skin tone
        trie.insert(new int[]{9977, 8205, 9792, 65039}, new ParseResult(4, new SpriteCoordinates(2, 10, 133, 1))); // woman bouncing ball
        trie.insert(new int[]{9977, 65039, 8205, 9792, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 133, 1))); // woman bouncing ball
        trie.insert(new int[]{9977, 65039, 8205, 9792}, new ParseResult(4, new SpriteCoordinates(2, 10, 133, 1))); // woman bouncing ball
        trie.insert(new int[]{9977, 8205, 9792}, new ParseResult(3, new SpriteCoordinates(2, 10, 133, 1))); // woman bouncing ball
        trie.insert(new int[]{127947, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 859, 859))); // person lifting weights: dark skin tone
        trie.insert(new int[]{127947, 127998, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 925, 1))); // woman lifting weights: medium-dark skin tone
        trie.insert(new int[]{127947, 127998, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 925, 1))); // woman lifting weights: medium-dark skin tone
        trie.insert(new int[]{128692, 127997, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 463, 595))); // man biking: medium skin tone
        trie.insert(new int[]{128692, 127997, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 463, 595))); // man biking: medium skin tone
        trie.insert(new int[]{128693, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 331, 595))); // person mountain biking: medium-light skin tone
        trie.insert(new int[]{128693, 127995, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 397, 595))); // woman mountain biking: light skin tone
        trie.insert(new int[]{128693, 127995, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 595))); // woman mountain biking: light skin tone
        trie.insert(new int[]{129336, 8205, 9794, 65039}, new ParseResult(5, new SpriteCoordinates(2, 10, 265, 529))); // man cartwheeling
        trie.insert(new int[]{129336, 8205, 9794}, new ParseResult(4, new SpriteCoordinates(2, 10, 265, 529))); // man cartwheeling
        trie.insert(new int[]{129336, 127999, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 529))); // woman cartwheeling: dark skin tone
        trie.insert(new int[]{129336, 127999, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 331, 529))); // woman cartwheeling: dark skin tone
        trie.insert(new int[]{129341, 127995, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 67, 529))); // man playing water polo: light skin tone
        trie.insert(new int[]{129341, 127995, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 67, 529))); // man playing water polo: light skin tone
        trie.insert(new int[]{129342}, new ParseResult(2, new SpriteCoordinates(2, 10, 529, 463))); // person playing handball
        trie.insert(new int[]{129342, 127999, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 1, 529))); // man playing handball: dark skin tone
        trie.insert(new int[]{129342, 127999, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 1, 529))); // man playing handball: dark skin tone
        trie.insert(new int[]{129337, 127998}, new ParseResult(4, new SpriteCoordinates(2, 10, 133, 529))); // person juggling: medium-dark skin tone
        trie.insert(new int[]{129337, 127997, 8205, 9792}, new ParseResult(6, new SpriteCoordinates(2, 10, 199, 529))); // woman juggling: medium skin tone
        trie.insert(new int[]{129337, 127997, 8205, 9792, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 199, 529))); // woman juggling: medium skin tone
        trie.insert(new int[]{129496, 127996, 8205, 9794, 65039}, new ParseResult(7, new SpriteCoordinates(2, 10, 331, 67))); // man in lotus position: medium-light skin tone
        trie.insert(new int[]{129496, 127996, 8205, 9794}, new ParseResult(6, new SpriteCoordinates(2, 10, 331, 67))); // man in lotus position: medium-light skin tone
        trie.insert(new int[]{128704, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 67, 595))); // person taking bath: light skin tone
        trie.insert(new int[]{129489, 8205, 129309, 8205, 129489}, new ParseResult(8, new SpriteCoordinates(2, 10, 199, 331))); // people holding hands
        trie.insert(new int[]{129489, 127997, 8205, 129309, 8205, 129489, 127995}, new ParseResult(12, new SpriteCoordinates(2, 10, 199, 397))); // people holding hands: medium skin tone, light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 129309, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 10, 397, 1))); // people holding hands: dark skin tone, medium-light skin tone
        trie.insert(new int[]{128109, 127996}, new ParseResult(4, new SpriteCoordinates(2, 10, 199, 727))); // women holding hands: medium-light skin tone
    }

    public static void init9(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{128105, 127998, 8205, 129309, 8205, 128105, 127997}, new ParseResult(12, new SpriteCoordinates(2, 10, 793, 331))); // women holding hands: medium-dark skin tone, medium skin tone
        trie.insert(new int[]{128105, 127995, 8205, 129309, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 10, 397, 793))); // woman and man holding hands: light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 129309, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 10, 793, 661))); // woman and man holding hands: medium skin tone, medium-dark skin tone
        trie.insert(new int[]{128107, 127999}, new ParseResult(4, new SpriteCoordinates(2, 10, 265, 727))); // woman and man holding hands: dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 129309, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 10, 1, 859))); // men holding hands: medium-light skin tone, dark skin tone
        trie.insert(new int[]{128104, 127999, 8205, 129309, 8205, 128104, 127995}, new ParseResult(12, new SpriteCoordinates(2, 10, 859, 67))); // men holding hands: dark skin tone, light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127996}, new ParseResult(15, new SpriteCoordinates(2, 10, 463, 199))); // kiss: person, person, light skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127995, 8205, 10084, 8205, 128139, 8205, 129489, 127996}, new ParseResult(14, new SpriteCoordinates(2, 10, 463, 199))); // kiss: person, person, light skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 8205, 128139, 8205, 129489, 127999}, new ParseResult(14, new SpriteCoordinates(2, 10, 67, 397))); // kiss: person, person, medium skin tone, dark skin tone
        trie.insert(new int[]{129489, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 129489, 127999}, new ParseResult(15, new SpriteCoordinates(2, 10, 67, 397))); // kiss: person, person, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127996}, new ParseResult(15, new SpriteCoordinates(2, 10, 265, 793))); // kiss: woman, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128104, 127996}, new ParseResult(14, new SpriteCoordinates(2, 10, 265, 793))); // kiss: woman, man, light skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128139, 8205, 128104, 127997}, new ParseResult(14, new SpriteCoordinates(2, 10, 793, 463))); // kiss: woman, man, medium skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127997}, new ParseResult(15, new SpriteCoordinates(2, 10, 793, 463))); // kiss: woman, man, medium skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 10, 661, 727))); // kiss: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 10, 661, 727))); // kiss: woman, man, dark skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127998}, new ParseResult(15, new SpriteCoordinates(2, 10, 859, 661))); // kiss: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127996, 8205, 10084, 8205, 128139, 8205, 128104, 127998}, new ParseResult(14, new SpriteCoordinates(2, 10, 859, 661))); // kiss: man, man, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128104, 127999}, new ParseResult(15, new SpriteCoordinates(2, 10, 859, 265))); // kiss: man, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128104, 127998, 8205, 10084, 8205, 128139, 8205, 128104, 127999}, new ParseResult(14, new SpriteCoordinates(2, 10, 859, 265))); // kiss: man, man, medium-dark skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 8205, 128139, 8205, 128105, 127999}, new ParseResult(14, new SpriteCoordinates(2, 10, 199, 793))); // kiss: woman, woman, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127995, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127999}, new ParseResult(15, new SpriteCoordinates(2, 10, 199, 793))); // kiss: woman, woman, light skin tone, dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128139, 8205, 128105, 127995}, new ParseResult(15, new SpriteCoordinates(2, 10, 793, 199))); // kiss: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128139, 8205, 128105, 127995}, new ParseResult(14, new SpriteCoordinates(2, 10, 793, 199))); // kiss: woman, woman, medium-dark skin tone, light skin tone
        trie.insert(new int[]{128145, 127995}, new ParseResult(4, new SpriteCoordinates(2, 10, 265, 661))); // couple with heart: light skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 8205, 129489, 127998}, new ParseResult(11, new SpriteCoordinates(2, 10, 397, 397))); // couple with heart: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127996, 8205, 10084, 65039, 8205, 129489, 127998}, new ParseResult(12, new SpriteCoordinates(2, 10, 397, 397))); // couple with heart: person, person, medium-light skin tone, medium-dark skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 8205, 129489, 127996}, new ParseResult(11, new SpriteCoordinates(2, 10, 265, 331))); // couple with heart: person, person, dark skin tone, medium-light skin tone
        trie.insert(new int[]{129489, 127999, 8205, 10084, 65039, 8205, 129489, 127996}, new ParseResult(12, new SpriteCoordinates(2, 10, 265, 331))); // couple with heart: person, person, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 65039, 8205, 128104, 127997}, new ParseResult(12, new SpriteCoordinates(2, 10, 1, 793))); // couple with heart: woman, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127996, 8205, 10084, 8205, 128104, 127997}, new ParseResult(11, new SpriteCoordinates(2, 10, 1, 793))); // couple with heart: woman, man, medium-light skin tone, medium skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 10, 793, 265))); // couple with heart: woman, man, medium-dark skin tone
        trie.insert(new int[]{128105, 127998, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 10, 793, 265))); // couple with heart: woman, man, medium-dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 8205, 128104, 127998}, new ParseResult(11, new SpriteCoordinates(2, 10, 133, 859))); // couple with heart: man, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127995, 8205, 10084, 65039, 8205, 128104, 127998}, new ParseResult(12, new SpriteCoordinates(2, 10, 133, 859))); // couple with heart: man, man, light skin tone, medium-dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 65039, 8205, 128104, 127999}, new ParseResult(12, new SpriteCoordinates(2, 10, 859, 397))); // couple with heart: man, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128104, 127997, 8205, 10084, 8205, 128104, 127999}, new ParseResult(11, new SpriteCoordinates(2, 10, 859, 397))); // couple with heart: man, man, medium skin tone, dark skin tone
        trie.insert(new int[]{128105, 8205, 10084, 8205, 128105}, new ParseResult(7, new SpriteCoordinates(2, 10, 397, 727))); // couple with heart: woman, woman
        trie.insert(new int[]{128105, 8205, 10084, 65039, 8205, 128105}, new ParseResult(8, new SpriteCoordinates(2, 10, 397, 727))); // couple with heart: woman, woman
        trie.insert(new int[]{128105, 127997, 8205, 10084, 65039, 8205, 128105, 127995}, new ParseResult(12, new SpriteCoordinates(2, 10, 793, 529))); // couple with heart: woman, woman, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127997, 8205, 10084, 8205, 128105, 127995}, new ParseResult(11, new SpriteCoordinates(2, 10, 793, 529))); // couple with heart: woman, woman, medium skin tone, light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 65039, 8205, 128105, 127996}, new ParseResult(12, new SpriteCoordinates(2, 10, 727, 727))); // couple with heart: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128105, 127999, 8205, 10084, 8205, 128105, 127996}, new ParseResult(11, new SpriteCoordinates(2, 10, 727, 727))); // couple with heart: woman, woman, dark skin tone, medium-light skin tone
        trie.insert(new int[]{128104, 8205, 128104, 8205, 128103, 8205, 128102}, new ParseResult(11, new SpriteCoordinates(2, 10, 793, 793))); // family: man, man, girl, boy
        trie.insert(new int[]{128104, 8205, 128103, 8205, 128102}, new ParseResult(8, new SpriteCoordinates(2, 10, 859, 1))); // family: man, girl, boy
        trie.insert(new int[]{128106}, new ParseResult(2, new SpriteCoordinates(2, 10, 331, 727))); // family
        trie.insert(new int[]{128053}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 529))); // monkey face
        trie.insert(new int[]{128018}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 661))); // monkey
        trie.insert(new int[]{129421}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 397))); // gorilla
        trie.insert(new int[]{129447}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 265))); // orangutan
        trie.insert(new int[]{128054}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 529))); // dog face
        trie.insert(new int[]{128021}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 661))); // dog
        trie.insert(new int[]{129454}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 67))); // guide dog
        trie.insert(new int[]{128021, 8205, 129466}, new ParseResult(5, new SpriteCoordinates(3, 0, 67, 661))); // service dog
        trie.insert(new int[]{128041}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 463))); // poodle
        trie.insert(new int[]{128058}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 463))); // wolf
        trie.insert(new int[]{129418}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 1))); // fox
        trie.insert(new int[]{129437}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 331))); // raccoon
        trie.insert(new int[]{128049}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 529))); // cat face
        trie.insert(new int[]{128008}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 199))); // cat
        trie.insert(new int[]{128008, 8205, 11035}, new ParseResult(4, new SpriteCoordinates(3, 0, 727, 265))); // black cat
        trie.insert(new int[]{129409}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 463))); // lion
        trie.insert(new int[]{128047}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 67))); // tiger face
        trie.insert(new int[]{128005}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 463))); // tiger
        trie.insert(new int[]{128006}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 397))); // leopard
        trie.insert(new int[]{128052}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 529))); // horse face
        trie.insert(new int[]{129742}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 67))); // moose
        trie.insert(new int[]{129743}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 1))); // donkey
        trie.insert(new int[]{128014}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 661))); // horse
        trie.insert(new int[]{129412}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 397))); // unicorn
        trie.insert(new int[]{129427}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 397))); // zebra
        trie.insert(new int[]{129420}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 397))); // deer
        trie.insert(new int[]{129452}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 199))); // bison
        trie.insert(new int[]{128046}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 133))); // cow face
        trie.insert(new int[]{128002}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 661))); // ox
        trie.insert(new int[]{128003}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 595))); // water buffalo
        trie.insert(new int[]{128004}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 529))); // cow
        trie.insert(new int[]{128055}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 529))); // pig face
        trie.insert(new int[]{128022}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 595))); // pig
        trie.insert(new int[]{128023}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 529))); // boar
        trie.insert(new int[]{128061}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 199))); // pig nose
        trie.insert(new int[]{128015}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 661))); // ram
        trie.insert(new int[]{128017}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 661))); // ewe
        trie.insert(new int[]{128016}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 661))); // goat
        trie.insert(new int[]{128042}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 397))); // camel
        trie.insert(new int[]{128043}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 331))); // two-hump camel
        trie.insert(new int[]{129433}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 1))); // llama
        trie.insert(new int[]{129426}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 397))); // giraffe
        trie.insert(new int[]{128024}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 463))); // elephant
        trie.insert(new int[]{129443}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 133))); // mammoth
        trie.insert(new int[]{129423}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 397))); // rhinoceros
        trie.insert(new int[]{129435}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 331))); // hippopotamus
        trie.insert(new int[]{128045}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 199))); // mouse face
        trie.insert(new int[]{128001}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 727))); // mouse
        trie.insert(new int[]{128000}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 727))); // rat
        trie.insert(new int[]{128057}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 529))); // hamster
        trie.insert(new int[]{128048}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 1))); // rabbit face
        trie.insert(new int[]{128007}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 331))); // rabbit
        trie.insert(new int[]{128063}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 67))); // chipmunk
        trie.insert(new int[]{128063, 65039}, new ParseResult(3, new SpriteCoordinates(3, 0, 529, 67))); // chipmunk
        trie.insert(new int[]{129451}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 265))); // beaver
        trie.insert(new int[]{129428}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 331))); // hedgehog
        trie.insert(new int[]{129415}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 199))); // bat
        trie.insert(new int[]{128059}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 331))); // bear
        trie.insert(new int[]{128059, 8205, 10052}, new ParseResult(4, new SpriteCoordinates(3, 0, 529, 397))); // polar bear
        trie.insert(new int[]{128059, 8205, 10052, 65039}, new ParseResult(5, new SpriteCoordinates(3, 0, 529, 397))); // polar bear
        trie.insert(new int[]{128040}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 529))); // koala
        trie.insert(new int[]{128060}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 265))); // panda
        trie.insert(new int[]{129445}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 1))); // sloth
        trie.insert(new int[]{129446}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 265))); // otter
        trie.insert(new int[]{129448}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 265))); // skunk
        trie.insert(new int[]{129432}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 67))); // kangaroo
        trie.insert(new int[]{129441}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 265))); // badger
        trie.insert(new int[]{128062}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 133))); // paw prints
        trie.insert(new int[]{129411}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 463))); // turkey
        trie.insert(new int[]{128020}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 661))); // chicken
        trie.insert(new int[]{128019}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 661))); // rooster
        trie.insert(new int[]{128035}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 595))); // hatching chick
        trie.insert(new int[]{128036}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 595))); // baby chick
        trie.insert(new int[]{128037}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 595))); // front-facing baby chick
        trie.insert(new int[]{128038}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 595))); // bird
        trie.insert(new int[]{128039}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 595))); // penguin
        trie.insert(new int[]{128330, 65039}, new ParseResult(3, new SpriteCoordinates(3, 0, 397, 463))); // dove
        trie.insert(new int[]{128330}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 463))); // dove
        trie.insert(new int[]{129413}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 331))); // eagle
        trie.insert(new int[]{129414}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 265))); // duck
        trie.insert(new int[]{129442}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 199))); // swan
        trie.insert(new int[]{129417}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 67))); // owl
        trie.insert(new int[]{129444}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 67))); // dodo
        trie.insert(new int[]{129718}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 133))); // feather
        trie.insert(new int[]{129449}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 265))); // flamingo
        trie.insert(new int[]{129434}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 331))); // peacock
        trie.insert(new int[]{129436}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 331))); // parrot
        trie.insert(new int[]{129725}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 1))); // wing
        trie.insert(new int[]{128038, 8205, 11035}, new ParseResult(4, new SpriteCoordinates(3, 0, 133, 595))); // black bird
        trie.insert(new int[]{129727}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 67))); // goose
        trie.insert(new int[]{128038, 8205, 128293}, new ParseResult(5, new SpriteCoordinates(3, 0, 199, 595))); // phoenix
        trie.insert(new int[]{128056}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 529))); // frog
        trie.insert(new int[]{128010}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 67))); // crocodile
        trie.insert(new int[]{128034}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 595))); // turtle
        trie.insert(new int[]{129422}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 397))); // lizard
        trie.insert(new int[]{128013}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 661))); // snake
        trie.insert(new int[]{128050}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 529))); // dragon face
        trie.insert(new int[]{128009}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 133))); // dragon
        trie.insert(new int[]{129429}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 265))); // sauropod
        trie.insert(new int[]{129430}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 199))); // T-Rex
        trie.insert(new int[]{128051}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 529))); // spouting whale
        trie.insert(new int[]{128011}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 1))); // whale
        trie.insert(new int[]{128044}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 265))); // dolphin
        trie.insert(new int[]{129453}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 133))); // seal
        trie.insert(new int[]{128031}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 1))); // fish
        trie.insert(new int[]{128032}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 595))); // tropical fish
        trie.insert(new int[]{128033}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 595))); // blowfish
        trie.insert(new int[]{129416}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 133))); // shark
        trie.insert(new int[]{128025}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 397))); // octopus
        trie.insert(new int[]{128026}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 331))); // spiral shell
        trie.insert(new int[]{129720}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 1))); // coral
        trie.insert(new int[]{129724}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 67))); // jellyfish
        trie.insert(new int[]{128012}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 661))); // snail
        trie.insert(new int[]{129419}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 397))); // butterfly
        trie.insert(new int[]{128027}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 265))); // bug
        trie.insert(new int[]{128028}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 199))); // ant
        trie.insert(new int[]{128029}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 133))); // honeybee
        trie.insert(new int[]{129714}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 199))); // beetle
        trie.insert(new int[]{128030}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 67))); // lady beetle
        trie.insert(new int[]{129431}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 133))); // cricket
        trie.insert(new int[]{129715}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 199))); // cockroach
        trie.insert(new int[]{128375, 65039}, new ParseResult(3, new SpriteCoordinates(3, 0, 331, 463))); // spider
        trie.insert(new int[]{128375}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 463))); // spider
        trie.insert(new int[]{128376}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 463))); // spider web
        trie.insert(new int[]{128376, 65039}, new ParseResult(3, new SpriteCoordinates(3, 0, 265, 463))); // spider web
        trie.insert(new int[]{129410}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 463))); // scorpion
        trie.insert(new int[]{129439}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 331))); // mosquito
        trie.insert(new int[]{129712}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 1))); // fly
        trie.insert(new int[]{129713}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 199))); // worm
        trie.insert(new int[]{129440}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 331))); // microbe
        trie.insert(new int[]{128144}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 1))); // bouquet
        trie.insert(new int[]{127800}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 133))); // cherry blossom
        trie.insert(new int[]{128174}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 463))); // white flower
        trie.insert(new int[]{129719}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 67))); // lotus
        trie.insert(new int[]{127989, 65039}, new ParseResult(3, new SpriteCoordinates(3, 0, 133, 727))); // rosette
        trie.insert(new int[]{127989}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 727))); // rosette
        trie.insert(new int[]{127801}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 67))); // rose
        trie.insert(new int[]{129344}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 463))); // wilted flower
        trie.insert(new int[]{127802}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 1))); // hibiscus
        trie.insert(new int[]{127803}, new ParseResult(2, new SpriteCoordinates(3, 0, 727, 727))); // sunflower
        trie.insert(new int[]{127804}, new ParseResult(2, new SpriteCoordinates(3, 0, 661, 727))); // blossom
        trie.insert(new int[]{127799}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 199))); // tulip
        trie.insert(new int[]{129723}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 133))); // hyacinth
        trie.insert(new int[]{127793}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 529))); // seedling
        trie.insert(new int[]{129716}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 199))); // potted plant
        trie.insert(new int[]{127794}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 463))); // evergreen tree
        trie.insert(new int[]{127795}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 397))); // deciduous tree
        trie.insert(new int[]{127796}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 331))); // palm tree
        trie.insert(new int[]{127797}, new ParseResult(2, new SpriteCoordinates(3, 0, 793, 265))); // cactus
        trie.insert(new int[]{127806}, new ParseResult(2, new SpriteCoordinates(3, 0, 595, 727))); // sheaf of rice
        trie.insert(new int[]{127807}, new ParseResult(2, new SpriteCoordinates(3, 0, 529, 727))); // herb
        trie.insert(new int[]{9752}, new ParseResult(1, new SpriteCoordinates(3, 0, 1, 1))); // shamrock
        trie.insert(new int[]{9752, 65039}, new ParseResult(2, new SpriteCoordinates(3, 0, 1, 1))); // shamrock
        trie.insert(new int[]{127808}, new ParseResult(2, new SpriteCoordinates(3, 0, 463, 727))); // four leaf clover
        trie.insert(new int[]{127809}, new ParseResult(2, new SpriteCoordinates(3, 0, 397, 727))); // maple leaf
        trie.insert(new int[]{127810}, new ParseResult(2, new SpriteCoordinates(3, 0, 331, 727))); // fallen leaf
        trie.insert(new int[]{127811}, new ParseResult(2, new SpriteCoordinates(3, 0, 265, 727))); // leaf fluttering in wind
        trie.insert(new int[]{129721}, new ParseResult(2, new SpriteCoordinates(3, 0, 133, 133))); // empty nest
        trie.insert(new int[]{129722}, new ParseResult(2, new SpriteCoordinates(3, 0, 67, 133))); // nest with eggs
        trie.insert(new int[]{127812}, new ParseResult(2, new SpriteCoordinates(3, 0, 199, 727))); // mushroom
        trie.insert(new int[]{127815}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 265))); // grapes
        trie.insert(new int[]{127816}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 199))); // melon
        trie.insert(new int[]{127817}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 133))); // watermelon
        trie.insert(new int[]{127818}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 67))); // tangerine
        trie.insert(new int[]{127819}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 661))); // lemon
        trie.insert(new int[]{127819, 8205, 129001}, new ParseResult(5, new SpriteCoordinates(4, 0, 727, 1))); // lime
        trie.insert(new int[]{127820}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 661))); // banana
        trie.insert(new int[]{127821}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 661))); // pineapple
        trie.insert(new int[]{129389}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 331))); // mango
        trie.insert(new int[]{127822}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 661))); // red apple
        trie.insert(new int[]{127823}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 661))); // green apple
        trie.insert(new int[]{127824}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 661))); // pear
        trie.insert(new int[]{127825}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 661))); // peach
        trie.insert(new int[]{127826}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 661))); // cherries
        trie.insert(new int[]{127827}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 661))); // strawberry
        trie.insert(new int[]{129744}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 199))); // blueberries
        trie.insert(new int[]{129373}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 397))); // kiwi fruit
        trie.insert(new int[]{127813}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 397))); // tomato
        trie.insert(new int[]{129746}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 67))); // olive
        trie.insert(new int[]{129381}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 265))); // coconut
        trie.insert(new int[]{129361}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 463))); // avocado
        trie.insert(new int[]{127814}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 331))); // eggplant
        trie.insert(new int[]{129364}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 463))); // potato
        trie.insert(new int[]{129365}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 463))); // carrot
        trie.insert(new int[]{127805}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 529))); // ear of corn
        trie.insert(new int[]{127798}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 595))); // hot pepper
        trie.insert(new int[]{127798, 65039}, new ParseResult(3, new SpriteCoordinates(4, 0, 727, 595))); // hot pepper
        trie.insert(new int[]{129745}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 133))); // bell pepper
        trie.insert(new int[]{129362}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 463))); // cucumber
        trie.insert(new int[]{129388}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 331))); // leafy green
        trie.insert(new int[]{129382}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 199))); // broccoli
        trie.insert(new int[]{129476}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 265))); // garlic
        trie.insert(new int[]{129477}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 199))); // onion
        trie.insert(new int[]{129372}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 1))); // peanuts
        trie.insert(new int[]{129752}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 1))); // beans
        trie.insert(new int[]{127792}, new ParseResult(2, new SpriteCoordinates(4, 0, 727, 661))); // chestnut
        trie.insert(new int[]{129754}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 67))); // ginger root
        trie.insert(new int[]{129755}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 1))); // pea pod
        trie.insert(new int[]{127812, 8205, 129003}, new ParseResult(5, new SpriteCoordinates(4, 0, 727, 463))); // brown mushroom
        trie.insert(new int[]{127838}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 67))); // bread
        trie.insert(new int[]{129360}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 463))); // croissant
        trie.insert(new int[]{129366}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 397))); // baguette bread
        trie.insert(new int[]{129747}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 1))); // flatbread
        trie.insert(new int[]{129384}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 67))); // pretzel
        trie.insert(new int[]{129391}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 331))); // bagel
        trie.insert(new int[]{129374}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 397))); // pancakes
        trie.insert(new int[]{129479}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 67))); // waffle
        trie.insert(new int[]{129472}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 265))); // cheese wedge
        trie.insert(new int[]{127830}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 595))); // meat on bone
        trie.insert(new int[]{127831}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 529))); // poultry leg
        trie.insert(new int[]{129385}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 1))); // cut of meat
        trie.insert(new int[]{129363}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 463))); // bacon
        trie.insert(new int[]{127828}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 661))); // hamburger
        trie.insert(new int[]{127839}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 1))); // french fries
        trie.insert(new int[]{127829}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 661))); // pizza
        trie.insert(new int[]{127789}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 727))); // hot dog
        trie.insert(new int[]{129386}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 331))); // sandwich
        trie.insert(new int[]{127790}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 727))); // taco
        trie.insert(new int[]{127791}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 727))); // burrito
        trie.insert(new int[]{129748}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 133))); // tamale
        trie.insert(new int[]{129369}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 199))); // stuffed flatbread
        trie.insert(new int[]{129478}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 133))); // falafel
        trie.insert(new int[]{129370}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 133))); // egg
        trie.insert(new int[]{127859}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 529))); // cooking
        trie.insert(new int[]{129368}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 265))); // shallow pan of food
        trie.insert(new int[]{127858}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 1))); // pot of food
        trie.insert(new int[]{129749}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 133))); // fondue
        trie.insert(new int[]{129379}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 397))); // bowl with spoon
        trie.insert(new int[]{129367}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 331))); // green salad
        trie.insert(new int[]{127871}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 265))); // popcorn
        trie.insert(new int[]{129480}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 1))); // butter
        trie.insert(new int[]{129474}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 265))); // salt
        trie.insert(new int[]{129387}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 331))); // canned food
        trie.insert(new int[]{127857}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 67))); // bento box
        trie.insert(new int[]{127832}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 463))); // rice cracker
        trie.insert(new int[]{127833}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 397))); // rice ball
        trie.insert(new int[]{127834}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 331))); // cooked rice
        trie.insert(new int[]{127835}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 265))); // curry rice
        trie.insert(new int[]{127836}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 199))); // steaming bowl
        trie.insert(new int[]{127837}, new ParseResult(2, new SpriteCoordinates(4, 0, 661, 133))); // spaghetti
        trie.insert(new int[]{127840}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 595))); // roasted sweet potato
        trie.insert(new int[]{127842}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 595))); // oden
        trie.insert(new int[]{127843}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 595))); // sushi
        trie.insert(new int[]{127844}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 595))); // fried shrimp
        trie.insert(new int[]{127845}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 595))); // fish cake with swirl
        trie.insert(new int[]{129390}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 331))); // moon cake
        trie.insert(new int[]{127841}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 595))); // dango
        trie.insert(new int[]{129375}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 397))); // dumpling
        trie.insert(new int[]{129376}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 397))); // fortune cookie
        trie.insert(new int[]{129377}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 397))); // takeout box
        trie.insert(new int[]{129408}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 265))); // crab
        trie.insert(new int[]{129438}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 67))); // lobster
        trie.insert(new int[]{129424}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 199))); // shrimp
        trie.insert(new int[]{129425}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 133))); // squid
        trie.insert(new int[]{129450}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 1))); // oyster
        trie.insert(new int[]{127846}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 595))); // soft ice cream
        trie.insert(new int[]{127847}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 595))); // shaved ice
        trie.insert(new int[]{127848}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 595))); // ice cream
        trie.insert(new int[]{127849}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 595))); // doughnut
        trie.insert(new int[]{127850}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 529))); // cookie
        trie.insert(new int[]{127874}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 199))); // birthday cake
        trie.insert(new int[]{127856}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 133))); // shortcake
        trie.insert(new int[]{129473}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 265))); // cupcake
        trie.insert(new int[]{129383}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 133))); // pie
        trie.insert(new int[]{127851}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 463))); // chocolate bar
        trie.insert(new int[]{127852}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 397))); // candy
        trie.insert(new int[]{127853}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 331))); // lollipop
        trie.insert(new int[]{127854}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 265))); // custard
        trie.insert(new int[]{127855}, new ParseResult(2, new SpriteCoordinates(4, 0, 595, 199))); // honey pot
        trie.insert(new int[]{127868}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 463))); // baby bottle
        trie.insert(new int[]{129371}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 67))); // glass of milk
        trie.insert(new int[]{9749}, new ParseResult(1, new SpriteCoordinates(4, 0, 1, 1))); // hot beverage
        trie.insert(new int[]{129750}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 133))); // teapot
        trie.insert(new int[]{127861}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 529))); // teacup without handle
        trie.insert(new int[]{127862}, new ParseResult(2, new SpriteCoordinates(4, 0, 331, 529))); // sake
        trie.insert(new int[]{127870}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 331))); // bottle with popping cork
        trie.insert(new int[]{127863}, new ParseResult(2, new SpriteCoordinates(4, 0, 265, 529))); // wine glass
        trie.insert(new int[]{127864}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 529))); // cocktail glass
        trie.insert(new int[]{127865}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 529))); // tropical drink
        trie.insert(new int[]{127866}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 529))); // beer mug
    }

    public static void init10(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{127867}, new ParseResult(2, new SpriteCoordinates(4, 0, 1, 529))); // clinking beer mugs
        trie.insert(new int[]{129346}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 1))); // clinking glasses
        trie.insert(new int[]{129347}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 463))); // tumbler glass
        trie.insert(new int[]{129751}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 67))); // pouring liquid
        trie.insert(new int[]{129380}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 331))); // cup with straw
        trie.insert(new int[]{129483}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 199))); // bubble tea
        trie.insert(new int[]{129475}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 265))); // beverage box
        trie.insert(new int[]{129481}, new ParseResult(2, new SpriteCoordinates(4, 0, 199, 199))); // mate
        trie.insert(new int[]{129482}, new ParseResult(2, new SpriteCoordinates(4, 0, 133, 199))); // ice
        trie.insert(new int[]{129378}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 397))); // chopsticks
        trie.insert(new int[]{127869, 65039}, new ParseResult(3, new SpriteCoordinates(4, 0, 529, 397))); // fork and knife with plate
        trie.insert(new int[]{127869}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 397))); // fork and knife with plate
        trie.insert(new int[]{127860}, new ParseResult(2, new SpriteCoordinates(4, 0, 463, 529))); // fork and knife
        trie.insert(new int[]{129348}, new ParseResult(2, new SpriteCoordinates(4, 0, 397, 463))); // spoon
        trie.insert(new int[]{128298}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 67))); // kitchen knife
        trie.insert(new int[]{129753}, new ParseResult(2, new SpriteCoordinates(4, 0, 67, 67))); // jar
        trie.insert(new int[]{127994}, new ParseResult(2, new SpriteCoordinates(4, 0, 529, 133))); // amphora
        trie.insert(new int[]{127875}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 529))); // jack-o-lantern
        trie.insert(new int[]{127876}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 529))); // Christmas tree
        trie.insert(new int[]{127878}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 529))); // fireworks
        trie.insert(new int[]{127879}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 529))); // sparkler
        trie.insert(new int[]{129512}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 265))); // firecracker
        trie.insert(new int[]{10024}, new ParseResult(1, new SpriteCoordinates(5, 0, 1, 1))); // sparkles
        trie.insert(new int[]{127880}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 529))); // balloon
        trie.insert(new int[]{127881}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 529))); // party popper
        trie.insert(new int[]{127882}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 529))); // confetti ball
        trie.insert(new int[]{127883}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 529))); // tanabata tree
        trie.insert(new int[]{127885}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 529))); // pine decoration
        trie.insert(new int[]{127886}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 463))); // Japanese dolls
        trie.insert(new int[]{127887}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 397))); // carp streamer
        trie.insert(new int[]{127888}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 331))); // wind chime
        trie.insert(new int[]{127889}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 265))); // moon viewing ceremony
        trie.insert(new int[]{129511}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 265))); // red envelope
        trie.insert(new int[]{127872}, new ParseResult(2, new SpriteCoordinates(5, 0, 595, 67))); // ribbon
        trie.insert(new int[]{127873}, new ParseResult(2, new SpriteCoordinates(5, 0, 595, 1))); // wrapped gift
        trie.insert(new int[]{127895}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 133))); // reminder ribbon
        trie.insert(new int[]{127895, 65039}, new ParseResult(3, new SpriteCoordinates(5, 0, 529, 133))); // reminder ribbon
        trie.insert(new int[]{127903, 65039}, new ParseResult(3, new SpriteCoordinates(5, 0, 529, 67))); // admission tickets
        trie.insert(new int[]{127903}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 67))); // admission tickets
        trie.insert(new int[]{127915}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 463))); // ticket
        trie.insert(new int[]{127894, 65039}, new ParseResult(3, new SpriteCoordinates(5, 0, 529, 199))); // military medal
        trie.insert(new int[]{127894}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 199))); // military medal
        trie.insert(new int[]{127942}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 397))); // trophy
        trie.insert(new int[]{127941}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 1))); // sports medal
        trie.insert(new int[]{129351}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 331))); // 1st place medal
        trie.insert(new int[]{129352}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 331))); // 2nd place medal
        trie.insert(new int[]{129353}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 331))); // 3rd place medal
        trie.insert(new int[]{9917}, new ParseResult(1, new SpriteCoordinates(5, 0, 133, 1))); // soccer ball
        trie.insert(new int[]{9918}, new ParseResult(1, new SpriteCoordinates(5, 0, 67, 67))); // baseball
        trie.insert(new int[]{129358}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 1))); // softball
        trie.insert(new int[]{127936}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 67))); // basketball
        trie.insert(new int[]{127952}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 397))); // volleyball
        trie.insert(new int[]{127944}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 397))); // american football
        trie.insert(new int[]{127945}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 397))); // rugby football
        trie.insert(new int[]{127934}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 199))); // tennis
        trie.insert(new int[]{129359}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 265))); // flying disc
        trie.insert(new int[]{127923}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 397))); // bowling
        trie.insert(new int[]{127951}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 397))); // cricket game
        trie.insert(new int[]{127953}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 397))); // field hockey
        trie.insert(new int[]{127954}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 397))); // ice hockey
        trie.insert(new int[]{129357}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 67))); // lacrosse
        trie.insert(new int[]{127955}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 331))); // ping pong
        trie.insert(new int[]{127992}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 265))); // badminton
        trie.insert(new int[]{129354}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 265))); // boxing glove
        trie.insert(new int[]{129355}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 199))); // martial arts uniform
        trie.insert(new int[]{129349}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 331))); // goal net
        trie.insert(new int[]{9971}, new ParseResult(1, new SpriteCoordinates(5, 0, 1, 67))); // flag in hole
        trie.insert(new int[]{9976}, new ParseResult(1, new SpriteCoordinates(5, 0, 67, 1))); // ice skate
        trie.insert(new int[]{9976, 65039}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 1))); // ice skate
        trie.insert(new int[]{127907}, new ParseResult(2, new SpriteCoordinates(5, 0, 529, 1))); // fishing pole
        trie.insert(new int[]{129343}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 331))); // diving mask
        trie.insert(new int[]{127933}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 265))); // running shirt
        trie.insert(new int[]{127935}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 133))); // skis
        trie.insert(new int[]{128759}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 331))); // sled
        trie.insert(new int[]{129356}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 133))); // curling stone
        trie.insert(new int[]{127919}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 463))); // bullseye
        trie.insert(new int[]{129664}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 67))); // yo-yo
        trie.insert(new int[]{129665}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 1))); // kite
        trie.insert(new int[]{128299}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 199))); // water pistol
        trie.insert(new int[]{127921}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 463))); // pool 8 ball
        trie.insert(new int[]{128302}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 133))); // crystal ball
        trie.insert(new int[]{129668}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 199))); // magic wand
        trie.insert(new int[]{127918}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 463))); // video game
        trie.insert(new int[]{128377, 65039}, new ParseResult(3, new SpriteCoordinates(5, 0, 397, 67))); // joystick
        trie.insert(new int[]{128377}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 67))); // joystick
        trie.insert(new int[]{127920}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 463))); // slot machine
        trie.insert(new int[]{127922}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 463))); // game die
        trie.insert(new int[]{129513}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 265))); // puzzle piece
        trie.insert(new int[]{129528}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 133))); // teddy bear
        trie.insert(new int[]{129669}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 199))); // piñata
        trie.insert(new int[]{129705}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 67))); // mirror ball
        trie.insert(new int[]{129670}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 199))); // nesting dolls
        trie.insert(new int[]{9824}, new ParseResult(1, new SpriteCoordinates(5, 0, 133, 133))); // spade suit
        trie.insert(new int[]{9824, 65039}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 133))); // spade suit
        trie.insert(new int[]{9829}, new ParseResult(1, new SpriteCoordinates(5, 0, 1, 133))); // heart suit
        trie.insert(new int[]{9829, 65039}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 133))); // heart suit
        trie.insert(new int[]{9830}, new ParseResult(1, new SpriteCoordinates(5, 0, 133, 67))); // diamond suit
        trie.insert(new int[]{9830, 65039}, new ParseResult(2, new SpriteCoordinates(5, 0, 133, 67))); // diamond suit
        trie.insert(new int[]{9827}, new ParseResult(1, new SpriteCoordinates(5, 0, 67, 133))); // club suit
        trie.insert(new int[]{9827, 65039}, new ParseResult(2, new SpriteCoordinates(5, 0, 67, 133))); // club suit
        trie.insert(new int[]{9823}, new ParseResult(1, new SpriteCoordinates(5, 0, 199, 1))); // chess pawn
        trie.insert(new int[]{9823, 65039}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 1))); // chess pawn
        trie.insert(new int[]{127183}, new ParseResult(2, new SpriteCoordinates(5, 0, 595, 133))); // joker
        trie.insert(new int[]{126980}, new ParseResult(2, new SpriteCoordinates(5, 0, 595, 199))); // mahjong red dragon
        trie.insert(new int[]{127924}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 331))); // flower playing cards
        trie.insert(new int[]{127917}, new ParseResult(2, new SpriteCoordinates(5, 0, 331, 463))); // performing arts
        trie.insert(new int[]{128444, 65039}, new ParseResult(3, new SpriteCoordinates(5, 0, 397, 1))); // framed picture
        trie.insert(new int[]{128444}, new ParseResult(2, new SpriteCoordinates(5, 0, 397, 1))); // framed picture
        trie.insert(new int[]{127912}, new ParseResult(2, new SpriteCoordinates(5, 0, 463, 463))); // artist palette
        trie.insert(new int[]{129525}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 265))); // thread
        trie.insert(new int[]{129697}, new ParseResult(2, new SpriteCoordinates(5, 0, 1, 199))); // sewing needle
        trie.insert(new int[]{129526}, new ParseResult(2, new SpriteCoordinates(5, 0, 265, 199))); // yarn
        trie.insert(new int[]{129698}, new ParseResult(2, new SpriteCoordinates(5, 0, 199, 133))); // knot
        trie.insert(new int[]{127757}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 529))); // globe showing Europe-Africa
        trie.insert(new int[]{127758}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 463))); // globe showing Americas
        trie.insert(new int[]{127759}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 397))); // globe showing Asia-Australia
        trie.insert(new int[]{127760}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 331))); // globe with meridians
        trie.insert(new int[]{128506}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 529))); // world map
        trie.insert(new int[]{128506, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 661, 529))); // world map
        trie.insert(new int[]{128510}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 265))); // map of Japan
        trie.insert(new int[]{129517}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 1))); // compass
        trie.insert(new int[]{127956, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 793, 793))); // snow-capped mountain
        trie.insert(new int[]{127956}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 793))); // snow-capped mountain
        trie.insert(new int[]{9968, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 1))); // mountain
        trie.insert(new int[]{9968}, new ParseResult(1, new SpriteCoordinates(6, 0, 199, 1))); // mountain
        trie.insert(new int[]{127755}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 661))); // volcano
        trie.insert(new int[]{128507}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 463))); // mount fuji
        trie.insert(new int[]{127957}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 793))); // camping
        trie.insert(new int[]{127957, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 727, 793))); // camping
        trie.insert(new int[]{127958, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 661, 793))); // beach with umbrella
        trie.insert(new int[]{127958}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 793))); // beach with umbrella
        trie.insert(new int[]{127964}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 793))); // desert
        trie.insert(new int[]{127964, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 265, 793))); // desert
        trie.insert(new int[]{127965}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 793))); // desert island
        trie.insert(new int[]{127965, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 199, 793))); // desert island
        trie.insert(new int[]{127966, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 133, 793))); // national park
        trie.insert(new int[]{127966}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 793))); // national park
        trie.insert(new int[]{127967, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 67, 793))); // stadium
        trie.insert(new int[]{127967}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 793))); // stadium
        trie.insert(new int[]{127963}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 793))); // classical building
        trie.insert(new int[]{127963, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 331, 793))); // classical building
        trie.insert(new int[]{127959}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 793))); // building construction
        trie.insert(new int[]{127959, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 595, 793))); // building construction
        trie.insert(new int[]{129521}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 331))); // brick
        trie.insert(new int[]{129704}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 331))); // rock
        trie.insert(new int[]{129717}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 331))); // wood
        trie.insert(new int[]{128726}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 463))); // hut
        trie.insert(new int[]{127960, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 529, 793))); // houses
        trie.insert(new int[]{127960}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 793))); // houses
        trie.insert(new int[]{127962, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 397, 793))); // derelict house
        trie.insert(new int[]{127962}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 793))); // derelict house
        trie.insert(new int[]{127968}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 793))); // house
        trie.insert(new int[]{127969}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 727))); // house with garden
        trie.insert(new int[]{127970}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 661))); // office building
        trie.insert(new int[]{127971}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 595))); // Japanese post office
        trie.insert(new int[]{127972}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 529))); // post office
        trie.insert(new int[]{127973}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 463))); // hospital
        trie.insert(new int[]{127974}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 397))); // bank
        trie.insert(new int[]{127976}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 331))); // hotel
        trie.insert(new int[]{127977}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 265))); // love hotel
        trie.insert(new int[]{127978}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 199))); // convenience store
        trie.insert(new int[]{127979}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 133))); // school
        trie.insert(new int[]{127980}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 67))); // department store
        trie.insert(new int[]{127981}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 1))); // factory
        trie.insert(new int[]{127983}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 727))); // Japanese castle
        trie.insert(new int[]{127984}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 727))); // castle
        trie.insert(new int[]{128146}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 727))); // wedding
        trie.insert(new int[]{128508}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 397))); // Tokyo tower
        trie.insert(new int[]{128509}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 331))); // Statue of Liberty
        trie.insert(new int[]{9962}, new ParseResult(1, new SpriteCoordinates(6, 0, 199, 67))); // church
        trie.insert(new int[]{128332}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 727))); // mosque
        trie.insert(new int[]{128725}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 463))); // hindu temple
        trie.insert(new int[]{128333}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 727))); // synagogue
        trie.insert(new int[]{9961}, new ParseResult(1, new SpriteCoordinates(6, 0, 199, 133))); // shinto shrine
        trie.insert(new int[]{9961, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 133))); // shinto shrine
        trie.insert(new int[]{128331}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 727))); // kaaba
        trie.insert(new int[]{9970}, new ParseResult(1, new SpriteCoordinates(6, 0, 67, 133))); // fountain
        trie.insert(new int[]{9978}, new ParseResult(1, new SpriteCoordinates(6, 0, 133, 1))); // tent
        trie.insert(new int[]{127745}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 925))); // foggy
        trie.insert(new int[]{127747}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 925))); // night with stars
        trie.insert(new int[]{127961}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 793))); // cityscape
        trie.insert(new int[]{127961, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 463, 793))); // cityscape
        trie.insert(new int[]{127748}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 925))); // sunrise over mountains
        trie.insert(new int[]{127749}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 925))); // sunrise
        trie.insert(new int[]{127750}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 925))); // cityscape at dusk
        trie.insert(new int[]{127751}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 925))); // sunset
        trie.insert(new int[]{127753}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 793))); // bridge at night
        trie.insert(new int[]{9832, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 67))); // hot springs
        trie.insert(new int[]{9832}, new ParseResult(1, new SpriteCoordinates(6, 0, 265, 67))); // hot springs
        trie.insert(new int[]{127904}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 331))); // carousel horse
        trie.insert(new int[]{128733}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 463))); // playground slide
        trie.insert(new int[]{127905}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 265))); // ferris wheel
        trie.insert(new int[]{127906}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 199))); // roller coaster
        trie.insert(new int[]{128136}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 727))); // barber pole
        trie.insert(new int[]{127914}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 133))); // circus tent
        trie.insert(new int[]{128642}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 67))); // locomotive
        trie.insert(new int[]{128643}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 1))); // railway car
        trie.insert(new int[]{128644}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 595))); // high-speed train
        trie.insert(new int[]{128645}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 595))); // bullet train
        trie.insert(new int[]{128646}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 595))); // train
        trie.insert(new int[]{128647}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 595))); // metro
        trie.insert(new int[]{128648}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 595))); // light rail
        trie.insert(new int[]{128649}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 595))); // station
        trie.insert(new int[]{128650}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 595))); // tram
        trie.insert(new int[]{128669}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 529))); // monorail
        trie.insert(new int[]{128670}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 529))); // mountain railway
        trie.insert(new int[]{128651}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 595))); // tram car
        trie.insert(new int[]{128652}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 595))); // bus
        trie.insert(new int[]{128653}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 595))); // oncoming bus
        trie.insert(new int[]{128654}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 529))); // trolleybus
        trie.insert(new int[]{128656}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 397))); // minibus
        trie.insert(new int[]{128657}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 331))); // ambulance
        trie.insert(new int[]{128658}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 265))); // fire engine
        trie.insert(new int[]{128659}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 199))); // police car
        trie.insert(new int[]{128660}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 133))); // oncoming police car
        trie.insert(new int[]{128661}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 67))); // taxi
        trie.insert(new int[]{128662}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 1))); // oncoming taxi
        trie.insert(new int[]{128663}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 529))); // automobile
        trie.insert(new int[]{128664}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 529))); // oncoming automobile
        trie.insert(new int[]{128665}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 529))); // sport utility vehicle
        trie.insert(new int[]{128763}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 265))); // pickup truck
        trie.insert(new int[]{128666}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 529))); // delivery truck
        trie.insert(new int[]{128667}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 529))); // articulated lorry
        trie.insert(new int[]{128668}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 529))); // tractor
        trie.insert(new int[]{127950, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 1))); // racing car
        trie.insert(new int[]{127950}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 1))); // racing car
        trie.insert(new int[]{127949, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 67))); // motorcycle
        trie.insert(new int[]{127949}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 67))); // motorcycle
        trie.insert(new int[]{128757}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 397))); // motor scooter
        trie.insert(new int[]{129469}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 67))); // manual wheelchair
        trie.insert(new int[]{129468}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 133))); // motorized wheelchair
        trie.insert(new int[]{128762}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 331))); // auto rickshaw
        trie.insert(new int[]{128690}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 463))); // bicycle
        trie.insert(new int[]{128756}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 397))); // kick scooter
        trie.insert(new int[]{128761}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 397))); // skateboard
        trie.insert(new int[]{128764}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 199))); // roller skate
        trie.insert(new int[]{128655}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 463))); // bus stop
        trie.insert(new int[]{128739}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 331))); // motorway
        trie.insert(new int[]{128739, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 463, 331))); // motorway
        trie.insert(new int[]{128740, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 463, 265))); // railway track
        trie.insert(new int[]{128740}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 265))); // railway track
        trie.insert(new int[]{128738}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 397))); // oil drum
        trie.insert(new int[]{128738, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 463, 397))); // oil drum
        trie.insert(new int[]{9981}, new ParseResult(1, new SpriteCoordinates(6, 0, 67, 67))); // fuel pump
        trie.insert(new int[]{128734}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 463))); // wheel
        trie.insert(new int[]{128680}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 1))); // police car light
        trie.insert(new int[]{128677}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 199))); // horizontal traffic light
        trie.insert(new int[]{128678}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 133))); // vertical traffic light
        trie.insert(new int[]{128721}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 463))); // stop sign
        trie.insert(new int[]{128679}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 67))); // construction
        trie.insert(new int[]{9875}, new ParseResult(1, new SpriteCoordinates(6, 0, 265, 1))); // anchor
        trie.insert(new int[]{128735}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 463))); // ring buoy
        trie.insert(new int[]{9973}, new ParseResult(1, new SpriteCoordinates(6, 0, 133, 67))); // sailboat
        trie.insert(new int[]{128758}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 397))); // canoe
        trie.insert(new int[]{128676}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 265))); // speedboat
        trie.insert(new int[]{128755}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 397))); // passenger ship
        trie.insert(new int[]{128755, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 331, 397))); // passenger ship
        trie.insert(new int[]{9972, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 133))); // ferry
        trie.insert(new int[]{9972}, new ParseResult(1, new SpriteCoordinates(6, 0, 1, 133))); // ferry
        trie.insert(new int[]{128741, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 463, 199))); // motor boat
        trie.insert(new int[]{128741}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 199))); // motor boat
        trie.insert(new int[]{128674}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 331))); // ship
        trie.insert(new int[]{9992}, new ParseResult(1, new SpriteCoordinates(6, 0, 1, 67))); // airplane
        trie.insert(new int[]{9992, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 67))); // airplane
        trie.insert(new int[]{128745, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 463, 133))); // small airplane
        trie.insert(new int[]{128745}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 133))); // small airplane
        trie.insert(new int[]{128747}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 67))); // airplane departure
        trie.insert(new int[]{128748}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 1))); // airplane arrival
        trie.insert(new int[]{129666}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 331))); // parachute
        trie.insert(new int[]{128186}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 727))); // seat
        trie.insert(new int[]{128641}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 133))); // helicopter
        trie.insert(new int[]{128671}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 529))); // suspension railway
        trie.insert(new int[]{128672}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 463))); // mountain cableway
        trie.insert(new int[]{128673}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 397))); // aerial tramway
        trie.insert(new int[]{128752, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 397, 397))); // satellite
        trie.insert(new int[]{128752}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 397))); // satellite
        trie.insert(new int[]{128640}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 199))); // rocket
        trie.insert(new int[]{128760}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 397))); // flying saucer
        trie.insert(new int[]{128718, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 397, 463))); // bellhop bell
        trie.insert(new int[]{128718}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 463))); // bellhop bell
        trie.insert(new int[]{129523}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 331))); // luggage
        trie.insert(new int[]{8987}, new ParseResult(1, new SpriteCoordinates(6, 0, 331, 199))); // hourglass done
        trie.insert(new int[]{9203}, new ParseResult(1, new SpriteCoordinates(6, 0, 265, 265))); // hourglass not done
        trie.insert(new int[]{8986}, new ParseResult(1, new SpriteCoordinates(6, 0, 331, 265))); // watch
        trie.insert(new int[]{9200}, new ParseResult(1, new SpriteCoordinates(6, 0, 331, 133))); // alarm clock
        trie.insert(new int[]{9201, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 67))); // stopwatch
        trie.insert(new int[]{9201}, new ParseResult(1, new SpriteCoordinates(6, 0, 331, 67))); // stopwatch
        trie.insert(new int[]{9202, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 1))); // timer clock
        trie.insert(new int[]{9202}, new ParseResult(1, new SpriteCoordinates(6, 0, 331, 1))); // timer clock
        trie.insert(new int[]{128368, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 661, 595))); // mantelpiece clock
        trie.insert(new int[]{128368}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 595))); // mantelpiece clock
        trie.insert(new int[]{128347}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 67))); // twelve o’clock
        trie.insert(new int[]{128359}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 661))); // twelve-thirty
        trie.insert(new int[]{128336}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 727))); // one o’clock
        trie.insert(new int[]{128348}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 1))); // one-thirty
        trie.insert(new int[]{128337}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 727))); // two o’clock
        trie.insert(new int[]{128349}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 661))); // two-thirty
        trie.insert(new int[]{128338}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 661))); // three o’clock
        trie.insert(new int[]{128350}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 661))); // three-thirty
        trie.insert(new int[]{128339}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 595))); // four o’clock
        trie.insert(new int[]{128351}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 661))); // four-thirty
        trie.insert(new int[]{128340}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 529))); // five o’clock
        trie.insert(new int[]{128352}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 661))); // five-thirty
        trie.insert(new int[]{128341}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 463))); // six o’clock
        trie.insert(new int[]{128353}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 661))); // six-thirty
        trie.insert(new int[]{128342}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 397))); // seven o’clock
        trie.insert(new int[]{128354}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 661))); // seven-thirty
        trie.insert(new int[]{128343}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 331))); // eight o’clock
        trie.insert(new int[]{128355}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 661))); // eight-thirty
        trie.insert(new int[]{128344}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 265))); // nine o’clock
        trie.insert(new int[]{128356}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 661))); // nine-thirty
        trie.insert(new int[]{128345}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 199))); // ten o’clock
        trie.insert(new int[]{128357}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 661))); // ten-thirty
        trie.insert(new int[]{128346}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 133))); // eleven o’clock
        trie.insert(new int[]{128358}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 661))); // eleven-thirty
        trie.insert(new int[]{127761}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 265))); // new moon
        trie.insert(new int[]{127762}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 199))); // waxing crescent moon
        trie.insert(new int[]{127763}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 133))); // first quarter moon
        trie.insert(new int[]{127764}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 67))); // waxing gibbous moon
        trie.insert(new int[]{127765}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 1))); // full moon
        trie.insert(new int[]{127766}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 859))); // waning gibbous moon
        trie.insert(new int[]{127767}, new ParseResult(2, new SpriteCoordinates(6, 0, 793, 859))); // last quarter moon
        trie.insert(new int[]{127768}, new ParseResult(2, new SpriteCoordinates(6, 0, 727, 859))); // waning crescent moon
        trie.insert(new int[]{127769}, new ParseResult(2, new SpriteCoordinates(6, 0, 661, 859))); // crescent moon
        trie.insert(new int[]{127770}, new ParseResult(2, new SpriteCoordinates(6, 0, 595, 859))); // new moon face
        trie.insert(new int[]{127771}, new ParseResult(2, new SpriteCoordinates(6, 0, 529, 859))); // first quarter moon face
        trie.insert(new int[]{127772}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 859))); // last quarter moon face
        trie.insert(new int[]{127777}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 859))); // thermometer
        trie.insert(new int[]{127777, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 133, 859))); // thermometer
        trie.insert(new int[]{9728, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 265))); // sun
        trie.insert(new int[]{9728}, new ParseResult(1, new SpriteCoordinates(6, 0, 199, 265))); // sun
        trie.insert(new int[]{127773}, new ParseResult(2, new SpriteCoordinates(6, 0, 397, 859))); // full moon face
        trie.insert(new int[]{127774}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 859))); // sun with face
        trie.insert(new int[]{129680}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 331))); // ringed planet
        trie.insert(new int[]{11088}, new ParseResult(1, new SpriteCoordinates(6, 0, 1, 1))); // star
        trie.insert(new int[]{127775}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 859))); // glowing star
        trie.insert(new int[]{127776}, new ParseResult(2, new SpriteCoordinates(6, 0, 199, 859))); // shooting star
        trie.insert(new int[]{127756}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 595))); // milky way
        trie.insert(new int[]{9729}, new ParseResult(1, new SpriteCoordinates(6, 0, 133, 265))); // cloud
        trie.insert(new int[]{9729, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 265))); // cloud
        trie.insert(new int[]{9925}, new ParseResult(1, new SpriteCoordinates(6, 0, 67, 199))); // sun behind cloud
        trie.insert(new int[]{9928, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 199))); // cloud with lightning and rain
        trie.insert(new int[]{9928}, new ParseResult(1, new SpriteCoordinates(6, 0, 1, 199))); // cloud with lightning and rain
        trie.insert(new int[]{127780}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 859))); // sun behind small cloud
        trie.insert(new int[]{127780, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 67, 859))); // sun behind small cloud
        trie.insert(new int[]{127781, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 1, 859))); // sun behind large cloud
        trie.insert(new int[]{127781}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 859))); // sun behind large cloud
        trie.insert(new int[]{127782, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 793))); // sun behind rain cloud
        trie.insert(new int[]{127782}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 793))); // sun behind rain cloud
        trie.insert(new int[]{127783, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 727))); // cloud with rain
        trie.insert(new int[]{127783}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 727))); // cloud with rain
    }

    public static void init11(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{127784, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 661))); // cloud with snow
        trie.insert(new int[]{127784}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 661))); // cloud with snow
        trie.insert(new int[]{127785}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 595))); // cloud with lightning
        trie.insert(new int[]{127785, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 595))); // cloud with lightning
        trie.insert(new int[]{127786, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 529))); // tornado
        trie.insert(new int[]{127786}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 529))); // tornado
        trie.insert(new int[]{127787}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 463))); // fog
        trie.insert(new int[]{127787, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 463))); // fog
        trie.insert(new int[]{127788, 65039}, new ParseResult(3, new SpriteCoordinates(6, 0, 859, 397))); // wind face
        trie.insert(new int[]{127788}, new ParseResult(2, new SpriteCoordinates(6, 0, 859, 397))); // wind face
        trie.insert(new int[]{127744}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 925))); // cyclone
        trie.insert(new int[]{127752}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 859))); // rainbow
        trie.insert(new int[]{127746}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 925))); // closed umbrella
        trie.insert(new int[]{9730}, new ParseResult(1, new SpriteCoordinates(6, 0, 67, 265))); // umbrella
        trie.insert(new int[]{9730, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 265))); // umbrella
        trie.insert(new int[]{9748}, new ParseResult(1, new SpriteCoordinates(6, 0, 265, 133))); // umbrella with rain drops
        trie.insert(new int[]{9969}, new ParseResult(1, new SpriteCoordinates(6, 0, 133, 133))); // umbrella on ground
        trie.insert(new int[]{9969, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 133, 133))); // umbrella on ground
        trie.insert(new int[]{9889}, new ParseResult(1, new SpriteCoordinates(6, 0, 199, 199))); // high voltage
        trie.insert(new int[]{10052, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 67, 1))); // snowflake
        trie.insert(new int[]{10052}, new ParseResult(1, new SpriteCoordinates(6, 0, 67, 1))); // snowflake
        trie.insert(new int[]{9731, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 1, 265))); // snowman
        trie.insert(new int[]{9731}, new ParseResult(1, new SpriteCoordinates(6, 0, 1, 265))); // snowman
        trie.insert(new int[]{9924}, new ParseResult(1, new SpriteCoordinates(6, 0, 133, 199))); // snowman without snow
        trie.insert(new int[]{9732, 65039}, new ParseResult(2, new SpriteCoordinates(6, 0, 265, 199))); // comet
        trie.insert(new int[]{9732}, new ParseResult(1, new SpriteCoordinates(6, 0, 265, 199))); // comet
        trie.insert(new int[]{128293}, new ParseResult(2, new SpriteCoordinates(6, 0, 331, 727))); // fire
        trie.insert(new int[]{128167}, new ParseResult(2, new SpriteCoordinates(6, 0, 463, 727))); // droplet
        trie.insert(new int[]{127754}, new ParseResult(2, new SpriteCoordinates(6, 0, 925, 727))); // water wave
        trie.insert(new int[]{128083}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 793))); // glasses
        trie.insert(new int[]{128374, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 595, 661))); // sunglasses
        trie.insert(new int[]{128374}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 661))); // sunglasses
        trie.insert(new int[]{129405}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 67))); // goggles
        trie.insert(new int[]{129404}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 133))); // lab coat
        trie.insert(new int[]{129466}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 529))); // safety vest
        trie.insert(new int[]{128084}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 727))); // necktie
        trie.insert(new int[]{128085}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 661))); // t-shirt
        trie.insert(new int[]{128086}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 595))); // jeans
        trie.insert(new int[]{129507}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 529))); // scarf
        trie.insert(new int[]{129508}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 529))); // gloves
        trie.insert(new int[]{129509}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 529))); // coat
        trie.insert(new int[]{129510}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 529))); // socks
        trie.insert(new int[]{128087}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 529))); // dress
        trie.insert(new int[]{128088}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 463))); // kimono
        trie.insert(new int[]{129403}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 199))); // sari
        trie.insert(new int[]{129649}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 397))); // one-piece swimsuit
        trie.insert(new int[]{129650}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 331))); // briefs
        trie.insert(new int[]{129651}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 265))); // shorts
        trie.insert(new int[]{128089}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 397))); // bikini
        trie.insert(new int[]{128090}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 331))); // woman’s clothes
        trie.insert(new int[]{129709}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 199))); // folding hand fan
        trie.insert(new int[]{128091}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 265))); // purse
        trie.insert(new int[]{128092}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 199))); // handbag
        trie.insert(new int[]{128093}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 133))); // clutch bag
        trie.insert(new int[]{128717}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 595))); // shopping bags
        trie.insert(new int[]{128717, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 67, 595))); // shopping bags
        trie.insert(new int[]{127890}, new ParseResult(2, new SpriteCoordinates(7, 0, 1057, 331))); // backpack
        trie.insert(new int[]{129652}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 199))); // thong sandal
        trie.insert(new int[]{128094}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 67))); // man’s shoe
        trie.insert(new int[]{128095}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 1))); // running shoe
        trie.insert(new int[]{129406}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 1))); // hiking boot
        trie.insert(new int[]{129407}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 529))); // flat shoe
        trie.insert(new int[]{128096}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 925))); // high-heeled shoe
        trie.insert(new int[]{128097}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 925))); // woman’s sandal
        trie.insert(new int[]{129648}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 463))); // ballet shoes
        trie.insert(new int[]{128098}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 925))); // woman’s boot
        trie.insert(new int[]{129710}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 133))); // hair pick
        trie.insert(new int[]{128081}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 925))); // crown
        trie.insert(new int[]{128082}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 859))); // woman’s hat
        trie.insert(new int[]{127913}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 991))); // top hat
        trie.insert(new int[]{127891}, new ParseResult(2, new SpriteCoordinates(7, 0, 1057, 265))); // graduation cap
        trie.insert(new int[]{129506}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 529))); // billed cap
        trie.insert(new int[]{129686}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 133))); // military helmet
        trie.insert(new int[]{9937, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 133))); // rescue worker’s helmet
        trie.insert(new int[]{9937}, new ParseResult(1, new SpriteCoordinates(7, 0, 1, 133))); // rescue worker’s helmet
        trie.insert(new int[]{128255}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 1))); // prayer beads
        trie.insert(new int[]{128132}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 925))); // lipstick
        trie.insert(new int[]{128141}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 925))); // ring
        trie.insert(new int[]{128142}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 925))); // gem stone
        trie.insert(new int[]{128263}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 727))); // muted speaker
        trie.insert(new int[]{128264}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 727))); // speaker low volume
        trie.insert(new int[]{128265}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 727))); // speaker medium volume
        trie.insert(new int[]{128266}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 727))); // speaker high volume
        trie.insert(new int[]{128226}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 793))); // loudspeaker
        trie.insert(new int[]{128227}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 793))); // megaphone
        trie.insert(new int[]{128239}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 727))); // postal horn
        trie.insert(new int[]{128276}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 595))); // bell
        trie.insert(new int[]{128277}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 529))); // bell with slash
        trie.insert(new int[]{127932}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 991))); // musical score
        trie.insert(new int[]{127925}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 991))); // musical note
        trie.insert(new int[]{127926}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 991))); // musical notes
        trie.insert(new int[]{127897, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 1057, 199))); // studio microphone
        trie.insert(new int[]{127897}, new ParseResult(2, new SpriteCoordinates(7, 0, 1057, 199))); // studio microphone
        trie.insert(new int[]{127898}, new ParseResult(2, new SpriteCoordinates(7, 0, 1057, 133))); // level slider
        trie.insert(new int[]{127898, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 1057, 133))); // level slider
        trie.insert(new int[]{127899}, new ParseResult(2, new SpriteCoordinates(7, 0, 1057, 67))); // control knobs
        trie.insert(new int[]{127899, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 1057, 67))); // control knobs
        trie.insert(new int[]{127908}, new ParseResult(2, new SpriteCoordinates(7, 0, 991, 991))); // microphone
        trie.insert(new int[]{127911}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 991))); // headphone
        trie.insert(new int[]{128251}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 199))); // radio
        trie.insert(new int[]{127927}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 991))); // saxophone
        trie.insert(new int[]{129687}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 67))); // accordion
        trie.insert(new int[]{127928}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 991))); // guitar
        trie.insert(new int[]{127929}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 991))); // musical keyboard
        trie.insert(new int[]{127930}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 991))); // trumpet
        trie.insert(new int[]{127931}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 991))); // violin
        trie.insert(new int[]{129685}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 199))); // banjo
        trie.insert(new int[]{129345}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 265))); // drum
        trie.insert(new int[]{129688}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 1))); // long drum
        trie.insert(new int[]{129671}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 397))); // maracas
        trie.insert(new int[]{129672}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 397))); // flute
        trie.insert(new int[]{128241}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 595))); // mobile phone
        trie.insert(new int[]{128242}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 529))); // mobile phone with arrow
        trie.insert(new int[]{9742}, new ParseResult(1, new SpriteCoordinates(7, 0, 199, 199))); // telephone
        trie.insert(new int[]{9742, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 199))); // telephone
        trie.insert(new int[]{128222}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 199))); // telephone receiver
        trie.insert(new int[]{128223}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 133))); // pager
        trie.insert(new int[]{128224}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 67))); // fax machine
        trie.insert(new int[]{128267}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 727))); // battery
        trie.insert(new int[]{129707}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 265))); // low battery
        trie.insert(new int[]{128268}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 727))); // electric plug
        trie.insert(new int[]{128187}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 661))); // laptop
        trie.insert(new int[]{128421, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 199, 661))); // desktop computer
        trie.insert(new int[]{128421}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 661))); // desktop computer
        trie.insert(new int[]{128424}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 661))); // printer
        trie.insert(new int[]{128424, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 133, 661))); // printer
        trie.insert(new int[]{9000}, new ParseResult(1, new SpriteCoordinates(7, 0, 265, 1))); // keyboard
        trie.insert(new int[]{9000, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 1))); // keyboard
        trie.insert(new int[]{128433}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 661))); // computer mouse
        trie.insert(new int[]{128433, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 67, 661))); // computer mouse
        trie.insert(new int[]{128434}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 661))); // trackball
        trie.insert(new int[]{128434, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 1, 661))); // trackball
        trie.insert(new int[]{128189}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 529))); // computer disk
        trie.insert(new int[]{128190}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 463))); // floppy disk
        trie.insert(new int[]{128191}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 397))); // optical disk
        trie.insert(new int[]{128192}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 331))); // dvd
        trie.insert(new int[]{129518}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 331))); // abacus
        trie.insert(new int[]{127909}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 991))); // movie camera
        trie.insert(new int[]{127902}, new ParseResult(2, new SpriteCoordinates(7, 0, 1057, 1))); // film frames
        trie.insert(new int[]{127902, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 1057, 1))); // film frames
        trie.insert(new int[]{128253}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 67))); // film projector
        trie.insert(new int[]{128253, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 793, 67))); // film projector
        trie.insert(new int[]{127916}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 991))); // clapper board
        trie.insert(new int[]{128250}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 265))); // television
        trie.insert(new int[]{128247}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 463))); // camera
        trie.insert(new int[]{128248}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 397))); // camera with flash
        trie.insert(new int[]{128249}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 331))); // video camera
        trie.insert(new int[]{128252}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 133))); // videocassette
        trie.insert(new int[]{128269}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 727))); // magnifying glass tilted left
        trie.insert(new int[]{128270}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 727))); // magnifying glass tilted right
        trie.insert(new int[]{128367, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 661))); // candle
        trie.insert(new int[]{128367}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 661))); // candle
        trie.insert(new int[]{128161}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 925))); // light bulb
        trie.insert(new int[]{128294}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 331))); // flashlight
        trie.insert(new int[]{127982}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 991))); // red paper lantern
        trie.insert(new int[]{129684}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 265))); // diya lamp
        trie.insert(new int[]{128212}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 793))); // notebook with decorative cover
        trie.insert(new int[]{128213}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 727))); // closed book
        trie.insert(new int[]{128214}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 661))); // open book
        trie.insert(new int[]{128215}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 595))); // green book
        trie.insert(new int[]{128216}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 529))); // blue book
        trie.insert(new int[]{128217}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 463))); // orange book
        trie.insert(new int[]{128218}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 397))); // books
        trie.insert(new int[]{128211}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 859))); // notebook
        trie.insert(new int[]{128210}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 859))); // ledger
        trie.insert(new int[]{128195}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 133))); // page with curl
        trie.insert(new int[]{128220}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 331))); // scroll
        trie.insert(new int[]{128196}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 67))); // page facing up
        trie.insert(new int[]{128240}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 661))); // newspaper
        trie.insert(new int[]{128478}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 67))); // rolled-up newspaper
        trie.insert(new int[]{128478, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 67))); // rolled-up newspaper
        trie.insert(new int[]{128209}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 859))); // bookmark tabs
        trie.insert(new int[]{128278}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 463))); // bookmark
        trie.insert(new int[]{127991}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 991))); // label
        trie.insert(new int[]{127991, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 67, 991))); // label
        trie.insert(new int[]{128176}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 925))); // money bag
        trie.insert(new int[]{129689}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 331))); // coin
        trie.insert(new int[]{128180}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 925))); // yen banknote
        trie.insert(new int[]{128181}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 925))); // dollar banknote
        trie.insert(new int[]{128182}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 925))); // euro banknote
        trie.insert(new int[]{128183}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 859))); // pound banknote
        trie.insert(new int[]{128184}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 793))); // money with wings
        trie.insert(new int[]{128179}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 925))); // credit card
        trie.insert(new int[]{129534}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 463))); // receipt
        trie.insert(new int[]{128185}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 727))); // chart increasing with yen
        trie.insert(new int[]{9993, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 67))); // envelope
        trie.insert(new int[]{9993}, new ParseResult(1, new SpriteCoordinates(7, 0, 1, 67))); // envelope
        trie.insert(new int[]{128231}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 793))); // e-mail
        trie.insert(new int[]{128232}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 793))); // incoming envelope
        trie.insert(new int[]{128233}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 793))); // envelope with arrow
        trie.insert(new int[]{128228}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 793))); // outbox tray
        trie.insert(new int[]{128229}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 793))); // inbox tray
        trie.insert(new int[]{128230}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 793))); // package
        trie.insert(new int[]{128235}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 793))); // closed mailbox with raised flag
        trie.insert(new int[]{128234}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 793))); // closed mailbox with lowered flag
        trie.insert(new int[]{128236}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 793))); // open mailbox with raised flag
        trie.insert(new int[]{128237}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 793))); // open mailbox with lowered flag
        trie.insert(new int[]{128238}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 793))); // postbox
        trie.insert(new int[]{128499}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 595))); // ballot box with ballot
        trie.insert(new int[]{128499, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 595, 595))); // ballot box with ballot
        trie.insert(new int[]{9999}, new ParseResult(1, new SpriteCoordinates(7, 0, 67, 1))); // pencil
        trie.insert(new int[]{9999, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 1))); // pencil
        trie.insert(new int[]{10002}, new ParseResult(1, new SpriteCoordinates(7, 0, 1, 1))); // black nib
        trie.insert(new int[]{10002, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 1))); // black nib
        trie.insert(new int[]{128395}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 661))); // fountain pen
        trie.insert(new int[]{128395, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 397, 661))); // fountain pen
        trie.insert(new int[]{128394, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 463, 661))); // pen
        trie.insert(new int[]{128394}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 661))); // pen
        trie.insert(new int[]{128396}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 661))); // paintbrush
        trie.insert(new int[]{128396, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 331, 661))); // paintbrush
        trie.insert(new int[]{128397}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 661))); // crayon
        trie.insert(new int[]{128397, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 265, 661))); // crayon
        trie.insert(new int[]{128221}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 265))); // memo
        trie.insert(new int[]{128188}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 595))); // briefcase
        trie.insert(new int[]{128193}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 265))); // file folder
        trie.insert(new int[]{128194}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 199))); // open file folder
        trie.insert(new int[]{128450}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 595))); // card index dividers
        trie.insert(new int[]{128450, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 595))); // card index dividers
        trie.insert(new int[]{128197}, new ParseResult(2, new SpriteCoordinates(7, 0, 925, 1))); // calendar
        trie.insert(new int[]{128198}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 859))); // tear-off calendar
        trie.insert(new int[]{128466, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 331))); // spiral notepad
        trie.insert(new int[]{128466}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 331))); // spiral notepad
        trie.insert(new int[]{128467}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 265))); // spiral calendar
        trie.insert(new int[]{128467, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 265))); // spiral calendar
        trie.insert(new int[]{128199}, new ParseResult(2, new SpriteCoordinates(7, 0, 793, 859))); // card index
        trie.insert(new int[]{128200}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 859))); // chart increasing
        trie.insert(new int[]{128201}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 859))); // chart decreasing
        trie.insert(new int[]{128202}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 859))); // bar chart
        trie.insert(new int[]{128203}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 859))); // clipboard
        trie.insert(new int[]{128204}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 859))); // pushpin
        trie.insert(new int[]{128205}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 859))); // round pushpin
        trie.insert(new int[]{128206}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 859))); // paperclip
        trie.insert(new int[]{128391, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 529, 661))); // linked paperclips
        trie.insert(new int[]{128391}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 661))); // linked paperclips
        trie.insert(new int[]{128207}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 859))); // straight ruler
        trie.insert(new int[]{128208}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 859))); // triangular ruler
        trie.insert(new int[]{9986}, new ParseResult(1, new SpriteCoordinates(7, 0, 67, 67))); // scissors
        trie.insert(new int[]{9986, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 67))); // scissors
        trie.insert(new int[]{128451, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 529))); // card file box
        trie.insert(new int[]{128451}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 529))); // card file box
        trie.insert(new int[]{128452, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 463))); // file cabinet
        trie.insert(new int[]{128452}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 463))); // file cabinet
        trie.insert(new int[]{128465}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 397))); // wastebasket
        trie.insert(new int[]{128465, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 397))); // wastebasket
        trie.insert(new int[]{128274}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 727))); // locked
        trie.insert(new int[]{128275}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 661))); // unlocked
        trie.insert(new int[]{128271}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 727))); // locked with pen
        trie.insert(new int[]{128272}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 727))); // locked with key
        trie.insert(new int[]{128273}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 727))); // key
        trie.insert(new int[]{128477}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 133))); // old key
        trie.insert(new int[]{128477, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 133))); // old key
        trie.insert(new int[]{128296}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 199))); // hammer
        trie.insert(new int[]{129683}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 331))); // axe
        trie.insert(new int[]{9935}, new ParseResult(1, new SpriteCoordinates(7, 0, 67, 133))); // pick
        trie.insert(new int[]{9935, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 133))); // pick
        trie.insert(new int[]{9874, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 199))); // hammer and pick
        trie.insert(new int[]{9874}, new ParseResult(1, new SpriteCoordinates(7, 0, 133, 199))); // hammer and pick
        trie.insert(new int[]{128736, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 595, 397))); // hammer and wrench
        trie.insert(new int[]{128736}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 397))); // hammer and wrench
        trie.insert(new int[]{128481}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 1))); // dagger
        trie.insert(new int[]{128481, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 1))); // dagger
        trie.insert(new int[]{9876}, new ParseResult(1, new SpriteCoordinates(7, 0, 67, 199))); // crossed swords
        trie.insert(new int[]{9876, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 199))); // crossed swords
        trie.insert(new int[]{128163}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 925))); // bomb
        trie.insert(new int[]{129667}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 397))); // boomerang
        trie.insert(new int[]{127993}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 991))); // bow and arrow
        trie.insert(new int[]{128737, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 595, 331))); // shield
        trie.insert(new int[]{128737}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 331))); // shield
        trie.insert(new int[]{129690}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 331))); // carpentry saw
        trie.insert(new int[]{128295}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 265))); // wrench
        trie.insert(new int[]{129691}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 331))); // screwdriver
        trie.insert(new int[]{128297}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 133))); // nut and bolt
        trie.insert(new int[]{9881}, new ParseResult(1, new SpriteCoordinates(7, 0, 199, 67))); // gear
        trie.insert(new int[]{9881, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 67))); // gear
        trie.insert(new int[]{128476, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 661, 199))); // clamp
        trie.insert(new int[]{128476}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 199))); // clamp
        trie.insert(new int[]{9878}, new ParseResult(1, new SpriteCoordinates(7, 0, 1, 199))); // balance scale
        trie.insert(new int[]{9878, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 199))); // balance scale
        trie.insert(new int[]{129455}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 529))); // white cane
        trie.insert(new int[]{128279}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 397))); // link
        trie.insert(new int[]{9939, 8205, 128165}, new ParseResult(4, new SpriteCoordinates(7, 0, 133, 67))); // broken chain
        trie.insert(new int[]{9939, 65039, 8205, 128165}, new ParseResult(5, new SpriteCoordinates(7, 0, 133, 67))); // broken chain
        trie.insert(new int[]{9939, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 1))); // chains
        trie.insert(new int[]{9939}, new ParseResult(1, new SpriteCoordinates(7, 0, 133, 1))); // chains
        trie.insert(new int[]{129693}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 331))); // hook
        trie.insert(new int[]{129520}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 199))); // toolbox
        trie.insert(new int[]{129522}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 133))); // magnet
        trie.insert(new int[]{129692}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 331))); // ladder
        trie.insert(new int[]{9879, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 133))); // alembic
        trie.insert(new int[]{9879}, new ParseResult(1, new SpriteCoordinates(7, 0, 199, 133))); // alembic
        trie.insert(new int[]{129514}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 529))); // test tube
        trie.insert(new int[]{129515}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 463))); // petri dish
        trie.insert(new int[]{129516}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 397))); // dna
        trie.insert(new int[]{128300}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 67))); // microscope
        trie.insert(new int[]{128301}, new ParseResult(2, new SpriteCoordinates(7, 0, 727, 1))); // telescope
        trie.insert(new int[]{128225}, new ParseResult(2, new SpriteCoordinates(7, 0, 859, 1))); // satellite antenna
        trie.insert(new int[]{128137}, new ParseResult(2, new SpriteCoordinates(7, 0, 661, 925))); // syringe
        trie.insert(new int[]{129656}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 133))); // drop of blood
        trie.insert(new int[]{128138}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 925))); // pill
        trie.insert(new int[]{129657}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 67))); // adhesive bandage
        trie.insert(new int[]{129660}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 397))); // crutch
        trie.insert(new int[]{129658}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 1))); // stethoscope
        trie.insert(new int[]{129659}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 397))); // x-ray
        trie.insert(new int[]{128682}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 595))); // door
        trie.insert(new int[]{128727}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 463))); // elevator
        trie.insert(new int[]{129694}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 331))); // mirror
        trie.insert(new int[]{129695}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 265))); // window
        trie.insert(new int[]{128719, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 1, 595))); // bed
        trie.insert(new int[]{128719}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 595))); // bed
        trie.insert(new int[]{128715}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 595))); // couch and lamp
        trie.insert(new int[]{128715, 65039}, new ParseResult(3, new SpriteCoordinates(7, 0, 133, 595))); // couch and lamp
        trie.insert(new int[]{129681}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 397))); // chair
        trie.insert(new int[]{128701}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 595))); // toilet
        trie.insert(new int[]{129696}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 199))); // plunger
        trie.insert(new int[]{128703}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 595))); // shower
        trie.insert(new int[]{128705}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 595))); // bathtub
        trie.insert(new int[]{129700}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 67))); // mouse trap
        trie.insert(new int[]{129682}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 397))); // razor
        trie.insert(new int[]{129524}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 67))); // lotion bottle
        trie.insert(new int[]{129527}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 1))); // safety pin
        trie.insert(new int[]{129529}, new ParseResult(2, new SpriteCoordinates(7, 0, 463, 463))); // broom
        trie.insert(new int[]{129530}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 463))); // basket
        trie.insert(new int[]{129531}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 463))); // roll of paper
        trie.insert(new int[]{129699}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 133))); // bucket
        trie.insert(new int[]{129532}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 463))); // soap
        trie.insert(new int[]{129767}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 67))); // bubbles
        trie.insert(new int[]{129701}, new ParseResult(2, new SpriteCoordinates(7, 0, 331, 1))); // toothbrush
        trie.insert(new int[]{129533}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 463))); // sponge
        trie.insert(new int[]{129519}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 265))); // fire extinguisher
        trie.insert(new int[]{128722}, new ParseResult(2, new SpriteCoordinates(7, 0, 595, 529))); // shopping cart
        trie.insert(new int[]{128684}, new ParseResult(2, new SpriteCoordinates(7, 0, 397, 595))); // cigarette
        trie.insert(new int[]{9904}, new ParseResult(1, new SpriteCoordinates(7, 0, 199, 1))); // coffin
        trie.insert(new int[]{9904, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 1))); // coffin
        trie.insert(new int[]{129702}, new ParseResult(2, new SpriteCoordinates(7, 0, 265, 265))); // headstone
        trie.insert(new int[]{9905}, new ParseResult(1, new SpriteCoordinates(7, 0, 133, 133))); // funeral urn
        trie.insert(new int[]{9905, 65039}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 133))); // funeral urn
        trie.insert(new int[]{129535}, new ParseResult(2, new SpriteCoordinates(7, 0, 67, 463))); // nazar amulet
        trie.insert(new int[]{129708}, new ParseResult(2, new SpriteCoordinates(7, 0, 1, 265))); // hamsa
        trie.insert(new int[]{128511}, new ParseResult(2, new SpriteCoordinates(7, 0, 529, 595))); // moai
        trie.insert(new int[]{129703}, new ParseResult(2, new SpriteCoordinates(7, 0, 199, 265))); // placard
        trie.insert(new int[]{129706}, new ParseResult(2, new SpriteCoordinates(7, 0, 133, 265))); // identification card
        trie.insert(new int[]{127975}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 529))); // ATM sign
        trie.insert(new int[]{128686}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 529))); // litter in bin sign
        trie.insert(new int[]{128688}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 397))); // potable water
        trie.insert(new int[]{9855}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 331))); // wheelchair symbol
        trie.insert(new int[]{128697}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 67))); // men’s room
        trie.insert(new int[]{128698}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 1))); // women’s room
        trie.insert(new int[]{128699}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 661))); // restroom
        trie.insert(new int[]{128700}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 661))); // baby symbol
        trie.insert(new int[]{128702}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 661))); // water closet
        trie.insert(new int[]{128706}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 661))); // passport control
        trie.insert(new int[]{128707}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 661))); // customs
        trie.insert(new int[]{128708}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 661))); // baggage claim
        trie.insert(new int[]{128709}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 661))); // left luggage
        trie.insert(new int[]{9888, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 67))); // warning
        trie.insert(new int[]{9888}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 67))); // warning
        trie.insert(new int[]{128696}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 133))); // children crossing
        trie.insert(new int[]{9940}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 331))); // no entry
        trie.insert(new int[]{128683}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 661))); // prohibited
        trie.insert(new int[]{128691}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 265))); // no bicycles
        trie.insert(new int[]{128685}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 595))); // no smoking
    }

    public static void init12(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{128687}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 463))); // no littering
        trie.insert(new int[]{128689}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 331))); // non-potable water
        trie.insert(new int[]{128695}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 199))); // no pedestrians
        trie.insert(new int[]{128245}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 67))); // no mobile phones
        trie.insert(new int[]{128286}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 727))); // no one under eighteen
        trie.insert(new int[]{9762}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 1))); // radioactive
        trie.insert(new int[]{9762, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 1))); // radioactive
        trie.insert(new int[]{9763, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 463))); // biohazard
        trie.insert(new int[]{9763}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 463))); // biohazard
        trie.insert(new int[]{11014}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 133))); // up arrow
        trie.insert(new int[]{11014, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 133))); // up arrow
        trie.insert(new int[]{8599, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 595))); // up-right arrow
        trie.insert(new int[]{8599}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 595))); // up-right arrow
        trie.insert(new int[]{10145, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 199))); // right arrow
        trie.insert(new int[]{10145}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 199))); // right arrow
        trie.insert(new int[]{8600}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 529))); // down-right arrow
        trie.insert(new int[]{8600, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 529))); // down-right arrow
        trie.insert(new int[]{11015}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 133))); // down arrow
        trie.insert(new int[]{11015, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 133))); // down arrow
        trie.insert(new int[]{8601}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 463))); // down-left arrow
        trie.insert(new int[]{8601, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 463))); // down-left arrow
        trie.insert(new int[]{11013}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 1))); // left arrow
        trie.insert(new int[]{11013, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 1))); // left arrow
        trie.insert(new int[]{8598}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 595))); // up-left arrow
        trie.insert(new int[]{8598, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 595))); // up-left arrow
        trie.insert(new int[]{8597, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 595))); // up-down arrow
        trie.insert(new int[]{8597}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 595))); // up-down arrow
        trie.insert(new int[]{8596, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 595))); // left-right arrow
        trie.insert(new int[]{8596}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 595))); // left-right arrow
        trie.insert(new int[]{8617, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 397))); // right arrow curving left
        trie.insert(new int[]{8617}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 397))); // right arrow curving left
        trie.insert(new int[]{8618, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 331))); // left arrow curving right
        trie.insert(new int[]{8618}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 331))); // left arrow curving right
        trie.insert(new int[]{10548}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 133))); // right arrow curving up
        trie.insert(new int[]{10548, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 133))); // right arrow curving up
        trie.insert(new int[]{10549, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 67))); // right arrow curving down
        trie.insert(new int[]{10549}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 67))); // right arrow curving down
        trie.insert(new int[]{128259}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 793))); // clockwise vertical arrows
        trie.insert(new int[]{128260}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 793))); // counterclockwise arrows button
        trie.insert(new int[]{128281}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 793))); // BACK arrow
        trie.insert(new int[]{128282}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 793))); // END arrow
        trie.insert(new int[]{128283}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 793))); // ON! arrow
        trie.insert(new int[]{128284}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 793))); // SOON arrow
        trie.insert(new int[]{128285}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 793))); // TOP arrow
        trie.insert(new int[]{128720}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 661))); // place of worship
        trie.insert(new int[]{9883}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 199))); // atom symbol
        trie.insert(new int[]{9883, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 199))); // atom symbol
        trie.insert(new int[]{128329, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 67, 727))); // om
        trie.insert(new int[]{128329}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 727))); // om
        trie.insert(new int[]{10017, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 133))); // star of David
        trie.insert(new int[]{10017}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 133))); // star of David
        trie.insert(new int[]{9784, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 463))); // wheel of dharma
        trie.insert(new int[]{9784}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 463))); // wheel of dharma
        trie.insert(new int[]{9775, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 463))); // yin yang
        trie.insert(new int[]{9775}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 463))); // yin yang
        trie.insert(new int[]{10013}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 199))); // latin cross
        trie.insert(new int[]{10013, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 199))); // latin cross
        trie.insert(new int[]{9766, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 463))); // orthodox cross
        trie.insert(new int[]{9766}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 463))); // orthodox cross
        trie.insert(new int[]{9770, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 463))); // star and crescent
        trie.insert(new int[]{9770}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 463))); // star and crescent
        trie.insert(new int[]{9774, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 463))); // peace symbol
        trie.insert(new int[]{9774}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 463))); // peace symbol
        trie.insert(new int[]{128334}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 727))); // menorah
        trie.insert(new int[]{128303}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 265))); // dotted six-pointed star
        trie.insert(new int[]{129711}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 595))); // khanda
        trie.insert(new int[]{9800}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 397))); // Aries
        trie.insert(new int[]{9801}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 331))); // Taurus
        trie.insert(new int[]{9802}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 265))); // Gemini
        trie.insert(new int[]{9803}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 199))); // Cancer
        trie.insert(new int[]{9804}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 133))); // Leo
        trie.insert(new int[]{9805}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 67))); // Virgo
        trie.insert(new int[]{9806}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 1))); // Libra
        trie.insert(new int[]{9807}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 397))); // Scorpio
        trie.insert(new int[]{9808}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 397))); // Sagittarius
        trie.insert(new int[]{9809}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 397))); // Capricorn
        trie.insert(new int[]{9810}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 397))); // Aquarius
        trie.insert(new int[]{9811}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 397))); // Pisces
        trie.insert(new int[]{9934}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 331))); // Ophiuchus
        trie.insert(new int[]{128256}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 793))); // shuffle tracks button
        trie.insert(new int[]{128257}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 793))); // repeat button
        trie.insert(new int[]{128258}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 793))); // repeat single button
        trie.insert(new int[]{9654}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 463))); // play button
        trie.insert(new int[]{9654, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 463))); // play button
        trie.insert(new int[]{9193}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 199))); // fast-forward button
        trie.insert(new int[]{9197}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 529))); // next track button
        trie.insert(new int[]{9197, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 529))); // next track button
        trie.insert(new int[]{9199}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 529))); // play or pause button
        trie.insert(new int[]{9199, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 529))); // play or pause button
        trie.insert(new int[]{9664}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 397))); // reverse button
        trie.insert(new int[]{9664, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 397))); // reverse button
        trie.insert(new int[]{9194}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 133))); // fast reverse button
        trie.insert(new int[]{9198}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 529))); // last track button
        trie.insert(new int[]{9198, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 529))); // last track button
        trie.insert(new int[]{128316}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 727))); // upwards button
        trie.insert(new int[]{9195}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 67))); // fast up button
        trie.insert(new int[]{128317}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 727))); // downwards button
        trie.insert(new int[]{9196}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 1))); // fast down button
        trie.insert(new int[]{9208}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 529))); // pause button
        trie.insert(new int[]{9208, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 529))); // pause button
        trie.insert(new int[]{9209, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 529))); // stop button
        trie.insert(new int[]{9209}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 529))); // stop button
        trie.insert(new int[]{9210, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 529))); // record button
        trie.insert(new int[]{9210}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 529))); // record button
        trie.insert(new int[]{9167, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 265))); // eject button
        trie.insert(new int[]{9167}, new ParseResult(1, new SpriteCoordinates(8, 0, 595, 265))); // eject button
        trie.insert(new int[]{127910}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 595))); // cinema
        trie.insert(new int[]{128261}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 793))); // dim button
        trie.insert(new int[]{128262}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 793))); // bright button
        trie.insert(new int[]{128246}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 1))); // antenna bars
        trie.insert(new int[]{128732}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 661))); // wireless
        trie.insert(new int[]{128243}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 199))); // vibration mode
        trie.insert(new int[]{128244}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 133))); // mobile phone off
        trie.insert(new int[]{9792}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 463))); // female sign
        trie.insert(new int[]{9792, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 463))); // female sign
        trie.insert(new int[]{9794, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 463))); // male sign
        trie.insert(new int[]{9794}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 463))); // male sign
        trie.insert(new int[]{9895}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 1))); // transgender symbol
        trie.insert(new int[]{9895, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 1))); // transgender symbol
        trie.insert(new int[]{10006, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 265))); // multiply
        trie.insert(new int[]{10006}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 265))); // multiply
        trie.insert(new int[]{10133}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 67))); // plus
        trie.insert(new int[]{10134}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 1))); // minus
        trie.insert(new int[]{10135}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 199))); // divide
        trie.insert(new int[]{129008}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 595))); // heavy equals sign
        trie.insert(new int[]{9854, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 397))); // infinity
        trie.insert(new int[]{9854}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 397))); // infinity
        trie.insert(new int[]{8252, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 595))); // double exclamation mark
        trie.insert(new int[]{8252}, new ParseResult(1, new SpriteCoordinates(8, 0, 463, 595))); // double exclamation mark
        trie.insert(new int[]{8265}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 595))); // exclamation question mark
        trie.insert(new int[]{8265, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 595))); // exclamation question mark
        trie.insert(new int[]{10067}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 265))); // red question mark
        trie.insert(new int[]{10068}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 265))); // white question mark
        trie.insert(new int[]{10069}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 199))); // white exclamation mark
        trie.insert(new int[]{10071}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 133))); // red exclamation mark
        trie.insert(new int[]{12336}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 67))); // wavy dash
        trie.insert(new int[]{12336, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 67))); // wavy dash
        trie.insert(new int[]{128177}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 397))); // currency exchange
        trie.insert(new int[]{128178}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 331))); // heavy dollar sign
        trie.insert(new int[]{9877, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 265))); // medical symbol
        trie.insert(new int[]{9877}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 265))); // medical symbol
        trie.insert(new int[]{9851}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 397))); // recycling symbol
        trie.insert(new int[]{9851, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 397))); // recycling symbol
        trie.insert(new int[]{9884, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 133))); // fleur-de-lis
        trie.insert(new int[]{9884}, new ParseResult(1, new SpriteCoordinates(8, 0, 397, 133))); // fleur-de-lis
        trie.insert(new int[]{128305}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 133))); // trident emblem
        trie.insert(new int[]{128219}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 265))); // name badge
        trie.insert(new int[]{128304}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 199))); // Japanese symbol for beginner
        trie.insert(new int[]{11093}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 1))); // hollow red circle
        trie.insert(new int[]{9989}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 331))); // check mark button
        trie.insert(new int[]{9745}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 67))); // check box with check
        trie.insert(new int[]{9745, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 67))); // check box with check
        trie.insert(new int[]{10004, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 331))); // check mark
        trie.insert(new int[]{10004}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 331))); // check mark
        trie.insert(new int[]{10060}, new ParseResult(1, new SpriteCoordinates(8, 0, 199, 265))); // cross mark
        trie.insert(new int[]{10062}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 265))); // cross mark button
        trie.insert(new int[]{10160}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 199))); // curly loop
        trie.insert(new int[]{10175}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 199))); // double curly loop
        trie.insert(new int[]{12349}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 67))); // part alternation mark
        trie.insert(new int[]{12349, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 67))); // part alternation mark
        trie.insert(new int[]{10035, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 67))); // eight-spoked asterisk
        trie.insert(new int[]{10035}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 67))); // eight-spoked asterisk
        trie.insert(new int[]{10036}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 1))); // eight-pointed star
        trie.insert(new int[]{10036, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 1))); // eight-pointed star
        trie.insert(new int[]{10055, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 265))); // sparkle
        trie.insert(new int[]{10055}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 265))); // sparkle
        trie.insert(new int[]{169, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 925))); // copyright
        trie.insert(new int[]{174, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 859))); // registered
        trie.insert(new int[]{8482, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 595))); // trade mark
        trie.insert(new int[]{35, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 793, 925))); // keycap: #
        trie.insert(new int[]{35, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 925))); // keycap: #
        trie.insert(new int[]{42, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 925))); // keycap: *
        trie.insert(new int[]{42, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 727, 925))); // keycap: *
        trie.insert(new int[]{48, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 661, 925))); // keycap: 0
        trie.insert(new int[]{48, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 925))); // keycap: 0
        trie.insert(new int[]{49, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 595, 925))); // keycap: 1
        trie.insert(new int[]{49, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 925))); // keycap: 1
        trie.insert(new int[]{50, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 529, 925))); // keycap: 2
        trie.insert(new int[]{50, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 925))); // keycap: 2
        trie.insert(new int[]{51, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 463, 925))); // keycap: 3
        trie.insert(new int[]{51, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 925))); // keycap: 3
        trie.insert(new int[]{52, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 925))); // keycap: 4
        trie.insert(new int[]{52, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 397, 925))); // keycap: 4
        trie.insert(new int[]{53, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 925))); // keycap: 5
        trie.insert(new int[]{53, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 331, 925))); // keycap: 5
        trie.insert(new int[]{54, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 925))); // keycap: 6
        trie.insert(new int[]{54, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 265, 925))); // keycap: 6
        trie.insert(new int[]{55, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 925))); // keycap: 7
        trie.insert(new int[]{55, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 199, 925))); // keycap: 7
        trie.insert(new int[]{56, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 133, 925))); // keycap: 8
        trie.insert(new int[]{56, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 925))); // keycap: 8
        trie.insert(new int[]{57, 65039, 8419}, new ParseResult(3, new SpriteCoordinates(8, 0, 67, 925))); // keycap: 9
        trie.insert(new int[]{57, 8419}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 925))); // keycap: 9
        trie.insert(new int[]{128287}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 661))); // keycap: 10
        trie.insert(new int[]{128288}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 595))); // input latin uppercase
        trie.insert(new int[]{128289}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 529))); // input latin lowercase
        trie.insert(new int[]{128290}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 463))); // input numbers
        trie.insert(new int[]{128291}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 397))); // input symbols
        trie.insert(new int[]{128292}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 331))); // input latin letters
        trie.insert(new int[]{127344}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 793))); // A button (blood type)
        trie.insert(new int[]{127344, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 925, 793))); // A button (blood type)
        trie.insert(new int[]{127374}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 529))); // AB button (blood type)
        trie.insert(new int[]{127345}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 727))); // B button (blood type)
        trie.insert(new int[]{127345, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 925, 727))); // B button (blood type)
        trie.insert(new int[]{127377}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 463))); // CL button
        trie.insert(new int[]{127378}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 397))); // COOL button
        trie.insert(new int[]{127379}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 331))); // FREE button
        trie.insert(new int[]{8505, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 595))); // information
        trie.insert(new int[]{8505}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 595))); // information
        trie.insert(new int[]{127380}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 265))); // ID button
        trie.insert(new int[]{9410}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 529))); // circled M
        trie.insert(new int[]{9410, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 529))); // circled M
        trie.insert(new int[]{127381}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 199))); // NEW button
        trie.insert(new int[]{127382}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 133))); // NG button
        trie.insert(new int[]{127358, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 925, 661))); // O button (blood type)
        trie.insert(new int[]{127358}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 661))); // O button (blood type)
        trie.insert(new int[]{127383}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 67))); // OK button
        trie.insert(new int[]{127359}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 595))); // P button
        trie.insert(new int[]{127359, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 925, 595))); // P button
        trie.insert(new int[]{127384}, new ParseResult(2, new SpriteCoordinates(8, 0, 925, 1))); // SOS button
        trie.insert(new int[]{127385}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 859))); // UP! button
        trie.insert(new int[]{127386}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 859))); // VS button
        trie.insert(new int[]{127489}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 859))); // Japanese “here” button
        trie.insert(new int[]{127490, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 661, 859))); // Japanese “service charge” button
        trie.insert(new int[]{127490}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 859))); // Japanese “service charge” button
        trie.insert(new int[]{127543}, new ParseResult(2, new SpriteCoordinates(8, 0, 133, 859))); // Japanese “monthly amount” button
        trie.insert(new int[]{127543, 65039}, new ParseResult(3, new SpriteCoordinates(8, 0, 133, 859))); // Japanese “monthly amount” button
        trie.insert(new int[]{127542}, new ParseResult(2, new SpriteCoordinates(8, 0, 199, 859))); // Japanese “not free of charge” button
        trie.insert(new int[]{127535}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 859))); // Japanese “reserved” button
        trie.insert(new int[]{127568}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 727))); // Japanese “bargain” button
        trie.insert(new int[]{127545}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 859))); // Japanese “discount” button
        trie.insert(new int[]{127514}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 859))); // Japanese “free of charge” button
        trie.insert(new int[]{127538}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 859))); // Japanese “prohibited” button
        trie.insert(new int[]{127569}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 661))); // Japanese “acceptable” button
        trie.insert(new int[]{127544}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 859))); // Japanese “application” button
        trie.insert(new int[]{127540}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 859))); // Japanese “passing grade” button
        trie.insert(new int[]{127539}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 859))); // Japanese “vacancy” button
        trie.insert(new int[]{12951, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 1))); // Japanese “congratulations” button
        trie.insert(new int[]{12951}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 1))); // Japanese “congratulations” button
        trie.insert(new int[]{12953}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 1))); // Japanese “secret” button
        trie.insert(new int[]{12953, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 1))); // Japanese “secret” button
        trie.insert(new int[]{127546}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 793))); // Japanese “open for business” button
        trie.insert(new int[]{127541}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 859))); // Japanese “no vacancy” button
        trie.insert(new int[]{128308}, new ParseResult(2, new SpriteCoordinates(8, 0, 727, 727))); // red circle
        trie.insert(new int[]{128992}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 661))); // orange circle
        trie.insert(new int[]{128993}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 661))); // yellow circle
        trie.insert(new int[]{128994}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 595))); // green circle
        trie.insert(new int[]{128309}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 727))); // blue circle
        trie.insert(new int[]{128995}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 529))); // purple circle
        trie.insert(new int[]{128996}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 463))); // brown circle
        trie.insert(new int[]{9899}, new ParseResult(1, new SpriteCoordinates(8, 0, 265, 331))); // black circle
        trie.insert(new int[]{9898}, new ParseResult(1, new SpriteCoordinates(8, 0, 331, 331))); // white circle
        trie.insert(new int[]{128997}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 397))); // red square
        trie.insert(new int[]{128999}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 265))); // orange square
        trie.insert(new int[]{129000}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 199))); // yellow square
        trie.insert(new int[]{129001}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 133))); // green square
        trie.insert(new int[]{128998}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 331))); // blue square
        trie.insert(new int[]{129002}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 67))); // purple square
        trie.insert(new int[]{129003}, new ParseResult(2, new SpriteCoordinates(8, 0, 661, 1))); // brown square
        trie.insert(new int[]{11035}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 133))); // black large square
        trie.insert(new int[]{11036}, new ParseResult(1, new SpriteCoordinates(8, 0, 133, 67))); // white large square
        trie.insert(new int[]{9724}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 265))); // black medium square
        trie.insert(new int[]{9724, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 265))); // black medium square
        trie.insert(new int[]{9723}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 331))); // white medium square
        trie.insert(new int[]{9723, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 331))); // white medium square
        trie.insert(new int[]{9726}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 133))); // black medium-small square
        trie.insert(new int[]{9725}, new ParseResult(1, new SpriteCoordinates(8, 0, 529, 199))); // white medium-small square
        trie.insert(new int[]{9642, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 67, 529))); // black small square
        trie.insert(new int[]{9642}, new ParseResult(1, new SpriteCoordinates(8, 0, 67, 529))); // black small square
        trie.insert(new int[]{9643}, new ParseResult(1, new SpriteCoordinates(8, 0, 1, 529))); // white small square
        trie.insert(new int[]{9643, 65039}, new ParseResult(2, new SpriteCoordinates(8, 0, 1, 529))); // white small square
        trie.insert(new int[]{128310}, new ParseResult(2, new SpriteCoordinates(8, 0, 595, 727))); // large orange diamond
        trie.insert(new int[]{128311}, new ParseResult(2, new SpriteCoordinates(8, 0, 529, 727))); // large blue diamond
        trie.insert(new int[]{128312}, new ParseResult(2, new SpriteCoordinates(8, 0, 463, 727))); // small orange diamond
        trie.insert(new int[]{128313}, new ParseResult(2, new SpriteCoordinates(8, 0, 397, 727))); // small blue diamond
        trie.insert(new int[]{128314}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 727))); // red triangle pointed up
        trie.insert(new int[]{128315}, new ParseResult(2, new SpriteCoordinates(8, 0, 265, 727))); // red triangle pointed down
        trie.insert(new int[]{128160}, new ParseResult(2, new SpriteCoordinates(8, 0, 859, 463))); // diamond with a dot
        trie.insert(new int[]{128280}, new ParseResult(2, new SpriteCoordinates(8, 0, 331, 793))); // radio button
        trie.insert(new int[]{128307}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 1))); // white square button
        trie.insert(new int[]{128306}, new ParseResult(2, new SpriteCoordinates(8, 0, 793, 67))); // black square button
        trie.insert(new int[]{127937}, new ParseResult(2, new SpriteCoordinates(9, 0, 133, 1))); // chequered flag
        trie.insert(new int[]{127884}, new ParseResult(2, new SpriteCoordinates(9, 0, 133, 67))); // crossed flags
        trie.insert(new int[]{127987, 65039}, new ParseResult(3, new SpriteCoordinates(9, 0, 1, 67))); // white flag
        trie.insert(new int[]{127987}, new ParseResult(2, new SpriteCoordinates(9, 0, 1, 67))); // white flag
        trie.insert(new int[]{127987, 8205, 9895, 65039}, new ParseResult(5, new SpriteCoordinates(9, 0, 67, 67))); // transgender flag
        trie.insert(new int[]{127987, 65039, 8205, 9895}, new ParseResult(5, new SpriteCoordinates(9, 0, 67, 67))); // transgender flag
        trie.insert(new int[]{127987, 65039, 8205, 9895, 65039}, new ParseResult(6, new SpriteCoordinates(9, 0, 67, 67))); // transgender flag
        trie.insert(new int[]{127987, 8205, 9895}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 67))); // transgender flag
        trie.insert(new int[]{127462, 127464}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 727))); // flag: Ascension Island
        trie.insert(new int[]{127462, 127466}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 727))); // flag: United Arab Emirates
        trie.insert(new int[]{127462, 127468}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 727))); // flag: Antigua & Barbuda
        trie.insert(new int[]{127462, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 661))); // flag: Albania
        trie.insert(new int[]{127462, 127476}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 595))); // flag: Angola
        trie.insert(new int[]{127462, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 529))); // flag: Argentina
        trie.insert(new int[]{127462, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 463))); // flag: Austria
        trie.insert(new int[]{127462, 127484}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 397))); // flag: Aruba
        trie.insert(new int[]{127462, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 331))); // flag: Azerbaijan
        trie.insert(new int[]{127463, 127463}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 265))); // flag: Barbados
        trie.insert(new int[]{127463, 127466}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 199))); // flag: Belgium
        trie.insert(new int[]{127463, 127468}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 133))); // flag: Bulgaria
        trie.insert(new int[]{127463, 127470}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 67))); // flag: Burundi
        trie.insert(new int[]{127463, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 727, 1))); // flag: St. Barthélemy
        trie.insert(new int[]{127463, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 661))); // flag: Brunei
        trie.insert(new int[]{127463, 127478}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 661))); // flag: Caribbean Netherlands
        trie.insert(new int[]{127463, 127480}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 661))); // flag: Bahamas
        trie.insert(new int[]{127463, 127483}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 661))); // flag: Bouvet Island
        trie.insert(new int[]{127463, 127486}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 661))); // flag: Belarus
        trie.insert(new int[]{127464, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 661))); // flag: Canada
        trie.insert(new int[]{127464, 127465}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 661))); // flag: Congo - Kinshasa
        trie.insert(new int[]{127464, 127468}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 661))); // flag: Congo - Brazzaville
        trie.insert(new int[]{127464, 127470}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 661))); // flag: Côte d’Ivoire
        trie.insert(new int[]{127464, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 661))); // flag: Chile
        trie.insert(new int[]{127464, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 661))); // flag: China
        trie.insert(new int[]{127464, 127477}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 595))); // flag: Clipperton Island
        trie.insert(new int[]{127464, 127482}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 529))); // flag: Cuba
        trie.insert(new int[]{127464, 127484}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 463))); // flag: Curaçao
        trie.insert(new int[]{127464, 127486}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 397))); // flag: Cyprus
        trie.insert(new int[]{127465, 127466}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 331))); // flag: Germany
        trie.insert(new int[]{127465, 127471}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 265))); // flag: Djibouti
        trie.insert(new int[]{127465, 127474}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 199))); // flag: Dominica
        trie.insert(new int[]{127465, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 133))); // flag: Algeria
        trie.insert(new int[]{127466, 127464}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 67))); // flag: Ecuador
        trie.insert(new int[]{127466, 127468}, new ParseResult(4, new SpriteCoordinates(9, 0, 661, 1))); // flag: Egypt
        trie.insert(new int[]{127466, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 595))); // flag: Eritrea
        trie.insert(new int[]{127466, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 595))); // flag: Ethiopia
        trie.insert(new int[]{127467, 127470}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 595))); // flag: Finland
        trie.insert(new int[]{127467, 127472}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 595))); // flag: Falkland Islands
        trie.insert(new int[]{127467, 127476}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 595))); // flag: Faroe Islands
        trie.insert(new int[]{127468, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 595))); // flag: Gabon
        trie.insert(new int[]{127468, 127465}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 595))); // flag: Grenada
        trie.insert(new int[]{127468, 127467}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 595))); // flag: French Guiana
        trie.insert(new int[]{127468, 127469}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 595))); // flag: Ghana
        trie.insert(new int[]{127468, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 595))); // flag: Greenland
        trie.insert(new int[]{127468, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 529))); // flag: Guinea
        trie.insert(new int[]{127468, 127478}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 463))); // flag: Equatorial Guinea
        trie.insert(new int[]{127468, 127480}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 397))); // flag: South Georgia & South Sandwich Islands
        trie.insert(new int[]{127468, 127482}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 331))); // flag: Guam
        trie.insert(new int[]{127468, 127486}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 265))); // flag: Guyana
        trie.insert(new int[]{127469, 127474}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 199))); // flag: Heard & McDonald Islands
        trie.insert(new int[]{127469, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 133))); // flag: Croatia
        trie.insert(new int[]{127469, 127482}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 67))); // flag: Hungary
        trie.insert(new int[]{127470, 127465}, new ParseResult(4, new SpriteCoordinates(9, 0, 595, 1))); // flag: Indonesia
        trie.insert(new int[]{127470, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 529))); // flag: Israel
        trie.insert(new int[]{127470, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 529))); // flag: India
        trie.insert(new int[]{127470, 127478}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 529))); // flag: Iraq
        trie.insert(new int[]{127470, 127480}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 529))); // flag: Iceland
        trie.insert(new int[]{127471, 127466}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 529))); // flag: Jersey
        trie.insert(new int[]{127471, 127476}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 529))); // flag: Jordan
        trie.insert(new int[]{127472, 127466}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 529))); // flag: Kenya
        trie.insert(new int[]{127472, 127469}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 529))); // flag: Cambodia
        trie.insert(new int[]{127472, 127474}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 529))); // flag: Comoros
        trie.insert(new int[]{127472, 127477}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 463))); // flag: North Korea
        trie.insert(new int[]{127472, 127484}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 397))); // flag: Kuwait
        trie.insert(new int[]{127472, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 331))); // flag: Kazakhstan
        trie.insert(new int[]{127473, 127463}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 265))); // flag: Lebanon
        trie.insert(new int[]{127473, 127470}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 199))); // flag: Liechtenstein
        trie.insert(new int[]{127473, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 133))); // flag: Liberia
        trie.insert(new int[]{127473, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 67))); // flag: Lithuania
        trie.insert(new int[]{127473, 127483}, new ParseResult(4, new SpriteCoordinates(9, 0, 529, 1))); // flag: Latvia
        trie.insert(new int[]{127474, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 463))); // flag: Morocco
        trie.insert(new int[]{127474, 127465}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 463))); // flag: Moldova
        trie.insert(new int[]{127474, 127467}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 463))); // flag: St. Martin
        trie.insert(new int[]{127474, 127469}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 463))); // flag: Marshall Islands
        trie.insert(new int[]{127474, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 463))); // flag: Mali
        trie.insert(new int[]{127474, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 463))); // flag: Mongolia
        trie.insert(new int[]{127474, 127477}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 463))); // flag: Northern Mariana Islands
        trie.insert(new int[]{127474, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 463))); // flag: Mauritania
        trie.insert(new int[]{127474, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 397))); // flag: Malta
        trie.insert(new int[]{127474, 127483}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 331))); // flag: Maldives
        trie.insert(new int[]{127474, 127485}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 265))); // flag: Mexico
        trie.insert(new int[]{127474, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 199))); // flag: Mozambique
        trie.insert(new int[]{127475, 127464}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 133))); // flag: New Caledonia
        trie.insert(new int[]{127475, 127467}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 67))); // flag: Norfolk Island
        trie.insert(new int[]{127475, 127470}, new ParseResult(4, new SpriteCoordinates(9, 0, 463, 1))); // flag: Nicaragua
        trie.insert(new int[]{127475, 127476}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 397))); // flag: Norway
        trie.insert(new int[]{127475, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 397))); // flag: Nauru
        trie.insert(new int[]{127475, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 397))); // flag: New Zealand
        trie.insert(new int[]{127477, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 397))); // flag: Panama
        trie.insert(new int[]{127477, 127467}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 397))); // flag: French Polynesia
        trie.insert(new int[]{127477, 127469}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 397))); // flag: Philippines
    }

    public static void init13(IntTrie<ParseResult> trie) {
        trie.insert(new int[]{127477, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 397))); // flag: Poland
        trie.insert(new int[]{127477, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 331))); // flag: Pitcairn Islands
        trie.insert(new int[]{127477, 127480}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 265))); // flag: Palestinian Territories
        trie.insert(new int[]{127477, 127484}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 199))); // flag: Palau
        trie.insert(new int[]{127478, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 133))); // flag: Qatar
        trie.insert(new int[]{127479, 127476}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 67))); // flag: Romania
        trie.insert(new int[]{127479, 127482}, new ParseResult(4, new SpriteCoordinates(9, 0, 397, 1))); // flag: Russia
        trie.insert(new int[]{127480, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 331))); // flag: Saudi Arabia
        trie.insert(new int[]{127480, 127464}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 331))); // flag: Seychelles
        trie.insert(new int[]{127480, 127466}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 331))); // flag: Sweden
        trie.insert(new int[]{127480, 127469}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 331))); // flag: St. Helena
        trie.insert(new int[]{127480, 127471}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 331))); // flag: Svalbard & Jan Mayen
        trie.insert(new int[]{127480, 127473}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 331))); // flag: Sierra Leone
        trie.insert(new int[]{127480, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 265))); // flag: Senegal
        trie.insert(new int[]{127480, 127479}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 199))); // flag: Suriname
        trie.insert(new int[]{127480, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 133))); // flag: São Tomé & Príncipe
        trie.insert(new int[]{127480, 127485}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 67))); // flag: Sint Maarten
        trie.insert(new int[]{127480, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 331, 1))); // flag: Eswatini
        trie.insert(new int[]{127481, 127464}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 265))); // flag: Turks & Caicos Islands
        trie.insert(new int[]{127481, 127467}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 265))); // flag: French Southern Territories
        trie.insert(new int[]{127481, 127469}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 265))); // flag: Thailand
        trie.insert(new int[]{127481, 127472}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 265))); // flag: Tokelau
        trie.insert(new int[]{127481, 127474}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 265))); // flag: Turkmenistan
        trie.insert(new int[]{127481, 127476}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 199))); // flag: Tonga
        trie.insert(new int[]{127481, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 133))); // flag: Trinidad & Tobago
        trie.insert(new int[]{127481, 127484}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 67))); // flag: Taiwan
        trie.insert(new int[]{127482, 127462}, new ParseResult(4, new SpriteCoordinates(9, 0, 265, 1))); // flag: Ukraine
        trie.insert(new int[]{127482, 127474}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 199))); // flag: U.S. Outlying Islands
        trie.insert(new int[]{127482, 127480}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 199))); // flag: United States
        trie.insert(new int[]{127482, 127487}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 199))); // flag: Uzbekistan
        trie.insert(new int[]{127483, 127464}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 199))); // flag: St. Vincent & Grenadines
        trie.insert(new int[]{127483, 127468}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 133))); // flag: British Virgin Islands
        trie.insert(new int[]{127483, 127475}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 67))); // flag: Vietnam
        trie.insert(new int[]{127484, 127467}, new ParseResult(4, new SpriteCoordinates(9, 0, 199, 1))); // flag: Wallis & Futuna
        trie.insert(new int[]{127485, 127472}, new ParseResult(4, new SpriteCoordinates(9, 0, 133, 133))); // flag: Kosovo
        trie.insert(new int[]{127486, 127481}, new ParseResult(4, new SpriteCoordinates(9, 0, 67, 133))); // flag: Mayotte
        trie.insert(new int[]{127487, 127474}, new ParseResult(4, new SpriteCoordinates(9, 0, 1, 133))); // flag: Zambia
        trie.insert(new int[]{127988, 917607, 917602, 917605, 917614, 917607, 917631}, new ParseResult(14, new SpriteCoordinates(9, 0, 67, 1))); // flag: England
        trie.insert(new int[]{127988, 917607, 917602, 917623, 917612, 917619, 917631}, new ParseResult(14, new SpriteCoordinates(9, 0, 1, 1))); // flag: Wales
        trie.insert(new int[]{128681}, new ParseResult(2, new SpriteCoordinates(9, 1, 1, 1))); // triangular flag
        trie.insert(new int[]{127988}, new ParseResult(2, new SpriteCoordinates(9, 1, 67, 1))); // black flag
        trie.insert(new int[]{127987, 8205, 127752}, new ParseResult(5, new SpriteCoordinates(9, 1, 133, 1))); // rainbow flag
        trie.insert(new int[]{127987, 65039, 8205, 127752}, new ParseResult(6, new SpriteCoordinates(9, 1, 133, 1))); // rainbow flag
        trie.insert(new int[]{127988, 8205, 9760}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 67))); // pirate flag
        trie.insert(new int[]{127988, 8205, 9760, 65039}, new ParseResult(5, new SpriteCoordinates(9, 1, 67, 67))); // pirate flag
        trie.insert(new int[]{127462, 127465}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 727))); // flag: Andorra
        trie.insert(new int[]{127462, 127467}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 727))); // flag: Afghanistan
        trie.insert(new int[]{127462, 127470}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 661))); // flag: Anguilla
        trie.insert(new int[]{127462, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 595))); // flag: Armenia
        trie.insert(new int[]{127462, 127478}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 529))); // flag: Antarctica
        trie.insert(new int[]{127462, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 463))); // flag: American Samoa
        trie.insert(new int[]{127462, 127482}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 397))); // flag: Australia
        trie.insert(new int[]{127462, 127485}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 331))); // flag: Åland Islands
        trie.insert(new int[]{127463, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 265))); // flag: Bosnia & Herzegovina
        trie.insert(new int[]{127463, 127465}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 199))); // flag: Bangladesh
        trie.insert(new int[]{127463, 127467}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 133))); // flag: Burkina Faso
        trie.insert(new int[]{127463, 127469}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 67))); // flag: Bahrain
        trie.insert(new int[]{127463, 127471}, new ParseResult(4, new SpriteCoordinates(9, 1, 727, 1))); // flag: Benin
        trie.insert(new int[]{127463, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 661))); // flag: Bermuda
        trie.insert(new int[]{127463, 127476}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 661))); // flag: Bolivia
        trie.insert(new int[]{127463, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 661))); // flag: Brazil
        trie.insert(new int[]{127463, 127481}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 661))); // flag: Bhutan
        trie.insert(new int[]{127463, 127484}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 661))); // flag: Botswana
        trie.insert(new int[]{127463, 127487}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 661))); // flag: Belize
        trie.insert(new int[]{127464, 127464}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 661))); // flag: Cocos (Keeling) Islands
        trie.insert(new int[]{127464, 127467}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 661))); // flag: Central African Republic
        trie.insert(new int[]{127464, 127469}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 661))); // flag: Switzerland
        trie.insert(new int[]{127464, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 661))); // flag: Cook Islands
        trie.insert(new int[]{127464, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 661))); // flag: Cameroon
        trie.insert(new int[]{127464, 127476}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 595))); // flag: Colombia
        trie.insert(new int[]{127464, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 529))); // flag: Costa Rica
        trie.insert(new int[]{127464, 127483}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 463))); // flag: Cape Verde
        trie.insert(new int[]{127464, 127485}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 397))); // flag: Christmas Island
        trie.insert(new int[]{127464, 127487}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 331))); // flag: Czechia
        trie.insert(new int[]{127465, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 265))); // flag: Diego Garcia
        trie.insert(new int[]{127465, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 199))); // flag: Denmark
        trie.insert(new int[]{127465, 127476}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 133))); // flag: Dominican Republic
        trie.insert(new int[]{127466, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 67))); // flag: Ceuta & Melilla
        trie.insert(new int[]{127466, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 661, 1))); // flag: Estonia
        trie.insert(new int[]{127466, 127469}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 595))); // flag: Western Sahara
        trie.insert(new int[]{127466, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 595))); // flag: Spain
        trie.insert(new int[]{127466, 127482}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 595))); // flag: European Union
        trie.insert(new int[]{127467, 127471}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 595))); // flag: Fiji
        trie.insert(new int[]{127467, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 595))); // flag: Micronesia
        trie.insert(new int[]{127467, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 595))); // flag: France
        trie.insert(new int[]{127468, 127463}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 595))); // flag: United Kingdom
        trie.insert(new int[]{127468, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 595))); // flag: Georgia
        trie.insert(new int[]{127468, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 595))); // flag: Guernsey
        trie.insert(new int[]{127468, 127470}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 595))); // flag: Gibraltar
        trie.insert(new int[]{127468, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 529))); // flag: Gambia
        trie.insert(new int[]{127468, 127477}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 463))); // flag: Guadeloupe
        trie.insert(new int[]{127468, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 397))); // flag: Greece
        trie.insert(new int[]{127468, 127481}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 331))); // flag: Guatemala
        trie.insert(new int[]{127468, 127484}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 265))); // flag: Guinea-Bissau
        trie.insert(new int[]{127469, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 199))); // flag: Hong Kong SAR China
        trie.insert(new int[]{127469, 127475}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 133))); // flag: Honduras
        trie.insert(new int[]{127469, 127481}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 67))); // flag: Haiti
        trie.insert(new int[]{127470, 127464}, new ParseResult(4, new SpriteCoordinates(9, 1, 595, 1))); // flag: Canary Islands
        trie.insert(new int[]{127470, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 529))); // flag: Ireland
        trie.insert(new int[]{127470, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 529))); // flag: Isle of Man
        trie.insert(new int[]{127470, 127476}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 529))); // flag: British Indian Ocean Territory
        trie.insert(new int[]{127470, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 529))); // flag: Iran
        trie.insert(new int[]{127470, 127481}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 529))); // flag: Italy
        trie.insert(new int[]{127471, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 529))); // flag: Jamaica
        trie.insert(new int[]{127471, 127477}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 529))); // flag: Japan
        trie.insert(new int[]{127472, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 529))); // flag: Kyrgyzstan
        trie.insert(new int[]{127472, 127470}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 529))); // flag: Kiribati
        trie.insert(new int[]{127472, 127475}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 463))); // flag: St. Kitts & Nevis
        trie.insert(new int[]{127472, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 397))); // flag: South Korea
        trie.insert(new int[]{127472, 127486}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 331))); // flag: Cayman Islands
        trie.insert(new int[]{127473, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 265))); // flag: Laos
        trie.insert(new int[]{127473, 127464}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 199))); // flag: St. Lucia
        trie.insert(new int[]{127473, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 133))); // flag: Sri Lanka
        trie.insert(new int[]{127473, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 67))); // flag: Lesotho
        trie.insert(new int[]{127473, 127482}, new ParseResult(4, new SpriteCoordinates(9, 1, 529, 1))); // flag: Luxembourg
        trie.insert(new int[]{127473, 127486}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 463))); // flag: Libya
        trie.insert(new int[]{127474, 127464}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 463))); // flag: Monaco
        trie.insert(new int[]{127474, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 463))); // flag: Montenegro
        trie.insert(new int[]{127474, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 463))); // flag: Madagascar
        trie.insert(new int[]{127474, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 463))); // flag: North Macedonia
        trie.insert(new int[]{127474, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 463))); // flag: Myanmar (Burma)
        trie.insert(new int[]{127474, 127476}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 463))); // flag: Macao SAR China
        trie.insert(new int[]{127474, 127478}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 463))); // flag: Martinique
        trie.insert(new int[]{127474, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 397))); // flag: Montserrat
        trie.insert(new int[]{127474, 127482}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 331))); // flag: Mauritius
        trie.insert(new int[]{127474, 127484}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 265))); // flag: Malawi
        trie.insert(new int[]{127474, 127486}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 199))); // flag: Malaysia
        trie.insert(new int[]{127475, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 133))); // flag: Namibia
        trie.insert(new int[]{127475, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 67))); // flag: Niger
        trie.insert(new int[]{127475, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 463, 1))); // flag: Nigeria
        trie.insert(new int[]{127475, 127473}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 397))); // flag: Netherlands
        trie.insert(new int[]{127475, 127477}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 397))); // flag: Nepal
        trie.insert(new int[]{127475, 127482}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 397))); // flag: Niue
        trie.insert(new int[]{127476, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 397))); // flag: Oman
        trie.insert(new int[]{127477, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 397))); // flag: Peru
        trie.insert(new int[]{127477, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 397))); // flag: Papua New Guinea
        trie.insert(new int[]{127477, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 397))); // flag: Pakistan
        trie.insert(new int[]{127477, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 331))); // flag: St. Pierre & Miquelon
        trie.insert(new int[]{127477, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 265))); // flag: Puerto Rico
        trie.insert(new int[]{127477, 127481}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 199))); // flag: Portugal
        trie.insert(new int[]{127477, 127486}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 133))); // flag: Paraguay
        trie.insert(new int[]{127479, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 67))); // flag: Réunion
        trie.insert(new int[]{127479, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 397, 1))); // flag: Serbia
        trie.insert(new int[]{127479, 127484}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 331))); // flag: Rwanda
        trie.insert(new int[]{127480, 127463}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 331))); // flag: Solomon Islands
        trie.insert(new int[]{127480, 127465}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 331))); // flag: Sudan
        trie.insert(new int[]{127480, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 331))); // flag: Singapore
        trie.insert(new int[]{127480, 127470}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 331))); // flag: Slovenia
        trie.insert(new int[]{127480, 127472}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 331))); // flag: Slovakia
        trie.insert(new int[]{127480, 127474}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 265))); // flag: San Marino
        trie.insert(new int[]{127480, 127476}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 199))); // flag: Somalia
        trie.insert(new int[]{127480, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 133))); // flag: South Sudan
        trie.insert(new int[]{127480, 127483}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 67))); // flag: El Salvador
        trie.insert(new int[]{127480, 127486}, new ParseResult(4, new SpriteCoordinates(9, 1, 331, 1))); // flag: Syria
        trie.insert(new int[]{127481, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 265))); // flag: Tristan da Cunha
        trie.insert(new int[]{127481, 127465}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 265))); // flag: Chad
        trie.insert(new int[]{127481, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 265))); // flag: Togo
        trie.insert(new int[]{127481, 127471}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 265))); // flag: Tajikistan
        trie.insert(new int[]{127481, 127473}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 265))); // flag: Timor-Leste
        trie.insert(new int[]{127481, 127475}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 199))); // flag: Tunisia
        trie.insert(new int[]{127481, 127479}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 133))); // flag: Türkiye
        trie.insert(new int[]{127481, 127483}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 67))); // flag: Tuvalu
        trie.insert(new int[]{127481, 127487}, new ParseResult(4, new SpriteCoordinates(9, 1, 265, 1))); // flag: Tanzania
        trie.insert(new int[]{127482, 127468}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 199))); // flag: Uganda
        trie.insert(new int[]{127482, 127475}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 199))); // flag: United Nations
        trie.insert(new int[]{127482, 127486}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 199))); // flag: Uruguay
        trie.insert(new int[]{127483, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 199))); // flag: Vatican City
        trie.insert(new int[]{127483, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 133))); // flag: Venezuela
        trie.insert(new int[]{127483, 127470}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 67))); // flag: U.S. Virgin Islands
        trie.insert(new int[]{127483, 127482}, new ParseResult(4, new SpriteCoordinates(9, 1, 199, 1))); // flag: Vanuatu
        trie.insert(new int[]{127484, 127480}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 133))); // flag: Samoa
        trie.insert(new int[]{127486, 127466}, new ParseResult(4, new SpriteCoordinates(9, 1, 67, 133))); // flag: Yemen
        trie.insert(new int[]{127487, 127462}, new ParseResult(4, new SpriteCoordinates(9, 1, 1, 133))); // flag: South Africa
        trie.insert(new int[]{127487, 127484}, new ParseResult(4, new SpriteCoordinates(9, 1, 133, 67))); // flag: Zimbabwe
        trie.insert(new int[]{127988, 917607, 917602, 917619, 917603, 917620, 917631}, new ParseResult(14, new SpriteCoordinates(9, 1, 1, 67))); // flag: Scotland
    }


    /**
     * Greedily process the char sequence and try to find an emoji at the
     * specified index.
     * <p>
     * The first time this static method is called, the parse trie will be initialized.
     */
    @Nullable
    public static ParseResult parseAt(CharSequence charSequence, int index) {
        EmojiParser.init();

        ParseResult lastFound = null;

        // Process codepoints
        List<Integer> codepoints = new ArrayList<>();
        int i = 0;
        while (true) {
            int codepoint;
            try {
                codepoint = Character.codePointAt(charSequence, index + i);
                codepoints.add(codepoint);
            } catch (IndexOutOfBoundsException e) {
                // We're at the end of the char sequence
                return lastFound;
            }
            final IntTrie.Value<ParseResult> value = EmojiParser.trie.get(codepoints);
            if (value == null) {
                // Unkown path
                return lastFound;
            }
            if (value.getValue() != null) {
                // This is a valid path
                lastFound = value.getValue();
            }
            if (value.isLeaf()) {
                // We're done!
                return lastFound;
            }
            i += Character.charCount(codepoint);
        }
    }

}
