"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getParams = void 0;
var cross_fetch_1 = __importDefault(require("cross-fetch"));
var query_string_1 = __importDefault(require("query-string"));
var decodelnurl_1 = require("./helpers/decodelnurl");
var getDomain_1 = require("./helpers/getDomain");
function getParams(lnurl) {
    return __awaiter(this, void 0, void 0, function () {
        var url, spl, params, r, _a, res, err_1, err_2;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    try {
                        url = (0, decodelnurl_1.decodelnurl)(lnurl);
                    }
                    catch (err) {
                        return [2 /*return*/, {
                                status: 'ERROR',
                                reason: "invalid lnurl '".concat(lnurl, "'")
                            }];
                    }
                    spl = url.split('?');
                    if (spl.length > 1) {
                        params = query_string_1.default.parse(spl[1]);
                        if (params.tag === 'login') {
                            return [2 /*return*/, {
                                    tag: 'login',
                                    k1: params.k1,
                                    callback: url,
                                    domain: (0, getDomain_1.getDomain)(url)
                                }];
                        }
                        else if (params.tag === 'withdrawRequest' &&
                            params.k1 &&
                            params.callback) {
                            return [2 /*return*/, __assign(__assign({}, params), { domain: (0, getDomain_1.getDomain)(params.callback) })];
                        }
                    }
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 9, , 10]);
                    return [4 /*yield*/, (0, cross_fetch_1.default)(url)];
                case 2:
                    r = _b.sent();
                    if (!(r.status >= 300)) return [3 /*break*/, 4];
                    _a = Error.bind;
                    return [4 /*yield*/, r.text()];
                case 3: throw new (_a.apply(Error, [void 0, _b.sent()]))();
                case 4:
                    res = void 0;
                    _b.label = 5;
                case 5:
                    _b.trys.push([5, 7, , 8]);
                    return [4 /*yield*/, r.json()];
                case 6:
                    res = _b.sent();
                    return [3 /*break*/, 8];
                case 7:
                    err_1 = _b.sent();
                    throw new Error('(invalid JSON)');
                case 8:
                    if (res.callback) {
                        res.domain = (0, getDomain_1.getDomain)(res.callback);
                    }
                    switch (res.tag) {
                        case 'withdrawRequest':
                            return [2 /*return*/, res];
                            break;
                        case 'payRequest':
                            try {
                                res.decodedMetadata = JSON.parse(res.metadata);
                            }
                            catch (err) {
                                res.decodedMetadata = [];
                            }
                            res.commentAllowed =
                                typeof res.commentAllowed === 'number' ? res.commentAllowed : 0;
                            return [2 /*return*/, res];
                        case 'channelRequest':
                            return [2 /*return*/, res];
                        default:
                            if (res.status === 'ERROR') {
                                return [2 /*return*/, __assign(__assign({}, res), { domain: (0, getDomain_1.getDomain)(url), url: url })];
                            }
                            throw new Error('unknown tag: ' + res.tag);
                    }
                    return [3 /*break*/, 10];
                case 9:
                    err_2 = _b.sent();
                    return [2 /*return*/, {
                            status: 'ERROR',
                            reason: "".concat(url, " returned error: ").concat(err_2.message),
                            url: url,
                            domain: (0, getDomain_1.getDomain)(url)
                        }];
                case 10: return [2 /*return*/];
            }
        });
    });
}
exports.getParams = getParams;
