"use strict";
/** @format */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.decipherAES = void 0;
var aes_js_1 = __importDefault(require("aes-js"));
var base64_js_1 = __importDefault(require("base64-js"));
function decipherAES(sa, preimage) {
    if (sa.tag !== 'aes') {
        return '';
    }
    var key = aes_js_1.default.utils.hex.toBytes(preimage);
    var iv = base64_js_1.default.toByteArray(sa.iv);
    var ciphertext = base64_js_1.default.toByteArray(sa.ciphertext);
    var CBC = new aes_js_1.default.ModeOfOperation.cbc(key, iv);
    var plaintext = CBC.decrypt(ciphertext);
    // remove padding
    var size = plaintext.length;
    var pad = plaintext[size - 1];
    plaintext = plaintext.slice(0, size - pad);
    return aes_js_1.default.utils.utf8.fromBytes(plaintext);
}
exports.decipherAES = decipherAES;
