<a href="https://nbd.wtf"><img align="right" height="196" src="https://user-images.githubusercontent.com/1653275/194609043-0add674b-dd40-41ed-986c-ab4a2e053092.png" /></a>

js-lnurl
========

Tools for adding [lnurl](https://github.com/fiatjaf/lnurl-rfc) support in JavaScript wallet interfaces.

### Example

```js
import { getParams } from 'js-lnurl'

getParams("LNURL1...")
  .then(params => {
    switch (params.tag) {
      case 'withdrawRequest':
        // tag: string
        // k1: string
        // callback: string
        // domain: string
        // minWithdrawable: number
        // maxWithdrawable: number
        // defaultDescription: string
        break
      case 'payRequest':
        // tag: string
        // callback: string
        // domain: string
        // minSendable: number
        // maxSendable: number
        // metadata: string
        // decodedMetadata: string[][]
        // commentAllowed?: number
        break
      case 'login':
        // tag: string
        // k1: string
        // callback: string
        // domain: string
        break
      case 'channelRequest':
        // params.tag: string
        // params.callback: string
        // params.domain: string
        // params.k1: string
        // params.uri: string
        break
    }
  })
```

### Other included helpers

```js
import {
  findlnurl,
  decodelnurl,
  decipherAES,
  getDomain
} from 'js-lnurl/lib/helpers'
// or
import {findlnurl} from 'js-lnurl/lib/helpers/findlnurl'
import {decodelnurl} from 'js-lnurl/lib/helpers/decodelnurl'
import {decipherAES} from 'js-lnurl/lib/helpers/decipherAES'
import {getDomain} from 'js-lnurl/lib/helpers/getDomain'

// see src/helpers/*.ts
```

## How to build

Do this before publishing to npm:

```
yarn
make
```
