/**
 * formatter.js
 */
/// <reference types="node" />
import TypedArray = NodeJS.TypedArray;
type SupportedPemTypes = 'public' | 'private' | 'encryptedPrivate' | 'certificate' | 'certRequest';
/**
 * Convert PEM armored string to Uint8Array
 * @param keydataB64Pem
 * @return {Uint8Array}
 */
export declare const pemToBin: (keydataB64Pem: string) => Uint8Array | string;
/**
 * Convert ArrayBuffer or TypedArray to PEM armored string with a specified type
 * @param keydata
 * @param type
 * @return {string}
 */
export declare const binToPem: (keydata: ArrayBuffer | TypedArray, type: SupportedPemTypes) => string;
export {};
