/**
 * index.js
 **/
/**
 * Obtain require(crypto) in Node.js environment.
 * @return {undefined|Object} - Node.js crypto object
 */
declare const getNodeCrypto: () => undefined | any;
/**
 * Obtain window.crypto.subtle object in browser environments.
 * @return {undefined|Object} - WebCrypto API object
 */
declare const getWebCrypto: () => undefined | any;
/**
 * Obtain window.crypto object in browser environments.
 * @return {undefined|Object} - WebCrypto API object
 */
declare const getRootWebCrypto: () => undefined | any;
/**
 * Get native crypto lib name.
 * @return {name: 'webCrypto'|'nodeCrypto'|undefined, crypto?: any}
 */
declare const getCrypto: () => {
    name: 'webCrypto' | 'nodeCrypto' | undefined;
    crypto?: any;
};
declare const _default: {
    getNodeCrypto: () => any;
    getWebCrypto: () => any;
    getRootWebCrypto: () => any;
    getCrypto: () => {
        name: "webCrypto" | "nodeCrypto" | undefined;
        crypto?: any;
    };
};
export default _default;
export { getNodeCrypto, getWebCrypto, getRootWebCrypto, getCrypto };
