import { abool as assertBool } from "@noble/curves/abstract/utils";
import { abytes as assertBytes } from "@noble/hashes/_assert";
import { hexToBytes as _hexToBytes } from "@noble/hashes/utils";
export { bytesToHex, concatBytes, createView, bytesToHex as toHex, utf8ToBytes } from "@noble/hashes/utils";
export { assertBool, assertBytes };
// buf.toString('utf8') -> bytesToUtf8(buf)
export function bytesToUtf8(data) {
    if (!(data instanceof Uint8Array)) {
        throw new TypeError(`bytesToUtf8 expected Uint8Array, got ${typeof data}`);
    }
    return new TextDecoder().decode(data);
}
export function hexToBytes(data) {
    const sliced = data.startsWith("0x") ? data.substring(2) : data;
    return _hexToBytes(sliced);
}
// buf.equals(buf2) -> equalsBytes(buf, buf2)
export function equalsBytes(a, b) {
    if (a.length !== b.length) {
        return false;
    }
    for (let i = 0; i < a.length; i++) {
        if (a[i] !== b[i]) {
            return false;
        }
    }
    return true;
}
// Internal utils
export function wrapHash(hash) {
    return (msg) => {
        assertBytes(msg);
        return hash(msg);
    };
}
