"use strict";

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var path = require('path');

var isAliasPath = require('../helpers/is-alias-path');

var entries = Object.entries || function (obj) {
  return Object.keys(obj).map(function (key) {
    return [key, obj[key]];
  });
};

var createFixer = function createFixer() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var alias = options.alias,
      filePath = options.filePath,
      cwd = options.cwd,
      _options$node = options.node,
      node = _options$node === void 0 ? {} : _options$node;
  var source = node.source; // ImportDeclaration or ImportExpression

  if (Array.isArray(node.arguments)) {
    source = node.arguments[0]; // CallExpression
  }

  if (!source) return null;
  var aliasPaths = entries(alias).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        key = _ref2[0],
        value = _ref2[1];

    return [key, path.join(cwd, value)];
  });
  var resolvedPath = path.resolve(filePath, source.value);

  var _ref3 = aliasPaths.find(function (_ref5) {
    var _ref6 = _slicedToArray(_ref5, 2),
        _ = _ref6[0],
        aliasPath = _ref6[1];

    return isAliasPath(resolvedPath, aliasPath);
  }) || [],
      _ref4 = _slicedToArray(_ref3, 2),
      aliasMatch = _ref4[0],
      aliasPath = _ref4[1];

  if (!aliasMatch || !aliasPath) return null;
  var newPath = resolvedPath.replace(aliasPath, '');
  var replacement = path.normalize(path.join(aliasMatch, newPath)).replace(/\\/g, '/').replace(/\/c:/gi, '');
  return function (fixer) {
    return fixer.replaceTextRange([source.range[0] + 1, source.range[1] - 1], replacement);
  };
};

module.exports = createFixer;