# Installation
> `npm install --save @types/react-native-material-ripple`

# Summary
This package contains type definitions for react-native-material-ripple (https://github.com/n4kz/react-native-material-ripple).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-native-material-ripple.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-native-material-ripple/index.d.ts)
````ts
import * as React from "react";
import { Animated, TouchableWithoutFeedback, ViewProps } from "react-native";

export type RippleProps =
    & TouchableWithoutFeedback["props"]
    & Animated.AnimatedProps<ViewProps>
    & {
        rippleColor?: string | undefined;
        rippleOpacity?: number | undefined;
        rippleDuration?: number | undefined;
        rippleSize?: number | undefined;
        rippleContainerBorderRadius?: number | undefined;
        rippleCentered?: boolean | undefined;
        rippleSequential?: boolean | undefined;
        rippleFades?: boolean | undefined;
        disabled?: boolean | undefined;
        onRippleAnimation?(animation: Animated.CompositeAnimation, callback: () => void): void;
    };

export default class Ripple extends React.Component<RippleProps> {}

````

### Additional Details
 * Last updated: Thu, 21 Dec 2023 19:06:51 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react), [react-native](https://npmjs.com/package/react-native)

# Credits
These definitions were written by [Serhiy Zhelizniak](https://github.com/SerhiyZheliznjak).
