import { createDeferred } from './createDeferred';
export const resolveAfter = (msec, signal, value) => {
    const { promise, reject, resolve } = createDeferred();
    const timeout = setTimeout(resolve, msec, value);
    const onAbort = () => reject(signal?.reason);
    signal?.addEventListener('abort', onAbort);
    if (signal?.aborted)
        onAbort();
    return promise.finally(() => {
        clearTimeout(timeout);
        signal?.removeEventListener('abort', onAbort);
    });
};
//# sourceMappingURL=resolveAfter.js.map