"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveAfter = void 0;
const createDeferred_1 = require("./createDeferred");
const resolveAfter = (msec, signal, value) => {
    const { promise, reject, resolve } = (0, createDeferred_1.createDeferred)();
    const timeout = setTimeout(resolve, msec, value);
    const onAbort = () => reject(signal?.reason);
    signal?.addEventListener('abort', onAbort);
    if (signal?.aborted)
        onAbort();
    return promise.finally(() => {
        clearTimeout(timeout);
        signal?.removeEventListener('abort', onAbort);
    });
};
exports.resolveAfter = resolveAfter;
//# sourceMappingURL=resolveAfter.js.map