"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isApproximatelyEqual = void 0;
const bigNumber_1 = require("./bigNumber");
const isApproximatelyEqual = (value1, value2, relativeTolerance) => {
    value1 = new bigNumber_1.BigNumber(value1);
    value2 = new bigNumber_1.BigNumber(value2);
    relativeTolerance = new bigNumber_1.BigNumber(relativeTolerance);
    if (value1.eq(0))
        return value1.eq(value2);
    const relativeDifference = value2.minus(value1).abs().dividedBy(value1);
    return relativeDifference.lte(relativeTolerance);
};
exports.isApproximatelyEqual = isApproximatelyEqual;
//# sourceMappingURL=isApproximatelyEqual.js.map