"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UdpTransport = void 0;
const abstract_1 = require("./abstract");
const errors_1 = require("../errors");
const result_1 = require("../utils/result");
const empty = () => Promise.resolve((0, result_1.error)({ error: errors_1.WRONG_ENVIRONMENT }));
const emptySync = () => (0, result_1.error)({ error: errors_1.WRONG_ENVIRONMENT });
class UdpTransport extends abstract_1.AbstractTransport {
    name = 'UdpTransport';
    apiType = 'udp';
    init = empty;
    acquire = empty;
    enumerate = empty;
    call = empty;
    receive = empty;
    send = empty;
    release = empty;
    stop = empty;
    releaseDevice = empty;
    releaseSync = emptySync;
    listen = emptySync;
}
exports.UdpTransport = UdpTransport;
//# sourceMappingURL=udp.browser.js.map