"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBitcoinOnlyDevice = exports.hasBitcoinOnlyFirmware = exports.getFirmwareVersion = exports.getFirmwareVersionArray = exports.getFirmwareRevision = exports.getFirmwareSource = void 0;
const modeUtils_1 = require("./modeUtils");
const types_1 = require("./types");
const getFirmwareSource = (device) => {
    if (device?.mode === 'bootloader') {
        return 'NA - bootloader';
    }
    if (device?.authenticityChecks?.firmwareRevision?.success &&
        device?.authenticityChecks?.firmwareHash?.success) {
        return 'official';
    }
    return 'unknown';
};
exports.getFirmwareSource = getFirmwareSource;
const getFirmwareRevision = (device) => device?.features?.revision || '';
exports.getFirmwareRevision = getFirmwareRevision;
const getFirmwareVersionArray = (device) => {
    if (!device?.features) {
        return null;
    }
    const { features } = device;
    if ((0, modeUtils_1.isDeviceInBootloaderMode)(device)) {
        return features.fw_major
            ? [features.fw_major, features.fw_minor, features.fw_patch]
            : null;
    }
    return [features.major_version, features.minor_version, features.patch_version];
};
exports.getFirmwareVersionArray = getFirmwareVersionArray;
const getFirmwareVersion = (device) => {
    if (!device?.features) {
        return '';
    }
    const { features } = device;
    if ((0, modeUtils_1.isDeviceInBootloaderMode)(device)) {
        return features.fw_major
            ? `${features.fw_major}.${features.fw_minor}.${features.fw_patch}`
            : '';
    }
    return `${features.major_version}.${features.minor_version}.${features.patch_version}`;
};
exports.getFirmwareVersion = getFirmwareVersion;
const hasBitcoinOnlyFirmware = (device) => device?.firmwareType === types_1.FirmwareType.BitcoinOnly;
exports.hasBitcoinOnlyFirmware = hasBitcoinOnlyFirmware;
const isBitcoinOnlyDevice = (device) => !!device?.features?.unit_btconly && device?.firmwareType !== types_1.FirmwareType.Universal;
exports.isBitcoinOnlyDevice = isBitcoinOnlyDevice;
//# sourceMappingURL=firmwareUtils.js.map