import type { DeviceModelInternal, FirmwareRelease } from '@trezor/device-utils';
import { CurrentVersion } from '../data/firmwareInfo';
import { Features, FirmwareType, StrictFeatures, VersionArray } from '../types';
export declare const isStrictFeatures: (extFeatures: Features) => extFeatures is StrictFeatures;
type VersionCheckProperty = 'min_firmware_version' | 'min_bootloader_version';
export declare const findBestCompatibleRelease: (releasesOfDevice: Record<string, FirmwareRelease>, currentVesion: CurrentVersion, checkProperty: VersionCheckProperty) => FirmwareRelease | undefined;
export declare const buildLocalFirmwareFileName: (firmwareType: FirmwareType, deviceModel: DeviceModelInternal, version: VersionArray) => string;
export declare const buildIntermediaryFirmwareFileName: (internalModel: DeviceModelInternal, version: number) => string;
export declare const getFirmwareMode: (features: Features) => "normal" | "bootloader" | "initialize" | "seedless";
export declare const getFirmwareType: (features: Features) => FirmwareType;
export {};
//# sourceMappingURL=firmwareUtils.d.ts.map