"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.httpRequest = exports.HttpRequestError = void 0;
const tslib_1 = require("tslib");
const cross_fetch_1 = tslib_1.__importDefault(require("cross-fetch"));
class HttpRequestError extends Error {
    response;
    constructor(response) {
        const message = `${response.status} while fetching ${response.url}`;
        super(message);
        this.response = response;
    }
}
exports.HttpRequestError = HttpRequestError;
const httpRequest = async (url, type = 'text', options) => {
    const init = { ...options, credentials: 'same-origin' };
    const response = await (0, cross_fetch_1.default)(url, init);
    if (response.ok) {
        if (type === 'json') {
            const txt = await response.text();
            return JSON.parse(txt);
        }
        if (type === 'binary') {
            return response.arrayBuffer();
        }
        return response.text();
    }
    throw new HttpRequestError(response);
};
exports.httpRequest = httpRequest;
//# sourceMappingURL=assets-browser.js.map