"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SolanaComposedTransaction = exports.SolanaComposeTransaction = exports.SolanaProgramName = exports.SolanaSignedTransaction = exports.SolanaSignTransaction = exports.SolanaTxAdditionalInfo = exports.SolanaTxTokenAccountInfo = exports.SolanaPublicKey = void 0;
const schema_utils_1 = require("@trezor/schema-utils");
const params_1 = require("../../params");
exports.SolanaPublicKey = schema_utils_1.Type.Intersect([
    params_1.PublicKey,
    schema_utils_1.Type.Object({
        publicKey: schema_utils_1.Type.String(),
        publicKeyBase58: schema_utils_1.Type.String(),
    }),
]);
exports.SolanaTxTokenAccountInfo = schema_utils_1.Type.Object({
    baseAddress: schema_utils_1.Type.String(),
    tokenProgram: schema_utils_1.Type.String(),
    tokenMint: schema_utils_1.Type.String(),
    tokenAccount: schema_utils_1.Type.String(),
    symbol: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
});
exports.SolanaTxAdditionalInfo = schema_utils_1.Type.Object({
    tokenAccountsInfos: schema_utils_1.Type.Optional(schema_utils_1.Type.Array(exports.SolanaTxTokenAccountInfo, { minItems: 1 })),
    isDevnet: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
});
exports.SolanaSignTransaction = schema_utils_1.Type.Object({
    path: schema_utils_1.Type.Union([schema_utils_1.Type.String(), schema_utils_1.Type.Array(schema_utils_1.Type.Number())]),
    serializedTx: schema_utils_1.Type.String(),
    additionalInfo: schema_utils_1.Type.Optional(exports.SolanaTxAdditionalInfo),
    serialize: schema_utils_1.Type.Optional(schema_utils_1.Type.Boolean()),
});
exports.SolanaSignedTransaction = schema_utils_1.Type.Object({
    signature: schema_utils_1.Type.String(),
    serializedTx: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
});
exports.SolanaProgramName = schema_utils_1.Type.Union([
    schema_utils_1.Type.Literal('spl-token'),
    schema_utils_1.Type.Literal('spl-token-2022'),
]);
exports.SolanaComposeTransaction = schema_utils_1.Type.Object({
    fromAddress: schema_utils_1.Type.String(),
    toAddress: schema_utils_1.Type.String(),
    amount: schema_utils_1.Type.String(),
    blockHash: schema_utils_1.Type.String(),
    lastValidBlockHeight: schema_utils_1.Type.Number(),
    priorityFees: schema_utils_1.Type.Optional(schema_utils_1.Type.Object({ computeUnitPrice: schema_utils_1.Type.String(), computeUnitLimit: schema_utils_1.Type.String() })),
    token: schema_utils_1.Type.Optional(schema_utils_1.Type.Object({
        mint: schema_utils_1.Type.String(),
        program: exports.SolanaProgramName,
        decimals: schema_utils_1.Type.Number(),
        accounts: schema_utils_1.Type.Array(schema_utils_1.Type.Object({ publicKey: schema_utils_1.Type.String(), balance: schema_utils_1.Type.String() })),
    })),
    coin: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
    identity: schema_utils_1.Type.Optional(schema_utils_1.Type.String()),
});
exports.SolanaComposedTransaction = schema_utils_1.Type.Object({
    serializedTx: schema_utils_1.Type.String(),
    additionalInfo: schema_utils_1.Type.Object({
        newAccountProgramName: schema_utils_1.Type.Optional(exports.SolanaProgramName),
        tokenAccountInfo: schema_utils_1.Type.Optional(exports.SolanaTxTokenAccountInfo),
    }),
});
//# sourceMappingURL=index.js.map