import EventEmitter from 'events';
import { CallMethodPayload } from '../events';
import { ConnectFactoryDependencies } from '../factory';
import { InitFullSettings } from '../types/api/init';
import type { SetTransports } from '../types/api/setTransports';
import type { Manifest } from '../types/settings';
type TrezorConnectDynamicParams<ImplType, SettingsType extends Record<string, any>, ImplInterface extends ConnectFactoryDependencies<SettingsType>> = {
    implementations: {
        type: ImplType;
        impl: ImplInterface;
    }[];
    getInitTarget: (settings: InitFullSettings<SettingsType>) => ImplType;
    handleBeforeCall: () => Promise<void>;
    handleErrorFallback: (errorCode: string) => Promise<boolean>;
};
export declare class TrezorConnectDynamic<ImplType, SettingsType extends Record<string, any>, ImplInterface extends ConnectFactoryDependencies<SettingsType>> implements ConnectFactoryDependencies<SettingsType> {
    eventEmitter: EventEmitter;
    private currentTarget;
    private implementations;
    private getInitTarget;
    private handleBeforeCall;
    private handleErrorFallback;
    lastSettings?: InitFullSettings<SettingsType>;
    private callPending;
    private beforeCallSynchronize;
    constructor({ implementations, getInitTarget, handleBeforeCall, handleErrorFallback, }: TrezorConnectDynamicParams<ImplType, SettingsType, ImplInterface>);
    getTarget(): ImplInterface;
    getTargetType(): ImplType;
    switchTarget(target: ImplType): Promise<void>;
    manifest(manifest: Manifest): void;
    init(settings: InitFullSettings<SettingsType>): Promise<void>;
    setTransports({ transports }: SetTransports): void;
    call(params: CallMethodPayload): Promise<any>;
    requestLogin(params: any): import("..").Response<import("../types/api/requestLogin").Login>;
    uiResponse(params: any): void;
    cancel(error?: string): void;
    dispose(): void;
}
export {};
//# sourceMappingURL=dynamic.d.ts.map