import EventEmitter from 'events';
import { CallMethodPayload, CoreEventMessage, CoreRequestMessage, UiResponseEvent } from '../events';
import { ConnectFactoryDependencies } from '../factory';
import type { ConnectSettings, ConnectSettingsPublic, DeviceIdentity, Manifest } from '../types';
import type { SetTransports } from '../types/api/setTransports';
export declare class CoreInModule implements ConnectFactoryDependencies<ConnectSettingsPublic> {
    eventEmitter: EventEmitter<[never]>;
    _settings: ConnectSettings;
    private _coreManager?;
    private _log;
    private _messagePromises;
    private readonly boundOnCoreEvent;
    private onCoreHook?;
    constructor(onCoreHook?: (message: CoreEventMessage) => CoreEventMessage);
    private initCoreManager;
    manifest(data: Manifest): void;
    dispose(): Promise<undefined>;
    cancel(error?: string): void;
    handleCoreMessage(message: CoreRequestMessage): void;
    private onCoreEvent;
    init(settings?: Partial<ConnectSettings>): Promise<void>;
    setTransports({ transports }: SetTransports): void;
    private initSettings;
    initCore(): any;
    call(params: CallMethodPayload): Promise<import("../types").Unsuccessful | {
        id: number;
        success: boolean;
        payload: any;
        device?: DeviceIdentity;
    }>;
    uiResponse(response: UiResponseEvent): void;
    requestLogin(params: any): Promise<import("../types").Unsuccessful | {
        id: number;
        success: boolean;
        payload: any;
        device?: DeviceIdentity;
    }>;
}
export declare const TrezorConnect: Omit<import("../types").TrezorConnect, "init"> & {
    init: import("../types/api/init").InitType<Record<string, any>>;
} & Record<string, any>;
//# sourceMappingURL=core-in-module.d.ts.map