import type { VersionArray } from '@trezor/device-utils';
import type { ThpCredentials, ThpPairingMethod } from '@trezor/protocol';
import type { PROTO } from '../constants';
import type { Device } from '../types/device';
import type { MessageFactoryFn } from '../types/utils';
export declare const DEVICE_EVENT = "DEVICE_EVENT";
export declare const DEVICE: {
    readonly CONNECT: "device-connect";
    readonly CONNECT_UNACQUIRED: "device-connect_unacquired";
    readonly DISCONNECT: "device-disconnect";
    readonly CHANGED: "device-changed";
    readonly FIRMWARE_VERSION_CHANGED: "device-firmware_version_changed";
    readonly THP_CREDENTIALS_CHANGED: "device-thp_credentials_changed";
    readonly BUTTON: "button";
    readonly PIN: "pin";
    readonly PASSPHRASE: "passphrase";
    readonly PASSPHRASE_ON_DEVICE: "passphrase_on_device";
    readonly WORD: "word";
    readonly THP_PAIRING: "thp_pairing";
};
export interface DeviceButtonRequestPayload extends Omit<PROTO.ButtonRequest, 'code'> {
    code?: PROTO.ButtonRequest['code'] | 'ButtonRequest_FirmwareUpdate';
}
export interface DeviceButtonRequest {
    type: typeof DEVICE.BUTTON;
    payload: DeviceButtonRequestPayload & {
        device: Device;
    };
}
export interface DeviceVersionChanged {
    type: typeof DEVICE.FIRMWARE_VERSION_CHANGED;
    payload: {
        device: Device;
        oldVersion: VersionArray;
        newVersion: VersionArray;
    };
}
export type DeviceThpCredentialsChangedPayload = {
    credentials: ThpCredentials;
    staticKey: string;
};
export type DeviceThpPairingPayload = {
    availableMethods: ThpPairingMethod[];
    selectedMethod?: ThpPairingMethod;
    nfcData?: string;
};
export interface DeviceThpCredentialsChanged {
    type: typeof DEVICE.THP_CREDENTIALS_CHANGED;
    payload: DeviceThpCredentialsChangedPayload & {
        device: Device;
    };
}
export type DeviceEvent = {
    type: typeof DEVICE.CONNECT | typeof DEVICE.CONNECT_UNACQUIRED | typeof DEVICE.CHANGED | typeof DEVICE.DISCONNECT;
    payload: Device;
} | DeviceButtonRequest | DeviceThpCredentialsChanged | DeviceVersionChanged;
export type DeviceEventMessage = DeviceEvent & {
    event: typeof DEVICE_EVENT;
};
export type DeviceEventListenerFn = (type: typeof DEVICE_EVENT, cb: (event: DeviceEventMessage) => void) => void;
export declare const createDeviceMessage: MessageFactoryFn<typeof DEVICE_EVENT, DeviceEvent>;
//# sourceMappingURL=device.d.ts.map