"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../core/AbstractMethod");
const pathUtils_1 = require("../utils/pathUtils");
const paramsValidator_1 = require("./common/paramsValidator");
const unlockPath_1 = require("../types/api/unlockPath");
class UnlockPath extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['read'];
        this.skipFinalReload = true;
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, undefined, this.firmwareRange);
        const { payload } = this;
        (0, schema_utils_1.Assert)(unlockPath_1.UnlockPathParams, payload);
        const path = (0, pathUtils_1.validatePath)(payload.path, 1);
        this.params = {
            address_n: path,
            mac: payload.mac,
        };
    }
    async run() {
        const cmd = this.device.getCommands();
        const { message } = await cmd.unlockPath(this.params);
        return {
            address_n: this.params.address_n,
            mac: message.mac,
        };
    }
}
exports.default = UnlockPath;
//# sourceMappingURL=unlockPath.js.map