"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../../../core/AbstractMethod");
const coinInfo_1 = require("../../../data/coinInfo");
const tezos_1 = require("../../../types/api/tezos");
const pathUtils_1 = require("../../../utils/pathUtils");
const paramsValidator_1 = require("../../common/paramsValidator");
const helper = tslib_1.__importStar(require("../tezosSignTx"));
class TezosSignTransaction extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['read', 'write'];
        this.requiredDeviceCapabilities = ['Capability_Tezos'];
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, (0, coinInfo_1.getMiscNetwork)('Tezos'), this.firmwareRange);
        const { payload } = this;
        (0, schema_utils_1.AssertWeak)(tezos_1.TezosSignTransaction, payload);
        const path = (0, pathUtils_1.validatePath)(payload.path, 3);
        this.params = helper.createTx(path, payload.branch, payload.operation);
    }
    get info() {
        return 'Sign Tezos transaction';
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('TezosSignTx', 'TezosSignedTx', this.params);
        return response.message;
    }
}
exports.default = TezosSignTransaction;
//# sourceMappingURL=tezosSignTransaction.js.map