"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
class GetDeviceState extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = [];
    }
    run() {
        const state = this.device.getState();
        if (!state?.staticSessionId) {
            throw constants_1.ERRORS.TypedError('Runtime', 'Device state not set');
        }
        return Promise.resolve({ state: state.staticSessionId, _state: state });
    }
}
exports.default = GetDeviceState;
//# sourceMappingURL=getDeviceState.js.map