"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../../../core/AbstractMethod");
const coinInfo_1 = require("../../../data/coinInfo");
const eos_1 = require("../../../types/api/eos");
const pathUtils_1 = require("../../../utils/pathUtils");
const paramsValidator_1 = require("../../common/paramsValidator");
const helper = tslib_1.__importStar(require("../eosSignTx"));
class EosSignTransaction extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['read', 'write'];
        this.requiredDeviceCapabilities = ['Capability_EOS'];
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, (0, coinInfo_1.getMiscNetwork)('EOS'), this.firmwareRange);
        const { payload } = this;
        (0, schema_utils_1.AssertWeak)(eos_1.EosSignTransaction, payload);
        const path = (0, pathUtils_1.validatePath)(payload.path, 3);
        const { chain_id, header, ack } = helper.validate(payload.transaction);
        this.params = {
            path,
            chain_id,
            header,
            ack,
            chunkify: typeof payload.chunkify === 'boolean' ? payload.chunkify : false,
        };
    }
    get info() {
        return 'Sign EOS transaction';
    }
    async run() {
        const response = await helper.signTx(this.device.getCommands().typedCall, this.params.path, this.params.chain_id, this.params.header, this.params.ack, this.params.chunkify);
        return {
            signature: response.signature,
        };
    }
}
exports.default = EosSignTransaction;
//# sourceMappingURL=eosSignTransaction.js.map