"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryGetScripthash = exports.blockheaderToBlockhash = exports.scriptToScripthash = exports.addressToScripthash = exports.btcToSat = void 0;
const utxo_lib_1 = require("@trezor/utxo-lib");
const btcToSat = (btc) => Math.round(100000000 * btc).toString();
exports.btcToSat = btcToSat;
const addressToScripthash = (address, network) => {
    const script = utxo_lib_1.address.toOutputScript(address, network);
    const scripthash = utxo_lib_1.crypto.sha256(script).reverse().toString('hex');
    return scripthash;
};
exports.addressToScripthash = addressToScripthash;
const scriptToScripthash = (hex) => {
    const buffer = Buffer.from(hex, 'hex');
    return utxo_lib_1.crypto.sha256(buffer).reverse().toString('hex');
};
exports.scriptToScripthash = scriptToScripthash;
const blockheaderToBlockhash = (header) => {
    const buffer = Buffer.from(header, 'hex');
    const hash = utxo_lib_1.crypto.hash256(buffer).reverse().toString('hex');
    return hash;
};
exports.blockheaderToBlockhash = blockheaderToBlockhash;
const tryGetScripthash = (address, network) => {
    try {
        return {
            valid: true,
            scripthash: (0, exports.addressToScripthash)(address, network),
        };
    }
    catch {
        return {
            valid: false,
        };
    }
};
exports.tryGetScripthash = tryGetScripthash;
//# sourceMappingURL=transform.js.map