"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("@trezor/utils");
const utils_2 = require("../utils");
const getInfo = client => {
    const { url, coin, block: { hex, height }, version: [_name, version], } = client.getInfo() || (0, utils_1.throwError)('Client not initialized');
    return Promise.resolve({
        url,
        version,
        blockHeight: height,
        blockHash: (0, utils_2.blockheaderToBlockhash)(hex),
        name: 'Bitcoin',
        shortcut: coin,
        network: coin,
        testnet: coin === 'REGTEST',
        decimals: 8,
    });
};
exports.default = getInfo;
//# sourceMappingURL=getInfo.js.map