import type { BlockContent, BlockfrostTransaction, Send } from '@trezor/blockchain-link-types/lib/blockfrost';
import type { AccountBalanceHistoryParams, AccountInfoParams, EstimateFeeParams } from '@trezor/blockchain-link-types/lib/params';
import { BaseWebsocket } from '../baseWebsocket';
interface BlockfrostEvents {
    block: BlockContent;
    notification: BlockfrostTransaction;
}
export declare class BlockfrostAPI extends BaseWebsocket<BlockfrostEvents> {
    protected createWebsocket(): import("ws");
    protected ping(): Promise<BlockContent>;
    send: Send;
    getServerInfo(): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").ServerInfo>;
    getBlockHash(number: number): Promise<BlockContent>;
    estimateFee(payload: EstimateFeeParams): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").Fee>;
    getAccountInfo(payload: AccountInfoParams): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").BlockfrostAccountInfo>;
    getAccountUtxo(descriptor: string): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").BlockfrostUtxos[]>;
    getAccountBalanceHistory(payload: AccountBalanceHistoryParams): Promise<import("@trezor/blockchain-link-types").AccountBalanceHistory[]>;
    getTransaction(txId: string): Promise<{
        hash: string;
        block: string;
        block_height: number;
        block_time: number;
        slot: number;
        index: number;
        output_amount: import("@trezor/blockchain-link-types/lib/blockfrost").AssetBalance[];
        fees: string;
        deposit: string;
        size: number;
        invalid_before: string | null;
        invalid_hereafter: string | null;
        utxo_count: number;
        withdrawal_count: number;
        mir_cert_count: number;
        delegation_count: number;
        stake_cert_count: number;
        pool_update_count: number;
        pool_retire_count: number;
        asset_mint_or_burn_count: number;
        redeemer_count: number;
        valid_contract: boolean;
    }>;
    pushTransaction(txData: string): Promise<string>;
    subscribeBlock(): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").Subscribe>;
    subscribeAddresses(addresses: string[]): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").Subscribe>;
    unsubscribeBlock(): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").Subscribe> | {
        subscribed: boolean;
    };
    unsubscribeAddresses(): Promise<import("@trezor/blockchain-link-types/lib/blockfrost").Subscribe> | {
        subscribed: boolean;
    };
}
export {};
//# sourceMappingURL=websocket.d.ts.map