import type { SolanaRpcSubscriptionsApi } from '@solana/rpc-subscriptions-api';
import { RpcSubscriptionsApiMethods, type RpcSubscriptionsTransport } from '@solana/rpc-subscriptions-spec';
import { ClusterUrl } from '@solana/rpc-types';
import { DefaultRpcSubscriptionsChannelConfig } from './rpc-subscriptions-channel';
import type { RpcSubscriptionsFromTransport } from './rpc-subscriptions-clusters';
type Config<TClusterUrl extends ClusterUrl> = DefaultRpcSubscriptionsChannelConfig<TClusterUrl>;
/**
 * Creates a {@link RpcSubscriptions} instance that exposes the Solana JSON RPC WebSocket API given
 * a cluster URL and some optional channel config. See
 * {@link createDefaultRpcSubscriptionsChannelCreator} for the shape of the channel config.
 */
export declare function createSolanaRpcSubscriptions<TClusterUrl extends ClusterUrl>(clusterUrl: TClusterUrl, config?: Omit<Config<TClusterUrl>, 'url'>): RpcSubscriptionsFromTransport<SolanaRpcSubscriptionsApi, import("./rpc-subscriptions-clusters").RpcSubscriptionsTransportFromClusterUrl<TClusterUrl>>;
/**
 * Creates a {@link RpcSubscriptions} instance that exposes the Solana JSON RPC WebSocket API,
 * including its unstable methods, given a cluster URL and some optional channel config. See
 * {@link createDefaultRpcSubscriptionsChannelCreator} for the shape of the channel config.
 */
export declare function createSolanaRpcSubscriptions_UNSTABLE<TClusterUrl extends ClusterUrl>(clusterUrl: TClusterUrl, config?: Omit<Config<TClusterUrl>, 'url'>): RpcSubscriptionsFromTransport<import("@solana/rpc-subscriptions-api").AccountNotificationsApi & import("@solana/rpc-subscriptions-api").LogsNotificationsApi & import("@solana/rpc-subscriptions-api").ProgramNotificationsApi & import("@solana/rpc-subscriptions-api").RootNotificationsApi & import("@solana/rpc-subscriptions-api").SignatureNotificationsApi & import("@solana/rpc-subscriptions-api").SlotNotificationsApi & import("@solana/rpc-subscriptions-api").BlockNotificationsApi & import("@solana/rpc-subscriptions-api").SlotsUpdatesNotificationsApi & import("@solana/rpc-subscriptions-api").VoteNotificationsApi, import("./rpc-subscriptions-clusters").RpcSubscriptionsTransportFromClusterUrl<TClusterUrl>>;
/**
 * Creates a {@link RpcSubscriptions} instance that exposes the Solana JSON RPC WebSocket API given
 * the supplied {@link RpcSubscriptionsTransport}.
 */
export declare function createSolanaRpcSubscriptionsFromTransport<TTransport extends RpcSubscriptionsTransport, TApi extends RpcSubscriptionsApiMethods = SolanaRpcSubscriptionsApi>(transport: TTransport): RpcSubscriptionsFromTransport<TApi, TTransport>;
export {};
//# sourceMappingURL=rpc-subscriptions.d.ts.map