/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_PROGRAM_ADDRESS } from '../programs';
export declare const TRANSFER_CHECKED_DISCRIMINATOR = 12;
export declare function getTransferCheckedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type TransferCheckedInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountSource extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountDestination extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSource extends string ? WritableAccount<TAccountSource> : TAccountSource,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountDestination extends string ? WritableAccount<TAccountDestination> : TAccountDestination,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type TransferCheckedInstructionData = {
    discriminator: number;
    /** The amount of tokens to transfer. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export type TransferCheckedInstructionDataArgs = {
    /** The amount of tokens to transfer. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export declare function getTransferCheckedInstructionDataEncoder(): Encoder<TransferCheckedInstructionDataArgs>;
export declare function getTransferCheckedInstructionDataDecoder(): Decoder<TransferCheckedInstructionData>;
export declare function getTransferCheckedInstructionDataCodec(): Codec<TransferCheckedInstructionDataArgs, TransferCheckedInstructionData>;
export type TransferCheckedInput<TAccountSource extends string = string, TAccountMint extends string = string, TAccountDestination extends string = string, TAccountAuthority extends string = string> = {
    /** The source account. */
    source: Address<TAccountSource>;
    /** The token mint. */
    mint: Address<TAccountMint>;
    /** The destination account. */
    destination: Address<TAccountDestination>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: TransferCheckedInstructionDataArgs['amount'];
    decimals: TransferCheckedInstructionDataArgs['decimals'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getTransferCheckedInstruction<TAccountSource extends string, TAccountMint extends string, TAccountDestination extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_PROGRAM_ADDRESS>(input: TransferCheckedInput<TAccountSource, TAccountMint, TAccountDestination, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): TransferCheckedInstruction<TProgramAddress, TAccountSource, TAccountMint, TAccountDestination, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedTransferCheckedInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source account. */
        source: TAccountMetas[0];
        /** The token mint. */
        mint: TAccountMetas[1];
        /** The destination account. */
        destination: TAccountMetas[2];
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[3];
    };
    data: TransferCheckedInstructionData;
};
export declare function parseTransferCheckedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedTransferCheckedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=transferChecked.d.ts.map