/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type Option, type OptionOrNullable, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR = 27;
export declare function getInitializeConfidentialTransferMintDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const INITIALIZE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 0;
export declare function getInitializeConfidentialTransferMintConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type InitializeConfidentialTransferMintInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMint extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    ...TRemainingAccounts
]>;
export type InitializeConfidentialTransferMintInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /**
     * Authority to modify the `ConfidentialTransferMint` configuration and to
     * approve new accounts.
     */
    authority: Option<Address>;
    /**
     * Determines if newly configured accounts must be approved by the
     * `authority` before they may be used by the user.
     */
    autoApproveNewAccounts: boolean;
    /** New authority to decode any transfer amount in a confidential transfer. */
    auditorElgamalPubkey: Option<Address>;
};
export type InitializeConfidentialTransferMintInstructionDataArgs = {
    /**
     * Authority to modify the `ConfidentialTransferMint` configuration and to
     * approve new accounts.
     */
    authority: OptionOrNullable<Address>;
    /**
     * Determines if newly configured accounts must be approved by the
     * `authority` before they may be used by the user.
     */
    autoApproveNewAccounts: boolean;
    /** New authority to decode any transfer amount in a confidential transfer. */
    auditorElgamalPubkey: OptionOrNullable<Address>;
};
export declare function getInitializeConfidentialTransferMintInstructionDataEncoder(): Encoder<InitializeConfidentialTransferMintInstructionDataArgs>;
export declare function getInitializeConfidentialTransferMintInstructionDataDecoder(): Decoder<InitializeConfidentialTransferMintInstructionData>;
export declare function getInitializeConfidentialTransferMintInstructionDataCodec(): Codec<InitializeConfidentialTransferMintInstructionDataArgs, InitializeConfidentialTransferMintInstructionData>;
export type InitializeConfidentialTransferMintInput<TAccountMint extends string = string> = {
    /** The SPL Token mint. */
    mint: Address<TAccountMint>;
    authority: InitializeConfidentialTransferMintInstructionDataArgs['authority'];
    autoApproveNewAccounts: InitializeConfidentialTransferMintInstructionDataArgs['autoApproveNewAccounts'];
    auditorElgamalPubkey: InitializeConfidentialTransferMintInstructionDataArgs['auditorElgamalPubkey'];
};
export declare function getInitializeConfidentialTransferMintInstruction<TAccountMint extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: InitializeConfidentialTransferMintInput<TAccountMint>, config?: {
    programAddress?: TProgramAddress;
}): InitializeConfidentialTransferMintInstruction<TProgramAddress, TAccountMint>;
export type ParsedInitializeConfidentialTransferMintInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The SPL Token mint. */
        mint: TAccountMetas[0];
    };
    data: InitializeConfidentialTransferMintInstructionData;
};
export declare function parseInitializeConfidentialTransferMintInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedInitializeConfidentialTransferMintInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=initializeConfidentialTransferMint.d.ts.map