/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const CONFIDENTIAL_DEPOSIT_DISCRIMINATOR = 27;
export declare function getConfidentialDepositDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const CONFIDENTIAL_DEPOSIT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 5;
export declare function getConfidentialDepositConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ConfidentialDepositInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountToken extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type ConfidentialDepositInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /** The amount of tokens to deposit. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export type ConfidentialDepositInstructionDataArgs = {
    /** The amount of tokens to deposit. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export declare function getConfidentialDepositInstructionDataEncoder(): Encoder<ConfidentialDepositInstructionDataArgs>;
export declare function getConfidentialDepositInstructionDataDecoder(): Decoder<ConfidentialDepositInstructionData>;
export declare function getConfidentialDepositInstructionDataCodec(): Codec<ConfidentialDepositInstructionDataArgs, ConfidentialDepositInstructionData>;
export type ConfidentialDepositInput<TAccountToken extends string = string, TAccountMint extends string = string, TAccountAuthority extends string = string> = {
    /** The SPL Token account. */
    token: Address<TAccountToken>;
    /** The corresponding SPL Token mint. */
    mint: Address<TAccountMint>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: ConfidentialDepositInstructionDataArgs['amount'];
    decimals: ConfidentialDepositInstructionDataArgs['decimals'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getConfidentialDepositInstruction<TAccountToken extends string, TAccountMint extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ConfidentialDepositInput<TAccountToken, TAccountMint, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): ConfidentialDepositInstruction<TProgramAddress, TAccountToken, TAccountMint, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedConfidentialDepositInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The SPL Token account. */
        token: TAccountMetas[0];
        /** The corresponding SPL Token mint. */
        mint: TAccountMetas[1];
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[2];
    };
    data: ConfidentialDepositInstructionData;
};
export declare function parseConfidentialDepositInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedConfidentialDepositInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=confidentialDeposit.d.ts.map